/* scanformat.body SCCS(4.1 91/02/18 15:43:01) */

/* 

scanformat.body

special scanning function for format strings

*/

#include "tokens.h"

extern int pos ;
extern int tok ;

scanformat()
{
    int inparen = 0 ;
    while( tok = scanlex() ) { 	/* scanlex is generated by lex */
	outputline() ;
	pos = 0 ;
        if      (tok == TLPAR) inparen++ ;
	else if (tok == TRPAR) inparen-- ;
	if (inparen <= 0) break ;
    }
    pos = 0 ;
    if ( inparen < 0 ) lexerr("unbalanced parentheses in format spec") ;
    if ( tok !=  TRPAR ) lexerr("unbalanced parentheses in format spec") ;
}

# include "stdio.h"
# define U(x) x
# define NLSTATE fmtyyprevious=YYNEWLINE
# define BEGIN fmtyybgin = fmtyysvec + 1 +
# define INITIAL 0
# define YYLERR fmtyysvec
# define YYSTATE (yyestate-fmtyysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,stdout)
# define yymore() (yymorfg=1)
# define ECHO fprintf(stdout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
extern int yyleng; extern char yytext[];
int yymorfg;
extern char *fmtyysptr, yysbuf[];
int yytchar;
/*FILE *fmtyyin = {stdin}, *fmtyyout = {stdout}; */
extern int fmtyylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf fmtyysvec[], *fmtyybgin;
# define YYNEWLINE 10
scanlex(){
int nstr; extern int fmtyyprevious;
while((nstr = fmtyylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
	lexerr("bad format specification -- check holleriths and parens") ;
	unput('\n') ;
	return(0) ;
	}
break;
case 2:
{ 
        /* integers are 1 or more digits (D).
	*/
	  return(TICON) ;
	  }
break;
case 3:
{ 
	/* a HOLLERITH string */
	char temp[40], temp2[80] ;
	char c ;
	int i, n ;
	n = atoi( yytext ) ;
	for ( i = 0 ; i<n ; i++ ) {
	    c = input() ;
            if ( c != '\n' ) {
		yytext[yyleng++] = c ;
	    } else {
		unput('\n') ;
		strncpy( temp, yytext, yyleng>=40?40:yyleng ) ;
		temp[yyleng>=40?40-1:yyleng] = 0 ;
		sprintf(temp2,"bad hollerith string: %s", temp) ;
		lexerr(temp2) ;
		return(0) ;
	    }
	}
	return(THOLLERITH) ;
	}
break;
case 4:
case 5:
{
	/* string literals
	   can be delimited either by " or '.  These are included
	   in a string by "" or '', but from the scanner's point of
	   view these are two consecutive strings.  If we read a string
	   and the next character is the same string delimiter (" or ')
	   as the previous string, we use yymore() to get it too
	   and tack it onto the end of yytext, after first eliminating
	   the delimiter at the end of the first string so in the 
	   resultant value, instances of the
	   delimiter in the string itself will be single.  As written
	   here, the string values are returned with enclosing quotes.
	   That could be altered if desired.
	*/
	int i ; char c; 
	/* look ahead.  if next character is also a quote, then
	   then we actually have a quote in a string. */
        c = input() ; unput(c) ;
	if (((yytext[yyleng-1]=='\'') && (c == '\'' )) ||
	    ((yytext[yyleng-1]=='"') && (c == '"' ))) {
#if 0
	    yyleng-- ;  /* get rid of delim at end of 1st string */
#endif
	    yymore() ;
	}
	else {
	    return(TSTRING) ;
	}
	}
break;
case 6:
{
	  return(TLPAR) ;
	}
break;
case 7:
	{
	  return(TRPAR) ;
	}
break;
case 8:
return(TANGLEEXP) ;
break;
case 9:
return(TLANGLE) ;
break;
case 10:
return(TRANGLE) ;
break;
case 11:
return(TI) ;
break;
case 12:
return(TA) ;
break;
case 13:
return(TL) ;
break;
case 14:
return(TE) ;
break;
case 15:
return(TF) ;
break;
case 16:
return(TT) ;
break;
case 17:
return(TTL) ;
break;
case 18:
return(TTR) ;
break;
case 19:
return(TG) ;
break;
case 20:
return(TD) ;
break;
case 21:
return(TP) ;
break;
case 22:
return(TX) ;
break;
case 23:
return(TZ) ;
break;
case 24:
return(TO) ;
break;
case 25:
return(TQ) ;
break;
case 26:
return(TS) ;
break;
case 27:
return(TSP) ;
break;
case 28:
return(TSS) ;
break;
case 29:
return(TBN) ;
break;
case 30:
return(TBZ) ;
break;
case 31:
return(TDOT) ;
break;
case 32:
return(TCOLON) ;
break;
case 33:
return(TCOMMA) ;
break;
case 34:
return(TSLASH) ;
break;
case 35:
return(TCURRENCY) ;
break;
case 36:
return(TLETTER) ;
break;
case -1:
break;
default:
fprintf(stdout,"bad switch fmtyylook %d",nstr);
} return(0); }
/* end of scanlex */
int fmtyyvstop[] = {
0,

36,
0,

36,
0,

35,
36,
0,

36,
0,

6,
36,
0,

7,
36,
0,

33,
36,
0,

31,
36,
0,

34,
36,
0,

2,
36,
0,

32,
36,
0,

9,
36,
0,

10,
36,
0,

12,
36,
0,

36,
0,

20,
36,
0,

14,
36,
0,

15,
36,
0,

19,
36,
0,

11,
36,
0,

13,
36,
0,

24,
36,
0,

21,
36,
0,

25,
36,
0,

26,
36,
0,

16,
36,
0,

22,
36,
0,

23,
36,
0,

4,
0,

5,
0,

2,
0,

3,
0,

8,
0,

29,
0,

30,
0,

27,
0,

28,
0,

17,
0,

18,
0,

1,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } fmtyycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	4,31,	0,0,	
0,0,	0,0,	0,0,	1,0,	
0,0,	6,33,	0,0,	4,0,	
0,0,	0,0,	31,0,	33,0,	
0,0,	38,0,	6,34,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,4,	
0,0,	1,5,	2,0,	4,32,	
1,6,	1,7,	1,8,	39,0,	
4,31,	1,9,	6,33,	1,10,	
1,11,	1,12,	34,46,	6,35,	
0,0,	4,31,	0,0,	0,0,	
0,0,	0,0,	14,38,	1,13,	
6,33,	1,14,	0,0,	1,15,	
2,5,	0,0,	0,0,	14,0,	
2,7,	2,8,	0,0,	0,0,	
2,9,	38,39,	2,10,	2,11,	
12,36,	12,36,	12,36,	12,36,	
12,36,	12,36,	12,36,	12,36,	
12,36,	12,36,	2,13,	0,0,	
2,14,	0,0,	2,15,	14,38,	
0,0,	0,0,	0,0,	39,39,	
14,38,	0,0,	1,16,	1,17,	
0,0,	1,18,	1,19,	1,20,	
1,21,	14,38,	1,22,	0,0,	
0,0,	1,23,	0,0,	0,0,	
1,24,	1,25,	1,26,	0,0,	
1,27,	1,28,	0,0,	14,39,	
0,0,	1,29,	17,40,	1,30,	
27,42,	2,16,	2,17,	27,43,	
2,18,	2,19,	2,20,	2,21,	
12,37,	2,22,	17,41,	0,0,	
2,23,	0,0,	0,0,	2,24,	
2,25,	2,26,	0,0,	2,27,	
2,28,	28,44,	0,0,	0,0,	
2,29,	0,0,	2,30,	28,45,	
0,0};
struct yysvf fmtyysvec[] = {
0,	0,	0,
fmtyycrank+-1,	0,		0,	
fmtyycrank+-28,	fmtyysvec+1,	0,	
fmtyycrank+0,	0,		fmtyyvstop+1,
fmtyycrank+-5,	0,		fmtyyvstop+3,
fmtyycrank+0,	0,		fmtyyvstop+5,
fmtyycrank+-12,	0,		fmtyyvstop+8,
fmtyycrank+0,	0,		fmtyyvstop+10,
fmtyycrank+0,	0,		fmtyyvstop+13,
fmtyycrank+0,	0,		fmtyyvstop+16,
fmtyycrank+0,	0,		fmtyyvstop+19,
fmtyycrank+0,	0,		fmtyyvstop+22,
fmtyycrank+28,	0,		fmtyyvstop+25,
fmtyycrank+0,	0,		fmtyyvstop+28,
fmtyycrank+-57,	0,		fmtyyvstop+31,
fmtyycrank+0,	0,		fmtyyvstop+34,
fmtyycrank+0,	0,		fmtyyvstop+37,
fmtyycrank+12,	0,		fmtyyvstop+40,
fmtyycrank+0,	0,		fmtyyvstop+42,
fmtyycrank+0,	0,		fmtyyvstop+45,
fmtyycrank+0,	0,		fmtyyvstop+48,
fmtyycrank+0,	0,		fmtyyvstop+51,
fmtyycrank+0,	0,		fmtyyvstop+54,
fmtyycrank+0,	0,		fmtyyvstop+57,
fmtyycrank+0,	0,		fmtyyvstop+60,
fmtyycrank+0,	0,		fmtyyvstop+63,
fmtyycrank+0,	0,		fmtyyvstop+66,
fmtyycrank+12,	0,		fmtyyvstop+69,
fmtyycrank+37,	0,		fmtyyvstop+72,
fmtyycrank+0,	0,		fmtyyvstop+75,
fmtyycrank+0,	0,		fmtyyvstop+78,
fmtyycrank+-8,	fmtyysvec+4,	0,	
fmtyycrank+0,	0,		fmtyyvstop+81,
fmtyycrank+-9,	fmtyysvec+6,	0,	
fmtyycrank+11,	0,		0,	
fmtyycrank+0,	0,		fmtyyvstop+83,
fmtyycrank+0,	fmtyysvec+12,	fmtyyvstop+85,
fmtyycrank+0,	0,		fmtyyvstop+87,
fmtyycrank+-11,	fmtyysvec+14,	0,	
fmtyycrank+-33,	fmtyysvec+14,	fmtyyvstop+89,
fmtyycrank+0,	0,		fmtyyvstop+91,
fmtyycrank+0,	0,		fmtyyvstop+93,
fmtyycrank+0,	0,		fmtyyvstop+95,
fmtyycrank+0,	0,		fmtyyvstop+97,
fmtyycrank+0,	0,		fmtyyvstop+99,
fmtyycrank+0,	0,		fmtyyvstop+101,
fmtyycrank+0,	0,		fmtyyvstop+103,
0,	0,	0};
struct yywork *fmtyytop = fmtyycrank+151;
struct yysvf *fmtyybgin = fmtyysvec+1;
char fmtyymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,'"' ,01  ,01  ,01  ,01  ,047 ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char fmtyyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int fmtyylineno =1;
# define YYU(x) x
# define NLSTATE fmtyyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *fmtyysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int fmtyyprevious = YYNEWLINE;
fmtyylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = fmtyybgin;
		if (fmtyyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(stdout,"state %d\n",yystate-fmtyysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == fmtyycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == fmtyycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(stdout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)fmtyycrank){
				yyt = yyr + yych;
				if (yyt <= fmtyytop && yyt->verify+fmtyysvec == yystate){
					if(yyt->advance+fmtyysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+fmtyysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)fmtyycrank) {		/* r < fmtyycrank */
				yyt = yyr = fmtyycrank+(fmtyycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(stdout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= fmtyytop && yyt->verify+fmtyysvec == yystate){
					if(yyt->advance+fmtyysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+fmtyysvec;
					goto contin;
					}
				yyt = yyr + YYU(fmtyymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(stdout,"try fall back character ");
					allprint(YYU(fmtyymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= fmtyytop && yyt->verify+fmtyysvec == yystate){
					if(yyt->advance+fmtyysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+fmtyysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != fmtyycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(stdout,"fall back to state %d\n",yystate-fmtyysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(stdout,"state %d char ",yystate-fmtyysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(stdout,"stopped at %d with ",*(lsp-1)-fmtyysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(fmtyyextra[*yyfnd]){		/* must backup */
					while(fmtyyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				fmtyyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(stdout,"\nmatch ");
					sprint(yytext);
					fprintf(stdout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(stdin) */)
			{
			fmtyysptr=yysbuf;
			return(0);
			}
		fmtyyprevious = yytext[0] = input();
		if (fmtyyprevious>0)
			output(fmtyyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
fmtyyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
fmtfmtyyinput(){
	return(input());
	}
fmtfmtyyoutput(c)
  int c; {
	output(c);
	}
fmtyyunput(c)
   int c; {
	unput(c);
	}
