MODULE header_data

   USE date_pack

   INTEGER            , DIMENSION(50,20) :: bhi
   CHARACTER (LEN=80) , DIMENSION(50,20) :: bhic
   REAL               , DIMENSION(20,20) :: bhr
   CHARACTER (LEN=80) , DIMENSION(20,20) :: bhrc

   TYPE sh
      INTEGER                :: num_dims
      INTEGER , DIMENSION(4) :: start_dims
      INTEGER , DIMENSION(4) :: end_dims
      REAL                   :: xtime
      CHARACTER (LEN= 4)     :: staggering
      CHARACTER (LEN= 4)     :: ordering
      CHARACTER (LEN=24)     :: current_date
      CHARACTER (LEN= 9)     :: name
      CHARACTER (LEN=25)     :: units
      CHARACTER (LEN=46)     :: description
   END TYPE sh

   TYPE(sh) :: small_header

   INTEGER , PARAMETER :: bh_flag  = 0 , &
                          sh_flag  = 1 , &
                          eot_flag = 2

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE compare_bh ( pbhi , pbhr , plbhi , plbhr , nbhi , nbhr , use_mm5_lowbdy )

      INTEGER , DIMENSION(50,20) :: pbhi , plbhi , nbhi
      REAL    , DIMENSION(20,20) :: pbhr , plbhr , nbhr
      LOGICAL                    :: use_mm5_lowbdy

      LOGICAL :: ok
      CHARACTER (LEN=19) :: mm5_date , lowbdy1_date , lowbdy2_date 
      INTEGER :: prog_num , i

      IF ( use_mm5_lowbdy ) THEN

         !  The MM5 data and the lower boundary file need to match horizontal domains.
   
         ok =          ALL ( pbhi(5:50,1) .EQ. plbhi(5:50,1) )
         DO i = 1 , 7
            ok = ok .AND. ( ABS ( pbhr(i,1) - plbhr(i,1) ) .LT. 0.01 )
         END DO
         DO i = 9 , 13
            ok = ok .AND. ( ABS ( pbhr(i,1) - plbhr(i,1) ) .LT. 0.01 )
         END DO
   
         !  The MM5 data and the lower boundary file need to match ptop.
   
         ok = ok .AND. ( ABS ( pbhr(2,2) - plbhr(2,2) ) .LT. 0.01 )
   
         !  The MM5 data and the lower boundary file need to match the number of sigma 
         !  levels in the model input location.
   
         ok = ok .AND. ( pbhi(  12,5) .EQ. plbhi(  12,5) )
   
         !  The MM5 data and the lower boundary file need to be close to the same dates.
   
         prog_num = pbhi(1,1)
         WRITE ( mm5_date     , '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)' ) &
         pbhi(5,prog_num)  , pbhi(6,prog_num)  , pbhi(7,prog_num)  , pbhi(8,prog_num)  , pbhi(9,prog_num)  , pbhi(10,prog_num)
   
         WRITE ( lowbdy1_date , '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)' ) &
         plbhi(5, 6) , plbhi(6, 6) , plbhi(7, 6) , plbhi(8, 6) , plbhi(9, 6) , plbhi(10, 6)
   
         CALL geth_newdate ( lowbdy2_date , lowbdy1_date , NINT ( plbhr(1,6) ) )
   
         ok = ok .AND. ( ( mm5_date .LE. lowbdy2_date ) .AND. ( mm5_date .GE. lowbdy1_date ) ) 
   
         IF ( .NOT. ok ) THEN
            PRINT '(A)','MM5 and the LOWBDY file are not consistent.'
            STOP 'MM5_and_LOWBDY_not_consistent'
         END IF      
   
      END IF

      !  The MM5 data and the fine grid TERRAIN data need to match horizontal domains.

      ok =          ( pbhi(  5,1) .EQ. nbhi(  5,1) ) .AND. &
                    ( pbhi(  6,1) .EQ. nbhi(  6,1) ) .AND. &
                    ( pbhi(  7,1) .EQ. nbhi(  7,1) ) 

      ok = ok .AND. ( ABS ( pbhr(1,1) - nbhr(1,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(2,1) - nbhr(2,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(3,1) - nbhr(3,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(4,1) - nbhr(4,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(5,1) - nbhr(5,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(6,1) - nbhr(6,1) ) .LT. 0.01 ) .AND. &
                    ( ABS ( pbhr(7,1) - nbhr(7,1) ) .LT. 0.01 )

      IF ( .NOT. ok ) THEN
         PRINT '(A)','MM5 and the fine grid TERRAIN file are not consistent.'
         STOP 'MM5_and_TERRAIN_not_consistent'
      END IF      

   END SUBROUTINE compare_bh

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE read_bh ( unit )

      IMPLICIT NONE

      !  Input variables.

      INTEGER , INTENT(IN) :: unit

      !  Local variables.

      INTEGER :: flag
      INTEGER :: OK

      !  The first thing for any read is the flag.

      READ ( unit , IOSTAT = OK ) flag

      IF ( OK .NE. 0 ) THEN
         PRINT '(A,I5,A)','Troubles with big header flag read.  Error #',OK,'.'
         STOP 'bh_flag_read_error'
      END IF

      !  We got the flag, is it the right one?

      IF ( flag .NE. bh_flag ) THEN
         PRINT '(A,I1,A)','Wrong flag found:',flag,'.'
         STOP 'bh_flag_error'
      END IF

      !  So, we have the big header flag, so let's assume the big
      !  header is next.  No more error tests on the reads, just when
      !  the flags are handled.  We assume that if the flag is there, 
      !  the next record is as well.

      READ ( unit ) bhi , bhr , bhic , bhrc

   END SUBROUTINE read_bh

END MODULE header_data

