MODULE horiz_interp

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION bint(xx,yy,list,iii,jjj,ibint)
   
      !  Bi-linear interpolation among four grid values
   
      IMPLICIT NONE
   
      REAL :: xx , yy
      INTEGER :: ibint , iii, jjj
      REAL list(iii,jjj),stl(4,4)
   
      INTEGER :: ib , jb, n , i , j , k , kk , l , ll
      REAL :: bint , x , y , a , b , c , d , e , f , g , h
   
      ib=iii-ibint
      jb=jjj-ibint
      bint = 0.0
      n = 0
      i = INT(xx+0.00001)
      j = INT(yy+0.00001)
      x = xx - i
      y = yy-j
   
      IF ( ( ABS(x).GT.0.0001 ) .OR. ( abs(y).gt.0.0001 ) ) THEN
         loop_1 : DO k = 1,4
            kk = i + k - 2
            IF ( ( kk .LT. 1) .OR. ( kk .GT. ib ) ) THEN
               CYCLE loop_1
            END IF
            loop_2 : DO l = 1,4
               stl(k,l) = 0.
               ll = j + l - 2
               IF ( ( ll .GT. jb ) .OR. ( ll .LT. 1 ) ) THEN
                  CYCLE loop_2
               END IF
               stl(k,l) = list(kk,ll)
               n = n + 1
               IF ( stl(k,l) .EQ. 0. ) THEN
                  stl(k,l) = 1.E-20
               END IF
            END DO loop_2
         END DO loop_1
   
         a = oned(x,stl(1,1),stl(2,1),stl(3,1),stl(4,1))
         b = oned(x,stl(1,2),stl(2,2),stl(3,2),stl(4,2))
         c = oned(x,stl(1,3),stl(2,3),stl(3,3),stl(4,3))
         d = oned(x,stl(1,4),stl(2,4),stl(3,4),stl(4,4))
         bint = oned(y,a,b,c,d)
   
         IF(n.NE.16) THEN
            e = oned(y,stl(1,1),stl(1,2),stl(1,3),stl(1,4))
            f = oned(y,stl(2,1),stl(2,2),stl(2,3),stl(2,4))
            g = oned(y,stl(3,1),stl(3,2),stl(3,3),stl(3,4))
            h = oned(y,stl(4,1),stl(4,2),stl(4,3),stl(4,4))
            bint = (bint+oned(x,e,f,g,h)) * 0.5
         END IF
   
      ELSE
         bint = list(i,j)
      END IF
   
   END FUNCTION bint

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION donor1 (y1, y2, a)
   
      !  This function is used by SUBROUTINE sint.f
   
      IMPLICIT NONE
   
      REAL                  :: donor1
      REAL,    INTENT(IN)   :: y1
      REAL,    INTENT(IN)   :: y2
      REAL,    INTENT(IN)   :: a
   
      donor1 = (y1 * MAX(0.,SIGN(1.,a)) - y2 * MIN(0.,SIGN(1.,a))) * a
   
   END FUNCTION donor1

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE exaint (ta, imax, jmax, kxs, tan, nimax, njmax, nesti, nestj, icrsdot)
   
      !  Ta is the incoming slab of data on the parent grid
      !  Tan is the outgoing slab interpolated from the parent to the nest
   
      IMPLICIT NONE
   
      INTEGER               :: imax
      INTEGER               :: jmax
      INTEGER               :: kxs
      INTEGER               :: nimax
      INTEGER               :: njmax
      INTEGER               :: nesti
      INTEGER               :: nestj
      INTEGER               :: icrsdot
      integer               :: jendc
      integer               :: iendc
      INTEGER               :: nf
      INTEGER               :: jw2
      INTEGER               :: is2
      INTEGER               :: jc2
      INTEGER               :: ic2
      INTEGER               :: jw3
      INTEGER               :: is3
      INTEGER               :: jc3
      INTEGER               :: ic3
      INTEGER               :: ii
      INTEGER               :: jj
      INTEGER               :: i
      INTEGER               :: j
      INTEGER               :: k
      INTEGER               :: j2

      REAL                  :: ta  (  imax ,  jmax , kxs )
      REAL                  :: tan ( nimax , njmax , kxs )
   
      REAL                  :: psca ( jmax, imax, 9 )
      REAL                  :: xig (9)
      REAL                  :: xjg (9)
      INTEGER               :: ig0 ( jmax, imax )
      INTEGER               :: jg0 ( jmax, imax )
   
      !  Code starts here
   
      DO i = 1 , 3
         DO j = 1 , 3
            xig(j+(i-1)*3)=1./3.-float(j-1)*1./3
            xjg(j+(i-1)*3)=1./3.-float(i-1)*1./3.
         END DO
      END DO
   
      DO i = 1 , imax
         DO j = 1 , jmax
            ig0(j,i)=j
            jg0(j,i)=i
         END DO
      END DO
   
      jendc = int(REAL(njmax-1)/3.+.001) + nestj
      iendc = int(REAL(nimax-1)/3.+.001) + nesti
   
      jw2 = nestj-4
      is2 = nesti-4
      jc2 = jendc+4
      ic2 = iendc+4
      jw3 = nestj-3
      is3 = nesti-3
      jc3 = jendc+3
      ic3 = iendc+3
   
      loop_k : DO k = 1, kxs
   
         psca = 0.
   
         !  Interpolate field, icrsdot = 1 is cross point, = 0 is dot point
   
         stagger : IF (icrsdot .EQ. 1) THEN
   
            DO i = is2 , ic2
               DO j = jw2 , jc2
                  psca(j,i,1) = ta(i,j,k)
                  psca(j,i,2) = ta(i,j,k)
                  psca(j,i,3) = ta(i,j,k)
                  psca(j,i,4) = ta(i,j,k)
                  psca(j,i,5) = ta(i,j,k)
                  psca(j,i,6) = ta(i,j,k)
                  psca(j,i,7) = ta(i,j,k)
                  psca(j,i,8) = ta(i,j,k)
                  psca(j,i,9) = ta(i,j,k)
               END DO
            END DO
     
            CALL mm5sint (psca, jmax, imax, jw3, jc3, is3, ic3, &
                          xig, xjg, ig0, jg0)
     
            DO j =1 , njmax-1
               j2 = (j-1) / 3 + nestj
               DO i = 1 , nimax-1
                  ii = (i-1) / 3 + nesti
                  jj = MOD(i-1,3) * 3 + MOD(j-1,3) + 1
                  tan(i,j,k) = psca(j2,ii,jj)
               END DO
            END DO
   
         ELSE IF (icrsdot .eq. 0) THEN stagger
   
            DO i = is2 , ic2
               DO j = jw2 , jc2
                  psca(j,i,1) = ta(i,j,k)
                  psca(j,i,2) = ta(i,j,k)
                  psca(j,i,3) = ta(i,j,k)
                  psca(j,i,4) = ta(i,j,k)
                  psca(j,i,5) = ta(i,j,k)
                  psca(j,i,6) = ta(i,j,k)
                  psca(j,i,7) = ta(i,j,k)
                  psca(j,i,8) = ta(i,j,k)
                  psca(j,i,9) = ta(i,j,k)
               END DO
            END DO
     
            CALL mm5sint (psca, jmax, imax, jw3, jc3, is3, ic3, &
                          xig, xjg, ig0, jg0)
     
            DO j = 1 , njmax
               j2 = j / 3 + nestj
               DO i = 1 , nimax
                  ii = i / 3 + nesti
                  jj = 3 * MOD(i,3) + MOD(j,3) + 1
                  tan(i,j,k) = psca(j2,ii,jj)
               END DO
            END DO
   
         END IF stagger
   
      END DO loop_k
   
   END SUBROUTINE exaint

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE mask_water ( parray ,  imax ,  jmax , &
                           narray , nimax , njmax , nesti , nestj , icrsdot , nratio , &
                           pluarray , nluarray , nlatarray , water_index , name , &
                           use_default_value , default_value , print_mask )

      IMPLICIT NONE

      !  parray    - parent array, coarse grid
      !  pluarray  - parent land use
      !  nluarray  - nested land use
      !  nlatarray - nested latitude
      !  narray    - nested array
 
      !  Input data.
 
      INTEGER                       :: imax ,  jmax , &
                                       nimax , njmax , nesti , nestj , icrsdot , &
                                       nratio , water_index
 
      REAL , DIMENSION(imax,jmax)   :: parray , pluarray
      REAL , DIMENSION(nimax,njmax) :: nluarray , nlatarray
 
      CHARACTER (LEN=8)             :: name
 
      LOGICAL                       :: print_mask , use_default_value

      REAL                          :: default_value
 
      !  Output data.
 
      REAL , DIMENSION(nimax,njmax) :: narray
 
      !  Local variables.
 
      INTEGER :: i , j , ip , jp , i_close , j_close , close_count
      REAL :: di , dj , close_data

      !  Loop through each of the nest model grid points.
   
      mask_i_loop : DO i = 1, nimax - icrsdot
         mask_j_loop : DO j = 1, njmax -icrsdot

            !  Find the lower-left hand point for the parental grid.

            ip = nesti + (i+1) / nratio - 1
            jp = nestj + (j+1) / nratio - 1
 
            di = REAL(MOD(i+1,nratio)) / REAL(nratio)
            dj = REAL(MOD(j+1,nratio)) / REAL(nratio)

            !  Test #1: Is this fine grid location a land point?  If so, then we do
            !  not assign any value here.  This may be handled in the calling routine.

            IF ( NINT(nluarray(i,j)) .NE. water_index ) THEN
            
               ! noop

            !  The alternative is that we SHOULD put some value in this slot.

            ELSE

               !  Test #2: No flag values.

               IF      ( ( NINT(pluarray(ip  ,jp  )) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp  )) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip  ,jp+1)) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp+1)) .EQ. water_index ) ) THEN
                  narray(i,j)= ( 1.-di ) * ( ( 1.-dj ) * parray ( ip   , jp   )     &
                               +                  dj   * parray ( ip   , jp+1 ) )   &
                               +    di   * ( ( 1.-dj ) * parray ( ip+1 , jp   )     &
                               +                  dj   * parray ( ip+1 , jp+1 ) )

               !  Test #3: All flag values.

               ELSE IF ( ( NINT(pluarray(ip  ,jp  )) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp  )) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip  ,jp+1)) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp+1)) .NE. water_index ) ) THEN
                  IF ( use_default_value ) THEN
                     narray(i,j)= default_value
                     IF ( print_mask ) THEN
                        PRINT '(A,A,A,I4,A,I4,A)', &
                        'Warning: Had to put in a default value for ',TRIM(name),' at (j,i) = (',i,',',j,').'
                     END IF
                  ELSE
                     IF      ( ( name(1:6) .EQ. 'SEAICE'   ) .OR. &
                               ( name(1:8) .EQ. 'SEAICEFR' ) ) THEN
                        narray(i,j) = 0.0
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus SEAICE value at (j,i) = (',i,',',j,').'
                        END IF
                     ELSE IF ( ( name(1:6) .EQ. 'ALBEDO'   ) .OR. &
                               ( name(1:6) .EQ. 'MONALB'   ) .OR. &
                               ( name(1:8) .EQ. 'ALBSNOMX' ) ) THEN
                        narray(i,j) = 8.
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus water value for one of the ALBEDO fields at (j,i) = (',i,',',j,').'
                        END IF
                     END IF
                  END IF

               !  Test #4: Some flag values.

               ELSE 

                  !  Check to see how many values of real data are within the surrounding
                  !  16 point square.

                  close_count = 0 
                  close_data  = 0
                  DO j_close = MAX (1,jp-1) , MIN(jmax-icrsdot,jp+2)                  
                     DO i_close = MAX (1,ip-1) , MIN(imax-icrsdot,ip+2)                  
                        IF ( NINT(pluarray(i_close,j_close)) .EQ. water_index ) THEN
                           close_count = close_count + 1
                           close_data = close_data + parray(i_close,j_close)
                        END IF
                     END DO
                  END DO

                  narray(i,j) = close_data / REAL ( close_count) 
                  IF ( print_mask ) THEN
                     PRINT '(A,A,A,I4,A,I4,A)', &
                     'Lake/coast type value for ',TRIM(name),' found for (j,i)=(',i,',',j,').'
                  END IF

               END IF
            END IF

         END DO mask_j_loop
      END DO mask_i_loop

   END SUBROUTINE mask_water

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE mask_land ( parray ,  imax ,  jmax , &
                          narray , nimax , njmax , nesti , nestj , icrsdot , nratio , &
                          pluarray , nluarray , nlatarray , water_index , name , &
                          use_default_value , default_value , print_mask )

      IMPLICIT NONE

      !  parray    - parent array, coarse grid
      !  pluarray  - parent land use
      !  nluarray  - nested land use
      !  nlatarray - nested latitude
      !  narray    - nested array
 
      !  Input data.
 
      INTEGER                       :: imax ,  jmax , &
                                       nimax , njmax , nesti , nestj , icrsdot , &
                                       nratio , water_index
 
      REAL , DIMENSION(imax,jmax)   :: parray , pluarray
      REAL , DIMENSION(nimax,njmax) :: nluarray , nlatarray
 
      CHARACTER (LEN=8)             :: name
 
      LOGICAL                       :: print_mask , use_default_value

      REAL                          :: default_value
 
      !  Output data.
 
      REAL , DIMENSION(nimax,njmax) :: narray
 
      !  Local variables.
 
      INTEGER :: i , j , ip , jp , i_close , j_close , close_count
      REAL :: di , dj , close_data

      !  Loop through each of the nest model grid points.
   
      mask_i_loop : DO i = 1, nimax - icrsdot
         mask_j_loop : DO j = 1, njmax -icrsdot

            !  Find the lower-left hand point for the parental grid.

            ip = nesti + (i+1) / nratio - 1
            jp = nestj + (j+1) / nratio - 1
 
            di = REAL(MOD(i+1,nratio)) / REAL(nratio)
            dj = REAL(MOD(j+1,nratio)) / REAL(nratio)

            !  Test #1: Is this fine grid location a water point?  If so, then we do
            !  not assign any value here.  This may be handled in the calling routine.

            IF ( NINT(nluarray(i,j)) .EQ. water_index ) THEN
            
               ! noop

            !  The alternative is that we SHOULD put some value in this slot.

            ELSE

               !  Test #2: No flag values.

               IF      ( ( NINT(pluarray(ip  ,jp  )) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp  )) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip  ,jp+1)) .NE. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp+1)) .NE. water_index ) ) THEN
                  narray(i,j)= ( 1.-di ) * ( ( 1.-dj ) * parray ( ip   , jp   )     &
                               +                  dj   * parray ( ip   , jp+1 ) )   &
                               +    di   * ( ( 1.-dj ) * parray ( ip+1 , jp   )     &
                               +                  dj   * parray ( ip+1 , jp+1 ) )

               !  Test #3: All flag values.

               ELSE IF ( ( NINT(pluarray(ip  ,jp  )) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp  )) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip  ,jp+1)) .EQ. water_index ) .AND. & 
                         ( NINT(pluarray(ip+1,jp+1)) .EQ. water_index ) ) THEN
                  IF ( use_default_value ) THEN
                     narray(i,j)= default_value
                     IF ( print_mask ) THEN
                        PRINT '(A,A,A,I4,A,I4,A)', &
                        'Warning: Had to put in a default value for ',TRIM(name),' at (j,i) = (',i,',',j,').'
                     END IF
                  ELSE
                     IF      ( ( name(1:5) .EQ. 'SOILT'    ) .OR.  ( name(1:6) .EQ. 'SOIL T'   ) .OR. &
                               ( name(1:8) .EQ. 'GROUND T' ) .OR.  ( name(1:8) .EQ. 'RES TEMP' ) ) THEN
                        CALL missing_soil ( nlatarray(i,j) , narray(i,j) )
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus latitude-based temperature value at (j,i) = (',i,',',j,').'
                        END IF
                     ELSE IF ( ( name(1:5) .EQ. 'SOILM' ) .OR.  ( name(1:6) .EQ. 'SOIL M' ) .OR. &
                               ( name(1:5) .EQ. 'SOILW' ) .OR.  ( name(1:6) .EQ. 'SOIL W' ) ) THEN
                        narray(i,j) = 0.3
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus value for soil moisture field at (j,i) = (',i,',',j,').'
                        END IF
                     ELSE IF ( ( name(1:6) .EQ. 'ALBEDO'   ) .OR. &
                               ( name(1:6) .EQ. 'MONALB'   ) ) THEN
                        narray(i,j) = 16.
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus value for one of the ALBEDO fields at (j,i) = (',i,',',j,').'
                        END IF
                     ELSE IF ( name(1:8) .EQ. 'ALBSNOMX' ) THEN
                        narray(i,j) = 60
                        IF ( print_mask ) THEN
                           PRINT '(A,I4,A,I4,A)', &
                           'Warning: Had to put in a bogus value for max ALBEDO fields at (j,i) = (',i,',',j,').'
                        END IF
                     END IF
                  END IF

               !  Test #4: Some flag values.

               ELSE 

                  !  Check to see how many values of real data are within the surrounding
                  !  16 point square.

                  close_count = 0 
                  close_data  = 0
                  DO j_close = MAX (1,jp-1) , MIN(jmax-icrsdot,jp+2)                  
                     DO i_close = MAX (1,ip-1) , MIN(imax-icrsdot,ip+2)                  
                        IF ( NINT(pluarray(i_close,j_close)) .NE. water_index ) THEN
                           close_count = close_count + 1
                           close_data = close_data + parray(i_close,j_close)
                        END IF
                     END DO
                  END DO

                  narray(i,j) = close_data / REAL ( close_count) 
                  IF ( print_mask ) THEN
                     PRINT '(A,A,A,I4,A,I4,A)', &
                     'Island/coast type value for ',TRIM(name),' found for (j,i)=(',i,',',j,').'
                  END IF

               END IF
            END IF

         END DO mask_j_loop
      END DO mask_i_loop

   END SUBROUTINE mask_land

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE missing_soil(xlat,tempg)

      !  Use latitude to define soil temperature for missing values.
      !  This routine and coefficients were obtained from Yong-Run Guo, Sep 1999.

      IMPLICIT NONE

      REAL :: xlat , tempg , angle 

      REAL , PARAMETER :: c0= 0.24206E+03 
      REAL , PARAMETER :: c1= 0.59736E+02 
      REAL , PARAMETER :: c2= 0.19445E+01

      angle = 0.5*3.1415926*((89.5-xlat)/89.5)
      tempg = c0 + c1*sin(angle) + c2*cos(angle)

   END SUBROUTINE missing_soil

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE mm5sint (xf, n, m, n1star, n1end, n2star, n2end, &
                          xig, xjg, ig0, jg0)
   
      !  Semi-lagrangian interpolation for whole domain
   
      IMPLICIT NONE
   
      INTEGER,   PARAMETER  :: nf       = 9
      REAL,      PARAMETER  :: ep       = 1.e-10
      INTEGER,   PARAMETER  :: ior      = 2
   
      INTEGER               :: iim
      INTEGER               :: i
      INTEGER               :: ii
      INTEGER               :: j
      INTEGER               :: jj
      INTEGER               :: n1star
      INTEGER               :: n1end
      INTEGER               :: n2star
      INTEGER               :: n2end
      INTEGER               :: n
      INTEGER               :: m
      REAL                  :: xig      (9)
      REAL                  :: xjg      (9)
      INTEGER               :: ig0      ( : , : )
      INTEGER               :: jg0      ( : , : )
   
      REAL                  :: xf       ( : , : , : )
   
      REAL                  :: f        ( n , m ,    0:1   )
      REAL                  :: fl       ( n , m ,    0:1   )
      REAL                  :: mxm      ( n , m )
      REAL                  :: mn       ( n , m )
      REAL                  :: ov       ( n , m )
      REAL                  :: un       ( n , m )
      REAL                  :: w        ( n , m )
      REAL                  :: y        ( n , m , -ior:ior )
      REAL                  :: z        ( n , m , -ior:ior )

      !  Statement functions.

      REAL,    PARAMETER    :: oneov12 = 1./12.
      REAL,    PARAMETER    :: oneov24 = 1./24.
      REAL                  :: y1
      REAL                  :: y2
      REAL                  :: a
      REAL                  :: x
      REAL                  :: ym1
      REAL                  :: y0
      REAL                  :: yp1
      REAL                  :: yp2

      REAL                  :: donor , pn , pp , tr4
   
      donor(y1, y2, a) = (y1 * MAX(0.,SIGN(1.,a)) - y2 * MIN(0.,SIGN(1.,a))) * a
      pn(x) = MIN(0. , x)
      pp(x) = MAX(0. , x)
      tr4(ym1, y0, yp1, yp2, a ) =     a * oneov12 * ( 7. * (yp1 + y0) - (yp2 + ym1)) &
           - a**2 * oneov24 * (15. * (yp1 - y0) - (yp2 - ym1)) &
           - a**3 * oneov12 *       ((yp1 + y0) - (yp2 + ym1)) &
           + a**4 * oneov24 * ( 3. * (yp1 - y0) - (yp2 - ym1))
   
      DO iim = 1, nf
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( ii , jj , i , j ) 
         DO jj = n2star, n2end
            DO j = -ior, ior
               DO i = -ior, ior
                  DO ii = n1star, n1end
                     y(ii,jj,i) = xf(ig0(ii,jj) + i, jg0(ii,jj) + j, iim)
                  END DO
               END DO
               DO ii = n1star, n1end
                  fl(ii,jj,0) = donor(y(ii,jj,-1), y(ii,jj,0), xig(iim))
                  fl(ii,jj,1) = donor(y(ii,jj, 0), y(ii,jj,1), xig(iim))
               END DO
               DO ii = n1star, n1end
                  w(ii,jj) = y(ii,jj,0) - (fl(ii,jj,1) - fl(ii,jj,0))
               END DO
               DO ii = n1star,n1end
                  mxm(ii,jj) = MAX (y(ii,jj,-1), y(ii,jj,0), &
                                      y(ii,jj, 1), w(ii,jj))
                  mn(ii,jj)  = MIN (y(ii,jj,-1), y(ii,jj,0), &
                                      y(ii,jj, 1), w(ii,jj))
               END DO
               DO ii = n1star , n1end
                  f(ii,jj,0) = tr4 (y(ii,jj,-2), y(ii,jj,-1), y(ii,jj,0), &
                                    y(ii,jj, 1), xig(iim))
                  f(ii,jj,1) = tr4 (y(ii,jj,-1), y(ii,jj, 0), y(ii,jj,1), &
                                    y(ii,jj, 2), xig(iim))
               END DO
               DO ii = n1star, n1end
                  f(ii,jj,0) = f(ii,jj,0) - fl(ii,jj,0)
                  f(ii,jj,1) = f(ii,jj,1) - fl(ii,jj,1)
               END DO
               DO ii = n1star, n1end
                  ov(ii,jj) = (mxm(ii,jj) -  w(ii,jj)) &
                            / (-pn(f(ii,jj,1)) + pp(f(ii,jj,0)) + ep)
                  un(ii,jj) = (  w(ii,jj) - mn(ii,jj)) &
                            / ( pp(f(ii,jj,1)) - pn(f(ii,jj,0)) + ep)
               END DO
               DO ii = n1star, n1end
                  f(ii,jj,0) = pp(f(ii,jj,0)) * MIN(1.,ov(ii,jj)) + &
                               pn(f(ii,jj,0)) * MIN(1.,un(ii,jj))
                  f(ii,jj,1) = pp(f(ii,jj,1)) * MIN(1.,un(ii,jj)) + &
                               pn(f(ii,jj,1)) * MIN(1.,ov(ii,jj))
               END DO
               DO ii = n1star, n1end
                  y(ii,jj,0) = w(ii,jj) - (f(ii,jj,1) - f(ii,jj,0))
               END DO
               DO ii = n1star, n1end
                  z(ii,jj,j) = y(ii,jj,0)
               END DO
            END DO
    
            DO ii = n1star, n1end
               fl(ii,jj,0) = donor(z(ii,jj,-1), z(ii,jj,0), xjg(iim))
               fl(ii,jj,1) = donor(z(ii,jj, 0), z(ii,jj,1), xjg(iim))
            END DO
            DO ii = n1star, n1end
               w(ii,jj) = z(ii,jj,0) - (fl(ii,jj,1) - fl(ii,jj,0))
            END DO
            DO ii = n1star, n1end
               mxm(ii,jj) = MAX(z(ii,jj,-1), z(ii,jj,0), &
                                  z(ii,jj, 1), w(ii,jj))
               mn (ii,jj) = MIN(z(ii,jj,-1), z(ii,jj,0), &
                                  z(ii,jj, 1), w(ii,jj))
            END DO
            DO ii = n1star, n1end
               f(ii,jj,0) = tr4 (z(ii,jj,-2), z(ii,jj,-1), z(ii,jj,0), &
                                 z(ii,jj, 1), xjg(iim))
               f(ii,jj,1) = tr4 (z(ii,jj,-1), z(ii,jj, 0), z(ii,jj,1), &
                                 z(ii,jj, 2), xjg(iim))
            END DO
            DO ii = n1star, n1end
               f(ii,jj,0) = f(ii,jj,0) - fl(ii,jj,0)
               f(ii,jj,1) = f(ii,jj,1) - fl(ii,jj,1)
            END DO
            DO ii = n1star, n1end
               ov(ii,jj) = (mxm(ii,jj) -  w(ii,jj)) &
                         / (-pn(f(ii,jj,1)) + pp(f(ii,jj,0)) + ep)
               un(ii,jj) = (  w(ii,jj) - mn(ii,jj)) &
                         / ( pp(f(ii,jj,1)) - pn(f(ii,jj,0)) + ep)
            END DO
            DO ii = n1star, n1end
               f(ii,jj,0) = pp(f(ii,jj,0)) * MIN(1.,ov(ii,jj)) &
                          + pn(f(ii,jj,0)) * MIN(1.,un(ii,jj))
               f(ii,jj,1) = pp(f(ii,jj,1)) * MIN(1.,un(ii,jj)) &
                          + pn(f(ii,jj,1)) * MIN(1.,ov(ii,jj))
            END DO
         END DO
   
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( ii , jj ) 
         DO jj = n2star, n2end
            DO ii = n1star, n1end
               xf(ii,jj,iim) = w(ii,jj) - (f(ii,jj,1) - f(ii,jj,0))
            END DO
         END DO
   
      END DO
   
   END SUBROUTINE mm5sint

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION oned(x,a,b,c,d) 
   
      IMPLICIT NONE
   
      REAL :: x,a,b,c,d,oned
   
      oned = 0.                
   
      IF      ( x .EQ. 0. ) THEN
         oned = b      
      ELSE IF ( x .EQ. 1. ) THEN
         oned = c      
      END IF
   
      IF(b*c.NE.0.) THEN
         IF ( a*d .EQ. 0. ) THEN
            IF      ( ( a .EQ. 0 ) .AND. ( d .EQ. 0 ) ) THEN
               oned = b*(1.0-x)+c*x                                        
            ELSE IF ( a .NE. 0. ) THEN
               oned = b+x*(0.5*(c-a)+x*(0.5*(c+a)-b))            
            ELSE IF ( d .NE. 0. ) THEN
               oned = c+(1.0-x)*(0.5*(b-d)+(1.0-x)*(0.5*(b+d)-c)) 
            END IF
         ELSE
            oned = (1.0-x)*(b+x*(0.5*(c-a)+x*(0.5*(c+a)-b)))+x*(c+(1.0-x)*(0.5*(b-d)+(1.0-x)*(0.5*(b+d)-c)))                                   
         END IF
      END IF
   
   END FUNCTION oned                                                       

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION pn1 ( x )
   
      !  This function is used by SUBROUTINE sint.f
   
      IMPLICIT NONE
   
      REAL                  :: pn1
      REAL,    INTENT(IN)   :: x
   
      pn1 = MIN(0. , x)
   
   END FUNCTION pn1

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION pp1 ( x )
   
      !  This function is used by SUBROUTINE sint.f
   
      IMPLICIT NONE
   
      REAL                  :: pp1
      REAL,    INTENT(IN)   :: x
   
      pp1 = MAX(0. , x)
   
   END FUNCTION pp1

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE quaint(fin,ixc,jxc,kx,fout,ixn,jxn,inest,jnest,icrsdot)
   
      IMPLICIT NONE
   
      INTEGER :: ixc,jxc,kx,ixn,jxn,inest,jnest,icrsdot
      REAL , dimension(ixc,jxc,kx) :: fin
      REAL , dimension(ixn,jxn,kx) :: fout
   
      INTEGER , PARAMETER :: iratio=3
      REAL , PARAMETER :: onethrd =1./3. , twothrd =2./3. , &
                          onethrd1=1./3.+1. , twothrd1=2./3.+1.
   
      REAL :: biparab , x , f1,f2,f3,f4,a,b,c,d,e,f,g,h
      INTEGER :: i , j , k , iendc , jendc , ic , jc
   
      biparab(x,f1,f2,f3,f4)= &
        ((x-1.0)*(x-2.0)*f1*0.5   - (x    )*(x-2.0)*f2 + &
         (x    )*(x-1.0)*f3*0.5 ) * ABS(x-2.0) + &
        ((x-2.0)*(x-3.0)*f2*0.5   - (x-1.0)*(x-3.0)*f3 + &
         (x-1.0)*(x-2.0)*f4*0.5 ) * ABS(x-1.0)
   
      !  Coarse i,j (ic,jc) to nest i,j
   
      jendc=(jxn-1)/iratio + jnest
      iendc=(ixn-1)/iratio + inest
   
!$OMP PARALLEL DO DEFAULT ( SHARED ) &
!$OMP PRIVATE ( i , j , k , ic , jc , a , b , c , d , e , f , g , h )
      DO k = 1 , kx
  
         !  Computation different for cross and dot point
      
         IF(icrsdot.EQ.0) THEN ! this is dot point interpolation
       
            !  Fill in all coincident points.
      
            DO jc=jnest,jendc
               j=jc*iratio-jnest*iratio+1
               DO ic=inest,iendc
                  i=ic*iratio-inest*iratio+1
                  fout(i,j,k)=fin(ic,jc,k)
               END DO
            END DO
      
            !  Set nested values in same rows as coarse
      
               DO jc=jnest,jendc-1
                  j=jc*iratio-jnest*iratio+1
            DO ic=inest,iendc
               i=ic*iratio-inest*iratio+1
                  fout(i,j+1,k)=biparab(onethrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
                  fout(i,j+2,k)=biparab(twothrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
               END DO
            END DO
      
            !  Set nested values in same columns as coarse
      
            DO jc=jnest,jendc
               j=jc*iratio-jnest*iratio+1
               DO ic=inest,iendc-1
                  i=ic*iratio-inest*iratio+1
                  fout(i+1,j,k)=biparab(onethrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
                  fout(i+2,j,k)=biparab(twothrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
               END DO
            END DO
      
            !  Set rest of 4 points in each of boundary corners
      
            jc=jnest ! lower left
            ic=inest
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(2,j+1,k)=biparab(onethrd1,a,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k))
            fout(2,j+2,k)=biparab(twothrd1,a,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k))
            fout(3,j+1,k)=biparab(onethrd1,b,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k))
            fout(3,j+2,k)=biparab(twothrd1,b,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k))
      
            jc=jendc-2 ! lower right
            ic=inest
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(2,j+4,k)=biparab(onethrd1,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k),a)
            fout(2,j+5,k)=biparab(twothrd1,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k),a)
            fout(3,j+4,k)=biparab(onethrd1,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k),b)
            fout(3,j+5,k)=biparab(twothrd1,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k),b)
      
            jc=jnest ! upper left
            ic=iendc-1
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(ixn-2,j+1,k)=biparab(onethrd1,a,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k))
            fout(ixn-2,j+2,k)=biparab(twothrd1,a,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k))
            fout(ixn-1,j+1,k)=biparab(onethrd1,b,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k))
            fout(ixn-1,j+2,k)=biparab(twothrd1,b,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k))
      
            jc=jendc-2 ! upper right
            ic=iendc-1
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(ixn-2,j+4,k)=biparab(onethrd1,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k),a)
            fout(ixn-2,j+5,k)=biparab(twothrd1,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k),a)
            fout(ixn-1,j+4,k)=biparab(onethrd1,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k),b)
            fout(ixn-1,j+5,k)=biparab(twothrd1,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k),b)
      
            !  Do inside of lower row and upper row
      
            DO jc=jnest+1,jendc-2
               j=jc*iratio-jnest*iratio+1
               fout(2,j+1,k)=biparab(onethrd1,fout(2,j-3,k),fout(2,j,k), &
                  fout(2,j+3,k),fout(2,j+6,k))
               fout(3,j+1,k)=biparab(onethrd1,fout(3,j-3,k),fout(3,j,k), &
                  fout(3,j+3,k),fout(3,j+6,k))
               fout(2,j+2,k)=biparab(twothrd1,fout(2,j-3,k),fout(2,j,k), &
                  fout(2,j+3,k),fout(2,j+6,k))
               fout(3,j+2,k)=biparab(twothrd1,fout(3,j-3,k),fout(3,j,k), &
                  fout(3,j+3,k),fout(3,j+6,k))
               fout(ixn-2,j+1,k)=biparab(onethrd1,fout(ixn-2,j-3,k),fout(ixn-2,j,k), &
                  fout(ixn-2,j+3,k),fout(ixn-2,j+6,k))
               fout(ixn-1,j+1,k)=biparab(onethrd1,fout(ixn-1,j-3,k),fout(ixn-1,j,k), &
                  fout(ixn-1,j+3,k),fout(ixn-1,j+6,k))
               fout(ixn-2,j+2,k)=biparab(twothrd1,fout(ixn-2,j-3,k),fout(ixn-2,j,k), &
                  fout(ixn-2,j+3,k),fout(ixn-2,j+6,k))
               fout(ixn-1,j+2,k)=biparab(twothrd1,fout(ixn-1,j-3,k),fout(ixn-1,j,k), &
                  fout(ixn-1,j+3,k),fout(ixn-1,j+6,k))
            END DO
      
            !  Fill in everyone
      
            DO jc=jnest,jendc-1
               j=jc*iratio-jnest*iratio+1
               DO ic=inest+1,iendc-2
                  i=ic*iratio-inest*iratio+1
                  a=fout(i-3,j+1,k)
                  b=fout(i  ,j+1,k)
                  c=fout(i+3,j+1,k)
                  d=fout(i+6,j+1,k)
                  fout(i+1,j+1,k)=biparab(onethrd1,a,b,c,d)
                  fout(i+2,j+1,k)=biparab(twothrd1,a,b,c,d)
                  e=fout(i-3,j+2,k)
                  f=fout(i  ,j+2,k)
                  g=fout(i+3,j+2,k)
                  h=fout(i+6,j+2,k)
                  fout(i+1,j+2,k)=biparab(onethrd1,e,f,g,h)
                  fout(i+2,j+2,k)=biparab(twothrd1,e,f,g,h)
               END DO
            END DO
      
         !     ... this is the cross point deal
      
         ELSE IF(icrsdot.EQ.1) THEN ! this is cross point interpolation
      
            !  Fill in all coincident points: nest is on top of coarse
      
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest,iendc-icrsdot
                  i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i,j,k)=fin(ic,jc,k)
               END DO
            END DO
      
           !  Set nested values in same rows as coarse
      
               DO jc=jnest,jendc-1
                  j=jc*iratio-jnest*iratio+1+icrsdot
            DO ic=inest,iendc-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i,j+1,k)=biparab(onethrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
                  fout(i,j+2,k)=biparab(twothrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
               END DO
            END DO
            DO ic=inest,iendc-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
               jc=jnest ! inside nest INTERFACE, outside cross pt x=1
               j=jc*iratio-jnest*iratio+1+icrsdot
               fout(i,j-1,k)=biparab(twothrd1,fin(ic,jc-2,k),fin(ic,jc-1,k), &
                  fin(ic,jc,k),fin(ic,jc+1,k))
               jc=jendc ! inside nest interface, outside cross pt x=jx-1
               j=jc*iratio-jnest*iratio+1+icrsdot
               fout(i,j-2,k)=biparab(onethrd1,fin(ic,jc-2,k),fin(ic,jc-1,k), &
                  fin(ic,jc,k),fin(ic,jc+1,k))
            END DO
      
            !  Set nested values in same columns as coarse
      
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest,iendc-1
                  i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i+1,j,k)=biparab(onethrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
                  fout(i+2,j,k)=biparab(twothrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
               END DO
            END DO
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               ic=inest ! inside nest INTERFACE, outside cross pt y=1
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i-1,j,k)=biparab(twothrd1,fin(ic-2,jc,k),fin(ic-1,jc,k), &
                  fin(ic,jc,k),fin(ic+1,jc,k))
               ic=iendc ! inside nest interface, outside cross pt y=ix-1
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i-2,j,k)=biparab(onethrd1,fin(ic-2,jc,k),fin(ic-1,jc,k), &
                  fin(ic,jc,k),fin(ic+1,jc,k))
            END DO
      
            !  Set rest of 4 points in each of boundary corners
      
            jc=jnest ! lower left + lower left straggler
            ic=inest
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(i+1,j+1,k)=biparab(onethrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+1,j+2,k)=biparab(twothrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+2,j+1,k)=biparab(onethrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            fout(i+2,j+2,k)=biparab(twothrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            c=biparab(twothrd1,fin(ic-2,jc-2,k),fin(ic-1,jc-2,k), &
               fin(ic,jc-2,k),fin(ic+1,jc-2,k))
            d=biparab(twothrd1,fin(ic-2,jc-1,k),fin(ic-1,jc-1,k), &
               fin(ic,jc-1,k),fin(ic+1,jc-1,k))
            fout(i-1,j-1,k)=biparab(twothrd1,c,d,fout(i-1,j,k),fout(i-1,j+3,k))
            fout(i-1,j+1,k)=biparab(onethrd1,d,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k))
            fout(i-1,j+2,k)=biparab(twothrd1,d,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k))
            e=biparab(twothrd1,fin(ic-1,jc-2,k),fin(ic-1,jc-1,k), &
               fin(ic-1,jc,k),fin(ic-1,jc+1,k))
            fout(i+1,j-1,k)=biparab(onethrd1,e,fout(i,j-1,k),fout(i+3,j-1,k), &
               fout(i+6,j-1,k))
            fout(i+2,j-1,k)=biparab(twothrd1,e,fout(i,j-1,k),fout(i+3,j-1,k), &
               fout(i+6,j-1,k))
      
            jc=jendc-2-icrsdot ! lower right + lower right straggler
            ic=inest
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(i+1,j+4,k)=biparab(onethrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+1,j+5,k)=biparab(twothrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+2,j+4,k)=biparab(onethrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            fout(i+2,j+5,k)=biparab(twothrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            c=biparab(twothrd1,fin(ic-2,jc+3,k),fin(ic-1,jc+3,k), &
               fin(ic,jc+3,k),fin(ic+1,jc+3,k))
            d=biparab(twothrd1,fin(ic-2,jc+4,k),fin(ic-1,jc+4,k), &
               fin(ic,jc+4,k),fin(ic+1,jc+4,k))
            fout(i-1,j+7,k)=biparab(onethrd1,fout(i-1,j+3,k),fout(i-1,j+6,k),c,d)
            fout(i-1,j+4,k)=biparab(onethrd1,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k),c)
            fout(i-1,j+5,k)=biparab(twothrd1,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k),c)
            e=biparab(onethrd1,fin(ic-1,jc+1,k),fin(ic-1,jc+2,k), &
               fin(ic-1,jc+3,k),fin(ic-1,jc+4,k))
            fout(i+1,j+7,k)=biparab(onethrd1,e,fout(i,j+7,k),fout(i+3,j+7,k), &
               fout(i+6,j+7,k))
            fout(i+2,j+7,k)=biparab(twothrd1,e,fout(i,j+7,k),fout(i+3,j+7,k), &
               fout(i+6,j+7,k))
      
            jc=jnest ! upper left + upper left straggler
            ic=iendc-1-icrsdot
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(i+1,j+1,k)=biparab(onethrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+1,j+2,k)=biparab(twothrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+2,j+1,k)=biparab(onethrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            fout(i+2,j+2,k)=biparab(twothrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            c=biparab(onethrd1,fin(ic,jc-2,k),fin(ic+1,jc-2,k), &
               fin(ic+2,jc-2,k),fin(ic+3,jc-2,k))
            d=biparab(onethrd1,fin(ic,jc-1,k),fin(ic+1,jc-1,k), &
               fin(ic+2,jc-1,k),fin(ic+3,jc-1,k))
            fout(i+4,j-1,k)=biparab(twothrd1,c,d,fout(i+4,j,k),fout(i+4,j+3,k))
            fout(i+4,j+1,k)=biparab(onethrd1,d,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k))
            fout(i+4,j+2,k)=biparab(twothrd1,d,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k))
            e=biparab(twothrd1,fin(ic+2,jc-2,k),fin(ic+2,jc-1,k), &
               fin(ic+2,jc,k),fin(ic+2,jc+1,k))
            fout(i+1,j-1,k)=biparab(onethrd1,fout(i-3,j-1,k),fout(i,j-1,k), &
               fout(i+3,j-1,k),e)
            fout(i+2,j-1,k)=biparab(twothrd1,fout(i-3,j-1,k),fout(i,j-1,k), &
               fout(i+3,j-1,k),e)
      
            jc=jendc-2-icrsdot ! upper right + upper right straggler
            ic=iendc-1-icrsdot
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(i+1,j+4,k)=biparab(onethrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+1,j+5,k)=biparab(twothrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+2,j+4,k)=biparab(onethrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            fout(i+2,j+5,k)=biparab(twothrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            c=biparab(onethrd1,fin(ic,jc+3,k),fin(ic+1,jc+3,k), &
               fin(ic+2,jc+3,k),fin(ic+3,jc+3,k))
            d=biparab(onethrd1,fin(ic,jc+4,k),fin(ic+1,jc+4,k), &
               fin(ic+2,jc+4,k),fin(ic+3,jc+4,k))
            fout(i+4,j+7,k)=biparab(onethrd1,fout(i+4,j+3,k),fout(i+4,j+6,k),c,d)
            fout(i+4,j+4,k)=biparab(onethrd1,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k),c)
            fout(i+4,j+5,k)=biparab(twothrd1,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k),c)
            e=biparab(onethrd1,fin(ic+2,jc+1,k),fin(ic+2,jc+2,k), &
               fin(ic+2,jc+3,k),fin(ic+2,jc+4,k))
            fout(i+1,j+7,k)=biparab(onethrd1,fout(i-3,j+7,k),fout(i,j+7,k), &
               fout(i+3,j+7,k),e)
            fout(i+2,j+7,k)=biparab(twothrd1,fout(i-3,j+7,k),fout(i,j+7,k), &
               fout(i+3,j+7,k),e)
      
            !  Do inside of lower row and upper row
      
            DO jc=jnest+1,jendc-2-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               ic=inest
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i+1,j+1,k)=biparab(onethrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+1,k)=biparab(onethrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+1,j+2,k)=biparab(twothrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+2,k)=biparab(twothrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i-1,j+1,k)=biparab(onethrd1,fout(i-1,j-3,k),fout(i-1,j,k), &
                  fout(i-1,j+3,k),fout(i-1,j+6,k))
               fout(i-1,j+2,k)=biparab(twothrd1,fout(i-1,j-3,k),fout(i-1,j,k), &
                  fout(i-1,j+3,k),fout(i-1,j+6,k))
               ic=iendc-1-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i+1,j+1,k)=biparab(onethrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+1,k)=biparab(onethrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+1,j+2,k)=biparab(twothrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+2,k)=biparab(twothrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+4,j+1,k)=biparab(onethrd1,fout(i+4,j-3,k),fout(i+4,j,k), &
                  fout(i+4,j+3,k),fout(i+4,j+6,k))
               fout(i+4,j+2,k)=biparab(twothrd1,fout(i+4,j-3,k),fout(i+4,j,k), &
                  fout(i+4,j+3,k),fout(i+4,j+6,k))
            END DO
      
            !  Fill in everyone
      
            DO jc=jnest,jendc-1-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest+1,iendc-2-icrsdot
                  i=ic*iratio-inest*iratio+1+icrsdot
                  a=fout(i-3,j+1,k)
                  b=fout(i  ,j+1,k)
                  c=fout(i+3,j+1,k)
                  d=fout(i+6,j+1,k)
                  fout(i+1,j+1,k)=biparab(onethrd1,a,b,c,d)
                  fout(i+2,j+1,k)=biparab(twothrd1,a,b,c,d)
                  e=fout(i-3,j+2,k)
                  f=fout(i  ,j+2,k)
                  g=fout(i+3,j+2,k)
                  h=fout(i+6,j+2,k)
                  fout(i+1,j+2,k)=biparab(onethrd1,e,f,g,h)
                  fout(i+2,j+2,k)=biparab(twothrd1,e,f,g,h)
               END DO
            END DO
            DO ic=inest+1,iendc-2-icrsdot
               j=1
               i=ic*iratio-inest*iratio+1+icrsdot
               a=fout(i-3,j,k)
               b=fout(i  ,j,k)
               c=fout(i+3,j,k)
               d=fout(i+6,j,k)
               fout(i+1,j,k)=biparab(onethrd1,a,b,c,d)
               fout(i+2,j,k)=biparab(twothrd1,a,b,c,d)
               j=jxn-1
               e=fout(i-3,j,k)
               f=fout(i  ,j,k)
               g=fout(i+3,j,k)
               h=fout(i+6,j,k)
               fout(i+1,j,k)=biparab(onethrd1,e,f,g,h)
               fout(i+2,j,k)=biparab(twothrd1,e,f,g,h)
            END DO
         END IF

      END DO 
   
   END SUBROUTINE quaint

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE slowint(coarse,ixc,jxc,kx,fine,ixn,jxn,icns,jcns,icrsdot,iratio)
   
      INTEGER :: ixc,jxc,kx,ixn,jxn,icns,jcns,iratio,icrsdot
      REAL , DIMENSION (ixc,jxc,kx) :: coarse
      REAL , DIMENSION (ixn,jxn,kx) :: fine
   
      REAL :: scale , xcross , x , y
      INTEGER :: i , j , k
   
      scale=1./REAL(iratio)
      xcross=REAL(icrsdot)
   
      DO k = 1 , kx 
         DO i=1,ixn
            y=REAL(icns)+REAL(i)*scale-scale-xcross*(1.-scale)/2.
            DO j=1,jxn
               x=REAL(jcns)+REAL(j)*scale-scale-xcross*(1.-scale)/2.
               fine(i,j,k)=bint(y,x,coarse(1,1,k),ixc,jxc,icrsdot)
            END DO
         END DO
      END DO
   
   END SUBROUTINE slowint

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   FUNCTION tr41 ( ym1, y0, yp1, yp2, a )
   
      !  This function is used by SUBROUTINE sint.f
   
      IMPLICIT NONE
   
      REAL,    PARAMETER    :: oneov12 = 1./12.
      REAL,    PARAMETER    :: oneov24 = 1./24.
      REAL                  :: tr41
      REAL,    INTENT(IN)   :: ym1
      REAL,    INTENT(IN)   :: y0
      REAL,    INTENT(IN)   :: yp1
      REAL,    INTENT(IN)   :: yp2
      REAL,    INTENT(IN)   :: a
   
      tr41 =    a * oneov12 * ( 7. * (yp1 + y0) - (yp2 + ym1)) &
           - a**2 * oneov24 * (15. * (yp1 - y0) - (yp2 - ym1)) &
           - a**3 * oneov12 *       ((yp1 + y0) - (yp2 + ym1)) &
           + a**4 * oneov24 * ( 3. * (yp1 - y0) - (yp2 - ym1))
   
   END FUNCTION tr41

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


END MODULE horiz_interp
