MODULE lateral_bdy
   
   USE bdy

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE bdyoutn (iunit ,imx, jmx, kxs, itimes, interval , &
                       start_year , start_month , start_day , start_hour , &
                       start_minute , start_second , start_frac )

      USE date_pack
      USE header_data
      USE all_io

      IMPLICIT NONE

      INTEGER               :: iunit , start_year , start_month , start_day , start_hour , &
                               start_minute , start_second , start_frac
      !  Data for small header.

      INTEGER                :: num_dims
      INTEGER , DIMENSION(4) :: start_dims
      INTEGER , DIMENSION(4) :: end_dims
      REAL                   :: xtime
      CHARACTER (LEN= 4)     :: staggering
      CHARACTER (LEN= 4)     :: ordering
      CHARACTER (LEN= 9)     :: name
      CHARACTER (LEN=25)     :: units
      CHARACTER (LEN=46)     :: description

      INTEGER                     :: imx
      INTEGER                     :: interval
      INTEGER                     :: itimes
      INTEGER                     :: jmx
      INTEGER                     :: kxs

      INTEGER                     :: icrsdot
      INTEGER                     :: loop
      REAL                        :: dts
      REAL , ALLOCATABLE , DIMENSION(:,:,:) :: et3d , wt3d , nt3d , st3d
      CHARACTER (LEN=16)          :: per_time
      CHARACTER (LEN= 3)          :: coupled 
      CHARACTER (LEN= 8)          :: new_name

      INTEGER                     :: return_code


      IF (ITIMES .EQ. 1) THEN

         !  Create the nspgd rows and columns along the boundary for each of the
         !  3d fields.

         DO loop = 1 , num_3d
            IF ( nall_3d(loop)%small_header%staggering(1:1) .EQ. 'D' ) THEN
               icrsdot = 0 
            ELSE
               icrsdot = 1 
            END IF
            CALL bound ( nall_3d(loop)%array , &
                         nall_3d(loop)%ebdy  , &
                         nall_3d(loop)%wbdy  , &
                         nall_3d(loop)%nbdy  , &
                         nall_3d(loop)%sbdy  , &
                         imx, jmx, nall_3d(loop)%small_header%end_dims(3), icrsdot )
         END DO

         !  The first time in we do the big header jazz.

         WRITE ( iunit ) bh_flag

         !  Just in case no one else cleared the big header, we should do it.  All
         !  of the header values for the lateral boundary condition index can be set to -999.
   
         bhi (:,7) = -999
         bhr (:,7) = -999
         bhic(:,7) = '                                                                                '
         bhrc(:,7) = '                                                                                '
   
         !  Identify the data as the lateral boundary condition for MM5.
   
         bhi( 1,1) = 7 ; bhic( 1,1) = '1-way model lateral boundary condition for MM5                                  '
   
         !  A few lines about data format and version numbers.  If we make a change in the
         !  IC INTERP output version numbers, those will now be reflected here.
   
         bhi( 2,7) = bhi(2,5) ; bhic( 2,7) = bhic(2,5)
         bhi( 3,7) = bhi(3,5) ; bhic( 3,7) = bhic(3,5)
         bhi( 4,7) = bhi(4,5) ; bhic( 4,7) = bhic(4,5)
   
         !  Starting date of the NESTDOWN data, this was specified in the namelist.
   
         bhi ( 5,7) = start_year
         bhic( 5,7) = 'Four-digit year of start time                                                   '
         bhi ( 6,7) = start_month
         bhic( 6,7) = 'Month of the year of the start time (1-12)                                      '
         bhi ( 7,7) = start_day
         bhic( 7,7) = 'Day of the month of the start time (1-31)                                       '
         bhi ( 8,7) = start_hour
         bhic( 8,7) = 'Hour of the day of the start time (0-23)                                        '
         bhi ( 9,7) = start_minute
         bhic( 9,7) = 'Minute of the start time (0-59)                                                 '
         bhi (10,7) = start_second
         bhic(10,7) = 'Second of the start time (0-59)                                                 '
         bhi (11,7) = start_frac
         bhic(11,7) = 'Ten thousandths of a second of the start time (0-9999)                          '
   
         !  How many levels to expect.
   
         bhi (12,7) = kxs
         bhic(12,7) = 'Number of levels in the lateral boundary condition file                         '
   
         !  Time interval between output files.
   
         bhr ( 1,7) = interval                
         bhrc( 1,7) = 'Time difference (seconds) during which the lateral boundary condition is valid  '
   
         !  Output the big header.
   
         WRITE ( iunit ) bhi , bhr , bhic , bhrc

      ELSE IF (ITIMES .GT. 1) THEN

         WRITE ( per_time , '(" ",I5,"{-1} s{-1}")' ) interval
         coupled = ' Pa'

         CALL geth_newdate(old_date , current_date , -1*interval )
         dts = interval

         !  Loop over all of the 3d arrays.

         !  1) For the east boundary:
         !     A) WRITE flag
         !     B) Build small header
         !     C) WRITE small_header
         !     D) WRITE lateral boundary
         !  2 - 4) repeat step 1) for west, north and south.
         !  5) Compute boundary tendencies
         !  6) For the east boundary tendency:
         !     A) WRITE flag
         !     B) Build small header
         !     C) WRITE small_header
         !     D) WRITE lateral boundary tendency
         !  7 - 10) repeat step 6) for west, north and south.
         ! 11) WRITE end-of-time flag

         DO loop = 1 , num_3d

            IF ( nall_3d(loop)%small_header%staggering(1:1) .EQ. 'D' ) THEN
               icrsdot = 0 
            ELSE
               icrsdot = 1 
            END IF
     
            !  The name of the field changes sometimes for the boundary file.

            IF      ( nall_3d(loop)%small_header%name(1:8) .EQ. 'CLW     ' ) THEN
               new_name = 'QC      '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'RNW     ' ) THEN
               new_name = 'QR      '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'ICE     ' ) THEN
               new_name = 'QI      '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'SNOW    ' ) THEN
               new_name = 'QNI     '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'GRAUPEL ' ) THEN
               new_name = 'QG      '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'NCI     ' ) THEN
               new_name = 'QNC     '
            ELSE IF ( nall_3d(loop)%small_header%name(1:8) .EQ. 'RAD TEND' ) THEN
               new_name = 'RT      '
            ELSE
               new_name = nall_3d(loop)%small_header%name(1:8)
            END IF

            !  East boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'EB'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled
            description     = nall_3d(loop)%small_header%description
            description(33:46) = ' east boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nall_3d(loop)%ebdy
   
            !  West boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'WB'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled
            description     = nall_3d(loop)%small_header%description
            description(33:46) = ' west boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nall_3d(loop)%wbdy
   
            !  North boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'NB'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled
            description     = nall_3d(loop)%small_header%description
            description(33:46) = 'north boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nall_3d(loop)%nbdy
   
            !  South boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'SB'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled
            description     = nall_3d(loop)%small_header%description
            description(33:46) = 'south boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nall_3d(loop)%sbdy

            !  Space for the boundary tendency is a different size for each variable due to
            !  the vertical velocity's kxs+1 dimension.

            ALLOCATE ( et3d(imx,nall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for ET3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,imx,nall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF
 
            ALLOCATE ( wt3d(imx,nall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for WT3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,imx,nall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            ALLOCATE ( nt3d(jmx,nall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for NT3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,jmx,nall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            ALLOCATE ( st3d(jmx,nall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for ST3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,jmx,nall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            !  Compute the boundary tendency, which is the difference between the value of the 
            !  variable and the previous value of the variable, at each (i,j,k) along the 
            !  nspgd rows and columns of the lateral boundary.

            CALL bndtend ( nall_3d(loop)%array , &
                           nall_3d(loop)%ebdy  , &
                           nall_3d(loop)%wbdy  , &
                           nall_3d(loop)%nbdy  , &
                           nall_3d(loop)%sbdy  , &
                           imx, jmx, nall_3d(loop)%small_header%end_dims(3), icrsdot , dts, &
                           et3d, wt3d, nt3d, st3d )

            !  East boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'EBT'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled // per_time
            description     = nall_3d(loop)%small_header%description
            description(28:46) = 'tend  east boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) et3d

            !  West boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'WBT'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled // per_time
            description     = nall_3d(loop)%small_header%description
            description(28:46) = 'tend  west boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) wt3d

            !  North boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'NBT'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled // per_time
            description     = nall_3d(loop)%small_header%description
            description(28:46) = 'tend north boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nt3d

            !  South boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, nall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = nall_3d(loop)%small_header%staggering
            IF ( nall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'SBT'
            units           = TRIM ( nall_3d(loop)%small_header%units ) // coupled // per_time
            description     = nall_3d(loop)%small_header%description
            description(28:46) = 'tend south boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) st3d
   
            !  Save values of data along the boundary for the next time period.

            CALL bound ( nall_3d(loop)%array , &
                         nall_3d(loop)%ebdy  , &
                         nall_3d(loop)%wbdy  , &
                         nall_3d(loop)%nbdy  , &
                         nall_3d(loop)%sbdy  , &
                         imx, jmx, nall_3d(loop)%small_header%end_dims(3), icrsdot )

            !  Deallocate the boundary tendencies.

            DEALLOCATE ( et3d )
            DEALLOCATE ( wt3d )
            DEALLOCATE ( nt3d )
            DEALLOCATE ( st3d )

         END DO 

         !  Always end the file with the end of time flag.

         WRITE ( iunit ) eot_flag

      END IF

   END SUBROUTINE bdyoutn

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE bdyoutv (iunit ,imx, jmx, kxs, itimes, interval , &
                       start_year , start_month , start_day , start_hour , &
                       start_minute , start_second , start_frac )

      USE date_pack
      USE header_data
      USE all_io

      IMPLICIT NONE

      INTEGER               :: iunit , start_year , start_month , start_day , start_hour , &
                               start_minute , start_second , start_frac
      !  Data for small header.

      INTEGER                :: num_dims
      INTEGER , DIMENSION(4) :: start_dims
      INTEGER , DIMENSION(4) :: end_dims
      REAL                   :: xtime
      CHARACTER (LEN= 4)     :: staggering
      CHARACTER (LEN= 4)     :: ordering
      CHARACTER (LEN= 9)     :: name
      CHARACTER (LEN=25)     :: units
      CHARACTER (LEN=46)     :: description

      INTEGER                     :: imx
      INTEGER                     :: interval
      INTEGER                     :: itimes
      INTEGER                     :: jmx
      INTEGER                     :: kxs

      INTEGER                     :: icrsdot
      INTEGER                     :: loop
      REAL                        :: dts
      REAL , ALLOCATABLE , DIMENSION(:,:,:) :: et3d , wt3d , nt3d , st3d
      CHARACTER (LEN=16)          :: per_time
      CHARACTER (LEN= 3)          :: coupled 
      CHARACTER (LEN= 8)          :: new_name

      INTEGER                     :: return_code


      IF (ITIMES .EQ. 1) THEN

         !  Create the nspgd rows and columns along the boundary for each of the
         !  3d fields.

         DO loop = 1 , num_3d
            IF ( vall_3d(loop)%small_header%staggering(1:1) .EQ. 'D' ) THEN
               icrsdot = 0 
            ELSE
               icrsdot = 1 
            END IF
            CALL bound ( vall_3d(loop)%array , &
                         vall_3d(loop)%ebdy  , &
                         vall_3d(loop)%wbdy  , &
                         vall_3d(loop)%nbdy  , &
                         vall_3d(loop)%sbdy  , &
                         imx, jmx, vall_3d(loop)%small_header%end_dims(3), icrsdot )
         END DO

         !  The first time in we do the big header jazz.

         WRITE ( iunit ) bh_flag

         !  Just in case no one else cleared the big header, we should do it.  All
         !  of the header values for the lateral boundary condition index can be set to -999.
   
         bhi (:,7) = -999
         bhr (:,7) = -999
         bhic(:,7) = '                                                                                '
         bhrc(:,7) = '                                                                                '
   
         !  Identify the data as the lateral boundary condition for MM5.
   
         bhi( 1,1) = 7 ; bhic( 1,1) = '1-way model lateral boundary condition for MM5                                  '
   
         !  A few lines about data format and version numbers.  If we make a change in the
         !  IC INTERP output version numbers, those will now be reflected here.
   
         bhi( 2,7) = bhi(2,5) ; bhic( 2,7) = bhic(2,5)
         bhi( 3,7) = bhi(3,5) ; bhic( 3,7) = bhic(3,5)
         bhi( 4,7) = bhi(4,5) ; bhic( 4,7) = bhic(4,5)
   
         !  Starting date of the NESTDOWN data, this was specified in the namelist.
   
         bhi ( 5,7) = start_year
         bhic( 5,7) = 'Four-digit year of start time                                                   '
         bhi ( 6,7) = start_month
         bhic( 6,7) = 'Month of the year of the start time (1-12)                                      '
         bhi ( 7,7) = start_day
         bhic( 7,7) = 'Day of the month of the start time (1-31)                                       '
         bhi ( 8,7) = start_hour
         bhic( 8,7) = 'Hour of the day of the start time (0-23)                                        '
         bhi ( 9,7) = start_minute
         bhic( 9,7) = 'Minute of the start time (0-59)                                                 '
         bhi (10,7) = start_second
         bhic(10,7) = 'Second of the start time (0-59)                                                 '
         bhi (11,7) = start_frac
         bhic(11,7) = 'Ten thousandths of a second of the start time (0-9999)                          '
   
         !  How many levels to expect.
   
         bhi (12,7) = kxs
         bhic(12,7) = 'Number of levels in the lateral boundary condition file                         '
   
         !  Time interval between output files.
   
         bhr ( 1,7) = interval                
         bhrc( 1,7) = 'Time difference (seconds) during which the lateral boundary condition is valid  '
   
         !  Output the big header.
   
         WRITE ( iunit ) bhi , bhr , bhic , bhrc

      ELSE IF (ITIMES .GT. 1) THEN

         WRITE ( per_time , '(" ",I5,"{-1} s{-1}")' ) interval
         coupled = ' Pa'

         CALL geth_newdate(old_date , current_date , -1*interval )
         dts = interval

         !  Loop over all of the 3d arrays.

         !  1) For the east boundary:
         !     A) WRITE flag
         !     B) Build small header
         !     C) WRITE small_header
         !     D) WRITE lateral boundary
         !  2 - 4) repeat step 1) for west, north and south.
         !  5) Compute boundary tendencies
         !  6) For the east boundary tendency:
         !     A) WRITE flag
         !     B) Build small header
         !     C) WRITE small_header
         !     D) WRITE lateral boundary tendency
         !  7 - 10) repeat step 6) for west, north and south.
         ! 11) WRITE end-of-time flag

         DO loop = 1 , num_3d

            IF ( vall_3d(loop)%small_header%staggering(1:1) .EQ. 'D' ) THEN
               icrsdot = 0 
            ELSE
               icrsdot = 1 
            END IF
     
            !  The name of the field changes sometimes for the boundary file.

            IF      ( vall_3d(loop)%small_header%name(1:8) .EQ. 'CLW     ' ) THEN
               new_name = 'QC      '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'RNW     ' ) THEN
               new_name = 'QR      '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'ICE     ' ) THEN
               new_name = 'QI      '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'SNOW    ' ) THEN
               new_name = 'QNI     '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'GRAUPEL ' ) THEN
               new_name = 'QG      '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'NCI     ' ) THEN
               new_name = 'QNC     '
            ELSE IF ( vall_3d(loop)%small_header%name(1:8) .EQ. 'RAD TEND' ) THEN
               new_name = 'RT      '
            ELSE
               new_name = vall_3d(loop)%small_header%name(1:8)
            END IF

            !  East boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'EB'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled
            description     = vall_3d(loop)%small_header%description
            description(33:46) = ' east boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) vall_3d(loop)%ebdy
   
            !  West boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'WB'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled
            description     = vall_3d(loop)%small_header%description
            description(33:46) = ' west boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) vall_3d(loop)%wbdy
   
            !  North boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'NB'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled
            description     = vall_3d(loop)%small_header%description
            description(33:46) = 'north boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) vall_3d(loop)%nbdy
   
            !  South boundary.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'SB'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled
            description     = vall_3d(loop)%small_header%description
            description(33:46) = 'south boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) vall_3d(loop)%sbdy

            !  Space for the boundary tendency is a different size for each variable due to
            !  the vertical velocity's kxs+1 dimension.

            ALLOCATE ( et3d(imx,vall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for ET3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,imx,vall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF
 
            ALLOCATE ( wt3d(imx,vall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for WT3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,imx,vall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            ALLOCATE ( nt3d(jmx,vall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for NT3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,jmx,vall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            ALLOCATE ( st3d(jmx,vall_3d(loop)%small_header%end_dims(3),nspgd) , STAT = return_code )
            IF ( return_code .NE. 0 ) THEN
               PRINT '(A,A,A,I1,A)','ALLOCATE return code for ST3D field ',TRIM ( new_name ),' is ',return_code,'.'
               STOP 'allocate_error'
#ifdef DEBUG_ALLOCATE
            ELSE
               PRINT *,jmx,vall_3d(loop)%small_header%end_dims(3),nspgd
#endif
            END IF

            !  Compute the boundary tendency, which is the difference between the value of the 
            !  variable and the previous value of the variable, at each (i,j,k) along the 
            !  nspgd rows and columns of the lateral boundary.

            CALL bndtend ( vall_3d(loop)%array , &
                           vall_3d(loop)%ebdy  , &
                           vall_3d(loop)%wbdy  , &
                           vall_3d(loop)%nbdy  , &
                           vall_3d(loop)%sbdy  , &
                           imx, jmx, vall_3d(loop)%small_header%end_dims(3), icrsdot , dts, &
                           et3d, wt3d, nt3d, st3d )

            !  East boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'EBT'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled // per_time
            description     = vall_3d(loop)%small_header%description
            description(28:46) = 'tend  east boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) et3d

            !  West boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ imx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'YSB '
            ELSE
               ordering        = 'YWB '
            END IF
            name            = TRIM ( new_name ) // 'WBT'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled // per_time
            description     = vall_3d(loop)%small_header%description
            description(28:46) = 'tend  west boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) wt3d

            !  North boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'NBT'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled // per_time
            description     = vall_3d(loop)%small_header%description
            description(28:46) = 'tend north boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) nt3d

            !  South boundary tendency.

            WRITE ( iunit ) sh_flag
            num_dims        = 3
            start_dims      = (/ 1, 1, 1, 1 /)
            end_dims        = (/ jmx, vall_3d(loop)%small_header%end_dims(3), nspgd, 1 /)
            xtime           = 0
            staggering      = vall_3d(loop)%small_header%staggering
            IF ( vall_3d(loop)%small_header%end_dims(3) .EQ. kxs ) THEN
               ordering        = 'XSB '
            ELSE
               ordering        = 'XWB '
            END IF
            name            = TRIM ( new_name ) // 'SBT'
            units           = TRIM ( vall_3d(loop)%small_header%units ) // coupled // per_time
            description     = vall_3d(loop)%small_header%description
            description(28:46) = 'tend south boundary'
            WRITE ( iunit ) num_dims , start_dims , end_dims , xtime , staggering , ordering , &
                            old_date//'.0000' , name , units , description
            WRITE ( iunit ) st3d
   
            !  Save values of data along the boundary for the next time period.

            CALL bound ( vall_3d(loop)%array , &
                         vall_3d(loop)%ebdy  , &
                         vall_3d(loop)%wbdy  , &
                         vall_3d(loop)%nbdy  , &
                         vall_3d(loop)%sbdy  , &
                         imx, jmx, vall_3d(loop)%small_header%end_dims(3), icrsdot )

            !  Deallocate the boundary tendencies.

            DEALLOCATE ( et3d )
            DEALLOCATE ( wt3d )
            DEALLOCATE ( nt3d )
            DEALLOCATE ( st3d )

         END DO 

         !  Always end the file with the end of time flag.

         WRITE ( iunit ) eot_flag

      END IF

   END SUBROUTINE bdyoutv

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE bndtend (f, east, west, north, south, imx, jmx, kxs, icrsdot, dts, teast, twest, tnorth, tsouth)

      IMPLICIT NONE

      INTEGER                     :: I
      INTEGER                     :: ICRSDOT
      INTEGER                     :: IMX
      INTEGER                     :: J
      INTEGER                     :: JMX
      INTEGER                     :: K
      INTEGER                     :: KXS
      INTEGER                     :: N

      REAL                        :: DTS
      REAL                        :: EAST      ( IMX, KXS, NSPGD )
      REAL                        :: F         ( IMX, JMX, KXS   )
      REAL                        :: NORTH     ( JMX, KXS, NSPGD )
      REAL                        :: ONEOVDT
      REAL                        :: SOUTH     ( JMX, KXS, NSPGD )
      REAL                        :: TEAST     ( IMX, KXS, NSPGD )
      REAL                        :: TNORTH    ( JMX, KXS, NSPGD )
      REAL                        :: TSOUTH    ( JMX, KXS, NSPGD )
      REAL                        :: TWEST     ( IMX, KXS, NSPGD )
      REAL                        :: WEST      ( IMX, KXS, NSPGD )

      teast = 0.0
      twest = 0.0
      tnorth = 0.0
      tsouth = 0.0
      oneovdt = 1.0 / dts

!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( n , k , i , j )
      DO n = 1, nspgd
         DO k = 1, kxs
            DO i = 1, imx - icrsdot
               twest(i,k,n) = (f(i,n,k) - west(i,k,n)) * oneovdt
               teast(i,k,n) = (f(i,jmx-icrsdot-n+1,k) - east(i,k,n)) * oneovdt
            END DO
         END DO

         DO k = 1, kxs
            DO j = 1, jmx - icrsdot
               tsouth(j,k,n) = (f(n,j,k) - south(j,k,n)) * oneovdt
               tnorth(j,k,n) = (f(imx-icrsdot-n+1,j,k) - north(j,k,n)) * oneovdt
            END DO
         END DO
      END DO

   END SUBROUTINE bndtend

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE bound (f, east, west, north, south, imx, jmx, kxs, icrsdot)

      IMPLICIT NONE

      INTEGER                     :: I
      INTEGER                     :: ICRSDOT
      INTEGER                     :: IMX
      INTEGER                     :: J
      INTEGER                     :: JMX
      INTEGER                     :: K
      INTEGER                     :: KXS
      INTEGER                     :: N

      REAL                        :: EAST      ( IMX, KXS, NSPGD )
      REAL                        :: F         ( IMX, JMX, KXS   )
      REAL                        :: NORTH     ( JMX, KXS, NSPGD )
      REAL                        :: SOUTH     ( JMX, KXS, NSPGD )
      REAL                        :: WEST      ( IMX, KXS, NSPGD )

      east = 0.0
      west = 0.0
      north = 0.0
      south = 0.0

!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( n , k , i , j )
      DO n = 1, nspgd
         DO k = 1, kxs
            DO i = 1, imx - icrsdot
               west(i,k,n) = f(i,n,k)
               east(i,k,n) = f(i,jmx-icrsdot-n+1,k)
            END DO
         END DO

         DO k = 1, kxs
            DO j = 1, jmx - icrsdot
               south(j,k,n) = f(n,j,k)
               north(j,k,n) = f(imx-icrsdot-n+1,j,k)
            END DO
         END DO
      END DO

   END SUBROUTINE bound

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE wbound (w2din, w3din, imx, kxs, w3dout)

      IMPLICIT NONE

      INTEGER                     :: I
      INTEGER                     :: IMX
      INTEGER                     :: K
      INTEGER                     :: KXS
      INTEGER                     :: N

      REAL                        :: W2DIN         ( IMX,   1  , NSPGX )
      REAL                        :: W3DIN         ( IMX,   KXS, NSPGX )
      REAL                        :: W3DOUT        ( IMX, KXS+1, NSPGX )

      W3DOUT = 0.0

      DO n = 1, nspgx
         DO i = 1, imx
            w3dout(i,1,n) = w2din(i,1,n)
            DO k = 2, kxs + 1
               w3dout(i,k,n) = w3din(i,k-1,n)
            END DO
         END DO
      END DO

   END SUBROUTINE wbound

END MODULE lateral_bdy
