MODULE vert_interp

CONTAINS

   SUBROUTINE vinterp ( field_new , sigma_new , kxs_new , &
                        field_old , sigma_old , kxs_old , &
                        nimax , njmax , icrsdot , nps0 , &
                        ptop , ts0 , p0 , tlp , tiso )

      IMPLICIT NONE

      REAL , PARAMETER :: R = 287.04
      REAL , PARAMETER :: g = 9.81

      INTEGER , INTENT(IN) :: icrsdot , nimax , njmax , kxs_old , kxs_new
      REAL , INTENT(IN) :: ptop , ts0 , p0 , tlp , tiso
      REAL , DIMENSION(kxs_new) , INTENT(IN ) :: sigma_new
      REAL , DIMENSION(kxs_old) , INTENT(IN ) :: sigma_old
      REAL , DIMENSION(nimax,njmax) , INTENT(IN) :: nps0
      REAL , DIMENSION(nimax,njmax,kxs_old) , INTENT(IN ) :: field_old

      REAL , DIMENSION(nimax,njmax,kxs_new) , INTENT(OUT) :: field_new

      !  Local variables.

      REAL , DIMENSION(nimax,njmax,kxs_old) :: z_old
      REAL , DIMENSION(nimax,njmax,kxs_new) :: z_new

      REAL :: p
      INTEGER :: i , j , ko , kn

      !  Compute the height of the old sigma levels.

      DO ko = 1 , kxs_old
         DO j = 1 , njmax-icrsdot
            DO i = 1 , nimax-icrsdot
               p = nps0(i,j) * sigma_old(ko) + ptop
               z_old(i,j,ko) = - ( R * tlp / (2.*g) * (LOG (p/p0))**2 + &
                                   R * ts0 /     g  *  LOG (p/p0)    ) 
            END DO
         END DO
      END DO

      !  Compute the height of the new sigma levels.

      DO kn = 1 , kxs_new
         DO j = 1 , njmax-icrsdot
            DO i = 1 , nimax-icrsdot
               p = nps0(i,j) * sigma_new(kn) + ptop
               z_new(i,j,kn) = - ( R * tlp / (2.*g) * (LOG (p/p0))**2 + &
                                   R * ts0 /     g  *  LOG (p/p0)    ) 
            END DO
         END DO
      END DO

      !  Interpolate the variable linear in height.  Loop over each i,j column

      DO j = 1 , njmax-icrsdot
         DO i = 1 , nimax-icrsdot

            !  For this i,j column, go through each of the new sigma levels.

            new : DO kn = 1 , kxs_new

               !  For each i,j,k in the new space, we have to find trapping levels from the
               !  old levels.  Since this is linear, we go from the bottom to one level below the
               !  top.  If the height is outside (not allowing a proper interpolation), we 
               !  extrapolate, and assume that we are not extrapolating very far (wink, wink, 
               !  nudge, nudge, say no more).

               !  Extrapolate up.

               IF ( z_new(i,j,kn) .GT. z_old(i,j,1) ) THEN
                  field_new(i,j,kn) = ( ( z_old(i,j, 1) - z_new(i,j,kn) ) * field_old(i,j,2) + &
                                        ( z_new(i,j,kn) - z_old(i,j, 2) ) * field_old(i,j,1) )  / &
                                        ( z_old(i,j, 1) - z_old(i,j, 2) )
                  CYCLE new
               END IF

               !  Extrapolate down.

               IF ( z_new(i,j,kn) .LT. z_old(i,j,kxs_old) ) THEN
                  field_new(i,j,kn) = ( ( z_old(i,j,kxs_old) - z_new(i,j,       kn) ) * field_old(i,j,kxs_old-1) + &
                                        ( z_new(i,j,     kn) - z_old(i,j,kxs_old-1) ) * field_old(i,j,kxs_old  ) )  / &
                                        ( z_old(i,j,kxs_old) - z_old(i,j,kxs_old-1) )
                  CYCLE new
               END IF

               !  Now the regular interpolations.  We checked on the only extrapolations possible, either
               !  above or below.  For this i,j,kn location, if we are here, we have to successfully pass
               !  through this ko loop and deposit a value into the kn index.

               old : DO ko = 1 , kxs_old - 1

                  IF ( (  z_new(i,j,kn) .LE. z_old(i,j,ko  ) ) .AND. & 
                       (  z_new(i,j,kn) .GE. z_old(i,j,ko+1) ) ) THEN
                     field_new(i,j,kn) = ( ( z_old(i,j,ko) - z_new(i,j,  kn) ) * field_old(i,j,ko+1) + &
                                           ( z_new(i,j,kn) - z_old(i,j,ko+1) ) * field_old(i,j,ko  ) )  / &
                                           ( z_old(i,j,ko) - z_old(i,j,ko+1) )
                     EXIT old
                  END IF

               END DO old

            END DO new

         END DO
      END DO

   END SUBROUTINE vinterp

END MODULE vert_interp
