/*  FILE: cio.c  */
/*  C functions to write bytes to UNIX files - called from FORTRAN */
/*  copen
    bnread
    bnwrit
    cclose
    rewtap
    eoftap
    fsftap
    bsrtap
    bsrfil */
/*  870417  */

#if defined(CRAY)

#define copen COPEN
#define cclose CCLOSE
#define bnread BNREAD
#define bnwrit BNWRIT
#define bsrtap BSRTAP

#endif

#if defined (SGI) || defined (SUN) || defined (DEC)

#define copen copen_
#define cclose cclose_
#define bnread bnread_
#define bnwrit bnwrit_
#define bsrtap bsrtap_

#endif

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/uio.h>

/* ****************************************************************** */

void copen(unit, nunit, name, mode, err, oflag)
#if defined (SGI) && defined (BIT64)
    int64_t          *unit;
    int64_t          *nunit;
    int64_t          *mode;
    int64_t          *err;
    int64_t          *oflag;
#else
    int          *unit;
    int          *nunit;
    int          *mode;
    int          *err;
    int          *oflag;
#endif
    char         name[120];

 /*
  * unit = Fortran unit number nunit = UNIX file descriptor associated with
  * 'unit' name  = UNIX file name mode = 0 : write only - file will be
  * created if it doesn't exist - otherwise will be rewritten = 1 : read only
  * = 2 : read/write oflag = 0 : no notification if file opened OK = 1 : file
  * name and unit number printed
  */
{
    int             fd, i;
    char            fname[120];
    extern int      errno;	/* I/O error return */


    if (*oflag != 0) {
	printf("Copen: File = %s Fortran Unit = %d   ", name, *unit);
    }

    /* strip trailing blanks and add null character to name */
    for (i = 0; name[i] != ' ' && name[i] != '\0' && i < 120; ++i)
	fname[i] = name[i];
    fname[i] = '\0';

/* if (*mode == 0)    WRITE ONLY
   printf ("UNIX File descriptor: %d\n", fd = open (fname, O_WRONLY));
     printf ("UNIX File descriptor: %d\n", fd = creat (fname, 0777));
   else if (*mode == 1)   READ ONLY
     printf ("UNIX File descriptor: %d\n", fd = open (fname, O_RDONLY));
   else   READ/WRITE
     printf ("UNIX File descriptor: %d\n", fd = open (fname, O_RDWR));*/

    if (*mode == 0)		/* WRITE ONLY */
	fd = creat(fname, 0777);
    else if (*mode == 1)	/* READ ONLY */
	fd = open(fname, O_RDONLY);
    else			/* READ/WRITE */
	fd = open(fname, O_RDWR);
    if (*oflag != 0)
	printf("UNIX File descriptor: %d\n", fd);

    *err = 0;
    if (fd == -1) {		/* error opening file */
	printf("Error opening %s  Error status: %d\n", fname, errno);
	perror("copen.c");
	*err = errno;
    };

    *nunit = fd;
}

/* ****************************************************************** */
void bnseek_(fd, bread, mode)
    int            *fd, *bread, *mode;

{
    off_t           i, offset;
    int             how_to_space;

    if (*mode == 0)
	how_to_space = SEEK_CUR;
    else if (*mode < 0)
	how_to_space = SEEK_SET;
    else
	how_to_space = SEEK_END;

    offset = *bread;
    i = lseek(*fd, offset, how_to_space);
    printf(" lseek return=%lli, *mode=%d\n", i, *mode);
}

/* ****************************************************************** */

void bnread(fd, buf, nbuf, bread, ios, idiag)
#if defined (SGI) && defined (BIT64)
    int64_t        *fd, *nbuf, buf[], *bread, *ios, *idiag;
#else
    int            *fd, *nbuf, buf[], *bread, *ios, *idiag;
#endif

 /*
  * fd = UNIX file descriptor number (NOT a Fortran unit) buf = area into
  * which to read nbuf = number of bytes to read from fd bread = number
  * actually read ios = error number returned to Fortran idiag : if non-zero,
  * error and EOF messages will be printed
  */

{
    int             bytesread;

    /* printf ("BNREAD Fd = %d Nbuf = %d\n", *fd, *nbuf); */
    bytesread = read(*fd, buf, *nbuf);
    /* printf ("Bytes %d   stat %d\n", bytesread, errno);  */

    if (bytesread == -1) {	/* error reading file */
	if (*idiag != 0)
	    printf("Error reading C unit %d\n", *fd);
	perror("bnread.c");
	*ios = 2;
	/*  *ios = errno; */
    } else if (bytesread == 0) {/* end-of-file on input */
	if (*idiag != 0)
	    printf("End of file on C unit %d\n", *fd);
            *ios = 1; 
	/*  *ios = errno; */
    } else {			/* read OK */

	/*
	 * printf ("BNREAD - bytes read = %d   Buf = %d %d %d\n", bytesread,
	 * buf[0], buf[1], buf[2]);
	 */
	*ios = 0;
    };

    *bread = bytesread;
}

/* ****************************************************************** */

void bnwrit(fd, buf, nbuf, bwritten, err, idiag)
    int            *fd, *nbuf, buf[], *bwritten, *err, *idiag;

 /*
  * fd = UNIX file descriptor number (NOT a Fortran unit) buf = area from
  * which to write nbuf = number of bytes to write to fd bwritten = number
  * actually written err = UNIX error number returned to FORTRAN idiag : if
  * non-zero, error and EOF messages will be printed
  */

{
    int             byteswritten;

    /*
     * printf ("BNWRIT Fd = %d Nbuf = %d   Buf = %d %d %d\n", fd, *nbuf,
     * buf[0], buf[1], buf[2]);
     */
    byteswritten = write(*fd, buf, *nbuf);
    /* printf ("Bytes %d   stat %d\n", byteswritten, errno);  */

    *err = 0;
    if (byteswritten == -1) {	/* error writing file */
	if (*idiag != 0)
	    printf("Error writing C unit %d\n", *fd);
	perror("bnwrit.c");
	*err = errno;
    };

    *bwritten = byteswritten;
}

/* ****************************************************************** */

void cclose(nunit, stat, err)
    int            *nunit, *stat, *err;
{
    extern int      errno;	/* I/O error return */
    int             istat;

    /*
     * printf ("Cclose: Nunit = %d Error status: %d Error #: %d\n", nunit,
     * istat = close (*nunit), errno);
     */
    istat = close(*nunit);

/*     if (istat == 0) */
/* 	printf("Cclose successful: Nunit = %d \n", *nunit); */

    *stat = istat;
    *err = 0;
    if (istat == -1) {		/* error closing file */
	printf("Error closing %d\n", *nunit);
	perror("cclose.c");
	*err = errno;
    };

}

/* ****************************************************************** */
