      SUBROUTINE GETERR(A2,ASTA,XOBS,YOBS,IMAX,JMAX,NSTA,IFAC,IVRBL,IFD,         GETERR.1
     1 PL,ERRMXW,ERRMXT,ERRMXP,ER,IER,NFI,ISTNUM,ASTAWD,KTYPE,                   GETERR.2
     2 LVL,MDATE,AUTBGW,AUTBGR,NVOL40,RANG,KN)                                   GETERR.3
C                                                                                GETERR.4
C        THIS SUBROUTINE FINDS THE DIFFERENCE (ERROR) BETWEEN THE                GETERR.5
C        CURRENT GUESS FIELD IN A2 AND THE STATION OBSERVATIONS IN               GETERR.6
C        ASTA AT THE STATION LOCATIONS.  THE DATA ARE ALSO CHECKED               GETERR.7
C        FOR MISTAKES, USING CRITERIA ERRMXW,ERRMXT AND ERRMXP.                  GETERR.8
C                                                                                GETERR.9
C                                                                                GETERR.10
C-----------------------------------------------------------------------         GETERR.11
C                                                                                GETERR.12
C     IF AUTBOG = .T., A RECORD WILL BE WRITTEN TO AN OUTPUT VOLUME,             GETERR.13
C     NUNIT=40, AS AN AUTOBOGUS POINT FOR EACH DATA POINT FOR WHICH              GETERR.14
C     THE DIFFERENCE BETWEEN THE OBSERVATION AND GRIDDED FIELD EXCEEDS           GETERR.15
C     THE SPECIFIED ERROR LIMIT.                                                 GETERR.16
C                                                                                GETERR.17
C           KN = ENTRY NO. (SEQ. NO. ON OUTPUT FILE)                             GETERR.18
C        KTYPE = DATA TYP:  1 = MAND. LEVEL DATA                                 GETERR.19
C                          -1 = NON-STD LEVEL DATA                               GETERR.20
C                           2 = SFC. DATA                                        GETERR.21
C         KSTA = STATION NO. (MUST BE UNIQUE; SEE END OF GETRAW)                 GETERR.22
C           PK = SEA-LEVEL PRES. OBS. DISCARDED (MB; 88888. IS DEFAULT)          GETERR.23
C           ZK = HT. OBS. DISCARDED (M; 88888. IS DEFAULT)                       GETERR.24
C           TK = T OBS. DISCARDED (C; 88888. IS DEFAULT)                         GETERR.25
C           HK = REL. HUM. DISCARDED (PERCENT; 88888. IS DEFAULT)                GETERR.26
C           DK = WIND DIR. OF DISCARDED U OR V (DEG; 88888. IS DEFAULT)          GETERR.27
C           FK = WIND SPD. OF DISCARDED U OR V (M/S; 88888. IS DEFAULT)          GETERR.28
C        IVRBL = IDENTIFIER FOR ERRONEOUS VARIABLE TYPE                          GETERR.29
C                           1 = U-COMP. DISCARDED (V MAY BE OK)                  GETERR.30
C                           2 = V-COMP. DISCARDED (U MAY BE OK)                  GETERR.31
C                           3 = TEMP.                                            GETERR.32
C                           4 = REL. HUM.                                        GETERR.33
C                           6 = SEA-LEVEL PRES.                                  GETERR.34
C          RIY = EXACT I-INDEX OF DISCARDED POINT                                GETERR.35
C          RJX = EXACT J-INDEX OF DISCARDED POINT                                GETERR.36
C          LVL = VERTICAL LEVEL INDEX AS GENERATED BY RAWINS (1=SURFACE,         GETERR.37
C                NON-STD. LEVELS HAVE HIGHER INDEX NOS. THAN MAND. LEVEL         GETERR.38
C        MDATE = DATE AND TIME OF DISCARDED OBS.                                 GETERR.39
C       RECYCL = RECYCLING LOGICAL FLAG TO INDICATE RE-USE OF DISCARDED          GETERR.40
C                OBS. AS AUTOBOGUS INPUT.  ALWAYS SET FALSE BY GETERR.           GETERR.41
C                USER MUST ALTER RECYCL = TRUE IN OUTPUT VOLUME.                 GETERR.42
C                                                                                GETERR.43
C-----------------------------------------------------------------------         GETERR.44
#include <paramirb.incl>                                                         GETERR.45
#include <paramirs.incl>                                                         GETERR.46
C-----------------------------------------------------------------------         GETERR.47
C                                                                                GETERR.48
      DIMENSION A2(IMAX,JMAX),XOBS(IRS),YOBS(IRS),ASTA(IRS),                     GETERR.49
     1 IFD(IRS),ER(IRS,2),ASTAWD(IRS),RANG(3,IRS)                                GETERR.50
     2,KBUD(IRS)                                                                 GETERR.51
      CHARACTER*8 ISTNUM(3,IRS), ISTR(IRS), KSTA                                 GETERR.52
#include <sbm.incl>                                                              GETERR.53
#include <comobs.incl>                                                           GETERR.54
#include <comksca.incl>                                                          GETERR.55
#include <comksfc.incl>                                                          GETERR.56
#include <comd.incl>                                                             GETERR.57
#include <comwt.incl>                                                            GETERR.58
C-----------------------------------------------------------------------         GETERR.59
      character*24 MDATE, MDATEH                                                 GETERR.60
      LOGICAL RECYCL,AUTBGW,AUTBGR                                               GETERR.61
      LOGICAL PRNTERR                                                            GETERR.62
      DATA RECYCL/.FALSE./ CONV/57.29578/                                        GETERR.63
      CHARACTER*3 FF,F1,F2,F3,F4                                                 GETERR.64
      CHARACTER*8 STR                                                            GETERR.65
      DATA F1,F2,F3,F4/'   ','  *',' **','***'/                                  GETERR.66
      SAVE MDATEH, NTOT                                                          06NOV00.7
C                                                                                GETERR.67
C  PRNTERR = TRUE PROVIDES DETAILED PRINTOUT FOR ERRMAX REMOVAL                  GETERR.68
C                                                                                GETERR.69
      PRNTERR=.FALSE.                                                            GETERR.70
C                                                                                GETERR.71
C                                                                                GETERR.72
      CALL DECOMDAT(MDATE,IYEAR,IMONTH,IDAY,IHOUR,IMINUTE,ISECOND,               GETERR.73
     &     IFRACTION)                                                            GETERR.74
      DO 221 K=1,NSTA                                                            GETERR.75
      IF(K .LE. NUSTAN ) THEN                                                    GETERR.76
         WRITE(ISTR(K),222) ISTNUM(3,K)                                          GETERR.77
222   FORMAT(A6,1X,'U')                                                          GETERR.78
      ELSE                                                                       GETERR.79
         WRITE(ISTR(K),223) ISTNUM(3,K)                                          GETERR.80
223   FORMAT(A6,1X,'S')                                                          GETERR.81
      ENDIF                                                                      GETERR.82
221   CONTINUE                                                                   GETERR.83
C                                                                                GETERR.84
      IF(MDATE.NE.MDATEH) NTOT=0                                                 GETERR.85
      IF(KSCAN.EQ.1.AND.BUDWGT.GT.0.01) THEN                                     GETERR.86
      CALL BUDDY(NSTA,ASTA,A2,ISTR,XOBS,YOBS,IMAX,JMAX,IVRBL,PL,                 GETERR.87
     1    BUDWGT,MDATE,KBUD,IUVEL,IVVEL,ITEMP,IRELH,IREFPC)                      GETERR.88
      END IF                                                                     GETERR.89
      DO 12 K = 1,NSTA                                                           GETERR.90
      IF(KBUD(K).GT.0.AND.BUDWGT.GT.0.01) THEN                                   GETERR.91
      ERR=1.E32                                                                  GETERR.92
      ASTA(K)=ERR                                                                GETERR.93
      GO TO 11                                                                   GETERR.94
      END IF                                                                     GETERR.95
      STR(1:8)='        '                                                        GETERR.96
      KSTA=ISTNUM(3,K)                                                           GETERR.97
      WRITE(STR,'(A8)')KSTA                                                      GETERR.98
      KELEV=KSFCEL(K)                                                            GETERR.99
C                                                                                GETERR.100
C     INCREASE ERRMX FOR WIND ABOVE 500 MB                                       GETERR.101
C                                                                                GETERR.102
      CONWND=1.0                                                                 GETERR.103
      IF(PL.LE.1000.1) CONWND=1.25                                               GETERR.104
      IF(PL.LT.499.9) CONWND=1.5                                                 GETERR.105
C                                                                                GETERR.106
C     INCREASE TEMP ERRMX FOR 00Z AT SURFACE                                     GETERR.107
C     DECREASE TEMP ERRMX IF OVER WATER                                          GETERR.108
C     DECREASE TEMP ERRMX AT UPPER LEVEL                                         GETERR.109
C                                                                                GETERR.110
      CONTMP=1.0                                                                 GETERR.111
      IF(PL.GT.1000.1) GO TO 311                                                 GETERR.112
      CONTMP=0.65                                                                GETERR.113
      IF(PL.GT.700.1)CONTMP=0.85                                                 GETERR.114
      IF(IFIRST.EQ.'ECMWF ') THEN                                                GETERR.115
      INTPL=PL                                                                   GETERR.116
      IF(INTPL.EQ.150.OR.INTPL.EQ.250) CONTMP=1.0                                GETERR.117
      END IF                                                                     GETERR.118
      GO TO 313                                                                  GETERR.119
311   IF(IHOUR.EQ.0)THEN                                                         GETERR.120
      CONTMP=1.25                                                                GETERR.121
      IF(KELEV.GT.500.)CONTMP=1.75                                               GETERR.122
      END IF                                                                     GETERR.123
      IF(IHOUR.EQ.12) CONTMP=1.5                                                 GETERR.124
312   IF(STR(4:5).EQ.'  ') GO TO 313                                             GETERR.125
      IF((STR(1:1).GE.'0') .AND. (STR(1:1).LE.'9')) GO TO 313                    GETERR.126
      CONTMP=0.75                                                                GETERR.127
313   CONTINUE                                                                   GETERR.128
      PK=88888.                                                                  GETERR.129
      ZK=88888.                                                                  GETERR.130
      TK=88888.                                                                  GETERR.131
      HK=88888.                                                                  GETERR.132
      DK=88888.                                                                  GETERR.133
      FK=88888.                                                                  GETERR.134
      IUORV=0                                                                    GETERR.135
C                                                                                GETERR.136
      IF(IFAC.EQ. 2) GO TO 10                                                    GETERR.137
      IF(IFAC .NE. 1) STOP5                                                      GETERR.138
C        FIND VALUES OF THE FIRST GUESS FIELD AT THE STATION                     GETERR.139
C        LOCATION, AOB.                                                          GETERR.140
      IOB = YOBS(K)                                                              GETERR.141
      JOB = XOBS(K)                                                              GETERR.142
      RIOB = IOB                                                                 GETERR.143
      RJOB = JOB                                                                 GETERR.144
      DXOB = XOBS(K) - RJOB                                                      GETERR.145
      DYOB = YOBS(K) - RIOB                                                      GETERR.146
      AOB = (1.-DXOB)*((1.-DYOB)*A2(IOB,JOB) + DYOB*A2(IOB+1,JOB)) +             GETERR.147
     1 DXOB*((1.-DYOB)*A2(IOB,JOB+1) + DYOB*A2(IOB+1,JOB+1))                     GETERR.148
      ERR = ASTA(K) - AOB                                                        GETERR.149
      IF(IVRBL.EQ.IRELH.AND.ASTA(K).LT.10000.) THEN                              GETERR.150
      ERRRH=100.*(AOB*AOB-ASTA(K)*ASTA(K))                                       GETERR.151
      END IF                                                                     GETERR.152
C      CHECK FOR BAD DATA POINTS                                                 GETERR.153
C        NOTE - BOGUS DATA (IFD .GT. 1) IS ASSUMED TO BE 'CORRECT'               GETERR.154
C               ... NO ERROR CHECKING IS DONE IN THIS CASE.                      GETERR.155
      IF(IFD(K) .NE. 1)GO TO 11                                                  GETERR.156
      IF(IVRBL .EQ. ITEMP .OR. IVRBL .EQ. IRELH) GO TO 110                       GETERR.157
      IF(IVRBL.EQ.IREFPC) GO TO 120                                              GETERR.158
      AOBFR = 0.15*ABS(AOB)                                                      GETERR.159
C                                                                                GETERR.160
C        SET MAXIMUM ERROR ALLOWED FOR WIND DATA (M/S)                           GETERR.161
C                                                                                GETERR.162
      IF (AUTBGR) THEN                                                           GETERR.163
         ERRMX=999.                                                              GETERR.164
      ELSE                                                                       GETERR.165
         ERRMX=ERRMXW                                                            GETERR.166
      END IF                                                                     GETERR.167
      ERRMX=CONWND*ERRMX                                                         GETERR.168
      IF(AOBFR .GT. ERRMX) ERRMX = AOBFR                                         GETERR.169
      IF(IVRBL.EQ.IUVEL.OR.IVRBL.EQ.IVVEL)THEN                                   GETERR.170
      IF(ASTAWD(K).GT.1.E29)THEN                                                 GETERR.171
      ERR=1.E32                                                                  GETERR.172
      ASTA(K)=1.E32                                                              GETERR.173
      GO TO 11                                                                   GETERR.174
      ENDIF                                                                      GETERR.175
      ENDIF                                                                      GETERR.176
      IF(ABS(ERR) .LE. ERRMX) GO TO 11                                           GETERR.177
      IF(ABS(ERR) .GT. 1.0E29) GO TO 11                                          GETERR.178
      IF(PRNTERR.AND.IVRBL.EQ.IUVEL)                                             GETERR.179
     1PRINT 107,ISTNUM(3,K),ERRMX,XOBS(K),YOBS(K),AOB,ASTA(K),ERR                GETERR.180
      IF(IVRBL.EQ.IUVEL) THEN                                                    GETERR.181
      NTOT=NTOT+1                                                                GETERR.182
      IF(NTOT.GT.SBM) THEN                                                       GETERR.183
      PRINT 127                                                                  GETERR.184
      STOP                                                                       GETERR.185
      END IF                                                                     GETERR.186
      MSTAE(NTOT)=ISTR(K)                                                        GETERR.187
      XERM(NTOT)=XOBS(K)                                                         GETERR.188
      YERM(NTOT)=YOBS(K)                                                         GETERR.189
      ERRMXE(NTOT)=ERRMX                                                         GETERR.190
      ELEVM(NTOT)=PL                                                             GETERR.191
      MVARE(NTOT)=IVRBL                                                          GETERR.192
      EDIFM(NTOT)=ERR                                                            GETERR.193
      END IF                                                                     GETERR.194
      IF(PRNTERR.AND.IVRBL.EQ.IVVEL)                                             GETERR.195
     1PRINT 108,ISTNUM(3,K),ERRMX,XOBS(K),YOBS(K),AOB,ASTA(K),ERR                GETERR.196
      IF(IVRBL.EQ.IVVEL) THEN                                                    GETERR.197
      NTOT=NTOT+1                                                                GETERR.198
      IF(NTOT.GT.SBM) THEN                                                       GETERR.199
      PRINT 127                                                                  GETERR.200
      STOP                                                                       GETERR.201
      END IF                                                                     GETERR.202
      MSTAE(NTOT)=ISTR(K)                                                        GETERR.203
      XERM(NTOT)=XOBS(K)                                                         GETERR.204
      YERM(NTOT)=YOBS(K)                                                         GETERR.205
      ERRMXE(NTOT)=ERRMX                                                         GETERR.206
      ELEVM(NTOT)=PL                                                             GETERR.207
      MVARE(NTOT)=IVRBL                                                          GETERR.208
      EDIFM(NTOT)=ERR                                                            GETERR.209
      END IF                                                                     GETERR.210
  107 FORMAT(2X,'STAT ID =',1X,A6,7X,'U COMP DIF>',F6.2,'----X,Y COOR ='         GETERR.211
     1,2F5.1,5X,'GUESS,OBS AND DIFF ARE',3F10.1)                                 GETERR.212
  108 FORMAT(2X,'STAT ID =',1X,A6,7X,'V COMP DIF>',F6.2,'----X,Y COOR ='         GETERR.213
     1,2F5.1,5X,'GUESS,OBS AND DIFF ARE',3F10.1)                                 GETERR.214
C                                                                                GETERR.215
C--------CREATE AUTOBOGUS RECORD, IF AUTBGW = .T.                                GETERR.216
      IF(AUTBGW)THEN                                                             GETERR.217
      KN=KN+1                                                                    GETERR.218
      FK=SQRT(ASTA(K)*ASTA(K)+ASTAWD(K)*ASTAWD(K))                               GETERR.219
C        FOR IVRBL=1, ASTAWD=V;  FOR IVRBL=2, ASTAWD=U                           GETERR.220
      UK=ASTA(K)                                                                 GETERR.221
      VK=ASTAWD(K)                                                               GETERR.222
      IF(IVRBL.EQ.2)THEN                                                         GETERR.223
      UK=ASTAWD(K)                                                               GETERR.224
      VK=ASTA(K)                                                                 GETERR.225
      ENDIF                                                                      GETERR.226
      IF (ABS(VK).LE.1.E-6) VK=1.E-6                                             GETERR.227
      DK=ATAN2(UK,VK)                                                            GETERR.228
      DK=(DK-RANG(3,K))*CONV+180.                                                GETERR.229
      IF(FK.EQ.0.)DK=0.                                                          GETERR.230
      IF (DK.LE.0.) DK=DK+360.                                                   GETERR.231
      IF (DK.GT.360.) DK=DK-360.                                                 GETERR.232
      FF=F1                                                                      GETERR.233
      IF(ABS(ERR).GT.1.33*ERRMX) FF=F2                                           GETERR.234
      IF(ABS(ERR).GT.1.67*ERRMX) FF=F3                                           GETERR.235
      IF(ABS(ERR).GT.2.00*ERRMX) FF=F4                                           GETERR.236
      LOCX=XOBS(K)+0.49                                                          GETERR.237
      LOCY=YOBS(K)+0.49                                                          GETERR.238
      WRITE(NVOL40,109)MDATE(1:16),KN,KTYPE,KSTA,LVL,IVRBL,PK,TK,DK,FK,          GETERR.239
     1RECYCL,FF,LOCX,LOCY,YOBS(K),XOBS(K),ZK,HK                                  GETERR.240
109   FORMAT(A16,I4,I2,1X,A8,I3,I2,4F8.1,1X,L1,A3,2I3,2F7.2,2F8.1)               GETERR.241
 7193 FORMAT(1H0,2X,'NVOL40 READ OK')                                            GETERR.242
      ENDIF                                                                      GETERR.243
      ELON2(K)=1.0                                                               GETERR.244
      MSCHEM(K)=1                                                                GETERR.245
      ERR = 1.0E32                                                               GETERR.246
      ASTA(K) = ERR                                                              GETERR.247
      GO TO 11                                                                   GETERR.248
110   IF(IVRBL.EQ.ITEMP)THEN                                                     GETERR.249
C                                                                                GETERR.250
C        SET MAXIMUM ERROR FOR TEMPERATURE DATA (K)                              GETERR.251
C                                                                                GETERR.252
      IF (AUTBGR) THEN                                                           GETERR.253
         ERRMX=999.                                                              GETERR.254
      ELSE                                                                       GETERR.255
         ERRMX=ERRMXT                                                            GETERR.256
      END IF                                                                     GETERR.257
      ERRMX=CONTMP*ERRMX                                                         GETERR.258
      IF(ABS(ERR).LE.ERRMX)GO TO 11                                              GETERR.259
      IF(ABS(ERR).GT.1.0E29)GO TO 11                                             GETERR.260
      NTOT=NTOT+1                                                                GETERR.261
      IF(NTOT.GT.SBM) THEN                                                       GETERR.262
      PRINT 127                                                                  GETERR.263
      STOP                                                                       GETERR.264
      END IF                                                                     GETERR.265
      MSTAE(NTOT)=ISTR(K)                                                        GETERR.266
      XERM(NTOT)=XOBS(K)                                                         GETERR.267
      YERM(NTOT)=YOBS(K)                                                         GETERR.268
      ERRMXE(NTOT)=ERRMX                                                         GETERR.269
      ELEVM(NTOT)=PL                                                             GETERR.270
      MVARE(NTOT)=IVRBL                                                          GETERR.271
      EDIFM(NTOT)=ERR                                                            GETERR.272
      IF(PRNTERR) THEN                                                           GETERR.273
      PRINT 106,ISTNUM(3,K),ERRMX,XOBS(K),YOBS(K),AOB,ASTA(K),ERR                GETERR.274
  106 FORMAT(2X,'STAT ID =',1X,A6,7X,'TEMP DIFF>',F6.2,'-----X,Y COOR ='         GETERR.275
     1,2F5.1,5X,'GUESS,OBS AND DIFF ARE',3F10.1)                                 GETERR.276
      END IF                                                                     GETERR.277
C                                                                                GETERR.278
      IF(AUTBGW)THEN                                                             GETERR.279
      KN=KN+1                                                                    GETERR.280
      FF=F1                                                                      GETERR.281
      IF(ABS(ERR).GT.1.33*ERRMX) FF=F2                                           GETERR.282
      IF(ABS(ERR).GT.1.67*ERRMX) FF=F3                                           GETERR.283
      IF(ABS(ERR).GT.2.00*ERRMX) FF=F4                                           GETERR.284
      LOCX=XOBS(K)+0.49                                                          GETERR.285
      LOCY=YOBS(K)+0.49                                                          GETERR.286
      WRITE(NVOL40,109)MDATE(1:16),KN,KTYPE,KSTA,LVL,IVRBL,PK,ASTA(K),           GETERR.287
     &     DK,FK,                                                                GETERR.288
     1RECYCL,FF,LOCX,LOCY,YOBS(K),XOBS(K),ZK,HK                                  GETERR.289
      ENDIF                                                                      GETERR.290
      ELSE                                                                       GETERR.291
C                                                                                GETERR.292
C   SET ERRMAX FOR RH TO 80% BELOW 300MB AND 100% ABOVE                          GETERR.293
C                                                                                GETERR.294
      ERRMXH=80.                                                                 GETERR.295
      IF (AUTBGR) THEN                                                           GETERR.296
         ERRMX=999.                                                              GETERR.297
      ELSE                                                                       GETERR.298
         ERRMX=ERRMXH                                                            GETERR.299
      END IF                                                                     GETERR.300
      IF(PL.LT.301.) ERRMX=100.                                                  GETERR.301
      IF(ABS(ERRRH).LE.ERRMX) GO TO 11                                           GETERR.302
      IF(ABS(ERR).GT.1.0E29) GO TO 11                                            GETERR.303
      NTOT=NTOT+1                                                                GETERR.304
      IF(NTOT.GT.SBM) THEN                                                       GETERR.305
      PRINT 127                                                                  GETERR.306
      STOP                                                                       GETERR.307
      END IF                                                                     GETERR.308
      MSTAE(NTOT)=ISTR(K)                                                        GETERR.309
      XERM(NTOT)=XOBS(K)                                                         GETERR.310
      YERM(NTOT)=YOBS(K)                                                         GETERR.311
      ERRMXE(NTOT)=ERRMX                                                         GETERR.312
      ELEVM(NTOT)=PL                                                             GETERR.313
      MVARE(NTOT)=IVRBL                                                          GETERR.314
      EDIFM(NTOT)=ERRRH                                                          GETERR.315
      IF(PRNTERR) THEN                                                           GETERR.316
      AAA=100.*(1.-ASTA(K)*ASTA(K))                                              GETERR.317
      BBB=100.*(1.-AOB*AOB)                                                      GETERR.318
      PRINT 115,ISTNUM(3,K),ERRMX,XOBS(K),YOBS(K),BBB,AAA,ERRRH                  GETERR.319
  115 FORMAT(2X,'STAT ID =',1X,A6,7X,'R.H. DIFF>',F6.1,'-----X,Y COOR ='         GETERR.320
     1,2F5.1,5X,'GUESS,OBS AND DIFF ARE',3F10.1)                                 GETERR.321
      END IF                                                                     GETERR.322
      IF(AUTBGW)THEN                                                             GETERR.323
      KN=KN+1                                                                    GETERR.324
      FF=F1                                                                      GETERR.325
      IF(ABS(ERR).GT.1.33*ERRMX) FF=F2                                           GETERR.326
      IF(ABS(ERR).GT.1.67*ERRMX) FF=F3                                           GETERR.327
      IF(ABS(ERR).GT.2.00*ERRMX) FF=F4                                           GETERR.328
      LOCX=XOBS(K)+0.49                                                          GETERR.329
      LOCY=YOBS(K)+0.49                                                          GETERR.330
      WRITE(NVOL40,109)MDATE(1:16),KN,KTYPE,KSTA,LVL,IVRBL,PK,TK,DK,FK,          GETERR.331
     1RECYCL,FF,LOCX,LOCY,YOBS(K),XOBS(K),ZK,ASTA(K)                             GETERR.332
      ENDIF                                                                      GETERR.333
      ENDIF                                                                      GETERR.334
      ERR=1.0E32                                                                 GETERR.335
      ASTA(K)=ERR                                                                GETERR.336
      GO TO 11                                                                   GETERR.337
  120 CONTINUE                                                                   GETERR.338
C                                                                                GETERR.339
C  SET MAX ERROR FOR SL PRES                                                     GETERR.340
C                                                                                GETERR.341
      IF (AUTBGR) THEN                                                           GETERR.342
         ERRMX=999.                                                              GETERR.343
      ELSE                                                                       GETERR.344
         ERRMX=ERRMXP                                                            GETERR.345
      END IF                                                                     GETERR.346
      IF(ABS(ERR) .LE. ERRMX) GO TO 11                                           GETERR.347
      IF(ABS(ERR) .GT. 1.0E29) GO TO 11                                          GETERR.348
      NTOT=NTOT+1                                                                GETERR.349
      IF(NTOT.GT.SBM) THEN                                                       GETERR.350
      PRINT 127                                                                  GETERR.351
      STOP                                                                       GETERR.352
      END IF                                                                     GETERR.353
      MSTAE(NTOT)=ISTR(K)                                                        GETERR.354
      XERM(NTOT)=XOBS(K)                                                         GETERR.355
      YERM(NTOT)=YOBS(K)                                                         GETERR.356
      ERRMXE(NTOT)=ERRMX                                                         GETERR.357
      ELEVM(NTOT)=PL                                                             GETERR.358
      MVARE(NTOT)=IVRBL                                                          GETERR.359
      EDIFM(NTOT)=ERR                                                            GETERR.360
      IF(PRNTERR) THEN                                                           GETERR.361
      PRINT 111,ISTNUM(3,K),ERRMX,XOBS(K),YOBS(K),AOB,ASTA(K),ERR                GETERR.362
  111 FORMAT(2X,'STAT ID =',1X,A6,7X,'SL P DIFF>',F6.1,'-----X,Y COOR ='         GETERR.363
     1,2F5.1,5X,'GUESS,OBS AND DIFF ARE',3F10.1)                                 GETERR.364
      END IF                                                                     GETERR.365
  127 FORMAT(1X,'STOP IN GETERR--TOO MANY ERMAX VALUES')                         GETERR.366
      IF(AUTBGW)THEN                                                             GETERR.367
      KN=KN+1                                                                    GETERR.368
      FF=F1                                                                      GETERR.369
      IF(ABS(ERR).GT.1.33*ERRMX) FF=F2                                           GETERR.370
      IF(ABS(ERR).GT.1.67*ERRMX) FF=F3                                           GETERR.371
      IF(ABS(ERR).GT.2.00*ERRMX) FF=F4                                           GETERR.372
      LOCX=XOBS(K)+0.49                                                          GETERR.373
      LOCY=YOBS(K)+0.49                                                          GETERR.374
      WRITE(NVOL40,109)MDATE(1:16),KN,KTYPE,KSTA,LVL,IVRBL,ASTA(K),TK,           GETERR.375
     &     DK,FK,                                                                GETERR.376
     1RECYCL,FF,LOCX,LOCY,YOBS(K),XOBS(K),ZK,HK                                  GETERR.377
      ENDIF                                                                      GETERR.378
      ERR = 1.0E32                                                               GETERR.379
      ASTA(K) = ERR                                                              GETERR.380
      GO TO 11                                                                   GETERR.381
  10  CONTINUE                                                                   GETERR.382
C        TO OBTAIN AN ANALYSIS, LET ERR = ASTA(K)                                GETERR.383
      ERR = ASTA(K)                                                              GETERR.384
   11 ER(K,IER) = ERR                                                            GETERR.385
      IF(KTYPE.NE.2) THEN                                                        GETERR.386
      OBS_UP(K,LVL,IVRBL) = ASTA(K)                                              GETERR.387
      ISTA_U(K)=ISTNUM(3,K)                                                      GETERR.388
      XOBS_U(K)=XOBS(K)                                                          GETERR.389
      YOBS_U(K)=YOBS(K)                                                          GETERR.390
      ELSE                                                                       GETERR.391
       IF(K.LE.NUSTAN) THEN                                                      GETERR.392
         OBS_UP(K,1,IVRBL) = ASTA(K)                                             GETERR.393
         ISTA_U(K)=ISTNUM(3,K)                                                   GETERR.394
         XOBS_U(K)=XOBS(K)                                                       GETERR.395
         YOBS_U(K)=YOBS(K)                                                       GETERR.396
       ELSE                                                                      GETERR.397
        OBS_SFC(K-NUSTAN,IVRBL) = ASTA(K)                                        GETERR.398
        ISTA_S(K-NUSTAN)=ISTNUM(3,K)                                             GETERR.399
        XOBS_S(K-NUSTAN)=XOBS(K)                                                 GETERR.400
        YOBS_S(K-NUSTAN)=YOBS(K)                                                 GETERR.401
       ENDIF                                                                     GETERR.402
      ENDIF                                                                      GETERR.403
   12 CONTINUE                                                                   GETERR.404
      MDATEH=MDATE                                                               GETERR.405
      MMTOT=NTOT                                                                 GETERR.406
      RETURN                                                                     GETERR.407
      END                                                                        GETERR.408
