      SUBROUTINE HRZFIL(JSH,LEV,IVRBL,IPLACE,HORZH,IH1,IH2,IH3,UPDATE)           HRZFIL.1
C                                                                                HRZFIL.2
C                                                                                HRZFIL.3
C        PURPOSE: READ OR WRITE INDIVIDUAL HORIZONTAL STRIP FROM OR TO L         HRZFIL.4
C                                                                                HRZFIL.5
C                                                                                HRZFIL.6
C        ARGUMENTS:                                                              HRZFIL.7
C                                                                                HRZFIL.8
C             JSH: HORIZONTAL STRIP NUMBER                                       HRZFIL.9
C             LEV: LEVEL NUMBER                                                  HRZFIL.10
C             IVRBL: VARIABLE NUMBER INDEX                                       HRZFIL.11
C             IPLACE: WORKING SPACE INDEX IN HORZH(IH1,IH2,IH3)                  HRZFIL.12
C                     IPLACE MUST BE .LE. IH3                                    HRZFIL.13
C             HORZH: WORKING SPACE FOR HORIZONTAL ARRAY                          HRZFIL.14
C             IH1,IH2,IH3: DIMENSIONS FOR HORZH                                  HRZFIL.15
C             UPDATE: LOGICAL INDEX                                              HRZFIL.16
C                     =.TRUE., WRITE TO LCM                                      HRZFIL.17
C                     =.FALSE., READ FROM LCM                                    HRZFIL.18
C-----------------------------------------------------------------------         HRZFIL.19
#include <paramirb.incl>                                                         HRZFIL.20
#include <paramirs.incl>                                                         HRZFIL.21
#include <coma.incl>                                                             HRZFIL.22
#include <comc.incl>                                                             HRZFIL.23
C-----------------------------------------------------------------------         HRZFIL.24
      DIMENSION HORZH(IH1,IH2,IH3)                                               HRZFIL.25
      LOGICAL UPDATE                                                             HRZFIL.26
      IF(.NOT.UPDATE)GO TO 10                                                    HRZFIL.27
      NAME = 10000*JSH + 100*LEV + IVAR(3,IVRBL)                                 HRZFIL.28
      LEN = IH1*IH2*IH3                                                          HRZFIL.29
      NWDS = LENHRZ(JSH)                                                         HRZFIL.30
      IFWA = IH1*IH2*(IPLACE-1)                                                  HRZFIL.31
      CALL WDISK(NAME,HORZH,LEN,IFWA,NWDS,CHECK)                                 HRZFIL.32
      GO TO 30                                                                   HRZFIL.33
  10  IF(JSH .NE. JSHCRN(IPLACE)) GO TO 20                                       HRZFIL.34
      IF(LEV .NE. LEVCRN(IPLACE)) GO TO 20                                       HRZFIL.35
      IF(IVAR(3,IVRBL) .NE. IVRCRN(IPLACE)) GO TO 20                             HRZFIL.36
      RETURN                                                                     HRZFIL.37
  20  NAME = 10000*JSH + 100*LEV + IVAR(3,IVRBL)                                 HRZFIL.38
      LEN = IH1*IH2*IH3                                                          HRZFIL.39
      NWDS = LENHRZ(JSH)                                                         HRZFIL.40
      IFWA = IH1*IH2*(IPLACE-1)                                                  HRZFIL.41
      CALL RDISK(NAME,HORZH,LEN,IFWA,NWDS,CHECK)                                 HRZFIL.42
  30  JSHCRN(IPLACE) = JSH                                                       HRZFIL.43
      LEVCRN(IPLACE) = LEV                                                       HRZFIL.44
      IVRCRN(IPLACE) = IVAR(3,IVRBL)                                             HRZFIL.45
      RETURN                                                                     HRZFIL.46
      END                                                                        HRZFIL.47
