      SUBROUTINE INHRZ2(IFGINT,INTF4D,IFILES,NTIMES,                             INHRZ2.1
     .     HORZH,IH1,IH2,IH3,IS1,IS2)                                            INHRZ2.2
C                                                                                INHRZ2.3
C-----------------------------------------------------------------------         INHRZ2.4
C                                                                                INHRZ2.5
C     PURPOSE:  READ REGRID 12-HR INPUT ANALYSES AND CREATE INTER-               INHRZ2.6
C               MEDIATE SURFACE FIRST-GUESS FIELDS OF U,V,T,RH, AND              INHRZ2.7
C               SLP BY TIME INTERPOLATION.                                       INHRZ2.8
C                                                                                INHRZ2.9
C-----------------------------------------------------------------------         INHRZ2.10
C                                                                                INHRZ2.11
C     *** THIS VERSION OF INHRZ2 EXPECTS GLOBAL GRID INPUT ***                   INHRZ2.12
C         MANDATORY PRES LEVELS: 1000,850,700,500,400,300,250,200,150,10         INHRZ2.13
C                                                                                INHRZ2.14
C         INPUT RECORDS:                                                         INHRZ2.15
C                                                                                INHRZ2.16
C           DATE IDENTIFIER                                                      INHRZ2.17
C           TERRAIN HEIGHT AT CROSS PTS (M)                                      INHRZ2.18
C           LAND USE AT CROSS POINTS (INTEGER)                                   INHRZ2.19
C           MAP SCALE FACTOR AT CROSS POINTS                                     INHRZ2.20
C           MAP SCALE FACTOR AT DOT POINTS                                       INHRZ2.21
C           CORIOLIS PARAMETER AT DOT POINTS                                     INHRZ2.22
C           LAT,LON AT CROSS POINTS                                              INHRZ2.23
C           LAT,LON AT DOT POINTS                                                INHRZ2.24
C           SNOW COVER AT CROSS POINTS                                           INHRZ2.25
C           SEA LEVEL PRES. AT DOT POINTS (MB)                                   INHRZ2.26
C       **  SEA LEVEL PRES. AT CROSS POINTS (MB)                                 INHRZ2.27
C       **  SFC TEMP. AT CROSS POINTS (C)                                        INHRZ2.28
C           SEA SFC TEMP. AT CROSS POINTS (C)                                    INHRZ2.29
C           *                                                                    INHRZ2.30
C           *   TEMP. AT MAND. LEVELS AT CROSS POINTS (C)                        INHRZ2.31
C           *                                                                    INHRZ2.32
C           * SFC GEOSTROPHIC U AND V (M/S)                                      INHRZ2.33
C       **  *   GEOP. HT, U, AND V AT EACH MAND. LEV. AT DOT POINTS (M/S         INHRZ2.34
C           *                                                                    INHRZ2.35
C       **  RELATIVE HUMID. AT MAND. LEVELS UP TO 300 MB (CROSS POINTS)          INHRZ2.36
C                                                                                INHRZ2.37
C-----------------------------------------------------------------------         INHRZ2.38
C-----------------------------------------------------------------------         INHRZ2.39
C                                                                                INHRZ2.40
#include <coma.incl>                                                             INHRZ2.41
C-----------------------------------------------------------------------         INHRZ2.42
C-----------------------------------------------------------------------         INHRZ2.43
#include <hedmif.incl>                                                           INHRZ2.44
#include <paramdim.incl>                                                         INHRZ2.45
C-----------------------------------------------------------------------         INHRZ2.46
      REAL SLABA1(IMX,JMX)                                                       INHRZ2.47
      REAL SLABA2(IMX,JMX)                                                       INHRZ2.48
      REAL SLABA3(IMX,JMX)                                                       INHRZ2.49
      REAL SLABA4(IMX,JMX)                                                       INHRZ2.50
      REAL SLABA5(IMX,JMX)                                                       INHRZ2.51
      REAL SLABB1(IMX,JMX)                                                       INHRZ2.52
      REAL SLABB2(IMX,JMX)                                                       INHRZ2.53
      REAL SLABB3(IMX,JMX)                                                       INHRZ2.54
      REAL SLABB4(IMX,JMX)                                                       INHRZ2.55
      REAL SLABB5(IMX,JMX)                                                       INHRZ2.56
      REAL SCR(IMX,JMX)                                                          INHRZ2.57
      DIMENSION HORZH(IS1,IS2), ISTAT(2)                                         INHRZ2.58
      character*8 name                                                           INHRZ2.59
      character*24 IDATE, LDATE                                                  INHRZ2.60
      integer MYY, MMO, MDY, MHR, MMI, MSC, MFR                                  INHRZ2.61
      logical hedwritten                                                         INHRZ2.62
      PRINT 10                                                                   INHRZ2.63
10    FORMAT(1H0,///'@@@@@@@@  CALL INHRZ2---RTAPE,(SLBFIL)',15X,                INHRZ2.64
     1 'INPUT FROM REGRID'///)                                                   INHRZ2.65
                                                                                 INHRZ2.66
      hedwritten = .FALSE.                                                       INHRZ2.67
                                                                                 INHRZ2.68
C                                                                                INHRZ2.69
C--****--READ INITIAL TIME, IDATE                                                INHRZ2.70
C                                                                                INHRZ2.71
      READ(NVOL4) iflag                                                          INHRZ2.72
      if (iflag .eq. bh_flag) then                                               INHRZ2.73
         READ(NVOL4)MIFSCR,MRFSCR                                                INHRZ2.74
      else                                                                       INHRZ2.75
         write(*,'(''Expecting big-header flag, but found'',I15)')iflag          INHRZ2.76
      endif                                                                      INHRZ2.77
 4431 format(I4.4,2('-',I2.2),'_',2(I2.2,':'),I2.2,'.',I4.4)                     INHRZ2.78
C  SKIP NON-SFC. DATA                                                            INHRZ2.79
C  From the 2-d fields, save only sea-level pressure at cross points.            INHRZ2.80
 4432 continue                                                                   INHRZ2.81
         READ(NVOL4) iflag                                                       INHRZ2.82
         if (iflag .eq. eot_flag) then                                           INHRZ2.83
            write(*,'(''Hit the END-OF-TIME mark.'')')                           INHRZ2.84
            go to 4433                                                           INHRZ2.85
         elseif (iflag .ne. sh_flag) then                                        INHRZ2.86
            write(*,'(''Unrecognized flag: '', I15)') iflag                      INHRZ2.87
         endif                                                                   INHRZ2.88
         READ(NVOL4) ndim, idst1, idst2, idst3, idst4, shdim,                    INHRZ2.89
     &        time, shstagger,                                                   INHRZ2.90
     &        shorder, idate, shname,                                            INHRZ2.91
     &        shunits, shdesc                                                    INHRZ2.92
         NAME = shname(1:8)                                                      INHRZ2.93
         IF (NAME.EQ.'T') THEN                                                   INHRZ2.94
           !READ AND SAVE TSFC                                                   INHRZ2.95
            READ(NVOL4)SLABA2                                                    INHRZ2.96
            DO I = 1, IS1                                                        INHRZ2.97
               DO J = 1, IS2                                                     INHRZ2.98
                  SLABA2(I,J)=SLABA2(I,J)-273.15                                 INHRZ2.99
               ENDDO                                                             INHRZ2.100
            ENDDO                                                                INHRZ2.101
         ELSEIF (NAME.EQ.'U') THEN                                               INHRZ2.102
            ! READ SFC GEOSTROPHIC U.  USE IT FOR SFC U IF IWIND=SFCGEO.         INHRZ2.103
            READ(NVOL4)SLABA3,SCR                                                INHRZ2.104
            IF(IWIND.EQ.2) THEN                                                  INHRZ2.105
               DO I = 1, IMX                                                     INHRZ2.106
                  DO J = 1, JMX                                                  INHRZ2.107
                     SLABA3(I,J)=SCR(I,J)                                        INHRZ2.108
                  ENDDO                                                          INHRZ2.109
               ENDDO                                                             INHRZ2.110
            ENDIF                                                                INHRZ2.111
         ELSEIF (NAME.EQ.'V') THEN                                               INHRZ2.112
            ! READ SFC GEOSTROPHIC V.  USE IT FOR SFC V IF IWIND=SFCGEO.         INHRZ2.113
            READ(NVOL4)SLABA4,SCR                                                INHRZ2.114
            IF(IWIND.EQ.2) THEN                                                  INHRZ2.115
               DO I = 1, IMX                                                     INHRZ2.116
                  DO J = 1, JMX                                                  INHRZ2.117
                     SLABA4(I,J)=SCR(I,J)                                        INHRZ2.118
                  ENDDO                                                          INHRZ2.119
               ENDDO                                                             INHRZ2.120
            ENDIF                                                                INHRZ2.121
         ELSEIF (NAME.EQ.'RH') THEN                                              INHRZ2.122
            ! SAVE SFC R.H., DISCARD ALL OTHER LEVELS                            INHRZ2.123
            READ(NVOL4)SLABA5                                                    INHRZ2.124
         ELSEIF (NAME.EQ.'PSEALVLC') THEN                                        INHRZ2.125
            READ(NVOL4) SLABA1                                                   INHRZ2.126
            ! Convert Sea-level pressure from Pa (MKS units in input) to mb.     INHRZ2.127
            do i = 1, imx                                                        INHRZ2.128
               do j = 1, jmx                                                     INHRZ2.129
                  slaba1(i,j) = slaba1(i,j) * 1.E-2                              INHRZ2.130
               enddo                                                             INHRZ2.131
            enddo                                                                INHRZ2.132
         ELSE                                                                    INHRZ2.133
            READ(NVOL4) XSCR                                                     INHRZ2.134
         ENDIF                                                                   INHRZ2.135
      go to 4432                                                                 INHRZ2.136
 4433 continue                                                                   INHRZ2.137
C                                                                                INHRZ2.138
C---****--INITIAL TIME READS ARE COMPLETE.  PROCEED TO SUCCESSIVE                INHRZ2.139
C         INPUT TIMES.                                                           INHRZ2.140
C                                                                                INHRZ2.141
 4434 continue                                                                   INHRZ2.142
         READ(NVOL4,END=200) iflag                                               INHRZ2.143
         if (iflag .eq. eot_flag) then                                           INHRZ2.144
            write(*,'(''Hit the END-OF-TIME mark.'')')                           INHRZ2.145
            go to 4435                                                           INHRZ2.146
         elseif (iflag .ne. sh_flag) then                                        INHRZ2.147
            write(*,'(''Unrecognized flag: '', I15)') iflag                      INHRZ2.148
         endif                                                                   INHRZ2.149
         READ(NVOL4) ndim, idst1, idst2, idst3, idst4, shdim,                    INHRZ2.150
     &        time, shstagger,                                                   INHRZ2.151
     &        shorder, ldate, shname,                                            INHRZ2.152
     &        shunits, shdesc                                                    INHRZ2.153
         NAME = shname(1:8)                                                      INHRZ2.154
         IF (NAME.EQ.'T') THEN                                                   INHRZ2.155
            !READ AND SAVE TSFC                                                  INHRZ2.156
            READ(NVOL4)SLABB2                                                    INHRZ2.157
            DO IK = 1, IS1                                                       INHRZ2.158
               DO J = 1, IS2                                                     INHRZ2.159
                  SLABB2(IK,J)=SLABB2(IK,J)-273.15                               INHRZ2.160
               ENDDO                                                             INHRZ2.161
            ENDDO                                                                INHRZ2.162
         ELSEIF (NAME.EQ.'U') THEN                                               INHRZ2.163
            ! READ SFC GEOSTROPHIC U.  USE IT FOR SFC U IF IWIND=SFCGEO.         INHRZ2.164
            READ(NVOL4)SLABB3,SCR                                                INHRZ2.165
            IF(IWIND.EQ.2) THEN                                                  INHRZ2.166
               DO IK = 1, IMX                                                    INHRZ2.167
                  DO J = 1, JMX                                                  INHRZ2.168
                     SLABB3(IK,J)=SCR(IK,J)                                      INHRZ2.169
                  ENDDO                                                          INHRZ2.170
               ENDDO                                                             INHRZ2.171
            ENDIF                                                                INHRZ2.172
         ELSEIF (NAME.EQ.'V') THEN                                               INHRZ2.173
            ! READ SFC GEOSTROPHIC V.  USE IT FOR SFC V IF IWIND=SFCGEO.         INHRZ2.174
            READ(NVOL4)SLABB4,SCR                                                INHRZ2.175
            IF(IWIND.EQ.2) THEN                                                  INHRZ2.176
               DO IK = 1, IMX                                                    INHRZ2.177
                  DO J = 1, JMX                                                  INHRZ2.178
                     SLABB4(IK,J)=SCR(IK,J)                                      INHRZ2.179
                  ENDDO                                                          INHRZ2.180
               ENDDO                                                             INHRZ2.181
            ENDIF                                                                INHRZ2.182
         ELSE IF (NAME.EQ.'RH') THEN                                             INHRZ2.183
            ! SAVE SFC R.H., DISCARD ALL OTHER LEVELS                            INHRZ2.184
            READ(NVOL4)SLABB5                                                    INHRZ2.185
         ELSE IF (NAME.EQ.'PSEALVLC') THEN                                       INHRZ2.186
            READ(NVOL4) SLABB1                                                   INHRZ2.187
            ! Convert Sea-level pressure from Pa (MKS units in input) to mb.     INHRZ2.188
            do i = 1, imx                                                        INHRZ2.189
               do j = 1, jmx                                                     INHRZ2.190
                  slabb1(i,j) = slabb1(i,j) * 1.E-2                              INHRZ2.191
               enddo                                                             INHRZ2.192
            enddo                                                                INHRZ2.193
         ELSE                                                                    INHRZ2.194
            READ(NVOL4) XSCR                                                     INHRZ2.195
         ENDIF                                                                   INHRZ2.196
      go to 4434                                                                 INHRZ2.197
 4435 continue                                                                   INHRZ2.198
C                                                                                INHRZ2.199
C---***--PERFORM TIME INTERPOLATIONS AND WRITE TO NVOL45                         INHRZ2.200
C      IDATE=IDATE+INCDAT                                                        INHRZ2.201
C      COEFF=FLOAT(INCDAT)/(FLOAT(12-(INCDAT*(J-2))))                            INHRZ2.202
         call geth_idts(ldate(1:19), idate(1:19), IFGINT)                        INHRZ2.203
         IFGINT = IFGINT / 3600                                                  INHRZ2.204
         J = 0                                                                   INHRZ2.205
 1500 continue                                                                   INHRZ2.206
         J = J + 1                                                               INHRZ2.207
         call geth_newdate(idate(1:13), idate(1:13), INTF4D)                     INHRZ2.208
         COEFF=1./FLOAT(IFGINT/INTF4D-J+1)                                       INHRZ2.209
         DO I1=1,IS1                                                             INHRZ2.210
         DO I2=1,IS2                                                             INHRZ2.211
            SLABA1(I1,I2)=(1.-COEFF)*SLABA1(I1,I2)+COEFF*SLABB1(I1,I2)           INHRZ2.212
            SLABA2(I1,I2)=(1.-COEFF)*SLABA2(I1,I2)+COEFF*SLABB2(I1,I2)           INHRZ2.213
            SLABA3(I1,I2)=(1.-COEFF)*SLABA3(I1,I2)+COEFF*SLABB3(I1,I2)           INHRZ2.214
            SLABA4(I1,I2)=(1.-COEFF)*SLABA4(I1,I2)+COEFF*SLABB4(I1,I2)           INHRZ2.215
            SLABA5(I1,I2)=(1.-COEFF)*SLABA5(I1,I2)+COEFF*SLABB5(I1,I2)           INHRZ2.216
         ENDDO                                                                   INHRZ2.217
         ENDDO                                                                   INHRZ2.218
         call decomdat(idate, myy, mmo, mdy, mhr, mmi, msc, mfr)                 INHRZ2.219
         MIFSCR(5,2) = myy                                                       INHRZ2.220
         MIFSCR(6,2) = mmo                                                       INHRZ2.221
         MIFSCR(7,2) = mdy                                                       INHRZ2.222
         MIFSCR(8,2) = mhr                                                       INHRZ2.223
         MIFSCR(9,2) = mmi                                                       INHRZ2.224
         MIFSCR(10,2) = 0                                                        INHRZ2.225
         MIFSCR(11,2) = 0                                                        INHRZ2.226
         if (idate .lt. ldate) then                                              INHRZ2.227
            if (.not. hedwritten) then                                           INHRZ2.228
               WRITE(NVOL45) eot_flag                                            INHRZ2.229
               if (lagtem) then                                                  INHRZ2.230
                  write(nvol45) eot_flag                                         INHRZ2.231
               else                                                              INHRZ2.232
                  WRITE(NVOL45) bh_flag                                          INHRZ2.233
                  WRITE(NVOL45)MIFSCR,MRF,MIFC,MRFC                              INHRZ2.234
               endif                                                             INHRZ2.235
               hedwritten = .true.                                               INHRZ2.236
            endif                                                                INHRZ2.237
            IF (.NOT.LAGTEM) THEN                                                INHRZ2.238
               write(nvol45) sh_flag                                             INHRZ2.239
               shname = 'PSEALVLC           '                                    INHRZ2.240
               shunits = 'hPa                                        '           INHRZ2.241
               shdesc = 'SEA-LEVEL PRESSURE                            '         INHRZ2.242
               write(nvol45) 2, IMX,JMX,-1,-1,0.,'C',                            INHRZ2.243
     &              'YX  ', idate, shname, shunits, shdesc                       INHRZ2.244
               WRITE(NVOL45)SLABA1                                               INHRZ2.245
                                                                                 INHRZ2.246
               write(nvol45) sh_flag                                             INHRZ2.247
               shname = 'U                   '                                   INHRZ2.248
               shunits = 'm/s                                          '         INHRZ2.249
               shdesc = 'U COMPONENT                                   '         INHRZ2.250
               write(nvol45) 2, IMX,JMX,-1,-1,0.,'D',                            INHRZ2.251
     &              'YX  ', idate, shname, shunits, shdesc                       INHRZ2.252
               WRITE(NVOL45)SLABA3                                               INHRZ2.253
                                                                                 INHRZ2.254
               write(nvol45) sh_flag                                             INHRZ2.255
               shname = 'V                   '                                   INHRZ2.256
               shunits = 'm/s                                          '         INHRZ2.257
               shdesc = 'V COMPONENT                                   '         INHRZ2.258
               write(nvol45) 2, IMX,JMX,-1,-1,0.,'D',                            INHRZ2.259
     &              'YX  ', idate, shname, shunits, shdesc                       INHRZ2.260
               WRITE(NVOL45)SLABA4                                               INHRZ2.261
                                                                                 INHRZ2.262
               write(nvol45) sh_flag                                             INHRZ2.263
               shname = 'T                   '                                   INHRZ2.264
               shunits = 'C                                            '         INHRZ2.265
               shdesc = 'TEMPERATURE                                   '         INHRZ2.266
               write(nvol45) 2, IMX,JMX,-1,-1,0.,'C',                            INHRZ2.267
     &              'YX  ', idate, shname, shunits, shdesc                       INHRZ2.268
               WRITE(NVOL45)SLABA2                                               INHRZ2.269
                                                                                 INHRZ2.270
               write(nvol45) sh_flag                                             INHRZ2.271
               shname = 'RH                  '                                   INHRZ2.272
               shunits = '%                                            '         INHRZ2.273
               shdesc = 'RELATIVE HUMIDITY                             '         INHRZ2.274
               write(nvol45) 2, IMX,JMX,-1,-1,0.,'C',                            INHRZ2.275
     &              'YX  ', idate, shname, shunits, shdesc                       INHRZ2.276
               WRITE(NVOL45)SLABA5                                               INHRZ2.277
            ENDIF                                                                INHRZ2.278
                                                                                 INHRZ2.279
            if (lagtem) then                                                     INHRZ2.280
               WRITE(NVOL45) sh_flag                                             INHRZ2.281
            else                                                                 INHRZ2.282
               write(nvol45) eot_flag                                            INHRZ2.283
            endif                                                                INHRZ2.284
            go to 1500                                                           INHRZ2.285
         endif                                                                   INHRZ2.286
         write(nvol45) eot_flag                                                  INHRZ2.287
         if (lagtem) then                                                        INHRZ2.288
            write(nvol45) eot_flag                                               INHRZ2.289
         endif                                                                   INHRZ2.290
                                                                                 INHRZ2.291
150   CONTINUE                                                                   INHRZ2.292
C        SHUFFLE IDATE AND SFC. DATA BEFORE NEXT READ STEP.                      INHRZ2.293
      IDATE=LDATE                                                                INHRZ2.294
      DO I1=1,IS1                                                            INH INHRZ2.295
         DO I2=1,IS2                                                             INHRZ2.296
            SLABA1(I1,I2)=SLABB1(I1,I2)                                          INHRZ2.297
            SLABA2(I1,I2)=SLABB2(I1,I2)                                          INHRZ2.298
            SLABA3(I1,I2)=SLABB3(I1,I2)                                          INHRZ2.299
            SLABA4(I1,I2)=SLABB4(I1,I2)                                          INHRZ2.300
            SLABA5(I1,I2)=SLABB5(I1,I2)                                          INHRZ2.301
         ENDDO                                                                   INHRZ2.302
      ENDDO                                                                      INHRZ2.303
      go to 4433                                                                 INHRZ2.304
200   CONTINUE                                                                   INHRZ2.305
      write(*,'("Hit the END-OF-DATA mark.")')                                   INHRZ2.306
C---***--INTERPOLATION AND WRITE PHASES COMPLETED.                               INHRZ2.307
C                                                                                INHRZ2.308
      REWIND NVOL4                                                               INHRZ2.309
      REWIND NVOL45                                                              INHRZ2.310
      RETURN                                                                     INHRZ2.311
      END                                                                        INHRZ2.312
