      SUBROUTINE LLTOXY (XLAT,XLON,X,Y,PROJECT)                                  LLTOXY.1
                                                                                 LLTOXY.2
C*****************************************************************************C  LLTOXY.3
C  NOTES    - MODELED AFTER XYTOLL IN THE PLOTS.O LIBRARY                     C  LLTOXY.4
C*****************************************************************************C  LLTOXY.5
                                                                                 LLTOXY.6
C  PARAMETERS                                                                    LLTOXY.7
      PARAMETER       (PI = 3.14159265)  ! YOU KNOW!  PI = 180 DEGREES           LLTOXY.8
      PARAMETER       (RE = 6370.)       ! THE RADIUS OF THE EARTH IN KM         LLTOXY.9
      PARAMETER       (CE = 40029.85315) ! THE CIRCUMFERENCE OF THE EARTH IN KM  LLTOXY.10
                                                                                 LLTOXY.11
C  CHARACTER VARIABLES                                                           LLTOXY.12
                                                                                 LLTOXY.13
      CHARACTER*2      PROJECT           ! PROJECTION INDICATOR            (IN)  LLTOXY.14
                                                                                 LLTOXY.15
C  REAL VARIABLES                                                                LLTOXY.16
                                                                                 LLTOXY.17
      REAL             XLAT,             ! INCOMING LATITUDE               (IN)  LLTOXY.18
     *                 XLON              ! INCOMING LONGITUDE              (IN)  LLTOXY.19
      REAL             X,                ! RESULTING X                    (OUT)  LLTOXY.20
     *                 Y                 ! RESULTING Y                    (OUT)  LLTOXY.21
      REAL             RCLN,             ! CENTER LONGITUDE IN RADIANS  (LOCAL)  LLTOXY.22
     *                 RCLT,             ! CENTER LATITUDE IN RADIANS   (LOCAL)  LLTOXY.23
     *                 CJ,               ! CENTER X COORD. FOR GRID     (LOCAL)  LLTOXY.24
     *                 CI,               ! CENTER Y COORD. FOR GRID     (LOCAL)  LLTOXY.25
     *                 DJ,               ! DISTANCE FROM THE CENTRAL             LLTOXY.26
C                                          MERIDIAN TO THE POINT        (LOCAL)  LLTOXY.27
     *                 DI,               ! DISTANCE FROM POLE TO POINT  (LOCAL)  LLTOXY.28
     *                 KAPPA             ! CALCULATION VARIABLE         (LOCAL)  LLTOXY.29
                                                                                 LLTOXY.30
C  COMMON BLOCKS                                                                 LLTOXY.31
                                                                                 LLTOXY.32
#include <comllxy.incl>                                                          LLTOXY.33
                                                                                 LLTOXY.34
C****************************  SUBROUTINE BEGIN  *****************************C  LLTOXY.35
                                                                                 LLTOXY.36
                                                                                 LLTOXY.37
      RLAT =  XLAT * PI / 180.0                                                  LLTOXY.38
      RLON =  XLON * PI / 180.0                                                  LLTOXY.39
      RCLT = CLAT * PI / 180.0                                                   LLTOXY.40
      RCLN = CLON * PI / 180.0                                                   LLTOXY.41
      PHI1 = FSPARL * PI / 180.0                                                 LLTOXY.42
      PHI2 = SSPARL * PI / 180.0                                                 LLTOXY.43
      RLONDIFF = MOD(RLON - RCLN + 3.0 * PI, 2.0 * PI) - PI                      LLTOXY.44
      IF (CLAT.GE.0) THEN                                                        LLTOXY.45
         PSI1 = PI * 0.5 - PHI1                                                  LLTOXY.46
      ELSE                                                                       LLTOXY.47
         PSI1 = (-PI * 0.5 - PHI1 )                                              LLTOXY.48
      ENDIF                                                                      LLTOXY.49
      CJ = FLOAT(LJMX + 1) * 0.5                                                 LLTOXY.50
      CI = FLOAT(LIMX + 1) * 0.5                                                 LLTOXY.51
                                                                                 LLTOXY.52
      IF (PROJECT(1:2) .EQ. 'ME') THEN                                           LLTOXY.53
         DI = RE * LOG(TAN ((RLAT + PI * 0.5)/(2.0)))                            LLTOXY.54
         DJ = RE *(RLONDIFF)                                                     LLTOXY.55
         Y = CI +(DI + RE * LOG(COS(RCLT)/(1 + SIN(RCLT))))/GRDS                 LLTOXY.56
         X = CJ + DJ/GRDS                                                        LLTOXY.57
      ELSE IF (PROJECT(1:2) .EQ. 'CE') THEN                                      LLTOXY.58
         DI = (CE*0.5)*(RLAT-RCLT)/PI                                            LLTOXY.59
         DJ = CE * (RLONDIFF)/(PI*2.)                                            LLTOXY.60
         Y = CI + DI/GRDS                                                        LLTOXY.61
      ELSE IF (PROJECT(1:2) .EQ. 'LC') THEN                                      LLTOXY.62
         IF (CLAT.GT.0.0) THEN                                                   LLTOXY.63
            KAPPA = (LOG10(COS(PHI1))-LOG10(COS(PHI2))) /                        LLTOXY.64
     &           (LOG10(TAN((PI * 0.5 - PHI1)/2.)) -                             LLTOXY.65
     &           LOG10(TAN((PI * 0.5 - PHI2)/2.)))                               LLTOXY.66
         ELSE                                                                    LLTOXY.67
            KAPPA = (LOG10(COS(PHI1))-LOG10(COS(PHI2))) /                        LLTOXY.68
     &           (LOG10(TAN((PI * 0.5 + PHI1)/2.)) -                             LLTOXY.69
     &           LOG10(TAN((PI * 0.5 + PHI2)/2.)))                               LLTOXY.70
         ENDIF                                                                   LLTOXY.71
         IF (CLAT.GT.0.0) THEN                                                   LLTOXY.72
            RS = (RE/KAPPA) * SIN (PSI1) *                                       LLTOXY.73
     &           (TAN(( PI * 0.5 - RLAT)/2.)/TAN(PSI1/2.))**KAPPA                LLTOXY.74
         ELSE                                                                    LLTOXY.75
            RS = (RE/KAPPA) * SIN (PSI1) *                                       LLTOXY.76
     &           (TAN((-PI * 0.5 - RLAT)/2.)/TAN(PSI1/2.))**KAPPA                LLTOXY.77
         ENDIF                                                                   LLTOXY.78
         IF (CLAT.GT.0.0) THEN                                                   LLTOXY.79
            YC = -(RE/KAPPA) * SIN(PSI1) *                                       LLTOXY.80
     &          (TAN((PI * 0.5 - RCLT)/2.0) / TAN (PSI1/2.0))**KAPPA             LLTOXY.81
         ELSE                                                                    LLTOXY.82
            YC = -(RE/KAPPA) * SIN(PSI1) *                                       LLTOXY.83
     &          (TAN((-PI * 0.5 - RCLT)/2.0) / TAN (PSI1/2.0))**KAPPA            LLTOXY.84
         ENDIF                                                                   LLTOXY.85
         DI = YC + RS*COS(KAPPA*(RLONDIFF))                                      LLTOXY.86
         Y = CI - DI/GRDS                                                        LLTOXY.87
         DJ = RS * SIN(KAPPA*(RLONDIFF))                                         LLTOXY.88
         IF (CLAT .GT. 0.0) THEN                                                 LLTOXY.89
            X = CJ + DJ/GRDS                                                     LLTOXY.90
         ELSE                                                                    LLTOXY.91
            X = CJ - DJ/GRDS                                                     LLTOXY.92
         ENDIF                                                                   LLTOXY.93
      ELSE IF (PROJECT(1:2) .EQ. 'ST') THEN                                      LLTOXY.94
         IF (CLAT.GT.0.0) THEN                                                   LLTOXY.95
            RS = RE * SIN (PI * 0.5 - RLAT) *                                    LLTOXY.96
     &           (1.0 + COS (PSI1)) / (1.0 + COS(PI * 0.5 - RLAT))               LLTOXY.97
         ELSE                                                                    LLTOXY.98
            RS = RE * SIN (PI * (-0.5) - RLAT) *                                 LLTOXY.99
     &           (1.0 + COS (PSI1)) / (1.0 + COS(PI * (-0.5) - RLAT))            LLTOXY.100
         ENDIF                                                                   LLTOXY.101
         IF (CLAT.GT.0.0) THEN                                                   LLTOXY.102
            YC = -RE * SIN(PSI1) *                                               LLTOXY.103
     &           (TAN((PI * 0.5 - RCLT)/2.0) / TAN (PSI1/2.0))                   LLTOXY.104
         ELSE                                                                    LLTOXY.105
            YC = -RE * SIN(PSI1) *                                               LLTOXY.106
     &           (TAN((PI * (-0.5) - RCLT)/2.0) / TAN (PSI1/2.0))                LLTOXY.107
         ENDIF                                                                   LLTOXY.108
         DI = YC + RS*COS(RLON-RCLN)                                             LLTOXY.109
         Y = CI - DI/GRDS                                                        LLTOXY.110
                                                                                 LLTOXY.111
         DJ = RS * SIN(RLON-RCLN)                                                LLTOXY.112
         IF (CLAT .GE. 0.0) THEN                                                 LLTOXY.113
            X = CJ + DJ/GRDS                                                     LLTOXY.114
         ELSE                                                                    LLTOXY.115
            X = CJ - DJ/GRDS                                                     LLTOXY.116
         ENDIF                                                                   LLTOXY.117
      ENDIF                                                                      LLTOXY.118
                                                                                 LLTOXY.119
C*****************************  SUBROUTINE END  ******************************C  LLTOXY.120
                                                                                 LLTOXY.121
      RETURN                                                                     LLTOXY.122
      END                                                                        LLTOXY.123
