      SUBROUTINE MQD (NOBS, YC, XC, DAT, IX, JY, IV, IFAC, A1, A2,QI,            MQD.1
     &     QGI,DUM)                                                              MQD.2
C                                                                                MQD.3
C MULTIQUADRIC INTERPOLATION BASED ON NUSS AND TITLEY (1994 MWR).                MQD.4
C THE FREE PARAMETERS ARE LAMBDA, THE SMOOTHING FACTOR AND C, THE                MQD.5
C MULTIQUADRIC PARAMETER. IF THE PROCEDURE BOMBS, THE MOST LIKELY                MQD.6
C PROBLEM IS THAT THE VALUE FOR C IS INCORRECT. FOR LONG, NARROW                 MQD.7
C DOMAINS, IT MIGHT BE A PROBLEM.                                                MQD.8
C NOTE THAT XC AND YC ARE INVERTED TO MATCH THE BACKWARDS MM5 SYSTEM.            MQD.9
C  ON ENTRY:                                                                     MQD.10
C             NOBS = NUMBER OF OBSERVATION DATA POINTS                           MQD.11
C             YC   = YC(NOBS), Y COORDINATE OF THE OB                            MQD.12
C             XC   = XC(NOBS), X COORDINATE OF THE OB                            MQD.13
C             DAT  = DAT(NOBS), THE OBSERVATIONS (IF IFAC=2) OR                  MQD.14
C                    DIFFERENCE BETWEEN 1ST GUESS AND OBSERVATIONS (IF IFAC=1)   MQD.15
C             IX   = FIRST DIMENSION OF THE GRID ARRAY                           MQD.16
C             JY   = SECOND DIMENSION OF THE GRID ARRAY                          MQD.17
C             IV   = VARIABLE TYPE, USED TO SET THE ERROR VALUE                  MQD.18
C             IFAC = ANALYSIS TYPE, 1 = ALTERS, 2 = ANALYSIS                     MQD.19
C             A1   = FIRST GUESS FIELD                                           MQD.20
C             A2   = WORKSPACE ARRAY                                             MQD.21
C ON EXIT:                                                                       MQD.22
C             A1  CONTAINS THE ANALYZED FIELD                                    MQD.23
C                                                                                MQD.24
C  PROGRAMMED BY JIM BRESCH NCAR/UW    12/14/94                                  MQD.25
C                                                                                MQD.26
      REAL LAMBDA                                                                MQD.27
      PARAMETER (LAMBDA=0.0025)                                                  MQD.28
      REAL QGI(IX,NOBS), QI(NOBS,NOBS), A1(IX,JY), A2(IX,JY)                     MQD.29
      REAL XC(NOBS), YC(NOBS), DAT(NOBS)                                         MQD.30
      REAL DUM(IX*NOBS)                                                          MQD.31
      real det(2)                                                                MQD.32
      IF (NOBS .LT. 3) THEN                                                      MQD.33
      WRITE(6,*) 'WARNING: NOBS < 3. NO MODIFICATION TO THE FIRST '//            MQD.34
     &        'GUESS FIELD OCCURRED.'                                            MQD.35
      RETURN                                                                     MQD.36
      ENDIF                                                                      MQD.37
      C = 0.0008 * (MAX0(IX,JY))                                                 MQD.38
C SET ERRM, THE MEAN ERROR VALUE FOR THE VARIABLE BEING ANALYZED. THE            MQD.39
C RESULTS ARE NOT TOO SENSITIVE TO THIS PARAMETER, BUT THE VALUES MUST           MQD.40
C BE SANE.                                                                       MQD.41
      IF (IV .EQ. 1) THEN   ! U, V  2 M/S                                        MQD.42
        ERRM = 2.                                                                MQD.43
      ELSE IF (IV .EQ. 2) THEN       ! P  1 MB                                   MQD.44
        ERRM = 1.                                                                MQD.45
      ELSE IF (IV .EQ. 3) THEN     ! T  0.5 DEGREE                               MQD.46
        ERRM = 0.5                                                               MQD.47
      ELSE IF (IV .EQ. 4) THEN     ! RH 0.1 CORRESPONDS TO 5%                    MQD.48
        ERRM = 0.1                                                               MQD.49
      ENDIF                                                                      MQD.50
      DO J = 1, JY                                                               MQD.51
        DO I = 1, IX                                                             MQD.52
          A2(I,J) = A1(I,J)                                                      MQD.53
        ENDDO                                                                    MQD.54
      ENDDO                                                                      MQD.55
C FILL THE QI MATRIX                                                             MQD.56
      DO J = 1, NOBS                                                             MQD.57
        DO I = 1, NOBS                                                           MQD.58
          QI(I,J) = -1.* SQRT(((XC(J)-XC(I))**2 +                                MQD.59
     &                       (YC(J)-YC(I))**2)/(C*C)+1.)                         MQD.60
        ENDDO                                                                    MQD.61
      ENDDO                                                                      MQD.62
C ACCOUNT FOR OBSERVATIONAL UNCERTAINTY (NUSS AND TITLEY 1994)                   MQD.63
      DO J = 1, NOBS                                                             MQD.64
        I = J                                                                    MQD.65
        QI(I,J) = QI(I,J) + NOBS*LAMBDA*ERRM                                     MQD.66
      ENDDO                                                                      MQD.67
C FIND THE INVERSE OF QI                                                         MQD.68
!      CALL LINRG (NOBS, QI, NOBS, QI, NOBS)                                     MQD.69
      call sgeco(qi, nobs, nobs, Dum(2*nobs), condition, Dum(1))                 MQD.70
      job = 01  ! Find the inverse                                               MQD.71
      call sgedi(qi, nobs, nobs, Dum(2*nobs), det, Dum(1), job)                  MQD.72
C QI NOW CONTAINS THE INVERSE OF ITSELF...                                       MQD.73
C FILL THE QGI MATRIX                                                            MQD.74
      DO JG = 1, JY                                                              MQD.75
        DO IG = 1, IX                                                            MQD.76
          DO I = 1, NOBS                                                         MQD.77
            QGI(IG,I) = -1.* SQRT(((FLOAT(IG)-XC(I))**2 +                        MQD.78
     &                       (FLOAT(JG)-YC(I))**2)/(C*C)+1.)                     MQD.79
          ENDDO                                                                  MQD.80
        ENDDO                                                                    MQD.81
C MULTIPLY QI INVERSE AND QGI                                                    MQD.82
C MULTIPLY THE PRODUCT WITH THE DATA VECTOR                                      MQD.83
        call sgemv('N',nobs,nobs,1.,Qi ,nobs,dat,1,0.,dum,1)                     MQD.84
        call sgemv('N',ix,nobs,1.,Qgi,ix,Dum,1,0.,A1(1,JG),1)                    MQD.85
      ENDDO                                                                      MQD.86
C ADD THE FIRST GUESS TO THE ARRAY IF IFAC=1                                     MQD.87
      IF (IFAC .EQ. 1) THEN                                                      MQD.88
        DO J = 1, JY                                                             MQD.89
          DO I = 1, IX                                                           MQD.90
            A1(I,J) = A1(I,J) + A2(I,J)                                          MQD.91
          ENDDO                                                                  MQD.92
        ENDDO                                                                    MQD.93
      ENDIF                                                                      MQD.94
      END                                                                        MQD.95
