      SUBROUTINE OUTFDA(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,SLAB3,PDIF12,              OUTFDA.1
     &     IS1,                                                                  OUTFDA.2
     .     IS2,MDATE,IFILE,NTIMES,INTF4D,ICHK,LCHK,NVOL39,NGRID,SLAB4,           OUTFDA.3
     .     MAXIC,MAXJC,ISTRTDAT)                                                 OUTFDA.4
C                                                                                OUTFDA.5
C-----------------------------------------------------------------------         OUTFDA.6
C                                                                                OUTFDA.7
C        THIS SUBROUTINE CREATE AN OUTPUT FILE CONSISTING OF SURFACE             OUTFDA.8
C        ANALYSES AT SELECTED INTERVALS FOR ASSIMILATION VIA FDDA                OUTFDA.9
C        INTO MM4.                                                               OUTFDA.10
C                                                                                OUTFDA.11
C                                                                                OUTFDA.12
C                                                                                OUTFDA.13
C        MDATE - DATE AND TIME OF OUTPUT FILE (INTEGER)                          OUTFDA.14
C                                                                                OUTFDA.15
C        NVOL39 - OUTPUT VOLUME FOR FDDA SFC FIELDS                              OUTFDA.16
C                                                                                OUTFDA.17
C        ICHK - QUALITY CHECK (INTEGER) FOR EACH SURFACE FIELD                   OUTFDA.18
C                                                                                OUTFDA.19
C                   0 = BAD;  INSUFFICIENT DATA FOR ANALYSIS, ETC.               OUTFDA.20
C                             CHECK NOBBOX ARRAY FOR DATA DISTRIBUTION.          OUTFDA.21
C                                                                                OUTFDA.22
C                   1 = GOOD ANALYSIS.                                           OUTFDA.23
C                                                                                OUTFDA.24
C        NSOB - NO. OF NONZERO GRID BOXES IN TOBBOX                              OUTFDA.25
C                                                                                OUTFDA.26
C        NMDTG - RUNNING TOTAL OF NUMBER OF MISSING DATE-TIME-GROUPS (SF         OUTFDA.27
C                                                                                OUTFDA.28
C                                                                                OUTFDA.29
C        DATA OUTPUT ORDER:                                                      OUTFDA.30
C                                                                                OUTFDA.31
C           SFC U (M/S)                                                          OUTFDA.32
C                                                                                OUTFDA.33
C           SFC V (M/S)                                                          OUTFDA.34
C                                                                                OUTFDA.35
C           SFC T (K)                                                            OUTFDA.36
C                                                                                OUTFDA.37
C           SFC MIX. RAT. (KG/KG)                                                OUTFDA.38
C                                                                                OUTFDA.39
C           PSTAR (CB):  PSL(TIME) - (PSL(00,12) - PSFC(00,12)) - PTOP           OUTFDA.40
C               ..... WHERE TIME = 00,03,06,... ETC.                             OUTFDA.41
C                                                                                OUTFDA.42
C           REL. HUM. (PERCENT)                                                  OUTFDA.43
C                                                                                OUTFDA.44
C           PSL (CB)                                                             OUTFDA.45
C                                                                                OUTFDA.46
C           TOBBOX:  (REAL) TOTAL OF OBS. PER GRID BOX (BASED ON FOUR            OUTFDA.47
C                    DOT-PTS AT CORNERS, CREATED IN SFCBLN).  NOTE -             OUTFDA.48
C                    IT IS ASSUMED THAT THERE IS LITTLE IMPORTANT                OUTFDA.49
C                    DIFFERENCE IN THE NO. OF OBS FOR DIFFERENT SFC.             OUTFDA.50
C                    VARIABLES, SO ONLY ONE TOBBOX FIELD IS USED.                OUTFDA.51
C                                                                                OUTFDA.52
C-----------------------------------------------------------------------         OUTFDA.53
#include <paramirb.incl>                                                         OUTFDA.54
#include <paramirs.incl>                                                         OUTFDA.55
#include <coma.incl>                                                             OUTFDA.56
#include <comc.incl>                                                             OUTFDA.57
#include <comd.incl>                                                             OUTFDA.58
#include <hedmif.incl>                                                           OUTFDA.59
C-----------------------------------------------------------------------         OUTFDA.60
      DIMENSION SLAB1(IS1,IS2),SLAB2(IS1,IS2),SLAB3(IS1,IS2),                    OUTFDA.61
     1 PDIF12(IS1,IS2),HORZH(IH1,IH2,IH3),ICHK(LCHK),SLAB4(MAXIC,MAXJC)          OUTFDA.62
      DIMENSION ISLAB(IS2)                                                       06NOV00.256
      character*24 MDATE, ISTRTDAT                                               OUTFDA.64
      integer SYY, SMO, SDY, SHR, SMI, SSC, SFR                                  OUTFDA.65
      logical lopened                                                            OUTFDA.66
C                                                                                OUTFDA.67
      DATA SVP1 /0.611/, SVP2 /19.84659/, SVP3 /5418.12/, EP2 /0.622/            OUTFDA.68
C                                                                                OUTFDA.69
      PRINT 10, MDATE(1:16)                                                      OUTFDA.70
10    FORMAT(//1X,'@@@@@@@@ CALL OUTFDA, MDATE = ',A16)                          OUTFDA.71
                                                                                 OUTFDA.72
      inquire(file='SFCFDDA_DOMAIN'//char(mif(13,1)+48), opened=lopened)         OUTFDA.73
      if (.not. lopened) then                                                    OUTFDA.74
         open(NVOL39, file='SFCFDDA_DOMAIN'//char(mif(13,1)+48),                 OUTFDA.75
     &        form='unformatted', status='unknown')                              OUTFDA.76
      endif                                                                      OUTFDA.77
                                                                                 OUTFDA.78
C****                                                                            OUTFDA.79
C DETERMINE ICHK BASED ON TOBBOX                                                 OUTFDA.80
      NSOB=0                                                                     OUTFDA.81
      L1=NVERT                                                                   OUTFDA.82
      ITBOX=IREFH                                                                OUTFDA.83
      CALL FILSLB(L1,ITBOX,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    OUTFDA.84
      DO I=1,IMAX                                                                OUTFDA.85
         DO J=1,JMAX                                                             OUTFDA.86
            IF(SLAB1(I,J).GT.0.5) NSOB=NSOB+1                                    OUTFDA.87
         ENDDO                                                                   OUTFDA.88
      ENDDO                                                                      OUTFDA.89
      IF(NSOB.LT.25) THEN                                                        OUTFDA.90
         NMDTG=NMDTG+1                                                           OUTFDA.91
         DO L=1,LCHK                                                             OUTFDA.92
            ICHK(L)=0                                                            OUTFDA.93
         ENDDO                                                                   OUTFDA.94
      ELSE                                                                       OUTFDA.95
         DO L=1,LCHK                                                             OUTFDA.96
            ICHK(L)=1                                                            OUTFDA.97
         ENDDO                                                                   OUTFDA.98
      ENDIF                                                                      OUTFDA.99
C****                                                                            OUTFDA.100
C       WRITE HEADER RECORD                                                      OUTFDA.101
      DO I = 1, MIFDIM1                                                          OUTFDA.102
         DO J = 1, MIFDIM2                                                       OUTFDA.103
            MIFSCR(I,J) = MIF(I,J)                                               OUTFDA.104
         ENDDO                                                                   OUTFDA.105
      ENDDO                                                                      OUTFDA.106
                                                                                 OUTFDA.107
      MRF(1,4) = INTF4D*3600.                                                    OUTFDA.108
      MRFC(1,4)='TIME DIFFERENCE (seconds) BETWEEN SURFACE ANALYSES'             OUTFDA.109
                                                                                 OUTFDA.110
      MIFSCR(1,1) = 4                                                            OUTFDA.111
      MIFC(1,1) = 'RAWINS SURFACE FDDA OUTPUT              '                     OUTFDA.112
     &        //  '                                        '                     OUTFDA.113
      MIFSCR(2,4)=MIF(2,3)                                                       OUTFDA.114
      MIFC(2,4)=MIFC(2,3)                                                        OUTFDA.115
      MIFSCR(3,4)=MIF(3,3)                                                       OUTFDA.116
      MIFC(3,4)=MIFC(3,3)                                                        OUTFDA.117
      MIFSCR(4,4)=MIF(4,3)                                                       OUTFDA.118
      MIFC(4,4)=MIFC(4,3)                                                        OUTFDA.119
                                                                                 OUTFDA.120
! PUT STARTING TIME IN RAWINS FDDA HEADER.                                       OUTFDA.121
      MIFSCR(5,4) = MIF(5,3)                                                     OUTFDA.122
      MIFC(5,4) = MIFC(5,3)                                                      OUTFDA.123
      MIFSCR(6,4) = MIF(6,3)                                                     OUTFDA.124
      MIFC(6,4) = MIFC(6,3)                                                      OUTFDA.125
      MIFSCR(7,4) = MIF(7,3)                                                     OUTFDA.126
      MIFC(7,4) = MIFC(7,3)                                                      OUTFDA.127
      MIFSCR(8,4) = MIF(8,3)                                                     OUTFDA.128
      MIFC(8,4) = MIFC(8,3)                                                      OUTFDA.129
      MIFSCR(9,4) = MIF(9,3)                                                     OUTFDA.130
      MIFC(9,4) = MIFC(9,3)                                                      OUTFDA.131
      MIFSCR(10,4) = MIF(10,3)                                                   OUTFDA.132
      MIFC(10,4) = MIFC(10,3)                                                    OUTFDA.133
      MIFSCR(11,4) = MIF(11,3)                                                   OUTFDA.134
      MIFC(11,4) = MIFC(11,3)                                                    OUTFDA.135
                                                                                 OUTFDA.136
      INDX = 12                                                                  OUTFDA.137
C                                                                                OUTFDA.138
      MIFSCR(8,1) = 0           ! RAWINS OUTPUT IS NOT EXPANDED                  OUTFDA.139
      if (IFILE .EQ. 1) THEN                                                     OUTFDA.140
         WRITE(NVOL39) bh_flag                                                   OUTFDA.141
         WRITE(NVOL39) MIFSCR,MRF,MIFC,MRFC                                      OUTFDA.142
      ENDIF                                                                      OUTFDA.143
      DO J = 1, MIFDIM2                                                          OUTFDA.144
      DO I = 1, MIFDIM1                                                          OUTFDA.145
         IF (MIFSCR(I,J).NE.-999) PRINT7754,I,J,MIFSCR(I,J),MIFC(I,J)            OUTFDA.146
 7754    FORMAT('MIF(',I3,',',I1,') = ',I10,' : ',A80)                           OUTFDA.147
      ENDDO                                                                      OUTFDA.148
      DO I = 1, MRFDIM1                                                          OUTFDA.149
         IF (MRF(I,J).NE.-999.) PRINT7756,I,J,MRF(I,J),MRFC(I,J)                 OUTFDA.150
 7756    FORMAT('MRF(',I3,',',I1,') =',F10.4,' : ',A80)                          OUTFDA.151
      ENDDO                                                                      OUTFDA.152
      ENDDO                                                                      OUTFDA.153
      WRITE(NVOL99)MDATE,ICHK                                                    OUTFDA.154
      PRINT 20, (ICHK(I),I=1,LCHK),NSOB                                          OUTFDA.155
20    FORMAT(' ',10X,'QUALITY CHECK ARRAY, ICHK(I)=',8I5,' NSOB=',I5)            OUTFDA.156
C                                                                                OUTFDA.157
C------WRITE SURFACE WINDS AT DOT POINTS                                         OUTFDA.158
      L1=NVERT                                                                   OUTFDA.159
      ISFCU=IREFPC                                                               OUTFDA.160
      ISFCV=IREFPD                                                               OUTFDA.161
      CALL FILSLB(L1,ISFCU,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    OUTFDA.162
      write(nvol39) sh_flag                                                      OUTFDA.163
      WRITE(NVOL39) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                       OUTFDA.164
     &     'D   ', 'YX  ', mdate,                                                OUTFDA.165
     &     'U        m/s                      U COMP'                            OUTFDA.166
     &  // 'ONENT OF SURFACE WIND (2-D FIELD)       '                            OUTFDA.167
      CALL WTAPE(1,ISFCU,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)             OUTFDA.168
                                                                                 OUTFDA.169
      CALL FILSLB(L1,ISFCV,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    OUTFDA.170
      write(nvol39) sh_flag                                                      OUTFDA.171
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.172
     &     'D   ', 'YX  ', mdate,                                                OUTFDA.173
     &     'V        m/s                      V COMP'                            OUTFDA.174
     &  // 'ONENT OF SURFACE WIND (2-D FIELD)       '                            OUTFDA.175
      CALL WTAPE(1,ISFCV,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)             OUTFDA.176
                                                                                 OUTFDA.177
C                                                                                OUTFDA.178
C         WRITE SURFACE TEMPERATURE AT CROSS POINTS (NO ATTEMPT TO ADJUS         OUTFDA.179
C         FOR SUPER-ADIABATIC LAYERS)                                            OUTFDA.180
      CALL FILSLB(1,IREFT,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                     OUTFDA.181
C         CONVERT TO KELVIN FROM CELCIUS                                         OUTFDA.182
      DO I=1,IMAX                                                                OUTFDA.183
         DO J=1,JMAX                                                             OUTFDA.184
            SLAB1(I,J)=SLAB1(I,J)+273.15                                         OUTFDA.185
         ENDDO                                                                   OUTFDA.186
      ENDDO                                                                      OUTFDA.187
      write(nvol39) sh_flag                                                      OUTFDA.188
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.189
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.190
     &     'T        K                        SURFAC'                            OUTFDA.191
     & //  'E TEMPERATURE (2-D FIELD)               '                            OUTFDA.192
      CALL WTAPE(1,IREFT,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,-1)            OUTFDA.193
C                                                                                OUTFDA.194
C---------FIND SFC. SAT. MIX. RATIO (CROSS PTS.)                                 OUTFDA.195
C         FIRST ESTIMATE SURFACE PRESSURE AT TIME=MDATE.                         OUTFDA.196
      CALL FILSLB(2,IREFPC,1,HORZH,IH1,IH2,IH3,SLAB2,IS1,IS2)                    OUTFDA.197
      DO I=1,IMAX                                                                OUTFDA.198
         DO J=1,JMAX                                                             OUTFDA.199
C         SFC. PRES. APPROX. EQUAL TO SEA-LEVEL PRES. MINUS PDIF12 (CB)          OUTFDA.200
            SLAB2(I,J)=(SLAB2(I,J)-PDIF12(I,J))/10.                              OUTFDA.201
            ES=SVP1*EXP(SVP2-SVP3/SLAB1(I,J))                                    OUTFDA.202
            SLAB1(I,J)=EP2*ES/(SLAB2(I,J)-ES)                                    OUTFDA.203
         ENDDO                                                                   OUTFDA.204
      ENDDO                                                                      OUTFDA.205
C                                                                                OUTFDA.206
C---------FIND AND WRITE SURFACE MIXING RATIO AT CROSS PTS                       OUTFDA.207
      CALL FILSLB(1,IREFRH,1,HORZH,IH1,IH2,IH3,SLAB3,IS1,IS2)                    OUTFDA.208
      DO I=1,IMAX                                                                OUTFDA.209
         DO J=1,JMAX                                                             OUTFDA.210
            SLAB1(I,J)=SLAB3(I,J)*SLAB1(I,J)/100.                                OUTFDA.211
         ENDDO                                                                   OUTFDA.212
      ENDDO                                                                      OUTFDA.213
      write(nvol39) sh_flag                                                      OUTFDA.214
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.215
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.216
     &     'Q        kg/kg                    SURFAC'                            OUTFDA.217
     & //  'E MIXING RATIO (2-D FIELD)              '                            OUTFDA.218
      CALL WTAPE(2,IREFRH,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)            OUTFDA.219
C                                                                                OUTFDA.220
C---------FIND AND WRITE PSTAR AT CROSS POINTS                                   OUTFDA.221
      DO I=1,IMAX                                                                OUTFDA.222
         DO J=1,JMAX                                                             OUTFDA.223
            SLAB2(I,J)=(SLAB2(I,J)-PTOP/10.)*1.E3                                OUTFDA.224
         ENDDO                                                                   OUTFDA.225
      ENDDO                                                                      OUTFDA.226
      write(nvol39) sh_flag                                                      OUTFDA.227
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.228
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.229
     &     'PSTARCRS Pa                       SURFAC'                            OUTFDA.230
     & //  'E PRESSURE MINUS PTOP                   '                            OUTFDA.231
      CALL WTAPE(1,IREFPC,SLAB2,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)            OUTFDA.232
C                                                                                OUTFDA.233
C---------WRITE SURFACE RELATIVE HUMIDITY AT CROSS PTS.                          OUTFDA.234
      write(nvol39) sh_flag                                                      OUTFDA.235
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.236
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.237
     &     'RH       %                        SURFAC'                            OUTFDA.238
     & //  'E RELATIVE HUMIDITY (2-D FIELD)         '                            OUTFDA.239
      CALL WTAPE(1,IREFRH,SLAB3,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)            OUTFDA.240
C                                                                                OUTFDA.241
C---------WRITE SEA-LEVEL PRESSURE AT CROSS PTS.                                 OUTFDA.242
      CALL FILSLB(2,IREFPC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    OUTFDA.243
      DO I=1,IMAX                                                                OUTFDA.244
         DO J=1,JMAX                                                             OUTFDA.245
            SLAB1(I,J)=SLAB1(I,J)*1.E2                                           OUTFDA.246
         ENDDO                                                                   OUTFDA.247
      ENDDO                                                                      OUTFDA.248
      write(nvol39) sh_flag                                                      OUTFDA.249
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.250
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.251
     &     'PSEALVLC Pa                       SEA-LE'                            OUTFDA.252
     & //  'VEL PRESSURE                            '                            OUTFDA.253
      CALL WTAPE(2,IREFPC,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,-2)           OUTFDA.254
C                                                                                OUTFDA.255
C---------WRITE TOBBOX, THE DATA-DENSITY ARRAY (CALCULATED IN SFCBLN)            OUTFDA.256
      L1=NVERT                                                                   OUTFDA.257
      ITBOX=IREFH                                                                OUTFDA.258
      CALL FILSLB(L1,ITBOX,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    OUTFDA.259
      write(nvol39) sh_flag                                                      OUTFDA.260
      write(nvol39)2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                        OUTFDA.261
     &     'C   ', 'YX  ', mdate,                                                OUTFDA.262
     &     'TOBBOX   OBSERVATIONS             OBSERV'                            OUTFDA.263
     & //  'ATION DENSITY                           '                            OUTFDA.264
      CALL WTAPE(L1,ITBOX,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL39,3,0)            OUTFDA.265
C                                                                                OUTFDA.266
C---------PRINT OUT NO. OF OBS PER GRID BOX - SHORT FORM                         OUTFDA.267
      PRINT 120                                                                  OUTFDA.268
120   FORMAT(' TOTAL NO. OF OBS. PER BOX -- SHORT FORM',///)                     OUTFDA.269
      DO II=1,IMAX                                                               OUTFDA.270
         I=IMAX+1-II                                                             OUTFDA.271
         DO J=1,JMAX                                                             OUTFDA.272
            ISLAB(J)=SLAB1(I,J)                                                  OUTFDA.273
         ENDDO                                                                   OUTFDA.274
         PRINT 140, (ISLAB(J),J=1,JMAX)                                          OUTFDA.275
      ENDDO                                                                      OUTFDA.276
140   FORMAT(1X,1000I1)                                                          06NOV00.257
      PRINT 150                                                                  OUTFDA.278
150   FORMAT(' ',///)                                                            OUTFDA.279
                                                                                 OUTFDA.280
      DO I = 1, MRFDIM1                                                          OUTFDA.281
         MRF(I,4) = -999.                                                        OUTFDA.282
      ENDDO                                                                      OUTFDA.283
                                                                                 OUTFDA.284
      print*, 'Writing eot_flag to nvol39'                                       OUTFDA.285
      write(nvol39) eot_flag                                                     OUTFDA.286
      END                                                                        OUTFDA.287
