      SUBROUTINE PROBGU(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,ISIGW,         PROBGU.1
     1                  ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,KREMEN,         PROBGU.2
     2                  DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MDATE,ISI)            PROBGU.3
C                                                                                PROBGU.4
C                                                                                PROBGU.5
C-----------------------------------------------------------------------         PROBGU.6
C                                                                                PROBGU.7
C      PURPOSE:  THIS SUBROUTINE PRE-PROCESSES BOGUS UPPER-AIR SOUNDINGS         PROBGU.8
C                PRIOR TO THE OBJECTIVE ANALYSIS STEP                            PROBGU.9
C                                                                                PROBGU.10
C                                                                                PROBGU.11
C-----------------------------------------------------------------------         PROBGU.12
#include <paramirb.incl>                                                         PROBGU.13
#include <paramirs.incl>                                                         PROBGU.14
#include <coma.incl>                                                             PROBGU.15
#include <comb.incl>                                                             PROBGU.16
#include <comc.incl>                                                             PROBGU.17
C-----------------------------------------------------------------------         PROBGU.18
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                            PROBGU.19
      DIMENSION DATAS(IDS1,IDS2,IDS3),SLAB1(IS1,IS2)                             PROBGU.20
C                                                                                PROBGU.21
C-----------------------------------------------------------------------         PROBGU.22
C                                                                                PROBGU.23
C      NOTES:                                                                    PROBGU.24
C        1. BOGUS DATA IN JOBDECK:  THE BOGUS DATA IS INSERTED INTO              PROBGU.25
C             THE JOB DECK AS A SEPARATE FILE, MARKED BY \EOF,                   PROBGU.26
C             IMMEDIATELY FOLLOWING THE MASTER INPUT FILE.                       PROBGU.27
C        2. ERRORS IN BOGUS DATA:  RAWINS ASSUMES ALL BOGUS DATA IS              PROBGU.28
C             CORRECT.  THIS ALLOWS THE USER  TO OVERRIDE A POOR FIRST           PROBGU.29
C             GUESS WITHOUT DATA-REJECTION, BUT THE USER IS RESPONSIBLE          PROBGU.30
C             FOR THE ACCURACY OF THE BOGUS DATA.                                PROBGU.31
C        3. DATA TYPES:  THE BOGUS SOUNDINGS ARE TO BE WRITTEN IN A FORM         PROBGU.32
C             CLOSELY SIMILAR TO THE REAL DATA.  THAT IS, A BLOCK OF             PROBGU.33
C             MANDATORY LEVEL DATA PRECEEDS A BLOCK OF SIGNIFICANT               PROBGU.34
C             LEVEL DATA .  THE SIGNIFICANT LEVELS CAN BE AT ANY                 PROBGU.35
C             PRESSURE, BUT THERE WILL BE LESS AMBIGUITY IF VERTICAL             PROBGU.36
C             INTERPOLATIONS ARE AVOIDED BY DEFINING THE BOGUS                   PROBGU.37
C             SIGNIFICANT LEVELS TO BE THE SAME AS THE NON-STANDARD              PROBGU.38
C             ANALYSIS LEVELS, READ INTO GNLVL FROM THE MASTER INPUT             PROBGU.39
C             FILE.                                                              PROBGU.40
C        4. SEA-LEVEL PRESSURE:  UNLIKE THE PREVIOUS RAWINS VERSIONS,            PROBGU.41
C             THE PRESSURE VALUE OF BOGUS SOUNDINGS IS SUPPLIED AS SEA-          PROBGU.42
C             LEVEL PRESSURE, NOT SURFACE PRESSURE.  STATION ELEVATION           PROBGU.43
C             SHOULD BE ESTIMATED FROM THE ANALYZED TERRAIN.  SUBROUTINE         PROBGU.44
C             SEAPRS WILL CONVERT BOGUS SEA-LEVEL PRESSURE TO SURFACE            PROBGU.45
C             PRESSURE.                                                          PROBGU.46
C        5. END OF DATA:  SET NDATE=999 ON THE LAST READ IMAGE FOR A             PROBGU.47
C             GIVEN DATE AND TIME TO DESIGNATE THE END OF UPPER-LEVEL            PROBGU.48
C             DATA FOR THAT TIME.  IF NBOGUS(IFIL)=.T., NDATE=999 MUST           PROBGU.49
C             APPEAR EVEN IF NO SURFACE DATA ARE USED, BEFORE BEGINNING          PROBGU.50
C             BOGUS DATA FOR THE NEXT DATE AND TIME. ALSO REFER TO NOTES         PROBGU.51
C             IN PROBGS.                                                         PROBGU.52
C        6. BOGUS DATA FORMAT:  SEE STATEMENT NO. 10 BELOW                       PROBGU.53
C        7. BOGUS DATA INPUT UNITS: P(MB), Z(M), T(C),                           PROBGU.54
C             H(DEWPT. DEPR.(C)), WIND(DEGREES,M/S)                              PROBGU.55
C        8. BOGUS ELEVATION:  WILL BE AUTOMATICALLY CALCULATED FROM THE          PROBGU.56
C             LAT., LONG., AND ANALYZED TERRAIN.                                 PROBGU.57
C                                                                                PROBGU.58
C-----------------------------------------------------------------------         PROBGU.59
C                                                                                PROBGU.60
C                                                                                PROBGU.61
C                                                                                PROBGU.62
C                                                                                PROBGU.63
      CHARACTER*8 IBOGUS                                                         PROBGU.64
      CHARACTER*(24) MDATE, NDATE                                                PROBGU.65
      NVOL13=13                                                                  PROBGU.66
      KSKIP=0                                                                    PROBGU.67
C                                                                                PROBGU.68
C---------BEGIN PROCESSOR LOOP; MAXIMUM IS 999 BOGUS SOUNDING PER TIME           PROBGU.69
C         PERIOD.                                                                PROBGU.70
      DO 230 I=1,999                                                             PROBGU.71
C                                                                                PROBGU.72
C---------INDEX K=1 FOR MAND.-DATA BLOCK; =2 FOR SIGN.-DATA BLOCK                PROBGU.73
      DO 200 K=1,2                                                               PROBGU.74
      IF(KSKIP.GT.0)GO TO 30                                                     PROBGU.75
C---------*** BOGUS DATA FORMAT ***                                              PROBGU.76
C---------SET NDATE=999 ON LAST READ IMAGE FOR END-OF-DATA DESIGNATION.          PROBGU.77
      READ (NVOL13,10,IOSTAT=IERR) NDATE(1:16),IBOGUS,IMAN,KLV,YLAT,YLON         PROBGU.78
      if (ierr .ne. 0) then                                                      PROBGU.79
         write(*,122)                                                            PROBGU.80
 122     format(//,'************************************************',/,         PROBGU.81
     &        '*****',/,                                                         PROBGU.82
     &        '***** Error reading NBOGUS file, unit 13.',/,                     PROBGU.83
     &   '***** Check that the file exists and is properly formatted.',          PROBGU.84
     &        /,'*****',/,                                                       PROBGU.85
     &        '************************************************',// )            PROBGU.86
         call abort                                                              PROBGU.87
      endif                                                                      PROBGU.88
      NDATE(17:24) = ':00.0000'                                                  PROBGU.89
10    FORMAT(22X,A16,1X,A5,2I3,2F8.2)                                            PROBGU.90
C                                                                                PROBGU.91
C                                                                                PROBGU.92
      KLAT=NINT(YLAT*10.)                                                        PROBGU.93
      KLON=NINT(YLON*10.)                                                        PROBGU.94
      ELEV=-999.                                                                 PROBGU.95
      KELEV=ELEV                                                                 PROBGU.96
      IF(NDATE(1:3).EQ.'999')RETURN                                              PROBGU.97
      SSTA=IBOGUS                                                                PROBGU.98
C                                                                                PROBGU.99
C---------COMPARE DATE OF BOGUS REPORT WITH DATE FROM MASTER INPUT FILE.         PROBGU.100
      IF(NDATE.NE.MDATE)THEN                                                     PROBGU.101
      PRINT 20                                                                   PROBGU.102
      PRINT 21, NDATE(1:16), MDATE(1:16)                                         PROBGU.103
 21   FORMAT('NDATE =',A16,' MDATE =',A16)                                       PROBGU.104
20    FORMAT(10X,'WARNINGS -- BOGUS DATE DOES NOT MATCH MASTER INPUT',           PROBGU.105
     1 'FILE DATE...  BOGUS UPPER AIR REPORT BYPASSED.')                         PROBGU.106
      GO TO 200                                                                  PROBGU.107
      END IF                                                                     PROBGU.108
      IF(K.EQ.2.AND.IMAN.GE.0)GO TO 160                                          PROBGU.109
      IF(K.EQ.1.AND.IMAN.LT.0)GO TO 210                                          PROBGU.110
30    IF(IMAN.GE.0)NLV=KLV                                                       PROBGU.111
      IF(IMAN.LT.0)MLV=KLV                                                       PROBGU.112
      KSKIP=0                                                                    PROBGU.113
      PRINT 35                                                                   PROBGU.114
35    FORMAT(1X,'-----------------------------------------------------',         PROBGU.115
     1'--------------------')                                                    PROBGU.116
      PRINT 40,IBOGUS,NDATE(1:16)                                                PROBGU.117
 40   FORMAT(1H0,'BOGUS UPPER-AIR STATION REPORT',1X,A5,5X,'DATE=',A16)          PROBGU.118
      IF(.NOT.BOGPRT)GO TO 50                                                    PROBGU.119
      WRITE(6,10) NDATE(1:16),IBOGUS,IMAN,KLV,YLAT,YLON                          PROBGU.120
      IF(IMAN.GE.0)PRINT 60                                                      PROBGU.121
      IF(IMAN.LT.0)PRINT 70                                                      PROBGU.122
50    CONTINUE                                                                   PROBGU.123
60    FORMAT(5X,'MANDATORY LEVEL DATA')                                          PROBGU.124
70    FORMAT(5X,'SIGNIFICANT LEVEL DATA')                                        PROBGU.125
      IF(KLV.GT.1)GO TO 110                                                      PROBGU.126
      IF(IMAN.LT.0)GO TO 90                                                      PROBGU.127
      PRINT 80,IBOGUS,NLV                                                        PROBGU.128
80    FORMAT(10X,'BOGUS STATION=',A5,2X,'HAS NLV=',I3,2X,'MANDATORY',            PROBGU.129
     1 ' LEVELS.  GO TO NEXT STATION.')                                          PROBGU.130
      GO TO 210                                                                  PROBGU.131
90    IF(MLV.GT.0)GO TO 110                                                      PROBGU.132
      IF(ISNDGS) PRINT 100,IBOGUS,MLV                                            PROBGU.133
100   FORMAT(10X,'BOGUS STATION=',A5,2X,'HAS MLV=',I3,2X,'SIGNIFICANT',          PROBGU.134
     1 ' LEVELS.')                                                               PROBGU.135
      GO TO 170                                                                  PROBGU.136
110   IF(BOGPRT)PRINT 120                                                        PROBGU.137
120   FORMAT(18X,'LVL',4X,'PRES(MB)',5X,'HGT(M)',6X,'TEMP(C)',3X,                PROBGU.138
     1 'DEW DEPR.(C)',2X,'WIND DIR.(DEG)',2X,'WIND SPD(KT)',3X,'Q(I)')           PROBGU.139
      DO 150 NN=1,KLV                                                            PROBGU.140
C                                                                                PROBGU.141
C---------CAUTION:  INPUT DATA UNITS -- SEE NOTE 7, ABOVE.                       PROBGU.142
      READ (NVOL13,130) P(NN),Z(NN),T(NN),H(NN),D(NN),F(NN)                      PROBGU.143
130   FORMAT(10X,6F10.1)                                                         PROBGU.144
      IF(F(NN).LT.900.)F(NN)=1.944*F(NN)                                         PROBGU.145
      IF(BOGPRT)PRINT 140,NN,P(NN),Z(NN),T(NN),H(NN),D(NN),F(NN)                 PROBGU.146
140   FORMAT(15X,I5,6F12.1,5X)                                                   PROBGU.147
150   CONTINUE                                                                   PROBGU.148
      IF(K.EQ.2)GO TO 170                                                        PROBGU.149
C                                                                                PROBGU.150
C---------SET UP STORAGE-IDENTIFIERS BY CALLING INACCT (K=1 PASS ONLY)           PROBGU.151
      CALL INACCT(ID1,ID3,ISTATN,IBOGUS,IDF,NSTA,ALRAWS,2,KLAT,KLON,             PROBGU.152
     1            KELEV,JSTATN,IDS3)                                             PROBGU.153
      CALL SAVSTN(DATAH,ID1,ID2,ID3,ITOSS,IMAND,KTOPPR,KMANPR,KSIGPR,            PROBGU.154
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROBGU.155
     2            IS2,ISI)                                                       PROBGU.156
      GO TO 180                                                                  PROBGU.157
160   KSKIP=1                                                                    PROBGU.158
170   CALL SAVSTN(CORRH,ID1,ID2,ID3,ITOSS,ISIGW,KTOPPR,KMANPR,KSIGPR,            PROBGU.159
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROBGU.160
     2            IS2,ISI)                                                       PROBGU.161
180   CONTINUE                                                                   PROBGU.162
      IF(MOD(ISTATN,ID3).NE.0)GO TO 200                                          PROBGU.163
      IF(ITOSS.GT.0)GO TO 200                                                    PROBGU.164
      IF(K.EQ.2.OR.KSKIP.EQ.1)GO TO 190                                          PROBGU.165
C         SAVE FULL FILE OF MANDATORY LEVEL DATA                                 PROBGU.166
      CALL SAVFIL(DATAH,ID1,ID2,ID3,ISTATN,IMAND,IDS3)                           PROBGU.167
      GO TO 200                                                                  PROBGU.168
C         SAVE FULL FILE OF SIGNIFICANT LEVEL DATA                               PROBGU.169
190   CALL SAVFIL(CORRH,ID1,ID2,ID3,ISTATN,ISIGW,IDS3)                           PROBGU.170
200   CONTINUE                                                                   PROBGU.171
      GO TO 230                                                                  PROBGU.172
C                                                                                PROBGU.173
C---------WHEN PROBGU DETECTS INCONSISTENT ORDER OF MAND. AND SIGN.              PROBGU.174
C         LEVEL DATA BLOCKS, THE FOLLOWING LOOP IS EXECUTED TO READ              PROBGU.175
C         PAST THE CURRENT BLOCK.  THEN, EXECUTION CONTINUES.                    PROBGU.176
210   DO 220 NN=1,KLV                                                            PROBGU.177
      READ (NVOL13,130)  DUM1,DUM2,DUM3,DUM4,DUM5,DUM6                           PROBGU.178
220   CONTINUE                                                                   PROBGU.179
      READ (NVOL13,10) NDATE(1:16),IBOGUS,IMAN,KLV,YLAT,YLON                     PROBGU.180
      ndate(17:24) = ':00.0000'                                                  PROBGU.181
      KLAT=NINT(YLAT*10.)                                                        PROBGU.182
      KLON=NINT(YLON*10.)                                                        PROBGU.183
      KELEV=ELEV                                                                 PROBGU.184
      IF(NDATE(1:3).EQ.'999')RETURN                                              PROBGU.185
      SSTA=IBOGUS                                                                PROBGU.186
      IF(NDATE.NE.MDATE)THEN                                                     PROBGU.187
      PRINT 20                                                                   PROBGU.188
      GO TO 230                                                                  PROBGU.189
      END IF                                                                     PROBGU.190
      IF(IMAN.LT.0)GO TO 210                                                     PROBGU.191
      KSKIP=2                                                                    PROBGU.192
230   CONTINUE                                                                   PROBGU.193
C                                                                                PROBGU.194
C---------MAX. NO. OF UPPER-AIR BOGUS STATIONS HAS BEEN PROCESSED.               PROBGU.195
C         WARNING -- THIS MAY CAUSE TROUBLE, SINCE DELINEATOR                    PROBGU.196
C         (NDATE=999) HAS NOT BEEN FOUND.                                        PROBGU.197
C                                                                                PROBGU.198
      RETURN                                                                     PROBGU.199
      END                                                                        PROBGU.200
