      SUBROUTINE PROUPR(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,                     PROUPR.1
     1                  ISIGT,ISIGW,ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,           PROUPR.2
     2                  KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,            PROUPR.3
     3                  IS2,MAXLEV,ISI)                                          PROUPR.4
C                                                                                PROUPR.5
C                                                                                PROUPR.6
C-----------------------------------------------------------------------         PROUPR.7
C                                                                                PROUPR.8
C      PURPOSE:  THIS SUBROUTINE PRE-PROCESSES UPPER-AIR DATA PRIOR TO           PROUPR.9
C                THE OBJECTIVE ANALYSIS PHASE OF RAWINS.                         PROUPR.10
C                                                                                PROUPR.11
C-----------------------------------------------------------------------         PROUPR.12
#include <paramirb.incl>                                                         PROUPR.13
#include <paramirs.incl>                                                         PROUPR.14
#include <coma.incl>                                                             PROUPR.15
#include <comb.incl>                                                             PROUPR.16
#include <comc.incl>                                                             PROUPR.17
C-----------------------------------------------------------------------         PROUPR.18
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                            PROUPR.19
      DIMENSION DATAS(IDS1,IDS2,IDS3),SLAB1(IS1,IS2)                             PROUPR.20
      DIMENSION STDHT(20,2),PP(60),DP(60),FP(60)                                 PROUPR.21
      DATA STDHT(1,1)/1000./,STDHT(2,1)/850./,STDHT(3,1)/700./,                  PROUPR.22
     1     STDHT(4,1)/500./, STDHT(5,1)/400./,STDHT(6,1)/300./,                  PROUPR.23
     2     STDHT(7,1)/250./, STDHT(8,1)/200./,STDHT(9,1)/150./,                  PROUPR.24
     3     STDHT(10,1)/100./,STDHT(11,1)/70./,STDHT(12,1)/50./                   PROUPR.25
     4     ,STDHT(13,1)/30./,STDHT(14,1)/20./,STDHT(15,1)/10./                   PROUPR.26
C                                                                                PROUPR.27
C---------PROCESS AIRCRAFT REPORTS:  PRINT ONLY; RAWINS IS NOT                   PROUPR.28
C         CURRENTLY ABLE TO INCLUDE THESE DATA IN THE OBJECTIVE                  PROUPR.29
C         ANALYSIS.                                                              PROUPR.30
      IF(IRTYP.LE.23)GO TO 140                                                   PROUPR.31
70    FORMAT(6X,'IREC=',I5,2X,'IRTYP=',I4,2X,'INSTYP=',I4,2X,'IYR=',I5,          PROUPR.32
     1 2X,'IMO=',I3,2X,'IDY=',I3,2X,'IHR=',I3,3X,'TIME=',F6.2,2X,                PROUPR.33
     2 'SSTA=',A6,'...'/5X,'YLAT=',F10.2,2X,'YLON=',F10.2,2X,'ELEV=',            PROUPR.34
     3 F10.2)                                                                    PROUPR.35
      RETURN                                                                     PROUPR.36
C                                                                                PROUPR.37
140   CONTINUE                                                                   PROUPR.38
C                                                                                PROUPR.39
C---------A DESIRABLE UPPER-AIR SOUNDING HAS BEEN FOUND.                         PROUPR.40
C---------UNPACK DATA, IF IUPPER=TRUE                                            PROUPR.41
      IF(.NOT.IUPPER)RETURN                                                      PROUPR.42
C                                                                                PROUPR.43
C---------SET UP STORAGE-IDENTIFIERS BY CALLING INACCT                           PROUPR.44
      KLAT=NINT(YLAT*10.)                                                        PROUPR.45
      KLON=NINT(YLON*10.)                                                        PROUPR.46
**                                                                               PROUPR.47
      KELEV=ELEV                                                                 PROUPR.48
      CALL INACCT(ID1,ID3,ISTATN,SSTA,IDF,NSTA,ALRAWS,1,KLAT,KLON,KELEV,         PROUPR.49
     1            JSTATN,IDS3)                                                   PROUPR.50
      IF(NPRINT.EQ.1)GO TO 160                                                   PROUPR.51
      IOBTYP=4HSHIP                                                              PROUPR.52
      IF(IRTYP.LE.13)IOBTYP=4HLAND                                               PROUPR.53
      PRINT 150,ISTATN,IOBTYP                                                    PROUPR.54
150   FORMAT(1H0,'UPPER AIR STATION REPORT NO.',I4,62X,A4,2X,'DATA')             PROUPR.55
      PRINT 70,IREC,IRTYP,INSTYP,IYR,IMO,IDY,IHR,TIME,SSTA,YLAT,YLON,            PROUPR.56
     1 ELEV                                                                      PROUPR.57
160   CONTINUE                                                                   PROUPR.58
C                                                                                PROUPR.59
C---------ACCESS MANDATORY LEVEL DATA                                            PROUPR.60
C                                                                                PROUPR.61
      LJTYP=1                                                                    PROUPR.62
      IF(UNIOBS) CALL  UNIUP(NVOLUP,P,Z,T,H,D,F,PP,DP,FP,LTHERM,                 PROUPR.63
     1                       LWND,LJTYP,NLV)                                     PROUPR.64
      IF(.NOT.UNIOBS) CALL MANADP(P,Z,T,H,D,F,Q,NLV,MAXLEV)                      PROUPR.65
      IF(NLV.GT.1)GO TO 170                                                      PROUPR.66
      KMANPR=1                                                                   PROUPR.67
      ISTATN=ISTATN-1                                                            PROUPR.68
      GO TO 230                                                                  PROUPR.69
170   CONTINUE                                                                   PROUPR.70
      IF(ISNDGS)PRINT 180,ISTATN,NLV                                             PROUPR.71
180   FORMAT(10X,'MANDATORY LEVEL DATA FOR THE',I3,'-TH STATION FOUND,',         PROUPR.72
     1 ' WHICH HAS',I3,' LEVELS')                                                PROUPR.73
      IF(ISNDGS)PRINT 190                                                        PROUPR.74
190   FORMAT(18X,'LVL',4X,'PRES(MB)',5X,'HGT(M)',6X,'TEMP(C)',3X,                PROUPR.75
     1 'DEW DEPR.(C)',2X,'WIND DIR.(DEG)',2X,'WIND SPD(KT)',3X,'Q(I)')           PROUPR.76
      DO 200 L=1,NVERT                                                           PROUPR.77
200   STDHT(L,2)=1.0E33                                                          PROUPR.78
      STDHT(1,1)=1.0E33                                                          PROUPR.79
      DO 220 I=1,NLV                                                             PROUPR.80
      IF(P(I).LT.PTOP-0.01)GO TO 220                                             PROUPR.81
      IF(ISNDGS) PRINT 210,I,P(I),Z(I),T(I),H(I),D(I),F(I)                       PROUPR.82
  210 FORMAT(15X,I5,5F12.1,6X,F12.1)                                             PROUPR.83
      IF(Z(I).LT.60000.)STDHT(I,2)=Z(I)                                          PROUPR.84
220   CONTINUE                                                                   PROUPR.85
      IF(NOBLND)GO TO 230                                                        PROUPR.86
      CALL SAVSTN(DATAH,ID1,ID2,ID3,ITOSS,IMAND,KTOPPR,KMANPR,KSIGPR,            PROUPR.87
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROUPR.88
     2            IS2,ISI)                                                       PROUPR.89
      IF(ISTATN.EQ.0)RETURN                                                      PROUPR.90
      IF(MOD(ISTATN,ID3).NE.0)GO TO 230                                          PROUPR.91
C        SAVE FULL FILE OF MANDATORY LEVEL DATA.                                 PROUPR.92
      CALL SAVFIL(DATAH,ID1,ID2,ID3,ISTATN,IMAND,IDS3)                           PROUPR.93
230   CONTINUE                                                                   PROUPR.94
C                                                                                PROUPR.95
C---------ACCESS SIGNIFICANT LEVEL TEMP. AND MOISTURE DATA;                      PROUPR.96
C         (RETAIN IF NNEWPL .GT. 0)                                              PROUPR.97
C                                                                                PROUPR.98
      LJTYP=2                                                                    PROUPR.99
      IF(UNIOBS) CALL  UNIUP(NVOLUP,P,Z,T,H,D,F,PP,DP,FP,LTHERM,                 PROUPR.100
     1                       LWND,LJTYP,MLV)                                     PROUPR.101
      IF(.NOT.UNIOBS) CALL SIGADP(P,T,H,Q,MLV,MAXLEV)                            PROUPR.102
      IF(MLV.GE.1)GO TO 240                                                      PROUPR.103
      KSIGPR=1                                                                   PROUPR.104
      GO TO 300                                                                  PROUPR.105
240   CONTINUE                                                                   PROUPR.106
      IF(ISNDGS)PRINT 250,MLV                                                    PROUPR.107
250   FORMAT(1H0,10X,'SIGNIFICANT LEVEL TEMPERATURE AND MOISTURE DATA',          PROUPR.108
     1 4X,'TOTAL OF',I3,' LEVELS')                                               PROUPR.109
      IF(ISNDGS)PRINT 260                                                        PROUPR.110
260   FORMAT(18X,'LVL',4X,'PRES(MB)',5X,'TEMP(C)',3X,'DEW DEPR.(C)',             PROUPR.111
     1 4X,'Q(I)')                                                                PROUPR.112
      DO 280 I=1,MLV                                                             PROUPR.113
      IF(P(I).LE.PMANMN)GO TO 290                                                PROUPR.114
      IF(ISNDGS) PRINT 270,I,P(I),T(I),H(I)                                      PROUPR.115
      IF(I.EQ.1)STDHT(1,1)=P(I)                                                  PROUPR.116
280   CONTINUE                                                                   PROUPR.117
290   CONTINUE                                                                   PROUPR.118
      IF(NLV.LE.1.OR.NOBLND)GO TO 300                                            PROUPR.119
      CALL SAVSTN(CORRH,ID1,ID2,ID3,ITOSS,ISIGT,KTOPPR,KMANPR,KSIGPR,            PROUPR.120
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROUPR.121
     2            IS2,ISI)                                                       PROUPR.122
C                                                                                PROUPR.123
C---------ACCESS SIGNIFICANT LEVEL WIND DATA;                                    PROUPR.124
C         (RETAIN IF NNEWPL .GT. 0)                                              PROUPR.125
300   DO 310 I=1,60                                                              PROUPR.126
      PP(I)=1.E33                                                                PROUPR.127
310   P(I)=1.E33                                                                 PROUPR.128
      MLVT=0                                                                     PROUPR.129
C                                                                                PROUPR.130
C---------WIND BY PRESSURE LEVELS                                                PROUPR.131
      LJTYP=3                                                                    PROUPR.132
      IF(UNIOBS) CALL  UNIUP(NVOLUP,P,Z,T,H,D,F,PP,DP,FP,LTHERM,                 PROUPR.133
     1                       LWND,LJTYP,MLV)                                     PROUPR.134
      IF(.NOT.UNIOBS) CALL WPPADP(PP,DP,FP,Q,MLV,MAXLEV)                         PROUPR.135
      IF(MLV.GE.1)GO TO 320                                                      PROUPR.136
      KWINDP=1                                                                   PROUPR.137
      GO TO 360                                                                  PROUPR.138
320   CONTINUE                                                                   PROUPR.139
      IF(ISNDGS)PRINT 330,MLV                                                    PROUPR.140
330   FORMAT(10X,'SIGNIFICANT LEVEL WIND DATA',25X,'TOTAL OF',I3,                PROUPR.141
     1 'LEVELS')                                                                 PROUPR.142
      IF(ISNDGS)PRINT 340                                                        PROUPR.143
340   FORMAT(18X,'LVL',4X,'PRES(MB)',2X,'WIND DIR.(DEG)',2X,                     PROUPR.144
     1 'WIND SPD(KT)',3X,'Q(I)')                                                 PROUPR.145
      DO 350 I=1,MLV                                                             PROUPR.146
      IF(PP(I).LE.PMANMN)GO TO 360                                               PROUPR.147
      MLVT=I                                                                     PROUPR.148
      IF(ISNDGS) PRINT 270,I,PP(I),DP(I),FP(I)                                   PROUPR.149
      IF(I.EQ.1)STDHT(1,1)=PP(I)                                                 PROUPR.150
350   CONTINUE                                                                   PROUPR.151
360   CONTINUE                                                                   PROUPR.152
C                                                                                PROUPR.153
C---------WIND BY HEIGHT LEVELS                                                  PROUPR.154
      LJTYP=4                                                                    PROUPR.155
      IF(UNIOBS) CALL  UNIUP(NVOLUP,P,Z,T,H,D,F,PP,DP,FP,LTHERM,                 PROUPR.156
     1                       LWND,LJTYP,LLV)                                     PROUPR.157
      IF(.NOT.UNIOBS) CALL WZZADP(Z,D,F,Q,LLV,MAXLEV)                            PROUPR.158
      IF(LLV.GE.1)GO TO 370                                                      PROUPR.159
      KWINDZ=1                                                                   PROUPR.160
      GO TO 410                                                                  PROUPR.161
370   IF(ISNDGS)PRINT 380,LLV                                                    PROUPR.162
380   FORMAT(10X,'SIGNIFICANT LEVEL WIND DATA BY HEIGHT',15X,'TOTAL OF',         PROUPR.163
     1 I3,' LEVELS')                                                             PROUPR.164
      IF(ISNDGS)PRINT 390                                                        PROUPR.165
390   FORMAT(18X,'LVL',5X,'HGT(M)',3X,'WIND DIR.(DEG)',2X,                       PROUPR.166
     1 'WIND SPD(KT)',3X,'Q(I)')                                                 PROUPR.167
      DO 400 I=1,LLV                                                             PROUPR.168
      IF(Z(I).GT.30000.)GO TO 410                                                PROUPR.169
      IF(ISNDGS) PRINT 270,I,Z(I),D(I),F(I)                                      PROUPR.170
  270 FORMAT(15X,I5,3F12.1)                                                      PROUPR.171
      IF(I.EQ.1)STDHT(1,2)=Z(I)                                                  PROUPR.172
400   CONTINUE                                                                   PROUPR.173
410   CONTINUE                                                                   PROUPR.174
      IF(NOBLND)RETURN                                                           PROUPR.175
C                                                                                PROUPR.176
C---------CONVERT SIGNIFICANT LEVEL WINDS AT HEIGHTS TO PRESSURE LEVELS          PROUPR.177
C         USING LOGARITHMIC INTERPOLATION.                                       PROUPR.178
      IS=60                                                                      PROUPR.179
      P(1)=STDHT(1,1)                                                            PROUPR.180
      DO 490 I=2,LLV                                                             PROUPR.181
      IF(Z(I).GT.Z(I-1))GO TO 420                                                PROUPR.182
      LLV=I-1                                                                    PROUPR.183
      GO TO 500                                                                  PROUPR.184
420   CONTINUE                                                                   PROUPR.185
      NTOP=NLV-1                                                                 PROUPR.186
         DO 460 L=1,NTOP                                                         PROUPR.187
         IF(STDHT(L,1).LE.PTOP)GO TO 490                                         PROUPR.188
         IF(Z(I).GT.STDHT(L,2).AND.Z(I).LE.STDHT(L+1,2))GO TO 430                PROUPR.189
         GO TO 460                                                               PROUPR.190
430      LP=L+1                                                                  PROUPR.191
440      IF(STDHT(LP,2).LT.1.E30)GO TO 450                                       PROUPR.192
         LP=LP+1                                                                 PROUPR.193
         IF(LP.GE.NTOP)GO TO 470                                                 PROUPR.194
         GO TO 440                                                               PROUPR.195
450      IF(STDHT(LP,2).LE.Z(I))GO TO 460                                        PROUPR.196
         PLOG=LOG(STDHT(L,1))+LOG(STDHT(LP,1)/STDHT(L,1))*(Z(I)-                 PROUPR.197
     1        STDHT(L,2))/(STDHT(LP,2)-STDHT(L,2))                               PROUPR.198
         P(I)=EXP(PLOG)                                                          PROUPR.199
         GO TO 490                                                               PROUPR.200
460      CONTINUE                                                                PROUPR.201
470   CONTINUE                                                                   PROUPR.202
490   CONTINUE                                                                   PROUPR.203
500   CONTINUE                                                                   PROUPR.204
C                                                                                PROUPR.205
C---------NOW CHECK TO SEE IF ANY SIGNIFICANT LEVEL WINDS SHOULD BESAVED         PROUPR.206
      IF(MLVT.LE.1)GO TO 590                                                     PROUPR.207
C                                                                                PROUPR.208
C---------FOR MLVT.GT.1, FORM A COMPOSITE OF WINDS FROM P-LEVEL OBS.             PROUPR.209
C         AND CONVERTED HGT.-LEVEL OBS.                                          PROUPR.210
      DO 580 JJ=2,MLVT                                                           PROUPR.211
         DO 510 L=2,IS                                                           PROUPR.212
         II=L                                                                    PROUPR.213
         IF(P(L).GT.1.E30)GO TO 570                                              PROUPR.214
         IF(P(L).LT.PP(JJ)-1.E-2)GO TO 530                                       PROUPR.215
510      CONTINUE                                                                PROUPR.216
      PRINT 520,II,JJ                                                            PROUPR.217
520   FORMAT(5X,'COMPOSITE SOUNDING IS FULL, II=',I3,3X,'JJ=',I3)                PROUPR.218
      GO TO 580                                                                  PROUPR.219
530      DO 560 IL=II,IS                                                         PROUPR.220
         ILA=IS+II-IL                                                            PROUPR.221
         IF(P(ILA).GT.1.E30.OR.ILA.LT.IS)GO TO 550                               PROUPR.222
         PRINT 540,II,IL                                                         PROUPR.223
540      FORMAT(5X,'SIGNIFICANT WIND COMPOSITE ARRAY IS FULL, II=',I3,           PROUPR.224
     1    2X,'IL=',I3,' SO A LEVEL IS LOST FROM THE TOP OF THE ',                PROUPR.225
     2    'COMPOSITE')                                                           PROUPR.226
550      P(ILA)=P(ILA-1)                                                         PROUPR.227
         D(ILA)=D(ILA-1)                                                         PROUPR.228
         F(ILA)=F(ILA-1)                                                         PROUPR.229
560      CONTINUE                                                                PROUPR.230
570   P(II)=PP(JJ)                                                               PROUPR.231
      D(II)=DP(JJ)                                                               PROUPR.232
      F(II)=FP(JJ)                                                               PROUPR.233
580   CONTINUE                                                                   PROUPR.234
590   CONTINUE                                                                   PROUPR.235
C                                                                                PROUPR.236
C                                                                                PROUPR.237
      IF(MLVT.LE.0)MLVT=1                                                        PROUPR.238
      MLV=LLV+MLVT-1                                                             PROUPR.239
      IF(NLV.LE.1)GO TO 600                                                      PROUPR.240
      CALL SAVSTN(CORRH,ID1,ID2,ID3,ITOSS,ISIGW,KTOPPR,KMANPR,KSIGPR,            PROUPR.241
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROUPR.242
     2            IS2,ISI)                                                       PROUPR.243
      IF(MOD(ISTATN,ID3).NE.0)GO TO 600                                          PROUPR.244
      IF(ITOSS.GT.0)GO TO 600                                                    PROUPR.245
C        SAVE FULL FILE OF SIGNIFICANT LEVEL DATA.                               PROUPR.246
      CALL SAVFIL(CORRH,ID1,ID2,ID3,ISTATN,ISIGW,IDS3)                           PROUPR.247
600   CONTINUE                                                                   PROUPR.248
C                                                                                PROUPR.249
C                                                                                PROUPR.250
      RETURN                                                                     PROUPR.251
      END                                                                        PROUPR.252
