      SUBROUTINE SAVSTN(FILEH,ID1,ID2,ID3,ITOSS,ITYP,KTOPPR,KMANPR,              SAVSTN.1
     1 KSIGPR,KWINDP,KWINDZ,KREMEM,FILES,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,           SAVSTN.2
     2 ISI)                                                                      SAVSTN.3
C                                                                                SAVSTN.4
C      PURPOSE:  SAVE DATA FOR LATER USE IN OBJECTIVE ANALYSIS.                  SAVSTN.5
C                SAVSTN USES ITYP TO IDENTIFY THE TYPE OF DATA TO                SAVSTN.6
C                BE PROCESSED AND SAVED:                                         SAVSTN.7
C                ITYP=1 - MANDATORY LEVEL DATA                                   SAVSTN.8
C                ITYP=2 - SIGNIFICANT LEVEL TEMPERATURES                         SAVSTN.9
C                ITYP=3 - SIGNIFICANT LEVEL WINDS                                SAVSTN.10
C                ITYP=4 - SURFACE-STATION DATA                                   SAVSTN.11
C                                                                                SAVSTN.12
C                THE LATITUDE AND LONGITUDE ARE RECEIVED AS INPUT AND            SAVSTN.13
C                ARE PROCESSED TO PROVIDE THE EQUIVALENT (I,J) LOCATION          SAVSTN.14
C                IN TERMS OF THE MESOSCALE GRID MESH.  FOR BOGUS                 SAVSTN.15
C                STATIONS, THE ELEVATION OF THE MODEL GRID IS INSERTED           SAVSTN.16
C                TO REPLACE THE FLAG VALUE (-999.)  RECEIVED ON INPUT.           SAVSTN.17
C-----------------------------------------------------------------------         SAVSTN.18
#include <paramirb.incl>                                                         SAVSTN.19
#include <paramirs.incl>                                                         SAVSTN.20
#include <coma.incl>                                                             SAVSTN.21
#include <comb.incl>                                                             SAVSTN.22
#include <comc.incl>                                                             SAVSTN.23
#include <comllxy.incl>                                                          SAVSTN.24
C-----------------------------------------------------------------------         SAVSTN.25
      CHARACTER*2      PROJECT  ! PROJECTION INDICATOR                           SAVSTN.26
      DIMENSION FILEH(ID1,ID2,ID3)                                               SAVSTN.27
      DIMENSION FILES(IDS1,IDS2,IDS3),SLAB1(IS1,IS2)                             SAVSTN.28
      DIMENSION PH(90)                                                           SAVSTN.29
      DATA XL/2.5E6/, RV/462.07/, DEGRAN/0.0174532/,                             SAVSTN.30
     1     A/6370./, CONV/57.29578/                                              SAVSTN.31
C    RV=1.61*287.                                                                SAVSTN.32
C                                                                                SAVSTN.33
C         FILEH(M,L,N) HOLDS SOUNDING DATA FOR UPPER-AIR DATA.                   SAVSTN.34
C            TO ID3 STATIONS                                                     SAVSTN.35
C                                                                                SAVSTN.36
C             M: VARIABLE TYPE INDEX                                             SAVSTN.37
C                  M=1 : U (M/S)                                                 SAVSTN.38
C                  M=2 : V (M/S)                                                 SAVSTN.39
C                  M=3 : TEMP (K)                                                SAVSTN.40
C                  M=4 : REL. HUM. (PERCENT)                                     SAVSTN.41
C                  M=5 : HT. OF P-LVL (M)                                        SAVSTN.42
C                                                                                SAVSTN.43
C             L: STD PRES LVL INDEX (INCLUDING ONE FALSE LEVEL L=1)              SAVSTN.44
C             N: STATION INDEX                                                   SAVSTN.45
C                                                                                SAVSTN.46
C         FILES(M,L,N) SIMILAR TO FILEH, BUT FOR SURFACE DATA                    SAVSTN.47
C         (WHEN ITYP = 4)                                                        SAVSTN.48
C                                                                                SAVSTN.49
C                  L: METEOR. DATA IS IN L = 2, LAT.-LON. AND ELEV               SAVSTN.50
C                     IN L = 1.                                                  SAVSTN.51
C        BUFD(J,N) IS A BUFFER TO HOLD STATION DATA OF ONE DATA FILE             SAVSTN.52
C             AT ONE PRES LEVEL.                                                 SAVSTN.53
C                                                                                SAVSTN.54
C                                                                                SAVSTN.55
C-----------------------------------------------------------------------         SAVSTN.56
C                                                                                SAVSTN.57
C---------INITIALIZE FILES ARRAY                                                 SAVSTN.58
      IF(ISI.EQ.0)THEN                                                           SAVSTN.59
      DO 5 M=1,IDS1                                                              SAVSTN.60
      DO 5 L=1,IDS2                                                              SAVSTN.61
      DO 5 N=1,IDS3                                                              SAVSTN.62
      FILES(M,L,N)=1.0E33                                                        SAVSTN.63
5     CONTINUE                                                                   SAVSTN.64
      ISI=1                                                                      SAVSTN.65
      END IF                                                                     SAVSTN.66
C                                                                                SAVSTN.67
C---***---SET UP PRELIMINARY INDICES                                             SAVSTN.68
      PH(1)=9999.                                                                SAVSTN.69
      LMAX = 10                                                                  SAVSTN.70
      MMAX = 5                                                                   SAVSTN.71
      ILV = 1                                                                    SAVSTN.72
      KLV=NLV                                                                    SAVSTN.73
      IF(ITYP.EQ.2.OR.ITYP.EQ.3)THEN                                             SAVSTN.74
      KLV=MLV                                                                    SAVSTN.75
         IF(MLV.LE.0)GO TO 70                                                    SAVSTN.76
      END IF                                                                     SAVSTN.77
      IF(ITYP.EQ.4)GO TO 33                                                      SAVSTN.78
C                                                                                SAVSTN.79
C---------FOR UPPER-AIR SOUNDINGS, CHECK FOR POSSIBLE MISMATCH OF                SAVSTN.80
C         MANDATORY LEVEL PRESSURES, AND FOR TOP-PRESSURE OF THE                 SAVSTN.81
C         SOUNDING                                                               SAVSTN.82
      IF(ITYP.EQ.1) MISMAT=0                                                     SAVSTN.83
      DO 20 N = ILV,KLV                                                          SAVSTN.84
      IF(ITYP.EQ.1) PH(N+1)=P(N)                                                 SAVSTN.85
      IF(P(N) .LT. PTOP-0.01) GO TO 30                                           SAVSTN.86
      NN=N                                                                       SAVSTN.87
      NNM=NN+1                                                                   SAVSTN.88
      IF(ITYP .GT. 1) GO TO 20                                                   SAVSTN.89
      IF(ABS(GLVL(NNM)-P(N)).lt.0.01) GO TO 20                                   SAVSTN.90
      MISMAT=1                                                                   SAVSTN.91
  20  CONTINUE                                                                   SAVSTN.92
      IF(ITYP.GT.1 .OR. P(NN).LT.PTOP+0.01)GO TO 30                              SAVSTN.93
      KTOPPR=1                                                                   SAVSTN.94
  30  CONTINUE                                                                   SAVSTN.95
      NTOP = NN                                                                  SAVSTN.96
      IF(NTOP .GT. NVERT .AND. ITYP .EQ. 1)NTOP = NVERT                          SAVSTN.97
      IF(NTOP.GE.ID2.AND.ITYP.GT.1)THEN                                          SAVSTN.98
      PRINT 32                                                                   SAVSTN.99
32    FORMAT(65X,'NO. OF SIG. LEVELS EXCEEDS ID2.  UPPERMOST DATA ',             SAVSTN.100
     1 'DISCARDED.')                                                             SAVSTN.101
      NTOP=ID2-1                                                                 SAVSTN.102
      END IF                                                                     SAVSTN.103
33    CONTINUE                                                                   SAVSTN.104
C                                                                                SAVSTN.105
C---------PREPARE STATION COUNTERS FOR SURFACE REPORTS, USING JSTATN             SAVSTN.106
      IF(ITYP.EQ.4)THEN                                                          SAVSTN.107
         ISTN=JSTATN                                                             SAVSTN.108
         NTOP=1                                                                  SAVSTN.109
      ELSE                                                                       SAVSTN.110
C                                                                                SAVSTN.111
C---------PREPARE STATION COUNTERS FOR SOUNDING REPORTS, USING ISTATN            SAVSTN.112
         ISTN=ISTATN                                                             SAVSTN.113
         IF(ITOSS.GT.0.AND.ITYP.GT.1)ISTN=ISTATN+1                               SAVSTN.114
      END IF                                                                     SAVSTN.115
      ISTNM=ISTN-1                                                               SAVSTN.116
C                                                                                SAVSTN.117
C---***---PROCESS METEOROLOGICAL VALUES FOR UPPER-AIR SOUNDINGS                  SAVSTN.118
      IF(ITYP.EQ.4)GO TO 60                                                      SAVSTN.119
C                                                                                SAVSTN.120
C---------DETERMINE NSTA, THE RELATIVE POSITION OF ISTN IN DATA FILE, ID         SAVSTN.121
      IDF=ISTNM/ID3+1                                                            SAVSTN.122
      NSTA=ISTN-(IDF-1)*ID3                                                      SAVSTN.123
      IF(ITYP.EQ.3.AND.IFOUND(IDF,NSTA).EQ.1)GO TO 47                            SAVSTN.124
C                                                                                SAVSTN.125
C---------WHEN A NEW DATA FILE IS OPENED, STORE DUMMY VALUES IN FILEH            SAVSTN.126
      IF(MOD(ISTNM,ID3).EQ.0)THEN                                                SAVSTN.127
      DO 35 M=1,ID1                                                              SAVSTN.128
      DO 35 L=1,ID2                                                              SAVSTN.129
      DO 35 N=1,ID3                                                              SAVSTN.130
      FILEH(M,L,N)=1.0E33                                                        SAVSTN.131
35    CONTINUE                                                                   SAVSTN.132
      END IF                                                                     SAVSTN.133
C                                                                                SAVSTN.134
C---------TEMP. AND HEIGHT OR PRESSURE STORAGE.                                  SAVSTN.135
      DO 40 L=ILV,NTOP                                                           SAVSTN.136
      LL=L+1                                                                     SAVSTN.137
      IF(ITYP.EQ.1)THEN                                                          SAVSTN.138
         IF(Z(L).LT.40000.0)FILEH(5,LL,NSTA)=Z(L)                                SAVSTN.139
         IF(ELEV.GT.Z(L).OR.T(L).GT.100.0)GO TO 40                               SAVSTN.140
      ELSE                                                                       SAVSTN.141
         IF(P(L).LT.PMANMN)GO TO 42                                              SAVSTN.142
         IF(P(L).LT.1100.0)FILEH(5,LL,NSTA)=P(L)                                 SAVSTN.143
         IF(T(L).GT.100.0)GO TO 40                                               SAVSTN.144
      END IF                                                                     SAVSTN.145
      FILEH(3,LL,NSTA)=T(L)                                                      SAVSTN.146
40    CONTINUE                                                                   SAVSTN.147
C                                                                                SAVSTN.148
C---------CONVERT DEW POINT DEPRESSION TO RELATIVE HUMIDITY                      SAVSTN.149
C         (SEE DUTTON, "THE CEASELESS WIND", P.274, EQ. 6)                       SAVSTN.150
42    DO 45 L=ILV,NTOP                                                           SAVSTN.151
      IF(H(L).GT.99.8 .AND. H(L).LT.100.0 .AND. P(L) .GT. 499.0                  SAVSTN.152
     1   .AND. T(L).LT.99.0) PRINT 212, SSTA,P(L)                                SAVSTN.153
212   FORMAT(1H0,5X,'+++++ NOTE: DEW POINT DEPRESSION IS 99.9 FOR ',             SAVSTN.154
     1     'STATION AND PRESSURE LEVEL = ',A6,F7.1)                              SAVSTN.155
      IF(H(L).GT.100.)GO TO 45                                                   SAVSTN.156
      LL=L+1                                                                     SAVSTN.157
      IF(ITYP.EQ.1)THEN                                                          SAVSTN.158
         IF(ELEV.GT.Z(L).OR.T(L).GT.100.0)GO TO 45                               SAVSTN.159
      ELSE                                                                       SAVSTN.160
         IF(P(L).LT.PMANMN)GO TO 47                                              SAVSTN.161
         IF(T(L).GT.100.0)GO TO 45                                               SAVSTN.162
      END IF                                                                     SAVSTN.163
      RECT=1.0/(T(L)+273.15)                                                     SAVSTN.164
      RECTD=1.0/(T(L)+273.15-H(L))                                               SAVSTN.165
      TERM=XL*(RECT-RECTD)/RV                                                    SAVSTN.166
      FILEH(4,LL,NSTA)=EXP(TERM)*100.                                            SAVSTN.167
      FILEH(4,LL,NSTA)=MAX(FILEH(4,LL,NSTA),10.0)                                SAVSTN.168
      FILEH(4,LL,NSTA)=MIN(FILEH(4,LL,NSTA),99.9)                                SAVSTN.169
45    CONTINUE                                                                   SAVSTN.170
C                                                                                SAVSTN.171
C---------CONVERT WINDS FROM SPEED AND DIRECTION TO COMPONENT FORM IN            SAVSTN.172
C         EARTH-COORDINATES, AND THEN TO MODEL COORDINATES WITH A LAMBER         SAVSTN.173
C         CONFORMAL, POLAR STEREOGRAPHIC, OR MERCATOR PROJECTION.  ONLY          SAVSTN.174
C         THE CONE CONSTANT, XN, CHANGES.                                        SAVSTN.175
47    IF(ITYP.EQ.2.AND.IFOUND(IDF,NSTA).EQ.1)GO TO 70                            SAVSTN.176
      XN = CONFAC                                                                SAVSTN.177
      DO 56 L=ILV,NTOP                                                           SAVSTN.178
      IF(ITYP.EQ.1)THEN                                                          SAVSTN.179
         LL=L+1                                                                  SAVSTN.180
         IF(ELEV.GT.Z(L).OR.D(L).GT.360.0)GO TO 56                               SAVSTN.181
      ELSE                                                                       SAVSTN.182
         IF(P(L).LT.PMANMN)GO TO 70                                              SAVSTN.183
         IF(D(L).GT.360.0.OR.P(L).GT.1.E5)GO TO 56                               SAVSTN.184
C                                                                                SAVSTN.185
C---------SIGNIFICANT LEVEL WIND DATA EXIST -- FIND THE APPROPRIATE              SAVSTN.186
C         LOCATION IN FILEH TO INSERT IT.   MOVE EXISTING HIGHER                 SAVSTN.187
C         LEVELS UPWARD BY ONE, IF THERE IS ROOM AVAILABLE (LIMIT IS             SAVSTN.188
C         ID2)                                                                   SAVSTN.189
         IF(FILEH(5,ID2,NSTA).LT.1.0E5)THEN                                      SAVSTN.190
            PRINT 48,NSTA,L,NTOP                                                 SAVSTN.191
48          FORMAT(5X,'FILEH(NSTA=',I4,') IS FULL.  SIGNIFICANT LEVEL',          SAVSTN.192
     1    ' WINDS FOR L=',I2,' TO ',I3,' HAVE BEEN DISCARDED.')                  SAVSTN.193
            GO TO 70                                                             SAVSTN.194
         END IF                                                                  SAVSTN.195
         DO 50 JP=2,ID2                                                          SAVSTN.196
         IF(FILEH(5,JP,NSTA).GT.P(L).AND.FILEH(5,JP,NSTA).LT.1.0E5)              SAVSTN.197
     1   GO TO 50                                                                SAVSTN.198
            LL=JP                                                                SAVSTN.199
            IF(FILEH(5,JP,NSTA).EQ.P(L))GO TO 55                                 SAVSTN.200
            JJ=LL+1                                                              SAVSTN.201
            IF(JJ.GT.ID2)GO TO 53                                                SAVSTN.202
            GO TO 51                                                             SAVSTN.203
50       CONTINUE                                                                SAVSTN.204
         STOP 50                                                                 SAVSTN.205
C                                                                                SAVSTN.206
C---------MOVE EXISTING DATA TO MAKE ROOM FOR INSERTED DATA LEVEL                SAVSTN.207
51       DO 52 J=JJ,ID2                                                          SAVSTN.208
         JL=ID2+JJ-J                                                             SAVSTN.209
         DO 52 M=1,ID1                                                           SAVSTN.210
52       FILEH(M,JL,NSTA)=FILEH(M,JL-1,NSTA)                                     SAVSTN.211
53       CONTINUE                                                                SAVSTN.212
         DO 54 M=1,ID1                                                           SAVSTN.213
54       FILEH(M,LL,NSTA)=1.0E33                                                 SAVSTN.214
         FILEH(5,LL,NSTA)=P(L)                                                   SAVSTN.215
      END IF                                                                     SAVSTN.216
C                                                                                SAVSTN.217
C---------INSERT NEW DATA                                                        SAVSTN.218
55    CONTINUE                                                                   SAVSTN.219
      AEARTH=D(L)*DEGRAN                                                         SAVSTN.220
      UEARTH=-F(L)*SIN(AEARTH)                                                   SAVSTN.221
      VEARTH=-F(L)*COS(AEARTH)                                                   SAVSTN.222
      XLONRT=XLONC-YLON                                                          SAVSTN.223
      IF(XLONRT.GT.180.)XLONRT=XLONRT-360.                                       SAVSTN.224
      IF(XLONRT.LT.-180.)XLONRT=XLONRT+360.                                      SAVSTN.225
      ANG=XLONRT*XN*DEGRAN                                                       SAVSTN.226
C                                                                                SAVSTN.227
C---------FOR MERCATOR PROJECTION, GRID COMPONENT WINDS ARE IN EARTH             SAVSTN.228
C         COORDINATES                                                            SAVSTN.229
      IF(IPROJ.EQ.3)ANG=0.0                                                      SAVSTN.230
      IF(PHIC.LT.0.0)ANG=-ANG                                                    SAVSTN.231
      RANG(IDF,NSTA)=ANG                                                         SAVSTN.232
C---------CONVERT WINDS FROM KNOTS TO M/S.                                       SAVSTN.233
      FILEH(1,LL,NSTA)=(VEARTH*SIN(ANG)+UEARTH*COS(ANG))*0.5144                  SAVSTN.234
      FILEH(2,LL,NSTA)=(VEARTH*COS(ANG)-UEARTH*SIN(ANG))*0.5144                  SAVSTN.235
56    CONTINUE                                                                   SAVSTN.236
      GO TO 70                                                                   SAVSTN.237
C                                                                                SAVSTN.238
C---***---PROCESS METEOROLOGICAL VALUES FOR SURFACE STATIONS                     SAVSTN.239
60    CONTINUE                                                                   SAVSTN.240
      NSTA=ISTN                                                                  SAVSTN.241
C                                                                                SAVSTN.242
C---------TEMP. AND SEA-LEVEL PRESSURE STORAGE                                   SAVSTN.243
      IF(P(1).LT.1100.0)FILES(5,2,NSTA)=P(1)                                     SAVSTN.244
      IF(T(1).LT.100.0)FILES(3,2,NSTA)=T(1)                                      SAVSTN.245
C                                                                                SAVSTN.246
C---------CONVERT DEW POINT DEPRESSTION TO RELATIVE HUMIDITY                     SAVSTN.247
      IF(H(1).LT.60.0.AND.T(1).LT.60.0)THEN                                      SAVSTN.248
      RECT=1.0/(T(1)+273.15)                                                     SAVSTN.249
      RECTD=1.0/(T(1)+273.15-H(1))                                               SAVSTN.250
      TERM=XL*(RECT-RECTD)/RV                                                    SAVSTN.251
      FILES(4,2,NSTA)=EXP(TERM)*100.                                             SAVSTN.252
      FILES(4,2,NSTA)=MAX(FILES(4,2,NSTA),10.0)                                  SAVSTN.253
      FILES(4,2,NSTA)=MIN(FILES(4,2,NSTA),99.9)                                  SAVSTN.254
      END IF                                                                     SAVSTN.255
C                                                                                SAVSTN.256
C---------CONVERT SURFACE WIND FROM EARTH-COORDINATES TO MODEL                   SAVSTN.257
C         PROJECTED COORDINATES, COMPONENT FORM, AND M/S.                        SAVSTN.258
      IF(D(1).GT.360.0.OR.P(1).GT.1.E5)GO TO 70                                  SAVSTN.259
      AEARTH=D(1)*DEGRAN                                                         SAVSTN.260
      UEARTH=-F(1)*SIN(AEARTH)                                                   SAVSTN.261
      VEARTH=-F(1)*COS(AEARTH)                                                   SAVSTN.262
      XLONRT=XLONC-YLON                                                          SAVSTN.263
      IF(XLONRT.GT.180.)XLONRT=XLONRT-360.                                       SAVSTN.264
      IF(XLONRT.LT.-180.)XLONRT=XLONRT+360.                                      SAVSTN.265
      ANG=XLONRT*XN*DEGRAN                                                       SAVSTN.266
      IF(IPROJ.EQ.3)ANG=0.0                                                      SAVSTN.267
      IF(PHIC.LT.0.0)ANG=-ANG                                                    SAVSTN.268
      RANG(2,NSTA)=ANG                                                           SAVSTN.269
      FILES(1,2,NSTA)=(VEARTH*SIN(ANG)+UEARTH*COS(ANG))*0.5144                   SAVSTN.270
      FILES(2,2,NSTA)=(VEARTH*COS(ANG)-UEARTH*SIN(ANG))*0.5144                   SAVSTN.271
C                                                                                SAVSTN.272
C---------SFC. STATION PROCESSING IS COMPLETE                                    SAVSTN.273
C                                                                                SAVSTN.274
70    CONTINUE                                                                   SAVSTN.275
C                                                                                SAVSTN.276
      IF (IPROJ.EQ.1) PROJECT = 'LC'                                             SAVSTN.277
      IF (IPROJ.EQ.2) PROJECT = 'ST'                                             SAVSTN.278
      IF (IPROJ.EQ.3) PROJECT = 'ME'                                             SAVSTN.279
      LIMX=NINT((FLOAT(IXMUN)-(2.*XSTH)+1.)*FLOAT(IRAT)) + 1                     SAVSTN.280
      LJMX=NINT((FLOAT(JXMUN)-(2.*XWST )+1.)*FLOAT(IRAT)) + 1                    SAVSTN.281
      CALL LLTOXY(YLAT,YLON,XOBSD,YOBSD,PROJECT)                                 SAVSTN.282
      LIMX=LIMX - 1                                                              SAVSTN.283
      LJMX=LJMX - 1                                                              SAVSTN.284
      CALL LLTOXY(YLAT,YLON,XOBSC,YOBSC,PROJECT)                                 SAVSTN.285
      IF(ITYP.EQ.4) THEN                                                         SAVSTN.286
         FILES(1,1,NSTA)=XOBSD                                                   SAVSTN.287
         FILES(2,1,NSTA)=YOBSD                                                   SAVSTN.288
         FILES(3,1,NSTA)=XOBSC                                                   SAVSTN.289
         FILES(4,1,NSTA)=YOBSC                                                   SAVSTN.290
      ELSE                                                                       SAVSTN.291
         FILEH(1,1,NSTA)=XOBSD                                                   SAVSTN.292
         FILEH(2,1,NSTA)=YOBSD                                                   SAVSTN.293
         FILEH(3,1,NSTA)=XOBSC                                                   SAVSTN.294
         FILEH(4,1,NSTA)=YOBSC                                                   SAVSTN.295
      ENDIF                                                                      SAVSTN.296
C                                                                                SAVSTN.297
C---------SET INCOMING BUFFERS BACK TO DUMMY VALUES                              SAVSTN.298
      DO 73 L = 1,60                                                             SAVSTN.299
      P(L) = 1.0E33                                                              SAVSTN.300
      Z(L) = 1.0E33                                                              SAVSTN.301
      T(L) = 1.0E33                                                              SAVSTN.302
      H(L) = 1.0E33                                                              SAVSTN.303
      D(L) = 1.0E33                                                              SAVSTN.304
      F(L) = 1.0E33                                                              SAVSTN.305
  73  Q(L) = '        '                                                          SAVSTN.306
C        CHECK TO SEE IF THE STATION IS IN THE MODEL DOMAIN.  IF NOT,            SAVSTN.307
C        TOSS IT OUT AND DECREMENT THE ISTATN COUNTER.                           SAVSTN.308
      RJ=JE                                                                      SAVSTN.309
      RI=IE                                                                      SAVSTN.310
      IF(MISMAT.GT.0 .AND. ITYP.EQ.1) THEN
      RJ=0.1                                                                     SAVSTN.312
      RI=0.1                                                                     SAVSTN.313
      END IF                                                                     SAVSTN.314
      IF(ITYP.EQ.4)THEN                                                          SAVSTN.315
         IF(FILES(3,1,NSTA).LT.1.0.OR.FILES(3,1,NSTA).GE.RJ)GO TO 110            SAVSTN.316
         IF(FILES(4,1,NSTA).LT.1.0.OR.FILES(4,1,NSTA).GE.RI)GO TO 110            SAVSTN.317
      ELSE                                                                       SAVSTN.318
         IF(FILEH(3,1,NSTA).LT.1.0.OR.FILEH(3,1,NSTA).GE.RJ)GO TO 110            SAVSTN.319
         IF(FILEH(4,1,NSTA).LT.1.0.OR.FILEH(4,1,NSTA).GE.RI)GO TO 110            SAVSTN.320
      END IF                                                                     SAVSTN.321
C                                                                                SAVSTN.322
C---------SET CORRECT ELEVATION:  USE ELEV FOR REAL STATIONS (DATBOG=1);         SAVSTN.323
C         CALCULATE ELEVATION FROM MODEL TERRAIN FOR BOGUS STATIONS              SAVSTN.324
C         (DATBOG=2).                                                            SAVSTN.325
      IF(ITYP.EQ.4)THEN                                                          SAVSTN.326
         DATBOG=IFOUND(2,NSTA)                                                   SAVSTN.327
      ELSE                                                                       SAVSTN.328
         DATBOG=IFOUND(IDF,NSTA)                                                 SAVSTN.329
      END IF                                                                     SAVSTN.330
      IF(DATBOG.EQ.1)THEN                                                        SAVSTN.331
C        REAL OBSERVATION; USE ELEV                                              SAVSTN.332
         IF(ITYP.EQ.4)THEN                                                       SAVSTN.333
            FILES(5,1,NSTA)=ELEV                                                 SAVSTN.334
         ELSE                                                                    SAVSTN.335
            FILEH(5,1,NSTA)=ELEV                                                 SAVSTN.336
         END IF                                                                  SAVSTN.337
      ELSE                                                                       SAVSTN.338
C                                                                                SAVSTN.339
C---------BOGUS OBSERVATION, CALCULATE TERRAIN AT BOGUS LOCATION FROM            SAVSTN.340
C         GRIDDED DATA HELD IN SLAB1 (CROSS-POINT VALUES)                        SAVSTN.341
         IF(ITYP.EQ.4)THEN                                                       SAVSTN.342
            RI=FILES(4,1,NSTA)                                                   SAVSTN.343
            RJ=FILES(3,1,NSTA)                                                   SAVSTN.344
         ELSE                                                                    SAVSTN.345
            RI=FILEH(4,1,NSTA)                                                   SAVSTN.346
            RJ=FILEH(3,1,NSTA)                                                   SAVSTN.347
         END IF                                                                  SAVSTN.348
         I=RI                                                                    SAVSTN.349
         J=RJ                                                                    SAVSTN.350
         DI=RI-FLOAT(I)                                                          SAVSTN.351
         DJ=RJ-FLOAT(J)                                                          SAVSTN.352
         ELEV=(1.0-DJ)*((1.0-DI)*SLAB1(I,J)+DI*SLAB1(I+1,J))                     SAVSTN.353
     1        +DJ*((1.0-DI)*SLAB1(I,J+1)+DI*SLAB1(I+1,J+1))                      SAVSTN.354
      IKELEV(IDF,NSTA)=ELEV                                                      SAVSTN.355
         IF(ITYP.EQ.4)THEN                                                       SAVSTN.356
            FILES(5,1,NSTA)=ELEV                                                 SAVSTN.357
         ELSE                                                                    SAVSTN.358
            FILEH(5,1,NSTA)=ELEV                                                 SAVSTN.359
         END IF                                                                  SAVSTN.360
      END IF                                                                     SAVSTN.361
C                                                                                SAVSTN.362
C---------PRINT OUT COMPLETED STATION DATA IN PRE-ANALYSIS FORM.                 SAVSTN.363
      IF(.NOT.ISTAWT)GO TO 106                                                   SAVSTN.364
      IF(ITYP.EQ.4)GO TO 150                                                     SAVSTN.365
C                                                                                SAVSTN.366
C---------UPPER-AIR DATA                                                         SAVSTN.367
      IF(ITYP.EQ.2)GO TO 106                                                     SAVSTN.368
      IF(ITYP .EQ. 3) GO TO 101                                                  SAVSTN.369
      KREMEM=1                                                                   SAVSTN.370
      XFIL1=FILEH(1,1,NSTA)                                                      SAVSTN.371
      XFIL2=FILEH(2,1,NSTA)                                                      SAVSTN.372
      JJELEV=ELEV                                                                SAVSTN.373
      PRINT 200,SSTA,YLAT,YLON,XFIL1,XFIL2,JJELEV                                SAVSTN.374
      IF(KTOPPR.EQ.1) PRINT 201,SSTA                                             SAVSTN.375
200   FORMAT(2X,'UPPER-AIR STATION',1X,A6,'PROCESSED---LAT,LONG IS',             SAVSTN.376
     1 F7.2,F10.2,7X,'X,Y (DOT) COORD`S ARE',2F7.2,7X,'ELEV=',I5,'M')            SAVSTN.377
      IF (NPRINT .EQ. 1) GO TO 12                                                SAVSTN.378
      PRINT 80,ISTATN,ITYP                                                       SAVSTN.379
  80  FORMAT(1H0,5X,'MANDATORY LEVEL DATA: FILEH(M,L,NSTA) FOR ISTATN=',         SAVSTN.380
     1 I5,' AND ITYP=',I5,' IN SAVSTN'/3X,'LEVEL(MB)',1X,'U(M/S)',2X,            SAVSTN.381
     2 'V(M/S)',3X,'T(C)',1X,'RH(0/0)',2X,'HT(M)')                               SAVSTN.382
      DO 100 LL = 1,NVERT                                                        SAVSTN.383
      L = NVERT + 1 - LL                                                         SAVSTN.384
      PRINT 194,PH(L),(FILEH(M,L,NSTA),M=1,MMAX)                                 SAVSTN.385
  194 FORMAT (4X,F6.0,1X,5F8.1)                                                  SAVSTN.386
 100  CONTINUE                                                                   SAVSTN.387
   12 CONTINUE                                                                   SAVSTN.388
      GO TO 106                                                                  SAVSTN.389
 101  CONTINUE                                                                   SAVSTN.390
      IF (NPRINT .EQ. 1) GO TO 14                                                SAVSTN.391
      PRINT 102,ISTATN,ITYP                                                      SAVSTN.392
 102  FORMAT(1H0,5X,'SIGNIFICANT LEVEL DATA: FILEH(M,L,NSTA) FOR',               SAVSTN.393
     1 ' ISTATN=',I5,' AND ITYP=',I5,' IN SAVSTN'/6X,'LEVEL',2X,                 SAVSTN.394
     2 'U(M/S)',2X,'V(M/S)',3X,'T(C)',1X,'RH(0/0)',3X,'P(MB)')                   SAVSTN.395
      DO 105 LL = 1,ID2                                                          SAVSTN.396
      L = ID2 + 1 - LL                                                           SAVSTN.397
      IF(FILEH(5,L,NSTA) .GT. 1.0E5) GO TO 105                                   SAVSTN.398
      PRINT 90,L,(FILEH(M,L,NSTA),M=1,MMAX)                                      SAVSTN.399
90    FORMAT(6X,I3,1X,5F8.1)                                                     SAVSTN.400
 105  CONTINUE                                                                   SAVSTN.401
   14 CONTINUE                                                                   SAVSTN.402
      IF(KREMEM.EQ.0) PRINT 200,SSTA,YLAT,YLON,XFIL1,XFIL2,JJELEV                SAVSTN.403
      IF(KMANPR.EQ.1) PRINT 202,SSTA                                             SAVSTN.404
      IF(KSIGPR.EQ.1) PRINT 203,SSTA                                             SAVSTN.405
      IF(KWINDP.EQ.1) PRINT 204,SSTA                                             SAVSTN.406
      IF(KWINDZ.EQ.1) PRINT 205,SSTA                                             SAVSTN.407
      IF(KREMEM.EQ.0.OR.KMANPR.EQ.1.OR.KSIGPR.EQ.1.OR.KWINDP.EQ.1.OR.            SAVSTN.408
     1KWINDZ.EQ.1.OR.KTOPPR.EQ.1) PRINT 209                                      SAVSTN.409
  201 FORMAT(1H ,27X,'LEVELS DO NOT EXTEND TO PTOP FOR STATION ',1X,A6)          SAVSTN.410
  202 FORMAT(1H ,27X,'NO MANDATORY LEVELS FOR STATION ',10X,A6)                  SAVSTN.411
  203 FORMAT(1H ,27X,'NO SIGNIFICANT TEMP LEVELS FOR STATION ',3X,A6)            SAVSTN.412
  204 FORMAT(1H ,27X,'NO SIGNIFICANT WIND(P) LEVELS FOR STATION ',A6)            SAVSTN.413
  205 FORMAT(1H ,27X,'NO SIGNIFICANT WIND(Z) LEVELS FOR STATION ',A6)            SAVSTN.414
      GO TO 106                                                                  SAVSTN.415
C                                                                                SAVSTN.416
C---------SURFACE STATION DATA                                                   SAVSTN.417
150   CONTINUE                                                                   SAVSTN.418
      XFIL1=FILES(1,1,NSTA)                                                      SAVSTN.419
      XFIL2=FILES(2,1,NSTA)                                                      SAVSTN.420
      JJELEV=ELEV                                                                SAVSTN.421
      IF(SFPROC) PRINT 160,SSTA,YLAT,YLON,XFIL1,XFIL2,JJELEV                     SAVSTN.422
 160  FORMAT(4X,'SURFACE STATION',1X,A6,'PROCESSED---LAT,LON IS',F7.2,           SAVSTN.423
     1 F9.2,7X,'X,Y (DOT) COORD`S ARE',2F7.2,7X,'ELEV=',I5,'M')                  SAVSTN.424
      IF(NPRINT.EQ.1)GO TO 190                                                   SAVSTN.425
      PRINT 170,JSTATN,ITYP                                                      SAVSTN.426
170   FORMAT(1H0,5X,'SURFACE STATION DATA: FILES(M,L,NSTAT) FOR JSTATN='         SAVSTN.427
     1 ,I5,' AND ITYP=',I5,' IN SAVSTN'/6X,'LEVEL',2X,'U(M/S)',2X,               SAVSTN.428
     2 'V(M/S)',3X,'T(C)',1X,'RH(%)',1X,'PSLVL(MB)')                             SAVSTN.429
      DO 180 LL=1,2                                                              SAVSTN.430
      L=3-LL                                                                     SAVSTN.431
      PRINT 90,L,(FILES(M,L,NSTA),M=1,MMAX)                                      SAVSTN.432
180   CONTINUE                                                                   SAVSTN.433
190   CONTINUE                                                                   SAVSTN.434
 106  ITOSS = 0                                                                  SAVSTN.435
      RETURN                                                                     SAVSTN.436
C        THE STATION IS OUTSIDE THE DOMAIN.  DO NOT SAVE IT.                     SAVSTN.437
 110  IF(ITYP .EQ. 1) ISTATN = ISTATN - 1                                        SAVSTN.438
      IF(ITYP.EQ.4)THEN                                                          SAVSTN.439
        JSTATN=JSTATN-1                                                          SAVSTN.440
        ISTATN=ISTATN-1                                                          SAVSTN.441
      END IF                                                                     SAVSTN.442
      ITOSS = 1                                                                  SAVSTN.443
      IF(ITYP.EQ.4)THEN                                                          SAVSTN.444
         XFIL1=FILES(1,1,NSTA)                                                   SAVSTN.445
         XFIL2=FILES(2,1,NSTA)                                                   SAVSTN.446
         IF(SFPROC) PRINT 215,SSTA,XFIL1,XFIL2                                   SAVSTN.447
215      FORMAT(16X,'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ SURFACE',           SAVSTN.448
     1  1X,'STATION',1X,A6,'WITH X,Y (DOT) COORD`S',1X,2F7.2,1X,                 SAVSTN.449
     .     'IS OUTSIDE',                                                         SAVSTN.450
     2 ' DOMAIN--DISCARDED')                                                     SAVSTN.451
         DO 220 M=1,IDS1                                                         SAVSTN.452
         DO 220 L=1,IDS2                                                         SAVSTN.453
220      FILES(M,L,NSTA)=1.0E33                                                  SAVSTN.454
      ELSE                                                                       SAVSTN.455
      XFIL1=FILEH(1,1,NSTA)                                                      SAVSTN.456
      XFIL2=FILEH(2,1,NSTA)                                                      SAVSTN.457
         IF(ITYP.EQ.1)THEN                                                       SAVSTN.458
            PRINT 209                                                            SAVSTN.459
      IF(MISMAT.EQ.0) PRINT 206,SSTA,XFIL1,XFIL2                                 SAVSTN.460
      IF(MISMAT.GT.0) PRINT 306,SSTA                                             SAVSTN.461
  306 FORMAT(16X,'++++++++++ NOTE:  STATION',1X,A6,1X,'DISCARDED BECAU',         SAVSTN.462
     1'SE OF PRES LEVEL MISMATCH')                                               SAVSTN.463
206   FORMAT(16X,'$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ UPPER',                 SAVSTN.464
     1  '-AIR',1X,'STATION',1X,A6,'WITH X,Y (DOT) COORD`S',1X,2F7.2,1X,          SAVSTN.465
     2 'IS OUTSIDE DOMAIN---DISCARDED')                                          SAVSTN.466
            PRINT 209                                                            SAVSTN.467
         END IF                                                                  SAVSTN.468
  209 FORMAT(1H )                                                                SAVSTN.469
      DO 120 M = 1,ID1                                                           SAVSTN.470
      DO 120 L = 1,ID2                                                           SAVSTN.471
 120  FILEH(M,L,NSTA) = 1.0E33                                                   SAVSTN.472
      END IF                                                                     SAVSTN.473
      RETURN                                                                     SAVSTN.474
      END                                                                        SAVSTN.475
