      SUBROUTINE SEAPRS(LENBUF,N,NF,NL)                                          SEAPRS.1
C                                                                                SEAPRS.2
C      PURPOSE:  THIS SUBROUTINE IS USED FOR UPPER-AIR REPORTS TO                SEAPRS.3
C                CONVERT INCOMING SFC. PRESS. AT REAL STATIONS TO                SEAPRS.4
C                SEA-LEVEL PRESSURE, AND TO CONVERT INCOMING SEA-                SEAPRS.5
C                LEVEL PRESSURE AT BOGUS STATIONS TO SFC. PRESS.                 SEAPRS.6
C                NOTE:  UPON RETURN FROM SEAPRS, ALL RSOND(5,NN)                 SEAPRS.7
C                       VALUES ARE IN SEA-LEVEL PRESSURE, AND                    SEAPRS.8
C                       SURFACE PRESSURE IS STORED IN LEVEL 2 OF                 SEAPRS.9
C                       PERMANENT BUFFER STORAGE FOR SIGNIFICANT                 SEAPRS.10
C                       LEVEL DATA.                                              SEAPRS.11
C-----------------------------------------------------------------------         SEAPRS.12
#include <paramirb.incl>                                                         SEAPRS.13
#include <paramirs.incl>                                                         SEAPRS.14
#include <coma.incl>                                                             SEAPRS.15
#include <comc.incl>                                                             SEAPRS.16
#include <comwt.incl>                                                            SEAPRS.17
C-----------------------------------------------------------------------         SEAPRS.18
      DIMENSION PSOND1(5,IRS),PSOND2(5,IRS),PSOND3(5,IRS),                       SEAPRS.19
     1 BUFSFP(5,IRB)                                                             SEAPRS.20
C                                                                                SEAPRS.21
C      ELEV. IS ALREADY IN BUFD(5,NN) FOR BOTH REAL AND BOGUS SOUNDINGS.         SEAPRS.22
C      FOR REAL STATIONS, RSOND(5,NN) HOLDS SURFACE PRESS. (INPUT)               SEAPRS.23
C      FOR BOGUS STATIONS, RSOND(5,NN) HOLDS SEA-LEVEL PRESS. (INPUT)            SEAPRS.24
C                                                                                SEAPRS.25
C        OBTAIN TEMPS AND HGTS AT 850MB IN PSOND1 AND AT 700MB                   SEAPRS.26
C        IN PSOND2, AND AT 500MB IN PSOND3.                                      SEAPRS.27
C                                                                                SEAPRS.28
C        ASSUME STD ATMOS. LAPSE RATE 6.5E-3(DEG/M).                             SEAPRS.29
C                                                                                SEAPRS.30
      GAMMA = 6.5E-3                                                             SEAPRS.31
      G = 9.81                                                                   06NOV00.518
      R = 287.04                                                                 SEAPRS.33
      XTERM = GAMMA*R/G                                                          SEAPRS.34
      GRLG78 = G/(LOG(850./700.)*R)                                              SEAPRS.35
      GRLG57 = G/(LOG(700./500.)*R)                                              SEAPRS.36
C  CHECK TO SEE IF NL DOES NOT EXCEED ARRAY DIMENSION OF IRB.                    SEAPRS.37
      IF(NL.GT.IRB)STOP 4                                                        SEAPRS.38
C                                                                                SEAPRS.39
C---------SAVE SURFACE-LEVEL DATA FROM RSOND IN BUFSFP                           SEAPRS.40
      DO 10 M=1,4                                                                SEAPRS.41
      DO 10 NN=NF,NL                                                             SEAPRS.42
10    BUFSFP(M,NN)=RSOND(M,NN)                                                   SEAPRS.43
C                                                                                SEAPRS.44
C   IF INTERPOLATION FROM 1000 AND 850 MB LEVELS IS DESIRED---LL1 = 2            SEAPRS.45
C                                                                                SEAPRS.46
      LL1 = 3                                                                    SEAPRS.47
      LL2 = LL1 + 1                                                              SEAPRS.48
      LL3 = LL2+1                                                                SEAPRS.49
      NAME = NAMDAT+10000*LL1                                                    SEAPRS.50
      CALL RDISK(NAME,BUFUPR,LENBUF,0,LENBUF,CHECK)                              SEAPRS.51
      DO 6 M=1,5                                                                 SEAPRS.52
      DO 5 L1=1,IRB                                                              SEAPRS.53
      PSOND1(M,L1)=BUFUPR(M,L1)                                                  SEAPRS.54
5     CONTINUE                                                                   SEAPRS.55
6     CONTINUE                                                                   SEAPRS.56
      NAME = NAMDAT+10000*LL2                                                    SEAPRS.57
      CALL RDISK(NAME,BUFUPR,LENBUF,0,LENBUF,CHECK)                              SEAPRS.58
      DO 8 M=1,5                                                                 SEAPRS.59
      DO 7 L1=1,IRB                                                              SEAPRS.60
      PSOND2(M,L1)=BUFUPR(M,L1)                                                  SEAPRS.61
7     CONTINUE                                                                   SEAPRS.62
8     CONTINUE                                                                   SEAPRS.63
      NAME = NAMDAT+10000*LL3                                                    SEAPRS.64
      CALL RDISK(NAME,BUFUPR,LENBUF,0,LENBUF,CHECK)                              SEAPRS.65
      DO 13 M=1,5                                                                SEAPRS.66
      DO 12 L1=1,IRB                                                             SEAPRS.67
      PSOND3(M,L1)=BUFUPR(M,L1)                                                  SEAPRS.68
12    CONTINUE                                                                   SEAPRS.69
13    CONTINUE                                                                   SEAPRS.70
C        FIND AN APPROXIMATE TSFC WITHOUT DIURNAL EFFECTS BY USING               SEAPRS.71
C        850MB AND 700MB DATA TO GET TSFCPM.                                     SEAPRS.72
C  IF SFC IS ABOVE 850MB-- USE TEMPS AT 700 AND 500MB FOR TSFCPM                 SEAPRS.73
      DO 100 NN = NF,NL                                                          SEAPRS.74
      IF (RSOND(5,NN) .LT. 1100.) GO TO 15                                       SEAPRS.75
      RSOND(5,NN) = 1.0E33                                                       SEAPRS.76
      BUFSFP(5,NN)=1.0E33                                                        SEAPRS.77
      GO TO 100                                                                  SEAPRS.78
   15 CONTINUE                                                                   SEAPRS.79
C  SET T1 TO AN INITIAL DUMMY VALUE                                              SEAPRS.80
      T1 = 500.                                                                  SEAPRS.81
      PSOND1(3,NN) = PSOND1(3,NN)+273.15                                         SEAPRS.82
      PSOND2(3,NN) = PSOND2(3,NN)+273.15                                         SEAPRS.83
      PSOND3(3,NN) = PSOND3(3,NN)+273.15                                         SEAPRS.84
C  FIND TEMP AT 100MB ABOVE SFC, OR AT 850MB IF TERRAIN IS BELOW 950MB.          SEAPRS.85
      IF (RSOND(5,NN) .LT. 950.) GO TO 20                                        SEAPRS.86
C  LOW TERRAIN                                                                   SEAPRS.87
      P1 = 850.                                                                  SEAPRS.88
      T1 = PSOND1(3,NN)                                                          SEAPRS.89
      T1 = min(T1,1.E15)                                                         SEAPRS.90
      GO TO 40                                                                   SEAPRS.91
   20 CONTINUE                                                                   SEAPRS.92
      P1 = RSOND(5,NN)-100.                                                      SEAPRS.93
      IF (RSOND(5,NN) .LT. 850.) GO TO 30                                        SEAPRS.94
C  MIDDLE TERRAIN                                                                SEAPRS.95
      IF (PSOND1(3,NN) .GT. 400.0 .OR. PSOND2(3,NN) .GT. 400.) GO TO 40          SEAPRS.96
      GAM78 = GRLG78*LOG(PSOND1(3,NN)/PSOND2(3,NN))                              SEAPRS.97
      X78 = GAM78*R/G                                                            SEAPRS.98
      T1 = PSOND2(3,NN)*(P1/700.)**X78                                           SEAPRS.99
      GO TO 40                                                                   SEAPRS.100
   30 CONTINUE                                                                   SEAPRS.101
      IF (RSOND(5,NN) .LT. 700.) GO TO 35                                        SEAPRS.102
C  HIGH TERRAIN                                                                  SEAPRS.103
      IF(PSOND2(3,NN).GT. 400.0 .OR.PSOND3(3,NN).GT. 400.) GO TO 40              SEAPRS.104
      GAM57 = GRLG57*LOG(PSOND2(3,NN)/PSOND3(3,NN))                              SEAPRS.105
      X57 = GAM57*R/G                                                            SEAPRS.106
      T1 = PSOND3(3,NN)*(P1/500.)**X57                                           SEAPRS.107
      GO TO 40                                                                   SEAPRS.108
   35 CONTINUE                                                                   SEAPRS.109
C  VERY HIGH TERRAIN  USE TEMP AT 500MB AS T1,  THEN EXTRAPOLATE DOWN US         SEAPRS.110
C  STANDARD LAPSE RATE                                                           SEAPRS.111
C                                                                                SEAPRS.112
      P1 = 500.                                                                  SEAPRS.113
      T1 = PSOND3(3,NN)                                                          SEAPRS.114
      T1 = min(T1,1.E15)
   40 TSFCPM = T1*(RSOND(5,NN)/P1)**XTERM-273.15                                 SEAPRS.115
C        NOW USE TSFCPM TO GET A SEA LEVEL TEMP WITH A MAX. CONSTRAINT           SEAPRS.116
C        OF 25C.  TBAR IS AVG. BELOW GROUND TEMP. TO SEA LEVEL.  THEN            SEAPRS.117
C        FIND PRES AT SEA LEVEL WITH HYPSOMETRIC EQUA.                           SEAPRS.118
      TSL = TSFCPM + GAMMA*BUFD(5,NN)                                            SEAPRS.119
      TSLC=17.5                                                                  SEAPRS.120
      IF(TSL .LT. TSLC) GO TO 50                                                 SEAPRS.121
      TSL = TSLC                                                                 SEAPRS.122
      IF(TSFCPM .GT. TSLC)TSL = TSL - 0.005*(TSFCPM - TSLC)**2                   SEAPRS.123
  50  TBAR = 0.5*(TSFCPM + TSL) + 273.15                                         SEAPRS.124
      TERM = BUFD(5,NN)*9.8/(287.*TBAR)                                          SEAPRS.125
C                                                                                SEAPRS.126
C---------MAKE PRESSURE CONVERSION AND PLACE RESULT INTO RSOND(5,NN)             SEAPRS.127
      IF(IFOUND(1,NN).EQ.1)THEN                                                  SEAPRS.128
C        REAL SOUNDING                                                           SEAPRS.129
         BUFSFP(5,NN)=RSOND(5,NN)                                                SEAPRS.130
         RSOND(5,NN)=RSOND(5,NN)*EXP(TERM)                                       SEAPRS.131
      ELSE                                                                       SEAPRS.132
C        BOGUS SOUNDING                                                          SEAPRS.133
         TERM=-TERM                                                              SEAPRS.134
         BUFSFP(5,NN)=RSOND(5,NN)*EXP(TERM)                                      SEAPRS.135
      END IF                                                                     SEAPRS.136
      IF (ABS(TBAR) .GE. 400.) RSOND(5,NN) = 1.E34                               SEAPRS.137
 100  CONTINUE                                                                   SEAPRS.138
C                                                                                SEAPRS.139
C---------CONVERSION OF PRESSURE VALUES IS COMPLETE.  RESTORE BUFSFP TO          SEAPRS.140
C         SAVE SURFACE PRESSURE.                                                 SEAPRS.141
      NAME=NAMCOR+10000*2                                                        SEAPRS.142
      CALL WDISK(NAME,BUFSFP,LENBUF,0,LENBUF,CHECK)                              SEAPRS.143
      RETURN                                                                     SEAPRS.144
      END                                                                        SEAPRS.145
