      SUBROUTINE SFCBLN(ID1,ID2,ID3,HORZH,IH1,IH2,IH3,SLAB1,SLAB2,               SFCBLN.1
     .     SLAB3,IS1,IS2,COR,NS,SUM,SUM2,DATAS,IDS1,IDS2,IDS3,                   SFCBLN.2
     .     MDATE,AUTBGW,AUTBGR,NVOL40,PSTA,IFUATIM,IFFGTIM)                      SFCBLN.3
C                                                                                SFCBLN.4
C        PURPOSE: THIS SUBROUTINE ADDS SFC OBS AT UPPER AIR AND                  SFCBLN.5
C                 BOGUS STATIONS TO FIRST GUESS FIELDS FOR SEA                   SFCBLN.6
C                 LVL PRES, U, V, T , AND RH.                                    SFCBLN.7
C-----------------------------------------------------------------------         SFCBLN.8
#include <paramirb.incl>                                                         SFCBLN.9
#include <paramirs.incl>                                                         SFCBLN.10
#include <coma.incl>                                                             SFCBLN.11
#include <comc.incl>                                                             SFCBLN.12
#include <comd.incl>                                                             SFCBLN.13
#include <comwt.incl>                                                            SFCBLN.14
C-----------------------------------------------------------------------         SFCBLN.15
      character*24 mdate                                                         SFCBLN.16
      DIMENSION HORZH(IH1,IH2,IH3),SLAB1(IS1,IS2),SLAB2(IS1,IS2),                SFCBLN.17
     1SLAB3(IS1,IS2),COR(IS1,IS2),NS(IS1,IS2),SUM(IS1,IS2),SUM2(IS1,IS2)         SFCBLN.18
      DIMENSION ASTA(IRS),ASTA1(IRS),XOBS(IRS),YOBS(IRS),IFD(IRS),               SFCBLN.19
     1 ASTAWD(IRS),ASTA2(185)                                                    SFCBLN.20
      character*32 NAMES                                                         SFCBLN.21
      DIMENSION DATAS(IDS1,IDS2,IDS3)                                            SFCBLN.22
      DIMENSION PSTA(IRS)                                                        SFCBLN.23
      DIMENSION MIFSCR(1000,20)                                                  SFCBLN.24
      DATA LVL1 /1/, KTYPE /2/                                                   SFCBLN.25
      REAL KB,LAMBDA                                                             SFCBLN.26
      LOGICAL AUTBGW,AUTBGR,IFUATIM,IFFGTIM                                      SFCBLN.27
C                                                                                SFCBLN.28
C-----------------------------------------------------------------------         SFCBLN.29
C                                                                                SFCBLN.30
C---------NOTES:  FOLLOWING GETRAW, UPPER-AIR SOUNDINGS (INCLUDING               SFCBLN.31
C            SURFACE-LEVEL DATA), ARE STORED IN BUFFER ARRAYS OF                 SFCBLN.32
C            MAXIMUM LENGTH ID3 (UP TO TWO BUFFERS).  THESE DATA                 SFCBLN.33
C            ARE RETRIEVED USING RDISK.  THE SURFACE STATION REPORTS             SFCBLN.34
C            ARE STORED IN THE DATAS ARRAY, BEGINNING AT ID3 + 1.                SFCBLN.35
C               ISTATN (=NSTATN) = TOTAL NO. OF UPPER-AIR REPROTS.               SFCBLN.36
C               JSTATN           = TOTAL NO. OF SFC.-STATION REPORTS.            SFCBLN.37
C            IN GETRAW, A TEST WAS MADE TO ENSURE THAT ISTATN PLUS               SFCBLN.38
C            JSTATN .LE. IDS3, SO THAT NO DATA WILL BE LOST IN SFCBLN            SFCBLN.39
C            PROCESSING.  THE SURFACE-LEVEL DATA OF THE UPPER-AIR                SFCBLN.40
C            REPORTS WILL NOW BE COLLECTED IN BUFD AND RSOND SO THAT             SFCBLN.41
C            THE OBJECTIVE ANALYSIS CAN TAKE PLACE IN ONE STEP.                  SFCBLN.42
C                                                                                SFCBLN.43
C-----------------------------------------------------------------------         SFCBLN.44
      PRINT 10                                                                   SFCBLN.45
   10 FORMAT(//1X,'@@@@@@@@@@ CALL SFCBLN---RDISK,SEAPRS,(FILSLB),OUTP',         SFCBLN.46
     1'PT,$SETANA$,(SLBFIL)'//)                                                  SFCBLN.47
C        SET UP SOME PARAMETERS FOR USE BY OUTPUT                                SFCBLN.48
  15  CONTINUE                                                                   SFCBLN.49
      NF=1                                                                       SFCBLN.50
      NL=0                                                                       SFCBLN.51
      IAA=1                                                                      SFCBLN.52
      JAA=1                                                                      SFCBLN.53
      IBB=IS1                                                                    SFCBLN.54
      JBB=IS2                                                                    SFCBLN.55
C                                                                                SFCBLN.56
C---***---FIRST, ACCESS SURFACE DATA OF UPPER-AIR REPORTS                        SFCBLN.57
C                                                                                SFCBLN.58
C-----WHEN IFUATIM IS .FALSE., THERE ARE NO UPPER-AIR REPORTS                    SFCBLN.59
C     AT THIS TIME.                                                              SFCBLN.60
C     DO NOT SEARCH FOR SURFACE DATA FROM SOUNDINGS.                             SFCBLN.61
      IF(IFUATIM)THEN                                                            SFCBLN.62
      LENBUF=ID1*ID3                                                             SFCBLN.63
C        GET HORIZONTAL LOCATIONS AND ELEVATIONS FROM LOWEST LEVEL               SFCBLN.64
      NAME = NAMCOR + 10000                                                      SFCBLN.65
      CALL RDISK(NAME,BUFUPR,LENBUF,0,LENBUF,CHECK)                              SFCBLN.66
      DO 6 M=1,ID1                                                               SFCBLN.67
      DO 5 L1=1,ID3                                                              SFCBLN.68
      BUFD(M,L1)=BUFUPR(M,L1)                                                    SFCBLN.69
5     CONTINUE                                                                   SFCBLN.70
6     CONTINUE                                                                   SFCBLN.71
      NF = NFSTAC                                                                SFCBLN.72
      NL = NLSTAC                                                                SFCBLN.73
      IF(NF .NE. 1) STOP15                                                       SFCBLN.74
C                                                                                SFCBLN.75
C---------SURFACE DATA IS IN 2ND LEVEL OF SIGNIFICANT LEVEL DATA STORAGE         SFCBLN.76
      NAME=NAMCOR+10000*2                                                        SFCBLN.77
      CALL RDISK(NAME,BUFUPR,LENBUF,0,LENBUF,CHECK)                              SFCBLN.78
      DO 8 M=1,ID1                                                               SFCBLN.79
      DO 7 L1=1,ID3                                                              SFCBLN.80
      RSOND(M,L1)=BUFUPR(M,L1)                                                   SFCBLN.81
      IF(M.EQ.5) PSTA(L1) = RSOND(M,L1)                                          SFCBLN.82
7     CONTINUE                                                                   SFCBLN.83
8     CONTINUE                                                                   SFCBLN.84
C                                                                                SFCBLN.85
C---------OBTAIN SEA-LEVEL PRESSURE FOR SOUNDINGS (AND SURFACE PRESSURE          SFCBLN.86
C         FOR BOGUS SOUNDINGS)                                                   SFCBLN.87
      CALL SEAPRS(LENBUF,1,NF,NL)                                                SFCBLN.88
      ENDIF                                                                      SFCBLN.89
C                                                                                SFCBLN.90
C---***---NOW, MERGE SURFACE-LEVEL DATA FROM SOUNDINGS (NOW IN BUFD,             SFCBLN.91
C         RSOND) AND SURFACE STATION REPORTS (IN DATAS).  ALSO, MERGE            SFCBLN.92
C         REAL/BOGUS IDENTIFIER IN IFOUND (ALSO SEE INACCT).                     SFCBLN.93
      DO 14 J=1,JSTATN                                                           SFCBLN.94
      DO 14 M=1,ID1                                                              SFCBLN.95
      BUFD(M,NL+J)=DATAS(M,1,J)                                                  SFCBLN.96
      RSOND(M,NL+J)=DATAS(M,2,J)                                                 SFCBLN.97
14    CONTINUE                                                                   SFCBLN.98
      NLUPR=NL                                                                   SFCBLN.99
      NL=NL+JSTATN                                                               SFCBLN.100
C                                                                                SFCBLN.101
C---------DATA ACQUISITION IS COMPLETE.  PROCEED TO SET-UP FOR ANALYSIS.         SFCBLN.102
C                                                                                SFCBLN.103
C        OBTAIN FIRST GUESS FIELDS AND PROCESS IN SETANA.  ALWAYS USE            SFCBLN.104
C        CRESSMAN ANALYSIS FOR THE SFC FIELDS(IWTSSF = 6HCRESMN)                 SFCBLN.105
C                                                                                SFCBLN.106
       IWTSSF = 1                                                                SFCBLN.107
      PRINT 17                                                                   SFCBLN.108
   17 FORMAT(78X,'BLEND AT SFC')                                                 SFCBLN.109
C        BETA IS NOT USED FOR SFC - SET BETA ARBITRARILY TO 0.05                 SFCBLN.110
      BETA = 0.05                                                                SFCBLN.111
C USE EITHER THE CRESSMAN SCHEME OR THE MQ SCHEME FOR SFC DATA                   SFCBLN.112
      IF (IWTSCM .NE. 4) THEN                                                    SFCBLN.113
      IWTSSF = 1                                                                 SFCBLN.114
      ELSE                                                                       SFCBLN.115
      IWTSSF = 4                                                                 SFCBLN.116
      ENDIF                                                                      SFCBLN.117
C                                                                                SFCBLN.118
C  ARBITRARILY SET PLSFC > 850MB SO ERRMXT IN SUBR. GETERR WILL BE               SFCBLN.119
C  INCREASED FOR SFC LAYER                                                       SFCBLN.120
C                                                                                SFCBLN.121
      PLSFC=1001.                                                                SFCBLN.122
      IGRID=-1                                                                   SFCBLN.123
C        OBTAIN VARIABLE FIELDS                                                  SFCBLN.124
      LVL = 2                                                                    SFCBLN.125
      IVRBL = IREFPC                                                             SFCBLN.126
      NVRBL=IREFPC                                                               SFCBLN.127
      GO TO 60                                                                   SFCBLN.128
C        SFC U ON NVERT OF IREFC, SFC V ON NVERT OF IREFPD                       SFCBLN.129
  20  LVL = NVERT                                                                SFCBLN.130
      IVRBL = IREFPC                                                             SFCBLN.131
      NVRBL = IUVEL                                                              SFCBLN.132
      NVRBLW=IVVEL                                                               SFCBLN.133
      GO TO 70                                                                   SFCBLN.134
  30  LVL = NVERT                                                                SFCBLN.135
      IVRBL = IREFPD                                                             SFCBLN.136
      NVRBL = IVVEL                                                              SFCBLN.137
      NVRBLW=IUVEL                                                               SFCBLN.138
      GO TO 70                                                                   SFCBLN.139
  40  LVL = 1                                                                    SFCBLN.140
      IVRBL = IREFT                                                              SFCBLN.141
      NVRBL = ITEMP                                                              SFCBLN.142
      GO TO 60                                                                   SFCBLN.143
  50  LVL = 1                                                                    SFCBLN.144
      IVRBL = IREFRH                                                             SFCBLN.145
      NVRBL = IRELH                                                              SFCBLN.146
      GO TO 60                                                                   SFCBLN.147
C        CROSS POINT LOCATIONS NEEDED                                            SFCBLN.148
  60  CONTINUE                                                                   SFCBLN.149
      IGRID=1                                                                    SFCBLN.150
      MVRBL=NVRBL                                                                SFCBLN.151
      IF(NVRBL.EQ.IREFPC) MVRBL=5                                                SFCBLN.152
      DO 65 NN = NF,NL                                                           SFCBLN.153
      XOBS(NN) = BUFD(3,NN)                                                      SFCBLN.154
      YOBS(NN) = BUFD(4,NN)                                                      SFCBLN.155
      ASTA(NN)=RSOND(MVRBL,NN)                                                   SFCBLN.156
      ASTA1(NN)=ASTA(NN)                                                         SFCBLN.157
      IFD(NN) = IFOUND(3,NN)                                                     SFCBLN.158
      MSCHEM(NN) = 1                                                             SFCBLN.159
  65  CONTINUE                                                                   SFCBLN.160
      GO TO 80                                                                   SFCBLN.161
C        DOT POINT LOCATIONS NEEDED                                              SFCBLN.162
  70  DO 75 NN = NF,NL                                                           SFCBLN.163
      XOBS(NN) = BUFD(1,NN)                                                      SFCBLN.164
      YOBS(NN) = BUFD(2,NN)                                                      SFCBLN.165
      ASTA(NN) = RSOND(NVRBL,NN)                                                 SFCBLN.166
      ASTA1(NN)=ASTA(NN)                                                         SFCBLN.167
      ASTAWD(NN)=RSOND(NVRBLW,NN)                                                SFCBLN.168
      IFD(NN) = IFOUND(3,NN)                                                     SFCBLN.169
      MSCHEM(NN) = 1                                                             SFCBLN.170
      IF(IFD(NN) .EQ. 1 .OR. IFD(NN) .EQ. 2) GO TO 75                            SFCBLN.171
      PRINT 72,NN,IFD(NN)                                                        SFCBLN.172
  72  FORMAT(1H0,'WARNING - IFOUND(1',I3,')=',I10)                               SFCBLN.173
  75  CONTINUE                                                                   SFCBLN.174
      IGRID=0                                                                    SFCBLN.175
C        ACCESS FIRST GUESS FIELD                                                SFCBLN.176
  80  CONTINUE                                                                   SFCBLN.177
      DO 82 NN=NF,NL                                                             SFCBLN.178
   82 ELON2(NN)=1.                                                               SFCBLN.179
C                                                                                SFCBLN.180
C---***---DETERMINE IF A FIRST-GUESS SURFACE ANALYSIS EXISTS (IFFGTIM =          SFCBLN.181
C         .TRUE.) OR IF THE BARNES ANALYSIS SHOULD BE USED TO                    SFCBLN.182
C         CREATE A FIRST-GUESS FROM THE DATA BEFORE ENTERING SETANA              SFCBLN.183
C         (IFFGTIM=.FALSE., ALL OTHER TIMES)                                     SFCBLN.184
C                                                                                SFCBLN.185
      IF(.NOT.IFFGTIM)THEN                                                       SFCBLN.186
        IF(.NOT.LAGTEM) THEN                                                     SFCBLN.187
           PRINT 310,NVRBL,MDATE                                                 SFCBLN.188
 310       FORMAT(///1H0,'USING TIME-INTERPOLATED SURFACE FIRST GUESS ',         SFCBLN.189
     .          'FOR NVRBL=',I3,2X,'AT MDATE=',A16)                              SFCBLN.190
           PRINT 310,NVRBL,MDATE(1:16)                                           SFCBLN.191
      READ(NVOL45) IV3FLAG                                                       SFCBLN.192
      if (IV3FLAG .NE. 1) then                                                   SFCBLN.193
         print*, 'Unexpected header.'                                            SFCBLN.194
         call abort                                                              SFCBLN.195
      endif                                                                      SFCBLN.196
      read(nvol45) iscr                                                          SFCBLN.197
      READ(NVOL45)SLAB1                                                          SFCBLN.198
        ENDIF                                                                    SFCBLN.199
      IF(LAGTEM) THEN                                                            SFCBLN.200
 311     FORMAT(///1H0,'USING 3-HR LAG TIME FOR SURFACE FIRST GUESS ',           SFCBLN.201
     .        'FOR NVRBL=',I3,2X,'AT MDATE=',A16)                                SFCBLN.202
         PRINT 311,NVRBL,MDATE(1:16)                                             SFCBLN.203
         CALL FILSLB(LVL,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                SFCBLN.204
      END IF                                                                     SFCBLN.205
#if defined (_THIS_IS_FOR_BARNES )
*******                                                                          SFCBLN.207
I have ifdef-ed this out, because it is avoided by GOTO anyway.                  SFCBLN.208
It has not been active for several years, but we keep it in just                 SFCBLN.209
in case somebody someday wants to try to get it going again.                     SFCBLN.210
*******                                                                          SFCBLN.211
      GO TO 5439                                                                 SFCBLN.212
      KB=40000.                                                                  SFCBLN.213
      LAMBDA=0.35                                                                SFCBLN.214
C DO PRE-BARNES GROSS CHECKS:                                                    SFCBLN.215
      FLAG=1.0E6                                                                 SFCBLN.216
CCC                                                                              SFCBLN.217
      IF(LVL.EQ.2.AND.NVRBL.EQ.IREFPC)THEN                                       SFCBLN.218
C SLP (MB)                                                                       SFCBLN.219
      DO 1000 NN=NF,NL                                                           SFCBLN.220
      IF(ASTA1(NN).GE.FLAG) GO TO 1000                                           SFCBLN.221
      IF(ASTA1(NN).LE.900..OR.ASTA1(NN).GE.1100.) THEN                           SFCBLN.222
      PRINT 1005,ASTA1(NN),XOBS(NN),YOBS(NN),NN                                  SFCBLN.223
1005  FORMAT(1X,'PRE-BARNES GROSS CHECK: TOSSING SLP = ',E12.5,                  SFCBLN.224
     1' AT XOBS = ',F7.2,', YOBS = ',F7.2,', AND NN = ',I4)                      SFCBLN.225
      ASTA1(NN)=FLAG                                                             SFCBLN.226
      ENDIF                                                                      SFCBLN.227
1000  CONTINUE                                                                   SFCBLN.228
      ENDIF                                                                      SFCBLN.229
CCC                                                                              SFCBLN.230
CCC                                                                              SFCBLN.231
      IF(LVL.EQ.NVERT.AND.NVRBL.EQ.IUVEL)THEN                                    SFCBLN.232
C SFC U (M/S)                                                                    SFCBLN.233
      DO 2000 NN=NF,NL                                                           SFCBLN.234
      IF(ASTA1(NN).GE.FLAG) GO TO 2000                                           SFCBLN.235
      IF(ABS(ASTA1(NN)).GE.100.) THEN                                            SFCBLN.236
      PRINT 2005,ASTA1(NN),XOBS(NN),YOBS(NN),NN                                  SFCBLN.237
2005  FORMAT(1X,'PRE-BARNES GROSS CHECK: TOSSING SFC U = ',E12.5,                SFCBLN.238
     1' AT XOBS = ',F7.2,', YOBS = ',F7.2,', AND NN = ',I4)                      SFCBLN.239
      ASTA1(NN)=FLAG                                                             SFCBLN.240
      ENDIF                                                                      SFCBLN.241
2000  CONTINUE                                                                   SFCBLN.242
      ENDIF                                                                      SFCBLN.243
CCC                                                                              SFCBLN.244
CCC                                                                              SFCBLN.245
      IF(LVL.EQ.NVERT.AND.NVRBL.EQ.IVVEL)THEN                                    SFCBLN.246
C SFC V (M/S)                                                                    SFCBLN.247
      DO 3000 NN=NF,NL                                                           SFCBLN.248
      IF(ASTA1(NN).GE.FLAG) GO TO 3000                                           SFCBLN.249
      IF(ABS(ASTA1(NN)).GE.100.) THEN                                            SFCBLN.250
      PRINT 3005,ASTA1(NN),XOBS(NN),YOBS(NN),NN                                  SFCBLN.251
3005  FORMAT(1X,'PRE-BARNES GROSS CHECK: TOSSING SFC V = ',E12.5,                SFCBLN.252
     1' AT XOBS = ',F7.2,', YOBS = ',F7.2,', AND NN = ',I4)                      SFCBLN.253
      ASTA1(NN)=FLAG                                                             SFCBLN.254
      ENDIF                                                                      SFCBLN.255
3000  CONTINUE                                                                   SFCBLN.256
      ENDIF                                                                      SFCBLN.257
CCC                                                                              SFCBLN.258
CCC                                                                              SFCBLN.259
      IF(LVL.EQ.1.AND.NVRBL.EQ.ITEMP)THEN                                        SFCBLN.260
C SFC T (C)                                                                      SFCBLN.261
      DO 4000 NN=NF,NL                                                           SFCBLN.262
      IF(ASTA1(NN).GE.FLAG) GO TO 4000                                           SFCBLN.263
      IF(ABS(ASTA1(NN)).GE.60.) THEN                                             SFCBLN.264
      PRINT 4005,ASTA1(NN),XOBS(NN),YOBS(NN),NN                                  SFCBLN.265
4005  FORMAT(1X,'PRE-BARNES GROSS CHECK: TOSSING SFC T = ',E12.5,                SFCBLN.266
     1' AT XOBS = ',F7.2,', YOBS = ',F7.2,', AND NN = ',I4)                      SFCBLN.267
      ASTA1(NN)=FLAG                                                             SFCBLN.268
      ENDIF                                                                      SFCBLN.269
4000  CONTINUE                                                                   SFCBLN.270
      ENDIF                                                                      SFCBLN.271
CCC                                                                              SFCBLN.272
CCC                                                                              SFCBLN.273
      IF(LVL.EQ.1.AND.NVRBL.EQ.IRELH)THEN                                        SFCBLN.274
C SFC RH (PERCENT)                                                               SFCBLN.275
      DO 5000 NN=NF,NL                                                           SFCBLN.276
      IF(ASTA1(NN).GE.FLAG) GO TO 5000                                           SFCBLN.277
      IF(ASTA1(NN).LT.0..OR.ASTA1(NN).GT.125.) THEN                              SFCBLN.278
      PRINT 4005,ASTA1(NN),NN,XOBS(NN),YOBS(NN)                                  SFCBLN.279
5005  FORMAT(1X,'PRE-BARNES GROSS CHECK: TOSSING SFC RH = ',E12.5,               SFCBLN.280
     1' AT XOBS = ',F7.2,', YOBS = ',F7.2,', AND NN = ',I4)                      SFCBLN.281
      ASTA1(NN)=FLAG                                                             SFCBLN.282
      ENDIF                                                                      SFCBLN.283
      IF(ASTA1(NN).GT.100..AND.ASTA1(NN).LE.125.) ASTA1(NN)=99.99                SFCBLN.284
5000  CONTINUE                                                                   SFCBLN.285
      ENDIF                                                                      SFCBLN.286
CCC                                                                              SFCBLN.287
CCC                                                                              SFCBLN.288
C  ASTA1 IS A DUMMY ARRAY THAT CONTAINS THE OBS.                                 SFCBLN.289
C  IN SUBROUTINE BARNES ASTA1 IS CHANGED.                                        SFCBLN.290
CCC                                                                              SFCBLN.291
      CALL BARNES(NL,ASTA1,XOBS,YOBS,IDS3,SLAB1,IS2,IS1,KB,LAMBDA,               SFCBLN.292
     1SLAB2,SLAB3,COR,NS,DS,IGRID,FLAG)                                          SFCBLN.293
C                                                                                SFCBLN.294
 5439 CONTINUE                                                                   SFCBLN.295
#endif                                                                           SFCBLN.296
      ELSE                                                                       SFCBLN.297
      CALL FILSLB(LVL,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                   SFCBLN.298
      ENDIF                                                                      SFCBLN.299
      IF(.NOT.DRAWM) GO TO 84                                                    SFCBLN.300
      WRITE(NAMES,85)LVL,IVAR(3,IVRBL)                                       SFC SFCBLN.301
  85  FORMAT('INCOMING LEVEL =',I2,3X,'IVRBL=',I3,2X)                            SFCBLN.302
      KM = NVERT                                                                 SFCBLN.303
      IF (LVL.EQ.2  .AND.IVAR(3,IVRBL).EQ.6 ) WRITE (6,131) MDATE(1:16)          SFCBLN.304
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.6 ) WRITE (6,132) MDATE(1:16)          SFCBLN.305
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.9 ) WRITE (6,133) MDATE(1:16)          SFCBLN.306
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.7 ) WRITE (6,134) MDATE(1:16)          SFCBLN.307
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.18) WRITE (6,135) MDATE(1:16)          SFCBLN.308
 131  FORMAT(/16X,'SL PRESSURE AT CROSS PTS--(1ST GUESS) AT TIME ',A16)          SFCBLN.309
 132  FORMAT(/16X,'SFC U-COMP AT DOT PTS---(1ST GUESS) AT TIME ',A16)            SFCBLN.310
 133  FORMAT(/16X,'SFC V-COMP AT DOT PTS---(1ST GUESS) AT TIME ',A16)            SFCBLN.311
 134  FORMAT(/16X,'SFC TEMP AT CROSS PTS---(1ST GUESS) AT TIME ',A16)            SFCBLN.312
 135  FORMAT(/16X,'RH(1000MB) AT CROSS PTS-(1ST GUESS) AT TIME ',A16)            SFCBLN.313
      ILB=IVAR(3,IVRBL)                                                          SFCBLN.314
      IF (LVL.EQ.2  .AND.IVAR(3,IVRBL).EQ.6 ) ICD=1                              06NOV00.525
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.6 ) ICD=0                              06NOV00.526
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.9 ) ICD=0                              06NOV00.527
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.7 ) ICD=1                              06NOV00.528
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.18) ICD=1                              06NOV00.529
      CALL OUTPT(SLAB1,IS1,IAA,IBB-ICD,INY,IS2,JAA,JBB-ICD,JNX,KSIGT,            SFCBLN.320
     &      NAMES,ILB)                                                           SFCBLN.321
   84 IF(NVRBL.NE.IRELH) GO TO 870                                               SFCBLN.322
      DO 850 NN = NF,NL                                                          SFCBLN.323
      IF(ASTA(NN).GT.1.0E6) GO TO 850                                            SFCBLN.324
      IF (ASTA(NN) .GT. 99.99) ASTA(NN) = 99.99                                  SFCBLN.325
      IF (ASTA(NN) .LT. 0.0) ASTA(NN) = 0.0                                      SFCBLN.326
      ASTA(NN) = SQRT(1.0 - (ASTA(NN)/100.))                                     SFCBLN.327
 850  CONTINUE                                                                   SFCBLN.328
      DO 860 I = 1,IE                                                            SFCBLN.329
      DO 860 J = 1,JE                                                            SFCBLN.330
      IF (SLAB1(I,J) .GT. 99.99) SLAB1(I,J) = 99.99                              SFCBLN.331
      IF (SLAB1(I,J) .LT. 0.0  ) SLAB1(I,J) = 0.0                                SFCBLN.332
 860  SLAB1(I,J) = SQRT(1.0 - (SLAB1(I,J)/100.))                                 SFCBLN.333
 870  CONTINUE                                                                   SFCBLN.334
  90  CONTINUE                                                                   SFCBLN.335
      CALL SETANA(SLAB1,SLAB2,SLAB3,ASTA,ASTA1,XOBS,YOBS,IS1,IS2,                SFCBLN.336
     .     NL  ,DS,RINSFC,IFAC,NVRBL,IFD,ERRMXW,ERRMXT,ERRMXP,                   SFCBLN.337
     .     IWTSSF,BETA,PLSFC,1,ISTNUM,COR,NS,SUM,SUM2,ASTAWD,KTYPE,              SFCBLN.338
     .     LVL1,MDATE,AUTBGW,AUTBGR,NVOL40,RANG,LAGTEM,IFUATIM)                  SFCBLN.339
      IF(NVRBL.EQ.IUVEL.OR.NVRBL.EQ.IVVEL) GO TO 92                              SFCBLN.340
      IF(.NOT.SMOOTH) GO TO 92                                                   SFCBLN.341
      DO 86 I=1,IE                                                               SFCBLN.342
   86 SLAB1(I,JMAX)=SLAB1(I,JE)                                                  SFCBLN.343
      DO 87 J=1,JMAX                                                             SFCBLN.344
   87 SLAB1(IMAX,J)=SLAB1(IE,J)                                                  SFCBLN.345
      CALL SMTHER(SLAB1,IS1,IS2)                                                 SFCBLN.346
   92 CONTINUE                                                                   SFCBLN.347
C        DO NOT BOTHER USING SMOOTHER ON SFC FIELDS.  REMOVE ALL VERY            SFCBLN.348
C        LOW VALUES OF REL. HUM.                                                 SFCBLN.349
      IF(NVRBL .NE. IRELH) GO TO 110                                             SFCBLN.350
      DO 100 I = 1,IS1                                                           SFCBLN.351
      DO 100 J = 1,IS2                                                           SFCBLN.352
      IF(SLAB1(I,J) .GT. 0.9487)SLAB1(I,J) = 0.9487                              SFCBLN.353
 100  CONTINUE                                                                   SFCBLN.354
 110  CONTINUE                                                                   SFCBLN.355
      IF(NVRBL .NE. IRELH) GO TO 125                                             SFCBLN.356
      DO 120 I=1,IMAX                                                            SFCBLN.357
      DO 120 J=1,JMAX                                                            SFCBLN.358
 120  SLAB1(I,J) = 100.*(1.0 -(SLAB1(I,J)*SLAB1(I,J)))                           SFCBLN.359
 125  CONTINUE                                                                   SFCBLN.360
      IF(.NOT.DRAWM) GO TO 140                                                   SFCBLN.361
      WRITE(NAMES,130)LVL,IVAR(3,IVRBL)                                      SFC SFCBLN.362
 130  FORMAT('OUTGOING LEVEL =',I2,3X,'IVRBL=',I3,2X)                            SFCBLN.363
      IF (LVL.EQ.2  .AND.IVAR(3,IVRBL).EQ.6 ) WRITE (6,141) MDATE(1:16)          SFCBLN.364
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.6 ) WRITE (6,142) MDATE(1:16)          SFCBLN.365
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.9 ) WRITE (6,143) MDATE(1:16)          SFCBLN.366
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.7 ) WRITE (6,144) MDATE(1:16)          SFCBLN.367
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.18) WRITE (6,145) MDATE(1:16)          SFCBLN.368
 141  FORMAT(///16X,'SL PRESSURE AT CROSS PTS--(OBJ-ANAL) AT TIME ',A16)         SFCBLN.369
 142  FORMAT(///16X,'SFC U-COMP AT DOT PTS---(OBJ-ANAL) AT TIME ',A16)           SFCBLN.370
 143  FORMAT(///16X,'SFC V-COMP AT DOT PTS---(OBJ-ANAL) AT TIME ',A16)           SFCBLN.371
 144  FORMAT(///16X,'SFC TEMP AT CROSS PTS---(OBJ-ANAL) AT TIME ',A16)           SFCBLN.372
 145  FORMAT(///16X,'SFC R.H. AT CROSS PTS---(OBJ-ANAL) AT TIME ',A16)           SFCBLN.373
      ILB=IVAR(3,IVRBL)                                                          SFCBLN.374
      IF (LVL.EQ.2  .AND.IVAR(3,IVRBL).EQ.6 ) ICD=1                              06NOV00.530
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.6 ) ICD=0                              06NOV00.531
      IF (LVL.EQ.KM .AND.IVAR(3,IVRBL).EQ.9 ) ICD=0                              06NOV00.532
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.7 ) ICD=1                              06NOV00.533
      IF (LVL.EQ.1  .AND.IVAR(3,IVRBL).EQ.18) ICD=1                              06NOV00.534
      CALL OUTPT(SLAB1,IS1,IAA,IBB-ICD,INY,IS2,JAA,JBB-ICD,JNX,KSIGT,            SFCBLN.380
     &           NAMES,ILB)                                                      SFCBLN.381
 140  CALL SLBFIL(LVL,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                   SFCBLN.382
      IF(NVRBL.EQ.IREFPC) GO TO 20                                               SFCBLN.383
      IF(NVRBL.EQ.IUVEL)THEN                                                     SFCBLN.384
C         CHECK NO. OF WIND OBS. IN EACH GRID BOX;  SAVE FOR OUTFDA              SFCBLN.385
      DO 160 I=1,IMAX                                                            SFCBLN.386
      DO 160 J=1,JMAX                                                            SFCBLN.387
160   SUM(I,J)=0.0                                                               SFCBLN.388
      DO 170 NN=NF,NL                                                            SFCBLN.389
      JXOBS=XOBS(NN)                                                             SFCBLN.390
      IYOBS=YOBS(NN)                                                             SFCBLN.391
      IF (ASTA(NN).LT.200.) SUM(IYOBS,JXOBS)=SUM(IYOBS,JXOBS)+1.0000001          SFCBLN.392
170   CONTINUE                                                                   SFCBLN.393
      CALL SLBFIL(NVERT,IREFH,1,HORZH,IH1,IH2,IH3,SUM,IS1,IS2)                   SFCBLN.394
      DO 152 NN=NF,NL                                                            SFCBLN.395
      RSOND(IUVEL,NN)=ASTA(NN)                                                   SFCBLN.396
      IF(ASTA(NN).GE.1.E29)RSOND(IVVEL,NN)=ASTA(NN)                              SFCBLN.397
152   CONTINUE                                                                   SFCBLN.398
      GO TO 30                                                                   SFCBLN.399
      ENDIF                                                                      SFCBLN.400
      IF(NVRBL .EQ. IVVEL) GO TO 40                                              SFCBLN.401
      IF(NVRBL.EQ.ITEMP)THEN                                                     SFCBLN.402
      DO 154 NN=NF,NL                                                            SFCBLN.403
      RSOND(ITEMP,NN)=ASTA(NN)                                                   SFCBLN.404
      IF(ASTA(NN).GE.1.E29)RSOND(IRELH,NN)=ASTA(NN)                              SFCBLN.405
154   CONTINUE                                                                   SFCBLN.406
      GO TO 50                                                                   SFCBLN.407
      ENDIF                                                                      SFCBLN.408
      IF(NVRBL .EQ. IRELH) GO TO 200                                             SFCBLN.409
      STOP140                                                                    SFCBLN.410
 200  CONTINUE                                                                   SFCBLN.411
      IF (.NOT.IFFGTIM) then                                                     SFCBLN.412
         read(NVOL45) iv3flag                                                    SFCBLN.413
      ELSE                                                                       SFCBLN.414
         if (LAGTEM) THEN                                                        SFCBLN.415
            read(NVOL45) iv3flag                                                 SFCBLN.416
         endif                                                                   SFCBLN.417
      ENDIF                                                                      SFCBLN.418
      RETURN                                                                     SFCBLN.419
      END                                                                        SFCBLN.420
