      SUBROUTINE SFCLUP (NREP, NS, GSZ, GSW, GSS)                                SFCLUP.1
                                                                                 SFCLUP.2
C***********************************************************************         SFCLUP.3
C  SFCLUP       -  STORM FRONT CLEAN UP SIGNIFICANT LEVEL DATA                   SFCLUP.4
C  PURPOSE      -  TO CLEAN UP THE DATA ON SIGNIFICANT LEVELS WITH RESPE         SFCLUP.5
C                  THE WINDS                                                     SFCLUP.6
C                                                                                SFCLUP.7
C  ON ENTRY     -  NREP   -  THE NUMBER OF REPORTS IN THE DATA                   SFCLUP.8
C                  NS     -  THE NUMBER OF LEVELS GIVEN FOR EACH REPORT          SFCLUP.9
C                  GSZ    -  GEOPOTENTIAL HEIGHT                                 SFCLUP.10
C                  GSW    -  WIND DIRECTIONS                                     SFCLUP.11
C                  GSS    -  WIND SPEEDS                                         SFCLUP.12
C                                                                                SFCLUP.13
C  ON EXIT      -  THE GLOBALS GIVEN BELOW HAVE BEEN SET UP                      SFCLUP.14
C                                                                                SFCLUP.15
C  GLOBALS      -  ZW     -  GEOPOTENTIAL HEIGHT ON SIGNIFICANT LEVELS W         SFCLUP.16
C                            RESPECT TO THE WIND FIELDS                          SFCLUP.17
C                  SPDW   -  WIND SPEEDS ON SIGNIFICANT LEVELS WITH RESP         SFCLUP.18
C                            TO THE WIND FIELDS                                  SFCLUP.19
C                  DIRW   -  WIND DIRECTIONS ON SIGNIFICANT LEVELS WITH          SFCLUP.20
C                            PECT TO THE WIND FIELDS                             SFCLUP.21
C                  SNLV   -  THEN NUMBER OF VERTICAL LEVELS PER REPORT           SFCLUP.22
C                                                                                SFCLUP.23
C  SIDE EFFECTS -  NONE                                                          SFCLUP.24
C                                                                                SFCLUP.25
C  AUTHOR       -  JEREMY ASBILL                                                 SFCLUP.26
C  DATE         -  SEPTEMBER 5, 1991                                             SFCLUP.27
C  FOR          -  THE MM4 CLUB (& STORMFEST)                                    SFCLUP.28
C***********************************************************************         SFCLUP.29
                                                                                 SFCLUP.30
C                                                                                SFCLUP.31
C  INCLUDE FILES                                                                 SFCLUP.32
C                                                                                SFCLUP.33
      INTEGER  MAXREP,SIDMAX,NUMANT,NUMSIG,TROPLV,SIGNIF                         SFCLUP.34
C                                                                                SFCLUP.35
      PARAMETER (MAXREP = 700, SIDMAX = 12, NUMANT = 20, NUMSIG = 50)            SFCLUP.36
      PARAMETER (MAXLEV = 70,  NMSIGW = 50,  MANSFC = 1)                         SFCLUP.37
      PARAMETER (TROPLV = 5,  SIGNIF = 4,   MAXWIN = 6,  MANDAT = 3)             SFCLUP.38
C                                                                                SFCLUP.39
      INTEGER  SRC(MAXLEV,MAXREP),PNLV(MAXREP),SNLV(MAXREP),                     SFCLUP.40
     1         IDRAOB(MAXREP)                                                    SFCLUP.41
C                                                                                SFCLUP.42
      REAL  LATU(MAXREP),LONU(MAXREP),ELVU(MAXREP)                               SFCLUP.43
C                                                                                SFCLUP.44
      DIMENSION  PU(MAXLEV,MAXREP),ZU(MAXLEV,MAXREP),TU(MAXLEV,MAXREP),          SFCLUP.45
     1 TDU(MAXLEV,MAXREP),SPDU(MAXLEV,MAXREP),DIRU(MAXLEV,MAXREP),               SFCLUP.46
     1 ZW(NUMSIG,MAXREP),DIRW(NUMSIG,MAXREP),SPDW(NUMSIG,MAXREP)                 SFCLUP.47
C                                                                                SFCLUP.48
#include <comuni.incl>                                                           SFCLUP.49
C                                                                                SFCLUP.50
      CHARACTER*(SIDMAX) STIDU(MAXREP)                                           SFCLUP.51
C                                                                                SFCLUP.52
C  PARAMETER LIST                                                                SFCLUP.53
C                                                                                SFCLUP.54
                                                                                 SFCLUP.55
      INTEGER NREP, NS(MAXREP)                                                   SFCLUP.56
      REAL    GSZ(NUMSIG, MAXREP), GSW(NUMSIG, MAXREP),                          SFCLUP.57
     *        GSS(NUMSIG, MAXREP)                                                SFCLUP.58
                                                                                 SFCLUP.59
C                                                                                SFCLUP.60
C  LOCAL VARIABLES                                                               SFCLUP.61
C                                                                                SFCLUP.62
C  COUNT    -  THE NUMBER OF SIGNIFICANT LEVELS IN THE DATA                      SFCLUP.63
C  L,R      -  LOOP COUNTERS                                                     SFCLUP.64
C                                                                                SFCLUP.65
                                                                                 SFCLUP.66
      INTEGER COUNT, L, R                                                        SFCLUP.67
                                                                                 SFCLUP.68
C****************************  SUBROUTINE BEGIN  ***********************         SFCLUP.69
                                                                                 SFCLUP.70
C                                                                                SFCLUP.71
C  CYCLE THROUGH THE REPORTS, TO CLEAN UP THE ARRAYS FOR EACH                    SFCLUP.72
C                                                                                SFCLUP.73
                                                                                 SFCLUP.74
      DO 10 R = 1, NREP                                                          SFCLUP.75
                                                                                 SFCLUP.76
C                                                                                SFCLUP.77
C  CYCLE THROUGH THE LEVELS AND TAKE OUT ANY LEVELS WITH NO                      SFCLUP.78
C  GEOPOTENTIAL HEIGHT                                                           SFCLUP.79
C                                                                                SFCLUP.80
                                                                                 SFCLUP.81
         COUNT = 0                                                               SFCLUP.82
         DO 20 L = 1, NS(R)                                                      SFCLUP.83
            IF (NINT(GSZ(L, R)) .NE. -9999) THEN                                 SFCLUP.84
               COUNT = COUNT + 1                                                 SFCLUP.85
               ZW(COUNT, R) = GSZ(L, R)                                          SFCLUP.86
               SPDW(COUNT, R) = GSS(L, R)                                        SFCLUP.87
               DIRW(COUNT, R) = GSW(L, R)                                        SFCLUP.88
            END IF                                                               SFCLUP.89
20       CONTINUE                                                                SFCLUP.90
                                                                                 SFCLUP.91
C                                                                                SFCLUP.92
C  SAVE THE NUMBER OF LEVELS IN THE REPORT                                       SFCLUP.93
C                                                                                SFCLUP.94
                                                                                 SFCLUP.95
         SNLV(R) = COUNT                                                         SFCLUP.96
10    CONTINUE                                                                   SFCLUP.97
C*****************************  SUBROUTINE END  ************************         SFCLUP.98
      RETURN                                                                     SFCLUP.99
      END                                                                        SFCLUP.100
