      SUBROUTINE SFSCVT (NREP,SFNAM)                                             SFSCVT.1
#if defined (NONETCDF)
      character*10 sfnam                                                         SFSCVT.3
      NREP=0                                                                     SFSCVT.4
#else                                                                            SFSCVT.5
                                                                                 SFSCVT.6
C***********************************************************************         SFSCVT.7
C  SFSCVT       -  STORM FRONT SURFACE CONVERTED DATA READER                     SFSCVT.8
C  PURPOSE      -  TO READ IN ALL SURFACE DATA REPORTS FROM THE SURFACE          SFSCVT.9
C                  CONVERTED DATA                                                SFSCVT.10
C                                                                                SFSCVT.11
C  ON ENTRY     -  THE SURFACE CONVERTED DATA FILE MUST BE IN THE CURREN         SFSCVT.12
C                  WORKING DIRECTORY AND MUST BE NAMED "DATA.CVT"                SFSCVT.13
C                                                                                SFSCVT.14
C  ON EXIT      -  NREP   -  THE NUMBER OF REPORTS STORED IN THE GLOBALS         SFSCVT.15
C                            LISTED BELOW                                        SFSCVT.16
C                                                                                SFSCVT.17
C  GLOBALS      -  COMMON BLOCK SCVTCH:                                          SFSCVT.18
C                  STID   -  A LIST OF REPORTING STATION IDS                     SFSCVT.19
C                  COMMON BLOCK SCVTNM:                                          SFSCVT.20
C                  TIME   -  THE REPORT TIMES                                    SFSCVT.21
C                  LAT    -  THE STATION LATITUDES IN DEGREES NORTH              SFSCVT.22
C                  LON    -  THE STATION LONGITUDES IN DEGREES EAST              SFSCVT.23
C                  ELEV   -  THE STATION ELEVATIONS IN METERS                    SFSCVT.24
C                  TEMP   -  THE TEMPERATURES IN DEGREES CELCIUS                 SFSCVT.25
C                  TD     -  THE DEWPOINT TEMPERATURES IN DEGREES CELCIU         SFSCVT.26
C                  SLP    -  THE SEA LEVEL PRESSURES IN HECTOPASCALS             SFSCVT.27
C                  SPEED  -  THE WIND SPEEDS IN METERS PER SECOND                SFSCVT.28
C                  WDIR   -  THE WIND DIRECTIONS IN DEGREES                      SFSCVT.29
C                                                                                SFSCVT.30
C  SIDE EFFECTS -  OPENS AND CLOSES THE "DATA.CVT" FILE                          SFSCVT.31
C                                                                                SFSCVT.32
C  AUTHOR       -  JEREMY ASBILL                                                 SFSCVT.33
C  DATE         -  AUGUST 19, 1991                                               SFSCVT.34
C  FOR          -  THE MM4 CLUB (& STORMFEST)                                    SFSCVT.35
C***********************************************************************         SFSCVT.36
                                                                                 SFSCVT.37
C                                                                                SFSCVT.38
C  INCLUDE FILES                                                                 SFSCVT.39
C                                                                                SFSCVT.40
                                                                                 SFSCVT.41
#include <netcdf.incl>                                                           SFSCVT.42
C                                                                                SFSCVT.43
      INTEGER  SIDMAX,TIMLEN                                                     SFSCVT.44
      CHARACTER*10 SFNAM                                                         SFSCVT.45
C                                                                                SFSCVT.46
      PARAMETER (MAXSFC = 3000, SIDMAX = 12, TIMLEN = 20)                        SFSCVT.47
      PARAMETER (LIMSID = 1200, LIMTIM = 740)                                    SFSCVT.48
C                                                                                SFSCVT.49
      REAL  LAT(MAXSFC),LON(MAXSFC),ELEV(MAXSFC)                                 SFSCVT.50
C                                                                                SFSCVT.51
      DIMENSION TD(MAXSFC),SLP(MAXSFC),SPEED(MAXSFC),WDIR(MAXSFC),               SFSCVT.52
     1 TEMP(MAXSFC)                                                              SFSCVT.53
C                                                                                SFSCVT.54
      INTEGER  TIME(MAXSFC)                                                      SFSCVT.55
C                                                                                SFSCVT.56
#include <comscv.incl>                                                           SFSCVT.57
C                                                                                SFSCVT.58
      CHARACTER*(SIDMAX) STID(MAXSFC)                                            SFSCVT.59
C                                                                                SFSCVT.60
C  PARAMETER LIST                                                                SFSCVT.61
C                                                                                SFSCVT.62
                                                                                 SFSCVT.63
      INTEGER NREP                                                               SFSCVT.64
                                                                                 SFSCVT.65
C                                                                                SFSCVT.66
C  LOCAL VARIABLES                                                               SFSCVT.67
C                                                                                SFSCVT.68
C  COUNT    -  THE NUMBER OF VALUES TO READ IN FROM THE NETCDF FILE              SFSCVT.69
C  CTIME    -  A CHARACTER VERSION OF THE TIME OF THE REPORT                     SFSCVT.70
C  CVTID    -  THE NETCDF ID UNDER WHICH THE "DATA.CVT" FILE IS OPENED           SFSCVT.71
C  ERROR    -  INDICATES WHEN AN ERROR OCCURS                                    SFSCVT.72
C  I,J,K    -  LOOP COUNTERS / PLACE KEEPERS                                     SFSCVT.73
C  SAVE     -  USED TO SAVE THE NUMBER OF STRINGS LEFT TO PROCESS                SFSCVT.74
C  START    -  WHERE TO START READING IN FROM A NETCDF FILE                      SFSCVT.75
C  STLIS    -  CONTAINS A LIST OF ALL REPORTING STATIONS                         SFSCVT.76
C  STRNG    -  USED TO INTERFACE WITH "NCDINQ"                                   SFSCVT.77
C  TIMLS    -  USED TO READ OUT ALL TIMES BEFORE CONVERTING THEM TO INTE         SFSCVT.78
C  TMP      -  USED IN CONVERTING THE REPORT TIME TO AN INTEGER                  SFSCVT.79
C  TMPID    -  A GENERIC NETCDF ID VARIABLE                                      SFSCVT.80
C                                                                                SFSCVT.81
                                                                                 SFSCVT.82
      CHARACTER*(SIDMAX * LIMSID) STLIS                                          SFSCVT.83
      CHARACTER*(TIMLEN * LIMTIM) TIMLS                                          SFSCVT.84
      CHARACTER*80                STRNG, CTIME                                   SFSCVT.85
      INTEGER                     TMPID, ERROR, COUNT(2), START(2),              SFSCVT.86
     *                            I, J, K, TMP, CVTID, SAVE                      SFSCVT.87
                                                                                 SFSCVT.88
C****************************  SUBROUTINE BEGIN  ***********************         SFSCVT.89
                                                                                 SFSCVT.90
C                                                                                SFSCVT.91
C  OPEN THE "DATA.CVT" FILE                                                      SFSCVT.92
C                                                                                SFSCVT.93
                                                                                 SFSCVT.94
      PRINT 854, SFNAM                                                           SFSCVT.95
 854  FORMAT ('NCOPN-ING ', A10)                                                 SFSCVT.96
      CVTID = NCOPN (SFNAM, NCNOWRIT, ERROR)                                     SFSCVT.97
                                                                                 SFSCVT.98
C                                                                                SFSCVT.99
C  GET THE NUMBER OF REPORTS FROM THE NETCDF FILE                                SFSCVT.100
C                                                                                SFSCVT.101
                                                                                 SFSCVT.102
      TMPID = NCDID (CVTID, 'report', ERROR)                                     SFSCVT.103
      CALL NCDINQ (CVTID, TMPID, STRNG, NREP, ERROR)                             SFSCVT.104
      SAVE = NREP                                                                SFSCVT.105
                                                                                 SFSCVT.106
C                                                                                SFSCVT.107
C  DETEMINE THE LENGTH OF THE STATION IDS                                        SFSCVT.108
C                                                                                SFSCVT.109
                                                                                 SFSCVT.110
      TMPID = NCDID (CVTID, 'id_len', ERROR)                                     SFSCVT.111
      CALL NCDINQ (CVTID, TMPID, STRNG, COUNT(1), ERROR)                         SFSCVT.112
                                                                                 SFSCVT.113
C                                                                                SFSCVT.114
C  GET THE LIST OF REPORTING STATIONS VARIABLE ID                                SFSCVT.115
C                                                                                SFSCVT.116
                                                                                 SFSCVT.117
      TMPID = NCVID (CVTID, 'id', ERROR)                                         SFSCVT.118
      START(1) = 1                                                               SFSCVT.119
      START(2) = 1                                                               SFSCVT.120
                                                                                 SFSCVT.121
C                                                                                SFSCVT.122
C  SET UP TO READ THE FIRST LIMSID OR LESS STATION IDS                           SFSCVT.123
C                                                                                SFSCVT.124
                                                                                 SFSCVT.125
                                                                                 SFSCVT.126
      K = 0                                                                      SFSCVT.127
5     CONTINUE                                                                   SFSCVT.128
         IF (SAVE .GT. LIMSID) THEN                                              SFSCVT.129
            COUNT(2) = LIMSID                                                    SFSCVT.130
            SAVE     = SAVE - LIMSID                                             SFSCVT.131
         ELSE                                                                    SFSCVT.132
            COUNT(2) = SAVE                                                      SFSCVT.133
            SAVE     = 0                                                         SFSCVT.134
         END IF                                                                  SFSCVT.135
         CALL NCVGTC (CVTID, TMPID, START, COUNT, STLIS,                         SFSCVT.136
     *                SIDMAX * COUNT(2), ERROR)                                  SFSCVT.137
         START(2) = START(2) + COUNT(2)                                          SFSCVT.138
C                                                                                SFSCVT.139
C  CONVERT THE LIST OF REPORTING STATIONS TO EASIER USED STRINGS                 SFSCVT.140
C                                                                                SFSCVT.141
                                                                                 SFSCVT.142
         DO 10 I = 1, COUNT(2)                                                   SFSCVT.143
            J = (I - 1) * COUNT(1) + 1                                           SFSCVT.144
            K = K + 1                                                            SFSCVT.145
            STID(K)(1:COUNT(1)) = STLIS(J:J + COUNT(1))                          SFSCVT.146
10       CONTINUE                                                                SFSCVT.147
      IF (SAVE .GT. 0) GOTO 5                                                    SFSCVT.148
                                                                                 SFSCVT.149
C                                                                                SFSCVT.150
C  LATITUDE                                                                      SFSCVT.151
C                                                                                SFSCVT.152
                                                                                 SFSCVT.153
      TMPID = NCVID (CVTID, 'lat', ERROR)                                        SFSCVT.154
      CALL NCVGT (CVTID, TMPID, 1, NREP, LAT, ERROR)                             SFSCVT.155
                                                                                 SFSCVT.156
C                                                                                SFSCVT.157
C  LONGITUDE                                                                     SFSCVT.158
C                                                                                SFSCVT.159
                                                                                 SFSCVT.160
      TMPID = NCVID (CVTID, 'lon', ERROR)                                        SFSCVT.161
      CALL NCVGT (CVTID, TMPID, 1, NREP, LON, ERROR)                             SFSCVT.162
                                                                                 SFSCVT.163
C                                                                                SFSCVT.164
C  ELEVATION                                                                     SFSCVT.165
C                                                                                SFSCVT.166
                                                                                 SFSCVT.167
      TMPID = NCVID (CVTID, 'elev', ERROR)                                       SFSCVT.168
      CALL NCVGT (CVTID, TMPID, 1, NREP, ELEV, ERROR)                            SFSCVT.169
                                                                                 SFSCVT.170
C                                                                                SFSCVT.171
C  TEMPERATURE                                                                   SFSCVT.172
C                                                                                SFSCVT.173
                                                                                 SFSCVT.174
      TMPID = NCVID (CVTID, 'T', ERROR)                                          SFSCVT.175
      CALL NCVGT (CVTID, TMPID, 1, NREP, TEMP, ERROR)                            SFSCVT.176
                                                                                 SFSCVT.177
C                                                                                SFSCVT.178
C  DEWPOINT TEMPERATURE                                                          SFSCVT.179
C                                                                                SFSCVT.180
                                                                                 SFSCVT.181
      TMPID = NCVID (CVTID, 'TD', ERROR)                                         SFSCVT.182
      CALL NCVGT (CVTID, TMPID, 1, NREP, TD, ERROR)                              SFSCVT.183
                                                                                 SFSCVT.184
C                                                                                SFSCVT.185
C  SEA LEVEL PRESSURE                                                            SFSCVT.186
C                                                                                SFSCVT.187
                                                                                 SFSCVT.188
      TMPID = NCVID (CVTID, 'PSL', ERROR)                                        SFSCVT.189
      CALL NCVGT (CVTID, TMPID, 1, NREP, SLP, ERROR)                             SFSCVT.190
                                                                                 SFSCVT.191
C                                                                                SFSCVT.192
C  WIND SPEED                                                                    SFSCVT.193
C                                                                                SFSCVT.194
                                                                                 SFSCVT.195
      TMPID = NCVID (CVTID, 'SPD', ERROR)                                        SFSCVT.196
      CALL NCVGT (CVTID, TMPID, 1, NREP, SPEED, ERROR)                           SFSCVT.197
                                                                                 SFSCVT.198
C                                                                                SFSCVT.199
C  WIND DIRECTION                                                                SFSCVT.200
C                                                                                SFSCVT.201
                                                                                 SFSCVT.202
      TMPID = NCVID (CVTID, 'DIR', ERROR)                                        SFSCVT.203
      CALL NCVGT (CVTID, TMPID, 1, NREP, WDIR, ERROR)                            SFSCVT.204
                                                                                 SFSCVT.205
C                                                                                SFSCVT.206
C  PREPARE PLACE KEEPERS FOR READING IN THE TIME, LIMTIM AT A TIME               SFSCVT.207
C                                                                                SFSCVT.208
                                                                                 SFSCVT.209
      SAVE     = NREP                                                            SFSCVT.210
      K        = 0                                                               SFSCVT.211
      START(1) = 1                                                               SFSCVT.212
      START(2) = 1                                                               SFSCVT.213
15    CONTINUE                                                                   SFSCVT.214
         IF (SAVE .GT. LIMTIM) THEN                                              SFSCVT.215
            COUNT(2) = LIMTIM                                                    SFSCVT.216
            SAVE     = SAVE - LIMTIM                                             SFSCVT.217
         ELSE                                                                    SFSCVT.218
            COUNT(2) = SAVE                                                      SFSCVT.219
            SAVE     = 0                                                         SFSCVT.220
         END IF                                                                  SFSCVT.221
                                                                                 SFSCVT.222
C                                                                                SFSCVT.223
C  READ IN THE TIME GIVEN FOR THE REPORT                                         SFSCVT.224
C                                                                                SFSCVT.225
                                                                                 SFSCVT.226
         TMPID = NCDID (CVTID, 'time_len', ERROR)                                SFSCVT.227
         CALL NCDINQ (CVTID, TMPID, STRNG, COUNT(1), ERROR)                      SFSCVT.228
         TMPID = NCVID (CVTID, 'time', ERROR)                                    SFSCVT.229
         CALL NCVGTC (CVTID, TMPID, START, COUNT, TIMLS,                         SFSCVT.230
     *                TIMLEN * COUNT(2), ERROR)                                  SFSCVT.231
         START(2) = START(2) + COUNT(2)                                          SFSCVT.232
                                                                                 SFSCVT.233
C                                                                                SFSCVT.234
C  CONVERT THE TIMES TO INTEGERS                                                 SFSCVT.235
C                                                                                SFSCVT.236
                                                                                 SFSCVT.237
         DO 20 I = 1, COUNT(2)                                                   SFSCVT.238
            J = (I - 1) * COUNT(1) + 1                                           SFSCVT.239
            K = K + 1                                                            SFSCVT.240
            CTIME(1:COUNT(1)) = TIMLS(J:J + COUNT(1))                            SFSCVT.241
            READ (CTIME(3:4), 30) TMP                                            SFSCVT.242
            TIME(K) = TMP * 100000000                                            SFSCVT.243
            READ (CTIME(6:7), 30) TMP                                            SFSCVT.244
            TIME(K) = TIME(K) + TMP * 1000000                                    SFSCVT.245
            READ (CTIME(9:10), 30) TMP                                           SFSCVT.246
            TIME(K) = TIME(K) + TMP * 10000                                      SFSCVT.247
            READ (CTIME(12:13), 30) TMP                                          SFSCVT.248
            TIME(K) = TIME(K) + TMP * 100                                        SFSCVT.249
            READ (CTIME(15:16), 30) TMP                                          SFSCVT.250
            TIME(K) = TIME(K) + TMP                                              SFSCVT.251
20       CONTINUE                                                                SFSCVT.252
      IF (SAVE .GT. 0) GOTO 15                                                   SFSCVT.253
                                                                                 SFSCVT.254
C                                                                                SFSCVT.255
C  CLOSE THE "DATA.CVT" FILE                                                     SFSCVT.256
C                                                                                SFSCVT.257
                                                                                 SFSCVT.258
      CALL NCCLOS (CVTID, ERROR)                                                 SFSCVT.259
                                                                                 SFSCVT.260
C*****************************  SUBROUTINE END  ************************         SFSCVT.261
                                                                                 SFSCVT.262
C                                                                                SFSCVT.263
C  FORMAT STATEMENTS BEGIN                                                       SFSCVT.264
C                                                                                SFSCVT.265
                                                                                 SFSCVT.266
30    FORMAT (I2)                                                                SFSCVT.267
                                                                                 SFSCVT.268
C                                                                                SFSCVT.269
C  FORMAT STATEMENTS END                                                         SFSCVT.270
C                                                                                SFSCVT.271
                                                                                 SFSCVT.272
      RETURN                                                                     SFSCVT.273
#endif                                                                           SFSCVT.274
      END                                                                        SFSCVT.275
