                                                                                 SGEMV.1
      SUBROUTINE SGEMV ( TRANS, M, N, ALPHA, A, LDA, X, INCX,                    SGEMV.2
     $                   BETA, Y, INCY )                                         SGEMV.3
*     .. Scalar Arguments ..                                                     SGEMV.4
      REAL               ALPHA, BETA                                             SGEMV.5
      INTEGER            INCX, INCY, LDA, M, N                                   SGEMV.6
      CHARACTER*1        TRANS                                                   SGEMV.7
*     .. Array Arguments ..                                                      SGEMV.8
      REAL               A( LDA, * ), X( * ), Y( * )                             SGEMV.9
*     ..                                                                         SGEMV.10
*                                                                                SGEMV.11
*  Purpose                                                                       SGEMV.12
*  =======                                                                       SGEMV.13
*                                                                                SGEMV.14
*  SGEMV  performs one of the matrix-vector operations                           SGEMV.15
*                                                                                SGEMV.16
*     y := alpha*A*x + beta*y,   or   y := alpha*A_prime*x + beta*y,             SGEMV.17
*                                                                                SGEMV.18
*  where alpha and beta are scalars, x and y are vectors and A is an             SGEMV.19
*  m by n matrix.                                                                SGEMV.20
*                                                                                SGEMV.21
*  Parameters                                                                    SGEMV.22
*  ==========                                                                    SGEMV.23
*                                                                                SGEMV.24
*  TRANS  - CHARACTER*1.                                                         SGEMV.25
*           On entry, TRANS specifies the operation to be performed as           SGEMV.26
*           follows:                                                             SGEMV.27
*                                                                                SGEMV.28
*              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.                     SGEMV.29
*                                                                                SGEMV.30
*              TRANS = 'T' or 't'   y := alpha*A_prime*x + beta*y.               SGEMV.31
*                                                                                SGEMV.32
*              TRANS = 'C' or 'c'   y := alpha*A_prime*x + beta*y.               SGEMV.33
*                                                                                SGEMV.34
*           Unchanged on exit.                                                   SGEMV.35
*                                                                                SGEMV.36
*  M      - INTEGER.                                                             SGEMV.37
*           On entry, M specifies the number of rows of the matrix A.            SGEMV.38
*           M must be at least zero.                                             SGEMV.39
*           Unchanged on exit.                                                   SGEMV.40
*                                                                                SGEMV.41
*  N      - INTEGER.                                                             SGEMV.42
*           On entry, N specifies the number of columns of the matrix A.         SGEMV.43
*           N must be at least zero.                                             SGEMV.44
*           Unchanged on exit.                                                   SGEMV.45
*                                                                                SGEMV.46
*  ALPHA  - REAL            .                                                    SGEMV.47
*           On entry, ALPHA specifies the scalar alpha.                          SGEMV.48
*           Unchanged on exit.                                                   SGEMV.49
*                                                                                SGEMV.50
*  A      - REAL             array of DIMENSION ( LDA, n ).                      SGEMV.51
*           Before entry, the leading m by n part of the array A must            SGEMV.52
*           contain the matrix of coefficients.                                  SGEMV.53
*           Unchanged on exit.                                                   SGEMV.54
*                                                                                SGEMV.55
*  LDA    - INTEGER.                                                             SGEMV.56
*           On entry, LDA specifies the first dimension of A as declared         SGEMV.57
*           in the calling (sub) program. LDA must be at least                   SGEMV.58
*           max( 1, m ).                                                         SGEMV.59
*           Unchanged on exit.                                                   SGEMV.60
*                                                                                SGEMV.61
*  X      - REAL             array of DIMENSION at least                         SGEMV.62
*           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'                SGEMV.63
*           and at least                                                         SGEMV.64
*           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.                             SGEMV.65
*           Before entry, the incremented array X must contain the               SGEMV.66
*           vector x.                                                            SGEMV.67
*           Unchanged on exit.                                                   SGEMV.68
*                                                                                SGEMV.69
*  INCX   - INTEGER.                                                             SGEMV.70
*           On entry, INCX specifies the increment for the elements of           SGEMV.71
*           X. INCX must not be zero.                                            SGEMV.72
*           Unchanged on exit.                                                   SGEMV.73
*                                                                                SGEMV.74
*  BETA   - REAL            .                                                    SGEMV.75
*           On entry, BETA specifies the scalar beta. When BETA is               SGEMV.76
*           supplied as zero then Y need not be set on input.                    SGEMV.77
*           Unchanged on exit.                                                   SGEMV.78
*                                                                                SGEMV.79
*  Y      - REAL             array of DIMENSION at least                         SGEMV.80
*           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'                SGEMV.81
*           and at least                                                         SGEMV.82
*           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.                             SGEMV.83
*           Before entry with BETA non-zero, the incremented array Y             SGEMV.84
*           must contain the vector y. On exit, Y is overwritten by the          SGEMV.85
*           updated vector y.                                                    SGEMV.86
*                                                                                SGEMV.87
*  INCY   - INTEGER.                                                             SGEMV.88
*           On entry, INCY specifies the increment for the elements of           SGEMV.89
*           Y. INCY must not be zero.                                            SGEMV.90
*           Unchanged on exit.                                                   SGEMV.91
*                                                                                SGEMV.92
*                                                                                SGEMV.93
*  Level 2 Blas routine.                                                         SGEMV.94
*                                                                                SGEMV.95
*  -- Written on 22-October-1986.                                                SGEMV.96
*     Jack Dongarra, Argonne National Lab.                                       SGEMV.97
*     Jeremy Du Croz, Nag Central Office.                                        SGEMV.98
*     Sven Hammarling, Nag Central Office.                                       SGEMV.99
*     Richard Hanson, Sandia National Labs.                                      SGEMV.100
*                                                                                SGEMV.101
*                                                                                SGEMV.102
*     .. Parameters ..                                                           SGEMV.103
      REAL               ONE         , ZERO                                      SGEMV.104
      PARAMETER        ( ONE = 1.0E+0, ZERO = 0.0E+0 )                           SGEMV.105
*     .. Local Scalars ..                                                        SGEMV.106
      REAL               TEMP                                                    SGEMV.107
      INTEGER            I, INFO, IX, IY, J, JX, JY, KX, KY, LENX, LENY          SGEMV.108
*     .. External Functions ..                                                   SGEMV.109
      LOGICAL            LSAME                                                   SGEMV.110
      EXTERNAL           LSAME                                                   SGEMV.111
*     .. External Subroutines ..                                                 SGEMV.112
      EXTERNAL           XERBLA                                                  SGEMV.113
*     .. Intrinsic Functions ..                                                  SGEMV.114
      INTRINSIC          MAX                                                     SGEMV.115
*     ..                                                                         SGEMV.116
*     .. Executable Statements ..                                                SGEMV.117
*                                                                                SGEMV.118
*     Test the input parameters.                                                 SGEMV.119
*                                                                                SGEMV.120
      INFO = 0                                                                   SGEMV.121
      IF     ( .NOT.LSAME( TRANS, 'N' ).AND.                                     SGEMV.122
     $         .NOT.LSAME( TRANS, 'T' ).AND.                                     SGEMV.123
     $         .NOT.LSAME( TRANS, 'C' )      )THEN                               SGEMV.124
         INFO = 1                                                                SGEMV.125
      ELSE IF( M.LT.0 )THEN                                                      SGEMV.126
         INFO = 2                                                                SGEMV.127
      ELSE IF( N.LT.0 )THEN                                                      SGEMV.128
         INFO = 3                                                                SGEMV.129
      ELSE IF( LDA.LT.MAX( 1, M ) )THEN                                          SGEMV.130
         INFO = 6                                                                SGEMV.131
      ELSE IF( INCX.EQ.0 )THEN                                                   SGEMV.132
         INFO = 8                                                                SGEMV.133
      ELSE IF( INCY.EQ.0 )THEN                                                   SGEMV.134
         INFO = 11                                                               SGEMV.135
      END IF                                                                     SGEMV.136
      IF( INFO.NE.0 )THEN                                                        SGEMV.137
         CALL XERBLA( 'SGEMV ', INFO )                                           SGEMV.138
         RETURN                                                                  SGEMV.139
      END IF                                                                     SGEMV.140
*                                                                                SGEMV.141
*     Quick return if possible.                                                  SGEMV.142
*                                                                                SGEMV.143
      IF( ( M.EQ.0 ).OR.( N.EQ.0 ).OR.                                           SGEMV.144
     $    ( ( ALPHA.EQ.ZERO ).AND.( BETA.EQ.ONE ) ) )                            SGEMV.145
     $   RETURN                                                                  SGEMV.146
*                                                                                SGEMV.147
*     Set  LENX  and  LENY, the lengths of the vectors x and y, and set          SGEMV.148
*     up the start points in  X  and  Y.                                         SGEMV.149
*                                                                                SGEMV.150
      IF( LSAME( TRANS, 'N' ) )THEN                                              SGEMV.151
         LENX = N                                                                SGEMV.152
         LENY = M                                                                SGEMV.153
      ELSE                                                                       SGEMV.154
         LENX = M                                                                SGEMV.155
         LENY = N                                                                SGEMV.156
      END IF                                                                     SGEMV.157
      IF( INCX.GT.0 )THEN                                                        SGEMV.158
         KX = 1                                                                  SGEMV.159
      ELSE                                                                       SGEMV.160
         KX = 1 - ( LENX - 1 )*INCX                                              SGEMV.161
      END IF                                                                     SGEMV.162
      IF( INCY.GT.0 )THEN                                                        SGEMV.163
         KY = 1                                                                  SGEMV.164
      ELSE                                                                       SGEMV.165
         KY = 1 - ( LENY - 1 )*INCY                                              SGEMV.166
      END IF                                                                     SGEMV.167
*                                                                                SGEMV.168
*     Start the operations. In this version the elements of A are                SGEMV.169
*     accessed sequentially with one pass through A.                             SGEMV.170
*                                                                                SGEMV.171
*     First form  y := beta*y.                                                   SGEMV.172
*                                                                                SGEMV.173
      IF( BETA.NE.ONE )THEN                                                      SGEMV.174
         IF( INCY.EQ.1 )THEN                                                     SGEMV.175
            IF( BETA.EQ.ZERO )THEN                                               SGEMV.176
               DO 10, I = 1, LENY                                                SGEMV.177
                  Y( I ) = ZERO                                                  SGEMV.178
   10          CONTINUE                                                          SGEMV.179
            ELSE                                                                 SGEMV.180
               DO 20, I = 1, LENY                                                SGEMV.181
                  Y( I ) = BETA*Y( I )                                           SGEMV.182
   20          CONTINUE                                                          SGEMV.183
            END IF                                                               SGEMV.184
         ELSE                                                                    SGEMV.185
            IY = KY                                                              SGEMV.186
            IF( BETA.EQ.ZERO )THEN                                               SGEMV.187
               DO 30, I = 1, LENY                                                SGEMV.188
                  Y( IY ) = ZERO                                                 SGEMV.189
                  IY      = IY   + INCY                                          SGEMV.190
   30          CONTINUE                                                          SGEMV.191
            ELSE                                                                 SGEMV.192
               DO 40, I = 1, LENY                                                SGEMV.193
                  Y( IY ) = BETA*Y( IY )                                         SGEMV.194
                  IY      = IY           + INCY                                  SGEMV.195
   40          CONTINUE                                                          SGEMV.196
            END IF                                                               SGEMV.197
         END IF                                                                  SGEMV.198
      END IF                                                                     SGEMV.199
      IF( ALPHA.EQ.ZERO )                                                        SGEMV.200
     $   RETURN                                                                  SGEMV.201
      IF( LSAME( TRANS, 'N' ) )THEN                                              SGEMV.202
*                                                                                SGEMV.203
*        Form  y := alpha*A*x + y.                                               SGEMV.204
*                                                                                SGEMV.205
         JX = KX                                                                 SGEMV.206
         IF( INCY.EQ.1 )THEN                                                     SGEMV.207
            DO 60, J = 1, N                                                      SGEMV.208
               IF( X( JX ).NE.ZERO )THEN                                         SGEMV.209
                  TEMP = ALPHA*X( JX )                                           SGEMV.210
                  DO 50, I = 1, M                                                SGEMV.211
                     Y( I ) = Y( I ) + TEMP*A( I, J )                            SGEMV.212
   50             CONTINUE                                                       SGEMV.213
               END IF                                                            SGEMV.214
               JX = JX + INCX                                                    SGEMV.215
   60       CONTINUE                                                             SGEMV.216
         ELSE                                                                    SGEMV.217
            DO 80, J = 1, N                                                      SGEMV.218
               IF( X( JX ).NE.ZERO )THEN                                         SGEMV.219
                  TEMP = ALPHA*X( JX )                                           SGEMV.220
                  IY   = KY                                                      SGEMV.221
                  DO 70, I = 1, M                                                SGEMV.222
                     Y( IY ) = Y( IY ) + TEMP*A( I, J )                          SGEMV.223
                     IY      = IY      + INCY                                    SGEMV.224
   70             CONTINUE                                                       SGEMV.225
               END IF                                                            SGEMV.226
               JX = JX + INCX                                                    SGEMV.227
   80       CONTINUE                                                             SGEMV.228
         END IF                                                                  SGEMV.229
      ELSE                                                                       SGEMV.230
*                                                                                SGEMV.231
*        Form  y := alpha*A_prime*x + y.                                         SGEMV.232
*                                                                                SGEMV.233
         JY = KY                                                                 SGEMV.234
         IF( INCX.EQ.1 )THEN                                                     SGEMV.235
            DO 100, J = 1, N                                                     SGEMV.236
               TEMP = ZERO                                                       SGEMV.237
               DO 90, I = 1, M                                                   SGEMV.238
                  TEMP = TEMP + A( I, J )*X( I )                                 SGEMV.239
   90          CONTINUE                                                          SGEMV.240
               Y( JY ) = Y( JY ) + ALPHA*TEMP                                    SGEMV.241
               JY      = JY      + INCY                                          SGEMV.242
  100       CONTINUE                                                             SGEMV.243
         ELSE                                                                    SGEMV.244
            DO 120, J = 1, N                                                     SGEMV.245
               TEMP = ZERO                                                       SGEMV.246
               IX   = KX                                                         SGEMV.247
               DO 110, I = 1, M                                                  SGEMV.248
                  TEMP = TEMP + A( I, J )*X( IX )                                SGEMV.249
                  IX   = IX   + INCX                                             SGEMV.250
  110          CONTINUE                                                          SGEMV.251
               Y( JY ) = Y( JY ) + ALPHA*TEMP                                    SGEMV.252
               JY      = JY      + INCY                                          SGEMV.253
  120       CONTINUE                                                             SGEMV.254
         END IF                                                                  SGEMV.255
      END IF                                                                     SGEMV.256
*                                                                                SGEMV.257
      RETURN                                                                     SGEMV.258
*                                                                                SGEMV.259
*     End of SGEMV .                                                             SGEMV.260
*                                                                                SGEMV.261
      END                                                                        SGEMV.262
                                                                                 SGEMV.263
      LOGICAL FUNCTION LSAME(CA,CB)                                              SGEMV.264
C     TEST IF TWO CHARACTERS ARE ESSENTIALLY THE SAME.                           SGEMV.265
C     THE CHARACTER CB IS ONE OF THE FORTRAN SET.                                SGEMV.266
C     (LOWER AND UPPER CASE LETTERS ARE EQUIVALENT.)                             SGEMV.267
C     THIS IS A SUBPROGRAM FOR THE LEVEL TWO BLAS.                               SGEMV.268
C     REVISED 860623                                                             SGEMV.269
C     REVISED YYMMDD                                                             SGEMV.270
C     AUTH=R. J. HANSON, SANDIA NATIONAL LABS.                                   SGEMV.271
C                                                                                SGEMV.272
C     END                                                                        SGEMV.273
C     LOGICAL FUNCTION LSAME(CA,CB)                                              SGEMV.274
C     TEST IF TWO CHARACTERS ARE ESSENTIALLY THE SAME.                           SGEMV.275
C     THE CHARACTER CB IS ONE OF THE FORTRAN SET.                                SGEMV.276
C     (LOWER AND UPPER CASE LETTERS ARE EQUIVALENT.)                             SGEMV.277
C     THIS IS A SUBPROGRAM FOR THE LEVEL TWO BLAS.                               SGEMV.278
C     REVISED 860623                                                             SGEMV.279
C     REVISED YYMMDD                                                             SGEMV.280
C     AUTH=R. J. HANSON, SANDIA NATIONAL LABS.                                   SGEMV.281
C                                                                                SGEMV.282
C     THIS SUBPROGRAM IS MACHINE-DEPENDENT.                                      SGEMV.283
C     VERSION FOR ANY ASCII MACHINE.                                             SGEMV.284
      CHARACTER *1 CA                                                            SGEMV.285
      CHARACTER *1 CB                                                            SGEMV.286
      INTEGER IOFF                                                               SGEMV.287
      DATA IOFF/32/                                                              SGEMV.288
C     SEE IF THE  CHAR. IN STRING CA EQUALS STRING CB.                           SGEMV.289
      LSAME = CA .EQ. CB                                                         SGEMV.290
      IF (LSAME) RETURN                                                          SGEMV.291
C     THE CHARS. ARE NOT IDENTICAL.  NOW CHECK THEM FOR EQUIVALENCE.             SGEMV.292
      ISHIFT = ICHAR(CA) - IOFF                                                  SGEMV.293
      IF (ISHIFT.GE.ICHAR('A') .AND. ISHIFT.LE.ICHAR('Z')) THEN                  SGEMV.294
          LSAME = ISHIFT .EQ. ICHAR(CB)                                          SGEMV.295
      END IF                                                                     SGEMV.296
                                                                                 SGEMV.297
      RETURN                                                                     SGEMV.298
C     END                                                                        SGEMV.299
C                                                                                SGEMV.300
C     LOGICAL FUNCTION LSAME(CA,CB)                                              SGEMV.301
C     TEST IF TWO CHARACTERS ARE ESSENTIALLY THE SAME.                           SGEMV.302
C     THE CHARACTER CB IS ONE OF THE FORTRAN SET.                                SGEMV.303
C     (LOWER AND UPPER CASE LETTERS ARE EQUIVALENT.)                             SGEMV.304
C     THIS IS A SUBPROGRAM FOR THE LEVEL TWO BLAS.                               SGEMV.305
C     REVISED 860623                                                             SGEMV.306
C     REVISED YYMMDD                                                             SGEMV.307
C     AUTH=R. J. HANSON, SANDIA NATIONAL LABS.                                   SGEMV.308
C                                                                                SGEMV.309
C     THIS SUBPROGRAM IS MACHINE-DEPENDENT.                                      SGEMV.310
C     VERSION FOR ANY EBCDIC MACHINE.                                            SGEMV.311
C     CHARACTER *1 CA                                                            SGEMV.312
C     CHARACTER *1 CB                                                            SGEMV.313
C     INTEGER IOFF                                                               SGEMV.314
C     DATA IOFF/64/                                                              SGEMV.315
C     SEE IF THE  CHAR. IN STRING CA EQUALS STRING CB.                           SGEMV.316
C     LSAME = CA .EQ. CB                                                         SGEMV.317
C     IF (LSAME) RETURN                                                          SGEMV.318
C     THE CHARS. ARE NOT IDENTICAL.  NOW CHECK THEM FOR EQUIVALENCE.             SGEMV.319
C     ISHIFT = ICHAR(CA) + IOFF                                                  SGEMV.320
C     IF (ISHIFT.GE.ICHAR('A') .AND. ISHIFT.LE.ICHAR('I')) THEN                  SGEMV.321
C         LSAME = ISHIFT .EQ. ICHAR(CB)                                          SGEMV.322
C     END IF                                                                     SGEMV.323
C                                                                                SGEMV.324
C     IF (ISHIFT.GE.ICHAR('J') .AND. ISHIFT.LE.ICHAR('R')) THEN                  SGEMV.325
C         LSAME = ISHIFT .EQ. ICHAR(CB)                                          SGEMV.326
C     END IF                                                                     SGEMV.327
C                                                                                SGEMV.328
C     IF (ISHIFT.GE.ICHAR('S') .AND. ISHIFT.LE.ICHAR('Z')) THEN                  SGEMV.329
C         LSAME = ISHIFT .EQ. ICHAR(CB)                                          SGEMV.330
C     END IF                                                                     SGEMV.331
C                                                                                SGEMV.332
C     RETURN                                                                     SGEMV.333
C     END                                                                        SGEMV.334
      END                                                                        SGEMV.335
                                                                                 SGEMV.336
      SUBROUTINE XERBLA( SRNAME, INFO )                                          SGEMV.337
*                                                                                SGEMV.338
*  -- LAPACK auxiliary routine (preliminary version) --                          SGEMV.339
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,                SGEMV.340
*     Courant Institute, Argonne National Lab, and Rice University               SGEMV.341
*     February 29, 1992                                                          SGEMV.342
*                                                                                SGEMV.343
*     .. Scalar Arguments ..                                                     SGEMV.344
      CHARACTER*6        SRNAME                                                  SGEMV.345
      INTEGER            INFO                                                    SGEMV.346
*     ..                                                                         SGEMV.347
*                                                                                SGEMV.348
*  Purpose                                                                       SGEMV.349
*  =======                                                                       SGEMV.350
*                                                                                SGEMV.351
*  XERBLA  is an error handler for the LAPACK routines.                          SGEMV.352
*  It is called by an LAPACK routine if an input parameter has an                SGEMV.353
*  invalid value.  A message is printed and execution stops.                     SGEMV.354
*                                                                                SGEMV.355
*  Installers may consider modifying the STOP statement in order to              SGEMV.356
*  call system-specific exception-handling facilities.                           SGEMV.357
*                                                                                SGEMV.358
*  Arguments                                                                     SGEMV.359
*  =========                                                                     SGEMV.360
*                                                                                SGEMV.361
*  SRNAME  (input) CHARACTER*6                                                   SGEMV.362
*          The name of the routine which called XERBLA.                          SGEMV.363
*                                                                                SGEMV.364
*  INFO    (input) INTEGER                                                       SGEMV.365
*          The position of the invalid parameter in the parameter list           SGEMV.366
*          of the calling routine.                                               SGEMV.367
*                                                                                SGEMV.368
*                                                                                SGEMV.369
      WRITE( *, FMT = 9999 )SRNAME, INFO                                         SGEMV.370
*                                                                                SGEMV.371
      STOP                                                                       SGEMV.372
*                                                                                SGEMV.373
 9999 FORMAT( ' ** On entry to ', A6, ' parameter number ', I2, ' had ',         SGEMV.374
     $      'an illegal value' )                                                 SGEMV.375
*                                                                                SGEMV.376
*     End of XERBLA                                                              SGEMV.377
*                                                                                SGEMV.378
      END                                                                        SGEMV.379
