      SUBROUTINE SIGDAT(DATAH,CORRH,ID1,ID2,ID3,IPLT,LFILL,NSORT,                SIGDAT.1
     1                  DATAS,IDS1,IDS2,IDS3)                                    SIGDAT.2
C                                                                                SIGDAT.3
C        PURPOSE : THIS SUBROUTINE FORMS A COMPOSITE SOUNDING FOR EACH           SIGDAT.4
C                  STATION FROM MANDATORY AND SIGNIFICANT LEVEL DATA,            SIGDAT.5
C                  INTERPOLATES TO THE NEW NON-MANDATORY P-LEVELS, AND           SIGDAT.6
C                  STORES THE DATA IN DISK FILES FOR INCORPORATION INTO          SIGDAT.7
C                  FIRST GUESS FIELDS PRODUCED BY SUBROUTINE NEWPLV.             SIGDAT.8
C                                                                                SIGDAT.9
C                  SUBR SORT IS CALLED WHICH OBJECTIVELY CHECKS EACH             SIGDAT.10
C                  COMPOSITE SOUNDING FOR ERRORS AND THEN THE SOUNDING           SIGDAT.11
C                  IS RECONSTRUCTED FROM THE CORRECTED DATA.                     SIGDAT.12
C                                                                                SIGDAT.13
C                  THIS ROUTINE ALSO GENERATES ARRAYS FOR RAOB PLOTS             SIGDAT.14
C                  (SUBR PLSOND) AND TBM RAOB OUTPUT FILE                        SIGDAT.15
C                                                                                SIGDAT.16
C-----------------------------------------------------------------------         SIGDAT.17
#include <paramirb.incl>                                                         SIGDAT.18
#include <paramirs.incl>                                                         SIGDAT.19
#include <coma.incl>                                                             SIGDAT.20
#include <comc.incl>                                                             SIGDAT.21
#include <comd.incl>                                                             SIGDAT.22
#include <comb.incl>                                                             SIGDAT.23
#include <skwdrw.incl>                                                           SIGDAT.24
#include <hedmif.incl>                                                           SIGDAT.25
C-----------------------------------------------------------------------         SIGDAT.26
      CHARACTER*8 IDENT                                                          SIGDAT.27
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3),WKSOND(7,200)              06NOV00.535
     1,ZNT(200),ZNW(200),WKS(7,200),PW(200),PT(200),TP(200),DPT(200),            06NOV00.536
     2 WD(200),WS(200),PTH(200),ZTH(200),TPH(200),DPH(200),ZWH(200),             06NOV00.537
     3 PWH(200),WDH(200),WSH(200),PIN(200),TIN(200),HIN(200),ZIN(200),           06NOV00.538
     4 POT(200),TOT(200),HOT(200),ZOT(200),PWN(200),DIN(200),SEN(200),           06NOV00.539
     5 WIN(200),PWT(200),DOT(200),SOT(200),WOT(200),ITFG(200),IWFG(200)          06NOV00.540
     6,STNZ(14),CORZ(200),ZCOR(200),NSORT(500),DATAS(IDS1,IDS2,IDS3)             05DEC01.40
      LOGICAL IPLT, LOPENED                                                      SIGDAT.35
      DATA STNZ /0.,111.,1457.,3012.,5574.,7185.,9164.,10363.,11787.,136         SIGDAT.36
     124.,16214.,18492.,20641.,23903./                                           SIGDAT.37
                                                                                 SIGDAT.38
      inquire(file='RAWOBS_DOMAIN'//char(mif(13,1)+48), opened=lopened)          SIGDAT.39
      if (.not. lopened) then                                                    SIGDAT.40
         open(11, file='RAWOBS_DOMAIN'//char(mif(13,1)+48),                      SIGDAT.41
     &        form='unformatted', status='unknown')                              SIGDAT.42
      endif                                                                      SIGDAT.43
C                                                                                SIGDAT.44
C  OPEN THE WISS FOR THE SKEWT GFLAS.                                            SIGDAT.45
C                                                                                SIGDAT.46
      IF (ISKEWT .EQ. 1) THEN                                                    SIGDAT.47
#ifdef NCARG                                                                     SIGDAT.48
        CALL GOPWK(8,9,3)                                                        SIGDAT.49
        CALL GSCLIP(0)                                                           SIGDAT.50
#endif                                                                           SIGDAT.51
      ENDIF                                                                      SIGDAT.52
C                                                                                SIGDAT.53
C  DEFINE CONSTANTS FOR DEWPOINT CALC AND CONVERSION OF WIND COMPONENTS          SIGDAT.54
C  FROM MAP TO MET AS NEEDED FOR SUBROUTINES SORT AND PLSOND                     SIGDAT.55
C                                                                                SIGDAT.56
      XN=0.716                                                                   SIGDAT.57
      IF(IPROJ.EQ.2) XN=1.0                                                      SIGDAT.58
      PCON=ACOS(-1.0)/180.                                                       SIGDAT.59
      CCC=PCON*270.                                                              SIGDAT.60
      XNXN=XN*PCON                                                               SIGDAT.61
      A=7.5                                                                      SIGDAT.62
      B=237.3                                                                    SIGDAT.63
      C=5.34                                                                     SIGDAT.64
      S=6.105                                                                    SIGDAT.65
      E=25.21                                                                    SIGDAT.66
      AB=273.15                                                                  SIGDAT.67
      RDD=180./ACOS(-1.0)                                                        SIGDAT.68
      LENBUF = ID1*ID3                                                           SIGDAT.69
C                                                                                SIGDAT.70
C  CONSTANTS FOR PRINT INVENTORY OF CORRECTED (BAD) DATA                         SIGDAT.71
C                                                                                SIGDAT.72
      ID4=ID1+2                                                                  SIGDAT.73
      ZNEG=-100.                                                                 SIGDAT.74
      WKIS=-222.                                                                 SIGDAT.75
      DD3=-39.9                                                                  SIGDAT.76
      A22=-200.                                                                  SIGDAT.77
      A33=-300.                                                                  SIGDAT.78
      PRINT 22                                                                   SIGDAT.79
   22 FORMAT(1H1,6X,'@@@@@@@@@ CALL SIGDAT---RDISK,WDISK,SORT,PLSOND'/)          SIGDAT.80
      NFS = NFSTAD                                                               SIGDAT.81
      NLS = NLSTAD                                                               SIGDAT.82
C        FIRST, SET ALL VALUES IN THE FILES TO A FICTICIOUS VALUE                SIGDAT.83
      DO 10 L = 1,ID2                                                            SIGDAT.84
      DO 10 M = 1,ID1                                                            SIGDAT.85
      DO 10 N = 1,ID3                                                            SIGDAT.86
      DATAH(M,L,N)=1.E33                                                         SIGDAT.87
   10 CORRH(M,L,N)=1.E33                                                         SIGDAT.88
C        NOW, READ IN A FILE OF MANDATORY AND SIGNIFICANT LEVEL DATA,            SIGDAT.89
C        BY LEVELS.                                                              SIGDAT.90
      DO 40 L = 1,ID2                                                            SIGDAT.91
      NAMED = NAMDAT + 10000*L                                                   SIGDAT.92
      NAMEC = NAMCOR + 10000*L                                                   SIGDAT.93
      CALL RDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                             SIGDAT.94
      DO 6 M=1,ID1                                                               SIGDAT.95
      DO 5 L1=1,ID3                                                              SIGDAT.96
      BUFD(M,L1)=BUFUPR(M,L1)                                                    SIGDAT.97
5     CONTINUE                                                                   SIGDAT.98
6     CONTINUE                                                                   SIGDAT.99
      CALL RDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                             SIGDAT.100
      DO 8 M=1,ID1                                                               SIGDAT.101
      DO 7 L1=1,ID3                                                              SIGDAT.102
      RSOND(M,L1)=BUFUPR(M,L1)                                                   SIGDAT.103
7     CONTINUE                                                                   SIGDAT.104
8     CONTINUE                                                                   SIGDAT.105
      DO 30 N = NFS,NLS                                                          SIGDAT.106
      DO 15 M = 1,ID1                                                            SIGDAT.107
  15  DATAH(M,L,N) = BUFD(M,N)                                                   SIGDAT.108
  20  IF(RSOND(5,N) .GT. 1.E10) GO TO 30                                         SIGDAT.109
      DO 25 M = 1,ID1                                                            SIGDAT.110
  25  CORRH(M,L,N) = RSOND(M,N)                                                  SIGDAT.111
  30  CONTINUE                                                                   SIGDAT.112
  40  CONTINUE                                                                   SIGDAT.113
C        BUILD COMPOSITE SOUNDINGS FOR EACH STATION OF FILE IDF, USING           SIGDAT.114
C        WKSOND, VERTICALLY INTERPOLATE TO NON-MANDATORY LEVELS IN               SIGDAT.115
C        GNLVL, AND STORE IN CORRH.                                              SIGDAT.116
      NMMAX = 0                                                                  SIGDAT.117
      DO 150 N = NFS,NLS                                                         SIGDAT.118
         if (ifound(3,n).eq.2) then                                              SIGDAT.119
            write(*,'(/)')                                                       SIGDAT.120
            DO L = 1, ID2                                                        SIGDAT.121
               write(*, '(''D:'', 7G18.8)')(DATAH(M,L,N),M=1,7)                  SIGDAT.122
            ENDDO                                                                SIGDAT.123
            DO L = 1, ID2                                                        SIGDAT.124
               write(*, '(''C:'', 7G18.8)')(DATAH(M,L,N),M=1,7)                  SIGDAT.125
            ENDDO                                                                SIGDAT.126
            write(*,'(/)')                                                       SIGDAT.127
         endif                                                                   SIGDAT.128
                                                                                 SIGDAT.129
      NSTPRB=0                                                                   SIGDAT.130
      DLON=FLOAT(IKLON(1,N))/10.                                                 SIGDAT.131
C                                                                                SIGDAT.132
C  GET ANGLE FOR CONVERSION OF WIND COMPS FROM MAP TO MET OR VISA VERSA          SIGDAT.133
C                                                                                SIGDAT.134
      ANGLE=RANG(1,N)                                                            SIGDAT.135
      NMMAX = NMMAX + 1                                                          SIGDAT.136
      DO 17 I=1,200                                                              06NOV00.542
      WKSOND(6,I)=1.E33                                                          SIGDAT.138
      WKS(1,I)=1.0E33                                                            SIGDAT.139
      WKS(2,I)=1.0E33                                                            SIGDAT.140
      WKS(3,I)=1.0E33                                                            SIGDAT.141
      WKS(4,I)=1.0E33                                                            SIGDAT.142
      WKS(5,I)=1.0E33                                                            SIGDAT.143
   17 WKS(6,I)=1.0E33                                                            SIGDAT.144
C                                                                                SIGDAT.145
C  GENERATE COMPOSITE SOUNDING (WKSOND ARRAY)                                    SIGDAT.146
C                                                                                SIGDAT.147
      INML = 2                                                                   SIGDAT.148
      IWK = 1                                                                    SIGDAT.149
      DO M = 1,ID1                                                               SIGDAT.150
         WKSOND(M,1) = DATAH(M,1,N)                                              SIGDAT.151
      ENDDO                                                                      SIGDAT.152
      WKSOND(6,1)=DATAH(5,1,N)                                                   SIGDAT.153
      WKSOND(7,1)=DATAH(5,1,N)                                                   SIGDAT.154
      DO 75 K = 2,NVERT                                                          SIGDAT.155
      CORZ(K)=STNZ(K)-DATAH(5,K,N)                                               SIGDAT.156
      IF(ABS(CORZ(K)).GT.2.0E3) CORZ(K)=0.                                       SIGDAT.157
      IB = INML                                                                  SIGDAT.158
      DO 60 L = IB,ID2                                                           SIGDAT.159
      IF(CORRH(5,L,N).GT.1.E10) THEN                                             SIGDAT.160
      INML=INML+1                                                                SIGDAT.161
      GO TO 60                                                                   SIGDAT.162
      END IF                                                                     SIGDAT.163
      IF(CORRH(5,L,N).LT.(GLVL(K)+1.E-2)) GO TO 65                               SIGDAT.164
      IWK = IWK + 1                                                              SIGDAT.165
      INML = INML + 1                                                            SIGDAT.166
      DO M = 1,ID1                                                               SIGDAT.167
         IF ((M.LE.4).and.(CORRH(M,L,N) .LT. 1.E30)) THEN                        SIGDAT.168
            WKSOND(M,IWK) = NINT(CORRH(M,L,N)*1.E3)*1.E-3                        SIGDAT.169
            CORRH(M,L,N)  = NINT(CORRH(M,L,N)*1.E3)*1.E-3                        SIGDAT.170
         ELSE                                                                    SIGDAT.171
            WKSOND(M,IWK) = CORRH(M,L,N)                                         SIGDAT.172
         ENDIF                                                                   SIGDAT.173
      ENDDO                                                                      SIGDAT.174
      WKSOND(7,IWK)=99999.                                                       SIGDAT.175
      IF(WKSOND(1,IWK) .GT.1.E3) WKSOND(6,IWK)=-222.                             SIGDAT.176
      IF(WKSOND(3,IWK) .GT.1.E3) WKSOND(6,IWK)=-111.                             SIGDAT.177
      IF(WKSOND(6,IWK).GT.1.E5) WKSOND(6,IWK)=-333.                              SIGDAT.178
  60  CONTINUE                                                                   SIGDAT.179
C        ALL SIGNIFICANT LEVELS HAVE BEEN SEARCHED                               SIGDAT.180
  65  IWK = IWK + 1                                                              SIGDAT.181
      IL = ID1 - 1                                                               SIGDAT.182
      DO M = 1,IL                                                                SIGDAT.183
         IF ((M.LE.4).and.(DATAH(M,K,N) .LT. 1.E30)) THEN                        SIGDAT.184
            WKSOND(M,IWK) = NINT(DATAH(M,K,N)*1.E3)*1.E-3                        SIGDAT.185
            DATAH(M,K,N)  = NINT(DATAH(M,K,N)*1.E3)*1.E-3                        SIGDAT.186
         ELSE                                                                    SIGDAT.187
            WKSOND(M,IWK) = DATAH(M,K,N)                                         SIGDAT.188
         ENDIF                                                                   SIGDAT.189
      ENDDO                                                                      SIGDAT.190
      WKSOND(6,IWK)=DATAH(5,K,N)                                                 SIGDAT.191
      WKSOND(7,IWK)=DATAH(5,K,N)                                                 SIGDAT.192
      WKSOND(5,IWK) = GLVL(K)                                                    SIGDAT.193
      IF(GLVL(K) .LT. PMANMN+1.E-2) GO TO 80                                     SIGDAT.194
  75  CONTINUE                                                                   SIGDAT.195
  80  CONTINUE                                                                   SIGDAT.196
      DO 84 M = 1,ID1                                                            SIGDAT.197
      DO 84 L = LEVEL1,ID2                                                       SIGDAT.198
   84 CORRH(M,L,N)=1.E33                                                         SIGDAT.199
      IF (NMMAX .GT. 0) GO TO 89                                                 SIGDAT.200
      PRINT 82,N                                                                 SIGDAT.201
   82 FORMAT (1H0,5X,'COMPOSITE SOUNDING NO.',I3)                                SIGDAT.202
      DO 86 LL = 1,IWK                                                           SIGDAT.203
      L = IWK + 1 - LL                                                           SIGDAT.204
      PRINT 85, (WKSOND(M,L),M=1,ID1)                                            SIGDAT.205
   85 FORMAT (9X,5(1x,F12.5))                                                    SIGDAT.206
   86 CONTINUE                                                                   SIGDAT.207
   89 CONTINUE                                                                   SIGDAT.208
C                                                                                SIGDAT.209
C  GENERATE RAOB ARRAYS FOR SUBR SORT,PLOTTING AND TBM FILE                      SIGDAT.210
C                                                                                SIGDAT.211
      NT=0                                                                       SIGDAT.212
      NW=0                                                                       SIGDAT.213
      DO 255 L=2,IWK                                                             SIGDAT.214
      IF(WKSOND(3,L).GT.500.+1.E-2) GO TO 256                                    SIGDAT.215
      QQ=AB/(WKSOND(3,L)+AB)                                                     SIGDAT.216
      VAPS=QQ**C*S*EXP(E*(1.-QQ))                                                SIGDAT.217
      VAP=VAPS*WKSOND(4,L)/100.                                                  SIGDAT.218
      GU=LOG10(VAP/S)                                                            SIGDAT.219
      DDPP=B*GU/(A-GU)                                                           SIGDAT.220
  256 IF(WKSOND(1,L).GT.500.+1.E-2) GO TO 257                                    SIGDAT.221
      NW=NW+1                                                                    SIGDAT.222
      PW(NW)=WKSOND(5,L)                                                         SIGDAT.223
      IF(NW.EQ.1) GO TO 270                                                      SIGDAT.224
      PWDIF=ABS(PW(NW)-PW(NW-1))                                                 SIGDAT.225
      IF(PWDIF.LT.0.1) NW=NW-1                                                   SIGDAT.226
  270 U2=WKSOND(1,L)                                                             SIGDAT.227
      V2=WKSOND(2,L)                                                             SIGDAT.228
      U=-V2*SIN(ANGLE)+U2*COS(ANGLE)                                             SIGDAT.229
      V= V2*COS(ANGLE)+U2*SIN(ANGLE)                                             SIGDAT.230
      IF(U.EQ.0.) U=.001                                                         SIGDAT.231
      WD(NW)=-ATAN2(V,U)*RDD+270.                                                SIGDAT.232
      IF(WD(NW).LE.0.)WD(NW)=WD(NW)+360.                                         SIGDAT.233
      IF(WD(NW).GT.360.)WD(NW)=WD(NW)-360.                                       SIGDAT.234
      WS(NW)=(U**2+V**2)**0.5                                                    SIGDAT.235
      WS(NW)=WS(NW)*1.944                                                        SIGDAT.236
      PW(NW)=WKSOND(5,L)                                                         SIGDAT.237
      ZNW(NW)=WKSOND(6,L)                                                        SIGDAT.238
      PWH(NW)=PW(NW)                                                             SIGDAT.239
      WDH(NW)=WD(NW)                                                             SIGDAT.240
      WSH(NW)=WS(NW)                                                             SIGDAT.241
      ZWH(NW)=ZNW(NW)                                                            SIGDAT.242
      IF(ZNW(NW).GT.60000.) GO TO 258                                            SIGDAT.243
      IF(ZNW(NW).GT.ZNEG) GO TO 257                                              SIGDAT.244
      PWH(NW)=PW(NW)                                                             SIGDAT.245
      WDH(NW)=WD(NW)                                                             SIGDAT.246
      WSH(NW)=WS(NW)                                                             SIGDAT.247
      ZWH(NW)=ZNW(NW)                                                            SIGDAT.248
C                                                                                SIGDAT.249
C  CONVERT WIND LVL PRES TO STANDARD ATM HEIGHT AND ADJUST ACCORDING             SIGDAT.250
C  TO OBSERVED MANDATORY LVL HEIGHT. THESE HEIGHTS ARE NEEDED IN SUBR            SIGDAT.251
C  SORT                                                                          SIGDAT.252
C                                                                                SIGDAT.253
  258 ZNW(NW)=4.433E4*(1.-(PW(NW)/1013.25)**.19025)                              SIGDAT.254
      IF(PW(NW).LE.234.) ZNW(NW)=10769.+67.407*218.16*LOG10(234.53/              SIGDAT.255
     1 PW(NW))                                                                   SIGDAT.256
      IF(PW(NW).GT.GLVL(2)-1.E-2) ZNW(NW)=ZNW(NW)-CORZ(2)                        SIGDAT.257
      LZVERT=NVERT-1                                                             SIGDAT.258
      DO 262 LZ=2,LZVERT                                                         SIGDAT.259
      IF(PW(NW).GT.GLVL(2)-1.E-2) GO TO 263                                      SIGDAT.260
      IF(PW(NW).LT.GLVL(LZ)-.01.AND.PW(NW).GT.GLVL(LZ+1)-.01)GOTO 264            SIGDAT.261
      GO TO 262                                                                  SIGDAT.262
  264 ZCOR(LZ)=ZNW(NW)-(GLVL(LZ)-PW(NW))*CORZ(LZ+1)/(GLVL(LZ)-GLVL(LZ+1)         SIGDAT.263
     1)-(PW(NW)-GLVL(LZ+1))*CORZ(LZ)/(GLVL(LZ)-GLVL(LZ+1))                       SIGDAT.264
      IF(CORZ(LZ+1).EQ.0.) ZCOR(LZ)=ZNW(NW)-CORZ(LZ)                             SIGDAT.265
      ZNW(NW)=ZCOR(LZ)                                                           SIGDAT.266
      GO TO 263                                                                  SIGDAT.267
  262 CONTINUE                                                                   SIGDAT.268
  263 CONTINUE                                                                   SIGDAT.269
      IF(NW.GT.1) THEN                                                           SIGDAT.270
      IF(ZNW(NW).LT.ZNW(NW-1)) ZNW(NW)=ZNW(NW-1)+3.                              SIGDAT.271
      END IF                                                                     SIGDAT.272
      IF(NW.EQ.1) ZNW(NW)=0.0                                                    SIGDAT.273
      ZWH(NW)=ZNW(NW)                                                            SIGDAT.274
 257  IF(WKSOND(3,L).GT.500.+1.E-2)GO TO 255                                     SIGDAT.275
      NT=NT+1                                                                    SIGDAT.276
      PT(NT)=WKSOND(5,L)                                                         SIGDAT.277
      IF(NT.EQ.1) GO TO 271                                                      SIGDAT.278
      PTDIF=ABS(PT(NT)-PT(NT-1))                                                 SIGDAT.279
      IF(PTDIF.LT.0.1) NT=NT-1                                                   SIGDAT.280
  271 TP(NT)=WKSOND(3,L)                                                         SIGDAT.281
      DPT(NT)=DDPP                                                               SIGDAT.282
      IF(TP(NT).LT.-40.) DPT(NT)=TP(NT)-50.                                      SIGDAT.283
      PT(NT)=WKSOND(5,L)                                                         SIGDAT.284
      ZNT(NT)=WKSOND(6,L)                                                        SIGDAT.285
      IF(ZNT(NT).LT.ZNEG) ZNT(NT)=0.0                                            SIGDAT.286
      PTH(NT)=PT(NT)                                                             SIGDAT.287
      ZTH(NT)=ZNT(NT)                                                            SIGDAT.288
      TPH(NT)=TP(NT)                                                             SIGDAT.289
      DPH(NT)=DPT(NT)                                                            SIGDAT.290
  255 CONTINUE                                                                   SIGDAT.291
      NWW=NW                                                                     SIGDAT.292
      NTT=NT                                                                     SIGDAT.293
      IDENT=ISTNUM(1,N)                                                          SIGDAT.294
      LAT=IKLAT(1,N)                                                             SIGDAT.295
      LONG=IKLON(1,N)                                                            SIGDAT.296
      KELEV=IKELEV(1,N)                                                          SIGDAT.297
C                                                                                SIGDAT.298
C   STORE ORIGINAL ARRAYS GOING INTO SUBR SORT FOR LATER REFERENCE               SIGDAT.299
C                                                                                SIGDAT.300
      DO 155 I=1,NT                                                              SIGDAT.301
      ITFG(I)=0                                                                  SIGDAT.302
      PIN(I)= PT(I)                                                              SIGDAT.303
      TIN(I)= TP(I)                                                              SIGDAT.304
      HIN(I)=DPT(I)                                                              SIGDAT.305
      IF(I.GT.1) THEN                                                            SIGDAT.306
      IF(PT(I).GT.PT(I-1)) NSTPRB=1                                              SIGDAT.307
      ENDIF                                                                      SIGDAT.308
 155  ZIN(I)=ZNT(I)                                                              SIGDAT.309
      DO 156 I=1,NW                                                              SIGDAT.310
      IWFG(I)=0                                                                  SIGDAT.311
      PWN(I)= PW(I)                                                              SIGDAT.312
      DIN(I)= WD(I)                                                              SIGDAT.313
      SEN(I)= WS(I)                                                              SIGDAT.314
 156  WIN(I)=ZNW(I)                                                              SIGDAT.315
      ELVL=KELEV                                                                 SIGDAT.316
      NV=NTT                                                                     SIGDAT.317
      NQ=NWW                                                                     SIGDAT.318
      PT(1)=-PT(1)                                                               SIGDAT.319
      KPRINT=0                                                                   SIGDAT.320
      PWWNN=PWN(1)-.01                                                           SIGDAT.321
      IF(AUTBGW) GO TO 274                                                       SIGDAT.322
      if(ifound(3,n).eq.2) then                                                  SIGDAT.323
         print*, 'this is ifound: ',ifound(1,n),ifound(2,n),ifound(3,n)          SIGDAT.324
         print*, 'This is a bogus station, so we skip SORT.'                     SIGDAT.325
         go to 274                                                               SIGDAT.326
      endif                                                                      SIGDAT.327
      IF(NSTPRB.EQ.1) THEN                                                       SIGDAT.328
      PRINT 6948,IDENT                                                           SIGDAT.329
6948  FORMAT(2X,'$$$$$$$$$$ NOTE.......SUBR SORT NOT CALLED FOR STAT',           SIGDAT.330
     1'ION NO. =',1X,A6,2X,'(TEMP ARRAY ---CORRH--- IS OUT OF ORDER) $',         SIGDAT.331
     2'$$$$$$$$$')                                                               SIGDAT.332
      GO TO 274                                                                  SIGDAT.333
      ENDIF                                                                      SIGDAT.334
      IF(PIN(1).LT.PWWNN) THEN                                                   SIGDAT.335
      PRINT 275,IDENT                                                            SIGDAT.336
  275 FORMAT(2X,'$$$$$$$$$$ NOTE.......SUBR SORT NOT CALLED FOR STAT',           SIGDAT.337
     1'ION NO. =',1X,A6,2X,'(TEMP NOT AVAILABLE AT LOWEST LEVEL) $$$$$',         SIGDAT.338
     2'$$$$$')                                                                   SIGDAT.339
      print*, 'That is, ', PIN(1), ' .LT. ', PWWNN                               SIGDAT.340
      GO TO 274                                                                  SIGDAT.341
      END IF                                                                     SIGDAT.342
C                                                                                SIGDAT.343
C  CALL SUBR SORT FOR OBJECTIVE CHECK OF RAOB STATION DATA                       SIGDAT.344
C                                                                                SIGDAT.345
      LBUG=0                                                                     SIGDAT.346
      CALL SORT(PT,TP,DPT,ZNT,NV,PW,ZNW,WD,WS,NQ,ELVL,NTT,NWW,LBUG)              SIGDAT.347
  274 PT(1)=ABS(PT(1))                                                           SIGDAT.348
      IF(NT.EQ.0) NTT=0                                                          SIGDAT.349
      IF(NW.EQ.0) NWW=0                                                          SIGDAT.350
      NQ1=NWW+1                                                                  SIGDAT.351
      DO 280 I=NQ1,200                                                           06NOV00.543
  280 PW(I)=0.                                                                   SIGDAT.353
C                                                                                SIGDAT.354
C  STORE ARRAYS COMING OUT OF SUBR SORT FOR PLOTTING AND DISPOSAL TO             SIGDAT.355
C  THE RAOB(STATION DATA) TBM FILE                                               SIGDAT.356
C                                                                                SIGDAT.357
      DO 157 I=1,NTT                                                             SIGDAT.358
      POT(I)= PT(I)                                                              SIGDAT.359
      TOT(I)= TP(I)                                                              SIGDAT.360
      HOT(I)=DPT(I)                                                              SIGDAT.361
 157  ZOT(I)=ZNT(I)                                                              SIGDAT.362
      DO 158 I=1,NWW                                                             SIGDAT.363
      PWT(I)= PW(I)                                                              SIGDAT.364
      DOT(I)= WD(I)                                                              SIGDAT.365
      SOT(I)= WS(I)                                                              SIGDAT.366
 158  WOT(I)=ZNW(I)                                                              SIGDAT.367
C                                                                                SIGDAT.368
C  DETERMINE IF SUBR SORT CORRECTED (CHANGED VALUE) ANY BAD DATA                 SIGDAT.369
C                                                                                SIGDAT.370
      JZT=0                                                                      SIGDAT.371
      J=0                                                                        SIGDAT.372
      DO 161 I=1,NT                                                              SIGDAT.373
      J=J+1                                                                      SIGDAT.374
      PIN1=ABS(PIN(I)-POT(J))                                                    SIGDAT.375
      IF(PIN1.GE.0.1) J=J-1                                                      SIGDAT.376
      IF(PIN1.GE.0.1) GO TO 161                                                  SIGDAT.377
      TIN1=ABS(TIN(I)-TOT(J))                                                    SIGDAT.378
      HIN1=ABS(HIN(I)-HOT(J))                                                    SIGDAT.379
      IF(PIN1.LT.0.1.AND.TIN1.LT.0.1.AND.HIN1.LT.0.1) GO TO 161                  SIGDAT.380
      TPH(I)=TOT(J)                                                              SIGDAT.381
      DPH(I)=HOT(J)                                                              SIGDAT.382
      JZT=1                                                                      SIGDAT.383
      ITFG(I)=1                                                                  SIGDAT.384
  161 CONTINUE                                                                   SIGDAT.385
      J=0                                                                        SIGDAT.386
      DO 162 I=1,NW                                                              SIGDAT.387
      J=J+1                                                                      SIGDAT.388
      PIN1=ABS(PWN(I)-PWT(J))                                                    SIGDAT.389
      IF(PIN1.GE.0.1) J=J-1                                                      SIGDAT.390
      IF(PIN1.GE.0.1) GO TO 162                                                  SIGDAT.391
      DIN1=ABS(DIN(I)-DOT(J))                                                    SIGDAT.392
      SIN1=ABS(SEN(I)-SOT(J))                                                    SIGDAT.393
      IF(PIN1.LT.0.1.AND.DIN1.LT.0.1.AND.SIN1.LT.0.1) GO TO 162                  SIGDAT.394
      WDH(I)=DOT(J)                                                              SIGDAT.395
      WSH(I)=SOT(J)                                                              SIGDAT.396
      JZT=1                                                                      SIGDAT.397
      IWFG(I)=1                                                                  SIGDAT.398
  162 CONTINUE                                                                   SIGDAT.399
C                                                                                SIGDAT.400
C  WRITE CORRECTED RAOB STATION DATA TO TBM OUTPUT FILE                          SIGDAT.401
C                                                                                SIGDAT.402
      IF(AUTBGW .AND. .NOT.AUTBGR) GO TO 163                                     SIGDAT.403
      WRITE(11) IDENT,NTT,POT,TOT,HOT,ZOT,NWW,PWT,DOT,SOT,LAT,LONG,              SIGDAT.404
     1KELEV,IYR,IMO,IDY,IHR                                                      SIGDAT.405
C                                                                                SIGDAT.406
C  CALL PLOTTING ROUTINE                                                         SIGDAT.407
C                                                                                SIGDAT.408
 163  IF(.NOT.IPLT .OR. AUTBGR) GO TO 249                                        SIGDAT.409
#ifdef NCARG                                                                     SIGDAT.410
      IF (ISKEWT .EQ. 2) THEN                                                    SIGDAT.411
         CALL PLSOND(IDENT,NTT,POT,TOT,HOT,NWW,PWT,DOT,SOT,LAT,LONG,             SIGDAT.412
     &        IYR,IMO,IDY,IHR)                                                   SIGDAT.413
      ELSE                                                                       SIGDAT.414
         CALL SKEWT (POT, TOT, HOT, NTT, PWT, DOT, SOT, NWW,                     SIGDAT.415
     &        IDENT, LAT, LONG, IYR, IMO, IDY, IHR)                              SIGDAT.416
      ENDIF                                                                      SIGDAT.417
#endif                                                                           SIGDAT.418
  249 CONTINUE                                                                   SIGDAT.419
C                                                                                SIGDAT.420
C  DETERMINE IF SUBR SORT DELETED ANY BAD DATA LEVELS AND INTERPOLATE            SIGDAT.421
C  FOR ANY OF THESE DELETED DATA.                                                SIGDAT.422
C                                                                                SIGDAT.423
      IF(NTT.EQ.NT) GO TO 765                                                    SIGDAT.424
      JZT=1                                                                      SIGDAT.425
      NTNV=ABS(NT-NTT)                                                           SIGDAT.426
      J=0                                                                        SIGDAT.427
      DO 766 I=1,NT                                                              SIGDAT.428
      J=J+1                                                                      SIGDAT.429
      IF(PT(J).EQ.PTH(I)) GO TO 766                                              SIGDAT.430
      ITFG(I)=1                                                                  SIGDAT.431
      ZTH(I)=-222.                                                               SIGDAT.432
      IF(I.EQ.1.OR.I.EQ.NT.OR.NTNV.GT.1) GO TO 761                               SIGDAT.433
      GO TO 762                                                                  SIGDAT.434
 761  TPH(I)=1.E33                                                               SIGDAT.435
      DPH(I)=1.E33                                                               SIGDAT.436
      GO TO 764                                                                  SIGDAT.437
  762 TPFAC=TPH(I+1)-TPH(I-1)                                                    SIGDAT.438
      DPFAC=DPH(I+1)-DPH(I-1)                                                    SIGDAT.439
      TPH(I)=TPH(I-1)+LOG(PTH(I-1)/PTH(I))/LOG(PTH(I-1)/PTH(I+1))*               SIGDAT.440
     1TPFAC                                                                      SIGDAT.441
      DPH(I)=DPH(I-1)+LOG(PTH(I-1)/PTH(I))/LOG(PTH(I-1)/PTH(I+1))*               SIGDAT.442
     1DPFAC                                                                      SIGDAT.443
      ZTH(I)=-333.                                                               SIGDAT.444
  764 J=J-1                                                                      SIGDAT.445
  766 CONTINUE                                                                   SIGDAT.446
      DO 768 I=1,NT                                                              SIGDAT.447
      PT(I)=PTH(I)                                                               SIGDAT.448
      TP(I)=TPH(I)                                                               SIGDAT.449
      DPT(I)=DPH(I)                                                              SIGDAT.450
  768 ZNT(I)=ZTH(I)                                                              SIGDAT.451
  765 IF(NWW.EQ.NW) GO TO 439                                                    SIGDAT.452
      JZT=1                                                                      SIGDAT.453
      NWNQ=ABS(NW-NWW)                                                           SIGDAT.454
      J=0                                                                        SIGDAT.455
      DO 786 I=1,NW                                                              SIGDAT.456
      J=J+1                                                                      SIGDAT.457
      IF(PW(J).EQ.PWH(I)) GO TO 786                                              SIGDAT.458
      IWFG(I)=1                                                                  SIGDAT.459
      ZWH(I)=-222.                                                               SIGDAT.460
      IF(I.EQ.1.OR.I.EQ.NW.OR.NWNQ.GT.1) GO TO 777                               SIGDAT.461
      GO TO 778                                                                  SIGDAT.462
 777  WDH(I)=1.E33                                                               SIGDAT.463
      WSH(I)=1.E33                                                               SIGDAT.464
      GO TO 784                                                                  SIGDAT.465
 778  RID1=WDH(I-1)*PCON                                                         SIGDAT.466
      RID2=WDH(I+1)*PCON                                                         SIGDAT.467
      U1=WSH(I-1)*COS(CCC-RID1)                                                  SIGDAT.468
      V1=WSH(I-1)*SIN(CCC-RID1)                                                  SIGDAT.469
      U2=WSH(I+1)*COS(CCC-RID2)                                                  SIGDAT.470
      V2=WSH(I+1)*SIN(CCC-RID2)                                                  SIGDAT.471
      U3=U1+LOG(PWH(I-1)/PWH(I))/LOG(PWH(I-1)/PWH(I+1))*(U2-U1)                  SIGDAT.472
      V3=V1+LOG(PWH(I-1)/PWH(I))/LOG(PWH(I-1)/PWH(I+1))*(V2-V1)                  SIGDAT.473
      WDH(I)=-ATAN2(V3,U3)*RDD+270.                                              SIGDAT.474
      IF(WDH(I).LE.0.) WDH(I)=WDH(I)+360.                                        SIGDAT.475
      IF(WDH(I).GT.360.) WDH(I)=WDH(I)-360.                                      SIGDAT.476
      WSH(I)=(U3**2+V3**2)**0.5                                                  SIGDAT.477
      ZWH(I)=-333.                                                               SIGDAT.478
  784 J=J-1                                                                      SIGDAT.479
  786 CONTINUE                                                                   SIGDAT.480
      DO 788 I=1,NW                                                              SIGDAT.481
      PW(I)=PWH(I)                                                               SIGDAT.482
      WD(I)=WDH(I)                                                               SIGDAT.483
      WS(I)=WSH(I)                                                               SIGDAT.484
  788 ZNW(I)=ZWH(I)                                                              SIGDAT.485
  439 CONTINUE                                                                   SIGDAT.486
C                                                                                SIGDAT.487
C  RECONSTRUCT THE COMPOSITE SOUNDING (WKS ARRAY) FROM THE CORRECTED             SIGDAT.488
C  DATA                                                                          SIGDAT.489
C                                                                                SIGDAT.490
      DO 500 I=1,IWK                                                             SIGDAT.491
      IF(WKSOND(5,I).GT.FLOAT(1100).OR.WKSOND(5,I).EQ.0.0) GO TO 500             SIGDAT.492
      IF(I.EQ.1) GO TO 499                                                       SIGDAT.493
      PPDIF=ABS(WKSOND(5,I)-WKSOND(5,I-1))                                       SIGDAT.494
      IF(PPDIF.GT.0.1) GO TO 499                                                 SIGDAT.495
      WKS(ID1,I-1)=WKSOND(ID1,I-1)                                               SIGDAT.496
      DO 495 M=1,2                                                               SIGDAT.497
      WKS(M,I-1)=WKSOND(M,I-1)                                                   SIGDAT.498
      IF(IWFLG.GT.0) WKS(M,I-1)=1.E33                                            SIGDAT.499
  495 CONTINUE                                                                   SIGDAT.500
      DO 496 M=3,4                                                               SIGDAT.501
      WKS(M,I-1)=WKSOND(M,I-1)                                                   SIGDAT.502
      IF(ITFLG.GT.0) WKS(M,I-1)=1.E33                                            SIGDAT.503
  496 CONTINUE                                                                   SIGDAT.504
  499 CONTINUE                                                                   SIGDAT.505
      DO 501 J=1,NT                                                              SIGDAT.506
      IF(ABS(WKSOND(5,I)-PT(J)).GT.1.E-2) GO TO 501                              SIGDAT.507
      WKS(3,I)=TP(J)                                                             SIGDAT.508
      WKS(4,I)=10.**(DPT(J)*A/(B+DPT(J))-A*TP(J)/(B+TP(J)))*100.                 SIGDAT.509
      IF(WKS(4,I).LT.1.) WKS(4,I)=1.                                             23DEC04.7
C     IF(WKS(4,I).LT.10.) WKS(4,I)=10.                                           23DEC04.8
      IF(WKS(3,I).GT.1.E5) WKS(4,I)=1.E33                                        SIGDAT.511
      IF(WKSOND(3,I).GT.1.E3) WKS(3,I)=WKSOND(3,I)                               SIGDAT.512
      IF(WKSOND(4,I).GT.1.E3) WKS(4,I)=WKSOND(4,I)                               SIGDAT.513
      WKS(5,I)=PT(J)                                                             SIGDAT.514
      WKS(6,I)=ZNT(J)                                                            SIGDAT.515
      WKS(7,I)=WKSOND(7,I)                                                       SIGDAT.516
      WKSS=WKS(6,I)                                                              SIGDAT.517
      ITFLG=ITFG(J)                                                              SIGDAT.518
      GO TO 502                                                                  SIGDAT.519
  501 CONTINUE                                                                   SIGDAT.520
      WKS(3,I)=1.E33                                                             SIGDAT.521
      WKS(4,I)=1.E33                                                             SIGDAT.522
      WKS(6,I)=1.E33                                                             SIGDAT.523
      WKSS=WKS(6,I)                                                              SIGDAT.524
      WKS(7,I)=WKSOND(7,I)                                                       SIGDAT.525
      WKS(5,I)=WKSOND(5,I)                                                       SIGDAT.526
  502 DO 503 J=1,NW                                                              SIGDAT.527
      IF(ABS(WKSOND(5,I)-PW(J)).gt.1.E-3) GO TO 503                              SIGDAT.528
      RID=WD(J)*PCON                                                             SIGDAT.529
      IF(WD(J).GT.1.E5) GO TO 506                                                SIGDAT.530
      U3=WS(J)*COS(CCC-RID)*.5144                                                SIGDAT.531
      V3=WS(J)*SIN(CCC-RID)*.5144                                                SIGDAT.532
      WKS(1,I)=V3*SIN(ANGLE)+U3*COS(ANGLE)                                       SIGDAT.533
      WKS(2,I)=V3*COS(ANGLE)-U3*SIN(ANGLE)                                       SIGDAT.534
      GO TO 507                                                                  SIGDAT.535
  506 WKS(1,I)=WD(J)                                                             SIGDAT.536
      WKS(2,I)=WS(J)                                                             SIGDAT.537
  507 IF(WKSOND(1,I).GT.1.E3) WKS(1,I)=WKSOND(1,I)                               SIGDAT.538
      IF(WKSOND(2,I).GT.1.E3) WKS(2,I)=WKSOND(2,I)                               SIGDAT.539
      WKS(5,I)=PW(J)                                                             SIGDAT.540
      WKS(6,I)=ZNW(J)                                                            SIGDAT.541
      WKS(7,I)=WKSOND(7,I)                                                       SIGDAT.542
      IF(WKS(1,I).LT.1.E3.AND.WKS(2,I).LT.1.E3.AND.WKSS.EQ.WKIS)                 SIGDAT.543
     1 WKS(6,I)=WKSS                                                             SIGDAT.544
      IF(WKS(1,I).LT.1.E3.AND.WKS(2,I).LT.1.E3.AND.WKS(3,I).LT.1.E3              SIGDAT.545
     1 .AND.WKS(4,I).LT.1.E3) WKS(6,I)=WKSS                                      SIGDAT.546
      IWFLG=IWFG(J)                                                              SIGDAT.547
      GO TO 500                                                                  SIGDAT.548
  503 CONTINUE                                                                   SIGDAT.549
      WKS(1,I)=1.E33                                                             SIGDAT.550
      WKS(2,I)=1.E33                                                             SIGDAT.551
      WKS(6,I)=WKS(6,I)                                                          SIGDAT.552
      WKS(7,I)=WKSOND(7,I)                                                       SIGDAT.553
      WKS(5,I)=WKSOND(5,I)                                                       SIGDAT.554
  500 CONTINUE                                                                   SIGDAT.555
      DO 486 I=1,IWK                                                             SIGDAT.556
      IF(NT.NE.0) GO TO 487                                                      SIGDAT.557
      WKS(3,I)=WKSOND(3,I)                                                       SIGDAT.558
      WKS(4,I)=WKSOND(4,I)                                                       SIGDAT.559
  487 IF(NW.NE.0) GO TO 488                                                      SIGDAT.560
      WKS(1,I)=WKSOND(1,I)                                                       SIGDAT.561
      WKS(2,I)=WKSOND(2,I)                                                       SIGDAT.562
  488 IF(NW.EQ.0.AND.NT.EQ.0) WKS(5,I)=WKSOND(5,I)                               SIGDAT.563
  486 CONTINUE                                                                   SIGDAT.564
      DO 511 M=1,ID4                                                             SIGDAT.565
  511 WKS(M,1)=WKSOND(M,1)                                                       SIGDAT.566
C                                                                                SIGDAT.567
C  DETERMINE WHICH SOUNDINGS HAVE BEEN CORRECTED AND PRINT AN INVENTORY          SIGDAT.568
C  OF THESE AFFECTED STATIONS. THE NUMBER OF STATIONS AND LEVELS MUST            SIGDAT.569
C  MUST NOT HAVE CHANGED                                                         SIGDAT.570
C                                                                                SIGDAT.571
      DO 517 L=1,IWK                                                             SIGDAT.572
      DO 1010 JKL=1,5                                                            SIGDAT.573
      IF(WKS(JKL,L).GT.1.E30) WKS(JKL,L)=1.E33                                   SIGDAT.574
      IF(WKSOND(JKL,L).GT.1.E30) WKSOND(JKL,L)=1.E33                             SIGDAT.575
 1010 CONTINUE                                                                   SIGDAT.576
      DIFW1=ABS(WKS(1,L)-WKSOND(1,L))                                            SIGDAT.577
      DIFW2=ABS(WKS(2,L)-WKSOND(2,L))                                            SIGDAT.578
      DIFT3=ABS(WKS(3,L)-WKSOND(3,L))                                            SIGDAT.579
      DIFT4=ABS(WKS(4,L)-WKSOND(4,L))                                            SIGDAT.580
      IF(WKS(3,L).LT.DD3) DIFT4=0.0                                              SIGDAT.581
      DIFP=ABS(WKS(5,L)-WKSOND(5,L))                                             SIGDAT.582
      IF(AUTBGW) GO TO 517                                                       SIGDAT.583
      IF(DIFP.LT.0.1) GO TO 520                                                  SIGDAT.584
      KPRINT=2                                                                   SIGDAT.585
      PRINT 522                                                                  SIGDAT.586
      PRINT 523,IDENT                                                            SIGDAT.587
      PRINT 522                                                                  SIGDAT.588
      GO TO 510                                                                  SIGDAT.589
 520  IF(DIFW1.LT.0.1.AND.DIFW2.LT.0.1) GO TO 530                                SIGDAT.590
      KPRINT=1                                                                   SIGDAT.591
      IF(WKS(6,L).LT.A22.AND.WKS(6,L).GT.A33) PRINT 524,IDENT,WKS(1,1),          SIGDAT.592
     1WKS(2,1),WKS(5,L),WKSOND(1,L),WKSOND(2,L),WKS(1,L),WKS(2,L)                SIGDAT.593
      IF(WKS(6,L) .LT.A33) PRINT 525,IDENT,WKS(1,1),WKS(2,1),WKS(5,L)            SIGDAT.594
     1,WKSOND(1,L),WKSOND(2,L),WKS(1,L),WKS(2,L)                                 SIGDAT.595
      IF(WKS(6,L) .GT.A22) PRINT 526,IDENT,WKS(1,1),WKS(2,1),WKS(5,L)            SIGDAT.596
     1,WKSOND(1,L),WKSOND(2,L),WKS(1,L),WKS(2,L)                                 SIGDAT.597
      IF(WKS(6,L) .GT.A22.AND.WKS(1,L).GT.1.E3) PRINT 534,IDENT,WKS(1,1)         SIGDAT.598
     1,WKS(2,1),WKS(5,L),WKSOND(1,L),WKSOND(2,L),WKS(1,L),WKS(2,L)               SIGDAT.599
      IF(WKS(6,L) .GT.A22) KPRINT=1                                              SIGDAT.600
  530 IF(DIFT3.LT.0.1)GO TO 518                                                  SIGDAT.601
      GO TO 519                                                                  SIGDAT.602
  518 IF(DIFT4.LT.2.49)GO TO 517                                                 SIGDAT.603
  519 KPRINT=1                                                                   SIGDAT.604
      IF(WKS(6,L).LT.A22.AND.WKS(6,L).GT.A33) PRINT 527,IDENT,WKS(1,1),          SIGDAT.605
     1WKS(2,1),WKS(5,L),WKSOND(3,L),WKSOND(4,L),WKS(3,L),WKS(4,L)                SIGDAT.606
      IF(WKS(6,L).LT.A33) PRINT 528,IDENT,WKS(1,1),WKS(2,1),WKS(5,L)             SIGDAT.607
     1,WKSOND(3,L),WKSOND(4,L),WKS(3,L),WKS(4,L)                                 SIGDAT.608
      IF(WKS(6,L).GT.A22) PRINT 529,IDENT,WKS(1,1),WKS(2,1),WKS(5,L)             SIGDAT.609
     1,WKSOND(3,L),WKSOND(4,L),WKS(3,L),WKS(4,L)                                 SIGDAT.610
      IF(WKS(6,L).GT.A22.AND.WKS(3,L).GT.1.E3) PRINT 535,IDENT,WKS(1,1)          SIGDAT.611
     1,WKS(2,1),WKS(5,L),WKSOND(3,L),WKSOND(4,L),WKS(3,L),WKS(4,L)               SIGDAT.612
      IF(WKS(6,L).GT.A22) KPRINT=1                                               SIGDAT.613
  517 CONTINUE                                                                   SIGDAT.614
C                                                                                SIGDAT.615
C----------------------------------------------------------------------          SIGDAT.616
C  FORMATS FOR CORRECTED DATA INVENTORY                                          SIGDAT.617
C----------------------------------------------------------------------          SIGDAT.618
C                                                                                SIGDAT.619
  521 FORMAT(1H0,30X,'BAD DATA NOT CORRECTED-STATION ID =',1X,A6)                SIGDAT.620
  522 FORMAT(1X,'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',         SIGDAT.621
     1'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')         SIGDAT.622
  523 FORMAT(1H0,40X,'MISSING PRES--STATION ID =',1X,A6)                         SIGDAT.623
  524 FORMAT(1H0,' WIND DELETED AT STAT ID,(X-Y-P) COORD =',1X,A6,2X,2F5         SIGDAT.624
     1.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                            SIGDAT.625
  534 FORMAT(1H0,' DUP WIND LVL AT STAT ID,(X-Y-P) COORD =',1X,A6,2X,2F5         SIGDAT.626
     1.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                            SIGDAT.627
  525 FORMAT(1H0,' WIND INTERPOLATED AT STAT ID,(X-Y-P) COORD =',1X,A6,2         SIGDAT.628
     1X,2F5.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                       SIGDAT.629
  526 FORMAT(1H0,' WIND CHANGED IN SORT AT STAT ID,(X-Y-P) COORD =',1X,A         SIGDAT.630
     16,2X,2F5.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                    SIGDAT.631
  527 FORMAT(1H0,' T/RH DELETED AT STAT ID,(X-Y-P) COORD =',1X,A6,2X,2F5         SIGDAT.632
     1.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                            SIGDAT.633
  535 FORMAT(1H0,' DUP T/RH LVL AT STAT ID,(X-Y-P) COORD =',1X,A6,2X,2F5         SIGDAT.634
     1.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                            SIGDAT.635
  528 FORMAT(1H0,' T/RH INTERPOLATED AT STAT ID,(X-Y-P) COORD =',1X,A6,2         SIGDAT.636
     1X,2F5.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                       SIGDAT.637
  529 FORMAT(1H0,' T/RH CHANGED IN SORT AT STAT ID,(X-Y-P) COORD =',1X,A         SIGDAT.638
     16,2X,2F5.1,F9.1,'-----OLD/NEW VALUES =',2F6.1,4X,2F6.1)                    SIGDAT.639
  533 FORMAT(1H0,30X,'DATAH ARRAY(OUT) PROB-STATION ID =',1X,A6)                 SIGDAT.640
  510 CONTINUE                                                                   SIGDAT.641
  248 CONTINUE                                                                   SIGDAT.642
C                                                                                SIGDAT.643
C  CHECK FOR ANY BAD DATA THAT HAS NOT BEEN CORRECTED OR DELETED                 SIGDAT.644
C                                                                                SIGDAT.645
      IF(KPRINT.EQ.0.AND.JZT.EQ.1) GO TO 531                                     SIGDAT.646
      GO TO 532                                                                  SIGDAT.647
  531 PRINT 522                                                                  SIGDAT.648
      PRINT 521,IDENT                                                            SIGDAT.649
      PRINT 522                                                                  SIGDAT.650
      KPRINT=2                                                                   SIGDAT.651
 532  IF(KPRINT.LT.2) GO TO 429                                                  SIGDAT.652
      PRINT 426,NT                                                               SIGDAT.653
      PRINT 440,(PIN(I),TIN(I),HIN(I),ZIN(I),I=1,NT)                             SIGDAT.654
      PRINT 424                                                                  SIGDAT.655
      PRINT 427,NW                                                               SIGDAT.656
      PRINT 440,(PWN(I),DIN(I),SEN(I),WIN(I),I=1,NW)                             SIGDAT.657
      PRINT 436,NTT                                                              SIGDAT.658
      PRINT 440,(POT(I),TOT(I),HOT(I),ZOT(I),I=1,NTT)                            SIGDAT.659
      PRINT 424                                                                  SIGDAT.660
      PRINT 437,NWW                                                              SIGDAT.661
      PRINT 440,(PWT(I),DOT(I),SOT(I),WOT(I),I=1,NWW)                            SIGDAT.662
  440 FORMAT(72X,4F12.1)                                                         SIGDAT.663
  441 PRINT 425                                                                  SIGDAT.664
      DO 430 LKL=1,IWK                                                           SIGDAT.665
  430 PRINT 428,(WKSOND(M,LKL),M=1,ID4)                                          SIGDAT.666
C        COMPOSITE READY - NOW, INTERPOLATE TO GNLVLS                            SIGDAT.667
      PRINT 485                                                                  SIGDAT.668
      DO 515 L=1,IWK                                                             SIGDAT.669
  515 PRINT 428,(WKS(M,L),M=1,ID4)                                               SIGDAT.670
  429 CONTINUE                                                                   SIGDAT.671
      DO 431 L=1,IWK                                                             SIGDAT.672
      DO 431 M=1,ID1                                                             SIGDAT.673
  431 WKSOND(M,L)=WKS(M,L)                                                       SIGDAT.674
      DO 145 K = 1,NNEWPL                                                        SIGDAT.675
      CORRH(5,K+1,N) = GNLVL(K)                                                  SIGDAT.676
      DO 90 LL = 2,IWK                                                           SIGDAT.677
      L = LL                                                                     SIGDAT.678
      IF(WKSOND(5,L).GT.GNLVL(K)-.01.AND.WKSOND(5,L+1).LT.GNLVL(K)-.01)          SIGDAT.679
     1 GO TO 95                                                                  SIGDAT.680
  90  CONTINUE                                                                   SIGDAT.681
      GO TO 145                                                                  SIGDAT.682
C        NEAREST PRESSURE LEVEL TO GNLVL(K) HAS BEEN FOUND.                      SIGDAT.683
  95  CONTINUE                                                                   SIGDAT.684
      IVR = IUVEL                                                                SIGDAT.685
      GO TO 110                                                                  SIGDAT.686
C        SEARCH FOR TEMP. DATA NEAR GNLVL(K)                                     SIGDAT.687
 100  IVR = ITEMP                                                                SIGDAT.688
      GO TO 110                                                                  SIGDAT.689
C        SEARCH FOR REL. HUM. DATA NEAR GNLVL(K)                                 SIGDAT.690
 105  IVR = IRELH                                                                SIGDAT.691
 110  DO 120 LD = 2,L                                                            SIGDAT.692
      KD = L + 2 - LD                                                            SIGDAT.693
      IF(WKSOND(IVR,KD) .LT. 1.E5) GO TO 125                                     SIGDAT.694
 120  CONTINUE                                                                   SIGDAT.695
C        NO DATA FOR VARIABLE IVR BELOW GNLVL(K)                                 SIGDAT.696
      GO TO 140                                                                  SIGDAT.697
 125  LP = L + 1                                                                 SIGDAT.698
      DO 130 LU = LP,IWK                                                         SIGDAT.699
      KU = LU                                                                    SIGDAT.700
      IF(WKSOND(IVR,KU) .LT. 1.E5) GO TO 135                                     SIGDAT.701
 130  CONTINUE                                                                   SIGDAT.702
      GO TO 140                                                                  SIGDAT.703
C        UPPER AND LOWER VALUES FOR IVR HAVE BEEN FOUND NEAR GNLVL(K)            SIGDAT.704
 135  CONTINUE                                                                   SIGDAT.705
      CORRH(IVR,K+1,N) = WKSOND(IVR,KD) - (WKSOND(IVR,KD) - WKSOND(IVR,          SIGDAT.706
     1 KU))*(WKSOND(5,KD) - GNLVL(K))/(WKSOND(5,KD) - WKSOND(5,KU))              SIGDAT.707
      IF(IVR .NE. 1) GO TO 140                                                   SIGDAT.708
C        INTERPOLATE FOR V AT SAME TME AS FOR U                                  SIGDAT.709
      CORRH(IVR+1,K+1,N) = WKSOND(IVR+1,KD) - (WKSOND(IVR+1,KD) -                SIGDAT.710
     1 WKSOND(IVR+1,KU))*(WKSOND(5,KD) - GNLVL(K))/(WKSOND(5,KD)                 SIGDAT.711
     2 - WKSOND(5,KU))                                                           SIGDAT.712
 140  IF(IVR .EQ. IUVEL) GO TO 100                                               SIGDAT.713
      IF(IVR .EQ. ITEMP) GO TO 105                                               SIGDAT.714
 145  CONTINUE                                                                   SIGDAT.715
      IF(KPRINT.LT.2) GO TO 902                                                  SIGDAT.716
      PRINT 443                                                                  SIGDAT.717
      DO 444 L=1,15                                                              SIGDAT.718
  444 PRINT 423,(DATAH(M,L,N),M=1,ID1)                                           SIGDAT.719
C                                                                                SIGDAT.720
C  RECONSTRUCT CORRECTED DATAH ARRAY                                             SIGDAT.721
C                                                                                SIGDAT.722
  902 DO 432 L=2,IWK                                                             SIGDAT.723
      DO 432 LL=2,NVERT                                                          SIGDAT.724
      IF(ABS(WKS(5,L)-GLVL(LL)).gt.0.01.OR.WKS(7,L).EQ.99999.) GO TO 432         SIGDAT.725
      DO 434 M=1,4                                                               SIGDAT.726
  434 DATAH(M,LL,N)=WKS(M,L)                                                     SIGDAT.727
      IF(DATAH(5,LL,N).NE.WKS(7,L)) PRINT 522                                    SIGDAT.728
      IF(DATAH(5,LL,N).NE.WKS(7,L)) PRINT 533,IDENT                              SIGDAT.729
      IF(DATAH(5,LL,N).NE.WKS(7,L)) GO TO 448                                    SIGDAT.730
      DATAH(5,LL,N)=WKS(7,L)                                                     SIGDAT.731
  432 CONTINUE                                                                   SIGDAT.732
      IF(KPRINT.LT.2) GO TO 904                                                  SIGDAT.733
  448 PRINT 445                                                                  SIGDAT.734
      DO 435 L=1,15                                                              SIGDAT.735
  435 PRINT 423,(DATAH(M,L,N),M=1,ID1)                                           SIGDAT.736
  442 CONTINUE                                                                   SIGDAT.737
      PRINT 446                                                                  SIGDAT.738
      NNEW=NNEWPL+1                                                              SIGDAT.739
      DO 447 L=1,NNEW                                                            SIGDAT.740
  447 PRINT 423,(CORRH(M,L,N),M=1,ID1)                                           SIGDAT.741
      PRINT 898                                                                  SIGDAT.742
      PRINT 899                                                                  SIGDAT.743
      NSORT(LFILL)=0                                                             SIGDAT.744
  904 CONTINUE                                                                   SIGDAT.745
      IF (NMMAX .GT. 0) GO TO 150                                                SIGDAT.746
      PRINT 146,N                                                                SIGDAT.747
  146 FORMAT (6X,'INTERPOLATED VALUES,  STAT. NO.',I3)                           SIGDAT.748
      NP1 = NNEWPL + 1                                                           SIGDAT.749
      DO 148 LL = 1,NP1                                                          SIGDAT.750
      L = NP1 + 1 - LL                                                           SIGDAT.751
      PRINT 85, (CORRH(M,L,N),M=1,ID1)                                           SIGDAT.752
  148 CONTINUE                                                                   SIGDAT.753
 150  CONTINUE                                                                   SIGDAT.754
C        CORRH NOW HOLDS DATA AT NEW P-LEVELS, GNLVLS.                           SIGDAT.755
C        STORE COMPLETED FILE ON DISK                                            SIGDAT.756
      DO 181 L=1,ID2                                                             SIGDAT.757
      DO 171 M=1,ID1                                                             SIGDAT.758
      DO 171 N=1,ID3                                                             SIGDAT.759
171   BUFUPR(M,N)=DATAH(M,L,N)                                                   SIGDAT.760
      NAMED=NAMDAT+10000*L                                                       SIGDAT.761
      CALL WDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                             SIGDAT.762
  181 CONTINUE                                                                   SIGDAT.763
      DO 180 L = 1,ID2                                                           SIGDAT.764
      DO 170 M = 1,ID1                                                           SIGDAT.765
      DO 170 N = 1,ID3                                                           SIGDAT.766
170   BUFUPR(M,N)=CORRH(M,L,N)                                                   SIGDAT.767
      NAMEC = NAMCOR + 10000*L                                                   SIGDAT.768
      CALL WDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                             SIGDAT.769
 180  CONTINUE                                                                   SIGDAT.770
 200  CONTINUE                                                                   SIGDAT.771
      PRINT 999                                                                  SIGDAT.772
  999 FORMAT(1H1)                                                                SIGDAT.773
      IF (ISKEWT .EQ. 1) THEN                                                    SIGDAT.774
#ifdef NCARG                                                                     SIGDAT.775
         CALL GCLWK(8)                                                           SIGDAT.776
         ISKDRW = 0                                                              SIGDAT.777
#endif                                                                           SIGDAT.778
      ENDIF                                                                      SIGDAT.779
      RETURN                                                                     SIGDAT.780
  424 FORMAT(1H0)                                                                SIGDAT.781
  423 FORMAT (2X,4F12.1,F14.1)                                                   SIGDAT.782
  428 FORMAT (2X,5F10.1,2F12.1)                                                  SIGDAT.783
  425 FORMAT(1H0,25X,'COMPOSITE SOUNDING(IN)',/)                                 SIGDAT.784
  426 FORMAT(1H0,75X,'TEMP LEVELS(IN) =',I5)                                     SIGDAT.785
  436 FORMAT(1H0,78X,'TEMP LEVELS(OUT) =',I5)                                    SIGDAT.786
  427 FORMAT(1H0,78X,'WIND LEVELS(IN) =',I5)                                     SIGDAT.787
  437 FORMAT(1H0,78X,'WIND LEVELS(OUT) =',I5)                                    SIGDAT.788
  443 FORMAT(1H0,25X,'DATAH ARRAY(IN)',/)                                        SIGDAT.789
  445 FORMAT(1H0,25X,'DATAH ARRAY(OUT)',/)                                       SIGDAT.790
  446 FORMAT(1H0,25X,'NEW PRES LEVELS',/)                                        SIGDAT.791
  485 FORMAT(1H0,25X,'COMPOSITE SOUNDING(OUT)',/)                                SIGDAT.792
  898 FORMAT(1H0,115('-'))                                                       SIGDAT.793
  899 FORMAT(1H ,115('-'))                                                       SIGDAT.794
      END                                                                        SIGDAT.795
