      SUBROUTINE SKEWT (PRES,TEMP,DWPT,NNN,PW,DIR,SPD,NNW,                       SKEWTSUBS.1
     &   IDENT,LAT,LONG,YEAR,MONTH,DAY,HOUR)                                     SKEWTSUBS.2
#ifdef NCARG                                                                     SKEWTSUBS.3
C                                                                                SKEWTSUBS.4
C     SKEWT- PLOTS SOUNDINGS ON A SKEWT, LOG P THERMODYNAMIC DIAGRAM             SKEWTSUBS.5
C     (RAWINS VERSION)                                                           SKEWTSUBS.6
C     PRES- PRESSURE ARRAY FOR THERMODYNAMIC DATA (MB)                           SKEWTSUBS.7
C     TEMP- TEMPERATURE ARRAY (CELSIUS)                                          SKEWTSUBS.8
C     DWPT- DEW POINT ARRAY (CELSIUS)                                            SKEWTSUBS.9
C     NNN - NUMBER OF THERMO LEVELS                                              SKEWTSUBS.10
C     PW- PRESSURE OF THE WIND LEVELS                                            SKEWTSUBS.11
C     DIR- WIND DIRECTION ARRAY (DEGREES-0 IS NORTH)                             SKEWTSUBS.12
C     SPD- WIND SPEED ARRAY (KTS)                                                SKEWTSUBS.13
C     NNW- NUMBER OF WIND LEVELS                                                 SKEWTSUBS.14
C     IDENT - STATION ID                                                         SKEWTSUBS.15
C     LAT, LON, .... SELF EXPLANATORY                                            SKEWTSUBS.16
C                                                                                SKEWTSUBS.17
C        OUTPUT PARAMETERS.....                                                  SKEWTSUBS.18
C     ALL INPUT PARAMETERS REMAIN UNCHANGED BY THIS ROUTINE.                     SKEWTSUBS.19
C                                                                                SKEWTSUBS.20
      DIMENSION PRES(1),TEMP(1),DWPT(1),PW(1),SPD(1),DIR(1)                      SKEWTSUBS.21
      INTEGER LAT, LONG, YEAR, MONTH, DAY, HOUR                                  SKEWTSUBS.22
      CHARACTER LAB*120                                                          SKEWTSUBS.23
C                                                                                SKEWTSUBS.24
      CHARACTER IDENT*5                                                          SKEWTSUBS.25
#include <skwdrw.incl>                                                           SKEWTSUBS.26
C                                                                                SKEWTSUBS.27
C  DEGREES TO RADIANS                                                            SKEWTSUBS.28
      PARAMETER (DTR = 0.0174532925)                                             SKEWTSUBS.29
C  WIND BARB DATA                                                                SKEWTSUBS.30
      PARAMETER (XM = 24.2)                                                      SKEWTSUBS.31
C                                                                                SKEWTSUBS.32
C  LINE WIDTH VARIABLES                                                          SKEWTSUBS.33
C                                                                                SKEWTSUBS.34
      DATA ISPOPT / 'LW' /                                                       SKEWTSUBS.35
      DATA ISWIDE / 2000 /                                                       SKEWTSUBS.36
C                                                                                SKEWTSUBS.37
C  MAPPINGS FROM (P,T) TO CM ON SKEWT                                            SKEWTSUBS.38
C                                                                                SKEWTSUBS.39
      FY(P) = 132.182 - 44.061 * ALOG10(P)                                       SKEWTSUBS.40
      FX(T,Y) = 0.54 * T + 0.90692 * Y                                           SKEWTSUBS.41
C                                                                                SKEWTSUBS.42
C  TEST TO SEE IF A BACKGROUND HAS BEEN DRAWN, IF NOT CALL SKWTBKG               SKEWTSUBS.43
C                                                                                SKEWTSUBS.44
      CALL GSPLCI (1 )                                                           SKEWTSUBS.45
      CALL GSPMCI (1 )                                                           SKEWTSUBS.46
      CALL GSTXCI (1 )                                                           SKEWTSUBS.47
      IF (ISKDRW .EQ. 0) THEN                                                    SKEWTSUBS.48
        CALL SKWTBKG                                                             SKEWTSUBS.49
        ISKDRW = 1                                                               SKEWTSUBS.50
      END IF                                                                     SKEWTSUBS.51
      CALL GSPLCI (9 )                                                           SKEWTSUBS.52
      CALL GSPMCI (9 )                                                           SKEWTSUBS.53
      CALL GSTXCI (9 )                                                           SKEWTSUBS.54
C                                                                                SKEWTSUBS.55
C  SKEWT BACKGROUND HAS BEEN GENERATED-- PLOT THE SOUNDING                       SKEWTSUBS.56
C                                                                                SKEWTSUBS.57
      CALL GFLAS3 (1)                                                            SKEWTSUBS.58
      CALL SET(.05,.95,.05,.95,-19.0,27.1,-.9346217,44.061,1)                    SKEWTSUBS.59
C                                                                                SKEWTSUBS.60
C  PUT ON TITLE                                                                  SKEWTSUBS.61
C                                                                                SKEWTSUBS.62
      WRITE(LAB,106) IDENT, LAT/10., LONG/10., YEAR, MONTH, DAY, HOUR            SKEWTSUBS.63
      CALL WTSTR (-19.5,-1.6,LAB,12,0,-1)                                        SKEWTSUBS.64
  106 FORMAT(1X,A5,1X,'LAT = ',F5.1,' LON = ',F6.1,3X, I4, '-', I2.2,            SKEWTSUBS.65
     & '-',I2.2,' / ',I2.2,' UTC')                                               SKEWTSUBS.66
      CALL GSPLCI (1 )                                                           SKEWTSUBS.67
      CALL GSPMCI (1 )                                                           SKEWTSUBS.68
      CALL GSTXCI (1 )                                                           SKEWTSUBS.69
      IF(NNN.GT.0) CALL LINE(XM,-.9346217,XM,44.061)                             SKEWTSUBS.70
C                                                                                SKEWTSUBS.71
C  SOLID DASH PATTERN, INCREASED SPOT SIZE (DEFAULT=8)                           SKEWTSUBS.72
C                                                                                SKEWTSUBS.73
      CALL DASHDB (65535)                                                        SKEWTSUBS.74
      CALL GETUSV (ISPOPT,ISNORM)                                                SKEWTSUBS.75
      ISWIDE = ISWIDE + 3000                                                     SKEWTSUBS.76
      CALL SETUSV (ISPOPT,ISWIDE)                                                SKEWTSUBS.77
      ISWIDE = ISWIDE - 3000                                                     SKEWTSUBS.78
C                                                                                SKEWTSUBS.79
      CALL SETUSV('LW',4000)                                                     SKEWTSUBS.80
      CALL GSPLCI (16)                                                           SKEWTSUBS.81
      CALL GSPMCI (16)                                                           SKEWTSUBS.82
      CALL GSTXCI (16)                                                           SKEWTSUBS.83
      DO 60 I=1,NNN                                                              SKEWTSUBS.84
        Y=FY(PRES(I))                                                            SKEWTSUBS.85
        X=FX(TEMP(I),Y)                                                          SKEWTSUBS.86
        IF (I.EQ.1) CALL FRSTPT(X,Y)                                             SKEWTSUBS.87
        CALL VECTOR(X,Y)                                                         SKEWTSUBS.88
   60 CONTINUE                                                                   SKEWTSUBS.89
   61 CONTINUE                                                                   SKEWTSUBS.90
      CALL SETUSV('LW',3000)                                                     SKEWTSUBS.91
      CALL GSPLCI (12)                                                           SKEWTSUBS.92
      CALL GSPMCI (12)                                                           SKEWTSUBS.93
      CALL GSTXCI (12)                                                           SKEWTSUBS.94
      CALL GSCLIP(1)                                                             SKEWTSUBS.95
      DO 70 I=1,NNN                                                              SKEWTSUBS.96
        Y=FY(PRES(I))                                                            SKEWTSUBS.97
        X=FX(DWPT(I),Y)                                                          SKEWTSUBS.98
        IF(I.EQ.1)CALL FRSTPT(X,Y)                                               SKEWTSUBS.99
        CALL VECTOR(X,Y)                                                         SKEWTSUBS.100
   70 CONTINUE                                                                   SKEWTSUBS.101
   71 CONTINUE                                                                   SKEWTSUBS.102
      CALL GSCLIP(0)                                                             SKEWTSUBS.103
      CALL SETUSV('LW',2000)                                                     SKEWTSUBS.104
      CALL GSPLCI (8 )                                                           SKEWTSUBS.105
      CALL GSPMCI (8 )                                                           SKEWTSUBS.106
      CALL GSTXCI (8 )                                                           SKEWTSUBS.107
C                                                                                SKEWTSUBS.108
C         PLOT WIND BARBS (PASS M/S TO WBARB)                                    SKEWTSUBS.109
C                                                                                SKEWTSUBS.110
      IF (NNW.LE.0) GO TO 76                                                     SKEWTSUBS.111
C                                                                                SKEWTSUBS.112
      CALL SETUSV (ISPOPT,ISWIDE)                                                SKEWTSUBS.113
      DO 75 I=1,NNW                                                              SKEWTSUBS.114
      IF (DIR(I) .GT. 360.) GO TO 75                                             SKEWTSUBS.115
      IF (PW(I) .LT. 10.) GO TO 75                                               SKEWTSUBS.116
        ANG=DIR(I)*DTR                                                           SKEWTSUBS.117
        U = -SPD(I)*SIN(ANG)*0.51546                                             SKEWTSUBS.118
        V = -SPD(I)*COS(ANG)*0.51546                                             SKEWTSUBS.119
        Y1=FY(PW(I))                                                             SKEWTSUBS.120
        CALL WBARB (XM,Y1,U,V)                                                   SKEWTSUBS.121
   75 CONTINUE                                                                   SKEWTSUBS.122
   76 CONTINUE                                                                   SKEWTSUBS.123
      CALL GSPLCI (1 )                                                           SKEWTSUBS.124
      CALL GSPMCI (1 )                                                           SKEWTSUBS.125
      CALL GSTXCI (1 )                                                           SKEWTSUBS.126
C                                                                                SKEWTSUBS.127
C  RESET TO NORMAL SPOT SIZE AND EXIT                                            SKEWTSUBS.128
C                                                                                SKEWTSUBS.129
      CALL SETUSV (ISPOPT,ISNORM)                                                SKEWTSUBS.130
C                                                                                SKEWTSUBS.131
      CALL FRAME                                                                 SKEWTSUBS.132
C                                                                                SKEWTSUBS.133
      RETURN                                                                     SKEWTSUBS.134
      END                                                                        SKEWTSUBS.135
C------------------------------------------------------------------------        SKEWTSUBS.136
      SUBROUTINE SKWTBKG                                                         SKEWTSUBS.137
C                                                                                SKEWTSUBS.138
C  SKWTBKG- PLOTS BACKGROUND FOR A SKEWT, LOG P THERMODYNAMIC DIAGRAM            SKEWTSUBS.139
C                                                                                SKEWTSUBS.140
#include <skwdrw.incl>                                                           SKEWTSUBS.141
C                                                                                SKEWTSUBS.142
C  ENCODE BUFFER                                                                 SKEWTSUBS.143
C                                                                                SKEWTSUBS.144
      CHARACTER*4 ITIT                                                           SKEWTSUBS.145
C                                                                                SKEWTSUBS.146
C  SKEWT BORDER                                                                  SKEWTSUBS.147
C                                                                                SKEWTSUBS.148
      DIMENSION XB(7),YB(7)                                                      SKEWTSUBS.149
      DATA XB/-19.,27.1,27.1,18.6,18.6,-19.,-19./                                SKEWTSUBS.150
      DATA YB/-.9346217,-.9346217,9.,17.53,44.061,44.061,-.9346217/              SKEWTSUBS.151
C                                                                                SKEWTSUBS.152
C  PRESSURE LINE SPECS                                                           SKEWTSUBS.153
C                                                                                SKEWTSUBS.154
      DIMENSION PLV(11),PLN(11,2)                                                SKEWTSUBS.155
      DATA PLV/100.,200.,300.,400.,500.,600.,700.,800.,900.,                     SKEWTSUBS.156
     &         1000.,1050./                                                      SKEWTSUBS.157
      DATA PLN/11*-19.,4*18.6,22.83,26.306,5*27.1/                               SKEWTSUBS.158
C                                                                                SKEWTSUBS.159
C  TEMPERATURE LINE SPECS                                                        SKEWTSUBS.160
C                                                                                SKEWTSUBS.161
      DIMENSION TP(15,2)                                                         SKEWTSUBS.162
      DATA TP/8*1050.,855.,625.,459.,337.,247.,181.,132.,730.,580.,500.,         SKEWTSUBS.163
     &   430.,342.,251.,185.,135.,7*100./                                        SKEWTSUBS.164
C                                                                                SKEWTSUBS.165
C  MIXING RATIO SPECS                                                            SKEWTSUBS.166
C                                                                                SKEWTSUBS.167
      REAL        RAT(8)                                                         SKEWTSUBS.168
      CHARACTER*2 LRAT(8)                                                        SKEWTSUBS.169
      DATA RAT/20.,12.,8.,5.,3.,2.,1.,0.4/                                       SKEWTSUBS.170
      DATA LRAT/'20','12',' 8',' 5',' 3',' 2',' 1','.4'/                         SKEWTSUBS.171
C                                                                                SKEWTSUBS.172
C  DRY/SATURATED ADAIBAT BUFFERS                                                 SKEWTSUBS.173
C                                                                                SKEWTSUBS.174
      DIMENSION SX(162),SY(162),Y45(162)                                         SKEWTSUBS.175
C                                                                                SKEWTSUBS.176
C  DEGREES TO RADIANS, ABSOLUTE ZERO                                             SKEWTSUBS.177
C                                                                                SKEWTSUBS.178
      PARAMETER (ABZ = 273.16)                                                   SKEWTSUBS.179
C                                                                                SKEWTSUBS.180
C  MAPPINGS FROM (P,T) TO CM ON SKEWT                                            SKEWTSUBS.181
C                                                                                SKEWTSUBS.182
      FY(P)=132.182-44.061*ALOG10(P)                                             SKEWTSUBS.183
      FX(T,Y)=0.54*T+0.90692*Y                                                   SKEWTSUBS.184
C                                                                                SKEWTSUBS.185
C  DRAW SKEWT BORDER                                                             SKEWTSUBS.186
C                                                                                SKEWTSUBS.187
      CALL GFLAS1 (1)                                                            SKEWTSUBS.188
      CALL SET(.05,.95,.05,.95,-19.0,27.1,-.9346217,44.061,1)                    SKEWTSUBS.189
      CALL CURVE(XB,YB,7)                                                        SKEWTSUBS.190
C                                                                                SKEWTSUBS.191
C  DRAW THE PRESSURE LINES                                                       SKEWTSUBS.192
C                                                                                SKEWTSUBS.193
      DO 10 K=1,11                                                               SKEWTSUBS.194
         Y1=FY(PLV(K))                                                           SKEWTSUBS.195
         IF(K.NE.1.AND.K.NE.11) CALL LINE(PLN(K,1),Y1,PLN(K,2),Y1)               SKEWTSUBS.196
         ITS=NINT(PLV(K))                                                        SKEWTSUBS.197
      WRITE (ITIT,101) ITS                                                       SKEWTSUBS.198
  101    FORMAT(I4)                                                              SKEWTSUBS.199
C        CALL PWRY(-20.9,Y1,ITIT,4,1.9,0,0)                                      SKEWTSUBS.200
      CALL WTSTR (-19.2,Y1,ITIT,11,0,1)                                          SKEWTSUBS.201
   10 CONTINUE                                                                   SKEWTSUBS.202
C                                                                                SKEWTSUBS.203
C  DRAW TEMPERATURE LINES                                                        SKEWTSUBS.204
C                                                                                SKEWTSUBS.205
      T=40.                                                                      SKEWTSUBS.206
      DO 20 I=1,15                                                               SKEWTSUBS.207
         Y1=FY(TP(I,1))                                                          SKEWTSUBS.208
         Y2=FY(TP(I,2))                                                          SKEWTSUBS.209
         X1=FX(T,Y1)                                                             SKEWTSUBS.210
         X2=FX(T,Y2)                                                             SKEWTSUBS.211
         CALL LINE(X1,Y1,X2,Y2)                                                  SKEWTSUBS.212
         ITS=NINT(T)                                                             SKEWTSUBS.213
         IF(ITS.EQ.20) GO TO 19                                                  SKEWTSUBS.214
            X2=X2+0.4                                                            SKEWTSUBS.215
            Y2=Y2+0.441                                                          SKEWTSUBS.216
      WRITE (ITIT,101) ITS                                                       SKEWTSUBS.217
C           CALL PWRY(X2,Y2,ITIT,4,12,.83422,0)                                  SKEWTSUBS.218
      CALL WTSTR (X2,Y2,ITIT,12,47,-1)                                           SKEWTSUBS.219
   19    T=T-10.                                                                 SKEWTSUBS.220
   20 CONTINUE                                                                   SKEWTSUBS.221
C                                                                                SKEWTSUBS.222
C  TICK MARKS AT 500 MB                                                          SKEWTSUBS.223
C                                                                                SKEWTSUBS.224
      Y1=13.2627                                                                 SKEWTSUBS.225
      Y2=13.75                                                                   SKEWTSUBS.226
      T=-52.                                                                     SKEWTSUBS.227
      DO 25 I=1,31                                                               SKEWTSUBS.228
         T=T+2.                                                                  SKEWTSUBS.229
         IF(AMOD(T,10.).EQ.0.)GO TO 25                                           SKEWTSUBS.230
         X1=FX(T,Y1)                                                             SKEWTSUBS.231
         X2=FX(T,Y2)                                                             SKEWTSUBS.232
         CALL LINE(X1,Y1,X2,Y2)                                                  SKEWTSUBS.233
   25 CONTINUE                                                                   SKEWTSUBS.234
C                                                                                SKEWTSUBS.235
C  DRAW MIXING RATIO LINES                                                       SKEWTSUBS.236
C                                                                                SKEWTSUBS.237
      CALL DASHDB (3855)      ! PATTERN = 0000111100001111                       SKEWTSUBS.238
      Y1=FY(1050.)                                                               SKEWTSUBS.239
      Y2=FY(700.)                                                                SKEWTSUBS.240
      DO 30 I=1,8                                                                SKEWTSUBS.241
         X1=FX(TMR(RAT(I),1050.)-ABZ,Y1)                                         SKEWTSUBS.242
         X2=FX(TMR(RAT(I), 700.)-ABZ,Y2)                                         SKEWTSUBS.243
         CALL LINED(X1,Y1,X2,Y2)                                                 SKEWTSUBS.244
C        CALL PWRY(X2,Y2+0.6,LRAT(I),2,10,0,1)                                   SKEWTSUBS.245
      CALL WTSTR (X2,Y2+0.6,LRAT(I),10,0,0)                                      SKEWTSUBS.246
   30 CONTINUE                                                                   SKEWTSUBS.247
C                                                                                SKEWTSUBS.248
C  DRAW SATURATED ADIABATS                                                       SKEWTSUBS.249
C                                                                                SKEWTSUBS.250
      CALL DASHDB (31710)     ! PATTERN = 0111101111011110                       SKEWTSUBS.251
      TS=32.                                                                     SKEWTSUBS.252
      DO 40 I=1,7                                                                SKEWTSUBS.253
         P=1060.                                                                 SKEWTSUBS.254
         TK=TS+ABZ                                                               SKEWTSUBS.255
         AOS=OS(TK,1000.)                                                        SKEWTSUBS.256
         DO 35 J=1,86                                                            SKEWTSUBS.257
            P=P-10.                                                              SKEWTSUBS.258
            ATSA=TSA(AOS,P)-ABZ                                                  SKEWTSUBS.259
            SY(J)=FY(P)                                                          SKEWTSUBS.260
            SX(J)=FX(ATSA,SY(J))                                                 SKEWTSUBS.261
   35    CONTINUE                                                                SKEWTSUBS.262
         CALL CURVED(SX,SY,86)                                                   SKEWTSUBS.263
         ITS=NINT(TS)                                                            SKEWTSUBS.264
      WRITE (ITIT,102) ITS                                                       SKEWTSUBS.265
  102    FORMAT(I2)                                                              SKEWTSUBS.266
C        CALL PWRY(SX(86),SY(86)+0.6,ITIT,2,10,0,1)                              SKEWTSUBS.267
      CALL WTSTR (SX(86),SY(86)+0.6,ITIT(1:2),10,0,0)                            SKEWTSUBS.268
         TS=TS-4.0                                                               SKEWTSUBS.269
   40 CONTINUE                                                                   SKEWTSUBS.270
C                                                                                SKEWTSUBS.271
C  DRAW DRY ADIABAT LINES                                                        SKEWTSUBS.272
C                                                                                SKEWTSUBS.273
      CALL DASHDB (21845)     ! PATTERN = 0101010101010101                       SKEWTSUBS.274
C     CALL DASHD(4444B)                                                          SKEWTSUBS.275
      T=51.                                                                      SKEWTSUBS.276
      DO 45 I=1,162                                                              SKEWTSUBS.277
         Y45(I)=66.67*(5.7625544-ALOG(T+ABZ))                                    SKEWTSUBS.278
         T=T-1.0                                                                 SKEWTSUBS.279
   45 CONTINUE                                                                   SKEWTSUBS.280
      T=450.                                                                     SKEWTSUBS.281
      TD=52.                                                                     SKEWTSUBS.282
      DO 55 I=1,20                                                               SKEWTSUBS.283
         T=T-10.                                                                 SKEWTSUBS.284
         K=0                                                                     SKEWTSUBS.285
         YD=66.67*(ALOG(T)-5.7625544)                                            SKEWTSUBS.286
         DO 50 J=1,162                                                           SKEWTSUBS.287
            YPD=Y45(J)+YD                                                        SKEWTSUBS.288
            TX=TD-FLOAT(J)                                                       SKEWTSUBS.289
            IF(YPD.GT.44.061) GO TO 54                                           SKEWTSUBS.290
            IF(YPD.LT.-.9346217) GO TO 50                                        SKEWTSUBS.291
            XPD=FX(TX,YPD)                                                       SKEWTSUBS.292
            IF(XPD.LT.-19.0)GO TO 54                                             SKEWTSUBS.293
            IF(XPD.GT.27.1)GO TO 50                                              SKEWTSUBS.294
            IF(XPD.GT.18.6.AND.T.GT.350.0)GO TO 50                               SKEWTSUBS.295
               K=K+1                                                             SKEWTSUBS.296
               SX(K)=XPD                                                         SKEWTSUBS.297
               SY(K)=YPD                                                         SKEWTSUBS.298
   50    CONTINUE                                                                SKEWTSUBS.299
C                                                                                SKEWTSUBS.300
   54    CALL CURVED(SX,SY,K)                                                    SKEWTSUBS.301
         ITS=NINT(T)                                                             SKEWTSUBS.302
      WRITE (ITIT,103) ITS                                                       SKEWTSUBS.303
  103    FORMAT(I3)                                                              SKEWTSUBS.304
C        IF(ITS .GE. 320) THEN                                                   SKEWTSUBS.305
C           CALL PWRY(SX(K-3),43.0,ITIT,3,10,0,1)                                SKEWTSUBS.306
C           ELSE                                                                 SKEWTSUBS.307
C           CALL PWRY(-18.0,SY(K-3),ITIT,3,10,0,1)                               SKEWTSUBS.308
C        END IF                                                                  SKEWTSUBS.309
         X=SX(K-3)                                                               SKEWTSUBS.310
         Y=SY(K-3)                                                               SKEWTSUBS.311
         IF(X.LT.-15.0) X = -17.95                                               SKEWTSUBS.312
         IF(Y.GT.40.0)  Y = 42.9                                                 SKEWTSUBS.313
      CALL WTSTR (X,Y,ITIT(1:3),10,0,0)                                          SKEWTSUBS.314
   55 CONTINUE                                                                   SKEWTSUBS.315
C                                                                                SKEWTSUBS.316
      CALL GFLAS2                                                                SKEWTSUBS.317
      ISKDRW = 1                                                                 SKEWTSUBS.318
      RETURN                                                                     SKEWTSUBS.319
      END                                                                        SKEWTSUBS.320
C---------------------------------------------------------------                 SKEWTSUBS.321
      SUBROUTINE WBARB (XBASE,YBASE,U,V)                                         SKEWTSUBS.322
                                                                                 SKEWTSUBS.323
C***********************************************************************         SKEWTSUBS.324
C WBARB - COPY OF WNDBARB FROM THE GRAPH PORTION OF GRIN                         SKEWTSUBS.325
C  THIS ROUTINE DRAWS A SINGLE WIND BARB PER CALL.                               SKEWTSUBS.326
C                                                                                SKEWTSUBS.327
C ON INPUT - FOUR VARIABLES COME IN.  XBASE CONTAINS THE HORIZONTAL COOR         SKEWTSUBS.328
C            DINATE OF THE BASE OF THE WIND BARB.  YBASE CONTAINS THE            SKEWTSUBS.329
C            VERTICAL COORDINATE OF THE BASE OF THE WIND BARB.  U CONTAI         SKEWTSUBS.330
C            THE EAST-WEST WIND COMPONENT IN METERS PER SECOND.  V CONTA         SKEWTSUBS.331
C            THE NORTH-SOUTH WIND COMPONENT IN METERS PER SECOND.                SKEWTSUBS.332
C                                                                                SKEWTSUBS.333
C ON OUTPUT - ONE BARB HAS BEEN DRAWN TO UNIT NUMBER 2, WHICH CORRESPOND         SKEWTSUBS.334
C            TO GMETA.CGM, THE GKS OUTPUT META CODE FILE.                        SKEWTSUBS.335
C                                                                                SKEWTSUBS.336
C ASSUMPTIONS - THIS ROUTINE ASSUMES THAT GKS HAS BEEN OPENED AND A WORK         SKEWTSUBS.337
C            STATION HAS BEEN SET.                                               SKEWTSUBS.338
C                                                                                SKEWTSUBS.339
C REVISED BY - JEREMY ASBILL ON MAY 3, 1990.                                     SKEWTSUBS.340
C***********************************************************************         SKEWTSUBS.341
                                                                                 SKEWTSUBS.342
C  INPUT VARIABLE DECLARATIONS ...                                               SKEWTSUBS.343
                                                                                 SKEWTSUBS.344
      REAL      XBASE,YBASE,                                                     SKEWTSUBS.345
     *          U,V                                                              SKEWTSUBS.346
                                                                                 SKEWTSUBS.347
C  LOCAL PARAMETER ...                                                           SKEWTSUBS.348
C    SC SPECIFIES IN THE NORMALIZED (FRACTIONAL) GRAPHICS COORDINATE             SKEWTSUBS.349
C       SYSTEM HOW LONG THE BARB SHAFT IS TO BE                                  SKEWTSUBS.350
C    COORDINATE SYSTEMS ARE EXPLAINED IN NCAR GRAPHICS USERS GUIDE VERS          SKEWTSUBS.351
C    2.00 ON PAGE 46.                                                            SKEWTSUBS.352
                                                                                 SKEWTSUBS.353
      PARAMETER (SC = 0.05493)                                                   SKEWTSUBS.354
                                                                                 SKEWTSUBS.355
C  LOCAL VARIABLE DECLARATIONS ...                                               SKEWTSUBS.356
                                                                                 SKEWTSUBS.357
      INTEGER   LLSV                 ! SAVE VARIABLE, SCALING FOR SET            SKEWTSUBS.358
                                                                                 SKEWTSUBS.359
      LOGICAL DONE                   ! T => SUBROUTINE ENDS, F => LOOP A         SKEWTSUBS.360
                                                                                 SKEWTSUBS.361
      REAL      WINDVCT,             ! WIND VECTOR MAGNITUDE                     SKEWTSUBS.362
     *          FLSV,FRSV,FBSV,FTSV, ! SAVE VARIABLES, FRACTIONAL COORDI         SKEWTSUBS.363
     *          ULSV,URSV,UBSV,UTSV, ! SAVE VARIABLES, INCOMING USER COO         SKEWTSUBS.364
     *          NEWXBASE,            ! FRACTIONAL X COORD. FOR BARB BASE         SKEWTSUBS.365
     *          NEWYBASE,            ! FRACTIONAL Y COORD. FOR BARB BASE         SKEWTSUBS.366
     *          XCOMP,               ! X COMPONENT OF GRAPHICAL VECTOR (         SKEWTSUBS.367
     *          YCOMP,               ! Y COMPONENT OF GRAPHICAL VECTOR (         SKEWTSUBS.368
     *          PK,                  ! PLACE KEEPER                              SKEWTSUBS.369
     *          FETHLENX,            ! X COMPONENT OF GRAPHICAL VECT. (F         SKEWTSUBS.370
     *          FETHLENY             ! Y COMPONENT OF GRAPHICAL VECT. (F         SKEWTSUBS.371
                                                                                 SKEWTSUBS.372
C  LOCAL ARRAY DECLARATIONS ...                                                  SKEWTSUBS.373
                                                                                 SKEWTSUBS.374
      INTEGER   IJUNK(5)             ! CALCULATION ARRAY FOR SFSGFA              SKEWTSUBS.375
                                                                                 SKEWTSUBS.376
      REAL      POINTX(3),           ! USED TO SPECIFY POINTS TO DRAW BE         SKEWTSUBS.377
     *          POINTY(3),           ! USED TO SPECIFY POINTS TO DRAW BE         SKEWTSUBS.378
     *          JUNK(7)              ! CALCULATION ARRAY FOR SFSGFA              SKEWTSUBS.379
                                                                                 SKEWTSUBS.380
C***************************** SUBROUTINE BEGIN ************************         SKEWTSUBS.381
                                                                                 SKEWTSUBS.382
C  INITIALIZE LOOP, BOOLEAN INDICATOR                                            SKEWTSUBS.383
                                                                                 SKEWTSUBS.384
      DONE = .FALSE.                                                             SKEWTSUBS.385
                                                                                 SKEWTSUBS.386
C  CALCULATE THE WIND VECTOR MAGNITUDE IN KNOTS                                  SKEWTSUBS.387
                                                                                 SKEWTSUBS.388
      IF ((U .EQ. 0) .AND. (V .EQ. 0)) THEN                                      SKEWTSUBS.389
        WINDVCT = 1.0                                                            SKEWTSUBS.390
      ELSE                                                                       SKEWTSUBS.391
        WINDVCT = SQRT(U**2 + V**2) * 1.94                                       SKEWTSUBS.392
      END IF                                                                     SKEWTSUBS.393
                                                                                 SKEWTSUBS.394
C  SAVE INCOMING USER COORDINATES AND CHANGE BACK TO NORMALIZED COORDINA         SKEWTSUBS.395
C  DOCUMENTATION FOR SET AND GETSET CAN BE FOUND IN NCAR GRAPHICS USERS          SKEWTSUBS.396
C  GUIDE VERSION 2.00 ON PAGES 49 (GETSET) AND 53 (SET).                         SKEWTSUBS.397
                                                                                 SKEWTSUBS.398
      CALL GETSET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)                 SKEWTSUBS.399
      CALL SET    (FLSV,FRSV,FBSV,FTSV, 0.0, 1.0, 0.0, 1.0, 1)                   SKEWTSUBS.400
                                                                                 SKEWTSUBS.401
C  DETERMINE WHERE THE BASE OF THE BARB IS IN THE NORMALIZED COORDINATES         SKEWTSUBS.402
                                                                                 SKEWTSUBS.403
      NEWXBASE = (XBASE - ULSV)/(URSV - ULSV)                                    SKEWTSUBS.404
      NEWYBASE = (YBASE - UBSV)/(UTSV - UBSV)                                    SKEWTSUBS.405
                                                                                 SKEWTSUBS.406
C  CALCULATE THE X DISTANCE AND Y DISTANCE FROM THE BASE OF THE BARB THA         SKEWTSUBS.407
C  DEFINES THE BARBS TIP (NORMALIZED COORDINATES)                                SKEWTSUBS.408
                                                                                 SKEWTSUBS.409
      XCOMP = -SC * U * 1.94/WINDVCT                                             SKEWTSUBS.410
      YCOMP = -SC * V * 1.94/WINDVCT                                             SKEWTSUBS.411
                                                                                 SKEWTSUBS.412
C  DETERMINE THE ACTUAL LOCATION IN NORMALIZED COORDINATES                       SKEWTSUBS.413
                                                                                 SKEWTSUBS.414
      POINTX(1) = NEWXBASE + XCOMP                                               SKEWTSUBS.415
      POINTY(1) = NEWYBASE + YCOMP                                               SKEWTSUBS.416
                                                                                 SKEWTSUBS.417
C  DRAW THE BARB SHAFT, DOCUMENTATION FOR THE LINE SUBROUTINE CAN BE FOU         SKEWTSUBS.418
C  IN NCAR GRAPHICS USERS GUIDE VERSION 2.00 ON PAGE 50                          SKEWTSUBS.419
                                                                                 SKEWTSUBS.420
      CALL LINE (NEWXBASE,NEWYBASE,POINTX(1),POINTY(1))                          SKEWTSUBS.421
                                                                                 SKEWTSUBS.422
C  DETERMINE THE FEATHER LENGTH                                                  SKEWTSUBS.423
                                                                                 SKEWTSUBS.424
      FETHLENX = 0.3 * YCOMP                                                     SKEWTSUBS.425
      FETHLENY = -0.3 * XCOMP                                                    SKEWTSUBS.426
                                                                                 SKEWTSUBS.427
C  SET THE PLACE KEEPER AND BOOST THE WIND MAGNITUDE                             SKEWTSUBS.428
                                                                                 SKEWTSUBS.429
      PK = 0.9                                                                   SKEWTSUBS.430
      WINDVCT = WINDVCT + 2.5                                                    SKEWTSUBS.431
                                                                                 SKEWTSUBS.432
C  BEGIN MAKING FEATHERS                                                         SKEWTSUBS.433
                                                                                 SKEWTSUBS.434
10    CONTINUE                                                                   SKEWTSUBS.435
                                                                                 SKEWTSUBS.436
C    DRAW A FLAG FOR EVERY 50 KNOTS WIND MAGNITUDE                               SKEWTSUBS.437
                                                                                 SKEWTSUBS.438
      IF (WINDVCT .GE. 50.0) THEN                                                SKEWTSUBS.439
                                                                                 SKEWTSUBS.440
C      DETERMINE THE POSITION OF THE FLAG TIP, POINT_(2)                         SKEWTSUBS.441
C      AND DETERMINE POSITION WHERE FLAG BOTTOM MEETS THE SHAFT, POINT_(         SKEWTSUBS.442
                                                                                 SKEWTSUBS.443
        POINTX(2) = POINTX(1) + FETHLENX + 0.0005                                SKEWTSUBS.444
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005                                SKEWTSUBS.445
        POINTX(3) = PK * XCOMP + NEWXBASE                                        SKEWTSUBS.446
        POINTY(3) = PK * YCOMP + NEWYBASE                                        SKEWTSUBS.447
                                                                                 SKEWTSUBS.448
C      DRAW FLAG                                                                 SKEWTSUBS.449
                                                                                 SKEWTSUBS.450
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      SKEWTSUBS.451
        CALL LINE (POINTX(3),POINTY(3),POINTX(2),POINTY(2))                      SKEWTSUBS.452
                                                                                 SKEWTSUBS.453
C      FILL IN FLAG, DOCUMENTATION FOR SFSGFA CAN BE FOUND IN NCAR               SKEWTSUBS.454
C      GRAPHICS GUIDE TO NEW UTILITIES VERSION 3.00 ON PAGE 4-8                  SKEWTSUBS.455
                                                                                 SKEWTSUBS.456
        CALL SFSETR ('SP',0.000001)                                              SKEWTSUBS.457
        CALL SFSGFA (POINTX,POINTY,3,JUNK,5,IJUNK,7,2)                           SKEWTSUBS.458
                                                                                 SKEWTSUBS.459
C      REMOVE 50 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)                    SKEWTSUBS.460
                                                                                 SKEWTSUBS.461
        WINDVCT = WINDVCT - 50.0                                                 SKEWTSUBS.462
                                                                                 SKEWTSUBS.463
C      DETERMINE NEW BEGIN POINT FOR NEXT FLAG OR FEATHER                        SKEWTSUBS.464
                                                                                 SKEWTSUBS.465
        PK = PK - 0.05                                                           SKEWTSUBS.466
        POINTX(1) = PK * XCOMP + NEWXBASE                                        SKEWTSUBS.467
        POINTY(1) = PK * YCOMP + NEWYBASE                                        SKEWTSUBS.468
        PK = PK - 0.1                                                            SKEWTSUBS.469
                                                                                 SKEWTSUBS.470
C    DRAW A FULL FEATHER FOR WIND MAGNITUDE OF EVERY 10 KNOTS                    SKEWTSUBS.471
                                                                                 SKEWTSUBS.472
      ELSE IF (WINDVCT .GE. 10.0) THEN                                           SKEWTSUBS.473
                                                                                 SKEWTSUBS.474
C      CALCULATE POSITION OF FEATHER END                                         SKEWTSUBS.475
                                                                                 SKEWTSUBS.476
        POINTX(2) = POINTX(1) + FETHLENX + 0.0005                                SKEWTSUBS.477
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005                                SKEWTSUBS.478
                                                                                 SKEWTSUBS.479
C      DRAW FEATHER                                                              SKEWTSUBS.480
                                                                                 SKEWTSUBS.481
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      SKEWTSUBS.482
                                                                                 SKEWTSUBS.483
C      REMOVE 10 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)                    SKEWTSUBS.484
                                                                                 SKEWTSUBS.485
        WINDVCT = WINDVCT - 10.0                                                 SKEWTSUBS.486
                                                                                 SKEWTSUBS.487
C      DETERMINE NEW START POINT FOR NEXT FEATHER OR FLAG                        SKEWTSUBS.488
                                                                                 SKEWTSUBS.489
        POINTX(1) = PK * XCOMP + NEWXBASE                                        SKEWTSUBS.490
        POINTY(1) = PK * YCOMP + NEWYBASE                                        SKEWTSUBS.491
        PK = PK - 0.1                                                            SKEWTSUBS.492
                                                                                 SKEWTSUBS.493
C    DRAW A HALF FEATHER FOR EVERY 5 KNOTS OF WIND MAGNITUDE                     SKEWTSUBS.494
                                                                                 SKEWTSUBS.495
      ELSE IF (WINDVCT .GE. 5.0) THEN                                            SKEWTSUBS.496
                                                                                 SKEWTSUBS.497
C      CALCULATE POSITION OF TIP OF HALF FEATHER                                 SKEWTSUBS.498
                                                                                 SKEWTSUBS.499
        POINTX(2) = POINTX(1) + 0.5 * FETHLENX + 0.0005                          SKEWTSUBS.500
        POINTY(2) = POINTY(1) + 0.5 * FETHLENY + 0.0005                          SKEWTSUBS.501
                                                                                 SKEWTSUBS.502
C      DRAW IN FEATHER                                                           SKEWTSUBS.503
                                                                                 SKEWTSUBS.504
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      SKEWTSUBS.505
                                                                                 SKEWTSUBS.506
C      TELL LOOP TO QUIT                                                         SKEWTSUBS.507
                                                                                 SKEWTSUBS.508
        DONE = .TRUE.                                                            SKEWTSUBS.509
      ELSE                                                                       SKEWTSUBS.510
        DONE = .TRUE.                                                            SKEWTSUBS.511
      END IF                                                                     SKEWTSUBS.512
                                                                                 SKEWTSUBS.513
C  IF THERE IS STILL MORE WIND MAGNITUDE (>= 5 KNOTS) LOOP AGAIN                 SKEWTSUBS.514
                                                                                 SKEWTSUBS.515
      IF (.NOT. DONE) GOTO 10                                                    SKEWTSUBS.516
                                                                                 SKEWTSUBS.517
C  RESET USER COORDINATES TO THE INCOMING VALUES                                 SKEWTSUBS.518
                                                                                 SKEWTSUBS.519
      CALL SET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)                    SKEWTSUBS.520
                                                                                 SKEWTSUBS.521
C****************************** SUBROUTINE END *************************         SKEWTSUBS.522
                                                                                 SKEWTSUBS.523
      RETURN                                                                     SKEWTSUBS.524
      END                                                                        SKEWTSUBS.525
C------------------------------------------------------                          SKEWTSUBS.526
      FUNCTION  TMR(W, P)                                                        SKEWTSUBS.527
C  TMR(KELVIN),W(GRAMS WATER VAPOR/KILOGRAM DRY AIR),P(MILLIBAR)                 SKEWTSUBS.528
      X =  ALOG10 (W * P / (622.+ W))                                            SKEWTSUBS.529
      TMR = 10.**(.0498646455*X+2.4082965)-7.07475+38.9114*                      SKEWTSUBS.530
     &                   ((10.**( .0915*X ) - 1.2035 )**2 )                      SKEWTSUBS.531
      RETURN                                                                     SKEWTSUBS.532
      END                                                                        SKEWTSUBS.533
C--------------------------------------------------------                        SKEWTSUBS.534
      FUNCTION  OS(T, P)                                                         SKEWTSUBS.535
C  OS AND T (KELVIN) , P (MILLIBARS )                                            SKEWTSUBS.536
      OS = T*((1000./P)**.286)/(EXP(-2.6518986*W(T,P)/T))                        SKEWTSUBS.537
      RETURN                                                                     SKEWTSUBS.538
      END                                                                        SKEWTSUBS.539
C------------------------------------------                                      SKEWTSUBS.540
      FUNCTION TSA(OS, P)                                                        SKEWTSUBS.541
C  TSA AND OS(KELVIN),P(MILLIBARS)                                               SKEWTSUBS.542
C  SIGN(A,B) REPLACES THE ALGEBRAIC SIGN OF A WITH THE SIGN OF B                 SKEWTSUBS.543
          A = OS                                                                 SKEWTSUBS.544
          TQ = 253.16                                                            SKEWTSUBS.545
          D = 120.                                                               SKEWTSUBS.546
          DO 1  I = 1,12                                                         SKEWTSUBS.547
             D = D/2.                                                            SKEWTSUBS.548
C  IF THE TEMPERATURE DIFFERENCE,X, IS SMALL,EXIT THIS LOOP                      SKEWTSUBS.549
             X=A*EXP(-2.6518986*W(TQ,P)/TQ)-TQ*((1000./P)**.286)                 SKEWTSUBS.550
             IF(ABS(X).LT.0.01)GO TO 2                                           SKEWTSUBS.551
             TQ = TQ + SIGN(D,X)                                                 SKEWTSUBS.552
  1       CONTINUE                                                               SKEWTSUBS.553
  2   TSA=TQ                                                                     SKEWTSUBS.554
      RETURN                                                                     SKEWTSUBS.555
      END                                                                        SKEWTSUBS.556
C--------------------------------------------                                    SKEWTSUBS.557
      FUNCTION W(T, P)                                                           SKEWTSUBS.558
C  W(GRAMS WATER VAPOR/KILOGRAM DRY AIR ), P(MILLIBAR )                          SKEWTSUBS.559
      IF (T .GE. 999.) GO TO 10                                                  SKEWTSUBS.560
         X =  ESAT(T)                                                            SKEWTSUBS.561
         W = 621.97 * X / (P - X)                                                SKEWTSUBS.562
      RETURN                                                                     SKEWTSUBS.563
   10 W = 0.0                                                                    SKEWTSUBS.564
      RETURN                                                                     SKEWTSUBS.565
      END                                                                        SKEWTSUBS.566
C------------------------------------------------                                SKEWTSUBS.567
      FUNCTION ESAT(T)                                                           SKEWTSUBS.568
C  ESAT(MILLIBARS),T(KELVIN)                                                     SKEWTSUBS.569
      PARAMETER (ABZ=273.16)                                                     SKEWTSUBS.570
      TC=T-ABZ                                                                   SKEWTSUBS.571
      ESAT=6.1078*EXP((17.2693882*TC)/(TC+237.3))                                SKEWTSUBS.572
#endif                                                                           SKEWTSUBS.573
      RETURN                                                                     SKEWTSUBS.574
      END                                                                        SKEWTSUBS.575
                                                                                 SKEWTSUBS.576
