      SUBROUTINE SMTHER(SLAB,IS1,IS2)                                            SMTHER.1
C                                                                                SMTHER.2
C        PURPOSE:  SPATIALLY SMOOTH DATA IN SLAB TO DAMPEN SHORT                 SMTHER.3
C                  WAVELENGTH COMPONENTS.                                        SMTHER.4
C                                                                                SMTHER.5
      DIMENSION SLAB(IS1,IS2)                                                    SMTHER.6
      IE = IS1 - 1                                                               SMTHER.7
      JE = IS2 - 1                                                               SMTHER.8
      IND = 1                                                                    SMTHER.9
      XNU1 = 0.50                                                                SMTHER.10
      XNU2 = -0.52                                                               SMTHER.11
      XNU = XNU1                                                                 SMTHER.12
  10  CONTINUE                                                                   SMTHER.13
C        FIRST, SMOOTH IN THE IS1 DIRECTION                                      SMTHER.14
      DO 1 I = 2,IE                                                              SMTHER.15
      ASV = SLAB(I,1)                                                            SMTHER.16
      DO 1 J = 2,JE                                                              SMTHER.17
      APLUS = SLAB(I,J+1)                                                        SMTHER.18
      CELL = SLAB(I,J)                                                           SMTHER.19
      SLAB(I,J) = SLAB(I,J) + XNU*((ASV + APLUS)/2.0 - SLAB(I,J))                SMTHER.20
      ASV = CELL                                                                 SMTHER.21
   1  CONTINUE                                                                   SMTHER.22
C        NOW, SMOOTH IN THE IS2 DIRECTION                                        SMTHER.23
      DO 2 J = 2,JE                                                              SMTHER.24
      ASV = SLAB(1,J)                                                            SMTHER.25
      DO 2 I = 2,IE                                                              SMTHER.26
      APLUS = SLAB(I+1,J)                                                        SMTHER.27
      CELL = SLAB(I,J)                                                           SMTHER.28
      SLAB(I,J) = SLAB(I,J) + XNU*((ASV + APLUS)/2.0 - SLAB(I,J))                SMTHER.29
      ASV = CELL                                                                 SMTHER.30
   2  CONTINUE                                                                   SMTHER.31
      IF(IND .NE. 1) GO TO 20                                                    SMTHER.32
      IND = 0                                                                    SMTHER.33
      XNU = XNU2                                                                 SMTHER.34
      GO TO 10                                                                   SMTHER.35
  20  RETURN                                                                     SMTHER.36
      END                                                                        SMTHER.37
