      SUBROUTINE VAPRES(T,E,DEDT)                                                VAPRES.1
C                                                                                VAPRES.2
C --- WATER VAPOR PRESSURE  E  AND ITS DERIVATIVE  (DE/DT)T/E  AS FUNCTI         VAPRES.3
C --- EW CONTAINS VAPOR PRESSURE OVER WATER FROM -50C TO +50C                    VAPRES.4
C --- EI CONTAINS VAPOR PRESSURE OVER ICE FROM -100C TO 0C                       VAPRES.5
C --- PRESSURE VALUES ARE TAKEN FROM SMITHSONIAN TABLES                          VAPRES.6
C                                                                                VAPRES.7
      REAL EW(101),EI(101),EE(151),ET(151)                                       VAPRES.8
      DATA EI/                                                                   VAPRES.9
     11.403E-5,1.719E-5,2.101E-5,2.561E-5,3.117E-5,3.784E-5,4.584E-5,            VAPRES.10
     25.542E-5,6.685E-5,8.049E-5,9.672E-5,11.60E-5,13.88E-5,16.58E-5,            VAPRES.11
     319.77E-5,23.53E-5,27.96E-5,33.16E-5,39.25E-5,46.38E-5,54.72E-5,            VAPRES.12
     464.44E-5,75.77E-5,88.94E-5,1.042E-3,1.220E-3,1.425E-3,1.662E-3,            VAPRES.13
     51.936E-3,2.252E-3,2.615E-3,3.032E-3,3.511E-3,4.060E-3,4.688E-3,            VAPRES.14
     65.406E-3,6.225E-3,7.159E-3,8.223E-3,9.432E-3,10.80E-3,12.36E-3,            VAPRES.15
     714.13E-3,16.12E-3,18.38E-3,20.92E-3,23.80E-3,27.03E-3,30.67E-3,            VAPRES.16
     834.76E-3,39.35E-3,44.49E-3,50.26E-3,56.71E-3,63.93E-3,71.98E-3,            VAPRES.17
     9.08097,.09098,0.1021,0.1145,0.1283,0.1436,0.1606,0.1794,0.2002,            VAPRES.18
     10.2233,0.2488,0.2769,0.3079,0.3421,0.3798,0.4213,0.4669,0.5170,            VAPRES.19
     20.5720,0.6323,0.6985,0.7709,0.8502,0.9370, 1.032, 1.135, 1.248,            VAPRES.20
     3 1.371, 1.506, 1.652, 1.811, 1.984, 2.172, 2.376, 2.597, 2.837,            VAPRES.21
     4 3.097, 3.379, 3.685, 4.015, 4.372, 4.757, 5.173, 5.623, 6.107/            VAPRES.22
      DATA EW/                                                                   VAPRES.23
     1.06356,.07124,.07975,.08918,.09961,0.1111,0.1239,0.1379,0.1534,            VAPRES.24
     20.1704,0.1891,0.2097,0.2323,0.2571,0.2842,0.3139,0.3463,0.3818,            VAPRES.25
     30.4205,0.4628,0.5088,0.5589,0.6134,0.6727,0.7371,0.8070,0.8827,            VAPRES.26
     40.9649,1.0538,1.1500,1.2540,1.3664,1.4877,1.6186,1.7597,1.9118,            VAPRES.27
     52.0755,2.2515,2.4409,2.6443,2.8627,3.0971,3.3484,3.6177,3.9061,            VAPRES.28
     64.2148,4.5451,4.8981,5.2753,5.6780,6.1078,6.5662,7.0547,7.5753,            VAPRES.29
     78.1294,8.7192,9.3465,10.013,10.722,11.474,12.272,13.119,14.017,            VAPRES.30
     814.969,15.977,17.044,18.173,19.367,20.630,21.964,23.373,24.861,            VAPRES.31
     926.430,28.086,29.831,31.671,33.608,35.649,37.796,40.055,42.430,            VAPRES.32
     144.927,47.551,50.307,53.200,56.236,59.422,62.762,66.264,69.934,            VAPRES.33
     273.777,77.802,82.015,86.423,91.034,95.855,100.89,106.16,111.66,            VAPRES.34
     3117.40,123.40/                                                             VAPRES.35
      DATA INDEX/1/                                                              VAPRES.36
      IF (INDEX.EQ.0) GO TO 5                                                    VAPRES.37
C --- SATURATION OVER ICE BELOW -35 DEG C                                        VAPRES.38
      DO 2 I=1,65                                                                VAPRES.39
2     EE(I)=EI(I)*1.E-3                                                          VAPRES.40
C --- WEIGHTED AVERAGE BETWEEN ICE AND WATER SATURATION IN THE RANGE -35         VAPRES.41
      DO 3 I=1,21                                                                VAPRES.42
      W=FLOAT(I)/22.                                                             VAPRES.43
3     EE(I+65)=(EI(I+65)*(1.-W)+EW(I+15)*W)*1.E-3                                VAPRES.44
C --- SATURATION OVER WATER ABOVE -15 DEG C                                      VAPRES.45
      DO 4 I=22,86                                                               VAPRES.46
4     EE(I+65)=EW(I+15)*1.E-3                                                    VAPRES.47
      DO 1 I=1,151                                                               VAPRES.48
      IP1=MIN0(I+1,151)                                                          VAPRES.49
       IM1=MAX0(1,I-1)                                                           VAPRES.50
1     ET(I)=LOG(EE(IP1)/EE(IM1))/LOG((172.16+IP1)/(172.16+IM1))                  VAPRES.51
      INDEX=0                                                                    VAPRES.52
    5 E=0.                                                                       VAPRES.53
      DEDT=0.                                                                    VAPRES.54
      T1=T-172.16                                                                VAPRES.55
      N=T1                                                                       VAPRES.56
      IF(N.LE.0) RETURN                                                          VAPRES.57
      IF(N.GT.150) GO TO 13                                                      VAPRES.58
      TT=T1-FLOAT(N)                                                             VAPRES.59
      E=EE(N)*(1.-TT)+EE(N+1)*TT                                                 VAPRES.60
      DEDT=ET(N)*(1.-TT)+ET(N+1)*TT                                              VAPRES.61
      RETURN                                                                     VAPRES.62
   13 CONTINUE                                                                   VAPRES.63
      RETURN                                                                     VAPRES.64
      END                                                                        VAPRES.65
