C                                                                                WNDBARB.1
C     *************************************************************              WNDBARB.2
C                                                                                WNDBARB.3
      SUBROUTINE WNDBARB(X,Y,U,V)                                                WNDBARB.4
#ifdef NCARG                                                                     WNDBARB.5
C  X,Y - COORDINATES OF ORIGIN OF WINDBARBS                                      WNDBARB.6
C  U,V - WIND COMPONENTS                                                         WNDBARB.7
      PARAMETER (A1=18.,A2=10.,TILT=90.)                                         WNDBARB.8
C   A1:   THE LENGTH OF THE MAIN FLAG (IN SCREEN COORDINATE UNITS,               WNDBARB.9
C         USUALLY SOME THING LIKE 30~50 WOULD BE O.K.)                           WNDBARB.10
C   A2:   THE LENGTH OF BARBS (SAME KIND OF UNIT AS A1)                          WNDBARB.11
C   TILT: THE ANGLE BETWEEN THE FLAG AND THE BARBS (75 IS GOOD)                  WNDBARB.12
      IF((ABS(U).LE.1.E-3).AND.(ABS(V).LE.1.E-3))RETURN                          WNDBARB.13
      SPEED=SQRT(U*U+V*V)                                                        WNDBARB.14
      IF((ABS(U).LE.1.E-3).AND.(V.GT.0.)) THEN                                   WNDBARB.15
         THETA=90.                                                               WNDBARB.16
      ELSE IF((ABS(U).LE.1.E-3).AND.(V.LT.0.)) THEN                              WNDBARB.17
         THETA=270.                                                              WNDBARB.18
      ELSE IF(U.GT.0.) THEN                                                      WNDBARB.19
         THETA=ATAN(V/U)*57.2957795130823                                        WNDBARB.20
      ELSE IF(U.LT.0.) THEN                                                      WNDBARB.21
         THETA=ATAN(V/U)*57.2957795130823+180.                                   WNDBARB.22
      END IF                                                                     WNDBARB.23
      DIR=270.-THETA                                                             WNDBARB.24
      IF(DIR.LT.  0.) DIR=DIR+360.                                               WNDBARB.25
      IF(DIR.GT.360.) DIR=DIR-360.                                               WNDBARB.26
      CALL FLT2INT(X,Y,M,N)                                                      WNDBARB.27
      CALL BARB(SPEED,DIR,M,N,A1,A2,TILT)                                        WNDBARB.28
#endif                                                                           WNDBARB.29
      RETURN                                                                     WNDBARB.30
      END                                                                        WNDBARB.31
