      SUBROUTINE ANALMN(A1,A2,ASTA,XOBS,YOBS,IMAX,JMAX,NSTA,RIS,                 ANALMN.1
     1   IFAC,IVRBL,ER,IER,COR,NS,SUM,SUM2)                                      ANALMN.2
C                                                                                ANALMN.3
C        THIS SUBROUTINE USES THE DIFFERENCES BETWEEN THE STATION                ANALMN.4
C        OBSERVATIONS AND THE CURRENT GUESS FIELD, IN ARRAY ER, TO               ANALMN.5
C        DETERMINE A NEW DATA FIELD, A1.  THE TYPE OF WEIGHTING FUNCTION         ANALMN.6
C        IS DETERMINED AT EACH STATION BY MSCHEM(K)                              ANALMN.7
C-----------------------------------------------------------------------         ANALMN.8
#include <paramirb.incl>                                                         ANALMN.9
#include <paramdim.incl>                                                         ANALMN.10
#include <paramirs.incl>                                                         ANALMN.11
#include <comd.incl>                                                             ANALMN.12
#include <comwt.incl>                                                            ANALMN.13
C-----------------------------------------------------------------------         ANALMN.14
      DIMENSION A2(IMAX,JMAX),XOBS(IRS),YOBS(IRS),ASTA(IRS),                     ANALMN.15
     1A1(IMAX,JMAX),COR(IMAX,JMAX),NS(IMAX,JMAX),SUM(IMAX,JMAX),                 ANALMN.16
     2 SUM2(IMAX,JMAX),ER(IRS,2)                                                 ANALMN.17
      DATA ICNT /0/                                                              ANALMN.18
      IF(IVRBL.EQ.IUVEL)ICNT=ICNT+1                                              ANALMN.19
      PI = 3.141593                                                              ANALMN.20
      RADINF=SQRT(RIS)                                                           ANALMN.21
      TWOPI = 6.283185                                                           ANALMN.22
      THRPI = 9.424778                                                           ANALMN.23
      DO 5 I = 1,IMAX                                                            ANALMN.24
      DO 5 J = 1,JMAX                                                            ANALMN.25
      COR(I,J)=0.                                                                ANALMN.26
      SUM(I,J)=0.                                                                ANALMN.27
      NS(I,J)=0.                                                                 ANALMN.28
      SUM2(I,J)=0.                                                               ANALMN.29
    5 A2(I,J) = A1(I,J)                                                          ANALMN.30
C                                                                                ANALMN.31
C                                                                                ANALMN.32
C  NOW LOOP THRU ALL STATIONS                                                    ANALMN.33
C                                                                                ANALMN.34
C                                                                                ANALMN.35
      DO 22 K=1,NSTA                                                             ANALMN.36
      IF(XOBS(K).GT.FLOAT(JMAX-1).OR.YOBS(K).GT.FLOAT(IMAX-1))GO TO 22           ANALMN.37
      IF(ASTA(K).GT.1.0E6) GO TO 22                                              ANALMN.38
      IF(MSCHEM(K).NE.3) GO TO 17                                                ANALMN.39
      IF(ER(K,1).GT.1.0E6.OR.ER(K,2).GT.1.0E6) GO TO 22                          ANALMN.40
   17 CONTINUE                                                                   ANALMN.41
C                                                                                ANALMN.42
C  DEFINE MAX AND MIN I,J VALUES TO LIMIT THE NUMBER OF GRID POINTS              ANALMN.43
C  WHICH WILL BE CONSIDERED                                                      ANALMN.44
C                                                                                ANALMN.45
      YMAXI=YOBS(K)+RADINF*ELON2(K)                                              ANALMN.46
      MAXI=IFIX(YMAXI+0.99)                                                      ANALMN.47
      MAXI=MIN0(IMAX,MAXI)                                                       ANALMN.48
C                                                                                ANALMN.49
      YMINI=YOBS(K)-RADINF*ELON2(K)                                              ANALMN.50
      MINI=IFIX(YMINI)                                                           ANALMN.51
      MINI=MAX0(1,MINI)                                                          ANALMN.52
C                                                                                ANALMN.53
      XMAXJ=XOBS(K)+RADINF*ELON2(K)                                              ANALMN.54
      MAXJ=IFIX(XMAXJ+0.99)                                                      ANALMN.55
      MAXJ=MIN0(JMAX,MAXJ)                                                       ANALMN.56
C                                                                                ANALMN.57
      XMINJ=XOBS(K)-RADINF*ELON2(K)                                              ANALMN.58
      MINJ=IFIX(XMINJ)                                                           ANALMN.59
      MINJ=MAX0(1,MINJ)                                                          ANALMN.60
C                                                                                ANALMN.61
C   NOW LOOP THRU THE GRID POINTS SURROUNDING THE STATION AND COMPUTE            ANALMN.62
C   THE DISTANCE BETWEEN THE K-TH STATION AND THE I,J GRID POINT                 ANALMN.63
C                                                                                ANALMN.64
      DO 20 I=MINI,MAXI                                                          ANALMN.65
      DO 20 J=MINJ,MAXJ                                                          ANALMN.66
      RI=I                                                                       ANALMN.67
      RJ=J                                                                       ANALMN.68
            RX = RJ - XOBS(K)                                                    ANALMN.69
            RY = RI - YOBS(K)                                                    ANALMN.70
            RSQ = RX*RX + RY*RY                                                  ANALMN.71
      RSQE=RSQ/ELON2(K)                                                          ANALMN.72
      IF(RSQE.GE.RIS) GO TO 20                                                   ANALMN.73
C        POINT I,J IS WITHIN THE INFLUENCE RADIUS OF STATION K. PROCEED          ANALMN.74
C        TO CALCULATE A DISTANCE-WEIGHTED CORRECTION VALUES TO A2(I,J).          ANALMN.75
      IF(IVRBL.EQ.ITEMP.OR.IVRBL.EQ.IREFPC) GO TO 85                             ANALMN.76
      WT=1.0                                                                     ANALMN.77
      IF (RSQ .LT. 0.05) GO TO 90                                                ANALMN.78
      IF (MSCHEM(K).EQ.1) GO TO 85                                               ANALMN.79
      IF (MSCHEM(K).EQ.2) GO TO 80                                               ANALMN.80
C        CALCULATE WEIGHTING FACTOR FOR BANANA-SHAPED REGION OF INFLUENC         ANALMN.81
      RXDIF = RJ - RORIG(K,1)                                                    ANALMN.82
      RYDIF = RI - RORIG(K,2)                                                    ANALMN.83
      RADKS = RXDIF*RXDIF + RYDIF*RYDIF                                          ANALMN.84
      RADK = SQRT(RADKS)                                                         ANALMN.85
      RDIF = RADK - RAD(K)                                                       ANALMN.86
      RDIFS = RDIF*RDIF                                                          ANALMN.87
      IF(RIS.LT.RDIFS) GO TO 20                                                  ANALMN.88
      THETIJ=ATAN2(RYDIF,RXDIF)                                                  ANALMN.89
      THETDF=MOD(THETIJ-THETK(K)+THRPI,TWOPI)-PI                                 ANALMN.90
      ARC2=RAD(K)*RAD(K)*THETDF*THETDF                                           ANALMN.91
      D2=RDIFS+ARC2/ELON2(K)                                                     ANALMN.92
      WT=(RIS-D2)/(RIS+D2)                                                       ANALMN.93
      IF (IVRBL.NE.IUVEL.AND.IVRBL.NE.IVVEL) GO TO 90                            ANALMN.94
C        FOR WINDS IN BANANA-SHAPED REGION, THE ERROR IS ADJUSTED TO             ANALMN.95
C        TAKE THE CURVATURE OF THE STREAMLINE FLOW INTO ACCOUNT.                 ANALMN.96
      COSTH = COS(THETDF)                                                        ANALMN.97
      SINTH = SIN(THETDF)                                                        ANALMN.98
      ERR = ER(K,2)*COSTH - ER(K,1)*SINTH                                        ANALMN.99
      IF (IVRBL.EQ.IVVEL) ERR = ER(K,2)*SINTH + ER(K,1)*COSTH                    ANALMN.100
      GO TO 95                                                                   ANALMN.101
C        CALCULATE WEIGHTING FACTOR FOR ELLIPTICAL REGION OF INFLUENCE.          ANALMN.102
C                                                                                ANALMN.103
C  ROTATE RX AND RY ALONG WIND DIRECTION                                         ANALMN.104
   80 RXP=(RX*UCOMP(K)+RY*VCOMP(K))/VMAG(K)                                      ANALMN.105
      RYP=(RX*VCOMP(K)-RY*UCOMP(K))/VMAG(K)                                      ANALMN.106
      D2=RYP*RYP+RXP*RXP/ELON2(K)                                                ANALMN.107
      WT=(RIS-D2)/(RIS+D2)                                                       ANALMN.108
      GO TO 90                                                                   ANALMN.109
C        CALCULATE WEIGHTING FACTOR FOR TEMPERATURES, OR FOR ALL                 ANALMN.110
C        VARIABLES WHEN CIRCULAR CRESSMAN REGION OF INFLUENCE IS USED.           ANALMN.111
   85 IF(RSQ.GT.RIS) GO TO 20                                                    ANALMN.112
      WT = (RIS-RSQ)/(RIS+RSQ)                                                   ANALMN.113
  90  CONTINUE                                                                   ANALMN.114
      ERR = ER(K,IER)                                                            ANALMN.115
  95  CONTINUE                                                                   ANALMN.116
      IF(WT.LE.0.0.OR.ASTA(K).GT.1.0E6) GO TO 20                                 ANALMN.117
      IF(.NOT.IWT) COR(I,J)=COR(I,J)+WT*ERR                                      ANALMN.118
      IF(IWT) COR(I,J)=COR(I,J)+WT*WT*ERR                                        ANALMN.119
      SUM(I,J)=SUM(I,J)+WT                                                       ANALMN.120
      SUM2(I,J)=SUM2(I,J)+WT*WT                                                  ANALMN.121
      NS(I,J)=NS(I,J)+1                                                          ANALMN.122
   20 CONTINUE                                                                   ANALMN.123
   22 CONTINUE                                                                   ANALMN.124
      DO 100 I=1,IMAX                                                            ANALMN.125
      DO 100 J=1,JMAX                                                            ANALMN.126
      IF(NS(I,J).EQ.0) GO TO 25                                                  ANALMN.127
      IF(IFAC .EQ. 2) GO TO 23                                                   ANALMN.128
      IF(.NOT.IWT) COR(I,J)=COR(I,J)/FLOAT(NS(I,J))                              ANALMN.129
      IF(IWT) COR(I,J)=COR(I,J)/SUM(I,J)                                         ANALMN.130
      A1(I,J)=A2(I,J)+COR(I,J)                                                   ANALMN.131
      GO TO 100                                                                  ANALMN.132
   23 CONTINUE                                                                   ANALMN.133
      IF(.NOT.IWT) COR(I,J)=COR(I,J)/SUM(I,J)                                    ANALMN.134
      IF(IWT) COR(I,J)=COR(I,J)/SUM2(I,J)                                        ANALMN.135
      A1(I,J)=COR(I,J)                                                           ANALMN.136
      GO TO 100                                                                  ANALMN.137
 25   IF(IFAC.NE.2) GO TO 100                                                    ANALMN.138
      PRINT 26,I,J                                                               ANALMN.139
  26  FORMAT(5X,'IFAC=ANALYS, BUT THERE ARE NO OBSERVATIONS WITHIN RIN',         ANALMN.140
     1 ' OF I=',I2,' J=',I2)                                                     ANALMN.141
  100 CONTINUE                                                                   ANALMN.142
      RETURN                                                                     ANALMN.143
      END                                                                        ANALMN.144
