      SUBROUTINE BARB(WSD,WDR,IJX,IJY,A1,A2,TILT)                                BARB.1
C                                                                                BARB.2
C   A PROGRAM TO DRAW WIND BARBS                                                 BARB.3
C                                                                                BARB.4
C   WSPD: WIND SPEED IN METER/SECOND                                             BARB.5
C   WDIR: WIND DIRECTION                                                         BARB.6
C   IJX:  SCREEN COORDINATE IN X DIRECTION (SCREEN IS 1024 X 1024)               BARB.7
C   IJY:  SCREEN COORDINATE IN Y DIRECTION                                       BARB.8
C   A1:   THE LENGTH OF THE MAIN FLAG (IN SCREEN COORDINATE UNITS, USUAL         BARB.9
C         SOME THING LIKE 30~50 WOULD BE O.K.)                                   BARB.10
C   A2:   THE LENGTH OF BARBS (SAME KIND OF UNIT AS A1)                          BARB.11
C   TILT: THE ANGLE BETWEEN THE FLAG AND THE BARBS (75 IS GOOD)                  BARB.12
C                                                                                BARB.13
C                                                                                BARB.14
      DIMENSION IX(22),IY(22)                                                    BARB.15
#include <compts.incl>                                                           BARB.16
      CONV=57.29578                                                              BARB.17
C                                                                                BARB.18
C FIND POSITION OF FLAG                                                          BARB.19
      K1=WDR/90.+1.                                                              BARB.20
      GO TO (1,2,3,4),K1                                                         BARB.21
C        WIND DIRECTION NORTH TO EAST                                            BARB.22
1     AN=WDR/CONV                                                                BARB.23
      COEX=SIN(AN)                                                               BARB.24
      COEY=COS(AN)                                                               BARB.25
      GO TO 50                                                                   BARB.26
C        WIND DIRECTION EAST TO SOUTH                                            BARB.27
2     AN=(WDR-90.)/CONV                                                          BARB.28
      COEX=COS(AN)                                                               BARB.29
      COEY=-SIN(AN)                                                              BARB.30
      GO TO 50                                                                   BARB.31
C        WIND DIRECTION SOUTH TO WEST                                            BARB.32
3     AN=(WDR-180.)/CONV                                                         BARB.33
      COEX=-SIN(AN)                                                              BARB.34
      COEY=-COS(AN)                                                              BARB.35
      GO TO 50                                                                   BARB.36
C        WIND DIRECTION WEST TO NORTH                                            BARB.37
4     AN=(WDR-270.)/CONV                                                         BARB.38
      COEX=-COS(AN)                                                              BARB.39
      COEY=SIN(AN)                                                               BARB.40
50    CONTINUE                                                                   BARB.41
      DO 10 I=1,7                                                                BARB.42
      IX(I)=0.1*A1*COEX*(11-I)+IJX                                               BARB.43
      IY(I)=0.1*A1*COEY*(11-I)+IJY                                               BARB.44
10    CONTINUE                                                                   BARB.45
C                                                                                BARB.46
C  FIND POSITION OF BARBS                                                        BARB.47
      TAG=WDR+TILT                                                               BARB.48
      IF(TAG.GT.360.) TAG=TAG-360.                                               BARB.49
      K2=TAG/90.+1.                                                              BARB.50
      GO TO (5,6,7,8),K2                                                         BARB.51
5     AN2=TAG/CONV                                                               BARB.52
      COEX=SIN(AN2)                                                              BARB.53
      COEY=COS(AN2)                                                              BARB.54
      GO TO 100                                                                  BARB.55
6     AN2=(TAG-90.)/CONV                                                         BARB.56
      COEX=COS(AN2)                                                              BARB.57
      COEY=-SIN(AN2)                                                             BARB.58
      GO TO 100                                                                  BARB.59
7     AN2=(TAG-180.)/CONV                                                        BARB.60
      COEX=-SIN(AN2)                                                             BARB.61
      COEY=-COS(AN2)                                                             BARB.62
      GO TO 100                                                                  BARB.63
8     AN2=(TAG-270.)/CONV                                                        BARB.64
      COEX=-COS(AN2)                                                             BARB.65
      COEY=SIN(AN2)                                                              BARB.66
100   CONTINUE                                                                   BARB.67
      DO 20 I=1,7                                                                BARB.68
      IX(7+I)=A2*0.5*COEX+IX(I)                                                  BARB.69
      IY(7+I)=A2*0.5*COEY+IY(I)                                                  BARB.70
      IX(14+I)=A2*COEX+IX(I)                                                     BARB.71
      IY(14+I)=A2*COEY+IY(I)                                                     BARB.72
20    CONTINUE                                                                   BARB.73
C                                                                                BARB.74
C  PLOT POINT AND DRAW MAIN FLAG                                                 BARB.75
      CALL IPINT(IJX,IJY)                                                        BARB.76
      CALL IDRAW(IX(1),IY(1))                                                    BARB.77
C                                                                                BARB.78
C  DRAW WIND BARBS                                                               BARB.79
      IK=(WSD+2.5)/5.                                                            BARB.80
      IF(IK.GT.38) GO TO 480                                                     BARB.81
      IF(IK.GE.30.AND.IK.LE.38) GO TO 400                                        BARB.82
      IF(IK.GE.20.AND.IK.LT.30) GO TO 300                                        BARB.83
      IF(IK.GE.10.AND.IK.LT.20) GO TO 200                                        BARB.84
      IF(IK.EQ.0) GO TO 500                                                      BARB.85
      DO 110 I=1,5                                                               BARB.86
        IX1=IX(I)                                                                BARB.87
        IY1=IY(I)                                                                BARB.88
      CALL IDRAW(IX(7+I),IY(7+I))                                                BARB.89
      IK=IK-1                                                                    BARB.90
      IF(IK.EQ.0) GO TO 500                                                      BARB.91
      CALL IDRAW(IX(14+I),IY(14+I))                                              BARB.92
      IK=IK-1                                                                    BARB.93
      IF(IK.EQ.0) GO TO 500                                                      BARB.94
110   CONTINUE                                                                   BARB.95
200   CALL IDRAW(IX(15),IY(15))                                                  BARB.96
      CALL IDRAW(IX(2),IY(2))                                                    BARB.97
      IK=IK-10                                                                   BARB.98
      IF(IK.EQ.0) GO TO 500                                                      BARB.99
      DO 210 I=1,5                                                               BARB.100
        IX1=IX(2+I)                                                              BARB.101
        IY1=IY(2+I)                                                              BARB.102
        CALL IDRAW(IX(9+I),IY(9+I))                                              BARB.103
        IK=IK-1                                                                  BARB.104
        IF(IK.EQ.0) GO TO 500                                                    BARB.105
        CALL IDRAW(IX(16+I),IY(16+I))                                            BARB.106
        IK=IK-1                                                                  BARB.107
        IF(IK.EQ.0) GO TO 500                                                    BARB.108
210   CONTINUE                                                                   BARB.109
300   CALL IDRAW(IX(15),IY(15))                                                  BARB.110
      CALL IDRAW(IX(2),IY(2))                                                    BARB.111
      CALL IDRAW(IX(16),IY(16))                                                  BARB.112
      CALL IDRAW(IX(3),IY(3))                                                    BARB.113
      IK=IK-20                                                                   BARB.114
      IF(IK.EQ.0) GO TO 500                                                      BARB.115
      DO 310 I=1,5                                                               BARB.116
        IX1=IX(2+I)                                                              BARB.117
        IY1=IY(2+I)                                                              BARB.118
        CALL IDRAW(IX(9+I),IY(9+I))                                              BARB.119
        IK=IK-1                                                                  BARB.120
        IF(IK.EQ.0) GO TO 500                                                    BARB.121
        CALL IDRAW(IX(16+I),IY(16+I))                                            BARB.122
        IK=IK-1                                                                  BARB.123
        IF(IK.EQ.0) GO TO 500                                                    BARB.124
310   CONTINUE                                                                   BARB.125
400   CALL IDRAW(IX(15),IY(15))                                                  BARB.126
      CALL IDRAW(IX(2),IY(2))                                                    BARB.127
      CALL IDRAW(IX(16),IY(16))                                                  BARB.128
      CALL IDRAW(IX(3),IY(3))                                                    BARB.129
      CALL IDRAW(IX(17),IY(17))                                                  BARB.130
      CALL IDRAW(IX(4),IY(4))                                                    BARB.131
      IK=IK-30                                                                   BARB.132
      IF(IK.EQ.0) GO TO 500                                                      BARB.133
      DO 410 I=1,5                                                               BARB.134
      IX1=IX(3+I)                                                                BARB.135
      IY1=IY(3+I)                                                                BARB.136
      CALL IDRAW(IX(10+I),IY(10+I))                                              BARB.137
      IK=IK-1                                                                    BARB.138
      IF(IK.EQ.0) GO TO 500                                                      BARB.139
      CALL IDRAW(IX(17+I),IY(17+I))                                              BARB.140
      IK=IK-1                                                                    BARB.141
      IF(IK.EQ.0) GO TO 500                                                      BARB.142
410   CONTINUE                                                                   BARB.143
480   CALL IDRAW(IX(15),IY(15))                                                  BARB.144
      CALL IDRAW(IX(2),IY(2))                                                    BARB.145
      CALL IDRAW(IX(16),IY(16))                                                  BARB.146
      CALL IDRAW(IX(3),IY(3))                                                    BARB.147
      CALL IDRAW(IX(17),IY(17))                                                  BARB.148
      CALL IDRAW(IX(4),IY(4))                                                    BARB.149
      CALL IDRAW(IX(18),IY(18))                                                  BARB.150
      CALL IDRAW(IX(5),IY(5))                                                    BARB.151
500   CONTINUE                                                                   BARB.152
      RETURN                                                                     BARB.153
      END                                                                        BARB.154
