C                                                                                BARNES.1
C     *************************************************************              BARNES.2
C                                                                                BARNES.3
      SUBROUTINE BARNES(NODATA,DAT,XP,YP,NMAX,SUMTHR,NX,NY,                      BARNES.4
     1  K,LAMBDA,SUMONE,SUMTWO,NOS,GRDATA,DX,IGRID,FLAG)                         BARNES.5
C                                                                                BARNES.6
C                                                                                BARNES.7
C            BARNES.FOR                                                          BARNES.8
C                                                                                BARNES.9
C                                                                                BARNES.10
C      THIS TECHNIQUE USES AN EXPONENTIAL WGT FUNCTION                           BARNES.11
C      AND REQUIRES ONLY ONE ITERATION.                                          BARNES.12
C                                                                                BARNES.13
C      DEVELOPMENT OF THIS SCHEME CAN FOUND IN THE FOLLOWING:                    BARNES.14
C            BARNES(64),MON.WEA.REV                                              BARNES.15
C            BARNES(73),NOAA/ERL TECH MEMO                                       BARNES.16
C                                                                                BARNES.17
C       VARIABLES DEFINED                                                        BARNES.18
C      DAT    IN PASS ONE THE STATION DATA--- IN PASS TWO THE                    BARNES.19
C              DIFFERENCE BETWEEN THE ACTUAL AND THE FIRST GUESS.                BARNES.20
C      GRDATA  A 2-D  OUTPUT FILE WITH GRIDDED DATA                              BARNES.21
C      K      A COEFFICIENT IN THE WGHT EQUATION                                 BARNES.22
C      LAMBDA  A CONVERGENCE COEFFICIENT IN EQUATIONS                            BARNES.23
C      NMAX      THE TOTAL OF POSSIBLE STATIONS                                  BARNES.24
C      NODATA  THE TOTAL NUMBER OF STATIONS REPORTING                            BARNES.25
C      RMAX       A MAXIMUM RADIUS OF INFLUENCE                                  BARNES.26
C      WGT      WGT OF A STATION IN A GRID COMPUTATION                           BARNES.27
C        SUMONE  AN ITERMEDIATE SUM OF WGTED DATA                                BARNES.28
C      SUMTWO       SIMILAR TO SUMONE                                            BARNES.29
C      IMAX/JMAX      THE MAX.GRID DIMENSIONS                                    BARNES.30
C      XP      A 1-D ARRAY OF GRID POSITIONS                                     BARNES.31
C      YP      A 1-D ARRAY OF GRID POSITIONS                                     BARNES.32
C      IGRID   1 FOR CROSS POINTS, 0 FOR DOT POINTS                              BARNES.33
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         BARNES.34
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         BARNES.35
C                                                                                BARNES.36
C      VERSION 1.0       RAY MENARD                  WINTER 1987                 BARNES.37
C      VERSION 2.0      PAUL HIRSHCBERG AND JIM DOYLE      SPRING 1987           BARNES.38
C      VERSION 3.0      JIM DOYLE                  SUMMER 1987                   BARNES.39
C      VERSION 4.0      DAVE STAUFFER                                            BARNES.40
C                       INSERTION INTO RAWINS     WINTER 1988                    BARNES.41
C                   (DOT/CROSS POINT CAPABILITY, FLAGGING BAD DATA, ETC.         BARNES.42
C                                                                                BARNES.43
C          NOTE:  BARNES CREATES A GRIDDED FIELD (X,Y) WHICH MUST BE             BARNES.44
C                 SHIFTED TO (Y,X) FOR RAWINS. DX MUST BE IN KM AND              BARNES.45
C                 AT GRID POINTS NOT AFFECTED BY ANY OBSERVATIONS. THE           BARNES.46
C                 SURROUNDING PASS ONE VALUES ARE TREATED AS OBSERVATION         BARNES.47
C                 FOR THE SECOND PASS.  THE NUMBER AND POSITION OF THESE         BARNES.48
C                 POINTS MAY BE PRINTED OUT.                                     BARNES.49
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         BARNES.50
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         BARNES.51
C                                                                                BARNES.52
C                                                                                BARNES.53
C DECLARE AND DIMENSION VARIABLES                                                BARNES.54
C                                                                                BARNES.55
      REAL XP(NMAX),YP(NMAX),GRDATA(NX,NY),K,PHI,KMAP,LAMBDA,                    BARNES.56
     1    DAT(NMAX),LAM(2)                                                       BARNES.57
      REAL SUMONE(NX,NY),SUMTWO(NX,NY),SUMTHR(NY,NX)                             BARNES.58
      LOGICAL QUAD,IPRNTB                                                        BARNES.59
      INTEGER IB(1000),JB(1000),NOS(NX,NY)                                       BARNES.60
C                                                                                BARNES.61
C COMPUTE KMAP IN GRID SPACE                                                     BARNES.62
      DXKM=DX/1000.                                                              BARNES.63
      KMAP=K/(DXKM*DXKM)                                                         BARNES.64
C                                                                                BARNES.65
C SET CONSTANTS                                                                  BARNES.66
C                                                                                BARNES.67
      RSQMAX=16.*KMAP                                                            BARNES.68
      RMAX=SQRT(RSQMAX)                                                          BARNES.69
C UNDERFLOW CHECK:                                                               BARNES.70
C      TEST=4*KMAP*LAMBDA*65.                                                    BARNES.71
C      IF(RSQMAX .GT. TEST) RSQMAX=TEST                                          BARNES.72
      LAM(1)=1.0                                                                 BARNES.73
      LAM(2)=LAMBDA                                                              BARNES.74
      DO 10 IGR=1,NX                                                             BARNES.75
      DO 10 JGR=1,NY                                                             BARNES.76
      GRDATA(IGR,JGR)=0.0                                                        BARNES.77
      SUMTHR(JGR,IGR)=0.0                                                        BARNES.78
10    CONTINUE                                                                   BARNES.79
C                                                                                BARNES.80
C      BEGIN THE ITERATIONS.                                                     BARNES.81
            QUAD=.TRUE.                  ! DO BI-QUADRATIC INTERPOLATION         BARNES.82
            IPRNTB=.TRUE.                ! PRINT "BAD" GRID POINTS               BARNES.83
            RADINF=RMAX*DXKM                                                     BARNES.84
      PRINT 21,LAM(2),K,KMAP,DXKM,RADINF                                         BARNES.85
21    FORMAT(5X,'/CALL BARNES: LAM,K,KMAP,DXKM,RADINF ',F6.3,1X,F7.1,            BARNES.86
     11X,F5.1,1X,F6.1,1X,F6.1)                                                   BARNES.87
C                                                                                BARNES.88
      DO 20 IPASS=1,2                                                            BARNES.89
C                                                                                BARNES.90
C      DETERMINE THE PASS AND APPLY THE APPROPRIATE VARIABLES                    BARNES.91
C                                                                                BARNES.92
      IF (IPASS.EQ.1) GO TO 35                                                   BARNES.93
C                                                                                BARNES.94
          DO 30 IISTA=1,NODATA                                                   BARNES.95
      IF(DAT(IISTA).GE.FLAG) GO TO 30                                            BARNES.96
C                                                                                BARNES.97
C SUBROUTINE INTR CALCUALTES AN INTERPOLATED FIRST GUESS VALUE AT THE            BARNES.98
C STATION LOCATION FOR THE SECOND PASS                                           BARNES.99
C                                                                                BARNES.100
            CALL INTR(GRDATA,NX-IGRID,NY-IGRID,XP(IISTA),YP(IISTA),              BARNES.101
     1      TEMDAT,QUAD,NX,NY)                                                   BARNES.102
            DAT(IISTA)=DAT(IISTA)-TEMDAT                                         BARNES.103
30            CONTINUE                                                           BARNES.104
35            CONTINUE                                                           BARNES.105
C                                                                                BARNES.106
C BEGIN THE LOOP THROUGH THE GRID POINTS, THE WEIGHTING SCHEME                   BARNES.107
C VARIES DEPENDING ON WHETHER THIS IS THE INITIAL PASS-1 OR THE                  BARNES.108
C CORRECTION PASS-2.                                                             BARNES.109
C                                                                                BARNES.110
C      FLUSH ARRAYS                                                              BARNES.111
C                                                                                BARNES.112
      DO 40 IGR=1,NX                                                             BARNES.113
        DO 40 JGR=1,NY                                                           BARNES.114
      SUMONE(IGR,JGR)=0.0                                                        BARNES.115
      SUMTWO(IGR,JGR)=0.0                                                        BARNES.116
      NOS(IGR,JGR)=0                                                             BARNES.117
40      CONTINUE                                                                 BARNES.118
C                                                                                BARNES.119
      NOB=0                                                                      BARNES.120
      DO 50 ISTA=1,NODATA                                                        BARNES.121
      IF(DAT(ISTA).GE.FLAG) THEN                                                 BARNES.122
      NOB=NOB+1                                                                  BARNES.123
      GO TO 50                                                                   BARNES.124
      ENDIF                                                                      BARNES.125
C                                                                                BARNES.126
C      DEFINE MAX AND MIN VALUES TO LIMIT THE NUMBER OF GRID POINTS              BARNES.127
C      TO BE CONSIDERED                                                          BARNES.128
C                                                                                BARNES.129
      XMAXI=XP(ISTA)+RMAX                                                        BARNES.130
      MAXI=IFIX(XMAXI+0.99)                                                      BARNES.131
C      IF(MAXI.GT.NX) MAXI=NX                                                    BARNES.132
      MAXI=MIN0(MAXI,NX-IGRID)                                                   BARNES.133
C                                                                                BARNES.134
      XMINI=XP(ISTA)-RMAX                                                        BARNES.135
      MINI=IFIX(XMINI)                                                           BARNES.136
C      IF(MINI.LT.1) MINI=1                                                      BARNES.137
      MINI=MAX0(MINI,1)                                                          BARNES.138
C                                                                                BARNES.139
C                                                                                BARNES.140
      YMAXJ=YP(ISTA)+RMAX                                                        BARNES.141
      MAXJ=IFIX(YMAXJ+0.99)                                                      BARNES.142
C      IF(MAXJ.GT.NY) MAXJ=NY                                                    BARNES.143
      MAXJ=MIN0(MAXJ,NY-IGRID)                                                   BARNES.144
C                                                                                BARNES.145
      YMINJ=YP(ISTA)-RMAX                                                        BARNES.146
      MINJ=IFIX(YMINJ)                                                           BARNES.147
C      IF(MINJ.LT.1) MINJ=1                                                      BARNES.148
      MINJ=MAX0(MINJ,1)                                                          BARNES.149
C                                                                                BARNES.150
      DO 60 IGR=MINI,MAXI                                                        BARNES.151
      DO 60 JGR=MINJ,MAXJ                                                        BARNES.152
            RSQ=((XP(ISTA)-IGR)**2+(YP(ISTA)-JGR)**2)                            BARNES.153
            IF (RSQ .GT. RSQMAX) GO TO 60                                        BARNES.154
            NOS(IGR,JGR)=NOS(IGR,JGR)+1                                          BARNES.155
            WGT=EXP(-RSQ/(4.0*KMAP*LAM(IPASS)))                                  BARNES.156
            SUMTWO(IGR,JGR)= SUMTWO(IGR,JGR) + WGT                               BARNES.157
            SUMONE(IGR,JGR)= SUMONE(IGR,JGR)+WGT*DAT(ISTA)                       BARNES.158
60      CONTINUE                                                                 BARNES.159
50      CONTINUE                                                                 BARNES.160
C IF THE NUMBER OF STATIONS THAT INFLUENCE THE ANALYSIS EXCEEDS ZERO             BARNES.161
C THEN CONTINUE IF NOT THEN SET THE GRID POINT VALUE TO -999 TEMPORARILY         BARNES.162
C                                                                                BARNES.163
      KK=0                                                                       BARNES.164
      DO 70 IGR=1,NX-IGRID                                                       BARNES.165
      DO 70 JGR=1,NY-IGRID                                                       BARNES.166
      IF(NOS(IGR,JGR) .GT. 0) THEN                                               BARNES.167
            GRDATA(IGR,JGR)=SUMONE(IGR,JGR)/SUMTWO(IGR,JGR)                      BARNES.168
     1                  + GRDATA(IGR,JGR)                                        BARNES.169
      ELSE                                                                       BARNES.170
            IF(IPASS.NE.2) GOTO 65                                               BARNES.171
            KK=KK+1                                                              BARNES.172
C                   IF(KK .EQ. 260) THEN                                         BARNES.173
C                  WRITE(6,80)                                                   BARNES.174
C80                  FORMAT(/' POOR DATA RESOLUTION')                            BARNES.175
C                  STOP                                                          BARNES.176
C                 END IF                                                         BARNES.177
            GRDATA(IGR,JGR) = -999.                                              BARNES.178
            IF(KK.GT.1000) STOP1000                                              BARNES.179
            IB(KK)=IGR                                                           BARNES.180
            JB(KK)=JGR                                                           BARNES.181
65      CONTINUE                                                                 BARNES.182
      END IF                                                                     BARNES.183
70      CONTINUE                                                                 BARNES.184
        IF(IPASS.EQ.2) THEN                                                      BARNES.185
        PRINT 79,NOB,NODATA                                                      BARNES.186
79      FORMAT(5X,'NOT PROCESSING ',I4,' OBSERVATIONS FROM A TOTAL OF ',         BARNES.187
     1I4,' OBSERVATIONS IN BARNES')                                              BARNES.188
        PRINT 80,KK                                                              BARNES.189
   80 FORMAT(1H0,I14,' GRID POINTS NOT AFFECTED BY OBS IN BARNES #####',         BARNES.190
     1'###############')                                                         BARNES.191
        ENDIF                                                                    BARNES.192
20      CONTINUE                                                                 BARNES.193
C                                                                                BARNES.194
C TREAT THE GRID POINT VALUES AS DATA VALUES AND PERFORM A BARNES ANALYS         BARNES.195
C FILL IN THE GRID POINTS THAT WERE SET TO -999                                  BARNES.196
C                                                                                BARNES.197
      IF(KK .EQ. 0) GO TO 115                                                    BARNES.198
C DEFINE RSQM TO FILL IN "HOLES" LEFT BY PASS ONE                                BARNES.199
      RSQM=260.                                                                  BARNES.200
      RMAX=SQRT(RSQM)                                                            BARNES.201
      DO 100 II=1,KK                                                             BARNES.202
      IX=IB(II)                                                                  BARNES.203
      IY=JB(II)                                                                  BARNES.204
      SUM1=0.0                                                                   BARNES.205
      SUM2=0.0                                                                   BARNES.206
C                                                                                BARNES.207
C      DEFINE MAX AND MIN VALUES TO LIMIT THE NUMBER OF GRID POINTS              BARNES.208
C      TO BE CONSIDERED                                                          BARNES.209
C                                                                                BARNES.210
      XMAXI=IX+RMAX                                                              BARNES.211
      MAXI=IFIX(XMAXI+0.99)                                                      BARNES.212
C      IF(MAXI.GT.NX) MAXI=NX                                                    BARNES.213
      MAXI=MIN0(MAXI,NX-IGRID)                                                   BARNES.214
C                                                                                BARNES.215
      XMINI=IX-RMAX                                                              BARNES.216
      MINI=IFIX(XMINI)                                                           BARNES.217
C      IF(MINI.LT.1) MINI=1                                                      BARNES.218
      MINI=MAX0(MINI,1)                                                          BARNES.219
C                                                                                BARNES.220
      YMAXJ=IY+RMAX                                                              BARNES.221
      MAXJ=IFIX(YMAXJ+0.99)                                                      BARNES.222
C      IF(MAXJ.GT.NY) MAXJ=NY                                                    BARNES.223
      MAXJ=MIN0(MAXJ,NY-IGRID)                                                   BARNES.224
C                                                                                BARNES.225
      YMINJ=IY-RMAX                                                              BARNES.226
      MINJ=IFIX(YMINJ)                                                           BARNES.227
C      IF(MINJ.LT.1) MINJ=1                                                      BARNES.228
      MINJ=MAX0(MINJ,1)                                                          BARNES.229
C                                                                                BARNES.230
      DO 110 IGR=MINI,MAXI                                                       BARNES.231
      DO 110 JGR=MINJ,MAXJ                                                       BARNES.232
      IF(IGR .EQ. IX .AND. JGR .EQ. IY) GO TO 110                                BARNES.233
      IF(GRDATA(IGR,JGR) .EQ. -999.) GO TO 110                                   BARNES.234
      IDIST=IGR-IX                                                               BARNES.235
      JDIST=JGR-IY                                                               BARNES.236
      DIST=(IDIST**2)+(JDIST**2)                                                 BARNES.237
      IF(DIST .GT. RSQM) GO TO 110                                               BARNES.238
      WGT=EXP(-DIST/4.)                                                          BARNES.239
      SUM1=SUM1+WGT*GRDATA(IGR,JGR)                                              BARNES.240
      SUM2=SUM2+WGT                                                              BARNES.241
110      CONTINUE                                                                BARNES.242
      GRDATA(IX,IY)=SUM1/SUM2                                                    BARNES.243
100      CONTINUE                                                                BARNES.244
115   CONTINUE                                                                   BARNES.245
C CONVERT GRDATA(IX,IY) TO GRDATA(IY,IX)                                         BARNES.246
      DO 120 I=1,NX                                                              BARNES.247
      DO 120 J=1,NY                                                              BARNES.248
      SUMTHR(J,I)=GRDATA(I,J)                                                    BARNES.249
120   CONTINUE                                                                   BARNES.250
C                                                                                BARNES.251
      RETURN                                                                     BARNES.252
      END                                                                        BARNES.253
