      SUBROUTINE BOGPTS(DATAH,CORRH,ID1,ID2,ID3,DATAS,IDS1,IDS2,IDS3,            BOGPTS.1
     1                   IUORS,MDATE,KBOGR,AUTBR,NBRFIL,RSOND,BUFD,              BOGPTS.2
     2                   ISTNUM,RANG,IFOUND,BUFUPR)                              BOGPTS.3
C                                                                                BOGPTS.4
C                                                                                BOGPTS.5
C-----------------------------------------------------------------------         BOGPTS.6
C                         !!!  IMPORTANT  !!!                                    BOGPTS.7
C                                                                                BOGPTS.8
C        PURPOSE:  THIS SUBROUTINE READS AND PROCESSES DATA TO CORRECT           BOGPTS.9
C                  ERRORS DETECTED IN EXISTING REPORTS.  CORRECTION              BOGPTS.10
C                  DATA MAY COME FROM EITHER OF TWO SOURCES:                     BOGPTS.11
C                                                                                BOGPTS.12
C             1. ***** KBOGUS - MANUALLY INSERTED DATA ENTERED THROUGH           BOGPTS.13
C                               LOGICAL UNIT 5 (FOLLOWING M.I.F.).  EACH         BOGPTS.14
C                               RECORD MAY CORRECT U,V,T,RH (AND SEA-            BOGPTS.15
C                               LEVEL PRES FOR SFC. STATIONS).                   BOGPTS.16
C                          ** - NOTE: EACH KBOGUS RECORD MUST INCLUDE            BOGPTS.17
C                               MDATE SINCE THERE MUST BE ONLY ONE FILE          BOGPTS.18
C                               OF KBOGUS DATA.                                  BOGPTS.19
C                          ** - NOTE: BE SURE TO INCLUDE \EOF TO DE-             BOGPTS.20
C                               LINEATE BEGINNING AND END OF KBOGUS              BOGPTS.21
C                               RECORDS.                                         BOGPTS.22
C                          ** - NOTE: KBOGUS DATA CONVENTIONS:                   BOGPTS.23
C                                  A.  IF YOU WANT TO CHANGE A VALUE --          BOGPTS.24
C                                      ENTER CORRECT NEW VALUE                   BOGPTS.25
C                                  B.  IF YOU WANT A VALUE DELETED --            BOGPTS.26
C                                      ENTER 99999.                              BOGPTS.27
C                                  C.  IF YOU DO NOT WANT TO CHANGE AN           BOGPTS.28
C                                      EXISTING VALUE -- ENTER 88888.            BOGPTS.29
C                                      (DEFAULT)                                 BOGPTS.30
C                                                                                BOGPTS.31
C             2. *** AUTOBOGUS - AUTOMATICALLY GENERATED DATA CREATED            BOGPTS.32
C                                BY A PREVIOUS RUN OF PROGRAM RAWINS             BOGPTS.33
C                                WITH AUTBGW=.T.).  EACH RECORD CONTAINS         BOGPTS.34
C                                ONE DATUM FOR A SINGLE STATION WHICH            BOGPTS.35
C                                RAWINS DETERMINED WAS A POSSIBLE BAD            BOGPTS.36
C                                OBSERVATION (SEE SUBR. GETERR), INCLUDI         BOGPTS.37
C                                U,V,T,RH (AND SEA-LVL PRES. FOR SFC.            BOGPTS.38
C                                STATIONS).                                      BOGPTS.39
C                                USE OF AUTBGR BY RAWINS:                        BOGPTS.40
C                                                                                BOGPTS.41
C                                AUTBGR = .T.  IN THIS CASE, SUBR. GETER         BOGPTS.42
C                                              WILL USE ERRMX = 999.,            BOGPTS.43
C                                              AND ALL OBS. WILL BE              BOGPTS.44
C                                              ACCEPTED, EXCEPT AUTOBOGU         BOGPTS.45
C                                              OBS. FLAGGED WITH RECYCL          BOGPTS.46
C                                              (F OR B)- ASSUMES ALL BAD         BOGPTS.47
C                                              OBS. HAVE ALREADY BEEN FL         BOGPTS.48
C                                              GED BY A PREVIOUS RUN OF          BOGPTS.49
C                                              RAWINS.                           BOGPTS.50
C                                AUTBGR = .F.  ERROR-CHECKING PROCEEDS A         BOGPTS.51
C                                              SPECIFIED BY ERRMXW,ERRMX         BOGPTS.52
C                                              AND ERRMXP IN M.I.F.              BOGPTS.53
C                           ** - NOTE: THERE WILL BE "IFDATL" FILES OF           BOGPTS.54
C                                AUTOBOGUS DATA CREATED FOR EACH 12-H            BOGPTS.55
C                                TIME PERIOD WHEN M.I.F. PARAMETER               BOGPTS.56
C                                FDDASF(IFILE) = .T. (SEE MAIN PROGRAM           BOGPTS.57
C                                FOR IFDATL).  ONE FILE PER PERIOD WHEN          BOGPTS.58
C                                FDDASF = .T.                                    BOGPTS.59
C                           ** - NOTE: THE USER MUST EDIT THE RAWINS-            BOGPTS.60
C                                GENERATED AUTOBOGUS POINTS TO INDICATE          BOGPTS.61
C                                WHICH POTENTIALLY-BAD OBS. FLAGGED BY           BOGPTS.62
C                                SUBR. GETERR ARE CONSIDERED OK, BY              BOGPTS.63
C                                SETTING THE VALUE OF "RECYCL" IN EACH           BOGPTS.64
C                                RECORD.                                         BOGPTS.65
C                                   RECYCL = T,   OBS. IS OK (NO ACTION          BOGPTS.66
C                                                 NEEDED).                       BOGPTS.67
C                                   RECYCL = F,   OBS. IS CONFIRMED AS           BOGPTS.68
C                                                 BAD (REMOVE).                  BOGPTS.69
C                                   RECYCL = B,   OBS. IS CONFIRMED AS           BOGPTS.70
C                                                 BAD (B FOR BOGUS---            BOGPTS.71
C                                                     ---CHANGE VALUE)           BOGPTS.72
C                                                                                BOGPTS.73
C             3. ***** CONTENTS OF INPUT BOGUS RECORDS:                          BOGPTS.74
C                                                                                BOGPTS.75
C           KN = ENTRY SEQ. NO. (INDEPENDENT FOR MANUAL [KBOGUS]                 BOGPTS.76
C                AND AUTOBOGUS SOURCES)                                          BOGPTS.77
C        KTYPE = DATA TYP:  1 = MAND. LEVEL DATA                                 BOGPTS.78
C                          -1 = NON-STD LEVEL DATA                               BOGPTS.79
C                           2 = SFC. DATA                                        BOGPTS.80
C         KSTA = STATION NO. (MUST BE UNIQUE; SEE END OF GETRAW)                 BOGPTS.81
C           PK = PRESSURE LEVEL (MB; REQUIRED FOR UPPER-AIR RECORDS,             BOGPTS.82
C                DEFINE SEA-LEVEL PRES. WHEN KTYPE=2; 88888. IS DEFAULT)         BOGPTS.83
C           ZK = HT. OBS. (M; 88888. IS DEFAULT; NOT USED CURRENTLY)             BOGPTS.84
C           TK = T OBS. (C; 88888. IS DEFAULT)                                   BOGPTS.85
C           HK = REL. HUM. (PERCENT; 88888. IS DEFAULT)                          BOGPTS.86
C           DK = WIND DIR. (DEG; 88888. IS DEFAULT; MUST INCLUDE FK)             BOGPTS.87
C           FK = WIND SPD. (M/S; 88888. IS DEFAULT; MUST INCLUDE DK)             BOGPTS.88
C        IUORV = IDENTIFIER FOR ERRONEOUS VARIABLE TYPE (AUTOBOG. ONLY)          BOGPTS.89
C                           1 = U-COMP. DISCARDED (V MAY BE OK)                  BOGPTS.90
C                           2 = V-COMP. DISCARDED (U MAY BE OK)                  BOGPTS.91
C                           3 = TEMP.                                            BOGPTS.92
C                           4 = REL. HUM.                                        BOGPTS.93
C                           6 = SEA-LEVEL PRES.                                  BOGPTS.94
C          RIY = EXACT I-INDEX OF DISCARDED POINT (AUTOBOG. ONLY)                BOGPTS.95
C          RJX = EXACT J-INDEX OF DISCARDED POINT (AUTOBOG. ONLY)                BOGPTS.96
C          LVL = VERTICAL LEVEL INDEX (1=SURFACE; 2 TO NVERT=MAND.LVLS;          BOGPTS.97
C                NON-STD. LEVELS NUMBERED FROM NVERT+1.) (AUTOBOG. ONLY)         BOGPTS.98
C        MDATE = DATE AND TIME OF BOGUS OBS.                                     BOGPTS.99
C        RECYCL = EXPLAINED ABOVE                                                BOGPTS.100
C                                                                                BOGPTS.101
C                                                                                BOGPTS.102
C             4. ***** PARAMETERS OF ARGUMENT LIST:                              BOGPTS.103
C                                                                                BOGPTS.104
C                DATAH(ID1,ID2,ID3), CORRH(ID1,ID2,ID3) - UPPER-AIR DATA         BOGPTS.105
C                DATAS(IDS1,IDS2,IDS3) - SURFACE-DATA STORAGE ARRAY              BOGPTS.106
C                IUORS  -  1 = UPPER-AIR DATA PROCESSING DESIRED                 BOGPTS.107
C                          2 = SFC.-DATE PROCESSING DESIRED                      BOGPTS.108
C                MDATE  -  DATE AND TIME TO BE PROCESSED                         BOGPTS.109
C                KBOGR  -  .T. = SEEK KBOGUS (MANUAL) PTS.                       BOGPTS.110
C                          .F. = NO KBOGUS PTS.                                  BOGPTS.111
C                AUTBR  -  .T. = SEEK AUTOBOGUS PTS.                             BOGPTS.112
C                          .F. = NO AUTOBOGUS PTS. FOR THIS MDATE                BOGPTS.113
C               NVOL10  -  UNIT NO. FOR AUTOBOGUS VOLUME (READ)                  BOGPTS.114
C               NBRFIL  -  FILE NO. ON NVOL10 CONTAINING MDATE DATA              BOGPTS.115
C                                                                                BOGPTS.116
C             5. ***** FORMAT FOR INPUT RECORDS:                                 BOGPTS.117
C                                                                                BOGPTS.118
C                   KBOGUS:  SEE STATEMENT NO. 40                                BOGPTS.119
C                AUTOBOGUS:  SEE STATEMENT NO. 80                                BOGPTS.120
C                                                                                BOGPTS.121
C                                                                                BOGPTS.122
C-----------------------------------------------------------------------         BOGPTS.123
C                                                                                BOGPTS.124
C-----------------------------------------------------------------------         BOGPTS.125
#include <paramirb.incl>                                                         BOGPTS.126
C-----------------------------------------------------------------------         BOGPTS.127
C                                                                                BOGPTS.128
C-----------------------------------------------------------------------         BOGPTS.129
#include <paramirs.incl>                                                         BOGPTS.130
C-----------------------------------------------------------------------         BOGPTS.131
C-----------------------------------------------------------------------         BOGPTS.132
C                                                                                BOGPTS.133
#include <coma.incl>                                                             BOGPTS.134
C-----------------------------------------------------------------------         BOGPTS.135
C-----------------------------------------------------------------------         BOGPTS.136
C                                                                                BOGPTS.137
#include <comb.incl>                                                             BOGPTS.138
C                                                                                BOGPTS.139
C-----------------------------------------------------------------------         BOGPTS.140
      character*24 MDATE                                                         BOGPTS.141
      character*16 KDATE                                                         BOGPTS.142
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                            BOGPTS.143
      DIMENSION DATAS(IDS1,IDS2,IDS3),RSOND(5,IRS),BUFD(5,IRS),                  BOGPTS.144
     1 ISTNUM(3,IRS),RANG(3,IRS),IFOUND(3,IRS),BUFUPR(5,IRB)                     BOGPTS.145
      DIMENSION DATNEW(5)                                                        BOGPTS.146
      DIMENSION ISTAT(2)                                                         BOGPTS.147
      CHARACTER RECYCL*1,ABOGUS*6,BOGTYP*6,KBOG*6,MSFC*7,MUPR*7,MUORS*7          BOGPTS.148
      DATA DEGRAN /0.0174532/, KBOG /'KBOGUS'/, ABOGUS /'ABOGUS'/                BOGPTS.149
      DATA KFIRST /1/, MSFC /'SURFACE'/, MUPR /' UPPER'/, DEF /88888./           BOGPTS.150
      IDF=1                                                                      BOGPTS.151
      IF(IUORS.EQ.1)THEN                                                         BOGPTS.152
      MUORS=MUPR                                                                 BOGPTS.153
      PRINT 10,MUORS                                                             BOGPTS.154
10    FORMAT(//1X,'@@@@@@@@@@ CALL BOGPTS FOR ',A7,' LEVEL DATA -- ',            BOGPTS.155
     1 'RDISK,WDISK'//)                                                          BOGPTS.156
      ELSEIF(IUORS.EQ.2)THEN                                                     BOGPTS.157
      MUORS=MSFC                                                                 BOGPTS.158
      PRINT 10,MUORS                                                             BOGPTS.159
      ELSE                                                                       BOGPTS.160
      PRINT 20,IUORS                                                             BOGPTS.161
20    FORMAT(//10X,' ERROR -- IUORS =',I3,2X,'ON ENTRY TO BOGPTS...STOP'         BOGPTS.162
     1 )                                                                         BOGPTS.163
      STOP20                                                                     BOGPTS.164
      ENDIF                                                                      BOGPTS.165
      NVOL12=12                                                                  BOGPTS.166
      IF(KFIRST.EQ.1)THEN                                                        BOGPTS.167
      PRINT 22                                                                   BOGPTS.168
22    FORMAT(1H1///////,55X,'!!!  IMPORTANT  !!!'////10X,'BEFORE USING',         BOGPTS.169
     1 ' OR AUTOBOGUS OPTIONS, USER SHOULD READ INTERNAL DOCUMENTATION',         BOGPTS.170
     2 ' COMMENTS IN SUBROUTINE BOGPTS'/1H1)                                     BOGPTS.171
      KFIRST=0                                                                   BOGPTS.172
      ENDIF                                                                      BOGPTS.173
      NABOG=0                                                                    BOGPTS.174
      NKBOG=0                                                                    BOGPTS.175
      NDF=0                                                                      BOGPTS.176
      LENBUF=ID1*ID3                                                             BOGPTS.177
      IDM=ID1-1                                                                  BOGPTS.178
      NNEWP1=NNEWPL+1                                                            BOGPTS.179
      PRINT 25                                                                   BOGPTS.180
25    FORMAT(//,3X,'KN KTYPE STA.NO. PRES.LVL. HGT.(M)  TEMP(C)  ',              BOGPTS.181
     1 ' RH(%)     DIR.  SPD(M/S) IVRBL   I     J    LVL   MDATE',               BOGPTS.182
     2 '  RECYCL  BOGUS TYPE'//)                                                 BOGPTS.183
C                                                                                BOGPTS.184
C-----------------------------------------------------------------------         BOGPTS.185
C                                                                                BOGPTS.186
C--------READ CYCLE:                                                             BOGPTS.187
C        BEGIN WITH KBOGUS DATA:  READ AND CHECK DATE                            BOGPTS.188
C                                                                                BOGPTS.189
      IF(.NOT.KBOGR)GO TO 60                                                     BOGPTS.190
      BOGTYP=KBOG                                                                BOGPTS.191
30    READ(NVOL12,40,END=50)KN,KTYPE,KSTA,                                       BOGPTS.192
     *   PK,ZK,TK,HK,DK,FK,LVL,KDATE                                             BOGPTS.193
40    FORMAT(I4,I2,1X,A8,1X,F7.1,1X,F7.1,4(1X,F7.1),2X,I2,4X,A16)                BOGPTS.194
      IF(KDATE.LT.MDATE(1:16))GO TO 30                                           BOGPTS.195
        IF(KDATE.EQ.MDATE(1:16)) THEN                                            BOGPTS.196
            IF(BOGPRT)  PRINT 120,KN,KTYPE,KSTA,PK,ZK,TK,HK,DK,FK                BOGPTS.197
     1                  ,LVL,KDATE,BOGTYP                                        BOGPTS.198
            GO TO 110                                                            BOGPTS.199
        ENDIF                                                                    BOGPTS.200
50    REWIND (NVOL12)                                                            BOGPTS.201
60    CONTINUE                                                                   BOGPTS.202
      BOGTYP=ABOGUS                                                              BOGPTS.203
C                                                                                BOGPTS.204
C--------READ DATA FROM FILE(NBRFIL) OF AUTOBOGUS VOLUME (NVOL10).               BOGPTS.205
C        THE POINTER SHOULD BE AUTOMATICALLY AT THE CORRECT FILE (KDATE          BOGPTS.206
C        = MDATE).                                                               BOGPTS.207
70    CONTINUE                                                                   BOGPTS.208
      IF(IUORS.EQ.2) THEN                                                        BOGPTS.209
         READ(NVOL10,80,ERR=71,END=100)KDATE,KN,KTYPE,KSTA,                      BOGPTS.210
     *      LVL,IUORV,                                                           BOGPTS.211
     1      PK,TK,DK,FK,RECYCL,RIY,RJX,ZK,HK                                     BOGPTS.212
         if (KDATE .GT. MDATE(1:16)) THEN                                        BOGPTS.213
            print*, 'Kdate > Mdate: ', kdate, '  ', mdate                        BOGPTS.214
            backspace(nvol10)                                                    BOGPTS.215
            go to 100                                                            BOGPTS.216
         endif                                                                   BOGPTS.217
         GOTO 72                                                                 BOGPTS.218
71       CONTINUE                                                                BOGPTS.219
        CALL DECOMDAT(MDATE,MMYR,MMMO,MMDY,MMHR,MMMI,MMSC,MMFR)                  BOGPTS.220
         IF ((MMHR.EQ.0) .OR. (MMHR.EQ.12)) THEN                                 BOGPTS.221
            PRINT *,'AUTOBOGUS FILE WILL HAVE NO',                               BOGPTS.222
     *              ' UPPER AIR OBS AT ',MDATE                                   BOGPTS.223
            BACKSPACE NVOL10                                                     BOGPTS.224
         ENDIF                                                                   BOGPTS.225
         GOTO 100                                                                BOGPTS.226
      ELSE IF(IUORS.EQ.1) THEN                                                   BOGPTS.227
         READ(NVOL10,80,ERR=100,END=100)KDATE,KN,KTYPE,KSTA,                     BOGPTS.228
     *      LVL,IUORV,                                                           BOGPTS.229
     1      PK,TK,DK,FK,RECYCL,RIY,RJX,ZK,HK                                     BOGPTS.230
         if (KDATE .GT. MDATE(1:16)) THEN                                        BOGPTS.231
            backspace(nvol10)                                                    BOGPTS.232
            print*, 'KDate > MDate: ', kdate, '  ', mdate                        BOGPTS.233
            go to 100                                                            BOGPTS.234
         endif                                                                   BOGPTS.235
      ENDIF                                                                      BOGPTS.236
72    CONTINUE                                                                   BOGPTS.237
80    FORMAT(A16,I4,I2,1X,A8,I3,I2,4F8.1,1X,A1,9X,2F7.2,2F8.1)                   BOGPTS.238
      IF(BOGPRT) THEN                                                            BOGPTS.239
         IF(RECYCL.EQ.'F' .OR. RECYCL.EQ.'B') PRINT 130,                         BOGPTS.240
     1      KN,KTYPE,KSTA,PK,ZK,TK,HK,DK,FK,IUORV,RIY,RJX,LVL                    BOGPTS.241
     2      ,KDATE,RECYCL,BOGTYP                                                 BOGPTS.242
      END IF                                                                     BOGPTS.243
      IF(KDATE.NE.MDATE(1:16))THEN                                               BOGPTS.244
      PRINT 90,NBRFIL,MDATE(1:16),KDATE                                          BOGPTS.245
90    FORMAT(10X,'AUTOBOGUS VOLUME, FILE NO.=',I3,2X,'ERROR: MDATE=',            BOGPTS.246
     1 A16,2X,'KDATE=',A16,'...STOP IN BOGPTS'/20X,'USER: EXAMINE ',             BOGPTS.247
     1 'COMMENTS IN BOGPTS AND GETERR')                                          BOGPTS.248
      STOP 90                                                                    BOGPTS.249
      ENDIF                                                                      BOGPTS.250
C                                                                                BOGPTS.251
C-----------------------------------------------------------------------         BOGPTS.252
C                                                                                BOGPTS.253
C--------SORT DATA TYPES:                                                        BOGPTS.254
C        USE KTYPE AND IUORS TO DETERMINE IF CURRENT DATA TYPE IS                BOGPTS.255
C        APPROPRIATE. IOURS=2 SFC DATA, IOURS=1 UPPER AIR DATA.                  BOGPTS.256
C---     KTYPE=2 SFC DATA, KTYPE.NE.2 UPPER AIR DATA                             BOGPTS.257
C                                                                                BOGPTS.258
 110  CONTINUE                                                                   BOGPTS.259
      IF(KTYPE.EQ.2 .AND. IUORS.EQ. 2) THEN                                      BOGPTS.260
        IF(BOGTYP.EQ.KBOG) GO TO 180                                             BOGPTS.261
        IF(RECYCL.EQ.'F' .OR. RECYCL.EQ.'B') THEN                                BOGPTS.262
          GO TO 180                                                              BOGPTS.263
        ELSE                                                                     BOGPTS.264
          NABOG=NABOG+1                                                          BOGPTS.265
          GO TO 70                                                               BOGPTS.266
        ENDIF                                                                    BOGPTS.267
      ELSEIF(KTYPE.NE.2.AND.IUORS.EQ.1) THEN                                     BOGPTS.268
        IF(BOGTYP.EQ.KBOG) GO TO 140                                             BOGPTS.269
        IF(RECYCL.EQ.'F' .OR. RECYCL.EQ.'B') THEN                                BOGPTS.270
          GO TO 140                                                              BOGPTS.271
        ELSE                                                                     BOGPTS.272
          NABOG=NABOG+1                                                          BOGPTS.273
          GO TO 70                                                               BOGPTS.274
        ENDIF                                                                    BOGPTS.275
      ELSE                                                                       BOGPTS.276
C   KTYPE IS WRONG TYPE, READ NEXT RECORD                                        BOGPTS.277
        IF(BOGTYP.EQ.KBOG) THEN                                                  BOGPTS.278
          PRINT 119                                                              BOGPTS.279
          GO TO 30                                                               BOGPTS.280
        END IF                                                                   BOGPTS.281
C---  WHEN IHOUR=2 AND ALL THE SFC DATA HAS BEEN PROCESSES, POSITION THE         BOGPTS.282
C     BACK TO THE FIRST UPPER AIR DATA                                           BOGPTS.283
         BACKSPACE NVOL10                                                        BOGPTS.284
      ENDIF                                                                      BOGPTS.285
119   FORMAT('!!! THE ABOVE K BOGUS TYPE (KTYPE) IS WRONG TYPE,',                BOGPTS.286
     &     ' DATA NOT USED')                                                     BOGPTS.287
120   FORMAT(1X,I4,2X,I2,4X,A5,3X,6(F7.1,2X),20X,I2,2X,                          BOGPTS.288
     1       A16,11X,A6)                                                         BOGPTS.289
130     FORMAT(1X,I4,2X,I2,4X,A5,3X,F7.1,2X,F7.1,2X,F7.1,2X,F7.1,2X,             BOGPTS.290
     1         F7.1,2X,F7.1,4X,I2,3X,F4.1,2X,F4.1,3X,I2,2X,A16,5X,A1,            BOGPTS.291
     2         6X,A6)                                                            BOGPTS.292
C                                                                                BOGPTS.293
C--------NO MORE AUTOBOGUS RECORDS FOR MDATE.                                    BOGPTS.294
C        THIS OPERATION ASSUMES SFCBLN IS EXECUTED BEFORE                        BOGPTS.295
C        BLEND, SO IUORS=2 ON FIRST ENTRANCE TO BOGPTS.                          BOGPTS.296
C                                                                                BOGPTS.297
C        NOTE -- THIS IS THE NORMAL RETURN PATHWAY.                              BOGPTS.298
C                                                                                BOGPTS.299
100   CONTINUE                                                                   BOGPTS.300
      IF(IUORS.EQ.1)GO TO 600                                                    BOGPTS.301
      IF(IUORS.EQ.2)GO TO 625                                                    BOGPTS.302
C                                                                                BOGPTS.303
C                                                                                BOGPTS.304
C-----------------------------------------------------------------------         BOGPTS.305
C                                                                                BOGPTS.306
C                        *** UPPER-AIR BOGUS POINTS ***                          BOGPTS.307
C                                                                                BOGPTS.308
C        ***---UPPER-AIR DATA FOR CORRECT DATE HAS BEEN FOUND.  FOR              BOGPTS.309
C              AUTOBOGUS DATA, RECYCL INDICTED BAD DATA MUST BE CHANGED          BOGPTS.310
C              OR REMOVED.  NEXT SEARCH FOR THE STATION NO. (KSTA)               BOGPTS.311
C              IN ARRAY ISTATN(1,N).  (UPPER-AIR DATA IS IN THE FIRST            BOGPTS.312
C              NSTATN POSITIONS.)                                                BOGPTS.313
140   CONTINUE                                                                   BOGPTS.314
      IF(NSTATN.LE.0)STOP140                                                     BOGPTS.315
      IDF=1                                                                      BOGPTS.316
      DO 150 N=1,NSTATN                                                          BOGPTS.317
      NN=N                                                                       BOGPTS.318
      NKB=N                                                                      BOGPTS.319
      IF(KSTA.EQ.ISTNUM(1,N))GO TO 250                                           BOGPTS.320
150   CONTINUE                                                                   BOGPTS.321
      IF(NSTATN.GT.ID3)STOP150                                                   BOGPTS.322
      PRINT 170,KSTA,NSTATN,BOGTYP                                               BOGPTS.323
170   FORMAT(2X,'WARNING: KSTA=',A5,2X,'NOT FOUND IN NSTATN=',I3,2X,             BOGPTS.324
     1 'UPPER-AIR STATION NUMBERS.  IN ARRAY ISTNUM.',2X,'BOGTYP=',              BOGPTS.325
     2 A6,'.',2X,'EXECUTION CONTINUING.')                                        BOGPTS.326
      IF(BOGTYP.EQ.KBOG)GO TO 30                                                 BOGPTS.327
      GO TO 70                                                                   BOGPTS.328
C                                                                                BOGPTS.329
C-----------------------------------------------------------------------         BOGPTS.330
C                                                                                BOGPTS.331
C                       *** SURFACE BOGUS POINTS ***                             BOGPTS.332
C                                                                                BOGPTS.333
C        ***---SURFACE DATA FOR CORRECT DATE HAS BEEN FOUND.  FOR                BOGPTS.334
C              AUTOBOGUS DATA, RECYCL INDICATED BAD DATA MUST BE CHANGED         BOGPTS.335
C              OR REMOVED.  NEXT, SEARCH FOR STATION NO. (KSTA)                  BOGPTS.336
C              IN ARRAY ISTATN(3,N) (SURFACE DATA MAY BE AMONG UPPER-            BOGPTS.337
C              AIR SOUNDINGS OR IN SURFACE-STATION REPORTS)                      BOGPTS.338
C                                                                                BOGPTS.339
180   CONTINUE                                                                   BOGPTS.340
C                                                                                BOGPTS.341
C        FIRST, CHECK FORCAST AMONG UPPER-AIR STATION (FIRST NSTATN)             BOGPTS.342
      IF(NSTATN.LE.0)GO TO 210                                                   BOGPTS.343
      IDF=1                                                                      BOGPTS.344
      DO 190 N=1,NSTATN                                                          BOGPTS.345
      NN=N                                                                       BOGPTS.346
      NKB=N                                                                      BOGPTS.347
      IF(KSTA.EQ.ISTNUM(3,N))GO TO 250                                           BOGPTS.348
190   CONTINUE                                                                   BOGPTS.349
      IF(NSTATN.GT.ID3)STOP190                                                   BOGPTS.350
C                                                                                BOGPTS.351
C        CHECK FOR KSTA AMONG SURFACE STATIONS                                   BOGPTS.352
210   IF(JSTATN.GT.0)THEN                                                        BOGPTS.353
      N1=NSTATN+1                                                                BOGPTS.354
C        ISTATN=NSTATN+JSTATN                                                    BOGPTS.355
      IDF=-1                                                                     BOGPTS.356
      DO 220 N=N1,ISTATN                                                         BOGPTS.357
      NN=N-NSTATN                                                                BOGPTS.358
      NKB=N                                                                      BOGPTS.359
      IF(KSTA.EQ.ISTNUM(3,N))GOTO 400                                            BOGPTS.360
220   CONTINUE                                                                   BOGPTS.361
      ENDIF                                                                      BOGPTS.362
      PRINT 230,KSTA,ISTATN,BOGTYP                                               BOGPTS.363
230   FORMAT(2X,'WARNING: KSTA=',A5,2X,'NOT FOUND IN ISTATN=',I4,2X,             BOGPTS.364
     1 'SURFACE REPORTS IN ARRAY ISTNUM.',2X,'BOGTYP=',A6,'.',2X,                BOGPTS.365
     2 'EXECUTION CONTINUING.')                                                  BOGPTS.366
      IF(BOGTYP.EQ.KBOG)GOTO 30                                                  BOGPTS.367
      GOTO 70                                                                    BOGPTS.368
C                                                                                BOGPTS.369
C-----------------------------------------------------------------------         BOGPTS.370
C                                                                                BOGPTS.371
C        ***---ACCESS STORED MANDATORY AND NON-STANDARD OBSERVATIONS             BOGPTS.372
C              FROM SORTED DISK FILES, UNLESS CORRECT DATA ARE ALREADY           BOGPTS.373
C              AVAILABLE IN DATAH AND CORRH.                                     BOGPTS.374
C                                                                                BOGPTS.375
250   CONTINUE                                                                   BOGPTS.376
      IF(IDF.EQ.NDF)GOTO 400                                                     BOGPTS.377
C                                                                                BOGPTS.378
          IF(NDF.NE.0)THEN                                                       BOGPTS.379
C             RESTORE CURRENT DATAH AND CORRH CONTENTS ON DISK BEFORE            BOGPTS.380
C             ACCESSING NEW FILE.                                                BOGPTS.381
          DO 270 L=1,ID2                                                         BOGPTS.382
          DO 260 M=1,ID1                                                         BOGPTS.383
          DO 260 N=1,ID3                                                         BOGPTS.384
260       BUFUPR(M,N)=DATAH(M,L,N)                                               BOGPTS.385
          NAMED=NAMDAT+10000*L                                                   BOGPTS.386
          CALL WDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                         BOGPTS.387
270       CONTINUE                                                               BOGPTS.388
          DO 290 L=1,ID2                                                         BOGPTS.389
          DO 280 M=1,ID1                                                         BOGPTS.390
          DO 280 N=1,ID3                                                         BOGPTS.391
280       BUFUPR(M,N)=CORRH(M,L,N)                                               BOGPTS.392
          NAMEC=NAMCOR+10000*L                                                   BOGPTS.393
          CALL WDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                         BOGPTS.394
290       CONTINUE                                                               BOGPTS.395
          ENDIF                                                                  BOGPTS.396
        NDF=IDF                                                                  BOGPTS.397
        NFS=NFSTAD                                                               BOGPTS.398
        NLS=NLSTAD                                                               BOGPTS.399
        DO 330 L=1,ID2                                                           BOGPTS.400
        NAMED=NAMDAT+10000*L                                                     BOGPTS.401
        NAMEC=NAMCOR+10000*L                                                     BOGPTS.402
        CALL RDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                           BOGPTS.403
        DO 300 M=1,ID1                                                           BOGPTS.404
        DO 300 L1=1,ID3                                                          BOGPTS.405
300     BUFD(M,L1)=BUFUPR(M,L1)                                                  BOGPTS.406
        CALL RDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                           BOGPTS.407
        DO 310 M=1,ID1                                                           BOGPTS.408
        DO 310 L1=1,ID3                                                          BOGPTS.409
310     RSOND(M,L1)=BUFUPR(M,L1)                                                 BOGPTS.410
        DO 320 N=NFS,NLS                                                         BOGPTS.411
        DO 320 M=1,ID1                                                           BOGPTS.412
        DATAH(M,L,N)=BUFD(M,N)                                                   BOGPTS.413
        CORRH(M,L,N)=RSOND(M,N)                                                  BOGPTS.414
320     CONTINUE                                                                 BOGPTS.415
330     CONTINUE                                                                 BOGPTS.416
C                                                                                BOGPTS.417
C-----------------------------------------------------------------------         BOGPTS.418
C                                                                                BOGPTS.419
C--------KSTA HAS BEEN LOCATED AND OBSERVATIONS ACCESSED.  NEXT, FOR             BOGPTS.420
C        KBOGUS DATA MAKE NECESSARY CONVERSIONS BEFORE REPLACING THE             BOGPTS.421
C        EXISTING DATA IN DATAH, CORRH, OR DATAS. AUTOBOGUS OBS. MUST            BOGPTS.422
C        BE FLAGGED FOR REMOVAL OR CHANGE.                                       BOGPTS.423
C                                                                                BOGPTS.424
C                                                                                BOGPTS.425
400   DO 410 M=1,ID1                                                             BOGPTS.426
410   DATNEW(M)=88888.                                                           BOGPTS.427
      IF(BOGTYP.EQ.KBOG)GO TO 415                                                BOGPTS.428
C                                                                                BOGPTS.429
C        FLAG AUTOBOGUS OBS. FOR REMOVALOR CHANGEE                               BOGPTS.430
C                                                                                BOGPTS.431
      IF (FK.EQ.DEF.OR.DK.EQ.DEF) THEN                                           BOGPTS.432
         DATNEW(1)=88888.                                                        BOGPTS.433
         DATNEW(2)=88888.                                                        BOGPTS.434
      ELSE                                                                       BOGPTS.435
         DATNEW(1) = 1.E33                                                       BOGPTS.436
         DATNEW(2) = 1.E33                                                       BOGPTS.437
      ENDIF                                                                      BOGPTS.438
      IF(RECYCL.EQ.'B'.AND.DK.LT.80000.) THEN                                    BOGPTS.439
        AEARTH=DK*DEGRAN                                                         BOGPTS.440
        UEARTH=-FK*SIN(AEARTH)                                                   BOGPTS.441
        VEARTH=-FK*COS(AEARTH)                                                   BOGPTS.442
        ANG=RANG(3,NKB)                                                          BOGPTS.443
        DATNEW(1)=VEARTH*SIN(ANG)+UEARTH*COS(ANG)                                BOGPTS.444
        DATNEW(2)=VEARTH*COS(ANG)-UEARTH*SIN(ANG)                                BOGPTS.445
      END IF                                                                     BOGPTS.446
      IF (TK.NE.DEF.OR.HK.NE.DEF) THEN                                           BOGPTS.447
         DATNEW(3)=1.E33                                                         BOGPTS.448
      ELSE                                                                       BOGPTS.449
         DATNEW(3)=88888.                                                        BOGPTS.450
      END IF                                                                     BOGPTS.451
      IF(RECYCL.EQ.'B'.AND.TK.LT.80000.) DATNEW(3)=TK                            BOGPTS.452
      IF (TK.NE.DEF.OR.HK.NE.DEF) THEN                                           BOGPTS.453
         DATNEW(4)=1.E33                                                         BOGPTS.454
      ELSE                                                                       BOGPTS.455
         DATNEW(4)=88888.                                                        BOGPTS.456
      END IF                                                                     BOGPTS.457
      IF(RECYCL.EQ.'B'.AND.HK.LT.80000.) DATNEW(4)=HK                            BOGPTS.458
      IF(KTYPE.EQ.2 .OR. KTYPE.LT.0)THEN                                         BOGPTS.459
        IF (PK.EQ.DEF) THEN                                                      BOGPTS.460
           DATNEW(5)=88888.                                                      BOGPTS.461
        ELSE                                                                     BOGPTS.462
           DATNEW(5)=1.E33                                                       BOGPTS.463
        END IF                                                                   BOGPTS.464
      IF(RECYCL.EQ.'B'.AND.PK.LT.80000.) DATNEW(5)=PK                            BOGPTS.465
      ELSEIF(KTYPE.EQ.1)THEN                                                     BOGPTS.466
        IF (ZK.EQ.DEF) THEN                                                      BOGPTS.467
           DATNEW(5)=88888.                                                      BOGPTS.468
        ELSE                                                                     BOGPTS.469
           DATNEW(5)=1.E33                                                       BOGPTS.470
        END IF                                                                   BOGPTS.471
      IF(RECYCL.EQ.'B'.AND.ZK.LT.80000.) DATNEW(5)=ZK                            BOGPTS.472
        PK=GLVL(LVL)                                                             BOGPTS.473
      ENDIF                                                                      BOGPTS.474
      GOTO 417                                                                   BOGPTS.475
415   CONTINUE                                                                   BOGPTS.476
C                                                                                BOGPTS.477
C        CONVERT KBOGUS CORRECTIONS                                              BOGPTS.478
      IF(KTYPE.EQ.2 .OR. KTYPE.LT.0)THEN                                         BOGPTS.479
C        SEA-LEVEL PRESSURE OR NON-STANDARD PRESSURE                             BOGPTS.480
        IF (PK.LT.90000.) THEN                                                   BOGPTS.481
           DATNEW(5)=PK                                                          BOGPTS.482
        ELSE                                                                     BOGPTS.483
           DATNEW(5)=99999.                                                      BOGPTS.484
        END IF                                                                   BOGPTS.485
      ELSEIF(KTYPE.EQ.1)THEN                                                     BOGPTS.486
C        HEIGHT                                                                  BOGPTS.487
        IF (ZK.LT.90000.) THEN                                                   BOGPTS.488
           DATNEW(5)=ZK                                                          BOGPTS.489
        ELSE                                                                     BOGPTS.490
           DATNEW(5)=99999.                                                      BOGPTS.491
        END IF                                                                   BOGPTS.492
      ENDIF                                                                      BOGPTS.493
C        TEMPERATURE                                                             BOGPTS.494
        IF (TK.LT.90000.) THEN                                                   BOGPTS.495
           DATNEW(3)=TK                                                          BOGPTS.496
        ELSE                                                                     BOGPTS.497
           DATNEW(3)=99999.                                                      BOGPTS.498
        END IF                                                                   BOGPTS.499
C        RELATIVE HUMIDITY                                                       BOGPTS.500
        IF (HK.LT.90000.) THEN                                                   BOGPTS.501
           DATNEW(4)=HK                                                          BOGPTS.502
        ELSE                                                                     BOGPTS.503
           DATNEW(4)=99999.                                                      BOGPTS.504
        END IF                                                                   BOGPTS.505
C        WIND:  CONVERT DIR. AND SPEED TO U AND V, USING ROTATION ANGLES         BOGPTS.506
C               SAVED IN ARRAY RANG (SEE SUBROUTINE SAVSTN)                      BOGPTS.507
      IF(FK.LE.200.0 .AND. DK.LE.360.0)THEN                                      BOGPTS.508
        AEARTH=DK*DEGRAN                                                         BOGPTS.509
        UEARTH=-FK*SIN(AEARTH)                                                   BOGPTS.510
        VEARTH=-FK*COS(AEARTH)                                                   BOGPTS.511
        ANG=RANG(3,NKB)                                                          BOGPTS.512
        DATNEW(1)=VEARTH*SIN(ANG)+UEARTH*COS(ANG)                                BOGPTS.513
        DATNEW(2)=VEARTH*COS(ANG)-UEARTH*SIN(ANG)                                BOGPTS.514
      ELSE                                                                       BOGPTS.515
C        WIND DATA IS FOR 'NO CHANGE' OR 'REMOVE'                                BOGPTS.516
        IF (DK.GT.90000..AND.FK.GT.90000.) THEN                                  BOGPTS.517
           DATNEW(1)=99999.                                                      BOGPTS.518
           DATNEW(2)=99999.                                                      BOGPTS.519
        ELSE                                                                     BOGPTS.520
           DATNEW(1)=88888.                                                      BOGPTS.521
           DATNEW(2)=88888.                                                      BOGPTS.522
        END IF                                                                   BOGPTS.523
      ENDIF                                                                      BOGPTS.524
C                                                                                BOGPTS.525
C-----------------------------------------------------------------------         BOGPTS.526
C                                                                                BOGPTS.527
C--------APPLY CONVERTED BOGUS DATA TO REPLACE SPECIFIED OBSERVATIONS            BOGPTS.528
C                                                                                BOGPTS.529
C   ***---MANDATORY LEVEL CORRECTION                                             BOGPTS.530
417   IF(KTYPE.EQ.1)THEN                                                         BOGPTS.531
        DO 420 LL=2,NVERT                                                        BOGPTS.532
          L=LL                                                                   BOGPTS.533
          IF(L.EQ.LVL)GO TO 440                                                  BOGPTS.534
420     CONTINUE                                                                 BOGPTS.535
        PRINT 430,BOGTYP,KSTA,LVL                                                BOGPTS.536
430     FORMAT(10X,A6,' STATION NUMBER KSTA=',A6,'COULD NOT MATCH',              BOGPTS.537
     1         ' LVL=',I2,' TO A MANDATORY PRESSURE LEVEL. ',                    BOGPTS.538
     2         ' IGNORE DATA')                                                   BOGPTS.539
440     DO 450 M=1,ID1                                                           BOGPTS.540
          IF(DATNEW(M).LT.88000.)DATAH(M,L,NN)=DATNEW(M)                         BOGPTS.541
          IF(DATNEW(M).GT.90000.)DATAH(M,L,NN)=1.0E33                            BOGPTS.542
450     CONTINUE                                                                 BOGPTS.543
        IF(BOGTYP.EQ.KBOG)THEN                                                   BOGPTS.544
          NKBOG=NKBOG+1                                                          BOGPTS.545
          GO TO 30                                                               BOGPTS.546
        ELSE                                                                     BOGPTS.547
C    *** FOR AUTOBOGUS CORRECTIONS, SET IFOUND(IDF,NN)=2 TO PREVENT              BOGPTS.548
C        GETERR TOSSING DATA.                                                    BOGPTS.549
          GO TO 70                                                               BOGPTS.550
        ENDIF                                                                    BOGPTS.551
C                                                                                BOGPTS.552
C     ***---NON-STANDARD LEVEL CORRECTION                                        BOGPTS.553
      ELSEIF(KTYPE.LT.0)THEN                                                     BOGPTS.554
        DO 470 LL=2,NNEWP1                                                       BOGPTS.555
          L=LL                                                                   BOGPTS.556
          NSTLVL=L+NVERT-1                                                       BOGPTS.557
          IF(NSTLVL.EQ.LVL)GO TO 490                                             BOGPTS.558
470     CONTINUE                                                                 BOGPTS.559
        PRINT 480,BOGTYP,KSTA,LVL                                                BOGPTS.560
480     FORMAT(10X,A6,' STATION NUMBER KSTA=',A6,'COULD NOT MATCH',              BOGPTS.561
     1         'LVL=',I2,'TO A NON-STANDARD PRES. LEVEL.',                       BOGPTS.562
     2         ' IGNORE DATA')                                                   BOGPTS.563
        IF(BOGTYP.EQ.KBOG)GO TO 30                                               BOGPTS.564
        GO TO 70                                                                 BOGPTS.565
490     DO 500 M=1,IDM                                                           BOGPTS.566
          IF(DATNEW(M).LT.88000.)CORRH(M,L,NN)=DATNEW(M)                         BOGPTS.567
          IF(DATNEW(M).GT.90000.)CORRH(M,L,NN)=1.0E33                            BOGPTS.568
500     CONTINUE                                                                 BOGPTS.569
        IF(BOGTYP.EQ.KBOG)THEN                                                   BOGPTS.570
          NKBOG=NKBOG+1                                                          BOGPTS.571
          GO TO 30                                                               BOGPTS.572
        ELSE                                                                     BOGPTS.573
C     *** FOR AUTOBOGUS CORRECTIONS, SET IFOUND(IDF,NN)=2 TO PREVENT             BOGPTS.574
C         GETERR TOSSING DATA.                                                   BOGPTS.575
          GO TO 70                                                               BOGPTS.576
        ENDIF                                                                    BOGPTS.577
C                                                                                BOGPTS.578
C   ***---SURFACE DATA (L=2; MAY BE IN CORRH OR DATAS)                           BOGPTS.579
      ELSEIF(KTYPE.EQ.2)THEN                                                     BOGPTS.580
        DO 510 M=1,ID1                                                           BOGPTS.581
          IF(IDF.GT.0)THEN                                                       BOGPTS.582
            IF(DATNEW(M).LT.88000.)CORRH(M,2,NN)=DATNEW(M)                       BOGPTS.583
            IF(DATNEW(M).GT.90000.)CORRH(M,2,NN)=1.0E33                          BOGPTS.584
          ELSE                                                                   BOGPTS.585
            IF(DATNEW(M).LT.88000.)DATAS(M,2,NN)=DATNEW(M)                       BOGPTS.586
            IF(DATNEW(M).GT.90000.)DATAS(M,2,NN)=1.0E33                          BOGPTS.587
          ENDIF                                                                  BOGPTS.588
510     CONTINUE                                                                 BOGPTS.589
        IF(BOGTYP.EQ.KBOG)THEN                                                   BOGPTS.590
          NKBOG=NKBOG+1                                                          BOGPTS.591
          GO TO 30                                                               BOGPTS.592
        ELSE                                                                     BOGPTS.593
C   ***  FOR AUTOBOGUS CORRECTIONS, SET IFOUND(2,NN)=2 TO PREVENT                BOGPTS.594
C        GETERR TOSSING DATA.                                                    BOGPTS.595
          GO TO 70                                                               BOGPTS.596
        ENDIF                                                                    BOGPTS.597
      ELSE                                                                       BOGPTS.598
C   *** KTYPE ERROR                                                              BOGPTS.599
        PRINT 520,BOGTYP,KSTA,KTYPE                                              BOGPTS.600
520     FORMAT(10X,A6,'STATION NUMBER KSTA=',A6,'HAS UNEXPECTED KTYPE=',         BOGPTS.601
     1         I3,2X,'...ERROR...STOP')                                          BOGPTS.602
        STOP520                                                                  BOGPTS.603
      ENDIF                                                                      BOGPTS.604
C                                                                                BOGPTS.605
C-----------------------------------------------------------------------         BOGPTS.606
C                                                                                BOGPTS.607
C--------BOGUS DATA REPLACEMENT IS COMPLETE.  IF UPPER-AIR ARRAYS DATAH          BOGPTS.608
C        AND CORRH WHERE AFFECTED, THEIR CONTENTS MUST RE-STORED ON DISK         BOGPTS.609
600   IF(NDF.EQ.0)GO TO 645                                                      BOGPTS.610
      DO 620 L=1,ID2                                                             BOGPTS.611
      DO 610 M=1,ID1                                                             BOGPTS.612
      DO 610 N=1,ID3                                                             BOGPTS.613
610   BUFUPR(M,N)=DATAH(M,L,N)                                                   BOGPTS.614
      NAMED=NAMDAT+10000*L                                                       BOGPTS.615
      CALL WDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                             BOGPTS.616
620   CONTINUE                                                                   BOGPTS.617
625   CONTINUE                                                                   BOGPTS.618
      IF(IDF.EQ.-1)IDF=1                                                         BOGPTS.619
      DO 640 L=1,ID2                                                             BOGPTS.620
      DO 630 M=1,ID1                                                             BOGPTS.621
      DO 630 N=1,ID3                                                             BOGPTS.622
630   BUFUPR(M,N)=CORRH(M,L,N)                                                   BOGPTS.623
      NAMEC=NAMCOR+10000*L                                                       BOGPTS.624
      CALL WDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                             BOGPTS.625
640   CONTINUE                                                                   BOGPTS.626
C                                                                                BOGPTS.627
C--------PRINT OUT THE TOTAL NO. OF KBOGUS AND AUTOBOGUS POINTS                  BOGPTS.628
C        INCORPORATED INTO ANALYSES.                                             BOGPTS.629
645   IF(KBOGR)THEN                                                              BOGPTS.630
        PRINT 650,MDATE(1:16),MUORS,NKBOG                                        BOGPTS.631
650     FORMAT(////5X,'MDATE=',A16,3X,'BOGPTS COMPLETED FOR ',A7,                BOGPTS.632
     1         ' LEVEL, WITH NKBOG=',I5,2X,'KBOGUS POINTS ADDED TO ',            BOGPTS.633
     2         'DATA BASE'///)                                                   BOGPTS.634
      ENDIF                                                                      BOGPTS.635
      IF(AUTBR)THEN                                                              BOGPTS.636
        PRINT 660,MDATE(1:16),MUORS,NABOG                                        BOGPTS.637
660     FORMAT(////5X,'MDATE=',A16,5X,'BOGPTS COMPLETED FOR ',A7,                BOGPTS.638
     1         ' LEVEL, WITH NABOG=',I5,2X,'AUTOBOGUS POINTS ADDED TO ',         BOGPTS.639
     2         'DATA BASE'///)                                                   BOGPTS.640
      ENDIF                                                                      BOGPTS.641
C                                                                                BOGPTS.642
C                                                                                BOGPTS.643
      RETURN                                                                     BOGPTS.644
      END                                                                        BOGPTS.645
