      SUBROUTINE OPENDAD(IUNIT,LENGTH)                                           DADLIB.1
#include <comadp.incl>                                                           DADLIB.2
C                                                                                DADLIB.3
C  PURPOSE  OPENS A FILE FOR DIRECT ACCESS                                       DADLIB.4
C                                                                                DADLIB.5
      COMMON /DADTAB1/ TNPERM                                                    DADLIB.6
      COMMON /DADTAB2/ TRPERM, TTPERM                                            DADLIB.7
      PARAMETER (LTPERM=500)                                                     DADLIB.8
      CHARACTER*8 TNPERM(LTPERM)                                                 DADLIB.9
      INTEGER TRPERM(LTPERM), TTPERM(LTPERM)                                     DADLIB.10
      common/idad/ iverbose, ierror, iabort                                      DADLIB.11
      integer icall                                                              DADLIB.12
      data icall/0/                                                              DADLIB.13
      save icall                                                                 DADLIB.14
                                                                                 DADLIB.15
      LENS=0                                                                     DADLIB.16
      LENS=NWSZ/8 * LENGTH ! LENGTH OF RECORD IN BYTES                           DADLIB.17
      if (LENS.EQ.0) THEN                                                        DADLIB.18
         write(*,*) 'LENS = 0.  Set BIT32 or BIT64.'                             DADLIB.19
         write(*,*) 'Stop OPENDAD.'                                              DADLIB.20
         call abort                                                              DADLIB.21
      endif                                                                      DADLIB.22
                                                                                 DADLIB.23
      if (icall.eq.0) then                                                       DADLIB.24
         DO I = 1, LTPERM                                                        DADLIB.25
            TNPERM(I) = 'BLANK   '                                               DADLIB.26
            TTPERM(I) = 0                                                        DADLIB.27
            TRPERM(I) = 0                                                        DADLIB.28
         ENDDO                                                                   DADLIB.29
         icall = 1                                                               DADLIB.30
      endif                                                                      DADLIB.31
                                                                                 DADLIB.32
      OPEN(IUNIT, STATUS='SCRATCH', ACCESS='DIRECT', FORM='UNFORMATTED',         DADLIB.33
     $            RECL=LENS, IOSTAT=IERR)                                        DADLIB.34
      if (IERR.NE.0) then                                                        DADLIB.35
         PRINT*, 'ERROR IN OPENING DIRECT ACCESS FILE UNIT=',IUNIT,              DADLIB.36
     $        '  RECORD LENGTH=',LENS                                            DADLIB.37
         print*, 'STOP OPENDAD'                                                  DADLIB.38
         call abort                                                              DADLIB.39
      endif                                                                      DADLIB.40
      if (iverbose.ge.1) then                                                    DADLIB.41
         write(*,'(''OPENDAD:  OPEN('',I3,'', RECL='',I10,'')'')')               DADLIB.42
     &        iunit, lens                                                        DADLIB.43
      endif                                                                      DADLIB.44
      RETURN                                                                     DADLIB.45
      END                                                                        DADLIB.46
!=======================================================================         DADLIB.47
                                                                                 DADLIB.48
      logical function isopdad(iunit)                                            DADLIB.49
! Purpose:  Check to see if a specified DAD unit is open.                        DADLIB.50
      inquire(iunit, opened=isopdad)                                             DADLIB.51
      end                                                                        DADLIB.52
                                                                                 DADLIB.53
!=======================================================================         DADLIB.54
      subroutine closdad(iunit)                                                  DADLIB.55
      COMMON /DADTAB1/ TNPERM                                                    DADLIB.56
      COMMON /DADTAB2/ TRPERM, TTPERM                                            DADLIB.57
      PARAMETER (LTPERM=500)                                                     DADLIB.58
      CHARACTER*8 TNPERM(LTPERM)                                                 DADLIB.59
      INTEGER TRPERM(LTPERM), TTPERM(LTPERM)                                     DADLIB.60
      common/idad/ iverbose, ierror, iabort                                      DADLIB.61
      logical lopen                                                              DADLIB.62
                                                                                 DADLIB.63
      inquire (iunit, opened=lopen)                                              DADLIB.64
      if (lopen) then                                                            DADLIB.65
         if (iverbose.ge.1) write(*, '(''Closing DAD unit '', I5)')              DADLIB.66
     &        iunit                                                              DADLIB.67
         close(iunit)                                                            DADLIB.68
                                                                                 DADLIB.69
         i = 1                                                                   DADLIB.70
         do while (TNPERM(i).NE.'BLANK   ')                                      DADLIB.71
            if (TTPERM(i).eq.iunit) then                                         DADLIB.72
               j = i+1                                                           DADLIB.73
               do while(TNPERM(j).NE.'BLANK   ')                                 DADLIB.74
                  TTPERM(j-1) = TTPERM(j)                                        DADLIB.75
                  TNPERM(j-1) = TNPERM(j)                                        DADLIB.76
                  TRPERM(j-1) = TRPERM(j)                                        DADLIB.77
                  j = j + 1                                                      DADLIB.78
               enddo                                                             DADLIB.79
               TTPERM(j-1) = 0                                                   DADLIB.80
               TRPERM(j-1) = 0                                                   DADLIB.81
               TNPERM(j-1) = 'BLANK   '                                          DADLIB.82
            else                                                                 DADLIB.83
               i = i + 1                                                         DADLIB.84
            endif                                                                DADLIB.85
         enddo                                                                   DADLIB.86
      else                                                                       DADLIB.87
         if (iverbose.ge.1) print*, 'DAD Unit ',iunit,' is not open.'//          DADLIB.88
     $        '... Not closing it.'                                              DADLIB.89
      endif                                                                      DADLIB.90
                                                                                 DADLIB.91
      end                                                                        DADLIB.92
                                                                                 DADLIB.93
      SUBROUTINE WRITDAD(F,VARNAME,IUNIT,IMX,JMX,KX)                             DADLIB.94
#include <comadp.incl>                                                           DADLIB.95
C                                                                                DADLIB.96
C  PURPOSE  WRITES DIRECT ACCESS FILE                                            DADLIB.97
C                                                                                DADLIB.98
      DIMENSION F(IMX,JMX,KX)                                                    DADLIB.99
      CHARACTER*(*) VARNAME                                                      DADLIB.100
      COMMON /DADTAB1/ TNPERM                                                    DADLIB.101
      COMMON /DADTAB2/ TRPERM, TTPERM                                            DADLIB.102
      PARAMETER (LTPERM=500)                                                     DADLIB.103
      CHARACTER*8 TNPERM(LTPERM)                                                 DADLIB.104
      INTEGER TRPERM(LTPERM), TTPERM(LTPERM)                                     DADLIB.105
      common/idad/ iverbose, ierror, iabort                                      DADLIB.106
C                                                                                DADLIB.107
C  Check record length                                                           DADLIB.108
C                                                                                DADLIB.109
      inquire(UNIT=iunit,RECL=lens)                                              DADLIB.110
      ilen = IMX*JMX*KX*(NWSZ/8)                                                 DADLIB.111
      if (ilen .ne. LENS) THEN                                                   DADLIB.112
         print*,IUNIT,', ',VARNAME,', ',IMX,JMX,KX,ilen,lens                     DADLIB.113
         STOP 'WRITDAD LENGTH'                                                   DADLIB.114
      endif                                                                      DADLIB.115
C                                                                                DADLIB.116
C  Initialize record counter.                                                    DADLIB.117
C                                                                                DADLIB.118
      IREC = 1                                                                   DADLIB.119
C                                                                                DADLIB.120
C  Loop over the variables, find right name                                      DADLIB.121
C                                                                                DADLIB.122
      DO LOOP=1,LTPERM                                                           DADLIB.123
         IF (TTPERM(LOOP).EQ. IUNIT) THEN                                        DADLIB.124
            IREC = IREC + 1                                                      DADLIB.125
            IF (TNPERM(LOOP).EQ.VARNAME) THEN                                    DADLIB.126
               IREC = TRPERM(LOOP)                                               DADLIB.127
               WRITE(IUNIT,ERR=1001,REC=IREC) F                                  DADLIB.128
               if (iverbose.ge.1) then                                           DADLIB.129
                  PRINT *,'   VARIABLE ',VARNAME, ' IS OVERWRITTEN'              DADLIB.130
     &                 //' on DAD unit ', IUNIT, ' at REC ', IREC                DADLIB.131
               endif                                                             DADLIB.132
               RETURN                                                            DADLIB.133
            END IF                                                               DADLIB.134
         ENDIF                                                                   DADLIB.135
         IF ( TNPERM(LOOP).EQ.'BLANK   ') THEN                                   DADLIB.136
            TRPERM(LOOP)=IREC   ! GET STARTING RECORD NUMBER                     DADLIB.137
            TNPERM(LOOP)=VARNAME ! NAME IN ARRAY                                 DADLIB.138
            TTPERM(LOOP) = IUNIT                                                 DADLIB.139
            WRITE(IUNIT,ERR=1001,REC=IREC) F                                     DADLIB.140
            if (iverbose.ge.1) then                                              DADLIB.141
               write(*,1322) VARNAME, IUNIT,IREC                                 DADLIB.142
            endif                                                                DADLIB.143
            RETURN                                                               DADLIB.144
         ENDIF                                                                   DADLIB.145
      ENDDO                                                                      DADLIB.146
 1322 format('   VARIABLE',A9,' IS WRITTEN to DAD unit ',I3,' at REC ',          DADLIB.147
     &     I6)                                                                   DADLIB.148
C                                                                                DADLIB.149
C        ... IF YOU ARE HERE, THERE IS AN ERROR                                  DADLIB.150
C                                                                                DADLIB.151
      PRINT *,'COULD NOT FIND AN END IN THE TABLE, '//                           DADLIB.152
     &     'DIMENSION IT BIGGER.  Current size is LTPERM=', LTPERM               DADLIB.153
      print*, 'Stop WRITDAD'                                                     DADLIB.154
      CALL ABORT                                                                 DADLIB.155
1001  CONTINUE                                                                   DADLIB.156
      PRINT *,'ERROR IN WRITING DATA TO DAD UNIT ', IUNIT, '.'                   DADLIB.157
      PRINT *,'VARIABLE=',VARNAME,' RECORD=',IREC                                DADLIB.158
      print*, 'Stop WRITDAD'                                                     DADLIB.159
      CALL ABORT                                                                 DADLIB.160
      RETURN                                                                     DADLIB.161
      END                                                                        DADLIB.162
                                                                                 DADLIB.163
      SUBROUTINE READDAD(F,VARNAME,IUNIT,IMX,JMX,KX)                             DADLIB.164
#include <comadp.incl>                                                           DADLIB.165
C                                                                                DADLIB.166
C  PURPOSE  READS DIRECT ACCESS FILE                                             DADLIB.167
C                                                                                DADLIB.168
      DIMENSION F(IMX,JMX,KX)                                                    DADLIB.169
      CHARACTER*(*) VARNAME                                                      DADLIB.170
      COMMON /DADTAB1/ TNPERM                                                    DADLIB.171
      COMMON /DADTAB2/ TRPERM, TTPERM                                            DADLIB.172
      PARAMETER (LTPERM=500)                                                     DADLIB.173
      CHARACTER*8 TNPERM(LTPERM)                                                 DADLIB.174
      INTEGER TRPERM(LTPERM), TTPERM(LTPERM)                                     DADLIB.175
      common/idad/ iverbose, ierror, iabort                                      DADLIB.176
      ierror = 0                                                                 DADLIB.177
C                                                                                DADLIB.178
C  Check record length                                                           DADLIB.179
C                                                                                DADLIB.180
      inquire(iunit,recl=lens)                                                   DADLIB.181
      ilen = IMX*JMX*KX*(NWSZ/8)                                                 DADLIB.182
      if (ilen .ne. LENS) THEN                                                   DADLIB.183
         print*, IUNIT,', ',VARNAME,', ',IMX,JMX, KX, ilen, lens                 DADLIB.184
         STOP 'READDAD LENGTH'                                                   DADLIB.185
      endif                                                                      DADLIB.186
C                                                                                DADLIB.187
C  LOOP OVER THE VARIABLES, FIND RIGHT NAME                                      DADLIB.188
C                                                                                DADLIB.189
      DO LOOP=1,LTPERM                                                           DADLIB.190
            IF ( (TNPERM(LOOP).EQ.VARNAME) .and.                                 DADLIB.191
     $           (TTPERM(LOOP).EQ.IUNIT) ) THEN                                  DADLIB.192
               IREC=TRPERM(LOOP) ! GET STARTING RECORD NUMBER                    DADLIB.193
               READ(IUNIT,ERR=1001,REC=IREC) F                                   DADLIB.194
               if (iverbose.ge.1) then                                           DADLIB.195
                  write(*,1322) VARNAME, IUNIT, IREC                             DADLIB.196
               endif                                                             DADLIB.197
               RETURN                                                            DADLIB.198
            ENDIF                                                                DADLIB.199
      ENDDO                                                                      DADLIB.200
 1322 format('   VARIABLE',A9,' IS FOUND ON DAD UNIT',I4, ' AT RECORD',          DADLIB.201
     &     I5)                                                                   DADLIB.202
C                                                                                DADLIB.203
C        ... IF YOU ARE HERE, THERE IS AN ERROR                                  DADLIB.204
C                                                                                DADLIB.205
      if (iverbose.ge.0) then                                                    DADLIB.206
         PRINT *,'COULD NOT FIND ',VARNAME,                                      DADLIB.207
     $        ' IN TABLE OF NAMES OF UNIT ', IUNIT                               DADLIB.208
      endif                                                                      DADLIB.209
1001  CONTINUE                                                                   DADLIB.210
      if (iverbose.ge.0) then                                                    DADLIB.211
         PRINT *,'ERROR IN READING DATA FROM DAD UNIT', iunit                    DADLIB.212
         write(*,'(''VARIABLE = '', A8)') VARNAME                                DADLIB.213
      endif                                                                      DADLIB.214
      if (iabort.ne.0) then                                                      DADLIB.215
         print*, 'Stop READDAD.'                                                 DADLIB.216
         call abort                                                              DADLIB.217
      else                                                                       DADLIB.218
         ierror = 1                                                              DADLIB.219
      endif                                                                      DADLIB.220
      END                                                                        DADLIB.221
                                                                                 DADLIB.222
      LOGICAL FUNCTION ISTHERE(VARNAME, IUNIT)                                   DADLIB.223
C                                                                                DADLIB.224
C  LOOKS TO SEE IF THE VARIABLE NAMED VARNAME IS IN THE DIRECT ACCESS            DADLIB.225
C     FILE IUNIT.                                                                DADLIB.226
C                                                                                DADLIB.227
      CHARACTER*(*) VARNAME                                                      DADLIB.228
      COMMON /DADTAB1/ TNPERM                                                    DADLIB.229
      COMMON /DADTAB2/ TRPERM, TTPERM                                            DADLIB.230
      PARAMETER (LTPERM=500)                                                     DADLIB.231
      CHARACTER*8 TNPERM(LTPERM)                                                 DADLIB.232
      INTEGER TRPERM(LTPERM), TTPERM(LTPERM)                                     DADLIB.233
      common/idad/ iverbose, ierror, iabort                                      DADLIB.234
      ISTHERE = .FALSE.                                                          DADLIB.235
C                                                                                DADLIB.236
C  LOOP OVER THE VARIABLES, FIND RIGHT NAME                                      DADLIB.237
C                                                                                DADLIB.238
      DO LOOP=1,LTPERM                                                           DADLIB.239
         IF ( (TNPERM(LOOP).EQ.VARNAME) .and.                                    DADLIB.240
     &        (TTPERM(LOOP).EQ.IUNIT) ) THEN                                     DADLIB.241
            ISTHERE = .TRUE.                                                     DADLIB.242
            if (iverbose.ge.2) then                                              DADLIB.243
               write(*,'(''Variable '',A8,'' IS THERE ON DAD UNIT'',I4)'         DADLIB.244
     &              ) Varname, iunit                                             DADLIB.245
            endif                                                                DADLIB.246
            RETURN                                                               DADLIB.247
         ENDIF                                                                   DADLIB.248
      ENDDO                                                                      DADLIB.249
      if (iverbose.ge.1) then                                                    DADLIB.250
         write(*,'(''Variable '',A8,'' IS NOT THERE ON DAD UNIT '',I3)')         DADLIB.251
     &        Varname, iunit                                                     DADLIB.252
      endif                                                                      DADLIB.253
      RETURN                                                                     DADLIB.254
      END                                                                        DADLIB.255
                                                                                 DADLIB.256
      subroutine daseti(str, ival)                                               DADLIB.257
      character *3 str                                                           DADLIB.258
                                                                                 DADLIB.259
      common/idad/ iverbose, ierror, iabort                                      DADLIB.260
                                                                                 DADLIB.261
      if (str(1:3).eq.'VRB') then                                                DADLIB.262
         iverbose = ival                                                         DADLIB.263
      elseif (str(1:3).eq.'ABO') then                                            DADLIB.264
         iabort = ival                                                           DADLIB.265
      else                                                                       DADLIB.266
         print*, 'IVAL NOT FOUND'                                                DADLIB.267
      endif                                                                      DADLIB.268
                                                                                 DADLIB.269
      return                                                                     DADLIB.270
      end                                                                        DADLIB.271
                                                                                 DADLIB.272
      subroutine dageti(str, ival)                                               DADLIB.273
      character *3 str                                                           DADLIB.274
                                                                                 DADLIB.275
      common/idad/ iverbose, ierror, iabort                                      DADLIB.276
                                                                                 DADLIB.277
      if (str(1:3).eq.'VRB') then      ! -1: no prints;                          DADLIB.278
         ival = iverbose               !  0: error print;                        DADLIB.279
                                       !  1: some printout                       DADLIB.280
                                                                                 DADLIB.281
      elseif (str(1:3).eq.'ABO') then  ! 0: Do not abort on read error;          DADLIB.282
         ival = iabort                 ! 1: Abort on read error                  DADLIB.283
                                                                                 DADLIB.284
      elseif (str(1:3).eq.'IER') then  ! 0: Good read                            DADLIB.285
         ival = ierror                 ! 1: Read error                           DADLIB.286
      else                                                                       DADLIB.287
         print*, 'IVAL NOT FOUND'                                                DADLIB.288
      endif                                                                      DADLIB.289
                                                                                 DADLIB.290
      return                                                                     DADLIB.291
      end                                                                        DADLIB.292
                                                                                 DADLIB.293
