                                                                                 DGECO.1
C                                                                                DGECO.2
C SINGLE PRECISION                                                               DGECO.3
                                                                                 DGECO.4
      subroutine sgeco(a,lda,n,ipvt,rcond,z)                                     DGECO.5
      integer lda,n,ipvt(1)                                                      DGECO.6
      real a(lda,1),z(1)                                                         DGECO.7
      real rcond                                                                 DGECO.8
c                                                                                DGECO.9
c     sgeco factors a real matrix by gaussian elimination                        DGECO.10
c     and estimates the condition of the matrix.                                 DGECO.11
c                                                                                DGECO.12
c     if  rcond  is not needed, sgefa is slightly faster.                        DGECO.13
c     to solve  a*x = b , follow sgeco by sgesl.                                 DGECO.14
c     to compute  inverse(a)*c , follow sgeco by sgesl.                          DGECO.15
c     to compute  determinant(a) , follow sgeco by sgedi.                        DGECO.16
c     to compute  inverse(a) , follow sgeco by sgedi.                            DGECO.17
c                                                                                DGECO.18
c     on entry                                                                   DGECO.19
c                                                                                DGECO.20
c        a       real(lda, n)                                                    DGECO.21
c                the matrix to be factored.                                      DGECO.22
c                                                                                DGECO.23
c        lda     integer                                                         DGECO.24
c                the leading dimension of the array  a .                         DGECO.25
c                                                                                DGECO.26
c        n       integer                                                         DGECO.27
c                the order of the matrix  a .                                    DGECO.28
c                                                                                DGECO.29
c     on return                                                                  DGECO.30
c                                                                                DGECO.31
c        a       an upper triangular matrix and the multipliers                  DGECO.32
c                which were used to obtain it.                                   DGECO.33
c                the factorization can be written  a = l*u  where                DGECO.34
c                l  is a product of permutation and unit lower                   DGECO.35
c                triangular matrices and  u  is upper triangular.                DGECO.36
c                                                                                DGECO.37
c        ipvt    integer(n)                                                      DGECO.38
c                an integer vector of pivot indices.                             DGECO.39
c                                                                                DGECO.40
c        rcond   real                                                            DGECO.41
c                an estimate of the reciprocal condition of  a .                 DGECO.42
c                for the system  a*x = b , relative perturbations                DGECO.43
c                in  a  and  b  of size  epsilon  may cause                      DGECO.44
c                relative perturbations in  x  of size  epsilon/rcond .          DGECO.45
c                if  rcond  is so small that the logical expression              DGECO.46
c                           1.0 + rcond .eq. 1.0                                 DGECO.47
c                is true, then  a  may be singular to working                    DGECO.48
c                precision.  in particular,  rcond  is zero  if                  DGECO.49
c                exact singularity is detected or the estimate                   DGECO.50
c                underflows.                                                     DGECO.51
c                                                                                DGECO.52
c        z       real(n)                                                         DGECO.53
c                a work vector whose contents are usually unimportant.           DGECO.54
c                if  a  is close to a singular matrix, then  z  is               DGECO.55
c                an approximate null vector in the sense that                    DGECO.56
c                norm(a*z) = rcond*norm(a)*norm(z) .                             DGECO.57
c                                                                                DGECO.58
c     linpack. this version dated 08/14/78 .                                     DGECO.59
c     cleve moler, university of new mexico, argonne national lab.               DGECO.60
c                                                                                DGECO.61
c     subroutines and functions                                                  DGECO.62
c                                                                                DGECO.63
c     linpack sgefa                                                              DGECO.64
c     blas saxpy,sdot,sscal,sasum                                                DGECO.65
c     fortran abs,amax1,sign                                                     DGECO.66
c                                                                                DGECO.67
c     internal variables                                                         DGECO.68
c                                                                                DGECO.69
      real sdot,ek,t,wk,wkm                                                      DGECO.70
      real anorm,s,sasum,sm,ynorm                                                DGECO.71
      integer info,j,k,kb,kp1,l                                                  DGECO.72
c                                                                                DGECO.73
c                                                                                DGECO.74
c     compute 1-norm of a                                                        DGECO.75
c                                                                                DGECO.76
      anorm = 0.0e0                                                              DGECO.77
      do 10 j = 1, n                                                             DGECO.78
         anorm = amax1(anorm,sasum(n,a(1,j),1))                                  DGECO.79
   10 continue                                                                   DGECO.80
c                                                                                DGECO.81
c     factor                                                                     DGECO.82
c                                                                                DGECO.83
      call sgefa(a,lda,n,ipvt,info)                                              DGECO.84
c                                                                                DGECO.85
c     rcond = 1/(norm(a)*(estimate of norm(inverse(a)))) .                       DGECO.86
c     estimate = norm(z)/norm(y) where  a*z = y  and  trans(a)*y = e .           DGECO.87
c     trans(a)  is the transpose of a .  the components of  e  are               DGECO.88
c     chosen to cause maximum local growth in the elements of w  where           DGECO.89
c     trans(u)*w = e .  the vectors are frequently rescaled to avoid             DGECO.90
c     overflow.                                                                  DGECO.91
c                                                                                DGECO.92
c     solve trans(u)*w = e                                                       DGECO.93
c                                                                                DGECO.94
      ek = 1.0e0                                                                 DGECO.95
      do 20 j = 1, n                                                             DGECO.96
         z(j) = 0.0e0                                                            DGECO.97
   20 continue                                                                   DGECO.98
      do 100 k = 1, n                                                            DGECO.99
         if (z(k) .ne. 0.0e0) ek = sign(ek,-z(k))                                DGECO.100
         if (abs(ek-z(k)) .le. abs(a(k,k))) go to 30                             DGECO.101
            s = abs(a(k,k))/abs(ek-z(k))                                         DGECO.102
            call sscal(n,s,z,1)                                                  DGECO.103
            ek = s*ek                                                            DGECO.104
   30    continue                                                                DGECO.105
         wk = ek - z(k)                                                          DGECO.106
         wkm = -ek - z(k)                                                        DGECO.107
         s = abs(wk)                                                             DGECO.108
         sm = abs(wkm)                                                           DGECO.109
         if (a(k,k) .eq. 0.0e0) go to 40                                         DGECO.110
            wk = wk/a(k,k)                                                       DGECO.111
            wkm = wkm/a(k,k)                                                     DGECO.112
         go to 50                                                                DGECO.113
   40    continue                                                                DGECO.114
            wk = 1.0e0                                                           DGECO.115
            wkm = 1.0e0                                                          DGECO.116
   50    continue                                                                DGECO.117
         kp1 = k + 1                                                             DGECO.118
         if (kp1 .gt. n) go to 90                                                DGECO.119
            do 60 j = kp1, n                                                     DGECO.120
               sm = sm + abs(z(j)+wkm*a(k,j))                                    DGECO.121
               z(j) = z(j) + wk*a(k,j)                                           DGECO.122
               s = s + abs(z(j))                                                 DGECO.123
   60       continue                                                             DGECO.124
            if (s .ge. sm) go to 80                                              DGECO.125
               t = wkm - wk                                                      DGECO.126
               wk = wkm                                                          DGECO.127
               do 70 j = kp1, n                                                  DGECO.128
                  z(j) = z(j) + t*a(k,j)                                         DGECO.129
   70          continue                                                          DGECO.130
   80       continue                                                             DGECO.131
   90    continue                                                                DGECO.132
         z(k) = wk                                                               DGECO.133
  100 continue                                                                   DGECO.134
      s = 1.0e0/sasum(n,z,1)                                                     DGECO.135
      call sscal(n,s,z,1)                                                        DGECO.136
c                                                                                DGECO.137
c     solve trans(l)*y = w                                                       DGECO.138
c                                                                                DGECO.139
      do 120 kb = 1, n                                                           DGECO.140
         k = n + 1 - kb                                                          DGECO.141
         if (k .lt. n) z(k) = z(k) + sdot(n-k,a(k+1,k),1,z(k+1),1)               DGECO.142
         if (abs(z(k)) .le. 1.0e0) go to 110                                     DGECO.143
            s = 1.0e0/abs(z(k))                                                  DGECO.144
            call sscal(n,s,z,1)                                                  DGECO.145
  110    continue                                                                DGECO.146
         l = ipvt(k)                                                             DGECO.147
         t = z(l)                                                                DGECO.148
         z(l) = z(k)                                                             DGECO.149
         z(k) = t                                                                DGECO.150
  120 continue                                                                   DGECO.151
      s = 1.0e0/sasum(n,z,1)                                                     DGECO.152
      call sscal(n,s,z,1)                                                        DGECO.153
c                                                                                DGECO.154
      ynorm = 1.0e0                                                              DGECO.155
c                                                                                DGECO.156
c     solve l*v = y                                                              DGECO.157
c                                                                                DGECO.158
      do 140 k = 1, n                                                            DGECO.159
         l = ipvt(k)                                                             DGECO.160
         t = z(l)                                                                DGECO.161
         z(l) = z(k)                                                             DGECO.162
         z(k) = t                                                                DGECO.163
         if (k .lt. n) call saxpy(n-k,t,a(k+1,k),1,z(k+1),1)                     DGECO.164
         if (abs(z(k)) .le. 1.0e0) go to 130                                     DGECO.165
            s = 1.0e0/abs(z(k))                                                  DGECO.166
            call sscal(n,s,z,1)                                                  DGECO.167
            ynorm = s*ynorm                                                      DGECO.168
  130    continue                                                                DGECO.169
  140 continue                                                                   DGECO.170
      s = 1.0e0/sasum(n,z,1)                                                     DGECO.171
      call sscal(n,s,z,1)                                                        DGECO.172
      ynorm = s*ynorm                                                            DGECO.173
c                                                                                DGECO.174
c     solve  u*z = v                                                             DGECO.175
c                                                                                DGECO.176
      do 160 kb = 1, n                                                           DGECO.177
         k = n + 1 - kb                                                          DGECO.178
         if (abs(z(k)) .le. abs(a(k,k))) go to 150                               DGECO.179
            s = abs(a(k,k))/abs(z(k))                                            DGECO.180
            call sscal(n,s,z,1)                                                  DGECO.181
            ynorm = s*ynorm                                                      DGECO.182
  150    continue                                                                DGECO.183
         if (a(k,k) .ne. 0.0e0) z(k) = z(k)/a(k,k)                               DGECO.184
         if (a(k,k) .eq. 0.0e0) z(k) = 1.0e0                                     DGECO.185
         t = -z(k)                                                               DGECO.186
         call saxpy(k-1,t,a(1,k),1,z(1),1)                                       DGECO.187
  160 continue                                                                   DGECO.188
c     make znorm = 1.0                                                           DGECO.189
      s = 1.0e0/sasum(n,z,1)                                                     DGECO.190
      call sscal(n,s,z,1)                                                        DGECO.191
      ynorm = s*ynorm                                                            DGECO.192
c                                                                                DGECO.193
      if (anorm .ne. 0.0e0) rcond = ynorm/anorm                                  DGECO.194
      if (anorm .eq. 0.0e0) rcond = 0.0e0                                        DGECO.195
      return                                                                     DGECO.196
      end                                                                        DGECO.197
      subroutine sgedi(a,lda,n,ipvt,det,work,job)                                DGECO.198
      integer lda,n,ipvt(1),job                                                  DGECO.199
      real a(lda,1),det(2),work(1)                                               DGECO.200
c                                                                                DGECO.201
c     sgedi computes the determinant and inverse of a matrix                     DGECO.202
c     using the factors computed by sgeco or sgefa.                              DGECO.203
c                                                                                DGECO.204
c     on entry                                                                   DGECO.205
c                                                                                DGECO.206
c        a       real(lda, n)                                                    DGECO.207
c                the output from sgeco or sgefa.                                 DGECO.208
c                                                                                DGECO.209
c        lda     integer                                                         DGECO.210
c                the leading dimension of the array  a .                         DGECO.211
c                                                                                DGECO.212
c        n       integer                                                         DGECO.213
c                the order of the matrix  a .                                    DGECO.214
c                                                                                DGECO.215
c        ipvt    integer(n)                                                      DGECO.216
c                the pivot vector from sgeco or sgefa.                           DGECO.217
c                                                                                DGECO.218
c        work    real(n)                                                         DGECO.219
c                work vector.  contents destroyed.                               DGECO.220
c                                                                                DGECO.221
c        job     integer                                                         DGECO.222
c                = 11   both determinant and inverse.                            DGECO.223
c                = 01   inverse only.                                            DGECO.224
c                = 10   determinant only.                                        DGECO.225
c                                                                                DGECO.226
c     on return                                                                  DGECO.227
c                                                                                DGECO.228
c        a       inverse of original matrix if requested.                        DGECO.229
c                otherwise unchanged.                                            DGECO.230
c                                                                                DGECO.231
c        det     real(2)                                                         DGECO.232
c                determinant of original matrix if requested.                    DGECO.233
c                otherwise not referenced.                                       DGECO.234
c                determinant = det(1) * 10.0**det(2)                             DGECO.235
c                with  1.0 .le. abs(det(1)) .lt. 10.0                            DGECO.236
c                or  det(1) .eq. 0.0 .                                           DGECO.237
c                                                                                DGECO.238
c     error condition                                                            DGECO.239
c                                                                                DGECO.240
c        a division by zero will occur if the input factor contains              DGECO.241
c        a zero on the diagonal and the inverse is requested.                    DGECO.242
c        it will not occur if the subroutines are called correctly               DGECO.243
c        and if sgeco has set rcond .gt. 0.0 or sgefa has set                    DGECO.244
c        info .eq. 0 .                                                           DGECO.245
c                                                                                DGECO.246
c     linpack. this version dated 08/14/78 .                                     DGECO.247
c     cleve moler, university of new mexico, argonne national lab.               DGECO.248
c                                                                                DGECO.249
c     subroutines and functions                                                  DGECO.250
c                                                                                DGECO.251
c     blas saxpy,sscal,sswap                                                     DGECO.252
c     fortran abs,mod                                                            DGECO.253
c                                                                                DGECO.254
c     internal variables                                                         DGECO.255
c                                                                                DGECO.256
      real t                                                                     DGECO.257
      real ten                                                                   DGECO.258
      integer i,j,k,kb,kp1,l,nm1                                                 DGECO.259
c                                                                                DGECO.260
c                                                                                DGECO.261
c     compute determinant                                                        DGECO.262
c                                                                                DGECO.263
      if (job/10 .eq. 0) go to 70                                                DGECO.264
         det(1) = 1.0e0                                                          DGECO.265
         det(2) = 0.0e0                                                          DGECO.266
         ten = 10.0e0                                                            DGECO.267
         do 50 i = 1, n                                                          DGECO.268
            if (ipvt(i) .ne. i) det(1) = -det(1)                                 DGECO.269
            det(1) = a(i,i)*det(1)                                               DGECO.270
c        ...exit                                                                 DGECO.271
            if (det(1) .eq. 0.0e0) go to 60                                      DGECO.272
   10       if (abs(det(1)) .ge. 1.0e0) go to 20                                 DGECO.273
               det(1) = ten*det(1)                                               DGECO.274
               det(2) = det(2) - 1.0e0                                           DGECO.275
            go to 10                                                             DGECO.276
   20       continue                                                             DGECO.277
   30       if (abs(det(1)) .lt. ten) go to 40                                   DGECO.278
               det(1) = det(1)/ten                                               DGECO.279
               det(2) = det(2) + 1.0e0                                           DGECO.280
            go to 30                                                             DGECO.281
   40       continue                                                             DGECO.282
   50    continue                                                                DGECO.283
   60    continue                                                                DGECO.284
   70 continue                                                                   DGECO.285
c                                                                                DGECO.286
c     compute inverse(u)                                                         DGECO.287
c                                                                                DGECO.288
      if (mod(job,10) .eq. 0) go to 150                                          DGECO.289
         do 100 k = 1, n                                                         DGECO.290
            a(k,k) = 1.0e0/a(k,k)                                                DGECO.291
            t = -a(k,k)                                                          DGECO.292
            call sscal(k-1,t,a(1,k),1)                                           DGECO.293
            kp1 = k + 1                                                          DGECO.294
            if (n .lt. kp1) go to 90                                             DGECO.295
            do 80 j = kp1, n                                                     DGECO.296
               t = a(k,j)                                                        DGECO.297
               a(k,j) = 0.0e0                                                    DGECO.298
               call saxpy(k,t,a(1,k),1,a(1,j),1)                                 DGECO.299
   80       continue                                                             DGECO.300
   90       continue                                                             DGECO.301
  100    continue                                                                DGECO.302
c                                                                                DGECO.303
c        form inverse(u)*inverse(l)                                              DGECO.304
c                                                                                DGECO.305
         nm1 = n - 1                                                             DGECO.306
         if (nm1 .lt. 1) go to 140                                               DGECO.307
         do 130 kb = 1, nm1                                                      DGECO.308
            k = n - kb                                                           DGECO.309
            kp1 = k + 1                                                          DGECO.310
            do 110 i = kp1, n                                                    DGECO.311
               work(i) = a(i,k)                                                  DGECO.312
               a(i,k) = 0.0e0                                                    DGECO.313
  110       continue                                                             DGECO.314
            do 120 j = kp1, n                                                    DGECO.315
               t = work(j)                                                       DGECO.316
               call saxpy(n,t,a(1,j),1,a(1,k),1)                                 DGECO.317
  120       continue                                                             DGECO.318
            l = ipvt(k)                                                          DGECO.319
            if (l .ne. k) call sswap(n,a(1,k),1,a(1,l),1)                        DGECO.320
  130    continue                                                                DGECO.321
  140    continue                                                                DGECO.322
  150 continue                                                                   DGECO.323
      return                                                                     DGECO.324
      end                                                                        DGECO.325
      subroutine sgefa(a,lda,n,ipvt,info)                                        DGECO.326
      integer lda,n,ipvt(1),info                                                 DGECO.327
      real a(lda,1)                                                              DGECO.328
c                                                                                DGECO.329
c     sgefa factors a real matrix by gaussian elimination.                       DGECO.330
c                                                                                DGECO.331
c     sgefa is usually called by sgeco, but it can be called                     DGECO.332
c     directly with a saving in time if  rcond  is not needed.                   DGECO.333
c     (time for sgeco) = (1 + 9/n)*(time for sgefa) .                            DGECO.334
c                                                                                DGECO.335
c     on entry                                                                   DGECO.336
c                                                                                DGECO.337
c        a       real(lda, n)                                                    DGECO.338
c                the matrix to be factored.                                      DGECO.339
c                                                                                DGECO.340
c        lda     integer                                                         DGECO.341
c                the leading dimension of the array  a .                         DGECO.342
c                                                                                DGECO.343
c        n       integer                                                         DGECO.344
c                the order of the matrix  a .                                    DGECO.345
c                                                                                DGECO.346
c     on return                                                                  DGECO.347
c                                                                                DGECO.348
c        a       an upper triangular matrix and the multipliers                  DGECO.349
c                which were used to obtain it.                                   DGECO.350
c                the factorization can be written  a = l*u  where                DGECO.351
c                l  is a product of permutation and unit lower                   DGECO.352
c                triangular matrices and  u  is upper triangular.                DGECO.353
c                                                                                DGECO.354
c        ipvt    integer(n)                                                      DGECO.355
c                an integer vector of pivot indices.                             DGECO.356
c                                                                                DGECO.357
c        info    integer                                                         DGECO.358
c                = 0  normal value.                                              DGECO.359
c                = k  if  u(k,k) .eq. 0.0 .  this is not an error                DGECO.360
c                     condition for this subroutine, but it does                 DGECO.361
c                     indicate that sgesl or sgedi will divide by zero           DGECO.362
c                     if called.  use  rcond  in sgeco for a reliable            DGECO.363
c                     indication of singularity.                                 DGECO.364
c                                                                                DGECO.365
c     linpack. this version dated 08/14/78 .                                     DGECO.366
c     cleve moler, university of new mexico, argonne national lab.               DGECO.367
c                                                                                DGECO.368
c     subroutines and functions                                                  DGECO.369
c                                                                                DGECO.370
c     blas saxpy,sscal,isamax                                                    DGECO.371
c                                                                                DGECO.372
c     internal variables                                                         DGECO.373
c                                                                                DGECO.374
      real t                                                                     DGECO.375
      integer isamax,j,k,kp1,l,nm1                                               DGECO.376
c                                                                                DGECO.377
c                                                                                DGECO.378
c     gaussian elimination with partial pivoting                                 DGECO.379
c                                                                                DGECO.380
      info = 0                                                                   DGECO.381
      nm1 = n - 1                                                                DGECO.382
      if (nm1 .lt. 1) go to 70                                                   DGECO.383
      do 60 k = 1, nm1                                                           DGECO.384
         kp1 = k + 1                                                             DGECO.385
c                                                                                DGECO.386
c        find l = pivot index                                                    DGECO.387
c                                                                                DGECO.388
         l = isamax(n-k+1,a(k,k),1) + k - 1                                      DGECO.389
         ipvt(k) = l                                                             DGECO.390
c                                                                                DGECO.391
c        zero pivot implies this column already triangularized                   DGECO.392
c                                                                                DGECO.393
         if (a(l,k) .eq. 0.0e0) go to 40                                         DGECO.394
c                                                                                DGECO.395
c           interchange if necessary                                             DGECO.396
c                                                                                DGECO.397
            if (l .eq. k) go to 10                                               DGECO.398
               t = a(l,k)                                                        DGECO.399
               a(l,k) = a(k,k)                                                   DGECO.400
               a(k,k) = t                                                        DGECO.401
   10       continue                                                             DGECO.402
c                                                                                DGECO.403
c           compute multipliers                                                  DGECO.404
c                                                                                DGECO.405
            t = -1.0e0/a(k,k)                                                    DGECO.406
            call sscal(n-k,t,a(k+1,k),1)                                         DGECO.407
c                                                                                DGECO.408
c           row elimination with column indexing                                 DGECO.409
c                                                                                DGECO.410
            do 30 j = kp1, n                                                     DGECO.411
               t = a(l,j)                                                        DGECO.412
               if (l .eq. k) go to 20                                            DGECO.413
                  a(l,j) = a(k,j)                                                DGECO.414
                  a(k,j) = t                                                     DGECO.415
   20          continue                                                          DGECO.416
               call saxpy(n-k,t,a(k+1,k),1,a(k+1,j),1)                           DGECO.417
   30       continue                                                             DGECO.418
         go to 50                                                                DGECO.419
   40    continue                                                                DGECO.420
            info = k                                                             DGECO.421
   50    continue                                                                DGECO.422
   60 continue                                                                   DGECO.423
   70 continue                                                                   DGECO.424
      ipvt(n) = n                                                                DGECO.425
      if (a(n,n) .eq. 0.0e0) info = n                                            DGECO.426
      return                                                                     DGECO.427
      end                                                                        DGECO.428
      integer function isamax(n,sx,incx)                                         DGECO.429
c                                                                                DGECO.430
c     finds the index of element having max. absolute value.                     DGECO.431
c     jack dongarra, linpack, 3/11/78.                                           DGECO.432
c     modified 3/93 to return if incx .le. 0.                                    DGECO.433
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.434
c                                                                                DGECO.435
      real sx(*),smax                                                            DGECO.436
      integer i,incx,ix,n                                                        DGECO.437
c                                                                                DGECO.438
      isamax = 0                                                                 DGECO.439
      if( n.lt.1 .or. incx.le.0 ) return                                         DGECO.440
      isamax = 1                                                                 DGECO.441
      if(n.eq.1)return                                                           DGECO.442
      if(incx.eq.1)go to 20                                                      DGECO.443
c                                                                                DGECO.444
c        code for increment not equal to 1                                       DGECO.445
c                                                                                DGECO.446
      ix = 1                                                                     DGECO.447
      smax = abs(sx(1))                                                          DGECO.448
      ix = ix + incx                                                             DGECO.449
      do 10 i = 2,n                                                              DGECO.450
         if(abs(sx(ix)).le.smax) go to 5                                         DGECO.451
         isamax = i                                                              DGECO.452
         smax = abs(sx(ix))                                                      DGECO.453
    5    ix = ix + incx                                                          DGECO.454
   10 continue                                                                   DGECO.455
      return                                                                     DGECO.456
c                                                                                DGECO.457
c        code for increment equal to 1                                           DGECO.458
c                                                                                DGECO.459
   20 smax = abs(sx(1))                                                          DGECO.460
      do 30 i = 2,n                                                              DGECO.461
         if(abs(sx(i)).le.smax) go to 30                                         DGECO.462
         isamax = i                                                              DGECO.463
         smax = abs(sx(i))                                                       DGECO.464
   30 continue                                                                   DGECO.465
      return                                                                     DGECO.466
      end                                                                        DGECO.467
      real function sasum(n,sx,incx)                                             DGECO.468
c                                                                                DGECO.469
c     takes the sum of the absolute values.                                      DGECO.470
c     uses unrolled loops for increment equal to one.                            DGECO.471
c     jack dongarra, linpack, 3/11/78.                                           DGECO.472
c     modified 3/93 to return if incx .le. 0.                                    DGECO.473
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.474
c                                                                                DGECO.475
      real sx(*),stemp                                                           DGECO.476
      integer i,incx,m,mp1,n,nincx                                               DGECO.477
c                                                                                DGECO.478
      sasum = 0.0e0                                                              DGECO.479
      stemp = 0.0e0                                                              DGECO.480
      if( n.le.0 .or. incx.le.0 )return                                          DGECO.481
      if(incx.eq.1)go to 20                                                      DGECO.482
c                                                                                DGECO.483
c        code for increment not equal to 1                                       DGECO.484
c                                                                                DGECO.485
      nincx = n*incx                                                             DGECO.486
      do 10 i = 1,nincx,incx                                                     DGECO.487
        stemp = stemp + abs(sx(i))                                               DGECO.488
   10 continue                                                                   DGECO.489
      sasum = stemp                                                              DGECO.490
      return                                                                     DGECO.491
c                                                                                DGECO.492
c        code for increment equal to 1                                           DGECO.493
c                                                                                DGECO.494
c                                                                                DGECO.495
c        clean-up loop                                                           DGECO.496
c                                                                                DGECO.497
   20 m = mod(n,6)                                                               DGECO.498
      if( m .eq. 0 ) go to 40                                                    DGECO.499
      do 30 i = 1,m                                                              DGECO.500
        stemp = stemp + abs(sx(i))                                               DGECO.501
   30 continue                                                                   DGECO.502
      if( n .lt. 6 ) go to 60                                                    DGECO.503
   40 mp1 = m + 1                                                                DGECO.504
      do 50 i = mp1,n,6                                                          DGECO.505
        stemp = stemp + abs(sx(i)) + abs(sx(i + 1)) + abs(sx(i + 2))             DGECO.506
     *  + abs(sx(i + 3)) + abs(sx(i + 4)) + abs(sx(i + 5))                       DGECO.507
   50 continue                                                                   DGECO.508
   60 sasum = stemp                                                              DGECO.509
      return                                                                     DGECO.510
      end                                                                        DGECO.511
      subroutine saxpy(n,sa,sx,incx,sy,incy)                                     DGECO.512
c                                                                                DGECO.513
c     constant times a vector plus a vector.                                     DGECO.514
c     uses unrolled loop for increments equal to one.                            DGECO.515
c     jack dongarra, linpack, 3/11/78.                                           DGECO.516
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.517
c                                                                                DGECO.518
      real sx(*),sy(*),sa                                                        DGECO.519
      integer i,incx,incy,ix,iy,m,mp1,n                                          DGECO.520
c                                                                                DGECO.521
      if(n.le.0)return                                                           DGECO.522
      if (sa .eq. 0.0) return                                                    DGECO.523
      if(incx.eq.1.and.incy.eq.1)go to 20                                        DGECO.524
c                                                                                DGECO.525
c        code for unequal increments or equal increments                         DGECO.526
c          not equal to 1                                                        DGECO.527
c                                                                                DGECO.528
      ix = 1                                                                     DGECO.529
      iy = 1                                                                     DGECO.530
      if(incx.lt.0)ix = (-n+1)*incx + 1                                          DGECO.531
      if(incy.lt.0)iy = (-n+1)*incy + 1                                          DGECO.532
      do 10 i = 1,n                                                              DGECO.533
        sy(iy) = sy(iy) + sa*sx(ix)                                              DGECO.534
        ix = ix + incx                                                           DGECO.535
        iy = iy + incy                                                           DGECO.536
   10 continue                                                                   DGECO.537
      return                                                                     DGECO.538
c                                                                                DGECO.539
c        code for both increments equal to 1                                     DGECO.540
c                                                                                DGECO.541
c                                                                                DGECO.542
c        clean-up loop                                                           DGECO.543
c                                                                                DGECO.544
   20 m = mod(n,4)                                                               DGECO.545
      if( m .eq. 0 ) go to 40                                                    DGECO.546
      do 30 i = 1,m                                                              DGECO.547
        sy(i) = sy(i) + sa*sx(i)                                                 DGECO.548
   30 continue                                                                   DGECO.549
      if( n .lt. 4 ) return                                                      DGECO.550
   40 mp1 = m + 1                                                                DGECO.551
      do 50 i = mp1,n,4                                                          DGECO.552
        sy(i) = sy(i) + sa*sx(i)                                                 DGECO.553
        sy(i + 1) = sy(i + 1) + sa*sx(i + 1)                                     DGECO.554
        sy(i + 2) = sy(i + 2) + sa*sx(i + 2)                                     DGECO.555
        sy(i + 3) = sy(i + 3) + sa*sx(i + 3)                                     DGECO.556
   50 continue                                                                   DGECO.557
      return                                                                     DGECO.558
      end                                                                        DGECO.559
      real function sdot(n,sx,incx,sy,incy)                                      DGECO.560
c                                                                                DGECO.561
c     forms the dot product of two vectors.                                      DGECO.562
c     uses unrolled loops for increments equal to one.                           DGECO.563
c     jack dongarra, linpack, 3/11/78.                                           DGECO.564
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.565
c                                                                                DGECO.566
      real sx(*),sy(*),stemp                                                     DGECO.567
      integer i,incx,incy,ix,iy,m,mp1,n                                          DGECO.568
c                                                                                DGECO.569
      stemp = 0.0e0                                                              DGECO.570
      sdot = 0.0e0                                                               DGECO.571
      if(n.le.0)return                                                           DGECO.572
      if(incx.eq.1.and.incy.eq.1)go to 20                                        DGECO.573
c                                                                                DGECO.574
c        code for unequal increments or equal increments                         DGECO.575
c          not equal to 1                                                        DGECO.576
c                                                                                DGECO.577
      ix = 1                                                                     DGECO.578
      iy = 1                                                                     DGECO.579
      if(incx.lt.0)ix = (-n+1)*incx + 1                                          DGECO.580
      if(incy.lt.0)iy = (-n+1)*incy + 1                                          DGECO.581
      do 10 i = 1,n                                                              DGECO.582
        stemp = stemp + sx(ix)*sy(iy)                                            DGECO.583
        ix = ix + incx                                                           DGECO.584
        iy = iy + incy                                                           DGECO.585
   10 continue                                                                   DGECO.586
      sdot = stemp                                                               DGECO.587
      return                                                                     DGECO.588
c                                                                                DGECO.589
c        code for both increments equal to 1                                     DGECO.590
c                                                                                DGECO.591
c                                                                                DGECO.592
c        clean-up loop                                                           DGECO.593
c                                                                                DGECO.594
   20 m = mod(n,5)                                                               DGECO.595
      if( m .eq. 0 ) go to 40                                                    DGECO.596
      do 30 i = 1,m                                                              DGECO.597
        stemp = stemp + sx(i)*sy(i)                                              DGECO.598
   30 continue                                                                   DGECO.599
      if( n .lt. 5 ) go to 60                                                    DGECO.600
   40 mp1 = m + 1                                                                DGECO.601
      do 50 i = mp1,n,5                                                          DGECO.602
        stemp = stemp + sx(i)*sy(i) + sx(i + 1)*sy(i + 1) +                      DGECO.603
     *   sx(i + 2)*sy(i + 2) + sx(i + 3)*sy(i + 3) + sx(i + 4)*sy(i + 4)         DGECO.604
   50 continue                                                                   DGECO.605
   60 sdot = stemp                                                               DGECO.606
      return                                                                     DGECO.607
      end                                                                        DGECO.608
      subroutine sscal(n,sa,sx,incx)                                             DGECO.609
c                                                                                DGECO.610
c     scales a vector by a constant.                                             DGECO.611
c     uses unrolled loops for increment equal to 1.                              DGECO.612
c     jack dongarra, linpack, 3/11/78.                                           DGECO.613
c     modified 3/93 to return if incx .le. 0.                                    DGECO.614
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.615
c                                                                                DGECO.616
      real sa,sx(*)                                                              DGECO.617
      integer i,incx,m,mp1,n,nincx                                               DGECO.618
c                                                                                DGECO.619
      if( n.le.0 .or. incx.le.0 )return                                          DGECO.620
      if(incx.eq.1)go to 20                                                      DGECO.621
c                                                                                DGECO.622
c        code for increment not equal to 1                                       DGECO.623
c                                                                                DGECO.624
      nincx = n*incx                                                             DGECO.625
      do 10 i = 1,nincx,incx                                                     DGECO.626
        sx(i) = sa*sx(i)                                                         DGECO.627
   10 continue                                                                   DGECO.628
      return                                                                     DGECO.629
c                                                                                DGECO.630
c        code for increment equal to 1                                           DGECO.631
c                                                                                DGECO.632
c                                                                                DGECO.633
c        clean-up loop                                                           DGECO.634
c                                                                                DGECO.635
   20 m = mod(n,5)                                                               DGECO.636
      if( m .eq. 0 ) go to 40                                                    DGECO.637
      do 30 i = 1,m                                                              DGECO.638
        sx(i) = sa*sx(i)                                                         DGECO.639
   30 continue                                                                   DGECO.640
      if( n .lt. 5 ) return                                                      DGECO.641
   40 mp1 = m + 1                                                                DGECO.642
      do 50 i = mp1,n,5                                                          DGECO.643
        sx(i) = sa*sx(i)                                                         DGECO.644
        sx(i + 1) = sa*sx(i + 1)                                                 DGECO.645
        sx(i + 2) = sa*sx(i + 2)                                                 DGECO.646
        sx(i + 3) = sa*sx(i + 3)                                                 DGECO.647
        sx(i + 4) = sa*sx(i + 4)                                                 DGECO.648
   50 continue                                                                   DGECO.649
      return                                                                     DGECO.650
      end                                                                        DGECO.651
      subroutine sswap (n,sx,incx,sy,incy)                                       DGECO.652
c                                                                                DGECO.653
c     interchanges two vectors.                                                  DGECO.654
c     uses unrolled loops for increments equal to 1.                             DGECO.655
c     jack dongarra, linpack, 3/11/78.                                           DGECO.656
c     modified 12/3/93, array(1) declarations changed to array(*)                DGECO.657
c                                                                                DGECO.658
      real sx(*),sy(*),stemp                                                     DGECO.659
      integer i,incx,incy,ix,iy,m,mp1,n                                          DGECO.660
c                                                                                DGECO.661
      if(n.le.0)return                                                           DGECO.662
      if(incx.eq.1.and.incy.eq.1)go to 20                                        DGECO.663
c                                                                                DGECO.664
c       code for unequal increments or equal increments not equal                DGECO.665
c         to 1                                                                   DGECO.666
c                                                                                DGECO.667
      ix = 1                                                                     DGECO.668
      iy = 1                                                                     DGECO.669
      if(incx.lt.0)ix = (-n+1)*incx + 1                                          DGECO.670
      if(incy.lt.0)iy = (-n+1)*incy + 1                                          DGECO.671
      do 10 i = 1,n                                                              DGECO.672
        stemp = sx(ix)                                                           DGECO.673
        sx(ix) = sy(iy)                                                          DGECO.674
        sy(iy) = stemp                                                           DGECO.675
        ix = ix + incx                                                           DGECO.676
        iy = iy + incy                                                           DGECO.677
   10 continue                                                                   DGECO.678
      return                                                                     DGECO.679
c                                                                                DGECO.680
c       code for both increments equal to 1                                      DGECO.681
c                                                                                DGECO.682
c                                                                                DGECO.683
c       clean-up loop                                                            DGECO.684
c                                                                                DGECO.685
   20 m = mod(n,3)                                                               DGECO.686
      if( m .eq. 0 ) go to 40                                                    DGECO.687
      do 30 i = 1,m                                                              DGECO.688
        stemp = sx(i)                                                            DGECO.689
        sx(i) = sy(i)                                                            DGECO.690
        sy(i) = stemp                                                            DGECO.691
   30 continue                                                                   DGECO.692
      if( n .lt. 3 ) return                                                      DGECO.693
   40 mp1 = m + 1                                                                DGECO.694
      do 50 i = mp1,n,3                                                          DGECO.695
        stemp = sx(i)                                                            DGECO.696
        sx(i) = sy(i)                                                            DGECO.697
        sy(i) = stemp                                                            DGECO.698
        stemp = sx(i + 1)                                                        DGECO.699
        sx(i + 1) = sy(i + 1)                                                    DGECO.700
        sy(i + 1) = stemp                                                        DGECO.701
        stemp = sx(i + 2)                                                        DGECO.702
        sx(i + 2) = sy(i + 2)                                                    DGECO.703
        sy(i + 2) = stemp                                                        DGECO.704
   50 continue                                                                   DGECO.705
      return                                                                     DGECO.706
      end                                                                        DGECO.707
