C-----------------------------------------------------------------------         GBYTESYS.1
C       Choice of computers                                                      GBYTESYS.2
C-----------------------------------------------------------------------         GBYTESYS.3
C                                                                                GBYTESYS.4
C                 CRAY XMP,YMP/UNICOS       (#define CRAY)                       GBYTESYS.5
C                 VAX/VMS                   (#define VAX)                        GBYTESYS.6
C                 Stardent 1500/3000/UNIX   (#define STARDENT)                   GBYTESYS.7
C                 IBM RS/6000-AIX           (#define IBM)                        GBYTESYS.8
C                 SUN Sparcstation          (#define SUN)                        GBYTESYS.9
C                 SGI Silicon Graphics      (#define SGI)                        GBYTESYS.10
C                 HP 7xx                    (#define HP)                         GBYTESYS.11
C                 DEC ALPHA                 (#define ALPHA)                      GBYTESYS.12
C +------------------------------------------------------------------+           GBYTESYS.13
C _                     SYSTEM DEPENDENT ROUTINES                    _           GBYTESYS.14
C _                                                                  _           GBYTESYS.15
C _    This module contains short utility routines that are not      _           GBYTESYS.16
C _ of the FORTRAN 77 standard and may differ from system to system. _           GBYTESYS.17
C _ These include bit manipulation, I/O, JCL calls, and vector       _           GBYTESYS.18
C _ functions.                                                       _           GBYTESYS.19
C +------------------------------------------------------------------+           GBYTESYS.20
C +------------------------------------------------------------------+           GBYTESYS.21
C                                                                                GBYTESYS.22
C          DATA SET UTILITY    AT LEVEL 003 AS OF 02/25/92                       GBYTESYS.23
      SUBROUTINE GBYTE(IN,IOUT,ISKIP,NBYTE)                                      GBYTESYS.24
C                                                                                GBYTESYS.25
C THIS PROGRAM WRITTEN BY.....                                                   GBYTESYS.26
C             DR. ROBERT C. GAMMILL, CONSULTANT                                  GBYTESYS.27
C             NATIONAL CENTER FOR ATMOSPHERIC RESEARCH                           GBYTESYS.28
C             MAY 1972                                                           GBYTESYS.29
C                                                                                GBYTESYS.30
C             CHANGES FOR CRAY Y-MP8/832                                         GBYTESYS.31
C             CRAY CFT77 FORTRAN                                                 GBYTESYS.32
C             JULY 1992, RUSSELL E. JONES                                        GBYTESYS.33
C             NATIONAL WEATHER SERVICE                                           GBYTESYS.34
C                                                                                GBYTESYS.35
C THIS IS THE FORTRAN VERSION OF GBYTE                                           GBYTESYS.36
C                                                                                GBYTESYS.37
      INTEGER    IN(*)                                                           GBYTESYS.38
      INTEGER    IOUT                                                            GBYTESYS.39
#if defined (CRAY) || defined (BIT64)
      INTEGER    MASKS(64)                                                       GBYTESYS.41
C                                                                                GBYTESYS.42
      DATA  NBITSW/64/                                                           GBYTESYS.43
C                                                                                GBYTESYS.44
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 64 BIT                GBYTESYS.45
C     COMPUTER                                                                   GBYTESYS.46
C                                                                                GBYTESYS.47
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.48
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.49
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.50
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.51
     & 2147483647, 4294967295, 8589934591, 17179869183,                          GBYTESYS.52
     & 34359738367, 68719476735, 137438953471, 274877906943,                     GBYTESYS.53
     & 549755813887, 1099511627775, 2199023255551, 4398046511103,                GBYTESYS.54
     & 8796093022207, 17592186044415, 35184372088831,                            GBYTESYS.55
     & 70368744177663, 140737488355327, 281474976710655,                         GBYTESYS.56
     & 562949953421311, 1125899906842623, 2251799813685247,                      GBYTESYS.57
     & 4503599627370495, 9007199254740991, 18014398509481983,                    GBYTESYS.58
     & 36028797018963967, 72057594037927935, 144115188075855871,                 GBYTESYS.59
     & 288230376151711743, 576460752303423487, 1152921504606846975,              GBYTESYS.60
     & 2305843009213693951, 4611686018427387903, 9223372036854775807,            GBYTESYS.61
     & -1/                                                                       GBYTESYS.62
#else                                                                            GBYTESYS.63
      INTEGER    MASKS(32)                                                       GBYTESYS.64
C                                                                                GBYTESYS.65
      DATA  NBITSW/32/                                                           GBYTESYS.66
C                                                                                GBYTESYS.67
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 32 BIT                GBYTESYS.68
C     COMPUTER                                                                   GBYTESYS.69
C                                                                                GBYTESYS.70
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.71
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.72
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.73
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.74
     & 2147483647, -1/                                                           GBYTESYS.75
#endif                                                                           GBYTESYS.76
C                                                                                GBYTESYS.77
C NBYTE MUST BE LESS THAN OR EQUAL TO NBITSW                                     GBYTESYS.78
C                                                                                GBYTESYS.79
      ICON   = NBITSW - NBYTE                                                    GBYTESYS.80
      IF (ICON.LT.0) RETURN                                                      GBYTESYS.81
      MASK   = MASKS(NBYTE)                                                      GBYTESYS.82
C                                                                                GBYTESYS.83
C INDEX TELLS HOW MANY WORDS INTO THE ARRAY 'IN' THE NEXT BYTE APPEARS.          GBYTESYS.84
C                                                                                GBYTESYS.85
      INDEX  = ISKIP / NBITSW                                                    GBYTESYS.86
C                                                                                GBYTESYS.87
C II TELLS HOW MANY BITS THE BYTE IS FROM THE LEFT SIDE OF THE WORD.             GBYTESYS.88
C                                                                                GBYTESYS.89
      II     = MOD(ISKIP,NBITSW)                                                 GBYTESYS.90
C                                                                                GBYTESYS.91
C MOVER SPECIFIES HOW FAR TO THE RIGHT NBYTE MUST BE MOVED IN ORDER              GBYTESYS.92
C                                                                                GBYTESYS.93
C    TO BE RIGHT ADJUSTED.                                                       GBYTESYS.94
C                                                                                GBYTESYS.95
      MOVER = ICON - II                                                          GBYTESYS.96
C                                                                                GBYTESYS.97
      IF (MOVER.GT.0) THEN                                                       GBYTESYS.98
        IOUT  = IAND(ISHFT(IN(INDEX+1),-MOVER),MASK)                             GBYTESYS.99
C                                                                                GBYTESYS.100
C THE BYTE IS SPLIT ACROSS A WORD BREAK.                                         GBYTESYS.101
C                                                                                GBYTESYS.102
      ELSE IF (MOVER.LT.0) THEN                                                  GBYTESYS.103
#if defined (DEC) && defined (BIT64)
        MOVEL = MOVER                                                            GBYTESYS.105
        MOVER = -(NBITSW + MOVER)                                                GBYTESYS.106
#else                                                                            GBYTESYS.107
        MOVEL = - MOVER                                                          GBYTESYS.108
        MOVER = NBITSW - MOVEL                                                   GBYTESYS.109
#endif                                                                           GBYTESYS.110
        IOUT  = IAND(IOR(ISHFT(IN(INDEX+1), MOVEL),                              GBYTESYS.111
     &                   ISHFT(IN(INDEX+2),-MOVER)),MASK)                        GBYTESYS.112
C                                                                                GBYTESYS.113
C THE BYTE IS ALREADY RIGHT ADJUSTED.                                            GBYTESYS.114
C                                                                                GBYTESYS.115
      ELSE                                                                       GBYTESYS.116
        IOUT  = IAND(IN(INDEX+1),MASK)                                           GBYTESYS.117
      ENDIF                                                                      GBYTESYS.118
C                                                                                GBYTESYS.119
      RETURN                                                                     GBYTESYS.120
      END                                                                        GBYTESYS.121
C                                                                                GBYTESYS.122
C +------------------------------------------------------------------+           GBYTESYS.123
      SUBROUTINE GBYTES(IN,IOUT,ISKIP,NBYTE,NSKIP,N)                             GBYTESYS.124
CDIR$ INTEGER=64                                                                 GBYTESYS.125
C                                                                                GBYTESYS.126
C THIS PROGRAM WRITTEN BY.....                                                   GBYTESYS.127
C             DR. ROBERT C. GAMMILL, CONSULTANT                                  GBYTESYS.128
C             NATIONAL CENTER FOR ATMOSPHERIC RESEARCH                           GBYTESYS.129
C             MAY 1972                                                           GBYTESYS.130
C                                                                                GBYTESYS.131
C             CHANGES FOR CRAY Y-MP8/832                                         GBYTESYS.132
C             CRAY CFT77 FORTRAN                                                 GBYTESYS.133
C             JULY 1992, RUSSELL E. JONES                                        GBYTESYS.134
C             NATIONAL WEATHER SERVICE                                           GBYTESYS.135
C                                                                                GBYTESYS.136
C THIS IS THE FORTRAN VERSION OF GBYTES.                                         GBYTESYS.137
C                                                                                GBYTESYS.138
      INTEGER    IN(*)                                                           GBYTESYS.139
      INTEGER    IOUT(*)                                                         GBYTESYS.140
#if defined (CRAY) || defined (BIT64)
      INTEGER    MASKS(64)                                                       GBYTESYS.142
C                                                                                GBYTESYS.143
      DATA  NBITSW/64/                                                           GBYTESYS.144
C                                                                                GBYTESYS.145
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 64 BIT                GBYTESYS.146
C     COMPUTER                                                                   GBYTESYS.147
C                                                                                GBYTESYS.148
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.149
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.150
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.151
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.152
     & 2147483647, 4294967295, 8589934591, 17179869183,                          GBYTESYS.153
     & 34359738367, 68719476735, 137438953471, 274877906943,                     GBYTESYS.154
     & 549755813887, 1099511627775, 2199023255551, 4398046511103,                GBYTESYS.155
     & 8796093022207, 17592186044415, 35184372088831,                            GBYTESYS.156
     & 70368744177663, 140737488355327, 281474976710655,                         GBYTESYS.157
     & 562949953421311, 1125899906842623, 2251799813685247,                      GBYTESYS.158
     & 4503599627370495, 9007199254740991, 18014398509481983,                    GBYTESYS.159
     & 36028797018963967, 72057594037927935, 144115188075855871,                 GBYTESYS.160
     & 288230376151711743, 576460752303423487, 1152921504606846975,              GBYTESYS.161
     & 2305843009213693951, 4611686018427387903, 9223372036854775807,            GBYTESYS.162
     & -1/                                                                       GBYTESYS.163
#else                                                                            GBYTESYS.164
      INTEGER    MASKS(32)                                                       GBYTESYS.165
C                                                                                GBYTESYS.166
      DATA  NBITSW/32/                                                           GBYTESYS.167
C                                                                                GBYTESYS.168
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 32 BIT                GBYTESYS.169
C     COMPUTER                                                                   GBYTESYS.170
C                                                                                GBYTESYS.171
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.172
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.173
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.174
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.175
     & 2147483647, -1/                                                           GBYTESYS.176
#endif                                                                           GBYTESYS.177
C                                                                                GBYTESYS.178
C NBYTE MUST BE LESS THAN OR EQUAL TO NBITSW                                     GBYTESYS.179
C                                                                                GBYTESYS.180
      ICON   = NBITSW - NBYTE                                                    GBYTESYS.181
      IF (ICON.LT.0) RETURN                                                      GBYTESYS.182
      MASK   = MASKS(NBYTE)                                                      GBYTESYS.183
C                                                                                GBYTESYS.184
C INDEX TELLS HOW MANY WORDS INTO THE ARRAY 'IN' THE NEXT BYTE APPEARS.          GBYTESYS.185
C                                                                                GBYTESYS.186
      INDEX  = ISKIP / NBITSW                                                    GBYTESYS.187
C                                                                                GBYTESYS.188
C II TELLS HOW MANY BITS THE BYTE IS FROM THE LEFT SIDE OF THE WORD.             GBYTESYS.189
C                                                                                GBYTESYS.190
      II     = MOD(ISKIP,NBITSW)                                                 GBYTESYS.191
C                                                                                GBYTESYS.192
C ISTEP IS THE DISTANCE IN BITS FROM THE START OF ONE BYTE TO THE NEXT.          GBYTESYS.193
C                                                                                GBYTESYS.194
      ISTEP  = NBYTE + NSKIP                                                     GBYTESYS.195
C                                                                                GBYTESYS.196
C IWORDS TELLS HOW MANY WORDS TO SKIP FROM ONE BYTE TO THE NEXT.                 GBYTESYS.197
C                                                                                GBYTESYS.198
      IWORDS = ISTEP / NBITSW                                                    GBYTESYS.199
C                                                                                GBYTESYS.200
C IBITS TELLS HOW MANY BITS TO SKIP AFTER SKIPPING IWORDS.                       GBYTESYS.201
C                                                                                GBYTESYS.202
      IBITS  = MOD(ISTEP,NBITSW)                                                 GBYTESYS.203
C                                                                                GBYTESYS.204
      DO 10 I = 1,N                                                              GBYTESYS.205
C                                                                                GBYTESYS.206
C MOVER SPECIFIES HOW FAR TO THE RIGHT A BYTE MUST BE MOVED IN ORDER             GBYTESYS.207
C    TO BE RIGHT ADJUSTED.                                                       GBYTESYS.208
C                                                                                GBYTESYS.209
      MOVER = ICON - II                                                          GBYTESYS.210
                                                                                 GBYTESYS.211
#if defined (DEC)
      if (mover.ge.0) mover = II                                                 GBYTESYS.213
#endif                                                                           GBYTESYS.214
                                                                                 GBYTESYS.215
C                                                                                GBYTESYS.216
C THE BYTE IS SPLIT ACROSS A WORD BREAK.                                         GBYTESYS.217
C                                                                                GBYTESYS.218
      IF (MOVER.LT.0) THEN                                                       GBYTESYS.219
                                                                                 GBYTESYS.220
#if defined (DEC)
        MOVEL = MOVER                                                            GBYTESYS.222
        MOVER = -(NBITSW + MOVER)                                                GBYTESYS.223
#else                                                                            GBYTESYS.224
        MOVEL = - MOVER                                                          GBYTESYS.225
        MOVER = NBITSW - MOVEL                                                   GBYTESYS.226
#endif                                                                           GBYTESYS.227
                                                                                 GBYTESYS.228
        IOUT(I) = IAND(IOR(ISHFT(IN(INDEX+1),MOVEL),                             GBYTESYS.229
     &            ISHFT(IN(INDEX+2),-MOVER)),MASK)                               GBYTESYS.230
C                                                                                GBYTESYS.231
C RIGHT ADJUST THE BYTE.                                                         GBYTESYS.232
C                                                                                GBYTESYS.233
      ELSE IF (MOVER.GT.0) THEN                                                  GBYTESYS.234
        IOUT(I) = IAND(ISHFT(IN(INDEX+1),-MOVER),MASK)                           GBYTESYS.235
C                                                                                GBYTESYS.236
C THE BYTE IS ALREADY RIGHT ADJUSTED.                                            GBYTESYS.237
C                                                                                GBYTESYS.238
      ELSE                                                                       GBYTESYS.239
        IOUT(I) = IAND(IN(INDEX+1),MASK)                                         GBYTESYS.240
      ENDIF                                                                      GBYTESYS.241
C                                                                                GBYTESYS.242
C INCREMENT II AND INDEX.                                                        GBYTESYS.243
C                                                                                GBYTESYS.244
        II    = II + IBITS                                                       GBYTESYS.245
        INDEX = INDEX + IWORDS                                                   GBYTESYS.246
        IF (II.GE.NBITSW) THEN                                                   GBYTESYS.247
          II    = II - NBITSW                                                    GBYTESYS.248
          INDEX = INDEX + 1                                                      GBYTESYS.249
        ENDIF                                                                    GBYTESYS.250
C                                                                                GBYTESYS.251
   10 CONTINUE                                                                   GBYTESYS.252
        RETURN                                                                   GBYTESYS.253
      END                                                                        GBYTESYS.254
C                                                                                GBYTESYS.255
C +------------------------------------------------------------------+           GBYTESYS.256
      SUBROUTINE SBYTE(IOUT,IN,ISKIP,NBYTE)                                      GBYTESYS.257
C THIS PROGRAM WRITTEN BY.....                                                   GBYTESYS.258
C             DR. ROBERT C. GAMMILL, CONSULTANT                                  GBYTESYS.259
C             NATIONAL CENTER FOR ATMOSPHERIC RESEARCH                           GBYTESYS.260
C             JULY 1972                                                          GBYTESYS.261
C THIS IS THE FORTRAN VERSIONS OF SBYTE.                                         GBYTESYS.262
C             FORTRAN 90                                                         GBYTESYS.263
C             AUGUST 1990  RUSSELL E. JONES                                      GBYTESYS.264
C             NATIONAL WEATHER SERVICE                                           GBYTESYS.265
C                                                                                GBYTESYS.266
C USAGE:    CALL SBYTE (PCKD,UNPK,INOFST,NBIT)                                   GBYTESYS.267
C                                                                                GBYTESYS.268
C   INPUT ARGUMENT LIST:                                                         GBYTESYS.269
C     UNPK     -  NBITS OF THE RIGHT SIDE OF UNPK IS MOVED TO                    GBYTESYS.270
C                 ARRAY PCKD. INOFST BITS ARE SKIPPED OVER BEFORE                GBYTESYS.271
C                 THE DATA IS MOVED, NBITS ARE STORED.                           GBYTESYS.272
C    INOFST    -  A FULLWORD INTEGER SPECIFYING THE INITAL OFFSET                GBYTESYS.273
C                 IN BITS OF THE FIRST BYTE, COUNTED FROM THE                    GBYTESYS.274
C                 LEFTMOST BIT IN PCKD.                                          GBYTESYS.275
C    NBITS     -  A FULLWORD INTEGER SPECIFYING THE NUMBER OF BITS               GBYTESYS.276
C                 IN EACH BYTE TO BE PACKED.  LEGAL BYTE WIDTHS                  GBYTESYS.277
C                 ARE IN THE RANGE 1 - 32.                                       GBYTESYS.278
C   OUTPUT ARGUMENT LIST:                                                        GBYTESYS.279
C    PCKD      -  THE FULLWORD IN MEMORY TO WHICH PACKING IS TO                  GBYTESYS.280
C                 BEGIN STARTING AT BIT INOFST. THE INOSTAT BITS                 GBYTESYS.281
C                 ARE NOT ALTERED.                                               GBYTESYS.282
C                                                                                GBYTESYS.283
      INTEGER    IN                                                              GBYTESYS.284
      INTEGER    IOUT(*)                                                         GBYTESYS.285
#if defined (CRAY) || defined (BIT64)
      INTEGER    MASKS(64)                                                       GBYTESYS.287
C                                                                                GBYTESYS.288
      DATA  NBITSW/64/                                                           GBYTESYS.289
C                                                                                GBYTESYS.290
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 64 BIT                GBYTESYS.291
C     COMPUTER                                                                   GBYTESYS.292
C                                                                                GBYTESYS.293
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.294
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.295
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.296
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.297
     & 2147483647, 4294967295, 8589934591, 17179869183,                          GBYTESYS.298
     & 34359738367, 68719476735, 137438953471, 274877906943,                     GBYTESYS.299
     & 549755813887, 1099511627775, 2199023255551, 4398046511103,                GBYTESYS.300
     & 8796093022207, 17592186044415, 35184372088831,                            GBYTESYS.301
     & 70368744177663, 140737488355327, 281474976710655,                         GBYTESYS.302
     & 562949953421311, 1125899906842623, 2251799813685247,                      GBYTESYS.303
     & 4503599627370495, 9007199254740991, 18014398509481983,                    GBYTESYS.304
     & 36028797018963967, 72057594037927935, 144115188075855871,                 GBYTESYS.305
     & 288230376151711743, 576460752303423487, 1152921504606846975,              GBYTESYS.306
     & 2305843009213693951, 4611686018427387903, 9223372036854775807,            GBYTESYS.307
     & -1/                                                                       GBYTESYS.308
#else                                                                            GBYTESYS.309
      INTEGER    MASKS(32)                                                       GBYTESYS.310
C                                                                                GBYTESYS.311
      DATA  NBITSW/32/                                                           GBYTESYS.312
C                                                                                GBYTESYS.313
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 32 BIT                GBYTESYS.314
C     COMPUTER                                                                   GBYTESYS.315
C                                                                                GBYTESYS.316
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.317
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.318
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.319
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.320
     & 2147483647, -1/                                                           GBYTESYS.321
#endif                                                                           GBYTESYS.322
C                                                                                GBYTESYS.323
C NBYTE MUST BE LESS THAN OR EQUAL TO NBITSW                                     GBYTESYS.324
C                                                                                GBYTESYS.325
        ICON  = NBITSW - NBYTE                                                   GBYTESYS.326
        IF (ICON.LT.0) RETURN                                                    GBYTESYS.327
        MASK  = MASKS(NBYTE)                                                     GBYTESYS.328
C                                                                                GBYTESYS.329
C INDEX TELLS HOW MANY WORDS INTO IOUT THE NEXT BYTE IS TO BE STORED.            GBYTESYS.330
C                                                                                GBYTESYS.331
        INDEX = ISKIP / NBITSW                                                   GBYTESYS.332
C                                                                                GBYTESYS.333
C II TELLS HOW MANY BITS IN FROM THE LEFT SIDE OF THE WORD TO STORE IT.          GBYTESYS.334
C                                                                                GBYTESYS.335
        II    = MOD(ISKIP,NBITSW)                                                GBYTESYS.336
C                                                                                GBYTESYS.337
        J     = IAND(MASK,IN)                                                    GBYTESYS.338
        MOVEL = ICON - II                                                        GBYTESYS.339
C                                                                                GBYTESYS.340
C BYTE IS TO BE STORED IN MIDDLE OF WORD.  SHIFT LEFT.                           GBYTESYS.341
C                                                                                GBYTESYS.342
        IF (MOVEL.GT.0) THEN                                                     GBYTESYS.343
          MSK           = ISHFT(MASK,MOVEL)                                      GBYTESYS.344
          IOUT(INDEX+1) = IOR(IAND(NOT(MSK),IOUT(INDEX+1)),                      GBYTESYS.345
     &    ISHFT(J,MOVEL))                                                        GBYTESYS.346
C                                                                                GBYTESYS.347
C THE BYTE IS TO BE SPLIT ACROSS A WORD BREAK.                                   GBYTESYS.348
C                                                                                GBYTESYS.349
        ELSE IF (MOVEL.LT.0) THEN                                                GBYTESYS.350
          MSK           = MASKS(NBYTE+MOVEL)                                     GBYTESYS.351
          IOUT(INDEX+1) = IOR(IAND(NOT(MSK),IOUT(INDEX+1)),                      GBYTESYS.352
     &    ISHFT(J,MOVEL))                                                        GBYTESYS.353
          ITEMP         = IAND(MASKS(NBITSW+MOVEL),IOUT(INDEX+2))                GBYTESYS.354
          IOUT(INDEX+2) = IOR(ITEMP,ISHFT(J,NBITSW+MOVEL))                       GBYTESYS.355
C                                                                                GBYTESYS.356
C BYTE IS TO BE STORED RIGHT-ADJUSTED.                                           GBYTESYS.357
C                                                                                GBYTESYS.358
        ELSE                                                                     GBYTESYS.359
          IOUT(INDEX+1) = IOR(IAND(NOT(MASK),IOUT(INDEX+1)),J)                   GBYTESYS.360
        ENDIF                                                                    GBYTESYS.361
C                                                                                GBYTESYS.362
      RETURN                                                                     GBYTESYS.363
      END                                                                        GBYTESYS.364
C                                                                                GBYTESYS.365
C +------------------------------------------------------------------+           GBYTESYS.366
      SUBROUTINE SBYTES(IOUT,IN,ISKIP,NBYTE,NSKIP,N)                             GBYTESYS.367
C THIS PROGRAM WRITTEN BY.....                                                   GBYTESYS.368
C             DR. ROBERT C. GAMMILL, CONSULTANT                                  GBYTESYS.369
C             NATIONAL CENTER FOR ATMOSPHERIC RESEARCH                           GBYTESYS.370
C             JULY 1972                                                          GBYTESYS.371
C THIS IS THE FORTRAN VERSIONS OF SBYTES.                                        GBYTESYS.372
C                                                                                GBYTESYS.373
C             FORTRAN 90                                                         GBYTESYS.374
C             AUGUST 1990  RUSSELL E. JONES                                      GBYTESYS.375
C             NATIONAL WEATHER SERVICE                                           GBYTESYS.376
C                                                                                GBYTESYS.377
C USAGE:    CALL SBYTES (PCKD,UNPK,INOFST,NBIT, NSKIP,ITER)                      GBYTESYS.378
C                                                                                GBYTESYS.379
C   INPUT ARGUMENT LIST:                                                         GBYTESYS.380
C     UNPK     -  NBITS OF THE RIGHT SIDE OF EACH WORD OF ARRAY                  GBYTESYS.381
C                 UNPK IS MOVED TO ARRAY PCKD. INOFST BITS ARE                   GBYTESYS.382
C                 SKIPPED OVER BEFORE THE 1ST DATA IS MOVED, NBITS               GBYTESYS.383
C                 ARE STORED, NSKIP BITS ARE SKIPPED OVER, THE NEXT              GBYTESYS.384
C                 NBITS ARE MOVED,  BIT ARE SKIPPED OVER, ETC. UNTIL             GBYTESYS.385
C                 ITER GROUPS OF BITS ARE PACKED.                                GBYTESYS.386
C    INOFST    -  A FULLWORD INTEGER SPECIFYING THE INITAL OFFSET                GBYTESYS.387
C                 IN BITS OF THE FIRST BYTE, COUNTED FROM THE                    GBYTESYS.388
C                 LEFTMOST BIT IN PCKD.                                          GBYTESYS.389
C    NBITS     -  A FULLWORD INTEGER SPECIFYING THE NUMBER OF BITS               GBYTESYS.390
C                 IN EACH BYTE TO BE PACKED.  LEGAL BYTE WIDTHS                  GBYTESYS.391
C                 ARE IN THE RANGE 1 - 32.                                       GBYTESYS.392
C    NSKIP     -  A FULLWORD INTEGER SPECIFYING THE NUMBER OF BITS               GBYTESYS.393
C                 TO SKIP BETWEEN SUCCESSIVE BYTES.  ALL NON-NEGATIVE            GBYTESYS.394
C                 SKIP COUNTS ARE LEGAL.                                         GBYTESYS.395
C    ITER      -  A FULLWORD INTEGER SPECIFYING THE TOTAL NUMBER OF              GBYTESYS.396
C                 BYTES TO BE PACKED, AS CONTROLLED BY INOFST,                   GBYTESYS.397
C                 NBIT AND NSKIP ABOVE.   ALL NON-NEGATIVE ITERATION             GBYTESYS.398
C                 COUNTS ARE LEGAL.                                              GBYTESYS.399
C                                                                                GBYTESYS.400
C   OUTPUT ARGUMENT LIST:                                                        GBYTESYS.401
C    PCKD      -  THE FULLWORD IN MEMORY TO WHICH PACKING IS TO                  GBYTESYS.402
C                 BEGIN STARTING AT BIT INOFST. THE INOSTAT BITS                 GBYTESYS.403
C                 ARE NOT ALTERED. NSKIP BITS ARE NOT ALTERED.                   GBYTESYS.404
C                                                                                GBYTESYS.405
      INTEGER    IN(*)                                                           GBYTESYS.406
      INTEGER    IOUT(*)                                                         GBYTESYS.407
#if defined (CRAY) || defined (BIT64)
      INTEGER    MASKS(64)                                                       GBYTESYS.409
C                                                                                GBYTESYS.410
      DATA  NBITSW/64/                                                           GBYTESYS.411
C                                                                                GBYTESYS.412
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 64 BIT                GBYTESYS.413
C     COMPUTER                                                                   GBYTESYS.414
C                                                                                GBYTESYS.415
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.416
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.417
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.418
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.419
     & 2147483647, 4294967295, 8589934591, 17179869183,                          GBYTESYS.420
     & 34359738367, 68719476735, 137438953471, 274877906943,                     GBYTESYS.421
     & 549755813887, 1099511627775, 2199023255551, 4398046511103,                GBYTESYS.422
     & 8796093022207, 17592186044415, 35184372088831,                            GBYTESYS.423
     & 70368744177663, 140737488355327, 281474976710655,                         GBYTESYS.424
     & 562949953421311, 1125899906842623, 2251799813685247,                      GBYTESYS.425
     & 4503599627370495, 9007199254740991, 18014398509481983,                    GBYTESYS.426
     & 36028797018963967, 72057594037927935, 144115188075855871,                 GBYTESYS.427
     & 288230376151711743, 576460752303423487, 1152921504606846975,              GBYTESYS.428
     & 2305843009213693951, 4611686018427387903, 9223372036854775807,            GBYTESYS.429
     & -1/                                                                       GBYTESYS.430
#else                                                                            GBYTESYS.431
      INTEGER    MASKS(32)                                                       GBYTESYS.432
C                                                                                GBYTESYS.433
      DATA  NBITSW/32/                                                           GBYTESYS.434
C                                                                                GBYTESYS.435
C     MASKS TABLE PUT IN DECIMAL SO IT WILL COMPILE ON ANY 32 BIT                GBYTESYS.436
C     COMPUTER                                                                   GBYTESYS.437
C                                                                                GBYTESYS.438
      DATA  MASKS / 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047,              GBYTESYS.439
     & 4095, 8191, 16383, 32767, 65535, 131071, 262143, 524287,                  GBYTESYS.440
     & 1048575, 2097151, 4194303, 8388607, 16777215, 33554431,                   GBYTESYS.441
     & 67108863, 134217727, 268435455, 536870911, 1073741823,                    GBYTESYS.442
     & 2147483647, -1/                                                           GBYTESYS.443
#endif                                                                           GBYTESYS.444
C                                                                                GBYTESYS.445
C NBYTE MUST BE LESS THAN OR EQUAL TO NBITSW                                     GBYTESYS.446
C                                                                                GBYTESYS.447
      ICON = NBITSW - NBYTE                                                      GBYTESYS.448
      IF (ICON.LT.0) RETURN                                                      GBYTESYS.449
      MASK   = MASKS(NBYTE)                                                      GBYTESYS.450
C                                                                                GBYTESYS.451
C INDEX TELLS HOW MANY WORDS INTO IOUT THE NEXT BYTE IS TO BE STORED.            GBYTESYS.452
C                                                                                GBYTESYS.453
      INDEX  = ISKIP / NBITSW                                                    GBYTESYS.454
C                                                                                GBYTESYS.455
C II TELLS HOW MANY BITS IN FROM THE LEFT SIDE OF THE WORD TO STORE IT.          GBYTESYS.456
C                                                                                GBYTESYS.457
      II     = MOD(ISKIP,NBITSW)                                                 GBYTESYS.458
C                                                                                GBYTESYS.459
C ISTEP IS THE DISTANCE IN BITS FROM ONE BYTE POSITION TO THE NEXT.              GBYTESYS.460
C                                                                                GBYTESYS.461
      ISTEP  = NBYTE + NSKIP                                                     GBYTESYS.462
C                                                                                GBYTESYS.463
C IWORDS TELLS HOW MANY WORDS TO SKIP FROM ONE BYTE TO THE NEXT.                 GBYTESYS.464
C                                                                                GBYTESYS.465
      IWORDS = ISTEP / NBITSW                                                    GBYTESYS.466
C                                                                                GBYTESYS.467
C IBITS TELLS HOW MANY BITS TO SKIP AFTER SKIPPING IWORDS.                       GBYTESYS.468
C                                                                                GBYTESYS.469
      IBITS  = MOD(ISTEP,NBITSW)                                                 GBYTESYS.470
C                                                                                GBYTESYS.471
      DO 10 I = 1,N                                                              GBYTESYS.472
        J     = IAND(MASK,IN(I))                                                 GBYTESYS.473
        MOVEL = ICON - II                                                        GBYTESYS.474
C                                                                                GBYTESYS.475
C BYTE IS TO BE STORED IN MIDDLE OF WORD.  SHIFT LEFT.                           GBYTESYS.476
C                                                                                GBYTESYS.477
        IF (MOVEL.GT.0) THEN                                                     GBYTESYS.478
          MSK           = ISHFT(MASK,MOVEL)                                      GBYTESYS.479
          IOUT(INDEX+1) = IOR(IAND(NOT(MSK),IOUT(INDEX+1)),                      GBYTESYS.480
     &    ISHFT(J,MOVEL))                                                        GBYTESYS.481
C                                                                                GBYTESYS.482
C THE BYTE IS TO BE SPLIT ACROSS A WORD BREAK.                                   GBYTESYS.483
C                                                                                GBYTESYS.484
        ELSE IF (MOVEL.LT.0) THEN                                                GBYTESYS.485
          MSK           = MASKS(NBYTE+MOVEL)                                     GBYTESYS.486
          IOUT(INDEX+1) = IOR(IAND(NOT(MSK),IOUT(INDEX+1)),                      GBYTESYS.487
     &    ISHFT(J,MOVEL))                                                        GBYTESYS.488
          ITEMP         = IAND(MASKS(NBITSW+MOVEL),IOUT(INDEX+2))                GBYTESYS.489
          IOUT(INDEX+2) = IOR(ITEMP,ISHFT(J,NBITSW+MOVEL))                       GBYTESYS.490
C                                                                                GBYTESYS.491
C BYTE IS TO BE STORED RIGHT-ADJUSTED.                                           GBYTESYS.492
C                                                                                GBYTESYS.493
        ELSE                                                                     GBYTESYS.494
          IOUT(INDEX+1) = IOR(IAND(NOT(MASK),IOUT(INDEX+1)),J)                   GBYTESYS.495
        ENDIF                                                                    GBYTESYS.496
C                                                                                GBYTESYS.497
        II    = II + IBITS                                                       GBYTESYS.498
        INDEX = INDEX + IWORDS                                                   GBYTESYS.499
        IF (II.GE.NBITSW) THEN                                                   GBYTESYS.500
          II    = II - NBITSW                                                    GBYTESYS.501
          INDEX = INDEX + 1                                                      GBYTESYS.502
        ENDIF                                                                    GBYTESYS.503
C                                                                                GBYTESYS.504
10    CONTINUE                                                                   GBYTESYS.505
C                                                                                GBYTESYS.506
      RETURN                                                                     GBYTESYS.507
      END                                                                        GBYTESYS.508
