      SUBROUTINE geth_newdate (ndate, odate, idt)                                GETH_NEWDATE.1
      IMPLICIT NONE                                                              GETH_NEWDATE.2
                                                                                 GETH_NEWDATE.3
      !  From old date ('YYYY-MM-DD HH:MM:SS.ffff') and                          GETH_NEWDATE.4
      !  delta-time, compute the new date.                                       GETH_NEWDATE.5
                                                                                 GETH_NEWDATE.6
      !  on entry     -  odate  -  the old hdate.                                GETH_NEWDATE.7
      !                  idt    -  the change in time                            GETH_NEWDATE.8
                                                                                 GETH_NEWDATE.9
      !  on exit      -  ndate  -  the new hdate.                                GETH_NEWDATE.10
                                                                                 GETH_NEWDATE.11
      INTEGER idt                                                                GETH_NEWDATE.12
      CHARACTER*(*) ndate                                                        GETH_NEWDATE.13
      CHARACTER*(*) odate                                                        GETH_NEWDATE.14
                                                                                 GETH_NEWDATE.15
      !  Local Variables                                                         GETH_NEWDATE.16
                                                                                 GETH_NEWDATE.17
      !  yrold    -  indicates the year associated with "odate"                  GETH_NEWDATE.18
      !  moold    -  indicates the month associated with "odate"                 GETH_NEWDATE.19
      !  dyold    -  indicates the day associated with "odate"                   GETH_NEWDATE.20
      !  hrold    -  indicates the hour associated with "odate"                  GETH_NEWDATE.21
      !  miold    -  indicates the minute associated with "odate"                GETH_NEWDATE.22
      !  scold    -  indicates the second associated with "odate"                GETH_NEWDATE.23
                                                                                 GETH_NEWDATE.24
      !  yrnew    -  indicates the year associated with "ndate"                  GETH_NEWDATE.25
      !  monew    -  indicates the month associated with "ndate"                 GETH_NEWDATE.26
      !  dynew    -  indicates the day associated with "ndate"                   GETH_NEWDATE.27
      !  hrnew    -  indicates the hour associated with "ndate"                  GETH_NEWDATE.28
      !  minew    -  indicates the minute associated with "ndate"                GETH_NEWDATE.29
      !  scnew    -  indicates the second associated with "ndate"                GETH_NEWDATE.30
                                                                                 GETH_NEWDATE.31
      !  mday     -  a list assigning the number of days in each month           GETH_NEWDATE.32
                                                                                 GETH_NEWDATE.33
      !  i        -  loop counter                                                GETH_NEWDATE.34
      !  nday     -  the integer number of days represented by "idt"             GETH_NEWDATE.35
      !  nhour    -  the integer number of hours in "idt" after taking out       GETH_NEWDATE.36
      !              all the whole days                                          GETH_NEWDATE.37
      !  nmin     -  the integer number of minutes in "idt" after taking out     GETH_NEWDATE.38
      !              all the whole days and whole hours.                         GETH_NEWDATE.39
      !  nsec     -  the integer number of minutes in "idt" after taking out     GETH_NEWDATE.40
      !              all the whole days, whole hours, and whole minutes.         GETH_NEWDATE.41
                                                                                 GETH_NEWDATE.42
      INTEGER len, nlen, olen                                                    GETH_NEWDATE.43
      INTEGER yrnew, monew, dynew, hrnew, minew, scnew, frnew                    GETH_NEWDATE.44
      INTEGER yrold, moold, dyold, hrold, miold, scold, frold                    GETH_NEWDATE.45
      INTEGER mday(12), nday, nhour, nmin, nsec, nfrac, i, ifrc                  GETH_NEWDATE.46
      LOGICAL opass                                                              GETH_NEWDATE.47
      CHARACTER*(10) hfrc                                                        GETH_NEWDATE.48
      CHARACTER*(1) sp                                                           GETH_NEWDATE.49
      INTEGER nfeb                                                               GETH_NEWDATE.50
      EXTERNAL nfeb                                                              GETH_NEWDATE.51
                                                                                 GETH_NEWDATE.52
      !  Assign the number of days in a months                                   GETH_NEWDATE.53
                                                                                 GETH_NEWDATE.54
      mday( 1) = 31                                                              GETH_NEWDATE.55
      mday( 2) = 28                                                              GETH_NEWDATE.56
      mday( 3) = 31                                                              GETH_NEWDATE.57
      mday( 4) = 30                                                              GETH_NEWDATE.58
      mday( 5) = 31                                                              GETH_NEWDATE.59
      mday( 6) = 30                                                              GETH_NEWDATE.60
      mday( 7) = 31                                                              GETH_NEWDATE.61
      mday( 8) = 31                                                              GETH_NEWDATE.62
      mday( 9) = 30                                                              GETH_NEWDATE.63
      mday(10) = 31                                                              GETH_NEWDATE.64
      mday(11) = 30                                                              GETH_NEWDATE.65
      mday(12) = 31                                                              GETH_NEWDATE.66
                                                                                 GETH_NEWDATE.67
      !  Break down old hdate into parts                                         GETH_NEWDATE.68
                                                                                 GETH_NEWDATE.69
      hrold = 0                                                                  GETH_NEWDATE.70
      miold = 0                                                                  GETH_NEWDATE.71
      scold = 0                                                                  GETH_NEWDATE.72
      frold = 0                                                                  GETH_NEWDATE.73
      olen = LEN(odate)                                                          GETH_NEWDATE.74
      IF (olen.GE.11) THEN                                                       GETH_NEWDATE.75
         sp = odate(11:11)                                                       GETH_NEWDATE.76
      else                                                                       GETH_NEWDATE.77
         sp = ' '                                                                GETH_NEWDATE.78
      END IF                                                                     GETH_NEWDATE.79
                                                                                 GETH_NEWDATE.80
      !  Use internal READ statements to convert the CHARACTER string            GETH_NEWDATE.81
      !  date into INTEGER components.                                           GETH_NEWDATE.82
                                                                                 GETH_NEWDATE.83
      READ(odate(1:4),  '(I4)') yrold                                            GETH_NEWDATE.84
      READ(odate(6:7),  '(I2)') moold                                            GETH_NEWDATE.85
      READ(odate(9:10), '(I2)') dyold                                            GETH_NEWDATE.86
      IF (olen.GE.13) THEN                                                       GETH_NEWDATE.87
         READ(odate(12:13),'(I2)') hrold                                         GETH_NEWDATE.88
         IF (olen.GE.16) THEN                                                    GETH_NEWDATE.89
            READ(odate(15:16),'(I2)') miold                                      GETH_NEWDATE.90
            IF (olen.GE.19) THEN                                                 GETH_NEWDATE.91
               READ(odate(18:19),'(I2)') scold                                   GETH_NEWDATE.92
               IF (olen.GT.20) THEN                                              GETH_NEWDATE.93
                  READ(odate(21:olen),*) frold                                   GETH_NEWDATE.94
               END IF                                                            GETH_NEWDATE.95
            END IF                                                               GETH_NEWDATE.96
         END IF                                                                  GETH_NEWDATE.97
      END IF                                                                     GETH_NEWDATE.98
                                                                                 GETH_NEWDATE.99
      !  Set the number of days in February for that year.                       GETH_NEWDATE.100
                                                                                 GETH_NEWDATE.101
      mday(2) = nfeb(yrold)                                                      GETH_NEWDATE.102
                                                                                 GETH_NEWDATE.103
      !  Check that ODATE makes sense.                                           GETH_NEWDATE.104
                                                                                 GETH_NEWDATE.105
      opass = .TRUE.                                                             GETH_NEWDATE.106
                                                                                 GETH_NEWDATE.107
      !  Check that the month of ODATE makes sense.                              GETH_NEWDATE.108
                                                                                 GETH_NEWDATE.109
      IF ((moold.GT.12).or.(moold.LT.1)) THEN                                    GETH_NEWDATE.110
         WRITE(*,*) 'GETH_NEWDATE:  Month of ODATE = ', moold                    GETH_NEWDATE.111
         opass = .FALSE.                                                         GETH_NEWDATE.112
      END IF                                                                     GETH_NEWDATE.113
                                                                                 GETH_NEWDATE.114
      !  Check that the day of ODATE makes sense.                                GETH_NEWDATE.115
                                                                                 GETH_NEWDATE.116
      IF ((dyold.GT.mday(moold)).or.(dyold.LT.1)) THEN                           GETH_NEWDATE.117
         WRITE(*,*) 'GETH_NEWDATE:  Day of ODATE = ', dyold                      GETH_NEWDATE.118
         opass = .FALSE.                                                         GETH_NEWDATE.119
      END IF                                                                     GETH_NEWDATE.120
                                                                                 GETH_NEWDATE.121
      !  Check that the hour of ODATE makes sense.                               GETH_NEWDATE.122
                                                                                 GETH_NEWDATE.123
      IF ((hrold.GT.23).or.(hrold.LT.0)) THEN                                    GETH_NEWDATE.124
         WRITE(*,*) 'GETH_NEWDATE:  Hour of ODATE = ', hrold                     GETH_NEWDATE.125
         opass = .FALSE.                                                         GETH_NEWDATE.126
      END IF                                                                     GETH_NEWDATE.127
                                                                                 GETH_NEWDATE.128
      !  Check that the minute of ODATE makes sense.                             GETH_NEWDATE.129
                                                                                 GETH_NEWDATE.130
      IF ((miold.GT.59).or.(miold.LT.0)) THEN                                    GETH_NEWDATE.131
         WRITE(*,*) 'GETH_NEWDATE:  Minute of ODATE = ', miold                   GETH_NEWDATE.132
         opass = .FALSE.                                                         GETH_NEWDATE.133
      END IF                                                                     GETH_NEWDATE.134
                                                                                 GETH_NEWDATE.135
      !  Check that the second of ODATE makes sense.                             GETH_NEWDATE.136
                                                                                 GETH_NEWDATE.137
      IF ((scold.GT.59).or.(scold.LT.0)) THEN                                    GETH_NEWDATE.138
         WRITE(*,*) 'GETH_NEWDATE:  Second of ODATE = ', scold                   GETH_NEWDATE.139
         opass = .FALSE.                                                         GETH_NEWDATE.140
      END IF                                                                     GETH_NEWDATE.141
                                                                                 GETH_NEWDATE.142
      !  Check that the fractional part  of ODATE makes sense.                   GETH_NEWDATE.143
                                                                                 GETH_NEWDATE.144
                                                                                 GETH_NEWDATE.145
      IF (.not.opass) THEN                                                       GETH_NEWDATE.146
         WRITE(*,*) 'Crazy ODATE: ', odate(1:olen), olen                         GETH_NEWDATE.147
         CALL ABORT()                                                            GETH_NEWDATE.148
      END IF                                                                     GETH_NEWDATE.149
                                                                                 GETH_NEWDATE.150
      !  Date Checks are completed.  Continue.                                   GETH_NEWDATE.151
                                                                                 GETH_NEWDATE.152
                                                                                 GETH_NEWDATE.153
      !  Compute the number of days, hours, minutes, and seconds in idt          GETH_NEWDATE.154
                                                                                 GETH_NEWDATE.155
      IF (olen.GT.20) THEN !idt should be in fractions of seconds                GETH_NEWDATE.156
         ifrc = olen-20                                                          GETH_NEWDATE.157
         ifrc = 10**ifrc                                                         GETH_NEWDATE.158
         nday   = ABS(idt)/(86400*ifrc)                                          GETH_NEWDATE.159
         nhour  = MOD(ABS(idt),86400*ifrc)/(3600*ifrc)                           GETH_NEWDATE.160
         nmin   = MOD(ABS(idt),3600*ifrc)/(60*ifrc)                              GETH_NEWDATE.161
         nsec   = MOD(ABS(idt),60*ifrc)/(ifrc)                                   GETH_NEWDATE.162
         nfrac = MOD(ABS(idt), ifrc)                                             GETH_NEWDATE.163
      ELSE IF (olen.eq.19) THEN  !idt should be in seconds                       GETH_NEWDATE.164
         ifrc = 1                                                                GETH_NEWDATE.165
         nday   = ABS(idt)/86400 ! Integer number of days in delta-time          GETH_NEWDATE.166
         nhour  = MOD(ABS(idt),86400)/3600                                       GETH_NEWDATE.167
         nmin   = MOD(ABS(idt),3600)/60                                          GETH_NEWDATE.168
         nsec   = MOD(ABS(idt),60)                                               GETH_NEWDATE.169
         nfrac  = 0                                                              GETH_NEWDATE.170
      ELSE IF (olen.eq.16) THEN !idt should be in minutes                        GETH_NEWDATE.171
         ifrc = 1                                                                GETH_NEWDATE.172
         nday   = ABS(idt)/1440 ! Integer number of days in delta-time           GETH_NEWDATE.173
         nhour  = MOD(ABS(idt),1440)/60                                          GETH_NEWDATE.174
         nmin   = MOD(ABS(idt),60)                                               GETH_NEWDATE.175
         nsec   = 0                                                              GETH_NEWDATE.176
         nfrac  = 0                                                              GETH_NEWDATE.177
      ELSE IF (olen.eq.13) THEN !idt should be in hours                          GETH_NEWDATE.178
         ifrc = 1                                                                GETH_NEWDATE.179
         nday   = ABS(idt)/24 ! Integer number of days in delta-time             GETH_NEWDATE.180
         nhour  = MOD(ABS(idt),24)                                               GETH_NEWDATE.181
         nmin   = 0                                                              GETH_NEWDATE.182
         nsec   = 0                                                              GETH_NEWDATE.183
         nfrac  = 0                                                              GETH_NEWDATE.184
      ELSE IF (olen.eq.10) THEN !idt should be in days                           GETH_NEWDATE.185
         ifrc = 1                                                                GETH_NEWDATE.186
         nday   = ABS(idt)    ! Integer number of days in delta-time             GETH_NEWDATE.187
         nhour  = 0                                                              GETH_NEWDATE.188
         nmin   = 0                                                              GETH_NEWDATE.189
         nsec   = 0                                                              GETH_NEWDATE.190
         nfrac  = 0                                                              GETH_NEWDATE.191
      ELSE                                                                       GETH_NEWDATE.192
         WRITE(*,'(''GETH_NEWDATE: Strange length for ODATE: '', i3)')           GETH_NEWDATE.193
     &        olen                                                               GETH_NEWDATE.194
         WRITE(*,*) odate(1:olen)                                                GETH_NEWDATE.195
         CALL abort()                                                            GETH_NEWDATE.196
      END IF                                                                     GETH_NEWDATE.197
                                                                                 GETH_NEWDATE.198
      IF (idt.GE.0) THEN                                                         GETH_NEWDATE.199
                                                                                 GETH_NEWDATE.200
         frnew = frold + nfrac                                                   GETH_NEWDATE.201
         IF (frnew.GE.ifrc) THEN                                                 GETH_NEWDATE.202
            frnew = frnew - ifrc                                                 GETH_NEWDATE.203
            nsec = nsec + 1                                                      GETH_NEWDATE.204
         END IF                                                                  GETH_NEWDATE.205
                                                                                 GETH_NEWDATE.206
         scnew = scold + nsec                                                    GETH_NEWDATE.207
         IF (scnew .GE. 60) THEN                                                 GETH_NEWDATE.208
            scnew = scnew - 60                                                   GETH_NEWDATE.209
            nmin  = nmin + 1                                                     GETH_NEWDATE.210
         END IF                                                                  GETH_NEWDATE.211
                                                                                 GETH_NEWDATE.212
         minew = miold + nmin                                                    GETH_NEWDATE.213
         IF (minew .GE. 60) THEN                                                 GETH_NEWDATE.214
            minew = minew - 60                                                   GETH_NEWDATE.215
            nhour  = nhour + 1                                                   GETH_NEWDATE.216
         END IF                                                                  GETH_NEWDATE.217
                                                                                 GETH_NEWDATE.218
         hrnew = hrold + nhour                                                   GETH_NEWDATE.219
         IF (hrnew .GE. 24) THEN                                                 GETH_NEWDATE.220
            hrnew = hrnew - 24                                                   GETH_NEWDATE.221
            nday  = nday + 1                                                     GETH_NEWDATE.222
         END IF                                                                  GETH_NEWDATE.223
                                                                                 GETH_NEWDATE.224
         dynew = dyold                                                           GETH_NEWDATE.225
         monew = moold                                                           GETH_NEWDATE.226
         yrnew = yrold                                                           GETH_NEWDATE.227
         DO i = 1, nday                                                          GETH_NEWDATE.228
            dynew = dynew + 1                                                    GETH_NEWDATE.229
            IF (dynew.GT.mday(monew)) THEN                                       GETH_NEWDATE.230
               dynew = dynew - mday(monew)                                       GETH_NEWDATE.231
               monew = monew + 1                                                 GETH_NEWDATE.232
               IF (monew .GT. 12) THEN                                           GETH_NEWDATE.233
                  monew = 1                                                      GETH_NEWDATE.234
                  yrnew = yrnew + 1                                              GETH_NEWDATE.235
                  ! If the year changes, recompute the number of days in Februar GETH_NEWDATE.236
                  mday(2) = nfeb(yrnew)                                          GETH_NEWDATE.237
               END IF                                                            GETH_NEWDATE.238
            END IF                                                               GETH_NEWDATE.239
         END DO                                                                  GETH_NEWDATE.240
                                                                                 GETH_NEWDATE.241
      ELSE IF (idt.LT.0) THEN                                                    GETH_NEWDATE.242
                                                                                 GETH_NEWDATE.243
         frnew = frold - nfrac                                                   GETH_NEWDATE.244
         IF (frnew .LT. 0) THEN                                                  GETH_NEWDATE.245
            frnew = frnew + ifrc                                                 GETH_NEWDATE.246
            nsec = nsec + 1                                                      GETH_NEWDATE.247
         END IF                                                                  GETH_NEWDATE.248
                                                                                 GETH_NEWDATE.249
         scnew = scold - nsec                                                    GETH_NEWDATE.250
         IF (scnew .LT. 00) THEN                                                 GETH_NEWDATE.251
            scnew = scnew + 60                                                   GETH_NEWDATE.252
            nmin  = nmin + 1                                                     GETH_NEWDATE.253
         END IF                                                                  GETH_NEWDATE.254
                                                                                 GETH_NEWDATE.255
         minew = miold - nmin                                                    GETH_NEWDATE.256
         IF (minew .LT. 00) THEN                                                 GETH_NEWDATE.257
            minew = minew + 60                                                   GETH_NEWDATE.258
            nhour  = nhour + 1                                                   GETH_NEWDATE.259
         END IF                                                                  GETH_NEWDATE.260
                                                                                 GETH_NEWDATE.261
         hrnew = hrold - nhour                                                   GETH_NEWDATE.262
         IF (hrnew .LT. 00) THEN                                                 GETH_NEWDATE.263
            hrnew = hrnew + 24                                                   GETH_NEWDATE.264
            nday  = nday + 1                                                     GETH_NEWDATE.265
         END IF                                                                  GETH_NEWDATE.266
                                                                                 GETH_NEWDATE.267
         dynew = dyold                                                           GETH_NEWDATE.268
         monew = moold                                                           GETH_NEWDATE.269
         yrnew = yrold                                                           GETH_NEWDATE.270
         DO i = 1, nday                                                          GETH_NEWDATE.271
            dynew = dynew - 1                                                    GETH_NEWDATE.272
            IF (dynew.eq.0) THEN                                                 GETH_NEWDATE.273
               monew = monew - 1                                                 GETH_NEWDATE.274
               IF (monew.eq.0) THEN                                              GETH_NEWDATE.275
                  monew = 12                                                     GETH_NEWDATE.276
                  yrnew = yrnew - 1                                              GETH_NEWDATE.277
                  ! If the year changes, recompute the number of days in Februar GETH_NEWDATE.278
                  mday(2) = nfeb(yrnew)                                          GETH_NEWDATE.279
               END IF                                                            GETH_NEWDATE.280
               dynew = mday(monew)                                               GETH_NEWDATE.281
            END IF                                                               GETH_NEWDATE.282
         END DO                                                                  GETH_NEWDATE.283
      END IF                                                                     GETH_NEWDATE.284
                                                                                 GETH_NEWDATE.285
      !  Now construct the new mdate                                             GETH_NEWDATE.286
                                                                                 GETH_NEWDATE.287
      nlen = LEN(ndate)                                                          GETH_NEWDATE.288
                                                                                 GETH_NEWDATE.289
      IF (nlen.GT.20) THEN                                                       GETH_NEWDATE.290
         WRITE(ndate(1:19),19) yrnew, monew, dynew, hrnew, minew, scnew          GETH_NEWDATE.291
         WRITE(hfrc,'(I10)') frnew+1000000000                                    GETH_NEWDATE.292
         ndate = ndate(1:19)//'.'//hfrc(31-nlen:10)                              GETH_NEWDATE.293
                                                                                 GETH_NEWDATE.294
      ELSE IF (nlen.eq.19.or.nlen.eq.20) THEN                                    GETH_NEWDATE.295
         WRITE(ndate(1:19),19) yrnew, monew, dynew, hrnew, minew, scnew          GETH_NEWDATE.296
 19      format(I4,'-',I2.2,'-',I2.2,'_',I2.2,':',I2.2,':',I2.2)                 GETH_NEWDATE.297
         IF (nlen.eq.20) ndate = ndate(1:19)//'.'                                GETH_NEWDATE.298
                                                                                 GETH_NEWDATE.299
      ELSE IF (nlen.eq.16) THEN                                                  GETH_NEWDATE.300
         WRITE(ndate,16) yrnew, monew, dynew, hrnew, minew                       GETH_NEWDATE.301
 16      format(I4,'-',I2.2,'-',I2.2,'_',I2.2,':',I2.2)                          GETH_NEWDATE.302
                                                                                 GETH_NEWDATE.303
      ELSE IF (nlen.eq.13) THEN                                                  GETH_NEWDATE.304
         WRITE(ndate,13) yrnew, monew, dynew, hrnew                              GETH_NEWDATE.305
 13      format(I4,'-',I2.2,'-',I2.2,'_',I2.2)                                   GETH_NEWDATE.306
                                                                                 GETH_NEWDATE.307
      ELSE IF (nlen.eq.10) THEN                                                  GETH_NEWDATE.308
         WRITE(ndate,10) yrnew, monew, dynew                                     GETH_NEWDATE.309
 10      format(I4,'-',I2.2,'-',I2.2)                                            GETH_NEWDATE.310
                                                                                 GETH_NEWDATE.311
      END IF                                                                     GETH_NEWDATE.312
                                                                                 GETH_NEWDATE.313
      IF (olen.GE.11) ndate(11:11) = sp                                          GETH_NEWDATE.314
                                                                                 GETH_NEWDATE.315
      END                                                                        GETH_NEWDATE.316
                                                                                 GETH_NEWDATE.317
                                                                                 GETH_NEWDATE.318
      INTEGER FUNCTION nfeb ( year )                                             GETH_NEWDATE.319
                                                                                 GETH_NEWDATE.320
      ! Compute the number of days in February for the given year                GETH_NEWDATE.321
                                                                                 GETH_NEWDATE.322
      IMPLICIT NONE                                                              GETH_NEWDATE.323
                                                                                 GETH_NEWDATE.324
      INTEGER year                                                               GETH_NEWDATE.325
                                                                                 GETH_NEWDATE.326
      nfeb = 28 ! By default, February has 28 days ...                           GETH_NEWDATE.327
      IF (MOD(year,4).eq.0) THEN                                                 GETH_NEWDATE.328
         nfeb = 29  ! But every four years, it has 29 days ...                   GETH_NEWDATE.329
         IF (MOD(year,100).eq.0) THEN                                            GETH_NEWDATE.330
            nfeb = 28  ! Except every 100 years, when it has 28 days ...         GETH_NEWDATE.331
            IF (MOD(year,400).eq.0) THEN                                         GETH_NEWDATE.332
               nfeb = 29  ! Except every 400 years, when it has 29 days.         GETH_NEWDATE.333
            END IF                                                               GETH_NEWDATE.334
         END IF                                                                  GETH_NEWDATE.335
      END IF                                                                     GETH_NEWDATE.336
                                                                                 GETH_NEWDATE.337
      END                                                                        GETH_NEWDATE.338
      subroutine geth_idts (ndate, odate, idts)                                  GETH_NEWDATE.339
      implicit none                                                              GETH_NEWDATE.340
                                                                                 GETH_NEWDATE.341
!***********************************************************************         GETH_NEWDATE.342
!                                                                                GETH_NEWDATE.343
!  purpose      -  from 2 input mdates ('YYYY-MM-DD HH:MM:SS'), compute          GETH_NEWDATE.344
!                  the time difference in seconds.                               GETH_NEWDATE.345
!                                                                                GETH_NEWDATE.346
!  on entry     -  ndate  -  the new hdate.                                      GETH_NEWDATE.347
!                  odate  -  the old hdate.                                      GETH_NEWDATE.348
!                                                                                GETH_NEWDATE.349
!  on exit      -  idts    -  the change in time in seconds.                     GETH_NEWDATE.350
!                                                                                GETH_NEWDATE.351
!***********************************************************************         GETH_NEWDATE.352
                                                                                 GETH_NEWDATE.353
      character*(*) ndate, odate                                                 GETH_NEWDATE.354
      character*(24) tdate                                                       GETH_NEWDATE.355
      integer idts                                                               GETH_NEWDATE.356
      integer len, olen, nlen                                                    GETH_NEWDATE.357
!                                                                                GETH_NEWDATE.358
!  Local Variables                                                               GETH_NEWDATE.359
!                                                                                GETH_NEWDATE.360
!  yrnew    -  indicates the year associated with "ndate"                        GETH_NEWDATE.361
!  yrold    -  indicates the year associated with "odate"                        GETH_NEWDATE.362
!  monew    -  indicates the month associated with "ndate"                       GETH_NEWDATE.363
!  moold    -  indicates the month associated with "odate"                       GETH_NEWDATE.364
!  dynew    -  indicates the day associated with "ndate"                         GETH_NEWDATE.365
!  dyold    -  indicates the day associated with "odate"                         GETH_NEWDATE.366
!  hrnew    -  indicates the hour associated with "ndate"                        GETH_NEWDATE.367
!  hrold    -  indicates the hour associated with "odate"                        GETH_NEWDATE.368
!  minew    -  indicates the minute associated with "ndate"                      GETH_NEWDATE.369
!  miold    -  indicates the minute associated with "odate"                      GETH_NEWDATE.370
!  scnew    -  indicates the second associated with "ndate"                      GETH_NEWDATE.371
!  scold    -  indicates the second associated with "odate"                      GETH_NEWDATE.372
!  i        -  loop counter                                                      GETH_NEWDATE.373
!  mday     -  a list assigning the number of days in each month                 GETH_NEWDATE.374
                                                                                 GETH_NEWDATE.379
      integer yrnew, monew, dynew, hrnew, minew, scnew                           GETH_NEWDATE.380
      integer yrold, moold, dyold, hrold, miold, scold                           GETH_NEWDATE.381
      integer mday(12), i, newdys, olddys                                        GETH_NEWDATE.382
      logical npass, opass                                                       GETH_NEWDATE.383
      integer isign                                                              GETH_NEWDATE.384
                                                                                 GETH_NEWDATE.385
      INTEGER nfeb
      EXTERNAL nfeb
!*************************  Subroutine Begin  **************************         GETH_NEWDATE.386
                                                                                 GETH_NEWDATE.387
      if (odate.gt.ndate) then                                                   GETH_NEWDATE.388
         isign = -1                                                              GETH_NEWDATE.389
         tdate=ndate                                                             GETH_NEWDATE.390
         ndate=odate                                                             GETH_NEWDATE.391
         odate=tdate                                                             GETH_NEWDATE.392
      else                                                                       GETH_NEWDATE.393
         isign = 1                                                               GETH_NEWDATE.394
      endif                                                                      GETH_NEWDATE.395
                                                                                 GETH_NEWDATE.396
!                                                                                GETH_NEWDATE.397
!  Assign the number of days in a months                                         GETH_NEWDATE.398
!                                                                                GETH_NEWDATE.399
                                                                                 GETH_NEWDATE.400
      mday( 1) = 31                                                              GETH_NEWDATE.401
      mday( 2) = 28                                                              GETH_NEWDATE.402
      mday( 3) = 31                                                              GETH_NEWDATE.403
      mday( 4) = 30                                                              GETH_NEWDATE.404
      mday( 5) = 31                                                              GETH_NEWDATE.405
      mday( 6) = 30                                                              GETH_NEWDATE.406
      mday( 7) = 31                                                              GETH_NEWDATE.407
      mday( 8) = 31                                                              GETH_NEWDATE.408
      mday( 9) = 30                                                              GETH_NEWDATE.409
      mday(10) = 31                                                              GETH_NEWDATE.410
      mday(11) = 30                                                              GETH_NEWDATE.411
      mday(12) = 31                                                              GETH_NEWDATE.412
                                                                                 GETH_NEWDATE.413
!                                                                                GETH_NEWDATE.414
!  Break down old hdate into parts                                               GETH_NEWDATE.415
!                                                                                GETH_NEWDATE.416
      hrold = 0                                                                  GETH_NEWDATE.417
      miold = 0                                                                  GETH_NEWDATE.418
      scold = 0                                                                  GETH_NEWDATE.419
      olen = len(odate)                                                          GETH_NEWDATE.420
                                                                                 GETH_NEWDATE.421
      read(odate(1:4),  '(I4)') yrold                                            GETH_NEWDATE.422
      read(odate(6:7),  '(I2)') moold                                            GETH_NEWDATE.423
      read(odate(9:10), '(I2)') dyold                                            GETH_NEWDATE.424
      if (olen.ge.13) then                                                       GETH_NEWDATE.425
         read(odate(12:13),'(I2)') hrold                                         GETH_NEWDATE.426
         if (olen.ge.16) then                                                    GETH_NEWDATE.427
            read(odate(15:16),'(I2)') miold                                      GETH_NEWDATE.428
            if (olen.ge.19) then                                                 GETH_NEWDATE.429
               read(odate(18:19),'(I2)') scold                                   GETH_NEWDATE.430
            endif                                                                GETH_NEWDATE.431
         endif                                                                   GETH_NEWDATE.432
      endif                                                                      GETH_NEWDATE.433
                                                                                 GETH_NEWDATE.434
!                                                                                GETH_NEWDATE.435
!  Break down new hdate into parts                                               GETH_NEWDATE.436
!                                                                                GETH_NEWDATE.437
      hrnew = 0                                                                  GETH_NEWDATE.438
      minew = 0                                                                  GETH_NEWDATE.439
      scnew = 0                                                                  GETH_NEWDATE.440
      nlen = len(ndate)                                                          GETH_NEWDATE.441
                                                                                 GETH_NEWDATE.442
      read(ndate(1:4),  '(I4)') yrnew                                            GETH_NEWDATE.443
      read(ndate(6:7),  '(I2)') monew                                            GETH_NEWDATE.444
      read(ndate(9:10), '(I2)') dynew                                            GETH_NEWDATE.445
      if (nlen.ge.13) then                                                       GETH_NEWDATE.446
         read(ndate(12:13),'(I2)') hrnew                                         GETH_NEWDATE.447
         if (nlen.ge.16) then                                                    GETH_NEWDATE.448
            read(ndate(15:16),'(I2)') minew                                      GETH_NEWDATE.449
            if (nlen.ge.19) then                                                 GETH_NEWDATE.450
               read(ndate(18:19),'(I2)') scnew                                   GETH_NEWDATE.451
            endif                                                                GETH_NEWDATE.452
         endif                                                                   GETH_NEWDATE.453
      endif                                                                      GETH_NEWDATE.454
                                                                                 GETH_NEWDATE.455
!                                                                                GETH_NEWDATE.456
!  Check that the dates make sense.                                              GETH_NEWDATE.457
!                                                                                GETH_NEWDATE.458
      npass = .true.                                                             GETH_NEWDATE.459
      opass = .true.                                                             GETH_NEWDATE.460
                                                                                 GETH_NEWDATE.461
!  Check that the month of NDATE makes sense.                                    GETH_NEWDATE.462
                                                                                 GETH_NEWDATE.463
      if ((monew.gt.12).or.(monew.lt.1)) then                                    GETH_NEWDATE.464
         print*, 'GETH_IDTS:  Month of NDATE = ', monew                          GETH_NEWDATE.465
         npass = .false.                                                         GETH_NEWDATE.466
      endif                                                                      GETH_NEWDATE.467
                                                                                 GETH_NEWDATE.468
!  Check that the month of ODATE makes sense.                                    GETH_NEWDATE.469
                                                                                 GETH_NEWDATE.470
      if ((moold.gt.12).or.(moold.lt.1)) then                                    GETH_NEWDATE.471
         print*, 'GETH_IDTS:  Month of ODATE = ', moold                          GETH_NEWDATE.472
         opass = .false.                                                         GETH_NEWDATE.473
      endif                                                                      GETH_NEWDATE.474
                                                                                 GETH_NEWDATE.475
!  Check that the day of NDATE makes sense.                                      GETH_NEWDATE.476
                                                                                 GETH_NEWDATE.477
      if (monew.ne.2) then                                                       GETH_NEWDATE.478
! ...... For all months but February                                             GETH_NEWDATE.479
         if ((dynew.gt.mday(monew)).or.(dynew.lt.1)) then                        GETH_NEWDATE.480
            print*, 'GETH_IDTS:  Day of NDATE = ', dynew                         GETH_NEWDATE.481
            npass = .false.                                                      GETH_NEWDATE.482
         endif                                                                   GETH_NEWDATE.483
      elseif (monew.eq.2) then                                                   GETH_NEWDATE.484
! ...... For February                                                            GETH_NEWDATE.485
         if ((dynew.gt.nfeb(yrnew)).or.(dynew.lt.1)) then
            print*, 'GETH_IDTS:  Day of NDATE = ', dynew                         GETH_NEWDATE.488
            npass = .false.                                                      GETH_NEWDATE.489
         endif                                                                   GETH_NEWDATE.490
      endif                                                                      GETH_NEWDATE.497
                                                                                 GETH_NEWDATE.498
!  Check that the day of ODATE makes sense.                                      GETH_NEWDATE.499
                                                                                 GETH_NEWDATE.500
      if (moold.ne.2) then                                                       GETH_NEWDATE.501
! ...... For all months but February                                             GETH_NEWDATE.502
         if ((dyold.gt.mday(moold)).or.(dyold.lt.1)) then                        GETH_NEWDATE.503
            print*, 'GETH_IDTS:  Day of ODATE = ', dyold                         GETH_NEWDATE.504
            opass = .false.                                                      GETH_NEWDATE.505
         endif                                                                   GETH_NEWDATE.506
      elseif (moold.eq.2) then                                                   GETH_NEWDATE.507
! ....... For February                                                           GETH_NEWDATE.508
         if ((dyold.gt.nfeb(yrold)).or.(dyold.lt.1)) then
            print*, 'GETH_IDTS:  Day of ODATE = ', dyold                         GETH_NEWDATE.511
            opass = .false.                                                      GETH_NEWDATE.512
         endif                                                                   GETH_NEWDATE.513
      endif                                                                      GETH_NEWDATE.520
                                                                                 GETH_NEWDATE.521
!  Check that the hour of NDATE makes sense.                                     GETH_NEWDATE.522
                                                                                 GETH_NEWDATE.523
      if ((hrnew.gt.23).or.(hrnew.lt.0)) then                                    GETH_NEWDATE.524
         print*, 'GETH_IDTS:  Hour of NDATE = ', hrnew                           GETH_NEWDATE.525
         npass = .false.                                                         GETH_NEWDATE.526
      endif                                                                      GETH_NEWDATE.527
                                                                                 GETH_NEWDATE.528
!  Check that the hour of ODATE makes sense.                                     GETH_NEWDATE.529
                                                                                 GETH_NEWDATE.530
      if ((hrold.gt.23).or.(hrold.lt.0)) then                                    GETH_NEWDATE.531
         print*, 'GETH_IDTS:  Hour of ODATE = ', hrold                           GETH_NEWDATE.532
         opass = .false.                                                         GETH_NEWDATE.533
      endif                                                                      GETH_NEWDATE.534
                                                                                 GETH_NEWDATE.535
!  Check that the minute of NDATE makes sense.                                   GETH_NEWDATE.536
                                                                                 GETH_NEWDATE.537
      if ((minew.gt.59).or.(minew.lt.0)) then                                    GETH_NEWDATE.538
         print*, 'GETH_IDTS:  Minute of NDATE = ', minew                         GETH_NEWDATE.539
         npass = .false.                                                         GETH_NEWDATE.540
      endif                                                                      GETH_NEWDATE.541
                                                                                 GETH_NEWDATE.542
!  Check that the minute of ODATE makes sense.                                   GETH_NEWDATE.543
                                                                                 GETH_NEWDATE.544
      if ((miold.gt.59).or.(miold.lt.0)) then                                    GETH_NEWDATE.545
         print*, 'GETH_IDTS:  Minute of ODATE = ', miold                         GETH_NEWDATE.546
         opass = .false.                                                         GETH_NEWDATE.547
      endif                                                                      GETH_NEWDATE.548
!                                                                                GETH_NEWDATE.549
!  Check that the second of NDATE makes sense.                                   GETH_NEWDATE.550
!                                                                                GETH_NEWDATE.551
      if ((scnew.gt.59).or.(scnew.lt.0)) then                                    GETH_NEWDATE.552
         print*, 'GETH_IDTS:  SECOND of NDATE = ', scnew                         GETH_NEWDATE.553
         npass = .false.                                                         GETH_NEWDATE.554
      endif                                                                      GETH_NEWDATE.555
                                                                                 GETH_NEWDATE.556
!  Check that the second of ODATE makes sense.                                   GETH_NEWDATE.557
                                                                                 GETH_NEWDATE.558
      if ((scold.gt.59).or.(scold.lt.0)) then                                    GETH_NEWDATE.559
         print*, 'GETH_IDTS:  Second of ODATE = ', scold                         GETH_NEWDATE.560
         opass = .false.                                                         GETH_NEWDATE.561
      endif                                                                      GETH_NEWDATE.562
                                                                                 GETH_NEWDATE.563
      if (.not. npass) then                                                      GETH_NEWDATE.564
         print*, 'Screwy NDATE: ', ndate(1:nlen)                                 GETH_NEWDATE.565
         call abort()                                                            GETH_NEWDATE.566
      endif                                                                      GETH_NEWDATE.567
                                                                                 GETH_NEWDATE.568
      if (.not. opass) then                                                      GETH_NEWDATE.569
         print*, 'Screwy ODATE: ', odate(1:olen)                                 GETH_NEWDATE.570
         call abort()                                                            GETH_NEWDATE.571
      endif                                                                      GETH_NEWDATE.572
!                                                                                GETH_NEWDATE.573
!  Date Checks are completed.  Continue.                                         GETH_NEWDATE.574
!                                                                                GETH_NEWDATE.575
                                                                                 GETH_NEWDATE.576
!                                                                                GETH_NEWDATE.577
!  Compute number of days from 1 January ODATE, 00:00:00 until ndate             GETH_NEWDATE.578
!  Compute number of hours from 1 January ODATE, 00:00:00 until ndate            GETH_NEWDATE.579
!  Compute number of minutes from 1 January ODATE, 00:00:00 until ndate          GETH_NEWDATE.580
!                                                                                GETH_NEWDATE.581
                                                                                 GETH_NEWDATE.582
      newdys = 0                                                                 GETH_NEWDATE.583
      do i = yrold, yrnew - 1                                                    GETH_NEWDATE.584
         newdys = newdys + (365 + (nfeb(i)-28))
      enddo                                                                      GETH_NEWDATE.590
                                                                                 GETH_NEWDATE.591
      if (monew .gt. 1) then                                                     GETH_NEWDATE.592
         mday(2) = nfeb(yrnew)                                                   GETH_NEWDATE.593
         do i = 1, monew - 1                                                     GETH_NEWDATE.594
            newdys = newdys + mday(i)                                            GETH_NEWDATE.595
         enddo                                                                   GETH_NEWDATE.596
         mday(2) = 28                                                            GETH_NEWDATE.597
      end if                                                                     GETH_NEWDATE.598
                                                                                 GETH_NEWDATE.599
      newdys = newdys + dynew-1                                                  GETH_NEWDATE.600
!                                                                                GETH_NEWDATE.601
!  Compute number of hours from 1 January ODATE, 00:00:00 until odate            GETH_NEWDATE.602
!  Compute number of minutes from 1 January ODATE, 00:00:00 until odate          GETH_NEWDATE.603
!                                                                                GETH_NEWDATE.604
                                                                                 GETH_NEWDATE.605
      olddys = 0                                                                 GETH_NEWDATE.606
                                                                                 GETH_NEWDATE.607
      if (moold .gt. 1) then                                                     GETH_NEWDATE.608
         mday(2) = nfeb(yrold)                                                   GETH_NEWDATE.609
         do i = 1, moold - 1                                                     GETH_NEWDATE.610
            olddys = olddys + mday(i)                                            GETH_NEWDATE.611
         enddo                                                                   GETH_NEWDATE.612
         mday(2) = 28                                                            GETH_NEWDATE.613
      end if                                                                     GETH_NEWDATE.614
                                                                                 GETH_NEWDATE.615
      olddys = olddys + dyold-1                                                  GETH_NEWDATE.616
!                                                                                GETH_NEWDATE.617
!  Determine the time difference in seconds                                      GETH_NEWDATE.618
!                                                                                GETH_NEWDATE.619
      idts = (newdys - olddys) * 86400                                           GETH_NEWDATE.620
      idts = idts + (hrnew - hrold) * 3600                                       GETH_NEWDATE.621
      idts = idts + (minew - miold) * 60                                         GETH_NEWDATE.622
      idts = idts + (scnew - scold)                                              GETH_NEWDATE.623
                                                                                 GETH_NEWDATE.624
      if (isign .eq. -1) then                                                    GETH_NEWDATE.625
         tdate=ndate                                                             GETH_NEWDATE.626
         ndate=odate                                                             GETH_NEWDATE.627
         odate=tdate                                                             GETH_NEWDATE.628
         idts = idts * isign                                                     GETH_NEWDATE.629
      endif                                                                      GETH_NEWDATE.630
                                                                                 GETH_NEWDATE.631
      end                                                                        GETH_NEWDATE.632
