      SUBROUTINE GETRAW (DATAH,CORRH,ID1,ID2,ID3,DATAS,IDS1,IDS2,IDS3,           GETRAW.1
     .                   MDATE,IUTIM,ISTIM,IFIL,F4D,IFUATIM,                     GETRAW.2
     .                   HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                        GETRAW.3
C                                                                                GETRAW.4
C        PURPOSE: THIS SUBROUTINE READS A PACKED UPPER AIR DATA TAPE,            GETRAW.5
C                 RETRIEVES AND UNPACKS DESIRED RECORDS, AND PROCESSES           GETRAW.6
C                 THE DATA INTO A FORM APPROPRIATE FOR INCLUSION INTO            GETRAW.7
C                 PRESSURE LEVEL FIELDS.  THE SOUNDINGS ARE COLLECTED            GETRAW.8
C                 INTO FILES AND STORED ON DISK UNTIL NEEDED.  SIMILAR           GETRAW.9
C                 PROCESSING IS PERFORMED FOR BOGUS STATIONS READ IN             GETRAW.10
C                 ON DATA CARDS.                                                 GETRAW.11
C-----------------------------------------------------------------------         GETRAW.12
#include <paramirb.incl>                                                         GETRAW.13
#include <paramirs.incl>                                                         GETRAW.14
#include <coma.incl>                                                             GETRAW.15
#include <comb.incl>                                                             GETRAW.16
#include <comc.incl>                                                             GETRAW.17
#include <comd.incl>                                                             GETRAW.18
#include <comadp.incl>                                                           GETRAW.19
#include <comksfc.incl>                                                          GETRAW.20
C-----------------------------------------------------------------------         GETRAW.21
      character Uflnm*7, S3flnm*8, S6flnm*8, Pflnm*8                             GETRAW.22
                                                                                 GETRAW.23
      DATA IREC /0/                                                              GETRAW.24
      DATA MAXLEV /60/, IMAND /1/, ISIGT /2/, ISIGW /3/, ISFCD /4/,              GETRAW.25
     1     NVOLUP /15/,  NVOLS3 /20/, NVOLS6 /25/, NVOLSP /30/                   GETRAW.26
      DATA NYRUP /0/, NMOUP /0/, NDYUP /0/, NHRUP /0/, NYRS3 /0/,                GETRAW.27
     1     NMOS3 /0/, NDYS3 /0/, NHRS3 /0/, NYRS6 /0/, NMOS6 /0/,                GETRAW.28
     2     NDYS6 /0/, NHRS6 /0/, NYRSP /0/, NMOSP /0/, NDYSP /0/,                GETRAW.29
     3     NHRSP /0/                                                             GETRAW.30
      DIMENSION IUPTYP(8),ISFTYP(10),ADMY(300),JDMY(50),BDMY(75),CDMY(6)         GETRAW.31
      DATA (IUPTYP(I),I=1,8) /11,12,13,21,22,23,31,41/                           GETRAW.32
      DATA (ISFTYP(I),I=1,10) /511,512,513,521,522,523,531,532,561,562/          GETRAW.33
C                                                                                GETRAW.34
C                                                                                GETRAW.35
C-----------------------------------------------------------------------         GETRAW.36
C                                                                                GETRAW.37
C  DEFINE GETRAW INTERNAL CODES:                                                 GETRAW.38
C                                                                                GETRAW.39
C    TAPE VOLUME NUMBERS:                                                        GETRAW.40
C      NVOLUP = 15-19  :   VOL. NO. FOR ARCHIVED UPPER-AIR                       GETRAW.41
C                          (RADIOSONDE) DATA                                     GETRAW.42
C      NVOLS3 = 20-24  :   VOL. NO. FOR ARCHIVED SFC. LAND DATA AT               GETRAW.43
C                          3,9,15, 21 GMT. (ALSO CONTAINS SHIP/BUOY              GETRAW.44
C                          DATA AT 0,6,12,18 GMT, BUT READ FROM COPY             GETRAW.45
C                          ON VOLS 30-34                                         GETRAW.46
C      NVOLS6 = 25-29  :   VOL. NO. FOR ARCHIVED SFC. LAND DATA                  GETRAW.47
C                          AT 0,6,12,18 GMT                                      GETRAW.48
C      NVOLSP = 30-34  :   VOL. NO. FOR ARCHIVED SHIP AND BUOY DATA AT           GETRAW.49
C                          0,6,12,18 GMT.  (ALSO CONTAINS SFC. LAND              GETRAW.50
C                          DATA AT 3,9,15, AND 21 GMT, BUT READ FROM             GETRAW.51
C                          ORIGINAL, VOLUMES 20-24.                              GETRAW.52
C                                                                                GETRAW.53
C      MXRTYP       :   MAXIMUM VALUE OF REPORT TYPE CODE TO BE SOUGHT,          GETRAW.54
C                       CONTROLLED BY USER-DEFINITION OF IUPPER,                 GETRAW.55
C                       ISFCS3,AND ISFCS6 IN THE MASTER INPUT FILE.              GETRAW.56
C                       = 23   UPPER AIR SOUNDINGS                               GETRAW.57
C                       = 41   AIRCRAFT REPORTS                                  GETRAW.58
C                       = 513  LAND SFC. DATA (0,6,12,18 GMT)                    GETRAW.59
C                       = 562  SHIPS AND BUOYS (0,6,12,18 GMT),                  GETRAW.60
C                                AND LAND SFC. DATA (3,9,15,21 GMT)              GETRAW.61
C                                                                                GETRAW.62
C      LIST OF REPORT-TYPE CODES                                                 GETRAW.63
C                                                                                GETRAW.64
C        011 - UPPER AIR, LAND, BY BLOCK AND STATION NO.                         GETRAW.65
C        012 - UPPER AIR, LAND, BY CALL LETTERS                                  GETRAW.66
C        013 - UPPER AIR, LAND, BY LAT. AND LONG.                                GETRAW.67
C        021 - UPPER AIR, FIXED SHIP                                             GETRAW.68
C        022 - UPPER AIR, MOVING SHIP WITH NAME                                  GETRAW.69
C        023 - UPPER AIR, MOVING SHIP WITHOUT NAME                               GETRAW.70
C        031 - UPPER AIR, RECONNAISSANCE AIRCRAFT                                GETRAW.71
C        041 - UPPER AIR, AIRCRAFT REPORT (PILOT OBS.)                           GETRAW.72
C        051 - UPPER AIR, MONITORING BOGUS STA., BY LAT. AND LONG.               GETRAW.73
C        061 - UPPER AIR, SATELL., SIRS SOUNDING                                 GETRAW.74
C        062 - UPPER AIR, SATELL., CLOUD WIND ESTIMATE                           GETRAW.75
C        063 - UPPER AIR, SATELL., ATS WIND ESTIMATE                             GETRAW.76
C        511 - SURFACE, LAND, BY BLOCK AND STATION NO.                           GETRAW.77
C        512 - SURFACE, LAND, BY CALL LETTERS                                    GETRAW.78
C        513 - SURFACE, LAND, BY LAT. AND LONG.                                  GETRAW.79
C        521 - SURFACE, FIXED SHIP                                               GETRAW.80
C        522 - SURFACE, MOVING SHIP WITH NAME                                    GETRAW.81
C        523 - SURFACE, MOVING SHIP WITHOUT NAME                                 GETRAW.82
C        531 - SURFACE, MARINE REPORTING STATION (MARS), FIXED                   GETRAW.83
C        532 - SURFACE, MARINE REPORTING STATION (MARS), MOVING                  GETRAW.84
C        551 - SURFACE, MONITORING BOGUS STA., BY LAT. AND LONG.                 GETRAW.85
C        561 - SURFACE, BUOY, FIXED                                              GETRAW.86
C        562 - SURFACE, BUOY, MOVING                                             GETRAW.87
C                                                                                GETRAW.88
C-----------------------------------------------------------------------         GETRAW.89
C                                                                                GETRAW.90
C                                                                                GETRAW.91
C                                                                                GETRAW.92
      CHARACTER*8 MDUP(IRS)                                                      GETRAW.93
      CHARACTER*8 INNNN                                                          GETRAW.94
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                            GETRAW.95
      DIMENSION DATAS(IDS1,IDS2,IDS3)                                            GETRAW.96
      DIMENSION HORZH(IH1,IH2,IH3),SLAB1(IS1,IS2)                                GETRAW.97
      LOGICAL IFUATIM, F4D                                                       GETRAW.98
      character*24 mdate, idate, kdate                                           GETRAW.99
#ifndef CRAY                                                                     GETRAW.100
      integer iuarr(255)                                                         GETRAW.101
      common /CCRD/ iuarr                                                        GETRAW.102
      data iuarr /0,0,0,0,0,0,0,                                                 GETRAW.103
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.104
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.105
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.106
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.107
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.108
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.109
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,         GETRAW.110
     &    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/         GETRAW.111
      Uflnm = 'raobsA'//char(0)                                                  GETRAW.112
      Pflnm = 'shpvolA'//char(0)                                                 GETRAW.113
      S6flnm = 'sfc6hrA'//char(0)                                                GETRAW.114
      S3flnm = 'sfc3hrA'//char(0)                                                GETRAW.115
#endif                                                                           GETRAW.116
C                                                                                GETRAW.117
C ACCESS UNIDATA OBS                                                             GETRAW.118
C                                                                                GETRAW.119
#ifdef NETCDF                                                                    GETRAW.120
      IF(UNIOBS) CALL GETUNIOB (NVOLS6,NVOLUP,IUTIM,                             GETRAW.121
     .     ISTIM,IFUATIM)                                                        GETRAW.122
#endif                                                                           GETRAW.123
C                                                                                GETRAW.124
      PRINT 5                                                                    GETRAW.125
    5 FORMAT(1H1,'@@@@@@@@@@ CALL GETRAW---INACCT,SAVSTN,(SAVFIL)',              GETRAW.126
     112X,'RAOB INVENTORY'//)                                                    GETRAW.127
      ITOSS = 0                                                                  GETRAW.128
      ISI=0                                                                      GETRAW.129
      JSTATN=0                                                                   GETRAW.130
C                                                                                GETRAW.131
      CALL DECOMDAT(MDATE,MYR,MMO,MDY,MHR,MMI,MSC,MFR)                           GETRAW.132
      IF (MHR.EQ.00.OR.MHR.EQ.12) IFDAA=1                                        GETRAW.133
      IF (MHR.EQ.03.OR.MHR.EQ.15) IFDAA=2                                        GETRAW.134
      IF (MHR.EQ.06.OR.MHR.EQ.18) IFDAA=3                                        GETRAW.135
      IF (MHR.EQ.09.OR.MHR.EQ.21) IFDAA=4                                        GETRAW.136
C                                                                                GETRAW.137
C---------ACCESS TERRAIN FIELD, IF NBOGUS(IFIL) = T                              GETRAW.138
      IF(NBOGUS(IFIL))THEN                                                       GETRAW.139
      CALL FILSLB(1,IREFH,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                     GETRAW.140
      END IF                                                                     GETRAW.141
      IT=0                                                                       GETRAW.142
C                                                                                GETRAW.143
C-----------------------------------------------------------------------         GETRAW.144
C---------SET UP SEARCH FOR UPPER AIR DATA (AT 00 GMT OR 12 GMT,                 GETRAW.145
C         IFDAA = 1)                                                             GETRAW.146
      IF(.NOT. IUPPER .OR. IFDAA.NE.1)GO TO 6                                    GETRAW.147
      IT=NVOLUP                                                                  GETRAW.148
#ifndef CRAY                                                                     GETRAW.149
      if (iuarr(it).eq.0) then                                                   GETRAW.150
         write(*,'(''Opening unit '', I5 ,'' as '', A8)') it, Uflnm              GETRAW.151
         call copen(it, knunit, Uflnm, 1, ierr, 0)                               GETRAW.152
         if(ierr.ne.0) then                                                      GETRAW.153
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.154
         write(*,'(7x,''Cannot find upper-air observations file.'',A8)')         GETRAW.155
     &           Uflnm                                                           GETRAW.156
            write(*,'(7x,''Check setting of script variable InRaobs'')')         GETRAW.157
            write(*,'(/)')                                                       GETRAW.158
            call abort                                                           GETRAW.159
         endif                                                                   GETRAW.160
         iuarr(it) = knunit                                                      GETRAW.161
      endif                                                                      GETRAW.162
#endif                                                                           GETRAW.163
      IF(UNIOBS) THEN                                                            GETRAW.164
      IRTYP=11                                                                   GETRAW.165
      IST=0                                                                      GETRAW.166
      INVEN=0                                                                    GETRAW.167
      END IF                                                                     GETRAW.168
      MXRTYP=23                                                                  GETRAW.169
      NYR=NYRUP                                                                  GETRAW.170
      NMO=NMOUP                                                                  GETRAW.171
      NDY=NDYUP                                                                  GETRAW.172
      NHR=NHRUP                                                                  GETRAW.173
      GO TO 8                                                                    GETRAW.174
C                                                                                GETRAW.175
C---------SET UP SEARCH FOR SURFACE DATA (REQUIRES SOME OR ALL OF                GETRAW.176
C         VOLUMES 20-24, 25-29, AND 30-34)                                       GETRAW.177
C                                                                                GETRAW.178
 6    IF(.NOT.F4D .AND. .NOT.ISFCS3)GO TO 7                                      GETRAW.179
      IF(UNIOBS) GO TO 7                                                         GETRAW.180
      IF(IFDAA.EQ.1 .OR. IFDAA.EQ.3) THEN                                        GETRAW.181
C        TIME IS 00, 06, 12, OR 18:  ACCESS SHIP/BUOY DATA FROM NVOLSP           GETRAW.182
      IT=NVOLSP                                                                  GETRAW.183
#ifndef CRAY                                                                     GETRAW.184
      if (iuarr(it).eq.0) then                                                   GETRAW.185
         write(*,'(''Opening unit '', I5 ,'' as '', A8)') it, Pflnm              GETRAW.186
         call copen(it, knunit, Pflnm, 1, ierr, 0)                               GETRAW.187
         if(ierr.ne.0) then                                                      GETRAW.188
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.189
            write(*,'(7x,''Cannot find 3h observations file: '',A8)')            GETRAW.190
     &           Pflnm                                                           GETRAW.191
            write(*,'(7x,''Check setting of script variable InSfc3h'')')         GETRAW.192
            write(*,'(/)')                                                       GETRAW.193
            call abort                                                           GETRAW.194
         endif                                                                   GETRAW.195
         iuarr(it) = knunit                                                      GETRAW.196
      endif                                                                      GETRAW.197
#endif                                                                           GETRAW.198
      MXRTYP=562                                                                 GETRAW.199
      NYR=NYRSP                                                                  GETRAW.200
      NMO=NMOSP                                                                  GETRAW.201
      NDY=NDYSP                                                                  GETRAW.202
      NHR=NHRSP                                                                  GETRAW.203
      ELSE IF (IFDAA.EQ.2 .OR. IFDAA.EQ.4) THEN                                  GETRAW.204
C        TIME IS 03, 09, 15, OR 21: ACCESS SFC. LAND DATA FROM NVOLS3            GETRAW.205
      IT=NVOLS3                                                                  GETRAW.206
#ifndef CRAY                                                                     GETRAW.207
      if (iuarr(it).eq.0) then                                                   GETRAW.208
         write(*,'(''Opening unit '', I5 ,'' as '', A8)') it, S3flnm             GETRAW.209
         call copen(it, knunit, S3flnm, 1, ierr, 0)                              GETRAW.210
         if(ierr.ne.0) then                                                      GETRAW.211
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.212
            write(*,'(7x,''Cannot find 3h observations file: '',A8)')            GETRAW.213
     &           S3flnm                                                          GETRAW.214
            write(*,'(7x,''Check setting of script variable InSfc3h'')')         GETRAW.215
            write(*,'(/)')                                                       GETRAW.216
            call abort                                                           GETRAW.217
         endif                                                                   GETRAW.218
         iuarr(it) = knunit                                                      GETRAW.219
      endif                                                                      GETRAW.220
#endif                                                                           GETRAW.221
      MXRTYP=513                                                                 GETRAW.222
      NYR=NYRS3                                                                  GETRAW.223
      NMO=NMOS3                                                                  GETRAW.224
      NDY=NDYS3                                                                  GETRAW.225
      NHR=NHRS3                                                                  GETRAW.226
      ELSE                                                                       GETRAW.227
      PRINT 425, IFDAA                                                           GETRAW.228
425   FORMAT(1H0,'IFDAA=',I4,3X,' IS NOT APPROPRIATE FOR NCAR STD.',             GETRAW.229
     1 'ARCHIVE TAPES,',' NVOLS3  ...STOP')                                      GETRAW.230
      STOP425                                                                    GETRAW.231
      ENDIF                                                                      GETRAW.232
      GO TO 8                                                                    GETRAW.233
7     IF(.NOT.ISFCS6)GO TO 105                                                   GETRAW.234
      IF ((.NOT.UNIOBS).AND.(IFDAA.EQ.2.OR.IFDAA.EQ.4)) GO TO 105                GETRAW.235
      IT=NVOLS6                                                                  GETRAW.236
#ifndef CRAY                                                                     GETRAW.237
      if (iuarr(it).eq.0) then                                                   GETRAW.238
         write(*,'(''Opening unit '', I5 ,'' as '', A8)') it, S6flnm             GETRAW.239
         call copen(it, knunit, S6flnm, 1, ierr, 0)                              GETRAW.240
         if(ierr.ne.0) then                                                      GETRAW.241
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.242
            write(*,'(7x,''Cannot find 6h observations file: '',A8)')            GETRAW.243
     &           S6flnm                                                          GETRAW.244
            write(*,'(7x,''Check setting of script variable InSfc6h'')')         GETRAW.245
            write(*,'(/)')                                                       GETRAW.246
            call abort                                                           GETRAW.247
         endif                                                                   GETRAW.248
         iuarr(it) = knunit                                                      GETRAW.249
      endif                                                                      GETRAW.250
#endif                                                                           GETRAW.251
      IF (UNIOBS) THEN                                                           GETRAW.252
         IRTYP=511                                                               GETRAW.253
         IST=0                                                                   GETRAW.254
      ENDIF                                                                      GETRAW.255
      MXRTYP=513                                                                 GETRAW.256
      NYR=NYRS6                                                                  GETRAW.257
      NMO=NMOS6                                                                  GETRAW.258
      NDY=NDYS6                                                                  GETRAW.259
      NHR=NHRS6                                                                  GETRAW.260
8     CONTINUE                                                                   GETRAW.261
C       RESET ADPBLK PARAMETERS FOR SURFACE DATA VOLUMES                         GETRAW.262
      IREC=0                                                                     GETRAW.263
      IWDS=0                                                                     GETRAW.264
      NPT=9                                                                      GETRAW.265
      LTH=0                                                                      GETRAW.266
9     KRTYP=0                                                                    GETRAW.267
      KDATE='9999-99-99_99:99:99.9999'                                           GETRAW.268
C                                                                                GETRAW.269
C---------BEGIN DATA PROCESSING CYCLE                                            GETRAW.270
300   CONTINUE                                                                   GETRAW.271
C                                                                                GETRAW.272
C---------READ DATA TAPE                                                         GETRAW.273
      GO TO 11                                                                   GETRAW.274
   10 CONTINUE                                                                   GETRAW.275
      IF(UNIOBS.AND.IRTYP.EQ.11) READ(NVOLUP) ADMY,JDMY,BDMY                     GETRAW.276
      IF(UNIOBS.AND.IRTYP.EQ.511) READ(NVOLS6) CDMY                              GETRAW.277
   11 CONTINUE                                                                   GETRAW.278
      CALL RDADP(IT,IST,YLONH,NYR,NMO,NDY,NHR)                                   GETRAW.279
      IF ((IT.EQ.NVOLSP).AND.(IRTYP.GT.562)) THEN                                GETRAW.280
         PRINT*, 'UNKNOWN REPORT TYPE:  IRTYP = ', IRTYP,                        GETRAW.281
     &        '.  SKIPPING RECORD.'                                              GETRAW.282
         GO TO 11                                                                GETRAW.283
      ENDIF                                                                      GETRAW.284
      IF(UNIOBS.AND.IST.EQ.1.AND.IRTYP.EQ.11.AND.INVEN.EQ.0.AND.IT.EQ.           GETRAW.285
     1 NVOLUP) GO TO 65                                                          GETRAW.286
      IF(UNIOBS.AND.IST.EQ.1.AND.IRTYP.EQ.511.AND.INVEN.EQ.1) GO TO 105          GETRAW.287
C         IF END OF FILE IS DETECTED, IST=1 IS RETURNED BY RDADP,                GETRAW.288
C         SKIP TO BOTTOM OF PROCESSING CYCLE                                     GETRAW.289
      IF(IST.EQ.1)GO TO 90                                                       GETRAW.290
C                                                                                GETRAW.291
C---------DATE AND REPORT-TYPE CHECKS:                                           GETRAW.292
 4431 format(I4.4,'-',I2.2,'-',I2.2,'_',I2.2,':00:00.0000')                      GETRAW.293
      write(IDATE,4431) IYR, IMO, IDY, IHR                                       GETRAW.294
      IF(IRTYP.LT.500)GO TO 23                                                   GETRAW.295
      IF(IDATE.EQ.KDATE)GO TO 30                                                 GETRAW.296
 23   KRTYP=IRTYP                                                                GETRAW.297
      KDATE=IDATE                                                                GETRAW.298
30    CONTINUE                                                                   GETRAW.299
      IF(IDATE.LT.MDATE)THEN                                                     GETRAW.300
         GO TO 10                                                                GETRAW.301
      ENDIF                                                                      GETRAW.302
      IF(IDATE.GT.MDATE)THEN                                                     GETRAW.303
         GO TO 50                                                                GETRAW.304
      ENDIF                                                                      GETRAW.305
      KYR=IYR                                                                    GETRAW.306
      KMO=IMO                                                                    GETRAW.307
      KDY=IDY                                                                    GETRAW.308
      KHR=IHR                                                                    GETRAW.309
C                                                                                GETRAW.310
C---------OBS. DATE MATCHES DESIRED ANALYSIS DATE.                               GETRAW.311
C                                                                                GETRAW.312
C---------NEXT, CHECK TO SEE IF ACTUAL TIME OF OBSERVATION IS CLOSE TO           GETRAW.313
C         DESIRED ANALYSIS TIME (MHR).  THE TIME WINDOW HAS BEEN SET             GETRAW.314
C         ACCORDING TO THE DATA TYPE.                                            GETRAW.315
      RHR=MHR                                                                    GETRAW.316
      RHRP24=RHR+24.0                                                            GETRAW.317
      DHR1=ABS(RHR-TIME)                                                         GETRAW.318
      DHR2=ABS(RHRP24-TIME)                                                      GETRAW.319
      DHR=MIN(DHR1,DHR2)                                                         GETRAW.320
      IF(UNIOBS) DHR=0.0                                                         GETRAW.321
      IF(IT.EQ.NVOLUP)GO TO 52                                                   GETRAW.322
      IF(DHR.LE.1.01)GO TO 202                                                   GETRAW.323
      GO TO 10                                                                   GETRAW.324
52    IF(IRTYP.LE.23.AND.DHR.LE.2.01)GO TO 202                                   GETRAW.325
      IF(IRTYP.GE.31.AND.DHR.LE.3.01)GO TO 202                                   GETRAW.326
      GO TO 10                                                                   GETRAW.327
202   CONTINUE                                                                   GETRAW.328
C                                                                                GETRAW.329
C---------CHECK REPORT TYPES OFF UPPER-AIR DATA.                                 GETRAW.330
      IF(IT.NE.NVOLUP)GO TO 40                                                   GETRAW.331
      DO 32 I=1,6                                                                GETRAW.332
      IF(IRTYP.EQ.IUPTYP(I))GO TO 60                                             GETRAW.333
32    CONTINUE                                                                   GETRAW.334
      GO TO 10                                                                   GETRAW.335
C                                                                                GETRAW.336
C---------CHECK REPORT TYPES FOR SURFACE DATA.                                   GETRAW.337
40    IF(IT.NE.NVOLSP)GO TO 45                                                   GETRAW.338
      DO 42 I=4,10                                                               GETRAW.339
      IF(IRTYP.EQ.ISFTYP(I))GO TO 60                                             GETRAW.340
42    CONTINUE                                                                   GETRAW.341
      IF(IRTYP.NE.551)THEN                                                       GETRAW.342
         PRINT*,'REPORT TYPE IRTYP = ', IRTYP, ' NOT KNOWN.  STOPPING'           GETRAW.343
         STOP 42                                                                 GETRAW.344
      ENDIF                                                                      GETRAW.345
      GO TO 10                                                                   GETRAW.346
45    CONTINUE                                                                   GETRAW.347
      DO 46 I=1,3                                                                GETRAW.348
      IF(IRTYP.EQ.ISFTYP(I))GO TO 60                                             GETRAW.349
46    CONTINUE                                                                   GETRAW.350
      GO TO 10                                                                   GETRAW.351
C                                                                                GETRAW.352
C---------DATE HAS BEEN FOUND TO BE TOO LATE.  CHECK IF READ-PHASE               GETRAW.353
C         SHOULD BE TERMINATED.                                                  GETRAW.354
50        CONTINUE                                                               GETRAW.355
      IF(IT.EQ.NVOLUP)GO TO 65                                                   GETRAW.356
      IF(IT.EQ.NVOLS6)GO TO 62                                                   GETRAW.357
      IF(MOD(MHR,6).NE.0.AND.IRTYP.GE.521)GO TO 10                               GETRAW.358
      GO TO 7                                                                    GETRAW.359
62    IF(IRTYP.GT.513)GO TO 10                                                   GETRAW.360
      GO TO 105                                                                  GETRAW.361
65     CONTINUE                                                                  GETRAW.362
      GO TO 91                                                                   GETRAW.363
60    CONTINUE                                                                   GETRAW.364
C                                                                                GETRAW.365
C---------CORRECT DATE AND REPORT TYPE HAS BEEN FOUND.                           GETRAW.366
C         PROCEED WITH DOMAIN AND LOCATION CHECKS.                               GETRAW.367
C                                                                                GETRAW.368
      IF(.NOT.ALRAWS)GO TO 220                                                   GETRAW.369
C                                                                                GETRAW.370
C---------SAVE ALL DATA (SFC. OR SOUNDINGS) IN SPECIFIED LAT.-LONG. BOX          GETRAW.371
      IF(YLAT.GT.XLATN .OR. YLAT.LT.XLATS) GO TO 10                              GETRAW.372
      IF (XLONW.LT.-180.) THEN                                                   GETRAW.373
         IF(YLON.LT.0.) THEN                                                     GETRAW.374
            IF(YLON.LT.XLONW .OR. YLON.GT.XLONE) GO TO 10                        GETRAW.375
         ELSE                                                                    GETRAW.376
            IF((YLON-360.).LT.XLONW .OR. (YLON-360.).GT.XLONE) GO TO 10          GETRAW.377
         ENDIF                                                                   GETRAW.378
      ELSE                                                                       GETRAW.379
         IF(YLON.LT.XLONW .OR. YLON.GT.XLONE) GO TO 10                           GETRAW.380
      ENDIF                                                                      GETRAW.381
                                                                                 GETRAW.382
C      CHECK TO SEE IF STATION IS ONE CHOSEN TO BE ELIMINATED                    GETRAW.383
      IF(.NOT. NSELIM(IFIL)) GO TO 210                                           GETRAW.384
      DO 205 N=1,NNCC-1                                                          GETRAW.385
      IF(ISELIM(N).EQ.SSTA) THEN                                                 GETRAW.386
      IF(ISU(N).EQ.2 .AND. IRTYP.GT.500) GO TO 10                                GETRAW.387
      IF(ISU(N).EQ.1 .AND. IRTYP.LT.500) GO TO 10                                GETRAW.388
      ENDIF                                                                      GETRAW.389
 205  CONTINUE                                                                   GETRAW.390
 210  CONTINUE                                                                   GETRAW.391
      GO TO 250                                                                  GETRAW.392
 220  CONTINUE                                                                   GETRAW.393
      NF = NFSTAD                                                                GETRAW.394
      NL = NLSTAD                                                                GETRAW.395
      DO 240 NMS=NF,NL                                                           GETRAW.396
      IF(ISTNUM(1,NMS) .EQ. SSTA) GO TO 250                                      GETRAW.397
 240  CONTINUE                                                                   GETRAW.398
      GO TO 10                                                                   GETRAW.399
 250  CONTINUE                                                                   GETRAW.400
      KTOPPR=0                                                                   GETRAW.401
      KMANPR=0                                                                   GETRAW.402
      KSIGPR=0                                                                   GETRAW.403
      KWINDP=0                                                                   GETRAW.404
      KWINDZ=0                                                                   GETRAW.405
      KREMEM=0                                                                   GETRAW.406
      IF(IRTYP.GT.500)GO TO 1100                                                 GETRAW.407
C                                                                                GETRAW.408
C---***---PROCESS UPPER AIR SOUNDING DATA:  PRE-ANALYSIS PHASE                   GETRAW.409
C                                                                                GETRAW.410
      CALL PROUPR(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,                     GETRAW.411
     1            ISIGW,ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,                GETRAW.412
     2            KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MAXLEV,              GETRAW.413
     3            ISI)                                                           GETRAW.414
      GO TO 11                                                                   GETRAW.415
C                                                                                GETRAW.416
C---***---PROCESS SURFACE DATA:  PRE-ANALYSIS PHASE                              GETRAW.417
C                                                                                GETRAW.418
 1100 IF(ISFCS3.OR.ISFCS6) THEN                                                  GETRAW.419
      CALL PROSFC(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,ISIGW,               GETRAW.420
     1            ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,KREMEM,               GETRAW.421
     2            DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MAXLEV,ISI)                 GETRAW.422
      END IF                                                                     GETRAW.423
      GO TO 11                                                                   GETRAW.424
   90 CONTINUE                                                                   GETRAW.425
      IF( (IT.EQ.NVOLUP  ) .OR. (IT.EQ.NVOLUP+1) .OR.                            GETRAW.426
     *    (IT.EQ.NVOLUP+2) .OR. (IT.EQ.NVOLUP+3) ) THEN                          GETRAW.427
         PRINT *,'INCREMENTING UPPER AIR OBS FILE, ORIG UNIT=15, ',              GETRAW.428
     *           'CURRENT UNIT=',IT+1                                            GETRAW.429
         NVOLUP=NVOLUP+1                                                         GETRAW.430
#if defined (CRAY)
         IT=NVOLUP                                                               GETRAW.432
#else                                                                            GETRAW.433
         call cclose(iuarr(it), iostat, ierr)                                    GETRAW.434
         iuarr(it) = 0                                                           GETRAW.435
         IT=NVOLUP                                                               GETRAW.436
         Uflnm(6:6) = char(ichar(Uflnm(6:6)) + 1)                                GETRAW.437
         call copen(it, knunit, Uflnm, 1, ierr, 0)                               GETRAW.438
         if (ierr.ne.0) call abort()                                             GETRAW.439
         iuarr(it) = knunit                                                      GETRAW.440
#endif                                                                           GETRAW.441
         IFILE=IFILE+1                                                           GETRAW.442
         GO TO 300                                                               GETRAW.443
      ELSE IF( (IT.EQ.NVOLS3  ) .OR. (IT.EQ.NVOLS3+1) .OR.                       GETRAW.444
     *         (IT.EQ.NVOLS3+2) .OR. (IT.EQ.NVOLS3+3) ) THEN                     GETRAW.445
         PRINT *,'INCREMENTING SURFACE 3H OBS FILE, ORIG UNIT=20, ',             GETRAW.446
     *           'CURRENT UNIT=',IT+1                                            GETRAW.447
         NVOLS3=NVOLS3+1                                                         GETRAW.448
#if defined (CRAY)
         IT=NVOLS3                                                               GETRAW.450
#else                                                                            GETRAW.451
         call cclose(iuarr(it), iostat, ierr)                                    GETRAW.452
         iuarr(it) = 0                                                           GETRAW.453
         IT=NVOLS3                                                               GETRAW.454
         S3flnm(7:7) = char(ichar(S3flnm(7:7)) + 1)                              GETRAW.455
         call copen(it, knunit, S3flnm, 1, ierr, 0)                              GETRAW.456
         if (ierr.ne.0) call abort                                               GETRAW.457
         iuarr(it) = knunit                                                      GETRAW.458
#endif                                                                           GETRAW.459
         IFILE=IFILE+1                                                           GETRAW.460
         GO TO 300                                                               GETRAW.461
      ELSE IF( (IT.EQ.NVOLS6  ) .OR. (IT.EQ.NVOLS6+1) .OR.                       GETRAW.462
     *         (IT.EQ.NVOLS6+2) .OR. (IT.EQ.NVOLS6+3) ) THEN                     GETRAW.463
         PRINT *,'INCREMENTING SURFACE 6H OBS FILE, ORIG UNIT=25, ',             GETRAW.464
     *           'CURRENT UNIT=',IT+1                                            GETRAW.465
         NVOLS6=NVOLS6+1                                                         GETRAW.466
#if defined (CRAY)
         IT=NVOLS6                                                               GETRAW.468
#else                                                                            GETRAW.469
         call cclose(iuarr(it), iostat, ierr)                                    GETRAW.470
         iuarr(it) = 0                                                           GETRAW.471
         IT=NVOLS6                                                               GETRAW.472
         S6flnm(7:7) = char(ichar(S6flnm(7:7)) + 1)                              GETRAW.473
         call copen(it, knunit, S6flnm, 1, ierr, 0)                              GETRAW.474
         if(ierr.ne.0) then                                                      GETRAW.475
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.476
            write(*,'(7x,''Cannot find 6h observations file: '',A8)')            GETRAW.477
     &           S6flnm                                                          GETRAW.478
            write(*,'(7x,''Check setting of script variable InSfc6h'')')         GETRAW.479
            write(*,'(/)')                                                       GETRAW.480
            call abort                                                           GETRAW.481
         endif                                                                   GETRAW.482
         iuarr(it) = knunit                                                      GETRAW.483
#endif                                                                           GETRAW.484
         IFILE=IFILE+1                                                           GETRAW.485
         GO TO 300                                                               GETRAW.486
      ELSE IF( (IT.EQ.NVOLSP  ) .OR. (IT.EQ.NVOLSP+1) .OR.                       GETRAW.487
     *         (IT.EQ.NVOLSP+2) .OR. (IT.EQ.NVOLSP+3) ) THEN                     GETRAW.488
         PRINT *,'INCREMENTING SHIP AND BUOY OBS FILE, ORIG ',                   GETRAW.489
     *           'UNIT=30, CURRENT UNIT=',IT+1                                   GETRAW.490
         NVOLSP=NVOLSP+1                                                         GETRAW.491
#if defined (CRAY)
         IT=NVOLSP                                                               GETRAW.493
#else                                                                            GETRAW.494
         call cclose(iuarr(it), iostat, ierr)                                    GETRAW.495
         iuarr(it) = 0                                                           GETRAW.496
         IT=NVOLSP                                                               GETRAW.497
         Pflnm(7:7) = char(ichar(Pflnm(7:7)) + 1)                                GETRAW.498
         call copen(it, knunit, Pflnm, 1, ierr, 0)                               GETRAW.499
         if(ierr.ne.0) then                                                      GETRAW.500
            write(*,'(/,''*****  ERROR EXIT *****'',/)')                         GETRAW.501
            write(*,'(7x,''Cannot find 3h observations file: '',A8)')            GETRAW.502
     &           Pflnm                                                           GETRAW.503
            write(*,'(7x,''Check setting of script variable InSfc3h'')')         GETRAW.504
            write(*,'(/)')                                                       GETRAW.505
            call abort                                                           GETRAW.506
         endif                                                                   GETRAW.507
         iuarr(it) = knunit                                                      GETRAW.508
#endif                                                                           GETRAW.509
         IFILE=IFILE+1                                                           GETRAW.510
         GO TO 300                                                               GETRAW.511
      ELSE                                                                       GETRAW.512
         PRINT *,'IT=',IT,'   TOO MANY OBS FILES, MAX OF 5 EACH'                 GETRAW.513
         PRINT *,'NVOLUP=',NVOLUP,'   ORIG WAS 15'                               GETRAW.514
         PRINT *,'NVOLS3=',NVOLS3,'   ORIG WAS 20'                               GETRAW.515
         PRINT *,'NVOLS6=',NVOLS6,'   ORIG WAS 25'                               GETRAW.516
         PRINT *,'NVOLSP=',NVOLSP,'   ORIG WAS 30'                               GETRAW.517
         STOP 90                                                                 GETRAW.518
      END IF                                                                     GETRAW.519
C                                                                                GETRAW.520
C---------REAL UPPER-AIR DATA READ-STAGE IS FINISHED.  RETURN TO TOP             GETRAW.521
C         OF GETRAW TO CHECK IF SFC. DATA SHOULD BE READ.                        GETRAW.522
#if defined (_NO_PATH_TO_THIS_STATEMENT)
I have ifdef-ed this statement out, because there is no path to it               GETRAW.524
anyway.  I have not removed it entirely because we might someday find            GETRAW.525
out why it was here in the first place.                                          GETRAW.526
      IF(IT.EQ.NVOLUP)GO TO 6                                                    GETRAW.527
#endif                                                                           GETRAW.528
C                                                                                GETRAW.529
C---***---PROCESS BOGUS UPPER-AIR DATA(IF ANY):  PRE-ANALYSIS PHASE              GETRAW.530
C           THE REAL UPPER-AIR DATA HAS BEEN PROCESSED.  BOGUS                   GETRAW.531
C           SOUNDINGS ARE APPENDED TO THE INPUT JOB DECK IN A FILE               GETRAW.532
C           IMMEDIATELY FOLLOWING THE MASTER INPUT FILE.  IF NOBLEND             GETRAW.533
C           = TRUE, RAWINS IS USED ONLY TO COLLECT AND PRINT REAL DATA,          GETRAW.534
C           SO THE BOGUS-DATA SECTION IS BYPASSED.  SEE NOTES IN                 GETRAW.535
C           SUBROUTINES PROBGU AND PROBGS FOR ADDITIONAL INSTRUCTIONS.           GETRAW.536
C                                                                                GETRAW.537
   91 IYR=KYR                                                                    GETRAW.538
      IMO=KMO                                                                    GETRAW.539
      IDY=KDY                                                                    GETRAW.540
      IHR=KHR                                                                    GETRAW.541
      KTOPPR=0                                                                   GETRAW.542
      KMANPR=0                                                                   GETRAW.543
      KSIGPR=0                                                                   GETRAW.544
      KWINDP=0                                                                   GETRAW.545
      KWINDZ=0                                                                   GETRAW.546
      KREMEM=0                                                                   GETRAW.547
      IF(NOBLND)GO TO 6                                                          GETRAW.548
      IF(NBOGUS(IFIL))THEN                                                       GETRAW.549
      CALL PROBGU(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,ISIGW,               GETRAW.550
     1            ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,KREMEM,               GETRAW.551
     2            DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MDATE,ISI)                  GETRAW.552
      END IF                                                                     GETRAW.553
C                                                                                GETRAW.554
C---------ALL BOGUS UPPER-AIR STATIONS HAVE BEEN PROCESSED.  DO FINAL            GETRAW.555
C         ACCOUNTING FOR UPPER-AIR BUFFER ARRAYS; THEN RETURN TO TOP             GETRAW.556
C         OF GETRAW TO BEGIN PRE-PROCESSING SURFACE DATA (IF DESIRED).           GETRAW.557
      IF(ISTATN.GT.ID3) PRINT 2131,ISTATN                                        GETRAW.558
      IF(ISTATN.GT.ID3) STOP                                                     GETRAW.559
 2131 FORMAT(1H0,2X,'NUMBER OR RAOBS =',I5,'  EXCEEDS ID3')                      GETRAW.560
      PRINT 100,NSTATN,ISTATN                                                    GETRAW.561
 100  FORMAT(1H0,'NSTATN =',I5,'  ISTATN, NO. OF STATIONS FOUND =',I5)           GETRAW.562
C                                                                                GETRAW.563
C     *** IF NO STATIONS ARE FOUND THERE IS NO POINT IN GOING FURTHER            GETRAW.564
C                                                                                GETRAW.565
      IF (ISTATN.EQ.0)THEN                                                       GETRAW.566
         PRINT 99                                                                GETRAW.567
   99 FORMAT(1H0,2X,'NO STATIONS FOUND--CHECK DATE OR SEARCH AREA')              GETRAW.568
         STOP                                                                    GETRAW.569
      END IF                                                                     GETRAW.570
      NSTATN = ISTATN                                                            GETRAW.571
      NSTA = NSTATN                                                              GETRAW.572
      CALL SAVFIL(DATAH,ID1,ID2,ID3,ISTATN,IMAND,IDS3)                           GETRAW.573
      CALL SAVFIL(CORRH,ID1,ID2,ID3,ISTATN,ISIGW,IDS3)                           GETRAW.574
      PRINT 98,NSTA                                                              GETRAW.575
 98     FORMAT(6X,'DATAH FILE CONTAINS',I3,                                      GETRAW.576
     1 ' NON-ZERO DATA SETS (ONE PER STATION)')                                  GETRAW.577
C---------FINAL ACCOUNTING FOR UPPER-AIR DATA IS FINISHED.  RETURN TO            GETRAW.578
C         FOR SFC. DATA PRE-PROCESSING                                           GETRAW.579
      IF(UNIOBS) IST=0                                                           GETRAW.580
      INVEN=1                                                                    GETRAW.581
      GO TO 6                                                                    GETRAW.582
C                                                                                GETRAW.583
C---***---PROCESS BOGUS SURFACE DATA(IF ANY):  PRE-ANALYSIS PHASE                GETRAW.584
C           THE REAL SURFACE DATA HAS BEEN PROCESSED.  BOGUS SURFACE             GETRAW.585
C           DATA ARE APPENDED TO THE INPUT JOB DECK IN A FILE                    GETRAW.586
C           IMMEDIATELY FOLLOWING THE MASTER INPUT FILE.  IF NOBLND              GETRAW.587
C           = T, RAWINS IS USED ONLY TO COLLECT AND PRINT REAL DATA,             GETRAW.588
C           SO THE BOGUS-DATA SECTION IS BYPASSED.  SEE NOTES IN                 GETRAW.589
C           SUBROUTINES PROBGU AND PROBGS FOR ADDITIONAL INSTRUCTIONS.           GETRAW.590
C                                                                                GETRAW.591
105   CONTINUE                                                                   GETRAW.592
      IYR=KYR                                                                    GETRAW.593
      IMO=KMO                                                                    GETRAW.594
      IDY=KDY                                                                    GETRAW.595
      IHR=KHR                                                                    GETRAW.596
      KTOPPR=0                                                                   GETRAW.597
      KMANPR=0                                                                   GETRAW.598
      KSIGPR=0                                                                   GETRAW.599
      KWINDP=0                                                                   GETRAW.600
      KWINDZ=0                                                                   GETRAW.601
      KREMEM=0                                                                   GETRAW.602
C                                                                                GETRAW.603
C---------IF NOBLND=T, RAWINS IS USED ONLY TO COLLECT AND PRINT REAL             GETRAW.604
C         DATA, SO RETURN TO MAIN PROGRAM FOR NEXT TIME.                         GETRAW.605
      IF(NOBLND)RETURN                                                           GETRAW.606
      IF(NBOGUS(IFIL))THEN                                                       GETRAW.607
      IF(ISFCS3.OR.ISFCS6) THEN                                                  GETRAW.608
      CALL PROBGS(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,ISIGW,               GETRAW.609
     1            ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,KREMEM,               GETRAW.610
     2            DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MDATE,ISI)                  GETRAW.611
      END IF                                                                     GETRAW.612
      END IF                                                                     GETRAW.613
C                                                                                GETRAW.614
C---------ALL BOGUS SURFACE STATIONS HAVE BEEN PROCESSED.  DO FINAL              GETRAW.615
C         ACCOUNTING FOR SURFACE BUFFER ARRAYS BEFORE COMPLETING GETRAW.         GETRAW.616
      MSTATN=NSTATN+JSTATN                                                       GETRAW.617
      IF(MSTATN.GT.IDS3)THEN                                                     GETRAW.618
      PRINT 320,NSTATN,JSTATN,IDS3                                               GETRAW.619
320   FORMAT(1H0,'ISTATN=',I5,2X,'PLUS JSTATN=',I5,2X,'EXCEEDS IDS3=',           GETRAW.620
     1 I5,2X,'...STOP')                                                          GETRAW.621
      STOP 320                                                                   GETRAW.622
      END IF                                                                     GETRAW.623
      IF(JSTATN.GT.0)THEN                                                        GETRAW.624
      PRINT 330,JSTATN                                                           GETRAW.625
330   FORMAT(1H0,'JSTATN,NO. OF SURFACE STATIONS FOUND (REAL PLUS ',             GETRAW.626
     1'BOGUS) =',I5)                                                             GETRAW.627
      END IF                                                                     GETRAW.628
110   FORMAT(6X,'NSTATN REDEFINED EQUAL TO ISTATN, THE NO. OF UPPER-AIR'         GETRAW.629
     .     ,' STATIONS ACTUALLY FOUND (REAL PLUS BOGUS)')                        GETRAW.630
      NFSTAD = 1                                                                 GETRAW.631
      NFSTAC = NFSTAD                                                            GETRAW.632
      NLSTAD = NSTATN                                                            GETRAW.633
      NLSTAC = NLSTAD                                                            GETRAW.634
      PRINT 125,NFSTAD,NLSTAD                                                    GETRAW.635
 125  FORMAT(6X,'REDEFINED NFSTAD =',I3,5X,'NLSTAD=',I3)                         GETRAW.636
C                                                                                GETRAW.637
C---------MOVE SURFACE ACCOUNTING INFORMATION TO THIRD VECTOR OF ARRAYS          GETRAW.638
C         ISTNUM, RANG, AND IFOUND.                                              GETRAW.639
C                                                                                GETRAW.640
      IF(NSTATN.GT.0)THEN                                                        GETRAW.641
      DO 360 N=1,NSTATN                                                          GETRAW.642
      ISTNUM(3,N)=ISTNUM(1,N)                                                    GETRAW.643
      KSFCEL(N)=IKELEV(1,N)                                                      GETRAW.644
      RANG(3,N)=RANG(1,N)                                                        GETRAW.645
360   IFOUND(3,N)=IFOUND(1,N)                                                    GETRAW.646
      ENDIF                                                                      GETRAW.647
      IF(JSTATN.GT.0)THEN                                                        GETRAW.648
      DO 370 N=1,JSTATN                                                          GETRAW.649
      ISTNUM(3,N+NSTATN)=ISTNUM(2,N)                                             GETRAW.650
      KSFCEL(N+NSTATN)=IKELEV(2,N)                                               GETRAW.651
      RANG(3,N+NSTATN)=RANG(2,N)                                                 GETRAW.652
370   IFOUND(3,N+NSTATN)=IFOUND(2,N)                                             GETRAW.653
      ENDIF                                                                      GETRAW.654
C                                                                                GETRAW.655
C---------SET RADIUS OF INFLUENCE FOR OBJECTIVE ANALYSIS OF SURFACE              GETRAW.656
C         OBSERVATIONS.  GENERALLY, SURFACE DATA DENSITY WILL EXCEED             GETRAW.657
C         RADIOSONDE DENSITY.  THUS, IN THEORY, THE RADIUS OF INFLUENCE          GETRAW.658
C         FOR SURFACE DATA COULD BE LESS THAN FOR UPPER-AIR DATA.                GETRAW.659
C         HOWEVER, THE STANDARD DEVIATION OF SURFACE OBS. FROM A FIRST           GETRAW.660
C         GUESS WILL TEND TO BE GREATER BECAUSE OF LOCAL SURFACE                 GETRAW.661
C         INFLUENCES, SO IT IS RECOMMENDED THAT THE SAME RADIUS OF               GETRAW.662
C         INFLUENCE BE USED FOR BOTH SURFACE AND UPPER-LEVEL ANALYSIS.           GETRAW.663
      RINSFC=RIN                                                                 GETRAW.664
      PRINT 500,RINSFC,RIN                                                       GETRAW.665
500   FORMAT('RADIUS OF INFLUENCE FOR SURFACE OBSERVATIONS, RINSFC = ',          GETRAW.666
     1   F5.1,2X,'GRID INCREMENTS.'/10X,'IN THE MASTER INPUT FILE, THE',         GETRAW.667
     2 ' RADIUS OF INFLUENCE FOR ANALYSIS OF UPPER-AIR DATA WAS SET TO',         GETRAW.668
     3 ' RIN =',F5.1/10X,'IF THE USER WISHES TO CHANGE RINSFC, SEE END',         GETRAW.669
     4 ' OF GETRAW.')                                                            GETRAW.670
C                                                                                GETRAW.671
C        NOW CHECK UNIQUENESS                                                    GETRAW.672
      PRINT 630,MDATE(1:16)                                                      GETRAW.673
630   FORMAT(///,10X,'UNIQUENESS CHECK OF STATION NUMBERS AT MDATE= ',           GETRAW.674
     1     A16 )                                                                 GETRAW.675
      NUNIQU=0                                                                   GETRAW.676
      NTOT=NSTATN+JSTATN                                                         GETRAW.677
      IF(NTOT.GT.0)THEN                                                          GETRAW.678
      DO 655 I=1,NTOT                                                            GETRAW.679
      SSTA=ISTNUM(3,I)                                                           GETRAW.680
      IF(NUNIQU.GT.0)THEN                                                        GETRAW.681
      DO 635 II=1,NUNIQU                                                         GETRAW.682
      IF(SSTA.EQ.MDUP(II))THEN                                                   GETRAW.683
          READ(MDUP(II),18)ICNT                                                  GETRAW.684
18        FORMAT(5X,I3)                                                          GETRAW.685
          ICNT=ICNT+1                                                            GETRAW.686
          WRITE(INNNN,19)SSTA,ICNT                                               GETRAW.687
19        FORMAT(A5,I3)                                                          GETRAW.688
          ISTNUM(3,I)=INNNN                                                      GETRAW.689
          GO TO 655                                                              GETRAW.690
      ENDIF                                                                      GETRAW.691
635   CONTINUE                                                                   GETRAW.692
      ENDIF                                                                      GETRAW.693
      DO 650 N=1,NTOT                                                            GETRAW.694
      IF(SSTA.NE.ISTNUM(3,N).OR.I.EQ.N)GO TO 650                                 GETRAW.695
      NUNIQU=NUNIQU+1                                                            GETRAW.696
      MDUP(NUNIQU)=SSTA                                                          GETRAW.697
650   CONTINUE                                                                   GETRAW.698
655   CONTINUE                                                                   GETRAW.699
      ENDIF                                                                      GETRAW.700
      PRINT 660,MDATE(1:16),NUNIQU                                               GETRAW.701
660   FORMAT(10X,'AT MDATE=',A16,2X,'THE TOTAL OF NON-UNIQUE STA. ',             GETRAW.702
     &     'NOS. =',I5)                                                          GETRAW.703
C                                                                                GETRAW.704
C                                                                                GETRAW.705
      PRINT 1000,IREC,IST                                                        GETRAW.706
1000  FORMAT(5X,'TOTAL RECORDS READ=',I5,2X,'IST=',I5,10X,                       GETRAW.707
     1 '...EXIT GETRAW')                                                         GETRAW.708
C                                                                                GETRAW.709
C        ALL STATION DATA AND BOGUS REPORTS HAVE NOW BEEN SAVED ON               GETRAW.710
C         DISK FILES OR BUFFER ARRAYS.                                           GETRAW.711
C                                                                                GETRAW.712
      RETURN                                                                     GETRAW.713
      END                                                                        GETRAW.714
