      SUBROUTINE INACCT(ID1,ID3,ISTATN,SSTA,IDF,NSTA,ALRAWS,DATBOG,              INACCT.1
     1 KLAT,KLON,KELEV,JSTATN,IDS3)                                              INACCT.2
C                                                                                INACCT.3
C        PURPOSE: THIS SUBROUTINE DOES THE ACCOUNTING FOR THE                    INACCT.4
C                 NECESSARY INTEGER COUNTERS AND STATION IDS.                    INACCT.5
C                                                                                INACCT.6
C             ISTNUM: ARRAY HOLDING STATION NUMBERS (ALPHANUMERIC CHAR.          INACCT.7
C             IFOUND: ARRAY SHOWING TYPE OF STATIONS FOUND:                      INACCT.8
C                         = 1, REAL DATA                                         INACCT.9
C                         = 2, BOGUS DATA                                        INACCT.10
C             ID1,ID3: DIMENSIONS OF ISTNUM, AND IFOUND                          INACCT.11
C             ISTATN: COUNTER FOR CURRENT NO. OF STATIONS SAVED                  INACCT.12
C             SSTA  : STATION NUMBER (ALPHANUMERIC CHARACTERS)                   INACCT.13
C             DATBOG: CODE TO PLACE TYPE OF STATION IN IFOUND                    INACCT.14
C             IDF   : CURRENT DATA FILE NO.                                      INACCT.15
C             NSTA  : POSTION OF LATEST STATION IN FILE IDF                      INACCT.16
C             ALRAWS: = TRUE WHEN ALL STATIONS IN A DESIGNATED AREA ARE          INACCT.17
C                     BEING SAVED; = FALSE IF ONLY SPECIFIC STATIONS ARE         INACCT.18
C                     BEING SAVED.                                               INACCT.19
C-----------------------------------------------------------------------         INACCT.20
#include <paramirb.incl>                                                         INACCT.21
#include <paramirs.incl>                                                         INACCT.22
#include <comc.incl>                                                             INACCT.23
C-----------------------------------------------------------------------         INACCT.24
      INTEGER DATBOG                                                             INACCT.25
      character*8 SSTA,INNNN, IMMMM, IRNNN, IPNNN                                INACCT.26
      character*8 IBNNN, ISNNN                                                   INACCT.27
      LOGICAL ALRAWS                                                             INACCT.28
C                                                                                INACCT.29
      DATA NRIGG /0/, NPLAT /0/, NBUOY /0/, NSHIP /0/                            INACCT.30
C--------THE COUNTERS IN THE DATA STATEMENT ABOVE ARE USED FOR SSTA              INACCT.31
C        (STATION NUMBERS) KNOWN TO BE NON-UNIQUE ON THE DATA TAPES.             INACCT.32
C        SSTA WILL BE RENAMED ACCORDINGLY.                                       INACCT.33
C                                                                                INACCT.34
      MAXUPR=2*ID3                                                               INACCT.35
      NTOTUP=ISTATN-JSTATN                                                       INACCT.36
      ISTATN=ISTATN+1                                                            INACCT.37
      IF(NTOTUP.LE.MAXUPR)GO TO 10                                               INACCT.38
      PRINT 5,NTOTUP,MAXUPR,ID3                                                  INACCT.39
5     FORMAT(5X,'TOTAL NO. OF OF UPPER-AIR STATIONS=',I5,2X,                     INACCT.40
     1 'HAS EXCEEDED',' THE TOTAL STORAGE ALLOTTED, MAXUPR=',I5/10X,             INACCT.41
     2 'WHICH ALLOWS TWO FILES OF ID3=',I5,2X,'EACH...STOP IN INACCT')           INACCT.42
      STOP 10                                                                    INACCT.43
10    CONTINUE                                                                   INACCT.44
C                                                                                INACCT.45
C---------UPPER-AIR SOUNDINGS ARE PROCESSED FIRST, WHILE JSTATN=0.               INACCT.46
C     STORE APPROPRIATE INFO. IN THE FIRST ID3 LOCATIONS OF THE                  INACCT.47
C     ACCOUNTING BUFFERS, WITH EITHER IDF=1 OR 2.  HOWEVER, INFO.                INACCT.48
C     FOR SURFACE DATA (WHEN JSTATN.GT.0) ARE STORED AFTER THE FIRST             INACCT.49
C     ID3 LOCATIONS OF THE ACCOUNTING BUFFERS, WITH IDF=2, ONLY.                 INACCT.50
C                                                                                INACCT.51
      IF(JSTATN.GT.0)GO TO 50                                                    INACCT.52
C                                                                                INACCT.53
C---------ACCOUNTING FOR UPPER-AIR DATA                                          INACCT.54
      IF(DATBOG .EQ. 2) GO TO 15                                                 INACCT.55
      IF(.NOT. ALRAWS) GO TO 20                                                  INACCT.56
15    IDF=1                                                                      INACCT.57
      NSTA=ISTATN                                                                INACCT.58
      IF(ISTATN.GT.ID3)STOP 15                                                   INACCT.59
C         STOP IF NO. OF UPPER AIR STATIONS EXCEEDS ID3                          INACCT.60
      IDNO=1                                                                     INACCT.61
      WRITE(IMMMM,21)SSTA,IDNO                                                   INACCT.62
      SSTA=IMMMM                                                                 INACCT.63
      ISTNUM(IDF,NSTA) = SSTA                                                    INACCT.64
      IKLAT(IDF,NSTA)=KLAT                                                       INACCT.65
      IKLON(IDF,NSTA)=KLON                                                       INACCT.66
      IKELEV(IDF,NSTA)=KELEV                                                     INACCT.67
  20  IFOUND(IDF,NSTA) = DATBOG                                                  INACCT.68
      RETURN                                                                     INACCT.69
C                                                                                INACCT.70
C---------ACCOUNTING FOR SURFACE DATA                                            INACCT.71
50    IF(ID3+JSTATN.LE.IDS3)GO TO 70                                             INACCT.72
      PRINT 60,ID3,JSTATN,IDS3                                                   INACCT.73
60    FORMAT(5X,'THE SUM OF SPACES ALLOTTED FOR UPPER-AIR STATIONS, ',           INACCT.74
     1 'ID3=',I5,2X,'PLUS THE NO. OF SFC. STATIONS, JSTATN=',I5/10X,             INACCT.75
     2 'HAS EXCEEDED THE LENGTH OF THE ACCOUNTING ARRAYS, IDS3=',                INACCT.76
     3 I5,2X,' ... STOP IN INACCT')                                              INACCT.77
      STOP 70                                                                    INACCT.78
70    CONTINUE                                                                   INACCT.79
      IF(DATBOG.EQ.2)GO TO 80                                                    INACCT.80
      IF(.NOT.ALRAWS)GO TO 90                                                    INACCT.81
80    NSTA=JSTATN                                                                INACCT.82
C--------CHECK FOR KNOWN NON-UNIQUE SSTA-TYPES...ALTER, IF NECESSARY.            INACCT.83
      IF(SSTA.EQ.'RIGG    ')THEN                                                 INACCT.84
      NRIGG=NRIGG+1                                                              INACCT.85
      WRITE(IRNNN(1:5),16) NRIGG                                                 INACCT.86
16    FORMAT('RG',I3)                                                            INACCT.87
      SSTA=IRNNN                                                                 INACCT.88
      ENDIF                                                                      INACCT.89
      IF(SSTA.EQ.'PLAT    ')THEN                                                 INACCT.90
      NPLAT=NPLAT+1                                                              INACCT.91
      WRITE(IPNNN(1:5),17)NPLAT                                                  INACCT.92
17    FORMAT('PL',I3)                                                            INACCT.93
      SSTA=IPNNN                                                                 INACCT.94
      ENDIF                                                                      INACCT.95
      IF(SSTA.EQ.'BUOY    ')THEN                                                 INACCT.96
      NBUOY=NBUOY+1                                                              INACCT.97
      write(IBNNN(1:5),18)NBUOY                                                  INACCT.98
18    FORMAT('BU',I3)                                                            INACCT.99
      SSTA=IBNNN                                                                 INACCT.100
      ENDIF                                                                      INACCT.101
      IF(SSTA.EQ.'SHIP    ')THEN                                                 INACCT.102
      NSHIP=NSHIP+1                                                              INACCT.103
      write(ISNNN(1:5),19)NSHIP                                                  INACCT.104
19    FORMAT('SP',I3)                                                            INACCT.105
      SSTA=ISNNN                                                                 INACCT.106
      ENDIF                                                                      INACCT.107
C                                                                                INACCT.108
      IDNO=1                                                                     INACCT.109
      WRITE(INNNN,21)SSTA,IDNO                                                   INACCT.110
21    FORMAT(A5,I3)                                                              INACCT.111
      SSTA=INNNN                                                                 INACCT.112
      ISTNUM(2,NSTA)=SSTA                                                        INACCT.113
      IKLAT(2,NSTA)=KLAT                                                         INACCT.114
      IKLON(2,NSTA)=KLON                                                         INACCT.115
      IKELEV(2,NSTA)=KELEV                                                       INACCT.116
90    IFOUND(2,NSTA)=DATBOG                                                      INACCT.117
      RETURN                                                                     INACCT.118
      END                                                                        INACCT.119
