      SUBROUTINE INHRZ1(HORZH,IH1,IH2,IH3,SLAB1,IX,JX,LAND,                      INHRZ1.1
     .     SNOW,KX,NVOLFGA,IFUATIM,SCR3D,MDATE,IDERR)                            INHRZ1.2
C                                                                                INHRZ1.3
C                                                                                INHRZ1.4
C     PURPOSE----READ IN DATA SET CREATED BY REGRID                              INHRZ1.5
C                                                                                INHRZ1.6
C*****  THIS VERSION OF RAWINS IS FOR THE GLOBAL GRID INPUT *****                INHRZ1.7
C                                                                                INHRZ1.8
C      MANDATORY PRES LVLS ARE 1000,850,700,500,400,300,250,200,150,100          INHRZ1.9
C                                                                                INHRZ1.10
C      THE INPUT RECORDS ARE AS FOLLOWS:                                         INHRZ1.11
C                                                                                INHRZ1.12
C                                                                                INHRZ1.13
C             DATE IDENTIFIER                                                    INHRZ1.14
C             TERRAIN HEIGHT AT CROSS PTS (M)                                    INHRZ1.15
C             LAND USE AT CROSS PTS (INTEGER)                                    INHRZ1.16
C             MAP SCALE FACTOR AT CROSS PTS                                      INHRZ1.17
C             MAP SCALE FACTOR AT DOT PTS                                        INHRZ1.18
C             CORIOLIS PARAMETER AT DOT PTS                                      INHRZ1.19
C             LAT,LONG AT CROSS PTS                                              INHRZ1.20
C             LAT,LONG AT DOT PTS                                                INHRZ1.21
C             SNOW COVER AT CROSS PTS                                            INHRZ1.22
C             SEA LEVEL PRESSURE AT DOT PTS (MB)                                 INHRZ1.23
C             SEA LEVEL PRESSURE AT CROSS PTS (MB)                               INHRZ1.24
C             SURFACE TEMP AT CROSS PTS (C)                                      INHRZ1.25
C             SEA SFC TEMP AT CROSS PTS (C)                                      INHRZ1.26
C             *                                                                  INHRZ1.27
C             *                                                                  INHRZ1.28
C             *  TEMPERATURE AT EACH MANDATORY LEVEL AT CROSS PTS (C)            INHRZ1.29
C             *                                                                  INHRZ1.30
C             *                                                                  INHRZ1.31
C             SFC GEOSTROPHIC U AND V (M/S)                                      INHRZ1.32
C             *                                                                  INHRZ1.33
C             *                                                                  INHRZ1.34
C             *  GEOPOTENTIAL HT, U, AND V AT EACH MANDATORY LEVEL               INHRZ1.35
C             *  AT DOT PTS (M, M/S, M/S)                                        INHRZ1.36
C             *                                                                  INHRZ1.37
C             *                                                                  INHRZ1.38
C             RELATIVE HUMIDITY AT ALL MANDATORY LEVELS UP TO 300MB              INHRZ1.39
C                                                                                INHRZ1.40
C                                                                                INHRZ1.41
C-----------------------------------------------------------------------         INHRZ1.42
#include <hedmif.incl>                                                           INHRZ1.43
#include <coma.incl>                                                             INHRZ1.44
#include <comd.incl>                                                             INHRZ1.45
C-----------------------------------------------------------------------         INHRZ1.46
      DIMENSION HORZH(IH1,IH2,IH3),SLAB1(IX,JX),LAND(IX,JX),SNOW(IX,JX),         INHRZ1.47
     .     SCR3D(IX,JX,KX)                                                       INHRZ1.48
      DIMENSION LPRES(50), LNUM(50)                                              INHRZ1.49
      REAL DATPRS(MAXPLV)                                                        INHRZ1.50
      INTEGER LDX(MAXPLV)    ! JIM BRESCH                                        INHRZ1.51
      LOGICAL IFUATIM                                                            INHRZ1.52
      CHARACTER*8 NAME                                                           INHRZ1.53
      character*24 MDATE                                                         INHRZ1.54
      CHARACTER*4 HNAM                                                           INHRZ1.55
      logical isopdad                                                            INHRZ1.56
      external isopdad                                                           INHRZ1.57
      PRINT 10                                                                   INHRZ1.58
 10   FORMAT (1H1,'@@@@@@@@@@ CALL INHRZ1---,(SLBFIL)',15X,                      INHRZ1.59
     .     'INPUT FROM REGRID  '//)                                              INHRZ1.60
                                                                                 INHRZ1.61
      IDERR = 0                                                                  INHRZ1.62
                                                                                 INHRZ1.63
      do icount = 1, 100                                                         INHRZ1.64
         sh_stagger(icount) = "    "                                             INHRZ1.65
         sh_order(icount) = "    "                                               INHRZ1.66
         sh_name(icount) = "         "                                           INHRZ1.67
         sh_units(icount) = "                          "                         INHRZ1.68
         sh_description(icount) = "                               "              INHRZ1.69
     &    //"                                    "                               INHRZ1.70
      enddo                                                                      INHRZ1.71
      numv3flds = 0                                                              INHRZ1.72
                                                                                 06NOV00.10
C  Restore the GNLVL array to the values set by the user in                      06NOV00.11
C  the namelist.  Restore NNEWPL as well.                                        06NOV00.12
      nnewpl = nnewpl_orig                                                       06NOV00.13
      do k = 1, 50                                                               06NOV00.14
         gnlvl(k) = gnlvl_orig(k)                                                06NOV00.15
      enddo                                                                      06NOV00.16
                                                                                 06NOV00.17
 1000 continue                                                                   INHRZ1.73
         read(nvolfga,END=1002) iv3flag                                          INHRZ1.74
         if (iv3flag .eq. 2) go to 1001                                          INHRZ1.75
         numv3flds = numv3flds + 1                                               INHRZ1.76
         read(nvolfga) ndim, idst1, idst2, idst3, idst4, shdim,                  INHRZ1.77
     &        time, sh_stagger(numv3flds),                                       INHRZ1.78
     &        sh_order(numv3flds), current_date, sh_name(numv3flds),             INHRZ1.79
     &        sh_units(numv3flds), sh_description(numv3flds)                     INHRZ1.80
         mdate=current_date                                                      INHRZ1.81
         sh_ndim(numv3flds) = ndim                                               INHRZ1.82
         NAME = sh_name(numv3flds)(1:8)                                          INHRZ1.83
         WRITE(6,260) NAME                                                       INHRZ1.84
 260     format(2x,A8,95('-'))                                                   INHRZ1.85
         if (ndim .eq.3) then                                                    INHRZ1.86
            nvert = shdim(3)                                                     INHRZ1.87
            if (nvert .gt. KX) then                                              INHRZ1.88
               PRINT 23, NVERT, KX, NVERT                                        INHRZ1.89
            endif                                                                INHRZ1.90
            call readsub(nvolfga, scr3d, shdim(1), shdim(2), shdim(3))           INHRZ1.91
         elseif (ndim .eq. 2) then                                               INHRZ1.92
            read(nvolfga) slab1                                                  INHRZ1.93
         elseif (ndim.eq.1) then                                                 INHRZ1.94
            if (NAME .EQ. 'PRESSURE') then                                       INHRZ1.95
               nvert = shdim(1)                                                  INHRZ1.96
               read(nvolfga) (datprs(k), k = 1, shdim(1))                        INHRZ1.97
               ndatlvl = shdim(1)                                                INHRZ1.98
               print*, 'datprs = ', (datprs(k), k = 1, shdim(1))                 INHRZ1.99
               do k = 1, nvert                                                   INHRZ1.100
                  ! Convert pressure from Pa to mb.                              INHRZ1.101
                  datprs(k) = datprs(k) * 0.01                                   INHRZ1.102
                  lprdat(k)= nint(datprs(k))                                     06NOV00.18
                  glvl(k) = datprs(k)                                            INHRZ1.103
                  allvl(k) = datprs(k)                                           INHRZ1.104
               enddo                                                             INHRZ1.105
!              Check that the expected mandatory levels are there:               06NOV00.19
               do k = 4, 16                                                      06NOV00.20
                  if (ipres(k) .lt. ptop) goto 121                               06NOV00.21
                  do kk = 1, nvert                                               06NOV00.22
                     if (lprdat(kk) .eq. ipres(k)) goto 121                      06NOV00.23
                  enddo                                                          06NOV00.24
                  print 122, ipres(k), ipres(k)                                  06NOV00.25
 122  FORMAT(/,'***** ERROR EXIT ', //,                                          06NOV00.26
     &  '     RAWINS EXPECTS TO FIND A MANDATORY LEVEL OF ', I4,                 06NOV00.27
     &        ' MB IN THE FIRST-GUESS FILE. ', /,                                06NOV00.28
     &  '     SUCH A LEVEL WAS NOT FOUND.',//,                                   06NOV00.29
     &  '     SOLUTION:  ', /,                                                   06NOV00.30
     &'        REGENERATE THE FIRST-GUESS FILE, AND MAKE SURE IT HAS',           06NOV00.31
     &       ' A ', I4, ' MB LEVEL.',/)                                          06NOV00.32
                  stop '***** ERROR EXIT: MISSING MANDATORY LEVEL'               06NOV00.33
 121              continue                                                       06NOV00.34
               enddo                                                             06NOV00.35
            else                                                                 INHRZ1.106
               read(nvolfga) xdum                                                INHRZ1.107
            endif                                                                INHRZ1.108
         endif                                                                   INHRZ1.109
         IF ((NAME.EQ.'T').or.(NAME.EQ.'U').or.(NAME.EQ.'V').or.                 INHRZ1.110
     &        (NAME.EQ.'H').or.(NAME.EQ.'RH')) THEN                              INHRZ1.111
            IF (NAME.EQ.'T') HNAM = 'TEMP'                                       INHRZ1.112
            IF ((NAME.EQ.'U').or.(NAME.EQ.'V').or.(NAME.EQ.'RH'))                INHRZ1.113
     &           HNAM=NAME(1:4)                                                  INHRZ1.114
            IF (NAME.EQ.'H') HNAM = 'HGT'                                        INHRZ1.115
            IF (NAME.EQ.'T') THEN                                                INHRZ1.116
               DO I = 1, IX-1                                                    INHRZ1.117
                  DO J = 1, JX-1                                                 INHRZ1.118
                     DO K = 1, KX                                                INHRZ1.119
                        SCR3D(I,J,K)=SCR3D(I,J,K)-273.15                         INHRZ1.120
                     ENDDO                                                       INHRZ1.121
                  ENDDO                                                          INHRZ1.122
               ENDDO                                                             INHRZ1.123
            ENDIF                                                                INHRZ1.124
                                                                                 INHRZ1.125
            IF (NAME.NE.'HGT') write(6,20) 'SFC '//HNAM                          INHRZ1.126
                                                                                 INHRZ1.127
            IF ((NAME.EQ.'U').or.(NAME.EQ.'V')) THEN                             INHRZ1.128
               IF(IWIND.EQ.1) THEN                                               INHRZ1.129
                  DO I = 1, IX                                                   INHRZ1.130
                     DO J = 1, JX                                                INHRZ1.131
                        SLAB1(I,J)=SCR3D(I,J,1)                                  INHRZ1.132
                     ENDDO                                                       INHRZ1.133
                  ENDDO                                                          INHRZ1.134
               ELSEIF(IWIND.EQ.2) THEN                                           INHRZ1.135
                  DO I = 1, IX                                                   INHRZ1.136
                     DO J = 1, JX                                                INHRZ1.137
                        SLAB1(I,J)=SCR3D(I,J,2)                                  INHRZ1.138
                     ENDDO                                                       INHRZ1.139
                  ENDDO                                                          INHRZ1.140
               ENDIF                                                             INHRZ1.141
            ELSEIF (NAME.EQ.'H') THEN                                            INHRZ1.142
            ELSE                                                                 INHRZ1.143
               DO I = 1, IX                                                      INHRZ1.144
                  DO J = 1, JX                                                   INHRZ1.145
                     SLAB1(I,J)=SCR3D(I,J,1)                                     INHRZ1.146
                  ENDDO                                                          INHRZ1.147
               ENDDO                                                             INHRZ1.148
            ENDIF                                                                INHRZ1.149
                                                                                 INHRZ1.150
            IF (NAME.NE.'H') PRINT 30,'SFC'//HNAM, SLAB1(1,1),IPRES(1)           INHRZ1.151
                                                                                 INHRZ1.152
            WRITE(6,40) HNAM                                                     INHRZ1.153
 40         format(2x,A4,' AT MANDATORY LEVELS ', 86('-'))                       INHRZ1.154
                                                                                 INHRZ1.155
            DO L = 1,NVERT                                                       INHRZ1.156
               DO I = 1, IX                                                      INHRZ1.157
                  DO J = 1, JX                                                   INHRZ1.158
                     SLAB1(I,J)=SCR3D(I,J,L)                                     INHRZ1.159
                  ENDDO                                                          INHRZ1.160
               ENDDO                                                             INHRZ1.161
               PRINT 30,HNAM, SLAB1(1,1), L !HERE                                INHRZ1.162
               IF (NAME.EQ.'T')                                                  INHRZ1.163
     &           CALL SLBFIL(L,ITEMP,2,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)            INHRZ1.164
               IF (NAME.EQ.'U')                                                  INHRZ1.165
     &           CALL SLBFIL(L,IUVEL,2,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)            INHRZ1.166
               IF (NAME.EQ.'V')                                                  INHRZ1.167
     &           CALL SLBFIL(L,IVVEL,2,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)            INHRZ1.168
               IF (NAME.EQ.'H')                                                  INHRZ1.169
     &           CALL SLBFIL(L,IHGT,2,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)             INHRZ1.170
               IF (NAME.EQ.'RH')                                                 INHRZ1.171
     &           CALL SLBFIL(L,IRELH,2,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)            INHRZ1.172
            ENDDO                                                                INHRZ1.173
         ELSEIF (NAME.EQ.'TERRAIN') THEN                                         INHRZ1.174
            CALL SLBFIL(1,IREFH,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.175
         ELSEIF (NAME.EQ.'LAND USE') THEN                                        INHRZ1.176
            DO I = 1, IX                                                         INHRZ1.177
               DO J = 1, JX                                                      INHRZ1.178
                  LAND(I,J)=INT(SLAB1(I,J))                                      INHRZ1.179
               ENDDO                                                             INHRZ1.180
            ENDDO                                                                INHRZ1.181
            PRINT 270,LAND(1,1)                                                  INHRZ1.182
 270        FORMAT(' AN INPUT FIELD(LAND USE)',4X,'HAS BEEN READ FROM',          INHRZ1.183
     .           ' UNIT  4.  THE VALUE AT I,J=1,1 IS',I9,4X,                     INHRZ1.184
     &           'PRES =  999')                                                  INHRZ1.185
         ELSEIF (NAME.EQ.'MAPFACCR') THEN                                        INHRZ1.186
            CALL SLBFIL(1,IMSC,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                  INHRZ1.187
         ELSEIF (NAME.EQ.'MAPFACDT') THEN                                        INHRZ1.188
            CALL SLBFIL(1,IMSD,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                  INHRZ1.189
         ELSEIF (NAME.EQ.'CORIOLIS') THEN                                        INHRZ1.190
            CALL SLBFIL(1,ICOR,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                  INHRZ1.191
         ELSEIF (NAME.EQ.'LATITCRS') THEN                                        INHRZ1.192
            CALL SLBFIL(1,ILATC,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.193
         ELSEIF (NAME.EQ.'LONGICRS') THEN                                        INHRZ1.194
            CALL SLBFIL(1,ILONC,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.195
         ELSEIF (NAME.EQ.'LATITDOT') THEN                                        INHRZ1.196
            CALL SLBFIL(1,ILATD,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.197
         ELSEIF (NAME.EQ.'LONGIDOT') THEN                                        INHRZ1.198
            CALL SLBFIL(1,ILOND,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.199
         ELSEIF (NAME.EQ.'SNOWCOVR') THEN                                        INHRZ1.200
            DO I = 1, IX
               DO J = 1, JX
                  SNOW(I,J)=SLAB1(I,J)
               ENDDO
            ENDDO
            PRINT 300,SNOW(1,1)                                                  INHRZ1.201
 300        FORMAT(1X,'AN INPUT FIELD(SNOWCOVR)',4X,                             INHRZ1.202
     &           'HAS BEEN READ FROM UNIT 4.  THE VALUE AT I,J=1,1 IS',          INHRZ1.203
     &           F9.2,4X, 'PRES =  999')                                         INHRZ1.204
         ELSEIF (NAME.EQ.'PSEALVLD') THEN                                        INHRZ1.205
            do i = 1, ix                                                         INHRZ1.206
               do j = 1, jx                                                      INHRZ1.207
                  slab1(i,j) = slab1(i,j) * 1.E-2 ! Convert from Pa to mb        INHRZ1.208
               enddo                                                             INHRZ1.209
            enddo                                                                INHRZ1.210
            CALL SLBFIL(2,IREFPD,4,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                INHRZ1.211
         ELSEIF (NAME.EQ.'PSEALVLC') THEN                                        INHRZ1.212
            do i = 1, ix                                                         INHRZ1.213
               do j = 1, jx                                                      INHRZ1.214
                  slab1(i,j) = slab1(i,j) * 1.E-2 ! Convert from Pa to mb        INHRZ1.215
               enddo                                                             INHRZ1.216
            enddo                                                                INHRZ1.217
            CALL SLBFIL(2,IREFPC,5,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                INHRZ1.218
         ELSEIF (NAME.EQ.'TSEASFC ') THEN                                        INHRZ1.219
            DO I = 1, IX                                                         INHRZ1.220
               DO J = 1, JX                                                      INHRZ1.221
                  SLAB1(I,J)=SLAB1(I,J)-273.15                                   INHRZ1.222
               ENDDO                                                             INHRZ1.223
            ENDDO                                                                INHRZ1.224
            CALL SLBFIL(1,ITSEA,1,HORZH,IH1,IH2,IH3,SLAB1,IX,JX)                 INHRZ1.225
         ELSE                                                                    INHRZ1.226
            if (ndim.eq.2) then                                                  INHRZ1.227
               if (.not. isopdad(idad2d)) CALL OPENDAD(IDAD2D, IX*JX)            INHRZ1.228
               CALL WRITDAD(SLAB1, NAME, IDAD2D, IX, JX, 1)                      INHRZ1.229
            endif                                                                05DEC01.6
CB                                                                               05DEC01.7
            if (ndim.eq.3) then                                                  05DEC01.8
               if (.not. isopdad(idad3d))                                        05DEC01.9
     &              CALL OPENDAD(IDAD3D, IX*JX*NVERT)                            05DEC01.10
               CALL WRITDAD(SCR3D, NAME, IDAD3D, IX, JX, NVERT)                  05DEC01.11
            endif                                                                05DEC01.12
CB                                                                               05DEC01.13
                                                                                 INHRZ1.231
         ENDIF                                                                   INHRZ1.232
                                                                                 INHRZ1.233
      GO TO 1000                                                                 INHRZ1.234
 1001 CONTINUE                                                                   INHRZ1.235
      print*, 'Hit the end of time.'                                             INHRZ1.236
                                                                                 INHRZ1.237
C                                                                                INHRZ1.238
C PUT THE REGRID LEVELS INTO THE COMBINED ARRAY                                  INHRZ1.239
C     CHECK=.TRUE.                                                               INHRZ1.240
      NLVDAT = NVERT                                                             INHRZ1.241
      ISUB = 0                                                                   INHRZ1.242
C IF THE USER REQUESTS NEW LEVELS, ADD THEM TO THE END OF THE COMBINED ARRAY     INHRZ1.243
      IF (NNEWPL .GT.0) THEN                                                     INHRZ1.244
C SORT THE NEW PRESSURE LEVELS AND ELIMINATE DUPLICATES                          INHRZ1.245
        DO M = 1, NNEWPL-1                                                       INHRZ1.246
          DO N = NNEWPL,M+1,-1                                                   INHRZ1.247
            IF (GNLVL(N) .GT. GNLVL(N-1)) THEN                                   INHRZ1.248
              TMP = GNLVL(N)                                                     INHRZ1.249
              GNLVL(N) = GNLVL(N-1)                                              INHRZ1.250
              GNLVL(N-1) = TMP                                                   INHRZ1.251
            ENDIF                                                                INHRZ1.252
          ENDDO                                                                  INHRZ1.253
        ENDDO                                                                    INHRZ1.254
        N = 1                                                                    INHRZ1.255
        DO M = 1, NNEWPL-1                                                       INHRZ1.256
          IF (GNLVL(M+1).LT.1.E-2) THEN                                          INHRZ1.257
             WRITE(6,*) 'WARNING... I FOUND A PRESSURE LEVEL CLOSE TO'           INHRZ1.258
     &            //' ZERO.  CHECK YOUR GNLVL CAREFULLY'                         INHRZ1.259
             DO LL = M+2, NNEWPL                                                 INHRZ1.260
                GNLVL(LL-1) = GNLVL(LL)                                          INHRZ1.261
             ENDDO                                                               INHRZ1.262
          ELSEIF (ABS(GNLVL(M+1)-GNLVL(M)).lt.1.E-3) THEN                        INHRZ1.263
            WRITE(6,*) 'WARNING... I FOUND THAT YOU REQUESTED ',                 INHRZ1.264
     & 'A DUPLICATE NEW PRESSURE LEVEL. CHECK YOUR GNLVL CAREFULLY'              INHRZ1.265
            DO LL = M+2, NNEWPL                                                  INHRZ1.266
              GNLVL(LL-1) = GNLVL(LL)                                            INHRZ1.267
            ENDDO                                                                INHRZ1.268
          ELSEIF (GNLVL(M+1).LT.PTOP) THEN                                       06NOV00.36
             WRITE(6,*) 'ERROR... I FOUND THAT YOU REQUESTED A NEW ',            06NOV00.37
     &   'PRESSURE LEVEL HIGHER THAN PTOP.  CHECK YOUR GNLVL CAREFULLY'          06NOV00.38
             write(6,116) GNLVL(M+1), PTOP                                       06NOV00.39
 116         FORMAT(' NEW LEVEL = ',F7.2,' mb;   PTOP =', F6.2,' mb',/)          06NOV00.40
             STOP " ***** ERROR EXIT:  NEW LEVEL HIGHER THAN PTOP"               06NOV00.41
          ELSE                                                                   INHRZ1.269
            N = N + 1                                                            INHRZ1.270
          ENDIF                                                                  INHRZ1.271
        ENDDO                                                                    INHRZ1.272
        NNEWPL = N                                                               INHRZ1.273
        DO 2 L=NLVDAT+1,NLVDAT+NNEWPL                                            INHRZ1.274
C CHECK IF A USER-REQUESTED LEVEL WAS ALREADY IN THE REGRID FILE                 INHRZ1.275
C IF SO, TOSS IT                                                                 INHRZ1.276
          DO I = 1, NLVDAT                                                       INHRZ1.277
            IF(INT(GNLVL(L-NLVDAT)) .EQ. INT(DATPRS(I))) THEN                    INHRZ1.278
              ISUB = ISUB + 1                                                    INHRZ1.279
              WRITE(6,*) 'YOU REQUESTED A NEW LEVEL THAT WAS ALREADY',           INHRZ1.280
     &     ' IN THE REGRID FILE.'                                                INHRZ1.281
              WRITE(6,1322) INT(GNLVL(L-NLVDAT))                                 INHRZ1.282
 1322         format('THE EXTRA LEVEL ',I4,' IS BEING DISREGARDED.')             INHRZ1.283
              GO TO 2                                                            INHRZ1.284
            ENDIF                                                                INHRZ1.285
          ENDDO                                                                  INHRZ1.286
          ALLVL(L-ISUB) = GNLVL(L-NLVDAT)                                        INHRZ1.287
    2   CONTINUE                                                                 INHRZ1.288
      ENDIF                                                                      INHRZ1.289
      L = NLVDAT+NNEWPL - ISUB                                                   INHRZ1.290
C NOW, USE A BUBBLE SORT TO ORDER THE PRESSURE LEVELS                            INHRZ1.291
      DO M = 1, L-1                                                              INHRZ1.292
        DO N = L,M+1,-1                                                          INHRZ1.293
          IF (ALLVL(N) .GT. ALLVL(N-1)) THEN                                     INHRZ1.294
            TMP = ALLVL(N)                                                       INHRZ1.295
            ALLVL(N) = ALLVL(N-1)                                                INHRZ1.296
            ALLVL(N-1) = TMP                                                     INHRZ1.297
          ENDIF                                                                  INHRZ1.298
        ENDDO                                                                    INHRZ1.299
      ENDDO                                                                      INHRZ1.300
C     DO M = 1, L                                                                INHRZ1.301
C       WRITE(6,*) 'M = ',M,' ALLVL = ',ALLVL(M)                                 INHRZ1.302
C     ENDDO                                                                      INHRZ1.303
C NOW, PULL OUT THE GLVL AND GNLVL                                               INHRZ1.304
      IG = 1                                                                     INHRZ1.305
      IGN = 1                                                                    INHRZ1.306
      DO 4 M = 1, L                                                              INHRZ1.307
        DO LLP = 3, 16                                                           INHRZ1.308
          IF (INT(ALLVL(M)) .EQ. IPRES(LLP)) THEN                                INHRZ1.309
            GLVL(IG) = ALLVL(M)                                                  INHRZ1.310
            IG = IG + 1                                                          INHRZ1.311
            GO TO 4                                                              INHRZ1.312
          ENDIF                                                                  INHRZ1.313
        ENDDO                                                                    INHRZ1.314
        GNLVL(IGN) = ALLVL(M)                                                    INHRZ1.315
        IGN = IGN + 1                                                            INHRZ1.316
    4 CONTINUE                                                                   INHRZ1.317
      IG = IG - 1                                                                INHRZ1.318
      IGN = IGN - 1                                                              INHRZ1.319
C NOW MAKE IHEDPR AND LVL ARRAYS                                                 INHRZ1.320
C     WRITE(6,*) 'IG = ',IG,' IGN = ',IGN                                        INHRZ1.321
      DO J = 1, IG                                                               INHRZ1.322
        IHEDPR(J) = INT(GLVL(J))                                                 INHRZ1.323
      ENDDO                                                                      INHRZ1.324
      DO K = IG+1, IG+1+IGN                                                      INHRZ1.325
        IHEDPR(K) = INT(GNLVL(K-IG))                                             INHRZ1.326
      ENDDO                                                                      INHRZ1.327
      DO 6 M = 1, L                                                              INHRZ1.328
        DO N = 1, L                                                              INHRZ1.329
          IF (INT(ALLVL(M)) .EQ. IHEDPR(N)) THEN                                 INHRZ1.330
            LVL(M) = N                                                           INHRZ1.331
            GO TO 6                                                              INHRZ1.332
          ENDIF                                                                  INHRZ1.333
        ENDDO                                                                    INHRZ1.334
    6 CONTINUE                                                                   INHRZ1.335
C NOW COMPUTE THE INDEX FOR SLBFIL TO USE                                        INHRZ1.336
      DO 8 M = 1, NLVDAT                                                         INHRZ1.337
        DO N = 1, L                                                              INHRZ1.338
          IF (INT(DATPRS(M)) .EQ. IHEDPR(N)) THEN                                INHRZ1.339
            LDX(M) = N                                                           INHRZ1.340
            GO TO 8                                                              INHRZ1.341
          ENDIF                                                                  INHRZ1.342
        ENDDO                                                                    INHRZ1.343
    8 CONTINUE                                                                   INHRZ1.344
                                                                                 INHRZ1.345
 20   FORMAT(2X,A8,93('-'))                                                      INHRZ1.346
 30   FORMAT(1X,'AN INPUT FIELD(',A8,') HAS BEEN READ FROM ',                    INHRZ1.347
     .     'UNIT  4.  THE VALUE AT I,J=1,1 IS',F9.2,4X,'LVL = ',I5)              INHRZ1.348
                                                                                 INHRZ1.349
      NVERT = IG                                                                 INHRZ1.350
      NNEWPL = IGN                                                               INHRZ1.351
      NTOTLV = NVERT + NNEWPL                                                    INHRZ1.352
                                                                                 INHRZ1.353
      if (NTOTLV .GT. KX) then                                                   INHRZ1.354
         PRINT 23, NTOTLV, KX, NTOTLV                                            INHRZ1.355
 23      FORMAT(/,66('$'), /, '$$$$$$$', T60, '$$$$$$$', /                       INHRZ1.356
     &        '$$$$$$$   PARAMETER (LMX) IS TOO SMALL TO ACCOUNT FOR ',          INHRZ1.357
     &        T60,'$$$$$$$',/,                                                   INHRZ1.358
     &        '$$$$$$$   INPUT LEVELS AND NEW LEVELS. LMX MUST BE',              INHRZ1.359
     &        T60,'$$$$$$$',/,                                                   INHRZ1.360
     &        '$$$$$$$   AT LEAST ', I4,'.',T60,'$$$$$$$'/                       INHRZ1.361
     &        '$$$$$$$   YOU HAVE IT SET TO ', I4,'.',T60,'$$$$$$$'/             INHRZ1.362
     &        '$$$$$$$', T60, '$$$$$$$', /                                       INHRZ1.363
     &        '$$$$$$$   RESET LMX TO ',I3,' IN THE RAWINS DECK. ',              INHRZ1.364
     &        T60,'$$$$$$$',/'$$$$$$$',T60,'$$$$$$$',/,66('$'),/)                INHRZ1.365
         call abort()                                                            INHRZ1.366
      endif                                                                      INHRZ1.367
                                                                                 INHRZ1.368
! OK.  Now that all the data have been read in, and we know our                  INHRZ1.369
! pressure levels, we need to rearrange the slabs in the storage array           INHRZ1.370
! so that it matches the storage order that V2 rawins expected.                  INHRZ1.371
                                                                                 INHRZ1.372
! Rearrange U:                                                                   INHRZ1.373
      DO L = 1, ndatlvl                                                          INHRZ1.374
         CALL FILSLB(L,IUVEL,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,L),IX,JX)             INHRZ1.375
      enddo                                                                      INHRZ1.376
      CALL SLBFIL(IG,IREFPC,1,HORZH,IH1,IH2,IH3,SCR3D(1,1,1),IX,JX)              INHRZ1.377
      DO L = 2, ndatlvl                                                          INHRZ1.378
         do lll = 1, ntotlv                                                      INHRZ1.379
            if (abs(allvl(lll)-datprs(l)).lt.0.1) then                           INHRZ1.380
               CALL SLBFIL(LVL(lll),IUVEL,2,HORZH,IH1,IH2,IH3,                   INHRZ1.381
     &              SCR3D(1,1,L),IX,JX)                                          INHRZ1.382
            endif                                                                INHRZ1.383
         enddo                                                                   INHRZ1.384
      enddo                                                                      INHRZ1.385
                                                                                 INHRZ1.386
! Rearrange V:                                                                   INHRZ1.387
      DO L = 1, NDATLVL                                                          INHRZ1.388
         CALL FILSLB(L,IVVEL,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,L),IX,JX)             INHRZ1.389
      enddo                                                                      INHRZ1.390
      CALL SLBFIL(IG,IREFPD,1,HORZH,IH1,IH2,IH3,SCR3D(1,1,1),IX,JX)              INHRZ1.391
      DO L = 2, ndatlvl                                                          INHRZ1.392
         do lll = 1, ntotlv                                                      INHRZ1.393
            if (abs(allvl(lll)-datprs(l)).lt.0.1) then                           INHRZ1.394
               CALL SLBFIL(LVL(LLL),IVVEL,2,HORZH,IH1,IH2,IH3,                   INHRZ1.395
     &              SCR3D(1,1,L),IX,JX)                                          INHRZ1.396
            endif                                                                INHRZ1.397
         enddo                                                                   INHRZ1.398
      enddo                                                                      INHRZ1.399
                                                                                 INHRZ1.400
! Rearrange T:                                                                   INHRZ1.401
      DO L = 1, NDATLVL                                                          INHRZ1.402
         CALL FILSLB(L,ITEMP,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,L),IX,JX)             INHRZ1.403
      enddo                                                                      INHRZ1.404
      CALL SLBFIL(1,IREFT,3,HORZH,IH1,IH2,IH3,SCR3D(1,1,1),IX,JX)                INHRZ1.405
      DO L = 2, ndatlvl                                                          INHRZ1.406
         do lll = 1, ntotlv                                                      INHRZ1.407
            if (abs(allvl(lll)-datprs(l)).lt.0.1) then                           INHRZ1.408
               CALL SLBFIL(LVL(Lll),ITEMP,2,HORZH,IH1,IH2,IH3,                   INHRZ1.409
     &              SCR3D(1,1,L),IX,JX)                                          INHRZ1.410
            endif                                                                INHRZ1.411
         enddo                                                                   INHRZ1.412
      enddo                                                                      INHRZ1.413
                                                                                 INHRZ1.414
! Rearrange Height:                                                              INHRZ1.415
      DO L = 1, NDATLVL                                                          INHRZ1.416
         CALL FILSLB(L,IHGT,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,L),IX,JX)              INHRZ1.417
      enddo                                                                      INHRZ1.418
      DO L = 2, ndatlvl                                                          INHRZ1.419
         do lll = 1, ntotlv                                                      INHRZ1.420
            if (abs(allvl(lll)-datprs(l)).lt.0.1) then                           INHRZ1.421
               CALL SLBFIL(LVL(LLL),IHGT,2,HORZH,IH1,IH2,IH3,                    INHRZ1.422
     &              SCR3D(1,1,L),IX,JX)                                          INHRZ1.423
            endif                                                                INHRZ1.424
         enddo                                                                   INHRZ1.425
      enddo                                                                      INHRZ1.426
                                                                                 INHRZ1.427
! Rearrange RH:                                                                  INHRZ1.428
      DO L = 1, NDATLVL                                                          INHRZ1.429
         CALL FILSLB(L,IRELH,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,L),IX,JX)             INHRZ1.430
      enddo                                                                      INHRZ1.431
      CALL SLBFIL(1,IREFRH,2,HORZH,IH1,IH2,IH3,SCR3D(1,1,1),IX,JX)               INHRZ1.432
      DO L = 2, ndatlvl                                                          INHRZ1.433
         do lll = 1, ntotlv                                                      INHRZ1.434
            if (abs(allvl(lll)-datprs(l)).lt.0.1) then                           INHRZ1.435
               CALL SLBFIL(LVL(LLL),IRELH,2,HORZH,IH1,IH2,IH3,                   INHRZ1.436
     &              SCR3D(1,1,L),IX,JX)                                          INHRZ1.437
            endif                                                                INHRZ1.438
         enddo                                                                   INHRZ1.439
      enddo                                                                      INHRZ1.440
      return                                                                     INHRZ1.441
 1002 print*, 'Hit the end of file.'                                             INHRZ1.442
      iderr = 1                                                                  INHRZ1.443
      END                                                                        INHRZ1.444
      subroutine readsub(nvolfga, scr3d, id1, id2, id3)                          INHRZ1.445
      integer nvolfga                                                            INHRZ1.446
      integer id1, id2, id3                                                      INHRZ1.447
      real scr3d(id1,id2,id3)                                                    INHRZ1.448
      read(nvolfga) scr3d                                                        INHRZ1.449
      end                                                                        INHRZ1.450
