         SUBROUTINE INTR(P,NX,NY,BX,BY,BB,QUAD,NXD,NYD)                          INTR.1
C                                                                                INTR.2
C      PERFORMS BI-QUADRATIC INTERPOLATION WHERE POSSIBLE,                       INTR.3
C      LINEAR INTERPOLATION IN OUTSIDE GRID INTERVAL, AND                        INTR.4
C      LINEAR EXTRAPOLATION OUTSIDE GRID.                                        INTR.5
C                                                                                INTR.6
C            JULY, 1968            GLAHN, HOLLENBAUGH                            INTR.7
C            AUGUST, 1977            ADAPTED BY W. LOTTES                        INTR.8
C                                                                                INTR.9
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         INTR.10
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC         INTR.11
C                                                                                INTR.12
C      ARGUMENTS                                                                 INTR.13
C            P    =  GRID FIELD TO INTERPOLATE FROM                              INTR.14
C            NX   =  X DIMENSION OF GRID (JMAX IN RAWINS)                        INTR.15
C            NY   =  Y DIMENSION OF GRID (IMAX IN RAWINS)                        INTR.16
C            BX   =  X-COORDINATE, FROM LEFT                                     INTR.17
C            BY   =  Y-COORDINATE, FROM BOTTOM                                   INTR.18
C            BB   =  INTERPOLATED (OR EXTRAPOLATED) VALUE RETURNED               INTR.19
C                  TO CALLING PROGRAM                                            INTR.20
C            QUAD =  LOGICAL FLAG TO INDICATE LINEAR OR                          INTR.21
C                  BI-QUADRATIC INTERPOLATION                                    INTR.22
C                                                                                INTR.23
C                                                                                INTR.24
      LOGICAL QUAD                                                               INTR.25
      REAL P(NXD,NYD),B(4)                                                       INTR.26
C                                                                                INTR.27
      NBX=BX                                                                     INTR.28
      NBY=BY                                                                     INTR.29
      IF (NBX-1) 114,120,111                                                     INTR.30
111   IF (NBX-(NX-1)) 112,120,115                                                INTR.31
112   IF (NBY-1) 121,130,113                                                     INTR.32
113   IF (NBY-(NY-1)) 140,130,123                                                INTR.33
114   NBX=1                                                                      INTR.34
      GO TO 120                                                                  INTR.35
115   NBX=NX-1                                                                   INTR.36
120   IF (NBY-1) 121,130,122                                                     INTR.37
121   NBY=1                                                                      INTR.38
      GO TO 130                                                                  INTR.39
122   IF (NBY-NY) 130,123,123                                                    INTR.40
123   NBY=(NY-1)                                                                 INTR.41
C                                                                                INTR.42
C---STATEMENT 130 STARTS BI-LINEAR INTERPOLATION-EXTRAPOLATION.                  INTR.43
C                                                                                INTR.44
130   NBXP1=NBX+1                                                                INTR.45
      NBYP1=NBY+1                                                                INTR.46
      DX=BX-FLOAT(NBX)                                                           INTR.47
      DY=BY-FLOAT(NBY)                                                           INTR.48
      BB=P(NBX,NBY)+(P(NBXP1,NBY)-P(NBX,NBY))*DX+(P(NBX,NBYP1)-                  INTR.49
     1 P(NBX,NBY))*DY+(P(NBX,NBY)+P(NBXP1,NBYP1)-P(NBX,NBYP1)-                   INTR.50
     2 P(NBXP1,NBY))*DX*DY                                                       INTR.51
      RETURN                                                                     INTR.52
C                                                                                INTR.53
C---STATEMENT 140 STARTS BI-QUADRATIC INTERPOLATION.                             INTR.54
C                                                                                INTR.55
140   IF(.NOT.QUAD) GO TO 130            ! DO PURE LINEAR ?                      INTR.56
      DX=BX-FLOAT(NBX)                                                           INTR.57
      DY=BY-FLOAT(NBY)                                                           INTR.58
      NBYP2=NBY+2                                                                INTR.59
      NBYP1=NBY+1                                                                INTR.60
      NBYM1=NBY-1                                                                INTR.61
      FCT=(DY**2-DY)/4.                                                          INTR.62
      FET=(DX**2-DX)/4.                                                          INTR.63
      DO 145 J=1,4                                                               INTR.64
      N=NBX-2+J                                                                  INTR.65
      B(J)=P(N,NBY)+(P(N,NBYP1)-P(N,NBY))*DY+(P(N,NBYM1)+P(N,NBYP2)-             INTR.66
     1 P(N,NBY)-P(N,NBYP1))*FCT                                                  INTR.67
145      CONTINUE                                                                INTR.68
      BB=B(2)+(B(3)-B(2))*DX+(B(1)+B(4)-B(2)-B(3))+FET                           INTR.69
      RETURN                                                                     INTR.70
      END                                                                        INTR.71
