      SUBROUTINE NEWPLV(LPR,IVRBL,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               06NOV00.45
C                                                                                06NOV00.46
C        PURPOSE:  THIS SUBROUTINE CALCULATES A FIRST GUESS FIELD FOR H,         06NOV00.47
C                  U, V, T, AND RH AT NEW NONMANDATORY PRESSURE LEVELS.          06NOV00.48
C                                                                                06NOV00.49
C        ARGUMENTS:                                                              06NOV00.50
C             LPR   : VERTICAL LEVEL OF NON-MANDATORY P-SFC IN GNLVL             06NOV00.51
!                   : LPR is the index in GNLVL of the pressure level            06NOV00.52
!                   : to which we are currently trying to interpolate.           06NOV00.53
C             IVRBL : VARIBLE TYPE CODE                                          06NOV00.54
C             HORZH : HORIZONTAL STRIP HOLDING ARRAY                             06NOV00.55
C             IH1,IH2,IH3: DIMENSIONS OF HORZH                                   06NOV00.56
C             SLAB1 : HORIZONTAL SLAB HOLDING ARRAY                              06NOV00.57
C             IS1,IS2: DIMENSIONS OF SLAB1                                       06NOV00.58
C                                                                                06NOV00.59
C-----------------------------------------------------------------------         06NOV00.60
C                                                                                06NOV00.61
#include <coma.incl>                                                             06NOV00.62
#include <comd.incl>                                                             06NOV00.63
#include <hedmif.incl>                                                           06NOV00.64
C-----------------------------------------------------------------------         06NOV00.65
      DIMENSION HORZH(IH1,IH2,IH3),SLAB1(IS1,IS2)                                06NOV00.66
      INTEGER NLPRDAT                                                            06NOV00.67
      REAL ARR(MAXPLV)                                                           06NOV00.68
! GLVL contains what RAWINS considers mandatory levels to be, plus               06NOV00.69
! the surface level (1001): 1001., 1000., 850., 700., 500., 400.,                06NOV00.70
! 300., 250., 200., ....                                                         06NOV00.71
! NVERT is the number of levels in GLVL.                                         06NOV00.72
                                                                                 06NOV00.73
! GNLVL contains what RAWINS considers the "new" levels to be,                   06NOV00.74
! whether they are in the input data set or not.  I.e., GNLVL                    06NOV00.75
! contains all new levels requested in the namelist that are                     06NOV00.76
! not listed in GLVL and all levels in the input data set that                   06NOV00.77
! are not listed in GLVL.  Arrays GLVL and GNLVL are complementary               06NOV00.78
! and have no overlap.                                                           06NOV00.79
! NNEWPL is the number of levels in GNLVL.                                       06NOV00.80
                                                                                 06NOV00.81
      do i = 1, NVERT                                                            06NOV00.82
         ARR(I) = GLVL(I)                                                        06NOV00.83
      enddo                                                                      06NOV00.84
      do i = NVERT+1, NVERT+NNEWPL                                               06NOV00.85
         ARR(I) = GNLVL(I-NVERT)                                                 06NOV00.86
      enddo                                                                      06NOV00.87
      do i = NVERT+NNEWPL+1, MAXPLV                                              06NOV00.88
         ARR(I) = 0.                                                             06NOV00.89
      enddo                                                                      06NOV00.90
! LPRDAT contains all levels in the input dataset, starting with                 06NOV00.91
! 1001.                                                                          06NOV00.92
      do i = 1, maxplv                                                           06NOV00.93
         if (lprdat(i) .GT. 0) nlprdat = i                                       06NOV00.94
      enddo                                                                      06NOV00.95
                                                                                 06NOV00.96
C        SET UP FICTICIOUS STORAGE LEVEL UNIQUE ADDRESS NAME FOR                 06NOV00.97
C        NEW NON-MANDATORY LEVELS:                                               06NOV00.98
      LNONMN = LPR + NVERT                                                       06NOV00.99
                                                                                 06NOV00.100
! Cross or dot-point field ending indices:                                       06NOV00.101
      IF (DORC(IVRBL) .EQ. 'DOT') THEN                                           06NOV00.102
        IEND = IMAX                                                              06NOV00.103
        JEND = JMAX                                                              06NOV00.104
      ELSE                                                                       06NOV00.105
        IEND = IE                                                                06NOV00.106
        JEND = JE                                                                06NOV00.107
      ENDIF                                                                      06NOV00.108
                                                                                 06NOV00.109
! LEVEL1 is 2, referring to the index in GLVL corresponding to the               06NOV00.110
! 1000 mb level, the first "real" pressure level.                                06NOV00.111
                                                                                 06NOV00.112
      DO L = 2, NLPRDAT-1                                                        06NOV00.113
        IF(GNLVL(LPR).GE.LPRDAT(L+1).AND.GNLVL(LPR).LE.LPRDAT(L)) THEN           06NOV00.114
                                                                                 06NOV00.115
          do i = 1, NVERT+NNEWPL                                                 06NOV00.116
            if (abs(lprdat(l  )-arr(i)).lt.1.E-3) L1 = i                         06NOV00.117
            if (abs(lprdat(l+1)-arr(i)).lt.1.E-3) L2 = i                         06NOV00.118
          enddo                                                                  06NOV00.119
                                                                                 06NOV00.120
          write(*,331)ARR(LNONMN),ARR(L2), ARR(L1)                               06NOV00.121
 331      FORMAT('     INTERPOLATING TO LEVEL ',F5.0,' FROM LEVELS ',            06NOV00.122
     &     F5.0, ' AND ', F5.0, ' (OR SFC AS APPROPRIATE).')                     06NOV00.123
                                                                                 06NOV00.124
          ! READ IN DATA FROM WHICH WE INTERPOLATE                               06NOV00.125
          CALL HRZFIL(1,L1,IVRBL,2,HORZH,IH1,IH2,IH3,.FALSE.)                    06NOV00.126
          CALL HRZFIL(1,L2,IVRBL,5,HORZH,IH1,IH2,IH3,.FALSE.)                    06NOV00.127
                                                                                 06NOV00.128
          IF (IVRBL .EQ. ITEMP) THEN                                             06NOV00.129
            LS = 1                                                               06NOV00.130
            IVARSF = IREFT                                                       06NOV00.131
            IVARP = IREFPC                                                       06NOV00.132
          ELSE IF (IVRBL .EQ. IUVEL) THEN                                        06NOV00.133
            LS = NVERT                                                           06NOV00.134
            IVARSF = IREFPC                                                      06NOV00.135
            IVARP = IREFPD                                                       06NOV00.136
          ELSE IF (IVRBL .EQ. IVVEL) THEN                                        06NOV00.137
            LS = NVERT                                                           06NOV00.138
            IVARSF = IREFPD                                                      06NOV00.139
            IVARP = IREFPD                                                       06NOV00.140
          ELSE IF (IVRBL .EQ. IRELH) THEN                                        06NOV00.141
            LS = 1                                                               06NOV00.142
            IVARSF = IREFRH                                                      06NOV00.143
            IVARP = IREFPC                                                       06NOV00.144
          ELSE IF (IVRBL .EQ. IHGT) THEN                                         06NOV00.145
            LS = 1                                                               06NOV00.146
            IVARSF = IHGT                                                        06NOV00.147
            IVARP = IREFPD                                                       06NOV00.148
          ELSE                                                                   06NOV00.149
            STOP130                                                              06NOV00.150
          ENDIF                                                                  06NOV00.151
                                                                                 06NOV00.152
          CALL HRZFIL(1,LS,IVARSF,1,HORZH,IH1,IH2,IH3,.FALSE.) !Sfc Data         06NOV00.153
          CALL HRZFIL(1, 1,IVARP ,4,HORZH,IH1,IH2,IH3,.FALSE.) ! Sfc P           06NOV00.154
                                                                                 06NOV00.155
          DO J = 1,JEND                                                          06NOV00.156
          DO I = 1,IEND                                                          06NOV00.157
            SP = HORZH(I,J,4)                                                    06NOV00.158
                                                                                 06NOV00.159
           ! If both of our bracketing pressure levels are earthward             06NOV00.160
           ! with respect to surface pressure, (and, consequently,               06NOV00.161
           ! our level of interest is earthward wrt surface pressure):           06NOV00.162
            IF (SP.LT.ARR(L1).AND.SP.LT.ARR(L2)) THEN                            06NOV00.163
              VAR1 = HORZH(I,J,2) ! Take data at earthward pressure lvl          06NOV00.164
              XLV1 = ARR(L1)      ! Take the earthward pressure level            06NOV00.165
              VAR2 = HORZH(I,J,5) ! Take data at skyward pressure level          06NOV00.166
              XLV2 = ARR(L2)      ! Take the skyward pressure level              06NOV00.167
                                                                                 06NOV00.168
           ! If both of our bracketing pressure levels are skyward               06NOV00.169
           ! with respect to surface pressure, (and, consequently,               06NOV00.170
           ! our level of interest is skyward wrt surface pressure):             06NOV00.171
            ELSEIF (SP.GT.ARR(L1).AND.SP.GT.ARR(L2)) THEN                        06NOV00.172
              VAR1 = HORZH(I,J,2) ! Take data at earthward pressure lvl          06NOV00.173
              XLV1 = ARR(L1)      ! Take the earthward pressure level            06NOV00.174
              VAR2 = HORZH(I,J,5) ! Take data at skyward pressure level          06NOV00.175
              XLV2 = ARR(L2)      ! Take the skyward pressure level              06NOV00.176
                                                                                 06NOV00.177
           ! If the level of interest is earthward wrt surface pressure,         06NOV00.178
           ! and one bracketing pressure level is earthward wrt SP               06NOV00.179
           ! and the other bracketing pressure level is skyward wrt SP:          06NOV00.180
            ELSEIF ((SP.LE.GNLVL(LPR)) .AND. (SP.LE.ARR(L1)) .AND.               06NOV00.181
     &             (SP.GE.ARR(L2))) THEN                                         06NOV00.182
              VAR1 = HORZH(I,J,2) ! Take data at groundward p-level              06NOV00.183
              XLV1 = ARR(L1)      ! Take the groundward pressure level           06NOV00.184
              VAR2=HORZH(I,J,1)   ! Take the surface Data                        06NOV00.185
              XLV2 = SP           ! Take the surface pressure level              06NOV00.186
                                                                                 06NOV00.187
           ! If the level of interest is skyward wrt surface pressure,           06NOV00.188
           ! and one bracketing pressure level is earthward wrt SP               06NOV00.189
           ! and the other bracketing pressure level is skyward wrt SP:          06NOV00.190
            ELSEIF ((SP.GE.GNLVL(LPR)) .AND. (SP.LE.ARR(L1)) .AND.               06NOV00.191
     &             (SP.GE.ARR(L2))) THEN                                         06NOV00.192
              VAR1=HORZH(I,J,1)   ! Take the surface Data                        06NOV00.193
              XLV1 = SP           ! Take the surface pressure level              06NOV00.194
              VAR2 = HORZH(I,J,5) ! Take data at skyward pressure level          06NOV00.195
              XLV2 = ARR(L2)      ! Take the skyward pressure level              06NOV00.196
                                                                                 06NOV00.197
            ELSE                                                                 06NOV00.198
               print*, 'i, j = ', i, j                                           06NOV00.199
               print*, 'SP = ', SP                                               06NOV00.200
               print*, 'GNLVL(LPR) = ', GNLVL(LPR)                               06NOV00.201
               print*, 'ARR(L1) = ', ARR(L1)                                     06NOV00.202
               print*, 'ARR(L2) = ', ARR(L2)                                     06NOV00.203
               STOP "MASS CONFUSION"                                             06NOV00.204
            ENDIF                                                                06NOV00.205
                                                                                 06NOV00.206
            if (IVRBL.EQ.IHGT) then                                              06NOV00.207
              VAR1 = HORZH(I,J,2) ! Take data at earthward p-level               06NOV00.208
              XLV1 = ARR(L1)      ! Take the earthward pressure level            06NOV00.209
              VAR2 = HORZH(I,J,5) ! Take data at skyward pressure level          06NOV00.210
              XLV2 = ARR(L2)      ! Take the skyward pressure level              06NOV00.211
            endif                                                                06NOV00.212
C          PERFORM VERTICAL INTERPOLATION :                                      06NOV00.213
            IF (IVRBL.EQ.ITEMP) THEN                                             06NOV00.214
              HORZH(I,J,3)=VAR1+(VAR2-VAR1)*(LOG(GNLVL(LPR)/XLV1)/               06NOV00.215
     &              LOG(XLV2/XLV1))                                              06NOV00.216
            ELSE                                                                 06NOV00.217
              HORZH(I,J,3)=VAR1+(VAR2-VAR1)*(GNLVL(LPR)-XLV1)/                   06NOV00.218
     &              (XLV2-XLV1)                                                  06NOV00.219
            ENDIF                                                                06NOV00.220
          ENDDO                                                                  06NOV00.221
          ENDDO                                                                  06NOV00.222
                                                                                 06NOV00.223
          GO TO 10                                                               06NOV00.224
        ENDIF                                                                    06NOV00.225
      ENDDO                                                                      06NOV00.226
      write(*,116) GNLVL(LPR)                                                    06NOV00.227
 116  format('***** ERROR EXIT:  NEWPLV', //,                                    06NOV00.228
     &     '  BRACKETING LEVELS NOT FOUND FOR NEW LEVEL: ', F8.2,/,              06NOV00.229
     &     '  CHECK YOUR GNLVL SETTINGS CAREFULLY.',/)                           06NOV00.230
      STOP '***** ERROR EXIT: BRACKETING LEVELS NOT FOUND IN NEWPLV'             06NOV00.231
 10   CONTINUE                                                                   06NOV00.232
      CALL HRZFIL(1,LNONMN,IVRBL,3,HORZH,IH1,IH2,IH3,.TRUE.)                     06NOV00.233
C                                                                                06NOV00.234
      CALL FILSLB(LNONMN,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                06NOV00.235
      IF (DORC(IVRBL) .NE. 'DOT') THEN                                           06NOV00.236
        DO I = 1,IMAX                                                            06NOV00.237
          SLAB1(I,JMAX) = 1.E36                                                  06NOV00.238
        ENDDO                                                                    06NOV00.239
        DO J = 1,JMAX                                                            06NOV00.240
          SLAB1(IMAX,J) = 1.E36                                                  06NOV00.241
        ENDDO                                                                    06NOV00.242
      ENDIF                                                                      06NOV00.243
      CALL SLBFIL(LNONMN,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                06NOV00.244
      IF(IVRBL.EQ.IHGT .AND. GNLVL(LPR).GE.GLVL(2)) THEN                         06NOV00.245
        DO I = 1,IE                                                              06NOV00.246
          SLAB1(I,JMAX) = SLAB1(I,JE)                                            06NOV00.247
        ENDDO                                                                    06NOV00.248
        DO J = 1,JMAX                                                            06NOV00.249
          SLAB1(IMAX,J) = SLAB1(IE,J)                                            06NOV00.250
        ENDDO                                                                    06NOV00.251
        CALL SLBFIL(LNONMN,IVRBL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              06NOV00.252
      ENDIF                                                                      06NOV00.253
      RETURN                                                                     06NOV00.254
      END                                                                        06NOV00.255
