      SUBROUTINE OUTPT(FLD,IYY,IA,IB,INY,JXX,JA,JB,JNX,KSIGT,NAME,ILB)           OUTPT.1
C                                                                                OUTPT.2
C                                                                                OUTPT.3
C        PURPOSE: PRINT OUT ARRAY FLD(IYY,JXX);                                  OUTPT.4
C                 X-DIRECTION -- FROM JA TO JB.                                  OUTPT.5
C                 Y-DIRECTION -- FROM IA TO IB.                                  OUTPT.6
C                 IN INPUT ARRAY, THE FIRST DIMENSION IS IN Y-DIRECTION.         OUTPT.7
C                 THE SECOND DIMENSION IS IN X-DIRECTION.                        OUTPT.8
C                 THE PRINT-OUT ARRAY WILL BE INVERTED.                          OUTPT.9
C                                                                                OUTPT.10
C                                                                                OUTPT.11
C        ARGUMENTS:                                                              OUTPT.12
C                                                                                OUTPT.13
C             FLD: THE OUTPUT ARRAY                                              OUTPT.14
C             IYY: THE FIRST DIMENSION FOR FLD                                   OUTPT.15
C             IA : INITIAL POINT IN THE FIRST DIMENSION                          OUTPT.16
C             IB : FINAL POINT IN THE FIRST DIMENSION                            OUTPT.17
C             INY: INTERVAL FOR THE FIRST DIMENSION                              OUTPT.18
C             JXX: THE SECOND DIMENSION FOR FLD                                  OUTPT.19
C             JA : INITIAL POINT IN THE SECOND DIMENSION                         OUTPT.20
C             JB : FINAL POINT IN THE SECOND DIMENSION                           OUTPT.21
C             JNX: INTERVAL FOR THE SECOND DIMENSION                             OUTPT.22
C             KSIGT: SIGNIFICANT DIGITS NEEDED                                   OUTPT.23
C             NAME: CHARACTER NAME FOR ARRAY FLD(IYY,JXX)                        OUTPT.24
C                                                                                OUTPT.25
C                                                                                OUTPT.26
C                                                                                OUTPT.27
      DIMENSION FLD(JXX,IYY), JM(1000)                                           OUTPT.28
      CHARACTER IFMT1*24, IFMT2*24                                               OUTPT.29
      CHARACTER NAME*32                                                          OUTPT.30
      INTEGER EXPON                                                              OUTPT.31
      CALL VTRAN(FLD,IYY,JXX)                                                    OUTPT.32
      N = 6                                                                      OUTPT.33
      K1 = KSIGT + 2                                                             OUTPT.34
      IWIDTH=132                                                                 OUTPT.35
      K2 = (IWIDTH-8)/K1                                                         OUTPT.36
      K3 = KSIGT/2                                                               OUTPT.37
      K4 = (KSIGT - K3) - 1                                                      06NOV00.258
C                                                                                OUTPT.39
C        SCALING:                                                                OUTPT.40
C                                                                                OUTPT.41
      FLDMAX = 0.                                                                OUTPT.42
      FLDU = 10.**KSIGT                                                          OUTPT.43
      FLDL = 10.**(KSIGT-1)                                                      OUTPT.44
      DO 10 J = JA,JB,JNX                                                        OUTPT.45
      DO 10 I = IA,IB,INY                                                        OUTPT.46
      IF(ABS(FLD(J,I)).GT. 1.E30 .OR. ABS(FLD(J,I)).LT. 1.E-30)                  OUTPT.47
     1  GO TO 10                                                                 OUTPT.48
      IF(ABS(FLD(J,I)) .GT. FLDMAX) FLDMAX = ABS(FLD(J,I))                       OUTPT.49
  10  CONTINUE                                                                   OUTPT.50
      IF(FLDMAX .EQ. 0.) GO TO 140                                               OUTPT.51
      EXPON=0                                                                    OUTPT.52
      DO 40 N1 = 1,500                                                           OUTPT.53
      IF(FLDMAX .GE. FLDU) GO TO 20                                              OUTPT.54
      IF(FLDMAX .LT. FLDL) GO TO 30                                              OUTPT.55
      IF(FLDMAX.LT.FLDU .AND. FLDMAX.GE.FLDL) GO TO 50                           OUTPT.56
  20  FLDMAX = FLDMAX/10.                                                        OUTPT.57
      EXPON=EXPON-1                                                              OUTPT.58
      GO TO 40                                                                   OUTPT.59
  30  FLDMAX = FLDMAX*10.                                                        OUTPT.60
      EXPON=EXPON+1                                                              OUTPT.61
  40  CONTINUE                                                                   OUTPT.62
  50  CONTINUE                                                                   OUTPT.63
      POWER=10.**EXPON                                                           OUTPT.64
C                                                                                OUTPT.65
      JX = JB - JA + 1                                                           OUTPT.66
      IY = IB - IA + 1                                                           OUTPT.67
      JN = K2*JNX                                                                OUTPT.68
      JN1 = JN - 1                                                               OUTPT.69
      IF(ILB.GT.5) THEN                                                          OUTPT.70
         PRINT 69,EXPON                                                          OUTPT.71
      ELSE                                                                       OUTPT.72
         WRITE(N,70) NAME,EXPON                                                  OUTPT.73
      END IF                                                                     OUTPT.74
  69  FORMAT(' ',75X,'SCALED BY 1.E',I3)                                         OUTPT.75
  70  FORMAT(////' THIS IS A LIST OF   ',A32,'  , SCALED BY 1.E',I3)             OUTPT.76
      DO 120 J1 = JA,JB,JN                                                       OUTPT.77
      JL = MIN0(J1+JN1,JB)                                                       OUTPT.78
      JT = JL - J1 + 1                                                           OUTPT.79
      JTN = (JT-1)/JNX + 1                                                       OUTPT.80
      DO 80 J2 = 1,JT,JNX                                                        OUTPT.81
  80  JM(J2) = J1 + J2 - 1                                                       OUTPT.82
      WRITE(IFMT1,90)JTN,K4,K3                                                   OUTPT.83
  90  FORMAT('(/4X,',I2,'(',I2,'X,I3,',I2,'X)/)')                                06NOV00.259
      WRITE(N,IFMT1) (JM(JJ),JJ=1,JT,JNX)                                        OUTPT.85
      WRITE(IFMT2,100) JTN,K1                                                    OUTPT.86
 100  FORMAT('(1X,I3,',I2,'F',I2,'.0,2X,I3)')                                    OUTPT.87
      IT = (IY-1)/INY                                                            OUTPT.88
      IR = IY - IT*INY                                                           OUTPT.89
      DO 110 I2 = IA,IB,INY                                                      OUTPT.90
      I1 = IB + IA - I2 - IR + 1                                                 OUTPT.91
      WRITE(N,IFMT2)I1,(FLOAT(NINT(FLD(J3,I1)*POWER)),J3 = J1,JL,JNX),I1         OUTPT.92
 110  CONTINUE                                                                   OUTPT.93
  120 CONTINUE                                                                   OUTPT.94
      GO TO 160                                                                  OUTPT.95
 140  PRINT 150,FLDMAX                                                           OUTPT.96
 150  FORMAT(/'     ALL OF THE VALUES OF THE ARRAY ARE EQUAL TO ',F10.3)         OUTPT.97
 160  CONTINUE                                                                   OUTPT.98
      CALL VTRAN(FLD,JXX,IYY)                                                    OUTPT.99
      RETURN                                                                     OUTPT.100
      END                                                                        OUTPT.101
