      SUBROUTINE OUTTAP(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,IS1,IS2,LAND,              OUTTAP.1
     &     SNOW,                                                                 OUTTAP.2
     .     SLAB4,SFCPR,LANDC,MAXIC,MAXJC,MDATE,IFILDAT,NSELIM,NBOGUS,            OUTTAP.3
     .     KBOGUS,KX,IFGINT,ISTRTDAT,IFILES,SCR3D,BGR3D)                         OUTTAP.4
                                                                                 OUTTAP.5
C     PURPOSE: WRITE ALL THE DATA FIELDS TO AN OUTPUT FILE, NVOL2.               OUTTAP.6
C     THE OUTPUT FILE INCLUDES THE DATA FIELDS THAT HAVE                         OUTTAP.7
C     HAD STATION OBSERVATIONS BLENDED INTO THE FIRST GUESS                      OUTTAP.8
C     FIELD READ IN FROM NVOL4.  IF IMOIST = TRUE, NVERT                         OUTTAP.9
C     RELATIVE HUMIDITY LEVELS ARE AVAILABLE TO WRITE OUT                        OUTTAP.10
C     FOR DATAFLOW1.                                                             OUTTAP.11
C                                                                                OUTTAP.12
C-----------------------------------------------------------------------         OUTTAP.13
C                                                                                OUTTAP.14
#include <coma.incl>                                                             OUTTAP.15
#include <comd.incl>                                                             OUTTAP.16
#include <hedmif.incl>                                                           OUTTAP.17
C                                                                                OUTTAP.18
      DIMENSION SLAB1(IS1,IS2),SLAB2(IS1,IS2),HORZH(IH1,IH2,IH3),                OUTTAP.19
     .     LAND(IS1,IS2),SNOW(IS1,IS2),                                          OUTTAP.20
     .     SLAB4(MAXIC,MAXJC),SFCPR(IS1,IS2),NSELIM(500),NBOGUS(500),            05DEC01.14
     .     KBOGUS(500),SCR3D(MAXIC,MAXJC,KX)                                     05DEC01.15
      REAL BGR3D(IS1,IS2,KX)                                                     OUTTAP.23
      REAL LANDC(MAXIC,MAXJC)                                                    OUTTAP.24
      LOGICAL NBOGUS,KBOGUS,NSELIM                                               OUTTAP.25
      character*8 name                                                           OUTTAP.26
      character*24 MDATE, ISTRTDAT                                               OUTTAP.27
      character*14 flnm                                                          OUTTAP.28
      integer SYY,SMO,SDY,SHR,SMI,SSC,SFR                                        OUTTAP.29
      logical lopen                                                              OUTTAP.30
      PRINT 10, mdate(1:19)                                                      OUTTAP.31
 10   FORMAT(//////1X,'@@@@@@@@@@ CALL OUTTAP---(FILSLB),WTAPE',12X,             OUTTAP.32
     .     'OUTPT TO DATAFLOW', 1X, A19//)                                       OUTTAP.33
                                                                                 OUTTAP.34
      flnm='RAWINS_DOMAIN'//char(mif(13,1)+48)                                   OUTTAP.35
      inquire(file=flnm, opened=lopen)                                           OUTTAP.36
      if (.not. lopen) then                                                      OUTTAP.37
         open(NVOL2, file=flnm, form='unformatted', iostat=ierr,                 OUTTAP.38
     &        status='unknown')                                                  OUTTAP.39
         if (ierr .ne. 0) then                                                   OUTTAP.40
            write(*,'(//,''*****  ERROR EXIT  *****'',/)')                       OUTTAP.41
            print*, 'Problem opening file '//flnm//' for output.'                OUTTAP.42
            call abort()                                                         OUTTAP.43
         endif                                                                   OUTTAP.44
      endif                                                                      OUTTAP.45
                                                                                 OUTTAP.46
C                                                                                OUTTAP.47
C     WRITE HEADER RECORDS                                                       OUTTAP.48
C                                                                                OUTTAP.49
      if (ifildat.eq.1) then                                                     OUTTAP.50
C                                                                                OUTTAP.51
C                                                                                OUTTAP.52
         MIF(8,1) = 0           ! RAWINS OUTPUT IS NOT EXPANDED                  OUTTAP.53
         mif(ntindx,3) = ntotlv ! Put the number of p-levels into the header     OUTTAP.54
         write(NVOL2) 0         ! The big-header flag                            OUTTAP.55
         WRITE(NVOL2) MIF,MRF,MIFC,MRFC                                          OUTTAP.56
         write(NVOL98) 0        ! The big-header flag                            OUTTAP.57
         WRITE(NVOL98) MIF,MRF,MIFC,MRFC                                         OUTTAP.58
      endif                                                                      OUTTAP.59
C                                                                                OUTTAP.60
C                                                                                OUTTAP.61
      DO J = 1, MIFDIM2                                                          OUTTAP.62
         DO I = 1, MIFDIM1                                                       OUTTAP.63
            IF (MIF(I,J).NE.-999) PRINT7754,I,J,MIF(I,J),MIFC(I,J)               OUTTAP.64
 7754       FORMAT('MIF(',I3,',',I1,') = ',I10,' : ',A80)                        OUTTAP.65
         ENDDO                                                                   OUTTAP.66
         DO I = 1, MRFDIM1                                                       OUTTAP.67
            IF (MRF(I,J).NE.-999.) PRINT7756,I,J,MRF(I,J),MRFC(I,J)              OUTTAP.68
 7756       FORMAT('MRF(',I3,',',I1,') =',F10.4,' : ',A80)                       OUTTAP.69
         ENDDO                                                                   OUTTAP.70
      ENDDO                                                                      OUTTAP.71
C                                                                                OUTTAP.72
C                                                                                OUTTAP.73
C     REDUCE LAND USE ARRAY IF EXPANDED                                          OUTTAP.74
C                                                                                OUTTAP.75
      AKP=2./7.                                                                  OUTTAP.76
      DO I = 1, MAXIC                                                            OUTTAP.77
         DO J = 1, MAXJC                                                         OUTTAP.78
            LANDC(I,J) =                                                         OUTTAP.79
     .           FLOAT(LAND(INC+I,INC+J))                                        OUTTAP.80
         ENDDO                                                                   OUTTAP.81
      ENDDO                                                                      OUTTAP.82
      NTOTAL=NTOTLV                                                              OUTTAP.83
      DO I3D = 1, NUMV3FLDS                                                      OUTTAP.84
         NAME = sh_name(I3D)(1:8)                                                OUTTAP.85
         print*, 'NAME = ', NAME                                                 OUTTAP.86
         IF (NAME.EQ.'PRESSURE') THEN                                            OUTTAP.87
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.88
            WRITE(NVOL2) 1, 1, 1, 1, 1, KX, 1, 1, 1, 0.,                         OUTTAP.89
     &           sh_stagger(i3d),                                                OUTTAP.90
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.91
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.92
            print*, (ALLVL(N),N=1,KX)                                            OUTTAP.93
            WRITE(NVOL2) ((ALLVL(N)*100.),N=1,KX)                                OUTTAP.94
                                                                                 06NOV00.260
            WRITE(NVOL98) 1                                                      06NOV00.261
            WRITE(NVOL98) 1, 1, 1, 1, 1, KX, 1, 1, 1, 0.,                        06NOV00.262
     &           sh_stagger(i3d),                                                06NOV00.263
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.264
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.265
            WRITE(NVOL98) ((ALLVL(N)*100.),N=1,KX)                               06NOV00.266
                                                                                 06NOV00.267
         ELSEIF (NAME.EQ.'T') THEN                                               OUTTAP.95
C                                                                                OUTTAP.96
C     REMOVE SUPER ADIABATIC LAPSE RATES IN ALL LAYERS BELOW 500MB               OUTTAP.97
C                                                                                OUTTAP.98
            ICCC=0                                                               OUTTAP.99
            DO 30 LL=LEVEL1,NTOTAL                                               OUTTAP.100
               IF(LL.EQ.NTOTAL) GO TO 30                                         OUTTAP.101
               LT=NTOTAL-LL+LEVEL1                                               OUTTAP.102
               LTT=LT-1                                                          OUTTAP.103
               L=LVL(LT)                                                         OUTTAP.104
               LB=LVL(LTT)                                                       OUTTAP.105
               LP=L+2                                                            OUTTAP.106
               LPB=LB+2                                                          OUTTAP.107
               KP=0                                                              OUTTAP.108
               IF(L.GT.NVERT) THEN                                               OUTTAP.109
                  KP=GNLVL(L-NVERT)                                              OUTTAP.110
                  LP=NVERT+2                                                     OUTTAP.111
               END IF                                                            OUTTAP.112
               KPB=0                                                             OUTTAP.113
               IF(LB.GT.NVERT) THEN                                              OUTTAP.114
                  KPB=GNLVL(LB-NVERT)                                            OUTTAP.115
                  LPB=NVERT+2                                                    OUTTAP.116
               END IF                                                            OUTTAP.117
               APRES=IPRES(LP)                                                   OUTTAP.118
               BPRES=IPRES(LPB)                                                  OUTTAP.119
               IF(KP.GT.0) APRES=KP                                              OUTTAP.120
               IF(KPB.GT.0) BPRES=KPB                                            OUTTAP.121
               IF(APRES.LT.499.)GO TO 30                                         OUTTAP.122
               CALL FILSLB(L,ITEMP,1,HORZH,IH1,IH2,IH3,SLAB2,IS1,IS2)            OUTTAP.123
               CALL FILSLB(LB,ITEMP,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)           OUTTAP.124
               DO I=1,IE                                                         OUTTAP.125
                  SLAB1(I,JMAX)=SLAB1(I,JE)                                      OUTTAP.126
                  SLAB2(I,JMAX)=SLAB2(I,JE)                                      OUTTAP.127
               ENDDO                                                             OUTTAP.128
               DO  J=1,JMAX                                                      OUTTAP.129
                  SLAB1(IMAX,J)=SLAB1(IE,J)                                      OUTTAP.130
                  SLAB2(IMAX,J)=SLAB2(IE,J)                                      OUTTAP.131
               ENDDO                                                             OUTTAP.132
               DO I=1,IMAX                                                       OUTTAP.133
                  DO J=1,JMAX                                                    OUTTAP.134
                     PRTH2=(SLAB2(I,J)+273.15)*(1000./APRES)**AKP                OUTTAP.135
                     PRTH1=(SLAB1(I,J)+273.15)*(1000./BPRES)**AKP                OUTTAP.136
                     IF(PRTH1.GT.PRTH2) THEN                                     OUTTAP.137
                        ICCC=ICCC+1                                              OUTTAP.138
                        THOLD=SLAB1(I,J)                                         OUTTAP.139
                        TMPNEW=(PRTH2-0.1)/(1000./BPRES)**AKP                    OUTTAP.140
                        SLAB1(I,J)=TMPNEW-273.15                                 OUTTAP.141
                     END IF                                                      OUTTAP.142
                  ENDDO                                                          OUTTAP.143
               ENDDO                                                             OUTTAP.144
               CALL SLBFIL(LB,ITEMP,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)           OUTTAP.145
 30         CONTINUE                                                             OUTTAP.146
            PRINT 40,ICCC                                                        OUTTAP.147
 40   FORMAT(1H0,I7,' TEMPS ADJUSTED TO REMOVE SUPER ADIABATIC LAPSE ',          OUTTAP.148
     .           'RATES AT PRES LEVELS <><><><><><><><><><><><><>'/)             OUTTAP.149
            CALL FILSLB(1,IREFT,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.150
C                                                                                OUTTAP.151
C     REMOVE SUPER ADIABATIC LAPSE RATES IN THE SURFACE LAYER                    OUTTAP.152
C                                                                                OUTTAP.153
            APHLD=1050.                                                          OUTTAP.154
            JCCC=0                                                               OUTTAP.155
            DO 60 LL=LEVEL1,NTOTAL                                               OUTTAP.156
               L=LVL(LL)                                                         OUTTAP.157
               LP=L+2                                                            OUTTAP.158
               KP=0                                                              OUTTAP.159
               IF(L.GT.NVERT) THEN                                               OUTTAP.160
                  KP=GNLVL(L-NVERT)                                              OUTTAP.161
                  LP=NVERT+2                                                     OUTTAP.162
               END IF                                                            OUTTAP.163
               APRES=IPRES(LP)                                                   OUTTAP.164
               IF(KP.GT.0) APRES=KP                                              OUTTAP.165
               IF(APRES.LT.499.)GO TO 60                                         OUTTAP.166
               CALL FILSLB(L,ITEMP,1,HORZH,IH1,IH2,IH3,SLAB2,IS1,IS2)            OUTTAP.167
               DO I = 1, IE                                                      OUTTAP.168
                  SLAB2(I,JMAX)=SLAB2(I,JE)                                      OUTTAP.169
               ENDDO                                                             OUTTAP.170
               DO J = 1, JMAX                                                    OUTTAP.171
                  SLAB2(IMAX,J)=SLAB2(IE,J)                                      OUTTAP.172
               ENDDO                                                             OUTTAP.173
               DO I=1,IMAX                                                       OUTTAP.174
                  DO J=1,JMAX                                                    OUTTAP.175
                     IF(SFCPR(I,J).LT.APRES.OR.SFCPR(I,J).GE.APHLD)              OUTTAP.176
     &                    GO TO 50                                               OUTTAP.177
                     PRSTH=(SLAB2(I,J)+273.15)*(1000./APRES)**AKP                OUTTAP.178
                     SFCTH=(SLAB1(I,J)+273.15)*(1000./SFCPR(I,J))**AKP           OUTTAP.179
                     IF(SFCTH.GT.PRSTH) THEN                                     OUTTAP.180
                        JCCC=JCCC+1                                              OUTTAP.181
                        THOLD=SLAB1(I,J)                                         OUTTAP.182
                        TMPNEW=(PRSTH-0.1)/(1000./SFCPR(I,J))**AKP               OUTTAP.183
                        SLAB1(I,J)=TMPNEW-273.15                                 OUTTAP.184
                     END IF                                                      OUTTAP.185
 50                  CONTINUE                                                    OUTTAP.186
                  ENDDO                                                          OUTTAP.187
               ENDDO                                                             OUTTAP.188
               APHLD=APRES                                                       OUTTAP.189
 60         CONTINUE                                                             OUTTAP.190
            PRINT 70,JCCC                                                        OUTTAP.191
 70   FORMAT(1H0,I7,' SFC TEMPS ADJUSTED TO REMOVE SUPER ADIABATIC ',            OUTTAP.192
     .           'LAPSE RATES <><><><><><><><><><><><><>'/)                      OUTTAP.193
            DO I = 1, MAXIC                                                      OUTTAP.194
               DO J = 1, MAXJC                                                   OUTTAP.195
                  SCR3D(I,J,1)=SLAB1(INC+I,INC+J)                                OUTTAP.196
               ENDDO                                                             OUTTAP.197
            ENDDO                                                                OUTTAP.198
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.199
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.200
     &           sh_stagger(i3d),                                                OUTTAP.201
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.202
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.203
            DO I = 1, IS1                                                        06NOV00.268
               DO J = 1, IS2                                                     06NOV00.269
                  SLAB1(I,J) = SLAB1(I,J) + 273.15                               06NOV00.270
               ENDDO                                                             06NOV00.271
            ENDDO                                                                06NOV00.272
            WRITE(NVOL98)SLAB1                                                   OUTTAP.204
C                                                                                OUTTAP.205
C     WRITE TEMPS FOR HIGHER LEVELS AT CROSS PTS                                 OUTTAP.206
C                                                                                OUTTAP.207
            WRITE (6,80)                                                         OUTTAP.208
 80         FORMAT(1H ,2X,'WRITE TEMP AT SFC AND PRESSURE LEVELS '               OUTTAP.209
     &           //'(CROSS PTS)---------------------------------------')         OUTTAP.210
            DO 90 LL = LEVEL1,NTOTAL                                             OUTTAP.211
               L = LVL(LL)                                                       OUTTAP.212
               CALL FILSLB(L,ITEMP,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)            OUTTAP.213
               DO I = 1, IE                                                      OUTTAP.214
                  SLAB1(I,JMAX) = SLAB1(I,JE)                                    OUTTAP.215
               ENDDO                                                             OUTTAP.216
               DO J = 1, JMAX                                                    OUTTAP.217
                  SLAB1(IMAX,J) = SLAB1(IE,J)                                    OUTTAP.218
               ENDDO                                                             OUTTAP.219
               LP = L + 2                                                        OUTTAP.220
               KP = 0                                                            OUTTAP.221
               IF (L .GT. NVERT) KP = GNLVL(L-NVERT)                             OUTTAP.222
               IF(L.GT.NVERT) LP=NVERT+2                                         OUTTAP.223
               DO I = 1, MAXIC                                                   OUTTAP.224
                  DO J = 1, MAXJC                                                OUTTAP.225
                     SCR3D(I,J,LL)=SLAB1(INC+I,INC+J)                            OUTTAP.226
                  ENDDO                                                          OUTTAP.227
               ENDDO                                                             OUTTAP.228
               WRITE(NVOL98) 1  ! The small-header flag                          OUTTAP.229
               WRITE(NVOL98) 2, 1, 1, LL, 1, IS1, IS2, LL, 1, 0.,                06NOV00.273
     &              sh_stagger(i3d), sh_order(i3d), mdate, sh_name(i3d),         OUTTAP.231
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.232
               DO I = 1, IS1                                                     06NOV00.274
                  DO J = 1, IS2                                                  06NOV00.275
                     SLAB1(I,J) = SLAB1(I,J) + 273.15                            06NOV00.276
                  ENDDO                                                          06NOV00.277
               ENDDO                                                             06NOV00.278
               WRITE(NVOL98)SLAB1                                                OUTTAP.233
 90         CONTINUE                                                             OUTTAP.234
            DO I = 1, MAXIC                                                      OUTTAP.235
               DO J = 1, MAXJC                                                   OUTTAP.236
                  DO K = 1, KX                                                   OUTTAP.237
                     SCR3D(I,J,K)=SCR3D(I,J,K)+273.15                            OUTTAP.238
                  ENDDO                                                          OUTTAP.239
               ENDDO                                                             OUTTAP.240
            ENDDO                                                                OUTTAP.241
            WRITE(NVOL2) 1      ! The small-header flag                          OUTTAP.242
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 OUTTAP.243
     &           sh_stagger(i3d), sh_order(i3d), mdate, sh_name(i3d),            OUTTAP.244
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.245
            WRITE(NVOL2)SCR3D                                                    OUTTAP.246
                                                                                 OUTTAP.247
            DO LL = 1, NTOTAL                                                    OUTTAP.248
               WRITE(6,209) ALLVL(LL),SCR3D(1,1,LL)                              OUTTAP.249
 209  FORMAT(1X,'AN OUTPUT FIELD (TEMP)',20X,'HAS BEEN WRITTEN TO ',             OUTTAP.250
     .              'UNIT  2.  THE VALUE AT I,J,P=1,1,',F6.1,' IS',F9.3)         OUTTAP.251
            ENDDO                                                                OUTTAP.252
         ELSEIF (NAME.EQ.'U') THEN                                               OUTTAP.253
C                                                                                OUTTAP.254
C     GET SURFACE U AT DOT POINTS (STORED IN NVERT LAYER OF                      OUTTAP.255
C     IREFPC).                                                                   OUTTAP.256
C                                                                                OUTTAP.257
            L1 = NVERT                                                           OUTTAP.258
            ISFCU = IREFPC                                                       OUTTAP.259
            CALL FILSLB(L1,ISFCU,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              OUTTAP.260
            DO I = 1, MAXIC                                                      OUTTAP.261
               DO J = 1, MAXJC                                                   OUTTAP.262
                  SCR3D(I,J,1)=SLAB1(INC+I,INC+J)                                OUTTAP.263
               ENDDO                                                             OUTTAP.264
            ENDDO                                                                OUTTAP.265
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.266
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.267
     &           sh_stagger(i3d), sh_order(i3d), mdate, sh_name(i3d),            OUTTAP.268
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.269
            WRITE(NVOL98)SLAB1                                                   OUTTAP.270
C                                                                                OUTTAP.271
C     WRITE U                                                                    OUTTAP.272
C                                                                                OUTTAP.273
            WRITE (6,110)                                                        OUTTAP.274
 110  FORMAT(1H ,2X,'WRITE U AT SFC AND PRESSURE LEVELS (DOT POINTS)--',         OUTTAP.275
     .'-------------------------------------------------------------')           OUTTAP.276
            DO 120 LL = LEVEL1,NTOTAL                                            OUTTAP.277
               L = LVL(LL)                                                       OUTTAP.278
               LP = L + 2                                                        OUTTAP.279
               KP = 0                                                            OUTTAP.280
               IF (L .GT. NVERT) KP = GNLVL(L-NVERT)                             OUTTAP.281
               IF(L.GT.NVERT) LP=NVERT+2                                         OUTTAP.282
               CALL FILSLB(L,IUVEL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)            OUTTAP.283
               DO I = 1, MAXIC                                                   OUTTAP.284
                  DO J = 1, MAXJC                                                OUTTAP.285
                     SCR3D(I,J,LL)=SLAB1(INC+I,INC+J)                            OUTTAP.286
                  ENDDO                                                          OUTTAP.287
               ENDDO                                                             OUTTAP.288
               WRITE(NVOL98) 1  ! The small-header flag                          OUTTAP.289
               WRITE(NVOL98) 2, 1, 1, LL, 1, IS1, IS2, LL, 1, 0.,                06NOV00.279
     &              sh_stagger(i3d), sh_order(i3d), mdate, sh_name(i3d),         OUTTAP.291
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.292
               WRITE(NVOL98)SLAB1                                                OUTTAP.293
 120        CONTINUE                                                             OUTTAP.294
            WRITE(NVOL2) 1      ! The small-header flag                          OUTTAP.295
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 OUTTAP.296
     &           sh_stagger(i3d),                                                OUTTAP.297
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.298
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.299
            WRITE(NVOL2)SCR3D                                                    OUTTAP.300
            DO LL = 1, NTOTAL                                                    OUTTAP.301
               WRITE(6,208) ALLVL(LL),SCR3D(1,1,LL)                              OUTTAP.302
 208  FORMAT(1X,'AN OUTPUT FIELD (U)',23X,'HAS BEEN WRITTEN TO ',                OUTTAP.303
     .              'UNIT  2.  THE VALUE AT I,J,P=1,1,',F6.1,' IS',F9.3)         OUTTAP.304
            ENDDO                                                                OUTTAP.305
         ELSEIF (NAME.EQ.'V') THEN                                               OUTTAP.306
C                                                                                OUTTAP.307
C     WRITE SURFACE V AT DOT POINTS (STORED IN NVERT LAYER OF                    OUTTAP.308
C     IREFPD).                                                                   OUTTAP.309
C                                                                                OUTTAP.310
            L1 = NVERT                                                           OUTTAP.311
            ISFCV = IREFPD                                                       OUTTAP.312
            CALL FILSLB(L1,ISFCV,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              OUTTAP.313
            DO I = 1, MAXIC                                                      OUTTAP.314
               DO J = 1, MAXJC                                                   OUTTAP.315
                  SCR3D(I,J,1)=SLAB1(INC+I,INC+J)                                OUTTAP.316
               ENDDO                                                             OUTTAP.317
            ENDDO                                                                OUTTAP.318
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.319
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.320
     &           sh_stagger(i3d),                                                OUTTAP.321
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.322
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.323
            WRITE(NVOL98)SLAB1                                                   OUTTAP.324
C                                                                                OUTTAP.325
C     WRITE V                                                                    OUTTAP.326
C                                                                                OUTTAP.327
            WRITE (6,140)                                                        OUTTAP.328
 140  FORMAT(1H ,2X,'WRITE V AT SFC AND PRESSURE LEVELS (DOT POINTS)--',         OUTTAP.329
     .'-------------------------------------------------------------')           OUTTAP.330
            DO 150 LL = LEVEL1,NTOTAL                                            OUTTAP.331
               L = LVL(LL)                                                       OUTTAP.332
               LP = L + 2                                                        OUTTAP.333
               KP = 0                                                            OUTTAP.334
               IF (L .GT. NVERT) KP = GNLVL(L-NVERT)                             OUTTAP.335
               IF(L.GT.NVERT) LP=NVERT+2                                         OUTTAP.336
               CALL FILSLB(L,IVVEL,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)            OUTTAP.337
               DO I = 1, MAXIC                                                   OUTTAP.338
                  DO J = 1, MAXJC                                                OUTTAP.339
                     SCR3D(I,J,LL)=SLAB1(INC+I,INC+J)                            OUTTAP.340
                  ENDDO                                                          OUTTAP.341
               ENDDO                                                             OUTTAP.342
               WRITE(NVOL98) 1  ! The small-header flag                          OUTTAP.343
               WRITE(NVOL98) 2, 1, 1, LL, 1, IS1, IS2, LL, 1, 0.,                06NOV00.280
     &              sh_stagger(i3d),                                             OUTTAP.345
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.346
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.347
               WRITE(NVOL98)SLAB1                                                OUTTAP.348
 150        CONTINUE                                                             OUTTAP.349
            WRITE(NVOL2) 1      ! The small-header flag                          OUTTAP.350
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 OUTTAP.351
     &           sh_stagger(i3d),                                                OUTTAP.352
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.353
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.354
            WRITE(NVOL2)SCR3D                                                    OUTTAP.355
            DO LL = 1, NTOTAL                                                    OUTTAP.356
               WRITE(6,207) ALLVL(LL),SCR3D(1,1,LL)                              OUTTAP.357
 207  FORMAT(1X,'AN OUTPUT FIELD (V)',23X,'HAS BEEN WRITTEN TO ',                OUTTAP.358
     .              'UNIT  2.  THE VALUE AT I,J,P=1,1,',F6.1,' IS',F9.3)         OUTTAP.359
            ENDDO                                                                OUTTAP.360
         ELSEIF (NAME.EQ.'H') THEN                                               OUTTAP.361
C                                                                                OUTTAP.362
C     WRITE GEOPOTENTIAL HEIGHTS                                                 OUTTAP.363
C                                                                                OUTTAP.364
            WRITE (6,160)                                                        OUTTAP.365
 160  FORMAT(1H ,2X,'WRITE GEOPOTENTIAL AT PRESSURE LEVELS (DOT POINTS',         OUTTAP.366
     .')------------------------------------------------------------')           OUTTAP.367
C     WRITE TERRAIN HEIGHT AS SURFACE GEOPOTENTIAL HEIGHT.                       OUTTAP.368
            CALL FILSLB(1,IREFH,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.369
            DO I = 1, MAXIC                                                      OUTTAP.370
               DO J = 1, MAXJC                                                   OUTTAP.371
                  SCR3D(I,J,1) = SLAB1(INC+I,INC+J)                              OUTTAP.372
               ENDDO                                                             OUTTAP.373
            ENDDO                                                                OUTTAP.374
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.375
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.376
     &           sh_stagger(i3d),                                                OUTTAP.377
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.378
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.379
            WRITE(NVOL98)SLAB1                                                   OUTTAP.380
! MAKE TERRAIN DOT-POINT FOR THE GEOPOTENTIAL HEIGHT FIELD.                      OUTTAP.381
            CALL DOTS(SCR3D(1,1,1),SLAB4,MAXIC,MAXJC,MAXIC,MAXJC)                OUTTAP.382
            DO I = 1, MAXIC                                                      OUTTAP.383
               DO J = 1, MAXJC                                                   OUTTAP.384
                  SCR3D(I,J,1) = SLAB4(I,J)                                      OUTTAP.385
               ENDDO                                                             OUTTAP.386
            ENDDO                                                                OUTTAP.387
! DONE WITH MAKING THE TERRAIN DOT-POINT FOR THIS OUTPUT ARRAY                   OUTTAP.388
                                                                                 OUTTAP.389
            DO 170 LL = LEVEL1,NTOTAL                                            OUTTAP.390
               L = LVL(LL)                                                       OUTTAP.391
               CALL FILSLB(L,IHGT,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)             OUTTAP.392
               LP = L + 2                                                        OUTTAP.393
               KP = 0                                                            OUTTAP.394
               IF (L .GT. NVERT) KP = GNLVL(L-NVERT)                             OUTTAP.395
               IF(L.GT.NVERT) LP=NVERT+2                                         OUTTAP.396
               DO I = 1, MAXIC                                                   OUTTAP.397
                  DO J = 1, MAXJC                                                OUTTAP.398
                     SCR3D(I,J,LL)=SLAB1(INC+I,INC+J)                            OUTTAP.399
                  ENDDO                                                          OUTTAP.400
               ENDDO                                                             OUTTAP.401
               WRITE(NVOL98) 1  ! The small-header flag                          OUTTAP.402
               WRITE(NVOL98) 2, 1, 1, LL, 1, IS1, IS2, LL, 1, 0.,                06NOV00.281
     &              sh_stagger(i3d),                                             OUTTAP.404
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.405
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.406
               WRITE(NVOL98)SLAB1                                                OUTTAP.407
 170        CONTINUE                                                             OUTTAP.408
            WRITE(NVOL2) 1      ! The small-header flag                          OUTTAP.409
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 OUTTAP.410
     &           sh_stagger(i3d),                                                OUTTAP.411
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.412
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.413
            WRITE(NVOL2)SCR3D                                                    OUTTAP.414
            DO LL = 1, NTOTAL                                                    OUTTAP.415
               WRITE(6,206) ALLVL(LL),SCR3D(1,1,LL)                              OUTTAP.416
 206           FORMAT(1X,'AN OUTPUT FIELD (GEOPOTENTIAL)',13X,                   OUTTAP.417
     &          'HAS BEEN WRITTEN TO UNIT  2.  THE VALUE AT I,J,P=1,1,',         OUTTAP.418
     &           F6.1,' IS',F9.3)                                                OUTTAP.419
            ENDDO                                                                OUTTAP.420
         ELSEIF (NAME.EQ.'RH') THEN                                              OUTTAP.421
C                                                                                OUTTAP.422
C     WRITE RELATIVE HUMIDITY AT CROSS POINTS                                    OUTTAP.423
C                                                                                OUTTAP.424
            WRITE (6,180)                                                        OUTTAP.425
 180  FORMAT(1H ,2X,'WRITE R. H. AT SFC AND PRESSURE LEVELS (CROSS PTS',         OUTTAP.426
     .')--------------------------------------------------------------')         OUTTAP.427
            CALL FILSLB(1,IREFRH,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              OUTTAP.428
            DO I = 1, MAXIC                                                      OUTTAP.429
               DO J = 1, MAXJC                                                   OUTTAP.430
                  SCR3D(I,J,1)=SLAB1(INC+I,INC+J)                                OUTTAP.431
               ENDDO                                                             OUTTAP.432
            ENDDO                                                                OUTTAP.433
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.434
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.435
     &           sh_stagger(i3d),                                                OUTTAP.436
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.437
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.438
            WRITE(NVOL98)SLAB1                                                   OUTTAP.439
            DO 190 LL = LEVEL1,NTOTAL                                            OUTTAP.440
               L = LVL(LL)                                                       OUTTAP.441
               CALL FILSLB(L,IRELH,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)            OUTTAP.442
               DO I = 1, IE                                                      OUTTAP.443
                  SLAB1(I,JMAX) = SLAB1(I,JE)                                    OUTTAP.444
               ENDDO                                                             OUTTAP.445
               DO J = 1, JMAX                                                    OUTTAP.446
                  SLAB1(IMAX,J) = SLAB1(IE,J)                                    OUTTAP.447
               ENDDO                                                             OUTTAP.448
               LP = L + 2                                                        OUTTAP.449
               KP = 0                                                            OUTTAP.450
               IF (L .GT. NVERT) KP = GNLVL(L-NVERT)                             OUTTAP.451
               IF(L.GT.NVERT) LP=NVERT+2                                         OUTTAP.452
               DO I = 1, MAXIC                                                   OUTTAP.453
                  DO J = 1, MAXJC                                                OUTTAP.454
                     SCR3D(I,J,LL)=SLAB1(INC+I,INC+J)                            OUTTAP.455
                  ENDDO                                                          OUTTAP.456
               ENDDO                                                             OUTTAP.457
               WRITE(NVOL98) 1  ! The small-header flag                          OUTTAP.458
               WRITE(NVOL98) 2, 1, 1, LL, 1, IS1, IS2, LL, 1, 0.,                06NOV00.282
     &              sh_stagger(i3d),                                             OUTTAP.460
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.461
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.462
               WRITE(NVOL98)SLAB1                                                OUTTAP.463
 190        CONTINUE                                                             OUTTAP.464
            WRITE(NVOL2) 1      ! The small-header flag                          OUTTAP.465
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 OUTTAP.466
     &           sh_stagger(i3d),                                                OUTTAP.467
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.468
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.469
            WRITE(NVOL2) SCR3D                                                   OUTTAP.470
            DO LL = 1, NTOTAL                                                    OUTTAP.471
               WRITE(6,205) ALLVL(LL),SCR3D(1,1,LL)                              OUTTAP.472
 205           FORMAT(1X,'AN OUTPUT FIELD (REL. HUM.)',15X,                      OUTTAP.473
     &          'HAS BEEN WRITTEN TO UNIT  2.  THE VALUE AT I,J,P=1,1,',         OUTTAP.474
     &              F6.1,' IS',F9.3)                                             OUTTAP.475
            ENDDO                                                                OUTTAP.476
C                                                                                OUTTAP.477
C     *** WRITE TERRAIN AND LAND USE AT CROSS PTS                                OUTTAP.478
C                                                                                OUTTAP.479
         ELSEIF (NAME.EQ.'TERRAIN') THEN                                         OUTTAP.480
            CALL FILSLB(1,IREFH,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.481
            WRITE (6,200)                                                        OUTTAP.482
 200  FORMAT(1H ,2X,'WRITE TERRAIN AND LAND USE AT CROSS PTS ---------',         OUTTAP.483
     .'---------------------------------------------------------------')         OUTTAP.484
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.485
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.486
     &           sh_stagger(i3d),                                                OUTTAP.487
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.488
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.489
                                                                                 06NOV00.283
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.284
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.285
     &           sh_stagger(i3d),                                                06NOV00.286
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.287
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.288
                                                                                 06NOV00.289
            CALL WTAPE(1,IREFH ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.490
     &           1,0)                                                            OUTTAP.491
         ELSE IF (NAME.EQ.'LAND USE') THEN                                       OUTTAP.492
            DO I = 1, IS1                                                        OUTTAP.493
               DO J = 1, IS2                                                     OUTTAP.494
                  SLAB1(I,J) = FLOAT(LAND(I,J))                                  OUTTAP.495
               ENDDO                                                             OUTTAP.496
            ENDDO                                                                OUTTAP.497
            WRITE(NVOL98) 1     ! The small-header flag                          OUTTAP.498
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     OUTTAP.499
     &           sh_stagger(i3d),                                                OUTTAP.500
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.501
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.502
            WRITE(NVOL98) SLAB1                                                  OUTTAP.503
            IF(IEXP) THEN                                                        OUTTAP.504
               WRITE(NVOL2)1   ! The small-header flag                           OUTTAP.505
               WRITE(NVOL2)2, 1, 1, 1, 1, MAXIC,MAXJC,1,1,0.,                    OUTTAP.506
     &              sh_stagger(i3d),                                             OUTTAP.507
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.508
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.509
               WRITE(NVOL2) LANDC                                                OUTTAP.510
               PRINT 210,LANDC(1,1)                                              OUTTAP.511
            ELSE                                                                 OUTTAP.512
               WRITE(NVOL2) 1   ! The small-header flag                          OUTTAP.513
               WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,               OUTTAP.514
     &              sh_stagger(i3d),                                             OUTTAP.515
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.516
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.517
               WRITE(NVOL2) SLAB1                                                OUTTAP.518
               PRINT 210,SLAB1(1,1)                                              OUTTAP.519
            END IF                                                               OUTTAP.520
 210  FORMAT(1X,'AN OUTPUT FIELD(LAND-USE)',17X,'HAS BEEN WRITTEN TO ',          OUTTAP.521
     .     'UNIT  2.  THE VALUE AT I,J=1,1 IS',F9.3,4X,'PRES =  999')            OUTTAP.522
         ELSE IF (NAME.EQ.'MAPFACCR') THEN                                       OUTTAP.523
C                                                                                OUTTAP.524
C     *** WRITE MAP SCALE FACTORS AT CROSS AND DOT POINTS                        OUTTAP.525
C                                                                                OUTTAP.526
            CALL FILSLB(1,IMSC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                OUTTAP.527
            WRITE (6,220)                                                        OUTTAP.528
 220  FORMAT(1H ,2X,'WRITE MAP SCALE(X-DOT),CORIOLIS(DOT) AND LAT,LON(',         OUTTAP.529
     .   'X-DOT)------------------------------------------------------')         OUTTAP.530
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.531
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.532
     &           sh_stagger(i3d),                                                OUTTAP.533
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.534
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.535
                                                                                 06NOV00.290
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.291
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.292
     &           sh_stagger(i3d),                                                06NOV00.293
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.294
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.295
                                                                                 06NOV00.296
            CALL WTAPE(1,IMSC  ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.536
     &           1,0)                                                            OUTTAP.537
         ELSEIF (NAME.EQ.'MAPFACDT') THEN                                        OUTTAP.538
            CALL FILSLB(1,IMSD,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                OUTTAP.539
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.540
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.541
     &           sh_stagger(i3d),                                                OUTTAP.542
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.543
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.544
                                                                                 06NOV00.297
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.298
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.299
     &           sh_stagger(i3d),                                                06NOV00.300
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.301
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.302
                                                                                 06NOV00.303
            CALL WTAPE(1,IMSD  ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.545
     &           1,0)                                                            OUTTAP.546
         ELSEIF (NAME.EQ.'CORIOLIS') THEN                                        OUTTAP.547
C                                                                                OUTTAP.548
C     *** WRITE CORIOLIS PARAMETER AT DOT POINTS                                 OUTTAP.549
C                                                                                OUTTAP.550
            CALL FILSLB(1,ICOR,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                OUTTAP.551
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.552
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.553
     &           sh_stagger(i3d),                                                OUTTAP.554
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.555
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.556
                                                                                 06NOV00.304
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.305
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.306
     &           sh_stagger(i3d),                                                06NOV00.307
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.308
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.309
                                                                                 06NOV00.310
            CALL WTAPE(1,ICOR  ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.557
     &           1,0)                                                            OUTTAP.558
         ELSEIF (NAME.EQ.'LATITCRS') THEN                                        OUTTAP.559
C                                                                                OUTTAP.560
C     *** WRITE LAT-LONG AT CROSS AND DOT POINTS                                 OUTTAP.561
C                                                                                OUTTAP.562
            CALL FILSLB(1,ILATC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.563
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.564
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.565
     &           sh_stagger(i3d),                                                OUTTAP.566
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.567
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.568
                                                                                 06NOV00.311
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.312
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.313
     &           sh_stagger(i3d),                                                06NOV00.314
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.315
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.316
                                                                                 06NOV00.317
            CALL WTAPE(1,ILATC ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.569
     &           1,0)                                                            OUTTAP.570
         ELSEIF (NAME.EQ.'LONGICRS') THEN                                        OUTTAP.571
            CALL FILSLB(1,ILONC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.572
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.573
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.574
     &           sh_stagger(i3d),                                                OUTTAP.575
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.576
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.577
                                                                                 06NOV00.318
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.319
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.320
     &           sh_stagger(i3d),                                                06NOV00.321
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.322
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.323
                                                                                 06NOV00.324
            CALL WTAPE(1,ILONC ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.578
     &           1,0)                                                            OUTTAP.579
         ELSEIF (NAME.EQ.'LATITDOT') THEN                                        OUTTAP.580
            CALL FILSLB(1,ILATD,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.581
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.582
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.583
     &           sh_stagger(i3d),                                                OUTTAP.584
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.585
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.586
                                                                                 06NOV00.325
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.326
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.327
     &           sh_stagger(i3d),                                                06NOV00.328
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.329
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.330
                                                                                 06NOV00.331
            CALL WTAPE(1,ILATD ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.587
     &           1,0)                                                            OUTTAP.588
         ELSEIF (NAME.EQ.'LONGIDOT') THEN                                        OUTTAP.589
            CALL FILSLB(1,ILOND,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.590
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.591
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.592
     &           sh_stagger(i3d),                                                OUTTAP.593
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.594
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.595
                                                                                 06NOV00.332
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.333
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.334
     &           sh_stagger(i3d),                                                06NOV00.335
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.336
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.337
                                                                                 06NOV00.338
            CALL WTAPE(1,ILOND ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.596
     &           1,0)                                                            OUTTAP.597
         ELSEIF (NAME.EQ.'SNOWCOVR') THEN                                        OUTTAP.598
C                                                                                OUTTAP.599
C     *** WRITE SNOW COVER AT CROSS PTS (-.01,1.0,-99.)                          OUTTAP.600
C                                                                                OUTTAP.601
            WRITE (6,230)                                                        OUTTAP.602
 230  FORMAT(1H ,2X,'WRITE SNOW COVER DATA AT CROSS PTS(-.01,1.0,-99.)',         OUTTAP.603
     .'--------------------------------------------------------------')          OUTTAP.604
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.605
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.606
     &           sh_stagger(i3d),                                                OUTTAP.607
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.608
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.609
                                                                                 06NOV00.339
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.340
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.341
     &           sh_stagger(i3d),                                                06NOV00.342
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.343
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.344
                                                                                 06NOV00.345
            CALL WTAPE(1,ILOND ,SNOW ,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.610
     &           1,25)                                                           OUTTAP.611
         ELSEIF (NAME.EQ.'PSEALVLD') THEN                                        OUTTAP.612
C                                                                                OUTTAP.613
C     *** WRITE SEA LEVEL PRESSURE AT DOT AND CROSS POINTS                       OUTTAP.614
C                                                                                OUTTAP.615
            CALL FILSLB(2,IREFPD,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              OUTTAP.616
            WRITE (6,240)                                                        OUTTAP.617
 240        FORMAT (1H ,2X,'WRITE SEA LEVEL PRES  DOT--CROSS ----------'         OUTTAP.618
     &      ,'--------------------------------------------------------')         OUTTAP.619
            if (sh_units(i3d) .ne. 'Pa  ') sh_units(i3d) = 'Pa  '                OUTTAP.620
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.621
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.622
     &           sh_stagger(i3d),                                                OUTTAP.623
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.624
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.625
            do i = 1, is1                                                        OUTTAP.626
               do j = 1, is2                                                     OUTTAP.627
                  slab1(i,j) = slab1(i,j) * 1.E2 ! Convert from mb to Pa         OUTTAP.628
               enddo                                                             OUTTAP.629
            enddo                                                                OUTTAP.630
                                                                                 06NOV00.346
            WRITE(NVOL98) 1                                                      06NOV00.347
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.348
     &           sh_stagger(i3d),                                                06NOV00.349
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.350
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.351
                                                                                 06NOV00.352
            CALL WTAPE(2,IREFPD,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.631
     &           2,0)                                                            OUTTAP.632
                                                                                 06NOV00.353
                                                                                 06NOV00.354
         ELSEIF (NAME.EQ.'PSEALVLC') THEN                                        OUTTAP.633
            CALL FILSLB(2,IREFPC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)              OUTTAP.634
            if (sh_units(i3d) .ne. 'Pa  ') sh_units(i3d) = 'Pa  '                OUTTAP.635
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.636
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.637
     &           sh_stagger(i3d),                                                OUTTAP.638
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.639
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.640
            do i = 1, is1                                                        OUTTAP.641
               do j = 1, is2                                                     OUTTAP.642
                  slab1(i,j) = slab1(i,j) * 1.E2 ! Convert from mb to Pa         OUTTAP.643
               enddo                                                             OUTTAP.644
            enddo                                                                OUTTAP.645
                                                                                 06NOV00.355
            WRITE(NVOL98) 1      ! The small-header flag                         06NOV00.356
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.357
     &           sh_stagger(i3d),                                                06NOV00.358
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.359
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.360
                                                                                 06NOV00.361
            CALL WTAPE(2,IREFPC,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.646
     &           2,0)                                                            OUTTAP.647
         ELSEIF (NAME.EQ.'TSEASFC') THEN                                         OUTTAP.648
C                                                                                OUTTAP.649
C     WRITE SEA SFC TEMP AT CROSS PTS                                            OUTTAP.650
C                                                                                OUTTAP.651
            CALL FILSLB(1,ITSEA,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)               OUTTAP.652
            DO I = 1, IS1                                                        OUTTAP.653
               DO J = 1, IS2                                                     OUTTAP.654
                  SLAB1(I,J)=SLAB1(I,J)+273.15                                   OUTTAP.655
               ENDDO                                                             OUTTAP.656
            ENDDO                                                                OUTTAP.657
            WRITE (6,241)                                                        OUTTAP.658
 241  FORMAT (1H ,2X,'WRITE SEA SURFACE TEMP CROSS -------------------',         OUTTAP.659
     .'-----------------------------------------------------------')             OUTTAP.660
            WRITE(NVOL2) 1 ! The small-header flag                               OUTTAP.661
            WRITE(NVOL2) 2, 1, 1, 1, 1, MAXIC, MAXJC, 1, 1, 0.,                  OUTTAP.662
     &           sh_stagger(i3d),                                                OUTTAP.663
     &           sh_order(i3d), mdate, sh_name(i3d),                             OUTTAP.664
     &           sh_units(i3d), sh_description(i3d)                              OUTTAP.665
                                                                                 06NOV00.362
                                                                                 06NOV00.363
            WRITE(NVOL98) 1 ! The small-header flag                              06NOV00.364
            WRITE(NVOL98) 2, 1, 1, 1, 1, IS1, IS2, 1, 1, 0.,                     06NOV00.365
     &           sh_stagger(i3d),                                                06NOV00.366
     &           sh_order(i3d), mdate, sh_name(i3d),                             06NOV00.367
     &           sh_units(i3d), sh_description(i3d)                              06NOV00.368
                                                                                 06NOV00.369
            CALL WTAPE(1,ITSEA ,SLAB1,IS1,IS2,SLAB4,MAXIC,MAXJC,NVOL2,           OUTTAP.666
     &           3,0)                                                            OUTTAP.667
         ELSE                                                                    OUTTAP.668
CB                                                                               05DEC01.16
            if (sh_ndim(i3d).eq.3) then                                          05DEC01.17
               CALL READDAD(SCR3D, NAME, IDAD3D, IS1, IS2, KX)                   05DEC01.18
C                                                                                05DEC01.19
C     WRITE 3D FIELD                                                             05DEC01.20
C                                                                                05DEC01.21
            WRITE (6,340) NAME                                                   05DEC01.22
 340  FORMAT(1H ,2X,'WRITE ',A8, 'AT SFC AND PRESSURE LEVELS --',                05DEC01.23
     .'-------------------------------------------------------------')           05DEC01.24
            WRITE(NVOL2) 1      ! The small-header flag                          05DEC01.25
            WRITE(NVOL2) 3, 1, 1, 1, 1, MAXIC, MAXJC, KX, 1, 0.,                 05DEC01.26
     &           sh_stagger(i3d),                                                05DEC01.27
     &           sh_order(i3d), mdate, sh_name(i3d),                             05DEC01.28
     &           sh_units(i3d), sh_description(i3d)                              05DEC01.29
            WRITE(NVOL2)SCR3D                                                    05DEC01.30
            DO LL = 1, NTOTAL                                                    05DEC01.31
               WRITE(6,307) NAME,ALLVL(LL),SCR3D(1,1,LL)                         05DEC01.32
 307  FORMAT(1X,'AN OUTPUT FIELD ',A8,' ',23X,'HAS BEEN WRITTEN TO ',            05DEC01.33
     .              'UNIT  2.  THE VALUE AT I,J,P=1,1,',F6.1,' IS',F9.3)         05DEC01.34
            ENDDO                                                                05DEC01.35
CB                                                                               05DEC01.36
            elseif (sh_ndim(i3d).eq.2) then                                      05DEC01.37
               CALL READDAD(SLAB1, NAME, IDAD2D, IS1, IS2, 1)                    OUTTAP.670
               DO I = 1, MAXIC                                                   OUTTAP.671
                  DO J = 1, MAXJC                                                OUTTAP.672
                     SLAB4(I,J) =                                                OUTTAP.673
     &                    SLAB1(INC+I,INC+J)                                     OUTTAP.674
                  ENDDO                                                          OUTTAP.675
               ENDDO                                                             OUTTAP.676
               WRITE (6,242) NAME                                                OUTTAP.677
 242           FORMAT (1H ,2X,'WRITE ',A8,95('-'))                               OUTTAP.678
               WRITE(NVOL2) 1  ! The small-header flag                           OUTTAP.679
               WRITE(NVOL2)2, 1, 1, 1, 1, MAXIC,MAXJC,1,1,0.,                    OUTTAP.680
     &              sh_stagger(i3d),                                             OUTTAP.681
     &              sh_order(i3d), mdate, sh_name(i3d),                          OUTTAP.682
     &              sh_units(i3d), sh_description(i3d)                           OUTTAP.683
               WRITE(NVOL2) SLAB4                                                OUTTAP.684
                                                                                 06NOV00.370
               WRITE(NVOL98) 1  ! The small-header flag                          06NOV00.371
               WRITE(NVOL98)2, 1, 1, 1, 1, IS1,IS2,1,1,0.,                       06NOV00.372
     &              sh_stagger(i3d),                                             06NOV00.373
     &              sh_order(i3d), mdate, sh_name(i3d),                          06NOV00.374
     &              sh_units(i3d), sh_description(i3d)                           06NOV00.375
               WRITE(NVOL98) SLAB1                                               06NOV00.376
                                                                                 06NOV00.377
            else                                                                 OUTTAP.685
               print*, 'OUTTAP. V3. 3D.'                                         OUTTAP.686
               call abort                                                        OUTTAP.687
            endif                                                                OUTTAP.688
                                                                                 OUTTAP.689
         ENDIF                                                                   OUTTAP.690
      ENDDO                                                                      OUTTAP.691
      call closdad(idad3d)                                                       OUTTAP.692
      call closdad(idad2d)                                                       OUTTAP.693
      write(NVOL2) 2            ! The end-of-time flag                           OUTTAP.694
      write(NVOL98) 2           ! The end-of-time flag                           OUTTAP.695
      RETURN                                                                     OUTTAP.696
      END                                                                        OUTTAP.697
