      SUBROUTINE PLGRID(F1,F2,WIND,XLOND,                                        PLGRID.1
     *   IX,JX,ISTART,IEND,JSTART,JEND,                                          PLGRID.2
     .     XNORTH,XEAST,TRUELAT1,TRUELAT2,                                       PLGRID.3
     *   KLEVEL,ICRSDOT,CINT,XLATC,XLONC,DS,INCX,INCY,                           PLGRID.4
     *   IPLTCNT,MXA,MXB,MYA,MYB,                                                PLGRID.5
     *   MDATRD,NAME,IPRESSUR,ABFLAG,ABOVER,NVOL40)                              PLGRID.6
#ifdef NCARG                                                                     PLGRID.7
C                                                                                PLGRID.8
C     PURPOSE  SIMPLE CONTOUR PLOTS OF VARIABLE                                  PLGRID.9
C                                                                                PLGRID.10
      character*24 mdatrd                                                        PLGRID.11
      character*16 mdatein                                                       PLGRID.12
      DIMENSION F1(IX,JX),F2(IX,JX),WIND(IX,JX),XLOND(IX,JX)                     PLGRID.13
      PARAMETER (LW=8)                                                           PLGRID.14
      CHARACTER *8 NAME,STATION                                                  PLGRID.15
      CHARACTER *3 LABPLT                                                        PLGRID.16
      CHARACTER *4 TESTEOF                                                       PLGRID.17
      LOGICAL RECYCLE,ABOVER,ABFLAG                                              PLGRID.18
#include <comllxy.incl>                                                          PLGRID.19
      DIMENSION ISTAT(2)                                                         PLGRID.20
#include <commap.incl>                                                           PLGRID.21
      DATA IRECNUM/0/                        !                                   PLGRID.22
      CHARACTER*8 IBULLET                                                        PLGRID.23
      DATA IBULLET/'''KGL''E'/                                                   PLGRID.24
      PARAMETER (A1=30.,A2=15.,TILT=75.)                                         PLGRID.25
C   A1:   THE LENGTH OF THE MAIN FLAG (IN SCREEN                                 PLGRID.26
C         COORDINATE UNITS, USUALLY                                              PLGRID.27
C         SOME THING LIKE 30~50 WOULD BE O.K.)                                   PLGRID.28
C   A2:   THE LENGTH OF BARBS (SAME KIND OF UNIT AS A1)                          PLGRID.29
C   TILT: THE ANGLE BETWEEN THE FLAG AND THE BARBS (75                           PLGRID.30
C         IS GOOD)                                                               PLGRID.31
      INTEGER MAPINTEN, PERINTEN, MSGINTEN, OBSINTEN                             PLGRID.32
      DATA MAPINTEN / 7000/                                                      PLGRID.33
      DATA PERINTEN / 9000/                                                      PLGRID.34
      DATA MSGINTEN / 7000/                                                      PLGRID.35
      DATA OBSINTEN / 7000/                                                      PLGRID.36
C                                                                                PLGRID.37
      CHARACTER *80 ISURF                                                        PLGRID.38
      CHARACTER *47 HOLD47                                                       PLGRID.39
      CHARACTER *46 HOLD46                                                       PLGRID.40
      CHARACTER *6  SLP                                                          PLGRID.41
      CHARACTER *5  TEMP                                                         PLGRID.42
C                                                                                PLGRID.43
      COMMON /RECINT/ IRECMJ,      ! COLOR OF MAJOR LINES FOR CONREC             PLGRID.44
     *                IRECMN,      ! COLOR OF MINOR LINES FOR CONREC             PLGRID.45
     *                IRECTX       ! COLOR OF TEXT FOR CONREC                    PLGRID.46
      CHARACTER *2  PROJECT                                                      PLGRID.47
      INTEGER SIGN                                                               PLGRID.48
C                                                                                PLGRID.49
C     ... PUT AT RIGHT LOCATION FOR INPUT OF AUTOBOGUS                           PLGRID.50
C                                                                                PLGRID.51
      REWIND (NVOL40)                                                            PLGRID.52
99    CONTINUE                                                                   PLGRID.53
      READ(NVOL40,2001,END=8001,ERR=99)MDATEIN,                                  PLGRID.54
     *  KN,KTYPE,STATION,LVL,IVARBL,OBP,OBT,WDR,                                 PLGRID.55
     *  WSD,RECYCLE,Y,X,OBH,OBD                                                  PLGRID.56
      IF(MDATEIN.EQ.MDATRD(1:16)) THEN                                           PLGRID.57
         BACKSPACE NVOL40                                                        PLGRID.58
         write(*,'(''FOUND RIGHT MDATE = '', A16, '' PRES = '', I4,'//           PLGRID.59
     &        ''' VARIABLE = '', A8)') MDATRD(1:16), IPRESSUR, NAME(1:8)         PLGRID.60
      ELSE IF(MDATEIN.GT.MDATRD(1:16)) THEN                                      PLGRID.61
         GO TO 8001                                                              PLGRID.62
      ELSE IF(MDATEIN.NE.MDATRD(1:16)) THEN                                      PLGRID.63
         GOTO 99                                                                 PLGRID.64
      END IF                                                                     PLGRID.65
C                                                                                PLGRID.66
C     ... GET LOCATIONS OF I,J FOR THE LATITUDE AND LONGITUDE                    PLGRID.67
C                                                                                PLGRID.68
      IF (IFILSHDR.EQ.1) THEN         ! LAMCON                                   PLGRID.69
         IF(IPLTCNT.EQ.0) PRINT *,'LAMBERT CONFORMAL PROJECTION'                 PLGRID.70
         IF(XLATC.LT.0.) THEN                                                    PLGRID.71
            SIGN = -1                                                            PLGRID.72
         ELSE                                                                    PLGRID.73
            SIGN = 1                                                             PLGRID.74
         ENDIF                                                                   PLGRID.75
         CALL LCCONE(TRUELAT1,TRUELAT2,SIGN)                                     PLGRID.76
         PROJECT(1:2)='LC'                                                       PLGRID.77
      ELSE IF (IFILSHDR.EQ.2) THEN    ! POLSTR                                   PLGRID.78
         IF(IPLTCNT.EQ.0) PRINT *,'POLAR STEREOGRAPHIC PROJECTION'               PLGRID.79
         CONFAC=1.0                                                              PLGRID.80
         PROJECT(1:2)='ST'                                                       PLGRID.81
      ELSE IF (IFILSHDR.EQ.3) THEN    ! MERCAT                                   PLGRID.82
         IF(IPLTCNT.EQ.0) PRINT *,'MERCATOR PROJECTION'                          PLGRID.83
         PROJECT(1:2)='ME'                                                       PLGRID.84
      ELSE                                                                       PLGRID.85
         IF(IPLTCNT.EQ.0) PRINT *,'UNDEFINED PROJECTION, ASSUMING ',             PLGRID.86
     *           'LAMBERT CONFORMAL PROJECTION'                                  PLGRID.87
      ENDIF                                                                      PLGRID.88
      XN=CONFAC                                                                  PLGRID.89
      DSKM=DS / 1000.                                                            PLGRID.90
      LIMX=NINT((FLOAT(IXMUN)-(2.*XSTH)+1.)*FLOAT(IRAT)) + 1                     PLGRID.91
      LJMX=NINT((FLOAT(JXMUN)-(2.*XWST )+1.)*FLOAT(IRAT)) + 1                    PLGRID.92
      CALL XYTOLL(FLOAT(JSTART),FLOAT(ISTART),XLAT1,XLON1,PROJECT)               PLGRID.93
      CALL XYTOLL(FLOAT(JEND)  ,FLOAT(IEND),  XLAT2,XLON2,PROJECT)               PLGRID.94
      IMX=IEND-ISTART+1                                                          PLGRID.95
      JMX=JEND-JSTART+1                                                          PLGRID.96
C                                                                                PLGRID.97
C     ... MAKE A NICE MAP IF FIRST TIME THROUGH                                  PLGRID.98
C                                                                                PLGRID.99
      IF(IPLTCNT.EQ.0) THEN                                                      PLGRID.100
                                                                                 PLGRID.101
C  OPEN THE COLOR TABLE FILE                                                     PLGRID.102
                                                                                 PLGRID.103
      MAPUNIT=8                                                                  PLGRID.104
      OPEN (MAPUNIT,FILE='map.tbl',STATUS='OLD')                                 PLGRID.105
                                                                                 PLGRID.106
C  SET UP A COLOR TABLE                                                          PLGRID.107
                                                                                 PLGRID.108
      CALL RDCOLT(MAPUNIT)                                                       PLGRID.109
                                                                                 PLGRID.110
C  MAKE THE MAP                                                                  PLGRID.111
                                                                                 PLGRID.112
      XA = (XWST-1.)*FLOAT(IRAT)+1.                                              PLGRID.113
      XB = (XEAST-1.)*FLOAT(IRAT)+1.                                             PLGRID.114
      YA = (XSTH-1.)*FLOAT(IRAT)+1.                                              PLGRID.115
      YB = (XNORTH-1.)*FLOAT(IRAT)+1.                                            PLGRID.116
      IENDEX = (IXMUN - 1)*IRAT+1                                                PLGRID.117
      JENDEX = (JXMUN - 1)*IRAT+1                                                PLGRID.118
      CALL MAPDRV (PROJECT,FSPARL,SSPARL,XLATC,XLONC,                            PLGRID.119
     .     DSKM,JENDEX,IENDEX,XA,XB,YA,YB,                                       PLGRID.120
     * '                                                            ',           PLGRID.121
     *             60,1,MAPUNIT,.TRUE.,0)                                        PLGRID.122
                                                                                 PLGRID.123
C  CLOSE THE TABLE FILE                                                          PLGRID.124
                                                                                 PLGRID.125
      CLOSE (MAPUNIT)                                                            PLGRID.126
      END IF                                                                     PLGRID.127
C                                                                                PLGRID.128
C     ... PERIMETER, SET UP FRAME                                                PLGRID.129
C                                                                                PLGRID.130
      CALL GSTXCI (1)                                                            PLGRID.131
      CALL GSPLCI (1)                                                            PLGRID.132
      CALL GFLAS3(1)                                                             PLGRID.133
      IF(IPLTCNT.EQ.0) THEN                                                      PLGRID.134
         CALL GETSET(XMXA,XMXB,XMYA,XMYB,X1,X2,Y1,Y2,LTYPE)                      PLGRID.135
         MXA=IFIX(XMXA*1023.+1.)                                                 PLGRID.136
         MXB=IFIX(XMXB*1023.+1.)                                                 PLGRID.137
         MYA=IFIX(XMYA*1023.+1.)                                                 PLGRID.138
         MYB=IFIX(XMYB*1023.+1.)                                                 PLGRID.139
      END IF                                                                     PLGRID.140
      CALL SET(XMXA,XMXB,XMYA,XMYB,1.,FLOAT(JMX),1.,FLOAT(IMX),1)                PLGRID.141
      CALL GSCLIP(0)                                                             PLGRID.142
      DO 201 INUMLAB=5,JMX,5                                                     PLGRID.143
         IF(INUMLAB.LT.10) THEN                                                  PLGRID.144
            WRITE(LABPLT,'(1X,I1,1X)')INUMLAB                                    PLGRID.145
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYA-10),LABPLT,10./1023.,            PLGRID.146
     *          0.,0.)                                                           PLGRID.147
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYB+10),LABPLT,10./1023.,            PLGRID.148
     *          0.,0.)                                                           PLGRID.149
         ELSE IF((INUMLAB.GE.10).AND.(INUMLAB.LT.100)) THEN                      PLGRID.150
            WRITE(LABPLT,'(I2)')INUMLAB                                          PLGRID.151
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYA-10),LABPLT,10./1023.,            PLGRID.152
     *          0.,0.)                                                           PLGRID.153
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYB+10),LABPLT,10./1023.,            PLGRID.154
     *          0.,0.)                                                           PLGRID.155
         ELSE IF(INUMLAB.GE.100) THEN                                            PLGRID.156
            WRITE(LABPLT,'(I3)')INUMLAB                                          PLGRID.157
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYA-10),LABPLT,10./1023.,            PLGRID.158
     *          0.,0.)                                                           PLGRID.159
            CALL PLCHLQ(FLOAT(INUMLAB),CPUY(MYB+10),LABPLT,10./1023.,            PLGRID.160
     *          0.,0.)                                                           PLGRID.161
         END IF                                                                  PLGRID.162
201   CONTINUE                                                                   PLGRID.163
      DO 205 INUMLAB=5,IMX,5                                                     PLGRID.164
         WRITE(LABPLT,'(I3)')INUMLAB                                             PLGRID.165
         CALL PLCHLQ(CPUX(MXA-20),FLOAT(INUMLAB),LABPLT,10./1023.,0.,0.)         PLGRID.166
         CALL PLCHLQ(CPUX(MXB+20),FLOAT(INUMLAB),LABPLT,10./1023.,0.,0.)         PLGRID.167
205   CONTINUE                                                                   PLGRID.168
      CALL PERIM(JMX-1,1,IMX-1,1)                                                PLGRID.169
      IF(ICRSDOT.EQ.1) THEN                                                      PLGRID.170
         SHIFT=0.500001                                                          PLGRID.171
         CALL GSTXCI (16)                                                        PLGRID.172
         CALL GSPLCI (16)                                                        PLGRID.173
         INCRX=INT(0.5*(FLOAT(MXB-MXA)/FLOAT(JMX-1)))                            PLGRID.174
         INCRY=INT(0.5*(FLOAT(MYB-MYA)/FLOAT(IMX-1)))                            PLGRID.175
         MXA=MXA+INCRX                                                           PLGRID.176
         MXB=MXB-INCRX                                                           PLGRID.177
         MYA=MYA+INCRY                                                           PLGRID.178
         MYB=MYB-INCRY                                                           PLGRID.179
      ELSE                                                                       PLGRID.180
         SHIFT=0.0                                                               PLGRID.181
         CALL GSTXCI ( 9)                                                        PLGRID.182
         CALL GSPLCI ( 9)                                                        PLGRID.183
      END IF                                                                     PLGRID.184
      XMXA=FLOAT(MXA-1)/1023.                                                    PLGRID.185
      XMXB=FLOAT(MXB-1)/1023.                                                    PLGRID.186
      XMYA=FLOAT(MYA-1)/1023.                                                    PLGRID.187
      XMYB=FLOAT(MYB-1)/1023.                                                    PLGRID.188
      CALL SET(XMXA,XMXB,XMYA,XMYB,                                              PLGRID.189
     *         1.,FLOAT(JMX-INT(2.*SHIFT)),                                      PLGRID.190
     *         1.,FLOAT(IMX-INT(2.*SHIFT)),1)                                    PLGRID.191
      CALL GSCLIP(0)                                                             PLGRID.192
C                                                                                PLGRID.193
C     ... RETURN ORIGINAL INTEGER CORNERS BEFORE CROSS POINT                     PLGRID.194
C                                                                                PLGRID.195
      IF(ICRSDOT.EQ.1) THEN                                                      PLGRID.196
         MXA=MXA-INCRX                                                           PLGRID.197
         MXB=MXB+INCRX                                                           PLGRID.198
         MYA=MYA-INCRY                                                           PLGRID.199
         MYB=MYB+INCRY                                                           PLGRID.200
         XMXA=FLOAT(MXA-1)/1023.                                                 PLGRID.201
         XMXB=FLOAT(MXB-1)/1023.                                                 PLGRID.202
         XMYA=FLOAT(MYA-1)/1023.                                                 PLGRID.203
         XMYB=FLOAT(MYB-1)/1023.                                                 PLGRID.204
      END IF                                                                     PLGRID.205
C                                                                                PLGRID.206
C     ... PLOT ANALYZED FIELD                                                    PLGRID.207
C                                                                                PLGRID.208
      L=JX               ! DIMENSION IN X DIRECTION                              PLGRID.209
      M=JMX-INT(2.*SHIFT)! HOW MUCH OF X DIRECTION TO USE                        PLGRID.210
      N=IMX-INT(2.*SHIFT)! NUMBER OF VALUES IN Y DIRECTION                       PLGRID.211
      FLO=0.             ! LOWEST CONTOUR                                        PLGRID.212
      HI=0.              ! BIGGEST CONTOUR                                       PLGRID.213
      FINC=CINT          ! CONTOUR INTERVAL                                      PLGRID.214
      NSET=-1            ! SET HAS BEEN CALLED                                   PLGRID.215
      NHI=0              ! HI AND LOWS MARKED                                    PLGRID.216
      NDOT=-682          ! DASH PATTERN FOR NEG VALUES                           PLGRID.217
      IF((NAME(1:1).EQ.'U').OR.(NAME(1:1).EQ.'V')) THEN                          PLGRID.218
         NHI=-1                                                                  PLGRID.219
         CALL WINDSPD(F1,F2,IX,JX,WIND)                                          PLGRID.220
         CALL VTRAN(WIND,IX,JX)                                                  PLGRID.221
250      CONTINUE                                                                PLGRID.222
         CALL SETUSV('LW',1*LW/8 * 1000)                                         PLGRID.223
         IRECTX=9                                                                PLGRID.224
         IRECMJ = 9                                                              PLGRID.225
         IRECMN = 9                                                              PLGRID.226
         CALL CONREC(WIND(JSTART,ISTART),L,M,N,FLO,HI,                           PLGRID.227
     *      FINC,NSET,NHI,NDOT)                                                  PLGRID.228
C                                                                                PLGRID.229
         DO 255 I=1,IMX,INCY                                                     PLGRID.230
         DO 255 J=1,JMX,INCX                                                     PLGRID.231
            CALL WNDBARB(FLOAT(J),FLOAT(I),                                      PLGRID.232
     *         F1(I+ISTART-1,J+JSTART-1),F2(I+ISTART-1,J+JSTART-1))              PLGRID.233
255      CONTINUE                                                                PLGRID.234
         LTOP=950                                                                PLGRID.235
         L1ST=930                                                                PLGRID.236
         LSTA=910                                                                PLGRID.237
         LKEY=150                                                                PLGRID.238
         CALL PLCHLQ(CPUX(LKEY),CPUY(L1ST),'GRID KEY:   ',10./1023.,             PLGRID.239
     *          0.,-1.)                                                          PLGRID.240
         CALL PLCHLQ(CPUX(LKEY),CPUY(LSTA),'STATION KEY:',10./1023.,             PLGRID.241
     *          0.,-1.)                                                          PLGRID.242
         LKEY=350                                                                PLGRID.243
         CALL PLCHLQ(CPUX(LKEY),CPUY(LTOP),' 0- 2 M/S',10./1023.,0.,0.)          PLGRID.244
         CALL INT2FL(LKEY,L1ST,XW,YW)                                            PLGRID.245
         CALL WNDBARB(XW,YW,1.,0.)                                               PLGRID.246
         CALL BARB( 1.,270.,LKEY,LSTA,A1,A2,TILT)                                PLGRID.247
         LKEY=500                                                                PLGRID.248
         CALL PLCHLQ(CPUX(LKEY),CPUY(LTOP),' 3- 7 M/S',10./1023.,0.,0.)          PLGRID.249
         CALL INT2FL(LKEY,L1ST,XW,YW)                                            PLGRID.250
         CALL WNDBARB(XW,YW,5.,0.)                                               PLGRID.251
         CALL BARB( 5.,270.,LKEY,LSTA,A1,A2,TILT)                                PLGRID.252
         LKEY=650                                                                PLGRID.253
         CALL PLCHLQ(CPUX(LKEY),CPUY(LTOP),' 8-12 M/S',10./1023.,0.,0.)          PLGRID.254
         CALL INT2FL(LKEY,L1ST,XW,YW)                                            PLGRID.255
         CALL WNDBARB(XW,YW,10.,0.)                                              PLGRID.256
         CALL BARB(10.,270.,LKEY,LSTA,A1,A2,TILT)                                PLGRID.257
         LKEY=800                                                                PLGRID.258
         CALL PLCHLQ(CPUX(LKEY),CPUY(LTOP),'48-52 M/S',10./1023.,0.,0.)          PLGRID.259
         CALL INT2FL(LKEY,L1ST,XW,YW)                                            PLGRID.260
         CALL WNDBARB(XW,YW,50.,0.)                                              PLGRID.261
         CALL BARB(50.,270.,LKEY,LSTA,A1,A2,TILT)                                PLGRID.262
      ELSE IF((NAME(1:1).EQ.'T').OR.(NAME(1:1).EQ.'S')) THEN                     PLGRID.263
         XMAX=-1.E-10                                                            PLGRID.264
         DO 262 J=JSTART,JEND-ICRSDOT                                            PLGRID.265
         DO 262 I=ISTART,IEND-ICRSDOT                                            PLGRID.266
            XMAX=MAX(XMAX,F1(I,J))                                               PLGRID.267
262      CONTINUE                                                                PLGRID.268
         IF(XMAX.LT.0.0) NDOT=0                                                  PLGRID.269
         CALL VTRAN(F1,IX,JX)                                                    PLGRID.270
         CALL SETUSV('LW',1*LW/8 * 1000)                                         PLGRID.271
         IRECTX=9                                                                PLGRID.272
         IRECMJ = 9                                                              PLGRID.273
         IRECMN = 9                                                              PLGRID.274
         CALL CONREC(F1(JSTART,ISTART),L,M,N,FLO,HI,                             PLGRID.275
     *      FINC,NSET,NHI,NDOT)                                                  PLGRID.276
         CALL VTRAN(F1,JX,IX)                                                    PLGRID.277
      END IF                                                                     PLGRID.278
C                                                                                PLGRID.279
C                                                                                PLGRID.280
C     ... PUT SOME LABELS ON THE PLOT                                            PLGRID.281
C                                                                                PLGRID.282
         CALL GSTXCI (1)                                                         PLGRID.283
         CALL GSPLCI (1)                                                         PLGRID.284
      IF(IPRESSUR.EQ.1001) THEN                                                  PLGRID.285
         WRITE(ISURF,FMT=901)NAME,MDATRD(1:16)                                   PLGRID.286
         HOLD46(1:46)=ISURF(1:46)                                                PLGRID.287
         CALL PLCHLQ(CPUX(512),CPUY(980),HOLD46,14./1023.,0.,0.)                 PLGRID.288
      ELSE                                                                       PLGRID.289
         IF((NAME(1:1).EQ.'U').OR.(NAME(1:1).EQ.'V')) THEN                       PLGRID.290
            WRITE(ISURF,FMT=904)IPRESSUR,MDATRD(1:16)                            PLGRID.291
         ELSE                                                                    PLGRID.292
            WRITE(ISURF,FMT=902)NAME,IPRESSUR,MDATRD(1:16)                       PLGRID.293
         END IF                                                                  PLGRID.294
         HOLD47(1:47)=ISURF(1:47)                                                PLGRID.295
         CALL PLCHLQ(CPUX(512),CPUY(980),HOLD47,14./1023.,0.,0.)                 PLGRID.296
      END IF                                                                     PLGRID.297
C                                                                                PLGRID.298
C     ... SEE IF THIS IS TO OVERLAY AUTO BOGUS STUFF                             PLGRID.299
C                                                                                PLGRID.300
      CALL SET(XMXA,XMXB,XMYA,XMYB,1.,FLOAT(JMX),1.,FLOAT(IMX),1)                PLGRID.301
      CALL GSCLIP(0)                                                             PLGRID.302
      ICOUNT=0                                                                   PLGRID.303
      CALL GSTXCI (12)                                                           PLGRID.304
      CALL GSPLCI (12)                                                           PLGRID.305
      IF((ABFLAG).AND.(ABOVER).AND.                                              PLGRID.306
     *      (NAME(1:1).EQ.'T')) THEN                                             PLGRID.307
         DO 3000 LOOP=1,1200                                                     PLGRID.308
            READ(NVOL40,2001,ERR=3001)MDATEIN,KN,KTYPE,                          PLGRID.309
     *         STATION,LVL,IVARBL,OBP,                                           PLGRID.310
     *         OBT,WDR,WSD,RECYCLE,Y,X,OBH,OBD                                   PLGRID.311
            if (MDATEIN(1:16) .gt. MDATRD(1:16)) goto 3001                       PLGRID.312
            IF((LVL.NE.KLEVEL).OR.(IVARBL.NE.3)) GOTO 3000                       PLGRID.313
            ICOUNT=ICOUNT+1                                                      PLGRID.314
            X=X - JSTART + 1.5                                                   PLGRID.315
            Y=Y - ISTART + 1.5                                                   PLGRID.316
            CALL PLOTDOM(X,Y,IMX,JMX,MXA,MXB,MYA,MYB,IJY,IJX)                    PLGRID.317
            CALL PWRITX(CPUX(IJX),CPUY(IJY),IBULLET,6,8,0,0)                     PLGRID.318
            IF(KLEVEL.NE.1) THEN                                                 PLGRID.319
            TEMP(1:5)=STATION(1:5)                                               PLGRID.320
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY+8),TEMP,                              PLGRID.321
     *         6./1023.,0.,0.)                                                   PLGRID.322
            END IF                                                               PLGRID.323
            WRITE(TEMP,FMT=1101)OBT                                              PLGRID.324
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY-8),TEMP,6./1023.,0.,0.)               PLGRID.325
3000     CONTINUE                                                                PLGRID.326
3001     CONTINUE                                                                PLGRID.327
         IF(ICOUNT.EQ.0) THEN                                                    PLGRID.328
            CALL GSTXCI (6)                                                      PLGRID.329
            CALL GSPLCI (6)                                                      PLGRID.330
            CALL PLCHLQ(CPUX(512),CPUY(35),                                      PLGRID.331
     *         '*** NO AUTOBOGUS RECYCLE ***',10./1023.,0.,0.)                   PLGRID.332
         END IF                                                                  PLGRID.333
      ELSE IF((ABFLAG).AND.(ABOVER).AND.(KLEVEL.EQ.1).AND.                       PLGRID.334
     *      (NAME(1:1).EQ.'U')) THEN                                             PLGRID.335
         DO 4000 LOOP=1,1200                                                     PLGRID.336
            READ(NVOL40,2001,ERR=4001)MDATEIN,KN,KTYPE,                          PLGRID.337
     *         STATION,LVL,IVARBL,OBP,                                           PLGRID.338
     *         OBT,WDR,WSD,RECYCLE,Y,X,OBH,OBD                                   PLGRID.339
            if (MDATEIN(1:16) .gt. MDATRD(1:16)) goto 4001                       PLGRID.340
            IF((LVL.NE.KLEVEL).OR.(IVARBL.NE.1)) GOTO 4000                       PLGRID.341
            ICOUNT=ICOUNT+1                                                      PLGRID.342
      CALL XYTOLL(X,Y,XLAT,XLON,PROJECT)                                         PLGRID.343
            X=X - JSTART + 1                                                     PLGRID.344
            Y=Y - ISTART + 1                                                     PLGRID.345
            DIR=WDR-(XLON-XLONC)*XN                                              PLGRID.346
            IF(DIR.LT.0.0) DIR=DIR+360.                                          PLGRID.347
            CALL PLOTDOM(X,Y,IMX,JMX,MXA,MXB,MYA,MYB,IJY,IJX)                    PLGRID.348
            TEMP(1:5)=STATION(1:5)                                               PLGRID.349
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY+8),TEMP,6./1023.,0.,0.)               PLGRID.350
            CALL BARB(WSD,DIR,IJX,IJY,A1,A2,TILT)                                PLGRID.351
4000     CONTINUE                                                                PLGRID.352
4001     CONTINUE                                                                PLGRID.353
         IF(ICOUNT.EQ.0) THEN                                                    PLGRID.354
            CALL GSTXCI (6)                                                      PLGRID.355
            CALL GSPLCI (6)                                                      PLGRID.356
            CALL PLCHLQ(CPUX(512),CPUY(35),                                      PLGRID.357
     *         '*** NO AUTOBOGUS RECYCLE ***',10./1023.,0.,0.)                   PLGRID.358
         END IF                                                                  PLGRID.359
      ELSE IF((ABFLAG).AND.(ABOVER).AND.(KLEVEL.EQ.1).AND.                       PLGRID.360
     *      (NAME(1:1).EQ.'V')) THEN                                             PLGRID.361
         DO 4500 LOOP=1,1200                                                     PLGRID.362
            READ(NVOL40,2001,ERR=4501)MDATEIN,KN,KTYPE,                          PLGRID.363
     *         STATION,LVL,IVARBL,OBP,                                           PLGRID.364
     *         OBT,WDR,WSD,RECYCLE,Y,X,OBH,OBD                                   PLGRID.365
            if (MDATEIN(1:16) .gt. MDATRD(1:16)) goto 4500                       PLGRID.366
            IF((LVL.NE.KLEVEL).OR.(IVARBL.NE.2)) GOTO 4500                       PLGRID.367
            ICOUNT=ICOUNT+1                                                      PLGRID.368
      CALL XYTOLL(X,Y,XLAT,XLON,PROJECT)                                         PLGRID.369
            X=X - JSTART + 1                                                     PLGRID.370
            Y=Y - ISTART + 1                                                     PLGRID.371
            DIR=WDR-(XLON-XLONC)*XN                                              PLGRID.372
            IF(DIR.LT.0.0) DIR=DIR+360.                                          PLGRID.373
            CALL PLOTDOM(X,Y,IMX,JMX,MXA,MXB,MYA,MYB,IJY,IJX)                    PLGRID.374
            TEMP(1:5)=STATION(1:5)                                               PLGRID.375
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY+8),TEMP,6./1023.,0.,0.)               PLGRID.376
            CALL BARB(WSD,DIR,IJX,IJY,A1,A2,TILT)                                PLGRID.377
4500     CONTINUE                                                                PLGRID.378
4501     CONTINUE                                                                PLGRID.379
         IF(ICOUNT.EQ.0) THEN                                                    PLGRID.380
            CALL GSTXCI (6)                                                      PLGRID.381
            CALL GSPLCI (6)                                                      PLGRID.382
            CALL PLCHLQ(CPUX(512),CPUY(35),                                      PLGRID.383
     *         '*** NO AUTOBOGUS RECYCLE ***',10./1023.,0.,0.)                   PLGRID.384
         END IF                                                                  PLGRID.385
      ELSE IF((ABFLAG).AND.(ABOVER).AND.(KLEVEL.NE.1).AND.                       PLGRID.386
     *      ((NAME(1:1).EQ.'U').OR.(NAME(1:1).EQ.'V'))) THEN                     PLGRID.387
         DO 4800 LOOP=1,1200                                                     PLGRID.388
            READ(NVOL40,2001,ERR=4801)MDATEIN,KN,KTYPE,                          PLGRID.389
     *         STATION,LVL,IVARBL,OBP,                                           PLGRID.390
     *         OBT,WDR,WSD,RECYCLE,Y,X,OBH,OBD                                   PLGRID.391
            if (MDATEIN(1:16) .gt. MDATRD(1:16)) goto 4800                       PLGRID.392
            IF((LVL.NE.KLEVEL).OR.                                               PLGRID.393
     *         ((IVARBL.NE.1).AND.(IVARBL.NE.2))) GOTO 4800                      PLGRID.394
            ICOUNT=ICOUNT+1                                                      PLGRID.395
      CALL XYTOLL(X,Y,XLAT,XLON,PROJECT)                                         PLGRID.396
            X=X - JSTART + 1                                                     PLGRID.397
            Y=Y - ISTART + 1                                                     PLGRID.398
            DIR=WDR-(XLON-XLONC)*XN                                              PLGRID.399
            IF(DIR.LT.0.0) DIR=DIR+360.                                          PLGRID.400
            CALL PLOTDOM(X,Y,IMX,JMX,MXA,MXB,MYA,MYB,IJY,IJX)                    PLGRID.401
            TEMP(1:5)=STATION(1:5)                                               PLGRID.402
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY+8),TEMP,6./1023.,0.,0.)               PLGRID.403
            CALL BARB(WSD,DIR,IJX,IJY,A1,A2,TILT)                                PLGRID.404
4800     CONTINUE                                                                PLGRID.405
4801     CONTINUE                                                                PLGRID.406
         IF(ICOUNT.EQ.0) THEN                                                    PLGRID.407
            CALL GSTXCI (6)                                                      PLGRID.408
            CALL GSPLCI (6)                                                      PLGRID.409
            CALL PLCHLQ(CPUX(512),CPUY(35),                                      PLGRID.410
     *         '*** NO AUTOBOGUS RECYCLE ***',10./1023.,0.,0.)                   PLGRID.411
         END IF                                                                  PLGRID.412
      ELSE IF((ABFLAG).AND.(ABOVER).AND.                                         PLGRID.413
     *      (NAME(1:1).EQ.'S')) THEN                                             PLGRID.414
         DO 5000 LOOP=1,1200                                                     PLGRID.415
            READ(NVOL40,2001,ERR=5001)MDATEIN,KN,KTYPE,                          PLGRID.416
     *         STATION,LVL,IVARBL,OBP,                                           PLGRID.417
     *         OBT,WDR,WSD,RECYCLE,Y,X,OBH,OBD                                   PLGRID.418
            if (MDATEIN(1:16) .gt. MDATRD(1:16)) goto 5000                       PLGRID.419
            IF((LVL.NE.1).OR.(IVARBL.NE.6)) GOTO 5000                            PLGRID.420
            ICOUNT=ICOUNT+1                                                      PLGRID.421
            X=X - JSTART + 1.5                                                   PLGRID.422
            Y=Y - ISTART + 1.5                                                   PLGRID.423
            CALL PLOTDOM(X,Y,IMX,JMX,MXA,MXB,MYA,MYB,IJY,IJX)                    PLGRID.424
            CALL PWRITX(CPUX(IJX),CPUY(IJY),IBULLET,6,8,0,0)                     PLGRID.425
C           CALL PWRIT(IJX,IJY+8,STATION(1:5),5,6,0,0)                           PLGRID.426
            WRITE(SLP,FMT=1103)OBP                                               PLGRID.427
            CALL PLCHLQ(CPUX(IJX),CPUY(IJY-8),SLP,6./1023.,0.,0.)                PLGRID.428
5000     CONTINUE                                                                PLGRID.429
5001     CONTINUE                                                                PLGRID.430
         IF(ICOUNT.EQ.0) THEN                                                    PLGRID.431
            CALL GSTXCI (6)                                                      PLGRID.432
            CALL GSPLCI (6)                                                      PLGRID.433
            CALL PLCHLQ(CPUX(512),CPUY(35),                                      PLGRID.434
     *         '*** NO AUTOBOGUS RECYCLE ***',10./1023.,0.,0.)                   PLGRID.435
         END IF                                                                  PLGRID.436
      END IF                                                                     PLGRID.437
      CALL FRAME                                                                 PLGRID.438
      RETURN                                                                     PLGRID.439
C                                                                                PLGRID.440
C                                                                                PLGRID.441
 901  FORMAT(A8,' SURFACE ANALYSIS: ',A16)                                       PLGRID.442
 902  FORMAT(A8,'   ',I4,'MB ANALYSIS: ',A16)                                    PLGRID.443
 904  FORMAT('U&V(M/S)','   ',I4,'MB ANALYSIS: ',A16)                            PLGRID.444
 2001 FORMAT(A16,I4,I2,1X,A8,I3,I2,4F8.1,1X,L1,9X,2F7.2,2F8.1)                   PLGRID.445
1101  FORMAT(F5.1)                                                               PLGRID.446
1103  FORMAT(F6.1)                                                               PLGRID.447
CC====FORMAT(I4,I2,1X,A8,6(1X,F7.1),1X,I1,2(1X,F6.2),1X,I2,1X,I8,1X,L1)          PLGRID.448
2009  FORMAT('  STA=',A8,' LVL=',I2,' IVAR=',I1,                                 PLGRID.449
     *       ' SLP=',F7.1,' TEMP=',F7.1,' DIR=',F7.1,' SPD=',F7.1)               PLGRID.450
C                                                                                PLGRID.451
8001  CONTINUE                                                                   PLGRID.452
      PRINT *,'COULD NOT FIND RIGHT MDATE IN ',                                  PLGRID.453
     *'AUTOBOGUS FILE=',MDATRD,                                                  PLGRID.454
     *'   PRES LEVEL=',IPRESSUR,                                                 PLGRID.455
     *'  VARIABLE=',NAME(1:8),                                                   PLGRID.456
     *'  **** EOD DETECTED ***'                                                  PLGRID.457
      IPLTCNT=IPLTCNT-1                                                          PLGRID.458
#endif                                                                           PLGRID.459
      RETURN                                                                     PLGRID.460
      END                                                                        PLGRID.461
