      SUBROUTINE PROBGS(DATAH,CORRH,ID1,ID2,ID3,ITOSS,IMAND,ISIGT,ISIGW,         PROBGS.1
     1                  ISFCD,KTOPPR,KMANPR,KSIGPR,KWINDP,KWINDZ,KREMEM,         PROBGS.2
     2                  DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,IS2,MDATE,ISI)            PROBGS.3
C                                                                                PROBGS.4
C                                                                                PROBGS.5
C-----------------------------------------------------------------------         PROBGS.6
C                                                                                PROBGS.7
C      PURPOSE:  THIS SUBROUTINE PRE-PROCESSES BOGUS SURFACE DATA PRIOR          PROBGS.8
C                TO THE OBJECTIVE ANALYSIS STEP.                                 PROBGS.9
C                                                                                PROBGS.10
C-----------------------------------------------------------------------         PROBGS.11
C-----------------------------------------------------------------------         PROBGS.12
#include <paramirb.incl>                                                         PROBGS.13
#include <paramirs.incl>                                                         PROBGS.14
#include <coma.incl>                                                             PROBGS.15
#include <comb.incl>                                                             PROBGS.16
#include <comc.incl>                                                             PROBGS.17
C-----------------------------------------------------------------------         PROBGS.18
      DIMENSION DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                            PROBGS.19
      DIMENSION DATAS(IDS1,IDS2,IDS3),SLAB1(IS1,IS2)                             PROBGS.20
      EQUIVALENCE (SLP,P(1)),(SFCT,T(1)),(SFCDD,D(1)),                           PROBGS.21
     1            (SFCFF,F(1)),(SFCTD,H(1))                                      PROBGS.22
C                                                                                PROBGS.23
C-----------------------------------------------------------------------         PROBGS.24
C                                                                                PROBGS.25
C      NOTES:                                                                    PROBGS.26
C        1. BOGUS DATA IN JOBDECK:  THE BOGUS SURFACE DATA IS INSERTED           PROBGS.27
C             INTO THE JOB DECK IN THE SAME FILE, DELINEATED BY \EOFS,           PROBGS.28
C             AS THE UPPER-AIR BOGUS DATA (SEE PROBGU).  THE BOGUS DATA          PROBGS.29
C             FILE IMMEDIATELY FOLLOWS THE MASTER INPUT FILE.                    PROBGS.30
C        2. ERRORS IN BOGUS DATA:  RAWINS ASSUMES ALL BOGUS DATA IS              PROBGS.31
C             CORRECT.  THIS ALLOWS THE USER  TO OVERRIDE A POOR FIRST           PROBGS.32
C             GUESS WITHOUT DATA-REJECTION, BUT THE USER IS RESPONSIBLE          PROBGS.33
C             FOR THE ACCURACY OF THE BOGUS DATA.                                PROBGS.34
C        3. DATA TYPES:  THE BOGUS SURFACE DATA APPEARS IN A VERY SIMPLE         PROBGS.35
C             FORM, WITHOUT SUPPLEMENTARY INFORMATION (CLOUD COVER AND           PROBGS.36
C             TYPE, PRECIP., ETC.).  VARIABLES ARE SEA-LEVEL PRES.,              PROBGS.37
C             SURFACE TEMP., SURFACE WIND SPEED AND DIRECTION, AND               PROBGS.38
C             SURFACE DEW POINT DEPRESSION.                                      PROBGS.39
C        4. SEA-LEVEL PRESSURE:  THE PRESSURE VARIABLE IS IDENTICAL TO           PROBGS.40
C             THAT READ FROM THE REAL-DATA TAPES.                                PROBGS.41
C        5. END OF DATA:  SET NDATE=888 ON THE LAST READ IMAGE FOR A             PROBGS.42
C             GIVEN DATE AND TIME TO DESIGNATE THE END OF SURFACE BOGUS          PROBGS.43
C             DATA FOR THAT TIME.  IF NBOGUS(IFIL)=.T., NDATE=888 MUST           PROBGS.44
C             APPEAR AFTER NDATE=999, EVEN IF NO BOGUS SURFACE DATA ARE          PROBGS.45
C             USED.  ALSO, REFER TO NOTES IN PROBGU.                             PROBGS.46
C        6. BOGUS DATA FORMAT:  SEE STATEMENT NO. 10 BELOW                       PROBGS.47
C        7. BOGUS DATA INPUT UNITS: SLB(MB), SFCT(C), SFC. WIND(DEGREES,         PROBGS.48
C             M/S), AND SFCTD(C).                                                PROBGS.49
C        8. BOGUS ELEVATION:  WILL BE AUTOMATICALLY CALCULATED FROM THE          PROBGS.50
C             LAT., LONG., AND ANALYZED TERRAIN.  A DUMMY VALUE IS               PROBGS.51
C             ASSIGNED TEMPORARILY.                                              PROBGS.52
C                                                                                PROBGS.53
C-----------------------------------------------------------------------         PROBGS.54
C                                                                                PROBGS.55
C                                                                                PROBGS.56
C                                                                                PROBGS.57
C                                                                                PROBGS.58
      LOGICAL SFIELD                                                             PROBGS.59
      CHARACTER*8 IBOGUS                                                         PROBGS.60
      character*(24) mdate, ndate                                                PROBGS.61
      SFIELD=SFPROC                                                              PROBGS.62
      NVOL13=13                                                                  PROBGS.63
C---------BEGIN PROCESSOR LOOP: MAXIMUM IS 999 BOGUS SURFACE STATIONS            PROBGS.64
C         PER TIME PERIOD.                                                       PROBGS.65
      DO 100 I=1,999                                                             PROBGS.66
      READ (NVOL13,10) NDATE(1:16),IBOGUS,YLAT,YLON                              PROBGS.67
      ndate(17:24) = ':00.0000'                                                  PROBGS.68
10    FORMAT(22X,A16,1X,A5,6X,2F7.1)                                             PROBGS.69
C                                                                                PROBGS.70
      KLAT=NINT(YLAT*10.)                                                        PROBGS.71
      KLON=NINT(YLON*10.)                                                        PROBGS.72
      ELEV=-999.                                                                 PROBGS.73
      KELEV=ELEV                                                                 PROBGS.74
      IF(NDATE(1:3).EQ.'888') RETURN                                             PROBGS.75
      SSTA=IBOGUS                                                                PROBGS.76
C                                                                                PROBGS.77
C---------COMPARE DATE OF BOGUS REPORT WITH DATE FROM MASTER INPUT FILE.         PROBGS.78
      IF(NDATE.NE.MDATE)THEN                                                     PROBGS.79
      PRINT 20                                                                   PROBGS.80
20    FORMAT(10X,'WARNINGS -- BOGUS DATE DOES NOT MATCH MASTER INPUT',           PROBGS.81
     1 'FILE DATE...  BOGUS SURFACE REPORT BYPASSED.')                           PROBGS.82
      PRINT 21, NDATE(1:16), MDATE(1:16)                                         PROBGS.83
21    FORMAT('NDATE =',A16,'MDATE =',A16)                                        PROBGS.84
      READ (NVOL13,30) DIM1,DUM2,DUM3,DUM4,DUM5                                  PROBGS.85
30    FORMAT(10X,F10.1,10X,4F10.1)                                               PROBGS.86
      GO TO 100                                                                  PROBGS.87
      END IF                                                                     PROBGS.88
      PRINT 40                                                                   PROBGS.89
40    FORMAT(1X,'-----------------------------------------------------',         PROBGS.90
     1'--------------------')                                                    PROBGS.91
      READ (NVOL13,30) SLP,SFCT,SFCTD,SFCDD,SFCFF                                PROBGS.92
      PRINT 50,IBOGUS,NDATE(1:16)                                                PROBGS.93
 50   FORMAT(1H0,'BOGUS SURFACE REPORT',1X,A5,5X,'DATE=',A16)                    PROBGS.94
      IF(BOGPRT)THEN                                                             PROBGS.95
C                                                                                PROBGS.96
C---------FOR PRINTER OUTPUT ONLY, TEMPERATURE AND DEWPT. DEPRESSION             PROBGS.97
C         ARE CONVERTED FROM CELCIUS TO FAHRENHEIT.  ONLY CELCIUS VALUES         PROBGS.98
C         ARE SAVED FOR THE OBJECTIVE ANALYSIS.  ALSO, WIND IS CONVERTED         PROBGS.99
C         FROM M/S TO KNOTS, FOR PRINTOUT ONLY.                                  PROBGS.100
      SFCTF=(9./5.)*SFCT+32.0                                                    PROBGS.101
      SFCTDF=(9./5.)*SFCTD                                                       PROBGS.102
      SFCFFM=SFCFF                                                               PROBGS.103
      SFCFF=SFCFF/0.5144                                                         PROBGS.104
      PRINT 60,SLP,SFCT,SFCTD,SFCTF,SFCTDF,SFCDD,SFCFFM,SFCFF                    PROBGS.105
60    FORMAT(15X,'S.L. PRES(MB)=',F6.1,2X,'T(C)=',F5.1,2X,'DEW DEPR.(C)'         PROBGS.106
     1 ,'=',F5.1,2X,'( T(F)=',F5.1,2X,'DEW DEPR.(F)=',F5.1,2X,')'/20X,           PROBGS.107
     2 'WIND DIR.(DEG)=',F5.1,2X,'WIND SPD(M/S)=',F5.1,2X,                       PROBGS.108
     3 '( WIND SPD(KT)=',F5.1,2X,')')                                            PROBGS.109
      END IF                                                                     PROBGS.110
C                                                                                PROBGS.111
C---------SET UP STORAGE-IDENTIFIERS BY CALLING INACCT                           PROBGS.112
C                                                                                PROBGS.113
C---------INCREMENT JSTATN, WHICH COUNTS THE TOTAL NO. OF SFC. STATIONS          PROBGS.114
      JSTATN=JSTATN+1                                                            PROBGS.115
      CALL INACCT(ID1,ID3,ISTATN,IBOGUS,IDF,NSTA,ALRAWS,2,KLAT,KLON,             PROBGS.116
     1            KELEV,JSTATN,IDS3)                                             PROBGS.117
      SFPROC=.TRUE.                                                              PROBGS.118
      CALL SAVSTN(CORRH,ID1,ID2,ID3,ITOSS,ISFCD,KTOPPR,KMANPR,KSIGPR,            PROBGS.119
     1            KWINDP,KWINDZ,KREMEM,DATAS,IDS1,IDS2,IDS3,SLAB1,IS1,           PROBGS.120
     2            IS2,ISI)                                                       PROBGS.121
      SFPROC=SFIELD                                                              PROBGS.122
100   CONTINUE                                                                   PROBGS.123
C                                                                                PROBGS.124
C---------MAX. NO. OF SURFACE BOGUS STATIONS HAS BEEN PROCESSED.                 PROBGS.125
C         WARNING -- THIS MAY CAUSE TROUBLE, BECAUSE DELINEATOR                  PROBGS.126
C         (NDATE=888) HAS NOT BEEN FOUND.                                        PROBGS.127
      RETURN                                                                     PROBGS.128
      END                                                                        PROBGS.129
