      SUBROUTINE PSFC(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,SFCPR,IS1,IS2,IP)            PSFC.1
C                                                                                PSFC.2
C        PURPOSE: CALCULATE SFC PRES FROM SEA LEVEL PRES.                        PSFC.3
C-----------------------------------------------------------------------         PSFC.4
#include <paramirb.incl>                                                         PSFC.5
#include <paramirs.incl>                                                         PSFC.6
#include <coma.incl>                                                             PSFC.7
#include <comc.incl>                                                             PSFC.8
#include <comd.incl>                                                             PSFC.9
C-----------------------------------------------------------------------         PSFC.10
      DIMENSION HORZH(IH1,IH2,IH3),SLAB1(IS1,IS2),SLAB2(IS1,IS2)                 PSFC.11
      DIMENSION SFCPR(IS1,IS2)                                                   PSFC.12
      CHARACTER*32 NAMES                                                         PSFC.13
      IF(IP.EQ.0) PRINT 10                                                       PSFC.14
      IF(IP.GT.0) PRINT 13                                                       PSFC.15
   10 FORMAT (1H1,'@@@@@@@@@@ CALL PSFC(SFC ANALYSIS)---(FILSLB),(HRZF',         PSFC.16
     1'IL),(SLBFIL),OUTPT'////)                                                  PSFC.17
   13 FORMAT(//1X,'@@@@@@@@@@ CALL PSFC(SFC ANALYSIS)---(FILSLB),(HRZF',         PSFC.18
     1'IL),(SLBFIL),OUTPT'////)                                                  PSFC.19
      IF(IP.EQ.0) PRINT 11                                                       PSFC.20
      IF(IP.GT.0) PRINT 12                                                       PSFC.21
   11 FORMAT(24X,'SFC PRESSURE AT CROSS PTS--(1ST GUESS)')                       PSFC.22
   12 FORMAT(24X,'SFC PRESSURE AT CROSS PTS--(OBJ-ANAL)')                        PSFC.23
C                                                                                PSFC.24
C        CALCULATE AND SAVE SFC PRES AT CROSS POINTS, BASED ON 850 MB            PSFC.25
C        TEMP. AND TERRAIN HT., ASSUMING CONST. LAPSE RATE = -6.5 C/KM.          PSFC.26
C                                                                                PSFC.27
      GAMMA = 6.5E-3                                                             PSFC.28
      G = 9.8                                                                    PSFC.29
      R = 287.04                                                                 PSFC.30
      XTERM = GAMMA*R/G                                                          PSFC.31
      GRLG78 = G/(LOG(850.0/700.0)*R)                                            PSFC.32
      GRLG57 = G/(LOG(700.0/500.0)*R)                                            PSFC.33
      CALL FILSLB(2,IREFPC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    PSFC.34
      DO 100 JS = 1,JSTRPH                                                       PSFC.35
C                                                                                PSFC.36
C  IF INTERPOLATION USING 1000 MB LEVEL IS DESIRED---LLX=LLX-1                   PSFC.37
C                                                                                PSFC.38
      LL2 = 3                                                                    PSFC.39
      LL3 = 4                                                                    PSFC.40
      LL4 = 5                                                                    PSFC.41
      CALL HRZFIL(JS,1,IREFH,1,HORZH,IH1,IH2,IH3,.FALSE.)                        PSFC.42
      CALL HRZFIL(JS,LL2,ITEMP,2,HORZH,IH1,IH2,IH3,.FALSE.)                      PSFC.43
      CALL HRZFIL(JS,LL3,ITEMP,3,HORZH,IH1,IH2,IH3,.FALSE.)                      PSFC.44
      CALL HRZFIL(JS,LL4,ITEMP,4,HORZH,IH1,IH2,IH3,.FALSE.)                      PSFC.45
      CALL HRZFIL(JS,LL2,IHGT,5,HORZH,IH1,IH2,IH3,.FALSE.)                       PSFC.46
      JA = JHLFT(JS)                                                             PSFC.47
      JB = JHRHT(JS)                                                             PSFC.48
      IF(JB.GT.JE) JB = JE                                                       PSFC.49
      DO 100 JJ = JA,JB                                                          PSFC.50
      J = JJ - JHLFT(JS) + 1                                                     PSFC.51
      IF(JS.GT.1)J = J + 1                                                       PSFC.52
C        AVG. GEO. HGT. TO CROSS PTS FOR THE CURRENT I-ROW, FIND                 PSFC.53
C        TEMP IN KELVIN.                                                         PSFC.54
      DO 50 II = 1,IE                                                            PSFC.55
      HORZH(II,J,5) = 0.25*(HORZH(II,J,5)+ HORZH(II+1,J,5) +                     PSFC.56
     1 HORZH(II,J+1,5) + HORZH(II+1,J+1,5))                                      PSFC.57
      HORZH(II,J,2) = HORZH(II,J,2) + 273.15                                     PSFC.58
      HORZH(II,J,3) = HORZH(II,J,3) + 273.15                                     PSFC.59
      HORZH(II,J,4) = HORZH(II,J,4) + 273.15                                     PSFC.60
  50  CONTINUE                                                                   PSFC.61
      DO 100 II = 1,IE                                                           PSFC.62
C        FIRST, FIND AND APPROXIMATE TSFC THAT DOES NOT INCLUDE DIURNAL          PSFC.63
C        EFFECTS (TO A FIRST-ORDER APPROXIMATION).                               PSFC.64
C  FIND AN APPROXIMATE SFC PRES AS A FIRST GUESS                                 PSFC.65
      XAPRX = -HORZH(II,J,1)/HORZH(II,J,5)                                       PSFC.66
      PSAPRX = SLAB1(II,JJ)*(SLAB1(II,JJ)/850.)**XAPRX                           PSFC.67
C  FIND TEMP AT 100 MB ABOVE SFC OR AT 850MB IF TERRAIN IS BELOW 950MB           PSFC.68
      IF (PSAPRX .LT. 950.) GO TO 60                                             PSFC.69
C  VERY LOW TERRAIN                                                              PSFC.70
      P1 = 850.                                                                  PSFC.71
      T1 = HORZH(II,J,2)                                                         PSFC.72
      GO TO 80                                                                   PSFC.73
   60 CONTINUE                                                                   PSFC.74
      P1 = PSAPRX-100.                                                           PSFC.75
      IF (PSAPRX .LT. 850.) GO TO 70                                             PSFC.76
C  MIDDLE TERRAIN                                                                PSFC.77
      GAM78 = GRLG78*LOG(HORZH(II,J,2)/HORZH(II,J,3))                            PSFC.78
      X78 = GAM78*R/G                                                            PSFC.79
      T1 = HORZH(II,J,3)*(P1/700.)**X78                                          PSFC.80
      GO TO 80                                                                   PSFC.81
   70 CONTINUE                                                                   PSFC.82
      IF (PSAPRX .LT. 700.) GO TO 75                                             PSFC.83
C  HIGH TERRAIN                                                                  PSFC.84
      GAM57 = GRLG57*LOG(HORZH(II,J,3)/HORZH(II,J,4))                            PSFC.85
      X57 = GAM57*R/G                                                            PSFC.86
      T1 = HORZH(II,J,4)*(P1/500.)**X57                                          PSFC.87
      GO TO 80                                                                   PSFC.88
   75 CONTINUE                                                                   PSFC.89
C                                                                                PSFC.90
C  VERY HIGH TERRAIN  USE TEMP AT 500MB AS T1,  THEN EXTRAPOLATE DOWN US         PSFC.91
C  STANDARD LAPSE RATE                                                           PSFC.92
C                                                                                PSFC.93
      P1 = 500.                                                                  PSFC.94
      T1 = HORZH(II,J,4)                                                         PSFC.95
   80 TSL = T1*(SLAB1(II,JJ)/P1)**XTERM                                          PSFC.96
      TSFCPM = TSL - GAMMA*HORZH(II,J,1)                                         PSFC.97
      TSLC=290.66                                                                PSFC.98
      IF(TSL .LT. TSLC) GO TO 95                                                 PSFC.99
      TSL = TSLC                                                                 PSFC.100
      IF(TSFCPM .GT. TSLC) TSL = TSL - 0.005*(TSFCPM - TSLC)**2                  PSFC.101
  95  TBAR = 0.5*(TSFCPM + TSL)                                                  PSFC.102
      TERM = -HORZH(II,J,1)*G/(R*TBAR)                                           PSFC.103
      SLAB1(II,JJ) = SLAB1(II,JJ)*EXP(TERM)                                      PSFC.104
 100  CONTINUE                                                                   PSFC.105
C                                                                                PSFC.106
C  STORE SFC PRES FOR LATER CALC OF SFC THETA                                    PSFC.107
C                                                                                PSFC.108
      IF(IP.GT.0) THEN                                                           PSFC.109
      DO 101 I=1,IE                                                              PSFC.110
      DO 101 J=1,JE                                                              PSFC.111
  101 SFCPR(I,J)=SLAB1(I,J)                                                      PSFC.112
      DO 102 I=1,IE                                                              PSFC.113
  102 SFCPR(I,JMAX)=SFCPR(I,JE)                                                  PSFC.114
      DO 103 J=1,JMAX                                                            PSFC.115
  103 SFCPR(IMAX,J)=SFCPR(IE,J)                                                  PSFC.116
      END IF                                                                     PSFC.117
      CALL SLBFIL(1,IREFPC,5,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    PSFC.118
      CALL DOTS(SLAB1,SLAB2,IS1,IS2,IS1,IS2)                                     PSFC.119
      CALL SLBFIL(1,IREFPD,5,HORZH,IH1,IH2,IH3,SLAB2,IS1,IS2)                    PSFC.120
      IF(.NOT.DRAWM) GO TO 110                                                   PSFC.121
      L1 = 1                                                                     PSFC.122
      IVRBL = IREFPC                                                             PSFC.123
      WRITE (NAMES,105) L1,IVAR(3,IVRBL)                                       P PSFC.124
 105  FORMAT('LEVEL=',I2,10X,'  IVAR =',I4,2X)                                   PSFC.125
      ILB=IVAR(3,IVRBL)                                                          PSFC.126
      CALL OUTPT(SLAB1,IS1,1,IS1-1,INY,IS2,1,IS2-1,JNX,KSIGT,NAMES,ILB)          06NOV00.470
  110 RETURN                                                                     PSFC.128
      END                                                                        PSFC.129
