      PROGRAM RAWINS                                                             RAWINS.1
C                                                                                RAWINS.2
C        PURPOSE: THIS PROGRAM INCORPORATES RAWINSONDE DATA AND SURFACE          RAWINS.3
C                 OBSERVATIONS INTO A FINAL ANALYSIS FOR USE BY THE MM5          RAWINS.4
C                 MODELING SYSTEM.                                               RAWINS.5
C                                                                                RAWINS.6
#include <paramdim.incl>                                                         RAWINS.7
#include <paramirb.incl>                                                         RAWINS.8
#include <paramirs.incl>                                                         RAWINS.9
#include <paramcr.incl>                                                          RAWINS.10
C                                                                                RAWINS.11
C   *******************************************************************          RAWINS.12
C                                                                                RAWINS.13
C  DIMENSIONS FOR LARGE ARRAYS ARE AS FOLLOWS:                                   RAWINS.14
C                                                                                RAWINS.15
C  DATAH(ID1,ID2,ID3),CORRH(ID1,ID2,ID3)                                         RAWINS.16
C       ID1=NUMBER OF STANDARD VARIABLES = 5                                     RAWINS.17
C       ID2=NUMBER OF RAOB LEVELS = 100                                          RAWINS.18
C       ID3=MAXIMUM NUMBER OF RAOBS = IRB(PARAMETERIZED DIM.)                    RAWINS.19
C                                                                                RAWINS.20
C  HORZH(IH1,IH2,IH3)                                                            RAWINS.21
C       IH1=IMAX = IMX(PARAMETERIZED DIM.)                                       RAWINS.22
C       IH2=HORIZONTAL STRIP WIDTH = IHS(PARAMETERIZED DIM.)                     RAWINS.23
C       IH3=MAX NUMBER OF VARIABLES IN SCM AT SAME TIME = 5                      RAWINS.24
C                                                                                RAWINS.25
C  SLAB1,SLAB2,SLAB3(IS1,IS2)                                                    RAWINS.26
C       IS1=IMAX = IMX(PARAMETERIZED DIM.)                                       RAWINS.27
C       IS2=JMAX = JMX(PARAMETERIZED DIM.)                                       RAWINS.28
C                                                                                RAWINS.29
C  D1(ICR1)                                                                      RAWINS.30
C       ICR1=F(IMX,JMX,LMX,IRB)--(PARAMETERIZED DIMENSION)                       RAWINS.31
C                                                                                RAWINS.32
#include <comdata.incl>                                                          RAWINS.33
      DIMENSION HORZH(IMX,IHS,5),SLAB1(IMX,JMX),SLAB2(IMX,JMX),                  RAWINS.34
     1SLAB3(IMX,JMX),COR(IMX,JMX),NS(IMX,JMX),SUM(IMX,JMX),SUM2(IMX,JMX)         RAWINS.35
     .     ,NSORT(500),LAND(IMX,JMX),SNOW(IMX,JMX),SLAB4(IMX,JMX),               05DEC01.38
     .     SFCPR(IMX,JMX),ISTAT(2),SCR3D(IMX,JMX,LMX)                            RAWINS.37
      REAL BGR3D(IMX,JMX,LMX)                                                    RAWINS.38
      REAL LANDC(IMX,JMX)                                                        RAWINS.39
                                                                                 RAWINS.40
      INTEGER AYR,AMO,ADY,AHR,AMI,ASC,AFR,RWSUBM                                 RAWINS.41
      CHARACTER*24 MDATE, ISTRTDAT                                               RAWINS.42
#include <comobs.incl>                                                           RAWINS.43
#include <comksfc.incl>                                                          RAWINS.44
C                                                                                RAWINS.45
#include <coma.incl>                                                             RAWINS.46
#include <comb.incl>                                                             RAWINS.47
#include <comc.incl>                                                             RAWINS.48
#include <comd.incl>                                                             RAWINS.49
#include <memcor.incl>                                                           RAWINS.50
#include <hedmif.incl>                                                           RAWINS.51
#include <comwt.incl>                                                            RAWINS.52
      DIMENSION ICHK(8),PDIF12(IMX,JMX),PCHOOSE(13,50)                           RAWINS.53
      DATA (ICHK(I),I=1,8) /8*1/, LCHK /8/, NVOL39 /39/, NMDTG /0/               RAWINS.54
C                                                                                RAWINS.55
C           DECLARE LOGICAL UNIT NO. FOR FDDA SFC. ANALYSES, NVOL39=39           RAWINS.56
C           ICHK(I) IS QUALITY CHK INTEGER FOR EACH FIELD: 1 = OK,               RAWINS.57
C           0 = BAD.  LCHK IS DIMENSIONED LENGTH OF ICHK.                        RAWINS.58
C                                                                                RAWINS.59
C                                                                                RAWINS.60
      LOGICAL IFNEST,FDSF,RECYCL,GOINSIDE                                        RAWINS.61
      LOGICAL LEXIST, LOPENED                                                    RAWINS.62
C                                                                                RAWINS.63
#include <sbm.incl>                                                              RAWINS.64
#include <skwdrw.incl>                                                           RAWINS.65
C                                                                                RAWINS.66
      INTEGER UNIUANM, UNISFNM                                                   RAWINS.67
      LOGICAL IFUATIM, IFFGTIM, F4D, IPLT, IFPRNT                                RAWINS.68
      CHARACTER*120 INDATG                                                       RAWINS.69
C                                                                                RAWINS.70
C NAMELIST FOR LOCAL MIF PARAMETERS                                              RAWINS.71
C                                                                                RAWINS.72
      NAMELIST/LOCMIF/NOBLND,IFPRNT,IFAC,IWTSCM,IWIND,IWT,SMOOTH,ALRAWS,         RAWINS.73
     .     NSTATN,NSELIM,NBOGUS,KBOGUS,ERRMXT,ERRMXW,ERRMXP,IPLOT,               RAWINS.74
     .     IUPPER,ISFCS3,ISFCS6,ISPRNT,RWSUBM,F4D,                               RAWINS.75
     .     ABFLAG,ABOVER,LAGTEM,UNIOBS,BUDWGT,IUINTVL,INTF4D,                    RAWINS.76
     .     NNEWPL,GNLVL,ISKEWT,INDATG                                            RAWINS.77
      NAMELIST/UNILIF/UNIUANM,UNISFNM                                            RAWINS.78
      DATA IPRES/999,1013,1001,1000,850,700,500,400,300,250,200,150,100,         RAWINS.79
     170,50,30/                                                                  RAWINS.80
      DATA NPROJ/'LAMCON  ','POLSTR  ','MERCAT  '/                               RAWINS.81
      CHARACTER *3 FF                                                            RAWINS.82
      CHARACTER*80 FNAME,CDUM                                                    RAWINS.83
      write(*,'(/,2(80(''*''),/))')                                              RAWINS.84
      write(*,'(''PROGRAM RAWINS:   '',//)')                                     RAWINS.85
C                                                                                RAWINS.86
C                                                                                RAWINS.87
C     ... OPEN GKS, OPEN AND ACTIVATE WORKSTATION  AS SND.PLT                    RAWINS.88
C                                                                                RAWINS.89
#ifdef NCARG                                                                     RAWINS.90
      CALL GOPKS(6,IDUM)                                                         RAWINS.91
      FNAME = 'SND.PLT'                                                          RAWINS.92
      CALL GESC(-1391,1,FNAME,1,IDUM,CDUM)                                       RAWINS.93
      CALL GOPWK( 1, 3, 1 )                                                      RAWINS.94
      CALL GACWK(1)                                                              RAWINS.95
#endif                                                                           RAWINS.96
C                                                                                RAWINS.97
C                                                                                RAWINS.98
C  NVOL98 AND 99 ARE INTERNAL RAWINS AND 4DDA FILES FOR AUTOPLOTS                RAWINS.99
C                                                                                RAWINS.100
      NVOL98=98                                                                  RAWINS.101
      NVOL99=99                                                                  RAWINS.102
      NVOL4=4                                                                    RAWINS.103
C                                                                                RAWINS.104
C INITIALIZE NAMELIST OPTIONS--RESET IN LOCAL INPUT FILE IF OTHER                RAWINS.105
C                              SELECTIONS ARE DESIRED                            RAWINS.106
C                                                                                RAWINS.107
      do nn = 1, 120                                                             RAWINS.108
         indatg(nn:nn) = ' '                                                     RAWINS.109
      enddo                                                                      RAWINS.110
      indatg(1:8) = 'regrid'                                                     RAWINS.111
      DO I=1,500                                                                 05DEC01.39
         NSELIM(I)=.FALSE.                                                       06NOV00.471
         NBOGUS(I)=.FALSE.                                                       06NOV00.472
         KBOGUS(I)=.FALSE.                                                       06NOV00.473
         ABFLAG(I)=.FALSE.                                                       RAWINS.113
         IPLOT(I)=.FALSE.                                                        RAWINS.114
         ABOVER(I)=.FALSE.                                                       RAWINS.115
      ENDDO                                                                      RAWINS.116
      LAGTEM=.TRUE.                                                              RAWINS.117
      NOBLND=.FALSE.                                                             RAWINS.118
      IFAC=1   ! (ALTERS)                                                        RAWINS.119
      IWTSCM=3 ! (BANANA)                                                        RAWINS.120
      IUINTVL=12                                                                 RAWINS.121
      IWT=.TRUE.                                                                 RAWINS.122
      SMOOTH=.TRUE.                                                              RAWINS.123
      ALRAWS=.TRUE.                                                              RAWINS.124
      NSTATN=0                                                                   RAWINS.125
      IUPPER=.TRUE.                                                              RAWINS.126
      ISFCS3=.TRUE.                                                              RAWINS.127
      ISFCS6=.TRUE.                                                              RAWINS.128
      IFPRNT = .TRUE.                                                            RAWINS.129
      ISKEWT = 1        ! 1: SKEWT; 2: STUVE.  DEFAULT TO SKEWT DIAGRAM.         RAWINS.130
      ISKDRW = 0        ! THE SKEW-T BACKGROUND HAS NOT BEEN DRAWN.              RAWINS.131
C                                                                                RAWINS.132
C   READ NAMELIST                                                                RAWINS.133
C                                                                                RAWINS.134
      open(14, file='rawins.namelist', status='old', form='formatted')           RAWINS.135
      READ (14,LOCMIF)                                                           RAWINS.136
      close(14)                                                                  RAWINS.137
C                                                                                06NOV00.474
C   Save the GNLVL array in another spot, because we overwrite gnlvl             06NOV00.475
C   in inhrz1.  Save NNEWPL as well.                                             06NOV00.476
C                                                                                06NOV00.477
      nnewpl_orig = nnewpl                                                       06NOV00.478
      do k = 1, 50                                                               06NOV00.479
         gnlvl_orig(k) = gnlvl(k)                                                06NOV00.480
      enddo                                                                      06NOV00.481
C                                                                                RAWINS.138
C  Check some namelist settings.                                                 RAWINS.139
C                                                                                RAWINS.140
      inquire(file=indatg, exist=lexist)                                         RAWINS.141
      if (.not. lexist) then                                                     RAWINS.142
         write(*, '(//,''*****  ERROR EXIT'',/)')                                RAWINS.143
         print*, '       Input File does not exist: ',                           RAWINS.144
     &        indatg(1:index(indatg,' ')-1)                                      RAWINS.145
         write(*, '(''        Check script variable InDatg'',/)')                RAWINS.146
         call abort()                                                            RAWINS.147
      endif                                                                      RAWINS.148
      open(NVOL4,file=indatg,status='old',form='unformatted',                    RAWINS.149
     &     iostat=ierr)                                                          RAWINS.150
      if (ierr .ne. 0) then                                                      RAWINS.151
         write(*, '(//,''*****  ERROR EXIT'',/)')                                RAWINS.152
         print*, '       Problem opening file ',                                 RAWINS.153
     &        indatg(1:index(indatg,' ')-1)                                      RAWINS.154
         write(*, '(''        Check script variable InDatg'',/)')                RAWINS.155
         call abort()                                                            RAWINS.156
      endif                                                                      RAWINS.157
      IF (UNIOBS) READ (14,UNILIF)                                               RAWINS.158
C                                                                                RAWINS.159
      IUPPER=.TRUE.                                                              RAWINS.160
      IF(F4D .AND. INTF4D.GT.3) LAGTEM=.FALSE.                                   RAWINS.161
      IF(.NOT. F4D) LAGTEM = .FALSE.                                             RAWINS.162
      AUTBGW=.FALSE.                                                             RAWINS.163
      AUTBGR=.FALSE.                                                             RAWINS.164
      IF(RWSUBM.EQ.1) AUTBGW=.TRUE.                                              RAWINS.165
      IF(RWSUBM.EQ.2) AUTBGR=.TRUE.                                              RAWINS.166
      FDDASF=F4D                                                                 RAWINS.167
      DO I=1,500                                                                 19DEC02.4
         IF(RWSUBM.LE.1) KBOGUS(I)=.FALSE.                                       RAWINS.169
      ENDDO                                                                      RAWINS.170
C                                                                                RAWINS.171
C  IF USING BUDDY CHECK, ONLY ONE SUBMITTAL IS EXPECTED.                         RAWINS.172
C                                                                                RAWINS.173
      IF(RWSUBM.GT.0.AND.BUDWGT.GT.0.01) THEN                                    RAWINS.174
      PRINT 1                                                                    RAWINS.175
      STOP                                                                       RAWINS.176
      END IF                                                                     RAWINS.177
 1    FORMAT(2X,'THIS VERSION OF RAWINS IS DESIGNED FOR ONLY ONE ',              RAWINS.178
     .     'SUBMITTAL WHEN THE BUDDY CHECK IS EMPLOYED',/,'   EITHER ',          RAWINS.179
     .     'SET BUDWGT TO ZERO (NO BUDDY CHECK) OR SET SUBMIT TO ZERO ',         RAWINS.180
     .     '(NO AUTOBOGUS)')                                                     RAWINS.181
C                                                                                RAWINS.182
C  DEFINE LARGE ARRAY DIMENSION NAMES                                            RAWINS.183
C                                                                                RAWINS.184
      IH1=IMX                                                                    RAWINS.185
      IH2=IHS                                                                    RAWINS.186
      IH3=5                                                                      RAWINS.187
      ID1=5                                                                      RAWINS.188
      ID2=100                                                                    RAWINS.189
      ID3=IRB                                                                    RAWINS.190
      IDS1=ID1                                                                   RAWINS.191
      IDS2=2                                                                     RAWINS.192
      IDS3=IRS                                                                   RAWINS.193
      IS1=IMX                                                                    RAWINS.194
      IS2=JMX                                                                    RAWINS.195
      ICR2=ICR1                                                                  RAWINS.196
      NBFILE=0                                                                   RAWINS.197
      NBRFIL=0                                                                   RAWINS.198
      IF(ID3.GT.IRB.OR.IDS3.GT.IRS) PRINT 25                                     RAWINS.199
      IF(ID3.GT.IRB.OR.IDS3.GT.IRS) STOP                                         RAWINS.200
   25 FORMAT(2X,'PARAMETERIZED DIMENSIONS IRB AND IRS CANNOT EXCEED '//          RAWINS.201
     1'IRB AND IRS RESPECTIVELY BECAUSE OF DIMENSION CONSTANTS IN CODE'          RAWINS.202
     2)                                                                          RAWINS.203
      PRINT 97                                                                   RAWINS.204
 97   FORMAT(' IMX  JMX  LMX   IHS   ICR1')                                      RAWINS.205
      PRINT 98,IMX,JMX,LMX,IHS,ICR1                                              RAWINS.206
 98   FORMAT(I4,1x,I4,1x,I4,1x,I6,1x,I8)                                         RAWINS.207
      PRINT 96,ID3                                                               RAWINS.208
   94 FORMAT(21X,'USING EXPANDED GRID FOR OBJ ANAL')                             RAWINS.209
   95 FORMAT(21X,'NOT USING EXPANDED GRID FOR OBJ ANAL')                         RAWINS.210
   96 FORMAT(3X,'++++++++++--ID3(RAOBS) DIMENSIONED FOR',I4)                     RAWINS.211
C                                                                                RAWINS.212
C                                                                                RAWINS.213
C **** NOTE ****                                                                 RAWINS.214
C  PRINTOUT FOR SPECIFIC LEVELS CAN BE REGULATED IN SUBR. BLEND                  RAWINS.215
C                                                                                RAWINS.216
C   READ RECORD HEADER INFO FROM PROGRAM REGRID                                  RAWINS.217
C                                                                                RAWINS.218
C  READ MIF, MRF, MIFC, MRFC ARRAYS                                              RAWINS.219
C  THE MIF AND MRF ARRAYS HOLD INFORMATION PASSED FROM PROGRAM REGRID            RAWINS.220
C  CONCERNING GRID CONFIGURATION, TIMES TO PROCESS, ETC.  THE NECESSARY          RAWINS.221
C  VARIABLES ARE DEFINED BELOW IN SUBROUTINE HEDRIN.                             RAWINS.222
C                                                                                RAWINS.223
C-----------------------------------------------------------------------         RAWINS.224
      READ(NVOL4,ERR=100) IV3FLAG                                                RAWINS.225
      print*, 'IV3FLAG = ', iv3flag                                              RAWINS.226
      IF (IV3FLAG .EQ. 0) READ(NVOL4,ERR=100) MIF,MRF,MIFC,MRFC                  RAWINS.227
C-----------------------------------------------------------------------         RAWINS.229
      REWIND NVOL4                                                               RAWINS.230
      IFILES=0                                                                   RAWINS.231
      IFGINT=0                                                                   RAWINS.232
      NLVDAT=0                                                                   RAWINS.233
      do ii = 1, maxplv                                                          RAWINS.234
         lprdat(ii) = 0                                                          RAWINS.235
      enddo                                                                      RAWINS.236
      ifirst = '        '                                                        RAWINS.237
      INY    = 10                                                                RAWINS.238
      JNX    = 10                                                                RAWINS.239
      KSIGT  = 5                                                                 RAWINS.240
      IHEMIS = -99                                                               RAWINS.241
      ISEQ   = -99                                                               RAWINS.242
      JSEQ   = -99                                                               RAWINS.243
      IFCST  = -99                                                               RAWINS.244
      CALL HEDRIN(IPROG,ISTRTDAT,IPROJ,IRATIO,                                   RAWINS.245
     .     IXMOAD,JXMOAD,IXCLC,JXCLC,IMAX,JMAX,ICNS,JCNS,                        RAWINS.246
     .     NSTTYP,DS,PHIC,XLONC,                                                 RAWINS.247
     .     AEXP,PTOP,TRUELAT1,TRUELAT2,XSOUTH,XWEST,XNORTH,XEAST,IFNEST,         RAWINS.248
     .     IEXP,MAXIC,MAXJC,DSBUD,INC,NESTID)                                    RAWINS.249
C                                                                                RAWINS.250
C  PRINT INTEGER MIF VARIABLES                                                   RAWINS.251
C                                                                                RAWINS.252
      PRINT 16                                                                   RAWINS.253
      PRINT 17                                                                   RAWINS.254
      CALL DECOMDAT(ISTRTDAT,AYR,AMO,ADY,AHR,AMI,ASC,AFR)                        RAWINS.255
      PRINT 119,IFCST                                                            RAWINS.256
      PRINT 19,IFILES,AYR,AMO,ADY,AHR,IMAX,JMAX,ICNS,JCNS,                       RAWINS.257
     1 NSTTYP,INY,JNX,KSIGT,ISEQ                                                 RAWINS.258
C                                                                                RAWINS.259
C  PRINT FLOATING POINT MIF VARIABLES                                            RAWINS.260
C                                                                                RAWINS.261
      PRINT 16                                                                   RAWINS.262
      PRINT 20                                                                   RAWINS.263
      PRINT 21,DS,PHIC,XLONC,AEXP,PTOP                                           RAWINS.264
C                                                                                RAWINS.265
C  PRINT LOGICAL MIF VARIABLES                                                   RAWINS.266
C                                                                                RAWINS.267
      PRINT 16                                                                   RAWINS.268
      PRINT 26                                                                   RAWINS.269
      PRINT 27,IFNEST,IEXP,JSEQ                                                  RAWINS.270
      IF(IEXP) PRINT 94                                                          RAWINS.271
      IF(.NOT.IEXP) PRINT 95                                                     RAWINS.272
      IF(RWSUBM.EQ.0) PRINT 91                                                   RAWINS.273
      IF(RWSUBM.EQ.1) PRINT 92                                                   RAWINS.274
      IF(RWSUBM.EQ.2) PRINT 93                                                   RAWINS.275
      IF(LAGTEM) PRINT 191                                                       RAWINS.276
      IF(.NOT.LAGTEM.AND.F4D) PRINT 192                                          RAWINS.277
      IF(UNIOBS) PRINT 193                                                       RAWINS.278
   91 FORMAT(3X,'FIRST RAWINS SUBMITTAL--NO SECOND SUBM INTENDED')               RAWINS.279
   92 FORMAT(3X,'FIRST RAWINS SUBMITTAL--A SECOND SUBM INTENDED')                RAWINS.280
   93 FORMAT(3X,'SECOND RAWINS SUBMITTAL')                                       RAWINS.281
  191 FORMAT(3X,'3-HR LAG TIME WILL BE USED FOR NON-STANDARD TIME'               RAWINS.282
     &     //' 1ST GUESS')                                                       RAWINS.283
  192 FORMAT(3X,'TEMPORAL INTERPOLATION WILL BE USED FOR NON-STANDA'//           RAWINS.284
     1'RD TIME 1ST GUESS')                                                       RAWINS.285
  193 FORMAT(2X,'========================== USING UNIDATA OBS ======'//          RAWINS.286
     1'==========================')                                              RAWINS.287
      CALL SETUP(ID1,ID2,ID3,IH1,IH2,IH3,IS1,IS2,RWSUBM,INTF4D,IFPRNT,           RAWINS.288
     .     ISTRTDAT,TRUELAT1,TRUELAT2,IXMOAD,JXMOAD,IXCLC,                       06NOV00.482
     .     JXCLC,XSOUTH,XNORTH,XWEST,XEAST,IRATIO,NESTID,SLAB1,SLAB2)            RAWINS.290
C                                                                                RAWINS.291
C     INHRZ2 TEMPORALLY INTERPOLATES FIRST-GUESS FIELDS IF THE OUTPUT            RAWINS.292
C     INTERVAL IS GREATER THAN THE INTERVAL OF FIRST-GUESS FIELDS.               RAWINS.293
C     AFTER THE CALL TO INHRZ2, ALL INTERPOLATED FIELDS ARE IN VOLUME            RAWINS.294
C     NVOL45.                                                                    RAWINS.295
C                                                                                RAWINS.296
      IF(F4D) THEN                                                               RAWINS.297
         CALL INHRZ2(IFGINT,INTF4D,IFILES,NTIMES,                                RAWINS.298
     &        HORZH,IH1,IH2,IH3,IS1,IS2)                                         RAWINS.299
      ELSE                                                                       RAWINS.300
         NTIMES = IFILES                                                         RAWINS.301
      ENDIF                                                                      RAWINS.302
C     IF (NTIMES.GT.50) THEN                                                     06NOV00.483
C        PRINT *, 'RAWINS CAN ONLY PROCESS UP TO 50 TIME PERIODS,'               06NOV00.484
C        PRINT *, 'RESUBMIT REGRID AND SPLIT THE DATA TIMES'                     06NOV00.485
C        STOP 'NTIMES TOO LARGE'                                                 06NOV00.486
C     END IF                                                                     06NOV00.487
C                                                                                RAWINS.308
C  LOOP THRU TIME PERIODS                                                        RAWINS.309
C                                                                                RAWINS.310
      IF(UNIOBS) NTIMES=MIN(NTIMES,MAX(UNIUANM,UNISFNM))                         RAWINS.311
      write(*,'(''NTIMES  = '', I5)') NTIMES                                     RAWINS.312
      ifildat = 0                                                                RAWINS.313
      DO 35 IFILE=1,100000                                                       RAWINS.314
         IF (F4D) THEN                                                           RAWINS.315
            NVOLFGA=NVOL45                                                       RAWINS.316
            print*, 'NVOLFGA = ', nvolfga                                        RAWINS.317
            READ(NVOLFGA,END=36) IV3FLAG                                         RAWINS.318
            print*, 'IV3FLAG = ', IV3FLAG                                        RAWINS.319
            if (iv3flag .eq. 2) then ! We have an upper-air time to process      RAWINS.320
               NVOLFGA = NVOL4                                                   RAWINS.321
               print*, 'NVOLFGA = ', nvolfga                                     RAWINS.322
               read(NVOLFGA) iv3flag                                             RAWINS.323
               print*, 'IV3FLAG = ', IV3FLAG                                     RAWINS.324
               IF (IV3FLAG .EQ. 0) THEN                                          RAWINS.325
                  print*, 'Reading header.'                                      RAWINS.326
                  READ(NVOLFGA) MIFSCR, MRFSCR                                   RAWINS.327
               ELSE                                                              RAWINS.328
                  print*, 'Backspacing on ', NVOLFGA                             RAWINS.329
                  backspace(NVOLFGA)                                             RAWINS.330
               ENDIF                                                             RAWINS.331
               IFFGTIM=.TRUE.                                                    RAWINS.332
               IFUATIM=.TRUE.                                                    RAWINS.333
               print*, 'ifile, intf4d, ifgint = ', ifile, intf4d, ifgint         RAWINS.334
               IOFGT=((IFILE-1)*INTF4D/IFGINT)+1                                 RAWINS.335
            else                                                                 RAWINS.336
               ! We have a surface time to process                               RAWINS.337
               IFFGTIM=.FALSE.                                                   RAWINS.338
               IFUATIM=.FALSE.                                                   RAWINS.339
               call geth_newdate(mdate(1:13), mdate(1:13), INTF4D)               RAWINS.340
               if (iv3flag .eq. 0) then                                          RAWINS.341
                  print*, 'Reading header.'                                      RAWINS.342
                  READ(NVOLFGA) MIFSCR, MRFSCR                                   RAWINS.343
               elseif (iv3flag.eq.1) then                                        RAWINS.344
                  print*, 'Backspacing on ', NVOLFGA                             RAWINS.345
                  backspace(nvolfga)                                             RAWINS.346
               endif                                                             RAWINS.347
            endif                                                                RAWINS.348
         ELSE                                                                    RAWINS.349
            NVOLFGA = NVOL4                                                      RAWINS.350
            print*, 'NVOLFGA = ', nvolfga                                        RAWINS.351
            read(NVOLFGA,END=36) iv3flag                                         RAWINS.352
            print*, 'IV3FLAG = ', IV3FLAG                                        RAWINS.353
            IF (IV3FLAG .EQ. 0) THEN                                             RAWINS.354
               print*, 'Reading header.'                                         RAWINS.355
               READ(NVOLFGA) MIFSCR, MRFSCR                                      RAWINS.356
            ELSEIF (IV3FLAG .EQ. 2) THEN                                         RAWINS.357
               print*, 'End of time unexpected.'                                 RAWINS.358
               stop                                                              RAWINS.359
            ELSE                                                                 RAWINS.360
               print*, 'Backspacing on ', NVOLFGA                                RAWINS.361
               backspace(NVOLFGA)                                                RAWINS.362
            ENDIF                                                                RAWINS.363
            IFFGTIM=.TRUE.                                                       RAWINS.364
            IFUATIM=.TRUE.                                                       RAWINS.365
            IOFGT=IFILE                                                          RAWINS.366
         ENDIF                                                                   RAWINS.367
      NSORT(IFILE)=1                                                             RAWINS.368
 4431 format(I4.4,2('-',I2.2),'_',2(I2.2,':'),I2.2,'.',I4.4)                     RAWINS.369
      AUTBW=AUTBGW                                                               RAWINS.370
      AUTBR=AUTBGR                                                               RAWINS.371
      IF(AUTBW.AND.AUTBR)THEN                                                    RAWINS.372
      PRINT 873                                                                  RAWINS.373
873   FORMAT(///,10X,'DO NOT SET AUTBGW AND AUTBGR BOTH EQUAL TO '//             RAWINS.374
     &'''TRUE''','...STOP.')                                                     RAWINS.375
      STOP 873                                                                   RAWINS.376
      ENDIF                                                                      RAWINS.377
      IF(AUTBW)NBFILE=NBFILE+1                                                   RAWINS.378
      write(*,'(''KBOGR,KBOGUS,IFILE='',2L6,I5)')                                RAWINS.379
     &     KBOGR,KBOGUS(IFILE),IFILE                                             RAWINS.380
      KBOGR=KBOGUS(IFILE)                                                        RAWINS.381
      IF(AUTBR)NBRFIL=NBRFIL+1                                                   RAWINS.382
      IPLT=IPLOT(IFILE)                                                          RAWINS.383
      IF(IPLT) PRINT 31                                                          RAWINS.384
      IF(.NOT.IPLT) PRINT 32                                                     RAWINS.385
   31 FORMAT(4X,'^^^^^^^^^^^^^RAOB PLOTS FOR THIS TIME PERIOD')                  RAWINS.386
   32 FORMAT(4X,'^^^^^^^^^^^^^NO RAOB PLOTS FOR THIS TIME PERIOD')               RAWINS.387
      CALL SETUPS(ID1,ID2,ID3,IFILE,IFUATIM)                                     RAWINS.388
      IF(IFILE.EQ.1) THEN                                                        RAWINS.389
      ERRORW=ERRMXW                                                              RAWINS.390
      ERRORP=ERRMXP                                                              RAWINS.391
      END IF                                                                     RAWINS.392
C                                                                                RAWINS.393
C  INCREASE ERRMXP AND ERRMXW IF USING TEMPORAL INTERPOLATION FOR                RAWINS.394
C  THE 1ST GUESS FIELDS (MISSING DATA)                                           RAWINS.395
C                                                                                RAWINS.396
      IF((JSEQ.NE.0).AND.(IOFGT.EQ.ISEQ).AND.(IFUATIM))THEN                      RAWINS.397
      ERRMXW=1.5*ERRMXW                                                          RAWINS.398
      ERRMXP=1.5*ERRMXP                                                          RAWINS.399
      END IF                                                                     RAWINS.400
      IF((JSEQ.NE.0).AND.(IOFGT.GT.ISEQ)) THEN                                   RAWINS.401
      ERRMXW=ERRORW                                                              RAWINS.402
      ERRMXP=ERRORP                                                              RAWINS.403
      END IF                                                                     RAWINS.404
      DO 753 I = 1,ID1                                                           RAWINS.405
      DO 853 J = 1,ID2                                                           RAWINS.406
      DO 18 K = 1,ID3                                                            RAWINS.407
      DATAH(I,J,K)=1.E33                                                         RAWINS.408
   18 CORRH(I,J,K)=1.E33                                                         RAWINS.409
  853 CONTINUE                                                                   RAWINS.410
  753 CONTINUE                                                                   RAWINS.411
C        IF NOBLND = TRUE, SIGNIFICANT LEVEL DATA WILL BE COLLECTED AND          RAWINS.412
C        PRINTED OUT, BUT NO BLENDING WILL BE PERFORMED FOR EITHER MANDA         RAWINS.413
C        TORY OR SIGNIFICANT LEVELS.                                             RAWINS.414
      IF (.NOT.NOBLND) THEN                                                      RAWINS.415
      write(*,'(''IFUATIM = '', L5)') IFUATIM                                    RAWINS.416
      write(*,'(''IFFGTIM = '', L5)') IFFGTIM                                    RAWINS.417
      IF (IFFGTIM) THEN                                                          RAWINS.418
         CALL INHRZ1(HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2,LAND,SNOW,                  RAWINS.419
     .        LMX,NVOLFGA,IFUATIM,SCR3D,MDATE,IDERR)                             RAWINS.420
         IF (IDERR .NE. 0) GO TO 36                                              RAWINS.421
         IFILES = IFILES + 1                                                     RAWINS.422
         ifildat = ifildat + 1                                                   RAWINS.423
      PRINT15, (GNLVL(N),N=1,NNEWPL)                                             RAWINS.424
                                                                                 RAWINS.425
      ENDIF                                                                      RAWINS.426
      ENDIF                                                                      RAWINS.427
C        PREPARE TO READ UPPER AIR SOUNDINGS                                     RAWINS.428
      ISTIM = IFILE                                                              RAWINS.429
      CALL GETRAW(DATAH,CORRH,ID1,ID2,ID3,DATAS,IDS1,IDS2,IDS3,                  RAWINS.430
     .                   MDATE,IUTIM,ISTIM,IFILE,F4D,IFUATIM,                    RAWINS.431
     .                   HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                        RAWINS.432
      PRINT 300                                                                  RAWINS.433
300   FORMAT(21X,'GETRAW COMPLETED')                                             RAWINS.434
                                                                                 RAWINS.435
                                                                                 RAWINS.436
      IF(NOBLND)GO TO 35                                                         RAWINS.437
      IF(KBOGR.OR.AUTBR)THEN                                                     RAWINS.438
C--------READ IN CORRECTIONS TO EXISTING STATIONS:  FOR SURFACE DATA             RAWINS.439
C             KBOGR = .TRUE.FOR MANUAL CORRECTIONS (NVOL=5,FOLLOWING M.I         RAWINS.440
C             AUTBR = .TRUE.FOR AUTOBOGUS CORRECTIONS (NVOL=41)                  RAWINS.441
      CALL BOGPTS(DATAH,CORRH,ID1,ID2,ID3,DATAS,IDS1,IDS2,IDS3,2,MDATE,          RAWINS.442
     1        KBOGR,AUTBR,NBRFIL,RSOND,BUFD,ISTNUM,RANG,IFOUND,BUFUPR)           RAWINS.443
      ENDIF                                                                      RAWINS.444
C                                                                                RAWINS.445
      NUSTAN=ISTATN-JSTATN                                                       RAWINS.446
      CALL SFCBLN (ID1,ID2,ID3,HORZH,IH1,IH2,IH3,SLAB1,                          RAWINS.447
     1 SLAB2,SLAB3,IS1,IS2,COR,NS,SUM,SUM2,DATAS,IDS1,IDS2,IDS3,                 RAWINS.448
     2 MDATE,AUTBGW,AUTBGR,NVOL40,PSTA,IFUATIM,IFFGTIM)                          RAWINS.449
C                                                                                RAWINS.450
C                                                                                RAWINS.451
      IF(.NOT.IFUATIM) THEN                                                      RAWINS.452
         WRITE (6,122)                                                           RAWINS.453
 122     FORMAT (3X,'$$$$$$$$$$ SURFACE ANALYSES HAVE BEEN BLENDED ',            RAWINS.454
     .      'WITH SFC 0BSERVATIONS $$$$$$$$$$')                                  RAWINS.455
         GO TO 42                                                                RAWINS.456
      ENDIF                                                                      RAWINS.457
C                                                                                RAWINS.458
C                                                                                RAWINS.459
      IF(NNEWPL.LE.0)GO TO 550                                                   RAWINS.460
      CALL PSFC(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,SFCPR,IS1,IS2,1)                   RAWINS.461
C                                                                                RAWINS.462
C-----IF FDSF = .T., SAVE THE DIFFERENCE BETWEEN SEA-LEVEL                       RAWINS.463
C     PRES. AND SFC. PRES. IN PDIF12 FOR 00 GMT OR 12 GMT.                       RAWINS.464
      CALL FILSLB(2,IREFPC,1,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    RAWINS.465
      DO 370 I=1,IMAX                                                            RAWINS.466
      DO 370 J=1,JMAX                                                            RAWINS.467
      PDIF12(I,J)=SLAB1(I,J)-SFCPR(I,J)                                          RAWINS.468
370   CONTINUE                                                                   RAWINS.469
C                                                                                RAWINS.470
C        NOW, CREATE NEW NON-MANDATORY PRESSURE FIELDS (FIRST GUESS)             RAWINS.471
C        IF DESIRED.                                                             RAWINS.472
C                                                                                RAWINS.473
      CALL SIGDAT(DATAH,CORRH,ID1,ID2,ID3,IPLT,IFILE,NSORT,                      RAWINS.474
     1            DATAS,IDS1,IDS2,IDS3)                                          RAWINS.475
      IF (IFIRST.EQ.'MM5   ') GO TO 550                                          RAWINS.476
      IVRBL = IUVEL                                                              RAWINS.477
 505  CONTINUE                                                                   RAWINS.478
C                                                                                06NOV00.488
C Check to see if any of the "new" pressure levels already have data             06NOV00.489
C                                                                                06NOV00.490
      i = 0                                                                      06NOV00.491
      do l = 1, nnewpl                                                           06NOV00.492
         do k = 1, maxplv                                                        06NOV00.493
            if (abs(GNLVL(l)-lprdat(k)) .lt. 0.1) then                           06NOV00.494
               i = i + 1                                                         06NOV00.495
            endif                                                                06NOV00.496
         enddo                                                                   06NOV00.497
      enddo                                                                      06NOV00.498
      if (I .EQ. NNEWPL) then                                                    06NOV00.499
         write(*,509)                                                            06NOV00.500
 509     format(/,'$$$$$$$$$$  NO FIRST-GUESS VERTICAL INTERPOLATION ',          06NOV00.501
     &        'NEEDED.  SUBROUTINE NEWPLV SKIPPED.  $$$$$$$$$$',/)               06NOV00.502
         go to 550                                                               06NOV00.503
      endif                                                                      06NOV00.504
      PRINT 510,NNEWPL-I,IVRBL                                                   06NOV00.505
 510  FORMAT('@@@@@ CREATE ',I2,' NEW PRESSURE LEVELS OF IVRBL=',                06NOV00.506
     1 I2,' BY CALLING NEWPLV')                                                  RAWINS.481
C                                                                                06NOV00.507
C Call NEWPLV only for "new" pressure levels that are not in the                 06NOV00.508
C first-guess file.                                                              06NOV00.509
C                                                                                06NOV00.510
      DO 520 L = 1,NNEWPL                                                        RAWINS.482
         do k = 1, maxplv                                                        06NOV00.511
            if (abs(GNLVL(l)-lprdat(k)) .lt. 0.1) go to 520                      06NOV00.512
         enddo                                                                   06NOV00.513
         CALL NEWPLV(L,IVRBL,HORZH,IH1,IH2,IH3,SLAB1,IS1,IS2)                    06NOV00.514
 520  CONTINUE                                                                   06NOV00.515
      write(*,'(//)')                                                            06NOV00.516
      IF(IVRBL .NE. IUVEL)GO TO 525                                              RAWINS.484
      IVRBL = IVVEL                                                              RAWINS.485
      GO TO 505                                                                  RAWINS.486
 525  IF(IVRBL .NE. IVVEL) GO TO 530                                             RAWINS.487
      IVRBL = ITEMP                                                              RAWINS.488
      GO TO 505                                                                  RAWINS.489
 530  IF(IVRBL .NE. ITEMP) GO TO 535                                             RAWINS.490
      IVRBL = IHGT                                                               RAWINS.491
      GO TO 505                                                                  RAWINS.492
 535  IF(IVRBL .NE. IHGT) GO TO 550                                              RAWINS.493
      IVRBL = IRELH                                                              RAWINS.494
      GO TO 505                                                                  RAWINS.495
 550  CONTINUE                                                                   RAWINS.496
      IF(KBOGR.OR.AUTBR.AND.NSTATN.GT.0)THEN                                     RAWINS.497
C--------READ IN CORRECTIONS TO EXISTING STATIONS:  FOR UPPER-AIR DATA           RAWINS.498
C             KBOGR = .T.  FOR MANUAL CORRECTIONS (NVOL=5,FOLLOWING M.I.         RAWINS.499
C             AUTBR = .T.  FOR AUTOBOGUS CORRECTIONS (NVOL=41)                   RAWINS.500
      CALL BOGPTS(DATAH,CORRH,ID1,ID2,ID3,DATAS,IDS1,IDS2,IDS3,1,MDATE,          RAWINS.501
     1        KBOGR,AUTBR,NBRFIL,RSOND,BUFD,ISTNUM,RANG,IFOUND,BUFUPR)           RAWINS.502
      ENDIF                                                                      RAWINS.503
C        USE PROCESSED UPPER AIR DATA TO OBTAIN VARIABLES FIELDS ON              RAWINS.504
C        PRESSURE LEVELS.                                                        RAWINS.505
      CALL BLEND(ID1,ID2,ID3,HORZH,IH1,IH2,IH3,SLAB1,SLAB2,SLAB3,                RAWINS.506
     1 IS1,IS2,COR,NS,SUM,SUM2,MDATE,AUTBW,AUTBR,NVOL40,IFUATIM)                 RAWINS.507
      KX = NTOTLV                                                                RAWINS.508
      ITOTF = IFILES                                                             RAWINS.509
      IF (UNIOBS) ITOTF = NTIMES                                                 RAWINS.510
      CALL OUTTAP(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,IS1,IS2,LAND,                    RAWINS.511
     &     SNOW,SLAB4,                                                           RAWINS.512
     .     SFCPR,LANDC,MAXIC,MAXJC,MDATE,IFILDAT,NSELIM,NBOGUS,KBOGUS,           RAWINS.513
     .     KX,IFGINT,ISTRTDAT,ITOTF,SCR3D,BGR3D)                                 RAWINS.514
      CALL DISCHK(MAXP1,ICR2)                                                    RAWINS.515
      WRITE (6,22)                                                               RAWINS.516
   22 FORMAT (3X,'$$$$$$$$$$ A MAP FILE HAS BEEN BLENDED WITH RAOBS'//           RAWINS.517
     1' $$$$$$$$$$')                                                             RAWINS.518
42    CONTINUE                                                                   RAWINS.519
      PRINT 213                                                                  RAWINS.520
      PRINT 210,NNTOT,BUDWGT                                                     RAWINS.521
      IF(NNTOT.GT.0.AND.BUDWGT.GT.0.01) THEN                                     RAWINS.522
      PRINT 211                                                                  RAWINS.523
      DO 125 I=1,NNTOT                                                           RAWINS.524
  125 PRINT 212,MSTAB(I),XBUD(I),YBUD(I),BLEV(I),MVARB(I),EDIF(I),               RAWINS.525
     1          BDIF(I),NBTOT(I)                                                 RAWINS.526
      END IF                                                                     RAWINS.527
      PRINT 213                                                                  RAWINS.528
      PRINT 214,MMTOT,ERRMXT,ERRMXW,ERRMXP                                       RAWINS.529
      IF(MMTOT.GT.0) THEN                                                        RAWINS.530
      PRINT 215                                                                  RAWINS.531
      DO 126 I=1,MMTOT                                                           RAWINS.532
  126 PRINT 216,MSTAE(I),XERM(I),YERM(I),ELEVM(I),MVARE(I),ERRMXE(I),            RAWINS.533
     1          EDIFM(I)                                                         RAWINS.534
      END IF                                                                     RAWINS.535
      PRINT 213                                                                  RAWINS.536
C        CREATE FOUR-DIMENSIONAL DATA-ASSIMILATION OUTPUT FILE FOR               RAWINS.537
C        SURFACE ANALYSES WHEN FDSF = .TRUE.                                     RAWINS.538
      IF (F4D) THEN                                                              RAWINS.539
C    SET NGRID =1 FOR COARSE GRID;  =2 FOR NESTED FINE GRID.                     RAWINS.540
      NGRID=1                                                                    RAWINS.541
      CALL OUTFDA(HORZH,IH1,IH2,IH3,SLAB1,SLAB2,SLAB3,PDIF12,IS1,IS2,            RAWINS.542
     .        MDATE,IFILE,NTIMES,INTF4D,ICHK,LCHK,NVOL39,NGRID,SLAB4,            RAWINS.543
     .        MAXIC,MAXJC,ISTRTDAT)                                              RAWINS.544
      ENDIF                                                                      RAWINS.545
C---- OUTPUT SFC AND SOUNDING DATA                                               RAWINS.546
C     ISTAT_S : SURFACE STATION NAME                                             RAWINS.547
C     XOBS_S  : SURFACE STATION LOCATION IN TERMS OF IX                          RAWINS.548
C     YOBS_S  : SURFACE STATION LOCATION IN TERMS OF JX                          RAWINS.549
C     KSFCEL  : SURFACE STATION ELEVATION                                        RAWINS.550
C     OBS_SFC(I,1) : U; OBS_SFC(I,2) : V; OBS_SFC(I,3) : T                       RAWINS.551
C     OBS_SFC(I,4) : RH; OBS_SFC(I,6) : SLP                                      RAWINS.552
C     IKLAT   : LATITUDE*10                                                      RAWINS.553
C     IKLON   : LONGITUDE *10                                                    RAWINS.554
C     KSFCEL  : STATION HEIGHT                                                   RAWINS.555
                                                                                 RAWINS.556
      PRINT *,' OUTPUT SURFACE OBS ON UNIT 60 FOR MDATE= ',MDATE(1:16)           RAWINS.557
      inquire(file='SFC4DOBS_DOMAIN'//char(mif(13,1)+48),opened=lopened)         RAWINS.558
      if (.not. lopened) then                                                    RAWINS.559
         open(60, file='SFC4DOBS_DOMAIN'//char(mif(13,1)+48),                    RAWINS.560
     &        form='unformatted', status='unknown')                              RAWINS.561
      endif                                                                      RAWINS.562
      DO 749 I=1,JSTATN                                                          RAWINS.563
      WRITE(60) MDATE,ISTA_S(I),IKLAT(2,I),IKLON(2,I)                            RAWINS.564
     +,KSFCEL(I+NUSTAN)                                                          RAWINS.565
     +,OBS_SFC(I,1),OBS_SFC(I,2),OBS_SFC(I,3),OBS_SFC(I,4)                       RAWINS.566
     +,OBS_SFC(I,6)                                                              RAWINS.567
 749  CONTINUE                                                                   RAWINS.568
                                                                                 RAWINS.569
      IF(IFUATIM) THEN                                                           RAWINS.570
      PRINT*,' OUTPUT UPPER AIR OBS ON UNIT 61 FOR MDATE = ',MDATE(1:16)         RAWINS.571
      inquire(file='UPR4DOBS_DOMAIN'//char(mif(13,1)+48),opened=lopened)         RAWINS.572
      if (.not. lopened) then                                                    RAWINS.573
         open(61, file='UPR4DOBS_DOMAIN'//char(mif(13,1)+48),                    RAWINS.574
     &        form='unformatted', status='unknown')                              RAWINS.575
      endif                                                                      RAWINS.576
      PRINT *,'NTOTLV= ',NTOTLV                                                  RAWINS.577
      IF(NTOTLV.GT.100) THEN                                                     RAWINS.578
      PRINT *,' INCREASE THE PPL DIMENSION, PROGRAM STOP'                        RAWINS.579
      STOP                                                                       RAWINS.580
      ENDIF                                                                      RAWINS.581
                                                                                 RAWINS.582
      DO 751 L=1,NTOTLV                                                          RAWINS.583
      IF(L.LE.NVERT) THEN                                                        RAWINS.584
      write(*,'(''LVL, PRESSURE= '', I3, F6.0)') L, GLVL(L)                      RAWINS.585
      PPL(L) = GLVL(L)                                                           RAWINS.586
      ELSE                                                                       RAWINS.587
      PPL(L) = GNLVL(L-NVERT)                                                    RAWINS.588
      write(*,'(''LVL, PRESSURE= '', I3, F6.0)') L, GNLVL(L-NVERT)               RAWINS.589
      ENDIF                                                                      RAWINS.590
 751  CONTINUE                                                                   RAWINS.591
                                                                                 RAWINS.592
C     ISTAT_U : RAOB STATION NAME                                                RAWINS.593
C     XOBS_U  : RAOB STATION LOCATION IN TERMS OF IX                             RAWINS.594
C     YOBS_U  : RAOB STATION LOCATION IN TERMS OF JX                             RAWINS.595
C     KSFCEL  : RAOB STATION ELEVATION                                           RAWINS.596
C     NTOTLV  : TOTAL NO. OF PRESSURE LEVELS                                     RAWINS.597
C     IHEDPR  : PRESSURE LEVELS IN RAWINS (START IN 1000 MB, NOT INCLUD.         RAWINS.598
C     OBS_UP(I,J,1) : U   ; OBS_UP(I,J,2) : V   ; OBS_UP(I,J,3) : T              RAWINS.599
C     OBS_UP(I,J,4) : RH  ; PSTA : RAOB STATION PRESSURE                         RAWINS.600
C     IKLAT   : LATITUDE*10                                                      RAWINS.601
C     IKLON   : LONGITUDE *10                                                    RAWINS.602
C     KSFCEL  : STATION HEIGHT                                                   RAWINS.603
                                                                                 RAWINS.604
      DO 750 I=1,NUSTAN                                                          RAWINS.605
      PPL(1) = PSTA(I)                                                           RAWINS.606
      WRITE(61) MDATE,ISTA_U(I),IKLAT(1,I),IKLON(1,I),KSFCEL(I),NTOTLV           RAWINS.607
     +,(PPL(L),L=1,NTOTLV)                                                       RAWINS.608
     +,(OBS_UP(I,J,1),J=1,NTOTLV)                                                RAWINS.609
     +,(OBS_UP(I,J,2),J=1,NTOTLV),(OBS_UP(I,J,3),J=1,NTOTLV)                     RAWINS.610
     +,(OBS_UP(I,J,4),J=1,NTOTLV)                                                RAWINS.611
  750 CONTINUE                                                                   RAWINS.612
      ENDIF                                                                      RAWINS.613
   35 CONTINUE                                                                   RAWINS.614
 36   CONTINUE                                                                   RAWINS.615
      DO 40 I=1,IFILES                                                           RAWINS.616
      IF(NSORT(I).EQ.0) PRINT 41,I                                               RAWINS.617
   40 CONTINUE                                                                   RAWINS.618
   41 FORMAT(2X,'++++++++++ CAUTION-POSSIBLE PROBLEM WITH A RAOB OBS',           RAWINS.619
     1' IN TIME PERIOD',I3,3X,'CHECK OUTPUT DATA FROM SUBR SIGDAT')              RAWINS.620
      PRINT 646,NMDTG                                                            RAWINS.621
646   FORMAT(15X,'+-+- TOTAL NO. OF MISSING DATE-TIME-GROUPS (SFC)',             RAWINS.622
     1' = ',I2)                                                                  RAWINS.623
C                                                                                RAWINS.624
C--------WHEN NBFILE .GT. 0, CHECK AUTOBOGUS OUTPUT VOLUME.                      RAWINS.625
C                                                                                RAWINS.626
      IF(NBFILE.GT.0)THEN                                                        RAWINS.627
C        AN AUTOBOGUS VOLUME HAS BEEN CREATED.  CHECK CONTENTS.                  RAWINS.628
      REWIND NVOL40                                                              RAWINS.629
      NTOT=0                                                                     RAWINS.630
      DO 640 IFILE=1,NBFILE                                                      RAWINS.631
      PRINT 620,IFILE                                                            RAWINS.632
      PRINT 616                                                                  RAWINS.633
      PRINT 617                                                                  RAWINS.634
      PRINT 618                                                                  RAWINS.635
 616  FORMAT(3X,'NOTE: 3 ASTERISKS MEAN DIFF VALUE > 2.00 X ERRMX')              RAWINS.636
 617  FORMAT(3X,'      2 ASTERISKS MEAN DIFF VALUE > 1.67 X ERRMX')              RAWINS.637
 618  FORMAT(3X,'      1 ASTERISK MEANS DIFF VALUE > 1.33 X ERRMX')              RAWINS.638
      PRINT 615, NVOL40                                                          RAWINS.639
 615  FORMAT(///,10X,'AUTOBOGUS VOLUME NVOL40 =',I3//2X,'KN',2X,'KTYPE',         RAWINS.640
     1 2X,'STA.NO.',2X,'S.L.PRES.',2X,'HGHT.',5X,'TEMP.',4X,                     RAWINS.641
     2  'REL.HUM.',2X,'WND.DIR.',2X,'WND.SPD.',2X,'IVRBL',3X,'YOBS',3X,          RAWINS.642
     3  'XOBS',2X,'LVL',4X,'DATE',4X,'RECYCL')                                   RAWINS.643
 620  FORMAT(///,10X,'AUTOBOGUS VOLUME: IFILE =',I4//)                           RAWINS.644
      NBOGPT=0                                                                   RAWINS.645
 622  CONTINUE                                                                   RAWINS.646
      READ (NVOL40,625,ERR=630,END=641) MDATE,KN,KTYPE,KSTA,LV1,                 RAWINS.647
     *     IVRBL,PK,TK,DK,FK,                                                    RAWINS.648
     1RECYCL,FF,LOCX,LOCY,YOBS,XOBS,ZK,HK                                        RAWINS.649
 625  FORMAT(I9,I4,I2,1X,A8,I3,I2,4F8.1,1X,L1,A3,2I3,2F7.2,2F8.1)                RAWINS.650
      NTOT=NTOT+1                                                                RAWINS.651
      NBOGPT=NBOGPT+1                                                            RAWINS.652
      PRINT 627,KN,KTYPE,KSTA,PK,ZK,TK,HK,DK,FK,IVRBL,YOBS,XOBS,LV1,             RAWINS.653
     1          MDATE,RECYCL,FF                                                  RAWINS.654
 627  FORMAT(I4,3X,I2,5X,A5,4X,F7.1,2X,F7.1,3X,F7.1,3X,F7.1,3X,                  RAWINS.655
     1 F7.1,3X,F7.1,6X,I1,3X,F5.2,2X,F5.2,3X,I2,2X,I8,4X,L1,A3)                  RAWINS.656
      GO TO 622                                                                  RAWINS.657
 630  CONTINUE                                                                   RAWINS.658
      PRINT 635, NBOGPT,IFILE                                                    RAWINS.659
 635  FORMAT(///,10X,'NO. OF AUTOBOGUS PTS=',I5,3X,'ON IFILE=',I3)               RAWINS.660
 640  CONTINUE                                                                   RAWINS.661
 641  CONTINUE                                                                   RAWINS.662
      PRINT 645,NTOT                                                             RAWINS.663
 645  FORMAT(///,20X,'TOTAL NO. OF AUTOBOGUS PTS=',I5)                           RAWINS.664
      ENDIF                                                                      RAWINS.665
#ifdef NCARG                                                                     RAWINS.666
      CALL GDAWK (1)                                                             RAWINS.667
      CALL GCLWK (1)                                                             RAWINS.668
#endif                                                                           RAWINS.669
C                                                                                RAWINS.670
C   PLOT AUTOBOGUS &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&            RAWINS.671
C                                                                                RAWINS.672
      NVL98=NVOL98                                                               RAWINS.673
      PRINT 105                                                                  RAWINS.674
      REWIND NVOL98                                                              RAWINS.675
      REWIND NVOL99                                                              RAWINS.676
      REWIND NVOL40                                                              RAWINS.677
      PRINT 108,(ABFLAG(I),I=1,IFILES)                                           RAWINS.678
      PRINT 109,(ABOVER(I),I=1,IFILES)                                           RAWINS.679
C                                                                                RAWINS.680
C     ... AUTOBOGUS PLOT OPTIONS                                                 RAWINS.681
C                                        ABFLAG ABOVER                           RAWINS.682
C                   NO AUTOBOGUS PLOTS    .F.    .F.                             RAWINS.683
C                   ANALYZED FILES ONLY   .TRUE. .F.                             RAWINS.684
C                   ANALYZED + OVERLAYS   .TRUE. .TRUE.                          RAWINS.685
C                                                                                RAWINS.686
C  LOOP OVER TIME PERIODS                                                        RAWINS.687
C                                                                                RAWINS.688
      DO 655 LOOPT=1,IFILES                                                      RAWINS.689
         ABFLAG(LOOPT)=((ABFLAG(LOOPT)).AND.                                     RAWINS.690
     1     (.NOT.AUTBGR).AND.(AUTBGW))                                           RAWINS.691
         ABOVER(LOOPT)=((ABOVER(LOOPT)).AND.                                     RAWINS.692
     1     (.NOT.AUTBGR).AND.(AUTBGW))                                           RAWINS.693
C                                                                                RAWINS.694
C  LOOP OVER MANDATORY LEVELS                                                    RAWINS.695
C                                                                                RAWINS.696
         DO 653 LOOPP=1,13                                                       RAWINS.697
            PCHOOSE(LOOPP,LOOPT)=999.1                                           RAWINS.698
653      CONTINUE                                                                RAWINS.699
      PCHOOSE(1,LOOPT)=1001.1                                                    RAWINS.700
      PCHOOSE(2,LOOPT)= 850.1                                                    RAWINS.701
      PCHOOSE(3,LOOPT)= 700.1                                                    RAWINS.702
      PCHOOSE(4,LOOPT)= 500.1                                                    RAWINS.703
      PCHOOSE(5,LOOPT)= 300.1                                                    RAWINS.704
655   CONTINUE                                                                   RAWINS.705
      GOINSIDE=.FALSE.                                                           RAWINS.706
      DO 656 LOOPT=1,IFILES                                                      RAWINS.707
         GOINSIDE=(GOINSIDE.OR.ABFLAG(LOOPT))                                    RAWINS.708
656   CONTINUE                                                                   RAWINS.709
C                                                                                RAWINS.710
C  IF YOU WANT A SUBGRID                                                         RAWINS.711
C                                                                                RAWINS.712
      ISTART=1                                                                   RAWINS.713
      IEND=IMX                                                                   RAWINS.714
      JSTART=1                                                                   RAWINS.715
      JEND=JMX                                                                   RAWINS.716
      IPLTCNT=0                                                                  RAWINS.717
      IF(GOINSIDE) THEN                                                          RAWINS.718
#ifdef NCARG                                                                     RAWINS.719
         PRINT *,'GOING INSIDE THE PLOTTING ROUTINE FOR AUTOBOGUS'               RAWINS.720
      XNORTH = XSOUTH + FLOAT(IMX-1)/FLOAT(IRATIO)                               RAWINS.721
      XEAST = XWEST + FLOAT(JMX-1)/FLOAT(IRATIO)                                 RAWINS.722
         CALL PLOTAB(SLAB1,SLAB2,SLAB3,SNOW,SUM,SUM2,                            RAWINS.723
     1     PCHOOSE,ISTART,IEND,JSTART,JEND,XSOUTH,XNORTH,XWEST,XEAST,            RAWINS.724
     .     IFILES,NVL98,IPLTCNT)                                                 RAWINS.725
      IF(FDDASF) THEN                                                            RAWINS.726
         ICOUNT=0                                                                RAWINS.727
         DO 660 IC=1,IFILES-1                                                    RAWINS.728
            ICOUNT=ICOUNT+12/INTF4D                                              RAWINS.729
660      CONTINUE                                                                RAWINS.730
         ICOUNT=ICOUNT+1                                                         RAWINS.731
         DO 670 IC=1,ICOUNT                                                      RAWINS.732
            ABFLAG(IC)=.TRUE.                                                    RAWINS.733
            ABOVER(IC)=.TRUE.                                                    RAWINS.734
         PCHOOSE(1,IC)=1001.1                                                    RAWINS.735
670      CONTINUE                                                                RAWINS.736
         CALL PLOTAB(SLAB1,SLAB2,SLAB3,SNOW,SUM,SUM2,                            RAWINS.737
     1     PCHOOSE,ISTART,IEND,JSTART,JEND,XSOUTH,XNORTH,XWEST,XEAST,            RAWINS.738
     .     IFILES,NVOL99,IPLTCNT)                                                06NOV00.517
      END IF                                                                     RAWINS.740
#endif                                                                           RAWINS.741
      ELSE                                                                       RAWINS.742
         PRINT *,'NOT GOING INSIDE THE PLOTTING ROUTINE FOR ',                   RAWINS.743
     1      'AUTOBOGUS'                                                          RAWINS.744
      END IF                                                                     RAWINS.745
#ifdef NCARG                                                                     RAWINS.746
      CALL GCLKS                                                                 RAWINS.747
#endif                                                                           RAWINS.748
      PRINT*, 'SUCCESSFUL COMPLETION OF PROGRAM RAWINS'                          RAWINS.749
      PRINT*, 'STOP 99999'                                                       RAWINS.750
      STOP 99999                                                                 RAWINS.751
 100  PRINT 101                                                                  RAWINS.752
      STOP                                                                       RAWINS.753
C                                                                                RAWINS.754
C--######### FORMAT STATEMENTS FOR INPUT VARIABLE PRINT #############            RAWINS.755
C                                                                                RAWINS.756
 10   FORMAT(90X,'USING NMC FIRST GUESS FIELDS')                                 RAWINS.757
 11   FORMAT(90X,'USING ECMWF FIRST GUESS FIELDS')                               RAWINS.758
 12   FORMAT(90X,'USING MM5 FIRST-GUESS FIELDS')                                 RAWINS.759
 13   FORMAT(3X,'STANDARD PRES LEVELS ARE ',40I5)                                RAWINS.760
 14   FORMAT(3X,'MAP PROJECTION =',2X,A8)                                        RAWINS.761
 15   FORMAT(3X,'THE NON-MANDATORY PRESSURE LEVELS ARE ',(15F6.0))               RAWINS.762
 16   FORMAT(/)                                                                  RAWINS.763
 17   FORMAT(2X,'FILES IYR  IMO  IDY  IHR IMAX JMAX ICNS JCNS NSTYP'//           RAWINS.764
     .' INY JNX KSIG ISEQ')                                                      RAWINS.765
 19   FORMAT(I5,3x,I4,1x,I2,13I5)                                                RAWINS.766
 20   FORMAT(2X,' DS   PHIC  XLONC  AEXP  PTOP')                                 RAWINS.767
 21   FORMAT(6F6.0)                                                              RAWINS.768
 26   FORMAT(2X,'IFNEST IEXP  JSEQ')                                             RAWINS.769
 27   FORMAT(2L6,I6)                                                             RAWINS.770
C                                                                                RAWINS.771
 101  FORMAT(3X,'REC HEADER ERROR--INPUT FILE MIGHT BE OLD VERSION')             RAWINS.772
 105  FORMAT(3X,'CALL AUTOBOGUS PLOTS')                                          RAWINS.773
 108  FORMAT(3X,'ABFLAG ARRAY =',18L4)                                           RAWINS.774
 109  FORMAT(3X,'ABOVER ARRAY =',18L4)                                           RAWINS.775
 110  FORMAT(90X,'USING UNIDATA FIRST GUESS FIELDS')                             RAWINS.776
 119  FORMAT(73X,'FORECAST HOUR =',I3)                                           RAWINS.777
 210  FORMAT(4X,'DATA REMOVED BY BUDDY CHECK',6X,'NUMBER =',I4,6X,               RAWINS.778
     &  'BUDWGT =',F5.2,/,10X,                                                   RAWINS.779
     &  '(IVRBL: 1 = U, 2 = V, 3 = T, 4 = RH, 6 = P)',/)                         RAWINS.780
 211  FORMAT(1X,'STATION',6X,'XLOC',4X,'YLOC',3X,'LEVEL',5X,'IVRBL',3X,          RAWINS.781
     . 'OB-GUESS',4X,'BUDDYDIF',4X,'NO. OF STATIONS',/)                          RAWINS.782
 212  FORMAT(1X,A8,F8.1,F7.1,F8.0,I8,F11.1,F12.1,I14)                            RAWINS.783
 213  FORMAT(1X,' ')                                                             RAWINS.784
 214  FORMAT(4X,'DATA REMOVED BY ERRMAX',6X,'NUMBER =',I4,6X,                    RAWINS.785
     &'ERRMAX (T,W,P) =',3F6.1,/,10X,                                            RAWINS.786
     &'(IVRBL: 1 = U, 2 = V, 3 = T, 4 = RH, 6 = P)',/)                           RAWINS.787
 215  FORMAT(1X,'STATION',6X,'XLOC',4X,'YLOC',3X,'LEVEL',5X,'IVRBL',3X,          RAWINS.788
     1 'ERRMAX',4X,'OB-GUESS')                                                   RAWINS.789
 216  FORMAT(1X,A8,F9.2,F8.2,F8.0,I8,F10.1,F11.1)                                RAWINS.790
C                                                                                RAWINS.791
      END                                                                        RAWINS.792
                                                                                 RAWINS.793
      subroutine listobs(DATAS,DATAH,CORRH,BUFUPR,RSOND,BUFD,                    RAWINS.794
     &     ID1,ID2,ID3,IRS,IRB,                                                  RAWINS.795
     &     NAMDAT,NAMCOR,NFSTAD,NLSTAD)                                          RAWINS.796
! A handy subroutine useful in some of my debugging                              RAWINS.797
      implicit none                                                              RAWINS.798
! ID1: Number of variables (5)                                                   RAWINS.799
! ID2: Maximum number of levels                                                  RAWINS.800
! ID3: Maximum number of stations                                                RAWINS.801
      integer ID1, ID2, ID3, IRS, IRB                                            RAWINS.802
      REAL DATAH(ID1,ID2,ID3), CORRH(ID1,ID2,ID3)                                RAWINS.803
      REAL DATAS(ID2,2,IRS)                                                      RAWINS.804
      REAL RSOND(ID1,IRS), BUFD(ID1,IRS), BUFUPR(ID1,IRB)                        RAWINS.805
      integer NAMDAT, NAMCOR, NFSTAD, NLSTAD                                     RAWINS.806
                                                                                 RAWINS.807
      INTEGER L, M, N, L1, NAMED, NAMEC, LENBUF, NFS, NLS                        RAWINS.808
      LOGICAL CHECK                                                              RAWINS.809
                                                                                 RAWINS.810
      LENBUF = ID1*ID3                                                           RAWINS.811
      NFS = NFSTAD                                                               RAWINS.812
      NLS = NLSTAD                                                               RAWINS.813
      CHECK = .FALSE.                                                            RAWINS.814
                                                                                 RAWINS.815
C FIRST, SET ALL VALUES IN THE ARRAYS TO A FICTICIOUS VALUE                      RAWINS.816
      DO L = 1,ID2                                                               RAWINS.817
         DO M = 1,ID1                                                            RAWINS.818
            DO N = 1,ID3                                                         RAWINS.819
               DATAH(M,L,N)=1.E33                                                RAWINS.820
               CORRH(M,L,N)=1.E33                                                RAWINS.821
            ENDDO                                                                RAWINS.822
         ENDDO                                                                   RAWINS.823
      ENDDO                                                                      RAWINS.824
                                                                                 RAWINS.825
C NOW, READ IN A FILE OF MANDATORY AND SIGNIFICANT LEVEL DATA,                   RAWINS.826
C BY LEVELS.                                                                     RAWINS.827
      DO L = 1,ID2                                                               RAWINS.828
         NAMED = NAMDAT + 10000*L                                                RAWINS.829
         NAMEC = NAMCOR + 10000*L                                                RAWINS.830
         CALL RDISK(NAMED,BUFUPR,LENBUF,0,LENBUF,CHECK)                          RAWINS.831
         DO M=1,ID1                                                              RAWINS.832
            DO L1=1,ID3                                                          RAWINS.833
               BUFD(M,L1)=BUFUPR(M,L1)                                           RAWINS.834
            ENDDO                                                                RAWINS.835
         ENDDO                                                                   RAWINS.836
         CALL RDISK(NAMEC,BUFUPR,LENBUF,0,LENBUF,CHECK)                          RAWINS.837
         DO M=1,ID1                                                              RAWINS.838
            DO L1=1,ID3                                                          RAWINS.839
               RSOND(M,L1)=BUFUPR(M,L1)                                          RAWINS.840
            ENDDO                                                                RAWINS.841
         ENDDO                                                                   RAWINS.842
         DO N = NFS,NLS                                                          RAWINS.843
            DO M = 1,ID1                                                         RAWINS.844
               DATAH(M,L,N) = BUFD(M,N)                                          RAWINS.845
            ENDDO                                                                RAWINS.846
            IF(RSOND(5,N) .LE. 1.E10) THEN                                       RAWINS.847
               DO M = 1,ID1                                                      RAWINS.848
                  CORRH(M,L,N) = RSOND(M,N)                                      RAWINS.849
               ENDDO                                                             RAWINS.850
            ENDIF                                                                RAWINS.851
         ENDDO                                                                   RAWINS.852
      ENDDO                                                                      RAWINS.853
                                                                                 RAWINS.854
                                                                                 RAWINS.855
      do n = NFS, NLS                                                            RAWINS.856
         write(*,'(I4,10x,"U",19x,"V",19x,"T", 18X,"RH", 19X,"P")')              RAWINS.857
     &        n                                                                  RAWINS.858
         do l = 1, id2                                                           RAWINS.859
            if (corrh(5,l,n).lt.1.E32) then                                      RAWINS.860
               write(*,'(''c: '',5G20.7)')                                       RAWINS.861
     &              (corrh(m,l,n), m = 1, id1)                                   RAWINS.862
            endif                                                                RAWINS.863
         enddo                                                                   RAWINS.864
                                                                                 RAWINS.865
         write(*,'(I4,10x,"U",19x,"V",19x,"T", 18X,"RH", 19X,"Z")')              RAWINS.866
     &        n                                                                  RAWINS.867
                                                                                 RAWINS.868
         do l = 1, id2                                                           RAWINS.869
            if (datah(5,l,n).lt.1.E32) then                                      RAWINS.870
               write(*,'(''d: '',5G20.7)')                                       RAWINS.871
     &              (datah(m,l,n), m = 1, id1)                                   RAWINS.872
            endif                                                                RAWINS.873
         enddo                                                                   RAWINS.874
                                                                                 RAWINS.875
      enddo                                                                      RAWINS.876
                                                                                 RAWINS.877
      do N = 1, IRB                                                              RAWINS.878
         do l = 1, 2                                                             RAWINS.879
            write(*,'(I4, ''s: '',5G20.7)') n,                                   RAWINS.880
     &           (datas(m,l,n), m = 1, id1)                                      RAWINS.881
         enddo                                                                   RAWINS.882
      enddo                                                                      RAWINS.883
                                                                                 RAWINS.884
      end                                                                        RAWINS.885
