      SUBROUTINE RDADP(IUN,IST,YLONH,NYR,NMO,NDY,NHR)                            RDADP.1
C-----------------------------------------------------------------------         RDADP.2
C                                                                                RDADP.3
#include <comb.incl>                                                             RDADP.4
C                                                                                RDADP.5
C-----------------------------------------------------------------------         RDADP.6
C-----------------------------------------------------------------------         RDADP.7
C                                                                                RDADP.8
#include <comadp.incl>                                                           RDADP.9
C-----------------------------------------------------------------------         RDADP.10
C                                                                                RDADP.11
C        PURPOSE: RDADP READS A STATION REPORT, THAT IS, A RECORD,               RDADP.12
C                 FROM A PACKED DATA TAPE, CALLS UNPACKING ROUTINES,             RDADP.13
C                 AND ISOLATES THE REPORT IDENTIFICATION WORDS.                  RDADP.14
C                                                                                RDADP.15
C        REPORT IDENTIFIERS:                                                     RDADP.16
C                 SSTA = STATION ID. NO., 6 CHARACTERS, LEFT JUSTI-              RDADP.17
C                        FIED, BLANK FILL.                                       RDADP.18
C                 YLAT = LATITUDE IN DEGREES (TO HUNDREDTHS)                     RDADP.19
C                 YLON = LONGITUDE IN DEGREES(TO HUNDREDTHS)                     RDADP.20
C                 TIME = TIME OF OBSERVATION IN HRS (TO HUNDREDTHS)              RDADP.21
C                 IRTYP = TYPE OF REPORT CODE                                    RDADP.22
C                 INSTYP = INSTRUMENT TYPE CODE                                  RDADP.23
C                 ELEV = STATION ELEVATION IN METERS                             RDADP.24
C                 LTH =  NO. OF 10-CHARACTER WORDS IN THE REPORT,                RDADP.25
C                        INCLUDING 1ST 5 WORDS OF RECORD IDENTIFIERS.            RDADP.26
C                        OBSERVATION BEGINS WITH 6TH WORD.  LAST WORD            RDADP.27
C                        IS 'END REPORT'.                                        RDADP.28
C                 IYR =  YEAR                                                    RDADP.29
C                 IMO =  MONTH                                                   RDADP.30
C                 IDY =  DAY                                                     RDADP.31
C                 IHR =  HOUR                                                    RDADP.32
C                 IREC = SEQUENTIAL NO. OF THE CURRENT RECORD                    RDADP.33
      CHARACTER*8 A8                                                             RDADP.34
      IF(UNIOBS) THEN                                                            RDADP.35
         IF(IST.EQ.1) RETURN                                                     RDADP.36
         IF(IRTYP.EQ.11) THEN                                                    RDADP.37
            READ(IUN,END=22)IJST,YLAT,YLON,ELEV,NYR,NMO,NDY,NHR,LTHERM,          RDADP.38
     1        LWND                                                               RDADP.39
            NYRUP=NYR                                                            RDADP.40
            NMOUP=NMO                                                            RDADP.41
            NDYUP=NDY                                                            RDADP.42
            NHRUP=NHR                                                            RDADP.43
         END IF                                                                  RDADP.44
         IF(IRTYP.EQ.511) THEN                                                   RDADP.45
            READ(IUN,END=22) IJST,YLAT,YLON,ELEV,NYR,NMO,NDY,NHR                 RDADP.46
            NYRS6=NYR                                                            RDADP.47
            NMOS6=NMO                                                            RDADP.48
            NDYS6=NDY                                                            RDADP.49
            NHRS6=NHR                                                            RDADP.50
         END IF                                                                  RDADP.51
         YLONCK=YLON                                                             RDADP.52
         IF(YLONCK.LT.0.) YLON=ABS(YLON)                                         RDADP.53
         IF(YLONCK.GT.0.) YLON=360-YLON                                          RDADP.54
         WRITE(SSTA(1:6),21) IJST                                                RDADP.55
                                                                                 RDADP.56
 21      FORMAT(I5)                                                              RDADP.57
         GO TO 20                                                                RDADP.58
 22      IST=1                                                                   RDADP.59
         GO TO 90                                                                RDADP.60
      END IF                                                                     RDADP.61
    3 NPT=NPT+LTH                                                                RDADP.62
      KPT=NPT-1                                                                  RDADP.63
      IF(NPT.GT.IWDS)GO TO 5                                                     RDADP.64
      IF(IST.EQ.1)GO TO 5                                                        RDADP.65
      IF(LOGCMP(NB,KPT,EOREP) .EQ. 1) GO TO 4                                    RDADP.66
      PRINT 1002,IREC                                                            RDADP.67
 1002 FORMAT(' RDADP LOST ITS WAY IN RECORD ',I6)                                RDADP.68
      GO TO 5                                                                    RDADP.69
    4 CONTINUE                                                                   RDADP.70
      IF(LOGCMP(NB,NPT,EOREC) .EQ. 1) GO TO 5                                    RDADP.71
      IF (NPT .LT. IWDS) GO TO 20                                                RDADP.72
    5 CONTINUE                                                                   RDADP.73
#if defined (CRAY)
      CALL RDTAPE(IUN,NMODE,0,NB,IDIM)                                           RDADP.75
      CALL IOWAIT(IUN,IST,IWDS)                                                  RDADP.76
#else                                                                            RDADP.77
      CALL readtape(IUN, NB, IDIM, IWDS, NWSZ, NCSZ, IST)                        RDADP.78
#endif                                                                           RDADP.79
C        IST SHOULD EQUAL 1 IF END OF FILE MARK IS DETECTED                      RDADP.80
      IWDS=IWDS*NWSZ/NTBTS                                                       RDADP.81
      IF (IST .EQ. 1) THEN                                                       RDADP.82
         IF (IUN.GT.40) THEN                                                     RDADP.83
            PRINT*, 'I THINK I HAVE RUN OUT OF DATA.  CHECK THE INPUT ',         RDADP.84
     &           'FILES FOR THE CORRECT DATES.'                                  RDADP.85
            STOP 00001                                                           RDADP.86
         ENDIF                                                                   RDADP.87
         GO TO 90                                                                RDADP.88
      ENDIF                                                                      RDADP.89
      IREC=IREC+1                                                                RDADP.90
      IF (IST .EQ. 0) GO TO 8                                                    RDADP.91
      PRINT 1001,IREC,IST                                                        RDADP.92
 1001 FORMAT('0READ ERROR IN RDADP  ',2I10)                                      RDADP.93
    8 CONTINUE                                                                   RDADP.94
      IF(LOGCMP(NB,1,EOREC) .EQ. 1) GO TO 5                                      RDADP.95
      IF(LOGCMP(NB,1,EOFIL) .EQ. 1) GO TO 5                                      RDADP.96
      IF(LOGCMP(NB,3,WASH) .NE. 1) GO TO 10                                      RDADP.97
C        UNPACK HEADER RECORD                                                    RDADP.98
      CALL GBYTES(NB,IC,0,NCSZ,0,10)                                             RDADP.99
      NYR=NTENS(IC(5),2)                                                         RDADP.100
      if (NYR .lt. 40) then                                                      RDADP.101
         NYR = NYR + 2000                                                        RDADP.102
      else                                                                       RDADP.103
         NYR = NYR + 1900                                                        RDADP.104
      endif                                                                      RDADP.105
      NMO=NTENS(IC(7),2)                                                         RDADP.106
      NDY=NTENS(IC(9),2)                                                         RDADP.107
      NHR=NTENS(IC(1),2)                                                         RDADP.108
      write(*,1322) NYR, NMO, NDY, NHR                                           RDADP.109
 1322 format('NYR-NMO-NDY_NHR = ', I4.4,'-',I2.2,'-',I2.2,'_',I2.2)              RDADP.110
                                                                                 RDADP.111
      IF(IUN.EQ.NVOLUP)THEN                                                      RDADP.112
      NYRUP=NYR                                                                  RDADP.113
      NMOUP=NMO                                                                  RDADP.114
      NDYUP=NDY                                                                  RDADP.115
      NHRUP=NHR                                                                  RDADP.116
      ELSE IF(IUN.EQ.NVOLS3)THEN                                                 RDADP.117
      NYRS3=NYR                                                                  RDADP.118
      NMOS3=NMO                                                                  RDADP.119
      NDYS3=NDY                                                                  RDADP.120
      NHRS3=NHR                                                                  RDADP.121
      ELSE IF(IUN.EQ.NVOLS6)THEN                                                 RDADP.122
      NYRS6=NYR                                                                  RDADP.123
      NMOS6=NMO                                                                  RDADP.124
      NDYS6=NDY                                                                  RDADP.125
      NHRS6=NHR                                                                  RDADP.126
      ELSE IF(IUN.EQ.NVOLSP)THEN                                                 RDADP.127
      NYRSP=NYR                                                                  RDADP.128
      NMOSP=NMO                                                                  RDADP.129
      NDYSP=NDY                                                                  RDADP.130
      NHRSP=NHR                                                                  RDADP.131
      ELSE                                                                       RDADP.132
      PRINT 9,IUN                                                                RDADP.133
9     FORMAT(10X,'ERROR-RDADP DOES NOT EXPECT IUN=',I5,5X,'...STOP.')            RDADP.134
      STOP                                                                       RDADP.135
      ENDIF                                                                      RDADP.136
      NPT=9999                                                                   RDADP.137
      GO TO 5                                                                    RDADP.138
   10 CONTINUE                                                                   RDADP.139
      IF(IWDS.LT.9)GO TO 5                                                       RDADP.140
      NPT=1                                                                      RDADP.141
   20 CONTINUE                                                                   RDADP.142
      IYR=NYR                                                                    RDADP.143
      IMO=NMO                                                                    RDADP.144
      IDY=NDY                                                                    RDADP.145
      IHR=NHR                                                                    RDADP.146
      IF(UNIOBS) GO TO 23                                                        RDADP.147
C        UNPACK REPORT IDENTIFICATIONS                                           RDADP.148
      IOFF=NTBTS*(NPT-1)                                                         RDADP.149
      CALL GBYTES(NB,IC,IOFF,NCSZ,0,40)                                          RDADP.150
      IFILL=NWSZ-NCSZ                                                            RDADP.151
      CALL SBYTES(SSTA,BLANK,NCSZ,IFILL,0,1)                                     RDADP.152
      SSTA='        '                                                            RDADP.153
      CALL SBYTES(SSTA,IC(11),0,NCSZ,0,5)                                        RDADP.154
#if defined (DEC)
      call swap4(SSTA, A8, 8)                                                    RDADP.156
#if defined (BIT64)
      SSTA = A8(5:8)//A8(1:4)                                                    RDADP.158
#elif defined (BIT32)
      SSTA = A8                                                                  RDADP.160
#endif                                                                           RDADP.161
#endif                                                                           RDADP.162
      YLAT=NTENS(IC(1),5)*.01                                                    RDADP.163
      YLON=NTENS(IC(6),5)*.01                                                    RDADP.164
   23 CONTINUE                                                                   RDADP.165
      YLONH=YLON                                                                 RDADP.166
C        MAKE LONGITUDE COMPATIBLE WITH REST OF DATAFLOW                         RDADP.167
      IF(YLON .LE. 180.0)YLON = -YLON                                            RDADP.168
      IF(YLON .GT. 180.0 .AND. YLON .LT. 360.0) YLON = 360. - YLON               RDADP.169
      IF(UNIOBS) GO TO 90                                                        RDADP.170
      TIME=NTENS(IC(17),4)*.01                                                   RDADP.171
      IRTYP=NTENS(IC(28),3)                                                      RDADP.172
      INSTYP=NTENS(IC(36),2)                                                     RDADP.173
      ELEV=NTENS(IC(31),5)                                                       RDADP.174
      LTH=NTENS(IC(38),3)                                                        RDADP.175
      IF(LTH.EQ.0) GO TO 5                                                       RDADP.176
   90 RETURN                                                                     RDADP.177
      END                                                                        RDADP.178
                                                                                 RDADP.179
#ifndef CRAY                                                                     RDADP.180
      subroutine readtape(IUNIT, NB, NWD, IWDS, NWSZ, NCSZ, IST)                 RDADP.181
      integer iunit                                                              RDADP.182
      integer NWD                                                                RDADP.183
      integer NB(NWD)                                                            RDADP.184
      integer IWDS, IST                                                          RDADP.185
                                                                                 RDADP.186
      character*1 h(6440)                                                        RDADP.187
      integer iuarr(255)                                                         RDADP.188
      common /CCRD/ iuarr                                                        RDADP.189
                                                                                 RDADP.190
      IST = 0                                                                    RDADP.191
      if (iuarr(iunit).eq.0) then                                                RDADP.192
         print*, 'Unit ', iunit, ' not opened.'                                  RDADP.193
         call abort()                                                            RDADP.194
      endif                                                                      RDADP.195
                                                                                 RDADP.196
      call bnread(iuarr(iunit), h, 6440, nread, iostat, 0)                       RDADP.197
      ist = iostat                                                               RDADP.198
      if (ist.ne.0) then                                                         RDADP.199
         print*, 'ist = ', ist                                                   RDADP.200
         return                                                                  RDADP.201
      endif                                                                      RDADP.202
                                                                                 RDADP.203
      ii = 6440 * NCSZ / NWSZ                                                    RDADP.204
      call sbytes(NB(1), H, 0, NWSZ, 0, ii)                                      RDADP.205
                                                                                 RDADP.206
      IWDS = 6440 * NCSZ / NWSZ                                                  RDADP.207
                                                                                 RDADP.208
      end                                                                        RDADP.209
#endif                                                                           RDADP.210
