      SUBROUTINE SFMERG (NREP, NM, NS, GM, GS, GMZ, GMT, GST, GMD, GSD,          SFMERG.1
     *                   GMS, GMW)                                               SFMERG.2
                                                                                 SFMERG.3
C***********************************************************************         SFMERG.4
C  SFMERG       -  STORM FRONT MERGE UPPER AIR DATA                              SFMERG.5
C  PURPOSE      -  TO MERGE UPPER AIR DATA DEFINED ON MANDATORY AND SIGN         SFMERG.6
C                  FICANT PRESSURE LEVELS                                        SFMERG.7
C                                                                                SFMERG.8
C  ON ENTRY     -  NREP   -  THE NUMBER OF REPORTS                               SFMERG.9
C                  NM     -  A LIST OF THE NUMBER OF MANDATORY LEVELS GI         SFMERG.10
C                            FOR EACH REPORT                                     SFMERG.11
C                  NS     -  A LIST OF THE NUMBER OF SIGNIFICANT LEVELS          SFMERG.12
C                            FOR EACH REPORT                                     SFMERG.13
C                  GM     -  A LIST OF MANDATORY PRESSURE LEVELS FOR EAC         SFMERG.14
C                            REPORT                                              SFMERG.15
C                  GS     -  A LIST OF SIGNIFICANT PRESSURE LEVELS FOR E         SFMERG.16
C                            REPORT                                              SFMERG.17
C                  GMZ    -  STORES GEOPOTENTIAL HEIGHT ON MANDATORY LEV         SFMERG.18
C                  GMT    -  STORES TEMPERATURE ON MANDATORY LEVELS              SFMERG.19
C                  GST    -  STORES TEMPERATURE ON SIGNIFICANT LEVELS            SFMERG.20
C                  GMD    -  STORES DEWPOINT TEMPERATURE ON MANDATORY LE         SFMERG.21
C                  GSD    -  STORES DEWPOINT TEMPERATURE ON SIGNIFICANT          SFMERG.22
C                  GMS    -  STORES WIND SPEED ON MANDATORY LEVELS               SFMERG.23
C                  GMW    -  STORES WIND DIRECTION ON MANDATORY LEVELS           SFMERG.24
C                                                                                SFMERG.25
C  ON EXIT      -  THE GLOBALS LIST BELOW HAVE BEEN DEFINED                      SFMERG.26
C                                                                                SFMERG.27
C  GLOBALS      -  PU     -  LISTS OF PRESSURE LEVELS WHERE DATA IS DEFI         SFMERG.28
C                            FOR EACH REPORT                                     SFMERG.29
C                  ZU     -  GEOPOTENTIAL HEIGHT                                 SFMERG.30
C                  TU     -  TEMPERATURE                                         SFMERG.31
C                  TDU    -  DEWPOINT TEMPERATURE                                SFMERG.32
C                  SPDU   -  WIND SPEED                                          SFMERG.33
C                  DIRU   -  WIND DIRECTION                                      SFMERG.34
C                  SRC    -  IDENTIFIES WHICH PRESSURE ARRAY THE DATA CO         SFMERG.35
C                            FROM ORIGINALLY                                     SFMERG.36
C                  PNLV   -  GIVES THE NUMBER OF VERTICAL PRESSURE LEVEL         SFMERG.37
C                            EACH REPORT                                         SFMERG.38
C                                                                                SFMERG.39
C  SIDE EFFECTS -  NONE                                                          SFMERG.40
C                                                                                SFMERG.41
C  AUTHOR       -  JEREMY ASBILL                                                 SFMERG.42
C  DATE         -  SEPTEMBER 3, 1991                                             SFMERG.43
C  FOR          -  THE MM4 CLUB (& STORMFEST)                                    SFMERG.44
C***********************************************************************         SFMERG.45
                                                                                 SFMERG.46
C                                                                                SFMERG.47
C  INCLUDE FILES                                                                 SFMERG.48
C                                                                                SFMERG.49
      INTEGER  MAXREP,SIDMAX,NUMANT,NUMSIG,TROPLV,SIGNIF                         SFMERG.50
C                                                                                SFMERG.51
      PARAMETER (MAXREP = 700, SIDMAX = 12, NUMANT = 20, NUMSIG = 50)            SFMERG.52
      PARAMETER (MAXLEV = 70,  NMSIGW = 50,  MANSFC = 1)                         SFMERG.53
      PARAMETER (TROPLV = 5,  SIGNIF = 4,   MAXWIN = 6,  MANDAT = 3)             SFMERG.54
C                                                                                SFMERG.55
      INTEGER  SRC(MAXLEV,MAXREP),PNLV(MAXREP),SNLV(MAXREP),                     SFMERG.56
     1         IDRAOB(MAXREP)                                                    SFMERG.57
C                                                                                SFMERG.58
      REAL  LATU(MAXREP),LONU(MAXREP),ELVU(MAXREP)                               SFMERG.59
C                                                                                SFMERG.60
      DIMENSION  PU(MAXLEV,MAXREP),ZU(MAXLEV,MAXREP),TU(MAXLEV,MAXREP),          SFMERG.61
     1 TDU(MAXLEV,MAXREP),SPDU(MAXLEV,MAXREP),DIRU(MAXLEV,MAXREP),               SFMERG.62
     1 ZW(NUMSIG,MAXREP),DIRW(NUMSIG,MAXREP),SPDW(NUMSIG,MAXREP)                 SFMERG.63
C                                                                                SFMERG.64
#include <comuni.incl>                                                           SFMERG.65
C                                                                                SFMERG.66
      CHARACTER*(SIDMAX) STIDU(MAXREP)                                           SFMERG.67
C                                                                                SFMERG.68
C  PARAMETER LIST                                                                SFMERG.69
C                                                                                SFMERG.70
                                                                                 SFMERG.71
      INTEGER   NM(MAXREP), NS(MAXREP)                                           SFMERG.72
      REAL      GM(NUMANT, MAXREP), GS(NUMSIG, MAXREP),                          SFMERG.73
     *          GMZ(NUMANT, MAXREP),                                             SFMERG.74
     *          GMT(NUMANT, MAXREP), GST(NUMSIG, MAXREP),                        SFMERG.75
     *          GMD(NUMANT, MAXREP), GSD(NUMSIG, MAXREP),                        SFMERG.76
     *          GMS(NUMANT, MAXREP),                                             SFMERG.77
     *          GMW(NUMANT, MAXREP)                                              SFMERG.78
                                                                                 SFMERG.79
C                                                                                SFMERG.80
C  LOCAL VARIABLES                                                               SFMERG.81
C                                                                                SFMERG.82
C  F        -  PLACE KEEPER                                                      SFMERG.83
C  MAXW     -  THE PRESSURE WHERE THE MAXIMUM WINDS ARE ENCOUNTERED              SFMERG.84
C  R, S     -  LOOP COUNTERS/PLACE KEEPERS                                       SFMERG.85
C  TOP      -  BOUNDS THE LOOP ACROSS THE MANDATORY LEVELS                       SFMERG.86
C  TROP     -  THE PRESSURE VALUE AT THE TROPOPAUSE                              SFMERG.87
C                                                                                SFMERG.88
                                                                                 SFMERG.89
      INTEGER F, R, S, TOP                                                       SFMERG.90
      REAL    MAXW, TROP                                                         SFMERG.91
                                                                                 SFMERG.92
C****************************  SUBROUTINE BEGIN  ***********************         SFMERG.93
                                                                                 SFMERG.94
C                                                                                SFMERG.95
C  FIRST TAKE DATA AT THE SURFACE WHICH IS ALWAYS THE FIRST MANDATORY LE         SFMERG.96
C  DO THIS FOR EACH REPORT                                                       SFMERG.97
C                                                                                SFMERG.98
                                                                                 SFMERG.99
      DO 10 R = 1, NREP                                                          SFMERG.100
         PU(1, R)   = GM(1, R)                                                   SFMERG.101
         ZU(1, R)   = GMZ(1, R)                                                  SFMERG.102
         TU(1, R)   = GMT(1, R)                                                  SFMERG.103
         TDU(1, R)  = GMD(1, R)                                                  SFMERG.104
         SPDU(1, R) = GMS(1, R)                                                  SFMERG.105
         DIRU(1, R) = GMW(1, R)                                                  SFMERG.106
         SRC(1, R)  = MANSFC                                                     SFMERG.107
                                                                                 SFMERG.108
C                                                                                SFMERG.109
C  FOR EACH REPORT CYCLE THROUGH THE MANDATORY LEVELS, IGNORING MISSING          SFMERG.110
C  AND INSERTING SIGNIFICANT LEVELS, THE TROP LEVEL, AND THE MAX WIND LE         SFMERG.111
C  WHEN APPROPRIATE                                                              SFMERG.112
C                                                                                SFMERG.113
                                                                                 SFMERG.114
         TROP             = -9999.0                                              SFMERG.115
         MAXW             = -9999.0                                              SFMERG.116
         GS(NS(R) + 1, R) = -9999.0                                              SFMERG.117
         TOP  = NM(R)                                                            SFMERG.118
         IF (NM(R) .GE. 16) TOP  = 16                                            SFMERG.119
         IF (NM(R) .GE. 17) TROP = GM(17, R)                                     SFMERG.120
         IF (NM(R) .GE. 18) MAXW = GM(18, R)                                     SFMERG.121
                                                                                 SFMERG.122
         IF (GS(1, R) .EQ. PU(1, R)) THEN                                        SFMERG.123
            S = 2                                                                SFMERG.124
         ELSE                                                                    SFMERG.125
            S = 1                                                                SFMERG.126
         END IF                                                                  SFMERG.127
                                                                                 SFMERG.128
         F = 1                                                                   SFMERG.129
         M = 2                                                                   SFMERG.130
20       CONTINUE                                                                SFMERG.131
         IF (M .LE. TOP) THEN                                                    SFMERG.132
                                                                                 SFMERG.133
C                                                                                SFMERG.134
C  IF THE MANDATORY LEVEL IS -9999.0, THEN THERE IS NO LEVEL HERE                SFMERG.135
C                                                                                SFMERG.136
                                                                                 SFMERG.137
            IF (NINT(GM(M, R)) .NE. -9999) THEN                                  SFMERG.138
                                                                                 SFMERG.139
C                                                                                SFMERG.140
C  THE MANDATORY LEVEL SHOULD BE USED WHEN IT IS LARGER OR THE SAME SIZE         SFMERG.141
C  THE CURRENT SIGNIFICANT LEVEL, THE TROPOPAUSE LEVEL, OR THE MAXIMUN W         SFMERG.142
C  LEVEL                                                                         SFMERG.143
C                                                                                SFMERG.144
                                                                                 SFMERG.145
               IF ((GM(M, R) .GE. GS(S, R)) .AND.                                SFMERG.146
     *             (GM(M, R) .GE. TROP)     .AND.                                SFMERG.147
     *             (GM(M, R) .GE. MAXW)) THEN                                    SFMERG.148
                  F = F + 1                                                      SFMERG.149
                  PU(F, R)   = GM(M, R)                                          SFMERG.150
                  ZU(F, R)   = GMZ(M, R)                                         SFMERG.151
                  TU(F, R)   = GMT(M, R)                                         SFMERG.152
                  TDU(F, R)  = GMD(M, R)                                         SFMERG.153
                  SPDU(F, R) = GMS(M, R)                                         SFMERG.154
                  DIRU(F, R) = GMW(M, R)                                         SFMERG.155
                  SRC(F, R)  = MANDAT                                            SFMERG.156
               END IF                                                            SFMERG.157
                                                                                 SFMERG.158
C                                                                                SFMERG.159
C  IF THE SIGNIFICANT LEVEL WAS LARGEST USE IT                                   SFMERG.160
C                                                                                SFMERG.161
                                                                                 SFMERG.162
               IF ((GS(S, R) .GT. GM(M, R)) .AND.                                SFMERG.163
     *             (GS(S, R) .GE. TROP)     .AND.                                SFMERG.164
     *             (GS(S, R) .GE. MAXW)) THEN                                    SFMERG.165
                  F = F + 1                                                      SFMERG.166
                  PU(F, R)   = GS(S, R)                                          SFMERG.167
                  ZU(F, R)   = -9999.0                                           SFMERG.168
                  TU(F, R)   = GST(S, R)                                         SFMERG.169
                  TDU(F, R)  = GSD(S, R)                                         SFMERG.170
                  SPDU(F, R) = -9999.0                                           SFMERG.171
                  DIRU(F, R) = -9999.0                                           SFMERG.172
                  SRC(F, R)  = SIGNIF                                            SFMERG.173
               END IF                                                            SFMERG.174
                                                                                 SFMERG.175
C                                                                                SFMERG.176
C  IF THE TROPOPAUSE WAS THE LARGEST USE IT                                      SFMERG.177
C                                                                                SFMERG.178
                                                                                 SFMERG.179
               IF ((TROP .GT. GM(M, R)) .AND.                                    SFMERG.180
     *             (TROP .GT. GS(S, R))    .AND.                                 SFMERG.181
     *             (TROP .GE. MAXW)) THEN                                        SFMERG.182
                  F = F + 1                                                      SFMERG.183
                  PU(F, R)   = GM(17, R)                                         SFMERG.184
                  ZU(F, R)   = GMZ(17, R)                                        SFMERG.185
                  TU(F, R)   = GMT(17, R)                                        SFMERG.186
                  TDU(F, R)  = GMD(17, R)                                        SFMERG.187
                  SPDU(F, R) = GMS(17, R)                                        SFMERG.188
                  DIRU(F, R) = GMW(17, R)                                        SFMERG.189
                  SRC(F, R)  = TROPLV                                            SFMERG.190
               END IF                                                            SFMERG.191
                                                                                 SFMERG.192
C                                                                                SFMERG.193
C  IF THE MAX WIND LEVEL WAS THE LARGEST USE IT                                  SFMERG.194
C                                                                                SFMERG.195
                                                                                 SFMERG.196
               IF ((MAXW .GT. GM(M, R)) .AND.                                    SFMERG.197
     *             (MAXW .GT. GS(S, R))    .AND.                                 SFMERG.198
     *             (MAXW .GT. TROP)) THEN                                        SFMERG.199
                  F = F + 1                                                      SFMERG.200
                  PU(F, R)   = GM(18, R)                                         SFMERG.201
                  ZU(F, R)   = GMZ(18, R)                                        SFMERG.202
                  TU(F, R)   = GMT(18, R)                                        SFMERG.203
                  TDU(F, R)  = GMD(18, R)                                        SFMERG.204
                  SPDU(F, R) = GMS(18, R)                                        SFMERG.205
                  DIRU(F, R) = GMW(18, R)                                        SFMERG.206
                  SRC(F, R)  = MAXWIN                                            SFMERG.207
               END IF                                                            SFMERG.208
                                                                                 SFMERG.209
C                                                                                SFMERG.210
C  IF THE SELECTED LEVEL WAS EQUAL TO THE SIGNIFICANT LEVEL, SKIP THAT           SFMERG.211
C  SIGNIFICANT LEVEL                                                             SFMERG.212
C                                                                                SFMERG.213
                                                                                 SFMERG.214
               IF (PU(F, R) .EQ. GS(S, R)) S = S + 1                             SFMERG.215
               IF (PU(F, R) .EQ. GM(M, R)) M = M + 1                             SFMERG.216
                                                                                 SFMERG.217
C                                                                                SFMERG.218
C  IF THE TROPOPAUSE WAS EQUAL TO THE SELECTED LEVEL, WE WILL NOT USE IT         SFMERG.219
C                                                                                SFMERG.220
                                                                                 SFMERG.221
               IF (TROP .EQ. PU(F, R)) TROP = -9999.0                            SFMERG.222
                                                                                 SFMERG.223
C                                                                                SFMERG.224
C  IF THE MAX WIND LEVEL WAS EQUAL TO THE SELECTED LEVEL WE WILL NOT USE         SFMERG.225
C                                                                                SFMERG.226
                                                                                 SFMERG.227
               IF (MAXW .EQ. PU(F, R)) MAXW = -9999.0                            SFMERG.228
            ELSE                                                                 SFMERG.229
               M = M + 1                                                         SFMERG.230
            END IF                                                               SFMERG.231
            GOTO 20                                                              SFMERG.232
         END IF                                                                  SFMERG.233
                                                                                 SFMERG.234
C                                                                                SFMERG.235
C  SAVE THE NUMBER OF VERTICAL LEVELS FOR EACH REPORT                            SFMERG.236
C                                                                                SFMERG.237
                                                                                 SFMERG.238
         PNLV(R) = F                                                             SFMERG.239
10    CONTINUE                                                                   SFMERG.240
                                                                                 SFMERG.241
C*****************************  SUBROUTINE END  ************************         SFMERG.242
                                                                                 SFMERG.243
      RETURN                                                                     SFMERG.244
      END                                                                        SFMERG.245
