      SUBROUTINE SFUAOB (NREP,UFNAM)                                             SFUAOB.1
#if defined (NONETCDF)
      character*10 UFNAM                                                         SFUAOB.3
      nrep=0                                                                     SFUAOB.4
#else                                                                            SFUAOB.5
                                                                                 SFUAOB.6
C***********************************************************************         SFUAOB.7
C  SFSCVT       -  STORM FRONT UPPER AIR OBSERVATIONS READER                     SFUAOB.8
C  PURPOSE      -  GIVEN A STATION ID THIS ROUTINE RETURNS (IN COMMON BL         SFUAOB.9
C                  ALL NECESSARY INFORMATION FOR THAT STATION                    SFUAOB.10
C                                                                                SFUAOB.11
C  ON ENTRY     -  THE UPPER AIR OBSERVATION FILE EXISTS IN THE CURRENT          SFUAOB.12
C                  ING DIRECTORY AND IS NAMED "DATA.UAO"                         SFUAOB.13
C                                                                                SFUAOB.14
C  ON EXIT      -  NREP   -  THE NUMBER OF REPORTING STATIONS                    SFUAOB.15
C                                                                                SFUAOB.16
C  GLOBALS      -  STIDU  -  A LIST OF STATION IDS GIVEN FOR THE DATA            SFUAOB.17
C                  LATU   -  THE LATITUDE AT EACH STATION IN "STIDU"             SFUAOB.18
C                  LONU   -  THE LONGITUDE AT EACH STATION IN "STIDU"            SFUAOB.19
C                  ELVU   -  THE ELEVATION AT EACH STATION IN "STIDU"            SFUAOB.20
C                                                                                SFUAOB.21
C  SIDE EFFECTS -  OPENS AND CLOSES THE UPPER AIR OBSERVATION DATA FILE          SFUAOB.22
C                                                                                SFUAOB.23
C  AUTHOR       -  JEREMY ASBILL                                                 SFUAOB.24
C  DATE         -  SEPTEMBER 2, 1991                                             SFUAOB.25
C  FOR          -  THE MM4 CLUB (& STORMFEST)                                    SFUAOB.26
C***********************************************************************         SFUAOB.27
                                                                                 SFUAOB.28
C                                                                                SFUAOB.29
C  INCLUDE FILES                                                                 SFUAOB.30
C                                                                                SFUAOB.31
                                                                                 SFUAOB.32
#include <netcdf.incl>                                                           SFUAOB.33
C                                                                                SFUAOB.34
      INTEGER  MAXREP,SIDMAX,NUMANT,NUMSIG,TROPLV,SIGNIF                         SFUAOB.35
C                                                                                SFUAOB.36
      PARAMETER (MAXREP = 700, SIDMAX = 12, NUMANT = 20, NUMSIG = 50)            SFUAOB.37
      PARAMETER (MAXLEV = 70,  NMSIGW = 50,  MANSFC = 1)                         SFUAOB.38
      PARAMETER (TROPLV = 5,  SIGNIF = 4,   MAXWIN = 6,  MANDAT = 3)             SFUAOB.39
C                                                                                SFUAOB.40
      INTEGER  SRC(MAXLEV,MAXREP),PNLV(MAXREP),SNLV(MAXREP),                     SFUAOB.41
     1         IDRAOB(MAXREP)                                                    SFUAOB.42
C                                                                                SFUAOB.43
      REAL  LATU(MAXREP),LONU(MAXREP),ELVU(MAXREP)                               SFUAOB.44
C                                                                                SFUAOB.45
      DIMENSION  PU(MAXLEV,MAXREP),ZU(MAXLEV,MAXREP),TU(MAXLEV,MAXREP),          SFUAOB.46
     1 TDU(MAXLEV,MAXREP),SPDU(MAXLEV,MAXREP),DIRU(MAXLEV,MAXREP),               SFUAOB.47
     1 ZW(NUMSIG,MAXREP),DIRW(NUMSIG,MAXREP),SPDW(NUMSIG,MAXREP)                 SFUAOB.48
C                                                                                SFUAOB.49
#include <comuni.incl>                                                           SFUAOB.50
#include <comrbt.incl>                                                           SFUAOB.51
C                                                                                SFUAOB.52
      CHARACTER*(SIDMAX) STIDU(MAXREP)                                           SFUAOB.53
C                                                                                SFUAOB.54
C  PARAMETER LIST                                                                SFUAOB.55
C                                                                                SFUAOB.56
                                                                                 SFUAOB.57
      INTEGER NREP                                                               SFUAOB.58
                                                                                 SFUAOB.59
C                                                                                SFUAOB.60
C  LOCAL VARIABLES                                                               SFUAOB.61
C                                                                                SFUAOB.62
C  COUNT    -  INDICATES TO NCVGT AND NCVGTC HOW MANY ELEMENTS TO READ           SFUAOB.63
C  ERROR    -  USED TO INTERFACE WITH THE NETCDF ROUTINES                        SFUAOB.64
C  GM       -  CONTAINS A LIST OF DEFINED MANDATORY LEVELS PER REPORT            SFUAOB.65
C  GMDIR    -  STORES WIND DIRECTION ON MANDATORY LEVELS                         SFUAOB.66
C  GMGHT    -  STORES GEOPOTENTIAL HEIGHT ON MANDATORY LEVELS                    SFUAOB.67
C  GMSPD    -  STORES WIND SPEED ON MANDATORY LEVELS                             SFUAOB.68
C  GMT      -  STORES TEMPERATURE ON MANDATORY LEVELS                            SFUAOB.69
C  GMTD     -  STORES DEWPOINT TEMPERATURE ON MANDATORY LEVELS                   SFUAOB.70
C  GS       -  CONTAINS A LIST OF DEFINED SIGNIFICANT LEVELS PER REPORT          SFUAOB.71
C  GSDIR    -  STORES WIND DIRECTION ON SIGNIFICANT LEVELS                       SFUAOB.72
C  GSGHT    -  STORES GEOPOTENTIAL HEIGHT ON SIGNIFICANT LEVELS                  SFUAOB.73
C  GSSPD    -  STORES WIND SPEED ON SIGNIFICANT LEVELS                           SFUAOB.74
C  GST      -  STORES TEMPERATURE ON SIGNIFICANT LEVELS                          SFUAOB.75
C  GSTD     -  STORES DEWPOINT TEMPERATURE ON SIGNIFICANT LEVELS                 SFUAOB.76
C  I,J      -  LOOP COUNTERS/PLACE KEEPERS                                       SFUAOB.77
C  NM       -  A LIST INDICATING THE NUMBER OF MANDATORY LEVELS PER REPO         SFUAOB.78
C  NS       -  A LIST INDICATING THE NUMBER OF SIGNIFICANT LEVELS PER RE         SFUAOB.79
C  START    -  INDICATES TO NCVGT AND NCVGTC WHERE TO START READING              SFUAOB.80
C  STLIS    -  A LIST OF STATIONS IDS AS ONE LONG STRING                         SFUAOB.81
C  STRNG    -  USED TO INTERFACE WITH THE NETCDF ROUTINE NCDINQ                  SFUAOB.82
C  TMPID    -  USED AS A NETCDF ID FOR VARIABLES AND DIMENSIONS                  SFUAOB.83
C  UAOID    -  THE NETCDF ID FOR THE DATA FILE                                   SFUAOB.84
                                                                                 SFUAOB.85
      CHARACTER*(MAXREP * SIDMAX) STLIS                                          SFUAOB.86
      CHARACTER*80                STRNG                                          SFUAOB.87
      CHARACTER*80                CTIME                                          SFUAOB.88
      CHARACTER*10 UFNAM                                                         SFUAOB.89
      INTEGER                     COUNT(2), START(2), ERROR, I, J,               SFUAOB.90
     *                            NM(MAXREP), NS(MAXREP), TMPID, UAOID           SFUAOB.91
      INTEGER                     TIMERB                                         SFUAOB.92
      REAL                        GM(NUMANT, MAXREP),                            SFUAOB.93
     *                            GMDIR(NUMANT, MAXREP),                         SFUAOB.94
     *                            GMGHT(NUMANT, MAXREP),                         SFUAOB.95
     *                            GMSPD(NUMANT, MAXREP),                         SFUAOB.96
     *                            GMT(NUMANT, MAXREP),                           SFUAOB.97
     *                            GMTD(NUMANT, MAXREP)                           SFUAOB.98
      REAL                        GS(NUMSIG, MAXREP),                            SFUAOB.99
     *                            GSDIR(NUMSIG, MAXREP),                         SFUAOB.100
     *                            GSGHT(NUMSIG, MAXREP),                         SFUAOB.101
     *                            GSSPD(NUMSIG, MAXREP),                         SFUAOB.102
     *                            GST(NUMSIG, MAXREP),                           SFUAOB.103
     *                            GSTD(NUMSIG, MAXREP)                           SFUAOB.104
                                                                                 SFUAOB.105
C****************************  SUBROUTINE BEGIN  ***********************         SFUAOB.106
                                                                                 SFUAOB.107
C                                                                                SFUAOB.108
C  OPEN THE UPPER AIR OBSERVATIONS DATA FILE                                     SFUAOB.109
C                                                                                SFUAOB.110
                                                                                 SFUAOB.111
      PRINT854, UFNAM                                                            SFUAOB.112
 854  FORMAT ('NCOPN-ING ', A10)                                                 SFUAOB.113
      UAOID = NCOPN (UFNAM, NCNOWRIT, ERROR)                                     SFUAOB.114
                                                                                 SFUAOB.115
                                                                                 SFUAOB.116
C                                                                                SFUAOB.117
C  GET THE NUMBER OF REPORTS FROM THE NETCDF FILE                                SFUAOB.118
C                                                                                SFUAOB.119
                                                                                 SFUAOB.120
      TMPID = NCDID (UAOID, 'report', ERROR)                                     SFUAOB.121
      CALL NCDINQ (UAOID, TMPID, STRNG, COUNT(2), ERROR)                         SFUAOB.122
      NREP  = COUNT(2)                                                           SFUAOB.123
                                                                                 SFUAOB.124
C                                                                                SFUAOB.125
C  READ IN THE TIME GIVEN FOR THE REPORT                                         SFUAOB.126
C                                                                                SFUAOB.127
                                                                                 SFUAOB.128
C         CALL NCAGT (UAOID, NCGLOBAL, 'yymmddhh', CTIME, ERROR)                 SFUAOB.129
         CALL NCAGTC (UAOID, NCGLOBAL, 'yymmddhh', CTIME, 80, ERROR)             SFUAOB.130
         READ(CTIME,'(I8)') TIMERB                                               SFUAOB.131
C                                                                                SFUAOB.132
C  DETEMINE THE LENGTH OF THE STATION IDS                                        SFUAOB.133
C                                                                                SFUAOB.134
                                                                                 SFUAOB.135
      TMPID = NCDID (UAOID, 'string_len', ERROR)                                 SFUAOB.136
      CALL NCDINQ (UAOID, TMPID, STRNG, COUNT(1), ERROR)                         SFUAOB.137
                                                                                 SFUAOB.138
C                                                                                SFUAOB.139
C  GET THE LIST OF REPORTING STATIONS                                            SFUAOB.140
C                                                                                SFUAOB.141
                                                                                 SFUAOB.142
      TMPID = NCVID (UAOID, 'id', ERROR)                                         SFUAOB.143
      START(1) = 1                                                               SFUAOB.144
      START(2) = 1                                                               SFUAOB.145
      CALL NCVGTC (UAOID, TMPID, START, COUNT, STLIS, SIDMAX * MAXREP,           SFUAOB.146
     *             ERROR)                                                        SFUAOB.147
                                                                                 SFUAOB.148
C                                                                                SFUAOB.149
C  CONVERT THE LIST OF REPORTING STATIONS TO EASIER USED STRINGS                 SFUAOB.150
C                                                                                SFUAOB.151
                                                                                 SFUAOB.152
      DO 10 I = 1, NREP                                                          SFUAOB.153
         J = (I - 1) * COUNT(1) + 1                                              SFUAOB.154
         STIDU(I)(1:COUNT(1)) = STLIS(J:J + COUNT(1))                            SFUAOB.155
10    CONTINUE                                                                   SFUAOB.156
      TMPID=NCVID(UAOID,'idn',ERROR)                                             SFUAOB.157
      CALL NCVGT(UAOID,TMPID,1,NREP,IDRAOB,ERROR)                                SFUAOB.158
                                                                                 SFUAOB.159
C                                                                                SFUAOB.160
C  READ IN THE STATION INFORMATION, INCLUDING:                                   SFUAOB.161
C  LATITUDE                                                                      SFUAOB.162
C                                                                                SFUAOB.163
                                                                                 SFUAOB.164
      TMPID = NCVID (UAOID, 'lat', ERROR)                                        SFUAOB.165
      CALL NCVGT (UAOID, TMPID, 1, NREP, LATU, ERROR)                            SFUAOB.166
                                                                                 SFUAOB.167
C                                                                                SFUAOB.168
C  LONGITUDE                                                                     SFUAOB.169
C                                                                                SFUAOB.170
                                                                                 SFUAOB.171
      TMPID = NCVID (UAOID, 'lon', ERROR)                                        SFUAOB.172
      CALL NCVGT (UAOID, TMPID, 1, NREP, LONU, ERROR)                            SFUAOB.173
                                                                                 SFUAOB.174
C                                                                                SFUAOB.175
C  ELEVATION                                                                     SFUAOB.176
C                                                                                SFUAOB.177
                                                                                 SFUAOB.178
      TMPID = NCVID (UAOID, 'Z_man', ERROR)                                      SFUAOB.179
      START(1) = 1                                                               SFUAOB.180
      START(2) = 1                                                               SFUAOB.181
      COUNT(1) = 1                                                               SFUAOB.182
      COUNT(2) = NREP                                                            SFUAOB.183
      CALL NCVGT (UAOID, TMPID, START, COUNT, ELVU, ERROR)                       SFUAOB.184
                                                                                 SFUAOB.185
C                                                                                SFUAOB.186
C  GET THE NUMBER MANDATORY LEVELS FOR EACH REPORT; THIS IS TYPICALLY 20         SFUAOB.187
C  HOWEVER, USUALLY NOT ALL OF THE SLOTS ARE USED (SLOT 17 HAS TROP; SLO         SFUAOB.188
C  MAX WINDS)                                                                    SFUAOB.189
C                                                                                SFUAOB.190
                                                                                 SFUAOB.191
      TMPID = NCVID (UAOID, 'num_mant', ERROR)                                   SFUAOB.192
      CALL NCVGT (UAOID, TMPID, 1, NREP, NM, ERROR)                              SFUAOB.193
                                                                                 SFUAOB.194
C                                                                                SFUAOB.195
C  GET THE NUMBER OF SIGNIFICAT LEVELS WITH RESPECT TO TEMPERATURE FOR           SFUAOB.196
C  EACH REPORT                                                                   SFUAOB.197
C                                                                                SFUAOB.198
                                                                                 SFUAOB.199
      TMPID = NCVID (UAOID, 'num_sigt', ERROR)                                   SFUAOB.200
      CALL NCVGT (UAOID, TMPID, 1, NREP, NS, ERROR)                              SFUAOB.201
                                                                                 SFUAOB.202
C                                                                                SFUAOB.203
C  READ IN THE MANDATORY LEVELS                                                  SFUAOB.204
C                                                                                SFUAOB.205
                                                                                 SFUAOB.206
      TMPID = NCVID (UAOID, 'P_man', ERROR)                                      SFUAOB.207
      START(1) = 1                                                               SFUAOB.208
      START(2) = 1                                                               SFUAOB.209
      COUNT(1) = NUMANT                                                          SFUAOB.210
      COUNT(2) = NREP                                                            SFUAOB.211
      CALL NCVGT (UAOID, TMPID, START, COUNT, GM, ERROR)                         SFUAOB.212
                                                                                 SFUAOB.213
C                                                                                SFUAOB.214
C  READ IN THE SIGNIFICAT LEVELS                                                 SFUAOB.215
C                                                                                SFUAOB.216
                                                                                 SFUAOB.217
      TMPID = NCVID (UAOID, 'P_sigt', ERROR)                                     SFUAOB.218
      START(1) = 1                                                               SFUAOB.219
      START(2) = 1                                                               SFUAOB.220
      COUNT(1) = NUMSIG                                                          SFUAOB.221
      COUNT(2) = NREP                                                            SFUAOB.222
      CALL NCVGT (UAOID, TMPID, START, COUNT, GS, ERROR)                         SFUAOB.223
                                                                                 SFUAOB.224
C                                                                                SFUAOB.225
C  READ IN GEOPETENTIAL HEIGHT ON MANDATORY LEVELS                               SFUAOB.226
C                                                                                SFUAOB.227
                                                                                 SFUAOB.228
      TMPID = NCVID (UAOID, 'Z_man', ERROR)                                      SFUAOB.229
      START(1) = 1                                                               SFUAOB.230
      START(2) = 1                                                               SFUAOB.231
      COUNT(1) = NUMANT                                                          SFUAOB.232
      COUNT(2) = NREP                                                            SFUAOB.233
      CALL NCVGT (UAOID, TMPID, START, COUNT, GMGHT, ERROR)                      SFUAOB.234
                                                                                 SFUAOB.235
C                                                                                SFUAOB.236
C  READ IN TEMPERATURE ON MANDATORY LEVELS                                       SFUAOB.237
C                                                                                SFUAOB.238
                                                                                 SFUAOB.239
      TMPID = NCVID (UAOID, 'T_man', ERROR)                                      SFUAOB.240
      START(1) = 1                                                               SFUAOB.241
      START(2) = 1                                                               SFUAOB.242
      COUNT(1) = NUMANT                                                          SFUAOB.243
      COUNT(2) = NREP                                                            SFUAOB.244
      CALL NCVGT (UAOID, TMPID, START, COUNT, GMT, ERROR)                        SFUAOB.245
                                                                                 SFUAOB.246
C                                                                                SFUAOB.247
C  READ IN TEMPERATURE ON SIGNIFICANT LEVELS WITH RESPECT TO TEMPERATURE         SFUAOB.248
C                                                                                SFUAOB.249
                                                                                 SFUAOB.250
                                                                                 SFUAOB.251
      TMPID = NCVID (UAOID, 'T_sigt', ERROR)                                     SFUAOB.252
      START(1) = 1                                                               SFUAOB.253
      START(2) = 1                                                               SFUAOB.254
      COUNT(1) = NUMSIG                                                          SFUAOB.255
      COUNT(2) = NREP                                                            SFUAOB.256
      CALL NCVGT (UAOID, TMPID, START, COUNT, GST, ERROR)                        SFUAOB.257
                                                                                 SFUAOB.258
C                                                                                SFUAOB.259
C  READ IN DEWPOINT TEMPERATURE ON MANDATORY LEVELS                              SFUAOB.260
C                                                                                SFUAOB.261
                                                                                 SFUAOB.262
      TMPID = NCVID (UAOID, 'TD_man', ERROR)                                     SFUAOB.263
      START(1) = 1                                                               SFUAOB.264
      START(2) = 1                                                               SFUAOB.265
      COUNT(1) = NUMANT                                                          SFUAOB.266
      COUNT(2) = NREP                                                            SFUAOB.267
      CALL NCVGT (UAOID, TMPID, START, COUNT, GMTD, ERROR)                       SFUAOB.268
                                                                                 SFUAOB.269
C                                                                                SFUAOB.270
C  READ IN DEWPOINT TEMPERATURE ON SIGNIFICANT LEVELS WITH RESPECT               SFUAOB.271
C  TO TEMPERATURE                                                                SFUAOB.272
C                                                                                SFUAOB.273
                                                                                 SFUAOB.274
      TMPID = NCVID (UAOID, 'TD_sigt', ERROR)                                    SFUAOB.275
      START(1) = 1                                                               SFUAOB.276
      START(2) = 1                                                               SFUAOB.277
      COUNT(1) = NUMSIG                                                          SFUAOB.278
      COUNT(2) = NREP                                                            SFUAOB.279
      CALL NCVGT (UAOID, TMPID, START, COUNT, GSTD, ERROR)                       SFUAOB.280
                                                                                 SFUAOB.281
C                                                                                SFUAOB.282
C  READ IN WIND SPEED ON MANDATORY LEVELS                                        SFUAOB.283
C                                                                                SFUAOB.284
                                                                                 SFUAOB.285
      TMPID = NCVID (UAOID, 'SPD_man', ERROR)                                    SFUAOB.286
      START(1) = 1                                                               SFUAOB.287
      START(2) = 1                                                               SFUAOB.288
      COUNT(1) = NUMANT                                                          SFUAOB.289
      COUNT(2) = NREP                                                            SFUAOB.290
      CALL NCVGT (UAOID, TMPID, START, COUNT, GMSPD, ERROR)                      SFUAOB.291
                                                                                 SFUAOB.292
C                                                                                SFUAOB.293
C  READ IN WIND DIRECTION ON MANDATORY LEVELS                                    SFUAOB.294
C                                                                                SFUAOB.295
                                                                                 SFUAOB.296
      TMPID = NCVID (UAOID, 'DIR_man', ERROR)                                    SFUAOB.297
      START(1) = 1                                                               SFUAOB.298
      START(2) = 1                                                               SFUAOB.299
      COUNT(1) = NUMANT                                                          SFUAOB.300
      COUNT(2) = NREP                                                            SFUAOB.301
      CALL NCVGT (UAOID, TMPID, START, COUNT, GMDIR, ERROR)                      SFUAOB.302
                                                                                 SFUAOB.303
C                                                                                SFUAOB.304
C  MERGE THE DATA TOGETHER, INDEXED BY ONE BIG LIST OF PRESSURES                 SFUAOB.305
C  FOR EACH REPORT                                                               SFUAOB.306
C                                                                                SFUAOB.307
                                                                                 SFUAOB.308
      CALL SFMERG (NREP, NM, NS, GM, GS, GMGHT, GMT, GST, GMTD, GSTD,            SFUAOB.309
     *             GMSPD, GMDIR)                                                 SFUAOB.310
                                                                                 SFUAOB.311
C                                                                                SFUAOB.312
C  GET THE NUMBER OF SIGNIFICAT LEVELS WITH RESPECT TO THE WINDS FOR             SFUAOB.313
C  EACH REPORT                                                                   SFUAOB.314
C                                                                                SFUAOB.315
                                                                                 SFUAOB.316
      TMPID = NCVID (UAOID, 'num_sigw', ERROR)                                   SFUAOB.317
      CALL NCVGT (UAOID, TMPID, 1, NREP, NS, ERROR)                              SFUAOB.318
                                                                                 SFUAOB.319
C                                                                                SFUAOB.320
C  GEOPOTENTIAL HEIGHT ON SIGNIFICANT LEVELS WITH RESPECT TO WINDS               SFUAOB.321
C                                                                                SFUAOB.322
                                                                                 SFUAOB.323
      TMPID = NCVID (UAOID, 'Z_sigw', ERROR)                                     SFUAOB.324
      START(1) = 1                                                               SFUAOB.325
      START(2) = 1                                                               SFUAOB.326
      COUNT(1) = NMSIGW                                                          SFUAOB.327
      COUNT(2) = NREP                                                            SFUAOB.328
      CALL NCVGT (UAOID, TMPID, START, COUNT, GSGHT, ERROR)                      SFUAOB.329
                                                                                 SFUAOB.330
C                                                                                SFUAOB.331
C  WIND DIRECTION ON SIGNIFICAT LEVELS WITH RESPECT TO WINDS                     SFUAOB.332
C                                                                                SFUAOB.333
                                                                                 SFUAOB.334
      TMPID = NCVID (UAOID, 'DIR_sigw', ERROR)                                   SFUAOB.335
      START(1) = 1                                                               SFUAOB.336
      START(2) = 1                                                               SFUAOB.337
      COUNT(1) = NMSIGW                                                          SFUAOB.338
      COUNT(2) = NREP                                                            SFUAOB.339
      CALL NCVGT (UAOID, TMPID, START, COUNT, GSDIR, ERROR)                      SFUAOB.340
                                                                                 SFUAOB.341
C                                                                                SFUAOB.342
C  READ IN WIND SPEED ON SIGNIFICAT LEVELS WITH RESPECT TO WINDS                 SFUAOB.343
C                                                                                SFUAOB.344
                                                                                 SFUAOB.345
      TMPID = NCVID (UAOID, 'SPD_sigw', ERROR)                                   SFUAOB.346
      START(1) = 1                                                               SFUAOB.347
      START(2) = 1                                                               SFUAOB.348
      COUNT(1) = NMSIGW                                                          SFUAOB.349
      COUNT(2) = NREP                                                            SFUAOB.350
      CALL NCVGT (UAOID, TMPID, START, COUNT, GSSPD, ERROR)                      SFUAOB.351
                                                                                 SFUAOB.352
C                                                                                SFUAOB.353
C  CLEAN UP THE WIND-SIGNIFICANT LEVELS                                          SFUAOB.354
C                                                                                SFUAOB.355
                                                                                 SFUAOB.356
      CALL SFCLUP (NREP, NS, GSGHT, GSDIR, GSSPD)                                SFUAOB.357
                                                                                 SFUAOB.358
C                                                                                SFUAOB.359
C  CLOSE THE DATA FILE                                                           SFUAOB.360
C                                                                                SFUAOB.361
                                                                                 SFUAOB.362
      CALL NCCLOS (UAOID, ERROR)                                                 SFUAOB.363
                                                                                 SFUAOB.364
C*****************************  SUBROUTINE END  ************************         SFUAOB.365
                                                                                 SFUAOB.366
      RETURN                                                                     SFUAOB.367
#endif                                                                           SFUAOB.368
      END                                                                        SFUAOB.369
