      subroutine clproc (xcs,ycs,ncs,aid,gid,nid)                                PLOTS.1
                                                                                 PLOTS.2
#ifdef NCARG                                                                     PLOTS.3
C*****************************************************************************C  PLOTS.4
C  clproc   - This is a MAPDRV routine                                        C  PLOTS.5
C  Section  - Fill                                                            C  PLOTS.6
C  Purpose  - This is the routine that does the color fill on countries,      C  PLOTS.7
C             states and continents.                                          C  PLOTS.8
C                                                                             C  PLOTS.9
C  On entry - XCS and YCS contain NCS  pairs which are x, y  coordinate pairs C  PLOTS.10
C             that describe a polygon to be filled.   AID  is an array of NID C  PLOTS.11
C             area identifiers for the polygon.  GID is an array of NID group C  PLOTS.12
C             identifiers for  the  polygon.   Color information for all non- C  PLOTS.13
C             water colors is passed in through the common block  FLINFO  and C  PLOTS.14
C             WACOLR, water color is passed in through common block FLWATR.   C  PLOTS.15
C                                                                             C  PLOTS.16
C  On exit  - The map in has been colored.                                    C  PLOTS.17
C                                                                             C  PLOTS.18
C  Assume   - GKS is open.  This routine is called by the AREAS utility.      C  PLOTS.19
C                                                                             C  PLOTS.20
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.21
C             ----------------------------------------------------------------C  PLOTS.22
C             SFSGFA              SOFTFILL utility*                           C  PLOTS.23
C             ----------------------------------------------------------------C  PLOTS.24
C             * NCAR Graphics routine                                         C  PLOTS.25
C                                                                             C  PLOTS.26
C             This routine is not called by the MAPDRV utility, rather it  is C  PLOTS.27
C             called by the AREAS utility.                                    C  PLOTS.28
C                                                                             C  PLOTS.29
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.30
C*****************************************************************************C  PLOTS.31
                                                                                 PLOTS.32
C  Integer variables                                                             PLOTS.33
                                                                                 PLOTS.34
      integer          aid(*),           ! area identifiers                (in)  PLOTS.35
     *                 gid(*),           ! group identifiers               (in)  PLOTS.36
     *                 nid,              ! dimension of AID,GID            (in)  PLOTS.37
     *                 ncs               ! dimension of XCS,YCS            (in)  PLOTS.38
      integer          fscolr,           ! for common block FLINFO               PLOTS.39
     *                 secolr,           ! for common block FLINFO               PLOTS.40
     *                 thcolr,           ! for common block FLINFO               PLOTS.41
     *                 frcolr,           ! for common block FLINFO               PLOTS.42
     *                 fvcolr,           ! for common block FLINFO               PLOTS.43
     *                 sicolr            ! for common block FLINFO               PLOTS.44
      integer          wacolr            ! for common block FLWATR               PLOTS.45
      integer          ind(200),         ! scratch array for SOFTFILL   (local)  PLOTS.46
     *                 index,            ! color index to use           (local)  PLOTS.47
     *                 itm               ! test value                   (local)  PLOTS.48
                                                                                 PLOTS.49
C  Real variables                                                                PLOTS.50
                                                                                 PLOTS.51
      real             xcs(*),           ! point locations x direction     (in)  PLOTS.52
     *                 ycs(*)            ! point locations y direction     (in)  PLOTS.53
      real             dst(100)          ! scratch array                (local)  PLOTS.54
                                                                                 PLOTS.55
C  Common blocks                                                                 PLOTS.56
                                                                                 PLOTS.57
      common /flinfo/  fscolr,           ! first color                           PLOTS.58
     *                 secolr,           ! second color                          PLOTS.59
     *                 thcolr,           ! third color                           PLOTS.60
     *                 frcolr,           ! fourth color                          PLOTS.61
     *                 fvcolr,           ! fifth color                           PLOTS.62
     *                 sicolr            ! sixth color                           PLOTS.63
      common /flwatr/  wacolr            ! water color                           PLOTS.64
                                                                                 PLOTS.65
C****************************  subroutine begin  *****************************C  PLOTS.66
                                                                                 PLOTS.67
C  Be certain that the current polygon is on the map                             PLOTS.68
                                                                                 PLOTS.69
      if ((aid(1) .ge. 0) .and. (aid(2) .ge. 0)) then                            PLOTS.70
                                                                                 PLOTS.71
C  If one is zero or negative and the other isn't test on the one that isn't     PLOTS.72
                                                                                 PLOTS.73
        itm = max0(aid(1),aid(2))                                                PLOTS.74
        if (itm .gt. 0) then                                                     PLOTS.75
                                                                                 PLOTS.76
C  Determine proper color index, MAPACI is an EZMAPA utility function            PLOTS.77
                                                                                 PLOTS.78
          index = mapaci(itm)                                                    PLOTS.79
          if (index .eq. 1) then                                                 PLOTS.80
            index = wacolr                                                       PLOTS.81
          else if (index .eq. 2) then                                            PLOTS.82
            index = fscolr                                                       PLOTS.83
          else if (index .eq. 3) then                                            PLOTS.84
            index = secolr                                                       PLOTS.85
          else if (index .eq. 4) then                                            PLOTS.86
            index = thcolr                                                       PLOTS.87
          else if (index .eq. 5) then                                            PLOTS.88
            index = frcolr                                                       PLOTS.89
          else if (index .eq. 6) then                                            PLOTS.90
            index = fvcolr                                                       PLOTS.91
          else if (index .eq. 7) then                                            PLOTS.92
            index = sicolr                                                       PLOTS.93
          end if                                                                 PLOTS.94
        else                                                                     PLOTS.95
          index = wacolr                                                         PLOTS.96
        end if                                                                   PLOTS.97
                                                                                 PLOTS.98
C  Do color fill                                                                 PLOTS.99
                                                                                 PLOTS.100
        call sfsgfa (xcs,ycs,ncs-1,dst,100,ind,200,index)                        PLOTS.101
      end if                                                                     PLOTS.102
                                                                                 PLOTS.103
C*****************************  subroutine end  ******************************C  PLOTS.104
                                                                                 PLOTS.105
      return                                                                     PLOTS.106
      end                                                                        PLOTS.107
      subroutine crdrci (test,error,colind,defind,whline,i,name,                 PLOTS.108
     *                   size,errsev,noplt,util)                                 PLOTS.109
                                                                                 PLOTS.110
C*****************************************************************************C  PLOTS.111
C  crdrci   - This is a CONDRV/MAPDRV routine                                 C  PLOTS.112
C  Section  - Tables                                                          C  PLOTS.113
C  Purpose  - To read in a single color index and check it for validity.      C  PLOTS.114
C                                                                             C  PLOTS.115
C  On entry - TEST is a logical that must be true for the index to be  parsed C  PLOTS.116
C             from the table.  ERROR is true if an error has occured in which C  PLOTS.117
C             case the index should not be parsed from the table.  DEFIND  is C  PLOTS.118
C             a default color index to use if needed.  WHLINE is a whole line C  PLOTS.119
C             taken from the current table.  I is the current place in WHLINE.C  PLOTS.120
C             NAME is the name of the color index to use when giving an error C  PLOTS.121
C             message.  SIZE is the number of characters in NAME.  ERRSEV in- C  PLOTS.122
C             dicates what severity of error should stop execution.   UTIL is C  PLOTS.123
C             is the name of the utility using this routine.                  C  PLOTS.124
C                                                                             C  PLOTS.125
C  On exit  - COLIND  contains  the value set to the  color index.   NOPLT is C  PLOTS.126
C             true if a non-correctable error has occured.  ERROR is true  if C  PLOTS.127
C             an error has occured and is false otherwise.                    C  PLOTS.128
C                                                                             C  PLOTS.129
C  Notes    - Routine             Location of Definition                      C  PLOTS.130
C             ----------------------------------------------------------------C  PLOTS.131
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.132
C             GQCR                GKS                                         C  PLOTS.133
C             ----------------------------------------------------------------C  PLOTS.134
C                                                                             C  PLOTS.135
C  Assume   - Nothing                                                         C  PLOTS.136
C                                                                             C  PLOTS.137
C  Author   - Jeremy Asbill      Date - August 7, 1990      for the MM4 club  C  PLOTS.138
C*****************************************************************************C  PLOTS.139
                                                                                 PLOTS.140
C  Character variables                                                           PLOTS.141
                                                                                 PLOTS.142
      character*80     whline            ! a line of text from table       (in)  PLOTS.143
      character*36     name              ! name of color index             (in)  PLOTS.144
      character*6      util              ! name of using utility           (in)  PLOTS.145
      character*60     ermes             ! error message string         (local)  PLOTS.146
                                                                                 PLOTS.147
C  Integer variables                                                             PLOTS.148
                                                                                 PLOTS.149
      integer          defind,           ! default color index             (in)  PLOTS.150
     *                 i,                ! position in WHLINE              (in)  PLOTS.151
     *                 size,             ! number of chars in NAME         (in)  PLOTS.152
     *                 errsev            ! error severity comparitor       (in)  PLOTS.153
      integer          colind            ! color index                    (out)  PLOTS.154
      integer          j,                ! loop counter                 (local)  PLOTS.155
     *                 ier               ! error flag from GKS          (local)  PLOTS.156
                                                                                 PLOTS.157
C  Logical variables                                                             PLOTS.158
                                                                                 PLOTS.159
      logical          test,             ! use the table ?                 (in)  PLOTS.160
     *                 error             ! has an error occured ?          (in)  PLOTS.161
      logical          noplt             ! will a plot be drawn ?         (out)  PLOTS.162
                                                                                 PLOTS.163
C  Real variables                                                                PLOTS.164
                                                                                 PLOTS.165
      real             f1,f2,f3          ! junk fillers                 (local)  PLOTS.166
                                                                                 PLOTS.167
C****************************  Subroutine Begin  *****************************C  PLOTS.168
                                                                                 PLOTS.169
C  Check to see if we should use the table                                       PLOTS.170
                                                                                 PLOTS.171
      if ((test) .and. (.not. error)) then                                       PLOTS.172
                                                                                 PLOTS.173
C  Use the table to read the color index                                         PLOTS.174
                                                                                 PLOTS.175
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.176
          colind = defind                                                        PLOTS.177
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.178
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.179
          read (whline(i:i+1),20,err=30) colind                                  PLOTS.180
        else                                                                     PLOTS.181
          read (whline(i:i),10,err=30) colind                                    PLOTS.182
        end if                                                                   PLOTS.183
                                                                                 PLOTS.184
C  Check that the color index is a valid one                                     PLOTS.185
                                                                                 PLOTS.186
        if (colind .ge. 0) then                                                  PLOTS.187
          call gqcr (1,colind,0,ier,f1,f2,f3)                                    PLOTS.188
        end if                                                                   PLOTS.189
        if ((ier .eq. 87) .or. ((colind .lt. 0) .and.                            PLOTS.190
     *      (colind .ne. defind)) .or. (colind .gt. 255) .or.                    PLOTS.191
     *      (ier .eq. 86)) then                                                  PLOTS.192
          ermes(1:size) = name(1:size)                                           PLOTS.193
          ermes(size+1:size+11) = ' Is Invalid'                                  PLOTS.194
          do 40 j = size+12,60                                                   PLOTS.195
            ermes(j:j) = ' '                                                     PLOTS.196
40        continue                                                               PLOTS.197
          call errhan (util,1,ermes,errsev)                                      PLOTS.198
          colind = defind                                                        PLOTS.199
          error = .true.                                                         PLOTS.200
        else if (ier .ne. 0) then                                                PLOTS.201
                                                                                 PLOTS.202
C  If GKS returns another error, who knows what is wrong                         PLOTS.203
                                                                                 PLOTS.204
          ermes(1:30)  = 'Non-Correctable Error Encounte'                        PLOTS.205
          ermes(31:60) = 'red                           '                        PLOTS.206
          call errhan (util,1,ermes,errsev)                                      PLOTS.207
          noplt = .true.                                                         PLOTS.208
        else if (colind .ge. 100) then                                           PLOTS.209
                                                                                 PLOTS.210
C  Warn the user if the index is within a reserved region                        PLOTS.211
C  100 - 199 is reserved for CONDRV                                              PLOTS.212
C  200 - 255 is reserved for MAPDRV                                              PLOTS.213
                                                                                 PLOTS.214
          ermes(1:size) = name(1:size)                                           PLOTS.215
          ermes(size+1:size+24) = ' Is In A Reserved Region'                     PLOTS.216
          do 50 j = size+24,60                                                   PLOTS.217
            ermes(j:j) = ' '                                                     PLOTS.218
50        continue                                                               PLOTS.219
          call errhan (util,0,ermes,errsev)                                      PLOTS.220
          colind = defind                                                        PLOTS.221
        end if                                                                   PLOTS.222
        goto 60                                                                  PLOTS.223
                                                                                 PLOTS.224
C  If an error occured during the read tell the user                             PLOTS.225
                                                                                 PLOTS.226
30      ermes(1:size) = name(1:size)                                             PLOTS.227
        ermes(size+1:size+17) = ' Input Conversion'                              PLOTS.228
        call errhan (util,1,ermes,errsev)                                        PLOTS.229
        colind = defind                                                          PLOTS.230
        error = .true.                                                           PLOTS.231
      else                                                                       PLOTS.232
        colind = defind                                                          PLOTS.233
      end if                                                                     PLOTS.234
                                                                                 PLOTS.235
C*****************************  subroutine end  ******************************C  PLOTS.236
                                                                                 PLOTS.237
C  Format statements begin ...                                                   PLOTS.238
                                                                                 PLOTS.239
10    format (I1)                                                                PLOTS.240
20    format (I2)                                                                PLOTS.241
                                                                                 PLOTS.242
C  Format statements end.                                                        PLOTS.243
                                                                                 PLOTS.244
60    return                                                                     PLOTS.245
      end                                                                        PLOTS.246
      subroutine errfil (flnum)                                                  PLOTS.247
                                                                                 PLOTS.248
C*****************************************************************************C  PLOTS.249
C  errfil   - this is a MAPDRV routine                                        C  PLOTS.250
C  Section  - Error Handling                                                  C  PLOTS.251
C  Purpose  - To assign fill colors after an  error has  occured in the  fill C  PLOTS.252
C             table read.                                                     C  PLOTS.253
C                                                                             C  PLOTS.254
C  On entry - FLNUM is the number of the color indicies still needed.         C  PLOTS.255
C                                                                             C  PLOTS.256
C  On exit  - Those color indicies below  the  one erred upon,  and including C  PLOTS.257
C             the one erred upon have been set up with some valid guesses.    C  PLOTS.258
C                                                                             C  PLOTS.259
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.260
C             ----------------------------------------------------------------C  PLOTS.261
C             GSCR                GKS                                         C  PLOTS.262
C             ----------------------------------------------------------------C  PLOTS.263
C                                                                             C  PLOTS.264
C  Assume   - GKS is open.  Color indicies above 200 are reserved for  MAPDRV C  PLOTS.265
C             use.                                                            C  PLOTS.266
C                                                                             C  PLOTS.267
C  Author   - Jeremy Asbill       Date - July 13, 1990       for the MM4 club C  PLOTS.268
C*****************************************************************************C  PLOTS.269
                                                                                 PLOTS.270
C  Integer variable                                                              PLOTS.271
                                                                                 PLOTS.272
      integer          flnum             ! number of indicies needed       (in)  PLOTS.273
      integer          fscolr,           ! for common block FLINFO               PLOTS.274
     *                 secolr,           ! for common block FLINFO               PLOTS.275
     *                 thcolr,           ! for common block FLINFO               PLOTS.276
     *                 frcolr,           ! for common block FLINFO               PLOTS.277
     *                 fvcolr,           ! for common block FLINFO               PLOTS.278
     *                 sicolr            ! for common block FLINFO               PLOTS.279
      integer          wacolr            ! for common block FLWATR               PLOTS.280
                                                                                 PLOTS.281
C  Common blocks                                                                 PLOTS.282
                                                                                 PLOTS.283
      common /flinfo/  fscolr,           ! first color                           PLOTS.284
     *                 secolr,           ! second color                          PLOTS.285
     *                 thcolr,           ! third color                           PLOTS.286
     *                 frcolr,           ! fourth color                          PLOTS.287
     *                 fvcolr,           ! fifth color                           PLOTS.288
     *                 sicolr            ! sixth color                           PLOTS.289
      common /flwatr/  wacolr            ! water color                           PLOTS.290
                                                                                 PLOTS.291
C****************************  subroutine begin  *****************************C  PLOTS.292
                                                                                 PLOTS.293
C  If execution did not stop in ERRHAN, make up some colors                      PLOTS.294
                                                                                 PLOTS.295
      if (flnum .gt. 0) then                                                     PLOTS.296
        call gscr (1,206,0.86,0.58,0.44)                                         PLOTS.297
        sicolr = 206                       ! Tan                                 PLOTS.298
      end if                                                                     PLOTS.299
                                                                                 PLOTS.300
      if (flnum .gt. 1) then                                                     PLOTS.301
        call gscr (1,205,0.57,0.00,0.87)                                         PLOTS.302
        fvcolr = 205                       ! Purple                              PLOTS.303
      end if                                                                     PLOTS.304
                                                                                 PLOTS.305
      if (flnum  .gt. 2) then                                                    PLOTS.306
        call gscr (1,204,1.00,0.00,0.00)                                         PLOTS.307
        frcolr = 204                       ! Red                                 PLOTS.308
      end if                                                                     PLOTS.309
                                                                                 PLOTS.310
      if (flnum .gt. 3) then                                                     PLOTS.311
        call gscr (1,203,0.14,0.56,0.14)                                         PLOTS.312
        thcolr = 203                       ! Forest Green                        PLOTS.313
      end if                                                                     PLOTS.314
                                                                                 PLOTS.315
      if (flnum .gt. 4) then                                                     PLOTS.316
        call gscr (1,202,1.00,1.00,0.00)                                         PLOTS.317
        secolr = 202                       ! Yellow                              PLOTS.318
      end if                                                                     PLOTS.319
                                                                                 PLOTS.320
      if (flnum .gt. 5) then                                                     PLOTS.321
        call gscr (1,201,1.00,0.00,1.00)                                         PLOTS.322
        fscolr = 201                       ! Magenta                             PLOTS.323
      end if                                                                     PLOTS.324
                                                                                 PLOTS.325
      if (flnum .gt. 6) then                                                     PLOTS.326
        call gscr (1,200,0.20,0.56,0.80)                                         PLOTS.327
        wacolr = 200                       ! Sky blue (A.K.A. Sea blue)          PLOTS.328
      end if                                                                     PLOTS.329
                                                                                 PLOTS.330
C*****************************  subroutine end  ******************************C  PLOTS.331
                                                                                 PLOTS.332
      return                                                                     PLOTS.333
      end                                                                        PLOTS.334
      subroutine errhan (util,errwar,ermes,errsev)                               PLOTS.335
                                                                                 PLOTS.336
C*****************************************************************************C  PLOTS.337
C  errhan   - this is a MAPDRV/CONDRV routine                                 C  PLOTS.338
C  Section  - Error Handling                                                  C  PLOTS.339
C  Purpose  - To deliver error  message  to  the user and determine  if  exe- C  PLOTS.340
C             execution should be halted.                                     C  PLOTS.341
C                                                                             C  PLOTS.342
C  On entry - UTIL contains the name of  the utility that has encountered the C  PLOTS.343
C             error.   ERMES  contains the string to be provided to the user. C  PLOTS.344
C             ERRWAR indicates a warning or a message.  ERRSEV indicates  the C  PLOTS.345
C             severity of an error at which execution should stop.   The cur- C  PLOTS.346
C             rent error count and warning count are passed in through common C  PLOTS.347
C             block ERRORS.                                                   C  PLOTS.348
C                                                                             C  PLOTS.349
C  On exit  - The message has been delivered.  The routine may or may not re- C  PLOTS.350
C             turn.                                                           C  PLOTS.351
C                                                                             C  PLOTS.352
C  Assume   - Nothing.                                                        C  PLOTS.353
C                                                                             C  PLOTS.354
C  Author   - Jeremy Asbill       Date - June 21, 1990       for the MM4 club C  PLOTS.355
C*****************************************************************************C  PLOTS.356
                                                                                 PLOTS.357
C  Character variables                                                           PLOTS.358
                                                                                 PLOTS.359
      character*60     ermes             ! error message to deliver        (in)  PLOTS.360
      character*6      util              ! the utility with a problem      (in)  PLOTS.361
      character*27     fmstp             ! first part of stop message   (local)  PLOTS.362
      character*12     smstp             ! second part of stop message  (local)  PLOTS.363
      character*9      tmstp             ! third part of stop message   (local)  PLOTS.364
                                                                                 PLOTS.365
C  Integer variables                                                             PLOTS.366
                                                                                 PLOTS.367
      integer          errwar,           ! severity of the error           (in)  PLOTS.368
     *                 errsev            ! execution stop level            (in)  PLOTS.369
      integer          error,            ! for common block ERRORS               PLOTS.370
     *                 warns             ! for common block ERRORS               PLOTS.371
                                                                                 PLOTS.372
C  Common blocks                                                                 PLOTS.373
                                                                                 PLOTS.374
      common /errors/  error,            ! current error count                   PLOTS.375
     *                 warns             ! current warning count                 PLOTS.376
                                                                                 PLOTS.377
C****************************  subroutine begin  *****************************C  PLOTS.378
                                                                                 PLOTS.379
C  Deliver the message                                                           PLOTS.380
C  ERRWAR = 0  => A Warning Message                                              PLOTS.381
C  ERRWAR = 1  => An Error Message                                               PLOTS.382
                                                                                 PLOTS.383
      if (errwar .eq. 0) then                                                    PLOTS.384
        warns = warns + 1                                                        PLOTS.385
        write (6,20) util,ermes                                                  PLOTS.386
      else                                                                       PLOTS.387
        error = error + 1                                                        PLOTS.388
        write (6,10) util,ermes                                                  PLOTS.389
      end if                                                                     PLOTS.390
                                                                                 PLOTS.391
C  Check to see if execution should be halted or not                             PLOTS.392
C  ERRSEV = 1    => Nothing Halts Execution                                      PLOTS.393
C  ERRSEV = 0    => Error Halt Execution                                         PLOTS.394
C  ERRSEV = -1   => Errors and Warnings Halt Execution                           PLOTS.395
                                                                                 PLOTS.396
      if (errwar .gt. errsev) then                                               PLOTS.397
        if ((warns .gt. 9) .and. (error .gt. 9)) then                            PLOTS.398
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.399
          smstp(1:12) = ' Errors And '                                           PLOTS.400
          tmstp(1:9) = ' Warnings'                                               PLOTS.401
          write (6,30) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.402
     *                 warns,tmstp(1:9)                                          PLOTS.403
        else if ((warns .gt. 9) .and. (error .eq. 1)) then                       PLOTS.404
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.405
          smstp(1:11) = ' Error And '                                            PLOTS.406
          tmstp(1:9) = ' Warnings'                                               PLOTS.407
          write (6,55) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.408
     *                 warns,tmstp(1:9)                                          PLOTS.409
        else if ((warns .gt. 9) .and.                                            PLOTS.410
     *           (((error .gt. 1) .and. (error .le. 9)) .or.                     PLOTS.411
     *            (error .eq. 0))) then                                          PLOTS.412
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.413
          smstp(1:12) = ' Errors And '                                           PLOTS.414
          tmstp(1:9) = ' Warnings'                                               PLOTS.415
          write (6,50) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.416
     *                 warns,tmstp(1:9)                                          PLOTS.417
        else if ((warns .eq. 1) .and. (error .gt. 9)) then                       PLOTS.418
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.419
          smstp(1:12) = ' Errors And '                                           PLOTS.420
          tmstp(1:8) = ' Warning'                                                PLOTS.421
          write (6,45) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.422
     *                 warns,tmstp(1:8)                                          PLOTS.423
        else if ((((warns .le. 9) .and. (warns .gt. 1)) .or.                     PLOTS.424
     *            (warns .eq. 0)) .and. (error .gt. 9)) then                     PLOTS.425
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.426
          smstp(1:12) = ' Errors And '                                           PLOTS.427
          tmstp(1:9) = ' Warnings'                                               PLOTS.428
          write (6,40) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.429
     *                 warns,tmstp(1:9)                                          PLOTS.430
        else if ((warns .eq. 1) .and. (error .eq. 1)) then                       PLOTS.431
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.432
          smstp(1:11) = ' Error And '                                            PLOTS.433
          tmstp(1:8) = ' Warning'                                                PLOTS.434
          write (6,65) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.435
     *                 warns,tmstp(1:8)                                          PLOTS.436
        else if ((((warns .le. 9) .and. (warns .gt. 1)) .or.                     PLOTS.437
     *            (warns .eq. 0)) .and. (error .eq. 1)) then                     PLOTS.438
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.439
          smstp(1:11) = ' Error And '                                            PLOTS.440
          tmstp(1:9) = ' Warnings'                                               PLOTS.441
          write (6,70) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.442
     *                 warns,tmstp(1:9)                                          PLOTS.443
        else if ((warns .eq. 1) .and. (((error .le. 9) .and.                     PLOTS.444
     *           (error .gt. 1)) .or. (error .eq. 0))) then                      PLOTS.445
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.446
          smstp(1:12) = ' Errors And '                                           PLOTS.447
          tmstp(1:8) = ' Warning'                                                PLOTS.448
          write (6,75) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.449
     *                 warns,tmstp(1:8)                                          PLOTS.450
        else                                                                     PLOTS.451
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.452
          smstp(1:12) = ' Errors And '                                           PLOTS.453
          tmstp(1:9) = ' Warnings'                                               PLOTS.454
          write (6,60) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.455
     *                 warns,tmstp(1:9)                                          PLOTS.456
        end if                                                                   PLOTS.457
        stop                                                                     PLOTS.458
      end if                                                                     PLOTS.459
                                                                                 PLOTS.460
C*****************************  subroutine end  ******************************C  PLOTS.461
                                                                                 PLOTS.462
C  Format statements begin ...                                                   PLOTS.463
                                                                                 PLOTS.464
10    format (' ',A6,' - Error - ',A60)                                          PLOTS.465
20    format (' ',A6,' - Warning - ',A60)                                        PLOTS.466
30    format (' ',A6,A27,I2,A12,I2,A9)                                           PLOTS.467
40    format (' ',A6,A27,I2,A12,I1,A9)                                           PLOTS.468
45    format (' ',A6,A27,I2,A12,I1,A8)                                           PLOTS.469
50    format (' ',A6,A27,I1,A12,I2,A9)                                           PLOTS.470
55    format (' ',A6,A27,I1,A11,I2,A9)                                           PLOTS.471
60    format (' ',A6,A27,I1,A12,I1,A9)                                           PLOTS.472
65    format (' ',A6,A27,I1,A11,I1,A8)                                           PLOTS.473
70    format (' ',A6,A27,I1,A11,I1,A9)                                           PLOTS.474
75    format (' ',A6,A27,I1,A12,I1,A8)                                           PLOTS.475
                                                                                 PLOTS.476
C  Format statements end.                                                        PLOTS.477
                                                                                 PLOTS.478
      return                                                                     PLOTS.479
      end                                                                        PLOTS.480
      subroutine gtreal (cval,rval,error)                                        PLOTS.481
                                                                                 PLOTS.482
C*****************************************************************************C  PLOTS.483
C  gtreal   - this is a MAPDRV/CONDRV routine                                 C  PLOTS.484
C  Section  - Tables                                                          C  PLOTS.485
C  Purpose  - To read from a character string a real, regardless of what      C  PLOTS.486
C             format it is in (that is, xxx.xxx or xxx.xxxExx).               C  PLOTS.487
C                                                                             C  PLOTS.488
C  On entry - CVAL  is  a character variable  of fixed size that contains the C  PLOTS.489
C             number to be converted to a real.  ERROR is false.              C  PLOTS.490
C                                                                             C  PLOTS.491
C  On exit  - RVAL  is the value in question.   If an error occured  ERROR is C  PLOTS.492
C             TRUE otherwise it is FALSE.                                     C  PLOTS.493
C                                                                             C  PLOTS.494
C  Assume   - Nothing                                                         C  PLOTS.495
C                                                                             C  PLOTS.496
C  Author   - Jeremy Asbill       Date - June 21, 1990      for the MM4 club  C  PLOTS.497
C*****************************************************************************C  PLOTS.498
                                                                                 PLOTS.499
C  Character variables                                                           PLOTS.500
                                                                                 PLOTS.501
      character*20     cval              ! character version of number     (in)  PLOTS.502
                                                                                 PLOTS.503
C  Integer variables                                                             PLOTS.504
                                                                                 PLOTS.505
      integer          unum              ! safe to use unit number      (local)  PLOTS.506
                                                                                 PLOTS.507
C  Logical variables                                                             PLOTS.508
                                                                                 PLOTS.509
      logical          error             ! has an error occured ?         (out)  PLOTS.510
      logical          used              ! is a unit number in use ?    (local)  PLOTS.511
                                                                                 PLOTS.512
C  Real variables                                                                PLOTS.513
                                                                                 PLOTS.514
      real             rval              ! real version of number          (in)  PLOTS.515
                                                                                 PLOTS.516
C****************************  subroutine begin  *****************************C  PLOTS.517
                                                                                 PLOTS.518
C  First make sure there are only numeric like chars in the string               PLOTS.519
                                                                                 PLOTS.520
      error = .false.                                                            PLOTS.521
      do 50 i = 1,20                                                             PLOTS.522
        if ((cval(i:i) .ne. ' ') .and. (cval(i:i) .ne. 'E') .and.                PLOTS.523
     *      (cval(i:i) .ne. 'e') .and. (cval(i:i) .ne. '.') .and.                PLOTS.524
     *      (cval(i:i) .ne. '+') .and. (cval(i:i) .ne. '-') .and.                PLOTS.525
     *      ((ichar(cval(i:i)) .lt. 48) .or.                                     PLOTS.526
     *       (ichar(cval(i:i)) .gt. 57))) error = .true.                         PLOTS.527
50    continue                                                                   PLOTS.528
      if (.not. error) then                                                      PLOTS.529
                                                                                 PLOTS.530
C  Determine a unit number that is safe to use                                   PLOTS.531
                                                                                 PLOTS.532
        unum = 7                                                                 PLOTS.533
40      unum = unum + 1                                                          PLOTS.534
        inquire (unit=unum,opened=used)                                          PLOTS.535
        if (used) goto 40                                                        PLOTS.536
                                                                                 PLOTS.537
C  Open a scratch file as unit number UNUM                                       PLOTS.538
                                                                                 PLOTS.539
        open (unum,status='SCRATCH',err=20)                                      06NOV00.128
                                                                                 PLOTS.541
C  Write CVAL out to the scratch file                                            PLOTS.542
                                                                                 PLOTS.543
        write (unum,10,err=20) cval                                              PLOTS.544
                                                                                 PLOTS.545
C  Rewind and read the value back in as a real                                   PLOTS.546
                                                                                 PLOTS.547
        rewind (unum)                                                            PLOTS.548
        read (unum,*,err=20) rval                                                PLOTS.549
                                                                                 PLOTS.550
C  Close the scratch file                                                        PLOTS.551
                                                                                 PLOTS.552
        close (unum)                                                             PLOTS.553
        goto 30                                                                  PLOTS.554
                                                                                 PLOTS.555
C  Handle the errors                                                             PLOTS.556
                                                                                 PLOTS.557
20      continue                                                                 PLOTS.558
        error = .true.                                                           PLOTS.559
      end if                                                                     PLOTS.560
                                                                                 PLOTS.561
C*****************************  subroutine end  ******************************C  PLOTS.562
                                                                                 PLOTS.563
C  Format statements ...                                                         PLOTS.564
                                                                                 PLOTS.565
10    format (A20)                                                               PLOTS.566
                                                                                 PLOTS.567
C  Format statements end.                                                        PLOTS.568
                                                                                 PLOTS.569
30    return                                                                     PLOTS.570
      end                                                                        PLOTS.571
      subroutine interr (nomap,fsplat,ssplat,jmax,imax,xpa,ypa,xpb,ypb,          PLOTS.572
     *                   project,grds,cenlat,cenlon,buff,errsev)                 PLOTS.573
                                                                                 PLOTS.574
C*****************************************************************************C  PLOTS.575
C  interr   - This is a MAPDRV routine                                        C  PLOTS.576
C  Section  - Error handling                                                  C  PLOTS.577
C  Purpose  - To check for a few obvious errors and  to  initialize the error C  PLOTS.578
C             handling variables.                                             C  PLOTS.579
C                                                                             C  PLOTS.580
C  On entry - JMAX is the x dimension of the entire domain grid.  IMAX is the C  PLOTS.581
C             y  dimension of the entire domain grid.    FSPLAT is the  first C  PLOTS.582
C             standard parallel if project = 'LC'.  SSPLAT is the second such C  PLOTS.583
C             parallel.  XPA, YPA form the lower left grid  point of the map. C  PLOTS.584
C             XPB, YPB the upper right  grid point of the map.  PROJECT is  2 C  PLOTS.585
C             characters denoting which projection is to be used. GRDS is the C  PLOTS.586
C             distance  between two grid  points.  CENLAT and CENLON are  the C  PLOTS.587
C             center latitude and longitude respectively.   ERRSEV  indicates C  PLOTS.588
C             what severity of error will halt execution of the program.   If C  PLOTS.589
C             BUFF  is negative, then no WISS workstation need be open.       C  PLOTS.590
C                                                                             C  PLOTS.591
C  On exit  - NOMAP is true if any errors occured.  The  counters in the com- C  PLOTS.592
C             mon block  ERRORS have been initialized correctly.              C  PLOTS.593
C                                                                             C  PLOTS.594
C  Assume   - Nothing.                                                        C  PLOTS.595
C                                                                             C  PLOTS.596
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.597
C             ----------------------------------------------------------------C  PLOTS.598
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.599
C             GQOPS               GKS                                         C  PLOTS.600
C             OPNGKS              SPPS*                                       C  PLOTS.601
C             GOPWK               GKS                                         C  PLOTS.602
C             GACWK               GKS                                         C  PLOTS.603
C             GQOPWK              GKS                                         C  PLOTS.604
C             GQCR                GKS                                         C  PLOTS.605
C             GSCR                GKS                                         C  PLOTS.606
C             GQWKC               GKS                                         C  PLOTS.607
C             GQWKCA              GKS                                         C  PLOTS.608
C             LCCONE              MAPDRV utility                              C  PLOTS.609
C             ----------------------------------------------------------------C  PLOTS.610
C                                                                             C  PLOTS.611
C  Author   - Jeremy Asbill       Date - July 14, 1990       for the MM4 club C  PLOTS.612
C*****************************************************************************C  PLOTS.613
                                                                                 PLOTS.614
C  Parameter                                                                     PLOTS.615
                                                                                 PLOTS.616
C  ECIRC is the circumference of the earth in kilometers                         PLOTS.617
                                                                                 PLOTS.618
      parameter        (ecirc = 40023.8904)                                      PLOTS.619
                                                                                 PLOTS.620
C  Character varaibles                                                           PLOTS.621
                                                                                 PLOTS.622
      character*2      project           ! specifies projection            (in)  PLOTS.623
      character*60     ermes             ! error message string         (local)  PLOTS.624
                                                                                 PLOTS.625
C  Integer variables                                                             PLOTS.626
                                                                                 PLOTS.627
      integer          imax,             ! y dimension size of entire grid (in)  PLOTS.628
     *                 jmax,             ! x dimension size of entire grid (in)  PLOTS.629
     *                 buff,             ! GFLASH buffer number to use     (in)  PLOTS.630
     *                 errsev            ! error severity comparitor       (in)  PLOTS.631
      integer          error,            ! for common block ERRORS               PLOTS.632
     *                 warns             ! for common block ERRORS               PLOTS.633
      integer          ier,              ! error flag from GKS          (local)  PLOTS.634
     *                 nwk,              ! number of open workstations  (local)  PLOTS.635
     *                 num,              ! workstation identifier       (local)  PLOTS.636
     *                 temp,             ! junk filler                  (local)  PLOTS.637
     *                 wtype,            ! workstation type             (local)  PLOTS.638
     *                 categ,            ! workstation category         (local)  PLOTS.639
     *                 i,                ! loop counter                 (local)  PLOTS.640
     *                 unum,             ! free unit number             (local)  PLOTS.641
     *                 opst              ! GKS operating state          (local)  PLOTS.642
                                                                                 PLOTS.643
C  Logical variables                                                             PLOTS.644
                                                                                 PLOTS.645
      logical          nomap             ! don't draw a map ?             (out)  PLOTS.646
      logical          awiss,            ! is a WISS workstation open ? (local)  PLOTS.647
     *                 used              ! is a unit number used ?      (local)  PLOTS.648
                                                                                 PLOTS.649
C  Real variables                                                                PLOTS.650
                                                                                 PLOTS.651
      real             xpa,              ! lower left x grid pt. on map    (in)  PLOTS.652
     *                 xpb,              ! upper right x grid pt. on map   (in)  PLOTS.653
     *                 ypa,              ! lower left y grid pt. on map    (in)  PLOTS.654
     *                 ypb,              ! upper right y grid pt. on map   (in)  PLOTS.655
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.656
     *                 fsplat,           ! first standard parallel (LC)    (in)  PLOTS.657
     *                 ssplat,           ! second standard parallel (LC)   (in)  PLOTS.658
     *                 cenlat,           ! center lattitude of domain      (in)  PLOTS.659
     *                 cenlon            ! center longitude of domain      (in)  PLOTS.660
      real             red,              ! red component of color rep.  (local)  PLOTS.661
     *                 blue,             ! blue component of color rep. (local)  PLOTS.662
     *                 green             ! green component of color rep.(local)  PLOTS.663
                                                                                 PLOTS.664
C  Common blocks                                                                 PLOTS.665
                                                                                 PLOTS.666
      common /errors/  error,            ! error count                           PLOTS.667
     *                 warns             ! warning count                         PLOTS.668
                                                                                 PLOTS.669
C****************************  subroutine begin  *****************************C  PLOTS.670
                                                                                 PLOTS.671
C  Initialize error counters                                                     PLOTS.672
                                                                                 PLOTS.673
      error = 0                                                                  PLOTS.674
      warns = 0                                                                  PLOTS.675
                                                                                 PLOTS.676
C  Initialize NOMAP                                                              PLOTS.677
                                                                                 PLOTS.678
      nomap = .false.                                                            PLOTS.679
                                                                                 PLOTS.680
C  Check for some obvious errors                                                 PLOTS.681
                                                                                 PLOTS.682
C  Grid dimensions of the domain don't jive                                      PLOTS.683
                                                                                 PLOTS.684
      if ((imax .le. 0.0) .or.                                                   PLOTS.685
     *    (jmax .le. 0.0)) then                                                  PLOTS.686
        ermes(1:34)  = 'Grid Is Short A Dimension Or Two, '                      PLOTS.687
        ermes(35:60) = 'Check JMAX and IMAX       '                              PLOTS.688
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.689
        nomap = .true.                                                           PLOTS.690
      end if                                                                     PLOTS.691
                                                                                 PLOTS.692
C  Grid dimensions of the map don't jive                                         PLOTS.693
                                                                                 PLOTS.694
      if ((xpb .le. xpa) .or.                                                    PLOTS.695
     *    (ypb .le. ypa)) then                                                   PLOTS.696
        ermes(1:30)  = 'Map Cannot Be Inverted, xpb An'                          PLOTS.697
        ermes(31:60) = 'd ypb Must Be > xpa And ypa   '                          PLOTS.698
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.699
        nomap = .true.                                                           PLOTS.700
      end if                                                                     PLOTS.701
                                                                                 PLOTS.702
C  Projection is not supported by MAPDRV                                         PLOTS.703
                                                                                 PLOTS.704
      if ((project(1:2) .ne. 'ST') .and.                                         PLOTS.705
     *    (project(1:2) .ne. 'LC') .and.                                         PLOTS.706
     *    (project(1:2) .ne. 'ME') .and.                                         PLOTS.707
     *    (project(1:2) .ne. 'CE')) then                                         PLOTS.708
        ermes(1:25)  = 'Incapable Of Projection, '                               PLOTS.709
        ermes(26:27) = project(1:2)                                              PLOTS.710
        ermes(28:60) = ', Choose From ST, LC, Or ME      '                       PLOTS.711
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.712
        nomap = .true.                                                           PLOTS.713
      end if                                                                     PLOTS.714
                                                                                 PLOTS.715
C  If the projection is Lambert Conformal make sure the given                    PLOTS.716
C  standard parallels are valid.  If they are calculate the cone factor          PLOTS.717
                                                                                 PLOTS.718
      if (project(1:2) .eq. 'LC') then                                           PLOTS.719
        if ((abs(fsplat) .gt. 90.0) .or. (abs(ssplat) .gt. 90.0)) then           PLOTS.720
          if (cenlat .gt. 0.0) then                                              PLOTS.721
            call lccone (30.0,60.0,1)                                            PLOTS.722
          else                                                                   PLOTS.723
            call lccone (-30.0,-60.0,-1)                                         PLOTS.724
            fsplat = -91.0                                                       PLOTS.725
          end if                                                                 PLOTS.726
        else if ((fsplat/ssplat) .lt. 0.0) then                                  PLOTS.727
          ermes(1:30)  = 'Lambert Projection Around The '                        PLOTS.728
          ermes(31:60) = 'Equator, Use Mercator         '                        PLOTS.729
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.730
          nomap = .true.                                                         PLOTS.731
        else                                                                     PLOTS.732
          if (cenlat .gt. 0.0) then                                              PLOTS.733
            call lccone (fsplat,ssplat,1)                                        PLOTS.734
          else                                                                   PLOTS.735
            call lccone (fsplat,ssplat,-1)                                       PLOTS.736
          end if                                                                 PLOTS.737
        end if                                                                   PLOTS.738
                                                                                 PLOTS.739
C  Make sure the given standard parallels are on the same half of the globe      PLOTS.740
C  as the center latitude                                                        PLOTS.741
                                                                                 PLOTS.742
        if ((fsplat/cenlat) .lt. 0.0) then                                       PLOTS.743
          ermes(1:30)  = 'Lambert Parallels And Domain C'                        PLOTS.744
          ermes(31:60) = 'enter In Opposite Hemispheres '                        PLOTS.745
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.746
          nomap = .true.                                                         PLOTS.747
        end if                                                                   PLOTS.748
                                                                                 PLOTS.749
C  If the projection is Polar Stereographic make sure the FSPLAT parameter       PLOTS.750
C  is a valid true latitude.                                                     PLOTS.751
                                                                                 PLOTS.752
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.753
        if (abs(fsplat) .gt. 90.0) then                                          PLOTS.754
          if (cenlat .gt. 0.0) then                                              PLOTS.755
            call lccone (60.0,0.0,1)                                             PLOTS.756
          else                                                                   PLOTS.757
            call lccone (-60.0,0.0,-1)                                           PLOTS.758
            fsplat = -91.0                                                       PLOTS.759
          end if                                                                 PLOTS.760
        else                                                                     PLOTS.761
          if (cenlat .gt. 0.0) then                                              PLOTS.762
            call lccone (fsplat,0.0,1)                                           PLOTS.763
          else                                                                   PLOTS.764
            call lccone (fsplat,0.0,-1)                                          PLOTS.765
          end if                                                                 PLOTS.766
        end if                                                                   PLOTS.767
                                                                                 PLOTS.768
C  Make sure the domain is in the same hemisphere as the projection is true in   PLOTS.769
                                                                                 PLOTS.770
        if ((fsplat/cenlat) .lt. 0.0) then                                       PLOTS.771
          ermes(1:30)  = 'Polar True Lat. And Domain Cen'                        PLOTS.772
          ermes(31:60) = 'ter In Opposite Hemispheres   '                        PLOTS.773
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.774
          nomap = .true.                                                         PLOTS.775
        end if                                                                   PLOTS.776
      end if                                                                     PLOTS.777
                                                                                 PLOTS.778
C  Make sure the subdomain is at least an improper subdomain of the domain       PLOTS.779
                                                                                 PLOTS.780
      if ((xpa .lt. 1.0) .or. (ypa .lt. 1.0) .or.                                PLOTS.781
     *    (xpb .gt. float(jmax)) .or. (ypb .gt. float(imax))) then               PLOTS.782
        ermes(1:43)  = 'Subdomain Defined By xpa,ypa And xpb,ypb Is'             PLOTS.783
        ermes(44:60) = ' Not A Subdomain'                                        PLOTS.784
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.785
        nomap = .true.                                                           PLOTS.786
      end if                                                                     PLOTS.787
                                                                                 PLOTS.788
C  Check that the domain will even fit on the earth                              PLOTS.789
                                                                                 PLOTS.790
      if ((jmax * nint(grds) .gt. ecirc) .or.                                    PLOTS.791
     *    (imax * nint(grds) .gt. ecirc)) then                                   PLOTS.792
        ermes(1:31)  = 'Domain Is Larger Than The Earth'                         PLOTS.793
        ermes(32:60) = '                             '                           PLOTS.794
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.795
        nomap = .true.                                                           PLOTS.796
      end if                                                                     PLOTS.797
                                                                                 PLOTS.798
C  Make sure the center lat and lon are withing reason                           PLOTS.799
                                                                                 PLOTS.800
      if ((cenlat .gt. 90) .or. (cenlat .lt. -90) .or.                           PLOTS.801
     *    (cenlon .gt. 180) .or. (cenlon .lt. -180)) then                        PLOTS.802
        ermes(1:30)  = 'Center Latitude And Longitude '                          PLOTS.803
        ermes(31:60) = 'Are Out Of This World         '                          PLOTS.804
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.805
        nomap = .true.                                                           PLOTS.806
      end if                                                                     PLOTS.807
                                                                                 PLOTS.808
C  Make sure the state of GKS is proper                                          PLOTS.809
                                                                                 PLOTS.810
      call gqops (opst)                                                          PLOTS.811
      if (opst .eq. 0) then                                                      PLOTS.812
        ermes(1:30)  = 'GKS Is Not Open               '                          PLOTS.813
        ermes(31:60) = '                              '                          PLOTS.814
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.815
        call opngks                                                              PLOTS.816
        nomap = .true.                                                           PLOTS.817
      else if (opst .eq. 1) then                                                 PLOTS.818
        ermes(1:30)  = 'There Are No Open Workstations'                          PLOTS.819
        ermes(31:60) = '                              '                          PLOTS.820
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.821
        call gopwk (1,2,1)                                                       PLOTS.822
        call gacwk (1)                                                           PLOTS.823
        nomap = .true.                                                           PLOTS.824
      else if (opst .eq. 2) then                                                 PLOTS.825
        ermes(1:30)  = 'There Are No Active Workstatio'                          PLOTS.826
        ermes(31:60) = 'ns                            '                          PLOTS.827
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.828
        call gqopwk (1,ier,nwk,num)                                              PLOTS.829
        call gacwk (num)                                                         PLOTS.830
        nomap = .true.                                                           PLOTS.831
      end if                                                                     PLOTS.832
                                                                                 PLOTS.833
C  Make certain background and foreground color are defined                      PLOTS.834
                                                                                 PLOTS.835
      call gqcr (1,0,0,ier,red,blue,green)                                       PLOTS.836
                                                                                 PLOTS.837
C  Check for errors from GKS                                                     PLOTS.838
                                                                                 PLOTS.839
      if ((ier .eq. 87) .or. (ier .eq. 93)) then                                 PLOTS.840
        ermes(1:30)  = 'Background Color Index Is Inva'                          PLOTS.841
        ermes(31:60) = 'lid                           '                          PLOTS.842
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.843
        nomap = .true.                                                           PLOTS.844
      else if ((ier .ne. 0) .and. (ier .ne. 94)) then                            PLOTS.845
        ermes(1:30)  = 'Uncorrectable Error Encoutered'                          PLOTS.846
        ermes(31:60) = '                              '                          PLOTS.847
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.848
        nomap = .true.                                                           PLOTS.849
      end if                                                                     PLOTS.850
                                                                                 PLOTS.851
C  If Background color is not black warn the user that their maps may look       PLOTS.852
C  stupid                                                                        PLOTS.853
                                                                                 PLOTS.854
      if ((red .ne. 0.0) .or. (blue .ne. 0.0) .or.                               PLOTS.855
     *    (green .ne. 0.0)) then                                                 PLOTS.856
        ermes(1:30)  = 'Background Color Index Is Not '                          PLOTS.857
        ermes(31:60) = 'Black, Background Color Reset '                          PLOTS.858
C       call errhan ('MAPDRV',0,ermes,errsev)                                    06NOV00.129
C  To use different background color (such as white), comment out gscr call      PLOTS.860
C       call gscr (1,0,0.00,0.00,0.00)                                           06NOV00.130
      end if                                                                     PLOTS.862
                                                                                 PLOTS.863
      call gqcr (1,1,0,ier,red,blue,green)                                       PLOTS.864
                                                                                 PLOTS.865
C  Check for errors from GKS                                                     PLOTS.866
                                                                                 PLOTS.867
      if ((ier .eq. 87) .or. (ier .eq. 93)) then                                 PLOTS.868
        ermes(1:30)  = 'Foreground Color Index Is Inva'                          PLOTS.869
        ermes(31:60) = 'lid                           '                          PLOTS.870
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.871
        nomap = .true.                                                           PLOTS.872
      else if ((ier .ne. 0) .and. (ier .ne. 94)) then                            PLOTS.873
        ermes(1:30)  = 'Uncorrectable Error Encoutered'                          PLOTS.874
        ermes(31:60) = '                              '                          PLOTS.875
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.876
        nomap = .true.                                                           PLOTS.877
      end if                                                                     PLOTS.878
                                                                                 PLOTS.879
C  If Background color is not black warn the user that their maps may look       PLOTS.880
C  stupid                                                                        PLOTS.881
                                                                                 PLOTS.882
      if ((red .lt. 0.8) .and. (blue .lt. 0.8) .and.                             PLOTS.883
     *    (green .lt. 0.8)) then                                                 PLOTS.884
        ermes(1:30)  = 'Foreground Color Index Is Not '                          PLOTS.885
        ermes(31:60) = 'White, Foreground Color Reset '                          PLOTS.886
        call errhan ('MAPDRV',0,ermes,errsev)                                    PLOTS.887
        call gscr (1,1,0.80,0.80,0.80)                                           PLOTS.888
      end if                                                                     PLOTS.889
                                                                                 PLOTS.890
C  Check that a WISS workstation has been opened for GFLASH                      PLOTS.891
                                                                                 PLOTS.892
      if (buff .ge. 0) then                                                      PLOTS.893
        call gqopwk (1,ier,nwk,num)                                              PLOTS.894
        do 10 i = 1,nwk                                                          PLOTS.895
          call gqopwk (i,ier,temp,num)                                           PLOTS.896
          call gqwkc (num,ier,temp,wtype)                                        PLOTS.897
          call gqwkca (wtype,ier,categ)                                          PLOTS.898
          if (categ .eq. 3) awiss = .true.                                       PLOTS.899
10      continue                                                                 PLOTS.900
        if (.not. awiss) then                                                    PLOTS.901
          ermes(1:30)  = 'No WISS Workstation Open      '                        PLOTS.902
          ermes(31:60) = '                              '                        PLOTS.903
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.904
          unum = 0                                                               PLOTS.905
20        unum = unum + 1                                                        PLOTS.906
          inquire (unit=unum,opened=used)                                        PLOTS.907
          if (used) goto 20                                                      PLOTS.908
          call gopwk (2,unum,3)                                                  PLOTS.909
          nomap = .true.                                                         PLOTS.910
        end if                                                                   PLOTS.911
      end if                                                                     PLOTS.912
                                                                                 PLOTS.913
C*****************************  subroutine end *******************************C  PLOTS.914
                                                                                 PLOTS.915
      return                                                                     PLOTS.916
      end                                                                        PLOTS.917
      subroutine lccone (fsplat,ssplat,sign)                                     PLOTS.918
                                                                                 PLOTS.919
C*****************************************************************************C  PLOTS.920
C  lccone   - This is a MAPDRV routine                                        C  PLOTS.921
C  Section  - Design                                                          C  PLOTS.922
C  Purpose  - To calculate the cone factor to use in a Lambert Conformal Pro- C  PLOTS.923
C             jection.                                                        C  PLOTS.924
C                                                                             C  PLOTS.925
C  On entry - FSPLAT is the first standard parallel to use in the calculation C  PLOTS.926
C             of the cone factor.  SSPLAT is the second such parallel.   SIGN C  PLOTS.927
C             indicates what hemisphere the projection is in.                 C  PLOTS.928
C                                                                             C  PLOTS.929
C  On exit  - CONFAC is calculated and stored in the common block LAMSTF with C  PLOTS.930
C             FSPLAT and SSPLAT.                                              C  PLOTS.931
C                                                                             C  PLOTS.932
C  Assume   - Nothing.                                                        C  PLOTS.933
C                                                                             C  PLOTS.934
C  Author   - Jeremy Asbill       Date - October 10, 1990    for the MM4 club C  PLOTS.935
C*****************************************************************************C  PLOTS.936
                                                                                 PLOTS.937
C  Parameters                                                                    PLOTS.938
                                                                                 PLOTS.939
      parameter       (conv = 0.01745329251994)                                  PLOTS.940
                                                                                 PLOTS.941
C  Integer variables                                                             PLOTS.942
                                                                                 PLOTS.943
      integer          sign              ! indicates which hemisphere      (in)  PLOTS.944
                                                                                 PLOTS.945
C  Real variables                                                                PLOTS.946
                                                                                 PLOTS.947
      real             fsplat,           ! first standard parallel lat.    (in)  PLOTS.948
     *                 ssplat            ! second standard parallel lat.   (in)  PLOTS.949
      real             confac,           ! for common block LAMSTF               PLOTS.950
     *                 fsparl,           ! for common block LAMSTF               PLOTS.951
     *                 ssparl            ! for common block LAMSTF               PLOTS.952
                                                                                 PLOTS.953
C  Common blocks                                                                 PLOTS.954
                                                                                 PLOTS.955
      common /lamstf/  confac,           ! cone factor to be used                PLOTS.956
     *                 fsparl,           ! first standard parallel lat.          PLOTS.957
     *                 ssparl            ! second standard parallel lat.         PLOTS.958
                                                                                 PLOTS.959
C****************************  subroutine begin  *****************************C  PLOTS.960
                                                                                 PLOTS.961
C  Calculate CONFAC using input parameters                                       PLOTS.962
                                                                                 PLOTS.963
      if ( abs(fsplat-ssplat) .gt. 1.e-1 ) then                                  19DEC02.4
      confac = alog10(cos(fsplat * conv)) - alog10(cos(ssplat * conv))           PLOTS.964
      confac = confac/(alog10(tan((45.0 - float(sign) *                          PLOTS.965
     *                             fsplat/2.0) * conv)) -                        PLOTS.966
     *                 alog10(tan((45.0 - float(sign) *                          PLOTS.967
     *                             ssplat/2.0) * conv)))                         PLOTS.968
      else                                                                       19DEC02.5
      confac = sign*sin(fsplat * conv)                                           19DEC02.6
      end if                                                                     19DEC02.7
                                                                                 PLOTS.969
C  Stuff it all into the common block                                            PLOTS.970
                                                                                 PLOTS.971
      fsparl = fsplat                                                            PLOTS.972
      ssparl = ssplat                                                            PLOTS.973
                                                                                 PLOTS.974
C*****************************  subroutine end  ******************************C  PLOTS.975
                                                                                 PLOTS.976
      return                                                                     PLOTS.977
      end                                                                        PLOTS.978
      subroutine llproc (xcs,ycs,ncs,aid,gid,nid)                                PLOTS.979
                                                                                 PLOTS.980
C*****************************************************************************C  PLOTS.981
C   llproc  - This is a MAPDRV routine                                        C  PLOTS.982
C   Section - Lat/Lon Lines                                                   C  PLOTS.983
C   Purpose - To draw lat/lon  lines  for  all  patterns  except  publication C  PLOTS.984
C             style.                                                          C  PLOTS.985
C                                                                             C  PLOTS.986
C  On entry - XCS and YCS hold the x  and y  coordinates,  in  the fractional C  PLOTS.987
C             coordinate system, of NCS points defining a segment of the lat/ C  PLOTS.988
C             lon grid to be drawn. AID and GID contain NID pairs of area and C  PLOTS.989
C             group identifiers describing the polygon.   Common block LLLDET C  PLOTS.990
C             contains the detail information about where the lines go an how C  PLOTS.991
C             they should look.  Common block LLLCOL contains  the  color  to C  PLOTS.992
C             make them.  Common block MOCDET contains information about what C  PLOTS.993
C             outlines were used to draw and fill the map.   Finally,  common C  PLOTS.994
C             block MAPEDGE contains the fraction  coordinates  defining  the C  PLOTS.995
C             edge of the map.                                                C  PLOTS.996
C                                                                             C  PLOTS.997
C  On exit  - A portion of the grid has been drawn.   If the current  portion C  PLOTS.998
C             of the lat/lon grid intersected the edge of the map the approp- C  PLOTS.999
C             riate variables in common blocks LABNUM  and LABPOS  have  been C  PLOTS.1000
C             updated.                                                        C  PLOTS.1001
C                                                                             C  PLOTS.1002
C  Assume   - GKS is open.  This routine is called by the EZMAPA utility.     C  PLOTS.1003
C                                                                             C  PLOTS.1004
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1005
C             ----------------------------------------------------------------C  PLOTS.1006
C             GQPLCI              GKS                                         C  PLOTS.1007
C             GSPLCI              GKS                                         C  PLOTS.1008
C             DASHDB              DASHLINE utility*                           C  PLOTS.1009
C             CURVED              DASHLINE utility*                           C  PLOTS.1010
C             ----------------------------------------------------------------C  PLOTS.1011
C             * NCAR Graphics routine                                         C  PLOTS.1012
C                                                                             C  PLOTS.1013
C             This routine is not called by MAPDRV, it is called by the AREAS C  PLOTS.1014
C             utility which is called by the EZMAPA utility routine MAPGRM.   C  PLOTS.1015
C                                                                             C  PLOTS.1016
C             Also note that the first part of this routine checks for  label C  PLOTS.1017
C             positions for the MAPDRV style labels.                          C  PLOTS.1018
C                                                                             C  PLOTS.1019
C  Author   - Jeremy Asbill       Date - July 7, 1990        for the MM4 club C  PLOTS.1020
C*****************************************************************************C  PLOTS.1021
                                                                                 PLOTS.1022
C  Parameters                                                                    PLOTS.1023
                                                                                 PLOTS.1024
      parameter        (tol = 0.0005)                                            PLOTS.1025
                                                                                 PLOTS.1026
C  Character variables                                                           PLOTS.1027
                                                                                 PLOTS.1028
      character*2      wouts             ! for common block MOCDET               PLOTS.1029
                                                                                 PLOTS.1030
C  Integer variables                                                             PLOTS.1031
                                                                                 PLOTS.1032
      integer          aid(*),           ! area identifiers                (in)  PLOTS.1033
     *                 gid(*),           ! group identifiers               (in)  PLOTS.1034
     *                 ncs,              ! dimension for XCS and YCS       (in)  PLOTS.1035
     *                 nid               ! dimension for AID and GID       (in)  PLOTS.1036
      integer          llplc,            ! for common block LLLDET               PLOTS.1037
     *                 grdsh,            ! for common block LLLDET               PLOTS.1038
     *                 llint             ! for common block LLLDET               PLOTS.1039
      integer          llcolr            ! for common block LLLCOL               PLOTS.1040
      integer          lfnum,            ! for common block LABNUM               PLOTS.1041
     *                 rgnum,            ! for common block LABNUM               PLOTS.1042
     *                 btnum,            ! for common block LABNUM               PLOTS.1043
     *                 tpnum             ! for common block LABNUM               PLOTS.1044
      integer          itm,              ! calculation variable         (local)  PLOTS.1045
     *                 plsv,             ! integer save variable        (local)  PLOTS.1046
     *                 ier               ! junk filler                  (local)  PLOTS.1047
                                                                                 PLOTS.1048
C  Real variables                                                                PLOTS.1049
                                                                                 PLOTS.1050
      real             xcs(*),           ! the grid line x coordinates     (in)  PLOTS.1051
     *                 ycs(*)            ! the grid line y coordinates     (in)  PLOTS.1052
      real             left,             ! for common block MAPEDGE              PLOTS.1053
     *                 right,            ! for common block MAPEDGE              PLOTS.1054
     *                 bottom,           ! for common block MAPEDGE              PLOTS.1055
     *                 top               ! for common block MAPEDGE              PLOTS.1056
      real             lfpos(360,2),     ! for common block LABPOS               PLOTS.1057
     *                 rgpos(360,2),     ! for common block LABPOS               PLOTS.1058
     *                 btpos(360,2),     ! for common block LABPOS               PLOTS.1059
     *                 tppos(360,2)      ! for common block LABPOS               PLOTS.1060
                                                                                 PLOTS.1061
C  Common blocks                                                                 PLOTS.1062
                                                                                 PLOTS.1063
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.1064
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.1065
     *                 llint             ! not used                              PLOTS.1066
      common /lllcol/  llcolr            ! color of lat/lon lines                PLOTS.1067
      common /mocdet/  wouts             ! which outlines were used              PLOTS.1068
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.1069
     *                 right,            ! fractional coord. of right edge       PLOTS.1070
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.1071
     *                 top               ! fractional coord. of top edge         PLOTS.1072
      common /labpos/  lfpos,            ! positions of labels along the left    PLOTS.1073
     *                 rgpos,            ! positions of labels along the right   PLOTS.1074
     *                 btpos,            ! positions of labels along the bottom  PLOTS.1075
     *                 tppos             ! positions of labels along the top     PLOTS.1076
      common /labnum/  lfnum,            ! # of positions in LFPOS               PLOTS.1077
     *                 rgnum,            ! # of positions in RGPOS               PLOTS.1078
     *                 btnum,            ! # of positions in BTPOS               PLOTS.1079
     *                 tpnum             ! # of positions in TPPOS               PLOTS.1080
                                                                                 PLOTS.1081
C****************************  subroutine begin  ****************************C   PLOTS.1082
                                                                                 PLOTS.1083
C  Iteratively search for all intersections with the boundary                    PLOTS.1084
C  These intersections are locations for lat/lon line labels or MAPDRV           PLOTS.1085
C  labels                                                                        PLOTS.1086
                                                                                 PLOTS.1087
      do 10 i = 1,ncs                                                            PLOTS.1088
                                                                                 PLOTS.1089
C  First check for an intersection with the bottom                               PLOTS.1090
                                                                                 PLOTS.1091
        if ((ycs(i) .ge. (bottom - tol))  .and.                                  PLOTS.1092
     *      (ycs(i) .le. (bottom + tol))) then                                   PLOTS.1093
          if (xcs(i) .ne. btpos(btnum,1)) then                                   PLOTS.1094
            btnum = btnum + 1                                                    PLOTS.1095
            if (btnum .eq. 362) then                                             PLOTS.1096
              btnum = btnum - 1                                                  PLOTS.1097
            else if (btnum .lt. 361) then                                        PLOTS.1098
              btpos(btnum,1) = xcs(i)                                            PLOTS.1099
              btpos(btnum,2) = ycs(i)                                            PLOTS.1100
            end if                                                               PLOTS.1101
          end if                                                                 PLOTS.1102
                                                                                 PLOTS.1103
C  Second check for an intersection with the top                                 PLOTS.1104
                                                                                 PLOTS.1105
        else if ((ycs(i) .ge. (top - tol)) .and.                                 PLOTS.1106
     *           (ycs(i) .le. (top + tol))) then                                 PLOTS.1107
          if (xcs(i) .ne. tppos(tpnum,1)) then                                   PLOTS.1108
            tpnum = tpnum + 1                                                    PLOTS.1109
            if (tpnum .eq. 362) then                                             PLOTS.1110
              tpnum = tpnum - 1                                                  PLOTS.1111
            else if (tpnum .lt. 361) then                                        PLOTS.1112
              tppos(tpnum,1) = xcs(i)                                            PLOTS.1113
              tppos(tpnum,2) = ycs(i)                                            PLOTS.1114
            end if                                                               PLOTS.1115
          end if                                                                 PLOTS.1116
                                                                                 PLOTS.1117
C  First check for intersection with the left                                    PLOTS.1118
                                                                                 PLOTS.1119
        else if ((xcs(i) .ge. (left - tol)) .and.                                PLOTS.1120
     *           (xcs(i) .le. (left + tol))) then                                PLOTS.1121
          if (ycs(i) .ne. lfpos(lfnum,2)) then                                   PLOTS.1122
            lfnum = lfnum + 1                                                    PLOTS.1123
            if (lfnum .eq. 362) then                                             PLOTS.1124
              lfnum = lfnum - 1                                                  PLOTS.1125
            else if (lfnum .lt. 361) then                                        PLOTS.1126
              lfpos(lfnum,1) = xcs(i)                                            PLOTS.1127
              lfpos(lfnum,2) = ycs(i)                                            PLOTS.1128
            end if                                                               PLOTS.1129
          end if                                                                 PLOTS.1130
                                                                                 PLOTS.1131
C  Second check for an intersection with the right                               PLOTS.1132
                                                                                 PLOTS.1133
        else if ((xcs(i) .ge. (right - tol)) .and.                               PLOTS.1134
     *           (xcs(i) .le. (right + tol))) then                               PLOTS.1135
          if (ycs(i) .ne. rgpos(rgnum,2)) then                                   PLOTS.1136
            rgnum = rgnum + 1                                                    PLOTS.1137
            if (rgnum .eq. 362) then                                             PLOTS.1138
              rgnum = rgnum - 1                                                  PLOTS.1139
            else if (rgnum .lt. 361) then                                        PLOTS.1140
              rgpos(rgnum,1) = xcs(i)                                            PLOTS.1141
              rgpos(rgnum,2) = ycs(i)                                            PLOTS.1142
            end if                                                               PLOTS.1143
          endif                                                                  PLOTS.1144
        end if                                                                   PLOTS.1145
10    continue                                                                   PLOTS.1146
                                                                                 PLOTS.1147
C  Only draw lat/lon lines if some were requested                                PLOTS.1148
C  LLPLC = 0 means no lat/lon lines were requested                               PLOTS.1149
C  LLPLC = 0 means publication style lat/lon lines were requested                PLOTS.1150
                                                                                 PLOTS.1151
      if ((llplc .ne. 0) .and. (grdsh .ne. 0)) then                              PLOTS.1152
                                                                                 PLOTS.1153
C  Get and save polyline color index                                             PLOTS.1154
                                                                                 PLOTS.1155
        call gqplci (ier,plsv)                                                   PLOTS.1156
                                                                                 PLOTS.1157
C  Set up new index                                                              PLOTS.1158
                                                                                 PLOTS.1159
        call gsplci (llcolr)                                                     PLOTS.1160
                                                                                 PLOTS.1161
C  Set up correct dash pattern                                                   PLOTS.1162
                                                                                 PLOTS.1163
        call dashdb (grdsh)                                                      PLOTS.1164
                                                                                 PLOTS.1165
C  Make sure the polygon lies within the map                                     PLOTS.1166
                                                                                 PLOTS.1167
        if ((aid(1) .ge. 0) .and. (aid(2) .ge. 0)) then                          PLOTS.1168
                                                                                 PLOTS.1169
C  Get the maximum of the area identifiers                                       PLOTS.1170
                                                                                 PLOTS.1171
          itm = max0(aid(1),aid(2))                                              PLOTS.1172
                                                                                 PLOTS.1173
C  If we want lat/lon lines over land then draw them when the suggested color    PLOTS.1174
C  index is not 1.  The areas package suggests that oceans have color index 1.   PLOTS.1175
C  MAPACI is an EZMAPA function.                                                 PLOTS.1176
                                                                                 PLOTS.1177
          if ((llplc .eq. 1) .and. (wouts(1:2) .ne. 'NO')) then                  PLOTS.1178
            if ((mapaci(itm) .ne. 1) .and. (itm .ne. 223) .and.                  PLOTS.1179
     *          (itm .ne. 0))                                                    PLOTS.1180
                                                                                 PLOTS.1181
C  Draw the line and do it using grdsh.                                          PLOTS.1182
                                                                                 PLOTS.1183
     *        call curved (xcs,ycs,ncs)                                          PLOTS.1184
                                                                                 PLOTS.1185
C  If we want lat/lon lines over water then draw them when the area is           PLOTS.1186
C  identified as either ocean or no within the outlines                          PLOTS.1187
C  ITM = 2,1005 means the line is over the ocean                                 PLOTS.1188
C  ITM = 223 means the line is outside the U.S. States                           PLOTS.1189
C  ITM = 0 means, even though outlines were requested there are none             PLOTS.1190
C          in the map, so it is all water                                        PLOTS.1191
                                                                                 PLOTS.1192
          else if ((llplc .eq. -1) .and. (wouts(1:2) .ne. 'NO')) then            PLOTS.1193
            if ((itm .eq. 2) .or. (itm .eq. 223) .or.                            PLOTS.1194
     *          (itm .eq. 1005) .or. (itm .eq. 0))                               PLOTS.1195
                                                                                 PLOTS.1196
C  Draw the line and try to do it using grdsh.                                   PLOTS.1197
                                                                                 PLOTS.1198
     *        call curved (xcs,ycs,ncs)                                          PLOTS.1199
                                                                                 PLOTS.1200
C  If we want lat/lon lines over both land and water just draw them              PLOTS.1201
C  Also if there are no outlines, just draw them                                 PLOTS.1202
                                                                                 PLOTS.1203
          else                                                                   PLOTS.1204
            call curved (xcs,ycs,ncs)                                            PLOTS.1205
          end if                                                                 PLOTS.1206
        end if                                                                   PLOTS.1207
                                                                                 PLOTS.1208
C  Reset the polyline color index                                                PLOTS.1209
                                                                                 PLOTS.1210
        call gsplci (plsv)                                                       PLOTS.1211
      end if                                                                     PLOTS.1212
                                                                                 PLOTS.1213
C****************************  subroutine end  ******************************C   PLOTS.1214
                                                                                 PLOTS.1215
      return                                                                     PLOTS.1216
      end                                                                        PLOTS.1217
      subroutine mapdrv (project,fsplat,ssplat,cenlat,cenlon,grds,jmax,          PLOTS.1218
     *                   imax,xpa,xpb,ypa,ypb,titline,titlen,buff,unum,          PLOTS.1219
     *                   doset,errsev)                                           PLOTS.1220
                                                                                 PLOTS.1221
C*****************************************************************************C  PLOTS.1222
C  mapdrv   - Map Driver                                                      C  PLOTS.1223
C                                                                             C  PLOTS.1224
C  Purpose  - To generate esthetically pleasing maps for use in analysis pro- C  PLOTS.1225
C             gram.  It is the hopes of the programmer that this utility will C  PLOTS.1226
C             be used in GRAPH, RAWINS, TERRAIN and other programs of the MM4 C  PLOTS.1227
C             modelling system.  This utility is completely general and gives C  PLOTS.1228
C             the user flexibility in map appearence.                         C  PLOTS.1229
C                                                                             C  PLOTS.1230
C  On entry - PROJECT  describes what projection is being  used.   FSPLAT and C  PLOTS.1231
C             SSPLAT are only valid if PROJECT = 'LC' and then they represent C  PLOTS.1232
C             the first and second standard parallels respectively to be used C  PLOTS.1233
C             when calculating the projection cone factor.  CENLAT and CENLON C  PLOTS.1234
C             is  the central latitude and longitude of the domain.  GRDS  is C  PLOTS.1235
C             the grid distance of the grid the domain is described on.  JMAX C  PLOTS.1236
C             and IMAX define the overall size of the grid.  XPA, YPA are the C  PLOTS.1237
C             lower left hand grid point of the subdomain to be drawn.   XPB, C  PLOTS.1238
C             YPB  are the upper right hand grid point of the subdomain to be C  PLOTS.1239
C             drawn.  TITLINE is the title to go below the map. TITLEN is the C  PLOTS.1240
C             number of characters in TITLINE.  BUFF is the GFLASH  buffer to C  PLOTS.1241
C             store the map in and UNUM is the unit number to read the tables C  PLOTS.1242
C             from.  If BUFF is negative then only an area map is to be  gen- C  PLOTS.1243
C             erated for CONDRV to use.  If UNUM is negative there are no ta- C  PLOTS.1244
C             bles and everything defaults.  DOSET  tells MAPDRV if it should C  PLOTS.1245
C             do  its  own set call or use the set call the  user  has  made. C  PLOTS.1246
C             ERRSEV  is either a negative positive or zero.                  C  PLOTS.1247
C               ERRSEV > 0 means, nothing stops execution                     C  PLOTS.1248
C               ERRSEV = 0 means, errors stop execution, warnings do not      C  PLOTS.1249
C               ERRSEV < 0 means, both errors and warnings stop execution.    C  PLOTS.1250
C                                                                             C  PLOTS.1251
C  On exit  - The map has been stored in GFLASH buffer BUFF.                  C  PLOTS.1252
C                                                                             C  PLOTS.1253
C  Assume   - That a color table has been set up and GKS is open and active.  C  PLOTS.1254
C             The defining grid begins at 1,1.                                C  PLOTS.1255
C                                                                             C  PLOTS.1256
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1257
C             ----------------------------------------------------------------C  PLOTS.1258
C             INTERR              MAPDRV utility                              C  PLOTS.1259
C             MRDDET              MAPDRV utility                              C  PLOTS.1260
C             MRDFIL              MAPDRV utility                              C  PLOTS.1261
C             MRDCLT              MAPDRV utility                              C  PLOTS.1262
C             SETWIN              MAPDRV utility                              C  PLOTS.1263
C             SETPRO              MAPDRV utility                              C  PLOTS.1264
C             MAPSTI              EZMAP utility*                              C  PLOTS.1265
C             SETMAP              MAPDRV utility                              C  PLOTS.1266
C             MPDRLL              MAPDRV utility                              C  PLOTS.1267
C             MPDRCL              MAPDRV utility                              C  PLOTS.1268
C             GSFAIS              GKS                                         C  PLOTS.1269
C             MAPINT              EZMAP utility*                              C  PLOTS.1270
C             GFLAS1              GFLASH utility*                             C  PLOTS.1271
C             MPDROL              MAPDRV utility                              C  PLOTS.1272
C             PERIM               GRIDAL utility*                             C  PLOTS.1273
C             MPDREL              MAPDRV utility                              C  PLOTS.1274
C             MPDRML              MAPDRV utility                              C  PLOTS.1275
C             MPDRTL              MAPDRV utility                              C  PLOTS.1276
C             GFLAS2              GFLASH utility*                             C  PLOTS.1277
C             MAPFIL              MAPDRV utility                              C  PLOTS.1278
C             GQCLIP              GKS                                         C  PLOTS.1279
C             GSCLIP              GKS                                         C  PLOTS.1280
C             ----------------------------------------------------------------C  PLOTS.1281
C             * NCAR Graphics routine                                         C  PLOTS.1282
C                                                                             C  PLOTS.1283
C             If this is the domain ...                                       C  PLOTS.1284
C                                                                             C  PLOTS.1285
C        imax ----------------------------|--------------------------         C  PLOTS.1286
C             |      ypb -------------------------------------      |         C  PLOTS.1287
C             |          |                |                  |      |         C  PLOTS.1288
C             |          |                |                  |      |         C  PLOTS.1289
C             |          |                |                  |      |         C  PLOTS.1290
C             |          |                |                  |      |         C  PLOTS.1291
C             |          |                |                  |      |         C  PLOTS.1292
C             |          |                |                  |      |         C  PLOTS.1293
C             |          |                |                  |      |         C  PLOTS.1294
C        cenlat----------|----------------|------------------|-------         C  PLOTS.1295
C             |          |                |                  |      |         C  PLOTS.1296
C             |      ypa -------------------------------------      |         C  PLOTS.1297
C             |          xpa              |                xpb      |         C  PLOTS.1298
C             |                           |                         |         C  PLOTS.1299
C             |                           |                         |         C  PLOTS.1300
C             |                         cenlon                      |         C  PLOTS.1301
C             |                           |                         |         C  PLOTS.1302
C             |                           |                         |         C  PLOTS.1303
C             ----------------------------|--------------------------         C  PLOTS.1304
C                                                                jmax         C  PLOTS.1305
C                                                                             C  PLOTS.1306
C  Author   - Jeremy Asbill        Date - July 6, 1990       for the MM4 club C  PLOTS.1307
C*****************************************************************************C  PLOTS.1308
                                                                                 PLOTS.1309
C  Character variables                                                           PLOTS.1310
                                                                                 PLOTS.1311
      character*80     titline           ! string containing the title     (in)  PLOTS.1312
      character*2      project           ! specifies projection            (in)  PLOTS.1313
                                                                                 PLOTS.1314
C  Integer variables                                                             PLOTS.1315
                                                                                 PLOTS.1316
      integer          imax,             ! y dimension size of entire grid (in)  PLOTS.1317
     *                 jmax,             ! x dimension size of entire grid (in)  PLOTS.1318
     *                 titlen,           ! # of characters in title string (in)  PLOTS.1319
     *                 buff,             ! GFLASH buffer to use            (in)  PLOTS.1320
     *                 unum,             ! unit number tables are on       (in)  PLOTS.1321
     *                 errsev            ! error severity indicator        (in)  PLOTS.1322
      integer          wlabs,            ! which labels do we want      (local)  PLOTS.1323
     *                 cfsv,             ! clipping flag save variable  (local)  PLOTS.1324
     *                 ier               ! junk filler                  (local)  PLOTS.1325
                                                                                 PLOTS.1326
C  Logical variables                                                             PLOTS.1327
                                                                                 PLOTS.1328
      logical          doset             ! do our own set here ?           (in)  PLOTS.1329
      logical          flmap,            ! is the map being filled ?    (local)  PLOTS.1330
     *                 title,            ! put a title on the map ?     (local)  PLOTS.1331
     *                 perm,             ! put a perimeter on the map ? (local)  PLOTS.1332
     *                 nomap             ! don't draw a map ?           (local)  PLOTS.1333
                                                                                 PLOTS.1334
C  Real variables                                                                PLOTS.1335
                                                                                 PLOTS.1336
      real             cenlat,           ! central latitude of the domain  (in)  PLOTS.1337
     *                 cenlon,           ! central longitude of the domain (in)  PLOTS.1338
     *                 fsplat,           ! first standard parallel (LC)    (in)  PLOTS.1339
     *                 ssplat,           ! second standard parallel (LC)   (in)  PLOTS.1340
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.1341
     *                 xpa,              ! lower left x grid pt. on map    (in)  PLOTS.1342
     *                 xpb,              ! upper right x grid pt. on map   (in)  PLOTS.1343
     *                 ypa,              ! lower left y grid pt. on map    (in)  PLOTS.1344
     *                 ypb               ! upper right y grid pt. on map   (in)  PLOTS.1345
      real             junk(4)           ! junk filler                  (local)  PLOTS.1346
                                                                                 PLOTS.1347
C*********************** subroutine begin ************************************C  PLOTS.1348
                                                                                 PLOTS.1349
C  EZMAP internal parameters used in this routine are:                           PLOTS.1350
C  VS  - Vertical Slicing                                                        PLOTS.1351
                                                                                 PLOTS.1352
C  Assume the map will not be filled until otherwise decided                     PLOTS.1353
                                                                                 PLOTS.1354
      flmap = .false.                                                            PLOTS.1355
                                                                                 PLOTS.1356
C  Do initial error checking                                                     PLOTS.1357
                                                                                 PLOTS.1358
      call interr (nomap,fsplat,ssplat,jmax,imax,xpa,ypa,xpb,ypb,                PLOTS.1359
     *             project,grds,cenlat,cenlon,buff,errsev)                       PLOTS.1360
                                                                                 PLOTS.1361
C  Get map details                                                               PLOTS.1362
                                                                                 PLOTS.1363
      call mrddet (unum,buff,llplc,wlabs,title,perm,errsev,nomap)                PLOTS.1364
                                                                                 PLOTS.1365
C  If an area map has been requested rather than a drawn map                     PLOTS.1366
C  skip the next two table reads                                                 PLOTS.1367
                                                                                 PLOTS.1368
      if (buff .ge. 0) then                                                      PLOTS.1369
                                                                                 PLOTS.1370
C  Get map fill information                                                      PLOTS.1371
                                                                                 PLOTS.1372
        call mrdfil (unum,flmap,errsev,nomap)                                    PLOTS.1373
                                                                                 PLOTS.1374
C  Get map color information                                                     PLOTS.1375
                                                                                 PLOTS.1376
        call mrdclt (unum,llplc,wlabs,title,errsev,nomap)                        PLOTS.1377
                                                                                 PLOTS.1378
C  Save the users setting for clipping and then turn it off                      PLOTS.1379
                                                                                 PLOTS.1380
        call gqclip (ier,cfsv,junk)                                              PLOTS.1381
        call gsclip (0)                                                          PLOTS.1382
      end if                                                                     PLOTS.1383
                                                                                 PLOTS.1384
C  Do not design the map if NOMAP is set                                         PLOTS.1385
                                                                                 PLOTS.1386
      if (.not. nomap) then                                                      PLOTS.1387
                                                                                 PLOTS.1388
C  Set up the proper projection                                                  PLOTS.1389
                                                                                 PLOTS.1390
        call setpro (project,cenlat,cenlon)                                      PLOTS.1391
                                                                                 PLOTS.1392
C  Set the window up, making sure there is room above and below it               PLOTS.1393
                                                                                 PLOTS.1394
        call setwin (xpa,ypa,xpb,ypb,doset)                                      PLOTS.1395
                                                                                 PLOTS.1396
C  Set up the map window on the globe                                            PLOTS.1397
                                                                                 PLOTS.1398
        call setmap (cenlat,cenlon,project,grds,                                 PLOTS.1399
     *               xpa,ypa,xpb,ypb,imax,jmax)                                  PLOTS.1400
                                                                                 PLOTS.1401
C  Set up the outline, outline colors, and text colors for the map               PLOTS.1402
                                                                                 PLOTS.1403
        call mpdrcl (perm,buff)                                                  PLOTS.1404
                                                                                 PLOTS.1405
C  If color fill is requested, force solid fill                                  PLOTS.1406
                                                                                 PLOTS.1407
        if ((flmap) .and. (buff .ge. 0)) then                                    PLOTS.1408
          call gsfais (1)                                                        PLOTS.1409
                                                                                 PLOTS.1410
C  Use 20 vertical slice to stay within polygon size limits of devices           PLOTS.1411
                                                                                 PLOTS.1412
          call mapsti ('VS',20)                                                  PLOTS.1413
        end if                                                                   PLOTS.1414
                                                                                 PLOTS.1415
C  Initialize EZMAP                                                              PLOTS.1416
                                                                                 PLOTS.1417
        call mapint                                                              PLOTS.1418
      end if                                                                     PLOTS.1419
                                                                                 PLOTS.1420
C  Start saving metacode instructions                                            PLOTS.1421
                                                                                 PLOTS.1422
      if (buff .ge. 0) call gflas1 (buff)                                        PLOTS.1423
                                                                                 PLOTS.1424
C  Do not draw the map if a non-correctable error occured                        PLOTS.1425
                                                                                 PLOTS.1426
      if (.not. nomap) then                                                      PLOTS.1427
                                                                                 PLOTS.1428
C  Call user subroutine                                                          PLOTS.1429
                                                                                 PLOTS.1430
        call mpdrus                                                              PLOTS.1431
                                                                                 PLOTS.1432
C  Prepare for and do color fill                                                 PLOTS.1433
                                                                                 PLOTS.1434
        call mapfil (flmap,buff)                                                 PLOTS.1435
                                                                                 PLOTS.1436
C  Draw the outlines                                                             PLOTS.1437
                                                                                 PLOTS.1438
        if (buff .ge. 0) then                                                    PLOTS.1439
          call mpdrol                                                            PLOTS.1440
                                                                                 PLOTS.1441
C  Draw in the lat/lon line grid                                                 PLOTS.1442
                                                                                 PLOTS.1443
          call mpdrll (grds,flmap,wlabs,cenlon,xpa,xpb,project)                  PLOTS.1444
                                                                                 PLOTS.1445
C  Draw a nice perimeter                                                         PLOTS.1446
                                                                                 PLOTS.1447
          if (perm)                                                              PLOTS.1448
     *      call perim (0,nint(xpb - xpa),0,nint(ypb - ypa))                     PLOTS.1449
                                                                                 PLOTS.1450
C  Set up and draw EZMAP labels                                                  PLOTS.1451
                                                                                 PLOTS.1452
          call mpdrel (perm)                                                     PLOTS.1453
                                                                                 PLOTS.1454
C  Set up and draw MAPDRV labels                                                 PLOTS.1455
                                                                                 PLOTS.1456
          call mpdrml (xpa,ypa,xpb,ypb,project,grds,cenlat,cenlon,               PLOTS.1457
     *                 jmax,imax,errsev)                                         PLOTS.1458
                                                                                 PLOTS.1459
C  Inform the user about there map only if one was made                          PLOTS.1460
                                                                                 PLOTS.1461
C         print *, 'MAPDRV - Map Successfully Completed'                         06NOV00.131
        end if                                                                   PLOTS.1463
      end if                                                                     PLOTS.1464
                                                                                 PLOTS.1465
C  Put on the title                                                              PLOTS.1466
                                                                                 PLOTS.1467
      if (buff .ge. 0) then                                                      PLOTS.1468
        call mpdrtl (titline,titlen,nomap)                                       PLOTS.1469
                                                                                 PLOTS.1470
C  Restore the users clipping setting                                            PLOTS.1471
                                                                                 PLOTS.1472
        call gsclip (cfsv)                                                       PLOTS.1473
                                                                                 PLOTS.1474
C  Save all this on the map background to be flashed                             PLOTS.1475
                                                                                 PLOTS.1476
        call gflas2                                                              PLOTS.1477
      end if                                                                     PLOTS.1478
                                                                                 PLOTS.1479
C*****************************  subroutine end  ******************************C  PLOTS.1480
                                                                                 PLOTS.1481
      return                                                                     PLOTS.1482
      end                                                                        PLOTS.1483
      subroutine mapfil (flmap,buff)                                             PLOTS.1484
                                                                                 PLOTS.1485
C*****************************************************************************C  PLOTS.1486
C  mapfil   - This is a MAPDRV routine                                        C  PLOTS.1487
C  Section  - Fill                                                            C  PLOTS.1488
C  Purpose  - To do requested color fill, including filling the background if C  PLOTS.1489
C             no geographical outlines are requested.                         C  PLOTS.1490
C                                                                             C  PLOTS.1491
C  On entry - FLMAP tells us if we should fill or not.  WOUTS in common block C  PLOTS.1492
C             MOCDET tells us which geographical outlines are requested.   If C  PLOTS.1493
C             BUFF is negative then the map should be put into the CONDRV ar- C  PLOTS.1494
C             ea map and not filled to the buffer.                            C  PLOTS.1495
C                                                                             C  PLOTS.1496
C  On exit  - The map has been filled.                                        C  PLOTS.1497
C                                                                             C  PLOTS.1498
C  Assume   - GKS is open.                                                    C  PLOTS.1499
C                                                                             C  PLOTS.1500
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1501
C             ----------------------------------------------------------------C  PLOTS.1502
C             ARINAM              AREAS utility*                              C  PLOTS.1503
C             MAPBLA              EZMAPA utility*                             C  PLOTS.1504
C             ARPRAM              AREAS utility*                              C  PLOTS.1505
C             ARSCAM              AREAS utility*                              C  PLOTS.1506
C             GETSET              SPPS*                                       C  PLOTS.1507
C             SFSGFA              SOFTFILL utility*                           C  PLOTS.1508
C             ----------------------------------------------------------------C  PLOTS.1509
C             * NCAR Graphics routine                                         C  PLOTS.1510
C                                                                             C  PLOTS.1511
C  Author   - Jeremy Asbill        Date - July 9, 1990       for the MM4 club C  PLOTS.1512
C*****************************************************************************C  PLOTS.1513
                                                                                 PLOTS.1514
C  Character variables                                                           PLOTS.1515
                                                                                 PLOTS.1516
      character*2      wouts             ! for common block MOCDET               PLOTS.1517
                                                                                 PLOTS.1518
C  Integer varaibles                                                             PLOTS.1519
                                                                                 PLOTS.1520
      integer          buff              ! GFLASH buffer to use            (in)  PLOTS.1521
      integer          amapf(8550000)     ! for common block ARAMAP              PLOTS.1522
      integer          cfmap(500000)     ! for common block CSCAMP               PLOTS.1523
      integer          cdmap(100000)     ! for common block CLNAMP               PLOTS.1524
      integer          wacolr            ! for common block FLWATR               PLOTS.1525
      integer          binhr             ! for common block CONFLG               PLOTS.1526
      integer          aid(10),          ! area idfiers array for AREAS (local)  PLOTS.1527
     *                 gid(10),          ! group idfiers array , AREAS  (local)  PLOTS.1528
     *                 ind(12),          ! scratch array for SOFTFILL   (local)  PLOTS.1529
     *                 llsv              ! junk filler                  (local)  PLOTS.1530
                                                                                 PLOTS.1531
C  Logical variables                                                             PLOTS.1532
                                                                                 PLOTS.1533
      logical          flmap             ! will we fill the map ?          (in)  PLOTS.1534
                                                                                 PLOTS.1535
C  Real variables                                                                PLOTS.1536
                                                                                 PLOTS.1537
      real             xcs(5500),        ! x dimension array for AREAS  (local)  PLOTS.1538
     *                 ycs(5500),        ! y dimension array for AREAS  (local)  PLOTS.1539
     *                 xvp(4),           ! x coords for viewport        (local)  PLOTS.1540
     *                 yvp(4),           ! y coords for viewport        (local)  PLOTS.1541
     *                 dst(8),           ! scratch array for SOFTFILL   (local)  PLOTS.1542
     *                 ulsv,             ! junk filler                  (local)  PLOTS.1543
     *                 ursv,             ! junk filler                  (local)  PLOTS.1544
     *                 utsv,             ! junk filler                  (local)  PLOTS.1545
     *                 ubsv              ! junk filler                  (local)  PLOTS.1546
                                                                                 PLOTS.1547
C  Common blocks                                                                 PLOTS.1548
                                                                                 PLOTS.1549
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.1550
      common /aramap/  amapf             ! area map for fill                     PLOTS.1551
      common /flwatr/  wacolr            ! background color                      PLOTS.1552
      common /cscamp/  cfmap             ! CONDRV area map for shade and color   PLOTS.1553
      common /clnamp/  cdmap             ! CONDRV area map for drawing           PLOTS.1554
      common /conflg/  binhr             ! 722 => we have been in here           PLOTS.1555
                                                                                 PLOTS.1556
C  External routines                                                             PLOTS.1557
                                                                                 PLOTS.1558
      external         clproc            ! does actual filling of polygons       PLOTS.1559
                                                                                 PLOTS.1560
C****************************  subroutine begin  *****************************C  PLOTS.1561
                                                                                 PLOTS.1562
C  Do a regular map fill if a fill is requested and there are geographical       PLOTS.1563
C  outlines to use                                                               PLOTS.1564
                                                                                 PLOTS.1565
      if ((flmap) .and. (wouts(1:2) .ne. 'NO')) then                             PLOTS.1566
                                                                                 PLOTS.1567
C  Initialize area map                                                           PLOTS.1568
                                                                                 PLOTS.1569
        call arinam (amapf,8550000)                                              PLOTS.1570
                                                                                 PLOTS.1571
C  Set the group identifiers to the EZMAPA defaults                              PLOTS.1572
                                                                                 PLOTS.1573
        call mapsti ('G1',1)                                                     PLOTS.1574
        call mapsti ('G2',2)                                                     PLOTS.1575
                                                                                 PLOTS.1576
C  Add edges to the area map                                                     PLOTS.1577
                                                                                 PLOTS.1578
        call mapbla (amapf)                                                      PLOTS.1579
                                                                                 PLOTS.1580
C  Preprocess the area map                                                       PLOTS.1581
                                                                                 PLOTS.1582
        call arpram (amapf,0,0,0)                                                PLOTS.1583
                                                                                 PLOTS.1584
C  Fill the map                                                                  PLOTS.1585
                                                                                 PLOTS.1586
        call arscam (amapf,xcs,ycs,5500,aid,gid,10,clproc)                       PLOTS.1587
                                                                                 PLOTS.1588
C  Fill the entire viewport if no outlines are request and fill is still         PLOTS.1589
C  desired                                                                       PLOTS.1590
                                                                                 PLOTS.1591
      else if ((flmap) .and. (wouts(1:2) .eq. 'NO')) then                        PLOTS.1592
                                                                                 PLOTS.1593
C  Define the polygon in an array                                                PLOTS.1594
                                                                                 PLOTS.1595
        call getset (ulsv,ursv,ubsv,utsv,xvp(1),xvp(3),yvp(1),yvp(2),            PLOTS.1596
     *               llsv)                                                       PLOTS.1597
        xvp(2) = xvp(1)                                                          PLOTS.1598
        yvp(3) = yvp(2)                                                          PLOTS.1599
        xvp(4) = xvp(3)                                                          PLOTS.1600
        yvp(4) = yvp(1)                                                          PLOTS.1601
                                                                                 PLOTS.1602
C  Fill the viewport                                                             PLOTS.1603
                                                                                 PLOTS.1604
        call sfsgfa (xvp,yvp,4,dst,8,ind,12,wacolr)                              PLOTS.1605
                                                                                 PLOTS.1606
C  Put the map into the CONDRV area map if BUFF is negative                      PLOTS.1607
                                                                                 PLOTS.1608
      else if (buff .lt. 0) then                                                 PLOTS.1609
                                                                                 PLOTS.1610
C  Let CONDRV know that we have been here                                        PLOTS.1611
                                                                                 PLOTS.1612
        binhr = 722                                                              PLOTS.1613
                                                                                 PLOTS.1614
C  Initialize both area maps                                                     PLOTS.1615
                                                                                 PLOTS.1616
        call arinam (cfmap,500000)                                               PLOTS.1617
        call arinam (cdmap,100000)                                               PLOTS.1618
                                                                                 PLOTS.1619
C  Set the group identifiers to 6 and 7                                          PLOTS.1620
                                                                                 PLOTS.1621
        call mapsti ('G1',6)                                                     PLOTS.1622
        call mapsti ('G2',7)                                                     PLOTS.1623
                                                                                 PLOTS.1624
C  Add the map to both area maps                                                 PLOTS.1625
                                                                                 PLOTS.1626
        call mapbla (cfmap)                                                      PLOTS.1627
        call mapbla (cdmap)                                                      PLOTS.1628
      end if                                                                     PLOTS.1629
                                                                                 PLOTS.1630
C*****************************  subroutine end  ******************************C  PLOTS.1631
                                                                                 PLOTS.1632
      return                                                                     PLOTS.1633
      end                                                                        PLOTS.1634
      subroutine mpdrcl (perm,buff)                                              PLOTS.1635
                                                                                 PLOTS.1636
C*****************************************************************************C  PLOTS.1637
C   mpdrcl  - This is a MAPDRV routine                                        C  PLOTS.1638
C   Section - Design                                                          C  PLOTS.1639
C   Purpose - To set up those internal parameters, and a few other parameters C  PLOTS.1640
C             that define the colors for the map.   To define the proper geo- C  PLOTS.1641
C             graphical outlines for the map.                                 C  PLOTS.1642
C                                                                             C  PLOTS.1643
C  On entry - Common block OUTCOL contains the outline colors.   Common block C  PLOTS.1644
C             PERCOL  contains the perimeter  color.   WOUTS  in common block C  PLOTS.1645
C             MOCDET tells us which outline colors to set.   PERM tells  what C  PLOTS.1646
C             kind of perimeter will be put on the map.   If BUFF is negative C  PLOTS.1647
C             only set up the outline.                                        C  PLOTS.1648
C                                                                             C  PLOTS.1649
C  On exit  - The color for the map outlines have been set up.  The color for C  PLOTS.1650
C             the perimeter has been set up.  The correct outlines have  been C  PLOTS.1651
C             set up with EZMAP.                                              C  PLOTS.1652
C                                                                             C  PLOTS.1653
C  Assume   - GKS is open.                                                    C  PLOTS.1654
C                                                                             C  PLOTS.1655
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1656
C             ----------------------------------------------------------------C  PLOTS.1657
C             MAPSTI              EZMAP utility*                              C  PLOTS.1658
C             GACOLR              GRIDAL utility*                             C  PLOTS.1659
C             ----------------------------------------------------------------C  PLOTS.1660
C             * NCAR Graphics routine                                         C  PLOTS.1661
C                                                                             C  PLOTS.1662
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1663
C*****************************************************************************C  PLOTS.1664
                                                                                 PLOTS.1665
C  Character variables                                                           PLOTS.1666
                                                                                 PLOTS.1667
      character*2      wouts             ! for common block MOCDET               PLOTS.1668
                                                                                 PLOTS.1669
C  Integer variables                                                             PLOTS.1670
                                                                                 PLOTS.1671
      integer          buff              ! GFLASH buffer number            (in)  PLOTS.1672
      integer          cocolr,           ! for common block OUTCOL               PLOTS.1673
     *                 uscolr,           ! for common block OUTCOL               PLOTS.1674
     *                 cncolr            ! for common block OUTCOL               PLOTS.1675
      integer          pecolr            ! for common block PERCOL               PLOTS.1676
                                                                                 PLOTS.1677
C  Logical variables                                                             PLOTS.1678
                                                                                 PLOTS.1679
      logical          perm              ! what perimeter will be used ?   (in)  PLOTS.1680
                                                                                 PLOTS.1681
C  Common blocks                                                                 PLOTS.1682
                                                                                 PLOTS.1683
      common /outcol/  cocolr,           ! color of continents                   PLOTS.1684
     *                 uscolr,           ! color of states                       PLOTS.1685
     *                 cncolr            ! color of countries                    PLOTS.1686
      common /percol/  pecolr            ! color of perimeter                    PLOTS.1687
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.1688
                                                                                 PLOTS.1689
C****************************  subroutine begin  ****************************C   PLOTS.1690
                                                                                 PLOTS.1691
C  EZMAP internal parameters used are:                                           PLOTS.1692
C  C1  - Color of EZMAP perimeter                                                PLOTS.1693
C  C5  - Color index for CO, continental boundaries                              PLOTS.1694
C  C6  - Color index for US, state boundaries                                    PLOTS.1695
C  C7  - Color index for CN, country boundaries                                  PLOTS.1696
C  OU  - geographical OUtlines                                                   PLOTS.1697
                                                                                 PLOTS.1698
C  Only set up colors if a map is going to be drawn                              PLOTS.1699
                                                                                 PLOTS.1700
      if (buff .ge. 0) then                                                      PLOTS.1701
                                                                                 PLOTS.1702
C  Determine which outlines will be drawn and set those colors                   PLOTS.1703
                                                                                 PLOTS.1704
        if (wouts(1:2) .eq. 'US') then                                           PLOTS.1705
          call mapsti ('C6',uscolr)                                              PLOTS.1706
        else if (wouts(1:2) .eq. 'PS') then                                      PLOTS.1707
          call mapsti ('C6',uscolr)                                              PLOTS.1708
          call mapsti ('C5',cocolr)                                              PLOTS.1709
          call mapsti ('C7',cncolr)                                              PLOTS.1710
        else if (wouts(1:2) .eq. 'PO') then                                      PLOTS.1711
          call mapsti ('C5',cocolr)                                              PLOTS.1712
          call mapsti ('C7',cncolr)                                              PLOTS.1713
        else if (wouts(1:2) .eq. 'CO') then                                      PLOTS.1714
          call mapsti ('C5',cocolr)                                              PLOTS.1715
        end if                                                                   PLOTS.1716
                                                                                 PLOTS.1717
C  Set up the color of the perimeter                                             PLOTS.1718
                                                                                 PLOTS.1719
        if (perm) then                                                           PLOTS.1720
          call gacolr (pecolr,pecolr,pecolr,pecolr)                              PLOTS.1721
        else                                                                     PLOTS.1722
          call mapsti ('C1',pecolr)                                              PLOTS.1723
        end if                                                                   PLOTS.1724
      end if                                                                     PLOTS.1725
                                                                                 PLOTS.1726
C  Setup the outline                                                             PLOTS.1727
                                                                                 PLOTS.1728
      call mapstc ('OU',wouts(1:2))                                              PLOTS.1729
                                                                                 PLOTS.1730
C****************************  subroutine end  ******************************C   PLOTS.1731
                                                                                 PLOTS.1732
      return                                                                     PLOTS.1733
      end                                                                        PLOTS.1734
      subroutine mpdrel  (perm)                                                  PLOTS.1735
                                                                                 PLOTS.1736
C*****************************************************************************C  PLOTS.1737
C  mpdrel   - This is a MAPDRV routine                                        C  PLOTS.1738
C  Section  - Labels                                                          C  PLOTS.1739
C  Purpose  - To design and draw EZMAP labels.                                C  PLOTS.1740
C                                                                             C  PLOTS.1741
C  On entry - PERM indicates if the EZMAP perimeter should  be drawn with the C  PLOTS.1742
C             labels.                                                         C  PLOTS.1743
C                                                                             C  PLOTS.1744
C  On exit  - The labels have been written to the GFLASH buffer.              C  PLOTS.1745
C                                                                             C  PLOTS.1746
C  Assume   - GKS is open.  The map itself has been drawn.                    C  PLOTS.1747
C                                                                             C  PLOTS.1748
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1749
C             ----------------------------------------------------------------C  PLOTS.1750
C             MAPSTI              EZMAP utility*                              C  PLOTS.1751
C             MAPLBL              EZMAP utility*                              C  PLOTS.1752
C             ----------------------------------------------------------------C  PLOTS.1753
C             * NCAR Graphics routine                                         C  PLOTS.1754
C                                                                             C  PLOTS.1755
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1756
C*****************************************************************************C  PLOTS.1757
                                                                                 PLOTS.1758
C  Parameter                                                                     PLOTS.1759
                                                                                 PLOTS.1760
      parameter        (scale = 20.0)    ! scales LBSIZ for EZMAP                PLOTS.1761
                                                                                 PLOTS.1762
C  Integer variables                                                             PLOTS.1763
                                                                                 PLOTS.1764
      integer          wlabs,            ! for common block MLBDET               PLOTS.1765
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.1766
      integer          lacolr            ! for common block LABCOL               PLOTS.1767
                                                                                 PLOTS.1768
C  Logical variables                                                             PLOTS.1769
                                                                                 PLOTS.1770
      logical          perm              ! put a perimeter on the map ?    (in)  PLOTS.1771
                                                                                 PLOTS.1772
C  Real variables                                                                PLOTS.1773
                                                                                 PLOTS.1774
      real             lbsiz             ! for common block MLBDET               PLOTS.1775
      real             temp              ! calculation variable         (local)  PLOTS.1776
                                                                                 PLOTS.1777
C  Common blocks                                                                 PLOTS.1778
                                                                                 PLOTS.1779
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.1780
     *                 lbsiz,            ! alternate label size                  PLOTS.1781
     *                 lbqul             ! not used                              PLOTS.1782
      common /labcol/  lacolr            ! label color                           PLOTS.1783
                                                                                 PLOTS.1784
C****************************  subroutine begin  *****************************C  PLOTS.1785
                                                                                 PLOTS.1786
C  EZMAP internal parameters used in this routine are:                           PLOTS.1787
C  LS  - Label Size                                                              PLOTS.1788
C  C3  - Color index for EZMAP labels                                            PLOTS.1789
C  PE  - PErimeter flag                                                          PLOTS.1790
C  LA  - LAbel flag                                                              PLOTS.1791
                                                                                 PLOTS.1792
C  Set up EZMAP labels                                                           PLOTS.1793
                                                                                 PLOTS.1794
      if ((wlabs .eq. 2) .or. (wlabs .eq. -1)) then                              PLOTS.1795
                                                                                 PLOTS.1796
C  Turn on the EZMAP labels                                                      PLOTS.1797
                                                                                 PLOTS.1798
        call mapstl ('LA',.true.)                                                PLOTS.1799
                                                                                 PLOTS.1800
C  Set up correct color for EZMAP labels                                         PLOTS.1801
                                                                                 PLOTS.1802
        call mapsti ('C3',lacolr)                                                PLOTS.1803
                                                                                 PLOTS.1804
C  Set up proper label size for EZMAP labels                                     PLOTS.1805
                                                                                 PLOTS.1806
        temp = scale * lbsiz                                                     PLOTS.1807
        temp = amod(temp,12.0)                                                   PLOTS.1808
        temp = temp/12                                                           PLOTS.1809
        if (temp .eq. 0.0) then                                                  PLOTS.1810
          temp = 1.0                                                             PLOTS.1811
        end if                                                                   PLOTS.1812
        call mapsti ('LS',nint(temp))                                            PLOTS.1813
      else                                                                       PLOTS.1814
                                                                                 PLOTS.1815
C  Turn of the EZMAP labels                                                      PLOTS.1816
                                                                                 PLOTS.1817
        call mapstl ('LA',.false.)                                               PLOTS.1818
      end if                                                                     PLOTS.1819
                                                                                 PLOTS.1820
                                                                                 PLOTS.1821
C  Set up the EZMAP perimeter                                                    PLOTS.1822
                                                                                 PLOTS.1823
      if (perm) then                                                             PLOTS.1824
        call mapstl ('PE',.false.)                                               PLOTS.1825
      else                                                                       PLOTS.1826
        call mapstl ('PE',.true.)                                                PLOTS.1827
      end if                                                                     PLOTS.1828
                                                                                 PLOTS.1829
C  Draw the EZMAP labels ( and possibly the perimeter)                           PLOTS.1830
                                                                                 PLOTS.1831
      if ((wlabs .eq. 2) .or. (wlabs .eq. -1) .or. (.not. perm))                 PLOTS.1832
     *  call maplbl                                                              PLOTS.1833
                                                                                 PLOTS.1834
C*****************************  subroutine end  ******************************C  PLOTS.1835
                                                                                 PLOTS.1836
      return                                                                     PLOTS.1837
      end                                                                        PLOTS.1838
      subroutine mpdrll (grds,flmap,wlabs,cenlon,xpa,xpb,project)                PLOTS.1839
                                                                                 PLOTS.1840
C*****************************************************************************C  PLOTS.1841
C  mpdrll   - This is a MAPDRV routine                                        C  PLOTS.1842
C  Section  - Lat/Lon Lines                                                   C  PLOTS.1843
C  Purpose  - To set up a lat/lon line grid and draw it to the map.           C  PLOTS.1844
C                                                                             C  PLOTS.1845
C  On entry - The common block LLLDET contains the design information for the C  PLOTS.1846
C             grid.  The common block LLLCOL contains the color index for the C  PLOTS.1847
C             grid.   GRDS  conatins  the  grid distance  on the domain grid. C  PLOTS.1848
C             FLMAP  tells us if the map was filled or not.   XPA  is  the  x C  PLOTS.1849
C             coord of the first grid point in the map.   XPB  is the x coord C  PLOTS.1850
C             of the last grid point  in  the map.   WLABS  tells what labels C  PLOTS.1851
C             have been requested.  PROJECT contains the projection used.     C  PLOTS.1852
C                                                                             C  PLOTS.1853
C  On exit  - The grid has been drawn to the GFLASH buffer.                   C  PLOTS.1854
C                                                                             C  PLOTS.1855
C  Assume   - GKS is open. A color table has been set up.  The map itself has C  PLOTS.1856
C             been drawn to the GFLASH buffer.                                C  PLOTS.1857
C                                                                             C  PLOTS.1858
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1859
C             ----------------------------------------------------------------C  PLOTS.1860
C             ARINAM              AREAS utility*                              C  PLOTS.1861
C             MAPSTC              EZMAP utility*                              C  PLOTS.1862
C             MAPBLA              EZMAPA utility*                             C  PLOTS.1863
C             ARPRAM              AREAS utility*                              C  PLOTS.1864
C             MAPSTI              EZMAP utility*                              C  PLOTS.1865
C             MAPGRM              EZMAPA utility*                             C  PLOTS.1866
C             ----------------------------------------------------------------C  PLOTS.1867
C             * NCAR Graphics routine                                         C  PLOTS.1868
C                                                                             C  PLOTS.1869
C             This routine also  determines  the  locations  for  the  MAPDRV C  PLOTS.1870
C             labels.   This  determination  occurs in the  external  routine C  PLOTS.1871
C             LLPROC  which  is called by the  EZMAPA  routine  MAPGRM.  This C  PLOTS.1872
C             routine saves some  necessary  information and then, even if no C  PLOTS.1873
C             no lat/lon  lines are  requested  may have to call   MAPGRM  if C  PLOTS.1874
C             MAPDRV labels have been requested.                              C  PLOTS.1875
C                                                                             C  PLOTS.1876
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1877
C*****************************************************************************C  PLOTS.1878
                                                                                 PLOTS.1879
C  Character variables                                                           PLOTS.1880
                                                                                 PLOTS.1881
      character*2      project           ! projection used in map          (in)  PLOTS.1882
      character*2      wouts             ! for common block MOCDET               PLOTS.1883
                                                                                 PLOTS.1884
C  Integer variables                                                             PLOTS.1885
                                                                                 PLOTS.1886
      integer          wlabs             ! which labels do we want         (in)  PLOTS.1887
      integer          llplc,            ! for common block LLLDET               PLOTS.1888
     *                 grdsh,            ! for common block LLLDET               PLOTS.1889
     *                 llint             ! for common block LLLDET               PLOTS.1890
      integer          amapf(255000)     ! for common block ARAMAP               PLOTS.1891
      integer          lfnum,            ! for common block LABNUM               PLOTS.1892
     *                 rgnum,            ! for common block LABNUM               PLOTS.1893
     *                 btnum,            ! for common block LABNUM               PLOTS.1894
     *                 tpnum             ! for common block LABNUM               PLOTS.1895
      integer          aid(10),          ! area identifiers for areas   (local)  PLOTS.1896
     *                 gid(10),          ! group identifiers for areas  (local)  PLOTS.1897
     *                 numdeg,           ! # of degs. lat/lon in domain (local)  PLOTS.1898
     *                 numgrd,           ! grid interval to use         (local)  PLOTS.1899
     *                 ngrd,             ! # of grid pts in map in x dir(local)  PLOTS.1900
     *                 lltm              ! junk filler                  (local)  PLOTS.1901
                                                                                 PLOTS.1902
C  Logical variables                                                             PLOTS.1903
                                                                                 PLOTS.1904
      logical          flmap             ! did we fill the map ?           (in)  PLOTS.1905
                                                                                 PLOTS.1906
C  Real variables                                                                PLOTS.1907
                                                                                 PLOTS.1908
      real             grds,             ! grid distance in kilometers     (in)  PLOTS.1909
     *                 xpa,              ! x coord of 1st grid in map      (in)  PLOTS.1910
     *                 xpb,              ! x coord of last grid in map     (in)  PLOTS.1911
     *                 cenlon            ! center longitude                (in)  PLOTS.1912
      real             left,             ! for common block MAPEDGE              PLOTS.1913
     *                 right,            ! for common block MAPEDGE              PLOTS.1914
     *                 bottom,           ! for common block MAPEDGE              PLOTS.1915
     *                 top               ! for common block MAPEDGE              PLOTS.1916
      real             xcs(1000),        ! x coords for polys in areas  (local)  PLOTS.1917
     *                 ycs(1000),        ! same as XCS for y coords     (local)  PLOTS.1918
     *                 ultm,             ! junk filler                  (local)  PLOTS.1919
     *                 urtm,             ! junk filler                  (local)  PLOTS.1920
     *                 ubtm,             ! junk filler                  (local)  PLOTS.1921
     *                 uttm              ! junk filler                  (local)  PLOTS.1922
                                                                                 PLOTS.1923
C  Common blocks                                                                 PLOTS.1924
                                                                                 PLOTS.1925
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.1926
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.1927
     *                 llint             ! lat/lon grid interval in degrees      PLOTS.1928
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.1929
      common /aramap/  amapf             ! area map for lat/lon lines            PLOTS.1930
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.1931
     *                 right,            ! fractional coord. of right edge       PLOTS.1932
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.1933
     *                 top               ! fractional coord. of top edge         PLOTS.1934
      common /labnum/  lfnum,            ! # of label positions on left          PLOTS.1935
     *                 rgnum,            ! # of label positions on right         PLOTS.1936
     *                 btnum,            ! # of label positions on bottom        PLOTS.1937
     *                 tpnum             ! # of label positions on top           PLOTS.1938
                                                                                 PLOTS.1939
C  External routines                                                             PLOTS.1940
                                                                                 PLOTS.1941
      external         llproc            ! does actual drawing of lat/lon lines  PLOTS.1942
                                                                                 PLOTS.1943
C****************************  subroutine begin  *****************************C  PLOTS.1944
                                                                                 PLOTS.1945
C  EZMAP internal parrameters used in this routine are:                          PLOTS.1946
C  GR  - lat/lon GRid interval                                                   PLOTS.1947
C  DA  - lat/lon grid DAsh pattern                                               PLOTS.1948
C  C2  - lat/lon grid Color index                                                PLOTS.1949
C  OU  - geographical OUtline indicator                                          PLOTS.1950
C  VS  - Vertical Slicing                                                        PLOTS.1951
                                                                                 PLOTS.1952
C  Set vertical slicing to 1 slice so that dash patterns will be okay            PLOTS.1953
                                                                                 PLOTS.1954
      if (llplc .ne. 0)                                                          PLOTS.1955
     *  call mapsti ('VS',1)                                                     PLOTS.1956
                                                                                 PLOTS.1957
C  See if grid needs to be masked                                                PLOTS.1958
C  We donn't need the areamap if                                                 PLOTS.1959
C    a - no lat/lon lines requested and                                          PLOTS.1960
C    b - no labels are requested                                                 PLOTS.1961
                                                                                 PLOTS.1962
      if ((llplc .ne. 0) .or. (wlabs .eq. 1) .or.                                PLOTS.1963
     *    (wlabs .eq. 2)) then                                                   PLOTS.1964
                                                                                 PLOTS.1965
C  Use the least time consuming outlines for the mask                            PLOTS.1966
                                                                                 PLOTS.1967
        if ((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'PO') .or.              PLOTS.1968
     *      (wouts(1:2) .eq. 'NO'))                                              PLOTS.1969
     *    call mapstc ('OU','CO')                                                PLOTS.1970
                                                                                 PLOTS.1971
C  Initialize area map                                                           PLOTS.1972
                                                                                 PLOTS.1973
        call arinam (amapf,5750000)                                              PLOTS.1974
                                                                                 PLOTS.1975
C  Also add the edges with which to mask                                         PLOTS.1976
                                                                                 PLOTS.1977
        call mapbla (amapf)                                                      PLOTS.1978
                                                                                 PLOTS.1979
C  Preprocess the area map                                                       PLOTS.1980
                                                                                 PLOTS.1981
        call arpram (amapf,0,0,0)                                                PLOTS.1982
                                                                                 PLOTS.1983
C  Get the fractional coordinates of the edges of the map                        PLOTS.1984
                                                                                 PLOTS.1985
        call getset (left,right,bottom,top,                                      PLOTS.1986
     *               ultm,urtm,ubtm,uttm,lltm)                                   PLOTS.1987
                                                                                 PLOTS.1988
C  Initialize the label counters                                                 PLOTS.1989
                                                                                 PLOTS.1990
        lfnum = 0                                                                PLOTS.1991
        rgnum = 0                                                                PLOTS.1992
        btnum = 0                                                                PLOTS.1993
        tpnum = 0                                                                PLOTS.1994
                                                                                 PLOTS.1995
C  If LLINT = 0 then choose a nice grid interval                                 PLOTS.1996
                                                                                 PLOTS.1997
        if (llint .eq. 0) then                                                   PLOTS.1998
          ngrd   = nint(xpb - xpa) + 1                                           PLOTS.1999
          numdeg = int(grds * float(ngrd)/111.0)                                 PLOTS.2000
          if (numdeg .lt. 10) then                                               PLOTS.2001
            numgrd = 2                                                           PLOTS.2002
          else if (numdeg .lt. 20) then                                          PLOTS.2003
            numgrd = 5                                                           PLOTS.2004
          else if (numdeg .lt. 90) then                                          PLOTS.2005
            numgrd = 10                                                          PLOTS.2006
          else                                                                   PLOTS.2007
            numgrd = 15                                                          PLOTS.2008
          end if                                                                 PLOTS.2009
        else                                                                     PLOTS.2010
                                                                                 PLOTS.2011
C  If LLINT isn't 0 then use it as the grid interval                             PLOTS.2012
                                                                                 PLOTS.2013
          numgrd = llint                                                         PLOTS.2014
        end if                                                                   PLOTS.2015
                                                                                 PLOTS.2016
C  Set up grid interval in EZMAP                                                 PLOTS.2017
                                                                                 PLOTS.2018
        call mapsti ('GR',numgrd)                                                PLOTS.2019
                                                                                 PLOTS.2020
C  Draw the latitude/longitude grid                                              PLOTS.2021
                                                                                 PLOTS.2022
        if ((grdsh .eq. 0) .and. (llplc .ne. 0)) then                            PLOTS.2023
          call prodll (numgrd,cenlon,project)                                    PLOTS.2024
        end if                                                                   PLOTS.2025
        call mapgrm (amapf,xcs,ycs,1000,aid,gid,10,llproc)                       PLOTS.2026
      end if                                                                     PLOTS.2027
                                                                                 PLOTS.2028
C*****************************  subroutine end  ******************************C  PLOTS.2029
                                                                                 PLOTS.2030
      return                                                                     PLOTS.2031
      end                                                                        PLOTS.2032
      subroutine mpdrml (xpa,ypa,xpb,ypb,project,grds,cenlat,cenlon,             PLOTS.2033
     *                   jend,iend,errsev)                                       PLOTS.2034
                                                                                 PLOTS.2035
C*****************************************************************************C  PLOTS.2036
C  mpdrml   - This is a MAPDRV routine                                        C  PLOTS.2037
C  Section  - Labels                                                          C  PLOTS.2038
C  Purpose  - To design and draw MAPDRV labels.                               C  PLOTS.2039
C                                                                             C  PLOTS.2040
C  On entry - XPA,vYPA forms the lower left grid point of the map.   XPB, YPB C  PLOTS.2041
C             forms the upper right grid point of the map.  PROJECT indicates C  PLOTS.2042
C             what projection  is  being used.   GRDS is the distance between C  PLOTS.2043
C             grid points in km.   CENLAT  and CENLON are the center latitude C  PLOTS.2044
C             and  longitude  respectively.   JEND, IEND form the upper right C  PLOTS.2045
C             grid point  of  the domain.   ERRSEV indicates what severity of C  PLOTS.2046
C             an error should halt execution.   Design information about  the C  PLOTS.2047
C             labels particularly is passed in through common blocks.         C  PLOTS.2048
C                                                                             C  PLOTS.2049
C  On exit  - The labels have been drawn.                                     C  PLOTS.2050
C                                                                             C  PLOTS.2051
C  Assume   - GKS is open.  The map itself has been drawn.                    C  PLOTS.2052
C                                                                             C  PLOTS.2053
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2054
C             ----------------------------------------------------------------C  PLOTS.2055
C             MAPGTI              EZMAP utility*                              C  PLOTS.2056
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.2057
C             XYTOLL              MAPDRV utility                              C  PLOTS.2058
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.2059
C             GSTXCI              GKS                                         C  PLOTS.2060
C             GSPLCI              GKS                                         C  PLOTS.2061
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2062
C             GETSET              SPPS*                                       C  PLOTS.2063
C             SET                 SPPS*                                       C  PLOTS.2064
C             ----------------------------------------------------------------C  PLOTS.2065
C             * NCAR Graphics routine                                         C  PLOTS.2066
C                                                                             C  PLOTS.2067
C             This  routine  also draws  in  the  publication style perimeter C  PLOTS.2068
C             ticks when they are requested.                                  C  PLOTS.2069
C                                                                             C  PLOTS.2070
C  Author   - Jeremy Asbill       Date - July 19, 1990       for the MM4 club C  PLOTS.2071
C*****************************************************************************C  PLOTS.2072
                                                                                 PLOTS.2073
C  Parameter                                                                     PLOTS.2074
                                                                                 PLOTS.2075
      parameter        (ito = 1)         ! redundancy tolerance                  PLOTS.2076
      parameter        (pi  = 3.14159)   ! pi! you know pi, irrational guy       PLOTS.2077
      parameter        (re  = 6370.0)    ! radius of the earth                   PLOTS.2078
                                                                                 PLOTS.2079
C  Character variables                                                           PLOTS.2080
                                                                                 PLOTS.2081
      character*2      project           ! projection indicator            (in)  PLOTS.2082
      character*60     ermes             ! error message string         (local)  PLOTS.2083
      character*5      str               ! label string                 (local)  PLOTS.2084
                                                                                 PLOTS.2085
C  Integer variables                                                             PLOTS.2086
                                                                                 PLOTS.2087
      integer          jend,             ! right grid point value, domain  (in)  PLOTS.2088
     *                 iend,             ! top grid point value, domain    (in)  PLOTS.2089
     *                 errsev            ! error severity comparitor       (in)  PLOTS.2090
      integer          wlabs,            ! for common block MLBDET               PLOTS.2091
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.2092
      integer          imax,             ! for common block XYLLON               PLOTS.2093
     *                 jmax              ! for common block XYLLON               PLOTS.2094
      integer          lacolr            ! for common block LABCOL               PLOTS.2095
      integer          lfnum,            ! for common block LABNUM               PLOTS.2096
     *                 rgnum,            ! for common block LABNUM               PLOTS.2097
     *                 btnum,            ! for common block LABNUM               PLOTS.2098
     *                 tpnum             ! for common block LABNUM               PLOTS.2099
      integer          llplc,            ! for common block LLLDET               PLOTS.2100
     *                 grdsh,            ! for common block LLLDET               PLOTS.2101
     *                 llint             ! for common block LLLDET               PLOTS.2102
      integer          llcolr            ! for common block LLLCOL               PLOTS.2103
      integer          nmgr,             ! lat/lon grid interval        (local)  PLOTS.2104
     *                 llval(360,2),     ! lat/lon values per side      (local)  PLOTS.2105
     *                 tst1,             ! test variable                (local)  PLOTS.2106
     *                 tst2,             ! test variable                (local)  PLOTS.2107
     *                 latcnt,           ! latitude counter             (local)  PLOTS.2108
     *                 loncnt,           ! longitude counter            (local)  PLOTS.2109
     *                 i,j,              ! loop counter/place keeper    (local)  PLOTS.2110
     *                 xy,yz,            ! dimension picker             (local)  PLOTS.2111
     *                 slen,             ! label string length          (local)  PLOTS.2112
     *                 loop,             ! loop maximum                 (local)  PLOTS.2113
     *                 llsv              ! save variable                (local)  PLOTS.2114
                                                                                 PLOTS.2115
C  Real variables                                                                PLOTS.2116
                                                                                 PLOTS.2117
      real             xpa,              ! left grid point value, map      (in)  PLOTS.2118
     *                 ypa,              ! bottom grid point value, map    (in)  PLOTS.2119
     *                 xpb,              ! right grid point value, map     (in)  PLOTS.2120
     *                 ypb,              ! top grid point value, map       (in)  PLOTS.2121
     *                 grds,             ! grid distance in km             (in)  PLOTS.2122
     *                 cenlat,           ! center latitude, domain         (in)  PLOTS.2123
     *                 cenlon            ! center longitude, domain        (in)  PLOTS.2124
      real             dds,              ! for common block XYLLON               PLOTS.2125
     *                 xlat,             ! for common block XYLLON               PLOTS.2126
     *                 xlon              ! for common block XYLLON               PLOTS.2127
      real             lbsiz             ! for common block MLBDET               PLOTS.2128
      real             left,             ! for common block MAPEDGE              PLOTS.2129
     *                 right,            ! for common block MAPEDGE              PLOTS.2130
     *                 bottom,           ! for common block MAPEDGE              PLOTS.2131
     *                 top               ! for common block MAPEDGE              PLOTS.2132
      real             lfpos(360,2),     ! for common block LABPOS               PLOTS.2133
     *                 rgpos(360,2),     ! for common block LABPOS               PLOTS.2134
     *                 btpos(360,2),     ! for common block LABPOS               PLOTS.2135
     *                 tppos(360,2)      ! for common block LABPOS               PLOTS.2136
      real             xn,               ! cone factor for projection   (local)  PLOTS.2137
     *                 grx,              ! grid value x coord           (local)  PLOTS.2138
     *                 gry,              ! grid value y coord           (local)  PLOTS.2139
     *                 llx,              ! real latitude                (local)  PLOTS.2140
     *                 lly,              ! real longitude               (local)  PLOTS.2141
     *                 flsv,             ! save variable                (local)  PLOTS.2142
     *                 frsv,             ! save variable                (local)  PLOTS.2143
     *                 fbsv,             ! save variable                (local)  PLOTS.2144
     *                 ftsv,             ! save variable                (local)  PLOTS.2145
     *                 ulsv,             ! save variable                (local)  PLOTS.2146
     *                 ursv,             ! save variable                (local)  PLOTS.2147
     *                 ubsv,             ! save variable                (local)  PLOTS.2148
     *                 utsv,             ! save variable                (local)  PLOTS.2149
     *                 ang,              ! angle at which to draw tick  (local)  PLOTS.2150
     *                 dcgtb,            ! dst from grd center to edge  (local)  PLOTS.2151
     *                 dcltp,            ! dst from center to pole      (local)  PLOTS.2152
     *                 tang              ! test angle                   (local)  PLOTS.2153
                                                                                 PLOTS.2154
C  Common blocks                                                                 PLOTS.2155
                                                                                 PLOTS.2156
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.2157
     *                 lbsiz,            ! alternate label size                  PLOTS.2158
     *                 lbqul             ! label quality                         PLOTS.2159
      common /xyllon/  dds,              ! grid distance in kilometers           PLOTS.2160
     *                 xlat,             ! center latitude                       PLOTS.2161
     *                 xlon,             ! center longitude                      PLOTS.2162
     *                 imax,             ! maximum vertical grid point           PLOTS.2163
     *                 jmax              ! maximum horizontal grid point         PLOTS.2164
      common /labcol/  lacolr            ! label color                           PLOTS.2165
      common /labpos/  lfpos,            ! positions of labels along the left    PLOTS.2166
     *                 rgpos,            ! positions of labels along the right   PLOTS.2167
     *                 btpos,            ! positions of labels along the bottom  PLOTS.2168
     *                 tppos             ! positions of labels along the top     PLOTS.2169
      common /labnum/  lfnum,            ! # of positions in LFPOS               PLOTS.2170
     *                 rgnum,            ! # of positions in RGPOS               PLOTS.2171
     *                 btnum,            ! # of positions in BTPOS               PLOTS.2172
     *                 tpnum             ! # of positions in TPPOS               PLOTS.2173
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.2174
     *                 right,            ! fractional coord. of right edge       PLOTS.2175
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.2176
     *                 top               ! fractional coord. of top edge         PLOTS.2177
      common /llldet/  llplc,            ! lat/lon line flag                     PLOTS.2178
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.2179
     *                 llint             ! not used                              PLOTS.2180
      common /lllcol/  llcolr            ! color of perimeter ticks              PLOTS.2181
                                                                                 PLOTS.2182
C****************************  subroutine begin  *****************************C  PLOTS.2183
                                                                                 PLOTS.2184
C  EZMAP internal parameters use in this routine are:                            PLOTS.2185
C  GR  - lat/lon GRid interval                                                   PLOTS.2186
                                                                                 PLOTS.2187
C  PLOTCHAR internal parameters use in this routine are:                         PLOTS.2188
C  CD  - Complex or Duplex characters                                            PLOTS.2189
C  QU  - QUality of charcters                                                    PLOTS.2190
                                                                                 PLOTS.2191
C  Don't draw anything unless MAPDRV labels were requested or publication        PLOTS.2192
C  style grid was used                                                           PLOTS.2193
                                                                                 PLOTS.2194
      if (((wlabs .eq. 1) .or. (wlabs .eq. 2)) .or.                              PLOTS.2195
     *    ((grdsh .eq. 0) .and. (llplc .ne. 0))) then                            PLOTS.2196
                                                                                 PLOTS.2197
C  Check right away for an error in locating them                                PLOTS.2198
                                                                                 PLOTS.2199
        if (lfnum .eq. 361) then                                                 PLOTS.2200
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2201
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2202
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2203
          lfnum = 360                                                            PLOTS.2204
        end if                                                                   PLOTS.2205
                                                                                 PLOTS.2206
        if (rgnum .eq. 361) then                                                 PLOTS.2207
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2208
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2209
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2210
          rgnum = 360                                                            PLOTS.2211
        end if                                                                   PLOTS.2212
                                                                                 PLOTS.2213
        if (btnum .eq. 361) then                                                 PLOTS.2214
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2215
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2216
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2217
          btnum = 360                                                            PLOTS.2218
        end if                                                                   PLOTS.2219
                                                                                 PLOTS.2220
        if (tpnum .eq. 361) then                                                 PLOTS.2221
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2222
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2223
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2224
          tpnum = 360                                                            PLOTS.2225
        end if                                                                   PLOTS.2226
                                                                                 PLOTS.2227
C  Set up routine XYTOLL for use                                                 PLOTS.2228
                                                                                 PLOTS.2229
        dds  = grds                                                              PLOTS.2230
        xlat = cenlat                                                            PLOTS.2231
        xlon = cenlon                                                            PLOTS.2232
        imax = iend                                                              PLOTS.2233
        jmax = jend                                                              PLOTS.2234
                                                                                 PLOTS.2235
C  Determine cone factor                                                         PLOTS.2236
                                                                                 PLOTS.2237
        if (project(1:2) .eq. 'LC') then                                         PLOTS.2238
          xn = 0.716                                                             PLOTS.2239
        else if (project .eq. 'ST') then                                         PLOTS.2240
          xn = 1.0                                                               PLOTS.2241
        else                                                                     PLOTS.2242
          xn = 0.0                                                               PLOTS.2243
        end if                                                                   PLOTS.2244
                                                                                 PLOTS.2245
C  Set quality as the user requested in PLOTCHAR                                 PLOTS.2246
                                                                                 PLOTS.2247
        call pcseti ('CD',lbqul(1))                                              PLOTS.2248
        call pcseti ('QU',lbqul(2))                                              PLOTS.2249
                                                                                 PLOTS.2250
C  Change user vieport to look like the grid so XYTOLL will be useful            PLOTS.2251
                                                                                 PLOTS.2252
        call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)               PLOTS.2253
        j = 0                                                                    PLOTS.2254
60      j = j + 1                                                                PLOTS.2255
        call set    (left,right,bottom,top,                                      PLOTS.2256
     *               xpa,xpb,ypa,ypb,1)                                          PLOTS.2257
        latcnt = 0                                                               PLOTS.2258
        loncnt = 0                                                               PLOTS.2259
                                                                                 PLOTS.2260
C  Retrieve the GRid interval                                                    PLOTS.2261
                                                                                 PLOTS.2262
        call mapgti ('GR',nmgr)                                                  PLOTS.2263
                                                                                 PLOTS.2264
C  First we will do the left, then the right, then the top,                      PLOTS.2265
C  and last the bottom                                                           PLOTS.2266
                                                                                 PLOTS.2267
        if (j .eq. 1) then                                                       PLOTS.2268
          loop = lfnum                                                           PLOTS.2269
        else if (j .eq. 2) then                                                  PLOTS.2270
          loop = rgnum                                                           PLOTS.2271
        else if (j .eq. 3) then                                                  PLOTS.2272
          loop = tpnum                                                           PLOTS.2273
        else                                                                     PLOTS.2274
          loop = btnum                                                           PLOTS.2275
        end if                                                                   PLOTS.2276
                                                                                 PLOTS.2277
C  First convert the positions to lat/lon values                                 PLOTS.2278
                                                                                 PLOTS.2279
        do 10 i = 1,loop                                                         PLOTS.2280
                                                                                 PLOTS.2281
C  CFUX and CFUY are SPPS functions that convert from fractional coordinates     PLOTS.2282
C  to user coordinates.  This gets the grid values of each point                 PLOTS.2283
                                                                                 PLOTS.2284
          if (j .eq. 1) then                                                     PLOTS.2285
            grx = cfux(lfpos(i,1))                                               PLOTS.2286
            gry = cfuy(lfpos(i,2))                                               PLOTS.2287
          else if (j .eq. 2) then                                                PLOTS.2288
            grx = cfux(rgpos(i,1))                                               PLOTS.2289
            gry = cfuy(rgpos(i,2))                                               PLOTS.2290
          else if (j .eq. 3) then                                                PLOTS.2291
            grx = cfux(tppos(i,1))                                               PLOTS.2292
            gry = cfuy(tppos(i,2))                                               PLOTS.2293
          else                                                                   PLOTS.2294
            grx = cfux(btpos(i,1))                                               PLOTS.2295
            gry = cfuy(btpos(i,2))                                               PLOTS.2296
          end if                                                                 PLOTS.2297
                                                                                 PLOTS.2298
C  Convert the grid values to lat/lon values                                     PLOTS.2299
                                                                                 PLOTS.2300
          call xytoll (grx,gry,llx,lly,project)                                  PLOTS.2301
          llval(i,1) = nint(llx)                                                 PLOTS.2302
          llval(i,2) = nint(lly)                                                 PLOTS.2303
                                                                                 PLOTS.2304
C  Check to see which (the lat or lon) value cause the line to be drawn          PLOTS.2305
                                                                                 PLOTS.2306
          tst1 = mod (llval(i,1),nmgr)                                           PLOTS.2307
          tst2 = mod (llval(i,2),nmgr)                                           PLOTS.2308
          if (tst1 .eq. 0) then                                                  PLOTS.2309
            if ((i .ne. 1) .and. (llval(i,1) .ne. llval(1,1))) then              PLOTS.2310
              if ((llval(i,1) .ne. llval(i-1,1)) .or.                            PLOTS.2311
     *            (llval(i,2) .ne. llval(i-1,2)))                                PLOTS.2312
     *          latcnt = latcnt + 1                                              PLOTS.2313
            else if (i .eq. 1) then                                              PLOTS.2314
              latcnt = latcnt + 1                                                PLOTS.2315
            end if                                                               PLOTS.2316
          end if                                                                 PLOTS.2317
          if (tst2 .eq. 0) then                                                  PLOTS.2318
            if ((i .ne. 1) .and. (llval(i,2) .ne. llval(1,2))) then              PLOTS.2319
              if (abs(llval(i,2)) .ne. 180) then                                 PLOTS.2320
                if ((llval(i,1) .ne. llval(i-1,1)) .or.                          PLOTS.2321
     *              (llval(i,2) .ne. llval(i-1,2)))                              PLOTS.2322
     *            loncnt = loncnt + 1                                            PLOTS.2323
              else                                                               PLOTS.2324
                if ((llval(i,1) .ne. llval(i-1,1)) .or.                          PLOTS.2325
     *              ((llval(i,2) .ne. llval(i-1,2)) .and.                        PLOTS.2326
     *               (llval(i,2) .ne. -llval(i-1,2))))                           PLOTS.2327
     *            loncnt = loncnt + 1                                            PLOTS.2328
              end if                                                             PLOTS.2329
            else if (i .eq. 1) then                                              PLOTS.2330
              loncnt = loncnt + 1                                                PLOTS.2331
            end if                                                               PLOTS.2332
          end if                                                                 PLOTS.2333
10      continue                                                                 PLOTS.2334
                                                                                 PLOTS.2335
C  Label the edge with the one which cause the most lines to be drawn            PLOTS.2336
                                                                                 PLOTS.2337
        if ((j .eq. 1) .or. (j .eq. 2)) then                                     PLOTS.2338
          if (latcnt .ge. loncnt) then                                           PLOTS.2339
            xy = 1                                                               PLOTS.2340
          else                                                                   PLOTS.2341
            xy = 2                                                               PLOTS.2342
          end if                                                                 PLOTS.2343
        else                                                                     PLOTS.2344
          if (latcnt .gt. loncnt) then                                           PLOTS.2345
            xy = 1                                                               PLOTS.2346
          else                                                                   PLOTS.2347
            xy = 2                                                               PLOTS.2348
          end if                                                                 PLOTS.2349
        end if                                                                   PLOTS.2350
                                                                                 PLOTS.2351
C  Make a pass through LLVAL checking for duplicate and redundant labels         PLOTS.2352
                                                                                 PLOTS.2353
        do 80 k = 1,loop                                                         PLOTS.2354
          do 70 i = 1,loop                                                       PLOTS.2355
            if (xy .eq. 1) then                                                  PLOTS.2356
              yz = 2                                                             PLOTS.2357
            else                                                                 PLOTS.2358
              yz = 1                                                             PLOTS.2359
            end if                                                               PLOTS.2360
            if ((llval(k,xy) .eq. llval(i,xy)) .and.                             PLOTS.2361
     *          (llval(k,yz) .le. (llval(i,yz) + ito)) .and.                     PLOTS.2362
     *          (llval(k,yz) .ge. (llval(i,yz) - ito)) .and.                     PLOTS.2363
     *          (k .ne. i) .and. (llval(k,xy) .ne. 400)) then                    PLOTS.2364
              llval(i,1) = 400                                                   PLOTS.2365
              llval(i,2) = 400                                                   PLOTS.2366
            end if                                                               PLOTS.2367
70        continue                                                               PLOTS.2368
80      continue                                                                 PLOTS.2369
                                                                                 PLOTS.2370
C  Set up the viewport to draw                                                   PLOTS.2371
                                                                                 PLOTS.2372
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.2373
                                                                                 PLOTS.2374
C  Make the string to be the label                                               PLOTS.2375
                                                                                 PLOTS.2376
        do 20 i = 1,loop                                                         PLOTS.2377
          if (llval(i,xy) .eq. 0) then                    ! Greenwich Meridian   PLOTS.2378
            if (xy .eq. 1) then                           ! or Equator           PLOTS.2379
              str(1:5) = 'EQ   '                                                 PLOTS.2380
            else                                                                 PLOTS.2381
              str(1:5) = 'GM   '                                                 PLOTS.2382
            end if                                                               PLOTS.2383
            slen     = 2                                                         PLOTS.2384
          else if ((llval(i,xy) .eq. -180) .or.           ! International        PLOTS.2385
     *             (llval(i,xy) .eq. 180)) then           ! Date Line            PLOTS.2386
            str(1:5) = 'ID   '                                                   PLOTS.2387
            slen     = 2                                                         PLOTS.2388
          else if ((mod(llval(i,xy),nmgr) .eq. 0) .and.                          PLOTS.2389
     *             (llval(i,xy) .ne. 400)) then                                  PLOTS.2390
            if (llval(i,xy) .ge. 100) then                ! [100 E,180)          PLOTS.2391
              write (str(1:3),30) llval(i,xy)                                    PLOTS.2392
              if (xy .eq. 1) then                                                PLOTS.2393
                str(4:5) = ' N'                                                  PLOTS.2394
              else                                                               PLOTS.2395
                str(4:5) = ' E'                                                  PLOTS.2396
              end if                                                             PLOTS.2397
              slen     = 5                                                       PLOTS.2398
            else if (llval(i,xy) .ge. 10) then            ! [10 E,100 E)         PLOTS.2399
              write (str(1:2),40) llval(i,xy)             ! [10 N,90 N]          PLOTS.2400
              if (xy .eq. 1) then                                                PLOTS.2401
                str(3:5) = ' N '                                                 PLOTS.2402
              else                                                               PLOTS.2403
                str(3:5) = ' E '                                                 PLOTS.2404
              end if                                                             PLOTS.2405
              slen     = 4                                                       PLOTS.2406
            else if (llval(i,xy) .gt. 0) then             ! (0,10 E)             PLOTS.2407
              write (str(1:1),50) llval(i,xy)             ! (0,10 N)             PLOTS.2408
              if (xy .eq. 1) then                                                PLOTS.2409
                str(2:5) = ' N  '                                                PLOTS.2410
              else                                                               PLOTS.2411
                str(2:5) = ' E  '                                                PLOTS.2412
              end if                                                             PLOTS.2413
              slen     = 3                                                       PLOTS.2414
            else if (llval(i,xy) .gt. -10) then           ! (10 W,0)             PLOTS.2415
              write (str(1:1),50) -1 * llval(i,xy)        ! (10 S,0)             PLOTS.2416
              if (xy .eq. 1) then                                                PLOTS.2417
                str(2:5) = ' S  '                                                PLOTS.2418
              else                                                               PLOTS.2419
                str(2:5) = ' W  '                                                PLOTS.2420
              end if                                                             PLOTS.2421
              slen     = 3                                                       PLOTS.2422
            else if (llval(i,xy) .gt. -100) then          ! (100 W,10 W]         PLOTS.2423
              write (str(1:2),40) -1 * llval(i,xy)        ! [90 S,10 S]          PLOTS.2424
              if (xy .eq. 1) then                                                PLOTS.2425
                str(3:5) = ' S '                                                 PLOTS.2426
              else                                                               PLOTS.2427
                str(3:5) = ' W '                                                 PLOTS.2428
              end if                                                             PLOTS.2429
              slen     = 4                                                       PLOTS.2430
            else                                          ! (180,100W]           PLOTS.2431
              write (str(1:3),30) -1 * llval(i,xy)                               PLOTS.2432
              if (xy .eq. 1) then                                                PLOTS.2433
                str(4:5) = ' S'                                                  PLOTS.2434
              else                                                               PLOTS.2435
                str(4:5) = ' W'                                                  PLOTS.2436
              end if                                                             PLOTS.2437
              slen     = 5                                                       PLOTS.2438
            end if                                                               PLOTS.2439
          end if                                                                 PLOTS.2440
                                                                                 PLOTS.2441
C  Draw the label in                                                             PLOTS.2442
                                                                                 PLOTS.2443
          if ((mod(llval(i,xy),nmgr) .eq. 0) .and.                               PLOTS.2444
     *        (llval(i,xy) .ne. 400)) then                                       PLOTS.2445
                                                                                 PLOTS.2446
C  Set up correct color for MAPDRV labels                                        PLOTS.2447
C  To understand what the quality of the letters has to do with the color        PLOTS.2448
C  read on page 2-14 in the NCAR Graphics Guide to New Utilities Version 3.00    PLOTS.2449
C  under the heading of PLOTCHAR                                                 PLOTS.2450
                                                                                 PLOTS.2451
            if ((lbqul(2) .eq. 0) .or. (lbqul(2) .eq. 1)) then                   PLOTS.2452
              call gsplci (lacolr)                                               PLOTS.2453
            else                                                                 PLOTS.2454
              call gstxci (lacolr)                                               PLOTS.2455
            end if                                                               PLOTS.2456
                                                                                 PLOTS.2457
C  Use PLOTCHAR to put the label up                                              PLOTS.2458
                                                                                 PLOTS.2459
            if (j .eq. 1) then                                                   PLOTS.2460
              call plchhq (lfpos(i,1)-lbsiz/85.0,lfpos(i,2),                     PLOTS.2461
     *                     str(1:slen),-lbsiz,0.0,1.0)                           PLOTS.2462
            else if (j .eq. 2) then                                              PLOTS.2463
              call plchhq (rgpos(i,1)+lbsiz/85.0,rgpos(i,2),                     PLOTS.2464
     *                     str(1:slen),-lbsiz,0.0,-1.0)                          PLOTS.2465
            else if (j .eq. 3) then                                              PLOTS.2466
              call plchhq (tppos(i,1),tppos(i,2)+lbsiz/55.0,                     PLOTS.2467
     *                     str(1:slen),-lbsiz,0.0,0.0)                           PLOTS.2468
            else                                                                 PLOTS.2469
              call plchhq (btpos(i,1),btpos(i,2)-lbsiz/45.0,                     PLOTS.2470
     *                     str(1:slen),-lbsiz,0.0,0.0)                           PLOTS.2471
            end if                                                               PLOTS.2472
                                                                                 PLOTS.2473
C  If publication style lat/lon grid was drawn, put in the tick marks            PLOTS.2474
                                                                                 PLOTS.2475
            if ((grdsh .eq. 0) .and. (llplc .ne. 0)) then                        PLOTS.2476
                                                                                 PLOTS.2477
C  Set up correct color for publication style perimeter ticks                    PLOTS.2478
                                                                                 PLOTS.2479
              if ((lbqul(2) .eq. 0) .or. (lbqul(2) .eq. 1)) then                 PLOTS.2480
                call gsplci (llcolr)                                             PLOTS.2481
              else                                                               PLOTS.2482
                call gstxci (llcolr)                                             PLOTS.2483
              end if                                                             PLOTS.2484
                                                                                 PLOTS.2485
C  Calculate the angle at which to draw the tick                                 PLOTS.2486
                                                                                 PLOTS.2487
              ang = (float(llval(i,2)) - cenlon) * xn                            PLOTS.2488
              if ((j .eq. 1) .and. (xy .eq. 2))                                  PLOTS.2489
     *          ang = ang + 90                                                   PLOTS.2490
              if ((j .eq. 2) .and. (xy .eq. 2))                                  PLOTS.2491
     *          ang = ang - 90                                                   PLOTS.2492
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2493
     *            (project(1:2) .eq. 'LC') .and.                                 PLOTS.2494
     *            (llval(i,2) .lt. 0)) ang = ang + 90                            PLOTS.2495
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2496
     *            (project(1:2) .eq. 'LC') .and.                                 PLOTS.2497
     *            (llval(i,2) .gt. 0)) ang = ang - 90                            PLOTS.2498
              if ((j .eq. 3) .and. (xy .eq. 2) .and.                             PLOTS.2499
     *            (project(1:2) .eq. 'ST')) then                                 PLOTS.2500
                if (cenlat .ge. 0.0) then                                        PLOTS.2501
                  tang = 90.0 - cenlat                                           PLOTS.2502
                else                                                             PLOTS.2503
                  tang = 90.0 + cenlat                                           PLOTS.2504
                end if                                                           PLOTS.2505
                dcltp = 2 * pi * re * (tang/360.0)                               PLOTS.2506
                dcgtb = grds * iend * 0.5                                        PLOTS.2507
                if (dcgtb .gt. dcltp) ang = ang + 180                            PLOTS.2508
              end if                                                             PLOTS.2509
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2510
     *            (project(1:2) .eq. 'ST')) then                                 PLOTS.2511
                if (tppos(i,1) .gt. 0.5) then                                    PLOTS.2512
                  ang = ang - 90                                                 PLOTS.2513
                else if (tppos(i,1) .lt. 0.5) then                               PLOTS.2514
                  ang = ang + 90                                                 PLOTS.2515
                end if                                                           PLOTS.2516
              end if                                                             PLOTS.2517
                                                                                 PLOTS.2518
C  Draw the tick as if it were a character.  Using the PLOTCHAR utility          PLOTS.2519
C  allows easy specification of the angle at which to draw the tick.             PLOTS.2520
C  For ticks extending from the right hand side, use a minus sign centered       PLOTS.2521
C  on its right.  ...Extending from the left, use a minus sign centered on       PLOTS.2522
C  its left.  ...Extending from the top, write down the screen instead of        PLOTS.2523
C  across it and use a vertical bar centered on its top.  ...Extending from      PLOTS.2524
C  the bottom, write down the screen instead of across it and use a vertical     PLOTS.2525
C  bar centered on its bottom.                                                   PLOTS.2526
                                                                                 PLOTS.2527
              if (j .eq. 1) then                                                 PLOTS.2528
                call plchhq (lfpos(i,1),lfpos(i,2),                              PLOTS.2529
     *                       '-',-lbsiz,ang,-1.0)                                PLOTS.2530
              else if (j .eq. 2) then                                            PLOTS.2531
                call plchhq (rgpos(i,1),rgpos(i,2),                              PLOTS.2532
     *                       '-',-lbsiz,ang,1.0)                                 PLOTS.2533
              else if (j .eq. 3) then                                            PLOTS.2534
                call plchhq (tppos(i,1),tppos(i,2),                              PLOTS.2535
     *                       ':D:|',-0.667*lbsiz,ang,-1.0)                       PLOTS.2536
              else                                                               PLOTS.2537
                call plchhq (btpos(i,1),btpos(i,2),                              PLOTS.2538
     *                       ':D:|',-0.667*lbsiz,ang,1.0)                        PLOTS.2539
              end if                                                             PLOTS.2540
            end if                                                               PLOTS.2541
          end if                                                                 PLOTS.2542
20      continue                                                                 PLOTS.2543
                                                                                 PLOTS.2544
C  If there are more sides to do, do them                                        PLOTS.2545
                                                                                 PLOTS.2546
        if (j .ne. 4) goto 60                                                    PLOTS.2547
                                                                                 PLOTS.2548
C  Restore any disrupted set call                                                PLOTS.2549
                                                                                 PLOTS.2550
        call set (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                  PLOTS.2551
      end if                                                                     PLOTS.2552
                                                                                 PLOTS.2553
C*****************************  subroutine end  ******************************C  PLOTS.2554
                                                                                 PLOTS.2555
C  Format statements begin ...                                                   PLOTS.2556
                                                                                 PLOTS.2557
30    format (I3)                                                                PLOTS.2558
40    format (I2)                                                                PLOTS.2559
50    format (I1)                                                                PLOTS.2560
                                                                                 PLOTS.2561
C  Format statements end.                                                        PLOTS.2562
                                                                                 PLOTS.2563
      return                                                                     PLOTS.2564
      end                                                                        PLOTS.2565
      subroutine mpdrol                                                          PLOTS.2566
                                                                                 PLOTS.2567
C*****************************************************************************C  PLOTS.2568
C  mpdrol   - This is a MAPDRV routine                                        C  PLOTS.2569
C  Section  - Draw                                                            C  PLOTS.2570
C  Purpose  - To set the correct outline style and draw the outlines.         C  PLOTS.2571
C                                                                             C  PLOTS.2572
C  On entry - The common block  MOTDET  contains dotted line,  and line width C  PLOTS.2573
C             information.                                                    C  PLOTS.2574
C                                                                             C  PLOTS.2575
C  On exit  - The outlines have been drawn.                                   C  PLOTS.2576
C                                                                             C  PLOTS.2577
C  Assume   - GKS is open.                                                    C  PLOTS.2578
C                                                                             C  PLOTS.2579
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2580
C             ----------------------------------------------------------------C  PLOTS.2581
C             MAPSTC              EZMAP utility*                              C  PLOTS.2582
C             MAPSTI              EZMAP utility*                              C  PLOTS.2583
C             MAPSTL              EZMAP utility*                              C  PLOTS.2584
C             GETUSV              SPPS*                                       C  PLOTS.2585
C             SETUSV              SPPS*                                       C  PLOTS.2586
C             MAPLOT              EZMAP utility*                              C  PLOTS.2587
C             ----------------------------------------------------------------C  PLOTS.2588
C             * NCAR Graphics routine                                         C  PLOTS.2589
C                                                                             C  PLOTS.2590
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.2591
C*****************************************************************************C  PLOTS.2592
                                                                                 PLOTS.2593
C  Integer variables                                                             PLOTS.2594
                                                                                 PLOTS.2595
      integer          maplw,            ! for common block MOTDET               PLOTS.2596
     *                 dtdsp             ! for common block MOTDET               PLOTS.2597
      integer          lwsv              ! integer save variable                 PLOTS.2598
                                                                                 PLOTS.2599
C  Logical variables                                                             PLOTS.2600
                                                                                 PLOTS.2601
      logical          dtdmp             ! for common block MOTDET               PLOTS.2602
                                                                                 PLOTS.2603
C  Common blocks                                                                 PLOTS.2604
                                                                                 PLOTS.2605
      common /motdet/  dtdmp,            ! T => draw the map with dots ?         PLOTS.2606
     *                 maplw,            ! line width for map outlines           PLOTS.2607
     *                 dtdsp             ! dash spacing for map outlines         PLOTS.2608
                                                                                 PLOTS.2609
cdave                                                                            PLOTS.2610
      common /hires/   ihires            ! ihires=1 do a hi res, else NCARG      PLOTS.2611
                                                                                 PLOTS.2612
C****************************  subroutine begin  *****************************C  PLOTS.2613
                                                                                 PLOTS.2614
C  EZMAP internal parameters use in this routine are:                            PLOTS.2615
C  DO  - DOtted outline flag                                                     PLOTS.2616
C  DD  - Distance between Dots                                                   PLOTS.2617
                                                                                 PLOTS.2618
C  SPPS internal parameters used in this routine are                             PLOTS.2619
C  LW  - Line Width                                                              PLOTS.2620
                                                                                 PLOTS.2621
C  Set up map outline form (dotted or solid)                                     PLOTS.2622
                                                                                 PLOTS.2623
      call mapstl ('DO',dtdmp)                                                   PLOTS.2624
                                                                                 PLOTS.2625
C  Set up the proper line width for or dot spacing                               PLOTS.2626
                                                                                 PLOTS.2627
      if (dtdmp) then                                                            PLOTS.2628
        call mapsti ('DD',dtdsp)                                                 PLOTS.2629
      else                                                                       PLOTS.2630
        call getusv ('LW',lwsv)                                                  PLOTS.2631
        call setusv ('LW',maplw)                                                 PLOTS.2632
      end if                                                                     PLOTS.2633
                                                                                 PLOTS.2634
C  Draw the outlines                                                             PLOTS.2635
                                                                                 PLOTS.2636
cdave                                                                            PLOTS.2637
      if(ihires.eq.1) then                                                       PLOTS.2638
         call hiresmap(3)                                                        PLOTS.2639
      else                                                                       PLOTS.2640
         call maplot                                                             PLOTS.2641
      endif                                                                      PLOTS.2642
                                                                                 PLOTS.2643
C  Reset the line width if need be                                               PLOTS.2644
                                                                                 PLOTS.2645
      if ((.not. dtdmp) .and. (lwsv .ne. maplw)) then                            PLOTS.2646
        call setusv ('LW',lwsv)                                                  PLOTS.2647
      end if                                                                     PLOTS.2648
                                                                                 PLOTS.2649
C*****************************  subroutine end  ******************************C  PLOTS.2650
                                                                                 PLOTS.2651
      return                                                                     PLOTS.2652
      end                                                                        PLOTS.2653
      subroutine mpdrtl (titline,titlen,nomap)                                   PLOTS.2654
                                                                                 PLOTS.2655
C*****************************************************************************C  PLOTS.2656
C  mpdrtl   - This is a MAPDRV routine                                        C  PLOTS.2657
C  Section  - Labels                                                          C  PLOTS.2658
C  Purpose  - To put the title of the map on the picture.                     C  PLOTS.2659
C                                                                             C  PLOTS.2660
C  On entry - TITLINE  contains the title string.   TITLEN  tells us how long C  PLOTS.2661
C             the string is.   TLSIZ  in the common block MTLDET tells us how C  PLOTS.2662
C             big to make the characters.  TLCOLR  in the common block TITCOL C  PLOTS.2663
C             contains the color index for the title.  If NOMAP is true,  the C  PLOTS.2664
C             routine delivers an error message to the plotting screen.       C  PLOTS.2665
C                                                                             C  PLOTS.2666
C  On exit  - The title has been drawn into the GFLASH buffer.                C  PLOTS.2667
C                                                                             C  PLOTS.2668
C  Assume   - GKS is open.                                                    C  PLOTS.2669
C                                                                             C  PLOTS.2670
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2671
C             ----------------------------------------------------------------C  PLOTS.2672
C             GETSET              SPPS*                                       C  PLOTS.2673
C             SET                 SPPS*                                       C  PLOTS.2674
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.2675
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.2676
C             GSTXCI              GKS                                         C  PLOTS.2677
C             GSPLCI              GKS                                         C  PLOTS.2678
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2679
C             ----------------------------------------------------------------C  PLOTS.2680
C             * NCAR Graphics routine                                         C  PLOTS.2681
C                                                                             C  PLOTS.2682
C  Author   - Jeremy Asbill        Date - July 8, 1990       for the MM4 club C  PLOTS.2683
C*****************************************************************************C  PLOTS.2684
                                                                                 PLOTS.2685
C  Character variables                                                           PLOTS.2686
                                                                                 PLOTS.2687
      character*80     titline           ! string containing the title     (in)  PLOTS.2688
                                                                                 PLOTS.2689
C  Integer variables                                                             PLOTS.2690
                                                                                 PLOTS.2691
      integer          titlen            ! # of characters in title string (in)  PLOTS.2692
      integer          tlqul(2)          ! for common block MTLDET               PLOTS.2693
      integer          tlcolr            ! for common block TITCOL               PLOTS.2694
      integer          llsv              ! viewport save variable       (local)  PLOTS.2695
                                                                                 PLOTS.2696
C  Logical variables                                                             PLOTS.2697
                                                                                 PLOTS.2698
      logical          nomap             ! we didn't draw a map ?          (in)  PLOTS.2699
                                                                                 PLOTS.2700
C  Real variables                                                                PLOTS.2701
                                                                                 PLOTS.2702
      real             tlsiz             ! for common block MTLDET               PLOTS.2703
      real             flsv,             ! viewport save variable       (local)  PLOTS.2704
     *                 frsv,             ! viewport save variable       (local)  PLOTS.2705
     *                 fbsv,             ! viewport save variable       (local)  PLOTS.2706
     *                 ftsv,             ! viewport save variable       (local)  PLOTS.2707
     *                 ulsv,             ! viewport save variable       (local)  PLOTS.2708
     *                 ursv,             ! viewport save variable       (local)  PLOTS.2709
     *                 ubsv,             ! viewport save variable       (local)  PLOTS.2710
     *                 utsv              ! viewport save variable       (local)  PLOTS.2711
                                                                                 PLOTS.2712
C  Common blocks                                                                 PLOTS.2713
                                                                                 PLOTS.2714
      common /mtldet/  tlsiz,            ! alternate title size                  PLOTS.2715
     *                 tlqul             ! title quality                         PLOTS.2716
      common /titcol/  tlcolr            ! title color                           PLOTS.2717
                                                                                 PLOTS.2718
C****************************  subroutine begin  *****************************C  PLOTS.2719
                                                                                 PLOTS.2720
C  PLOTCHAR internal parameters used in this routine are:                        PLOTS.2721
C  CD  - Complex Duplex flag                                                     PLOTS.2722
C  QU  - QUality forcing flag                                                    PLOTS.2723
                                                                                 PLOTS.2724
C  Make certian there is supposed to be a title plotted                          PLOTS.2725
                                                                                 PLOTS.2726
      if ((nint(tlsiz) .ne. 0) .or. (nomap)) then                                PLOTS.2727
                                                                                 PLOTS.2728
C  Get and save the current viewport                                             PLOTS.2729
                                                                                 PLOTS.2730
        call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)               PLOTS.2731
                                                                                 PLOTS.2732
C  Set up viewport to be normalized                                              PLOTS.2733
                                                                                 PLOTS.2734
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.2735
      end if                                                                     PLOTS.2736
                                                                                 PLOTS.2737
C  Set up the type of characters to use                                          PLOTS.2738
                                                                                 PLOTS.2739
      if ((nint(tlsiz) .ne. 0) .and. (.not. nomap)) then                         PLOTS.2740
        call pcseti ('CD',tlqul(1))                                              PLOTS.2741
                                                                                 PLOTS.2742
C  Force PLCHHQ to use the desired quality                                       PLOTS.2743
                                                                                 PLOTS.2744
        call pcseti ('QU',tlqul(2))                                              PLOTS.2745
                                                                                 PLOTS.2746
C  Set up the color properly                                                     PLOTS.2747
C  To understand how color and quality are related read on page 2-14 in the      PLOTS.2748
C  NCAR Graphics Guide to New utilities Version 3.00 under the heading of        PLOTS.2749
C  PLOTCHAR                                                                      PLOTS.2750
                                                                                 PLOTS.2751
        if ((tlqul(2) .eq. 0) .or. (tlqul(2) .eq. 1)) then                       PLOTS.2752
          call gsplci (tlcolr)                                                   PLOTS.2753
        else                                                                     PLOTS.2754
          call gstxci (tlcolr)                                                   PLOTS.2755
        end if                                                                   PLOTS.2756
      end if                                                                     PLOTS.2757
                                                                                 PLOTS.2758
C  If there was no map drawn put a title in the GFLASH buffer reflecting this    PLOTS.2759
                                                                                 PLOTS.2760
      if (nomap) then                                                            PLOTS.2761
                                                                                 PLOTS.2762
C  Mske the title                                                                PLOTS.2763
                                                                                 PLOTS.2764
        titline(1:43)  = 'No Map Drawn Due To A Non-Correctable Error'           PLOTS.2765
        titlen = 43                                                              PLOTS.2766
        tlsiz = 1.0                                                              PLOTS.2767
      end if                                                                     PLOTS.2768
                                                                                 PLOTS.2769
C  Put on title                                                                  PLOTS.2770
                                                                                 PLOTS.2771
      if ((nint(tlsiz) .ne. 0) .or. (nomap)) then                                PLOTS.2772
        call plchhq (0.5,0.035,titline(1:titlen),-tlsiz,0.0,0.0)                 PLOTS.2773
                                                                                 PLOTS.2774
C  Restore original viewport                                                     PLOTS.2775
                                                                                 PLOTS.2776
        call set (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                  PLOTS.2777
      end if                                                                     PLOTS.2778
                                                                                 PLOTS.2779
C*****************************  subroutine end  ******************************C  PLOTS.2780
                                                                                 PLOTS.2781
      return                                                                     PLOTS.2782
      end                                                                        PLOTS.2783
      subroutine mpdrus                                                          PLOTS.2784
                                                                                 PLOTS.2785
C*****************************************************************************C  PLOTS.2786
C  mpdrus   - This is a MAPDRV routine                                        C  PLOTS.2787
C  Section  - Design                                                          C  PLOTS.2788
C  Purpose  - The default version of this routine does nothing.  It is called C  PLOTS.2789
C             just before any  drawing takes place so the user can reset some C  PLOTS.2790
C             things this way.                                                C  PLOTS.2791
C                                                                             C  PLOTS.2792
C  On entry - Nothing is input.                                               C  PLOTS.2793
C                                                                             C  PLOTS.2794
C  On exit  - Nothing is done.                                                C  PLOTS.2795
C                                                                             C  PLOTS.2796
C  Assume   - Nothing.                                                        C  PLOTS.2797
C                                                                             C  PLOTS.2798
C  Notes    - This is suppose to be a really well kept secret.                C  PLOTS.2799
C                                                                             C  PLOTS.2800
C  Author   - Jeremy Asbill       Date - July 11, 1990       for the MM4 club C  PLOTS.2801
C*****************************************************************************C  PLOTS.2802
                                                                                 PLOTS.2803
C****************************  subroutine begin  *****************************C  PLOTS.2804
                                                                                 PLOTS.2805
C*****************************  subroutine end  ******************************C  PLOTS.2806
                                                                                 PLOTS.2807
      return                                                                     PLOTS.2808
      end                                                                        PLOTS.2809
      subroutine mrdclt (unum,llplc,wlabs,title,errsev,nomap)                    PLOTS.2810
                                                                                 PLOTS.2811
C*****************************************************************************C  PLOTS.2812
C  mrdclt   - This is a MAPDRV routine                                        C  PLOTS.2813
C  Section  - Tables                                                          C  PLOTS.2814
C  Purpose  - To read in the map color table and assign  the map color  indi- C  PLOTS.2815
C             cators appropriately.                                           C  PLOTS.2816
C                                                                             C  PLOTS.2817
C  On entry - UNUM  is the unit number  where to look for the  table.   LLPLC C  PLOTS.2818
C             is the lat/lon line details flag.   WLABS  is the label details C  PLOTS.2819
C             flag.   TITLE  is true if a title will be drawn and false if no C  PLOTS.2820
C             title will be drawn.   ERRSEV  indicates the severity  of error C  PLOTS.2821
C             that will cause execution to halt.   NOMAP  is  true  if a non- C  PLOTS.2822
C             correctible error has occured  and no map is to be drawn and is C  PLOTS.2823
C             false otherwise.                                                C  PLOTS.2824
C                                                                             C  PLOTS.2825
C  On exit  - The color indication variables in common blocks LLLCOL, LABCOL, C  PLOTS.2826
C             OUTCOL, and PERCOL have been assigned correctly.  NOMAP is true C  PLOTS.2827
C             if a  non-correctible  error has  occured  and no map  is to be C  PLOTS.2828
C             drawn and is false otherwise.                                   C  PLOTS.2829
C                                                                             C  PLOTS.2830
C  Assume   - Nothing.                                                        C  PLOTS.2831
C                                                                             C  PLOTS.2832
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2833
C             ----------------------------------------------------------------C  PLOTS.2834
C             TBLLOK              MAPDRV/CONDRV utility                       C  PLOTS.2835
C             CRDRCI              MAPDRV/CONDRV utility                       C  PLOTS.2836
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.2837
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.2838
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2839
C             ----------------------------------------------------------------C  PLOTS.2840
C             *NCAR Graphics Routine                                          C  PLOTS.2841
C                                                                             C  PLOTS.2842
C  Author   - Jeremy Asbill        Date - May 26, 1990       for the MM4 club C  PLOTS.2843
C*****************************************************************************C  PLOTS.2844
                                                                                 PLOTS.2845
C  Character variables                                                           PLOTS.2846
                                                                                 PLOTS.2847
      character*80     whline            ! line from map color table    (local)  PLOTS.2848
      character*60     p,                ! SEARCH error message string  (local)  PLOTS.2849
     *                 q,                ! NEXT error message string    (local)  PLOTS.2850
     *                 ermes             ! general error message string (local)  PLOTS.2851
      character*2      wouts             ! for common block MOCDET               PLOTS.2852
                                                                                 PLOTS.2853
C  Integer variables                                                             PLOTS.2854
                                                                                 PLOTS.2855
      integer          llplc,            ! where do we want lat/lon lines  (in)  PLOTS.2856
     *                 wlabs,            ! which labels do we want         (in)  PLOTS.2857
     *                 unum,             ! unit number of table file       (in)  PLOTS.2858
     *                 errsev            ! error severity indicator        (in)  PLOTS.2859
      integer          llcolr            ! for common block LLLCOL               PLOTS.2860
      integer          lacolr            ! for common block LABCOL               PLOTS.2861
      integer          tlcolr            ! for common block TITCOL               PLOTS.2862
      integer          cocolr,           ! for common block OUTCOL               PLOTS.2863
     *                 uscolr,           ! for common block OUTCOL               PLOTS.2864
     *                 cncolr            ! for common block OUTCOL               PLOTS.2865
      integer          pecolr            ! for common block PERCOL               PLOTS.2866
      integer          i                 ! loop counter/place keeper    (local)  PLOTS.2867
                                                                                 PLOTS.2868
C  Logical variables                                                             PLOTS.2869
                                                                                 PLOTS.2870
      logical          title,            ! put a title on the map ?        (in)  PLOTS.2871
     *                 nomap             ! don't draw a map ?              (in)  PLOTS.2872
      logical          error,            ! has an error occured ?       (local)  PLOTS.2873
     *                 found,            ! was the table found ?        (local)  PLOTS.2874
     *                 test              ! is this true ?               (local)  PLOTS.2875
                                                                                 PLOTS.2876
C  Common blocks                                                                 PLOTS.2877
                                                                                 PLOTS.2878
      common /lllcol/  llcolr            ! color of lat lon lines                PLOTS.2879
      common /labcol/  lacolr            ! color of labels                       PLOTS.2880
      common /titcol/  tlcolr            ! color of title                        PLOTS.2881
      common /outcol/  cocolr,           ! color of continents                   PLOTS.2882
     *                 uscolr,           ! color of states                       PLOTS.2883
     *                 cncolr            ! color of countries                    PLOTS.2884
      common /percol/  pecolr            ! color of perimeter                    PLOTS.2885
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.2886
                                                                                 PLOTS.2887
C****************************  subroutine begin  *****************************C  PLOTS.2888
                                                                                 PLOTS.2889
C  If no map is to be drawn skip this routine                                    PLOTS.2890
                                                                                 PLOTS.2891
      if (nomap) goto 150                                                        PLOTS.2892
                                                                                 PLOTS.2893
C  Initialize error flag                                                         PLOTS.2894
                                                                                 PLOTS.2895
      error = .false.                                                            PLOTS.2896
                                                                                 PLOTS.2897
C  Look for the table                                                            PLOTS.2898
                                                                                 PLOTS.2899
      call tbllok (unum,'MAP COLORS',errsev,found,whline,'MAPDRV')               PLOTS.2900
                                                                                 PLOTS.2901
C  Parse table only if it was found                                              PLOTS.2902
                                                                                 PLOTS.2903
      if (found) then                                                            PLOTS.2904
                                                                                 PLOTS.2905
C  Initialize the place keeper                                                   PLOTS.2906
                                                                                 PLOTS.2907
        i = 1                                                                    PLOTS.2908
                                                                                 PLOTS.2909
C  Set up the error messages for SEARCH and NEXT errors                          PLOTS.2910
                                                                                 PLOTS.2911
        p(1:23)  = 'Reading Colors Table,  '                                     PLOTS.2912
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.2913
        q(1:23)  = p(1:23)                                                       PLOTS.2914
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.2915
                                                                                 PLOTS.2916
C  First in line is the lat/lon line color index, LLCOLR                         PLOTS.2917
                                                                                 PLOTS.2918
        if (llplc .ne. 0) then                                                   PLOTS.2919
          call search (whline,i,error)                                           PLOTS.2920
          if (error)                                                             PLOTS.2921
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2922
        end if                                                                   PLOTS.2923
                                                                                 PLOTS.2924
        if (llplc .ne. 0) then                                                   PLOTS.2925
          test = .true.                                                          PLOTS.2926
        else                                                                     PLOTS.2927
          test = .false.                                                         PLOTS.2928
        end if                                                                   PLOTS.2929
        call crdrci (test,error,llcolr,1,whline,i,                               PLOTS.2930
     *               'Lat/Lon Grid Color Index',24,errsev,                       PLOTS.2931
     *               nomap,'MAPDRV')                                             PLOTS.2932
        if (nomap) goto 150                                                      PLOTS.2933
                                                                                 PLOTS.2934
        if ((llplc .ne. 0) .and. (.not. error)) then                             PLOTS.2935
          call next (whline,i,error)                                             PLOTS.2936
          if (error)                                                             PLOTS.2937
     *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.2938
        end if                                                                   PLOTS.2939
                                                                                 PLOTS.2940
C  Second in line is the labels color index, LACOLR                              PLOTS.2941
                                                                                 PLOTS.2942
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.2943
          call search (whline,i,error)                                           PLOTS.2944
          if (error)                                                             PLOTS.2945
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2946
        end if                                                                   PLOTS.2947
                                                                                 PLOTS.2948
        if (wlabs .ne. 0) then                                                   PLOTS.2949
          test = .true.                                                          PLOTS.2950
        else                                                                     PLOTS.2951
          test = .false.                                                         PLOTS.2952
        end if                                                                   PLOTS.2953
        call crdrci (test,error,lacolr,1,whline,i,                               PLOTS.2954
     *               'Label Color Index',17,errsev,                              PLOTS.2955
     *               nomap,'MAPDRV')                                             PLOTS.2956
        if (nomap) goto 150                                                      PLOTS.2957
                                                                                 PLOTS.2958
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.2959
          call next (whline,i,error)                                             PLOTS.2960
          if (error)                                                             PLOTS.2961
     *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.2962
        end if                                                                   PLOTS.2963
                                                                                 PLOTS.2964
C  Third in line is the title color index, TLCOLR                                PLOTS.2965
                                                                                 PLOTS.2966
        if ((title) .and. (.not. error)) then                                    PLOTS.2967
          call search (whline,i,error)                                           PLOTS.2968
          if (error)                                                             PLOTS.2969
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2970
        end if                                                                   PLOTS.2971
                                                                                 PLOTS.2972
        call crdrci (title,error,tlcolr,1,whline,i,                              PLOTS.2973
     *               'Title Color Index ',17,errsev,                             PLOTS.2974
     *               nomap,'MAPDRV')                                             PLOTS.2975
        if (nomap) goto 150                                                      PLOTS.2976
                                                                                 PLOTS.2977
        if ((title) .and. (.not. error)) then                                    PLOTS.2978
          call next (whline,i,error)                                             PLOTS.2979
          if (error)                                                             PLOTS.2980
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2981
        end if                                                                   PLOTS.2982
                                                                                 PLOTS.2983
C  Third in line is the U.S. States outline color index, USCOLR                  PLOTS.2984
                                                                                 PLOTS.2985
        if (((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) .and.           PLOTS.2986
     *      (.not. error)) then                                                  PLOTS.2987
          call search (whline,i,error)                                           PLOTS.2988
          if (error)                                                             PLOTS.2989
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2990
        end if                                                                   PLOTS.2991
                                                                                 PLOTS.2992
        if ((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) then             PLOTS.2993
          test = .true.                                                          PLOTS.2994
        else                                                                     PLOTS.2995
          test = .false.                                                         PLOTS.2996
        end if                                                                   PLOTS.2997
        call crdrci (test,error,uscolr,1,whline,i,                               PLOTS.2998
     *               'U.S. State Outline Color Index',30,errsev,                 PLOTS.2999
     *               nomap,'MAPDRV')                                             PLOTS.3000
        if (nomap) goto 150                                                      PLOTS.3001
                                                                                 PLOTS.3002
        if (((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) .and.           PLOTS.3003
     *      (.not. error)) then                                                  PLOTS.3004
          call next (whline,i,error)                                             PLOTS.3005
          if (error)                                                             PLOTS.3006
     *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3007
        end if                                                                   PLOTS.3008
                                                                                 PLOTS.3009
C  Fourth in line is the countries outline color index, CNCOLR                   PLOTS.3010
                                                                                 PLOTS.3011
        if ((wouts(1:1) .eq. 'P') .and. (.not. error)) then                      PLOTS.3012
          call search (whline,i,error)                                           PLOTS.3013
          if (error)                                                             PLOTS.3014
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3015
        end if                                                                   PLOTS.3016
                                                                                 PLOTS.3017
        if (wouts(1:1) .eq. 'P') then                                            PLOTS.3018
          test = .true.                                                          PLOTS.3019
        else                                                                     PLOTS.3020
          test = .false.                                                         PLOTS.3021
        end if                                                                   PLOTS.3022
        call crdrci (test,error,cncolr,1,whline,i,                               PLOTS.3023
     *               'Political Outline Color Index',29,errsev,                  PLOTS.3024
     *               nomap,'MAPDRV')                                             PLOTS.3025
        if (nomap) goto 150                                                      PLOTS.3026
                                                                                 PLOTS.3027
        if ((wouts(1:1) .eq. 'P') .and. (.not. error)) then                      PLOTS.3028
          call next (whline,i,error)                                             PLOTS.3029
          if (error)                                                             PLOTS.3030
     *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3031
        end if                                                                   PLOTS.3032
                                                                                 PLOTS.3033
C  Fifth in line is Continental outline color index, COCOLR                      PLOTS.3034
                                                                                 PLOTS.3035
        if (((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) .and.            PLOTS.3036
     *      (.not. error)) then                                                  PLOTS.3037
          call search (whline,i,error)                                           PLOTS.3038
          if (error)                                                             PLOTS.3039
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3040
        end if                                                                   PLOTS.3041
                                                                                 PLOTS.3042
        if  ((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) then             PLOTS.3043
          test = .true.                                                          PLOTS.3044
        else                                                                     PLOTS.3045
          test = .false.                                                         PLOTS.3046
        end if                                                                   PLOTS.3047
        call crdrci (test,error,cocolr,1,whline,i,                               PLOTS.3048
     *               'Continental Outline Color Index',31,errsev,                PLOTS.3049
     *               nomap,'MAPDRV')                                             PLOTS.3050
        if (nomap) goto 150                                                      PLOTS.3051
                                                                                 PLOTS.3052
        if (((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) .and.            PLOTS.3053
     *      (.not. error)) then                                                  PLOTS.3054
          call next (whline,i,error)                                             PLOTS.3055
          if (error)                                                             PLOTS.3056
     *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3057
        end if                                                                   PLOTS.3058
                                                                                 PLOTS.3059
C  Sixth in line is the perimeter color index, PECOLR                            PLOTS.3060
                                                                                 PLOTS.3061
        if (.not. error) then                                                    PLOTS.3062
          call search (whline,i,error)                                           PLOTS.3063
          if (error)                                                             PLOTS.3064
     *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3065
        end if                                                                   PLOTS.3066
                                                                                 PLOTS.3067
        call crdrci (.true.,error,pecolr,1,whline,i,                             PLOTS.3068
     *               'Perimeter Color Index',21,errsev,                          PLOTS.3069
     *               nomap,'MAPDRV')                                             PLOTS.3070
        if (nomap) goto 150                                                      PLOTS.3071
                                                                                 PLOTS.3072
        if (.not. error) then                                                    PLOTS.3073
          call next (whline,i,error)                                             PLOTS.3074
          if (error)                                                             PLOTS.3075
     *      call errhan ('MAPDRV',0,q,errsev)                                    PLOTS.3076
        end if                                                                   PLOTS.3077
                                                                                 PLOTS.3078
C  Check to see if there were too many entries in the table                      PLOTS.3079
                                                                                 PLOTS.3080
        if (.not. error) then                                                    PLOTS.3081
          call search (whline,i,error)                                           PLOTS.3082
          if (.not. error) then                                                  PLOTS.3083
            ermes(1:24)  = 'Reading Colors Table, To'                            PLOTS.3084
            ermes(25:50) = 'o Many Entries On Line    '                          PLOTS.3085
            ermes(51:60) = '          '                                          PLOTS.3086
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3087
          end if                                                                 PLOTS.3088
        end if                                                                   PLOTS.3089
                                                                                 PLOTS.3090
C  Inform the user that things are at least okay                                 PLOTS.3091
                                                                                 PLOTS.3092
C       print *, 'MAPDRV - Map Colors Set Up'                                    06NOV00.132
      else                                                                       PLOTS.3094
                                                                                 PLOTS.3095
C  The table was not found, assign the defaults                                  PLOTS.3096
                                                                                 PLOTS.3097
C       print *, 'MAPDRV - Default Map Colors Used'                              06NOV00.133
        llcolr = 1                                                               PLOTS.3099
        tlcolr = 1                                                               PLOTS.3100
        lacolr = 1                                                               PLOTS.3101
        uscolr = 1                                                               PLOTS.3102
        cncolr = 1                                                               PLOTS.3103
        cocolr = 1                                                               PLOTS.3104
        pecolr = 1                                                               PLOTS.3105
        goto 150                                                                 PLOTS.3106
      end if                                                                     PLOTS.3107
                                                                                 PLOTS.3108
                                                                                 PLOTS.3109
C*****************************  subroutine end  ******************************C  PLOTS.3110
                                                                                 PLOTS.3111
C  Format statements begin ...                                                   PLOTS.3112
                                                                                 PLOTS.3113
30    format (I2)                                                                PLOTS.3114
40    format (I1)                                                                PLOTS.3115
                                                                                 PLOTS.3116
C  Format statements end.                                                        PLOTS.3117
                                                                                 PLOTS.3118
150   return                                                                     PLOTS.3119
      end                                                                        PLOTS.3120
      subroutine mrddet (unum,buff,ollplc,owlabs,title,perm,errsev,              PLOTS.3121
     *                   nomap)                                                  PLOTS.3122
                                                                                 PLOTS.3123
C*****************************************************************************C  PLOTS.3124
C  mrddet   - This is a MAPDRV routine                                        C  PLOTS.3125
C  Section  - Tables                                                          C  PLOTS.3126
C  Purpose  - This routine reads in  the map detail table and assigns the map C  PLOTS.3127
C             detail indicators appropriately.                                C  PLOTS.3128
C                                                                             C  PLOTS.3129
C  On entry - UNUM  is the unit number of the table file.   ERRSEV  indicates C  PLOTS.3130
C             the error severity at which execution should be halted.   NOMAP C  PLOTS.3131
C             is true if a non-correctable error has occured and no map is to C  PLOTS.3132
C             be made and is false otherwise.                                 C  PLOTS.3133
C                                                                             C  PLOTS.3134
C  On exit  - The information  variables in  common  blocks  MOCDET,  MOTDET, C  PLOTS.3135
C             LLLDET,  MLBDET, and MTLDET have been set up correctly.  OLLPLC C  PLOTS.3136
C             tells the driver where  to put lat/lon  lines, OWLABS tells the C  PLOTS.3137
C             driver what labels to use and TITLE tells the driver whether or C  PLOTS.3138
C             not a title is to be.  PERM is true if the perimeter with  tick C  PLOTS.3139
C             marks is to be drawn  and false if  the perimeter without  tick C  PLOTS.3140
C             marks should be drawn. NOMAP is true if a non-correctable error C  PLOTS.3141
C             has  occured and no map is to be made and is  false  otherwise. C  PLOTS.3142
C             If BUFF is negative special defaults are used.                  C  PLOTS.3143
C                                                                             C  PLOTS.3144
C  Assume   - Nothing.                                                        C  PLOTS.3145
C                                                                             C  PLOTS.3146
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.3147
C             ----------------------------------------------------------------C  PLOTS.3148
C             TBLLOK              MAPDRV/CONDRV utility                       C  PLOTS.3149
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.3150
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.3151
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.3152
C             GTREAL              MAPDRV/CONDRV utility                       C  PLOTS.3153
C             ----------------------------------------------------------------C  PLOTS.3154
C                                                                             C  PLOTS.3155
C  Author   - Jeremy Asbill       Date - May 27, 1990        for the MM4 club C  PLOTS.3156
C*****************************************************************************C  PLOTS.3157
                                                                                 PLOTS.3158
C  Parameters                                                                    PLOTS.3159
                                                                                 PLOTS.3160
      parameter        (scale = 20.0)    ! scales LBSIZ and TLSIZ                PLOTS.3161
                                                                                 PLOTS.3162
C  Character variables                                                           PLOTS.3163
                                                                                 PLOTS.3164
      character*2      wouts             ! for common block MOCDET               PLOTS.3165
      character*80     whline            ! line of info. from table     (local)  PLOTS.3166
      character*60     p,                ! error message for SEARCH     (local)  PLOTS.3167
     *                 q,                ! error message for NEXT       (local)  PLOTS.3168
     *                 ermes             ! general error message        (local)  PLOTS.3169
      character*20     gstrng            ! temporary string             (local)  PLOTS.3170
                                                                                 PLOTS.3171
C  Integer variables                                                             PLOTS.3172
                                                                                 PLOTS.3173
      integer          unum,             ! unit number tables are on       (in)  PLOTS.3174
     *                 buff,             ! GFLASH buffer number            (in)  PLOTS.3175
     *                 errsev            ! error severity indicator        (in)  PLOTS.3176
      integer          ollplc,           ! out version of LLPLC           (out)  PLOTS.3177
     *                 owlabs            ! out version of WLABS           (out)  PLOTS.3178
      integer          llplc,            ! for common block LLLDET               PLOTS.3179
     *                 grdsh,            ! for common block LLLDET               PLOTS.3180
     *                 llint             ! for common block LLLDET               PLOTS.3181
      integer          wlabs,            ! for common block MLBDET               PLOTS.3182
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.3183
      integer          tlqul(2)          ! for common block MTLDET               PLOTS.3184
      integer          maplw,            ! for common block MOTDET               PLOTS.3185
     *                 dtdsp             ! for common block MOTDET               PLOTS.3186
      integer          i,                ! loop counter/place keeper    (local)  PLOTS.3187
     *                 temp              ! temporary variable           (local)  PLOTS.3188
                                                                                 PLOTS.3189
C  Logical variables                                                             PLOTS.3190
                                                                                 PLOTS.3191
      logical          nomap             ! don't draw a map ?              (in)  PLOTS.3192
      logical          title,            ! draw a title to the map ?      (out)  PLOTS.3193
     *                 perm              ! draw a perimeter ?             (out)  PLOTS.3194
      logical          dtdmp             ! for common block MOTDET               PLOTS.3195
      logical          error,            ! has an error occurred ?      (local)  PLOTS.3196
     *                 found             ! is the table there ?         (local)  PLOTS.3197
                                                                                 PLOTS.3198
C  Real variables                                                                PLOTS.3199
                                                                                 PLOTS.3200
      real             lbsiz             ! for common block MLBDET               PLOTS.3201
      real             tlsiz             ! for common block MTLDET               PLOTS.3202
      real             dumy              ! dumy variable                (local)  PLOTS.3203
                                                                                 PLOTS.3204
C  Common blocks                                                                 PLOTS.3205
                                                                                 PLOTS.3206
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.3207
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.3208
     *                 llint             ! lat/lon grid interval in degrees      PLOTS.3209
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.3210
     *                 lbsiz,            ! alternate label size                  PLOTS.3211
     *                 lbqul             ! label quality                         PLOTS.3212
      common /mtldet/  tlsiz,            ! alternate title size                  PLOTS.3213
     *                 tlqul             ! title quality                         PLOTS.3214
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.3215
      common /motdet/  dtdmp,            ! T => draw the map with dots ?         PLOTS.3216
     *                 maplw,            ! line width for map outlines           PLOTS.3217
     *                 dtdsp             ! dash spacing for map outlines         PLOTS.3218
                                                                                 PLOTS.3219
C****************************  subroutine begin  *****************************C  PLOTS.3220
                                                                                 PLOTS.3221
C  Check if we need to do this                                                   PLOTS.3222
                                                                                 PLOTS.3223
      if (nomap) goto 250                                                        PLOTS.3224
                                                                                 PLOTS.3225
C  Initialize the error flag                                                     PLOTS.3226
                                                                                 PLOTS.3227
      error = .false.                                                            PLOTS.3228
                                                                                 PLOTS.3229
C  Look for the table                                                            PLOTS.3230
                                                                                 PLOTS.3231
      call tbllok (unum,'MAP DETAIL',errsev,found,whline,'MAPDRV')               PLOTS.3232
                                                                                 PLOTS.3233
C  Don't do reading if it wasn't there                                           PLOTS.3234
                                                                                 PLOTS.3235
      if ((found) .and. (buff .ge. 0)) then                                      PLOTS.3236
                                                                                 PLOTS.3237
C  Initialize the place keeper                                                   PLOTS.3238
                                                                                 PLOTS.3239
        i = 1                                                                    PLOTS.3240
                                                                                 PLOTS.3241
C  Set up the error messages for SEARCH and NEXT errors                          PLOTS.3242
                                                                                 PLOTS.3243
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.3244
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.3245
        q(1:23)  = p(1:23)                                                       PLOTS.3246
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.3247
                                                                                 PLOTS.3248
C  Parse the line starting with lat/lon grid information                         PLOTS.3249
C  First is LLPLC which may be                                                   PLOTS.3250
C    L                => LLPLC = 1  ; or over land only                          PLOTS.3251
C    W                => LLPLC = -1 ; or over water only                         PLOTS.3252
C    N                => LLPLC = 0  ; or no lat/lon lines                        PLOTS.3253
C    D,A,E            => LLPLC = 2  ; or over both land and water                PLOTS.3254
                                                                                 PLOTS.3255
        call search (whline,i,error)                                             PLOTS.3256
        if (error) then                                                          PLOTS.3257
          call errhan ('MAPDRV',1,p,errsev)                                      PLOTS.3258
          llplc      = 2                                                         PLOTS.3259
          grdsh      = 21845                                                     PLOTS.3260
          llint      = 0                                                         PLOTS.3261
          wlabs      = 2                                                         PLOTS.3262
          lbsiz      = 0.4                                                       PLOTS.3263
          lbqul(1)   = 0                                                         PLOTS.3264
          lbqul(2)   = 0                                                         PLOTS.3265
          tlsiz      = 0.6                                                       PLOTS.3266
          tlqul(1)   = 0                                                         PLOTS.3267
          tlqul(2)   = 0                                                         PLOTS.3268
          wouts(1:2) = 'PS'                                                      PLOTS.3269
          dtdmp      = .false.                                                   PLOTS.3270
          maplw      = 1000                                                      PLOTS.3271
          dtdsp      = 0                                                         PLOTS.3272
          perm       = .true.                                                    PLOTS.3273
        end if                                                                   PLOTS.3274
                                                                                 PLOTS.3275
        if (.not. error) then                                                    PLOTS.3276
          if ((whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.3277
            llplc = 1                                                            PLOTS.3278
          else if ((whline(i:i) .eq. 'W') .or.                                   PLOTS.3279
     *             (whline(i:i) .eq. 'w')) then                                  PLOTS.3280
            llplc = -1                                                           PLOTS.3281
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3282
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3283
            llplc = 0                                                            PLOTS.3284
          else if ((whline(i:i) .eq. 'D') .or.                                   PLOTS.3285
     *             (whline(i:i) .eq. 'd') .or.                                   PLOTS.3286
     *             (whline(i:i) .eq. 'E') .or.                                   PLOTS.3287
     *             (whline(i:i) .eq. 'e') .or.                                   PLOTS.3288
     *             (whline(i:i) .eq. 'A') .or.                                   PLOTS.3289
     *             (whline(i:i) .eq. 'a')) then                                  PLOTS.3290
            llplc = 2                                                            PLOTS.3291
          else                                                                   PLOTS.3292
            ermes(1:19)  = 'Lat/Lon Grid Flag, '                                 PLOTS.3293
            ermes(20:20) = whline(i:i)                                           PLOTS.3294
            ermes(21:60) = ', Unknown, Default Used                 '            PLOTS.3295
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3296
            llplc = 2                                                            PLOTS.3297
          end if                                                                 PLOTS.3298
          call next (whline,i,error)                                             PLOTS.3299
          if (error) then                                                        PLOTS.3300
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3301
            if (llplc .ne. 0) then                                               PLOTS.3302
              grdsh    = 21845                                                   PLOTS.3303
            else                                                                 PLOTS.3304
              grdsh    = 0                                                       PLOTS.3305
            end if                                                               PLOTS.3306
            llint      = 0                                                       PLOTS.3307
            wlabs      = 2                                                       PLOTS.3308
            lbsiz      = 0.4                                                     PLOTS.3309
            lbqul(1)   = 0                                                       PLOTS.3310
            lbqul(2)   = 0                                                       PLOTS.3311
            tlsiz      = 0.6                                                     PLOTS.3312
            tlqul(1)   = 0                                                       PLOTS.3313
            tlqul(2)   = 0                                                       PLOTS.3314
            wouts(1:2) = 'PS'                                                    PLOTS.3315
            dtdmp      = .false.                                                 PLOTS.3316
            maplw      = 1000                                                    PLOTS.3317
            dtdsp      = 0                                                       PLOTS.3318
            perm       = .true.                                                  PLOTS.3319
          end if                                                                 PLOTS.3320
        end if                                                                   PLOTS.3321
                                                                                 PLOTS.3322
C  Second is the lat/lon grid dash pattern, or GRDSH which may be                PLOTS.3323
C    L  => GRDSH = 255   ; or 0000000011111111 ; or Large                        PLOTS.3324
C    M  => GRDSH = 3855  ; or 0000111100001111 ; or Medium                       PLOTS.3325
C    SM => GRDSH = 13107 ; or 0011001100110011 ; or SMall                        PLOTS.3326
C    T  => GRDSH = 21845 ; or 0101010101010101 ; or Tiny                         PLOTS.3327
C    SO => GRDSH = -1    ; or 1111111111111111 ; or SOlid                        PLOTS.3328
C    P  => GRDSH = 0     ; or publication style                                  PLOTS.3329
C    D  => GRDSH = 21845 ; or 0101010101010101 ; or Default                      PLOTS.3330
                                                                                 PLOTS.3331
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3332
          call search (whline,i,error)                                           PLOTS.3333
          if (error) then                                                        PLOTS.3334
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3335
            if (llplc .ne. 0) then                                               PLOTS.3336
              grdsh    = 21845                                                   PLOTS.3337
            else                                                                 PLOTS.3338
              grdsh    = 0                                                       PLOTS.3339
            end if                                                               PLOTS.3340
            llint      = 0                                                       PLOTS.3341
            wlabs      = 2                                                       PLOTS.3342
            lbsiz      = 0.4                                                     PLOTS.3343
            lbqul(1)   = 0                                                       PLOTS.3344
            lbqul(2)   = 0                                                       PLOTS.3345
            tlsiz      = 0.6                                                     PLOTS.3346
            tlqul(1)   = 0                                                       PLOTS.3347
            tlqul(2)   = 0                                                       PLOTS.3348
            wouts(1:2) = 'PS'                                                    PLOTS.3349
            dtdmp      = .false.                                                 PLOTS.3350
            maplw      = 1000                                                    PLOTS.3351
            dtdsp      = 0                                                       PLOTS.3352
            perm       = .true.                                                  PLOTS.3353
          end if                                                                 PLOTS.3354
        end if                                                                   PLOTS.3355
                                                                                 PLOTS.3356
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3357
          if ((whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.3358
            grdsh = 255                                                          PLOTS.3359
          else if ((whline(i:i) .eq. 'M') .or.                                   PLOTS.3360
     *             (whline(i:i) .eq. 'm')) then                                  PLOTS.3361
            grdsh = 3855                                                         PLOTS.3362
          else if ((whline(i:i+1) .eq. 'SM') .or.                                PLOTS.3363
     *             (whline(i:i+1) .eq. 'sm') .or.                                PLOTS.3364
     *             (whline(i:i+1) .eq. 'Sm') .or.                                PLOTS.3365
     *             (whline(i:i+1) .eq. 'sM')) then                               PLOTS.3366
            grdsh = 13107                                                        PLOTS.3367
          else if ((whline(i:i) .eq. 'T') .or.                                   PLOTS.3368
     *             (whline(i:i) .eq. 't') .or.                                   PLOTS.3369
     *             (whline(i:i) .eq. 'D') .or.                                   PLOTS.3370
     *             (whline(i:i) .eq. 'd')) then                                  PLOTS.3371
            grdsh = 21845                                                        PLOTS.3372
          else if ((whline(i:i+1) .eq. 'SO') .or.                                PLOTS.3373
     *             (whline(i:i+1) .eq. 'so') .or.                                PLOTS.3374
     *             (whline(i:i+1) .eq. 'So') .or.                                PLOTS.3375
     *             (whline(i:i+1) .eq. 'sO')) then                               PLOTS.3376
            grdsh = -1                                                           PLOTS.3377
          else if ((whline(i:i) .eq. 'P') .or.                                   PLOTS.3378
     *             (whline(i:i) .eq. 'p')) then                                  PLOTS.3379
            grdsh = 0                                                            PLOTS.3380
            if (llplc .ne. 2) then                                               PLOTS.3381
              ermes(1:31)  = 'Publication Style Lat/Lon Grids'                   PLOTS.3382
              ermes(32:60) = ' Are Plotted Over Land & Water'                    PLOTS.3383
              call errhan ('MAPDRV',0,ermes,errsev)                              06NOV00.134
              llplc = 2                                                          PLOTS.3385
            end if                                                               PLOTS.3386
          else                                                                   PLOTS.3387
            ermes(1:27)  = 'Lat/Lon Grid Dash Pattern, '                         PLOTS.3388
            ermes(28:29) = whline(i:i+1)                                         PLOTS.3389
            ermes(30:60) = ', Unknown, Default Uesd        '                     PLOTS.3390
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3391
            grdsh = 21845                                                        PLOTS.3392
          end if                                                                 PLOTS.3393
          call next (whline,i,error)                                             PLOTS.3394
          if (error) then                                                        PLOTS.3395
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3396
            llint      = 0                                                       PLOTS.3397
            wlabs      = 2                                                       PLOTS.3398
            lbsiz      = 0.4                                                     PLOTS.3399
            lbqul(1)   = 0                                                       PLOTS.3400
            lbqul(2)   = 0                                                       PLOTS.3401
            tlsiz      = 0.6                                                     PLOTS.3402
            tlqul(1)   = 0                                                       PLOTS.3403
            tlqul(2)   = 0                                                       PLOTS.3404
            wouts(1:2) = 'PS'                                                    PLOTS.3405
            dtdmp      = .false.                                                 PLOTS.3406
            maplw      = 1000                                                    PLOTS.3407
            dtdsp      = 0                                                       PLOTS.3408
            perm       = .true.                                                  PLOTS.3409
          end if                                                                 PLOTS.3410
        end if                                                                   PLOTS.3411
                                                                                 PLOTS.3412
C  Third is the lat/lon grid interval, or LLINT                                  PLOTS.3413
                                                                                 PLOTS.3414
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3415
          call search (whline,i,error)                                           PLOTS.3416
          if (error) then                                                        PLOTS.3417
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3418
            llint      = 0                                                       PLOTS.3419
            wlabs      = 2                                                       PLOTS.3420
            lbsiz      = 0.4                                                     PLOTS.3421
            lbqul(1)   = 0                                                       PLOTS.3422
            lbqul(2)   = 0                                                       PLOTS.3423
            tlsiz      = 0.6                                                     PLOTS.3424
            tlqul(1)   = 0                                                       PLOTS.3425
            tlqul(2)   = 0                                                       PLOTS.3426
            wouts(1:2) = 'PS'                                                    PLOTS.3427
            dtdmp      = .false.                                                 PLOTS.3428
            maplw      = 1000                                                    PLOTS.3429
            dtdsp      = 0                                                       PLOTS.3430
            perm       = .true.                                                  PLOTS.3431
          end if                                                                 PLOTS.3432
        end if                                                                   PLOTS.3433
                                                                                 PLOTS.3434
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3435
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3436
            llint = 0                                                            PLOTS.3437
          else                                                                   PLOTS.3438
            if ((whline(i+1:i+1) .ne. ' ') .and.                                 PLOTS.3439
     *          (whline(i+1:i+1) .ne. '|')) then                                 PLOTS.3440
              read (whline(i:i+1),50,err=110) llint                              PLOTS.3441
            else                                                                 PLOTS.3442
              read (whline(i:i),30,err=110) llint                                PLOTS.3443
            end if                                                               PLOTS.3444
          end if                                                                 PLOTS.3445
          call next (whline,i,error)                                             PLOTS.3446
          if (error) then                                                        PLOTS.3447
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3448
            wlabs      = 2                                                       PLOTS.3449
            lbsiz      = 0.4                                                     PLOTS.3450
            lbqul(1)   = 0                                                       PLOTS.3451
            lbqul(2)   = 0                                                       PLOTS.3452
            tlsiz      = 0.6                                                     PLOTS.3453
            tlqul(1)   = 0                                                       PLOTS.3454
            tlqul(2)   = 0                                                       PLOTS.3455
            wouts(1:2) = 'PS'                                                    PLOTS.3456
            dtdmp      = .false.                                                 PLOTS.3457
            maplw      = 1000                                                    PLOTS.3458
            dtdsp      = 0                                                       PLOTS.3459
            perm       = .true.                                                  PLOTS.3460
          end if                                                                 PLOTS.3461
        end if                                                                   PLOTS.3462
                                                                                 PLOTS.3463
C  Set up GRDSH and LLINT to be clean if no grid is desired                      PLOTS.3464
                                                                                 PLOTS.3465
        if ((llplc .eq. 0) .and. (.not. error)) then                             PLOTS.3466
          grdsh = 0                                                              PLOTS.3467
          llint = 0                                                              PLOTS.3468
        end if                                                                   PLOTS.3469
                                                                                 PLOTS.3470
C  Read in label information                                                     PLOTS.3471
C  First is WLABS, which can be                                                  PLOTS.3472
C    E                => WLABS = -1 ; or only EZMAP labels                       PLOTS.3473
C    M                => WLABS = 1  ; or only MAPDRV labels                      PLOTS.3474
C    N                => WLABS = 0  ; or no labels at all                        PLOTS.3475
C    D,A              => WLABS = 2  ; or both EZMAP and MAPDRV labels            PLOTS.3476
                                                                                 PLOTS.3477
        if (.not. error) then                                                    PLOTS.3478
          call search (whline,i,error)                                           PLOTS.3479
          if (error) then                                                        PLOTS.3480
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3481
            wlabs      = 2                                                       PLOTS.3482
            lbsiz      = 0.4                                                     PLOTS.3483
            lbqul(1)   = 0                                                       PLOTS.3484
            lbqul(2)   = 0                                                       PLOTS.3485
            tlsiz      = 0.6                                                     PLOTS.3486
            tlqul(1)   = 0                                                       PLOTS.3487
            tlqul(2)   = 0                                                       PLOTS.3488
            wouts(1:2) = 'PS'                                                    PLOTS.3489
            dtdmp      = .false.                                                 PLOTS.3490
            maplw      = 1000                                                    PLOTS.3491
            dtdsp      = 0                                                       PLOTS.3492
            perm       = .true.                                                  PLOTS.3493
          end if                                                                 PLOTS.3494
        end if                                                                   PLOTS.3495
                                                                                 PLOTS.3496
        if (.not. error) then                                                    PLOTS.3497
          if ((whline(i:i) .eq. 'E') .or.                                        PLOTS.3498
     *        (whline(i:i) .eq. 'e')) then                                       PLOTS.3499
            wlabs = -1                                                           PLOTS.3500
          else if ((whline(i:i) .eq. 'M') .or.                                   PLOTS.3501
     *             (whline(i:i) .eq. 'm')) then                                  PLOTS.3502
            wlabs = 1                                                            PLOTS.3503
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3504
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3505
            wlabs = 0                                                            PLOTS.3506
          else if ((whline(i:i) .eq. 'A') .or.                                   PLOTS.3507
     *             (whline(i:i) .eq. 'a') .or.                                   PLOTS.3508
     *             (whline(i:i) .eq. 'D') .or.                                   PLOTS.3509
     *             (whline(i:i) .eq. 'd')) then                                  PLOTS.3510
            wlabs = 2                                                            PLOTS.3511
          else                                                                   PLOTS.3512
            ermes(1:12)  = 'Label Flag, '                                        PLOTS.3513
            ermes(13:13) = whline(i:i)                                           PLOTS.3514
            ermes(14:36) = ', Unknown, Default Used'                             PLOTS.3515
            ermes(37:60) = '                        '                            PLOTS.3516
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3517
            wlabs = 2                                                            PLOTS.3518
          end if                                                                 PLOTS.3519
          call next (whline,i,error)                                             PLOTS.3520
          if (error) then                                                        PLOTS.3521
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3522
            if (wlabs .ne. 0) then                                               PLOTS.3523
              lbsiz    = 0.4                                                     PLOTS.3524
            else                                                                 PLOTS.3525
              lbsiz    = 0.0                                                     PLOTS.3526
            end if                                                               PLOTS.3527
            lbqul(1)   = 0                                                       PLOTS.3528
            lbqul(2)   = 0                                                       PLOTS.3529
            tlsiz      = 0.6                                                     PLOTS.3530
            tlqul(1)   = 0                                                       PLOTS.3531
            tlqul(2)   = 0                                                       PLOTS.3532
            wouts(1:2) = 'PS'                                                    PLOTS.3533
            dtdmp      = .false.                                                 PLOTS.3534
            maplw      = 1000                                                    PLOTS.3535
            dtdsp      = 0                                                       PLOTS.3536
            perm       = .true.                                                  PLOTS.3537
          end if                                                                 PLOTS.3538
        end if                                                                   PLOTS.3539
                                                                                 PLOTS.3540
C  Second is LBSIZ, or the label size                                            PLOTS.3541
                                                                                 PLOTS.3542
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3543
          call search (whline,i,error)                                           PLOTS.3544
          if (error) then                                                        PLOTS.3545
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3546
            if (wlabs .ne. 0) then                                               PLOTS.3547
              lbsiz    = 0.4                                                     PLOTS.3548
            else                                                                 PLOTS.3549
              lbsiz    = 0.0                                                     PLOTS.3550
            end if                                                               PLOTS.3551
            lbqul(1)   = 0                                                       PLOTS.3552
            lbqul(2)   = 0                                                       PLOTS.3553
            tlsiz      = 0.6                                                     PLOTS.3554
            tlqul(1)   = 0                                                       PLOTS.3555
            tlqul(2)   = 0                                                       PLOTS.3556
            wouts(1:2) = 'PS'                                                    PLOTS.3557
            dtdmp      = .false.                                                 PLOTS.3558
            maplw      = 1000                                                    PLOTS.3559
            dtdsp      = 0                                                       PLOTS.3560
            perm       = .true.                                                  PLOTS.3561
          end if                                                                 PLOTS.3562
        end if                                                                   PLOTS.3563
                                                                                 PLOTS.3564
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3565
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3566
            lbsiz = 0.4                                                          PLOTS.3567
          else                                                                   PLOTS.3568
            if ((whline(i+1:i+1) .ne. ' ') .and.                                 PLOTS.3569
     *          (whline(i+1:i+1) .ne. '|')) then                                 PLOTS.3570
              read (whline(i:i+1),50,err=120) temp                               PLOTS.3571
            else                                                                 PLOTS.3572
              read (whline(i:i),30,err=120) temp                                 PLOTS.3573
            end if                                                               PLOTS.3574
                                                                                 PLOTS.3575
C  Label Size should not be less than 1 and should not be greater than           PLOTS.3576
C  25                                                                            PLOTS.3577
                                                                                 PLOTS.3578
            if (temp .lt. 1) then                                                PLOTS.3579
              ermes(1:30)  = 'Label Size Is Too Freaking Sma'                    PLOTS.3580
              ermes(31:60) = 'll, 1 Assumed                 '                    PLOTS.3581
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3582
              temp = 1                                                           PLOTS.3583
            end if                                                               PLOTS.3584
                                                                                 PLOTS.3585
            if (temp .gt. 25) then                                               PLOTS.3586
              ermes(1:30)  = 'Label Size Is Too Large, 25 As'                    PLOTS.3587
              ermes(31:60) = 'sumed                         '                    PLOTS.3588
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3589
              temp = 25                                                          PLOTS.3590
            end if                                                               PLOTS.3591
                                                                                 PLOTS.3592
            lbsiz = float(temp)/scale                                            PLOTS.3593
          end if                                                                 PLOTS.3594
          call next (whline,i,error)                                             PLOTS.3595
          if (error) then                                                        PLOTS.3596
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3597
            lbqul(1)   = 0                                                       PLOTS.3598
            lbqul(2)   = 0                                                       PLOTS.3599
            tlsiz      = 0.6                                                     PLOTS.3600
            tlqul(1)   = 0                                                       PLOTS.3601
            tlqul(2)   = 0                                                       PLOTS.3602
            wouts(1:2) = 'PS'                                                    PLOTS.3603
            dtdmp      = .false.                                                 PLOTS.3604
            maplw      = 1000                                                    PLOTS.3605
            dtdsp      = 0                                                       PLOTS.3606
            perm       = .true.                                                  PLOTS.3607
          end if                                                                 PLOTS.3608
        end if                                                                   PLOTS.3609
                                                                                 PLOTS.3610
C  Third in line is the label quality, LBQUL specified by to consecutive         PLOTS.3611
C  integers, combinations are                                                    PLOTS.3612
C  00 - Complex characters / High quality                                        PLOTS.3613
C  01 - Complex characters / Medium quality                                      PLOTS.3614
C  02 - Complex characters / Low quality                                         PLOTS.3615
C  10 - Duplex characters  / High quality                                        PLOTS.3616
C  11 - Duplex characters  / Medium quality                                      PLOTS.3617
C  12 - Duplex characters  / Low quality                                         PLOTS.3618
C  D  - Default = 11                                                             PLOTS.3619
                                                                                 PLOTS.3620
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3621
          call search (whline,i,error)                                           PLOTS.3622
          if (error) then                                                        PLOTS.3623
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3624
            lbqul(1)   = 0                                                       PLOTS.3625
            lbqul(2)   = 0                                                       PLOTS.3626
            tlsiz      = 0.6                                                     PLOTS.3627
            tlqul(1)   = 0                                                       PLOTS.3628
            tlqul(2)   = 0                                                       PLOTS.3629
            wouts(1:2) = 'PS'                                                    PLOTS.3630
            dtdmp      = .false.                                                 PLOTS.3631
            maplw      = 1000                                                    PLOTS.3632
            dtdsp      = 0                                                       PLOTS.3633
            perm       = .true.                                                  PLOTS.3634
          end if                                                                 PLOTS.3635
        end if                                                                   PLOTS.3636
                                                                                 PLOTS.3637
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3638
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3639
            lbqul(1) = 1                                                         PLOTS.3640
            lbqul(2) = 1                                                         PLOTS.3641
          else                                                                   PLOTS.3642
            read (whline(i:i),30,err=130)     lbqul(1)                           PLOTS.3643
            read (whline(i+1:i+1),30,err=130) lbqul(2)                           PLOTS.3644
          end if                                                                 PLOTS.3645
                                                                                 PLOTS.3646
C  If the specified qualities are none of the defined ones                       PLOTS.3647
C  give and error message                                                        PLOTS.3648
                                                                                 PLOTS.3649
          if ((lbqul(1) .ne. 0) .and. (lbqul(1) .ne. 1)) then                    PLOTS.3650
            ermes(1:40) = 'Text Type Specified For Labels Unknown, '             PLOTS.3651
            ermes(41:60) = '1 Used (Duplex)     '                                PLOTS.3652
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3653
            lbqul(1) = 1                                                         PLOTS.3654
          end if                                                                 PLOTS.3655
          if ((lbqul(2) .lt. 0) .or. (lbqul(2) .gt. 2)) then                     PLOTS.3656
            ermes(1:40) = 'Text Quality Specified For Labels Unknow'             PLOTS.3657
            ermes(41:60) = 'n, 1 Used (Medium)  '                                PLOTS.3658
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3659
            lbqul(2) = 1                                                         PLOTS.3660
          end if                                                                 PLOTS.3661
                                                                                 PLOTS.3662
          call next (whline,i,error)                                             PLOTS.3663
          if (error) then                                                        PLOTS.3664
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3665
            tlsiz      = 0.6                                                     PLOTS.3666
            tlqul(1)   = 0                                                       PLOTS.3667
            tlqul(2)   = 0                                                       PLOTS.3668
            wouts(1:2) = 'PS'                                                    PLOTS.3669
            dtdmp      = .false.                                                 PLOTS.3670
            maplw      = 1000                                                    PLOTS.3671
            dtdsp      = 0                                                       PLOTS.3672
            perm       = .true.                                                  PLOTS.3673
          end if                                                                 PLOTS.3674
        end if                                                                   PLOTS.3675
                                                                                 PLOTS.3676
C  Set up label info to be clean if none were requested                          PLOTS.3677
                                                                                 PLOTS.3678
        if ((wlabs .eq. 0) .and. (.not. error)) then                             PLOTS.3679
          lbsiz    = 0.0                                                         PLOTS.3680
          lbqul(1) = 1                                                           PLOTS.3681
          lbqul(2) = 1                                                           PLOTS.3682
        end if                                                                   PLOTS.3683
                                                                                 PLOTS.3684
C  Read in the perimeter flag, PERM                                              PLOTS.3685
C  N   => Draw a line perimeter                                                  PLOTS.3686
C  Y   => Draw a perimeter with ticks                                            PLOTS.3687
                                                                                 PLOTS.3688
        if (((.not. error) .and. (grdsh .ne. 0)) .or.                            PLOTS.3689
     *      (llplc .eq. 0)) then                                                 PLOTS.3690
          call search (whline,i,error)                                           PLOTS.3691
          if (error) then                                                        PLOTS.3692
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3693
            tlsiz      = 0.6                                                     PLOTS.3694
            tlqul(1)   = 0                                                       PLOTS.3695
            tlqul(2)   = 0                                                       PLOTS.3696
            wouts(1:2) = 'PS'                                                    PLOTS.3697
            dtdmp      = .false.                                                 PLOTS.3698
            maplw      = 1000                                                    PLOTS.3699
            dtdsp      = 0                                                       PLOTS.3700
            perm       = .true.                                                  PLOTS.3701
          end if                                                                 PLOTS.3702
        end if                                                                   PLOTS.3703
                                                                                 PLOTS.3704
        if (.not. error) then                                                    PLOTS.3705
          if ((grdsh .eq. 0) .and. (llplc .eq. 2)) then                          PLOTS.3706
            perm = .false.                                                       PLOTS.3707
          else                                                                   PLOTS.3708
            if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then         PLOTS.3709
              perm = .false.                                                     PLOTS.3710
            else if ((whline(i:i) .eq. 'Y') .or.                                 PLOTS.3711
     *               (whline(i:i) .eq. 'y')) then                                PLOTS.3712
              perm = .true.                                                      PLOTS.3713
            else                                                                 PLOTS.3714
              ermes(1:35)  = 'Perimeter Flag Can Only Be Y or N, '               PLOTS.3715
              ermes(36:60) = 'Y Assumed                '                         PLOTS.3716
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3717
              perm = .true.                                                      PLOTS.3718
            end if                                                               PLOTS.3719
            call next (whline,i,error)                                           PLOTS.3720
            if (error) then                                                      PLOTS.3721
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.3722
              tlsiz      = 0.6                                                   PLOTS.3723
              tlqul(1)   = 0                                                     PLOTS.3724
              tlqul(2)   = 0                                                     PLOTS.3725
              wouts(1:2) = 'PS'                                                  PLOTS.3726
              dtdmp      = .false.                                               PLOTS.3727
              maplw      = 1000                                                  PLOTS.3728
              dtdsp      = 0                                                     PLOTS.3729
            end if                                                               PLOTS.3730
          end if                                                                 PLOTS.3731
        end if                                                                   PLOTS.3732
                                                                                 PLOTS.3733
C  Read in title information                                                     PLOTS.3734
C  First is the title flag                                                       PLOTS.3735
C    Y                   => read in TLSIZ and TLQUL                              PLOTS.3736
C    N                   => skip to outlines                                     PLOTS.3737
                                                                                 PLOTS.3738
        if (.not. error) then                                                    PLOTS.3739
          call search (whline,i,error)                                           PLOTS.3740
          if (error) then                                                        PLOTS.3741
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3742
            tlsiz      = 0.6                                                     PLOTS.3743
            tlqul(1)   = 0                                                       PLOTS.3744
            tlqul(2)   = 0                                                       PLOTS.3745
            wouts(1:2) = 'PS'                                                    PLOTS.3746
            dtdmp      = .false.                                                 PLOTS.3747
            maplw      = 1000                                                    PLOTS.3748
            dtdsp      = 0                                                       PLOTS.3749
          end if                                                                 PLOTS.3750
        end if                                                                   PLOTS.3751
                                                                                 PLOTS.3752
        if (.not. error) then                                                    PLOTS.3753
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.3754
            title = .true.                                                       PLOTS.3755
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3756
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3757
            title    = .false.                                                   PLOTS.3758
            tlsiz    = 0.0                                                       PLOTS.3759
            tlqul(1) = 0                                                         PLOTS.3760
            tlqul(2) = 0                                                         PLOTS.3761
          else                                                                   PLOTS.3762
            ermes(1:31)  = 'Title Flag Can Only Be Y or N, '                     PLOTS.3763
            ermes(32:60) = 'Y Assumed                    '                       PLOTS.3764
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3765
            title = .true.                                                       PLOTS.3766
          end if                                                                 PLOTS.3767
          call next (whline,i,error)                                             PLOTS.3768
          if (error) then                                                        PLOTS.3769
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3770
            if (.not. title) then                                                PLOTS.3771
              tlsiz      = 0.0                                                   PLOTS.3772
            else                                                                 PLOTS.3773
              tlsiz      = 0.6                                                   PLOTS.3774
            end if                                                               PLOTS.3775
            tlqul(1)   = 0                                                       PLOTS.3776
            tlqul(2)   = 0                                                       PLOTS.3777
            wouts(1:2) = 'PS'                                                    PLOTS.3778
            dtdmp      = .false.                                                 PLOTS.3779
            maplw      = 1000                                                    PLOTS.3780
            dtdsp      = 0                                                       PLOTS.3781
          end if                                                                 PLOTS.3782
        end if                                                                   PLOTS.3783
                                                                                 PLOTS.3784
C  Read in TLSIZ                                                                 PLOTS.3785
                                                                                 PLOTS.3786
        if ((title) .and. (.not. error)) then                                    PLOTS.3787
          call search (whline,i,error)                                           PLOTS.3788
          if (error) then                                                        PLOTS.3789
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3790
            tlsiz      = 0.6                                                     PLOTS.3791
            tlqul(1)   = 0                                                       PLOTS.3792
            tlqul(2)   = 0                                                       PLOTS.3793
            wouts(1:2) = 'PS'                                                    PLOTS.3794
            dtdmp      = .false.                                                 PLOTS.3795
            maplw      = 1000                                                    PLOTS.3796
            dtdsp      = 0                                                       PLOTS.3797
          end if                                                                 PLOTS.3798
        end if                                                                   PLOTS.3799
                                                                                 PLOTS.3800
        if ((title) .and. (.not. error)) then                                    PLOTS.3801
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3802
            tlsiz = 0.6                                                          PLOTS.3803
          else                                                                   PLOTS.3804
            if ((whline(i+1:i+1) .ne. '|') .and.                                 PLOTS.3805
     *          (whline(i+1:i+1) .ne. ' ')) then                                 PLOTS.3806
              read (whline(i:i+1),50,err=140) temp                               PLOTS.3807
            else                                                                 PLOTS.3808
              read (whline(i:i),30,err=140) temp                                 PLOTS.3809
            end if                                                               PLOTS.3810
                                                                                 PLOTS.3811
C  Title size entered must be between 1 and 25                                   PLOTS.3812
                                                                                 PLOTS.3813
            if (temp .lt. 1) then                                                PLOTS.3814
              ermes(1:30)  = 'Title Size Is Too Freaking Sma'                    PLOTS.3815
              ermes(31:60) = 'll, 1 Assumed                 '                    PLOTS.3816
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3817
              temp = 1                                                           PLOTS.3818
            end if                                                               PLOTS.3819
                                                                                 PLOTS.3820
            if (temp .gt. 25) then                                               PLOTS.3821
              ermes(1:30)  = 'Title Size Is Too Large, 25 As'                    PLOTS.3822
              ermes(31:60) = 'sumed                         '                    PLOTS.3823
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3824
              temp = 25                                                          PLOTS.3825
            end if                                                               PLOTS.3826
                                                                                 PLOTS.3827
            tlsiz = float(temp)/scale                                            PLOTS.3828
          end if                                                                 PLOTS.3829
          call next (whline,i,error)                                             PLOTS.3830
          if (error) then                                                        PLOTS.3831
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3832
            tlqul(1)   = 0                                                       PLOTS.3833
            tlqul(2)   = 0                                                       PLOTS.3834
            wouts(1:2) = 'PS'                                                    PLOTS.3835
            dtdmp      = .false.                                                 PLOTS.3836
            maplw      = 1000                                                    PLOTS.3837
            dtdsp      = 0                                                       PLOTS.3838
          end if                                                                 PLOTS.3839
        end if                                                                   PLOTS.3840
                                                                                 PLOTS.3841
C  Read in TLQUL, which may be                                                   PLOTS.3842
C  00 - Complex characters / High quality                                        PLOTS.3843
C  01 - Complex characters / Medium quality                                      PLOTS.3844
C  02 - Complex characters / Low quality                                         PLOTS.3845
C  10 - Duplex characters  / High quality                                        PLOTS.3846
C  11 - Duplex characters  / Medium quality                                      PLOTS.3847
C  12 - Duplex characters  / Low quality                                         PLOTS.3848
C  D  - Default = 11                                                             PLOTS.3849
                                                                                 PLOTS.3850
        if ((title) .and. (.not. error)) then                                    PLOTS.3851
          call search (whline,i,error)                                           PLOTS.3852
          if (error) then                                                        PLOTS.3853
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3854
            tlqul(1)   = 0                                                       PLOTS.3855
            tlqul(2)   = 0                                                       PLOTS.3856
            wouts(1:2) = 'PS'                                                    PLOTS.3857
            dtdmp      = .false.                                                 PLOTS.3858
            maplw      = 1000                                                    PLOTS.3859
            dtdsp      = 0                                                       PLOTS.3860
          end if                                                                 PLOTS.3861
        end if                                                                   PLOTS.3862
                                                                                 PLOTS.3863
        if ((title) .and. (.not. error)) then                                    PLOTS.3864
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3865
            tlqul(1) = 1                                                         PLOTS.3866
            tlqul(2) = 1                                                         PLOTS.3867
          else                                                                   PLOTS.3868
            read (whline(i:i),30,err=150)     tlqul(1)                           PLOTS.3869
            read (whline(i+1:i+1),30,err=150) tlqul(2)                           PLOTS.3870
          end if                                                                 PLOTS.3871
                                                                                 PLOTS.3872
C  If the specified quality numbers are not defined, deliver an error message    PLOTS.3873
                                                                                 PLOTS.3874
          if ((tlqul(1) .ne. 0) .and. (tlqul(1) .ne. 1)) then                    PLOTS.3875
            ermes(1:40) = 'Text Type Specified For Title Unknown, 1'             PLOTS.3876
            ermes(41:60) = ' Used (Duplex)      '                                PLOTS.3877
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3878
            tlqul(1) = 1                                                         PLOTS.3879
          end if                                                                 PLOTS.3880
          if ((tlqul(2) .lt. 0) .or. (tlqul(2) .gt. 2)) then                     PLOTS.3881
            ermes(1:40) = 'Text Quality Specified For Title Unknown'             PLOTS.3882
            ermes(41:60) = ', 1 Used (Medium)   '                                PLOTS.3883
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3884
            tlqul(2) = 1                                                         PLOTS.3885
          end if                                                                 PLOTS.3886
                                                                                 PLOTS.3887
          call next (whline,i,error)                                             PLOTS.3888
          if (error) then                                                        PLOTS.3889
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3890
            wouts(1:2) = 'PS'                                                    PLOTS.3891
            dtdmp      = .false.                                                 PLOTS.3892
            maplw      = 1000                                                    PLOTS.3893
            dtdsp      = 0                                                       PLOTS.3894
          end if                                                                 PLOTS.3895
        end if                                                                   PLOTS.3896
                                                                                 PLOTS.3897
C  Read in outline information, or WOUTS, which can be                           PLOTS.3898
C    NO => no outlines                                                           PLOTS.3899
C    CO => continental outlines only                                             PLOTS.3900
C    US => U.S. State outlines only                                              PLOTS.3901
C    PS => Continental + International + State outlines                          PLOTS.3902
C    PO => Continental + International outlines                                  PLOTS.3903
                                                                                 PLOTS.3904
        if (.not. error) then                                                    PLOTS.3905
          call search (whline,i,error)                                           PLOTS.3906
          if (error) then                                                        PLOTS.3907
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3908
            wouts(1:2) = 'PS'                                                    PLOTS.3909
            dtdmp      = .false.                                                 PLOTS.3910
            maplw      = 1000                                                    PLOTS.3911
            dtdsp      = 0                                                       PLOTS.3912
          end if                                                                 PLOTS.3913
        end if                                                                   PLOTS.3914
                                                                                 PLOTS.3915
        if (.not. error) then                                                    PLOTS.3916
          wouts(1:2) = whline(i:i+1)                                             PLOTS.3917
                                                                                 PLOTS.3918
C  Make sure that WOUTS is given in all upper case                               PLOTS.3919
                                                                                 PLOTS.3920
          if ((ichar(wouts(1:1)) .le. ichar('z')) .and.                          PLOTS.3921
     *        (ichar(wouts(1:1)) .ge. ichar('a')))                               PLOTS.3922
     *      wouts(1:1) = char(ichar(wouts(1:1)) - 32)                            PLOTS.3923
          if ((ichar(wouts(2:2)) .le. ichar('z')) .and.                          PLOTS.3924
     *        (ichar(wouts(2:2)) .ge. ichar('a')))                               PLOTS.3925
     *      wouts(2:2) = char(ichar(wouts(2:2)) - 32)                            PLOTS.3926
                                                                                 PLOTS.3927
C  If WOUTS is not valid give an error                                           PLOTS.3928
                                                                                 PLOTS.3929
          if ((wouts(1:2) .ne. 'NO') .and.                                       PLOTS.3930
     *        (wouts(1:2) .ne. 'CO') .and.                                       PLOTS.3931
     *        (wouts(1:2) .ne. 'US') .and.                                       PLOTS.3932
     *        (wouts(1:2) .ne. 'PS') .and.                                       PLOTS.3933
     *        (wouts(1:2) .ne. 'PO')) then                                       PLOTS.3934
            ermes(1:32)  = 'Geographical Outline Specifier, '                    PLOTS.3935
            ermes(33:34) = wouts(1:2)                                            PLOTS.3936
            ermes(35:60) = ', Unknown, PS Used        '                          PLOTS.3937
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3938
            wouts(1:2) = 'PS'                                                    PLOTS.3939
          end if                                                                 PLOTS.3940
          call next (whline,i,error)                                             PLOTS.3941
          if (error) then                                                        PLOTS.3942
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3943
            dtdmp      = .false.                                                 PLOTS.3944
            maplw      = 1000                                                    PLOTS.3945
            dtdsp      = 0                                                       PLOTS.3946
          end if                                                                 PLOTS.3947
        end if                                                                   PLOTS.3948
                                                                                 PLOTS.3949
C  Read in outline details information                                           PLOTS.3950
C  First is the dotted outline flag, or DTDMP, which may be                      PLOTS.3951
C    Y                   => outlines are to be drawn with dots;                  PLOTS.3952
C                           read in the dot spacing                              PLOTS.3953
C    N                   => outlines are solid lines;                            PLOTS.3954
C                           read in the outline line width                       PLOTS.3955
                                                                                 PLOTS.3956
        if (wouts(1:2) .ne. 'NO') then                                           PLOTS.3957
          if (.not. error) then                                                  PLOTS.3958
            call search (whline,i,error)                                         PLOTS.3959
            if (error) then                                                      PLOTS.3960
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.3961
              dtdmp      = .false.                                               PLOTS.3962
              maplw      = 1000                                                  PLOTS.3963
              dtdsp      = 0                                                     PLOTS.3964
            end if                                                               PLOTS.3965
          end if                                                                 PLOTS.3966
                                                                                 PLOTS.3967
          if (.not. error) then                                                  PLOTS.3968
            if ((whline(i:i) .eq. 'y') .or. (whline(i:i) .eq. 'Y')) then         PLOTS.3969
              dtdmp = .true.                                                     PLOTS.3970
            else if ((whline(i:i) .eq. 'n') .or.                                 PLOTS.3971
     *               (whline(i:i) .eq. 'N')) then                                PLOTS.3972
              dtdmp = .false.                                                    PLOTS.3973
            else                                                                 PLOTS.3974
              ermes(1:40)  = 'Dotted Outline Flag Can Only Be Y or N, '          PLOTS.3975
              ermes(41:60) = 'N Assumed           '                              PLOTS.3976
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3977
              dtdmp = .false.                                                    PLOTS.3978
            end if                                                               PLOTS.3979
            call next (whline,i,error)                                           PLOTS.3980
            if (error) then                                                      PLOTS.3981
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.3982
              maplw      = 1000                                                  PLOTS.3983
              dtdsp      = 0                                                     PLOTS.3984
            end if                                                               PLOTS.3985
          end if                                                                 PLOTS.3986
                                                                                 PLOTS.3987
C  Advance to next entry                                                         PLOTS.3988
                                                                                 PLOTS.3989
          if (.not. error) then                                                  PLOTS.3990
            call search (whline,i,error)                                         PLOTS.3991
            if (error) then                                                      PLOTS.3992
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.3993
              maplw      = 1000                                                  PLOTS.3994
              dtdsp      = 0                                                     PLOTS.3995
            end if                                                               PLOTS.3996
          end if                                                                 PLOTS.3997
                                                                                 PLOTS.3998
          if ((dtdmp) .and. (.not. error)) then                                  PLOTS.3999
                                                                                 PLOTS.4000
C  Read in the dot spacing                                                       PLOTS.4001
                                                                                 PLOTS.4002
            if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then         PLOTS.4003
              dtdsp = 12                                                         PLOTS.4004
            else                                                                 PLOTS.4005
              if ((whline(i+1:i+1) .ne. ' ') .or.                                PLOTS.4006
     *            (whline(i+1:i+1) .ne. '|')) then                               PLOTS.4007
                read (whline(i:i+1),50,err=160) dtdsp                            PLOTS.4008
              else                                                               PLOTS.4009
                read (whline(i:i+1),30,err=160) dtdsp                            PLOTS.4010
              end if                                                             PLOTS.4011
            end if                                                               PLOTS.4012
            if (dtdsp .lt. 1) then                                               PLOTS.4013
              ermes(1:38)  = 'Dot Spacing Must Be At Least 1, Change'            PLOTS.4014
              ermes(39:60) = 'd To 1                '                            PLOTS.4015
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4016
              dtdsp = 1                                                          PLOTS.4017
            end if                                                               PLOTS.4018
            if (dtdsp .gt. 36) then                                              PLOTS.4019
              ermes(1:38)  = 'Dot Spacing Would Hardly Make A Map Re'            PLOTS.4020
              ermes(39:60) = 'set To 36             '                            PLOTS.4021
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4022
              dtdsp = 36                                                         PLOTS.4023
            end if                                                               PLOTS.4024
            maplw = 0                                                            PLOTS.4025
          else                                                                   PLOTS.4026
                                                                                 PLOTS.4027
C  Read in the outline line width                                                PLOTS.4028
                                                                                 PLOTS.4029
            if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then         PLOTS.4030
              maplw = 1000                                                       PLOTS.4031
            else                                                                 PLOTS.4032
              j = i                                                              PLOTS.4033
              call next (whline,i,error)                                         PLOTS.4034
              if (.not. error) then                                              PLOTS.4035
                gstrng(1:i-j) = whline(j:i-1)                                    PLOTS.4036
                do 260 k = i-j+1,20                                              PLOTS.4037
                  gstrng(k:k) = ' '                                              PLOTS.4038
260             continue                                                         PLOTS.4039
                call gtreal (gstrng,dumy,error)                                  PLOTS.4040
                if (error) then                                                  PLOTS.4041
                  ermes(1:30)  = 'Map Outline Line Width Input C'                PLOTS.4042
                  ermes(31:60) = 'onversion                     '                PLOTS.4043
                  call errhan ('MAPDRV',0,ermes,errsev)                          PLOTS.4044
                  maplw = 1000                                                   PLOTS.4045
                  error = .false.                                                PLOTS.4046
                else                                                             PLOTS.4047
                  maplw = nint(dumy * 1000)                                      PLOTS.4048
                end if                                                           PLOTS.4049
              else                                                               PLOTS.4050
                call errhan ('MAPDRV',0,q,errsev)                                PLOTS.4051
              end if                                                             PLOTS.4052
            end if                                                               PLOTS.4053
            dtdsp = 0                                                            PLOTS.4054
            if (maplw .lt. 1000) then                                            PLOTS.4055
              ermes(1:38)  = 'Line Widths Of Less Than 1000 Will Be '            PLOTS.4056
              ermes(39:60) = '1000                  '                            PLOTS.4057
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4058
              maplw = 1000                                                       PLOTS.4059
            end if                                                               PLOTS.4060
            if (maplw .gt. 10000) then                                           PLOTS.4061
              ermes(1:38)  = 'Line Widths Of Greater Than 10000 Will'            PLOTS.4062
              ermes(39:60) = ' Be 10000             '                            PLOTS.4063
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4064
              maplw = 10000                                                      PLOTS.4065
            end if                                                               PLOTS.4066
          end if                                                                 PLOTS.4067
        else                                                                     PLOTS.4068
          dtdmp      = .false.                                                   PLOTS.4069
          maplw      = 1000                                                      PLOTS.4070
          dtdsp      = 0                                                         PLOTS.4071
        end if                                                                   PLOTS.4072
                                                                                 PLOTS.4073
C  Warn user if errors exist                                                     PLOTS.4074
                                                                                 PLOTS.4075
        if (.not. error) then                                                    PLOTS.4076
          call next (whline,i,error)                                             PLOTS.4077
          if (error) then                                                        PLOTS.4078
            call errhan ('MAPDRV',0,q,errsev)                                    PLOTS.4079
          else                                                                   PLOTS.4080
            call search (whline,i,error)                                         PLOTS.4081
            if (.not. error) then                                                PLOTS.4082
              ermes(1:24)  = 'Too Many Entries On Line'                          PLOTS.4083
              ermes(25:50) = ' - Extras Ignored         '                        PLOTS.4084
              ermes(51:60) = '          '                                        PLOTS.4085
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4086
            end if                                                               PLOTS.4087
          end if                                                                 PLOTS.4088
        end if                                                                   PLOTS.4089
                                                                                 PLOTS.4090
C  Check for value errors                                                        PLOTS.4091
C  The lat/lon grid interval must be between 0 and 180                           PLOTS.4092
                                                                                 PLOTS.4093
        if ((llint .lt. 0) .or. (llint .gt. 180)) then                           PLOTS.4094
          ermes(1:30)  = 'Lat/Lon Grid Interval Invalid,'                        PLOTS.4095
          ermes(31:60) = ' Default Used                 '                        PLOTS.4096
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.4097
          llint = 0                                                              PLOTS.4098
        end if                                                                   PLOTS.4099
                                                                                 PLOTS.4100
        goto 70                                                                  PLOTS.4101
      else                                                                       PLOTS.4102
                                                                                 PLOTS.4103
        if (buff .ge. 0) then                                                    PLOTS.4104
                                                                                 PLOTS.4105
C  The table is not there so use the defaults                                    PLOTS.4106
                                                                                 PLOTS.4107
C         print *, 'MAPDRV - Defaults Used For Map Details'                      06NOV00.135
          error      = .false.                                                   PLOTS.4109
          llplc      = 2                                                         PLOTS.4110
          grdsh      = 21845                                                     PLOTS.4111
          llint      = 0                                                         PLOTS.4112
          wlabs      = 2                                                         PLOTS.4113
          lbsiz      = 0.4                                                       PLOTS.4114
          lbqul(1)   = 0                                                         PLOTS.4115
          lbqul(2)   = 0                                                         PLOTS.4116
          tlsiz      = 0.6                                                       PLOTS.4117
          tlqul(1)   = 0                                                         PLOTS.4118
          tlqul(2)   = 0                                                         PLOTS.4119
          wouts(1:2) = 'PS'                                                      PLOTS.4120
          dtdmp      = .false.                                                   PLOTS.4121
          maplw      = 1000                                                      PLOTS.4122
          dtdsp      = 0                                                         PLOTS.4123
        else                                                                     PLOTS.4124
                                                                                 PLOTS.4125
C  The table may or may not be there, but only an area map has been requested    PLOTS.4126
C  so special defaults are used                                                  PLOTS.4127
                                                                                 PLOTS.4128
C         print *, 'MAPDRV - Area Map Request Accepted'                          06NOV00.136
          error      = .false.                                                   PLOTS.4130
          llplc      = 0                                                         PLOTS.4131
          grdsh      = 0                                                         PLOTS.4132
          llint      = 0                                                         PLOTS.4133
          wlabs      = 0                                                         PLOTS.4134
          lbsiz      = 0.0                                                       PLOTS.4135
          lbqul(1)   = 0                                                         PLOTS.4136
          lbqul(2)   = 0                                                         PLOTS.4137
          tlsiz      = 0.0                                                       PLOTS.4138
          tlqul(1)   = 0                                                         PLOTS.4139
          tlqul(2)   = 0                                                         PLOTS.4140
          wouts(1:2) = 'CO'                                                      PLOTS.4141
          dtdmp      = .false.                                                   PLOTS.4142
          maplw      = 1000                                                      PLOTS.4143
          dtdsp      = 0                                                         PLOTS.4144
        end if                                                                   PLOTS.4145
        goto 90                                                                  PLOTS.4146
      end if                                                                     PLOTS.4147
                                                                                 PLOTS.4148
C  Handle mismatch errors                                                        PLOTS.4149
C  First are lat/lon gird interval mismatch errors                               PLOTS.4150
                                                                                 PLOTS.4151
110   ermes(1:37)  = 'Lat/Lon Grid Interval Type Mismatch  '                     PLOTS.4152
      ermes(38:60) = '                       '                                   PLOTS.4153
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4154
      llint      = 0                                                             PLOTS.4155
      wlabs      = 2                                                             PLOTS.4156
      lbsiz      = 0.4                                                           PLOTS.4157
      lbqul(1)   = 0                                                             PLOTS.4158
      lbqul(2)   = 0                                                             PLOTS.4159
      tlsiz      = 0.6                                                           PLOTS.4160
      tlqul(1)   = 0                                                             PLOTS.4161
      tlqul(2)   = 0                                                             PLOTS.4162
      wouts(1:2) = 'PS'                                                          PLOTS.4163
      dtdmp      = .false.                                                       PLOTS.4164
      maplw      = 1000                                                          PLOTS.4165
      dtdsp      = 0                                                             PLOTS.4166
      perm       = .true.                                                        PLOTS.4167
      goto 70                                                                    PLOTS.4168
                                                                                 PLOTS.4169
C  Second is the label size type mismatch                                        PLOTS.4170
                                                                                 PLOTS.4171
120   ermes(1:24)  = 'Label Size Type Mismatch'                                  PLOTS.4172
      ermes(25:60) = '                                    '                      PLOTS.4173
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4174
      lbsiz      = 0.4                                                           PLOTS.4175
      lbqul(1)   = 0                                                             PLOTS.4176
      lbqul(2)   = 0                                                             PLOTS.4177
      tlsiz      = 0.6                                                           PLOTS.4178
      tlqul(1)   = 0                                                             PLOTS.4179
      tlqul(2)   = 0                                                             PLOTS.4180
      wouts(1:2) = 'PS'                                                          PLOTS.4181
      dtdmp      = .false.                                                       PLOTS.4182
      maplw      = 1000                                                          PLOTS.4183
      dtdsp      = 0                                                             PLOTS.4184
      perm       = .true.                                                        PLOTS.4185
      goto 70                                                                    PLOTS.4186
                                                                                 PLOTS.4187
C  Third is label quality mismatch                                               PLOTS.4188
                                                                                 PLOTS.4189
130   ermes(1:27)  = 'Label Quality Type Mismatch'                               PLOTS.4190
      ermes(28:60) = '                                 '                         PLOTS.4191
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4192
      lbqul(1)   = 0                                                             PLOTS.4193
      lbqul(2)   = 0                                                             PLOTS.4194
      tlsiz      = 0.6                                                           PLOTS.4195
      tlqul(1)   = 0                                                             PLOTS.4196
      tlqul(2)   = 0                                                             PLOTS.4197
      wouts(1:2) = 'PS'                                                          PLOTS.4198
      dtdmp      = .false.                                                       PLOTS.4199
      maplw      = 1000                                                          PLOTS.4200
      dtdsp      = 0                                                             PLOTS.4201
      perm       = .true.                                                        PLOTS.4202
      goto 70                                                                    PLOTS.4203
                                                                                 PLOTS.4204
C  Fourth is the title size type mismatch                                        PLOTS.4205
                                                                                 PLOTS.4206
140   ermes(1:24)  = 'Title Size Type Mismatch'                                  PLOTS.4207
      ermes(25:60) = '                                    '                      PLOTS.4208
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4209
      tlsiz      = 0.6                                                           PLOTS.4210
      tlqul(1)   = 0                                                             PLOTS.4211
      tlqul(2)   = 0                                                             PLOTS.4212
      wouts(1:2) = 'PS'                                                          PLOTS.4213
      dtdmp      = .false.                                                       PLOTS.4214
      maplw      = 1000                                                          PLOTS.4215
      dtdsp      = 0                                                             PLOTS.4216
      goto 70                                                                    PLOTS.4217
                                                                                 PLOTS.4218
C  Fifth is the title quality type mismatch                                      PLOTS.4219
                                                                                 PLOTS.4220
150   ermes(1:27)  = 'Title Quality Type Mismatch'                               PLOTS.4221
      ermes(28:60) = '                                 '                         PLOTS.4222
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4223
      tlqul(1)   = 0                                                             PLOTS.4224
      tlqul(2)   = 0                                                             PLOTS.4225
      wouts(1:2) = 'PS'                                                          PLOTS.4226
      dtdmp      = .false.                                                       PLOTS.4227
      maplw      = 1000                                                          PLOTS.4228
      dtdsp      = 0                                                             PLOTS.4229
      goto 70                                                                    PLOTS.4230
                                                                                 PLOTS.4231
C  Sixth is the dot spacing type mismatch                                        PLOTS.4232
                                                                                 PLOTS.4233
160   ermes(1:25)  = 'Dot Spacing Type Mismatch'                                 PLOTS.4234
      ermes(26:60) = '                                   '                       PLOTS.4235
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4236
      dtdsp      = 12                                                            PLOTS.4237
      maplw      = 0                                                             PLOTS.4238
      goto 70                                                                    PLOTS.4239
                                                                                 PLOTS.4240
C  Last is the line width type mismatch                                          PLOTS.4241
                                                                                 PLOTS.4242
170   ermes(1:24)  = 'Line Width Type Mismatch'                                  PLOTS.4243
      ermes(25:60) = '                                    '                      PLOTS.4244
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4245
      dtdsp      = 0                                                             PLOTS.4246
      maplw      = 1000                                                          PLOTS.4247
                                                                                 PLOTS.4248
70    continue                                                                   06NOV00.137
C     print *, 'MAPDRV - Map Details Set Up'                                     06NOV00.138
90    owlabs = wlabs                                                             PLOTS.4250
      ollplc = llplc                                                             PLOTS.4251
                                                                                 PLOTS.4252
C*****************************  subroutine end  ******************************C  PLOTS.4253
                                                                                 PLOTS.4254
C  Format statements begin ...                                                   PLOTS.4255
                                                                                 PLOTS.4256
30    format (I1)                                                                PLOTS.4257
50    format (I2)                                                                PLOTS.4258
60    format (I4)                                                                PLOTS.4259
                                                                                 PLOTS.4260
C  Format statements end.                                                        PLOTS.4261
                                                                                 PLOTS.4262
250   return                                                                     PLOTS.4263
      end                                                                        PLOTS.4264
      subroutine mrdfil (unum,flmap,errsev,nomap)                                PLOTS.4265
                                                                                 PLOTS.4266
C*****************************************************************************C  PLOTS.4267
C  mrdfil   - This is a MAPDRV routine                                        C  PLOTS.4268
C  Section  - Tables                                                          C  PLOTS.4269
C  Purpose  - To read in the map fill table and assign the map fill colors.   C  PLOTS.4270
C                                                                             C  PLOTS.4271
C  On entry - UNUM  is the unit  number of the table file.   ERRSEV indicates C  PLOTS.4272
C             severity of a error which will cause execution to halt.   NOMAP C  PLOTS.4273
C             is true if a non-correctable  error has  occured and  is  false C  PLOTS.4274
C             otherwise.                                                      C  PLOTS.4275
C                                                                             C  PLOTS.4276
C  On exit  - FLMAP is true if the table  was there,  and is false otherwise. C  PLOTS.4277
C             The color indicies in common blocks FLINFO  and FLWATR have all C  PLOTS.4278
C             been set up correctly.  If a non-correctable error has  occrued C  PLOTS.4279
C             NOMAP is true and is false otherwise.                           C  PLOTS.4280
C                                                                             C  PLOTS.4281
C  Assume   - Nothing.                                                        C  PLOTS.4282
C                                                                             C  PLOTS.4283
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4284
C             ----------------------------------------------------------------C  PLOTS.4285
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.4286
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.4287
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.4288
C             ERRFIL              MAPDRV utility                              C  PLOTS.4289
C             CRDRCI              MAPDRV/CONDRV utility                       C  PLOTS.4290
C             ----------------------------------------------------------------C  PLOTS.4291
C                                                                             C  PLOTS.4292
C  Author   - Jeremy Asbill        Date - May 27, 1990       for the MM4 club C  PLOTS.4293
C*****************************************************************************C  PLOTS.4294
                                                                                 PLOTS.4295
C  Character variables                                                           PLOTS.4296
                                                                                 PLOTS.4297
      character*80     whline            ! line of info. from table     (local)  PLOTS.4298
      character*60     p,                ! error message for SEARCH     (local)  PLOTS.4299
     *                 q,                ! error message for NEXT       (local)  PLOTS.4300
     *                 ermes             ! general error message        (local)  PLOTS.4301
      character*2      wouts             ! for common block MOCDET               PLOTS.4302
                                                                                 PLOTS.4303
C  Integer variables                                                             PLOTS.4304
                                                                                 PLOTS.4305
      integer          unum,             ! unit number of table file       (in)  PLOTS.4306
     *                 errsev            ! error severity indicator        (in)  PLOTS.4307
      integer          fscolr,           ! for common block FLINFO               PLOTS.4308
     *                 secolr,           ! for common block FLINFO               PLOTS.4309
     *                 thcolr,           ! for common block FLINFO               PLOTS.4310
     *                 frcolr,           ! for common block FLINFO               PLOTS.4311
     *                 fvcolr,           ! for common block FLINFO               PLOTS.4312
     *                 sicolr            ! for common block FLINFO               PLOTS.4313
      integer          wacolr            ! for common block FLWATR               PLOTS.4314
      integer          i                 ! loop counter/place keeper    (local)  PLOTS.4315
                                                                                 PLOTS.4316
C  Logical variables                                                             PLOTS.4317
                                                                                 PLOTS.4318
      logical          flmap             ! color fill the map ?           (out)  PLOTS.4319
      logical          nomap,            ! don't draw a map ?           (local)  PLOTS.4320
     *                 error,            ! has an error occured ?       (local)  PLOTS.4321
     *                 found             ! was the table found ?        (local)  PLOTS.4322
                                                                                 PLOTS.4323
C  Common blocks                                                                 PLOTS.4324
                                                                                 PLOTS.4325
      common /flinfo/  fscolr,           ! first color                           PLOTS.4326
     *                 secolr,           ! second color                          PLOTS.4327
     *                 thcolr,           ! third color                           PLOTS.4328
     *                 frcolr,           ! fourth color                          PLOTS.4329
     *                 fvcolr,           ! fifth color                           PLOTS.4330
     *                 sicolr            ! sixth color                           PLOTS.4331
      common /flwatr/  wacolr            ! water color                           PLOTS.4332
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.4333
                                                                                 PLOTS.4334
C****************************  subroutine begin  *****************************C  PLOTS.4335
                                                                                 PLOTS.4336
C  Check to see if we need to do this                                            PLOTS.4337
                                                                                 PLOTS.4338
      if (nomap) goto 150                                                        PLOTS.4339
                                                                                 PLOTS.4340
C  Initialize the error flag                                                     PLOTS.4341
                                                                                 PLOTS.4342
      error = .false.                                                            PLOTS.4343
                                                                                 PLOTS.4344
C  Try to get the information line from the table                                PLOTS.4345
                                                                                 PLOTS.4346
      call tbllok (unum,'MAP FILL  ',errsev,found,whline,'MAPDRV')               PLOTS.4347
                                                                                 PLOTS.4348
C  Only parse the information if the table was found                             PLOTS.4349
                                                                                 PLOTS.4350
      if (found) then                                                            PLOTS.4351
                                                                                 PLOTS.4352
C  Assume since the table was there that the map will be filled                  PLOTS.4353
                                                                                 PLOTS.4354
        flmap = .true.                                                           PLOTS.4355
                                                                                 PLOTS.4356
C  Set up the SEARCH and NEXT messages                                           PLOTS.4357
                                                                                 PLOTS.4358
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.4359
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.4360
        q(1:23)  = p(1:23)                                                       PLOTS.4361
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.4362
                                                                                 PLOTS.4363
C  Initialize the place keepers                                                  PLOTS.4364
                                                                                 PLOTS.4365
        i = 1                                                                    PLOTS.4366
                                                                                 PLOTS.4367
C  First read in the water color index                                           PLOTS.4368
                                                                                 PLOTS.4369
        call search (whline,i,error)                                             PLOTS.4370
        if (error)                                                               PLOTS.4371
     *    call errhan ('MAPDRV',1,p,errsev)                                      PLOTS.4372
                                                                                 PLOTS.4373
        call crdrci (.true.,error,wacolr,1,whline,i,                             PLOTS.4374
     *               'Water Color Index',17,errsev,                              PLOTS.4375
     *               nomap,'MAPDRV')                                             PLOTS.4376
        if (error) call errfil (7)                                               PLOTS.4377
        if (nomap) goto 150                                                      PLOTS.4378
                                                                                 PLOTS.4379
        if (.not. error) then                                                    PLOTS.4380
          call next (whline,i,error)                                             PLOTS.4381
          if (error) then                                                        PLOTS.4382
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.4383
            call errfil (6)                                                      PLOTS.4384
          end if                                                                 PLOTS.4385
        end if                                                                   PLOTS.4386
                                                                                 PLOTS.4387
C  After the water color there are six more color indices to read in             PLOTS.4388
C  1                                                                             PLOTS.4389
                                                                                 PLOTS.4390
        if ((wouts(1:2) .ne. 'NO') .and. (.not. error)) then                     PLOTS.4391
          call search (whline,i,error)                                           PLOTS.4392
          if (error) then                                                        PLOTS.4393
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.4394
            call errfil (6)                                                      PLOTS.4395
          end if                                                                 PLOTS.4396
                                                                                 PLOTS.4397
          if (.not. error) then                                                  PLOTS.4398
            call crdrci (.true.,error,fscolr,1,whline,i,                         PLOTS.4399
     *                   'First Color Index',17,errsev,                          PLOTS.4400
     *                   nomap,'MAPDRV')                                         PLOTS.4401
            if (error) call errfil (6)                                           PLOTS.4402
            if (nomap) goto 150                                                  PLOTS.4403
          end if                                                                 PLOTS.4404
                                                                                 PLOTS.4405
          if (.not. error) then                                                  PLOTS.4406
            call next (whline,i,error)                                           PLOTS.4407
            if (error) then                                                      PLOTS.4408
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4409
              call errfil (5)                                                    PLOTS.4410
            end if                                                               PLOTS.4411
          end if                                                                 PLOTS.4412
                                                                                 PLOTS.4413
C  2                                                                             PLOTS.4414
                                                                                 PLOTS.4415
          if (.not. error) then                                                  PLOTS.4416
            call search (whline,i,error)                                         PLOTS.4417
            if (error) then                                                      PLOTS.4418
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4419
              call errfil (5)                                                    PLOTS.4420
            end if                                                               PLOTS.4421
          end if                                                                 PLOTS.4422
                                                                                 PLOTS.4423
          if (.not. error) then                                                  PLOTS.4424
            call crdrci (.true.,error,secolr,1,whline,i,                         PLOTS.4425
     *                   'Second Color Index',18,errsev,                         PLOTS.4426
     *                   nomap,'MAPDRV')                                         PLOTS.4427
            if (error) call errfil (5)                                           PLOTS.4428
            if (nomap) goto 150                                                  PLOTS.4429
          end if                                                                 PLOTS.4430
                                                                                 PLOTS.4431
          if (.not. error) then                                                  PLOTS.4432
            call next (whline,i,error)                                           PLOTS.4433
            if (error) then                                                      PLOTS.4434
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4435
              call errfil (4)                                                    PLOTS.4436
            end if                                                               PLOTS.4437
          end if                                                                 PLOTS.4438
                                                                                 PLOTS.4439
C  3                                                                             PLOTS.4440
                                                                                 PLOTS.4441
          if (.not. error) then                                                  PLOTS.4442
            call search (whline,i,error)                                         PLOTS.4443
            if (error) then                                                      PLOTS.4444
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4445
              call errfil (4)                                                    PLOTS.4446
            end if                                                               PLOTS.4447
          end if                                                                 PLOTS.4448
                                                                                 PLOTS.4449
          if (.not. error) then                                                  PLOTS.4450
            call crdrci (.true.,error,thcolr,1,whline,i,                         PLOTS.4451
     *                   'Third Color Index',17,errsev,                          PLOTS.4452
     *                   nomap,'MAPDRV')                                         PLOTS.4453
            if (error) call errfil (4)                                           PLOTS.4454
            if (nomap) goto 150                                                  PLOTS.4455
          end if                                                                 PLOTS.4456
                                                                                 PLOTS.4457
          if (.not. error) then                                                  PLOTS.4458
            call next (whline,i,error)                                           PLOTS.4459
            if (error) then                                                      PLOTS.4460
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4461
              call errfil (3)                                                    PLOTS.4462
            end if                                                               PLOTS.4463
          end if                                                                 PLOTS.4464
                                                                                 PLOTS.4465
C  4                                                                             PLOTS.4466
                                                                                 PLOTS.4467
          if (.not. error) then                                                  PLOTS.4468
            call search (whline,i,error)                                         PLOTS.4469
            if (error) then                                                      PLOTS.4470
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4471
              call errfil (3)                                                    PLOTS.4472
            end if                                                               PLOTS.4473
          end if                                                                 PLOTS.4474
                                                                                 PLOTS.4475
          if (.not. error) then                                                  PLOTS.4476
            call crdrci (.true.,error,frcolr,1,whline,i,                         PLOTS.4477
     *                   'Fourth Color Index',18,errsev,                         PLOTS.4478
     *                   nomap,'MAPDRV')                                         PLOTS.4479
            if (error) call errfil (3)                                           PLOTS.4480
            if (nomap) goto 150                                                  PLOTS.4481
          end if                                                                 PLOTS.4482
                                                                                 PLOTS.4483
          if (.not. error) then                                                  PLOTS.4484
            call next (whline,i,error)                                           PLOTS.4485
            if (error) then                                                      PLOTS.4486
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4487
              call errfil (2)                                                    PLOTS.4488
            end if                                                               PLOTS.4489
          end if                                                                 PLOTS.4490
                                                                                 PLOTS.4491
C  5                                                                             PLOTS.4492
                                                                                 PLOTS.4493
          if (.not. error) then                                                  PLOTS.4494
            call search (whline,i,error)                                         PLOTS.4495
            if (error) then                                                      PLOTS.4496
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4497
              call errfil (2)                                                    PLOTS.4498
            end if                                                               PLOTS.4499
          end if                                                                 PLOTS.4500
                                                                                 PLOTS.4501
          if (.not. error) then                                                  PLOTS.4502
            call crdrci (.true.,error,fvcolr,1,whline,i,                         PLOTS.4503
     *                   'Fifth Color Index',17,errsev,                          PLOTS.4504
     *                   nomap,'MAPDRV')                                         PLOTS.4505
            if (error) call errfil (2)                                           PLOTS.4506
            if (nomap) goto 150                                                  PLOTS.4507
          end if                                                                 PLOTS.4508
                                                                                 PLOTS.4509
          if (.not. error) then                                                  PLOTS.4510
            call next (whline,i,error)                                           PLOTS.4511
            if (error) then                                                      PLOTS.4512
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4513
              call errfil (1)                                                    PLOTS.4514
            end if                                                               PLOTS.4515
          end if                                                                 PLOTS.4516
                                                                                 PLOTS.4517
C  6                                                                             PLOTS.4518
                                                                                 PLOTS.4519
          if (.not. error) then                                                  PLOTS.4520
            call search (whline,i,error)                                         PLOTS.4521
            if (error) then                                                      PLOTS.4522
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4523
              call errfil (1)                                                    PLOTS.4524
            end if                                                               PLOTS.4525
          end if                                                                 PLOTS.4526
                                                                                 PLOTS.4527
          if (.not. error) then                                                  PLOTS.4528
            call crdrci (.true.,error,sicolr,1,whline,i,                         PLOTS.4529
     *                   'Sixth Color Index',17,errsev,                          PLOTS.4530
     *                   nomap,'MAPDRV')                                         PLOTS.4531
            if (error) call errfil (1)                                           PLOTS.4532
            if (nomap) goto 150                                                  PLOTS.4533
          end if                                                                 PLOTS.4534
                                                                                 PLOTS.4535
          if (.not. error) then                                                  PLOTS.4536
            call next (whline,i,error)                                           PLOTS.4537
            if (error) then                                                      PLOTS.4538
              call errhan ('MAPDRV',0,q,errsev)                                  PLOTS.4539
            end if                                                               PLOTS.4540
          end if                                                                 PLOTS.4541
        end if                                                                   PLOTS.4542
                                                                                 PLOTS.4543
C  Check to see if there were too many entries in the table                      PLOTS.4544
                                                                                 PLOTS.4545
        if (.not. error) then                                                    PLOTS.4546
          call search (whline,i,error)                                           PLOTS.4547
          if (.not. error) then                                                  PLOTS.4548
            ermes(1:24)  = 'Too Many Entries On Line'                            PLOTS.4549
            ermes(25:50) = ' - Extras Ignored         '                          PLOTS.4550
            ermes(51:60) = '          '                                          PLOTS.4551
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.4552
          end if                                                                 PLOTS.4553
        end if                                                                   PLOTS.4554
C       print *, 'MAPDRV - Map Fill Information Set Up'                          06NOV00.139
      else                                                                       PLOTS.4556
                                                                                 PLOTS.4557
C  The table was not there, no fill is to be done                                PLOTS.4558
                                                                                 PLOTS.4559
        flmap = .false.                                                          PLOTS.4560
        wacolr = 0                                                               PLOTS.4561
        fscolr = 0                                                               PLOTS.4562
        secolr = 0                                                               PLOTS.4563
        thcolr = 0                                                               PLOTS.4564
        frcolr = 0                                                               PLOTS.4565
        fvcolr = 0                                                               PLOTS.4566
        sicolr = 0                                                               PLOTS.4567
      end if                                                                     PLOTS.4568
                                                                                 PLOTS.4569
C*****************************  subroutine end  ******************************C  PLOTS.4570
                                                                                 PLOTS.4571
C  Format statements begin ...                                                   PLOTS.4572
                                                                                 PLOTS.4573
30    format (I1)                                                                PLOTS.4574
50    format (I2)                                                                PLOTS.4575
                                                                                 PLOTS.4576
C  Format statements end.                                                        PLOTS.4577
                                                                                 PLOTS.4578
150   return                                                                     PLOTS.4579
      end                                                                        PLOTS.4580
      subroutine next (whline,place,error)                                       PLOTS.4581
                                                                                 PLOTS.4582
C*****************************************************************************C  PLOTS.4583
C  next     - This is a CONDRV/MAPDRV routine                                 C  PLOTS.4584
C  Section  - Tables                                                          C  PLOTS.4585
C  Purpose  - To read to the next space or vertical bar in a table.           C  PLOTS.4586
C                                                                             C  PLOTS.4587
C  On entry - WHLINE contains a line (80 Characters) of a table.  PLACE  con- C  PLOTS.4588
C             tains the location in WHLINE to start looking.  ERROR comes  in C  PLOTS.4589
C             false.                                                          C  PLOTS.4590
C                                                                             C  PLOTS.4591
C  On exit  - PLACE contains the location of the the next space  or  vertical C  PLOTS.4592
C             bar in WHLINE and ERROR is true if the  search went  beyond  80 C  PLOTS.4593
C             characters and is false otherwise.                              C  PLOTS.4594
C                                                                             C  PLOTS.4595
C  Assume   - Nothing.                                                        C  PLOTS.4596
C                                                                             C  PLOTS.4597
C  Author   - Jeremy Asbill        Date - June 21, 1990      for the MM4 Club C  PLOTS.4598
C*****************************************************************************C  PLOTS.4599
                                                                                 PLOTS.4600
C  Character variables                                                           PLOTS.4601
                                                                                 PLOTS.4602
      character*80     whline            ! a line from current table       (in)  PLOTS.4603
                                                                                 PLOTS.4604
C  Integer variables                                                             PLOTS.4605
                                                                                 PLOTS.4606
      integer          place             ! start parse here                (in)  PLOTS.4607
      integer          i                 ! place keeper                 (local)  PLOTS.4608
                                                                                 PLOTS.4609
C  Logical variables                                                             PLOTS.4610
                                                                                 PLOTS.4611
      logical          error             ! has an error occured ?          (in)  PLOTS.4612
                                                                                 PLOTS.4613
C****************************  subroutine begin  *****************************C  PLOTS.4614
                                                                                 PLOTS.4615
C  Use I and not PLACE                                                           PLOTS.4616
                                                                                 PLOTS.4617
      i = place                                                                  PLOTS.4618
                                                                                 PLOTS.4619
C  Always increment at least one place in WHLINE                                 PLOTS.4620
                                                                                 PLOTS.4621
      i = i + 1                                                                  PLOTS.4622
                                                                                 PLOTS.4623
C  Test until we find the first space or vertical bar                            PLOTS.4624
                                                                                 PLOTS.4625
10    continue                                                                   PLOTS.4626
      if (i .le. 80) then                                                        PLOTS.4627
        if ((whline(i:i) .ne. ' ') .and. (whline(i:i) .ne. '|')) then            PLOTS.4628
          i = i + 1                                                              PLOTS.4629
          goto 10                                                                PLOTS.4630
        end if                                                                   PLOTS.4631
      end if                                                                     PLOTS.4632
                                                                                 PLOTS.4633
C  If no error occured reassign PLACE and exit                                   PLOTS.4634
                                                                                 PLOTS.4635
      if (i .le. 80) then                                                        PLOTS.4636
        place = i                                                                PLOTS.4637
                                                                                 PLOTS.4638
C  If an error has occured let the calling routine know                          PLOTS.4639
                                                                                 PLOTS.4640
      else                                                                       PLOTS.4641
        error = .true.                                                           PLOTS.4642
      end if                                                                     PLOTS.4643
                                                                                 PLOTS.4644
C*****************************  subroutine end  ******************************C  PLOTS.4645
                                                                                 PLOTS.4646
      return                                                                     PLOTS.4647
      end                                                                        PLOTS.4648
      subroutine prodll (nmgr,cenlon,project)                                    PLOTS.4649
                                                                                 PLOTS.4650
C*****************************************************************************C  PLOTS.4651
C  prodll   - This is a MAPDRV routine                                        C  PLOTS.4652
C  Section  - Lat/Lon Lines                                                   C  PLOTS.4653
C  Purpose  - To make publication style lat/lon patterns on a map.            C  PLOTS.4654
C                                                                             C  PLOTS.4655
C  On entry - NMGR is the grid interval being used. CENLON is the center lon- C  PLOTS.4656
C             longitude of the entire domain, even if this is a subset.       C  PLOTS.4657
C                                                                             C  PLOTS.4658
C  On exit  - The lat/lon grid has been marked with plus signs.               C  PLOTS.4659
C                                                                             C  PLOTS.4660
C  Assume   - GKS is open.                                                    C  PLOTS.4661
C                                                                             C  PLOTS.4662
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4663
C             ----------------------------------------------------------------C  PLOTS.4664
C             MAPGTI              EZMAP utility*                              C  PLOTS.4665
C             MAPTRN              EZMAP utility*                              C  PLOTS.4666
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.4667
C             ----------------------------------------------------------------C  PLOTS.4668
C             * NCAR Graphics routine                                         C  PLOTS.4669
C                                                                             C  PLOTS.4670
C  Author   - Jeremy Asbill       Date - July 23, 1990       for the MM4 club C  PLOTS.4671
C*****************************************************************************C  PLOTS.4672
                                                                                 PLOTS.4673
C  Character variables                                                           PLOTS.4674
                                                                                 PLOTS.4675
      character*2      project           ! projection used in map          (in)  PLOTS.4676
                                                                                 PLOTS.4677
C  Integer variables                                                             PLOTS.4678
                                                                                 PLOTS.4679
      integer          nmgr              ! grid interval to use            (in)  PLOTS.4680
      integer          wlabs,            ! for common block MLBDET               PLOTS.4681
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.4682
      integer          llcolr            ! for common block LLLCOL               PLOTS.4683
      integer          i,j,              ! loop counters/place keepers  (local)  PLOTS.4684
     *                 stri,             ! what lon. to start with      (local)  PLOTS.4685
     *                 strj,             ! what lat. to start with      (local)  PLOTS.4686
     *                 llsv              ! save variable                (local)  PLOTS.4687
                                                                                 PLOTS.4688
C  Real variables                                                                PLOTS.4689
                                                                                 PLOTS.4690
      real             cenlon            ! center longitude                (in)  PLOTS.4691
      real             lbsiz             ! for common block MLBDET               PLOTS.4692
      real             xn,               ! cone factor for projection   (local)  PLOTS.4693
     *                 x,                ! x position in grid of a pt.  (local)  PLOTS.4694
     *                 y,                ! y position in grid of a pt.  (local)  PLOTS.4695
     *                 flsv,             ! save variable                (local)  PLOTS.4696
     *                 frsv,             ! save variable                (local)  PLOTS.4697
     *                 fbsv,             ! save variable                (local)  PLOTS.4698
     *                 ftsv,             ! save variable                (local)  PLOTS.4699
     *                 ulsv,             ! left of map in user coords.  (local)  PLOTS.4700
     *                 ursv,             ! right of map in user coords. (local)  PLOTS.4701
     *                 ubsv,             ! bottom of map in user coords.(local)  PLOTS.4702
     *                 utsv,             ! top of map in user coords.   (local)  PLOTS.4703
     *                 ang               ! angle at which to draw plus  (local)  PLOTS.4704
                                                                                 PLOTS.4705
C  Common blocks                                                                 PLOTS.4706
                                                                                 PLOTS.4707
      common /mlbdet/  wlabs,            ! not used                              PLOTS.4708
     *                 lbsiz,            ! alternate label size                  PLOTS.4709
     *                 lbqul             ! not used                              PLOTS.4710
      common /lllcol/  llcolr            ! color of lat/lon lines                PLOTS.4711
                                                                                 PLOTS.4712
C****************************  subroutine begin  *****************************C  PLOTS.4713
                                                                                 PLOTS.4714
C  Set the user coords. up to mimic the grid                                     PLOTS.4715
                                                                                 PLOTS.4716
      call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                 PLOTS.4717
                                                                                 PLOTS.4718
C  Set up correct color for the ticks                                            PLOTS.4719
C  To understand what the quality of the letters has to do with the color        PLOTS.4720
C  read on page 2-14 in the NCAR Graphics Guide to New Utilities Version 3.00    PLOTS.4721
C  under the heading of PLOTCHAR                                                 PLOTS.4722
                                                                                 PLOTS.4723
      call pcseti ('QU',0)                                                       PLOTS.4724
      call gsplci (llcolr)                                                       PLOTS.4725
                                                                                 PLOTS.4726
C  Determin projection cone factor                                               PLOTS.4727
                                                                                 PLOTS.4728
      if (project(1:2) .eq. 'LC') then                                           PLOTS.4729
        xn = 0.716                                                               PLOTS.4730
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.4731
        xn = 1.0                                                                 PLOTS.4732
      else                                                                       PLOTS.4733
        xn = 0.0                                                                 PLOTS.4734
      end if                                                                     PLOTS.4735
                                                                                 PLOTS.4736
C  Determine which lat/lons to start with                                        PLOTS.4737
                                                                                 PLOTS.4738
      stri = -180 + nmgr                                                         PLOTS.4739
      strj = -90  + nmgr                                                         PLOTS.4740
                                                                                 PLOTS.4741
C  Turn clipping on                                                              PLOTS.4742
                                                                                 PLOTS.4743
      call gsclip (1)                                                            PLOTS.4744
                                                                                 PLOTS.4745
C  Loop through every lat lon combo. with proper grid interval                   PLOTS.4746
                                                                                 PLOTS.4747
      do 10 i = stri,180,nmgr                                                    PLOTS.4748
        do 20 j = strj,90,nmgr                                                   PLOTS.4749
                                                                                 PLOTS.4750
C  Calculate the angle at which to draw the pluses                               PLOTS.4751
                                                                                 PLOTS.4752
          ang = (float(i) - cenlon) * xn                                         PLOTS.4753
                                                                                 PLOTS.4754
C  Change current lat/lon combo. to user coordinates                             PLOTS.4755
                                                                                 PLOTS.4756
          call maptrn (float(j),float(i),x,y)                                    PLOTS.4757
                                                                                 PLOTS.4758
C  Check to see if the point is within the viewport                              PLOTS.4759
                                                                                 PLOTS.4760
          if ((x .ge. ulsv) .and. (x .le. ursv) .and.                            PLOTS.4761
     *        (y .ge. ubsv) .and. (y .le. utsv)) then                            PLOTS.4762
                                                                                 PLOTS.4763
C  Draw a correct plus                                                           PLOTS.4764
                                                                                 PLOTS.4765
            call plchhq (x,y,'+',-lbsiz,ang,0)                                   PLOTS.4766
          end if                                                                 PLOTS.4767
20      continue                                                                 PLOTS.4768
10    continue                                                                   PLOTS.4769
                                                                                 PLOTS.4770
C  Turn clipping off                                                             PLOTS.4771
                                                                                 PLOTS.4772
      call gsclip (0)                                                            PLOTS.4773
                                                                                 PLOTS.4774
C*****************************  subroutine end  ******************************C  PLOTS.4775
                                                                                 PLOTS.4776
      return                                                                     PLOTS.4777
      end                                                                        PLOTS.4778
      subroutine search (whline,place,error)                                     PLOTS.4779
                                                                                 PLOTS.4780
C*****************************************************************************C  PLOTS.4781
C  search   - This is a CONDRV/MAPDRV routine                                 C  PLOTS.4782
C  Section  - Tables                                                          C  PLOTS.4783
C  Purpose  - This is  a tool to  read to the next  meaningful character in a C  PLOTS.4784
C             table.                                                          C  PLOTS.4785
C                                                                             C  PLOTS.4786
C  On entry - WHLINE contains a line of a table. PLACE contains the  position C  PLOTS.4787
C             from where to start looking.                                    C  PLOTS.4788
C                                                                             C  PLOTS.4789
C  On exit  - PLACE contains the  location of the first  meaningful character C  PLOTS.4790
C             within the string.  If no character was found ERROR is true.    C  PLOTS.4791
C                                                                             C  PLOTS.4792
C  Assume   - Nothing.                                                        C  PLOTS.4793
C                                                                             C  PLOTS.4794
C  Author   - Jeremy Asbill        Date - June 11, 1990      for the MM4 club C  PLOTS.4795
C*****************************************************************************C  PLOTS.4796
                                                                                 PLOTS.4797
C  Character Variables                                                           PLOTS.4798
                                                                                 PLOTS.4799
      character*80 whline      ! a line from a table                       (in)  PLOTS.4800
                                                                                 PLOTS.4801
C  Integer Variables                                                             PLOTS.4802
                                                                                 PLOTS.4803
      integer      place       ! position within WHLINE                    (in)  PLOTS.4804
                                                                                 PLOTS.4805
C  Logical Variables                                                             PLOTS.4806
                                                                                 PLOTS.4807
      logical      error       ! was there no character to find           (out)  PLOTS.4808
                                                                                 PLOTS.4809
C****************************  subroutine begin  *****************************C  PLOTS.4810
                                                                                 PLOTS.4811
C  Initialize ERROR                                                              PLOTS.4812
                                                                                 PLOTS.4813
      error = .false.                                                            PLOTS.4814
                                                                                 PLOTS.4815
C  Try to read to the first character                                            PLOTS.4816
                                                                                 PLOTS.4817
10    continue                                                                   PLOTS.4818
      if ((whline(place:place) .eq. ' ') .or.                                    PLOTS.4819
     *     (whline(place:place) .eq. '|')) then                                  PLOTS.4820
        place = place + 1                                                        PLOTS.4821
                                                                                 PLOTS.4822
C  Check to see if there is an error condition                                   PLOTS.4823
                                                                                 PLOTS.4824
        if (place .gt. 80) then                                                  PLOTS.4825
          error = .true.                                                         PLOTS.4826
          goto 20                                                                PLOTS.4827
        end if                                                                   PLOTS.4828
        goto 10                                                                  PLOTS.4829
      end if                                                                     PLOTS.4830
                                                                                 PLOTS.4831
C*****************************  subroutine end  ******************************C  PLOTS.4832
                                                                                 PLOTS.4833
20    return                                                                     PLOTS.4834
      end                                                                        PLOTS.4835
      subroutine setmap (cenlat,cenlon,project,grds,xpa,ypa,xpb,ypb,             PLOTS.4836
     *                   iend,jend)                                              PLOTS.4837
                                                                                 PLOTS.4838
C*****************************************************************************C  PLOTS.4839
C  setmap   - This is a MAPDRV routine                                        C  PLOTS.4840
C  Section  - Design                                                          C  PLOTS.4841
C  Purpose  - To match the grid and the  screen window with the domain on the C  PLOTS.4842
C             globe.                                                          C  PLOTS.4843
C                                                                             C  PLOTS.4844
C  On entry - CENLAT is the center latitude of the whole domain.   CENLON  is C  PLOTS.4845
C             the center longitude of the whole domain.  PROJECT is  the pro- C  PLOTS.4846
C             jection indicator.  GRDS is the grid  distance  in  kilometers. C  PLOTS.4847
C             XPA, YPA  are the lower  left grid point of the map.   XPB, YPB C  PLOTS.4848
C             are the upper right grid point of the map. IEND is the value of C  PLOTS.4849
C             the maximum grid point in the y direction.   JEND is the  value C  PLOTS.4850
C             of the maximum grid point in the x direction.                   C  PLOTS.4851
C                                                                             C  PLOTS.4852
C  On exit  - The domain has been set up with EZMAP.                          C  PLOTS.4853
C                                                                             C  PLOTS.4854
C  Assume   - GKS is open.                                                    C  PLOTS.4855
C                                                                             C  PLOTS.4856
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4857
C             ----------------------------------------------------------------C  PLOTS.4858
C             MAPSET              EZMAP utility*                              C  PLOTS.4859
C             ----------------------------------------------------------------C  PLOTS.4860
C             * NCAR Graphics routine                                         C  PLOTS.4861
C                                                                             C  PLOTS.4862
C  Author   - Jeremy Asbill       Date - July 14, 1990       for the MM4 club C  PLOTS.4863
C*****************************************************************************C  PLOTS.4864
                                                                                 PLOTS.4865
C  Character varaibles                                                           PLOTS.4866
                                                                                 PLOTS.4867
      character*2      project           ! specifies projection            (in)  PLOTS.4868
                                                                                 PLOTS.4869
C  Integer variables                                                             PLOTS.4870
                                                                                 PLOTS.4871
      integer          iend,             ! max. y value of grids           (in)  PLOTS.4872
     *                 jend              ! max. x value of grids           (in)  PLOTS.4873
      integer          imax,             ! for common block XYLLON               PLOTS.4874
     *                 jmax              ! for common block XYLLON               PLOTS.4875
                                                                                 PLOTS.4876
C  Real variables                                                                PLOTS.4877
                                                                                 PLOTS.4878
      real             cenlat,           ! center latitude                 (in)  PLOTS.4879
     *                 cenlon,           ! center longitude                (in)  PLOTS.4880
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.4881
     *                 xpa,              ! x of lower left grid pt. in map (in)  PLOTS.4882
     *                 ypa,              ! y of lower left grid pt. in map (in)  PLOTS.4883
     *                 xpb,              ! x of upper right grd pt. in map (in)  PLOTS.4884
     *                 ypb               ! y of upper right grd pt. in map (in)  PLOTS.4885
      real             ds,               ! for common block XYLLON               PLOTS.4886
     *                 xlatc,            ! for common block XYLLON               PLOTS.4887
     *                 xlonc             ! for common block XYLLON               PLOTS.4888
      real             latl,             ! lower left latitude          (local)  PLOTS.4889
     *                 lonl,             ! lower left longitude         (local)  PLOTS.4890
     *                 latu,             ! upper right latitude         (local)  PLOTS.4891
     *                 lonu              ! upper right longitude        (local)  PLOTS.4892
                                                                                 PLOTS.4893
C  Common blocks                                                                 PLOTS.4894
                                                                                 PLOTS.4895
      common /xyllon/  ds,               ! grid distance in kilometers           PLOTS.4896
     *                 xlatc,            ! center latitude                       PLOTS.4897
     *                 xlonc,            ! center longitude                      PLOTS.4898
     *                 imax,             ! maximum vertical gird point           PLOTS.4899
     *                 jmax              ! maximum horizontal grid point         PLOTS.4900
                                                                                 PLOTS.4901
C****************************  subroutine begin  *****************************C  PLOTS.4902
                                                                                 PLOTS.4903
C  Set up to use XYTOLL                                                          PLOTS.4904
                                                                                 PLOTS.4905
      ds    = grds                                                               PLOTS.4906
      xlatc = cenlat                                                             PLOTS.4907
      xlonc = cenlon                                                             PLOTS.4908
      imax  = iend                                                               PLOTS.4909
      jmax  = jend                                                               PLOTS.4910
                                                                                 PLOTS.4911
C  Get the longitude and latitude                                                PLOTS.4912
                                                                                 PLOTS.4913
      call xytoll (xpa,ypa,latl,lonl,project)                                    PLOTS.4914
      call xytoll (xpb,ypb,latu,lonu,project)                                    PLOTS.4915
                                                                                 PLOTS.4916
C  Set up the domain with EZMAP                                                  PLOTS.4917
                                                                                 PLOTS.4918
      call mapset ('CO',latl,lonl,latu,lonu)                                     PLOTS.4919
                                                                                 PLOTS.4920
C*****************************  subroutine end  ******************************C  PLOTS.4921
                                                                                 PLOTS.4922
      return                                                                     PLOTS.4923
      end                                                                        PLOTS.4924
      subroutine setpro (project,cenlat,cenlon)                                  PLOTS.4925
                                                                                 PLOTS.4926
C*****************************************************************************C  PLOTS.4927
C  setpro   - This is a MAPDRV routine                                        C  PLOTS.4928
C  Section  - Design                                                          C  PLOTS.4929
C  Purpose  - To determine and set up the proper projection for the map.      C  PLOTS.4930
C                                                                             C  PLOTS.4931
C  On entry - PROJECT describes what  projection we are to use.   CENLAT  and C  PLOTS.4932
C             CENLON are the central latitude and longitude respectively.     C  PLOTS.4933
C                                                                             C  PLOTS.4934
C  On exit  - The correct projection has been set up.   XN  contains  a calc- C  PLOTS.4935
C             culation value needed by the routine  XYTOLL.                   C  PLOTS.4936
C                                                                             C  PLOTS.4937
C  Assume   - GKS is open.                                                    C  PLOTS.4938
C                                                                             C  PLOTS.4939
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4940
C             ----------------------------------------------------------------C  PLOTS.4941
C             MAPPROJ             EZMAP utility*                              C  PLOTS.4942
C             ----------------------------------------------------------------C  PLOTS.4943
C             * NCAR Graphics routine                                         C  PLOTS.4944
C                                                                             C  PLOTS.4945
C  Author   - Jeremy Asbill        Date - July 6, 1990       for the MM4 club C  PLOTS.4946
C*****************************************************************************C  PLOTS.4947
                                                                                 PLOTS.4948
C  Character variables                                                           PLOTS.4949
                                                                                 PLOTS.4950
      character*2      project           ! specifies projection to use     (in)  PLOTS.4951
                                                                                 PLOTS.4952
C  Real variables                                                                PLOTS.4953
                                                                                 PLOTS.4954
      real             cenlat,           ! center latitude to use          (in)  PLOTS.4955
     *                 cenlon            ! center longitude to use         (in)  PLOTS.4956
      real             rotan,            ! rotation angle               (local)  PLOTS.4957
     *                 polat             ! polar latitude               (local)  PLOTS.4958
      real             confac,           ! for common block LAMSTF               PLOTS.4959
     *                 fsparl,           ! for common block LAMSTF               PLOTS.4960
     *                 ssparl            ! for common block LAMSTF               PLOTS.4961
                                                                                 PLOTS.4962
C  Common blocks                                                                 PLOTS.4963
                                                                                 PLOTS.4964
      common /lamstf/  confac,           ! not used                              PLOTS.4965
     *                 fsparl,           ! first standard parallel lat.          PLOTS.4966
     *                 ssparl            ! second standard parallel lat.         PLOTS.4967
                                                                                 PLOTS.4968
C****************************  subroutine begin  *****************************C  PLOTS.4969
                                                                                 PLOTS.4970
C  Lambert Conformal Projection - These values are either set to defaults        PLOTS.4971
C  or by the user, determined in INTERR.                                         PLOTS.4972
                                                                                 PLOTS.4973
      if (project .eq. 'LC') then                                                PLOTS.4974
        rotan = fsparl                                                           PLOTS.4975
        polat = ssparl                                                           PLOTS.4976
C       print *, 'MAPDRV - Lambert Conformal Projection'                         06NOV00.140
                                                                                 PLOTS.4978
C  Polar Stereographic Projection - The polar true latitude is either set to     PLOTS.4979
C  the default by the user or determined in INTERR.                              PLOTS.4980
                                                                                 PLOTS.4981
      else if (project .eq. 'ST') then                                           PLOTS.4982
        rotan = 0.0                                                              PLOTS.4983
        if (cenlat .gt. 0.0) then                                                PLOTS.4984
          polat = 90.0                                                           PLOTS.4985
        else                                                                     PLOTS.4986
          polat = -90.0                                                          PLOTS.4987
        end if                                                                   PLOTS.4988
C       print *, 'MAPDRV - Polar Stereographic Projection'                       06NOV00.141
                                                                                 PLOTS.4990
C  Cylindrical Equidistant                                                       PLOTS.4991
                                                                                 PLOTS.4992
      else if (project .eq. 'CE') then                                           PLOTS.4993
        rotan = 0.0                                                              PLOTS.4994
        polat = 0.0                                                              PLOTS.4995
C       print *, 'MAPDRV - Cylindrical Equidistant Projection'                   06NOV00.142
                                                                                 PLOTS.4997
C  MErcator                                                                      PLOTS.4998
                                                                                 PLOTS.4999
      else if (project .eq. 'ME') then                                           PLOTS.5000
        rotan = 0.0                                                              PLOTS.5001
        polat = 0.0                                                              PLOTS.5002
C       print *, 'MAPDRV - Mercator Projection'                                  06NOV00.143
      end if                                                                     PLOTS.5004
                                                                                 PLOTS.5005
C  Set up the projection                                                         PLOTS.5006
                                                                                 PLOTS.5007
      call maproj (project,polat,cenlon,rotan)                                   PLOTS.5008
                                                                                 PLOTS.5009
C*****************************  subroutine end  ******************************C  PLOTS.5010
                                                                                 PLOTS.5011
      return                                                                     PLOTS.5012
      end                                                                        PLOTS.5013
      subroutine setwin (xpa,ypa,xpb,ypb,doset)                                  PLOTS.5014
                                                                                 PLOTS.5015
C*****************************************************************************C  PLOTS.5016
C  setwin   - This is a MAPDRV routine                                        C  PLOTS.5017
C  Section  - Design                                                          C  PLOTS.5018
C  Purpose  - To set the map in a nice window on the screen.  That is the map C  PLOTS.5019
C             must allow room above and below it.                             C  PLOTS.5020
C                                                                             C  PLOTS.5021
C  On entry - XPA, YPA are the lower left hand corners of the map  within the C  PLOTS.5022
C             domain grid.  XPB, YPB are the  upper  right hand corner of the C  PLOTS.5023
C             map within the domain grid.  DOSET  indicates whether to make a C  PLOTS.5024
C             set call here or whether the user did it.                       C  PLOTS.5025
C                                                                             C  PLOTS.5026
C  On exit  - The proper window has been set.                                 C  PLOTS.5027
C                                                                             C  PLOTS.5028
C  Assume   - GKS is open.                                                    C  PLOTS.5029
C                                                                             C  PLOTS.5030
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5031
C             ----------------------------------------------------------------C  PLOTS.5032
C             MAPPOS              EZMAP utility*                              C  PLOTS.5033
C             GETSET              SPPS*                                       C  PLOTS.5034
C             SET                 SPPS*                                       C  PLOTS.5035
C             ----------------------------------------------------------------C  PLOTS.5036
C             * NCAR Graphics routine                                         C  PLOTS.5037
C                                                                             C  PLOTS.5038
C  Author   - Jeremy Asbill       Date - July 11, 1990       for the MM4 club C  PLOTS.5039
C*****************************************************************************C  PLOTS.5040
                                                                                 PLOTS.5041
C  Integer varaibles                                                             PLOTS.5042
                                                                                 PLOTS.5043
      integer          llsv              ! junk filler                  (local)  PLOTS.5044
                                                                                 PLOTS.5045
C  Logical variables                                                             PLOTS.5046
                                                                                 PLOTS.5047
      logical          doset             ! do a set call here ?            (in)  PLOTS.5048
                                                                                 PLOTS.5049
C  Real variables                                                                PLOTS.5050
                                                                                 PLOTS.5051
      real             xpa,              ! left hand x coord of map        (in)  PLOTS.5052
     *                 ypa,              ! lower y coord of map            (in)  PLOTS.5053
     *                 xpb,              ! right hand x coord of map       (in)  PLOTS.5054
     *                 ypb               ! upper y coord of map            (in)  PLOTS.5055
      real             temp,             ! temporary test variable      (local)  PLOTS.5056
     *                 dumy,             ! dummy test variable          (local)  PLOTS.5057
     *                 test,             ! test variable                (local)  PLOTS.5058
     *                 flsv,             ! left window edge             (local)  PLOTS.5059
     *                 frsv,             ! right window edge            (local)  PLOTS.5060
     *                 fbsv,             ! bottom window edge           (local)  PLOTS.5061
     *                 ftsv,             ! top window edge              (local)  PLOTS.5062
     *                 ulsv,             ! junk filler                  (local)  PLOTS.5063
     *                 ursv,             ! junk filler                  (local)  PLOTS.5064
     *                 ubsv,             ! junk filler                  (local)  PLOTS.5065
     *                 utsv              ! junk filler                  (local)  PLOTS.5066
                                                                                 PLOTS.5067
C****************************  subroutine begin  *****************************C  PLOTS.5068
                                                                                 PLOTS.5069
C  Set up variables to test on                                                   PLOTS.5070
C  TEMP will represent the maps width                                            PLOTS.5071
C  DUMY will represent the maps height                                           PLOTS.5072
                                                                                 PLOTS.5073
      temp = ypb - ypa + 1.0                                                     PLOTS.5074
      dumy = (xpb - xpa + 1.0) * 0.9                                             PLOTS.5075
                                                                                 PLOTS.5076
C  Check to see if we have control over the set call                             PLOTS.5077
                                                                                 PLOTS.5078
      if (doset) then                                                            PLOTS.5079
                                                                                 PLOTS.5080
C  If the map is almost sqare or is taller than it is wide, guarantee at least   PLOTS.5081
C  10% of the scren on the top and bottom.                                       PLOTS.5082
C  Otherwise, guarantee ourselves at least 5% on the top and bottom              PLOTS.5083
                                                                                 PLOTS.5084
        if (temp .ge. dumy) then                                                 PLOTS.5085
          call mappos (0.1,0.9,0.1,0.9)                                          PLOTS.5086
        else                                                                     PLOTS.5087
          call mappos (0.05,0.95,0.05,0.95)                                      PLOTS.5088
        end if                                                                   PLOTS.5089
      else                                                                       PLOTS.5090
                                                                                 PLOTS.5091
C  We don't have control over the set, do it like the user wants                 PLOTS.5092
                                                                                 PLOTS.5093
        call getset (flsv,frsv,fbsv,ftsv,ursv,ulsv,ubsv,utsv,llsv)               PLOTS.5094
                                                                                 PLOTS.5095
C  Adjust to use the proper percentage of the domain by the same tests as        PLOTS.5096
C  we would if a set call had not been made                                      PLOTS.5097
                                                                                 PLOTS.5098
        if (temp .ge. dumy) then                                                 PLOTS.5099
          test = 0.1 * (frsv - flsv)                                             PLOTS.5100
          frsv = frsv - test                                                     PLOTS.5101
          flsv = flsv + test                                                     PLOTS.5102
          test = 0.1 * (ftsv - fbsv)                                             PLOTS.5103
          ftsv = ftsv - test                                                     PLOTS.5104
          fbsv = fbsv + test                                                     PLOTS.5105
        else                                                                     PLOTS.5106
          test = 0.05 * (frsv - flsv)                                            PLOTS.5107
          frsv = frsv - test                                                     PLOTS.5108
          flsv = flsv + test                                                     PLOTS.5109
          test = 0.05 * (ftsv - fbsv)                                            PLOTS.5110
          ftsv = ftsv - test                                                     PLOTS.5111
          fbsv = fbsv + test                                                     PLOTS.5112
        end if                                                                   PLOTS.5113
                                                                                 PLOTS.5114
C  Set up the users set call with EZMAP                                          PLOTS.5115
                                                                                 PLOTS.5116
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.5117
        call mappos (flsv,frsv,fbsv,ftsv)                                        PLOTS.5118
      end if                                                                     PLOTS.5119
                                                                                 PLOTS.5120
C*****************************  subroutine end  ******************************C  PLOTS.5121
                                                                                 PLOTS.5122
      return                                                                     PLOTS.5123
      end                                                                        PLOTS.5124
      subroutine tbllok (unum,tabnam,errsev,there,whline,util)                   PLOTS.5125
                                                                                 PLOTS.5126
C*****************************************************************************C  PLOTS.5127
C  tbllok   - This is a MAPDRV/CONDRV routine                                 C  PLOTS.5128
C  Section  - Tables                                                          C  PLOTS.5129
C  Purpose  - To check and see if the requested table is there and place  the C  PLOTS.5130
C             file pointer to the first information line in the table.        C  PLOTS.5131
C                                                                             C  PLOTS.5132
C  On entry - UNUM is the unit number of the table file.  TABNAM cantains the C  PLOTS.5133
C             name of the table to check for.   ERRSEV  is the error severity C  PLOTS.5134
C             indicator.                                                      C  PLOTS.5135
C                                                                             C  PLOTS.5136
C  On exit  - THERE tells the calling routine  whether the table is  there or C  PLOTS.5137
C             is there or not.  WHLINE is the first information line from the C  PLOTS.5138
C             table.                                                          C  PLOTS.5139
C                                                                             C  PLOTS.5140
C  Assume   - Nothing.                                                        C  PLOTS.5141
C                                                                             C  PLOTS.5142
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5143
C             ----------------------------------------------------------------C  PLOTS.5144
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.5145
C             ----------------------------------------------------------------C  PLOTS.5146
C             * NCAR Graphics routine                                         C  PLOTS.5147
C                                                                             C  PLOTS.5148
C  Author   - Jeremy Asbill       Date - July 13, 1990       for the MM4 club C  PLOTS.5149
C*****************************************************************************C  PLOTS.5150
                                                                                 PLOTS.5151
C  Character variables                                                           PLOTS.5152
                                                                                 PLOTS.5153
      character*10     tabnam            ! name of the table to look for   (in)  PLOTS.5154
      character*6      util              ! name of utility calling TBLLOK  (in)  PLOTS.5155
      character*80     whline            ! line from the table            (out)  PLOTS.5156
      character*60     ermes             ! error/warning message        (local)  PLOTS.5157
                                                                                 PLOTS.5158
C  Integer variables                                                             PLOTS.5159
                                                                                 PLOTS.5160
      integer          unum,             ! unit number of table file       (in)  PLOTS.5161
     *                 errsev            ! error severity indicator        (in)  PLOTS.5162
      integer          start,            ! char. in ERMES to start      (local)  PLOTS.5163
     *                 i                 ! loop counter/place keeper    (local)  PLOTS.5164
                                                                                 PLOTS.5165
C  Logical variables                                                             PLOTS.5166
                                                                                 PLOTS.5167
      logical          there             ! is the table there ?           (out)  PLOTS.5168
                                                                                 PLOTS.5169
C****************************  subroutine begin  *****************************C  PLOTS.5170
                                                                                 PLOTS.5171
C  Prepare ERMES in case of an error                                             PLOTS.5172
                                                                                 PLOTS.5173
      if (tabnam(1:10) .eq. 'MAP DETAIL') then                                   PLOTS.5174
        ermes(1:23) = 'Reading Details Table, '                                  PLOTS.5175
        start = 24                                                               PLOTS.5176
      else if (tabnam(1:10) .eq. 'MAP FILL  ') then                              PLOTS.5177
        ermes(1:20) = 'Reading Fill Table, '                                     PLOTS.5178
        start = 21                                                               PLOTS.5179
      else if (tabnam(1:10) .eq. 'CON DETAIL') then                              PLOTS.5180
        ermes(1:23) = 'Reading Details Table, '                                  PLOTS.5181
        start = 24                                                               PLOTS.5182
      else                                                                       PLOTS.5183
        ermes(1:21) = 'Reading Color Table, '                                    PLOTS.5184
        start = 22                                                               PLOTS.5185
      end if                                                                     PLOTS.5186
                                                                                 PLOTS.5187
C  If UNUM is negative then it is assumed that the table is not there            PLOTS.5188
                                                                                 PLOTS.5189
      if (unum .lt. 0) then                                                      PLOTS.5190
        there = .false.                                                          PLOTS.5191
      else                                                                       PLOTS.5192
C  It is expected that each table be preceded by three lines:                    PLOTS.5193
C  Line 1 - Anything                                                             PLOTS.5194
C  Line 2 - Table Title                                                          PLOTS.5195
C  Line 3 - Anything                                                             PLOTS.5196
C  Line 4 - Anything                                                             PLOTS.5197
                                                                                 PLOTS.5198
C  Line 1 -                                                                      PLOTS.5199
C  Try to read from the file,                                                    PLOTS.5200
C  if EOF the table is not there                                                 PLOTS.5201
                                                                                 PLOTS.5202
        read (unum,10,end=20,err=30) whline(1:1)                                 PLOTS.5203
                                                                                 PLOTS.5204
C  Line 2 -                                                                      PLOTS.5205
C  if EOF then give a warning                                                    PLOTS.5206
                                                                                 PLOTS.5207
        read (unum,100,end=50,err=30) whline(1:80)                               PLOTS.5208
                                                                                 PLOTS.5209
C  Check if this is the table we are looking for                                 PLOTS.5210
                                                                                 PLOTS.5211
        i = 1                                                                    PLOTS.5212
70      continue                                                                 PLOTS.5213
        if (whline(i:i) .eq. ' ') then                                           PLOTS.5214
          i = i + 1                                                              PLOTS.5215
          if (i .gt. 73) then                                                    PLOTS.5216
                                                                                 PLOTS.5217
C  No title was found on the line where it was expected                          PLOTS.5218
                                                                                 PLOTS.5219
            ermes(start:start+33) = 'Table Title Expected But Not Found'         PLOTS.5220
            do 80 i = start+34,60                                                PLOTS.5221
              ermes(i:i) = ' '                                                   PLOTS.5222
80          continue                                                             PLOTS.5223
            call errhan (util,0,ermes,errsev)                                    PLOTS.5224
            goto 20                                                              PLOTS.5225
          end if                                                                 PLOTS.5226
          goto 70                                                                PLOTS.5227
        end if                                                                   PLOTS.5228
                                                                                 PLOTS.5229
C  A title was found on the line                                                 PLOTS.5230
                                                                                 PLOTS.5231
        if (whline(i:i+9) .ne. tabnam(1:10)) then                                PLOTS.5232
                                                                                 PLOTS.5233
C  The title found was not the one we wanted                                     PLOTS.5234
                                                                                 PLOTS.5235
          backspace (unum)                                                       PLOTS.5236
          backspace (unum)                                                       PLOTS.5237
          goto 20                                                                PLOTS.5238
        end if                                                                   PLOTS.5239
                                                                                 PLOTS.5240
C  Line 3 & 4 -                                                                  PLOTS.5241
C  The title found was the one we wanted, read up to the infformation            PLOTS.5242
                                                                                 PLOTS.5243
        read (unum,10,end=50,err=30) whline(1:1)                                 PLOTS.5244
        read (unum,10,end=50,err=30) whline(1:1)                                 PLOTS.5245
                                                                                 PLOTS.5246
C  Read in the first information line                                            PLOTS.5247
                                                                                 PLOTS.5248
        read (unum,100,end=50,err=30) whline(1:80)                               PLOTS.5249
                                                                                 PLOTS.5250
C  Let the calling routine know the table is there                               PLOTS.5251
                                                                                 PLOTS.5252
        there = .true.                                                           PLOTS.5253
        goto 90                                                                  PLOTS.5254
                                                                                 PLOTS.5255
C  Warnings                                                                      PLOTS.5256
                                                                                 PLOTS.5257
50      ermes(start:start+29) = 'Unexpected End Of File Reached'                 PLOTS.5258
        do 60 i = start+30,60                                                    PLOTS.5259
          ermes(i:i) = ' '                                                       PLOTS.5260
60      continue                                                                 PLOTS.5261
        call errhan (util,0,ermes,errsev)                                        PLOTS.5262
        goto 20                                                                  PLOTS.5263
                                                                                 PLOTS.5264
C  Errors                                                                        PLOTS.5265
                                                                                 PLOTS.5266
30      ermes(start:start+25) = 'Possibly A Bad Unit Number'                     PLOTS.5267
        do 40 i = start+26,60                                                    PLOTS.5268
          ermes(i:i) = ' '                                                       PLOTS.5269
40      continue                                                                 PLOTS.5270
        call errhan (util,1,ermes,errsev)                                        PLOTS.5271
20      there = .false.                                                          PLOTS.5272
      end if                                                                     PLOTS.5273
                                                                                 PLOTS.5274
C*****************************  subroutine end  ******************************C  PLOTS.5275
                                                                                 PLOTS.5276
C  Format statements begin ...                                                   PLOTS.5277
                                                                                 PLOTS.5278
10    format (A1)                                                                PLOTS.5279
100   format (A80)                                                               PLOTS.5280
                                                                                 PLOTS.5281
C  Format statements end.                                                        PLOTS.5282
                                                                                 PLOTS.5283
90    return                                                                     PLOTS.5284
      end                                                                        PLOTS.5285
      subroutine xytoll (j,i,lat,lon,project)                                    PLOTS.5286
                                                                                 PLOTS.5287
C*****************************************************************************C  PLOTS.5288
C  xytoll   - This is a MAPDRV routine                                        C  PLOTS.5289
C  Section  - Labels                                                          C  PLOTS.5290
C  Purpose  - To  transform  mesoscale gird point coordinates into  latitude, C  PLOTS.5291
C             longitude coordinates.                                          C  PLOTS.5292
C                                                                             C  PLOTS.5293
C  On entry - J  and  I are an ordered pair representing a grid point in  the C  PLOTS.5294
C             mesoscale grid.  XYLLON is a common block that contains the in- C  PLOTS.5295
C             formation necessary for describing the domain.                  C  PLOTS.5296
C                                                                             C  PLOTS.5297
C  On exit  - LAT, LON contain  the latitude and longitude respectively  that C  PLOTS.5298
C             resulted from the transformation.                               C  PLOTS.5299
C                                                                             C  PLOTS.5300
C  Assume   - Nothing.                                                        C  PLOTS.5301
C                                                                             C  PLOTS.5302
C  Notes    - The formula's used in this routine were taken from the  PROGRAM C  PLOTS.5303
C             TERRAIN DOCUMENTATION AND USER'S GUIDE.                         C  PLOTS.5304
C                                                                             C  PLOTS.5305
C  Author   - Jeremy Asbill   Date - September 17, 1990      for the MM4 club C  PLOTS.5306
C*****************************************************************************C  PLOTS.5307
                                                                                 PLOTS.5308
C  Parameters                                                                    PLOTS.5309
                                                                                 PLOTS.5310
      parameter       (pi = 3.14159265)  ! you know!  pi = 180 degrees           PLOTS.5311
      parameter       (re = 6370.)       ! the radius of the earth in km         PLOTS.5312
      parameter       (ce = 40029.85315) ! the circumference of the earth in km  PLOTS.5313
                                                                                 PLOTS.5314
C  Character variables                                                           PLOTS.5315
                                                                                 PLOTS.5316
      character*2      project           ! projection indicator            (in)  PLOTS.5317
                                                                                 PLOTS.5318
C  Integer variables                                                             PLOTS.5319
                                                                                 PLOTS.5320
      integer          imax,             ! for common block XYLLON               PLOTS.5321
     *                 jmax              ! for common block XYLLON               PLOTS.5322
                                                                                 PLOTS.5323
C  Real variables                                                                PLOTS.5324
                                                                                 PLOTS.5325
      real             j,                ! x coord. to be changed          (in)  PLOTS.5326
     *                 i                 ! y coord. to be changed          (in)  PLOTS.5327
      real             lat,              ! resulting latitude             (out)  PLOTS.5328
     *                 lon               ! resulting longitude            (out)  PLOTS.5329
      real             grds,             ! for common block XYLLON               PLOTS.5330
     *                 clat,             ! for common block XYLLON               PLOTS.5331
     *                 clon              ! for common block XYLLON               PLOTS.5332
      real             confac,           ! for common block LAMSTF               PLOTS.5333
     *                 fsparl,           ! for common block LAMSTF               PLOTS.5334
     *                 ssparl            ! for common block LAMSTF               PLOTS.5335
      real             rcln,             ! center longitude in radians  (local)  PLOTS.5336
     *                 rclt,             ! center latitude in radians   (local)  PLOTS.5337
     *                 cj,               ! center x coord. for grid     (local)  PLOTS.5338
     *                 ci,               ! center y coord. for grid     (local)  PLOTS.5339
     *                 dj,               ! distance from the central             PLOTS.5340
C                                          meridian to the point        (local)  PLOTS.5341
     *                 di,               ! distance from pole to point  (local)  PLOTS.5342
     *                 bm                ! calculation variable         (local)  PLOTS.5343
                                                                                 PLOTS.5344
C  Common blocks                                                                 PLOTS.5345
                                                                                 PLOTS.5346
      common /xyllon/  grds,             ! grid distance in kilometers           PLOTS.5347
     *                 clat,             ! center latitude                       PLOTS.5348
     *                 clon,             ! center longitude                      PLOTS.5349
     *                 imax,             ! maximum vertical gird point           PLOTS.5350
     *                 jmax              ! maximum horizontal grid point         PLOTS.5351
      common /lamstf/  confac,           ! cone factor to be used                PLOTS.5352
     *                 fsparl,           ! first standard parallel lat.          PLOTS.5353
     *                 ssparl            ! second standard parallel lat.         PLOTS.5354
                                                                                 PLOTS.5355
C****************************  subroutine begin  *****************************C  PLOTS.5356
                                                                                 PLOTS.5357
C  Convert the center latitude and longitude of the domain to radians            PLOTS.5358
                                                                                 PLOTS.5359
      rclt = clat * pi/180.0                                                     PLOTS.5360
      rcln = clon * pi/180.0                                                     PLOTS.5361
                                                                                 PLOTS.5362
C  Find the center values of the grid in mesoscale grid coordinates              PLOTS.5363
                                                                                 PLOTS.5364
      cj = float(jmax + 1) * 0.5                                                 PLOTS.5365
      ci = float(imax + 1) * 0.5                                                 PLOTS.5366
                                                                                 PLOTS.5367
C  Calculate the distance from the vertical axis to (J,I)                        PLOTS.5368
                                                                                 PLOTS.5369
      dj = (j - cj) * grds                                                       PLOTS.5370
                                                                                 PLOTS.5371
C  The rest is figured out differently for each type of projection, so ...       PLOTS.5372
C  If the projection is mercator ('ME') then ...                                 PLOTS.5373
                                                                                 PLOTS.5374
      if (project(1:2) .eq. 'ME') then                                           PLOTS.5375
                                                                                 PLOTS.5376
C  Calculate the distance the point in question is from the pole                 PLOTS.5377
                                                                                 PLOTS.5378
        di = -re * log(cos(rclt)/(1 + sin(rclt))) +                              PLOTS.5379
     *       (i - ci) * grds                                                     PLOTS.5380
                                                                                 PLOTS.5381
C  Calculate the latitude desired in radians                                     PLOTS.5382
                                                                                 PLOTS.5383
        lat = 2.0 * atan(exp(di/re)) - pi * 0.5                                  PLOTS.5384
                                                                                 PLOTS.5385
C  Calculate the longitude desired in radians                                    PLOTS.5386
                                                                                 PLOTS.5387
        lon = rcln + dj/re                                                       PLOTS.5388
                                                                                 PLOTS.5389
C  If the projection is cylindrical equidistant ('CE') then ...                  PLOTS.5390
                                                                                 PLOTS.5391
      else if (project(1:2) .eq. 'CE') then                                      PLOTS.5392
                                                                                 PLOTS.5393
C  Calculate the distance from the horizontal axis to (J,I)                      PLOTS.5394
                                                                                 PLOTS.5395
        di = (i - ci) * grds                                                     PLOTS.5396
                                                                                 PLOTS.5397
C  Determine the shift north-south                                               PLOTS.5398
                                                                                 PLOTS.5399
        lat = rclt + (pi * di/(ce * 0.5))                                        PLOTS.5400
                                                                                 PLOTS.5401
C  Determine the shift east-west                                                 PLOTS.5402
                                                                                 PLOTS.5403
        lon = rcln + (2 * pi * dj/ce)                                            PLOTS.5404
                                                                                 PLOTS.5405
C  If the projection is lambert conic conformal ('LC') then ...                  PLOTS.5406
                                                                                 PLOTS.5407
      else if (project(1:2) .eq. 'LC') then                                      PLOTS.5408
                                                                                 PLOTS.5409
C  Calculate the distance from the pole to J,I                                   PLOTS.5410
                                                                                 PLOTS.5411
        if (clat .ge. 0.0) then                                                  PLOTS.5412
          di = -re/confac * sin(pi * 0.5 - (fsparl * pi/180.0)) *                PLOTS.5413
     *         (tan((pi * 0.5 - rclt) * 0.5) /                                   PLOTS.5414
     *          tan((pi * 0.5 - (fsparl * pi/180.0)) * 0.5))**confac +           PLOTS.5415
     *         (i - ci) * grds                                                   PLOTS.5416
        else                                                                     PLOTS.5417
          di = -re/confac * sin(-pi * 0.5 - (fsparl * pi/180.0)) *               PLOTS.5418
     *         (tan((-pi * 0.5 - rclt) * 0.5) /                                  PLOTS.5419
     *          tan((-pi * 0.5 - (fsparl * pi/180.0)) * 0.5))**confac +          PLOTS.5420
     *         (i - ci) * grds                                                   PLOTS.5421
        end if                                                                   PLOTS.5422
                                                                                 PLOTS.5423
C  Calculate out the Big Messy equation refered to as c1 in the document         PLOTS.5424
C  from which this formula was taken                                             PLOTS.5425
                                                                                 PLOTS.5426
        bm = tan((pi * 0.5 - abs(fsparl * pi/180.0))/2.0) *                      PLOTS.5427
     *       (confac/re * sqrt(dj**2 + di**2) /                                  PLOTS.5428
     *        sin(pi * 0.5 - abs(fsparl * pi/180.0)))**(1.0/confac)              PLOTS.5429
                                                                                 PLOTS.5430
C  Calculate the desired latitude in radians                                     PLOTS.5431
                                                                                 PLOTS.5432
        if (clat .ge. 0.0) then                                                  PLOTS.5433
          lat = pi * 0.5 - 2.0 * atan(bm)                                        PLOTS.5434
        else                                                                     PLOTS.5435
          lat = -pi * 0.5 + 2.0 * atan(bm)                                       PLOTS.5436
        end if                                                                   PLOTS.5437
                                                                                 PLOTS.5438
C  Calculate the desired longitude in radians                                    PLOTS.5439
                                                                                 PLOTS.5440
        if (clat .ge. 0.0) then                                                  PLOTS.5441
          lon = rcln + (1.0/confac) * atan2(dj,-di)                              PLOTS.5442
        else                                                                     PLOTS.5443
          lon = rcln + (1.0/confac) * atan2(dj,di)                               PLOTS.5444
        end if                                                                   PLOTS.5445
                                                                                 PLOTS.5446
C  If the projection is polar stereographic ('ST') then ...                      PLOTS.5447
                                                                                 PLOTS.5448
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.5449
                                                                                 PLOTS.5450
C  Calculate the distance J,I lies from the "true" point                         PLOTS.5451
                                                                                 PLOTS.5452
        if (clat .gt. 0.0) then                                                  PLOTS.5453
          di = -re * sin(pi * 0.5 - rclt) *                                      PLOTS.5454
     *         (1.0 + cos(pi * 0.5 - (fsparl * pi/180.0))) /                     PLOTS.5455
     *         (1.0 + cos(pi * 0.5 - rclt)) +                                    PLOTS.5456
     *         (i - ci) * grds                                                   PLOTS.5457
        else                                                                     PLOTS.5458
          di = -re * sin(-pi * 0.5 - rclt) *                                     PLOTS.5459
     *         (1.0 + cos(-pi * 0.5 - (fsparl * pi/180.0))) /                    PLOTS.5460
     *         (1.0 + cos(-pi * 0.5 - rclt)) +                                   PLOTS.5461
     *         (i - ci) * grds                                                   PLOTS.5462
        end if                                                                   PLOTS.5463
                                                                                 PLOTS.5464
C  Calculate the Big Messy quantity as would be done, for lambert conformal      PLOTS.5465
C  projections.  This quantity is different in value, same in purpose of         PLOTS.5466
C  BM above                                                                      PLOTS.5467
                                                                                 PLOTS.5468
        if (clat .ge. 0.0) then                                                  PLOTS.5469
          bm = (1/re) * sqrt(dj**2 + di**2) /                                    PLOTS.5470
     *         (1.0 + cos(pi * 0.5 - (fsparl * pi/180.0)))                       PLOTS.5471
        else                                                                     PLOTS.5472
          bm = (1/re) * sqrt(dj**2 + di**2) /                                    PLOTS.5473
     *         (1.0 + cos(-pi * 0.5 - (fsparl * pi/180.0)))                      PLOTS.5474
        end if                                                                   PLOTS.5475
                                                                                 PLOTS.5476
C  Calculate the desired latitude in radians                                     PLOTS.5477
                                                                                 PLOTS.5478
        if (clat .ge. 0.0) then                                                  PLOTS.5479
          lat = pi * 0.5 - 2.0 * atan(bm)                                        PLOTS.5480
        else                                                                     PLOTS.5481
          lat = -pi * 0.5 + 2.0 * atan(bm)                                       PLOTS.5482
        end if                                                                   PLOTS.5483
                                                                                 PLOTS.5484
C  Calculate the desired longitude in radians                                    PLOTS.5485
                                                                                 PLOTS.5486
        if (clat .ge. 0.0) then                                                  PLOTS.5487
          lon = rcln + atan2(dj,-di)                                             PLOTS.5488
        else                                                                     PLOTS.5489
          lon = rcln + atan2(dj,di)                                              PLOTS.5490
        end if                                                                   PLOTS.5491
      end if                                                                     PLOTS.5492
                                                                                 PLOTS.5493
C  Convert the calculated lat,lon pair into degrees                              PLOTS.5494
                                                                                 PLOTS.5495
      lat = lat * 180.0/pi                                                       PLOTS.5496
      lon = lon * 180.0/pi                                                       PLOTS.5497
                                                                                 PLOTS.5498
C  Make sure no values are greater than 180 degrees and none                     PLOTS.5499
C  are less than -180 degrees                                                    PLOTS.5500
                                                                                 PLOTS.5501
      if (lon .gt. 180.0)  lon = lon - 360.0                                     PLOTS.5502
      if (lon .lt. -180.0) lon = lon + 360.0                                     PLOTS.5503
                                                                                 PLOTS.5504
C*****************************  Subroutine End  ******************************C  PLOTS.5505
                                                                                 PLOTS.5506
      return                                                                     PLOTS.5507
      end                                                                        PLOTS.5508
      subroutine condrv (indata,xdim,ydim,xstr,ystr,xend,yend,pnum,              PLOTS.5509
     *                   lmeth,levels,zl,mask,scale,title,tsize,unum,            PLOTS.5510
     *                   doset,errsev)                                           PLOTS.5511
                                                                                 PLOTS.5512
C*****************************************************************************C  PLOTS.5513
C  condrv   - Contour Driver                                                  C  PLOTS.5514
C                                                                             C  PLOTS.5515
C  Purpose  - This utility is intended as an interface to the CONPACK utility C  PLOTS.5516
C             in NCAR Graphics.   For reference to that utility look to  NCAR C  PLOTS.5517
C             Graphics Guide to New Utilities in the Contours section.   This C  PLOTS.5518
C             utility will allow the user to access all of the  power  of the C  PLOTS.5519
C             CONPACK utility through one call to this routine.  Data direct- C  PLOTS.5520
C             ives for this routine are passed in as  parameters and graphics C  PLOTS.5521
C             directives are read in from a table file.  This utility  should C  PLOTS.5522
C             be one hundred percent general and completely portable.         C  PLOTS.5523
C                                                                             C  PLOTS.5524
C  On entry - INDATA contains the data to be plotted.   XDIM and YDIM are the C  PLOTS.5525
C             x and y dimensions of  INDATA.   XSTR and  YSTR are the x and y C  PLOTS.5526
C             grid point at which to start plotting (lower left).    XEND and C  PLOTS.5527
C             YEND are the x and y grid point at which to quit plotting  (up- C  PLOTS.5528
C             per right).   PNUM contains the number that denotes which over- C  PLOTS.5529
C             this plot is.  LMETH specifies the method to use when determin- C  PLOTS.5530
C             ing contour levels.  Choices for LMETH are:                     C  PLOTS.5531
C             LMETH = 0  : CONDRV picks everything, defaults.   LEVELS is ig- C  PLOTS.5532
C               nored.                                                        C  PLOTS.5533
C             LMETH = -1 : A contour interval is given to use between a given C  PLOTS.5534
C               contour minimum and a given contour maximum. LEVELS(1) is the C  PLOTS.5535
C               contour  interval.    LEVELS(2)  is the contour  maximum  and C  PLOTS.5536
C               LEVELS(3) is the contour minimum.                             C  PLOTS.5537
C             LMETH = -2 : A contour interval is specified, CONDRV picks  the C  PLOTS.5538
C               contour minimum and maximum.   LEVELS(1) is that contour  in- C  PLOTS.5539
C               terval.                                                       C  PLOTS.5540
C             LMETH > 0  : LMETH is the number of levels the user wants.      C  PLOTS.5541
C               LEVELS is ignored.                                            C  PLOTS.5542
C             LMETH < -2 : ABS(LMETH) - 2 is  the  number of  levels the user C  PLOTS.5543
C               wants.  Each level is specified individually in LEVELS.       C  PLOTS.5544
C             ZL indicates whether a zero line should appear  on the plot  or C  PLOTS.5545
C             not.  SCALE is a scale factor to use when labeling the contours C  PLOTS.5546
C             and  TITLE  is the title string for the picture.   TSIZE is the C  PLOTS.5547
C             number of characters in TITLE.  If  TSIZE  is negative the con- C  PLOTS.5548
C             tour minimum, maximum and interval will be used as a title.  If C  PLOTS.5549
C             TSIZE is zero no title will be drawn.  UNUM is the unit  number C  PLOTS.5550
C             where the information tables may be found if UNUM is  positive. C  PLOTS.5551
C             If UNUM is negative, then no tables are to be used and defaults C  PLOTS.5552
C             are used.  If UNUM is 0 then the settings made by the last read C  PLOTS.5553
C             through tables should be used.  DOSET = 1 if CONDRV should make C  PLOTS.5554
C             the set call for the plot and is 0  if it should use the user's C  PLOTS.5555
C             set call and is -1  if it should make the set call  considering C  PLOTS.5556
C             cross points.   ERRSEV indicates what severity of  error should C  PLOTS.5557
C             halt CONDRV execution.                                          C  PLOTS.5558
C               ERRSEV > 0 means, nothing stops execution                     C  PLOTS.5559
C               ERRSEV = 0 means, errors stop execution, warnings do not      C  PLOTS.5560
C               ERRSEV < 0 means, both errors and warnings stop execution.    C  PLOTS.5561
C             MASK indicates if a map mask is to be made when contouring.  In C  PLOTS.5562
C             other words, if MASK is :                                       C  PLOTS.5563
C               NO - the contouring will be done like normal.                 C  PLOTS.5564
C               LO - contouring will be done over the land only               C  PLOTS.5565
C               LL - contouring will be done over the land and lakes          C  PLOTS.5566
C               OO - contouring will be done over the oceans only             C  PLOTS.5567
C               OL - contouring will be done over all water bodies.           C  PLOTS.5568
C             If MASK is not NO the MAPDRV must be called before CONDRV.      C  PLOTS.5569
C                                                                             C  PLOTS.5570
C  On exit  - A nice contour plot has been drawn to a CGM file including, all C  PLOTS.5571
C             requested labels and a title.                                   C  PLOTS.5572
C                                                                             C  PLOTS.5573
C  Assume   - GKS is open.  A color table has been defined.                   C  PLOTS.5574
C                                                                             C  PLOTS.5575
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5576
C             ----------------------------------------------------------------C  PLOTS.5577
C             INTERC              CONDRV utility                              C  PLOTS.5578
C             CRDDET              CONDRV utility                              C  PLOTS.5579
C             CRDCLT              CONDRV utility                              C  PLOTS.5580
C             CRDPRT              CONDRV utility                              C  PLOTS.5581
C             CSETWN              CONDRV utility                              C  PLOTS.5582
C             SETCON              CONDRV utility                              C  PLOTS.5583
C             SUBCON              CONDRV utility                              C  PLOTS.5584
C             CSETCL              CONDRV utility                              C  PLOTS.5585
C             CPSETR              CONPACK utility*                            C  PLOTS.5586
C             CONFIL              CONDRV utility                              C  PLOTS.5587
C             CONDRW              CONDRV utility                              C  PLOTS.5588
C             SETLIN              CONDRV utility                              C  PLOTS.5589
C             CONLBL              CONDRV utility                              C  PLOTS.5590
C             ----------------------------------------------------------------C  PLOTS.5591
C             * NCAR Graphics routine                                         C  PLOTS.5592
C                                                                             C  PLOTS.5593
C  Author   - Jeremy Asbill       Date - June 5, 1990       for the MM4 club  C  PLOTS.5594
C*****************************************************************************C  PLOTS.5595
                                                                                 PLOTS.5596
C  Character variables                                                           PLOTS.5597
                                                                                 PLOTS.5598
      character*120    title             ! title string for plot           (in)  PLOTS.5599
      character*2      mask              ! map masking indicator           (in)  PLOTS.5600
      character*2      cmask             ! changeable version of MASK   (local)  PLOTS.5601
                                                                                 PLOTS.5602
C  Integer variables                                                             PLOTS.5603
                                                                                 PLOTS.5604
      integer          xdim,             ! the x dimension of INDATA       (in)  PLOTS.5605
     *                 xend,             ! x coord. of last grid point     (in)  PLOTS.5606
     *                 xstr,             ! x coord. of first grid point    (in)  PLOTS.5607
     *                 ydim,             ! the y dimension of INDATA       (in)  PLOTS.5608
     *                 yend,             ! y coord. of last grid point     (in)  PLOTS.5609
     *                 ystr,             ! y coord. of first grid point    (in)  PLOTS.5610
     *                 pnum,             ! number of overlays current      (in)  PLOTS.5611
     *                 lmeth,            ! method of level specification   (in)  PLOTS.5612
     *                 tsize,            ! # of characters in TITLE        (in)  PLOTS.5613
     *                 unum,             ! unit number of info. files      (in)  PLOTS.5614
     *                 doset,            ! set call indicator              (in)  PLOTS.5615
     *                 errsev            ! error severity comparitor       (in)  PLOTS.5616
      integer          cmeth,            ! coloring method indicator    (local)  PLOTS.5617
     *                 ctsiz             ! changeable version of TSIZE  (local)  PLOTS.5618
                                                                                 PLOTS.5619
C  Logical variables                                                             PLOTS.5620
                                                                                 PLOTS.5621
      logical          zl                ! draw in the zero line ?         (in)  PLOTS.5622
      logical          noplt             ! for common block NOPLOT               PLOTS.5623
      logical          color,            ! is this a color plot ?       (local)  PLOTS.5624
     *                 lover             ! draw lines over the plot ?   (local)  PLOTS.5625
                                                                                 PLOTS.5626
C  Real variables                                                                PLOTS.5627
                                                                                 PLOTS.5628
      real             indata(xdim,ydim),! data array                      (in)  PLOTS.5629
     *                 levels(100),      ! individually specified levels   (in)  PLOTS.5630
     *                 scale             ! scaling factor for labeling     (in)  PLOTS.5631
                                                                                 PLOTS.5632
C  Common blocks                                                                 PLOTS.5633
                                                                                 PLOTS.5634
      common /noplot/  noplt             ! don't draw anything ?                 PLOTS.5635
                                                                                 PLOTS.5636
C****************************  subroutine begin  *****************************C  PLOTS.5637
                                                                                 PLOTS.5638
C  Initialize changeables                                                        PLOTS.5639
                                                                                 PLOTS.5640
      ctsiz      = tsize                                                         PLOTS.5641
      cmask(1:2) = mask(1:2)                                                     PLOTS.5642
                                                                                 PLOTS.5643
C  Check for any errors that may exist before starting                           PLOTS.5644
                                                                                 PLOTS.5645
      call interc (xstr,ystr,xend,yend,xdim,ydim,lmeth,pnum,                     PLOTS.5646
     *             ctsiz,cmask,errsev)                                           PLOTS.5647
                                                                                 PLOTS.5648
C  Set up detail variables                                                       PLOTS.5649
                                                                                 PLOTS.5650
      if (unum .ne. 0) then                                                      PLOTS.5651
        call crddet (unum,errsev,pnum,hfilb,tfilb,lfilb)                         PLOTS.5652
                                                                                 PLOTS.5653
C  Set up color variables with correct color indices                             PLOTS.5654
                                                                                 PLOTS.5655
        call crdclt (unum,errsev,hfilb,tfilb,lfilb,zl,cmeth)                     PLOTS.5656
                                                                                 PLOTS.5657
C  Set up any contouring partitions that might be needed                         PLOTS.5658
                                                                                 PLOTS.5659
        call crdprt (unum,errsev,cmeth,scale)                                    PLOTS.5660
      end if                                                                     PLOTS.5661
                                                                                 PLOTS.5662
C  If an non-correctable error has occurred skip all Design and Draw             PLOTS.5663
C  routines                                                                      PLOTS.5664
                                                                                 PLOTS.5665
      if (.not. noplt) then                                                      PLOTS.5666
                                                                                 PLOTS.5667
C  Set up the window to use when plotting                                        PLOTS.5668
                                                                                 PLOTS.5669
        call csetwn (xstr,ystr,xend,yend,doset)                                  PLOTS.5670
                                                                                 PLOTS.5671
C  Set up contouring method, including setting up the contour levels             PLOTS.5672
                                                                                 PLOTS.5673
        call setcon (lmeth,cmeth,levels,errsev)                                  PLOTS.5674
                                                                                 PLOTS.5675
C  Set up the scaling factor                                                     PLOTS.5676
                                                                                 PLOTS.5677
        call cpsetr ('SFS',scale)                                                PLOTS.5678
                                                                                 PLOTS.5679
C  Set up the correct subset of the data to be plotted                           PLOTS.5680
C  and initialize CONPACK                                                        PLOTS.5681
                                                                                 PLOTS.5682
        call subcon (indata,xdim,ydim,xstr,ystr,xend,yend)                       PLOTS.5683
                                                                                 PLOTS.5684
C  Set up the line width, dash pattern and the zero line                         PLOTS.5685
                                                                                 PLOTS.5686
        call setlin (zl)                                                         PLOTS.5687
      end if                                                                     PLOTS.5688
                                                                                 PLOTS.5689
C  Title will be drawn even if no plot is to be made                             PLOTS.5690
C  Set up colors and labels and title                                            PLOTS.5691
                                                                                 PLOTS.5692
      call csetcl (ctsiz,title,pnum,scale,errsev)                                PLOTS.5693
                                                                                 PLOTS.5694
C  If requested fill the plot (shade or solid fill)                              PLOTS.5695
                                                                                 PLOTS.5696
      if (.not. noplt) then                                                      PLOTS.5697
        call confil (lover,cmask)                                                PLOTS.5698
                                                                                 PLOTS.5699
C  Draw contour lines                                                            PLOTS.5700
                                                                                 PLOTS.5701
        if (lover) call condrw (cmask)                                           PLOTS.5702
                                                                                 PLOTS.5703
C  Draw in the labels                                                            PLOTS.5704
                                                                                 PLOTS.5705
        call conlbl (xstr,ystr,xend,yend)                                        PLOTS.5706
C       print *, 'CONDRV - Plot Successfully Completed'                          06NOV00.144
      end if                                                                     PLOTS.5708
                                                                                 PLOTS.5709
C*****************************  suroutine end  *******************************C  PLOTS.5710
                                                                                 PLOTS.5711
      return                                                                     PLOTS.5712
      end                                                                        PLOTS.5713
      subroutine condrw (mask)                                                   PLOTS.5714
                                                                                 PLOTS.5715
C*****************************************************************************C  PLOTS.5716
C  condrw   - This is a CONDRV routine                                        C  PLOTS.5717
C  Section  - Contour Lines                                                   C  PLOTS.5718
C  Purpose  - To draw contour lines to a plot.                                C  PLOTS.5719
C                                                                             C  PLOTS.5720
C  On entry - Needed information is passed in through common blocks. MASK in- C  PLOTS.5721
C             dicates how to draw the contours with respect to a map.         C  PLOTS.5722
C                                                                             C  PLOTS.5723
C  On exit  - The contour lines have been drawn.                              C  PLOTS.5724
C                                                                             C  PLOTS.5725
C  Assume   - GKS is open and everything is set up with CONPACK.              C  PLOTS.5726
C                                                                             C  PLOTS.5727
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5728
C             ----------------------------------------------------------------C  PLOTS.5729
C             ARINAM              AREAS utility*                              C  PLOTS.5730
C             CPLBAM              CONPACK utility*                            C  PLOTS.5731
C             CPCLDM              CONPACK utility*                            C  PLOTS.5732
C             CPCLDR              CONPACK utility*                            C  PLOTS.5733
C             ----------------------------------------------------------------C  PLOTS.5734
C             * NCAR Graphics routine                                         C  PLOTS.5735
C                                                                             C  PLOTS.5736
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.5737
C*****************************************************************************C  PLOTS.5738
                                                                                 PLOTS.5739
C  Character variables                                                           PLOTS.5740
                                                                                 PLOTS.5741
      character*2      mask              ! map masking indicator           (in)  PLOTS.5742
      character*2      cmask             ! for common block MAPFLI               PLOTS.5743
                                                                                 PLOTS.5744
C  Integer variables                                                             PLOTS.5745
                                                                                 PLOTS.5746
      integer          lputl,            ! for common block QLBDET               PLOTS.5747
     *                 tputl             ! for common block QLBDET               PLOTS.5748
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.5749
      integer          amapl(100000)     ! for common block CLNAMP               PLOTS.5750
      integer          aid(20),          ! area identifiers             (local)  PLOTS.5751
     *                 gid(20)           ! group identifiers            (local)  PLOTS.5752
                                                                                 PLOTS.5753
C  Logical variables                                                             PLOTS.5754
                                                                                 PLOTS.5755
      logical          hputl             ! for common block QLBDET               PLOTS.5756
      logical          hputb             ! for common block HLBDET               PLOTS.5757
                                                                                 PLOTS.5758
C  Real variables                                                                PLOTS.5759
                                                                                 PLOTS.5760
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.5761
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.5762
      real             xscm(2000),       ! work space for AREAS         (local)  PLOTS.5763
     *                 yscm(2000)        ! work space for AREAS         (local)  PLOTS.5764
                                                                                 PLOTS.5765
C  Common block                                                                  PLOTS.5766
                                                                                 PLOTS.5767
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.5768
     *                 lputl,            ! draw in line labels                   PLOTS.5769
     *                 tputl             ! draw in the title                     PLOTS.5770
      common /hlbdet/  hputb             ! draw a box around high/low labels ?   PLOTS.5771
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.5772
     *                 iwork,            ! integer work space for CONPACK        PLOTS.5773
     *                 rwork             ! real work space for CONPACK           PLOTS.5774
      common /clnamp/  amapl             ! area map for line drawing             PLOTS.5775
      common /mapfli/  cmask             ! common block version of MASK          PLOTS.5776
                                                                                 PLOTS.5777
C  External routines                                                             PLOTS.5778
                                                                                 PLOTS.5779
      external         drawcl            ! draws contour lines masked            PLOTS.5780
                                                                                 PLOTS.5781
C****************************  Subroutine Begin  *****************************C  PLOTS.5782
                                                                                 PLOTS.5783
C  Initialize CMASK                                                              PLOTS.5784
                                                                                 PLOTS.5785
      cmask(1:2) = mask(1:2)                                                     PLOTS.5786
                                                                                 PLOTS.5787
C  Initialize the area map                                                       PLOTS.5788
                                                                                 PLOTS.5789
      if ((mask(1:1) .eq. 'N') .or. (mask(1:1) .eq. 'n'))                        PLOTS.5790
     *  call arinam (amapl,100000)                                               PLOTS.5791
                                                                                 PLOTS.5792
C  Put the label boxes in the area map                                           PLOTS.5793
                                                                                 PLOTS.5794
      if ((hputb) .or. (lputl .gt. 0) .or.                                       PLOTS.5795
     *    ((mask(1:1) .ne. 'N') .and. (mask(1:1) .ne. 'n'))) then                PLOTS.5796
        call cplbam (mywork,rwork,iwork,amapl)                                   PLOTS.5797
                                                                                 PLOTS.5798
C  Use area map to mask high/lows in drawing                                     PLOTS.5799
                                                                                 PLOTS.5800
        call cpcldm (mywork,rwork,iwork,amapl,drawcl)                            PLOTS.5801
      else                                                                       PLOTS.5802
                                                                                 PLOTS.5803
C  Do not mask high/lows                                                         PLOTS.5804
                                                                                 PLOTS.5805
        call cpcldr (mywork,rwork,iwork)                                         PLOTS.5806
      end if                                                                     PLOTS.5807
                                                                                 PLOTS.5808
C*****************************  Subroutine End  ******************************C  PLOTS.5809
                                                                                 PLOTS.5810
      return                                                                     PLOTS.5811
      end                                                                        PLOTS.5812
      subroutine confil (lover,mask)                                             PLOTS.5813
                                                                                 PLOTS.5814
C*****************************************************************************C  PLOTS.5815
C  confil   - This is a CONDRV routine                                        C  PLOTS.5816
C  Section  - Fill                                                            C  PLOTS.5817
C  Purpose  - To direct the color and shade fill for the plot.                C  PLOTS.5818
C                                                                             C  PLOTS.5819
C  On entry - The data to be plotted is in common block DATAKP.  The fill in- C  PLOTS.5820
C             formation is in common block FILDET.  MASK indicated how the a- C  PLOTS.5821
C             rea map should be used with respect to a map.                   C  PLOTS.5822
C                                                                             C  PLOTS.5823
C  On exit  - LOVER is true if lines should be drawn over a filled plot  & is C  PLOTS.5824
C             true if the plot was not filled and is false otherwise.         C  PLOTS.5825
C                                                                             C  PLOTS.5826
C  Assume   - GKS is open.                                                    C  PLOTS.5827
C                                                                             C  PLOTS.5828
C  Notes    - Routine             Location of Definition                      C  PLOTS.5829
C             ----------------------------------------------------------------C  PLOTS.5830
C             ARINAM              AREAS utility*                              C  PLOTS.5831
C             CPCLAM              CONPACK utility*                            C  PLOTS.5832
C             CPLBAM              CONPACK utility*                            C  PLOTS.5833
C             SFSETP              SOFTFILL utility*                           C  PLOTS.5834
C             SFSETI              SOFTFILL utility*                           C  PLOTS.5835
C             ARSCAM              AREAS utility*                              C  PLOTS.5836
C             GSFAIS              GKS                                         C  PLOTS.5837
C             MKFCOL              CONDRV utility                              C  PLOTS.5838
C             ----------------------------------------------------------------C  PLOTS.5839
C             * NCAR Graphics Routine                                         C  PLOTS.5840
C                                                                             C  PLOTS.5841
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.5842
C*****************************************************************************C  PLOTS.5843
                                                                                 PLOTS.5844
C  Character variables                                                           PLOTS.5845
                                                                                 PLOTS.5846
      character*2      mask              ! map masking indicator           (in)  PLOTS.5847
      character*2      cmask             ! for common block MAPFLI               PLOTS.5848
                                                                                 PLOTS.5849
C  Integer variables                                                             PLOTS.5850
                                                                                 PLOTS.5851
      integer          lputl,            ! for common block QLBDET               PLOTS.5852
     *                 tputl             ! for common block QLBDET               PLOTS.5853
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.5854
      integer          amapf(5000000)     ! for common block CSCAMP              PLOTS.5855
      integer          aid(20),          ! area identifiers for AREAS   (local)  PLOTS.5856
     *                 gid(20),          ! group identifiers for AREAS  (local)  PLOTS.5857
     *                 pat(8,8),         ! dot pattern for shading      (local)  PLOTS.5858
     *                 i,j               ! loop counters                (local)  PLOTS.5859
                                                                                 PLOTS.5860
C  Logical variables                                                             PLOTS.5861
                                                                                 PLOTS.5862
      logical          lover             ! should lines be drawn ?        (out)  PLOTS.5863
      logical          fill,             ! for common block FILDET               PLOTS.5864
     *                 lshd,             ! for common block FILDET               PLOTS.5865
     *                 color             ! for common block FILDET               PLOTS.5866
      logical          hputl             ! for common block QLBDET               PLOTS.5867
      logical          hputb             ! for common block HLBDET               PLOTS.5868
                                                                                 PLOTS.5869
C  Real variables                                                                PLOTS.5870
                                                                                 PLOTS.5871
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.5872
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.5873
      real             xscam(200000),    ! work space for ARSCAM        (local)  PLOTS.5874
     *                 yscam(200000)     ! work space for ARSCAM        (local)  PLOTS.5875
                                                                                 PLOTS.5876
C  Common blocks                                                                 PLOTS.5877
                                                                                 PLOTS.5878
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.5879
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.5880
     *                 color             ! make the plot in color ?              PLOTS.5881
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.5882
     *                 lputl,            ! draw in line labels                   PLOTS.5883
     *                 tputl             ! draw in the title                     PLOTS.5884
      common /hlbdet/  hputb             ! draw a box around high/low labels ?   PLOTS.5885
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.5886
     *                 iwork,            ! integer work space for CONPACK        PLOTS.5887
     *                 rwork             ! real work space for CONPACK           PLOTS.5888
      common /cscamp/  amapf             ! area map for shade and color          PLOTS.5889
      common /mapfli/  cmask             ! common block version of MASK          PLOTS.5890
                                                                                 PLOTS.5891
C  External routines                                                             PLOTS.5892
                                                                                 PLOTS.5893
      external         shadem            ! does shade filling                    PLOTS.5894
      external         fillem            ! does color filling                    PLOTS.5895
                                                                                 PLOTS.5896
C****************************  Subroutine Begin  *****************************C  PLOTS.5897
                                                                                 PLOTS.5898
C  SOFTFILL internal parameters used in this routine are :                       PLOTS.5899
C  TY  - TYpe of fill                                                            PLOTS.5900
C  DO  - DOtted fill flag                                                        PLOTS.5901
                                                                                 PLOTS.5902
C  If no filling was requested, do nothing                                       PLOTS.5903
                                                                                 PLOTS.5904
      if (fill) then                                                             PLOTS.5905
                                                                                 PLOTS.5906
C  Initialize CMASK                                                              PLOTS.5907
                                                                                 PLOTS.5908
        cmask(1:2) = mask(1:2)                                                   PLOTS.5909
                                                                                 PLOTS.5910
C  Initialize the area map                                                       PLOTS.5911
                                                                                 PLOTS.5912
        if ((mask(1:1) .eq. 'N') .or. (mask(1:1) .eq. 'n'))                      PLOTS.5913
     *    call arinam (amapf,5000000)                                            PLOTS.5914
                                                                                 PLOTS.5915
C  And set up the area identifiers                                               PLOTS.5916
                                                                                 PLOTS.5917
        if (color) call mkfcol                                                   PLOTS.5918
                                                                                 PLOTS.5919
C  Put contour lines to the area map                                             PLOTS.5920
                                                                                 PLOTS.5921
        call cpclam (mywork,rwork,iwork,amapf)                                   PLOTS.5922
                                                                                 PLOTS.5923
C  Put the label boxes in the area map                                           PLOTS.5924
                                                                                 PLOTS.5925
        if ((hputb) .or. (lputl .gt. 0))                                         PLOTS.5926
     *    call cplbam (mywork,rwork,iwork,amapf)                                 PLOTS.5927
                                                                                 PLOTS.5928
C  Shade the plot if requested                                                   PLOTS.5929
                                                                                 PLOTS.5930
        if (.not. color) then                                                    PLOTS.5931
                                                                                 PLOTS.5932
C  If a label bar was made all should be set up                                  PLOTS.5933
                                                                                 PLOTS.5934
          if (tputl .ne. 0) then                                                 PLOTS.5935
                                                                                 PLOTS.5936
C  Make the fill a pattern fill                                                  PLOTS.5937
                                                                                 PLOTS.5938
            call gsfais (0)                                                      PLOTS.5939
                                                                                 PLOTS.5940
C  Set up a constant dot pattern                                                 PLOTS.5941
                                                                                 PLOTS.5942
            do 10 i = 1,8                                                        PLOTS.5943
              do 20 j = 1,8                                                      PLOTS.5944
                pat(i,j) = 1                                                     PLOTS.5945
20            continue                                                           PLOTS.5946
10          continue                                                             PLOTS.5947
                                                                                 PLOTS.5948
C  Set up the dot pattern with SOFTFILL                                          PLOTS.5949
                                                                                 PLOTS.5950
            call sfsetp (pat)                                                    PLOTS.5951
                                                                                 PLOTS.5952
C  Tell SOFTFILL to use dots in shading                                          PLOTS.5953
                                                                                 PLOTS.5954
            call sfseti ('TY',1)                                                 PLOTS.5955
            call sfseti ('DO',1)                                                 PLOTS.5956
          end if                                                                 PLOTS.5957
          call arscam (amapf,xscam,yscam,200000,aid,gid,20,shadem)               PLOTS.5958
        end if                                                                   PLOTS.5959
                                                                                 PLOTS.5960
C  Force a solid fill if not shading                                             PLOTS.5961
                                                                                 PLOTS.5962
        if (color) then                                                          PLOTS.5963
          call gsfais (1)                                                        PLOTS.5964
                                                                                 PLOTS.5965
C  Fill the plot if requested                                                    PLOTS.5966
                                                                                 PLOTS.5967
          call arscam (amapf,xscam,yscam,200000,aid,gid,20,fillem)               PLOTS.5968
        end if                                                                   PLOTS.5969
      end if                                                                     PLOTS.5970
                                                                                 PLOTS.5971
C  Determine if lines should be drawn                                            PLOTS.5972
                                                                                 PLOTS.5973
      if ((fill) .and. (lshd)) then                                              PLOTS.5974
        lover = .true.                                                           PLOTS.5975
      else if (.not. fill) then                                                  PLOTS.5976
        lover = .true.                                                           PLOTS.5977
      else                                                                       PLOTS.5978
        lover = .false.                                                          PLOTS.5979
      end if                                                                     PLOTS.5980
                                                                                 PLOTS.5981
C*****************************  Subroutine End  ******************************C  PLOTS.5982
                                                                                 PLOTS.5983
      return                                                                     PLOTS.5984
      end                                                                        PLOTS.5985
      subroutine conlbl (xstr,ystr,xend,yend)                                    PLOTS.5986
                                                                                 PLOTS.5987
C*****************************************************************************C  PLOTS.5988
C  conlbl   - This is a CONDRV routine                                        C  PLOTS.5989
C  Section  - Labels                                                          C  PLOTS.5990
C  Purpose  - To draw in, high/low labels,  line labels,  the title,  and the C  PLOTS.5991
C             perimeter.                                                      C  PLOTS.5992
C                                                                             C  PLOTS.5993
C  On entry - Needed information is passed in through common blocks.   Common C  PLOTS.5994
C             block  PERDET has the flag that indicates if a perimeter should C  PLOTS.5995
C             should be drawn.  XSTR & YSTR represent the first point of  the C  PLOTS.5996
C             grid to be plotted. XEND & YEND represent the last point of the C  PLOTS.5997
C             the grid to be plotted.                                         C  PLOTS.5998
C                                                                             C  PLOTS.5999
C  On exit  - The labels have been drawn.                                     C  PLOTS.6000
C                                                                             C  PLOTS.6001
C  Assume   - GKS is open.  The plot has been completed except for the labels C  PLOTS.6002
C             and they are all set up with CONPACK.                           C  PLOTS.6003
C                                                                             C  PLOTS.6004
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.6005
C             ----------------------------------------------------------------C  PLOTS.6006
C             GSFAIS              GKS                                         C  PLOTS.6007
C             CPLBDR              CONPACK utility*                            C  PLOTS.6008
C             DRWTTL              CONDRV utility                              C  PLOTS.6009
C             ----------------------------------------------------------------C  PLOTS.6010
C             * NCAR Graphics routine                                         C  PLOTS.6011
C                                                                             C  PLOTS.6012
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.6013
C*****************************************************************************C  PLOTS.6014
                                                                                 PLOTS.6015
C  Integer variables                                                             PLOTS.6016
                                                                                 PLOTS.6017
      integer          xstr,             ! x coord. of first plotted point (in)  PLOTS.6018
     *                 ystr,             ! y coord. of first plotted point (in)  PLOTS.6019
     *                 xend,             ! x coord. of last plotted point  (in)  PLOTS.6020
     *                 yend              ! y coord. of last plotted point  (in)  PLOTS.6021
      integer          lputl,            ! for common block QLBDET               PLOTS.6022
     *                 tputl             ! for common block QLBDET               PLOTS.6023
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.6024
                                                                                 PLOTS.6025
C  Logical variables                                                             PLOTS.6026
                                                                                 PLOTS.6027
      logical          hputl             ! for common block QLBDET               PLOTS.6028
      logical          prput             ! for common block PERDET               PLOTS.6029
                                                                                 PLOTS.6030
C  Real variables                                                                PLOTS.6031
                                                                                 PLOTS.6032
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.6033
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.6034
                                                                                 PLOTS.6035
C  Common blocks                                                                 PLOTS.6036
                                                                                 PLOTS.6037
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.6038
     *                 lputl,            ! draw in line labels                   PLOTS.6039
     *                 tputl             ! draw in the title                     PLOTS.6040
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.6041
     *                 iwork,            ! integer work space for CONPACK        PLOTS.6042
     *                 rwork             ! real work space for CONPACK           PLOTS.6043
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.6044
                                                                                 PLOTS.6045
C****************************  Subroutine Begin  *****************************C  PLOTS.6046
                                                                                 PLOTS.6047
C  Force a solid fill here for label box fills                                   PLOTS.6048
                                                                                 PLOTS.6049
      call gsfais (1)                                                            PLOTS.6050
                                                                                 PLOTS.6051
C  If the information label is suppose to be drawn, do so                        PLOTS.6052
                                                                                 PLOTS.6053
      if (tputl .gt. 0) call drwttl                                              PLOTS.6054
                                                                                 PLOTS.6055
C  If no labels are to be drawn do nothing                                       PLOTS.6056
                                                                                 PLOTS.6057
      if ((lputl .gt. 0) .or. (hputl)) then                                      PLOTS.6058
                                                                                 PLOTS.6059
C  Fill in the labels                                                            PLOTS.6060
                                                                                 PLOTS.6061
        call cplbdr (mywork,rwork,iwork)                                         PLOTS.6062
      end if                                                                     PLOTS.6063
                                                                                 PLOTS.6064
C  Draw a perimeter now if one was requested                                     PLOTS.6065
                                                                                 PLOTS.6066
      if (prput) call perim (0,xend-xstr,0,yend-ystr)                            PLOTS.6067
                                                                                 PLOTS.6068
C*****************************  Subroutine End  ******************************C  PLOTS.6069
                                                                                 PLOTS.6070
      return                                                                     PLOTS.6071
      end                                                                        PLOTS.6072
      subroutine connum (value,number,length)                                    PLOTS.6073
                                                                                 PLOTS.6074
C*****************************************************************************C  PLOTS.6075
C  connum   - This is a CONDRV routine                                        C  PLOTS.6076
C  Section  - Design                                                          C  PLOTS.6077
C  Purpose  - To convert real numbers into nice strings for PLOTCHAR use      C  PLOTS.6078
C                                                                             C  PLOTS.6079
C  On entry - VALUE is the number to convert                                  C  PLOTS.6080
C                                                                             C  PLOTS.6081
C  On exit  - NUMBER is the string representing VALUE.  LENGTH is the number  C  PLOTS.6082
C             of characters the conversion used.                              C  PLOTS.6083
C                                                                             C  PLOTS.6084
C  Assume   - Then string is to be for PLOTCHAR.                              C  PLOTS.6085
C                                                                             C  PLOTS.6086
C  Notes    - Routine             Location of Definition                      C  PLOTS.6087
C             ----------------------------------------------------------------C  PLOTS.6088
C             PCGETC              PLOTCHAR utility*                           C  PLOTS.6089
C             ----------------------------------------------------------------C  PLOTS.6090
C             * NCAR Graphics Routine                                         C  PLOTS.6091
C                                                                             C  PLOTS.6092
C  Author   - Jeremy Asbill      Date - October 31, 1990     for the MM4 club C  PLOTS.6093
C*****************************************************************************C  PLOTS.6094
                                                                                 PLOTS.6095
C  Character variables                                                           PLOTS.6096
                                                                                 PLOTS.6097
      character          cchar           ! PLOTCHAR command delimeter   (local)  PLOTS.6098
      character*20       number          ! the converted number           (out)  PLOTS.6099
                                                                                 PLOTS.6100
C  Integer variables                                                             PLOTS.6101
                                                                                 PLOTS.6102
      integer            length          ! the number of characters used  (out)  PLOTS.6103
      integer            adjust,         ! for counting exponents       (local)  PLOTS.6104
     *                   expon,          ! the numbers exponent         (local)  PLOTS.6105
     *                   start,          ! string place keeper          (local)  PLOTS.6106
     *                   i               ! loop counter                 (local)  PLOTS.6107
                                                                                 PLOTS.6108
C  Real variables                                                                PLOTS.6109
                                                                                 PLOTS.6110
      real               value           ! the number to convert           (in)  PLOTS.6111
      real               divis,          ! divisor for finding exponent (local)  PLOTS.6112
     *                   manti,          ! the numbers mantissa         (local)  PLOTS.6113
     *                   test            ! calculation variable         (local)  PLOTS.6114
                                                                                 PLOTS.6115
C****************************  Subroutine Begin  *****************************C  PLOTS.6116
                                                                                 PLOTS.6117
C  The following PLOTCHAR internal parameters are used:                          PLOTS.6118
C  FC  - Function Code delimeter character                                       PLOTS.6119
                                                                                 PLOTS.6120
C  Retrieve the current PLOTCHAR command character                               PLOTS.6121
                                                                                 PLOTS.6122
      call pcgetc ('FC',cchar)                                                   PLOTS.6123
                                                                                 PLOTS.6124
C  Determine the divisor for finding the exponent                                PLOTS.6125
                                                                                 PLOTS.6126
      if ((abs(value) .lt. 1.0) .and. (abs(value) .gt. 0.0)) then                PLOTS.6127
        divis  = 0.1                                                             PLOTS.6128
        adjust = -1                                                              PLOTS.6129
      else                                                                       PLOTS.6130
        divis  = 10.0                                                            PLOTS.6131
        adjust = 1                                                               PLOTS.6132
      end if                                                                     PLOTS.6133
                                                                                 PLOTS.6134
C  Determine the exponent                                                        PLOTS.6135
                                                                                 PLOTS.6136
      expon = 0                                                                  PLOTS.6137
      test  = abs(value)                                                         PLOTS.6138
10    continue                                                                   PLOTS.6139
      if (((test .lt. 1.0) .or. (test .ge. 10.0)) .and.                          PLOTS.6140
     *    (test .ne. 0.0)) then                                                  PLOTS.6141
        test  = test/divis                                                       PLOTS.6142
        expon = expon + adjust                                                   PLOTS.6143
        goto 10                                                                  PLOTS.6144
      end if                                                                     PLOTS.6145
                                                                                 PLOTS.6146
C  Get the mantissa from the previous loop                                       PLOTS.6147
                                                                                 PLOTS.6148
      if (value .lt. 0.0) then                                                   PLOTS.6149
        manti = -1.0 * test                                                      PLOTS.6150
      else                                                                       PLOTS.6151
        manti = test                                                             PLOTS.6152
      end if                                                                     PLOTS.6153
                                                                                 PLOTS.6154
C  Check to see if number should be drawn in exponential format                  PLOTS.6155
                                                                                 PLOTS.6156
      if ((expon .gt. 4) .or. (expon .lt. -3)) then                              PLOTS.6157
                                                                                 PLOTS.6158
C  Write the mantissa into the string                                            PLOTS.6159
                                                                                 PLOTS.6160
        if (manti .lt. 0.0) then                                                 PLOTS.6161
          write (number(1:6),20) manti                                           PLOTS.6162
          start = 7                                                              PLOTS.6163
        else                                                                     PLOTS.6164
          write (number(1:5),30) manti                                           PLOTS.6165
          start = 6                                                              PLOTS.6166
        end if                                                                   PLOTS.6167
                                                                                 PLOTS.6168
C  Clean trailing zeros                                                          PLOTS.6169
                                                                                 PLOTS.6170
        i = start - 1                                                            PLOTS.6171
5       continue                                                                 PLOTS.6172
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ') .or.              PLOTS.6173
     *      (number(i:i) .eq. '.')) then                                         PLOTS.6174
          i = i - 1                                                              PLOTS.6175
          goto 5                                                                 PLOTS.6176
        end if                                                                   PLOTS.6177
        start                   = i + 1                                          PLOTS.6178
        number(start:start+4)   = ' x 10'                                        PLOTS.6179
        number(start+5:start+5) = cchar                                          PLOTS.6180
        number(start+6:start+6) = 'S'                                            PLOTS.6181
        start = start + 7                                                        PLOTS.6182
                                                                                 PLOTS.6183
C  Write the exponent into the string                                            PLOTS.6184
                                                                                 PLOTS.6185
        if (expon .lt. 0) then                                                   PLOTS.6186
          if (expon .lt. -9) then                                                PLOTS.6187
            number(start:start)     = '3'                                        PLOTS.6188
            number(start+1:start+1) = cchar                                      PLOTS.6189
            write (number(start+2:start+4),40) expon                             PLOTS.6190
            length = start + 4                                                   PLOTS.6191
          else                                                                   PLOTS.6192
            number(start:start)     = '2'                                        PLOTS.6193
            number(start+1:start+1) = cchar                                      PLOTS.6194
            write (number(start+2:start+3),50) expon                             PLOTS.6195
            length = start + 3                                                   PLOTS.6196
          end if                                                                 PLOTS.6197
        else                                                                     PLOTS.6198
          if (expon .gt. 9) then                                                 PLOTS.6199
            number(start:start)     = '2'                                        PLOTS.6200
            number(start+1:start+1) = cchar                                      PLOTS.6201
            write (number(start+2:start+3),50) expon                             PLOTS.6202
            length = start + 3                                                   PLOTS.6203
          else                                                                   PLOTS.6204
            number(start:start)     = '1'                                        PLOTS.6205
            number(start+1:start+1) = cchar                                      PLOTS.6206
            write (number(start+2:start+2),60) expon                             PLOTS.6207
            length = start + 2                                                   PLOTS.6208
          end if                                                                 PLOTS.6209
        end if                                                                   PLOTS.6210
                                                                                 PLOTS.6211
C  If not exponent format write it normal                                        PLOTS.6212
                                                                                 PLOTS.6213
      else                                                                       PLOTS.6214
        if (value .lt. 0) then                                                   PLOTS.6215
          write (number(1:10),70) value                                          PLOTS.6216
          i = 10                                                                 PLOTS.6217
        else                                                                     PLOTS.6218
          write (number(1:9),80) value                                           PLOTS.6219
          i = 9                                                                  PLOTS.6220
        end if                                                                   PLOTS.6221
                                                                                 PLOTS.6222
C  Clean trailing zeros and spaces                                               PLOTS.6223
                                                                                 PLOTS.6224
15      continue                                                                 PLOTS.6225
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ') .or.              PLOTS.6226
     *      (number(i:i) .eq. '.')) then                                         PLOTS.6227
          i = i - 1                                                              PLOTS.6228
          goto 15                                                                PLOTS.6229
        end if                                                                   PLOTS.6230
        length = i                                                               PLOTS.6231
      end if                                                                     PLOTS.6232
                                                                                 PLOTS.6233
C  Clean leading blanks from the string                                          PLOTS.6234
                                                                                 PLOTS.6235
      if (length .eq. 0) then                                                    PLOTS.6236
        number(1:1) = '0'                                                        PLOTS.6237
        length      = 1                                                          PLOTS.6238
      else                                                                       PLOTS.6239
        i = 1                                                                    PLOTS.6240
25      continue                                                                 PLOTS.6241
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ')) then             PLOTS.6242
          i = i + 1                                                              PLOTS.6243
          goto 25                                                                PLOTS.6244
        end if                                                                   PLOTS.6245
        number (1:length - i + 1) = number (i:length)                            PLOTS.6246
        length = length - i + 1                                                  PLOTS.6247
      end if                                                                     PLOTS.6248
                                                                                 PLOTS.6249
C*****************************  Subroutine End  ******************************C  PLOTS.6250
                                                                                 PLOTS.6251
C  Format statements begin ...                                                   PLOTS.6252
                                                                                 PLOTS.6253
20    format (F6.3)                                                              PLOTS.6254
30    format (F5.3)                                                              PLOTS.6255
40    format (I3)                                                                PLOTS.6256
50    format (I2)                                                                PLOTS.6257
60    format (I1)                                                                PLOTS.6258
70    format (F10.3)                                                             PLOTS.6259
80    format (F9.3)                                                              PLOTS.6260
                                                                                 PLOTS.6261
C  Format statements end                                                         PLOTS.6262
                                                                                 PLOTS.6263
      return                                                                     PLOTS.6264
      end                                                                        PLOTS.6265
        subroutine cpchhl (flag)                                                 PLOTS.6266
                                                                                 PLOTS.6267
C*****************************************************************************C  PLOTS.6268
C  cpchhl   - This is for CONDRV                                              C  PLOTS.6269
C  Section  - CONPACK change routines                                         C  PLOTS.6270
C  Purpose  - To alter the character quality and the box fill color of the    C  PLOTS.6271
C             high low labels.                                                C  PLOTS.6272
C                                                                             C  PLOTS.6273
C  On entry - HQUAL in the common block HLQDET contains the necessary infor-  C  PLOTS.6274
C             maiton for character quality.  The common block BCOLORS has     C  PLOTS.6275
C             the box fill colors for the high low labels.                    C  PLOTS.6276
C                                                                             C  PLOTS.6277
C  On exit  - The PLOTCHAR internal parameters CD and QU have been set up     C  PLOTS.6278
C             properly.  The PLOTCHAR utility is documented in the NCAR       C  PLOTS.6279
C             Graphics Guide to New Utilities Version 3.00.                   C  PLOTS.6280
C             CD - Use Complex or Duplex characters                           C  PLOTS.6281
C             QU - High Low or Medium Quality                                 C  PLOTS.6282
C             CONPACK internal parameter LBC has been set up to fill high/low C  PLOTS.6283
C             label boxes with the right color.                               C  PLOTS.6284
C                                                                             C  PLOTS.6285
C  Assume   - GKS is open and either CPLBDR or CPLBDM has been called and is  C  PLOTS.6286
C             calling this routine.                                           C  PLOTS.6287
C                                                                             C  PLOTS.6288
C  Notes    - Routine             Location of Definition                      C  PLOTS.6289
C             ----------------------------------------------------------------C  PLOTS.6290
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.6291
C             GSFACI              GKS                                         C  PLOTS.6292
C             ----------------------------------------------------------------C  PLOTS.6293
C             * NCAR Graphics routine                                         C  PLOTS.6294
C                                                                             C  PLOTS.6295
C             This is a CONPACK change routine and is called by the CONPACK   C  PLOTS.6296
C             utility and NOT the CONDRV utility.                             C  PLOTS.6297
C                                                                             C  PLOTS.6298
C  Author   - Jeremy Asbill     Date - June 15, 1990 for the MM4 club.        C  PLOTS.6299
C*****************************************************************************C  PLOTS.6300
                                                                                 PLOTS.6301
C  Integer variables                                                             PLOTS.6302
                                                                                 PLOTS.6303
      integer          flag              ! indicates action in hi/lo draw  (in)  PLOTS.6304
      integer          hqual(2)          ! for common block HLQDET               PLOTS.6305
      integer          hcol(2),          ! for common block HLCOLS               PLOTS.6306
     *                 lcol(2)           ! for common block HLCOLS               PLOTS.6307
                                                                                 PLOTS.6308
C  Common blocks                                                                 PLOTS.6309
                                                                                 PLOTS.6310
      common /hlqdet/  hqual             ! quality of characters                 PLOTS.6311
      common /hlcols/  hcol,             ! high label box fill color             PLOTS.6312
     *                 lcol              ! low label box fill color              PLOTS.6313
                                                                                 PLOTS.6314
C****************************  subroutine begin  *****************************C  PLOTS.6315
                                                                                 PLOTS.6316
C  Test on flag, if flag is:                                                     PLOTS.6317
C       2 then a box for a high is about to be filled                            PLOTS.6318
C       3 then a label for a high is about to be drawn                           PLOTS.6319
C       6 then a box for a low is about to be filled                             PLOTS.6320
C       7 then a label for a low is about to be drawn                            PLOTS.6321
                                                                                 PLOTS.6322
      if ((flag .eq. 3) .or. (flag .eq. 7)) then                                 PLOTS.6323
                                                                                 PLOTS.6324
C  Set the character quality                                                     PLOTS.6325
                                                                                 PLOTS.6326
        call pcseti ('CD',hqual(1))                                              PLOTS.6327
        call pcseti ('QU',hqual(2))                                              PLOTS.6328
      else if (flag .eq. 2) then                                                 PLOTS.6329
                                                                                 PLOTS.6330
C  Set up high label box fill color index                                        PLOTS.6331
                                                                                 PLOTS.6332
        call gsfaci (hcol(2))                                                    PLOTS.6333
      else if (flag .eq. 6) then                                                 PLOTS.6334
                                                                                 PLOTS.6335
C  Set up low label box fill color index                                         PLOTS.6336
                                                                                 PLOTS.6337
        call gsfaci (lcol(2))                                                    PLOTS.6338
      end if                                                                     PLOTS.6339
                                                                                 PLOTS.6340
C*****************************  subroutine end  ******************************C  PLOTS.6341
                                                                                 PLOTS.6342
      return                                                                     PLOTS.6343
      end                                                                        PLOTS.6344
        subroutine cpchll (flag)                                                 PLOTS.6345
                                                                                 PLOTS.6346
C*****************************************************************************C  PLOTS.6347
C  cpchhl   - This is for CONDRV                                              C  PLOTS.6348
C  Section  - CONPACK change routines                                         C  PLOTS.6349
C  Purpose  - To alter the character quality of the line labels.  To properly C  PLOTS.6350
C             color the fills for line labels.                                C  PLOTS.6351
C                                                                             C  PLOTS.6352
C  On entry - LQUAL contains the information as to how the user wants to      C  PLOTS.6353
C             change the labels.  MFCOLOR and ZFCOLOR and MLCOLOR contain     C  PLOTS.6354
C             the indicies to use when coloring the labels.                   C  PLOTS.6355
C                                                                             C  PLOTS.6356
C  On exit  - The PLOTCHAR internal parameters CD and QU have been set up     C  PLOTS.6357
C             properly.  The PLOTCHAR utility is documented in the NCAR       C  PLOTS.6358
C             Graphics Guide to New Utilities Version 3.00.                   C  PLOTS.6359
C             CD - Use Complex or Duplex characters                           C  PLOTS.6360
C             QU - High Low or Medium Quality                                 C  PLOTS.6361
C             The proper indicies have been set up to color the fill boxes.   C  PLOTS.6362
C                                                                             C  PLOTS.6363
C  Assume   - GKS is open and either CPLBDR or CPLBDM has been called and is  C  PLOTS.6364
C             calling this routine.                                           C  PLOTS.6365
C                                                                             C  PLOTS.6366
C  Notes    - Routine             Location of Definition                      C  PLOTS.6367
C             ----------------------------------------------------------------C  PLOTS.6368
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.6369
C             GSFACI              GKS                                         C  PLOTS.6370
C             CPGETR              CONPACK utility*                            C  PLOTS.6371
C             CPSETI              CONPACK utility*                            C  PLOTS.6372
C             ----------------------------------------------------------------C  PLOTS.6373
C             * NCAR Graphics routine                                         C  PLOTS.6374
C                                                                             C  PLOTS.6375
C             This is a CONPACK change routine and is called by the CONPACK   C  PLOTS.6376
C             utility and NOT the CONDRV utility.                             C  PLOTS.6377
C                                                                             C  PLOTS.6378
C  Author   - Jeremy Asbill     Date - June 15, 1990 for the MM4 club.        C  PLOTS.6379
C*****************************************************************************C  PLOTS.6380
                                                                                 PLOTS.6381
C  Parameter                                                                     PLOTS.6382
                                                                                 PLOTS.6383
      parameter       (idcsp = -1)       ! indicates default color specified     PLOTS.6384
                                                                                 PLOTS.6385
C  Integer variables                                                             PLOTS.6386
                                                                                 PLOTS.6387
      integer          flag              ! indicates action label drawing  (in)  PLOTS.6388
      integer          lqual(2)          ! for common block LBQDET               PLOTS.6389
      integer          lbco(3)           ! for common block LBCOLS               PLOTS.6390
      integer          zcol(3)           ! for common block ZLCOLS               PLOTS.6391
      integer          linco             ! contour line color index     (local)  PLOTS.6392
                                                                                 PLOTS.6393
C  Logical variables                                                             PLOTS.6394
                                                                                 PLOTS.6395
      logical          hghlt,            ! for common block LBCOLS               PLOTS.6396
     *                 same,             ! for common block LBCOLS               PLOTS.6397
     *                 revrs             ! for common block LBCOLS               PLOTS.6398
                                                                                 PLOTS.6399
C  Real variables                                                                PLOTS.6400
                                                                                 PLOTS.6401
      real             clev              ! contour level value          (local)  PLOTS.6402
                                                                                 PLOTS.6403
C  Common blocks                                                                 PLOTS.6404
                                                                                 PLOTS.6405
      common /lbqdet/  lqual             ! quality of characters                 PLOTS.6406
      common /lbcols/  hghlt,            ! highlighted labeled lines ?           PLOTS.6407
     *                 same,             ! line same color as label ?            PLOTS.6408
     *                 revrs,            ! text and fill reverse after zero ?    PLOTS.6409
     *                 lbco              ! line label colors                     PLOTS.6410
      common /zrcols/  zcol              ! zero line colors                      PLOTS.6411
                                                                                 PLOTS.6412
                                                                                 PLOTS.6413
C****************************  subroutine begin  *****************************C  PLOTS.6414
                                                                                 PLOTS.6415
C  Test on flag, if flag is:                                                     PLOTS.6416
C       2 then a box is about to be filled                                       PLOTS.6417
C       3 then a label is about to be drawn                                      PLOTS.6418
                                                                                 PLOTS.6419
      if (flag .eq. 3) then                                                      PLOTS.6420
                                                                                 PLOTS.6421
C  Set the character quality                                                     PLOTS.6422
                                                                                 PLOTS.6423
        call pcseti ('CD',lqual(1))                                              PLOTS.6424
        call pcseti ('QU',lqual(2))                                              PLOTS.6425
                                                                                 PLOTS.6426
      else if (flag .eq. 2) then                                                 PLOTS.6427
                                                                                 PLOTS.6428
C  Watch for a box to be filled                                                  PLOTS.6429
                                                                                 PLOTS.6430
        call cpgetr ('CLV',clev)                                                 PLOTS.6431
        if (revrs) then                                                          PLOTS.6432
          if (clev .lt. 0.0) then                                                PLOTS.6433
            call gsfaci (lbco(2))                                                PLOTS.6434
          else if (clev .eq. 0.0) then                                           PLOTS.6435
            call gsfaci (zcol(2))                                                PLOTS.6436
          else if (clev .gt. 0.0) then                                           PLOTS.6437
            call gsfaci (lbco(3))                                                PLOTS.6438
          end if                                                                 PLOTS.6439
        else                                                                     PLOTS.6440
          call gsfaci (lbco(2))                                                  PLOTS.6441
        end if                                                                   PLOTS.6442
      end if                                                                     PLOTS.6443
                                                                                 PLOTS.6444
C*****************************  subroutine end  ******************************C  PLOTS.6445
                                                                                 PLOTS.6446
      return                                                                     PLOTS.6447
      end                                                                        PLOTS.6448
      subroutine cramps                                                          PLOTS.6449
                                                                                 PLOTS.6450
C*****************************************************************************C  PLOTS.6451
C  cramps   - This is a CONDRV routine                                        C  PLOTS.6452
C  Section  - Colors                                                          C  PLOTS.6453
C  Purpose  - To  calculate out ramps of colors.  The ramps change  gradually C  PLOTS.6454
C             from  one  color to another and are specified by the  partition C  PLOTS.6455
C             colors.                                                         C  PLOTS.6456
C                                                                             C  PLOTS.6457
C  On entry - All neccesary information is passed in through  common  blocks. C  PLOTS.6458
C                                                                             C  PLOTS.6459
C  On exit  - The variables NRMPS and  RAMPS have been set up in common block C  PLOTS.6460
C             RAMPSC.  NRMPS is a list of levels/partition. RAMPS is a set of C  PLOTS.6461
C             color ramps to use on the partitions.                           C  PLOTS.6462
C                                                                             C  PLOTS.6463
C  Assume   - GKS is open.  CONPACK has been initialized. Contour levels have C  PLOTS.6464
C             been set up.                                                    C  PLOTS.6465
C                                                                             C  PLOTS.6466
C  Notes    - Routine             Location of Definition                      C  PLOTS.6467
C             ----------------------------------------------------------------C  PLOTS.6468
C             CPGETI              CONPACK utility*                            C  PLOTS.6469
C             CPSETI              CONPACK utility*                            C  PLOTS.6470
C             CPGETR              CONPACK utility*                            C  PLOTS.6471
C             GQCR                GKS                                         C  PLOTS.6472
C             GSCR                GKS                                         C  PLOTS.6473
C             ----------------------------------------------------------------C  PLOTS.6474
C             * NCAR Graphics Routine                                         C  PLOTS.6475
C                                                                             C  PLOTS.6476
C  Author   - Jeremy Asbill       Date - June 8, 1990       for the MM4 club  C  PLOTS.6477
C*****************************************************************************C  PLOTS.6478
                                                                                 PLOTS.6479
C  Parameters                                                                    PLOTS.6480
                                                                                 PLOTS.6481
      parameter       (imin = -1)        ! since before the first contour level  PLOTS.6482
      parameter       (imax = 101)       ! until after the last contour level    PLOTS.6483
                                                                                 PLOTS.6484
C  Integer variables                                                             PLOTS.6485
                                                                                 PLOTS.6486
      integer          pcolor(100,2)     ! for common block PARCOL               PLOTS.6487
      integer          nprt,             ! for common block PARINF               PLOTS.6488
     *                 iprts(100,2)      ! for common block PARINF               PLOTS.6489
      integer          cmeth,            ! for common block COLIND               PLOTS.6490
     *                 bckco,            ! for common block COLIND               PLOTS.6491
     *                 rmeth             ! for common block COLIND               PLOTS.6492
      integer          nrmps(100),       ! for common block RAMPSC               PLOTS.6493
     *                 ramps(100,100)    ! for common block RAMPSC               PLOTS.6494
      integer          nclv,             ! # of contour levels total    (local)  PLOTS.6495
     *                 i,j,              ! loop counters/place keepers  (local)  PLOTS.6496
     *                 dum,temp,         ! temporary dummy values       (local)  PLOTS.6497
     *                 base              ! calculation variable         (local)  PLOTS.6498
                                                                                 PLOTS.6499
C  Logical variables                                                             PLOTS.6500
                                                                                 PLOTS.6501
      logical          ints              ! for common block PARINF               PLOTS.6502
                                                                                 PLOTS.6503
C  Real variables                                                                PLOTS.6504
                                                                                 PLOTS.6505
      real             rprts(100,2)      ! for common block PARINF               PLOTS.6506
      real             clev,             ! temporary contour level value(local)  PLOTS.6507
     *                 rindo,            ! COLONE's red portion         (local)  PLOTS.6508
     *                 rindt,            ! COLTWO's red portion         (local)  PLOTS.6509
     *                 rindn,            ! new color's red portion      (local)  PLOTS.6510
     *                 gindo,            ! COLONE's green portion       (local)  PLOTS.6511
     *                 gindt,            ! COLTWO's grren portion       (local)  PLOTS.6512
     *                 gindn,            ! new color's green portion    (local)  PLOTS.6513
     *                 bindo,            ! COLONE's blue portion        (local)  PLOTS.6514
     *                 bindt,            ! COLTWO's blue portion        (local)  PLOTS.6515
     *                 bindn,            ! new color's blue portion     (local)  PLOTS.6516
     *                 mpy,              ! calculation variable         (local)  PLOTS.6517
     *                 root,             ! calculation variable         (local)  PLOTS.6518
     *                 divn              ! calculation variable         (local)  PLOTS.6519
                                                                                 PLOTS.6520
C  Comon blocks                                                                  PLOTS.6521
                                                                                 PLOTS.6522
      common /colind/  cmeth,            ! method of color plot                  PLOTS.6523
     *                 bckco,            ! not used                              PLOTS.6524
     *                 rmeth             ! method of ramping colors              PLOTS.6525
      common /parinf/  nprt,             ! number of partitions                  PLOTS.6526
     *                 iprts,            ! integer partitions                    PLOTS.6527
     *                 rprts,            ! real partitions                       PLOTS.6528
     *                 ints              ! are the partitions integers ?         PLOTS.6529
      common /parcol/  pcolor            ! colors for each partition             PLOTS.6530
      common /rampsc/  nrmps,            ! # or levels/partition                 PLOTS.6531
     *                 ramps             ! color ramps                           PLOTS.6532
                                                                                 PLOTS.6533
C****************************  subroutine begin  *****************************C  PLOTS.6534
                                                                                 PLOTS.6535
C  CONPACK internal parameters used are:                                         PLOTS.6536
C  NCL - Number of Contour Levels                                                PLOTS.6537
C  PAI - Parameter Array Index                                                   PLOTS.6538
C  CLV - Contour LeVels                                                          PLOTS.6539
                                                                                 PLOTS.6540
C  Get the number of levels that are in the plot                                 PLOTS.6541
                                                                                 PLOTS.6542
      call cpgeti ('NCL',nclv)                                                   PLOTS.6543
                                                                                 PLOTS.6544
C  Ramps only need to be built if the coloring method is 4,5,6 or 7              PLOTS.6545
C  and there are contours                                                        PLOTS.6546
                                                                                 PLOTS.6547
      if ((cmeth .ge. 4) .and. (cmeth .le. 7) .and. (nclv .ne. 0)) then          PLOTS.6548
                                                                                 PLOTS.6549
C  Initialize the BASE of the color ramps                                        PLOTS.6550
                                                                                 PLOTS.6551
        base = 100                                                               PLOTS.6552
                                                                                 PLOTS.6553
C  Initialize partition levels counts                                            PLOTS.6554
                                                                                 PLOTS.6555
        do 10 i = 1,nprt                                                         PLOTS.6556
          nrmps(i) = 0                                                           PLOTS.6557
10      continue                                                                 PLOTS.6558
                                                                                 PLOTS.6559
C  Determine how many of levels exist within each partition                      PLOTS.6560
                                                                                 PLOTS.6561
        if ((.not. ints) .and. (cmeth .lt. 6)) then                              PLOTS.6562
          do 20 i = 1,nclv                                                       PLOTS.6563
            call cpseti ('PAI',i)                                                PLOTS.6564
            call cpgetr ('CLV',clev)                                             PLOTS.6565
            do 30 j = 1,nprt                                                     PLOTS.6566
              if ((clev .ge. rprts(j,1)) .and.                                   PLOTS.6567
     *            (clev .lt. rprts(j,2))) then                                   PLOTS.6568
                nrmps(j) = nrmps(j) + 1                                          PLOTS.6569
              end if                                                             PLOTS.6570
30          continue                                                             PLOTS.6571
20        continue                                                               PLOTS.6572
        else if ((ints) .and. (cmeth .lt. 6)) then                               PLOTS.6573
          do 40 i = 1,nprt                                                       PLOTS.6574
            if (iprts(i,1) .eq. imin) then                                       PLOTS.6575
              temp = 1                                                           PLOTS.6576
            else                                                                 PLOTS.6577
              temp = iprts(i,1)                                                  PLOTS.6578
            end if                                                               PLOTS.6579
            if (iprts(i,2) .eq. imax) then                                       PLOTS.6580
              dum  = nclv + 1                                                    PLOTS.6581
            else                                                                 PLOTS.6582
              dum  = iprts(i,2)                                                  PLOTS.6583
            end if                                                               PLOTS.6584
            nrmps(i) = dum - temp                                                PLOTS.6585
40        continue                                                               PLOTS.6586
        else if (cmeth .eq. 6) then                                              PLOTS.6587
          nprt = 5                                                               PLOTS.6588
          dum  = mod(nclv,5)                                                     PLOTS.6589
          temp = nclv/5                                                          PLOTS.6590
          nrmps(1) = temp                                                        PLOTS.6591
          nrmps(2) = temp                                                        PLOTS.6592
          nrmps(3) = temp                                                        PLOTS.6593
          nrmps(4) = temp                                                        PLOTS.6594
          nrmps(5) = temp                                                        PLOTS.6595
          do 90 i = 1,dum                                                        PLOTS.6596
            nrmps(i) = nrmps(i) + 1                                              PLOTS.6597
90        continue                                                               PLOTS.6598
        else if (cmeth .eq. 7) then                                              PLOTS.6599
          nprt = 5                                                               PLOTS.6600
          nrmps(1) = 20                                                          PLOTS.6601
          nrmps(2) = 20                                                          PLOTS.6602
          nrmps(3) = 20                                                          PLOTS.6603
          nrmps(4) = 20                                                          PLOTS.6604
          nrmps(5) = 20                                                          PLOTS.6605
        end if                                                                   PLOTS.6606
                                                                                 PLOTS.6607
C  Loop through the partitions, building, for each, individual ramps             PLOTS.6608
                                                                                 PLOTS.6609
        do 50 i = 1,nprt                                                         PLOTS.6610
                                                                                 PLOTS.6611
C  Retrieve from GKS the color representations specified                         PLOTS.6612
                                                                                 PLOTS.6613
          if (cmeth .lt. 6) then                                                 PLOTS.6614
            call gqcr (1,pcolor(i,1),0,ier,rindo,gindo,bindo)                    PLOTS.6615
            call gqcr (1,pcolor(i,2),0,ier,rindt,gindt,bindt)                    PLOTS.6616
            ramps(i,1) = pcolor(i,1)                                             PLOTS.6617
          else                                                                   PLOTS.6618
            if (i .eq. 1) then                                                   PLOTS.6619
              call gscr (1,250,0.0,0.0,1.0)                                      PLOTS.6620
              ramps(i,1) = 250                                                   PLOTS.6621
              rindo      = 0.0                                                   PLOTS.6622
              gindo      = 0.0                                                   PLOTS.6623
              bindo      = 1.0                                                   PLOTS.6624
              rindt      = 0.0                                                   PLOTS.6625
              gindt      = 1.0                                                   PLOTS.6626
              bindt      = 1.0                                                   PLOTS.6627
            else if (i .eq. 2) then                                              PLOTS.6628
              call gscr (1,251,0.0,1.0,1.0)                                      PLOTS.6629
              ramps(i,1) = 251                                                   PLOTS.6630
              rindo      = 0.0                                                   PLOTS.6631
              gindo      = 1.0                                                   PLOTS.6632
              bindo      = 1.0                                                   PLOTS.6633
              rindt      = 0.0                                                   PLOTS.6634
              gindt      = 1.0                                                   PLOTS.6635
              bindt      = 0.0                                                   PLOTS.6636
            else if (i .eq. 3) then                                              PLOTS.6637
              call gscr (1,252,0.0,1.0,0.0)                                      PLOTS.6638
              ramps(i,1) = 252                                                   PLOTS.6639
              rindo      = 0.0                                                   PLOTS.6640
              gindo      = 1.0                                                   PLOTS.6641
              bindo      = 0.0                                                   PLOTS.6642
              rindt      = 1.0                                                   PLOTS.6643
              gindt      = 1.0                                                   PLOTS.6644
              bindt      = 0.0                                                   PLOTS.6645
            else if (i .eq. 4) then                                              PLOTS.6646
              call gscr (1,253,1.0,1.0,0.0)                                      PLOTS.6647
              ramps(i,1) = 253                                                   PLOTS.6648
              rindo      = 1.0                                                   PLOTS.6649
              gindo      = 1.0                                                   PLOTS.6650
              bindo      = 0.0                                                   PLOTS.6651
              rindt      = 1.0                                                   PLOTS.6652
              gindt      = 0.5                                                   PLOTS.6653
              bindt      = 0.0                                                   PLOTS.6654
            else                                                                 PLOTS.6655
              call gscr (1,254,1.0,0.5,0.0)                                      PLOTS.6656
              ramps(i,1) = 254                                                   PLOTS.6657
              rindo      = 1.0                                                   PLOTS.6658
              gindo      = 0.5                                                   PLOTS.6659
              bindo      = 0.0                                                   PLOTS.6660
              rindt      = 1.0                                                   PLOTS.6661
              gindt      = 0.0                                                   PLOTS.6662
              bindt      = 0.0                                                   PLOTS.6663
            end if                                                               PLOTS.6664
          end if                                                                 PLOTS.6665
                                                                                 PLOTS.6666
C  Determine the function on which to vary the colors                            PLOTS.6667
                                                                                 PLOTS.6668
          if (rmeth .gt. 0) then                                                 PLOTS.6669
                                                                                 PLOTS.6670
C  RMETH > 0 means use a sine function                                           PLOTS.6671
                                                                                 PLOTS.6672
            divn = 3.14159/(float(nrmps(i)) + 1)                                 PLOTS.6673
            do 60 j = 2,nrmps(i)                                                 PLOTS.6674
              if (mod(i,2) .eq. 0) then                                          PLOTS.6675
                                                                                 PLOTS.6676
C  If the current partition is even go down the ramp instead of up it            PLOTS.6677
                                                                                 PLOTS.6678
                root  = (3.14159 * 0.5) + float(j) * divn                        PLOTS.6679
                mpy   = sin(root)                                                PLOTS.6680
                mpy   = (1.0 - mpy)/2.0                                          PLOTS.6681
              else                                                               PLOTS.6682
                                                                                 PLOTS.6683
C  If the current partition is odd go up the ramp                                PLOTS.6684
                                                                                 PLOTS.6685
                root  = (3.14159 * 3.0/2.0) + float(j) * divn                    PLOTS.6686
                mpy   = sin(root)                                                PLOTS.6687
                mpy   = (mpy + 1.0)/2.0                                          PLOTS.6688
              end if                                                             PLOTS.6689
                                                                                 PLOTS.6690
C  Determine the red, green and blue components of the new color                 PLOTS.6691
                                                                                 PLOTS.6692
              rindn = rindo + (rindt - rindo) * mpy                              PLOTS.6693
              gindn = gindo + (gindt - gindo) * mpy                              PLOTS.6694
              bindn = bindo + (bindt - bindo) * mpy                              PLOTS.6695
                                                                                 PLOTS.6696
C  Define the color in GKS                                                       PLOTS.6697
                                                                                 PLOTS.6698
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6699
                                                                                 PLOTS.6700
C  Add the color to the ramp                                                     PLOTS.6701
                                                                                 PLOTS.6702
              ramps(i,j) = base + j - 2                                          PLOTS.6703
60          continue                                                             PLOTS.6704
          else if (rmeth .lt. 0) then                                            PLOTS.6705
                                                                                 PLOTS.6706
C  RMETH < 0 means use an exponential function                                   PLOTS.6707
                                                                                 PLOTS.6708
            divn = 1.0/(float(nrmps(i)) + 1)                                     PLOTS.6709
            do 70 j = 2,nrmps(i)                                                 PLOTS.6710
              if (mod(i,2) .eq. 0) then                                          PLOTS.6711
                                                                                 PLOTS.6712
C  If the current partition is even go down the ramp instead of up it            PLOTS.6713
                                                                                 PLOTS.6714
                root  = 1.0 - float(j) * divn                                    PLOTS.6715
                mpy   = root**2                                                  PLOTS.6716
                                                                                 PLOTS.6717
C  Calculate the red, green and blue components for the new color                PLOTS.6718
                                                                                 PLOTS.6719
                rindn = rindt + (rindo - rindt) * mpy                            PLOTS.6720
                gindn = gindt + (gindo - gindt) * mpy                            PLOTS.6721
                bindn = bindt + (bindo - bindt) * mpy                            PLOTS.6722
              else                                                               PLOTS.6723
                                                                                 PLOTS.6724
C  If the curent partition is odd go down the ramp instead of up it              PLOTS.6725
                                                                                 PLOTS.6726
                root  = float(j) * divn                                          PLOTS.6727
                mpy   = root**2                                                  PLOTS.6728
                                                                                 PLOTS.6729
C  Calculate the red, green and blue components for the new color                PLOTS.6730
                                                                                 PLOTS.6731
                rindn = rindo + (rindt - rindo) * mpy                            PLOTS.6732
                gindn = gindo + (gindt - gindo) * mpy                            PLOTS.6733
                bindn = bindo + (bindt - bindo) * mpy                            PLOTS.6734
              end if                                                             PLOTS.6735
                                                                                 PLOTS.6736
C  Define the new color with GKS                                                 PLOTS.6737
                                                                                 PLOTS.6738
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6739
                                                                                 PLOTS.6740
C  Add the new color to the ramp                                                 PLOTS.6741
                                                                                 PLOTS.6742
              ramps(i,j) = base + j - 2                                          PLOTS.6743
70          continue                                                             PLOTS.6744
          else                                                                   PLOTS.6745
                                                                                 PLOTS.6746
C  RMETH = 0 means use a linear function                                         PLOTS.6747
                                                                                 PLOTS.6748
            divn = 1.0/(float(nrmps(i)) + 1)                                     PLOTS.6749
            do 80 j = 2,nrmps(i)                                                 PLOTS.6750
              mpy   = float(j) * divn                                            PLOTS.6751
                                                                                 PLOTS.6752
C  Calculate the red, green and blue color components of the new color           PLOTS.6753
                                                                                 PLOTS.6754
              rindn = rindo + (rindt - rindo) * mpy                              PLOTS.6755
              gindn = gindo + (gindt - gindo) * mpy                              PLOTS.6756
              bindn = bindo + (bindt - bindo) * mpy                              PLOTS.6757
                                                                                 PLOTS.6758
C  Define the new color with GKS                                                 PLOTS.6759
                                                                                 PLOTS.6760
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6761
                                                                                 PLOTS.6762
C  Add the new color to the ramps                                                PLOTS.6763
                                                                                 PLOTS.6764
              ramps(i,j) = base + j - 2                                          PLOTS.6765
80          continue                                                             PLOTS.6766
          end if                                                                 PLOTS.6767
                                                                                 PLOTS.6768
C  Increment BASE to be the first free color index after the last one in the     PLOTS.6769
C  last ramp                                                                     PLOTS.6770
                                                                                 PLOTS.6771
          if ((ramps(i,nrmps(i)) .ge. 100) .and.                                 PLOTS.6772
     *        (ramps(i,nrmps(i)) .lt. 200)) base = ramps(i,nrmps(i)) + 1         PLOTS.6773
50      continue                                                                 PLOTS.6774
C       print *, 'CONDRV - Color Ramps Created'                                  06NOV00.145
      end if                                                                     PLOTS.6776
                                                                                 PLOTS.6777
C*****************************  subroutine end  ******************************C  PLOTS.6778
                                                                                 PLOTS.6779
      return                                                                     PLOTS.6780
      end                                                                        PLOTS.6781
      subroutine crdclt (unum,errsev,hfilb,tfilb,lfilb,zl,ometh)                 PLOTS.6782
                                                                                 PLOTS.6783
C*****************************************************************************C  PLOTS.6784
C  crdclt   - This is a CONDRV routine                                        C  PLOTS.6785
C  Section  - Tables                                                          C  PLOTS.6786
C  Purpose  - To read in the proper color indexes to be used in a contour     C  PLOTS.6787
C             plot.                                                           C  PLOTS.6788
C                                                                             C  PLOTS.6789
C  On entry - COLOR indicates whether to look for the CON COLORS table.  UNUM C  PLOTS.6790
C             is the unit number on  which to look for  the table. ERRSEV in- C  PLOTS.6791
C             dicates what severity of error should halt execution.    HFILB, C  PLOTS.6792
C             TFILB  and  LFILB are logicals indicating if the high/low label C  PLOTS.6793
C             boxes, the title boxes and the line  label  boxes  respectively C  PLOTS.6794
C             should be fill.  ZL is true if a zero line will be drawn in the C  PLOTS.6795
C             plot.                                                           C  PLOTS.6796
C                                                                             C  PLOTS.6797
C  On exit  - OMETH  contains the  coloring method to use.   All variables in C  PLOTS.6798
C             common blocks HLCOLS, ZLCOLS, TLCOLS,  LBCOLS and  COLIND  have C  PLOTS.6799
C             been set up accordingly with the table.   See listing of  those C  PLOTS.6800
C             common blocks for more information.                             C  PLOTS.6801
C                                                                             C  PLOTS.6802
C  Assume   - Nothing                                                         C  PLOTS.6803
C                                                                             C  PLOTS.6804
C  Notes    - Routine             Location of Definition                      C  PLOTS.6805
C             ----------------------------------------------------------------C  PLOTS.6806
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.6807
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.6808
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.6809
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.6810
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.6811
C             CRDRCI              CONDRV/MAPDRV utility                       C  PLOTS.6812
C             ----------------------------------------------------------------C  PLOTS.6813
C                                                                             C  PLOTS.6814
C  Author   - Jeremy Asbill       Date - June 5, 1990       for the MM4 club  C  PLOTS.6815
C*****************************************************************************C  PLOTS.6816
                                                                                 PLOTS.6817
C  Parameters                                                                    PLOTS.6818
                                                                                 PLOTS.6819
      parameter       (idcsp = -1)       ! color index for defaults              PLOTS.6820
                                                                                 PLOTS.6821
C  Character variables                                                           PLOTS.6822
                                                                                 PLOTS.6823
      character*80     whline            ! a whole line from the table  (local)  PLOTS.6824
      character*60     ermes,            ! error message string,general (local)  PLOTS.6825
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.6826
     *                 q                 ! error message string,NEXT    (local)  PLOTS.6827
                                                                                 PLOTS.6828
C  Integer variables                                                             PLOTS.6829
                                                                                 PLOTS.6830
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.6831
     *                 unum              ! unit number of table file       (in)  PLOTS.6832
      integer          ometh             ! out version of CMETH           (out)  PLOTS.6833
      integer          cmeth,            ! for common block COLIND               PLOTS.6834
     *                 bckco,            ! for common block COLIND               PLOTS.6835
     *                 rmeth             ! for common block COLIND               PLOTS.6836
      integer          lputl,            ! for common block QLBDET               PLOTS.6837
     *                 tputl             ! for common block QLBDET               PLOTS.6838
      integer          hcol(2),          ! for common block HLCOLS               PLOTS.6839
     *                 lcol(2)           ! for common block HLCOLS               PLOTS.6840
      integer          zcol(3)           ! for common block ZLCOLS               PLOTS.6841
      integer          tcol(2)           ! for common block TLCOLS               PLOTS.6842
      integer          lbco(3)           ! for common block LBCOLS               PLOTS.6843
      integer          pcol              ! for common block PERCOL               PLOTS.6844
      integer          i                 ! place keeper                 (local)  PLOTS.6845
                                                                                 PLOTS.6846
C  Logical variables                                                             PLOTS.6847
                                                                                 PLOTS.6848
      logical          hfilb,            ! fill high/low label boxes ?     (in)  PLOTS.6849
     *                 tfilb,            ! fill title boxes ?              (in)  PLOTS.6850
     *                 lfilb,            ! fill line label boxes ?         (in)  PLOTS.6851
     *                 zl                ! draw the zero line ?            (in)  PLOTS.6852
      logical          noplt             ! for common block NOPLOT               PLOTS.6853
      logical          hputl             ! for common block QLBDET               PLOTS.6854
      logical          hghlt,            ! for common block LBCOLS               PLOTS.6855
     *                 same,             ! for common block LBCOLS               PLOTS.6856
     *                 revrs             ! for common block LBCOLS               PLOTS.6857
      logical          fill,             ! for common block FILDET               PLOTS.6858
     *                 lshd,             ! for common block FILDET               PLOTS.6859
     *                 color             ! for common block FILDET               PLOTS.6860
      logical          prput             ! for common block PERDET               PLOTS.6861
      logical          error,            ! has an error occured ?       (local)  PLOTS.6862
     *                 found,            ! was the table found ?        (local)  PLOTS.6863
     *                 test              ! is this true ?               (local)  PLOTS.6864
                                                                                 PLOTS.6865
C  Common blocks                                                                 PLOTS.6866
                                                                                 PLOTS.6867
      common /colind/  cmeth,            ! method of color plot                  PLOTS.6868
     *                 bckco,            ! backup color index                    PLOTS.6869
     *                 rmeth             ! method of ramping colors              PLOTS.6870
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.6871
     *                 lputl,            ! draw in line labels                   PLOTS.6872
     *                 tputl             ! draw in the title                     PLOTS.6873
      common /hlcols/  hcol,             ! high label colors                     PLOTS.6874
     *                 lcol              ! low label colors                      PLOTS.6875
      common /zrcols/  zcol              ! zero line colors                      PLOTS.6876
      common /tlcols/  tcol              ! title colors                          PLOTS.6877
      common /lbcols/  hghlt,            ! highlighted labeled lines ?           PLOTS.6878
     *                 same,             ! line same color as label ?            PLOTS.6879
     *                 revrs,            ! text and fill reverse after zero ?    PLOTS.6880
     *                 lbco              ! line label colors                     PLOTS.6881
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.6882
      common /percol/  pcol              ! color index for perimeter             PLOTS.6883
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.6884
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.6885
     *                 color             ! make the plot in color ?              PLOTS.6886
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.6887
                                                                                 PLOTS.6888
C****************************  subroutine begin  *****************************C  PLOTS.6889
                                                                                 PLOTS.6890
C  If a non-correctable error has occured, don't bother reading the table        PLOTS.6891
                                                                                 PLOTS.6892
      if (noplt) goto 90                                                         PLOTS.6893
                                                                                 PLOTS.6894
C  Assume the table is not there                                                 PLOTS.6895
                                                                                 PLOTS.6896
      found = .false.                                                            PLOTS.6897
                                                                                 PLOTS.6898
C  The table should only be there if this is a color plot, we should only        PLOTS.6899
C  parse it if this is a color plot                                              PLOTS.6900
                                                                                 PLOTS.6901
      if (color)                                                                 PLOTS.6902
                                                                                 PLOTS.6903
C  Look for the CON COLORS table                                                 PLOTS.6904
                                                                                 PLOTS.6905
     *  call tbllok (unum,'CON COLORS',errsev,found,whline,'CONDRV')             PLOTS.6906
                                                                                 PLOTS.6907
C  Initialize the error flag                                                     PLOTS.6908
                                                                                 PLOTS.6909
      error = .false.                                                            PLOTS.6910
                                                                                 PLOTS.6911
C  If the table was there to be read, parse through it                           PLOTS.6912
                                                                                 PLOTS.6913
      if (found) then                                                            PLOTS.6914
                                                                                 PLOTS.6915
C  Initialize the place keeper                                                   PLOTS.6916
                                                                                 PLOTS.6917
        i = 1                                                                    PLOTS.6918
                                                                                 PLOTS.6919
C  Set up SEARCH and NEXT error message strings                                  PLOTS.6920
                                                                                 PLOTS.6921
        p(1:22)  = 'Reading Colors Table, '                                      PLOTS.6922
        p(23:60) = 'Too Few Entries On Line               '                      PLOTS.6923
        q(1:22)  = p(1:22)                                                       PLOTS.6924
        q(23:60) = 'Entry Is Bizarre                      '                      PLOTS.6925
                                                                                 PLOTS.6926
C  CMETH is the first item in the color table                                    PLOTS.6927
C  0   => Use all the defaults                                                   PLOTS.6928
C  1   => A single color to color all contour lines                              PLOTS.6929
C  2   => User will specify a group of partitions with one color                 PLOTS.6930
C         used per partition; partitions specified by level values               PLOTS.6931
C  3   => User will specify a group of partitions with one color                 PLOTS.6932
C         used per partition; partitions specified by level numbers              PLOTS.6933
C  4   => User will specify a group of partitions; color ramping will            PLOTS.6934
C         be done between two colors for each partition; partitons               PLOTS.6935
C         specified by level value                                               PLOTS.6936
C  5   => User will specify a group of partitions; color ramping will            PLOTS.6937
C         be done between two colors for each partition; partitions              PLOTS.6938
C         specified by level number                                              PLOTS.6939
C  6   => CONDRV chooses four partions and ramp between :                        PLOTS.6940
C         partition 1 : Blue to Cyan                                             PLOTS.6941
C         partition 2 : Cyan to Green                                            PLOTS.6942
C         partition 3 : Green to Yellow                                          PLOTS.6943
C         partition 4 : Yellow to Red                                            PLOTS.6944
C  7   => CONDRV will force 100 contour levels, select four partitions and       PLOTS.6945
C         ramp as above                                                          PLOTS.6946
C  anything else will cause a warning message and CMETH = 1 will be assumed      PLOTS.6947
                                                                                 PLOTS.6948
        call search (whline,i,error)                                             PLOTS.6949
        if (error) then                                                          PLOTS.6950
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.6951
          found = .false.                                                        PLOTS.6952
          cmeth = -1                                                             PLOTS.6953
        end if                                                                   PLOTS.6954
                                                                                 PLOTS.6955
        if (.not. error) then                                                    PLOTS.6956
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.6957
            cmeth = 1                                                            PLOTS.6958
          else                                                                   PLOTS.6959
            read (whline(i:i),10,err=30) cmeth                                   PLOTS.6960
          end if                                                                 PLOTS.6961
          if ((cmeth .lt. 0) .or. (cmeth .gt. 7)) then                           PLOTS.6962
            ermes(1:30)  = 'Color Method Value Is Invalid,'                      PLOTS.6963
            ermes(31:60) = ' Options Are 0 Thru 7         '                      PLOTS.6964
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.6965
            cmeth = 1                                                            PLOTS.6966
          end if                                                                 PLOTS.6967
                                                                                 PLOTS.6968
C  CMETH = 0 Means all the defaults should be used, FOUND as false and           PLOTS.6969
C  ERROR as true will cause execution to lead right to the defaults assignments  PLOTS.6970
                                                                                 PLOTS.6971
          if (cmeth .eq. 0) then                                                 PLOTS.6972
            found = .false.                                                      PLOTS.6973
            call next (whline,i,error)                                           PLOTS.6974
            if (error) then                                                      PLOTS.6975
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.6976
            else                                                                 PLOTS.6977
              error = .true.                                                     PLOTS.6978
            end if                                                               PLOTS.6979
          end if                                                                 PLOTS.6980
          goto 35                                                                PLOTS.6981
                                                                                 PLOTS.6982
C  If there was an error during read give an error message                       PLOTS.6983
                                                                                 PLOTS.6984
30        ermes(1:30)  = 'Color Method Value Input Conve'                        PLOTS.6985
          ermes(31:60) = 'rsion                         '                        PLOTS.6986
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.6987
          cmeth = 1                                                              PLOTS.6988
          bckco = 1                                                              PLOTS.6989
                                                                                 PLOTS.6990
          error = .true.                                                         PLOTS.6991
                                                                                 PLOTS.6992
35        if (.not. error) then                                                  PLOTS.6993
            call next (whline,i,error)                                           PLOTS.6994
            if (error) then                                                      PLOTS.6995
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.6996
              bckco = 1                                                          PLOTS.6997
              rmeth = 0                                                          PLOTS.6998
            end if                                                               PLOTS.6999
          end if                                                                 PLOTS.7000
        end if                                                                   PLOTS.7001
                                                                                 PLOTS.7002
C  Next in line should always be BCKCO, which is the "BACKUP COLOR"              PLOTS.7003
C  BCKCO is used to color all contours when CMETH = 1                            PLOTS.7004
C  It is also used if any colors are accidentally left out of the table          PLOTS.7005
C  and it is used for any place that has a D or a d for the color                PLOTS.7006
                                                                                 PLOTS.7007
        if (.not. error) then                                                    PLOTS.7008
          call search (whline,i,error)                                           PLOTS.7009
          if (error) then                                                        PLOTS.7010
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7011
            bckco = 1                                                            PLOTS.7012
            rmeth = 0                                                            PLOTS.7013
          end if                                                                 PLOTS.7014
        end if                                                                   PLOTS.7015
                                                                                 PLOTS.7016
        call crdrci (.true.,error,bckco,1,whline,i,                              PLOTS.7017
     *               'Backup Color Index',18,errsev,noplt,                       PLOTS.7018
     *               'CONDRV')                                                   PLOTS.7019
        if (error) rmeth = 0                                                     PLOTS.7020
        if (noplt) goto 90                                                       PLOTS.7021
                                                                                 PLOTS.7022
        if (.not. error) then                                                    PLOTS.7023
          call next (whline,i,error)                                             PLOTS.7024
          if (error) then                                                        PLOTS.7025
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7026
            rmeth = 0                                                            PLOTS.7027
          end if                                                                 PLOTS.7028
        end if                                                                   PLOTS.7029
                                                                                 PLOTS.7030
C  Next item will be the ramping method if CMETH was specified as                PLOTS.7031
C  either 4 or 5                                                                 PLOTS.7032
                                                                                 PLOTS.7033
        if (((cmeth .eq. 4) .or. (cmeth .eq. 5)) .and.                           PLOTS.7034
     *      (.not. error)) then                                                  PLOTS.7035
          call search (whline,i,error)                                           PLOTS.7036
          if (error) then                                                        PLOTS.7037
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7038
            rmeth = 0                                                            PLOTS.7039
          end if                                                                 PLOTS.7040
        end if                                                                   PLOTS.7041
                                                                                 PLOTS.7042
C  L         => Linear Ramping                                                   PLOTS.7043
C  E         => Exponential Ramping                                              PLOTS.7044
C  S         => Sine Wavular Ramping Dude                                        PLOTS.7045
C  D         => Linear Ramping                                                   PLOTS.7046
C  anything else results in a warning message and linear ramping                 PLOTS.7047
                                                                                 PLOTS.7048
        if (((cmeth .eq. 4) .or. (cmeth .eq. 5)) .and.                           PLOTS.7049
     *      (.not. error)) then                                                  PLOTS.7050
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd') .or.            PLOTS.7051
     *        (whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.7052
            rmeth = 0                                                            PLOTS.7053
          else if ((whline(i:i) .eq. 'E') .or.                                   PLOTS.7054
     *             (whline(i:i) .eq. 'e')) then                                  PLOTS.7055
            rmeth = -1                                                           PLOTS.7056
          else if ((whline(i:i) .eq. 'S') .or.                                   PLOTS.7057
     *             (whline(i:i) .eq. 's')) then                                  PLOTS.7058
            rmeth = 1                                                            PLOTS.7059
          else                                                                   PLOTS.7060
            ermes(1:30)  = 'Ramping Method Flag Is Inconcl'                      PLOTS.7061
            ermes(31:60) = 'usive, L Assumed              '                      PLOTS.7062
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7063
            rmeth = 0                                                            PLOTS.7064
          end if                                                                 PLOTS.7065
                                                                                 PLOTS.7066
          call next (whline,i,error)                                             PLOTS.7067
          if (error)                                                             PLOTS.7068
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7069
        else                                                                     PLOTS.7070
          rmeth = 0                                                              PLOTS.7071
        end if                                                                   PLOTS.7072
                                                                                 PLOTS.7073
C  High label text and perimeter color is next                                   PLOTS.7074
C  D,d => use color index 1 (white)                                              PLOTS.7075
                                                                                 PLOTS.7076
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7077
          call search (whline,i,error)                                           PLOTS.7078
          if (error)                                                             PLOTS.7079
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7080
        end if                                                                   PLOTS.7081
                                                                                 PLOTS.7082
        call crdrci (hputl,error,hcol(1),1,whline,i,                             PLOTS.7083
     *               'High Label Color Index',22,errsev,noplt,                   PLOTS.7084
     *               'CONDRV')                                                   PLOTS.7085
        if (noplt) goto 90                                                       PLOTS.7086
                                                                                 PLOTS.7087
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7088
          call next (whline,i,error)                                             PLOTS.7089
          if (error)                                                             PLOTS.7090
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7091
        end if                                                                   PLOTS.7092
                                                                                 PLOTS.7093
C  If there was a box requested around the high labels and it is to be filled    PLOTS.7094
C  there should be a high fill color                                             PLOTS.7095
                                                                                 PLOTS.7096
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7097
          call search (whline,i,error)                                           PLOTS.7098
          if (error)                                                             PLOTS.7099
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7100
        end if                                                                   PLOTS.7101
                                                                                 PLOTS.7102
        call crdrci (hfilb,error,hcol(2),0,whline,i,                             PLOTS.7103
     *               'High Label Box Fill Color Index',32,errsev,                PLOTS.7104
     *               noplt,'CONDRV')                                             PLOTS.7105
        if (noplt) goto 90                                                       PLOTS.7106
                                                                                 PLOTS.7107
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7108
          call next (whline,i,error)                                             PLOTS.7109
          if (error)                                                             PLOTS.7110
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7111
        end if                                                                   PLOTS.7112
                                                                                 PLOTS.7113
C  Low label text and perimeter color is next                                    PLOTS.7114
C  D,d => use color index 1 (white)                                              PLOTS.7115
                                                                                 PLOTS.7116
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7117
          call search (whline,i,error)                                           PLOTS.7118
          if (error)                                                             PLOTS.7119
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7120
        end if                                                                   PLOTS.7121
                                                                                 PLOTS.7122
        call crdrci (hputl,error,lcol(1),1,whline,i,                             PLOTS.7123
     *               'Low Label Color Index',21,errsev,noplt,                    PLOTS.7124
     *               'CONDRV')                                                   PLOTS.7125
        if (noplt) goto 90                                                       PLOTS.7126
                                                                                 PLOTS.7127
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7128
          call next (whline,i,error)                                             PLOTS.7129
          if (error)                                                             PLOTS.7130
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7131
        end if                                                                   PLOTS.7132
                                                                                 PLOTS.7133
C  If there was a box requested around the low labels and it is to be filled     PLOTS.7134
C  there should be a low fill color                                              PLOTS.7135
                                                                                 PLOTS.7136
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7137
          call search (whline,i,error)                                           PLOTS.7138
          if (error)                                                             PLOTS.7139
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7140
        end if                                                                   PLOTS.7141
                                                                                 PLOTS.7142
        call crdrci (hfilb,error,lcol(2),0,whline,i,                             PLOTS.7143
     *               'Low Label Box Fill Color Index',31,errsev,                 PLOTS.7144
     *               noplt,'CONDRV')                                             PLOTS.7145
        if (noplt) goto 90                                                       PLOTS.7146
                                                                                 PLOTS.7147
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7148
          call next (whline,i,error)                                             PLOTS.7149
          if (error)                                                             PLOTS.7150
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7151
        end if                                                                   PLOTS.7152
                                                                                 PLOTS.7153
C  The zero line has three points in question                                    PLOTS.7154
C  First - Zero Line Label text and perimeter color index                        PLOTS.7155
C          D,d  => Use color of zero line                                        PLOTS.7156
                                                                                 PLOTS.7157
        if ((zl) .and. (lputl .eq. 1) .and. (.not. error)) then                  PLOTS.7158
          call search (whline,i,error)                                           PLOTS.7159
          if (error)                                                             PLOTS.7160
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7161
        end if                                                                   PLOTS.7162
                                                                                 PLOTS.7163
        if ((zl) .and. (lputl .eq. 1)) then                                      PLOTS.7164
          test = .true.                                                          PLOTS.7165
        else                                                                     PLOTS.7166
          test = .false.                                                         PLOTS.7167
        end if                                                                   PLOTS.7168
        call crdrci (test,error,zcol(1),idcsp,whline,i,                          PLOTS.7169
     *               'Zero Line Label Color Index',27,errsev,                    PLOTS.7170
     *               noplt,'CONDRV')                                             PLOTS.7171
        if (noplt) goto 90                                                       PLOTS.7172
                                                                                 PLOTS.7173
        if ((zl) .and. (lputl .eq. 1) .and. (.not. error)) then                  PLOTS.7174
          call next (whline,i,error)                                             PLOTS.7175
          if (error)                                                             PLOTS.7176
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7177
        end if                                                                   PLOTS.7178
                                                                                 PLOTS.7179
C  Second - Zero Line Label Box Fill Color index                                 PLOTS.7180
C           D,d  => Use black                                                    PLOTS.7181
                                                                                 PLOTS.7182
        if ((zl) .and. (lfilb) .and. (.not. error)) then                         PLOTS.7183
          call search (whline,i,error)                                           PLOTS.7184
          if (error)                                                             PLOTS.7185
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7186
        end if                                                                   PLOTS.7187
                                                                                 PLOTS.7188
        if ((zl) .and. (lfilb)) then                                             PLOTS.7189
          test = .true.                                                          PLOTS.7190
        else                                                                     PLOTS.7191
          test = .false.                                                         PLOTS.7192
        end if                                                                   PLOTS.7193
        call crdrci (test,error,zcol(2),0,whline,i,                              PLOTS.7194
     *               'Zero Line Label Box Fill Color Index',36,                  PLOTS.7195
     *               errsev,noplt,'CONDRV')                                      PLOTS.7196
        if (noplt) goto 90                                                       PLOTS.7197
                                                                                 PLOTS.7198
        if ((lfilb) .and. (zl) .and. (.not. error)) then                         PLOTS.7199
          call next (whline,i,error)                                             PLOTS.7200
          if (error)                                                             PLOTS.7201
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7202
        end if                                                                   PLOTS.7203
                                                                                 PLOTS.7204
C  Third - Zero Line color index                                                 PLOTS.7205
C          D,d  => Treat the zero line as any other line                         PLOTS.7206
                                                                                 PLOTS.7207
        if ((zl) .and. (.not. error) .and. (((fill) .and. (lshd)) .or.           PLOTS.7208
     *      (.not. fill))) then                                                  PLOTS.7209
          call search (whline,i,error)                                           PLOTS.7210
          if (error)                                                             PLOTS.7211
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7212
        end if                                                                   PLOTS.7213
                                                                                 PLOTS.7214
        if ((zl) .and. (((fill) .and. (lshd)) .or.                               PLOTS.7215
     *      (.not. fill))) then                                                  PLOTS.7216
          test = .true.                                                          PLOTS.7217
        else                                                                     PLOTS.7218
          test = .false.                                                         PLOTS.7219
        end if                                                                   PLOTS.7220
        call crdrci (test,error,zcol(3),idcsp,whline,i,                          PLOTS.7221
     *               'Zero Line Color Index',21,errsev,noplt,                    PLOTS.7222
     *               'CONDRV')                                                   PLOTS.7223
        if (noplt) goto 90                                                       PLOTS.7224
                                                                                 PLOTS.7225
        if ((zl) .and. (.not. error) .and. (((fill) .and. (lshd)) .or.           PLOTS.7226
     *      (.not. fill))) then                                                  PLOTS.7227
          call next (whline,i,error)                                             PLOTS.7228
          if (error)                                                             PLOTS.7229
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7230
        end if                                                                   PLOTS.7231
                                                                                 PLOTS.7232
C  Title text and perimeter color is next                                        PLOTS.7233
C  D,d => use color index 1 (white)                                              PLOTS.7234
                                                                                 PLOTS.7235
        if ((tputl .ge. 0) .and. (.not. error)) then                             PLOTS.7236
          call search (whline,i,error)                                           PLOTS.7237
          if (error)                                                             PLOTS.7238
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7239
        end if                                                                   PLOTS.7240
                                                                                 PLOTS.7241
        if (tputl .ge. 0) then                                                   PLOTS.7242
          test = .true.                                                          PLOTS.7243
        else                                                                     PLOTS.7244
          test = .false.                                                         PLOTS.7245
        end if                                                                   PLOTS.7246
        call crdrci (test,error,tcol(1),1,whline,i,                              PLOTS.7247
     *               'Title Color Index',17,errsev,noplt,                        PLOTS.7248
     *               'CONDRV')                                                   PLOTS.7249
        if (noplt) goto 90                                                       PLOTS.7250
                                                                                 PLOTS.7251
        if ((tputl .ge. 0) .and. (.not. error)) then                             PLOTS.7252
          call next (whline,i,error)                                             PLOTS.7253
          if (error)                                                             PLOTS.7254
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7255
        end if                                                                   PLOTS.7256
                                                                                 PLOTS.7257
C  If there was a box requested around the title and it is to be filled          PLOTS.7258
C  there should be a title fill color                                            PLOTS.7259
                                                                                 PLOTS.7260
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7261
          call search (whline,i,error)                                           PLOTS.7262
          if (error)                                                             PLOTS.7263
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7264
        end if                                                                   PLOTS.7265
                                                                                 PLOTS.7266
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7267
          test = .true.                                                          PLOTS.7268
        else                                                                     PLOTS.7269
          test = .false.                                                         PLOTS.7270
        end if                                                                   PLOTS.7271
        call crdrci (test,error,tcol(2),0,whline,i,                              PLOTS.7272
     *               'Title Box Fill Color Index',26,errsev,                     PLOTS.7273
     *               noplt,'CONDRV')                                             PLOTS.7274
        if (noplt) goto 90                                                       PLOTS.7275
                                                                                 PLOTS.7276
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7277
          call next (whline,i,error)                                             PLOTS.7278
          if (error)                                                             PLOTS.7279
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7280
        end if                                                                   PLOTS.7281
                                                                                 PLOTS.7282
C  Last Group - The Line Label Things                                            PLOTS.7283
C  Initialize variables                                                          PLOTS.7284
                                                                                 PLOTS.7285
        hghlt = .false.                                                          PLOTS.7286
        same  = .false.                                                          PLOTS.7287
        revrs = .false.                                                          PLOTS.7288
                                                                                 PLOTS.7289
C  First - The Line Label Flag, It may be :                                      PLOTS.7290
C  H  => Special Highlighted Lines and Labels, Don't read third                  PLOTS.7291
C  S  => Line color is given by the label color which is given third             PLOTS.7292
C  D  => Label color is the same as the line color which is given third          PLOTS.7293
C  R  => Label Text/Perimeter color and Box Fill color should be flipped         PLOTS.7294
C        at the zero line, lines default and text/perimeter color is given       PLOTS.7295
C        third                                                                   PLOTS.7296
C  #  => the color index for the label text/perimeter                            PLOTS.7297
                                                                                 PLOTS.7298
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7299
          call search (whline,i,error)                                           PLOTS.7300
          if (error)                                                             PLOTS.7301
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7302
        end if                                                                   PLOTS.7303
                                                                                 PLOTS.7304
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7305
          if ((whline(i:i) .eq. 'H') .or. (whline(i:i) .eq. 'h')) then           PLOTS.7306
            hghlt   = .true.                                                     PLOTS.7307
            lbco(1) = 0                                                          PLOTS.7308
          else if ((whline(i:i) .eq. 'S') .or.                                   PLOTS.7309
     *             (whline(i:i) .eq. 's')) then                                  PLOTS.7310
            same    = .true.                                                     PLOTS.7311
            lbco(1) = 0                                                          PLOTS.7312
          else if ((whline(i:i) .eq. 'R') .or.                                   PLOTS.7313
     *             (whline(i:i) .eq. 'r')) then                                  PLOTS.7314
            revrs   = .true.                                                     PLOTS.7315
            lbco(1) = 0                                                          PLOTS.7316
          else                                                                   PLOTS.7317
            call crdrci (.true.,error,lbco(1),idcsp,whline,i,                    PLOTS.7318
     *                   'Line Label Color',16,errsev,noplt,                     PLOTS.7319
     *                   'CONDRV')                                               PLOTS.7320
            if (noplt) goto 90                                                   PLOTS.7321
          end if                                                                 PLOTS.7322
        else                                                                     PLOTS.7323
          lbco(1) = 0                                                            PLOTS.7324
        end if                                                                   PLOTS.7325
                                                                                 PLOTS.7326
C  If the user requested zero line reversal and conrec style line labels         PLOTS.7327
C  tell then where they are wistling                                             PLOTS.7328
                                                                                 PLOTS.7329
        if ((lputl .eq. 0) .and. (revrs)) then                                   PLOTS.7330
          ermes(1:30)  = 'Zero Line Reversal And Conrec '                        PLOTS.7331
          ermes(31:60) = 'Style Labeling Do Not Mix     '                        PLOTS.7332
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.7333
          revrs = .false.                                                        PLOTS.7334
        end if                                                                   PLOTS.7335
                                                                                 PLOTS.7336
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7337
          call next (whline,i,error)                                             PLOTS.7338
          if (error)                                                             PLOTS.7339
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7340
        end if                                                                   PLOTS.7341
                                                                                 PLOTS.7342
C  Second - Line Label Box Fill color index                                      PLOTS.7343
C           D,d  => fill in black                                                PLOTS.7344
                                                                                 PLOTS.7345
        if ((lfilb) .and. (.not. error)) then                                    PLOTS.7346
          call search (whline,i,error)                                           PLOTS.7347
          if (error)                                                             PLOTS.7348
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7349
        end if                                                                   PLOTS.7350
                                                                                 PLOTS.7351
        call crdrci (lfilb,error,lbco(2),0,whline,i,                             PLOTS.7352
     *               'Line Label Fill Color Index',27,errsev,                    PLOTS.7353
     *               noplt,'CONDRV')                                             PLOTS.7354
        if (noplt) goto 90                                                       PLOTS.7355
                                                                                 PLOTS.7356
        if ((lfilb) .and. (.not. error)) then                                    PLOTS.7357
          call next (whline,i,error)                                             PLOTS.7358
          if (error)                                                             PLOTS.7359
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7360
        end if                                                                   PLOTS.7361
                                                                                 PLOTS.7362
C  Third - Labeled Line Color Index                                              PLOTS.7363
C          D,d  => treat it as any other contour line                            PLOTS.7364
                                                                                 PLOTS.7365
        if ((lputl .ge. 0) .and. (.not. hghlt) .and.                             PLOTS.7366
     *      (.not. error)) then                                                  PLOTS.7367
          call search (whline,i,error)                                           PLOTS.7368
          if (error)                                                             PLOTS.7369
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7370
        end if                                                                   PLOTS.7371
                                                                                 PLOTS.7372
        if ((lputl .ge. 0) .and. (.not. hghlt)) then                             PLOTS.7373
          test = .true.                                                          PLOTS.7374
        else                                                                     PLOTS.7375
          test = .false.                                                         PLOTS.7376
        end if                                                                   PLOTS.7377
        call crdrci (test,error,lbco(3),idcsp,whline,i,                          PLOTS.7378
     *               'Labeled Line Color Index',24,errsev,                       PLOTS.7379
     *               noplt,'CONDRV')                                             PLOTS.7380
        if (noplt) goto 90                                                       PLOTS.7381
                                                                                 PLOTS.7382
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7383
          call next (whline,i,error)                                             PLOTS.7384
          if (error)                                                             PLOTS.7385
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7386
        end if                                                                   PLOTS.7387
                                                                                 PLOTS.7388
C  If the user requested two different colors for the label and the line         PLOTS.7389
C  and requested CONREC style labels, tell them it ain't gonna work              PLOTS.7390
                                                                                 PLOTS.7391
        if ((lputl .eq. 0) .and. (lbco(1) .ne. lbco(3)) .and.                    PLOTS.7392
     *      (.not. same) .and. (.not. hghlt)) then                               PLOTS.7393
          ermes(1:30)  = 'Line And Labels Cannot Be Diff'                        PLOTS.7394
          ermes(31:60) = 'erent Colors With CONREC Style'                        PLOTS.7395
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.7396
          lbco(1) = -1                                                           PLOTS.7397
        end if                                                                   PLOTS.7398
                                                                                 PLOTS.7399
C  Perimeter color is next                                                       PLOTS.7400
C  D,d => use color index 1 (white)                                              PLOTS.7401
                                                                                 PLOTS.7402
        if ((prput) .and. (.not. error)) then                                    PLOTS.7403
          call search (whline,i,error)                                           PLOTS.7404
          if (error)                                                             PLOTS.7405
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7406
        end if                                                                   PLOTS.7407
                                                                                 PLOTS.7408
        call crdrci (prput,error,pcol,1,whline,i,                                PLOTS.7409
     *               'Perimeter Color Index',21,errsev,noplt,                    PLOTS.7410
     *               'CONDRV')                                                   PLOTS.7411
        if (noplt) goto 90                                                       PLOTS.7412
                                                                                 PLOTS.7413
        if ((prput) .and. (.not. error)) then                                    PLOTS.7414
          call next (whline,i,error)                                             PLOTS.7415
          if (error)                                                             PLOTS.7416
     *      call errhan ('CONDRV',0,q,errsev)                                    PLOTS.7417
        end if                                                                   PLOTS.7418
                                                                                 PLOTS.7419
C  Check for extra entries at the end of the line                                PLOTS.7420
                                                                                 PLOTS.7421
        if ((.not. error) .or. ((.not. found) .and.                              PLOTS.7422
     *      (cmeth .eq. 0))) then                                                PLOTS.7423
          call search (whline,i,error)                                           PLOTS.7424
          if (.not. error) then                                                  PLOTS.7425
            ermes(1:30)  = 'Reading Color Table, Too Many '                      PLOTS.7426
            ermes(31:60) = 'Entries On Line               '                      PLOTS.7427
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7428
          end if                                                                 PLOTS.7429
        end if                                                                   PLOTS.7430
                                                                                 PLOTS.7431
C  Inform the user all is at least okay                                          PLOTS.7432
                                                                                 PLOTS.7433
C       if (cmeth .ne. 0) print *, 'CONDRV - Contour Colors Set Up'              06NOV00.146
      end if                                                                     PLOTS.7435
                                                                                 PLOTS.7436
C  If the table was not found, assign the defaults                               PLOTS.7437
                                                                                 PLOTS.7438
      if (.not. found) then                                                      PLOTS.7439
C       print *, 'CONDRV - Default Contour Colors Used'                          06NOV00.147
        cmeth   = 0                                                              PLOTS.7441
        bckco   = 1                                                              PLOTS.7442
        rmeth   = 0                                                              PLOTS.7443
        hcol(1) = 1                                                              PLOTS.7444
        hcol(2) = 0                                                              PLOTS.7445
        lcol(1) = 1                                                              PLOTS.7446
        lcol(2) = 0                                                              PLOTS.7447
        zcol(1) = 1                                                              PLOTS.7448
        zcol(2) = 0                                                              PLOTS.7449
        zcol(3) = 1                                                              PLOTS.7450
        tcol(1) = 1                                                              PLOTS.7451
        tcol(2) = 0                                                              PLOTS.7452
        hghlt   = .false.                                                        PLOTS.7453
        same    = .false.                                                        PLOTS.7454
        revrs   = .false.                                                        PLOTS.7455
        lbco(1) = 1                                                              PLOTS.7456
        lbco(2) = 0                                                              PLOTS.7457
        lbco(3) = 1                                                              PLOTS.7458
        pcol    = 1                                                              PLOTS.7459
      end if                                                                     PLOTS.7460
                                                                                 PLOTS.7461
C  Set up output variable                                                        PLOTS.7462
                                                                                 PLOTS.7463
      ometh = cmeth                                                              PLOTS.7464
                                                                                 PLOTS.7465
C*****************************  subroutine end  ******************************C  PLOTS.7466
                                                                                 PLOTS.7467
C  Format statements begin ...                                                   PLOTS.7468
                                                                                 PLOTS.7469
10    format (I1)                                                                PLOTS.7470
20    format (I2)                                                                PLOTS.7471
                                                                                 PLOTS.7472
C  Format statements end.                                                        PLOTS.7473
                                                                                 PLOTS.7474
90    return                                                                     PLOTS.7475
      end                                                                        PLOTS.7476
                                                                                 PLOTS.7477
      subroutine crddet (unum,errsev,pnum,hfilb,tfilb,lfilb)                     PLOTS.7478
                                                                                 PLOTS.7479
C*****************************************************************************C  PLOTS.7480
C  crddet   - this is a CONDRV routine                                        C  PLOTS.7481
C  Section  - Tables                                                          C  PLOTS.7482
C  Purpose  - To read in the entire details table including:  Color, shading, C  PLOTS.7483
C             line width and dash pattern characteristics; High/Low label in- C  PLOTS.7484
C             formation; Line Label information; and Title details.           C  PLOTS.7485
C                                                                             C  PLOTS.7486
C  On entry - UNUM is the unit number from which to read the table.    ERRSEV C  PLOTS.7487
C             indicates at what severity of error execution should halt. PNUM C  PLOTS.7488
C             is the number of call this was to CONDRV within one frame.      C  PLOTS.7489
C                                                                             C  PLOTS.7490
C  On exit  - All CONDRV variables associated with the aforementioned details C  PLOTS.7491
C             have been set up.  See common blocks in this routine and in the C  PLOTS.7492
C             routines CRDHLO, CRDLAB, CRDTTL for more information. The three C  PLOTS.7493
C             variables, HFILB, TFILB and LFILB indicate whether boxes around C  PLOTS.7494
C             the high/low labels, the title and the line labels respectively C  PLOTS.7495
C             are to be filled.                                               C  PLOTS.7496
C                                                                             C  PLOTS.7497
C  Assume   - Nothing                                                         C  PLOTS.7498
C                                                                             C  PLOTS.7499
C  Notes    - Routine             Location of Definition                      C  PLOTS.7500
C             ----------------------------------------------------------------C  PLOTS.7501
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.7502
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.7503
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.7504
C             CRDHLO              CONDRV utility                              C  PLOTS.7505
C             CRDLAB              CONDRV utility                              C  PLOTS.7506
C             CRDTTL              CONDRV utility                              C  PLOTS.7507
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.7508
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.7509
C             ----------------------------------------------------------------C  PLOTS.7510
C                                                                             C  PLOTS.7511
C  Author   - Jeremy Asbill      Date - June 6, 1990        for the MM4 club  C  PLOTS.7512
C*****************************************************************************C  PLOTS.7513
                                                                                 PLOTS.7514
C  Parameter                                                                     PLOTS.7515
                                                                                 PLOTS.7516
      parameter       (wltwo = 2.0)      ! line width for even overlays          PLOTS.7517
                                                                                 PLOTS.7518
C  Character variables                                                           PLOTS.7519
                                                                                 PLOTS.7520
      character*80     whline            ! a whole line from the table  (local)  PLOTS.7521
      character*60     ermes,            ! error message string         (local)  PLOTS.7522
     *                 p,                ! error message string, SEARCH (local)  PLOTS.7523
     *                 q                 ! error message string, NEXT   (local)  PLOTS.7524
      character*20     tstrg             ! temporary string             (local)  PLOTS.7525
                                                                                 PLOTS.7526
C  Integer variables                                                             PLOTS.7527
                                                                                 PLOTS.7528
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.7529
     *                 unum,             ! unit number of info. file       (in)  PLOTS.7530
     *                 pnum              ! overlay indicator               (in)  PLOTS.7531
      integer          ddpv(3)           ! for common block LWDPDT               PLOTS.7532
      integer          lputl,            ! for common block QLBDET               PLOTS.7533
     *                 tputl             ! for common block QLBDET               PLOTS.7534
      integer          dlwi,             ! line width partition indic.  (local)  PLOTS.7535
     *                 ddpi,             ! dash pat. partition indic.   (local)  PLOTS.7536
     *                 i,j,k,n           ! loop counter/place keepers   (local)  PLOTS.7537
                                                                                 PLOTS.7538
C  Logical variables                                                             PLOTS.7539
                                                                                 PLOTS.7540
      logical          hfilb,            ! fill high/low label boxes ?    (out)  PLOTS.7541
     *                 lfilb,            ! fill line label boxes ?        (out)  PLOTS.7542
     *                 tfilb             ! fill title box ?               (out)  PLOTS.7543
      logical          noplt             ! for common block NOPLOT               PLOTS.7544
      logical          fshd              ! for common block SHDDIR               PLOTS.7545
      logical          hputl             ! for common block QLBDET               PLOTS.7546
      logical          fill,             ! for common block FILDET               PLOTS.7547
     *                 lshd,             ! for common block FILDET               PLOTS.7548
     *                 color             ! for common block FILDET               PLOTS.7549
      logical          prput             ! for common block PERDET               PLOTS.7550
      logical          error,            ! error reading table ?        (local)  PLOTS.7551
     *                 found,            ! is the table there ?         (local)  PLOTS.7552
     *                 done,             ! loop test flag ?             (local)  PLOTS.7553
     *                 dash              ! has dash pattern been read ? (local)  PLOTS.7554
                                                                                 PLOTS.7555
C  Real variables                                                                PLOTS.7556
                                                                                 PLOTS.7557
      real             dlwv(3)           ! for common block LWDPDT               PLOTS.7558
      real             temp              ! temporary storage            (local)  PLOTS.7559
                                                                                 PLOTS.7560
C  Common blocks                                                                 PLOTS.7561
                                                                                 PLOTS.7562
      common /shddir/  fshd              ! should shading go from low to high ?  PLOTS.7563
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.7564
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.7565
     *                 color             ! make the plot in color ?              PLOTS.7566
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.7567
     *                 lputl,            ! draw in line labels                   PLOTS.7568
     *                 tputl             ! draw in the title                     PLOTS.7569
      common /lwdpdt/  dlwv,             ! details line width values             PLOTS.7570
     *                 ddpv              ! details dash pattern values           PLOTS.7571
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.7572
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.7573
                                                                                 PLOTS.7574
C****************************  subroutine begin  *****************************C  PLOTS.7575
                                                                                 PLOTS.7576
C  Check if we need to read in the table at all                                  PLOTS.7577
                                                                                 PLOTS.7578
      if (noplt) goto 130                                                        PLOTS.7579
                                                                                 PLOTS.7580
C  Initialze ERROR and output flags                                              PLOTS.7581
                                                                                 PLOTS.7582
      error = .false.                                                            PLOTS.7583
      lfilb = .false.                                                            PLOTS.7584
      hfilb = .false.                                                            PLOTS.7585
      tfilb = .false.                                                            PLOTS.7586
                                                                                 PLOTS.7587
C  Look for the table                                                            PLOTS.7588
                                                                                 PLOTS.7589
      call tbllok (unum,'CON DETAIL',errsev,found,whline,'CONDRV')               PLOTS.7590
                                                                                 PLOTS.7591
C  If the table was there parse the input                                        PLOTS.7592
                                                                                 PLOTS.7593
      if (found) then                                                            PLOTS.7594
                                                                                 PLOTS.7595
C  Initialize the place keeper                                                   PLOTS.7596
                                                                                 PLOTS.7597
        i = 1                                                                    PLOTS.7598
                                                                                 PLOTS.7599
C  Set up error messages got errors in SEARCH and NEXT                           PLOTS.7600
                                                                                 PLOTS.7601
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.7602
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.7603
        q(1:23)  = p(1:23)                                                       PLOTS.7604
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.7605
                                                                                 PLOTS.7606
C  Parse the line starting with the color flag                                   PLOTS.7607
C  Y             => the plot will be color                                       PLOTS.7608
C  N             => the plot will not be color                                   PLOTS.7609
C  anything else => gives a waring                                               PLOTS.7610
                                                                                 PLOTS.7611
        call search (whline,i,error)                                             PLOTS.7612
        if (error) then                                                          PLOTS.7613
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.7614
          color   = .false.                                                      PLOTS.7615
          fill    = .false.                                                      PLOTS.7616
          hputl   = .true.                                                       PLOTS.7617
          lputl   = 0                                                            PLOTS.7618
          tputl   = 1                                                            PLOTS.7619
          prput   = .false.                                                      PLOTS.7620
        end if                                                                   PLOTS.7621
                                                                                 PLOTS.7622
        if (.not. error) then                                                    PLOTS.7623
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7624
            color = .true.                                                       PLOTS.7625
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7626
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7627
            color = .false.                                                      PLOTS.7628
          else                                                                   PLOTS.7629
            ermes(1:30)  = 'Color Flag Entry Is Inconclusi'                      PLOTS.7630
            ermes(31:60) = 've, N Assumed                 '                      PLOTS.7631
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7632
            color = .false.                                                      PLOTS.7633
          end if                                                                 PLOTS.7634
          call next (whline,i,error)                                             PLOTS.7635
          if (error) then                                                        PLOTS.7636
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7637
            fill    = .false.                                                    PLOTS.7638
            hputl   = .true.                                                     PLOTS.7639
            lputl   = 0                                                          PLOTS.7640
            tputl   = 1                                                          PLOTS.7641
            prput   = .false.                                                    PLOTS.7642
          end if                                                                 PLOTS.7643
        end if                                                                   PLOTS.7644
                                                                                 PLOTS.7645
C  Check to see if the plot will be filled                                       PLOTS.7646
C  Y             => the plot will be filled                                      PLOTS.7647
C  N             => the plot will not be filled                                  PLOTS.7648
C  anything else => gives a warning message                                      PLOTS.7649
                                                                                 PLOTS.7650
        if (.not. error) then                                                    PLOTS.7651
          call search (whline,i,error)                                           PLOTS.7652
          if (error) then                                                        PLOTS.7653
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7654
            fill    = .false.                                                    PLOTS.7655
            hputl   = .true.                                                     PLOTS.7656
            lputl   = 0                                                          PLOTS.7657
            tputl   = 1                                                          PLOTS.7658
            prput   = .false.                                                    PLOTS.7659
          end if                                                                 PLOTS.7660
        end if                                                                   PLOTS.7661
                                                                                 PLOTS.7662
        if (.not. error) then                                                    PLOTS.7663
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7664
            fill = .true.                                                        PLOTS.7665
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7666
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7667
            fill = .false.                                                       PLOTS.7668
          else                                                                   PLOTS.7669
            ermes(1:30)  = 'Fill Flag Entry Is Inconclusiv'                      PLOTS.7670
            ermes(31:60) = 'e, N Assumed                  '                      PLOTS.7671
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7672
            fill = .false.                                                       PLOTS.7673
          end if                                                                 PLOTS.7674
          call next (whline,i,error)                                             PLOTS.7675
          if (error) then                                                        PLOTS.7676
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7677
            hputl   = .true.                                                     PLOTS.7678
            lputl   = 0                                                          PLOTS.7679
            tputl   = 1                                                          PLOTS.7680
            prput   = .false.                                                    PLOTS.7681
          end if                                                                 PLOTS.7682
        end if                                                                   PLOTS.7683
                                                                                 PLOTS.7684
C  If COLOR is false and FILL is true then the plot will be shaded and           PLOTS.7685
C  we will need to know if we should shade from low to high or high to           PLOTS.7686
C  low                                                                           PLOTS.7687
C  This flag is only here if COLOR is false and FILL is true                     PLOTS.7688
C  H             => high gets highest shading intensity                          PLOTS.7689
C  L             => low gets highest shading intensity                           PLOTS.7690
C  anything else => give a warning message                                       PLOTS.7691
                                                                                 PLOTS.7692
        if ((.not. color) .and. (fill) .and. (.not. error)) then                 PLOTS.7693
          call search (whline,i,error)                                           PLOTS.7694
          if (error) then                                                        PLOTS.7695
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7696
            hputl  = .true.                                                      PLOTS.7697
            lputl  = 0                                                           PLOTS.7698
            tputl  = 1                                                           PLOTS.7699
            prput   = .false.                                                    PLOTS.7700
          end if                                                                 PLOTS.7701
        end if                                                                   PLOTS.7702
                                                                                 PLOTS.7703
        if ((.not. color) .and. (fill) .and. (.not. error)) then                 PLOTS.7704
          if ((whline(i:i) .eq. 'H') .or. (whline(i:i) .eq. 'h')) then           PLOTS.7705
            fshd = .false.                                                       PLOTS.7706
          else if ((whline(i:i) .eq. 'L') .or.                                   PLOTS.7707
     *             (whline(i:i) .eq. 'l')) then                                  PLOTS.7708
            fshd = .true.                                                        PLOTS.7709
          else                                                                   PLOTS.7710
            ermes(1:30)  = 'Shading Direction Indicator Is'                      PLOTS.7711
            ermes(31:60) = 'Missing Or Invalid, H Used    '                      PLOTS.7712
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7713
            fshd = .false.                                                       PLOTS.7714
          end if                                                                 PLOTS.7715
          call next (whline,i,error)                                             PLOTS.7716
          if (error) then                                                        PLOTS.7717
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7718
            hputl   = .true.                                                     PLOTS.7719
            lputl   = 0                                                          PLOTS.7720
            tputl   = 1                                                          PLOTS.7721
            prput   = .false.                                                    PLOTS.7722
          end if                                                                 PLOTS.7723
        else                                                                     PLOTS.7724
          fshd = .false.                                                         PLOTS.7725
        end if                                                                   PLOTS.7726
                                                                                 PLOTS.7727
C  If FILL is true then there will be a flag saying whether the lines            PLOTS.7728
C  should be drawn in at all                                                     PLOTS.7729
C  Y             => draw in the lines                                            PLOTS.7730
C  N             => don't draw in the lines                                      PLOTS.7731
C  anything else => give a warning message                                       PLOTS.7732
C  If the plot will be color filled and this flag is Y the backup color will     PLOTS.7733
C  be used to draw the lines                                                     PLOTS.7734
                                                                                 PLOTS.7735
        if ((fill) .and. (.not. error)) then                                     PLOTS.7736
          call search (whline,i,error)                                           PLOTS.7737
          if (error) then                                                        PLOTS.7738
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7739
            hputl   = .true.                                                     PLOTS.7740
            lputl   = 0                                                          PLOTS.7741
            tputl   = 1                                                          PLOTS.7742
            prput   = .false.                                                    PLOTS.7743
          end if                                                                 PLOTS.7744
        end if                                                                   PLOTS.7745
                                                                                 PLOTS.7746
        if ((fill) .and. (.not. error)) then                                     PLOTS.7747
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7748
            lshd = .true.                                                        PLOTS.7749
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7750
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7751
            lshd = .false.                                                       PLOTS.7752
          else                                                                   PLOTS.7753
            ermes(1:30)  = 'Draw Fill Line Flag Is Inconcl'                      PLOTS.7754
            ermes(31:60) = 'usive, N Assumed              '                      PLOTS.7755
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7756
            lshd = .false.                                                       PLOTS.7757
          end if                                                                 PLOTS.7758
          call next (whline,i,error)                                             PLOTS.7759
          if (error) then                                                        PLOTS.7760
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7761
            hputl   = .true.                                                     PLOTS.7762
            lputl   = 0                                                          PLOTS.7763
            tputl   = 1                                                          PLOTS.7764
            prput   = .false.                                                    PLOTS.7765
          end if                                                                 PLOTS.7766
        else                                                                     PLOTS.7767
          lshd = .false.                                                         PLOTS.7768
        end if                                                                   PLOTS.7769
                                                                                 PLOTS.7770
C  Parse through in the high/low label flag                                      PLOTS.7771
C  Y             => include the high/low labels                                  PLOTS.7772
C  N             => don't include the high/low labels                            PLOTS.7773
C  anything else => give a warning message                                       PLOTS.7774
                                                                                 PLOTS.7775
        if (.not. error) then                                                    PLOTS.7776
          call search (whline,i,error)                                           PLOTS.7777
          if (error) then                                                        PLOTS.7778
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7779
            hputl   = .true.                                                     PLOTS.7780
            lputl   = 0                                                          PLOTS.7781
            tputl   = 1                                                          PLOTS.7782
            prput   = .false.                                                    PLOTS.7783
          end if                                                                 PLOTS.7784
        end if                                                                   PLOTS.7785
                                                                                 PLOTS.7786
        if (.not. error) then                                                    PLOTS.7787
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7788
            hputl = .false.                                                      PLOTS.7789
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7790
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7791
            hputl = .true.                                                       PLOTS.7792
          else                                                                   PLOTS.7793
            ermes(1:30)  = 'High/Low Label Flag Is Inconcl'                      PLOTS.7794
            ermes(31:60) = 'usive, Y Assumed              '                      PLOTS.7795
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7796
            hputl = .true.                                                       PLOTS.7797
          end if                                                                 PLOTS.7798
          call next (whline,i,error)                                             PLOTS.7799
          if (error) then                                                        PLOTS.7800
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7801
            lputl   = 0                                                          PLOTS.7802
            tputl   = 1                                                          PLOTS.7803
            prput   = .false.                                                    PLOTS.7804
          end if                                                                 PLOTS.7805
        end if                                                                   PLOTS.7806
                                                                                 PLOTS.7807
C  Parse through in the line label flag                                          PLOTS.7808
C  Y             => include the line labels                                      PLOTS.7809
C  N             => don't include the line labels                                PLOTS.7810
C  anything else => give a warning message                                       PLOTS.7811
                                                                                 PLOTS.7812
        if (.not. error) then                                                    PLOTS.7813
          call search (whline,i,error)                                           PLOTS.7814
          if (error) then                                                        PLOTS.7815
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7816
            lputl   = 0                                                          PLOTS.7817
            tputl   = 1                                                          PLOTS.7818
            prput   = .false.                                                    PLOTS.7819
          end if                                                                 PLOTS.7820
        end if                                                                   PLOTS.7821
                                                                                 PLOTS.7822
        if (.not. error) then                                                    PLOTS.7823
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7824
            lputl = -1                                                           PLOTS.7825
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7826
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7827
            lputl = 1                                                            PLOTS.7828
          else if ((whline(i:i) .eq. 'C') .or.                                   PLOTS.7829
     *             (whline(i:i) .eq. 'c')) then                                  PLOTS.7830
            lputl = 0                                                            PLOTS.7831
          else                                                                   PLOTS.7832
            ermes(1:30)  = 'Line Label Flag Is Inconclusiv'                      PLOTS.7833
            ermes(31:60) = 'e, C Assumed                  '                      PLOTS.7834
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7835
            lputl = 0                                                            PLOTS.7836
          end if                                                                 PLOTS.7837
          call next (whline,i,error)                                             PLOTS.7838
          if (error) then                                                        PLOTS.7839
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7840
            tputl   = 1                                                          PLOTS.7841
            prput   = .false.                                                    PLOTS.7842
          end if                                                                 PLOTS.7843
        end if                                                                   PLOTS.7844
                                                                                 PLOTS.7845
C  Parse through in the title flag                                               PLOTS.7846
C  Y             => include the title                                            PLOTS.7847
C  N             => don't include the title                                      PLOTS.7848
C  anything else => give a warning message                                       PLOTS.7849
                                                                                 PLOTS.7850
        if (.not. error) then                                                    PLOTS.7851
          call search (whline,i,error)                                           PLOTS.7852
          if (error) then                                                        PLOTS.7853
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7854
            tputl   = 1                                                          PLOTS.7855
            prput   = .false.                                                    PLOTS.7856
          end if                                                                 PLOTS.7857
        end if                                                                   PLOTS.7858
                                                                                 PLOTS.7859
        if (.not. error) then                                                    PLOTS.7860
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7861
            tputl = -1                                                           PLOTS.7862
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7863
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7864
            tputl = 1                                                            PLOTS.7865
          else if ((whline(i:i) .eq. 'L') .or.                                   PLOTS.7866
     *             (whline(i:i) .eq. 'l')) then                                  PLOTS.7867
            tputl = 0                                                            PLOTS.7868
          else                                                                   PLOTS.7869
            ermes(1:30)  = 'Title Flag Is Inconclusive, Y '                      PLOTS.7870
            ermes(31:60) = 'Assumed                       '                      PLOTS.7871
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7872
            tputl = 1                                                            PLOTS.7873
          end if                                                                 PLOTS.7874
          call next (whline,i,error)                                             PLOTS.7875
          if (error) then                                                        PLOTS.7876
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7877
            prput = .false.                                                      PLOTS.7878
          end if                                                                 PLOTS.7879
        end if                                                                   PLOTS.7880
                                                                                 PLOTS.7881
C  Parse through in the perimeter flag                                           PLOTS.7882
C  Y             => include the perimeter                                        PLOTS.7883
C  N             => don't include the perimeter                                  PLOTS.7884
C  anything else => give a warning message                                       PLOTS.7885
                                                                                 PLOTS.7886
        if (.not. error) then                                                    PLOTS.7887
          call search (whline,i,error)                                           PLOTS.7888
          if (error) then                                                        PLOTS.7889
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7890
            prput = .false.                                                      PLOTS.7891
          end if                                                                 PLOTS.7892
        end if                                                                   PLOTS.7893
                                                                                 PLOTS.7894
        if (.not. error) then                                                    PLOTS.7895
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7896
            prput = .false.                                                      PLOTS.7897
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7898
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7899
            prput = .true.                                                       PLOTS.7900
          else                                                                   PLOTS.7901
            ermes(1:30)  = 'Perimeter Flag Is Inconclusive'                      PLOTS.7902
            ermes(31:60) = ', N Assumed                   '                      PLOTS.7903
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7904
            prput = .false.                                                      PLOTS.7905
          end if                                                                 PLOTS.7906
          call next (whline,i,error)                                             PLOTS.7907
          if (error) then                                                        PLOTS.7908
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7909
          end if                                                                 PLOTS.7910
        end if                                                                   PLOTS.7911
                                                                                 PLOTS.7912
C  Check to see if the line width or dash pattern is here                        PLOTS.7913
                                                                                 PLOTS.7914
        dlwv(1) = -1.0                                                           PLOTS.7915
        dlwv(2) = -1.0                                                           PLOTS.7916
        dlwv(3) = -1.0                                                           PLOTS.7917
        ddpv(1) = 0                                                              PLOTS.7918
        ddpv(2) = 0                                                              PLOTS.7919
        ddpv(3) = 0                                                              PLOTS.7920
        if ((.not. error) .and. ((lshd) .or. (.not. fill))) then                 PLOTS.7921
          dash    = .false.                                                      PLOTS.7922
50        call search (whline,i,error)                                           PLOTS.7923
          if (.not. error) then                                                  PLOTS.7924
                                                                                 PLOTS.7925
C  One or both of them are here, figure out which                                PLOTS.7926
                                                                                 PLOTS.7927
            if ((whline(i:i) .eq. 'L') .or.                                      PLOTS.7928
     *          (whline(i:i) .eq. 'l')) then                                     PLOTS.7929
                                                                                 PLOTS.7930
C  This is line width                                                            PLOTS.7931
                                                                                 PLOTS.7932
              i = i + 1                                                          PLOTS.7933
              dlwv(1) = 1.0                                                      PLOTS.7934
              dlwv(2) = 1.0                                                      PLOTS.7935
              dlwv(3) = 1.0                                                      PLOTS.7936
              n = 1                                                              PLOTS.7937
              done = .false.                                                     PLOTS.7938
30            continue                                                           PLOTS.7939
                                                                                 PLOTS.7940
C  Get the detail line width indicator                                           PLOTS.7941
C  +             => only positive contours are affected by the following value   PLOTS.7942
C  -             => only negative contours are affected by the following value   PLOTS.7943
C  @             => only the zero line is affected by the following value        PLOTS.7944
C  =             => all contours are affected by the following value             PLOTS.7945
C  D,d           => all contours will be normal line width                       PLOTS.7946
C  anything else => give a warning message                                       PLOTS.7947
                                                                                 PLOTS.7948
                if (whline(i:i) .eq. '+') then                                   PLOTS.7949
                  dlwi = 1                                                       PLOTS.7950
                else if (whline(i:i) .eq. '-') then                              PLOTS.7951
                  dlwi = -1                                                      PLOTS.7952
                else if (whline(i:i) .eq. '@') then                              PLOTS.7953
                  dlwi = 0                                                       PLOTS.7954
                else if (whline(i:i) .eq. '=') then                              PLOTS.7955
                  dlwi = 2                                                       PLOTS.7956
                else if ((whline(i:i) .eq. 'd') .or.                             PLOTS.7957
     *                   (whline(i:i) .eq. 'D')) then                            PLOTS.7958
                  done    = .true.                                               PLOTS.7959
                else                                                             PLOTS.7960
                  ermes(1:30)  = 'Detail Line Width Indicator Is'                PLOTS.7961
                  ermes(31:60) = ' Invalid, Options: +-=@dD     '                PLOTS.7962
                  call errhan ('CONDRV',0,ermes,errsev)                          PLOTS.7963
                  done    = .true.                                               PLOTS.7964
                end if                                                           PLOTS.7965
                                                                                 PLOTS.7966
C  Parse out the line width multiplier                                           PLOTS.7967
C  any multiplier less than 1.0 is ineffective                                   PLOTS.7968
                                                                                 PLOTS.7969
                if (.not. done) then                                             PLOTS.7970
                  j = i                                                          PLOTS.7971
                  i = i + 1                                                      PLOTS.7972
10                j = j + 1                                                      PLOTS.7973
                  if ((whline(j:j) .ne. '+') .and.                               PLOTS.7974
     *                (whline(j:j) .ne. '-') .and.                               PLOTS.7975
     *                (whline(j:j) .ne. '=') .and.                               PLOTS.7976
     *                (whline(j:j) .ne. '@') .and.                               PLOTS.7977
     *                (whline(j:j) .ne. ' ') .and.                               PLOTS.7978
     *                (whline(j:j) .ne. '|') .and.                               PLOTS.7979
     *                (whline(j:j) .ne. 'D') .and.                               PLOTS.7980
     *                (whline(j:j) .ne. 'd'))                                    PLOTS.7981
     *              goto 10                                                      PLOTS.7982
                  tstrg(1:j-i) = whline(i:j-1)                                   PLOTS.7983
                  if ((tstrg(1:j-i) .eq. 'D') .or.                               PLOTS.7984
     *                (tstrg(1:j-i) .eq. 'd')) then                              PLOTS.7985
                    temp = 1.0                                                   PLOTS.7986
                  else                                                           PLOTS.7987
                    do 40 k = j-i+1,20                                           PLOTS.7988
                      tstrg(k:k) = ' '                                           PLOTS.7989
40                  continue                                                     PLOTS.7990
                    call gtreal (tstrg(1:20),temp,error)                         PLOTS.7991
                    if (error) then                                              PLOTS.7992
                      ermes(1:30)  = 'Could Not Convert Line Width M'            PLOTS.7993
                      ermes(31:60) = 'ultiplier To A Real Number    '            PLOTS.7994
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.7995
                      temp = 1.0                                                 PLOTS.7996
                    end if                                                       PLOTS.7997
                                                                                 PLOTS.7998
C  Line width multipliers must be between 1 and 10 inclusive                     PLOTS.7999
                                                                                 PLOTS.8000
                    if (temp .lt. 1.0) then                                      PLOTS.8001
                      ermes(1:30)  = 'Line Width Multipliers Less Th'            PLOTS.8002
                      ermes(31:60) = 'an One, Have No Effect        '            PLOTS.8003
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.8004
                      temp = 1.0                                                 PLOTS.8005
                    end if                                                       PLOTS.8006
                    if (temp .gt. 10.0) then                                     PLOTS.8007
                      ermes(1:30)  = 'Line Width Multipliers Greater'            PLOTS.8008
                      ermes(31:60) = ' Than 10 Are Invalid          '            PLOTS.8009
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.8010
                      temp = 10.0                                                PLOTS.8011
                    end if                                                       PLOTS.8012
                  end if                                                         PLOTS.8013
                  i = j                                                          PLOTS.8014
                  if (dlwi .eq. 1) then                                          PLOTS.8015
                    dlwv(1) = temp                                               PLOTS.8016
                  else if (dlwi .eq. -1) then                                    PLOTS.8017
                    dlwv(3) = temp                                               PLOTS.8018
                  else if (dlwi .eq. 0) then                                     PLOTS.8019
                    dlwv(2) = temp                                               PLOTS.8020
                  else                                                           PLOTS.8021
                    dlwv(1) = temp                                               PLOTS.8022
                    dlwv(2) = temp                                               PLOTS.8023
                    dlwv(3) = temp                                               PLOTS.8024
                    done = .true.                                                PLOTS.8025
                  end if                                                         PLOTS.8026
                end if                                                           PLOTS.8027
                                                                                 PLOTS.8028
C  Determine if the entire line width string has been parsed, if not             PLOTS.8029
C  continue parsing otherwise go on.  There can never be more than three         PLOTS.8030
C  linwe width entries                                                           PLOTS.8031
                                                                                 PLOTS.8032
                if ((whline(i:i) .eq. ' ') .or.                                  PLOTS.8033
     *              (whline(i:i) .eq. '|') .or.                                  PLOTS.8034
     *              (n .eq. 3)) then                                             PLOTS.8035
                  done = .true.                                                  PLOTS.8036
                else                                                             PLOTS.8037
                  n = n + 1                                                      PLOTS.8038
                end if                                                           PLOTS.8039
              if (.not. done) goto 30                                            PLOTS.8040
            else if ((whline(i:i) .eq. 'D') .or.                                 PLOTS.8041
     *               (whline(i:i) .eq. 'd')) then                                PLOTS.8042
              dash = .true.                                                      PLOTS.8043
                                                                                 PLOTS.8044
C  This is dash pattern                                                          PLOTS.8045
                                                                                 PLOTS.8046
              i = i + 1                                                          PLOTS.8047
              ddpv(1) = -1                                                       PLOTS.8048
              ddpv(2) = -1                                                       PLOTS.8049
              ddpv(3) = 21845                                                    PLOTS.8050
              n = 1                                                              PLOTS.8051
              done = .false.                                                     PLOTS.8052
60            continue                                                           PLOTS.8053
                                                                                 PLOTS.8054
C  Get the detail dash pattern indicator                                         PLOTS.8055
C  +             => only positive contours are affected by the following value   PLOTS.8056
C  -             => only negative contours are affected by the following value   PLOTS.8057
C  @             => only the zero line is affected by the following value        PLOTS.8058
C  =             => all contours are affected by the following value             PLOTS.8059
C  D,d           => all contours will be normal line width                       PLOTS.8060
C  anything else => give a warning message                                       PLOTS.8061
                                                                                 PLOTS.8062
                if (whline(i:i) .eq. '+') then                                   PLOTS.8063
                  ddpi = 1                                                       PLOTS.8064
                else if (whline(i:i) .eq. '-') then                              PLOTS.8065
                  ddpi = -1                                                      PLOTS.8066
                else if (whline(i:i) .eq. '@') then                              PLOTS.8067
                  ddpi = 0                                                       PLOTS.8068
                else if (whline(i:i) .eq. '=') then                              PLOTS.8069
                  ddpi = 2                                                       PLOTS.8070
                else if ((whline(i:i) .eq. 'd') .or.                             PLOTS.8071
     *                   (whline(i:i) .eq. 'D')) then                            PLOTS.8072
                  done    = .true.                                               PLOTS.8073
                else                                                             PLOTS.8074
                  ermes(1:30)  = 'Detail Dash Pattern Indicator '                PLOTS.8075
                  ermes(31:60) = 'Is Invalid, Options: +-=@dD   '                PLOTS.8076
                  call errhan ('CONDRV',0,ermes,errsev)                          PLOTS.8077
                  done    = .true.                                               PLOTS.8078
                end if                                                           PLOTS.8079
                                                                                 PLOTS.8080
C  Parse out the dash pattern                                                    PLOTS.8081
C  L  => DDPV = 255   ; or 0000000011111111 ; or Large                           PLOTS.8082
C  M  => DDPV = 3855  ; or 0000111100001111 ; or Medium                          PLOTS.8083
C  SM => DDPV = 13107 ; or 0011001100110011 ; or SMall                           PLOTS.8084
C  T  => DDPV = 21845 ; or 0101010101010101 ; or Tiny                            PLOTS.8085
C  SO => DDPV = -1    ; or 1111111111111111 ; or SOlid                           PLOTS.8086
C  D  => DDPV = -1    ; or 1111111111111111 ; or Default for non negatives       PLOTS.8087
C  D  => DDPV = 21845 ; or 0101010101010101 ; or Default for negatives           PLOTS.8088
                                                                                 PLOTS.8089
                if (.not. done) then                                             PLOTS.8090
                  i = i + 1                                                      PLOTS.8091
                  if ((whline(i:i) .eq. 'L') .or.                                PLOTS.8092
     *                (whline(i:i) .eq. 'l')) then                               PLOTS.8093
                    j = 255                                                      PLOTS.8094
                  else if ((whline(i:i) .eq. 'M') .or.                           PLOTS.8095
     *                     (whline(i:i) .eq. 'm')) then                          PLOTS.8096
                    j = 3855                                                     PLOTS.8097
                  else if ((whline(i:i+1) .eq. 'SM') .or.                        PLOTS.8098
     *                     (whline(i:i+1) .eq. 'Sm') .or.                        PLOTS.8099
     *                     (whline(i:i+1) .eq. 'sM') .or.                        PLOTS.8100
     *                     (whline(i:i+1) .eq. 'sm')) then                       PLOTS.8101
                    j = 13107                                                    PLOTS.8102
                  else if ((whline(i:i) .eq. 'T') .or.                           PLOTS.8103
     *                     (whline(i:i) .eq. 't')) then                          PLOTS.8104
                    j = 21845                                                    PLOTS.8105
                  else if ((whline(i:i+1) .eq. 'SO') .or.                        PLOTS.8106
     *                     (whline(i:i+1) .eq. 'So') .or.                        PLOTS.8107
     *                     (whline(i:i+1) .eq. 'sO') .or.                        PLOTS.8108
     *                     (whline(i:i+1) .eq. 'so')) then                       PLOTS.8109
                    j = -1                                                       PLOTS.8110
                  else if (((whline(i:i) .eq. 'D') .or.                          PLOTS.8111
     *                      (whline(i:i) .eq. 'd')) .and.                        PLOTS.8112
     *                     (ddpi .eq. -1)) then                                  PLOTS.8113
                    j = 21845                                                    PLOTS.8114
                  else if (((whline(i:i) .eq. 'D') .or.                          PLOTS.8115
     *                      (whline(i:i) .eq. 'd')) .and.                        PLOTS.8116
     *                     (ddpi .ne. -1)) then                                  PLOTS.8117
                    j = -1                                                       PLOTS.8118
                  else                                                           PLOTS.8119
                    ermes(1:30)  = 'Dash Pattern Entry Is In Error'              PLOTS.8120
                    ermes(31:60) = ', Options: LG ME SM TI SO D   '              PLOTS.8121
                    call errhan ('CONDRV',0,ermes,errsev)                        PLOTS.8122
                    j = -1                                                       PLOTS.8123
                  end if                                                         PLOTS.8124
                  if (ddpi .eq. 1) then                                          PLOTS.8125
                    ddpv(1) = j                                                  PLOTS.8126
                  else if (ddpi .eq. -1) then                                    PLOTS.8127
                    ddpv(3) = j                                                  PLOTS.8128
                  else if (ddpi .eq. 0) then                                     PLOTS.8129
                    ddpv(2) = j                                                  PLOTS.8130
                  else                                                           PLOTS.8131
                    ddpv(1) = j                                                  PLOTS.8132
                    ddpv(2) = j                                                  PLOTS.8133
                    ddpv(3) = j                                                  PLOTS.8134
                    done = .true.                                                PLOTS.8135
                  end if                                                         PLOTS.8136
                end if                                                           PLOTS.8137
                                                                                 PLOTS.8138
C  Look for the next indicator                                                   PLOTS.8139
                                                                                 PLOTS.8140
70              i = i + 1                                                        PLOTS.8141
                if ((whline(i:i) .ne. '+') .and.                                 PLOTS.8142
     *              (whline(i:i) .ne. '-') .and.                                 PLOTS.8143
     *              (whline(i:i) .ne. '=') .and.                                 PLOTS.8144
     *              (whline(i:i) .ne. '@') .and.                                 PLOTS.8145
     *              (whline(i:i) .ne. ' ') .and.                                 PLOTS.8146
     *              (whline(i:i) .ne. '|') .and.                                 PLOTS.8147
     *              (whline(i:i) .ne. 'D') .and.                                 PLOTS.8148
     *              (whline(i:i) .ne. 'd'))                                      PLOTS.8149
     *            goto 70                                                        PLOTS.8150
                                                                                 PLOTS.8151
C  Determine if the entire dash pattern string has been parsed, if not           PLOTS.8152
C  continue parsing otherwise go on.  There can never be more than three         PLOTS.8153
C  dash pattern entries                                                          PLOTS.8154
                                                                                 PLOTS.8155
                if ((whline(i:i) .eq. ' ') .or.                                  PLOTS.8156
     *              (whline(i:i) .eq. '|') .or.                                  PLOTS.8157
     *              (n .eq. 3)) then                                             PLOTS.8158
                  done = .true.                                                  PLOTS.8159
                else                                                             PLOTS.8160
                  n = n + 1                                                      PLOTS.8161
                end if                                                           PLOTS.8162
              if (.not. done) goto 60                                            PLOTS.8163
            else                                                                 PLOTS.8164
              ermes(1:30)  = 'Expecting Line Width Or Dash P'                    PLOTS.8165
              ermes(31:60) = 'attern Information            '                    PLOTS.8166
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.8167
              dash = .true.                                                      PLOTS.8168
            end if                                                               PLOTS.8169
            call next (whline,i,error)                                           PLOTS.8170
          else                                                                   PLOTS.8171
            dash  = .true.                                                       PLOTS.8172
            error = .false.                                                      PLOTS.8173
            i     = 80                                                           PLOTS.8174
          end if                                                                 PLOTS.8175
          if (error) then                                                        PLOTS.8176
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8177
          else if (.not. dash) then                                              PLOTS.8178
            goto 50                                                              PLOTS.8179
          end if                                                                 PLOTS.8180
        else                                                                     PLOTS.8181
                                                                                 PLOTS.8182
C  No lines are going to be drawn so no line width and dash pattern              PLOTS.8183
C  is necessary                                                                  PLOTS.8184
                                                                                 PLOTS.8185
          ddpv(1) = -1                                                           PLOTS.8186
          ddpv(2) = -1                                                           PLOTS.8187
          ddpv(3) = -1                                                           PLOTS.8188
          dlwv(1) = 1.0                                                          PLOTS.8189
          dlwv(2) = 1.0                                                          PLOTS.8190
          dlwv(3) = 1.0                                                          PLOTS.8191
        end if                                                                   PLOTS.8192
                                                                                 PLOTS.8193
C  Check to see that everything is hunky dory at the end of the line             PLOTS.8194
                                                                                 PLOTS.8195
        call search (whline,i,error)                                             PLOTS.8196
        if (.not. error) then                                                    PLOTS.8197
          ermes(1:30)  = 'Reading First Line Of Details '                        PLOTS.8198
          ermes(31:60) = 'Table, Too Many Entries       '                        PLOTS.8199
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8200
        end if                                                                   PLOTS.8201
                                                                                 PLOTS.8202
C  If high/low labels were requested read in high/low information from           PLOTS.8203
C  the next line of information in the table                                     PLOTS.8204
                                                                                 PLOTS.8205
        if (hputl) then                                                          PLOTS.8206
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8207
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8208
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8209
          read (unum,100,end=80,err=80) whline(1:80)                             PLOTS.8210
                                                                                 PLOTS.8211
C  Read in all the high/low information                                          PLOTS.8212
                                                                                 PLOTS.8213
          call crdhlo (whline,errsev,hfilb)                                      PLOTS.8214
          goto 85                                                                PLOTS.8215
                                                                                 PLOTS.8216
C  If there was an error in the read, give an error message, then                PLOTS.8217
C  default the high/low label information                                        PLOTS.8218
                                                                                 PLOTS.8219
80        ermes(1:30)   = 'Could Not Read In High/Low Lab'                       PLOTS.8220
          ermes(31:60)  = 'el Information Line           '                       PLOTS.8221
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8222
          whline(1:40)  = '                                        '             PLOTS.8223
          whline(41:80) = '                                        '             PLOTS.8224
          call crdhlo (whline,errsev,hfilb)                                      PLOTS.8225
85        continue                                                               PLOTS.8226
        end if                                                                   PLOTS.8227
                                                                                 PLOTS.8228
C  If line labels were requested read in the line label information from         PLOTS.8229
C  the next line of information in the table                                     PLOTS.8230
                                                                                 PLOTS.8231
        if (lputl .eq. 1) then                                                   PLOTS.8232
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8233
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8234
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8235
          read (unum,100,end=110,err=110) whline(1:80)                           PLOTS.8236
                                                                                 PLOTS.8237
C  Read in all the label information                                             PLOTS.8238
                                                                                 PLOTS.8239
          call crdlab (whline,errsev,lfilb)                                      PLOTS.8240
          goto 115                                                               PLOTS.8241
                                                                                 PLOTS.8242
C  If there was an error reading in the information, give an error               PLOTS.8243
C  message and default the line label information                                PLOTS.8244
                                                                                 PLOTS.8245
110       ermes(1:30)   = 'Could Not Read In Line Label I'                       PLOTS.8246
          ermes(31:60)  = 'nformation Line               '                       PLOTS.8247
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8248
          whline(1:40)  = '                                        '             PLOTS.8249
          whline(41:80) = '                                        '             PLOTS.8250
          call crdlab (whline,errsev,lfilb)                                      PLOTS.8251
115       continue                                                               PLOTS.8252
        end if                                                                   PLOTS.8253
                                                                                 PLOTS.8254
C  If a title is to be drawn read the information concerning it from the         PLOTS.8255
C  next line of information in the table                                         PLOTS.8256
                                                                                 PLOTS.8257
        if (tputl .ge. 0) then                                                   PLOTS.8258
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8259
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8260
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8261
          read (unum,100,end=120,err=120) whline(1:80)                           PLOTS.8262
                                                                                 PLOTS.8263
C  Read in all the title information                                             PLOTS.8264
                                                                                 PLOTS.8265
          call crdttl (whline,errsev,tputl,tfilb)                                PLOTS.8266
          goto 125                                                               PLOTS.8267
                                                                                 PLOTS.8268
C  If there was an error in the read, give an error message and default          PLOTS.8269
C  the title information                                                         PLOTS.8270
                                                                                 PLOTS.8271
120       ermes(1:30)   = 'Could Not Read In Title Inform'                       PLOTS.8272
          ermes(31:60)  = 'ation Line                    '                       PLOTS.8273
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8274
          whline(1:40)  = '                                        '             PLOTS.8275
          whline(41:80) = '                                        '             PLOTS.8276
          call crdttl (whline,errsev,tputl,tfilb)                                PLOTS.8277
125       continue                                                               PLOTS.8278
        end if                                                                   PLOTS.8279
                                                                                 PLOTS.8280
C  Tell the user the details are set up, even if an error occured but            PLOTS.8281
C  didn't stop execution                                                         PLOTS.8282
                                                                                 PLOTS.8283
C       print *, 'CONDRV - Contour Details Set Up'                               06NOV00.148
      else                                                                       PLOTS.8285
                                                                                 PLOTS.8286
C  Assign defaults if the table is not there                                     PLOTS.8287
                                                                                 PLOTS.8288
C       print *, 'CONDRV - Default Contour Details Used'                         06NOV00.149
        color       = .false.                                                    PLOTS.8290
        fill        = .false.                                                    PLOTS.8291
        hputl       = .true.                                                     PLOTS.8292
        lputl       = 0                                                          PLOTS.8293
        lshd        = .false.                                                    PLOTS.8294
        fshd        = .false.                                                    PLOTS.8295
        prput       = .false.                                                    PLOTS.8296
        tputl       = 1                                                          PLOTS.8297
        if (mod(pnum,2) .eq. 0) then                                             PLOTS.8298
          ddpv(1) = -1                                                           PLOTS.8299
          ddpv(2) = -1                                                           PLOTS.8300
          ddpv(3) = -1                                                           PLOTS.8301
          dlwv(1) = wltwo                                                        PLOTS.8302
          dlwv(2) = wltwo                                                        PLOTS.8303
          dlwv(3) = wltwo                                                        PLOTS.8304
        else                                                                     PLOTS.8305
          ddpv(1) = -1                                                           PLOTS.8306
          ddpv(2) = -1                                                           PLOTS.8307
          ddpv(3) = 21845                                                        PLOTS.8308
          dlwv(1) = 1.0                                                          PLOTS.8309
          dlwv(2) = 1.0                                                          PLOTS.8310
          dlwv(3) = 1.0                                                          PLOTS.8311
        end if                                                                   PLOTS.8312
        whline(1:40)  = '                                        '               PLOTS.8313
        whline(41:80) = '                                        '               PLOTS.8314
        call crdhlo (whline,errsev,hfilb)                                        PLOTS.8315
        call crdttl (whline,errsev,tputl,tfilb)                                  PLOTS.8316
      end if                                                                     PLOTS.8317
                                                                                 PLOTS.8318
C*****************************  subroutine end  ******************************C  PLOTS.8319
                                                                                 PLOTS.8320
C  Format statements begin ...                                                   PLOTS.8321
                                                                                 PLOTS.8322
90    format (A1)                                                                PLOTS.8323
100   format (A80)                                                               PLOTS.8324
                                                                                 PLOTS.8325
C  Format statements end.                                                        PLOTS.8326
                                                                                 PLOTS.8327
                                                                                 PLOTS.8328
130   return                                                                     PLOTS.8329
      end                                                                        PLOTS.8330
      subroutine crdhlo (whline,errsev,ofilb)                                    PLOTS.8331
                                                                                 PLOTS.8332
C*****************************************************************************C  PLOTS.8333
C  crdhlo   - this is a CONDRV routine                                        C  PLOTS.8334
C  Section  - Tables                                                          C  PLOTS.8335
C  Purpose  - This routine determines high/low  label information as was des- C  PLOTS.8336
C             scribed by the user in the DETAILS table.                       C  PLOTS.8337
C                                                                             C  PLOTS.8338
C  On entry - WHLINE contains the line of the DETAILS table containing all of C  PLOTS.8339
C             the high/low label information.  ERRSEV indicates at  what sev- C  PLOTS.8340
C             erity or error execution should halt.                           C  PLOTS.8341
C                                                                             C  PLOTS.8342
C  On exit  - All variables in common block HLODET have been properly set up. C  PLOTS.8343
C             The variables in common block HLQDET are set up.  OFILB says if C  PLOTS.8344
C             the high/low label boxes should be filled or not.               C  PLOTS.8345
C                                                                             C  PLOTS.8346
C  Assume   - Nothing.                                                        C  PLOTS.8347
C                                                                             C  PLOTS.8348
C  Notes    - Routine             Location of Definition                      C  PLOTS.8349
C             ----------------------------------------------------------------C  PLOTS.8350
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.8351
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.8352
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.8353
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.8354
C             ----------------------------------------------------------------C  PLOTS.8355
C                                                                             C  PLOTS.8356
C  Author   - Jeremy Asbill       Date - June 11, 1990      for the MM4 club  C  PLOTS.8357
C*****************************************************************************C  PLOTS.8358
                                                                                 PLOTS.8359
C  Character variables                                                           PLOTS.8360
                                                                                 PLOTS.8361
      character*80     whline            ! a line from the table           (in)  PLOTS.8362
      character*60     ermes,            ! error message string,general (local)  PLOTS.8363
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.8364
     *                 q                 ! error message string,NEXT    (local)  PLOTS.8365
      character*20     gstrng            ! temporary string             (local)  PLOTS.8366
                                                                                 PLOTS.8367
C  Integer variables                                                             PLOTS.8368
                                                                                 PLOTS.8369
      integer          errsev            ! error severity comparitor       (in)  PLOTS.8370
      integer          hstyl(2),         ! for common block HLODET               PLOTS.8371
     *                 hsize,            ! for common block HLODET               PLOTS.8372
     *                 hangl             ! for common block HLODET               PLOTS.8373
      integer          hqual(2)          ! for common block HLQDET               PLOTS.8374
      integer          i                 ! loop counter                 (local)  PLOTS.8375
                                                                                 PLOTS.8376
C  Logical variables                                                             PLOTS.8377
                                                                                 PLOTS.8378
      logical          ofilb             ! out version of HFILB           (out)  PLOTS.8379
      logical          hputb             ! for common block HLBDET               PLOTS.8380
      logical          hputp,            ! for common block HLODET               PLOTS.8381
     *                 hfilb,            ! for common block HLODET               PLOTS.8382
     *                 hfilt             ! for common block HLODET               PLOTS.8383
      logical          error             ! has an error been detected ? (local)  PLOTS.8384
                                                                                 PLOTS.8385
C  Real variables                                                                PLOTS.8386
                                                                                 PLOTS.8387
      real             hprlw             ! for common block HLODET               PLOTS.8388
                                                                                 PLOTS.8389
C  Common blocks                                                                 PLOTS.8390
                                                                                 PLOTS.8391
      common /hlbdet/  hputb             ! draw boxes around highs and lows ?    PLOTS.8392
      common /hlodet/  hputp,            ! darw in perimeter on boxes ?          PLOTS.8393
     *                 hfilb,            ! fill in the the box ?                 PLOTS.8394
     *                 hprlw,            ! line width for box perimeter          PLOTS.8395
     *                 hstyl,            ! high/low style indicator              PLOTS.8396
     *                 hsize,            ! character size for highs and lows     PLOTS.8397
     *                 hfilt,            ! use an overlap filter ?               PLOTS.8398
     *                 hangl             ! angle for horiz. to draw highs/lows   PLOTS.8399
      common /hlqdet/  hqual             ! character quality                     PLOTS.8400
                                                                                 PLOTS.8401
C****************************  subroutine begin  *****************************C  PLOTS.8402
                                                                                 PLOTS.8403
C  Set up I to use as a counter                                                  PLOTS.8404
                                                                                 PLOTS.8405
      i = 1                                                                      PLOTS.8406
                                                                                 PLOTS.8407
C  Initialize the error flag                                                     PLOTS.8408
                                                                                 PLOTS.8409
      error = .false.                                                            PLOTS.8410
                                                                                 PLOTS.8411
C  Set up SEARCH and NEXT error strings                                          PLOTS.8412
                                                                                 PLOTS.8413
      p(1:23)  = 'Reading High/Low Inform'                                       PLOTS.8414
      p(24:60) = 'ation Line, Too Few Entries On Line  '                         PLOTS.8415
      q(1:23)  = p(1:23)                                                         PLOTS.8416
      q(24:60) = 'ation Line, Entry Is Bizzare         '                         PLOTS.8417
                                                                                 PLOTS.8418
C  Do we want to draw in boxes                                                   PLOTS.8419
                                                                                 PLOTS.8420
      call search (whline,i,error)                                               PLOTS.8421
      if (error) then                                                            PLOTS.8422
        hputb    = .false.                                                       PLOTS.8423
        hputb    = .false.                                                       PLOTS.8424
        hfilb    = .false.                                                       PLOTS.8425
        hstyl(1) = 13                                                            PLOTS.8426
        hstyl(2) = 13                                                            PLOTS.8427
        hsize    = 12                                                            PLOTS.8428
        hfilt    = .false.                                                       PLOTS.8429
        hangl    = 0                                                             PLOTS.8430
        hqual(1) = 1                                                             PLOTS.8431
        hqual(2) = 1                                                             PLOTS.8432
      end if                                                                     PLOTS.8433
                                                                                 PLOTS.8434
      if (.not. error) then                                                      PLOTS.8435
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.8436
          hputb = .true.                                                         PLOTS.8437
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.8438
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.8439
          hputb = .false.                                                        PLOTS.8440
        else                                                                     PLOTS.8441
          ermes(1:30)  = 'High/Low Label Box Flag Is Inc'                        PLOTS.8442
          ermes(31:60) = 'conclusive, N Assumed         '                        PLOTS.8443
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8444
          hputb = .false.                                                        PLOTS.8445
        end if                                                                   PLOTS.8446
        call next (whline,i,error)                                               PLOTS.8447
        if (error) then                                                          PLOTS.8448
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.8449
          hstyl(1) = 13                                                          PLOTS.8450
          hstyl(2) = 13                                                          PLOTS.8451
          hsize    = 12                                                          PLOTS.8452
          hfilt    = .false.                                                     PLOTS.8453
          hangl    = 0                                                           PLOTS.8454
          hqual(1) = 1                                                           PLOTS.8455
          hqual(2) = 1                                                           PLOTS.8456
        end if                                                                   PLOTS.8457
      end if                                                                     PLOTS.8458
                                                                                 PLOTS.8459
C  Do we want to draw in the perimeter on the boxes                              PLOTS.8460
                                                                                 PLOTS.8461
      if ((hputb) .and. (.not. error)) then                                      PLOTS.8462
        call search (whline,i,error)                                             PLOTS.8463
        if (error) then                                                          PLOTS.8464
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8465
          hputp    = .false.                                                     PLOTS.8466
          hfilb    = .false.                                                     PLOTS.8467
          hprlw    = 0.0                                                         PLOTS.8468
          hstyl(1) = 13                                                          PLOTS.8469
          hstyl(2) = 13                                                          PLOTS.8470
          hsize    = 12                                                          PLOTS.8471
          hfilt    = .false.                                                     PLOTS.8472
          hangl    = 0                                                           PLOTS.8473
          hqual(1) = 1                                                           PLOTS.8474
          hqual(2) = 1                                                           PLOTS.8475
        end if                                                                   PLOTS.8476
                                                                                 PLOTS.8477
        if (.not. error) then                                                    PLOTS.8478
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.8479
            hputp = .false.                                                      PLOTS.8480
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.8481
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.8482
            hputp = .true.                                                       PLOTS.8483
          else                                                                   PLOTS.8484
            ermes(1:30)  = 'High/Low Label Box Perimeter F'                      PLOTS.8485
            ermes(31:60) = 'lag Is Inconclusive, Y Assumed'                      PLOTS.8486
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8487
            hputp = .true.                                                       PLOTS.8488
          end if                                                                 PLOTS.8489
          call next (whline,i,error)                                             PLOTS.8490
          if (error) then                                                        PLOTS.8491
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8492
            hfilb    = .false.                                                   PLOTS.8493
            if (hputp) then                                                      PLOTS.8494
              hprlw  = 1.0                                                       PLOTS.8495
            else                                                                 PLOTS.8496
              hprlw  = 0.0                                                       PLOTS.8497
            end if                                                               PLOTS.8498
            hstyl(1) = 13                                                        PLOTS.8499
            hstyl(2) = 13                                                        PLOTS.8500
            hsize    = 12                                                        PLOTS.8501
            hfilt    = .false.                                                   PLOTS.8502
            hangl    = 0                                                         PLOTS.8503
            hqual(1) = 1                                                         PLOTS.8504
            hqual(2) = 1                                                         PLOTS.8505
          end if                                                                 PLOTS.8506
        end if                                                                   PLOTS.8507
                                                                                 PLOTS.8508
C  Do we want to fill in the boxes                                               PLOTS.8509
                                                                                 PLOTS.8510
        if (.not. error) then                                                    PLOTS.8511
          call search (whline,i,error)                                           PLOTS.8512
          if (error) then                                                        PLOTS.8513
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.8514
            hfilb    = .false.                                                   PLOTS.8515
            if (hputp) then                                                      PLOTS.8516
              hprlw  = 1.0                                                       PLOTS.8517
            else                                                                 PLOTS.8518
              hprlw  = 0.0                                                       PLOTS.8519
            end if                                                               PLOTS.8520
            hstyl(1) = 13                                                        PLOTS.8521
            hstyl(2) = 13                                                        PLOTS.8522
            hsize    = 12                                                        PLOTS.8523
            hfilt    = .false.                                                   PLOTS.8524
            hangl    = 0                                                         PLOTS.8525
            hqual(1) = 1                                                         PLOTS.8526
            hqual(2) = 1                                                         PLOTS.8527
          end if                                                                 PLOTS.8528
        end if                                                                   PLOTS.8529
                                                                                 PLOTS.8530
        if (.not. error) then                                                    PLOTS.8531
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.8532
            hfilb = .true.                                                       PLOTS.8533
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.8534
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.8535
            hfilb = .false.                                                      PLOTS.8536
          else                                                                   PLOTS.8537
            ermes (1:30)  = 'High/Low Label Box Fill Flag I'                     PLOTS.8538
            ermes (1:30)  = 's Inconclusive, N Assumed     '                     PLOTS.8539
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8540
            hfilb = .false.                                                      PLOTS.8541
          end if                                                                 PLOTS.8542
          call next (whline,i,error)                                             PLOTS.8543
          if (error) then                                                        PLOTS.8544
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8545
            if (hputp) then                                                      PLOTS.8546
              hprlw  = 1.0                                                       PLOTS.8547
            else                                                                 PLOTS.8548
              hprlw  = 0.0                                                       PLOTS.8549
            end if                                                               PLOTS.8550
            hstyl(1) = 13                                                        PLOTS.8551
            hstyl(2) = 13                                                        PLOTS.8552
            hsize    = 12                                                        PLOTS.8553
            hfilt    = .false.                                                   PLOTS.8554
            hangl    = 0                                                         PLOTS.8555
            hqual(1) = 1                                                         PLOTS.8556
            hqual(2) = 1                                                         PLOTS.8557
          end if                                                                 PLOTS.8558
        end if                                                                   PLOTS.8559
                                                                                 PLOTS.8560
C  What line width should the box perimeter have?                                PLOTS.8561
C  "d" indicates lw = 1000                                                       PLOTS.8562
                                                                                 PLOTS.8563
        if ((hputp) .and. (.not. error)) then                                    PLOTS.8564
          call search (whline,i,error)                                           PLOTS.8565
          if (error) then                                                        PLOTS.8566
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.8567
            if (hputp) then                                                      PLOTS.8568
              hprlw  = 1.0                                                       PLOTS.8569
            else                                                                 PLOTS.8570
              hprlw  = 0.0                                                       PLOTS.8571
            end if                                                               PLOTS.8572
            hstyl(1) = 13                                                        PLOTS.8573
            hstyl(2) = 13                                                        PLOTS.8574
            hsize    = 12                                                        PLOTS.8575
            hfilt    = .false.                                                   PLOTS.8576
            hangl    = 0                                                         PLOTS.8577
            hqual(1) = 1                                                         PLOTS.8578
            hqual(2) = 1                                                         PLOTS.8579
          end if                                                                 PLOTS.8580
        end if                                                                   PLOTS.8581
                                                                                 PLOTS.8582
        if ((hputp) .and. (.not. error)) then                                    PLOTS.8583
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.8584
            hprlw = 1.0                                                          PLOTS.8585
            call next (whline,i,error)                                           PLOTS.8586
          else                                                                   PLOTS.8587
            j = i                                                                PLOTS.8588
            call next (whline,i,error)                                           PLOTS.8589
            if (.not. error) then                                                PLOTS.8590
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.8591
              do 10 k = i-j+1,20                                                 PLOTS.8592
                gstrng(k:k) = ' '                                                PLOTS.8593
10            continue                                                           PLOTS.8594
              call gtreal (gstrng,hprlw,error)                                   PLOTS.8595
              if (error) then                                                    PLOTS.8596
                ermes(1:30)  = 'Could Not Read High/Low Label '                  PLOTS.8597
                ermes(31:60) = 'Box Perimeter Width, 1.0 Used '                  PLOTS.8598
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.8599
                hprlw = 1.0                                                      PLOTS.8600
                error = .false.                                                  PLOTS.8601
              end if                                                             PLOTS.8602
            end if                                                               PLOTS.8603
          end if                                                                 PLOTS.8604
          if (error) then                                                        PLOTS.8605
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8606
            hstyl(1) = 13                                                        PLOTS.8607
            hstyl(2) = 13                                                        PLOTS.8608
            hsize    = 12                                                        PLOTS.8609
            hfilt    = .false.                                                   PLOTS.8610
            hangl    = 0                                                         PLOTS.8611
            hqual(1) = 1                                                         PLOTS.8612
            hqual(2) = 1                                                         PLOTS.8613
          end if                                                                 PLOTS.8614
        end if                                                                   PLOTS.8615
      else                                                                       PLOTS.8616
        hfilb = .false.                                                          PLOTS.8617
        hputp = .false.                                                          PLOTS.8618
        hprlw  = 0.0                                                             PLOTS.8619
      end if                                                                     PLOTS.8620
                                                                                 PLOTS.8621
C  What kind of marker to we want for the highs                                  PLOTS.8622
C  There are 13 options, defined in the routine SETHLO                           PLOTS.8623
C  D,d  => style # 13 is used                                                    PLOTS.8624
                                                                                 PLOTS.8625
      if (.not. error) then                                                      PLOTS.8626
        call search (whline,i,error)                                             PLOTS.8627
        if (error) then                                                          PLOTS.8628
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8629
          hstyl(1) = 13                                                          PLOTS.8630
          hstyl(2) = 13                                                          PLOTS.8631
          hsize    = 12                                                          PLOTS.8632
          hfilt    = .false.                                                     PLOTS.8633
          hangl    = 0                                                           PLOTS.8634
          hqual(1) = 1                                                           PLOTS.8635
          hqual(2) = 1                                                           PLOTS.8636
        end if                                                                   PLOTS.8637
      end if                                                                     PLOTS.8638
                                                                                 PLOTS.8639
      if (.not. error) then                                                      PLOTS.8640
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8641
          hstyl(1) = 13                                                          PLOTS.8642
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8643
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8644
          read  (whline(i:i+1),20,err=40) hstyl(1)                               PLOTS.8645
        else                                                                     PLOTS.8646
          read (whline(i:i),30,err=40) hstyl(1)                                  PLOTS.8647
        end if                                                                   PLOTS.8648
        goto 45                                                                  PLOTS.8649
                                                                                 PLOTS.8650
C  Inform the user of an error in the read in                                    PLOTS.8651
                                                                                 PLOTS.8652
40      ermes(1:30)  = 'High Label Style Number Input '                          PLOTS.8653
        ermes(31:60) = 'Conversion                    '                          PLOTS.8654
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8655
        hstyl(1) = 13                                                            PLOTS.8656
        hstyl(2) = 13                                                            PLOTS.8657
        hsize    = 12                                                            PLOTS.8658
        hfilt    = .false.                                                       PLOTS.8659
        hangl    = 0                                                             PLOTS.8660
        hqual(1) = 1                                                             PLOTS.8661
        hqual(2) = 1                                                             PLOTS.8662
        error = .true.                                                           PLOTS.8663
                                                                                 PLOTS.8664
45      if (.not. error) then                                                    PLOTS.8665
          call next (whline,i,error)                                             PLOTS.8666
          if (error) then                                                        PLOTS.8667
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8668
            hstyl(2) = 13                                                        PLOTS.8669
            hsize    = 12                                                        PLOTS.8670
            hfilt    = .false.                                                   PLOTS.8671
            hangl    = 0                                                         PLOTS.8672
            hqual(1) = 1                                                         PLOTS.8673
            hqual(2) = 1                                                         PLOTS.8674
          end if                                                                 PLOTS.8675
        end if                                                                   PLOTS.8676
      end if                                                                     PLOTS.8677
                                                                                 PLOTS.8678
C  What kind of marker to we want for the lows                                   PLOTS.8679
C  There are 13 options, defined in the routine SETHLO                           PLOTS.8680
C  D, d  => style # 13 is used                                                   PLOTS.8681
                                                                                 PLOTS.8682
      if (.not. error) then                                                      PLOTS.8683
        call search (whline,i,error)                                             PLOTS.8684
        if (error) then                                                          PLOTS.8685
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8686
          hstyl(2) = 13                                                          PLOTS.8687
          hsize    = 12                                                          PLOTS.8688
          hfilt    = .false.                                                     PLOTS.8689
          hangl    = 0                                                           PLOTS.8690
          hqual(1) = 1                                                           PLOTS.8691
          hqual(2) = 1                                                           PLOTS.8692
        end if                                                                   PLOTS.8693
      end if                                                                     PLOTS.8694
                                                                                 PLOTS.8695
      if (.not. error) then                                                      PLOTS.8696
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8697
          hstyl(2) = 13                                                          PLOTS.8698
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8699
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8700
          read  (whline(i:i+1),20,err=50) hstyl(2)                               PLOTS.8701
        else                                                                     PLOTS.8702
          read (whline(i:i),30,err=50) hstyl(2)                                  PLOTS.8703
        end if                                                                   PLOTS.8704
        goto 55                                                                  PLOTS.8705
                                                                                 PLOTS.8706
C  Inform the user of an error in the read in                                    PLOTS.8707
                                                                                 PLOTS.8708
50      ermes(1:30)  = 'Low Label Style Number Input C'                          PLOTS.8709
        ermes(31:60) = 'onversion                     '                          PLOTS.8710
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8711
        hstyl(2) = 13                                                            PLOTS.8712
        hsize    = 12                                                            PLOTS.8713
        hfilt    = .false.                                                       PLOTS.8714
        hangl    = 0                                                             PLOTS.8715
        hqual(1) = 1                                                             PLOTS.8716
        hqual(2) = 1                                                             PLOTS.8717
        error = .true.                                                           PLOTS.8718
                                                                                 PLOTS.8719
55      if (.not. error) then                                                    PLOTS.8720
          call next (whline,i,error)                                             PLOTS.8721
          if (error) then                                                        PLOTS.8722
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8723
            hsize    = 12                                                        PLOTS.8724
            hfilt    = .false.                                                   PLOTS.8725
            hangl    = 0                                                         PLOTS.8726
            hqual(1) = 1                                                         PLOTS.8727
            hqual(2) = 1                                                         PLOTS.8728
          end if                                                                 PLOTS.8729
        end if                                                                   PLOTS.8730
      end if                                                                     PLOTS.8731
                                                                                 PLOTS.8732
C  How big should the highs and lows be                                          PLOTS.8733
C  This is specified in plotter coordinates                                      PLOTS.8734
                                                                                 PLOTS.8735
      if (.not. error) then                                                      PLOTS.8736
        call search (whline,i,error)                                             PLOTS.8737
        if (error) then                                                          PLOTS.8738
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8739
          hsize    = 12                                                          PLOTS.8740
          hfilt    = .false.                                                     PLOTS.8741
          hangl    = 0                                                           PLOTS.8742
          hqual(1) = 1                                                           PLOTS.8743
          hqual(2) = 1                                                           PLOTS.8744
        end if                                                                   PLOTS.8745
      end if                                                                     PLOTS.8746
                                                                                 PLOTS.8747
      if (.not. error) then                                                      PLOTS.8748
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8749
          hsize = 12                                                             PLOTS.8750
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8751
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8752
          read  (whline(i:i+1),20,err=60) hsize                                  PLOTS.8753
        else                                                                     PLOTS.8754
          read (whline(i:i),30,err=60) hsize                                     PLOTS.8755
        end if                                                                   PLOTS.8756
        goto 65                                                                  PLOTS.8757
                                                                                 PLOTS.8758
C  Inform the user of an error if here                                           PLOTS.8759
                                                                                 PLOTS.8760
60      ermes(1:30)  = 'High/Low Label Size Input Conv'                          PLOTS.8761
        ermes(31:60) = 'ersion                        '                          PLOTS.8762
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8763
        hsize    = 12                                                            PLOTS.8764
        hfilt    = .false.                                                       PLOTS.8765
        hangl    = 0                                                             PLOTS.8766
        hqual(1) = 1                                                             PLOTS.8767
        hqual(2) = 1                                                             PLOTS.8768
        error = .true.                                                           PLOTS.8769
                                                                                 PLOTS.8770
65      if (.not. error) then                                                    PLOTS.8771
          call next (whline,i,error)                                             PLOTS.8772
          if (error) then                                                        PLOTS.8773
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8774
            hfilt    = .false.                                                   PLOTS.8775
            hangl    = 0                                                         PLOTS.8776
            hqual(1) = 1                                                         PLOTS.8777
            hqual(2) = 1                                                         PLOTS.8778
          end if                                                                 PLOTS.8779
        end if                                                                   PLOTS.8780
      end if                                                                     PLOTS.8781
                                                                                 PLOTS.8782
C  Check to see if the overlap filter has been requested                         PLOTS.8783
                                                                                 PLOTS.8784
      if (.not. error) then                                                      PLOTS.8785
        call search (whline,i,error)                                             PLOTS.8786
        if (error) then                                                          PLOTS.8787
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8788
          hfilt    = .false.                                                     PLOTS.8789
          hangl    = 0                                                           PLOTS.8790
          hqual(1) = 1                                                           PLOTS.8791
          hqual(2) = 1                                                           PLOTS.8792
        end if                                                                   PLOTS.8793
      end if                                                                     PLOTS.8794
                                                                                 PLOTS.8795
      if (.not. error) then                                                      PLOTS.8796
        if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then             PLOTS.8797
          hfilt = .false.                                                        PLOTS.8798
        else if ((whline(i:i) .eq. 'Y') .or.                                     PLOTS.8799
     *           (whline(i:i) .eq. 'y')) then                                    PLOTS.8800
          hfilt = .true.                                                         PLOTS.8801
        else                                                                     PLOTS.8802
          ermes(1:30)  = 'High/Low Label Overlap Filter '                        PLOTS.8803
          ermes(31:60) = 'Flag Is Inconclusive, Y Used  '                        PLOTS.8804
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8805
          hfilt = .true.                                                         PLOTS.8806
        end if                                                                   PLOTS.8807
        call next (whline,i,error)                                               PLOTS.8808
        if (error) then                                                          PLOTS.8809
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.8810
          hangl    = 0                                                           PLOTS.8811
          hqual(1) = 1                                                           PLOTS.8812
          hqual(2) = 1                                                           PLOTS.8813
        end if                                                                   PLOTS.8814
      end if                                                                     PLOTS.8815
                                                                                 PLOTS.8816
C  Get the angle from the horizontal of the highs and lows                       PLOTS.8817
                                                                                 PLOTS.8818
      if (.not. error) then                                                      PLOTS.8819
        call search (whline,i,error)                                             PLOTS.8820
        if (error) then                                                          PLOTS.8821
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8822
          hangl    = 0                                                           PLOTS.8823
          hqual(1) = 1                                                           PLOTS.8824
          hqual(2) = 1                                                           PLOTS.8825
        end if                                                                   PLOTS.8826
      end if                                                                     PLOTS.8827
                                                                                 PLOTS.8828
      if (.not. error) then                                                      PLOTS.8829
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8830
          hangl = 0                                                              PLOTS.8831
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8832
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8833
          if ((whline(i+2:i+2) .ne. ' ') .and.                                   PLOTS.8834
     *        (whline(i+2:i+2) .ne. '|')) then                                   PLOTS.8835
            read (whline(i:i+2),80,err=70) hangl                                 PLOTS.8836
          else                                                                   PLOTS.8837
            read  (whline(i:i+1),20,err=70) hangl                                PLOTS.8838
          end if                                                                 PLOTS.8839
        else                                                                     PLOTS.8840
          read (whline(i:i),30,err=70) hangl                                     PLOTS.8841
        end if                                                                   PLOTS.8842
        goto 75                                                                  PLOTS.8843
                                                                                 PLOTS.8844
C  If there was an error in the read inform the user                             PLOTS.8845
                                                                                 PLOTS.8846
70      ermes(1:30)  = 'High/Low Label Angle Input Con'                          PLOTS.8847
        ermes(31:60) = 'version                       '                          PLOTS.8848
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8849
        hangl    = 0                                                             PLOTS.8850
        hqual(1) = 1                                                             PLOTS.8851
        hqual(2) = 1                                                             PLOTS.8852
        error = .false.                                                          PLOTS.8853
                                                                                 PLOTS.8854
75      if (.not. error) then                                                    PLOTS.8855
          call next (whline,i,error)                                             PLOTS.8856
          if (error) then                                                        PLOTS.8857
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8858
            hqual(1) = 1                                                         PLOTS.8859
            hqual(2) = 1                                                         PLOTS.8860
          end if                                                                 PLOTS.8861
        end if                                                                   PLOTS.8862
      end if                                                                     PLOTS.8863
                                                                                 PLOTS.8864
C  Read in the letter quality to be used in the high low labels                  PLOTS.8865
                                                                                 PLOTS.8866
      if (.not. error) then                                                      PLOTS.8867
        call search (whline,i,error)                                             PLOTS.8868
        if (error) then                                                          PLOTS.8869
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8870
          hqual(1) = 1                                                           PLOTS.8871
          hqual(2) = 1                                                           PLOTS.8872
        end if                                                                   PLOTS.8873
      end if                                                                     PLOTS.8874
                                                                                 PLOTS.8875
      if (.not. error) then                                                      PLOTS.8876
        hqual(2) = -1                                                            PLOTS.8877
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.8878
          hqual(1) = 1                                                           PLOTS.8879
          hqual(2) = 1                                                           PLOTS.8880
        else if (whline(i:i) .eq. '0') then                                      PLOTS.8881
          hqual(1) = 0                                                           PLOTS.8882
        else if (whline(i:i) .eq. '1') then                                      PLOTS.8883
          hqual(1) = 1                                                           PLOTS.8884
        else                                                                     PLOTS.8885
          ermes(1:30)  = 'High/Low Label Text Type Is In'                        PLOTS.8886
          ermes(31:60) = 'valid, 1 Used (Duplex)        '                        PLOTS.8887
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8888
          hqual(1) = 1                                                           PLOTS.8889
        end if                                                                   PLOTS.8890
        if (hqual(2) .eq. -1) then                                               PLOTS.8891
          i = i + 1                                                              PLOTS.8892
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.8893
            hqual(2) = 1                                                         PLOTS.8894
          else if (whline(i:i) .eq. '0') then                                    PLOTS.8895
            hqual(2) = 0                                                         PLOTS.8896
          else if (whline(i:i) .eq. '1') then                                    PLOTS.8897
            hqual(2) = 1                                                         PLOTS.8898
          else if (whline(i:i) .eq. '2') then                                    PLOTS.8899
            hqual(2) = 2                                                         PLOTS.8900
          else                                                                   PLOTS.8901
            ermes(1:30)  = 'High/Low Label Text Quality Is'                      PLOTS.8902
            ermes(31:60) = ' Invalid, 1 Used (Medium)     '                      PLOTS.8903
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8904
            hqual(2) = 1                                                         PLOTS.8905
          end if                                                                 PLOTS.8906
        end if                                                                   PLOTS.8907
        call next (whline,i,error)                                               PLOTS.8908
        if (error) then                                                          PLOTS.8909
          call errhan ('CONDRV',0,q,errsev)                                      PLOTS.8910
        else                                                                     PLOTS.8911
          call search (whline,i,error)                                           PLOTS.8912
          if (.not. error) then                                                  PLOTS.8913
            ermes(1:30)  = 'Reading High/Low Information L'                      PLOTS.8914
            ermes(31:60) = 'ine, Too Many Entries On Line '                      PLOTS.8915
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8916
          end if                                                                 PLOTS.8917
        end if                                                                   PLOTS.8918
      end if                                                                     PLOTS.8919
                                                                                 PLOTS.8920
C  Check for value errors in the set up numbers                                  PLOTS.8921
C  Label Box Perimeter Line Width Needs to Be between 1 and 10                   PLOTS.8922
                                                                                 PLOTS.8923
      if (hprlw .gt. 10.0) then                                                  PLOTS.8924
        ermes(1:30)  = 'High/Low Label Box Perimeter L'                          PLOTS.8925
        ermes(31:60) = 'ine Width Is Too Big, 10 Used '                          PLOTS.8926
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8927
        hprlw = 10.0                                                             PLOTS.8928
      end if                                                                     PLOTS.8929
                                                                                 PLOTS.8930
      if ((hprlw .lt. 1.0) .and. (hputp)) then                                   PLOTS.8931
        ermes(1:30)  = 'High/Low Label Box Perimeter L'                          PLOTS.8932
        ermes(31:60) = 'ine Width Is Too Small, 1 Used'                          PLOTS.8933
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8934
        hprlw = 10.0                                                             PLOTS.8935
      end if                                                                     PLOTS.8936
                                                                                 PLOTS.8937
C  Styles range from 1 to 13                                                     PLOTS.8938
                                                                                 PLOTS.8939
      if ((hstyl(1) .lt. 1) .or. (hstyl(1) .gt. 13)) then                        PLOTS.8940
        ermes(1:30)  = 'High Label Style Is Invalid, S'                          PLOTS.8941
        ermes(31:60) = 'tyle 13 Used                  '                          PLOTS.8942
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8943
        hstyl(1) = 13                                                            PLOTS.8944
      end if                                                                     PLOTS.8945
                                                                                 PLOTS.8946
      if ((hstyl(2) .lt. 1) .or. (hstyl(2) .gt. 13)) then                        PLOTS.8947
        ermes(1:30)  = 'Low Label Style Is Invalid, St'                          PLOTS.8948
        ermes(31:60) = 'yle 13 Used                   '                          PLOTS.8949
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8950
        hstyl(2) = 13                                                            PLOTS.8951
      end if                                                                     PLOTS.8952
                                                                                 PLOTS.8953
C  Size can be no less than 1 and no more than 25                                PLOTS.8954
                                                                                 PLOTS.8955
      if (hsize .lt. 1) then                                                     PLOTS.8956
        ermes(1:30)  = 'High/Low Label Size Is Too Sma'                          PLOTS.8957
        ermes(31:60) = 'll, 1 Used                    '                          PLOTS.8958
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8959
        hsize = 1                                                                PLOTS.8960
      end if                                                                     PLOTS.8961
                                                                                 PLOTS.8962
      if (hsize .gt. 25) then                                                    PLOTS.8963
        ermes(1:30)  = 'High/Low Label Size Is Too Big'                          PLOTS.8964
        ermes(31:60) = ', 25 Used                     '                          PLOTS.8965
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8966
        hsize = 25                                                               PLOTS.8967
      end if                                                                     PLOTS.8968
                                                                                 PLOTS.8969
C  Angle can only be given between 0 and 360 degrees inclusive                   PLOTS.8970
                                                                                 PLOTS.8971
      if ((hangl .lt. 0) .or. (hangl .gt. 360)) then                             PLOTS.8972
        ermes(1:30)  = 'High/Low Label Angle Is Invali'                          PLOTS.8973
        ermes(31:60) = 'd, 0 Degrees Used             '                          PLOTS.8974
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8975
        hangl = 0                                                                PLOTS.8976
      end if                                                                     PLOTS.8977
                                                                                 PLOTS.8978
C  Quality, the first number is the type of characters                           PLOTS.8979
C    0 - Complex                                                                 PLOTS.8980
C    1 - Duplex                                                                  PLOTS.8981
C  the second number is the quality of characters                                PLOTS.8982
C    0 - High Quality                                                            PLOTS.8983
C    1 - Medium Quality                                                          PLOTS.8984
C    2 - Low Quality                                                             PLOTS.8985
                                                                                 PLOTS.8986
      if ((hqual(1) .ne. 0) .and. (hqual(1) .ne. 1)) then                        PLOTS.8987
        ermes(1:30)  = 'High/Low Label Text Type Is In'                          PLOTS.8988
        ermes(31:60) = 'valid, 1 Assumed (Duplex)     '                          PLOTS.8989
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8990
        hqual(1) = 1                                                             PLOTS.8991
      end if                                                                     PLOTS.8992
                                                                                 PLOTS.8993
      if ((hqual(2) .gt. 2) .or. (hqual(2) .lt. 0)) then                         PLOTS.8994
        ermes(1:30)  = 'High/Low Label Text Quality Is'                          PLOTS.8995
        ermes(31:60) = ' Invalid, 1 Assumed (Medium)  '                          PLOTS.8996
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8997
        hqual(2) = 1                                                             PLOTS.8998
      end if                                                                     PLOTS.8999
                                                                                 PLOTS.9000
C  Assign output variable                                                        PLOTS.9001
                                                                                 PLOTS.9002
      ofilb = hfilb                                                              PLOTS.9003
                                                                                 PLOTS.9004
C*****************************  subroutine end  ******************************C  PLOTS.9005
                                                                                 PLOTS.9006
C  Format statements begin ...                                                   PLOTS.9007
                                                                                 PLOTS.9008
20    format (I2)                                                                PLOTS.9009
30    format (I1)                                                                PLOTS.9010
80    format (I3)                                                                PLOTS.9011
                                                                                 PLOTS.9012
C  Format statements end.                                                        PLOTS.9013
                                                                                 PLOTS.9014
      return                                                                     PLOTS.9015
      end                                                                        PLOTS.9016
      subroutine crdlab (whline,errsev,ofilb)                                    PLOTS.9017
                                                                                 PLOTS.9018
C*****************************************************************************C  PLOTS.9019
C  crdlab   - This is a CONDRV routine                                        C  PLOTS.9020
C  Section  - Tables                                                          C  PLOTS.9021
C  Purpose  - To determine line label information as specified by the user in C  PLOTS.9022
C             the CON DETAILS table.                                          C  PLOTS.9023
C                                                                             C  PLOTS.9024
C  On entry - WHLINE  contains  the line from  the table  which holds all the C  PLOTS.9025
C             needed information.  ERRSEV indicates what severity of an error C  PLOTS.9026
C             will cause execution to cease.                                  C  PLOTS.9027
C                                                                             C  PLOTS.9028
C  On exit  - All of the values in common block LABDET have been set up.  The C  PLOTS.9029
C             variables in LBQDET too have been set up correctly.  OFILB says C  PLOTS.9030
C             if the line label boxes will be filled or not.                  C  PLOTS.9031
C                                                                             C  PLOTS.9032
C  Assume   - Nothing.                                                        C  PLOTS.9033
C                                                                             C  PLOTS.9034
C  Notes    - Routine             Location of Definition                      C  PLOTS.9035
C             ----------------------------------------------------------------C  PLOTS.9036
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.9037
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.9038
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.9039
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.9040
C             ----------------------------------------------------------------C  PLOTS.9041
C                                                                             C  PLOTS.9042
C  Author   - Jeremy Asbill       Date - June 11, 1990      for the MM4 club  C  PLOTS.9043
C*****************************************************************************C  PLOTS.9044
                                                                                 PLOTS.9045
C  Character variables                                                           PLOTS.9046
                                                                                 PLOTS.9047
      character*80     whline            ! the line from the table         (in)  PLOTS.9048
      character*60     p,                ! error message string, SEARCH (local)  PLOTS.9049
     *                 q,                ! error message string, NEXT   (local)  PLOTS.9050
     *                 ermes             ! error message string, general(local)  PLOTS.9051
      character*20     gstrng            ! temporary string             (local)  PLOTS.9052
                                                                                 PLOTS.9053
C  Integer variables                                                             PLOTS.9054
                                                                                 PLOTS.9055
      integer          errsev            ! error severity comparitor       (in)  PLOTS.9056
      integer          lqual(2)          ! for common block LBQDET               PLOTS.9057
      integer          lsize,            ! for common block LABDET               PLOTS.9058
     *                 lortn,            ! for common block LABDET               PLOTS.9059
     *                 langl,            ! for common block LABDET               PLOTS.9060
     *                 lintv             ! for common block LABDET               PLOTS.9061
                                                                                 PLOTS.9062
C  Logical varaibles                                                             PLOTS.9063
                                                                                 PLOTS.9064
      logical          ofilb             ! out version of LFILB           (out)  PLOTS.9065
      logical          lputb,            ! for common block LABDET               PLOTS.9066
     *                 lputp,            ! for common block LABDET               PLOTS.9067
     *                 lfilb             ! for common block LABDET               PLOTS.9068
      logical          error             ! has an error occured ?       (local)  PLOTS.9069
                                                                                 PLOTS.9070
C  Real variables                                                                PLOTS.9071
                                                                                 PLOTS.9072
      real             lprlw             ! for common block LABDET               PLOTS.9073
                                                                                 PLOTS.9074
C  Common blocks                                                                 PLOTS.9075
                                                                                 PLOTS.9076
      common /labdet/  lputb,            ! put boxes on the line labels ?        PLOTS.9077
     *                 lputp,            ! put perimeter on label boxes ?        PLOTS.9078
     *                 lfilb,            ! fill label boxes ?                    PLOTS.9079
     *                 lprlw,            ! label box perimeter line width        PLOTS.9080
     *                 lsize,            ! line label character size             PLOTS.9081
     *                 lintv,            ! line label placement per line         PLOTS.9082
     *                 langl,            ! line label angle                      PLOTS.9083
     *                 lortn             ! line label orientation                PLOTS.9084
      common /lbqdet/  lqual             ! line label character quality          PLOTS.9085
                                                                                 PLOTS.9086
C****************************  subroutine begin  *****************************C  PLOTS.9087
                                                                                 PLOTS.9088
C  Set up I to use as a counter                                                  PLOTS.9089
                                                                                 PLOTS.9090
      i = 1                                                                      PLOTS.9091
                                                                                 PLOTS.9092
C  Initialize the error flag                                                     PLOTS.9093
                                                                                 PLOTS.9094
      error = .false.                                                            PLOTS.9095
                                                                                 PLOTS.9096
C  Set up the SEARCH and NEXT error message strings                              PLOTS.9097
                                                                                 PLOTS.9098
      p(1:23)  = 'Reading Line Label Info'                                       PLOTS.9099
      p(24:60) = 'rmation Line, Too Few Entries On Line'                         PLOTS.9100
      q(1:23)  = p(1:23)                                                         PLOTS.9101
      q(24:60) = 'rmation Line, Entry Is Bizarre       '                         PLOTS.9102
                                                                                 PLOTS.9103
C  The first search is erred upon if WHLINE is blank, if this is the case        PLOTS.9104
C  CONDRV does not consider that an error but an instruction to default all      PLOTS.9105
C  line label information                                                        PLOTS.9106
                                                                                 PLOTS.9107
      call search (whline,i,error)                                               PLOTS.9108
      if (error) then                                                            PLOTS.9109
        lputb    = .false.                                                       PLOTS.9110
        lputp    = .false.                                                       PLOTS.9111
        lfilb    = .false.                                                       PLOTS.9112
        lsize    = 8                                                             PLOTS.9113
        lintv    = 4                                                             PLOTS.9114
        langl    = 0                                                             PLOTS.9115
        lortn    = 1                                                             PLOTS.9116
        lqual(1) = 1                                                             PLOTS.9117
        lqual(2) = 1                                                             PLOTS.9118
      end if                                                                     PLOTS.9119
                                                                                 PLOTS.9120
C  Parse out the line label box flag, first                                      PLOTS.9121
C  Y             => Do draw a box around the line labels                         PLOTS.9122
C  N             => Don't draw a box around the line labels                      PLOTS.9123
C  anything else => Give a warning message                                       PLOTS.9124
                                                                                 PLOTS.9125
      if (.not. error) then                                                      PLOTS.9126
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.9127
          lputb = .true.                                                         PLOTS.9128
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.9129
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.9130
          lputb = .false.                                                        PLOTS.9131
        else                                                                     PLOTS.9132
          ermes(1:30)  = 'Line Label Box Flag Is Inconcl'                        PLOTS.9133
          ermes(31:60) = 'usive, N Assumed              '                        PLOTS.9134
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.9135
          lputb = .false.                                                        PLOTS.9136
        end if                                                                   PLOTS.9137
        call next (whline,i,error)                                               PLOTS.9138
        if (error) then                                                          PLOTS.9139
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.9140
          lsize    = 8                                                           PLOTS.9141
          lintv    = 4                                                           PLOTS.9142
          langl    = 0                                                           PLOTS.9143
          lortn    = 1                                                           PLOTS.9144
          lqual(1) = 1                                                           PLOTS.9145
          lqual(2) = 1                                                           PLOTS.9146
        end if                                                                   PLOTS.9147
      end if                                                                     PLOTS.9148
                                                                                 PLOTS.9149
C  Parse through the label line box detail information if a box has been         PLOTS.9150
C  requested                                                                     PLOTS.9151
                                                                                 PLOTS.9152
      if ((lputb) .and. (.not. error)) then                                      PLOTS.9153
                                                                                 PLOTS.9154
C  First is the box perimeter flag                                               PLOTS.9155
C  Y             => Do draw a perimeter around the line label box                PLOTS.9156
C  N             => Don't draw a perimeter around the line label box             PLOTS.9157
C  anything else => Give a warning message                                       PLOTS.9158
                                                                                 PLOTS.9159
        call search (whline,i,error)                                             PLOTS.9160
        if (error) then                                                          PLOTS.9161
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9162
          lputp    = .false.                                                     PLOTS.9163
          lfilb    = .false.                                                     PLOTS.9164
          lprlw    = 0.0                                                         PLOTS.9165
          lsize    = 8                                                           PLOTS.9166
          lintv    = 4                                                           PLOTS.9167
          langl    = 0                                                           PLOTS.9168
          lortn    = 1                                                           PLOTS.9169
          lqual(1) = 1                                                           PLOTS.9170
          lqual(2) = 1                                                           PLOTS.9171
        end if                                                                   PLOTS.9172
                                                                                 PLOTS.9173
        if (.not. error) then                                                    PLOTS.9174
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.9175
            lputp = .false.                                                      PLOTS.9176
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.9177
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.9178
            lputp = .true.                                                       PLOTS.9179
          else                                                                   PLOTS.9180
            ermes(1:30)  = 'Line Label Box Perimeter Flag '                      PLOTS.9181
            ermes(31:60) = 'Is Inconclusive, N Assumed    '                      PLOTS.9182
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9183
            lputp = .false.                                                      PLOTS.9184
          end if                                                                 PLOTS.9185
          call next (whline,i,error)                                             PLOTS.9186
          if (error) then                                                        PLOTS.9187
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9188
            lfilb    = .false.                                                   PLOTS.9189
            if (lputp) then                                                      PLOTS.9190
              lprlw    = 1.0                                                     PLOTS.9191
            else                                                                 PLOTS.9192
              lprlw    = 0.0                                                     PLOTS.9193
            end if                                                               PLOTS.9194
            lsize    = 8                                                         PLOTS.9195
            lintv    = 4                                                         PLOTS.9196
            langl    = 0                                                         PLOTS.9197
            lortn    = 1                                                         PLOTS.9198
            lqual(1) = 1                                                         PLOTS.9199
            lqual(2) = 1                                                         PLOTS.9200
          end if                                                                 PLOTS.9201
        end if                                                                   PLOTS.9202
                                                                                 PLOTS.9203
C  Next is the line label box fill flag                                          PLOTS.9204
C  Y              => Fill the box                                                PLOTS.9205
C  N              => Leave the box hollow                                        PLOTS.9206
C  Anything else  => Give Warning message                                        PLOTS.9207
                                                                                 PLOTS.9208
        if (.not. error) then                                                    PLOTS.9209
          call search (whline,i,error)                                           PLOTS.9210
          if (error) then                                                        PLOTS.9211
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.9212
            lfilb    = .false.                                                   PLOTS.9213
            if (lputp) then                                                      PLOTS.9214
              lprlw    = 1.0                                                     PLOTS.9215
            else                                                                 PLOTS.9216
              lprlw    = 0.0                                                     PLOTS.9217
            end if                                                               PLOTS.9218
            lsize    = 8                                                         PLOTS.9219
            lintv    = 4                                                         PLOTS.9220
            langl    = 0                                                         PLOTS.9221
            lortn    = 1                                                         PLOTS.9222
            lqual(1) = 1                                                         PLOTS.9223
            lqual(2) = 1                                                         PLOTS.9224
          end if                                                                 PLOTS.9225
        end if                                                                   PLOTS.9226
                                                                                 PLOTS.9227
        if (.not. error) then                                                    PLOTS.9228
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.9229
            lfilb = .true.                                                       PLOTS.9230
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.9231
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.9232
            lfilb = .false.                                                      PLOTS.9233
          else                                                                   PLOTS.9234
            ermes(1:30)  = 'Line Label Box Fill Flag Is In'                      PLOTS.9235
            ermes(31:60) = 'conclusive, N Assumed         '                      PLOTS.9236
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9237
            lfilb = .false.                                                      PLOTS.9238
          end if                                                                 PLOTS.9239
          call next (whline,i,error)                                             PLOTS.9240
          if (error) then                                                        PLOTS.9241
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9242
            if (lputp) then                                                      PLOTS.9243
              lprlw    = 1.0                                                     PLOTS.9244
            else                                                                 PLOTS.9245
              lprlw    = 0.0                                                     PLOTS.9246
            end if                                                               PLOTS.9247
            lsize    = 8                                                         PLOTS.9248
            lintv    = 4                                                         PLOTS.9249
            langl    = 0                                                         PLOTS.9250
            lortn    = 1                                                         PLOTS.9251
            lqual(1) = 1                                                         PLOTS.9252
            lqual(2) = 1                                                         PLOTS.9253
          end if                                                                 PLOTS.9254
        end if                                                                   PLOTS.9255
                                                                                 PLOTS.9256
C  What line width should the box perimeter have?  This value is a mulitplier    PLOTS.9257
C  by the normal line width, a "D" or a "d" indicates normal line width          PLOTS.9258
                                                                                 PLOTS.9259
        if ((lputp) .and. (.not. error)) then                                    PLOTS.9260
          call search (whline,i,error)                                           PLOTS.9261
          if (error) then                                                        PLOTS.9262
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.9263
            if (lputp) then                                                      PLOTS.9264
              lprlw    = 1.0                                                     PLOTS.9265
            else                                                                 PLOTS.9266
              lprlw    = 0.0                                                     PLOTS.9267
            end if                                                               PLOTS.9268
            lsize    = 8                                                         PLOTS.9269
            lintv    = 4                                                         PLOTS.9270
            langl    = 0                                                         PLOTS.9271
            lortn    = 1                                                         PLOTS.9272
            lqual(1) = 1                                                         PLOTS.9273
            lqual(2) = 1                                                         PLOTS.9274
          end if                                                                 PLOTS.9275
        end if                                                                   PLOTS.9276
                                                                                 PLOTS.9277
        if ((lputp) .and. (.not. error)) then                                    PLOTS.9278
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.9279
            lprlw = 1.0                                                          PLOTS.9280
            call next (whline,i,error)                                           PLOTS.9281
          else                                                                   PLOTS.9282
            j = 1                                                                PLOTS.9283
            call next (whline,i,error)                                           PLOTS.9284
            if (.not. error) then                                                PLOTS.9285
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9286
              do 10 k = i-j+1,20                                                 PLOTS.9287
                gstrng(k:k) = ' '                                                PLOTS.9288
10            continue                                                           PLOTS.9289
              call gtreal (gstrng,lprlw,error)                                   PLOTS.9290
              if (error) then                                                    PLOTS.9291
                ermes(1:30)  = 'Could Not Read Line Label Box '                  PLOTS.9292
                ermes(31:60) = 'Perimeter Width, 1.0 Used     '                  PLOTS.9293
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.9294
                lprlw = 1.0                                                      PLOTS.9295
                error = .false.                                                  PLOTS.9296
              end if                                                             PLOTS.9297
            end if                                                               PLOTS.9298
          end if                                                                 PLOTS.9299
          if (error) then                                                        PLOTS.9300
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9301
            lsize    = 8                                                         PLOTS.9302
            lintv    = 4                                                         PLOTS.9303
            langl    = 0                                                         PLOTS.9304
            lortn    = 1                                                         PLOTS.9305
            lqual(1) = 1                                                         PLOTS.9306
            lqual(2) = 1                                                         PLOTS.9307
          end if                                                                 PLOTS.9308
        end if                                                                   PLOTS.9309
      else                                                                       PLOTS.9310
        lfilb = .false.                                                          PLOTS.9311
        lputp = .false.                                                          PLOTS.9312
        lprlw  = 0.0                                                             PLOTS.9313
      end if                                                                     PLOTS.9314
                                                                                 PLOTS.9315
C  Parse out character quality                                                   PLOTS.9316
C  0 In space 1          => Complex Characters will be used                      PLOTS.9317
C  1 In space 1          => Duplex Characters will be used                       PLOTS.9318
C  0 In space 2          => Characters are of high quality                       PLOTS.9319
C  1 In space 2          => Medium Quality                                       PLOTS.9320
C  2 In space 2          => Low Quality                                          PLOTS.9321
C  Anything Else         => Give a Warning Message                               PLOTS.9322
                                                                                 PLOTS.9323
      if (.not. error) then                                                      PLOTS.9324
        call search (whline,i,error)                                             PLOTS.9325
        if (error) then                                                          PLOTS.9326
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9327
          lsize    = 8                                                           PLOTS.9328
          lintv    = 4                                                           PLOTS.9329
          langl    = 0                                                           PLOTS.9330
          lortn    = 1                                                           PLOTS.9331
          lqual(1) = 1                                                           PLOTS.9332
          lqual(2) = 1                                                           PLOTS.9333
        end if                                                                   PLOTS.9334
      end if                                                                     PLOTS.9335
                                                                                 PLOTS.9336
      if (.not. error) then                                                      PLOTS.9337
        lqual(2) = -1                                                            PLOTS.9338
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.9339
          lqual(1) = 1                                                           PLOTS.9340
          lqual(2) = 1                                                           PLOTS.9341
        else if (whline(i:i) .eq. '0') then                                      PLOTS.9342
          lqual(1) = 0                                                           PLOTS.9343
        else if (whline(i:i) .eq. '1') then                                      PLOTS.9344
          lqual(1) = 1                                                           PLOTS.9345
        else                                                                     PLOTS.9346
          ermes(1:30)  = 'Line Label Text Type Is Invali'                        PLOTS.9347
          ermes(31:60) = 'd, 1 Used (Duplex)            '                        PLOTS.9348
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.9349
          lqual(1) = 1                                                           PLOTS.9350
        end if                                                                   PLOTS.9351
        if (lqual(2) .eq. -1) then                                               PLOTS.9352
          i = i + 1                                                              PLOTS.9353
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.9354
            lqual(2) = 1                                                         PLOTS.9355
          else if (whline(i:i) .eq. '0') then                                    PLOTS.9356
            lqual(2) = 0                                                         PLOTS.9357
          else if (whline(i:i) .eq. '1') then                                    PLOTS.9358
            lqual(2) = 1                                                         PLOTS.9359
          else if (whline(i:i) .eq. '2') then                                    PLOTS.9360
            lqual(2) = 2                                                         PLOTS.9361
          else                                                                   PLOTS.9362
            ermes(1:30)  = 'Line Label Text Quality Is Inv'                      PLOTS.9363
            ermes(31:60) = 'alid, 1 Used (Medium)         '                      PLOTS.9364
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9365
            lqual(2) = 1                                                         PLOTS.9366
          end if                                                                 PLOTS.9367
        end if                                                                   PLOTS.9368
        call next (whline,i,error)                                               PLOTS.9369
        if (error) then                                                          PLOTS.9370
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.9371
          lsize    = 8                                                           PLOTS.9372
          lintv    = 4                                                           PLOTS.9373
          langl    = 0                                                           PLOTS.9374
          lortn    = 1                                                           PLOTS.9375
        end if                                                                   PLOTS.9376
      end if                                                                     PLOTS.9377
                                                                                 PLOTS.9378
C  How big should line labels be                                                 PLOTS.9379
C  This is specified in plotter coordinates                                      PLOTS.9380
                                                                                 PLOTS.9381
      if (.not. error) then                                                      PLOTS.9382
        call search (whline,i,error)                                             PLOTS.9383
        if (error) then                                                          PLOTS.9384
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9385
          lsize    = 8                                                           PLOTS.9386
          lintv    = 4                                                           PLOTS.9387
          langl    = 0                                                           PLOTS.9388
          lortn    = 1                                                           PLOTS.9389
        end if                                                                   PLOTS.9390
      end if                                                                     PLOTS.9391
                                                                                 PLOTS.9392
      if (.not. error) then                                                      PLOTS.9393
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.9394
          lsize = 8                                                              PLOTS.9395
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.9396
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.9397
          read  (whline(i:i+1),20,err=40) lsize                                  PLOTS.9398
        else                                                                     PLOTS.9399
          read (whline(i:i),30,err=40) lsize                                     PLOTS.9400
        end if                                                                   PLOTS.9401
        goto 45                                                                  PLOTS.9402
                                                                                 PLOTS.9403
C  Inform the user of an error if here                                           PLOTS.9404
                                                                                 PLOTS.9405
40      ermes(1:30)  = 'Line Label Size Input Conversi'                          PLOTS.9406
        ermes(31:60) = 'on                            '                          PLOTS.9407
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9408
        lsize    = 8                                                             PLOTS.9409
        langl    = 0                                                             PLOTS.9410
        lintv    = 4                                                             PLOTS.9411
        lortn    = 1                                                             PLOTS.9412
        error = .true.                                                           PLOTS.9413
                                                                                 PLOTS.9414
45      if (.not. error) then                                                    PLOTS.9415
          call next (whline,i,error)                                             PLOTS.9416
          if (error) then                                                        PLOTS.9417
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9418
            lintv    = 4                                                         PLOTS.9419
            langl    = 0                                                         PLOTS.9420
            lortn    = 1                                                         PLOTS.9421
          end if                                                                 PLOTS.9422
        end if                                                                   PLOTS.9423
      end if                                                                     PLOTS.9424
                                                                                 PLOTS.9425
C  Check to see how the user wants their labels oriented                         PLOTS.9426
C  D,d           => drawn along with line                                        PLOTS.9427
C  360 > x > 0   => rotated x degrees from horizontal                            PLOTS.9428
C  = 0           => horizontal                                                   PLOTS.9429
                                                                                 PLOTS.9430
      if (.not. error) then                                                      PLOTS.9431
        call search (whline,i,error)                                             PLOTS.9432
        if (error) then                                                          PLOTS.9433
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9434
          lintv    = 4                                                           PLOTS.9435
          langl    = 0                                                           PLOTS.9436
          lortn    = 1                                                           PLOTS.9437
        end if                                                                   PLOTS.9438
      end if                                                                     PLOTS.9439
                                                                                 PLOTS.9440
      if (.not. error) then                                                      PLOTS.9441
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.9442
          lortn = 1                                                              PLOTS.9443
          langl = 0                                                              PLOTS.9444
        else                                                                     PLOTS.9445
          lortn = 0                                                              PLOTS.9446
          if ((whline(i+1:i+1) .ne. ' ') .and.                                   PLOTS.9447
     *        (whline(i+1:i+1) .ne. '|')) then                                   PLOTS.9448
            if ((whline(i+2:i+2) .ne. ' ') .and.                                 PLOTS.9449
     *          (whline(i+2:i+2) .ne. '|')) then                                 PLOTS.9450
              read (whline(i:i+2),60,err=50) langl                               PLOTS.9451
            else                                                                 PLOTS.9452
              read (whline(i:i+1),20,err=50) langl                               PLOTS.9453
            end if                                                               PLOTS.9454
          else                                                                   PLOTS.9455
            read (whline(i:i),30,err=50) langl                                   PLOTS.9456
          end if                                                                 PLOTS.9457
        end if                                                                   PLOTS.9458
        goto 55                                                                  PLOTS.9459
                                                                                 PLOTS.9460
C  Inform user of error if here                                                  PLOTS.9461
                                                                                 PLOTS.9462
50      ermes(1:30)  = 'Line Label Angle Input Convers'                          PLOTS.9463
        ermes(31:60) = 'ion                           '                          PLOTS.9464
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9465
        langl    = 0                                                             PLOTS.9466
        lintv    = 4                                                             PLOTS.9467
        lortn    = 1                                                             PLOTS.9468
        error = .true.                                                           PLOTS.9469
                                                                                 PLOTS.9470
55      if (.not. error) then                                                    PLOTS.9471
          call next (whline,i,error)                                             PLOTS.9472
          if (error) then                                                        PLOTS.9473
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9474
            lintv = 4                                                            PLOTS.9475
          end if                                                                 PLOTS.9476
        end if                                                                   PLOTS.9477
      end if                                                                     PLOTS.9478
                                                                                 PLOTS.9479
C  Get the interval of lines at which to place line labels                       PLOTS.9480
                                                                                 PLOTS.9481
      if (.not. error) then                                                      PLOTS.9482
        call search (whline,i,error)                                             PLOTS.9483
        if (error) then                                                          PLOTS.9484
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9485
          lintv = 4                                                              PLOTS.9486
        end if                                                                   PLOTS.9487
      end if                                                                     PLOTS.9488
                                                                                 PLOTS.9489
      if (.not. error) then                                                      PLOTS.9490
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.9491
          lintv = 4                                                              PLOTS.9492
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.9493
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.9494
          if ((whline(i+2:i+2) .ne. ' ') .and.                                   PLOTS.9495
     *        (whline(i+2:i+2) .ne. '|')) then                                   PLOTS.9496
            read (whline(i:i+2),60,err=70) lintv                                 PLOTS.9497
          else                                                                   PLOTS.9498
            read (whline(i:i+1),20,err=70) lintv                                 PLOTS.9499
          end if                                                                 PLOTS.9500
        else                                                                     PLOTS.9501
          read (whline(i:i),30,err=70) lintv                                     PLOTS.9502
        end if                                                                   PLOTS.9503
        goto 75                                                                  PLOTS.9504
                                                                                 PLOTS.9505
C  Inform user of an error if here                                               PLOTS.9506
                                                                                 PLOTS.9507
70      ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9508
        ermes(31:60) = 'Input Conversion              '                          PLOTS.9509
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9510
        lintv    = 4                                                             PLOTS.9511
        error = .true.                                                           PLOTS.9512
                                                                                 PLOTS.9513
75      if (.not. error) then                                                    PLOTS.9514
          call next (whline,i,error)                                             PLOTS.9515
          if (error) then                                                        PLOTS.9516
            call errhan ('CONDRV',0,q,errsev)                                    PLOTS.9517
          else                                                                   PLOTS.9518
            call search (whline,i,error)                                         PLOTS.9519
            if (.not. error) then                                                PLOTS.9520
              ermes(1:30)  = 'Reading Line Labels Informatio'                    PLOTS.9521
              ermes(31:60) = 'n, Too Many Entries On Line   '                    PLOTS.9522
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.9523
            end if                                                               PLOTS.9524
          end if                                                                 PLOTS.9525
        end if                                                                   PLOTS.9526
      end if                                                                     PLOTS.9527
                                                                                 PLOTS.9528
                                                                                 PLOTS.9529
C  Check for some value errors                                                   PLOTS.9530
C  LPRLW must be between 1 and 10 inclusive if the perimeter is going to         PLOTS.9531
C  be drawn around boxes                                                         PLOTS.9532
                                                                                 PLOTS.9533
      if ((lputp) .and. (lprlw .lt. 1.0)) then                                   PLOTS.9534
        ermes(1:30)  = 'Line Label Box Perimeter Width'                          PLOTS.9535
        ermes(31:60) = 's Less Than 1 Are Ineffective '                          PLOTS.9536
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9537
        lprlw = 1.0                                                              PLOTS.9538
      end if                                                                     PLOTS.9539
      if ((lputp) .and. (lprlw .gt. 10.0)) then                                  PLOTS.9540
        ermes(1:30)  = 'Line Label Box Perimeter Width'                          PLOTS.9541
        ermes(31:60) = 's Greater Than 10 Are Too Big '                          PLOTS.9542
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9543
        lprlw = 10.0                                                             PLOTS.9544
      end if                                                                     PLOTS.9545
                                                                                 PLOTS.9546
C  Maximum Label Size is 25 and the minimum is 1                                 PLOTS.9547
                                                                                 PLOTS.9548
      if (lsize .lt. 1) then                                                     PLOTS.9549
        ermes(1:30)  = 'Line Label Size Is Too Small, '                          PLOTS.9550
        ermes(31:60) = 'Changed To 1                  '                          PLOTS.9551
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9552
        lsize = 1                                                                PLOTS.9553
      end if                                                                     PLOTS.9554
      if (lsize .gt. 25) then                                                    PLOTS.9555
        ermes(1:30)  = 'Line Label Size Is Too Large, '                          PLOTS.9556
        ermes(31:60) = 'Changed To 25                 '                          PLOTS.9557
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9558
        lsize = 25                                                               PLOTS.9559
      end if                                                                     PLOTS.9560
                                                                                 PLOTS.9561
C  Label angle must be between 0 and 360                                         PLOTS.9562
                                                                                 PLOTS.9563
      if ((langl .lt. 0) .or. (langl .gt. 360)) then                             PLOTS.9564
        ermes(1:30)  = 'Line Label Angle Is Invalid, L'                          PLOTS.9565
        ermes(31:60) = 'abels Will Be Along Lines     '                          PLOTS.9566
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9567
        langl = 0                                                                PLOTS.9568
        lortn = 1                                                                PLOTS.9569
      end if                                                                     PLOTS.9570
                                                                                 PLOTS.9571
C  Label Interval must be at least 1 and at most 100                             PLOTS.9572
                                                                                 PLOTS.9573
      if (lintv .lt. 1) then                                                     PLOTS.9574
        ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9575
        ermes(31:60) = 'Too Small, Changed to 1       '                          PLOTS.9576
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9577
        lintv = 1                                                                PLOTS.9578
      end if                                                                     PLOTS.9579
      if (lintv .gt. 100) then                                                   PLOTS.9580
        ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9581
        ermes(31:60) = 'Too Large, Changed to 100     '                          PLOTS.9582
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9583
        lintv = 100                                                              PLOTS.9584
      end if                                                                     PLOTS.9585
                                                                                 PLOTS.9586
C  Assign output variable                                                        PLOTS.9587
                                                                                 PLOTS.9588
      ofilb = lfilb                                                              PLOTS.9589
                                                                                 PLOTS.9590
C*****************************  subroutine end  ******************************C  PLOTS.9591
                                                                                 PLOTS.9592
C  Format statements begin ...                                                   PLOTS.9593
                                                                                 PLOTS.9594
20    format (I2)                                                                PLOTS.9595
30    format (I1)                                                                PLOTS.9596
60    format (I3)                                                                PLOTS.9597
                                                                                 PLOTS.9598
C  Format statements end.                                                        PLOTS.9599
                                                                                 PLOTS.9600
      return                                                                     PLOTS.9601
      end                                                                        PLOTS.9602
      subroutine crdprt (unum,errsev,cmeth,scale)                                PLOTS.9603
                                                                                 PLOTS.9604
C*****************************************************************************C  PLOTS.9605
C  crdprt   - This is a CONDRV routine                                        C  PLOTS.9606
C  Section  - Tables                                                          C  PLOTS.9607
C  Purpose  - To read in contouring partitions indicated by the user.         C  PLOTS.9608
C                                                                             C  PLOTS.9609
C  On entry - UNUM is the unit number of the file containing the  CON  PARTI- C  PLOTS.9610
C             TIONS table.   ERRSEV indicated what  severity of error  should C  PLOTS.9611
C             halt execution.   CMETH is the  coloring  method to be used  in C  PLOTS.9612
C             the  picture.   SCALE is a scaling factor that will be used  in C  PLOTS.9613
C             labeling the plot.                                              C  PLOTS.9614
C                                                                             C  PLOTS.9615
C  On exit  - Variables in common blocks for partitions,  color,  line width, C  PLOTS.9616
C             and dash pattern have been set up.  Remember not  all of  these C  PLOTS.9617
C             need to be set up all the time.                                 C  PLOTS.9618
C                                                                             C  PLOTS.9619
C  Assume   - Nothing                                                         C  PLOTS.9620
C                                                                             C  PLOTS.9621
C  Notes    - Routine             Location of Definition                      C  PLOTS.9622
C             ----------------------------------------------------------------C  PLOTS.9623
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.9624
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.9625
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.9626
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.9627
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.9628
C             CRDRCI              CONDRV/MAPDRV utility                       C  PLOTS.9629
C             ----------------------------------------------------------------C  PLOTS.9630
C                                                                             C  PLOTS.9631
C  Author   - Jeremy Asbill      Date - August 9, 1990      for the MM4 club  C  PLOTS.9632
C*****************************************************************************C  PLOTS.9633
                                                                                 PLOTS.9634
C  Parameters                                                                    PLOTS.9635
                                                                                 PLOTS.9636
      parameter       (imin = -1)        ! since before the first contour level  PLOTS.9637
      parameter       (imax = 101)       ! until after the last contour level    PLOTS.9638
      parameter       (rmin = -1.0E36)   ! the smallest value in the data        PLOTS.9639
      parameter       (rmax = 1.0E36)    ! the largest value in the data         PLOTS.9640
                                                                                 PLOTS.9641
C  Character variables                                                           PLOTS.9642
                                                                                 PLOTS.9643
      character*80     whline            ! a whole line from the table  (local)  PLOTS.9644
      character*60     ermes,            ! error message string,general (local)  PLOTS.9645
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.9646
     *                 q                 ! error message string,NEXT    (local)  PLOTS.9647
      character*36     cermes            ! color index error message    (local)  PLOTS.9648
      character*20     gstrng            ! string for GTREAL            (local)  PLOTS.9649
                                                                                 PLOTS.9650
C  Integer variables                                                             PLOTS.9651
                                                                                 PLOTS.9652
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.9653
     *                 unum,             ! unit number of table file       (in)  PLOTS.9654
     *                 cmeth             ! coloring method to use          (in)  PLOTS.9655
      integer          ddpv(3)           ! for common block LWDPDT               PLOTS.9656
      integer          nprt,             ! for common block PARINF               PLOTS.9657
     *                 iprts(100,2)      ! for common block PARINF               PLOTS.9658
      integer          pcolor(100,2)     ! for common block PARCOL               PLOTS.9659
      integer          pdpv(100)         ! for common block LWDPPR               PLOTS.9660
      integer          cmln,             ! number of chars in CERMES    (local)  PLOTS.9661
     *                 i,j               ! loop counter/place keeper    (local)  PLOTS.9662
                                                                                 PLOTS.9663
C  Logical variables                                                             PLOTS.9664
                                                                                 PLOTS.9665
      logical          noplt             ! don't make any plot ?           (in)  PLOTS.9666
      logical          ints              ! for common block PARINF               PLOTS.9667
      logical          found,            ! was the table found ?        (local)  PLOTS.9668
     *                 error,            ! has an error occured ?       (local)  PLOTS.9669
     *                 done              ! are all partitions in ?      (local)  PLOTS.9670
                                                                                 PLOTS.9671
C  Real variables                                                                PLOTS.9672
                                                                                 PLOTS.9673
      real             scale             ! scaling factor                  (in)  PLOTS.9674
      real             dlwv(3)           ! for common block LWDPDT               PLOTS.9675
      real             rprts(100,2)      ! for common block PARINF               PLOTS.9676
      real             plwv(100)         ! for common block LWDPPR               PLOTS.9677
                                                                                 PLOTS.9678
C  Common blocks                                                                 PLOTS.9679
                                                                                 PLOTS.9680
      common /lwdpdt/  dlwv,             ! details line width values             PLOTS.9681
     *                 ddpv              ! details dash pattern values           PLOTS.9682
      common /parinf/  nprt,             ! number of partitions                  PLOTS.9683
     *                 iprts,            ! integer partitions                    PLOTS.9684
     *                 rprts,            ! real partitions                       PLOTS.9685
     *                 ints              ! are the partitions integers ?         PLOTS.9686
      common /parcol/  pcolor            ! colors for each partition             PLOTS.9687
      common /lwdppr/  plwv,             ! partition line width values           PLOTS.9688
     *                 pdpv              ! partition dash pattern values         PLOTS.9689
      common /noplot/  noplt             ! don't draw anything ?                 PLOTS.9690
                                                                                 PLOTS.9691
C****************************  Subroutine Begin  *****************************C  PLOTS.9692
                                                                                 PLOTS.9693
C  If no picture will be made don't bother parsing the table                     PLOTS.9694
                                                                                 PLOTS.9695
      if (noplt) goto 110                                                        PLOTS.9696
                                                                                 PLOTS.9697
C  Only read the table if the prior tables indicated that we should do so        PLOTS.9698
C  Those indications are :                                                       PLOTS.9699
C    (1) There was no line width given before (DLWV(x) < 0)                      PLOTS.9700
C    (2) There was no dash pattern given before (DDPV(x) = 0)                    PLOTS.9701
C    (3) The coloring method includes user specified partitions                  PLOTS.9702
C        (CMETH = 2,3,4,5)                                                       PLOTS.9703
                                                                                 PLOTS.9704
      if (((cmeth .ge. 2) .and. (cmeth .le. 5)) .or.                             PLOTS.9705
     *    (dlwv(1) .lt. 0.0) .or. (ddpv(1) .eq. 0)) then                         PLOTS.9706
                                                                                 PLOTS.9707
C  The table should be there, since we are here, try to read in the first line   PLOTS.9708
                                                                                 PLOTS.9709
        call tbllok (unum,'CON PARTIT',errsev,found,whline,'CONDRV')             PLOTS.9710
                                                                                 PLOTS.9711
C  If the table was found, parse it                                              PLOTS.9712
                                                                                 PLOTS.9713
        if (found) then                                                          PLOTS.9714
                                                                                 PLOTS.9715
C  Initialize all parsing tools and place keepers                                PLOTS.9716
                                                                                 PLOTS.9717
          i        = 1                                                           PLOTS.9718
          p(1:23)  = 'Reading Partition Table'                                   PLOTS.9719
          p(24:60) = ', Too Few Entries On Line            '                     PLOTS.9720
          q(1:23)  = p(1:23)                                                     PLOTS.9721
          q(24:60) = ', Entry Is Bizarre                   '                     PLOTS.9722
          error    = .false.                                                     PLOTS.9723
          nprt     = 0                                                           PLOTS.9724
          done     = .false.                                                     PLOTS.9725
                                                                                 PLOTS.9726
C  Get to the first entry in the table                                           PLOTS.9727
                                                                                 PLOTS.9728
          call search (whline,i,error)                                           PLOTS.9729
          if (error) then                                                        PLOTS.9730
            found = .false.                                                      PLOTS.9731
            done  = .true.                                                       PLOTS.9732
          end if                                                                 PLOTS.9733
                                                                                 PLOTS.9734
C  The partition specification should always be there                            PLOTS.9735
C  If CMETH = 3,5 then the specifications will be integers                       PLOTS.9736
C  If CMETH = 2,4 then the specifications will be reals                          PLOTS.9737
C  If CMETH is not in either of those groups assume the partitions are           PLOTS.9738
C    reals                                                                       PLOTS.9739
                                                                                 PLOTS.9740
          if ((cmeth .eq. 3) .or. (cmeth .eq. 5)) then                           PLOTS.9741
            ints = .true.                                                        PLOTS.9742
          else                                                                   PLOTS.9743
            ints = .false.                                                       PLOTS.9744
          end if                                                                 PLOTS.9745
                                                                                 PLOTS.9746
C  This is the begining of the loop that is iterated once per line of the        PLOTS.9747
C  table                                                                         PLOTS.9748
                                                                                 PLOTS.9749
10        nprt = nprt + 1                                                        PLOTS.9750
                                                                                 PLOTS.9751
          if ((ints) .and. (.not. error)) then                                   PLOTS.9752
                                                                                 PLOTS.9753
C  An M,m in the minimum column means that that partition starts with the        PLOTS.9754
C  first level in the plot                                                       PLOTS.9755
                                                                                 PLOTS.9756
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9757
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9758
              iprts(nprt,1) = imin                                               PLOTS.9759
            else if ((whline(i+1:i+1) .ne. ' ') .and.                            PLOTS.9760
     *               (whline(i+1:i+1) .ne. '|')) then                            PLOTS.9761
              read (whline(i:i+1),20,err=40) iprts(nprt,1)                       PLOTS.9762
            else                                                                 PLOTS.9763
              read (whline(i:i),30,err=40) iprts(nprt,1)                         PLOTS.9764
            end if                                                               PLOTS.9765
            goto 45                                                              PLOTS.9766
                                                                                 PLOTS.9767
C  If there is an error in reading the value, inform the user here               PLOTS.9768
                                                                                 PLOTS.9769
40          ermes(1:30)  = 'Partition Minimum Boundary Inp'                      PLOTS.9770
            ermes(31:60) = 'ut Conversion                 '                      PLOTS.9771
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.9772
            found = .false.                                                      PLOTS.9773
            done  = .true.                                                       PLOTS.9774
            error = .true.                                                       PLOTS.9775
                                                                                 PLOTS.9776
C  Goto maximum column                                                           PLOTS.9777
                                                                                 PLOTS.9778
45          if (.not. error) then                                                PLOTS.9779
              call next (whline,i,error)                                         PLOTS.9780
              if (error) then                                                    PLOTS.9781
                call errhan ('CONDRV',1,q,errsev)                                PLOTS.9782
                found = .false.                                                  PLOTS.9783
                done  = .true.                                                   PLOTS.9784
              end if                                                             PLOTS.9785
            end if                                                               PLOTS.9786
                                                                                 PLOTS.9787
            if (.not. error) then                                                PLOTS.9788
              call search (whline,i,error)                                       PLOTS.9789
              if (error) then                                                    PLOTS.9790
                call errhan ('CONDRV',1,p,errsev)                                PLOTS.9791
                found = .false.                                                  PLOTS.9792
                done  = .true.                                                   PLOTS.9793
              end if                                                             PLOTS.9794
            end if                                                               PLOTS.9795
                                                                                 PLOTS.9796
C  An M,m in the maximum column means that that partition ends with the          PLOTS.9797
C  last level in the plot                                                        PLOTS.9798
                                                                                 PLOTS.9799
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9800
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9801
              iprts(nprt,2) = imax                                               PLOTS.9802
              done = .true.                                                      PLOTS.9803
            else if ((whline(i+1:i+1) .ne. ' ') .and.                            PLOTS.9804
     *               (whline(i+1:i+1) .ne. '|')) then                            PLOTS.9805
              read (whline(i:i+1),20,err=60) iprts(nprt,2)                       PLOTS.9806
            else                                                                 PLOTS.9807
              read (whline(i:i),30,err=60) iprts(nprt,2)                         PLOTS.9808
            end if                                                               PLOTS.9809
            goto 65                                                              PLOTS.9810
                                                                                 PLOTS.9811
C  If there is an error in reading the value, inform the user here               PLOTS.9812
                                                                                 PLOTS.9813
60          ermes(1:30)  = 'Partition Maximum Boundary Inp'                      PLOTS.9814
            ermes(31:60) = 'ut Conversion                 '                      PLOTS.9815
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.9816
            found = .false.                                                      PLOTS.9817
            done  = .true.                                                       PLOTS.9818
            error = .true.                                                       PLOTS.9819
65          continue                                                             PLOTS.9820
          else if (.not. error) then                                             PLOTS.9821
                                                                                 PLOTS.9822
C  An M,m in the minimum column means that that partition starts with the        PLOTS.9823
C  smallest value in the data                                                    PLOTS.9824
                                                                                 PLOTS.9825
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9826
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9827
              rprts(nprt,1) = rmin                                               PLOTS.9828
            else                                                                 PLOTS.9829
              j = i                                                              PLOTS.9830
              call next (whline,i,error)                                         PLOTS.9831
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9832
              do 50 k = i-j+1,20                                                 PLOTS.9833
                gstrng(k:k) = ' '                                                PLOTS.9834
50            continue                                                           PLOTS.9835
              call gtreal (gstrng,rprts(nprt,1),error)                           PLOTS.9836
              if (error) then                                                    PLOTS.9837
                ermes(1:30)  = 'Partition Minimum Boundary Inp'                  PLOTS.9838
                ermes(31:60) = 'ut Conversion                 '                  PLOTS.9839
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.9840
                found = .false.                                                  PLOTS.9841
                done  = .true.                                                   PLOTS.9842
              end if                                                             PLOTS.9843
              rprts(nprt,1) = rprts(nprt,1) * scale                              PLOTS.9844
            end if                                                               PLOTS.9845
                                                                                 PLOTS.9846
C  Goto maximum column                                                           PLOTS.9847
                                                                                 PLOTS.9848
            if (.not. error) then                                                PLOTS.9849
              call next (whline,i,error)                                         PLOTS.9850
              if (error) then                                                    PLOTS.9851
                call errhan ('CONDRV',1,q,errsev)                                PLOTS.9852
                found = .false.                                                  PLOTS.9853
                done  = .true.                                                   PLOTS.9854
              end if                                                             PLOTS.9855
            end if                                                               PLOTS.9856
                                                                                 PLOTS.9857
            if (.not. error) then                                                PLOTS.9858
              call search (whline,i,error)                                       PLOTS.9859
              if (error) then                                                    PLOTS.9860
                call errhan ('CONDRV',1,p,errsev)                                PLOTS.9861
                found = .false.                                                  PLOTS.9862
                done  = .true.                                                   PLOTS.9863
              end if                                                             PLOTS.9864
            end if                                                               PLOTS.9865
                                                                                 PLOTS.9866
C  An M,m in the maximum column means that that partition ends with the          PLOTS.9867
C  largest value in the data                                                     PLOTS.9868
                                                                                 PLOTS.9869
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9870
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9871
              rprts(nprt,2) = rmax                                               PLOTS.9872
              done = .true.                                                      PLOTS.9873
            else                                                                 PLOTS.9874
              j = i                                                              PLOTS.9875
              call next (whline,i,error)                                         PLOTS.9876
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9877
              do 70 k = i-j+1,20                                                 PLOTS.9878
                gstrng(k:k) = ' '                                                PLOTS.9879
70            continue                                                           PLOTS.9880
              call gtreal (gstrng,rprts(nprt,2),error)                           PLOTS.9881
              if (error) then                                                    PLOTS.9882
                ermes(1:30)  = 'Partition Maximum Boundary Inp'                  PLOTS.9883
                ermes(31:60) = 'ut Conversion                 '                  PLOTS.9884
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.9885
                found = .false.                                                  PLOTS.9886
                done  = .true.                                                   PLOTS.9887
              end if                                                             PLOTS.9888
              rprts(nprt,2) = rprts(nprt,2) * scale                              PLOTS.9889
            end if                                                               PLOTS.9890
          end if                                                                 PLOTS.9891
                                                                                 PLOTS.9892
          if (.not. error) then                                                  PLOTS.9893
            call next (whline,i,error)                                           PLOTS.9894
            if (error) then                                                      PLOTS.9895
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.9896
              found = .false.                                                    PLOTS.9897
              done  = .true.                                                     PLOTS.9898
            end if                                                               PLOTS.9899
          end if                                                                 PLOTS.9900
                                                                                 PLOTS.9901
C  The next column in the table is for COLOR 1.  COLOR 1 is the color to use     PLOTS.9902
C  on the partition if CMETH = 2,3 and is the color to ramp FROM if CMETH = 4,5  PLOTS.9903
                                                                                 PLOTS.9904
          if ((cmeth .ge. 2) .and. (cmeth .le. 5) .and.                          PLOTS.9905
     *        (.not. error)) then                                                PLOTS.9906
            call search (whline,i,error)                                         PLOTS.9907
            if (error) then                                                      PLOTS.9908
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.9909
              found = .false.                                                    PLOTS.9910
              done  = .true.                                                     PLOTS.9911
            end if                                                               PLOTS.9912
          end if                                                                 PLOTS.9913
                                                                                 PLOTS.9914
          if ((cmeth .ge. 2) .and. (cmeth .le. 5) .and.                          PLOTS.9915
     *        (.not. error)) then                                                PLOTS.9916
            cermes(1:16) = 'Color 1 On Line '                                    PLOTS.9917
            if (nprt .le. 9) then                                                PLOTS.9918
              write (cermes(17:17),30) nprt                                      PLOTS.9919
              cermes (18:36) = ' Of The Partitions'                              PLOTS.9920
              cmln = 35                                                          PLOTS.9921
            else                                                                 PLOTS.9922
              write (cermes(17:18),20) nprt                                      PLOTS.9923
              cermes (19:36) = ' Of The Partitions'                              PLOTS.9924
              cmln = 36                                                          PLOTS.9925
            end if                                                               PLOTS.9926
            call crdrci (.true.,error,pcolor(nprt,1),0,whline,i,                 PLOTS.9927
     *                   cermes,cmln,errsev,noplt,'CONDRV')                      PLOTS.9928
            if (error) then                                                      PLOTS.9929
              found = .false.                                                    PLOTS.9930
              done  = .true.                                                     PLOTS.9931
            end if                                                               PLOTS.9932
            if (noplt) goto 110                                                  PLOTS.9933
                                                                                 PLOTS.9934
            if (.not. error) then                                                PLOTS.9935
              call next (whline,i,error)                                         PLOTS.9936
              if (error) then                                                    PLOTS.9937
                if (((cmeth .eq. 2) .or. (cmeth .eq. 3)) .and.                   PLOTS.9938
     *              (dlwv(1) .ge. 0.0) .and. (ddpv(1) .ne. 0)) then              PLOTS.9939
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.9940
                else                                                             PLOTS.9941
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.9942
                  found = .false.                                                PLOTS.9943
                  done  = .true.                                                 PLOTS.9944
                end if                                                           PLOTS.9945
              end if                                                             PLOTS.9946
            end if                                                               PLOTS.9947
          end if                                                                 PLOTS.9948
                                                                                 PLOTS.9949
C  The next column in the table is for COLOR 1.  COLOR 2 is the color to         PLOTS.9950
C  ramp TO if CMETH = 4,5                                                        PLOTS.9951
                                                                                 PLOTS.9952
          if ((cmeth .eq. 4) .or. (cmeth .eq. 5) .and.                           PLOTS.9953
     *        (.not. error)) then                                                PLOTS.9954
            call search (whline,i,error)                                         PLOTS.9955
            if (error) then                                                      PLOTS.9956
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.9957
              found = .false.                                                    PLOTS.9958
              done  = .true.                                                     PLOTS.9959
            end if                                                               PLOTS.9960
          end if                                                                 PLOTS.9961
                                                                                 PLOTS.9962
          if ((cmeth .eq. 4) .or. (cmeth .eq. 5) .and.                           PLOTS.9963
     *        (.not. error)) then                                                PLOTS.9964
            cermes(1:16) = 'Color 2 On Line '                                    PLOTS.9965
            if (nprt .le. 9) then                                                PLOTS.9966
              write (cermes(17:17),30) nprt                                      PLOTS.9967
              cermes (18:36) = ' Of The Partitions'                              PLOTS.9968
              cmln = 35                                                          PLOTS.9969
            else                                                                 PLOTS.9970
              write (cermes(17:18),20) nprt                                      PLOTS.9971
              cermes (19:36) = ' Of The Partitions'                              PLOTS.9972
              cmln = 36                                                          PLOTS.9973
            end if                                                               PLOTS.9974
            call crdrci (.true.,error,pcolor(nprt,2),1,whline,i,                 PLOTS.9975
     *                   cermes,cmln,errsev,noplt,'CONDRV')                      PLOTS.9976
            if (error) then                                                      PLOTS.9977
              found = .false.                                                    PLOTS.9978
              done  = .true.                                                     PLOTS.9979
            end if                                                               PLOTS.9980
            if (noplt) goto 110                                                  PLOTS.9981
                                                                                 PLOTS.9982
            if (.not. error) then                                                PLOTS.9983
              call next (whline,i,error)                                         PLOTS.9984
              if (error) then                                                    PLOTS.9985
                if ((dlwv(1) .ge. 0.0) .and. (ddpv(1) .ne. 0)) then              PLOTS.9986
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.9987
                else                                                             PLOTS.9988
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.9989
                  found = .false.                                                PLOTS.9990
                  done  = .true.                                                 PLOTS.9991
                end if                                                           PLOTS.9992
              end if                                                             PLOTS.9993
            end if                                                               PLOTS.9994
          end if                                                                 PLOTS.9995
                                                                                 PLOTS.9996
C  The next column in the table is for line width if it is needed                PLOTS.9997
                                                                                 PLOTS.9998
          if (dlwv(1) .lt. 0.0) then                                             PLOTS.9999
            call search (whline,i,error)                                         PLOTS.10000
            if (error) then                                                      PLOTS.10001
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.10002
              found = .false.                                                    PLOTS.10003
              done  = .true.                                                     PLOTS.10004
            end if                                                               PLOTS.10005
          end if                                                                 PLOTS.10006
                                                                                 PLOTS.10007
          if (dlwv(1) .lt. 0.0) then                                             PLOTS.10008
            if ((whline(i:i) .eq. 'D') .or.                                      PLOTS.10009
     *          (whline(i:i) .eq. 'd')) then                                     PLOTS.10010
              plwv(nprt) = 1.0                                                   PLOTS.10011
            else                                                                 PLOTS.10012
              j = i                                                              PLOTS.10013
              call next (whline,i,error)                                         PLOTS.10014
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.10015
              do 80 k = i-j+1,20                                                 PLOTS.10016
                gstrng(k:k) = ' '                                                PLOTS.10017
80            continue                                                           PLOTS.10018
              call gtreal (gstrng,plwv(nprt),error)                              PLOTS.10019
              if (error) then                                                    PLOTS.10020
                ermes(1:30)  = 'Line Width Multiplier On Line '                  PLOTS.10021
                if (nprt .le. 9) then                                            PLOTS.10022
                  write (ermes(31:31),30) nprt                                   PLOTS.10023
                  ermes(32:60) = ' Input Conversion            '                 PLOTS.10024
                else                                                             PLOTS.10025
                  write (ermes(31:32),20) nprt                                   PLOTS.10026
                  ermes(33:60) = ' Input Conversion           '                  PLOTS.10027
                end if                                                           PLOTS.10028
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.10029
                found = .false.                                                  PLOTS.10030
                done  = .true.                                                   PLOTS.10031
              end if                                                             PLOTS.10032
                                                                                 PLOTS.10033
C  Make sure the given value is within reason                                    PLOTS.10034
                                                                                 PLOTS.10035
              if (plwv(nprt) .lt. 1.0) then                                      PLOTS.10036
                ermes(1:27)  = 'Line Width Entered On Line '                     PLOTS.10037
                if (nprt .le. 9) then                                            PLOTS.10038
                  write (ermes(28:28),30) nprt                                   PLOTS.10039
                  ermes(29:60) = ' Is Too Small, 1 Used           '              PLOTS.10040
                else                                                             PLOTS.10041
                  write (ermes(28:29),20) nprt                                   PLOTS.10042
                  ermes(30:60) = ' Is Too Small, 1 Used          '               PLOTS.10043
                end if                                                           PLOTS.10044
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.10045
                plwv(nprt) = 1.0                                                 PLOTS.10046
              else if (plwv(nprt) .gt. 10.0) then                                PLOTS.10047
                ermes(1:27)  = 'Line Width Entered On Line '                     PLOTS.10048
                if (nprt .le. 9) then                                            PLOTS.10049
                  write (ermes(28:28),30) nprt                                   PLOTS.10050
                  ermes(29:60) = ' Is Too Large, 10 Used          '              PLOTS.10051
                else                                                             PLOTS.10052
                  write (ermes(28:29),20) nprt                                   PLOTS.10053
                  ermes(30:60) = ' Is Too Large, 10 Used         '               PLOTS.10054
                end if                                                           PLOTS.10055
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.10056
                plwv(nprt) = 10.0                                                PLOTS.10057
              end if                                                             PLOTS.10058
            end if                                                               PLOTS.10059
                                                                                 PLOTS.10060
            if (.not. error) then                                                PLOTS.10061
              call next (whline,i,error)                                         PLOTS.10062
              if (error) then                                                    PLOTS.10063
                if (ddpv(1) .ne. 0) then                                         PLOTS.10064
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.10065
                else                                                             PLOTS.10066
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.10067
                  found = .false.                                                PLOTS.10068
                  done  = .true.                                                 PLOTS.10069
                end if                                                           PLOTS.10070
              end if                                                             PLOTS.10071
            end if                                                               PLOTS.10072
          end if                                                                 PLOTS.10073
                                                                                 PLOTS.10074
C  The next column in the table is for dash pattern if it is needed              PLOTS.10075
                                                                                 PLOTS.10076
          if (ddpv(1) .eq. 0) then                                               PLOTS.10077
            call search (whline,i,error)                                         PLOTS.10078
            if (error) then                                                      PLOTS.10079
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.10080
              found = .false.                                                    PLOTS.10081
              done  = .true.                                                     PLOTS.10082
            end if                                                               PLOTS.10083
          end if                                                                 PLOTS.10084
                                                                                 PLOTS.10085
          if (ddpv(1) .eq. 0) then                                               PLOTS.10086
            if ((whline(i:i) .eq. 'D') .or.                                      PLOTS.10087
     *          (whline(i:i) .eq. 'd') .or.                                      PLOTS.10088
     *          (whline(i:i+1) .eq. 'SO') .or.                                   PLOTS.10089
     *          (whline(i:i+1) .eq. 'So') .or.                                   PLOTS.10090
     *          (whline(i:i+1) .eq. 'so') .or.                                   PLOTS.10091
     *          (whline(i:i+1) .eq. 'sO')) then                                  PLOTS.10092
              pdpv(nprt) = -1                                                    PLOTS.10093
            else if ((whline(i:i) .eq. 'L') .or.                                 PLOTS.10094
     *               (whline(i:i) .eq. 'l')) then                                PLOTS.10095
              pdpv(nprt) = 255                                                   PLOTS.10096
            else if ((whline(i:i) .eq. 'M') .or.                                 PLOTS.10097
     *               (whline(i:i) .eq. 'm')) then                                PLOTS.10098
              pdpv(nprt) = 3855                                                  PLOTS.10099
            else if ((whline(i:i+1) .eq. 'SM') .or.                              PLOTS.10100
     *               (whline(i:i+1) .eq. 'Sm') .or.                              PLOTS.10101
     *               (whline(i:i+1) .eq. 'sM') .or.                              PLOTS.10102
     *               (whline(i:i+1) .eq. 'sm')) then                             PLOTS.10103
              pdpv(nprt) = 13107                                                 PLOTS.10104
            else if ((whline(i:i) .eq. 'T') .or.                                 PLOTS.10105
     *               (whline(i:i) .eq. 't')) then                                PLOTS.10106
              pdpv(nprt) = 21845                                                 PLOTS.10107
            else                                                                 PLOTS.10108
              ermes(1:27)  = 'Dash Pattern Given On Line '                       PLOTS.10109
              if (nprt .le. 9) then                                              PLOTS.10110
                write (ermes(28:28),30) nprt                                     PLOTS.10111
                ermes(29:60) = ' Is Unknown, SO Used            '                PLOTS.10112
              else                                                               PLOTS.10113
                write (ermes(28:29),20) nprt                                     PLOTS.10114
                ermes(30:60) = ' Is Unknown, SO Used           '                 PLOTS.10115
              end if                                                             PLOTS.10116
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10117
              pdpv(nprt) = -1                                                    PLOTS.10118
            end if                                                               PLOTS.10119
                                                                                 PLOTS.10120
            if (.not. error) then                                                PLOTS.10121
              call next (whline,i,error)                                         PLOTS.10122
              if (error) then                                                    PLOTS.10123
                call errhan ('CONDRV',0,q,errsev)                                PLOTS.10124
              end if                                                             PLOTS.10125
            end if                                                               PLOTS.10126
          end if                                                                 PLOTS.10127
                                                                                 PLOTS.10128
C  Check for extra entries on the line                                           PLOTS.10129
                                                                                 PLOTS.10130
          if (.not. error) then                                                  PLOTS.10131
            call search (whline,i,error)                                         PLOTS.10132
            if (.not. error) then                                                PLOTS.10133
              ermes(1:25)  = 'Too Many Entries On Line '                         PLOTS.10134
              if (nprt .le. 9) then                                              PLOTS.10135
                write (ermes(26:26),30) nprt                                     PLOTS.10136
                ermes(27:60) = ' Of The Partitions Table          '              PLOTS.10137
              else                                                               PLOTS.10138
                write (ermes(26:27),20) nprt                                     PLOTS.10139
                ermes(28:60) = ' Of The Partitions Table         '               PLOTS.10140
              end if                                                             PLOTS.10141
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10142
            end if                                                               PLOTS.10143
          end if                                                                 PLOTS.10144
                                                                                 PLOTS.10145
C  Go back and read the next line if that was not the last one                   PLOTS.10146
                                                                                 PLOTS.10147
          if (.not. done) then                                                   PLOTS.10148
            read (unum,90,err=100,end=100) whline(1:80)                          PLOTS.10149
            i = 1                                                                PLOTS.10150
            call search (whline,i,error)                                         PLOTS.10151
            if (error) then                                                      PLOTS.10152
              ermes(1:30)  = 'More Lines Expected In Partiti'                    PLOTS.10153
              ermes(31:60) = 'ons Table                     '                    PLOTS.10154
            else                                                                 PLOTS.10155
              goto 10                                                            PLOTS.10156
            end if                                                               PLOTS.10157
            goto 105                                                             PLOTS.10158
100         ermes(1:30)  = 'Could Not All Of The Partition'                      PLOTS.10159
            ermes(31:60) = 's Table                       '                      PLOTS.10160
105         call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10161
            found = .false.                                                      PLOTS.10162
          else                                                                   PLOTS.10163
C           if (found) print *, 'CONDRV - Contour Partitions Set Up'             06NOV00.150
          end if                                                                 PLOTS.10165
        end if                                                                   PLOTS.10166
                                                                                 PLOTS.10167
C  If the table was not found, deliver an error message                          PLOTS.10168
                                                                                 PLOTS.10169
        if (.not. found) then                                                    PLOTS.10170
          if (nprt .le. 1) then                                                  PLOTS.10171
            ermes(1:30)  = 'Partition Table Expected But N'                      PLOTS.10172
            ermes(31:60) = 'ot Found                      '                      PLOTS.10173
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10174
            nprt        = 1                                                      PLOTS.10175
            iprts(1,1)  = imin                                                   PLOTS.10176
            iprts(1,2)  = imax                                                   PLOTS.10177
            ints        = .true.                                                 PLOTS.10178
            pcolor(1,1) = 0                                                      PLOTS.10179
            pcolor(1,1) = 1                                                      PLOTS.10180
            plwv(1)    = 1.0                                                     PLOTS.10181
            pdpv(1)    = -1                                                      PLOTS.10182
          else                                                                   PLOTS.10183
                                                                                 PLOTS.10184
C  If the table was found bu not complete give a different error message         PLOTS.10185
                                                                                 PLOTS.10186
            ermes(1:30)  = 'Partition Table Not Complete  '                      PLOTS.10187
            ermes(31:60) = '                              '                      PLOTS.10188
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10189
            if (ints) then                                                       PLOTS.10190
              iprts(nprt,1)  = iprts(nprt-1,2)                                   PLOTS.10191
              iprts(nprt,2)  = imax                                              PLOTS.10192
            else                                                                 PLOTS.10193
              rprts(nprt,1)  = rprts(nprt-1,2)                                   PLOTS.10194
              rprts(nprt,2)  = rmax                                              PLOTS.10195
            end if                                                               PLOTS.10196
            pcolor(nprt,1)   = 0                                                 PLOTS.10197
            pcolor(nprt,1)   = 1                                                 PLOTS.10198
            plwv(nprt)      = 1.0                                                PLOTS.10199
            pdpv(nprt)      = -1                                                 PLOTS.10200
          end if                                                                 PLOTS.10201
        end if                                                                   PLOTS.10202
      end if                                                                     PLOTS.10203
                                                                                 PLOTS.10204
C*****************************  Subroutine End  *****************************C   PLOTS.10205
                                                                                 PLOTS.10206
C  Format statements begin ...                                                   PLOTS.10207
                                                                                 PLOTS.10208
20    format (I2)                                                                PLOTS.10209
30    format (I1)                                                                PLOTS.10210
90    format (A80)                                                               PLOTS.10211
                                                                                 PLOTS.10212
C  Format statements end.                                                        PLOTS.10213
                                                                                 PLOTS.10214
110   return                                                                     PLOTS.10215
      end                                                                        PLOTS.10216
      subroutine crdttl (whline,errsev,tputl,ofilb)                              PLOTS.10217
                                                                                 PLOTS.10218
C*****************************************************************************C  PLOTS.10219
C  crdttl   - This is for CONDRV                                              C  PLOTS.10220
C  Section  - Tables                                                          C  PLOTS.10221
C  Purpose  - To parse out  the title  information  given in the  CON DETAILS C  PLOTS.10222
C             table.                                                          C  PLOTS.10223
C                                                                             C  PLOTS.10224
C  On entry - WHLINE contains the line from the table giving all of the title C  PLOTS.10225
C             information.  ERRSEV indicates what severity of error will halt C  PLOTS.10226
C             execution.   TPUTL is 0  if label bar information is to be read C  PLOTS.10227
C             and is 1 if title information is to be read.                    C  PLOTS.10228
C                                                                             C  PLOTS.10229
C  On exit  - All variables in the common block TITDET have been properly set C  PLOTS.10230
C             up.  OFILB is true if the title box will be filled and is false C  PLOTS.10231
C             otherwise.                                                      C  PLOTS.10232
C                                                                             C  PLOTS.10233
C  Assume   - Nothing                                                         C  PLOTS.10234
C                                                                             C  PLOTS.10235
C  Notes    - Routine             Location of Definition                      C  PLOTS.10236
C             ----------------------------------------------------------------C  PLOTS.10237
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.10238
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.10239
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.10240
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.10241
C             ----------------------------------------------------------------C  PLOTS.10242
C                                                                             C  PLOTS.10243
C  Author   - Jeremy Asbill       Date - June 29, 1990      for the MM4 club  C  PLOTS.10244
C*****************************************************************************C  PLOTS.10245
                                                                                 PLOTS.10246
C  Character variables                                                           PLOTS.10247
                                                                                 PLOTS.10248
      character*80     whline            ! a whole line from the table     (in)  PLOTS.10249
      character*60     ermes,            ! error mess. string, general  (local)  PLOTS.10250
     *                 p,                ! error message string, SEARCH (local)  PLOTS.10251
     *                 q                 ! error message string, NEXT   (local)  PLOTS.10252
      character*20     gstrng            ! temporary, skimpy string     (local)  PLOTS.10253
                                                                                 PLOTS.10254
C  Integer variables                                                             PLOTS.10255
                                                                                 PLOTS.10256
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.10257
     *                 tputl             ! label bar/title indicator       (in)  PLOTS.10258
      integer          tsize             ! for common block TITDET               PLOTS.10259
      integer          tqual(2)          ! for common block TIQDET               PLOTS.10260
      integer          i,j,k             ! loop counters/place keepers  (local)  PLOTS.10261
                                                                                 PLOTS.10262
C  Logical variables                                                             PLOTS.10263
                                                                                 PLOTS.10264
      logical          ofilb             ! out version of TFILB           (out)  PLOTS.10265
      logical          tputb,            ! for common block TITDET               PLOTS.10266
     *                 tputp,            ! for common block TITDET               PLOTS.10267
     *                 tfilb             ! for common block TITDET               PLOTS.10268
      logical          error             ! has an error occured ?       (local)  PLOTS.10269
                                                                                 PLOTS.10270
C  Real variables                                                                PLOTS.10271
                                                                                 PLOTS.10272
      real             tprlw             ! for common block TITDET               PLOTS.10273
                                                                                 PLOTS.10274
C  Common blocks                                                                 PLOTS.10275
                                                                                 PLOTS.10276
      common /titdet/  tputb,            ! put a box around the title ?          PLOTS.10277
     *                 tputp,            ! draw the perimeter of the box ?       PLOTS.10278
     *                 tfilb,            ! fill the box ?                        PLOTS.10279
     *                 tprlw,            ! title box perim. line width           PLOTS.10280
     *                 tsize             ! title character size                  PLOTS.10281
      common /tiqdet/  tqual             ! title character quality               PLOTS.10282
                                                                                 PLOTS.10283
C****************************  subroutine begin  *****************************C  PLOTS.10284
                                                                                 PLOTS.10285
C  Set up I to use as a counter                                                  PLOTS.10286
                                                                                 PLOTS.10287
      i = 1                                                                      PLOTS.10288
                                                                                 PLOTS.10289
C  Initialize the error flag                                                     PLOTS.10290
                                                                                 PLOTS.10291
      error = .false.                                                            PLOTS.10292
                                                                                 PLOTS.10293
C  Set up SEARCH and NEXT error strings                                          PLOTS.10294
                                                                                 PLOTS.10295
      p(1:23)  = 'Reading Line Label Info'                                       PLOTS.10296
      p(24:60) = 'rmation Line, Too Few Entries On Line'                         PLOTS.10297
      q(1:23)  = p(1:23)                                                         PLOTS.10298
      q(24:60) = 'rmation Line, Entry Is Bizarre       '                         PLOTS.10299
                                                                                 PLOTS.10300
C  Whline being passed in as blanks is the same as assigning the defaults        PLOTS.10301
                                                                                 PLOTS.10302
      call search (whline,i,error)                                               PLOTS.10303
      if ((error) .and. (tputl .eq. 1)) then                                     PLOTS.10304
        tputb    = .false.                                                       PLOTS.10305
        tputp    = .false.                                                       PLOTS.10306
        tfilb    = .false.                                                       PLOTS.10307
        tsize    = 10                                                            PLOTS.10308
        tqual(1) = 1                                                             PLOTS.10309
        tqual(2) = 1                                                             PLOTS.10310
      else if ((error) .and. (tputl .eq. 0)) then                                PLOTS.10311
        tputb    = .true.                                                        PLOTS.10312
        tsize    = 0                                                             PLOTS.10313
        tqual(1) = 0                                                             PLOTS.10314
        tqual(2) = 0                                                             PLOTS.10315
      end if                                                                     PLOTS.10316
                                                                                 PLOTS.10317
C  The title box flag should be read in whether this is a label bar              PLOTS.10318
C  or a regular title                                                            PLOTS.10319
C  Y & Label Bar => make label bar one big bar                                   PLOTS.10320
C  N & Label Bar => break label bar into individual blocks                       PLOTS.10321
C  Y & Title     => put a box around the title                                   PLOTS.10322
C  N & Title     => title should not be boxed                                    PLOTS.10323
C  anything else => give a warning message                                       PLOTS.10324
                                                                                 PLOTS.10325
      if (.not. error) then                                                      PLOTS.10326
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.10327
          tputb = .true.                                                         PLOTS.10328
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.10329
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.10330
          tputb = .false.                                                        PLOTS.10331
        else if (tputl .eq. 1) then                                              PLOTS.10332
          ermes(1:30)  = 'Title Box Flag Is Inconclusive'                        PLOTS.10333
          ermes(31:60) = ', N Assumed                   '                        PLOTS.10334
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10335
          tputb = .false.                                                        PLOTS.10336
        else if (tputl .eq. 0) then                                              PLOTS.10337
          ermes(1:30)  = 'Label Bar Box Flag Is Inconclu'                        PLOTS.10338
          ermes(31:60) = 'sive, Y Assumed               '                        PLOTS.10339
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10340
          tputb = .true.                                                         PLOTS.10341
        end if                                                                   PLOTS.10342
        call next (whline,i,error)                                               PLOTS.10343
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10344
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10345
          tsize    = 10                                                          PLOTS.10346
          tqual(1) = 1                                                           PLOTS.10347
          tqual(2) = 1                                                           PLOTS.10348
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10349
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10350
          tsize    = 0                                                           PLOTS.10351
          tqual(1) = 0                                                           PLOTS.10352
          tqual(2) = 0                                                           PLOTS.10353
        end if                                                                   PLOTS.10354
      end if                                                                     PLOTS.10355
                                                                                 PLOTS.10356
C  If TPUTL indicates a title and a box was requested,  parse out the box        PLOTS.10357
C  perimeter flag and the box fill flag                                          PLOTS.10358
                                                                                 PLOTS.10359
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10360
        call search (whline,i,error)                                             PLOTS.10361
        if (error) then                                                          PLOTS.10362
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10363
          tputp    = .false.                                                     PLOTS.10364
          tsize    = 10                                                          PLOTS.10365
          tqual(1) = 1                                                           PLOTS.10366
          tqual(2) = 1                                                           PLOTS.10367
        end if                                                                   PLOTS.10368
      end if                                                                     PLOTS.10369
                                                                                 PLOTS.10370
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10371
        if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then             PLOTS.10372
          tputp = .false.                                                        PLOTS.10373
        else if ((whline(i:i) .eq. 'Y') .or.                                     PLOTS.10374
     *           (whline(i:i) .eq. 'y')) then                                    PLOTS.10375
          tputp = .true.                                                         PLOTS.10376
        else                                                                     PLOTS.10377
          ermes(1:30)  = 'Title Box Perimeter Flag Is In'                        PLOTS.10378
          ermes(31:60) = 'conclusive, N Assumed         '                        PLOTS.10379
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10380
          tputp = .false.                                                        PLOTS.10381
        end if                                                                   PLOTS.10382
        call next (whline,i,error)                                               PLOTS.10383
        if (error) then                                                          PLOTS.10384
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10385
          tsize    = 10                                                          PLOTS.10386
          tqual(1) = 1                                                           PLOTS.10387
          tqual(2) = 1                                                           PLOTS.10388
        end if                                                                   PLOTS.10389
      else                                                                       PLOTS.10390
        tputp = .false.                                                          PLOTS.10391
      end if                                                                     PLOTS.10392
                                                                                 PLOTS.10393
C  If TPUTL indicates a title and a box was requested, parse to see if the       PLOTS.10394
C  box should be filled                                                          PLOTS.10395
C  Y             => Fill the box                                                 PLOTS.10396
C  N             => Leave the box hollow                                         PLOTS.10397
C  anything else => give a warning message                                       PLOTS.10398
                                                                                 PLOTS.10399
                                                                                 PLOTS.10400
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10401
        call search (whline,i,error)                                             PLOTS.10402
        if (error) then                                                          PLOTS.10403
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10404
          tfilb    = .false.                                                     PLOTS.10405
          tsize    = 10                                                          PLOTS.10406
          tqual(1) = 1                                                           PLOTS.10407
          tqual(2) = 1                                                           PLOTS.10408
        end if                                                                   PLOTS.10409
      end if                                                                     PLOTS.10410
                                                                                 PLOTS.10411
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10412
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.10413
          tfilb = .true.                                                         PLOTS.10414
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.10415
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.10416
          tfilb = .false.                                                        PLOTS.10417
        else                                                                     PLOTS.10418
          ermes(1:30)  = 'Title Box Fill Flag Is Inconcl'                        PLOTS.10419
          ermes(31:60) = 'usive, N Assumed              '                        PLOTS.10420
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10421
          tfilb = .false.                                                        PLOTS.10422
        end if                                                                   PLOTS.10423
        call next (whline,i,error)                                               PLOTS.10424
        if (error) then                                                          PLOTS.10425
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10426
          tsize    = 10                                                          PLOTS.10427
          tqual(1) = 1                                                           PLOTS.10428
          tqual(2) = 1                                                           PLOTS.10429
        end if                                                                   PLOTS.10430
      else                                                                       PLOTS.10431
        tfilb = .false.                                                          PLOTS.10432
      end if                                                                     PLOTS.10433
                                                                                 PLOTS.10434
C  Parse the perimeter line with for a label bar or a title                      PLOTS.10435
C  D,d    => use normal line width                                               PLOTS.10436
                                                                                 PLOTS.10437
      if ((((tputb) .and. (tputp)) .or. (tputl .eq. 0)) .and.                    PLOTS.10438
     *    (.not. error)) then                                                    PLOTS.10439
        call search (whline,i,error)                                             PLOTS.10440
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10441
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10442
          tsize    = 10                                                          PLOTS.10443
          tqual(1) = 1                                                           PLOTS.10444
          tqual(2) = 1                                                           PLOTS.10445
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10446
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10447
          tsize    = 0                                                           PLOTS.10448
          tqual(1) = 0                                                           PLOTS.10449
          tqual(2) = 0                                                           PLOTS.10450
        end if                                                                   PLOTS.10451
      end if                                                                     PLOTS.10452
                                                                                 PLOTS.10453
      if ((((tputb) .and. (tputp)) .or. (tputl .eq. 0)) .and.                    PLOTS.10454
     *    (.not. error)) then                                                    PLOTS.10455
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.10456
          tprlw = 1.0                                                            PLOTS.10457
          call next (whline,i,error)                                             PLOTS.10458
        else                                                                     PLOTS.10459
          j = i                                                                  PLOTS.10460
          call next (whline,i,error)                                             PLOTS.10461
          if (.not. error) then                                                  PLOTS.10462
            gstrng(1:i-j) = whline(j:i-1)                                        PLOTS.10463
            do 10 k = i-j+1,20                                                   PLOTS.10464
              gstrng(k:k) = ' '                                                  PLOTS.10465
10          continue                                                             PLOTS.10466
            call gtreal (gstrng,tprlw,error)                                     PLOTS.10467
            if ((error) .and. (tputl .eq. 1)) then                               PLOTS.10468
              ermes(1:30)  = 'Could Not Read Title Box Perim'                    PLOTS.10469
              ermes(31:60) = 'eter Width, 1.0 Used          '                    PLOTS.10470
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10471
              tprlw = 1.0                                                        PLOTS.10472
              error = .false.                                                    PLOTS.10473
            else if ((error) .and. (tputl .eq. 0)) then                          PLOTS.10474
              ermes(1:30)  = 'Could Not Read Label Bar Perim'                    PLOTS.10475
              ermes(31:60) = 'eter Width, 1.0 Used          '                    PLOTS.10476
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10477
              tprlw = 1.0                                                        PLOTS.10478
              error = .false.                                                    PLOTS.10479
            end if                                                               PLOTS.10480
          end if                                                                 PLOTS.10481
        end if                                                                   PLOTS.10482
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10483
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10484
          tsize    = 10                                                          PLOTS.10485
          tqual(1) = 1                                                           PLOTS.10486
          tqual(2) = 1                                                           PLOTS.10487
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10488
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10489
          tsize    = 0                                                           PLOTS.10490
          tqual(1) = 0                                                           PLOTS.10491
          tqual(2) = 0                                                           PLOTS.10492
        end if                                                                   PLOTS.10493
      else                                                                       PLOTS.10494
        tprlw  = 0.0                                                             PLOTS.10495
      end if                                                                     PLOTS.10496
                                                                                 PLOTS.10497
C  If TPUTL implies a title, then parse character quality                        PLOTS.10498
C  0 in space 1 => complex character set should be used                          PLOTS.10499
C  1 in space 1 => duplex character set should be used                           PLOTS.10500
C  0 in space 2 => high quality characters                                       PLOTS.10501
C  1 in space 2 => medium quality                                                PLOTS.10502
C  1 in space 3 => low quality                                                   PLOTS.10503
                                                                                 PLOTS.10504
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10505
        call search (whline,i,error)                                             PLOTS.10506
        if (error) then                                                          PLOTS.10507
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10508
          tsize    = 10                                                          PLOTS.10509
          tqual(1) = 1                                                           PLOTS.10510
          tqual(2) = 1                                                           PLOTS.10511
        end if                                                                   PLOTS.10512
      end if                                                                     PLOTS.10513
                                                                                 PLOTS.10514
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10515
        tqual(2) = -1                                                            PLOTS.10516
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.10517
          tqual(1) = 1                                                           PLOTS.10518
          tqual(2) = 1                                                           PLOTS.10519
        else if (whline(i:i) .eq. '0') then                                      PLOTS.10520
          tqual(1) = 0                                                           PLOTS.10521
        else if (whline(i:i) .eq. '1') then                                      PLOTS.10522
          tqual(1) = 1                                                           PLOTS.10523
        else                                                                     PLOTS.10524
          ermes(1:30)  = 'Title Text Type Is Invalid, 1 '                        PLOTS.10525
          ermes(31:60) = 'Used (Duplex)                 '                        PLOTS.10526
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10527
          tqual(1) = 1                                                           PLOTS.10528
        end if                                                                   PLOTS.10529
        if (tqual(2) .eq. -1) then                                               PLOTS.10530
          i = i + 1                                                              PLOTS.10531
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.10532
            tqual(2) = 1                                                         PLOTS.10533
          else if (whline(i:i) .eq. '0') then                                    PLOTS.10534
            tqual(2) = 0                                                         PLOTS.10535
          else if (whline(i:i) .eq. '1') then                                    PLOTS.10536
            tqual(2) = 1                                                         PLOTS.10537
          else if (whline(i:i) .eq. '2') then                                    PLOTS.10538
            tqual(2) = 2                                                         PLOTS.10539
          else                                                                   PLOTS.10540
            ermes(1:30)  = 'Title Text Quality Is Invalid,'                      PLOTS.10541
            ermes(31:60) = ' 1 Used (Medium)              '                      PLOTS.10542
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.10543
            tqual(2) = 1                                                         PLOTS.10544
          end if                                                                 PLOTS.10545
        end if                                                                   PLOTS.10546
        call next (whline,i,error)                                               PLOTS.10547
        if (error) then                                                          PLOTS.10548
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10549
          tsize    = 10                                                          PLOTS.10550
        end if                                                                   PLOTS.10551
      end if                                                                     PLOTS.10552
                                                                                 PLOTS.10553
C  If TPUTL implies a title, parse out the title character size                  PLOTS.10554
C  This should be specified in plotter coordinates                               PLOTS.10555
                                                                                 PLOTS.10556
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10557
        call search (whline,i,error)                                             PLOTS.10558
        if (error) then                                                          PLOTS.10559
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10560
          tsize = 10                                                             PLOTS.10561
        end if                                                                   PLOTS.10562
      end if                                                                     PLOTS.10563
                                                                                 PLOTS.10564
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10565
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.10566
          tsize = 10                                                             PLOTS.10567
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.10568
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.10569
          read  (whline(i:i+1),20,err=40) tsize                                  PLOTS.10570
        else                                                                     PLOTS.10571
          read (whline(i:i),30,err=40) tsize                                     PLOTS.10572
        end if                                                                   PLOTS.10573
        goto 45                                                                  PLOTS.10574
                                                                                 PLOTS.10575
C  Inform the user of the error if here                                          PLOTS.10576
                                                                                 PLOTS.10577
40      ermes(1:30)  = 'Title Character Size Input Con'                          PLOTS.10578
        ermes(31:60) = 'version                       '                          PLOTS.10579
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.10580
        tsize = 10                                                               PLOTS.10581
        error = .true.                                                           PLOTS.10582
                                                                                 PLOTS.10583
45      if (.not. error) then                                                    PLOTS.10584
          call next (whline,i,error)                                             PLOTS.10585
          if (error)                                                             PLOTS.10586
     *      call errhan ('CONDRV',0,q,errsev)                                    PLOTS.10587
        end if                                                                   PLOTS.10588
      end if                                                                     PLOTS.10589
                                                                                 PLOTS.10590
C  Check for extra entries on the end of the line                                PLOTS.10591
                                                                                 PLOTS.10592
      if (.not. error) then                                                      PLOTS.10593
        call search (whline,i,error)                                             PLOTS.10594
        if ((.not. error) .and. (tputl .eq. 1)) then                             PLOTS.10595
          ermes(1:30)  = 'Reading Title Information Line'                        PLOTS.10596
          ermes(31:60) = ', Too Many Entries On Line    '                        PLOTS.10597
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10598
        else if ((.not. error) .and. (tputl .eq. 0)) then                        PLOTS.10599
          ermes(1:30)  = 'Reading Label Bar Information '                        PLOTS.10600
          ermes(31:60) = 'Line, Too Many Entries On Line'                        PLOTS.10601
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10602
        end if                                                                   PLOTS.10603
      end if                                                                     PLOTS.10604
                                                                                 PLOTS.10605
C  Check for value errors                                                        PLOTS.10606
C  TPRLW must be between 1.0 and 10.0 inclusive                                  PLOTS.10607
                                                                                 PLOTS.10608
      if ((tprlw .lt. 1.0) .and. ((tputl .eq. 0) .or. (tputp))) then             PLOTS.10609
        if (tputl .eq. 1) then                                                   PLOTS.10610
          ermes(1:30)  = 'Title Box Perimeter Line Width'                        PLOTS.10611
          ermes(1:30)  = 'Is Too Small, 1 Used          '                        PLOTS.10612
        else                                                                     PLOTS.10613
          ermes(1:30)  = 'Label Bar Perimeter Line Width'                        PLOTS.10614
          ermes(1:30)  = 'Is Too Small, 1 Used          '                        PLOTS.10615
        end if                                                                   PLOTS.10616
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10617
        tprlw = 1.0                                                              PLOTS.10618
      end if                                                                     PLOTS.10619
      if ((tprlw .gt. 10.0) .and. ((tputl .eq. 0) .or. (tputp))) then            PLOTS.10620
        if (tputl .eq. 1) then                                                   PLOTS.10621
          ermes(1:30)  = 'Title Box Perimeter Line Width'                        PLOTS.10622
          ermes(1:30)  = 'Is Too Large, 10 Used         '                        PLOTS.10623
        else                                                                     PLOTS.10624
          ermes(1:30)  = 'Label Bar Perimeter Line Width'                        PLOTS.10625
          ermes(1:30)  = 'Is Too Large, 10 Used         '                        PLOTS.10626
        end if                                                                   PLOTS.10627
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10628
        tprlw = 10.0                                                             PLOTS.10629
      end if                                                                     PLOTS.10630
                                                                                 PLOTS.10631
C  TSIZE must be between 1 and 25 inclusive                                      PLOTS.10632
                                                                                 PLOTS.10633
      if ((tsize .lt. 1) .and. (tputl .eq. 1)) then                              PLOTS.10634
        ermes(1:30)  = 'Title Character Size Is Too Sm'                          PLOTS.10635
        ermes(1:30)  = 'all, 1 Used                   '                          PLOTS.10636
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10637
        tsize = 1                                                                PLOTS.10638
      end if                                                                     PLOTS.10639
      if ((tsize .gt. 25) .and. (tputl .eq. 1)) then                             PLOTS.10640
        ermes(1:30)  = 'Title Character Size Is Too La'                          PLOTS.10641
        ermes(1:30)  = 'rge, 1 Used                   '                          PLOTS.10642
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10643
        tsize = 25                                                               PLOTS.10644
      end if                                                                     PLOTS.10645
                                                                                 PLOTS.10646
C  Assign output variables                                                       PLOTS.10647
                                                                                 PLOTS.10648
      ofilb = tfilb                                                              PLOTS.10649
                                                                                 PLOTS.10650
C*****************************  subroutine end  ******************************C  PLOTS.10651
                                                                                 PLOTS.10652
C  Format statements begin ...                                                   PLOTS.10653
                                                                                 PLOTS.10654
20    format (I2)                                                                PLOTS.10655
30    format (I1)                                                                PLOTS.10656
                                                                                 PLOTS.10657
C  Format statements end.                                                        PLOTS.10658
                                                                                 PLOTS.10659
      return                                                                     PLOTS.10660
      end                                                                        PLOTS.10661
                                                                                 PLOTS.10662
      subroutine csetcl (tsize,title,pnum,scale,errsev)                          PLOTS.10663
                                                                                 PLOTS.10664
C*****************************************************************************C  PLOTS.10665
C  csetcl   - This is a CONDRV routine                                        C  PLOTS.10666
C  Section  - Design                                                          C  PLOTS.10667
C  Purpose  - To set up the color of contour levels,  style and placement  of C  PLOTS.10668
C             line labels, style of high/low labels and the color of the pre- C  PLOTS.10669
C             viously mentioned labels.  To set the color of the perimeter if C  PLOTS.10670
C             one was requested.                                              C  PLOTS.10671
C                                                                             C  PLOTS.10672
C  On entry - TITLE is the title string to draw with the plot.   TSIZE is the C  PLOTS.10673
C             number of characters in TITLE.   PNUM is the number of overlays C  PLOTS.10674
C             done previous to this one plus two.  SCALE is the scale  factor C  PLOTS.10675
C             to  be used when labeling.   ERRSEV indicates at what  severity C  PLOTS.10676
C             or an error, execution should halt.                             C  PLOTS.10677
C                                                                             C  PLOTS.10678
C  On exit  - Color and label information for the entire plot has been set.   C  PLOTS.10679
C                                                                             C  PLOTS.10680
C  Assume   - GKS is open.  CONPACK has been initialized.                     C  PLOTS.10681
C                                                                             C  PLOTS.10682
C  Notes    - Routine             Location of Definition                      C  PLOTS.10683
C             ----------------------------------------------------------------C  PLOTS.10684
C             SETTTL              CONDRV utility                              C  PLOTS.10685
C             CPSETI              CONPACK utility*                            C  PLOTS.10686
C             SETHLO              CONDRV utility                              C  PLOTS.10687
C             CPSETC              CONPACK utility                             C  PLOTS.10688
C             CRAMPS              CONDRV utility                              C  PLOTS.10689
C             SETCOL              CONDRV utility                              C  PLOTS.10690
C             SETLAB              CONDRV utility                              C  PLOTS.10691
C             MKLBAR              CONDRV utility                              C  PLOTS.10692
C             ----------------------------------------------------------------C  PLOTS.10693
C             * NCAR Graphics Routine                                         C  PLOTS.10694
C                                                                             C  PLOTS.10695
C  Author   - Jeremy Asbill     Date - August 10, 1990      for the MM4 club  C  PLOTS.10696
C*****************************************************************************C  PLOTS.10697
                                                                                 PLOTS.10698
C  Character variables                                                           PLOTS.10699
                                                                                 PLOTS.10700
      character*120    title             ! title string                    (in)  PLOTS.10701
                                                                                 PLOTS.10702
C  Integer variables                                                             PLOTS.10703
                                                                                 PLOTS.10704
      integer          tsize,            ! # of chars in TITLE             (in)  PLOTS.10705
     *                 pnum,             ! indicates what overlay this is  (in)  PLOTS.10706
     *                 errsev            ! error severity comparitor       (in)  PLOTS.10707
      integer          lputl,            ! for common block QLBDET               PLOTS.10708
     *                 tputl             ! for common block QLBDET               PLOTS.10709
      integer          pcol              ! for common block PERCOL               PLOTS.10710
                                                                                 PLOTS.10711
C  Logical variables                                                             PLOTS.10712
                                                                                 PLOTS.10713
      logical          hputl             ! for common block QLBDET               PLOTS.10714
      logical          prput             ! for common block PERDET               PLOTS.10715
      logical          noplt             ! for common block NOPLOT               PLOTS.10716
                                                                                 PLOTS.10717
C  Real variables                                                                PLOTS.10718
                                                                                 PLOTS.10719
      real             scale             ! scale factor to use             (in)  PLOTS.10720
                                                                                 PLOTS.10721
C  Common blocks                                                                 PLOTS.10722
                                                                                 PLOTS.10723
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.10724
     *                 lputl,            ! draw in line labels                   PLOTS.10725
     *                 tputl             ! draw in the title                     PLOTS.10726
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.10727
      common /percol/  pcol              ! color index for perimeter             PLOTS.10728
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.10729
                                                                                 PLOTS.10730
C****************************  Subroutine Begin  *****************************C  PLOTS.10731
                                                                                 PLOTS.10732
C  CONPACK internal parameters used in this routine are :                        PLOTS.10733
C  LBC - Label Box fill Color index                                              PLOTS.10734
C  HLT - High/Low label Text                                                     PLOTS.10735
C  LLP - Line Label Positioning flag                                             PLOTS.10736
C  ILT - Information Label Text                                                  PLOTS.10737
                                                                                 PLOTS.10738
C  Set up the title information, if no plot will be drawn or a title is          PLOTS.10739
C  requested                                                                     PLOTS.10740
                                                                                 PLOTS.10741
      if ((noplt) .or. ((tputl .eq. 1) .and. (tsize .ne. 0))) then               PLOTS.10742
        call setttl (tsize,title,pnum,scale)                                     PLOTS.10743
      else                                                                       PLOTS.10744
        call cpsetc ('ILT',' ')                                                  PLOTS.10745
      end if                                                                     PLOTS.10746
                                                                                 PLOTS.10747
C  If there should be no plot drawn, don't bother with setting up the colors     PLOTS.10748
                                                                                 PLOTS.10749
      if (.not. noplt) then                                                      PLOTS.10750
                                                                                 PLOTS.10751
C  Tell CONPACK to use the current fill color index to fill all types            PLOTS.10752
C  of label boxes                                                                PLOTS.10753
                                                                                 PLOTS.10754
        call cpseti ('LBC',-1)                                                   PLOTS.10755
                                                                                 PLOTS.10756
C  Set up the high/low information, if a plot will be drawn and they             PLOTS.10757
C  are requested                                                                 PLOTS.10758
                                                                                 PLOTS.10759
        if (hputl) then                                                          PLOTS.10760
          call sethlo                                                            PLOTS.10761
        else                                                                     PLOTS.10762
          call cpsetc ('HLT',' '' ')                                             PLOTS.10763
        end if                                                                   PLOTS.10764
                                                                                 PLOTS.10765
C  Set up the color ramps requested by the user                                  PLOTS.10766
                                                                                 PLOTS.10767
        call cramps                                                              PLOTS.10768
                                                                                 PLOTS.10769
C  Set up the colors as they relate to individual lines                          PLOTS.10770
                                                                                 PLOTS.10771
        call setcol                                                              PLOTS.10772
                                                                                 PLOTS.10773
C  Set the color of the perimeter if a perimeter was requested                   PLOTS.10774
                                                                                 PLOTS.10775
        if (prput) call gacolr (pcol,pcol,pcol,pcol)                             PLOTS.10776
                                                                                 PLOTS.10777
C  Set up all the line label information, if line labels were requested          PLOTS.10778
                                                                                 PLOTS.10779
        if (lputl .ge. 0) then                                                   PLOTS.10780
          call setlab (lputl,errsev)                                             PLOTS.10781
        else                                                                     PLOTS.10782
          call cpseti ('LLP',0)                                                  PLOTS.10783
        end if                                                                   PLOTS.10784
      end if                                                                     PLOTS.10785
                                                                                 PLOTS.10786
C  If a label bar was requested, make it here                                    PLOTS.10787
                                                                                 PLOTS.10788
      if ((.not. noplt) .and. (tputl .eq. 0)) call mklbar                        PLOTS.10789
                                                                                 PLOTS.10790
C*****************************  Subroutine End  ******************************C  PLOTS.10791
                                                                                 PLOTS.10792
      return                                                                     PLOTS.10793
      end                                                                        PLOTS.10794
      subroutine csetwn (xstr,ystr,xend,yend,doset)                              PLOTS.10795
                                                                                 PLOTS.10796
C*****************************************************************************C  PLOTS.10797
C  csetwn   - This is a CONDRV routine                                        C  PLOTS.10798
C  Section  - Design                                                          C  PLOTS.10799
C  Purpose  - To set up the proper viewport in which to draw the contours.    C  PLOTS.10800
C                                                                             C  PLOTS.10801
C  On entry - XSTR, YSTR are the first point in the grid to be plotted.  XEND C  PLOTS.10802
C             and YEND are the last point in the  grid to be plotted.   These C  PLOTS.10803
C             two points should correspond to the lower left and  upper right C  PLOTS.10804
C             respecitvely, of a map on which the picture is overlayed. DOSET C  PLOTS.10805
C             is 1 if CONDRV should make a standard  set call and is 0 if  it C  PLOTS.10806
C             should use the users last call to the SPPS routine SET.  If DO- C  PLOTS.10807
C             set is negative CONDRV  makes the set call  considering a cross C  PLOTS.10808
C             point grid.                                                     C  PLOTS.10809
C                                                                             C  PLOTS.10810
C  On exit  - The proper window has been set.                                 C  PLOTS.10811
C                                                                             C  PLOTS.10812
C  Assume   - GKS is open                                                     C  PLOTS.10813
C                                                                             C  PLOTS.10814
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.10815
C             ----------------------------------------------------------------C  PLOTS.10816
C             CPSETR              CONPACK utility*                            C  PLOTS.10817
C             CPSETI              CONPACK utility*                            C  PLOTS.10818
C             GETSET              SPPS*                                       C  PLOTS.10819
C             SET                 SPPS*                                       C  PLOTS.10820
C             ----------------------------------------------------------------C  PLOTS.10821
C             * NCAR Graphics routine                                         C  PLOTS.10822
C                                                                             C  PLOTS.10823
C  Author   - Jeremy Asbill      Date - August 9, 1990      for the MM4 club  C  PLOTS.10824
C*****************************************************************************C  PLOTS.10825
                                                                                 PLOTS.10826
C  Integer variables                                                             PLOTS.10827
                                                                                 PLOTS.10828
      integer          xstr,             ! x coord. of first grid point    (in)  PLOTS.10829
     *                 ystr,             ! y coord. of first grid point    (in)  PLOTS.10830
     *                 xend,             ! x coord. of last grid point     (in)  PLOTS.10831
     *                 yend,             ! y coord. of last grid point     (in)  PLOTS.10832
     *                 doset             ! set call type indicator         (in)  PLOTS.10833
      integer          lltp              ! junk filler                  (local)  PLOTS.10834
                                                                                 PLOTS.10835
C  Real variables                                                                PLOTS.10836
                                                                                 PLOTS.10837
      real             temp,             ! temporary test variable      (local)  PLOTS.10838
     *                 dumy,             ! dummy test variable          (local)  PLOTS.10839
     *                 right,            ! right side of view port      (local)  PLOTS.10840
     *                 left,             ! left side of view port       (local)  PLOTS.10841
     *                 top,              ! top of view port             (local)  PLOTS.10842
     *                 bottom,           ! bottom of view port          (local)  PLOTS.10843
     *                 test,             ! calculation variable         (local)  PLOTS.10844
     *                 junk,             ! calculation variable         (local)  PLOTS.10845
     *                 ultp,urtp,        ! junk filler                  (local)  PLOTS.10846
     *                 ubtp,uttp         ! junk filler                  (local)  PLOTS.10847
                                                                                 PLOTS.10848
C****************************  Subroutine Begin  *****************************C  PLOTS.10849
                                                                                 PLOTS.10850
C  CONPACK internal parameters used in this routine are:                         PLOTS.10851
C  VPB - View Port Bottom                                                        PLOTS.10852
C  VPT - View Port Top                                                           PLOTS.10853
C  VPL - View Port Left                                                          PLOTS.10854
C  VPR - View Port Right                                                         PLOTS.10855
C  SET - do-SET-call flag                                                        PLOTS.10856
                                                                                 PLOTS.10857
C  Set up variables to test on                                                   PLOTS.10858
C  TEMP will represent the maps width                                            PLOTS.10859
C  DUMY will represent the maps height                                           PLOTS.10860
                                                                                 PLOTS.10861
      if (doset .lt. 0) then                                                     PLOTS.10862
        temp = float(yend - ystr + 2)                                            PLOTS.10863
        dumy = float(xend - xstr + 2) * 0.9                                      PLOTS.10864
      else                                                                       PLOTS.10865
        temp = float(yend - ystr + 1)                                            PLOTS.10866
        dumy = float(xend - xstr + 1) * 0.9                                      PLOTS.