!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


      subroutine sfcdrag(u0,v0,rf0,uu,vv,t13,t23,u,v)
      implicit none

      include 'input.incl'
      include 'constants.incl'
      include 'timestat.incl'

      real, dimension(ib:ie,jb:je,kb:ke) :: rf0
      real, dimension(ib:ie,jb:je,kb:ke) :: uu,vv,t13,t23
      real, dimension(ib:ie+1,jb:je,kb:ke) :: u0,u
      real, dimension(ib:ie,jb:je+1,kb:ke) :: v0,v

      integer i,j
      real usfc,vsfc,wspd

! Note:  The default formulation comes from Rotunno and Emanuel, 1987, p. 547)
! Note:  for pertflx=1, the base-state is not included in calculation of 
!        wind speed

!-----------------------------------------------------------------------

      IF(pertflx.eq.1)THEN

!$omp parallel do default(shared)   &
!$omp private(i,j)
        do j=0,nj+1
        do i=0,ni+1
          uu(i,j,1) = u(i,j,1)-u0(i,j,1)
          vv(i,j,1) = v(i,j,1)-v0(i,j,1)
        enddo
        enddo

      ELSE

!$omp parallel do default(shared)   &
!$omp private(i,j)
        do j=0,nj+1
        do i=0,ni+1
          uu(i,j,1) = u(i,j,1)
          vv(i,j,1) = v(i,j,1)
        enddo
        enddo

      ENDIF

!-----------------------------------------------------------------------

!$omp parallel do default(shared)   &
!$omp private(i,j,usfc,vsfc,wspd)
      do j=1,nj
      do i=1,ni+1
        usfc=uu(i,j,1)
        vsfc=0.25*( ( vv(i  ,j,1)+vv(i  ,j+1,1) )   &
                   +( vv(i-1,j,1)+vv(i-1,j+1,1) ) )
        wspd=sqrt(usfc**2+vsfc**2)
        t13(i,j,1)=(1.1e-3+(4.0e-5*wspd))*usfc*wspd
!!!        t13(i,j,1)=0.01*usfc*wspd
      enddo
      enddo

!-----------------------------------------------------------------------

!$omp parallel do default(shared)   &
!$omp private(i,j,usfc,vsfc,wspd)
      do j=1,nj+1
      do i=1,ni
        usfc=0.25*( ( uu(i,j  ,1)+uu(i+1,j  ,1) )   &
                   +( uu(i,j-1,1)+uu(i+1,j-1,1) ) )
        vsfc=vv(i,j,1)
        wspd=sqrt(usfc**2+vsfc**2)
        t23(i,j,1)=(1.1e-3+(4.0e-5*wspd))*vsfc*wspd
!!!        t23(i,j,1)=0.01*vsfc*wspd
      enddo
      enddo

!-----------------------------------------------------------------------

      if(timestats.ge.1) time_sfcphys=time_sfcphys+mytime()

      return
      end


!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


      subroutine sfcflux(xh,ruh,rvh,zh,pi0,thv0,th0,u0,v0,thflux,qvflux,   &
                         rho,uu,vv,u,v,ppi,tha,qva,qsfc)
      implicit none

      include 'input.incl'
      include 'constants.incl'
      include 'timestat.incl'

      real, dimension(ib:ie) :: xh,ruh
      real, dimension(jb:je) :: rvh
      real, dimension(ib:ie,jb:je,kb:ke) :: zh,pi0,thv0,th0
      real, dimension(ib:ie,jb:je) :: thflux,qvflux
      real, dimension(ib:ie,jb:je,kb:ke) :: uu,vv
      real, dimension(ib:ie+1,jb:je,kb:ke) :: u0,u
      real, dimension(ib:ie,jb:je+1,kb:ke) :: v0,v
      real, dimension(ib:ie,jb:je,kb:ke) :: rho,ppi,tha
      real, dimension(ibm:iem,jbm:jem,kbm:kem) :: qva
      real*8 :: qsfc

      integer i,j
      real pisfc,usfc,vsfc,qvsat

      real :: pisurf,rhosfc,tem
      real rslf
      real, dimension(ni,nj) :: wspd,coef
      real*8 :: bud(nj)

! Note:  The default formulation comes from Rotunno and Emanuel, 1987, p. 547)
! Note:  for pertflx=1, the base-state is not included in calculation of 
!        wind speed

!-----------------------------------------------------------------------

      IF(pertflx.eq.1)THEN

!$omp parallel do default(shared)   &
!$omp private(i,j)
        do j=1,nj+1
        do i=1,ni+1
          uu(i,j,1) = u(i,j,1)-u0(i,j,1)
          vv(i,j,1) = v(i,j,1)-v0(i,j,1)
        enddo
        enddo

      ELSE

!$omp parallel do default(shared)   &
!$omp private(i,j)
        do j=1,nj+1
        do i=1,ni+1
          uu(i,j,1) = u(i,j,1)
          vv(i,j,1) = v(i,j,1)
        enddo
        enddo

      ENDIF

      pisurf = (psurf*rp00)**rovcp

!$omp parallel do default(shared)   &
!$omp private(i,j,usfc,vsfc)
      do j=1,nj
      do i=1,ni
        usfc=0.5*( uu(i,j,1)+uu(i+1,j,1) )
        vsfc=0.5*( vv(i,j,1)+vv(i,j+1,1) )
        wspd(i,j)=sqrt(usfc**2+vsfc**2)
        coef(i,j)=(1.1e-3+(4.0e-5*wspd(i,j)))
      enddo
      enddo

!$omp parallel do default(shared)   &
!$omp private(i,j,pisfc)
      do j=1,nj
      do i=1,ni
        pisfc = pisurf + ppi(i,j,1)
        thflux(i,j)=coef(i,j)*wspd(i,j)*(tsurf/pisfc-th0(i,j,1)-tha(i,j,1))
      enddo
      enddo

    IF(imoist.eq.1)THEN

!$omp parallel do default(shared)   &
!$omp private(i,j,pisfc,qvsat)
      do j=1,nj
      do i=1,ni
        pisfc = pisurf + ppi(i,j,1)
        qvsat=rslf(p00*(pisfc**cpdrd),tsurf)
        qvflux(i,j)=coef(i,j)*wspd(i,j)*(qvsat-qva(i,j,1))
      enddo
      enddo

!$omp parallel do default(shared)  &
!$omp private(j)
      do j=1,nj
        bud(j)=0.0d0
      enddo

!$omp parallel do default(shared)  &
!$omp private(i,j,rhosfc)
      do j=1,nj
      do i=1,ni
        rhosfc=rho(i,j,1)-zh(i,j,1)*(rho(i,j,2)-rho(i,j,1))   &
                                   /( zh(i,j,2)- zh(i,j,1))
        if(axisymm.eq.1) rhosfc=rhosfc*xh(i)
        bud(j)=bud(j)+qvflux(i,j)*ruh(i)*rvh(j)*rhosfc
      enddo
      enddo

      tem = dtl*dx*dy

      do j=1,nj
        qsfc=qsfc+bud(j)*tem
      enddo

    ENDIF

!-----------------------------------------------------------------------

      if(timestats.ge.1) time_sfcphys=time_sfcphys+mytime()

      return
      end


