!
!##################################################################
!##################################################################
!######                                                      ######
!######                BLOCK DATA RADDATA                    ######
!######                                                      ######
!######                     Developed by                     ######
!######                                                      ######
!######    Goddard Cumulus Ensemble Modeling Group, NASA     ######
!######                                                      ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################
!
  BLOCK DATA raddata
!
!-----------------------------------------------------------------------
!
!  PURPOSE:
!
!  Initialize pre-calculated look-up tables used in radiation
!  computation.
!
!-----------------------------------------------------------------------
!
!  AUTHOR: Yuhe Liu
!  03/15/1996
!
!  Combined all files of look-up tables used in radiation computation
!  into this file. Different tables are identified by different
!  COMMON block names.
!
!-----------------------------------------------------------------------
!
  IMPLICIT NONE

  INTEGER :: i, j, ip, iw
!
!-----------------------------------------------------------------------
!
!  The following DATA statements originally came from file
!  "h2o.tran3", which define pre-computed tables used for h2o (bands
!  1, 2, and 7 only) transmittance calculations.
!
!-----------------------------------------------------------------------
!
!  integer nx,no,nc,nh,nt
!  parameter (nx=26,no=21,nc=24,nh=31,nt=7)
!
!-----------------------------------------------------------------------
!
! h2o.tran3

  REAL :: h11(26,31,7),h12(26,31,7),h13(26,31,7)
  REAL :: h21(26,31,7),h22(26,31,7),h23(26,31,7)
  REAL :: h71(26,31,7),h72(26,31,7),h73(26,31,7)

  COMMON /radtab001/ h11,h12,h13,h21,h22,h23,h71,h72,h73

  DATA ((h11(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      0.6160E-04,  0.9815E-04,  0.1474E-03,  0.2092E-03,  0.2823E-03,   &
      0.3662E-03,  0.4615E-03,  0.5710E-03,  0.6998E-03,  0.8554E-03,   &
      0.1049E-02,  0.1295E-02,  0.1612E-02,  0.2021E-02,  0.2548E-02,   &
      0.3230E-02,  0.4123E-02,  0.5306E-02,  0.6887E-02,  0.9021E-02,   &
      0.1193E-01,  0.1590E-01,  0.2135E-01,  0.2885E-01,  0.3914E-01,   &
      0.5317E-01,  0.7223E-01,  0.9800E-01,  0.1326E+00,  0.1783E+00,   &
      0.2373E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      -0.2021E-06, -0.3628E-06, -0.5891E-06, -0.8735E-06, -0.1204E-05,  &
      -0.1579E-05, -0.2002E-05, -0.2494E-05, -0.3093E-05, -0.3852E-05,  &
      -0.4835E-05, -0.6082E-05, -0.7591E-05, -0.9332E-05, -0.1128E-04,  &
      -0.1347E-04, -0.1596E-04, -0.1890E-04, -0.2241E-04, -0.2672E-04,  &
      -0.3208E-04, -0.3884E-04, -0.4747E-04, -0.5854E-04, -0.7272E-04,  &
      -0.9092E-04, -0.1146E-03, -0.1458E-03, -0.1877E-03, -0.2435E-03,  &
      -0.3159E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      0.5907E-09,  0.8541E-09,  0.1095E-08,  0.1272E-08,  0.1297E-08,   &
      0.1105E-08,  0.6788E-09, -0.5585E-10, -0.1147E-08, -0.2746E-08,   &
      -0.5001E-08, -0.7715E-08, -0.1037E-07, -0.1227E-07, -0.1287E-07,  &
      -0.1175E-07, -0.8517E-08, -0.2920E-08,  0.4786E-08,  0.1407E-07,  &
      0.2476E-07,  0.3781E-07,  0.5633E-07,  0.8578E-07,  0.1322E-06,   &
      0.2013E-06,  0.3006E-06,  0.4409E-06,  0.6343E-06,  0.8896E-06,   &
      0.1216E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      0.6166E-04,  0.9828E-04,  0.1477E-03,  0.2097E-03,  0.2833E-03,   &
      0.3680E-03,  0.4648E-03,  0.5768E-03,  0.7101E-03,  0.8736E-03,   &
      0.1080E-02,  0.1348E-02,  0.1700E-02,  0.2162E-02,  0.2767E-02,   &
      0.3563E-02,  0.4621E-02,  0.6039E-02,  0.7953E-02,  0.1056E-01,   &
      0.1412E-01,  0.1901E-01,  0.2574E-01,  0.3498E-01,  0.4763E-01,   &
      0.6484E-01,  0.8815E-01,  0.1196E+00,  0.1614E+00,  0.2157E+00,   &
      0.2844E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      -0.2017E-06, -0.3620E-06, -0.5878E-06, -0.8713E-06, -0.1201E-05,  &
      -0.1572E-05, -0.1991E-05, -0.2476E-05, -0.3063E-05, -0.3808E-05,  &
      -0.4776E-05, -0.6011E-05, -0.7516E-05, -0.9272E-05, -0.1127E-04,  &
      -0.1355E-04, -0.1620E-04, -0.1936E-04, -0.2321E-04, -0.2797E-04,  &
      -0.3399E-04, -0.4171E-04, -0.5172E-04, -0.6471E-04, -0.8150E-04,  &
      -0.1034E-03, -0.1321E-03, -0.1705E-03, -0.2217E-03, -0.2889E-03,  &
      -0.3726E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      0.5894E-09,  0.8519E-09,  0.1092E-08,  0.1267E-08,  0.1289E-08,   &
      0.1093E-08,  0.6601E-09, -0.7831E-10, -0.1167E-08, -0.2732E-08,   &
      -0.4864E-08, -0.7334E-08, -0.9581E-08, -0.1097E-07, -0.1094E-07,  &
      -0.8999E-08, -0.4669E-08,  0.2391E-08,  0.1215E-07,  0.2424E-07,  &
      0.3877E-07,  0.5711E-07,  0.8295E-07,  0.1218E-06,  0.1793E-06,   &
      0.2621E-06,  0.3812E-06,  0.5508E-06,  0.7824E-06,  0.1085E-05,   &
      0.1462E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      0.6175E-04,  0.9849E-04,  0.1481E-03,  0.2106E-03,  0.2849E-03,   &
      0.3708E-03,  0.4698E-03,  0.5857E-03,  0.7257E-03,  0.9006E-03,   &
      0.1126E-02,  0.1425E-02,  0.1823E-02,  0.2353E-02,  0.3059E-02,   &
      0.4002E-02,  0.5270E-02,  0.6984E-02,  0.9316E-02,  0.1251E-01,   &
      0.1689E-01,  0.2292E-01,  0.3123E-01,  0.4262E-01,  0.5814E-01,   &
      0.7921E-01,  0.1077E+00,  0.1458E+00,  0.1957E+00,  0.2595E+00,   &
      0.3380E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      -0.2011E-06, -0.3609E-06, -0.5859E-06, -0.8680E-06, -0.1195E-05,  &
      -0.1563E-05, -0.1975E-05, -0.2450E-05, -0.3024E-05, -0.3755E-05,  &
      -0.4711E-05, -0.5941E-05, -0.7455E-05, -0.9248E-05, -0.1132E-04,  &
      -0.1373E-04, -0.1659E-04, -0.2004E-04, -0.2431E-04, -0.2966E-04,  &
      -0.3653E-04, -0.4549E-04, -0.5724E-04, -0.7259E-04, -0.9265E-04,  &
      -0.1191E-03, -0.1543E-03, -0.2013E-03, -0.2633E-03, -0.3421E-03,  &
      -0.4350E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      0.5872E-09,  0.8484E-09,  0.1087E-08,  0.1259E-08,  0.1279E-08,   &
      0.1077E-08,  0.6413E-09, -0.9334E-10, -0.1161E-08, -0.2644E-08,   &
      -0.4588E-08, -0.6709E-08, -0.8474E-08, -0.9263E-08, -0.8489E-08,  &
      -0.5553E-08,  0.1203E-09,  0.9035E-08,  0.2135E-07,  0.3689E-07,  &
      0.5610E-07,  0.8097E-07,  0.1155E-06,  0.1649E-06,  0.2350E-06,   &
      0.3353E-06,  0.4806E-06,  0.6858E-06,  0.9617E-06,  0.1315E-05,   &
      0.1741E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      0.6189E-04,  0.9882E-04,  0.1488E-03,  0.2119E-03,  0.2873E-03,   &
      0.3752E-03,  0.4776E-03,  0.5993E-03,  0.7490E-03,  0.9403E-03,   &
      0.1192E-02,  0.1531E-02,  0.1990E-02,  0.2610E-02,  0.3446E-02,   &
      0.4576E-02,  0.6109E-02,  0.8196E-02,  0.1105E-01,  0.1498E-01,   &
      0.2039E-01,  0.2785E-01,  0.3809E-01,  0.5209E-01,  0.7112E-01,   &
      0.9688E-01,  0.1315E+00,  0.1773E+00,  0.2363E+00,  0.3100E+00,   &
      0.3976E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      -0.2001E-06, -0.3592E-06, -0.5829E-06, -0.8631E-06, -0.1187E-05,  &
      -0.1549E-05, -0.1953E-05, -0.2415E-05, -0.2975E-05, -0.3694E-05,  &
      -0.4645E-05, -0.5882E-05, -0.7425E-05, -0.9279E-05, -0.1147E-04,  &
      -0.1406E-04, -0.1717E-04, -0.2100E-04, -0.2580E-04, -0.3191E-04,  &
      -0.3989E-04, -0.5042E-04, -0.6432E-04, -0.8261E-04, -0.1068E-03,  &
      -0.1389E-03, -0.1820E-03, -0.2391E-03, -0.3127E-03, -0.4021E-03,  &
      -0.5002E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      0.5838E-09,  0.8426E-09,  0.1081E-08,  0.1249E-08,  0.1267E-08,   &
      0.1062E-08,  0.6313E-09, -0.8241E-10, -0.1094E-08, -0.2436E-08,   &
      -0.4100E-08, -0.5786E-08, -0.6992E-08, -0.7083E-08, -0.5405E-08,  &
      -0.1259E-08,  0.6099E-08,  0.1732E-07,  0.3276E-07,  0.5256E-07,  &
      0.7756E-07,  0.1103E-06,  0.1547E-06,  0.2159E-06,  0.3016E-06,   &
      0.4251E-06,  0.6033E-06,  0.8499E-06,  0.1175E-05,  0.1579E-05,   &
      0.2044E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      0.6211E-04,  0.9932E-04,  0.1499E-03,  0.2140E-03,  0.2911E-03,   &
      0.3820E-03,  0.4895E-03,  0.6196E-03,  0.7834E-03,  0.9973E-03,   &
      0.1285E-02,  0.1678E-02,  0.2216E-02,  0.2951E-02,  0.3953E-02,   &
      0.5319E-02,  0.7186E-02,  0.9743E-02,  0.1326E-01,  0.1811E-01,   &
      0.2479E-01,  0.3400E-01,  0.4662E-01,  0.6379E-01,  0.8708E-01,   &
      0.1185E+00,  0.1603E+00,  0.2147E+00,  0.2835E+00,  0.3667E+00,   &
      0.4620E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      -0.1987E-06, -0.3565E-06, -0.5784E-06, -0.8557E-06, -0.1175E-05,  &
      -0.1530E-05, -0.1923E-05, -0.2372E-05, -0.2919E-05, -0.3631E-05,  &
      -0.4587E-05, -0.5848E-05, -0.7442E-05, -0.9391E-05, -0.1173E-04,  &
      -0.1455E-04, -0.1801E-04, -0.2232E-04, -0.2779E-04, -0.3489E-04,  &
      -0.4428E-04, -0.5678E-04, -0.7333E-04, -0.9530E-04, -0.1246E-03,  &
      -0.1639E-03, -0.2164E-03, -0.2848E-03, -0.3697E-03, -0.4665E-03,  &
      -0.5646E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      0.5785E-09,  0.8338E-09,  0.1071E-08,  0.1239E-08,  0.1256E-08,   &
      0.1057E-08,  0.6480E-09, -0.1793E-10, -0.9278E-09, -0.2051E-08,   &
      -0.3337E-08, -0.4514E-08, -0.5067E-08, -0.4328E-08, -0.1545E-08,  &
      0.4100E-08,  0.1354E-07,  0.2762E-07,  0.4690E-07,  0.7190E-07,   &
      0.1040E-06,  0.1459E-06,  0.2014E-06,  0.2764E-06,  0.3824E-06,   &
      0.5359E-06,  0.7532E-06,  0.1047E-05,  0.1424E-05,  0.1873E-05,   &
      0.2356E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      0.6246E-04,  0.1001E-03,  0.1515E-03,  0.2171E-03,  0.2970E-03,   &
      0.3924E-03,  0.5072E-03,  0.6495E-03,  0.8329E-03,  0.1078E-02,   &
      0.1413E-02,  0.1876E-02,  0.2516E-02,  0.3399E-02,  0.4612E-02,   &
      0.6276E-02,  0.8562E-02,  0.1171E-01,  0.1605E-01,  0.2205E-01,   &
      0.3032E-01,  0.4167E-01,  0.5717E-01,  0.7821E-01,  0.1067E+00,   &
      0.1447E+00,  0.1948E+00,  0.2586E+00,  0.3372E+00,  0.4290E+00,   &
      0.5295E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      -0.1964E-06, -0.3526E-06, -0.5717E-06, -0.8451E-06, -0.1158E-05,  &
      -0.1504E-05, -0.1886E-05, -0.2322E-05, -0.2861E-05, -0.3576E-05,  &
      -0.4552E-05, -0.5856E-05, -0.7529E-05, -0.9609E-05, -0.1216E-04,  &
      -0.1528E-04, -0.1916E-04, -0.2408E-04, -0.3043E-04, -0.3880E-04,  &
      -0.4997E-04, -0.6488E-04, -0.8474E-04, -0.1113E-03, -0.1471E-03,  &
      -0.1950E-03, -0.2583E-03, -0.3384E-03, -0.4326E-03, -0.5319E-03,  &
      -0.6244E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      0.5713E-09,  0.8263E-09,  0.1060E-08,  0.1226E-08,  0.1252E-08,   &
      0.1076E-08,  0.7149E-09,  0.1379E-09, -0.6043E-09, -0.1417E-08,   &
      -0.2241E-08, -0.2830E-08, -0.2627E-08, -0.8950E-09,  0.3231E-08,  &
      0.1075E-07,  0.2278E-07,  0.4037E-07,  0.6439E-07,  0.9576E-07,   &
      0.1363E-06,  0.1886E-06,  0.2567E-06,  0.3494E-06,  0.4821E-06,   &
      0.6719E-06,  0.9343E-06,  0.1280E-05,  0.1705E-05,  0.2184E-05,   &
      0.2651E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      0.6299E-04,  0.1013E-03,  0.1541E-03,  0.2220E-03,  0.3058E-03,   &
      0.4078E-03,  0.5334E-03,  0.6928E-03,  0.9032E-03,  0.1190E-02,   &
      0.1587E-02,  0.2140E-02,  0.2912E-02,  0.3982E-02,  0.5460E-02,   &
      0.7500E-02,  0.1031E-01,  0.1420E-01,  0.1958E-01,  0.2700E-01,   &
      0.3721E-01,  0.5118E-01,  0.7019E-01,  0.9593E-01,  0.1305E+00,   &
      0.1763E+00,  0.2354E+00,  0.3091E+00,  0.3969E+00,  0.4952E+00,   &
      0.5978E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      -0.1932E-06, -0.3467E-06, -0.5623E-06, -0.8306E-06, -0.1136E-05,  &
      -0.1472E-05, -0.1842E-05, -0.2269E-05, -0.2807E-05, -0.3539E-05,  &
      -0.4553E-05, -0.5925E-05, -0.7710E-05, -0.9968E-05, -0.1278E-04,  &
      -0.1629E-04, -0.2073E-04, -0.2644E-04, -0.3392E-04, -0.4390E-04,  &
      -0.5727E-04, -0.7516E-04, -0.9916E-04, -0.1315E-03, -0.1752E-03,  &
      -0.2333E-03, -0.3082E-03, -0.3988E-03, -0.4982E-03, -0.5947E-03,  &
      -0.6764E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      0.5612E-09,  0.8116E-09,  0.1048E-08,  0.1222E-08,  0.1270E-08,   &
      0.1141E-08,  0.8732E-09,  0.4336E-09, -0.6548E-10, -0.4774E-09,   &
      -0.7556E-09, -0.6577E-09,  0.4377E-09,  0.3359E-08,  0.9159E-08,  &
      0.1901E-07,  0.3422E-07,  0.5616E-07,  0.8598E-07,  0.1251E-06,   &
      0.1752E-06,  0.2392E-06,  0.3228E-06,  0.4389E-06,  0.6049E-06,   &
      0.8370E-06,  0.1150E-05,  0.1547E-05,  0.2012E-05,  0.2493E-05,   &
      0.2913E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      0.6378E-04,  0.1032E-03,  0.1579E-03,  0.2293E-03,  0.3190E-03,   &
      0.4305E-03,  0.5712E-03,  0.7541E-03,  0.1001E-02,  0.1342E-02,   &
      0.1819E-02,  0.2489E-02,  0.3427E-02,  0.4734E-02,  0.6548E-02,   &
      0.9059E-02,  0.1254E-01,  0.1735E-01,  0.2401E-01,  0.3318E-01,   &
      0.4577E-01,  0.6292E-01,  0.8620E-01,  0.1176E+00,  0.1594E+00,   &
      0.2139E+00,  0.2827E+00,  0.3660E+00,  0.4614E+00,  0.5634E+00,   &
      0.6649E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      -0.1885E-06, -0.3385E-06, -0.5493E-06, -0.8114E-06, -0.1109E-05,  &
      -0.1436E-05, -0.1796E-05, -0.2219E-05, -0.2770E-05, -0.3535E-05,  &
      -0.4609E-05, -0.6077E-05, -0.8016E-05, -0.1051E-04, -0.1367E-04,  &
      -0.1768E-04, -0.2283E-04, -0.2955E-04, -0.3849E-04, -0.5046E-04,  &
      -0.6653E-04, -0.8813E-04, -0.1173E-03, -0.1569E-03, -0.2100E-03,  &
      -0.2794E-03, -0.3656E-03, -0.4637E-03, -0.5629E-03, -0.6512E-03,  &
      -0.7167E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      0.5477E-09,  0.8000E-09,  0.1039E-08,  0.1234E-08,  0.1331E-08,   &
      0.1295E-08,  0.1160E-08,  0.9178E-09,  0.7535E-09,  0.8301E-09,   &
      0.1184E-08,  0.2082E-08,  0.4253E-08,  0.8646E-08,  0.1650E-07,   &
      0.2920E-07,  0.4834E-07,  0.7564E-07,  0.1125E-06,  0.1606E-06,   &
      0.2216E-06,  0.2992E-06,  0.4031E-06,  0.5493E-06,  0.7549E-06,   &
      0.1035E-05,  0.1400E-05,  0.1843E-05,  0.2327E-05,  0.2774E-05,   &
      0.3143E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      0.6495E-04,  0.1059E-03,  0.1635E-03,  0.2400E-03,  0.3381E-03,   &
      0.4631E-03,  0.6246E-03,  0.8394E-03,  0.1134E-02,  0.1546E-02,   &
      0.2126E-02,  0.2944E-02,  0.4093E-02,  0.5699E-02,  0.7934E-02,   &
      0.1104E-01,  0.1535E-01,  0.2131E-01,  0.2956E-01,  0.4089E-01,   &
      0.5636E-01,  0.7739E-01,  0.1058E+00,  0.1439E+00,  0.1939E+00,   &
      0.2578E+00,  0.3364E+00,  0.4283E+00,  0.5290E+00,  0.6314E+00,   &
      0.7292E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      -0.1822E-06, -0.3274E-06, -0.5325E-06, -0.7881E-06, -0.1079E-05,  &
      -0.1398E-05, -0.1754E-05, -0.2184E-05, -0.2763E-05, -0.3581E-05,  &
      -0.4739E-05, -0.6341E-05, -0.8484E-05, -0.1128E-04, -0.1490E-04,  &
      -0.1955E-04, -0.2561E-04, -0.3364E-04, -0.4438E-04, -0.5881E-04,  &
      -0.7822E-04, -0.1045E-03, -0.1401E-03, -0.1884E-03, -0.2523E-03,  &
      -0.3335E-03, -0.4289E-03, -0.5296E-03, -0.6231E-03, -0.6980E-03,  &
      -0.7406E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      0.5334E-09,  0.7859E-09,  0.1043E-08,  0.1279E-08,  0.1460E-08,   &
      0.1560E-08,  0.1618E-08,  0.1657E-08,  0.1912E-08,  0.2569E-08,   &
      0.3654E-08,  0.5509E-08,  0.8964E-08,  0.1518E-07,  0.2560E-07,   &
      0.4178E-07,  0.6574E-07,  0.9958E-07,  0.1449E-06,  0.2031E-06,   &
      0.2766E-06,  0.3718E-06,  0.5022E-06,  0.6849E-06,  0.9360E-06,   &
      0.1268E-05,  0.1683E-05,  0.2157E-05,  0.2625E-05,  0.3020E-05,   &
      0.3364E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=10,10)/                               &
      0.6661E-04,  0.1098E-03,  0.1716E-03,  0.2554E-03,  0.3653E-03,   &
      0.5088E-03,  0.6986E-03,  0.9557E-03,  0.1313E-02,  0.1816E-02,   &
      0.2527E-02,  0.3532E-02,  0.4947E-02,  0.6929E-02,  0.9694E-02,   &
      0.1354E-01,  0.1888E-01,  0.2628E-01,  0.3647E-01,  0.5043E-01,   &
      0.6941E-01,  0.9514E-01,  0.1297E+00,  0.1755E+00,  0.2347E+00,   &
      0.3084E+00,  0.3962E+00,  0.4947E+00,  0.5974E+00,  0.6973E+00,   &
      0.7898E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=10,10)/                               &
      -0.1742E-06, -0.3134E-06, -0.5121E-06, -0.7619E-06, -0.1048E-05,  &
      -0.1364E-05, -0.1725E-05, -0.2177E-05, -0.2801E-05, -0.3694E-05,  &
      -0.4969E-05, -0.6748E-05, -0.9161E-05, -0.1236E-04, -0.1655E-04,  &
      -0.2203E-04, -0.2927E-04, -0.3894E-04, -0.5192E-04, -0.6936E-04,  &
      -0.9294E-04, -0.1250E-03, -0.1686E-03, -0.2271E-03, -0.3027E-03,  &
      -0.3944E-03, -0.4951E-03, -0.5928E-03, -0.6755E-03, -0.7309E-03,  &
      -0.7417E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=10,10)/                               &
      0.5179E-09,  0.7789E-09,  0.1071E-08,  0.1382E-08,  0.1690E-08,   &
      0.1979E-08,  0.2297E-08,  0.2704E-08,  0.3466E-08,  0.4794E-08,   &
      0.6746E-08,  0.9739E-08,  0.1481E-07,  0.2331E-07,  0.3679E-07,   &
      0.5726E-07,  0.8716E-07,  0.1289E-06,  0.1837E-06,  0.2534E-06,   &
      0.3424E-06,  0.4609E-06,  0.6245E-06,  0.8495E-06,  0.1151E-05,   &
      0.1536E-05,  0.1991E-05,  0.2468E-05,  0.2891E-05,  0.3245E-05,   &
      0.3580E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=11,11)/                               &
      0.6888E-04,  0.1151E-03,  0.1828E-03,  0.2766E-03,  0.4028E-03,   &
      0.5713E-03,  0.7987E-03,  0.1111E-02,  0.1548E-02,  0.2167E-02,   &
      0.3044E-02,  0.4285E-02,  0.6035E-02,  0.8490E-02,  0.1192E-01,   &
      0.1670E-01,  0.2333E-01,  0.3249E-01,  0.4506E-01,  0.6220E-01,   &
      0.8546E-01,  0.1168E+00,  0.1587E+00,  0.2131E+00,  0.2820E+00,   &
      0.3653E+00,  0.4609E+00,  0.5630E+00,  0.6645E+00,  0.7599E+00,   &
      0.8458E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=11,11)/                               &
      -0.1647E-06, -0.2974E-06, -0.4900E-06, -0.7358E-06, -0.1022E-05,  &
      -0.1344E-05, -0.1721E-05, -0.2212E-05, -0.2901E-05, -0.3896E-05,  &
      -0.5327E-05, -0.7342E-05, -0.1011E-04, -0.1382E-04, -0.1875E-04,  &
      -0.2530E-04, -0.3403E-04, -0.4573E-04, -0.6145E-04, -0.8264E-04,  &
      -0.1114E-03, -0.1507E-03, -0.2039E-03, -0.2737E-03, -0.3607E-03,  &
      -0.4599E-03, -0.5604E-03, -0.6497E-03, -0.7161E-03, -0.7443E-03,  &
      -0.7133E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=11,11)/                               &
      0.5073E-09,  0.7906E-09,  0.1134E-08,  0.1560E-08,  0.2046E-08,   &
      0.2589E-08,  0.3254E-08,  0.4107E-08,  0.5481E-08,  0.7602E-08,   &
      0.1059E-07,  0.1501E-07,  0.2210E-07,  0.3334E-07,  0.5055E-07,   &
      0.7629E-07,  0.1134E-06,  0.1642E-06,  0.2298E-06,  0.3133E-06,   &
      0.4225E-06,  0.5709E-06,  0.7739E-06,  0.1047E-05,  0.1401E-05,   &
      0.1833E-05,  0.2308E-05,  0.2753E-05,  0.3125E-05,  0.3467E-05,   &
      0.3748E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=12,12)/                               &
      0.7179E-04,  0.1221E-03,  0.1975E-03,  0.3049E-03,  0.4529E-03,   &
      0.6547E-03,  0.9312E-03,  0.1315E-02,  0.1855E-02,  0.2620E-02,   &
      0.3705E-02,  0.5243E-02,  0.7414E-02,  0.1046E-01,  0.1472E-01,   &
      0.2065E-01,  0.2888E-01,  0.4019E-01,  0.5566E-01,  0.7668E-01,   &
      0.1051E+00,  0.1432E+00,  0.1932E+00,  0.2571E+00,  0.3358E+00,   &
      0.4278E+00,  0.5285E+00,  0.6310E+00,  0.7289E+00,  0.8184E+00,   &
      0.8954E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=12,12)/                               &
      -0.1548E-06, -0.2808E-06, -0.4683E-06, -0.7142E-06, -0.1008E-05,  &
      -0.1347E-05, -0.1758E-05, -0.2306E-05, -0.3083E-05, -0.4214E-05,  &
      -0.5851E-05, -0.8175E-05, -0.1140E-04, -0.1577E-04, -0.2166E-04,  &
      -0.2955E-04, -0.4014E-04, -0.5434E-04, -0.7343E-04, -0.9931E-04,  &
      -0.1346E-03, -0.1826E-03, -0.2467E-03, -0.3283E-03, -0.4246E-03,  &
      -0.5264E-03, -0.6211E-03, -0.6970E-03, -0.7402E-03, -0.7316E-03,  &
      -0.6486E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=12,12)/                               &
      0.5078E-09,  0.8244E-09,  0.1255E-08,  0.1826E-08,  0.2550E-08,   &
      0.3438E-08,  0.4532E-08,  0.5949E-08,  0.8041E-08,  0.1110E-07,   &
      0.1534E-07,  0.2157E-07,  0.3116E-07,  0.4570E-07,  0.6747E-07,   &
      0.9961E-07,  0.1451E-06,  0.2061E-06,  0.2843E-06,  0.3855E-06,   &
      0.5213E-06,  0.7060E-06,  0.9544E-06,  0.1280E-05,  0.1684E-05,   &
      0.2148E-05,  0.2609E-05,  0.3002E-05,  0.3349E-05,  0.3670E-05,   &
      0.3780E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=13,13)/                               &
      0.7529E-04,  0.1306E-03,  0.2160E-03,  0.3410E-03,  0.5175E-03,   &
      0.7626E-03,  0.1103E-02,  0.1577E-02,  0.2246E-02,  0.3196E-02,   &
      0.4544E-02,  0.6455E-02,  0.9152E-02,  0.1294E-01,  0.1823E-01,   &
      0.2560E-01,  0.3577E-01,  0.4971E-01,  0.6870E-01,  0.9443E-01,   &
      0.1290E+00,  0.1748E+00,  0.2340E+00,  0.3078E+00,  0.3956E+00,   &
      0.4942E+00,  0.5969E+00,  0.6970E+00,  0.7896E+00,  0.8714E+00,   &
      0.9364E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=13,13)/                               &
      -0.1461E-06, -0.2663E-06, -0.4512E-06, -0.7027E-06, -0.1014E-05,  &
      -0.1387E-05, -0.1851E-05, -0.2478E-05, -0.3373E-05, -0.4682E-05,  &
      -0.6588E-05, -0.9311E-05, -0.1311E-04, -0.1834E-04, -0.2544E-04,  &
      -0.3502E-04, -0.4789E-04, -0.6515E-04, -0.8846E-04, -0.1202E-03,  &
      -0.1635E-03, -0.2217E-03, -0.2975E-03, -0.3897E-03, -0.4913E-03,  &
      -0.5902E-03, -0.6740E-03, -0.7302E-03, -0.7415E-03, -0.6858E-03,  &
      -0.5447E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=13,13)/                               &
      0.5236E-09,  0.8873E-09,  0.1426E-08,  0.2193E-08,  0.3230E-08,   &
      0.4555E-08,  0.6200E-08,  0.8298E-08,  0.1126E-07,  0.1544E-07,   &
      0.2130E-07,  0.2978E-07,  0.4239E-07,  0.6096E-07,  0.8829E-07,   &
      0.1280E-06,  0.1830E-06,  0.2555E-06,  0.3493E-06,  0.4740E-06,   &
      0.6431E-06,  0.8701E-06,  0.1169E-05,  0.1547E-05,  0.1992E-05,   &
      0.2460E-05,  0.2877E-05,  0.3230E-05,  0.3569E-05,  0.3782E-05,   &
      0.3591E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=14,14)/                               &
      0.7911E-04,  0.1403E-03,  0.2378E-03,  0.3847E-03,  0.5973E-03,   &
      0.8978E-03,  0.1319E-02,  0.1909E-02,  0.2741E-02,  0.3923E-02,   &
      0.5600E-02,  0.7977E-02,  0.1133E-01,  0.1604E-01,  0.2262E-01,   &
      0.3174E-01,  0.4429E-01,  0.6143E-01,  0.8469E-01,  0.1161E+00,   &
      0.1579E+00,  0.2124E+00,  0.2813E+00,  0.3647E+00,  0.4603E+00,   &
      0.5625E+00,  0.6641E+00,  0.7596E+00,  0.8456E+00,  0.9170E+00,   &
      0.9670E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=14,14)/                               &
      -0.1402E-06, -0.2569E-06, -0.4428E-06, -0.7076E-06, -0.1051E-05,  &
      -0.1478E-05, -0.2019E-05, -0.2752E-05, -0.3802E-05, -0.5343E-05,  &
      -0.7594E-05, -0.1082E-04, -0.1536E-04, -0.2166E-04, -0.3028E-04,  &
      -0.4195E-04, -0.5761E-04, -0.7867E-04, -0.1072E-03, -0.1462E-03,  &
      -0.1990E-03, -0.2687E-03, -0.3559E-03, -0.4558E-03, -0.5572E-03,  &
      -0.6476E-03, -0.7150E-03, -0.7439E-03, -0.7133E-03, -0.6015E-03,  &
      -0.4089E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=14,14)/                               &
      0.5531E-09,  0.9757E-09,  0.1644E-08,  0.2650E-08,  0.4074E-08,   &
      0.5957E-08,  0.8314E-08,  0.1128E-07,  0.1528E-07,  0.2087E-07,   &
      0.2874E-07,  0.4002E-07,  0.5631E-07,  0.7981E-07,  0.1139E-06,   &
      0.1621E-06,  0.2275E-06,  0.3136E-06,  0.4280E-06,  0.5829E-06,   &
      0.7917E-06,  0.1067E-05,  0.1419E-05,  0.1844E-05,  0.2310E-05,   &
      0.2747E-05,  0.3113E-05,  0.3455E-05,  0.3739E-05,  0.3715E-05,   &
      0.3125E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=15,15)/                               &
      0.8292E-04,  0.1503E-03,  0.2614E-03,  0.4345E-03,  0.6915E-03,   &
      0.1061E-02,  0.1584E-02,  0.2320E-02,  0.3359E-02,  0.4831E-02,   &
      0.6920E-02,  0.9877E-02,  0.1405E-01,  0.1990E-01,  0.2805E-01,   &
      0.3933E-01,  0.5477E-01,  0.7579E-01,  0.1042E+00,  0.1423E+00,   &
      0.1924E+00,  0.2564E+00,  0.3351E+00,  0.4271E+00,  0.5280E+00,   &
      0.6306E+00,  0.7286E+00,  0.8182E+00,  0.8952E+00,  0.9530E+00,   &
      0.9864E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=15,15)/                               &
      -0.1378E-06, -0.2542E-06, -0.4461E-06, -0.7333E-06, -0.1125E-05,  &
      -0.1630E-05, -0.2281E-05, -0.3159E-05, -0.4410E-05, -0.6246E-05,  &
      -0.8933E-05, -0.1280E-04, -0.1826E-04, -0.2589E-04, -0.3639E-04,  &
      -0.5059E-04, -0.6970E-04, -0.9552E-04, -0.1307E-03, -0.1784E-03,  &
      -0.2422E-03, -0.3237E-03, -0.4203E-03, -0.5227E-03, -0.6184E-03,  &
      -0.6953E-03, -0.7395E-03, -0.7315E-03, -0.6487E-03, -0.4799E-03,  &
      -0.2625E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=15,15)/                               &
      0.5891E-09,  0.1074E-08,  0.1885E-08,  0.3167E-08,  0.5051E-08,   &
      0.7631E-08,  0.1092E-07,  0.1500E-07,  0.2032E-07,  0.2769E-07,   &
      0.3810E-07,  0.5279E-07,  0.7361E-07,  0.1032E-06,  0.1450E-06,   &
      0.2026E-06,  0.2798E-06,  0.3832E-06,  0.5242E-06,  0.7159E-06,   &
      0.9706E-06,  0.1299E-05,  0.1701E-05,  0.2159E-05,  0.2612E-05,   &
      0.2998E-05,  0.3341E-05,  0.3661E-05,  0.3775E-05,  0.3393E-05,   &
      0.2384E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=16,16)/                               &
      0.8637E-04,  0.1598E-03,  0.2853E-03,  0.4876E-03,  0.7970E-03,   &
      0.1251E-02,  0.1901E-02,  0.2820E-02,  0.4118E-02,  0.5955E-02,   &
      0.8557E-02,  0.1224E-01,  0.1742E-01,  0.2467E-01,  0.3476E-01,   &
      0.4864E-01,  0.6759E-01,  0.9332E-01,  0.1280E+00,  0.1738E+00,   &
      0.2330E+00,  0.3069E+00,  0.3949E+00,  0.4935E+00,  0.5964E+00,   &
      0.6965E+00,  0.7893E+00,  0.8713E+00,  0.9363E+00,  0.9780E+00,   &
      0.9961E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=16,16)/                               &
      -0.1383E-06, -0.2577E-06, -0.4608E-06, -0.7793E-06, -0.1237E-05,  &
      -0.1850E-05, -0.2652E-05, -0.3728E-05, -0.5244E-05, -0.7451E-05,  &
      -0.1067E-04, -0.1532E-04, -0.2193E-04, -0.3119E-04, -0.4395E-04,  &
      -0.6126E-04, -0.8466E-04, -0.1164E-03, -0.1596E-03, -0.2177E-03,  &
      -0.2933E-03, -0.3855E-03, -0.4874E-03, -0.5870E-03, -0.6718E-03,  &
      -0.7290E-03, -0.7411E-03, -0.6859E-03, -0.5450E-03, -0.3353E-03,  &
      -0.1363E-03/
  DATA ((h13(ip,iw,1),iw=1,31),ip=16,16)/                               &
      0.6217E-09,  0.1165E-08,  0.2116E-08,  0.3685E-08,  0.6101E-08,   &
      0.9523E-08,  0.1400E-07,  0.1959E-07,  0.2668E-07,  0.3629E-07,   &
      0.4982E-07,  0.6876E-07,  0.9523E-07,  0.1321E-06,  0.1825E-06,   &
      0.2505E-06,  0.3420E-06,  0.4677E-06,  0.6416E-06,  0.8760E-06,   &
      0.1183E-05,  0.1565E-05,  0.2010E-05,  0.2472E-05,  0.2882E-05,   &
      0.3229E-05,  0.3564E-05,  0.3777E-05,  0.3589E-05,  0.2786E-05,   &
      0.1487E-05/
  DATA ((h11(ip,iw,1),iw=1,31),ip=17,17)/                               &
      0.8925E-04,  0.1682E-03,  0.3074E-03,  0.5403E-03,  0.9085E-03,   &
      0.1463E-02,  0.2268E-02,  0.3416E-02,  0.5040E-02,  0.7333E-02,   &
      0.1057E-01,  0.1515E-01,  0.2157E-01,  0.3055E-01,  0.4297E-01,   &
      0.6001E-01,  0.8323E-01,  0.1146E+00,  0.1565E+00,  0.2111E+00,   &
      0.2801E+00,  0.3636E+00,  0.4594E+00,  0.5618E+00,  0.6636E+00,   &
      0.7592E+00,  0.8454E+00,  0.9169E+00,  0.9669E+00,  0.9923E+00,   &
      0.9995E+00/
  DATA ((h12(ip,iw,1),iw=1,31),ip=17,17)/                               &
      -0.1405E-06, -0.2649E-06, -0.4829E-06, -0.8398E-06, -0.1379E-05,  &
      -0.2132E-05, -0.3138E-05, -0.4487E-05, -0.6353E-05, -0.9026E-05,  &
      -0.1290E-04, -0.1851E-04, -0.2650E-04, -0.3772E-04, -0.5319E-04,  &
      -0.7431E-04, -0.1031E-03, -0.1422E-03, -0.1951E-03, -0.2648E-03,  &
      -0.3519E-03, -0.4518E-03, -0.5537E-03, -0.6449E-03, -0.7133E-03,  &
      -0.7432E-03, -0.7133E-03, -0.6018E-03, -0.4092E-03, -0.1951E-03,  &
      -0.5345E-04/
  DATA ((h13(ip,iw,1),iw=1,31),ip=17,17)/                               &
      0.6457E-09,  0.1235E-08,  0.2303E-08,  0.4149E-08,  0.7120E-08,   &
      0.1152E-07,  0.1749E-07,  0.2508E-07,  0.3462E-07,  0.4718E-07,   &
      0.6452E-07,  0.8874E-07,  0.1222E-06,  0.1675E-06,  0.2276E-06,   &
      0.3076E-06,  0.4174E-06,  0.5714E-06,  0.7837E-06,  0.1067E-05,   &
      0.1428E-05,  0.1859E-05,  0.2327E-05,  0.2760E-05,  0.3122E-05,   &
      0.3458E-05,  0.3739E-05,  0.3715E-05,  0.3126E-05,  0.1942E-05,   &
      0.6977E-06/
  DATA ((h11(ip,iw,1),iw=1,31),ip=18,18)/                               &
      0.9151E-04,  0.1750E-03,  0.3265E-03,  0.5891E-03,  0.1020E-02,   &
      0.1688E-02,  0.2679E-02,  0.4109E-02,  0.6138E-02,  0.9002E-02,   &
      0.1304E-01,  0.1871E-01,  0.2667E-01,  0.3773E-01,  0.5299E-01,   &
      0.7386E-01,  0.1022E+00,  0.1403E+00,  0.1905E+00,  0.2546E+00,   &
      0.3335E+00,  0.4258E+00,  0.5269E+00,  0.6297E+00,  0.7280E+00,   &
      0.8178E+00,  0.8950E+00,  0.9529E+00,  0.9864E+00,  0.9983E+00,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=18,18)/                               &
      -0.1431E-06, -0.2731E-06, -0.5072E-06, -0.9057E-06, -0.1537E-05,  &
      -0.2460E-05, -0.3733E-05, -0.5449E-05, -0.7786E-05, -0.1106E-04,  &
      -0.1574E-04, -0.2249E-04, -0.3212E-04, -0.4564E-04, -0.6438E-04,  &
      -0.9019E-04, -0.1256E-03, -0.1737E-03, -0.2378E-03, -0.3196E-03,  &
      -0.4163E-03, -0.5191E-03, -0.6154E-03, -0.6931E-03, -0.7384E-03,  &
      -0.7313E-03, -0.6492E-03, -0.4805E-03, -0.2629E-03, -0.8897E-04,  &
      -0.1432E-04/
  DATA ((h13(ip,iw,1),iw=1,31),ip=18,18)/                               &
      0.6607E-09,  0.1282E-08,  0.2441E-08,  0.4522E-08,  0.8027E-08,   &
      0.1348E-07,  0.2122E-07,  0.3139E-07,  0.4435E-07,  0.6095E-07,   &
      0.8319E-07,  0.1139E-06,  0.1557E-06,  0.2107E-06,  0.2819E-06,   &
      0.3773E-06,  0.5107E-06,  0.6982E-06,  0.9542E-06,  0.1290E-05,   &
      0.1703E-05,  0.2170E-05,  0.2628E-05,  0.3013E-05,  0.3352E-05,   &
      0.3669E-05,  0.3780E-05,  0.3397E-05,  0.2386E-05,  0.1062E-05,   &
      0.2216E-06/
  DATA ((h11(ip,iw,1),iw=1,31),ip=19,19)/                               &
      0.9320E-04,  0.1803E-03,  0.3422E-03,  0.6317E-03,  0.1124E-02,   &
      0.1915E-02,  0.3121E-02,  0.4890E-02,  0.7421E-02,  0.1100E-01,   &
      0.1602E-01,  0.2306E-01,  0.3288E-01,  0.4647E-01,  0.6515E-01,   &
      0.9066E-01,  0.1252E+00,  0.1710E+00,  0.2304E+00,  0.3045E+00,   &
      0.3928E+00,  0.4918E+00,  0.5951E+00,  0.6956E+00,  0.7887E+00,   &
      0.8709E+00,  0.9361E+00,  0.9780E+00,  0.9961E+00,  0.9999E+00,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=19,19)/                               &
      -0.1454E-06, -0.2805E-06, -0.5296E-06, -0.9685E-06, -0.1695E-05,  &
      -0.2812E-05, -0.4412E-05, -0.6606E-05, -0.9573E-05, -0.1363E-04,  &
      -0.1932E-04, -0.2743E-04, -0.3897E-04, -0.5520E-04, -0.7787E-04,  &
      -0.1094E-03, -0.1529E-03, -0.2117E-03, -0.2880E-03, -0.3809E-03,  &
      -0.4834E-03, -0.5836E-03, -0.6692E-03, -0.7275E-03, -0.7408E-03,  &
      -0.6865E-03, -0.5459E-03, -0.3360E-03, -0.1365E-03, -0.2935E-04,  &
      -0.2173E-05/
  DATA ((h13(ip,iw,1),iw=1,31),ip=19,19)/                               &
      0.6693E-09,  0.1312E-08,  0.2538E-08,  0.4802E-08,  0.8778E-08,   &
      0.1528E-07,  0.2501E-07,  0.3836E-07,  0.5578E-07,  0.7806E-07,   &
      0.1069E-06,  0.1456E-06,  0.1970E-06,  0.2631E-06,  0.3485E-06,   &
      0.4642E-06,  0.6268E-06,  0.8526E-06,  0.1157E-05,  0.1545E-05,   &
      0.2002E-05,  0.2478E-05,  0.2897E-05,  0.3245E-05,  0.3578E-05,   &
      0.3789E-05,  0.3598E-05,  0.2792E-05,  0.1489E-05,  0.4160E-06,   &
      0.3843E-07/
  DATA ((h11(ip,iw,1),iw=1,31),ip=20,20)/                               &
      0.9443E-04,  0.1843E-03,  0.3545E-03,  0.6669E-03,  0.1217E-02,   &
      0.2133E-02,  0.3577E-02,  0.5742E-02,  0.8880E-02,  0.1333E-01,   &
      0.1958E-01,  0.2830E-01,  0.4039E-01,  0.5705E-01,  0.7988E-01,   &
      0.1110E+00,  0.1526E+00,  0.2072E+00,  0.2764E+00,  0.3604E+00,   &
      0.4567E+00,  0.5597E+00,  0.6620E+00,  0.7581E+00,  0.8447E+00,   &
      0.9165E+00,  0.9668E+00,  0.9923E+00,  0.9995E+00,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=20,20)/                               &
      -0.1472E-06, -0.2866E-06, -0.5485E-06, -0.1024E-05, -0.1842E-05,  &
      -0.3160E-05, -0.5136E-05, -0.7922E-05, -0.1171E-04, -0.1682E-04,  &
      -0.2381E-04, -0.3355E-04, -0.4729E-04, -0.6673E-04, -0.9417E-04,  &
      -0.1327E-03, -0.1858E-03, -0.2564E-03, -0.3449E-03, -0.4463E-03,  &
      -0.5495E-03, -0.6420E-03, -0.7116E-03, -0.7427E-03, -0.7139E-03,  &
      -0.6031E-03, -0.4104E-03, -0.1957E-03, -0.5358E-04, -0.6176E-05,  &
      -0.1347E-06/
  DATA ((h13(ip,iw,1),iw=1,31),ip=20,20)/                               &
      0.6750E-09,  0.1332E-08,  0.2602E-08,  0.5003E-08,  0.9367E-08,   &
      0.1684E-07,  0.2863E-07,  0.4566E-07,  0.6865E-07,  0.9861E-07,   &
      0.1368E-06,  0.1856E-06,  0.2479E-06,  0.3274E-06,  0.4315E-06,   &
      0.5739E-06,  0.7710E-06,  0.1040E-05,  0.1394E-05,  0.1829E-05,   &
      0.2309E-05,  0.2759E-05,  0.3131E-05,  0.3472E-05,  0.3755E-05,   &
      0.3730E-05,  0.3138E-05,  0.1948E-05,  0.6994E-06,  0.1022E-06,   &
      0.2459E-08/
  DATA ((h11(ip,iw,1),iw=1,31),ip=21,21)/                               &
      0.9530E-04,  0.1872E-03,  0.3638E-03,  0.6949E-03,  0.1295E-02,   &
      0.2330E-02,  0.4022E-02,  0.6633E-02,  0.1049E-01,  0.1601E-01,   &
      0.2378E-01,  0.3456E-01,  0.4941E-01,  0.6980E-01,  0.9765E-01,   &
      0.1353E+00,  0.1852E+00,  0.2494E+00,  0.3287E+00,  0.4216E+00,   &
      0.5234E+00,  0.6272E+00,  0.7261E+00,  0.8166E+00,  0.8943E+00,   &
      0.9526E+00,  0.9863E+00,  0.9983E+00,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=21,21)/                               &
      -0.1487E-06, -0.2912E-06, -0.5636E-06, -0.1069E-05, -0.1969E-05,  &
      -0.3483E-05, -0.5858E-05, -0.9334E-05, -0.1416E-04, -0.2067E-04,  &
      -0.2936E-04, -0.4113E-04, -0.5750E-04, -0.8072E-04, -0.1139E-03,  &
      -0.1606E-03, -0.2246E-03, -0.3076E-03, -0.4067E-03, -0.5121E-03,  &
      -0.6110E-03, -0.6909E-03, -0.7378E-03, -0.7321E-03, -0.6509E-03,  &
      -0.4825E-03, -0.2641E-03, -0.8936E-04, -0.1436E-04, -0.5966E-06,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=21,21)/                               &
      0.6777E-09,  0.1344E-08,  0.2643E-08,  0.5138E-08,  0.9798E-08,   &
      0.1809E-07,  0.3185E-07,  0.5285E-07,  0.8249E-07,  0.1222E-06,   &
      0.1730E-06,  0.2351E-06,  0.3111E-06,  0.4078E-06,  0.5366E-06,   &
      0.7117E-06,  0.9495E-06,  0.1266E-05,  0.1667E-05,  0.2132E-05,   &
      0.2600E-05,  0.3001E-05,  0.3354E-05,  0.3679E-05,  0.3796E-05,   &
      0.3414E-05,  0.2399E-05,  0.1067E-05,  0.2222E-06,  0.1075E-07,   &
      0.0000E+00/
  DATA ((h11(ip,iw,1),iw=1,31),ip=22,22)/                               &
      0.9589E-04,  0.1893E-03,  0.3706E-03,  0.7162E-03,  0.1357E-02,   &
      0.2500E-02,  0.4434E-02,  0.7523E-02,  0.1220E-01,  0.1900E-01,   &
      0.2860E-01,  0.4190E-01,  0.6015E-01,  0.8508E-01,  0.1189E+00,   &
      0.1643E+00,  0.2233E+00,  0.2976E+00,  0.3865E+00,  0.4865E+00,   &
      0.5909E+00,  0.6925E+00,  0.7866E+00,  0.8696E+00,  0.9355E+00,   &
      0.9778E+00,  0.9961E+00,  0.9999E+00,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=22,22)/                               &
      -0.1496E-06, -0.2947E-06, -0.5749E-06, -0.1105E-05, -0.2074E-05,  &
      -0.3763E-05, -0.6531E-05, -0.1076E-04, -0.1682E-04, -0.2509E-04,  &
      -0.3605E-04, -0.5049E-04, -0.7012E-04, -0.9787E-04, -0.1378E-03,  &
      -0.1939E-03, -0.2695E-03, -0.3641E-03, -0.4703E-03, -0.5750E-03,  &
      -0.6648E-03, -0.7264E-03, -0.7419E-03, -0.6889E-03, -0.5488E-03,  &
      -0.3382E-03, -0.1375E-03, -0.2951E-04, -0.2174E-05,  0.0000E+00,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=22,22)/                               &
      0.6798E-09,  0.1350E-08,  0.2667E-08,  0.5226E-08,  0.1010E-07,   &
      0.1903E-07,  0.3455E-07,  0.5951E-07,  0.9658E-07,  0.1479E-06,   &
      0.2146E-06,  0.2951E-06,  0.3903E-06,  0.5101E-06,  0.6693E-06,   &
      0.8830E-06,  0.1168E-05,  0.1532E-05,  0.1968E-05,  0.2435E-05,   &
      0.2859E-05,  0.3222E-05,  0.3572E-05,  0.3797E-05,  0.3615E-05,   &
      0.2811E-05,  0.1500E-05,  0.4185E-06,  0.3850E-07,  0.0000E+00,   &
      0.0000E+00/
  DATA ((h11(ip,iw,1),iw=1,31),ip=23,23)/                               &
      0.9629E-04,  0.1907E-03,  0.3755E-03,  0.7321E-03,  0.1406E-02,   &
      0.2639E-02,  0.4796E-02,  0.8368E-02,  0.1394E-01,  0.2221E-01,   &
      0.3400E-01,  0.5037E-01,  0.7279E-01,  0.1033E+00,  0.1442E+00,   &
      0.1983E+00,  0.2673E+00,  0.3516E+00,  0.4489E+00,  0.5533E+00,   &
      0.6572E+00,  0.7547E+00,  0.8425E+00,  0.9153E+00,  0.9663E+00,   &
      0.9922E+00,  0.9995E+00,  0.1000E+01,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=23,23)/                               &
      -0.1503E-06, -0.2971E-06, -0.5832E-06, -0.1131E-05, -0.2154E-05,  &
      -0.3992E-05, -0.7122E-05, -0.1211E-04, -0.1954E-04, -0.2995E-04,  &
      -0.4380E-04, -0.6183E-04, -0.8577E-04, -0.1191E-03, -0.1668E-03,  &
      -0.2333E-03, -0.3203E-03, -0.4237E-03, -0.5324E-03, -0.6318E-03,  &
      -0.7075E-03, -0.7429E-03, -0.7168E-03, -0.6071E-03, -0.4139E-03,  &
      -0.1976E-03, -0.5410E-04, -0.6215E-05, -0.1343E-06,  0.0000E+00,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=23,23)/                               &
      0.6809E-09,  0.1356E-08,  0.2683E-08,  0.5287E-08,  0.1030E-07,   &
      0.1971E-07,  0.3665E-07,  0.6528E-07,  0.1100E-06,  0.1744E-06,   &
      0.2599E-06,  0.3650E-06,  0.4887E-06,  0.6398E-06,  0.8358E-06,   &
      0.1095E-05,  0.1429E-05,  0.1836E-05,  0.2286E-05,  0.2716E-05,   &
      0.3088E-05,  0.3444E-05,  0.3748E-05,  0.3740E-05,  0.3157E-05,   &
      0.1966E-05,  0.7064E-06,  0.1030E-06,  0.2456E-08,  0.0000E+00,   &
      0.0000E+00/
  DATA ((h11(ip,iw,1),iw=1,31),ip=24,24)/                               &
      0.9655E-04,  0.1917E-03,  0.3789E-03,  0.7436E-03,  0.1442E-02,   &
      0.2748E-02,  0.5100E-02,  0.9128E-02,  0.1563E-01,  0.2553E-01,   &
      0.3987E-01,  0.5994E-01,  0.8746E-01,  0.1246E+00,  0.1739E+00,   &
      0.2376E+00,  0.3170E+00,  0.4107E+00,  0.5141E+00,  0.6198E+00,   &
      0.7208E+00,  0.8130E+00,  0.8923E+00,  0.9517E+00,  0.9860E+00,   &
      0.9983E+00,  0.1000E+01,  0.1000E+01,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=24,24)/                               &
      -0.1508E-06, -0.2989E-06, -0.5892E-06, -0.1151E-05, -0.2216E-05,  &
      -0.4175E-05, -0.7619E-05, -0.1333E-04, -0.2217E-04, -0.3497E-04,  &
      -0.5238E-04, -0.7513E-04, -0.1049E-03, -0.1455E-03, -0.2021E-03,  &
      -0.2790E-03, -0.3757E-03, -0.4839E-03, -0.5902E-03, -0.6794E-03,  &
      -0.7344E-03, -0.7341E-03, -0.6557E-03, -0.4874E-03, -0.2674E-03,  &
      -0.9059E-04, -0.1455E-04, -0.5986E-06,  0.0000E+00,  0.0000E+00,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=24,24)/                               &
      0.6812E-09,  0.1356E-08,  0.2693E-08,  0.5328E-08,  0.1045E-07,   &
      0.2021E-07,  0.3826E-07,  0.6994E-07,  0.1218E-06,  0.1997E-06,   &
      0.3069E-06,  0.4428E-06,  0.6064E-06,  0.8015E-06,  0.1043E-05,   &
      0.1351E-05,  0.1733E-05,  0.2168E-05,  0.2598E-05,  0.2968E-05,   &
      0.3316E-05,  0.3662E-05,  0.3801E-05,  0.3433E-05,  0.2422E-05,   &
      0.1081E-05,  0.2256E-06,  0.1082E-07,  0.0000E+00,  0.0000E+00,   &
      0.0000E+00/
  DATA ((h11(ip,iw,1),iw=1,31),ip=25,25)/                               &
      0.9672E-04,  0.1923E-03,  0.3813E-03,  0.7518E-03,  0.1469E-02,   &
      0.2832E-02,  0.5343E-02,  0.9779E-02,  0.1719E-01,  0.2882E-01,   &
      0.4606E-01,  0.7051E-01,  0.1042E+00,  0.1493E+00,  0.2081E+00,   &
      0.2824E+00,  0.3720E+00,  0.4736E+00,  0.5803E+00,  0.6844E+00,   &
      0.7810E+00,  0.8663E+00,  0.9339E+00,  0.9772E+00,  0.9960E+00,   &
      0.9999E+00,  0.1000E+01,  0.1000E+01,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=25,25)/                               &
      -0.1511E-06, -0.3001E-06, -0.5934E-06, -0.1166E-05, -0.2263E-05,  &
      -0.4319E-05, -0.8028E-05, -0.1438E-04, -0.2460E-04, -0.3991E-04,  &
      -0.6138E-04, -0.9005E-04, -0.1278E-03, -0.1778E-03, -0.2447E-03,  &
      -0.3313E-03, -0.4342E-03, -0.5424E-03, -0.6416E-03, -0.7146E-03,  &
      -0.7399E-03, -0.6932E-03, -0.5551E-03, -0.3432E-03, -0.1398E-03,  &
      -0.3010E-04, -0.2229E-05,  0.0000E+00,  0.0000E+00,  0.0000E+00,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=25,25)/                               &
      0.6815E-09,  0.1358E-08,  0.2698E-08,  0.5355E-08,  0.1054E-07,   &
      0.2056E-07,  0.3942E-07,  0.7349E-07,  0.1315E-06,  0.2226E-06,   &
      0.3537E-06,  0.5266E-06,  0.7407E-06,  0.9958E-06,  0.1296E-05,   &
      0.1657E-05,  0.2077E-05,  0.2512E-05,  0.2893E-05,  0.3216E-05,   &
      0.3562E-05,  0.3811E-05,  0.3644E-05,  0.2841E-05,  0.1524E-05,   &
      0.4276E-06,  0.3960E-07,  0.0000E+00,  0.0000E+00,  0.0000E+00,   &
      0.0000E+00/
  DATA ((h11(ip,iw,1),iw=1,31),ip=26,26)/                               &
      0.9682E-04,  0.1928E-03,  0.3829E-03,  0.7576E-03,  0.1489E-02,   &
      0.2894E-02,  0.5533E-02,  0.1031E-01,  0.1856E-01,  0.3195E-01,   &
      0.5237E-01,  0.8187E-01,  0.1227E+00,  0.1771E+00,  0.2468E+00,   &
      0.3321E+00,  0.4312E+00,  0.5384E+00,  0.6455E+00,  0.7463E+00,   &
      0.8372E+00,  0.9126E+00,  0.9652E+00,  0.9919E+00,  0.9994E+00,   &
      0.1000E+01,  0.1000E+01,  0.1000E+01,  0.1000E+01,  0.1000E+01,   &
      0.1000E+01/
  DATA ((h12(ip,iw,1),iw=1,31),ip=26,26)/                               &
      -0.1513E-06, -0.3009E-06, -0.5966E-06, -0.1176E-05, -0.2299E-05,  &
      -0.4430E-05, -0.8352E-05, -0.1526E-04, -0.2674E-04, -0.4454E-04,  &
      -0.7042E-04, -0.1062E-03, -0.1540E-03, -0.2163E-03, -0.2951E-03,  &
      -0.3899E-03, -0.4948E-03, -0.5983E-03, -0.6846E-03, -0.7332E-03,  &
      -0.7182E-03, -0.6142E-03, -0.4209E-03, -0.2014E-03, -0.5530E-04,  &
      -0.6418E-05, -0.1439E-06,  0.0000E+00,  0.0000E+00,  0.0000E+00,  &
      0.0000E+00/
  DATA ((h13(ip,iw,1),iw=1,31),ip=26,26)/                               &
      0.6817E-09,  0.1359E-08,  0.2702E-08,  0.5374E-08,  0.1061E-07,   &
      0.2079E-07,  0.4022E-07,  0.7610E-07,  0.1392E-06,  0.2428E-06,   &
      0.3992E-06,  0.6149E-06,  0.8893E-06,  0.1220E-05,  0.1599E-05,   &
      0.2015E-05,  0.2453E-05,  0.2853E-05,  0.3173E-05,  0.3488E-05,   &
      0.3792E-05,  0.3800E-05,  0.3210E-05,  0.2002E-05,  0.7234E-06,   &
      0.1068E-06,  0.2646E-08,  0.0000E+00,  0.0000E+00,  0.0000E+00,   &
      0.0000E+00/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      0.3920E-05,  0.7617E-05,  0.1455E-04,  0.2706E-04,  0.4855E-04,   &
      0.8315E-04,  0.1349E-03,  0.2063E-03,  0.2984E-03,  0.4109E-03,   &
      0.5422E-03,  0.6896E-03,  0.8537E-03,  0.1041E-02,  0.1262E-02,   &
      0.1534E-02,  0.1870E-02,  0.2286E-02,  0.2803E-02,  0.3444E-02,   &
      0.4242E-02,  0.5244E-02,  0.6511E-02,  0.8138E-02,  0.1027E-01,   &
      0.1312E-01,  0.1697E-01,  0.2222E-01,  0.2941E-01,  0.3923E-01,   &
      0.5258E-01/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      -0.5622E-07, -0.1071E-06, -0.1983E-06, -0.3533E-06, -0.5991E-06,  &
      -0.9592E-06, -0.1444E-05, -0.2049E-05, -0.2764E-05, -0.3577E-05,  &
      -0.4469E-05, -0.5467E-05, -0.6654E-05, -0.8137E-05, -0.1002E-04,  &
      -0.1237E-04, -0.1528E-04, -0.1884E-04, -0.2310E-04, -0.2809E-04,  &
      -0.3396E-04, -0.4098E-04, -0.4960E-04, -0.6058E-04, -0.7506E-04,  &
      -0.9451E-04, -0.1207E-03, -0.1558E-03, -0.2026E-03, -0.2648E-03,  &
      -0.3468E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      -0.2195E-09, -0.4031E-09, -0.7043E-09, -0.1153E-08, -0.1737E-08,  &
      -0.2395E-08, -0.3020E-08, -0.3549E-08, -0.4034E-08, -0.4421E-08,  &
      -0.4736E-08, -0.5681E-08, -0.8289E-08, -0.1287E-07, -0.1873E-07,  &
      -0.2523E-07, -0.3223E-07, -0.3902E-07, -0.4409E-07, -0.4699E-07,  &
      -0.4782E-07, -0.4705E-07, -0.4657E-07, -0.4885E-07, -0.5550E-07,  &
      -0.6619E-07, -0.7656E-07, -0.8027E-07, -0.7261E-07, -0.4983E-07,  &
      -0.1101E-07/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      0.3920E-05,  0.7617E-05,  0.1455E-04,  0.2706E-04,  0.4856E-04,   &
      0.8318E-04,  0.1349E-03,  0.2065E-03,  0.2986E-03,  0.4114E-03,   &
      0.5431E-03,  0.6912E-03,  0.8566E-03,  0.1046E-02,  0.1272E-02,   &
      0.1552E-02,  0.1902E-02,  0.2342E-02,  0.2899E-02,  0.3605E-02,   &
      0.4501E-02,  0.5648E-02,  0.7129E-02,  0.9063E-02,  0.1163E-01,   &
      0.1509E-01,  0.1980E-01,  0.2626E-01,  0.3510E-01,  0.4717E-01,   &
      0.6351E-01/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      -0.5622E-07, -0.1071E-06, -0.1983E-06, -0.3534E-06, -0.5992E-06,  &
      -0.9594E-06, -0.1445E-05, -0.2050E-05, -0.2766E-05, -0.3580E-05,  &
      -0.4476E-05, -0.5479E-05, -0.6677E-05, -0.8179E-05, -0.1009E-04,  &
      -0.1251E-04, -0.1553E-04, -0.1928E-04, -0.2384E-04, -0.2930E-04,  &
      -0.3588E-04, -0.4393E-04, -0.5403E-04, -0.6714E-04, -0.8458E-04,  &
      -0.1082E-03, -0.1400E-03, -0.1829E-03, -0.2401E-03, -0.3157E-03,  &
      -0.4147E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      -0.2195E-09, -0.4032E-09, -0.7046E-09, -0.1153E-08, -0.1738E-08,  &
      -0.2395E-08, -0.3021E-08, -0.3550E-08, -0.4035E-08, -0.4423E-08,  &
      -0.4740E-08, -0.5692E-08, -0.8314E-08, -0.1292E-07, -0.1882E-07,  &
      -0.2536E-07, -0.3242E-07, -0.3927E-07, -0.4449E-07, -0.4767E-07,  &
      -0.4889E-07, -0.4857E-07, -0.4860E-07, -0.5132E-07, -0.5847E-07,  &
      -0.6968E-07, -0.8037E-07, -0.8400E-07, -0.7521E-07, -0.4830E-07,  &
      -0.7562E-09/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      0.3920E-05,  0.7617E-05,  0.1455E-04,  0.2707E-04,  0.4858E-04,   &
      0.8322E-04,  0.1350E-03,  0.2066E-03,  0.2990E-03,  0.4122E-03,   &
      0.5444E-03,  0.6937E-03,  0.8611E-03,  0.1054E-02,  0.1287E-02,   &
      0.1579E-02,  0.1949E-02,  0.2424E-02,  0.3037E-02,  0.3829E-02,   &
      0.4854E-02,  0.6190E-02,  0.7942E-02,  0.1026E-01,  0.1338E-01,   &
      0.1761E-01,  0.2340E-01,  0.3134E-01,  0.4223E-01,  0.5703E-01,   &
      0.7694E-01/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      -0.5622E-07, -0.1071E-06, -0.1983E-06, -0.3535E-06, -0.5994E-06,  &
      -0.9599E-06, -0.1446E-05, -0.2052E-05, -0.2769E-05, -0.3586E-05,  &
      -0.4487E-05, -0.5499E-05, -0.6712E-05, -0.8244E-05, -0.1021E-04,  &
      -0.1272E-04, -0.1591E-04, -0.1992E-04, -0.2489E-04, -0.3097E-04,  &
      -0.3845E-04, -0.4782E-04, -0.5982E-04, -0.7558E-04, -0.9674E-04,  &
      -0.1254E-03, -0.1644E-03, -0.2167E-03, -0.2863E-03, -0.3777E-03,  &
      -0.4959E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      -0.2196E-09, -0.4033E-09, -0.7048E-09, -0.1154E-08, -0.1739E-08,  &
      -0.2396E-08, -0.3022E-08, -0.3551E-08, -0.4036E-08, -0.4425E-08,  &
      -0.4746E-08, -0.5710E-08, -0.8354E-08, -0.1300E-07, -0.1894E-07,  &
      -0.2554E-07, -0.3265E-07, -0.3958E-07, -0.4502E-07, -0.4859E-07,  &
      -0.5030E-07, -0.5053E-07, -0.5104E-07, -0.5427E-07, -0.6204E-07,  &
      -0.7388E-07, -0.8477E-07, -0.8760E-07, -0.7545E-07, -0.4099E-07,  &
      0.2046E-07/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      0.3919E-05,  0.7618E-05,  0.1455E-04,  0.2708E-04,  0.4860E-04,   &
      0.8327E-04,  0.1352E-03,  0.2070E-03,  0.2997E-03,  0.4134E-03,   &
      0.5466E-03,  0.6976E-03,  0.8682E-03,  0.1067E-02,  0.1310E-02,   &
      0.1619E-02,  0.2020E-02,  0.2543E-02,  0.3232E-02,  0.4136E-02,   &
      0.5328E-02,  0.6906E-02,  0.9004E-02,  0.1182E-01,  0.1562E-01,   &
      0.2081E-01,  0.2794E-01,  0.3773E-01,  0.5111E-01,  0.6919E-01,   &
      0.9329E-01/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      -0.5623E-07, -0.1071E-06, -0.1984E-06, -0.3536E-06, -0.5997E-06,  &
      -0.9606E-06, -0.1447E-05, -0.2055E-05, -0.2775E-05, -0.3596E-05,  &
      -0.4504E-05, -0.5529E-05, -0.6768E-05, -0.8345E-05, -0.1039E-04,  &
      -0.1304E-04, -0.1645E-04, -0.2082E-04, -0.2633E-04, -0.3322E-04,  &
      -0.4187E-04, -0.5292E-04, -0.6730E-04, -0.8640E-04, -0.1122E-03,  &
      -0.1472E-03, -0.1948E-03, -0.2585E-03, -0.3428E-03, -0.4523E-03,  &
      -0.5915E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      -0.2196E-09, -0.4034E-09, -0.7050E-09, -0.1154E-08, -0.1740E-08,  &
      -0.2398E-08, -0.3024E-08, -0.3552E-08, -0.4037E-08, -0.4428E-08,  &
      -0.4756E-08, -0.5741E-08, -0.8418E-08, -0.1310E-07, -0.1910E-07,  &
      -0.2575E-07, -0.3293E-07, -0.3998E-07, -0.4572E-07, -0.4980E-07,  &
      -0.5211E-07, -0.5287E-07, -0.5390E-07, -0.5782E-07, -0.6650E-07,  &
      -0.7892E-07, -0.8940E-07, -0.8980E-07, -0.7119E-07, -0.2452E-07,  &
      0.5823E-07/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      0.3919E-05,  0.7618E-05,  0.1455E-04,  0.2709E-04,  0.4863E-04,   &
      0.8337E-04,  0.1354E-03,  0.2075E-03,  0.3007E-03,  0.4152E-03,   &
      0.5500E-03,  0.7038E-03,  0.8793E-03,  0.1086E-02,  0.1345E-02,   &
      0.1680E-02,  0.2123E-02,  0.2712E-02,  0.3500E-02,  0.4552E-02,   &
      0.5958E-02,  0.7844E-02,  0.1038E-01,  0.1381E-01,  0.1847E-01,   &
      0.2487E-01,  0.3366E-01,  0.4572E-01,  0.6209E-01,  0.8406E-01,   &
      0.1130E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      -0.5623E-07, -0.1071E-06, -0.1985E-06, -0.3538E-06, -0.6002E-06,  &
      -0.9618E-06, -0.1450E-05, -0.2059E-05, -0.2783E-05, -0.3611E-05,  &
      -0.4531E-05, -0.5577E-05, -0.6855E-05, -0.8499E-05, -0.1066E-04,  &
      -0.1351E-04, -0.1723E-04, -0.2207E-04, -0.2829E-04, -0.3621E-04,  &
      -0.4636E-04, -0.5954E-04, -0.7690E-04, -0.1002E-03, -0.1317E-03,  &
      -0.1746E-03, -0.2326E-03, -0.3099E-03, -0.4111E-03, -0.5407E-03,  &
      -0.7020E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      -0.2197E-09, -0.4037E-09, -0.7054E-09, -0.1155E-08, -0.1741E-08,  &
      -0.2401E-08, -0.3027E-08, -0.3553E-08, -0.4039E-08, -0.4431E-08,  &
      -0.4775E-08, -0.5784E-08, -0.8506E-08, -0.1326E-07, -0.1931E-07,  &
      -0.2600E-07, -0.3324E-07, -0.4048E-07, -0.4666E-07, -0.5137E-07,  &
      -0.5428E-07, -0.5558E-07, -0.5730E-07, -0.6228E-07, -0.7197E-07,  &
      -0.8455E-07, -0.9347E-07, -0.8867E-07, -0.5945E-07,  0.5512E-08,  &
      0.1209E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      0.3919E-05,  0.7619E-05,  0.1456E-04,  0.2710E-04,  0.4868E-04,   &
      0.8351E-04,  0.1357E-03,  0.2082E-03,  0.3022E-03,  0.4181E-03,   &
      0.5554E-03,  0.7134E-03,  0.8963E-03,  0.1117E-02,  0.1397E-02,   &
      0.1770E-02,  0.2270E-02,  0.2947E-02,  0.3865E-02,  0.5107E-02,   &
      0.6787E-02,  0.9062E-02,  0.1215E-01,  0.1634E-01,  0.2209E-01,   &
      0.2999E-01,  0.4083E-01,  0.5563E-01,  0.7559E-01,  0.1021E+00,   &
      0.1364E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      -0.5624E-07, -0.1072E-06, -0.1986E-06, -0.3541E-06, -0.6010E-06,  &
      -0.9636E-06, -0.1453E-05, -0.2067E-05, -0.2796E-05, -0.3634E-05,  &
      -0.4572E-05, -0.5652E-05, -0.6987E-05, -0.8733E-05, -0.1107E-04,  &
      -0.1418E-04, -0.1832E-04, -0.2378E-04, -0.3092E-04, -0.4017E-04,  &
      -0.5221E-04, -0.6806E-04, -0.8916E-04, -0.1176E-03, -0.1562E-03,  &
      -0.2087E-03, -0.2793E-03, -0.3724E-03, -0.4928E-03, -0.6440E-03,  &
      -0.8270E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      -0.2198E-09, -0.4040E-09, -0.7061E-09, -0.1156E-08, -0.1744E-08,  &
      -0.2405E-08, -0.3032E-08, -0.3556E-08, -0.4040E-08, -0.4444E-08,  &
      -0.4800E-08, -0.5848E-08, -0.8640E-08, -0.1346E-07, -0.1957E-07,  &
      -0.2627E-07, -0.3357E-07, -0.4114E-07, -0.4793E-07, -0.5330E-07,  &
      -0.5676E-07, -0.5873E-07, -0.6152E-07, -0.6783E-07, -0.7834E-07,  &
      -0.9023E-07, -0.9530E-07, -0.8162E-07, -0.3634E-07,  0.5638E-07,  &
      0.2189E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      0.3919E-05,  0.7620E-05,  0.1457E-04,  0.2713E-04,  0.4877E-04,   &
      0.8374E-04,  0.1363E-03,  0.2095E-03,  0.3047E-03,  0.4227E-03,   &
      0.5637E-03,  0.7282E-03,  0.9224E-03,  0.1162E-02,  0.1475E-02,   &
      0.1898E-02,  0.2475E-02,  0.3267E-02,  0.4354E-02,  0.5839E-02,   &
      0.7866E-02,  0.1063E-01,  0.1440E-01,  0.1957E-01,  0.2666E-01,   &
      0.3641E-01,  0.4975E-01,  0.6784E-01,  0.9201E-01,  0.1236E+00,   &
      0.1639E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      -0.5626E-07, -0.1072E-06, -0.1987E-06, -0.3545E-06, -0.6022E-06,  &
      -0.9665E-06, -0.1460E-05, -0.2078E-05, -0.2817E-05, -0.3671E-05,  &
      -0.4637E-05, -0.5767E-05, -0.7188E-05, -0.9080E-05, -0.1165E-04,  &
      -0.1513E-04, -0.1981E-04, -0.2609E-04, -0.3441E-04, -0.4534E-04,  &
      -0.5978E-04, -0.7897E-04, -0.1047E-03, -0.1396E-03, -0.1870E-03,  &
      -0.2510E-03, -0.3363E-03, -0.4475E-03, -0.5888E-03, -0.7621E-03,  &
      -0.9647E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      -0.2200E-09, -0.4045E-09, -0.7071E-09, -0.1159E-08, -0.1748E-08,  &
      -0.2411E-08, -0.3040E-08, -0.3561E-08, -0.4046E-08, -0.4455E-08,  &
      -0.4839E-08, -0.5941E-08, -0.8815E-08, -0.1371E-07, -0.1983E-07,  &
      -0.2652E-07, -0.3400E-07, -0.4207E-07, -0.4955E-07, -0.5554E-07,  &
      -0.5966E-07, -0.6261E-07, -0.6688E-07, -0.7454E-07, -0.8521E-07,  &
      -0.9470E-07, -0.9275E-07, -0.6525E-07,  0.3686E-08,  0.1371E-06,  &
      0.3623E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      0.3919E-05,  0.7622E-05,  0.1458E-04,  0.2717E-04,  0.4890E-04,   &
      0.8410E-04,  0.1372E-03,  0.2114E-03,  0.3085E-03,  0.4298E-03,   &
      0.5765E-03,  0.7508E-03,  0.9618E-03,  0.1229E-02,  0.1586E-02,   &
      0.2077E-02,  0.2757E-02,  0.3697E-02,  0.5000E-02,  0.6794E-02,   &
      0.9260E-02,  0.1264E-01,  0.1728E-01,  0.2365E-01,  0.3242E-01,   &
      0.4444E-01,  0.6080E-01,  0.8278E-01,  0.1118E+00,  0.1491E+00,   &
      0.1956E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      -0.5628E-07, -0.1073E-06, -0.1990E-06, -0.3553E-06, -0.6042E-06,  &
      -0.9710E-06, -0.1469E-05, -0.2096E-05, -0.2849E-05, -0.3728E-05,  &
      -0.4738E-05, -0.5942E-05, -0.7490E-05, -0.9586E-05, -0.1247E-04,  &
      -0.1644E-04, -0.2184E-04, -0.2916E-04, -0.3898E-04, -0.5205E-04,  &
      -0.6948E-04, -0.9285E-04, -0.1244E-03, -0.1672E-03, -0.2251E-03,  &
      -0.3028E-03, -0.4051E-03, -0.5365E-03, -0.6998E-03, -0.8940E-03,  &
      -0.1112E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      -0.2204E-09, -0.4052E-09, -0.7088E-09, -0.1162E-08, -0.1755E-08,  &
      -0.2422E-08, -0.3053E-08, -0.3572E-08, -0.4052E-08, -0.4474E-08,  &
      -0.4898E-08, -0.6082E-08, -0.9046E-08, -0.1400E-07, -0.2009E-07,  &
      -0.2683E-07, -0.3463E-07, -0.4334E-07, -0.5153E-07, -0.5811E-07,  &
      -0.6305E-07, -0.6749E-07, -0.7346E-07, -0.8208E-07, -0.9173E-07,  &
      -0.9603E-07, -0.8264E-07, -0.3505E-07,  0.6878E-07,  0.2586E-06,  &
      0.5530E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      0.3919E-05,  0.7625E-05,  0.1459E-04,  0.2723E-04,  0.4910E-04,   &
      0.8465E-04,  0.1385E-03,  0.2143E-03,  0.3143E-03,  0.4407E-03,   &
      0.5960E-03,  0.7850E-03,  0.1020E-02,  0.1326E-02,  0.1744E-02,   &
      0.2324E-02,  0.3135E-02,  0.4267E-02,  0.5845E-02,  0.8031E-02,   &
      0.1105E-01,  0.1520E-01,  0.2093E-01,  0.2880E-01,  0.3962E-01,   &
      0.5440E-01,  0.7435E-01,  0.1009E+00,  0.1353E+00,  0.1787E+00,   &
      0.2317E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      -0.5630E-07, -0.1074E-06, -0.1994E-06, -0.3564E-06, -0.6072E-06,  &
      -0.9779E-06, -0.1484E-05, -0.2124E-05, -0.2900E-05, -0.3817E-05,  &
      -0.4891E-05, -0.6205E-05, -0.7931E-05, -0.1031E-04, -0.1362E-04,  &
      -0.1821E-04, -0.2454E-04, -0.3320E-04, -0.4493E-04, -0.6068E-04,  &
      -0.8186E-04, -0.1104E-03, -0.1491E-03, -0.2016E-03, -0.2722E-03,  &
      -0.3658E-03, -0.4873E-03, -0.6404E-03, -0.8253E-03, -0.1037E-02,  &
      -0.1267E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      -0.2207E-09, -0.4061E-09, -0.7117E-09, -0.1169E-08, -0.1767E-08,  &
      -0.2439E-08, -0.3074E-08, -0.3588E-08, -0.4062E-08, -0.4510E-08,  &
      -0.4983E-08, -0.6261E-08, -0.9324E-08, -0.1430E-07, -0.2036E-07,  &
      -0.2725E-07, -0.3561E-07, -0.4505E-07, -0.5384E-07, -0.6111E-07,  &
      -0.6731E-07, -0.7355E-07, -0.8112E-07, -0.8978E-07, -0.9616E-07,  &
      -0.9157E-07, -0.6114E-07,  0.1622E-07,  0.1694E-06,  0.4277E-06,  &
      0.7751E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip=10,10)/                               &
      0.3919E-05,  0.7629E-05,  0.1462E-04,  0.2733E-04,  0.4940E-04,   &
      0.8549E-04,  0.1406E-03,  0.2188E-03,  0.3232E-03,  0.4572E-03,   &
      0.6253E-03,  0.8354E-03,  0.1105E-02,  0.1464E-02,  0.1960E-02,   &
      0.2657E-02,  0.3637E-02,  0.5014E-02,  0.6942E-02,  0.9622E-02,   &
      0.1333E-01,  0.1846E-01,  0.2553E-01,  0.3526E-01,  0.4859E-01,   &
      0.6667E-01,  0.9084E-01,  0.1225E+00,  0.1629E+00,  0.2127E+00,   &
      0.2721E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=10,10)/                               &
      -0.5636E-07, -0.1076E-06, -0.2000E-06, -0.3582E-06, -0.6119E-06,  &
      -0.9888E-06, -0.1507E-05, -0.2168E-05, -0.2978E-05, -0.3952E-05,  &
      -0.5122E-05, -0.6592E-05, -0.8565E-05, -0.1132E-04, -0.1518E-04,  &
      -0.2060E-04, -0.2811E-04, -0.3848E-04, -0.5261E-04, -0.7173E-04,  &
      -0.9758E-04, -0.1326E-03, -0.1801E-03, -0.2442E-03, -0.3296E-03,  &
      -0.4415E-03, -0.5840E-03, -0.7591E-03, -0.9636E-03, -0.1189E-02,  &
      -0.1427E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=10,10)/                               &
      -0.2214E-09, -0.4080E-09, -0.7156E-09, -0.1178E-08, -0.1784E-08,  &
      -0.2466E-08, -0.3105E-08, -0.3617E-08, -0.4087E-08, -0.4563E-08,  &
      -0.5110E-08, -0.6492E-08, -0.9643E-08, -0.1461E-07, -0.2069E-07,  &
      -0.2796E-07, -0.3702E-07, -0.4717E-07, -0.5662E-07, -0.6484E-07,  &
      -0.7271E-07, -0.8079E-07, -0.8928E-07, -0.9634E-07, -0.9625E-07,  &
      -0.7776E-07, -0.2242E-07,  0.9745E-07,  0.3152E-06,  0.6388E-06,  &
      0.9992E-06/
  DATA ((h21(ip,iw,1),iw=1,31),ip=11,11)/                               &
      0.3919E-05,  0.7639E-05,  0.1466E-04,  0.2748E-04,  0.4986E-04,   &
      0.8675E-04,  0.1437E-03,  0.2255E-03,  0.3365E-03,  0.4816E-03,   &
      0.6682E-03,  0.9082E-03,  0.1224E-02,  0.1653E-02,  0.2253E-02,   &
      0.3099E-02,  0.4296E-02,  0.5984E-02,  0.8352E-02,  0.1165E-01,   &
      0.1623E-01,  0.2257E-01,  0.3132E-01,  0.4333E-01,  0.5968E-01,   &
      0.8166E-01,  0.1107E+00,  0.1481E+00,  0.1947E+00,  0.2509E+00,   &
      0.3170E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=11,11)/                               &
      -0.5645E-07, -0.1079E-06, -0.2009E-06, -0.3610E-06, -0.6190E-06,  &
      -0.1005E-05, -0.1541E-05, -0.2235E-05, -0.3096E-05, -0.4155E-05,  &
      -0.5463E-05, -0.7150E-05, -0.9453E-05, -0.1269E-04, -0.1728E-04,  &
      -0.2375E-04, -0.3279E-04, -0.4531E-04, -0.6246E-04, -0.8579E-04,  &
      -0.1175E-03, -0.1604E-03, -0.2186E-03, -0.2964E-03, -0.3990E-03,  &
      -0.5311E-03, -0.6957E-03, -0.8916E-03, -0.1112E-02, -0.1346E-02,  &
      -0.1590E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=11,11)/                               &
      -0.2225E-09, -0.4104E-09, -0.7217E-09, -0.1192E-08, -0.1811E-08,  &
      -0.2509E-08, -0.3155E-08, -0.3668E-08, -0.4138E-08, -0.4650E-08,  &
      -0.5296E-08, -0.6785E-08, -0.9991E-08, -0.1494E-07, -0.2122E-07,  &
      -0.2911E-07, -0.3895E-07, -0.4979E-07, -0.6002E-07, -0.6964E-07,  &
      -0.7935E-07, -0.8887E-07, -0.9699E-07, -0.9967E-07, -0.8883E-07,  &
      -0.4988E-07,  0.4156E-07,  0.2197E-06,  0.5081E-06,  0.8667E-06,  &
      0.1212E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=12,12)/                               &
      0.3920E-05,  0.7649E-05,  0.1472E-04,  0.2768E-04,  0.5051E-04,   &
      0.8856E-04,  0.1481E-03,  0.2352E-03,  0.3557E-03,  0.5169E-03,   &
      0.7295E-03,  0.1010E-02,  0.1388E-02,  0.1909E-02,  0.2640E-02,   &
      0.3678E-02,  0.5151E-02,  0.7231E-02,  0.1015E-01,  0.1423E-01,   &
      0.1990E-01,  0.2775E-01,  0.3856E-01,  0.5333E-01,  0.7328E-01,   &
      0.9980E-01,  0.1343E+00,  0.1778E+00,  0.2308E+00,  0.2936E+00,   &
      0.3667E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=12,12)/                               &
      -0.5658E-07, -0.1083E-06, -0.2023E-06, -0.3650E-06, -0.6295E-06,  &
      -0.1030E-05, -0.1593E-05, -0.2334E-05, -0.3273E-05, -0.4455E-05,  &
      -0.5955E-05, -0.7935E-05, -0.1067E-04, -0.1455E-04, -0.2007E-04,  &
      -0.2788E-04, -0.3885E-04, -0.5409E-04, -0.7503E-04, -0.1036E-03,  &
      -0.1425E-03, -0.1951E-03, -0.2660E-03, -0.3598E-03, -0.4817E-03,  &
      -0.6355E-03, -0.8218E-03, -0.1035E-02, -0.1267E-02, -0.1508E-02,  &
      -0.1755E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=12,12)/                               &
      -0.2241E-09, -0.4142E-09, -0.7312E-09, -0.1214E-08, -0.1854E-08,  &
      -0.2578E-08, -0.3250E-08, -0.3765E-08, -0.4238E-08, -0.4809E-08,  &
      -0.5553E-08, -0.7132E-08, -0.1035E-07, -0.1538E-07, -0.2211E-07,  &
      -0.3079E-07, -0.4142E-07, -0.5303E-07, -0.6437E-07, -0.7566E-07,  &
      -0.8703E-07, -0.9700E-07, -0.1025E-06, -0.9718E-07, -0.6973E-07,  &
      -0.5265E-09,  0.1413E-06,  0.3895E-06,  0.7321E-06,  0.1085E-05,  &
      0.1449E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=13,13)/                               &
      0.3920E-05,  0.7668E-05,  0.1480E-04,  0.2798E-04,  0.5143E-04,   &
      0.9106E-04,  0.1542E-03,  0.2488E-03,  0.3827E-03,  0.5661E-03,   &
      0.8143E-03,  0.1150E-02,  0.1608E-02,  0.2246E-02,  0.3147E-02,   &
      0.4428E-02,  0.6248E-02,  0.8823E-02,  0.1244E-01,  0.1750E-01,   &
      0.2452E-01,  0.3424E-01,  0.4756E-01,  0.6564E-01,  0.8981E-01,   &
      0.1215E+00,  0.1619E+00,  0.2118E+00,  0.2713E+00,  0.3409E+00,   &
      0.4215E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=13,13)/                               &
      -0.5677E-07, -0.1090E-06, -0.2043E-06, -0.3709E-06, -0.6448E-06,  &
      -0.1066E-05, -0.1669E-05, -0.2480E-05, -0.3532E-05, -0.4887E-05,  &
      -0.6650E-05, -0.9017E-05, -0.1232E-04, -0.1701E-04, -0.2372E-04,  &
      -0.3325E-04, -0.4664E-04, -0.6528E-04, -0.9095E-04, -0.1260E-03,  &
      -0.1737E-03, -0.2381E-03, -0.3238E-03, -0.4359E-03, -0.5789E-03,  &
      -0.7549E-03, -0.9607E-03, -0.1188E-02, -0.1427E-02, -0.1674E-02,  &
      -0.1914E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=13,13)/                               &
      -0.2262E-09, -0.4191E-09, -0.7441E-09, -0.1244E-08, -0.1916E-08,  &
      -0.2687E-08, -0.3407E-08, -0.3947E-08, -0.4432E-08, -0.5059E-08,  &
      -0.5896E-08, -0.7538E-08, -0.1079E-07, -0.1606E-07, -0.2346E-07,  &
      -0.3305E-07, -0.4459E-07, -0.5720E-07, -0.6999E-07, -0.8300E-07,  &
      -0.9536E-07, -0.1039E-06, -0.1036E-06, -0.8526E-07, -0.3316E-07,  &
      0.7909E-07,  0.2865E-06,  0.6013E-06,  0.9580E-06,  0.1303E-05,   &
      0.1792E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=14,14)/                               &
      0.3923E-05,  0.7691E-05,  0.1491E-04,  0.2836E-04,  0.5261E-04,   &
      0.9432E-04,  0.1623E-03,  0.2667E-03,  0.4187E-03,  0.6323E-03,   &
      0.9278E-03,  0.1334E-02,  0.1897E-02,  0.2685E-02,  0.3800E-02,   &
      0.5388E-02,  0.7646E-02,  0.1084E-01,  0.1533E-01,  0.2160E-01,   &
      0.3031E-01,  0.4231E-01,  0.5866E-01,  0.8064E-01,  0.1097E+00,   &
      0.1471E+00,  0.1938E+00,  0.2501E+00,  0.3163E+00,  0.3932E+00,   &
      0.4810E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=14,14)/                               &
      -0.5703E-07, -0.1098E-06, -0.2071E-06, -0.3788E-06, -0.6657E-06,  &
      -0.1116E-05, -0.1776E-05, -0.2687E-05, -0.3898E-05, -0.5493E-05,  &
      -0.7607E-05, -0.1048E-04, -0.1450E-04, -0.2024E-04, -0.2845E-04,  &
      -0.4014E-04, -0.5658E-04, -0.7947E-04, -0.1110E-03, -0.1541E-03,  &
      -0.2125E-03, -0.2907E-03, -0.3936E-03, -0.5261E-03, -0.6912E-03,  &
      -0.8880E-03, -0.1109E-02, -0.1346E-02, -0.1591E-02, -0.1837E-02,  &
      -0.2054E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=14,14)/                               &
      -0.2288E-09, -0.4265E-09, -0.7627E-09, -0.1289E-08, -0.2011E-08,  &
      -0.2861E-08, -0.3673E-08, -0.4288E-08, -0.4812E-08, -0.5475E-08,  &
      -0.6365E-08, -0.8052E-08, -0.1142E-07, -0.1711E-07, -0.2533E-07,  &
      -0.3597E-07, -0.4862E-07, -0.6259E-07, -0.7708E-07, -0.9150E-07,  &
      -0.1035E-06, -0.1079E-06, -0.9742E-07, -0.5928E-07,  0.2892E-07,  &
      0.1998E-06,  0.4789E-06,  0.8298E-06,  0.1172E-05,  0.1583E-05,   &
      0.2329E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=15,15)/                               &
      0.3928E-05,  0.7724E-05,  0.1504E-04,  0.2883E-04,  0.5403E-04,   &
      0.9826E-04,  0.1722E-03,  0.2891E-03,  0.4644E-03,  0.7172E-03,   &
      0.1074E-02,  0.1572E-02,  0.2267E-02,  0.3245E-02,  0.4632E-02,   &
      0.6606E-02,  0.9411E-02,  0.1338E-01,  0.1896E-01,  0.2674E-01,   &
      0.3751E-01,  0.5227E-01,  0.7222E-01,  0.9875E-01,  0.1332E+00,   &
      0.1768E+00,  0.2299E+00,  0.2927E+00,  0.3660E+00,  0.4504E+00,   &
      0.5444E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=15,15)/                               &
      -0.5736E-07, -0.1109E-06, -0.2106E-06, -0.3890E-06, -0.6928E-06,  &
      -0.1181E-05, -0.1917E-05, -0.2965E-05, -0.4396E-05, -0.6315E-05,  &
      -0.8891E-05, -0.1242E-04, -0.1736E-04, -0.2442E-04, -0.3454E-04,  &
      -0.4892E-04, -0.6916E-04, -0.9735E-04, -0.1362E-03, -0.1891E-03,  &
      -0.2602E-03, -0.3545E-03, -0.4768E-03, -0.6310E-03, -0.8179E-03,  &
      -0.1032E-02, -0.1265E-02, -0.1508E-02, -0.1757E-02, -0.1989E-02,  &
      -0.2159E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=15,15)/                               &
      -0.2321E-09, -0.4350E-09, -0.7861E-09, -0.1347E-08, -0.2144E-08,  &
      -0.3120E-08, -0.4107E-08, -0.4892E-08, -0.5511E-08, -0.6164E-08,  &
      -0.7054E-08, -0.8811E-08, -0.1240E-07, -0.1862E-07, -0.2773E-07,  &
      -0.3957E-07, -0.5371E-07, -0.6939E-07, -0.8564E-07, -0.1006E-06,  &
      -0.1100E-06, -0.1066E-06, -0.8018E-07, -0.1228E-07,  0.1263E-06,  &
      0.3678E-06,  0.7022E-06,  0.1049E-05,  0.1411E-05,  0.2015E-05,   &
      0.3099E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=16,16)/                               &
      0.2064E-05,  0.4104E-05,  0.8141E-05,  0.1607E-04,  0.3145E-04,   &
      0.6080E-04,  0.1153E-03,  0.2129E-03,  0.3802E-03,  0.6538E-03,   &
      0.1078E-02,  0.1699E-02,  0.2576E-02,  0.3805E-02,  0.5540E-02,   &
      0.8004E-02,  0.1149E-01,  0.1640E-01,  0.2329E-01,  0.3290E-01,   &
      0.4622E-01,  0.6441E-01,  0.8888E-01,  0.1210E+00,  0.1622E+00,   &
      0.2132E+00,  0.2745E+00,  0.3470E+00,  0.4317E+00,  0.5286E+00,   &
      0.6335E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=16,16)/                               &
      -0.3122E-07, -0.6175E-07, -0.1214E-06, -0.2361E-06, -0.4518E-06,  &
      -0.8438E-06, -0.1524E-05, -0.2643E-05, -0.4380E-05, -0.6922E-05,  &
      -0.1042E-04, -0.1504E-04, -0.2125E-04, -0.2987E-04, -0.4200E-04,  &
      -0.5923E-04, -0.8383E-04, -0.1186E-03, -0.1670E-03, -0.2328E-03,  &
      -0.3204E-03, -0.4347E-03, -0.5802E-03, -0.7595E-03, -0.9703E-03,  &
      -0.1205E-02, -0.1457E-02, -0.1720E-02, -0.1980E-02, -0.2191E-02,  &
      -0.2290E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=16,16)/                               &
      -0.1376E-09, -0.2699E-09, -0.5220E-09, -0.9897E-09, -0.1819E-08,  &
      -0.3186E-08, -0.5224E-08, -0.7896E-08, -0.1090E-07, -0.1349E-07,  &
      -0.1443E-07, -0.1374E-07, -0.1386E-07, -0.1673E-07, -0.2237E-07,  &
      -0.3248E-07, -0.5050E-07, -0.7743E-07, -0.1097E-06, -0.1369E-06,  &
      -0.1463E-06, -0.1268E-06, -0.6424E-07,  0.5941E-07,  0.2742E-06,  &
      0.5924E-06,  0.9445E-06,  0.1286E-05,  0.1819E-05,  0.2867E-05,   &
      0.4527E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=17,17)/                               &
      0.2452E-05,  0.4881E-05,  0.9693E-05,  0.1918E-04,  0.3768E-04,   &
      0.7322E-04,  0.1399E-03,  0.2607E-03,  0.4694E-03,  0.8102E-03,   &
      0.1334E-02,  0.2098E-02,  0.3180E-02,  0.4710E-02,  0.6879E-02,   &
      0.9952E-02,  0.1429E-01,  0.2038E-01,  0.2894E-01,  0.4085E-01,   &
      0.5722E-01,  0.7939E-01,  0.1088E+00,  0.1468E+00,  0.1945E+00,   &
      0.2524E+00,  0.3210E+00,  0.4017E+00,  0.4948E+00,  0.5978E+00,   &
      0.7040E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=17,17)/                               &
      -0.3547E-07, -0.7029E-07, -0.1386E-06, -0.2709E-06, -0.5218E-06,  &
      -0.9840E-06, -0.1799E-05, -0.3156E-05, -0.5272E-05, -0.8357E-05,  &
      -0.1260E-04, -0.1827E-04, -0.2598E-04, -0.3667E-04, -0.5169E-04,  &
      -0.7312E-04, -0.1037E-03, -0.1467E-03, -0.2060E-03, -0.2857E-03,  &
      -0.3907E-03, -0.5257E-03, -0.6940E-03, -0.8954E-03, -0.1124E-02,  &
      -0.1371E-02, -0.1632E-02, -0.1897E-02, -0.2131E-02, -0.2275E-02,  &
      -0.2265E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=17,17)/                               &
      -0.1482E-09, -0.2910E-09, -0.5667E-09, -0.1081E-08, -0.2005E-08,  &
      -0.3554E-08, -0.5902E-08, -0.8925E-08, -0.1209E-07, -0.1448E-07,  &
      -0.1536E-07, -0.1565E-07, -0.1763E-07, -0.2088E-07, -0.2564E-07,  &
      -0.3635E-07, -0.5791E-07, -0.8907E-07, -0.1213E-06, -0.1418E-06,  &
      -0.1397E-06, -0.1000E-06, -0.4427E-08,  0.1713E-06,  0.4536E-06,  &
      0.8086E-06,  0.1153E-05,  0.1588E-05,  0.2437E-05,  0.3905E-05,   &
      0.5874E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=18,18)/                               &
      0.2878E-05,  0.5733E-05,  0.1140E-04,  0.2258E-04,  0.4446E-04,   &
      0.8668E-04,  0.1664E-03,  0.3120E-03,  0.5656E-03,  0.9812E-03,   &
      0.1621E-02,  0.2559E-02,  0.3902E-02,  0.5812E-02,  0.8522E-02,   &
      0.1235E-01,  0.1773E-01,  0.2530E-01,  0.3590E-01,  0.5058E-01,   &
      0.7059E-01,  0.9736E-01,  0.1323E+00,  0.1767E+00,  0.2312E+00,   &
      0.2962E+00,  0.3728E+00,  0.4619E+00,  0.5623E+00,  0.6685E+00,   &
      0.7716E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=18,18)/                               &
      -0.4064E-07, -0.8066E-07, -0.1593E-06, -0.3124E-06, -0.6049E-06,  &
      -0.1148E-05, -0.2118E-05, -0.3751E-05, -0.6314E-05, -0.1006E-04,  &
      -0.1526E-04, -0.2232E-04, -0.3196E-04, -0.4525E-04, -0.6394E-04,  &
      -0.9058E-04, -0.1284E-03, -0.1812E-03, -0.2533E-03, -0.3493E-03,  &
      -0.4740E-03, -0.6315E-03, -0.8228E-03, -0.1044E-02, -0.1286E-02,  &
      -0.1544E-02, -0.1810E-02, -0.2061E-02, -0.2243E-02, -0.2291E-02,  &
      -0.2152E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=18,18)/                               &
      -0.1630E-09, -0.3213E-09, -0.6266E-09, -0.1201E-08, -0.2248E-08,  &
      -0.4030E-08, -0.6770E-08, -0.1033E-07, -0.1392E-07, -0.1640E-07,  &
      -0.1768E-07, -0.1932E-07, -0.2229E-07, -0.2508E-07, -0.2940E-07,  &
      -0.4200E-07, -0.6717E-07, -0.1002E-06, -0.1286E-06, -0.1402E-06,  &
      -0.1216E-06, -0.5487E-07,  0.8418E-07,  0.3246E-06,  0.6610E-06,  &
      0.1013E-05,  0.1394E-05,  0.2073E-05,  0.3337E-05,  0.5175E-05,   &
      0.7255E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=19,19)/                               &
      0.3282E-05,  0.6539E-05,  0.1300E-04,  0.2578E-04,  0.5085E-04,   &
      0.9936E-04,  0.1914E-03,  0.3608E-03,  0.6586E-03,  0.1153E-02,   &
      0.1924E-02,  0.3074E-02,  0.4742E-02,  0.7126E-02,  0.1051E-01,   &
      0.1526E-01,  0.2195E-01,  0.3133E-01,  0.4441E-01,  0.6238E-01,   &
      0.8664E-01,  0.1186E+00,  0.1597E+00,  0.2108E+00,  0.2723E+00,   &
      0.3450E+00,  0.4300E+00,  0.5272E+00,  0.6324E+00,  0.7378E+00,   &
      0.8330E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=19,19)/                               &
      -0.4629E-07, -0.9195E-07, -0.1819E-06, -0.3572E-06, -0.6936E-06,  &
      -0.1323E-05, -0.2456E-05, -0.4385E-05, -0.7453E-05, -0.1200E-04,  &
      -0.1843E-04, -0.2731E-04, -0.3943E-04, -0.5606E-04, -0.7936E-04,  &
      -0.1123E-03, -0.1588E-03, -0.2231E-03, -0.3101E-03, -0.4247E-03,  &
      -0.5713E-03, -0.7522E-03, -0.9651E-03, -0.1202E-02, -0.1456E-02,  &
      -0.1721E-02, -0.1983E-02, -0.2196E-02, -0.2296E-02, -0.2224E-02,  &
      -0.1952E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=19,19)/                               &
      -0.1827E-09, -0.3607E-09, -0.7057E-09, -0.1359E-08, -0.2552E-08,  &
      -0.4615E-08, -0.7854E-08, -0.1218E-07, -0.1670E-07, -0.2008E-07,  &
      -0.2241E-07, -0.2516E-07, -0.2796E-07, -0.3015E-07, -0.3506E-07,  &
      -0.4958E-07, -0.7627E-07, -0.1070E-06, -0.1289E-06, -0.1286E-06,  &
      -0.8843E-07,  0.1492E-07,  0.2118E-06,  0.5155E-06,  0.8665E-06,  &
      0.1220E-05,  0.1765E-05,  0.2825E-05,  0.4498E-05,  0.6563E-05,   &
      0.8422E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=20,20)/                               &
      0.3608E-05,  0.7189E-05,  0.1430E-04,  0.2837E-04,  0.5601E-04,   &
      0.1097E-03,  0.2120E-03,  0.4017E-03,  0.7396E-03,  0.1311E-02,   &
      0.2226E-02,  0.3624E-02,  0.5685E-02,  0.8652E-02,  0.1286E-01,   &
      0.1878E-01,  0.2709E-01,  0.3868E-01,  0.5471E-01,  0.7654E-01,   &
      0.1057E+00,  0.1435E+00,  0.1912E+00,  0.2492E+00,  0.3181E+00,   &
      0.3990E+00,  0.4926E+00,  0.5960E+00,  0.7027E+00,  0.8027E+00,   &
      0.8852E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=20,20)/                               &
      -0.5164E-07, -0.1026E-06, -0.2031E-06, -0.3994E-06, -0.7771E-06,  &
      -0.1488E-05, -0.2776E-05, -0.5001E-05, -0.8610E-05, -0.1411E-04,  &
      -0.2209E-04, -0.3328E-04, -0.4860E-04, -0.6954E-04, -0.9861E-04,  &
      -0.1393E-03, -0.1961E-03, -0.2738E-03, -0.3778E-03, -0.5132E-03,  &
      -0.6831E-03, -0.8868E-03, -0.1118E-02, -0.1368E-02, -0.1632E-02,  &
      -0.1899E-02, -0.2136E-02, -0.2282E-02, -0.2273E-02, -0.2067E-02,  &
      -0.1679E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=20,20)/                               &
      -0.2058E-09, -0.4066E-09, -0.7967E-09, -0.1539E-08, -0.2904E-08,  &
      -0.5293E-08, -0.9116E-08, -0.1447E-07, -0.2058E-07, -0.2608E-07,  &
      -0.3053E-07, -0.3418E-07, -0.3619E-07, -0.3766E-07, -0.4313E-07,  &
      -0.5817E-07, -0.8299E-07, -0.1072E-06, -0.1195E-06, -0.1031E-06,  &
      -0.3275E-07,  0.1215E-06,  0.3835E-06,  0.7220E-06,  0.1062E-05,  &
      0.1504E-05,  0.2367E-05,  0.3854E-05,  0.5842E-05,  0.7875E-05,   &
      0.9082E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=21,21)/                               &
      0.3827E-05,  0.7626E-05,  0.1518E-04,  0.3013E-04,  0.5955E-04,   &
      0.1169E-03,  0.2268E-03,  0.4325E-03,  0.8046E-03,  0.1449E-02,   &
      0.2512E-02,  0.4185E-02,  0.6707E-02,  0.1038E-01,  0.1561E-01,   &
      0.2298E-01,  0.3328E-01,  0.4754E-01,  0.6708E-01,  0.9340E-01,   &
      0.1280E+00,  0.1722E+00,  0.2267E+00,  0.2918E+00,  0.3688E+00,   &
      0.4584E+00,  0.5594E+00,  0.6662E+00,  0.7700E+00,  0.8597E+00,   &
      0.9266E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=21,21)/                               &
      -0.5584E-07, -0.1110E-06, -0.2198E-06, -0.4329E-06, -0.8444E-06,  &
      -0.1623E-05, -0.3049E-05, -0.5551E-05, -0.9714E-05, -0.1627E-04,  &
      -0.2609E-04, -0.4015E-04, -0.5955E-04, -0.8603E-04, -0.1223E-03,  &
      -0.1724E-03, -0.2413E-03, -0.3346E-03, -0.4578E-03, -0.6155E-03,  &
      -0.8087E-03, -0.1033E-02, -0.1279E-02, -0.1540E-02, -0.1811E-02,  &
      -0.2065E-02, -0.2251E-02, -0.2301E-02, -0.2163E-02, -0.1828E-02,  &
      -0.1365E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=21,21)/                               &
      -0.2274E-09, -0.4498E-09, -0.8814E-09, -0.1708E-08, -0.3247E-08,  &
      -0.5972E-08, -0.1045E-07, -0.1707E-07, -0.2545E-07, -0.3440E-07,  &
      -0.4259E-07, -0.4822E-07, -0.5004E-07, -0.5061E-07, -0.5485E-07,  &
      -0.6687E-07, -0.8483E-07, -0.9896E-07, -0.9646E-07, -0.5557E-07,  &
      0.5765E-07,  0.2752E-06,  0.5870E-06,  0.9188E-06,  0.1291E-05,   &
      0.1971E-05,  0.3251E-05,  0.5115E-05,  0.7221E-05,  0.8825E-05,   &
      0.9032E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=22,22)/                               &
      0.3938E-05,  0.7849E-05,  0.1563E-04,  0.3105E-04,  0.6149E-04,   &
      0.1210E-03,  0.2361E-03,  0.4537E-03,  0.8543E-03,  0.1565E-02,   &
      0.2774E-02,  0.4739E-02,  0.7781E-02,  0.1229E-01,  0.1877E-01,   &
      0.2791E-01,  0.4064E-01,  0.5812E-01,  0.8180E-01,  0.1132E+00,   &
      0.1539E+00,  0.2047E+00,  0.2662E+00,  0.3391E+00,  0.4247E+00,   &
      0.5226E+00,  0.6287E+00,  0.7351E+00,  0.8311E+00,  0.9066E+00,   &
      0.9569E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=22,22)/                               &
      -0.5833E-07, -0.1160E-06, -0.2300E-06, -0.4540E-06, -0.8885E-06,  &
      -0.1718E-05, -0.3256E-05, -0.6010E-05, -0.1072E-04, -0.1838E-04,  &
      -0.3026E-04, -0.4772E-04, -0.7223E-04, -0.1057E-03, -0.1512E-03,  &
      -0.2128E-03, -0.2961E-03, -0.4070E-03, -0.5514E-03, -0.7320E-03,  &
      -0.9467E-03, -0.1187E-02, -0.1446E-02, -0.1717E-02, -0.1985E-02,  &
      -0.2203E-02, -0.2307E-02, -0.2237E-02, -0.1965E-02, -0.1532E-02,  &
      -0.1044E-02/
  DATA ((h23(ip,iw,1),iw=1,31),ip=22,22)/                               &
      -0.2426E-09, -0.4805E-09, -0.9447E-09, -0.1841E-08, -0.3519E-08,  &
      -0.6565E-08, -0.1172E-07, -0.1979E-07, -0.3095E-07, -0.4443E-07,  &
      -0.5821E-07, -0.6868E-07, -0.7282E-07, -0.7208E-07, -0.7176E-07,  &
      -0.7562E-07, -0.8110E-07, -0.7934E-07, -0.5365E-07,  0.2483E-07,  &
      0.1959E-06,  0.4731E-06,  0.7954E-06,  0.1123E-05,  0.1652E-05,   &
      0.2711E-05,  0.4402E-05,  0.6498E-05,  0.8392E-05,  0.9154E-05,   &
      0.8261E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=23,23)/                               &
      0.3973E-05,  0.7921E-05,  0.1578E-04,  0.3139E-04,  0.6229E-04,   &
      0.1231E-03,  0.2414E-03,  0.4680E-03,  0.8923E-03,  0.1663E-02,   &
      0.3011E-02,  0.5268E-02,  0.8869E-02,  0.1434E-01,  0.2230E-01,   &
      0.3359E-01,  0.4924E-01,  0.7057E-01,  0.9908E-01,  0.1363E+00,   &
      0.1834E+00,  0.2411E+00,  0.3100E+00,  0.3913E+00,  0.4856E+00,   &
      0.5901E+00,  0.6981E+00,  0.7994E+00,  0.8832E+00,  0.9424E+00,   &
      0.9773E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=23,23)/                               &
      -0.5929E-07, -0.1180E-06, -0.2344E-06, -0.4638E-06, -0.9118E-06,  &
      -0.1775E-05, -0.3401E-05, -0.6375E-05, -0.1160E-04, -0.2039E-04,  &
      -0.3444E-04, -0.5575E-04, -0.8641E-04, -0.1287E-03, -0.1856E-03,  &
      -0.2615E-03, -0.3618E-03, -0.4928E-03, -0.6594E-03, -0.8621E-03,  &
      -0.1095E-02, -0.1349E-02, -0.1618E-02, -0.1894E-02, -0.2140E-02,  &
      -0.2293E-02, -0.2290E-02, -0.2085E-02, -0.1696E-02, -0.1212E-02,  &
      -0.7506E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip=23,23)/                               &
      -0.2496E-09, -0.4954E-09, -0.9780E-09, -0.1915E-08, -0.3697E-08,  &
      -0.6991E-08, -0.1279E-07, -0.2231E-07, -0.3653E-07, -0.5541E-07,  &
      -0.7688E-07, -0.9614E-07, -0.1069E-06, -0.1065E-06, -0.9866E-07,  &
      -0.8740E-07, -0.7192E-07, -0.4304E-07,  0.1982E-07,  0.1525E-06,  &
      0.3873E-06,  0.6947E-06,  0.1000E-05,  0.1409E-05,  0.2253E-05,   &
      0.3739E-05,  0.5744E-05,  0.7812E-05,  0.9067E-05,  0.8746E-05,   &
      0.6940E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=24,24)/                               &
      0.3978E-05,  0.7933E-05,  0.1581E-04,  0.3149E-04,  0.6260E-04,   &
      0.1240E-03,  0.2445E-03,  0.4777E-03,  0.9213E-03,  0.1743E-02,   &
      0.3217E-02,  0.5756E-02,  0.9929E-02,  0.1644E-01,  0.2612E-01,   &
      0.3995E-01,  0.5910E-01,  0.8497E-01,  0.1190E+00,  0.1626E+00,   &
      0.2165E+00,  0.2813E+00,  0.3583E+00,  0.4485E+00,  0.5505E+00,   &
      0.6590E+00,  0.7646E+00,  0.8562E+00,  0.9245E+00,  0.9676E+00,   &
      0.9897E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=24,24)/                               &
      -0.5950E-07, -0.1185E-06, -0.2358E-06, -0.4678E-06, -0.9235E-06,  &
      -0.1810E-05, -0.3503E-05, -0.6664E-05, -0.1236E-04, -0.2223E-04,  &
      -0.3849E-04, -0.6396E-04, -0.1017E-03, -0.1545E-03, -0.2257E-03,  &
      -0.3192E-03, -0.4399E-03, -0.5933E-03, -0.7824E-03, -0.1005E-02,  &
      -0.1251E-02, -0.1516E-02, -0.1794E-02, -0.2060E-02, -0.2257E-02,  &
      -0.2318E-02, -0.2186E-02, -0.1853E-02, -0.1386E-02, -0.9021E-03,  &
      -0.5050E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip=24,24)/                               &
      -0.2515E-09, -0.5001E-09, -0.9904E-09, -0.1951E-08, -0.3800E-08,  &
      -0.7288E-08, -0.1362E-07, -0.2452E-07, -0.4184E-07, -0.6663E-07,  &
      -0.9770E-07, -0.1299E-06, -0.1533E-06, -0.1584E-06, -0.1425E-06,  &
      -0.1093E-06, -0.5972E-07,  0.1426E-07,  0.1347E-06,  0.3364E-06,  &
      0.6209E-06,  0.9169E-06,  0.1243E-05,  0.1883E-05,  0.3145E-05,   &
      0.5011E-05,  0.7136E-05,  0.8785E-05,  0.9048E-05,  0.7686E-05,   &
      0.5368E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=25,25)/                               &
      0.3978E-05,  0.7934E-05,  0.1582E-04,  0.3153E-04,  0.6275E-04,   &
      0.1246E-03,  0.2466E-03,  0.4847E-03,  0.9432E-03,  0.1808E-02,   &
      0.3392E-02,  0.6189E-02,  0.1092E-01,  0.1852E-01,  0.3009E-01,   &
      0.4683E-01,  0.7008E-01,  0.1012E+00,  0.1416E+00,  0.1920E+00,   &
      0.2531E+00,  0.3258E+00,  0.4115E+00,  0.5102E+00,  0.6180E+00,   &
      0.7267E+00,  0.8252E+00,  0.9030E+00,  0.9550E+00,  0.9838E+00,   &
      0.9965E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=25,25)/                               &
      -0.5953E-07, -0.1187E-06, -0.2363E-06, -0.4697E-06, -0.9304E-06,  &
      -0.1833E-05, -0.3578E-05, -0.6889E-05, -0.1299E-04, -0.2384E-04,  &
      -0.4227E-04, -0.7201E-04, -0.1174E-03, -0.1825E-03, -0.2710E-03,  &
      -0.3861E-03, -0.5313E-03, -0.7095E-03, -0.9203E-03, -0.1158E-02,  &
      -0.1417E-02, -0.1691E-02, -0.1968E-02, -0.2200E-02, -0.2320E-02,  &
      -0.2263E-02, -0.1998E-02, -0.1563E-02, -0.1068E-02, -0.6300E-03,  &
      -0.3174E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip=25,25)/                               &
      -0.2520E-09, -0.5016E-09, -0.9963E-09, -0.1971E-08, -0.3867E-08,  &
      -0.7500E-08, -0.1427E-07, -0.2634E-07, -0.4656E-07, -0.7753E-07,  &
      -0.1196E-06, -0.1683E-06, -0.2113E-06, -0.2309E-06, -0.2119E-06,  &
      -0.1518E-06, -0.5200E-07,  0.9274E-07,  0.2973E-06,  0.5714E-06,  &
      0.8687E-06,  0.1152E-05,  0.1621E-05,  0.2634E-05,  0.4310E-05,   &
      0.6418E-05,  0.8347E-05,  0.9162E-05,  0.8319E-05,  0.6209E-05,   &
      0.3844E-05/
  DATA ((h21(ip,iw,1),iw=1,31),ip=26,26)/                               &
      0.3976E-05,  0.7932E-05,  0.1582E-04,  0.3154E-04,  0.6284E-04,   &
      0.1250E-03,  0.2479E-03,  0.4896E-03,  0.9592E-03,  0.1857E-02,   &
      0.3532E-02,  0.6558E-02,  0.1181E-01,  0.2048E-01,  0.3402E-01,   &
      0.5399E-01,  0.8188E-01,  0.1190E+00,  0.1664E+00,  0.2243E+00,   &
      0.2933E+00,  0.3747E+00,  0.4695E+00,  0.5755E+00,  0.6858E+00,   &
      0.7903E+00,  0.8773E+00,  0.9391E+00,  0.9758E+00,  0.9934E+00,   &
      0.9996E+00/
  DATA ((h22(ip,iw,1),iw=1,31),ip=26,26)/                               &
      -0.5954E-07, -0.1187E-06, -0.2366E-06, -0.4709E-06, -0.9349E-06,  &
      -0.1849E-05, -0.3632E-05, -0.7058E-05, -0.1350E-04, -0.2521E-04,  &
      -0.4564E-04, -0.7958E-04, -0.1329E-03, -0.2114E-03, -0.3200E-03,  &
      -0.4611E-03, -0.6353E-03, -0.8409E-03, -0.1072E-02, -0.1324E-02,  &
      -0.1592E-02, -0.1871E-02, -0.2127E-02, -0.2297E-02, -0.2312E-02,  &
      -0.2123E-02, -0.1738E-02, -0.1247E-02, -0.7744E-03, -0.4117E-03,  &
      -0.1850E-03/
  DATA ((h23(ip,iw,1),iw=1,31),ip=26,26)/                               &
      -0.2522E-09, -0.5025E-09, -0.9997E-09, -0.1983E-08, -0.3912E-08,  &
      -0.7650E-08, -0.1474E-07, -0.2777E-07, -0.5055E-07, -0.8745E-07,  &
      -0.1414E-06, -0.2095E-06, -0.2790E-06, -0.3241E-06, -0.3135E-06,  &
      -0.2269E-06, -0.5896E-07,  0.1875E-06,  0.4996E-06,  0.8299E-06,  &
      0.1115E-05,  0.1467E-05,  0.2236E-05,  0.3672E-05,  0.5668E-05,   &
      0.7772E-05,  0.9094E-05,  0.8827E-05,  0.7041E-05,  0.4638E-05,   &
      0.2539E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      0.1342E-04,  0.2640E-04,  0.5137E-04,  0.9829E-04,  0.1832E-03,   &
      0.3284E-03,  0.5585E-03,  0.8907E-03,  0.1327E-02,  0.1856E-02,   &
      0.2461E-02,  0.3138E-02,  0.3898E-02,  0.4766E-02,  0.5783E-02,   &
      0.7007E-02,  0.8521E-02,  0.1041E-01,  0.1278E-01,  0.1570E-01,   &
      0.1928E-01,  0.2361E-01,  0.2884E-01,  0.3520E-01,  0.4305E-01,   &
      0.5286E-01,  0.6531E-01,  0.8127E-01,  0.1019E+00,  0.1287E+00,   &
      0.1632E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      -0.5685E-08, -0.1331E-07, -0.3249E-07, -0.8137E-07, -0.2048E-06,  &
      -0.4973E-06, -0.1118E-05, -0.2246E-05, -0.3982E-05, -0.6290E-05,  &
      -0.9040E-05, -0.1215E-04, -0.1567E-04, -0.1970E-04, -0.2449E-04,  &
      -0.3046E-04, -0.3798E-04, -0.4725E-04, -0.5831E-04, -0.7123E-04,  &
      -0.8605E-04, -0.1028E-03, -0.1212E-03, -0.1413E-03, -0.1635E-03,  &
      -0.1884E-03, -0.2160E-03, -0.2461E-03, -0.2778E-03, -0.3098E-03,  &
      -0.3411E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 1, 1)/                               &
      0.2169E-10,  0.5237E-10,  0.1296E-09,  0.3204E-09,  0.7665E-09,   &
      0.1691E-08,  0.3222E-08,  0.5110E-08,  0.6779E-08,  0.7681E-08,   &
      0.7378E-08,  0.5836E-08,  0.3191E-08, -0.1491E-08, -0.1022E-07,   &
      -0.2359E-07, -0.3957E-07, -0.5553E-07, -0.6927E-07, -0.7849E-07,  &
      -0.8139E-07, -0.7853E-07, -0.7368E-07, -0.7220E-07, -0.7780E-07,  &
      -0.9091E-07, -0.1038E-06, -0.9929E-07, -0.5422E-07,  0.5379E-07,  &
      0.2350E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      0.1342E-04,  0.2640E-04,  0.5137E-04,  0.9829E-04,  0.1832E-03,   &
      0.3284E-03,  0.5586E-03,  0.8908E-03,  0.1327E-02,  0.1856E-02,   &
      0.2462E-02,  0.3140E-02,  0.3902E-02,  0.4774E-02,  0.5797E-02,   &
      0.7033E-02,  0.8570E-02,  0.1050E-01,  0.1294E-01,  0.1599E-01,   &
      0.1979E-01,  0.2448E-01,  0.3024E-01,  0.3738E-01,  0.4633E-01,   &
      0.5766E-01,  0.7218E-01,  0.9096E-01,  0.1154E+00,  0.1471E+00,   &
      0.1880E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      -0.5684E-08, -0.1331E-07, -0.3248E-07, -0.8133E-07, -0.2047E-06,  &
      -0.4971E-06, -0.1117E-05, -0.2245E-05, -0.3981E-05, -0.6287E-05,  &
      -0.9035E-05, -0.1215E-04, -0.1565E-04, -0.1967E-04, -0.2444E-04,  &
      -0.3036E-04, -0.3780E-04, -0.4694E-04, -0.5779E-04, -0.7042E-04,  &
      -0.8491E-04, -0.1013E-03, -0.1196E-03, -0.1399E-03, -0.1625E-03,  &
      -0.1879E-03, -0.2163E-03, -0.2474E-03, -0.2803E-03, -0.3140E-03,  &
      -0.3478E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 2, 2)/                               &
      0.2168E-10,  0.5242E-10,  0.1295E-09,  0.3201E-09,  0.7662E-09,   &
      0.1690E-08,  0.3220E-08,  0.5106E-08,  0.6776E-08,  0.7673E-08,   &
      0.7362E-08,  0.5808E-08,  0.3138E-08, -0.1595E-08, -0.1041E-07,   &
      -0.2390E-07, -0.4010E-07, -0.5636E-07, -0.7045E-07, -0.7972E-07,  &
      -0.8178E-07, -0.7677E-07, -0.6876E-07, -0.6381E-07, -0.6583E-07,  &
      -0.7486E-07, -0.8229E-07, -0.7017E-07, -0.1497E-07,  0.1051E-06,  &
      0.2990E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      0.1342E-04,  0.2640E-04,  0.5137E-04,  0.9830E-04,  0.1832E-03,   &
      0.3285E-03,  0.5587E-03,  0.8911E-03,  0.1328E-02,  0.1857E-02,   &
      0.2465E-02,  0.3144E-02,  0.3909E-02,  0.4787E-02,  0.5820E-02,   &
      0.7075E-02,  0.8646E-02,  0.1064E-01,  0.1319E-01,  0.1643E-01,   &
      0.2053E-01,  0.2569E-01,  0.3215E-01,  0.4028E-01,  0.5059E-01,   &
      0.6380E-01,  0.8088E-01,  0.1031E+00,  0.1321E+00,  0.1698E+00,   &
      0.2179E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      -0.5682E-08, -0.1330E-07, -0.3247E-07, -0.8129E-07, -0.2046E-06,  &
      -0.4968E-06, -0.1117E-05, -0.2244E-05, -0.3978E-05, -0.6283E-05,  &
      -0.9027E-05, -0.1213E-04, -0.1563E-04, -0.1963E-04, -0.2436E-04,  &
      -0.3021E-04, -0.3754E-04, -0.4649E-04, -0.5709E-04, -0.6940E-04,  &
      -0.8359E-04, -0.9986E-04, -0.1182E-03, -0.1388E-03, -0.1620E-03,  &
      -0.1882E-03, -0.2175E-03, -0.2498E-03, -0.2843E-03, -0.3203E-03,  &
      -0.3573E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 3, 3)/                               &
      0.2167E-10,  0.5238E-10,  0.1294E-09,  0.3198E-09,  0.7656E-09,   &
      0.1688E-08,  0.3217E-08,  0.5104E-08,  0.6767E-08,  0.7661E-08,   &
      0.7337E-08,  0.5764E-08,  0.3051E-08, -0.1752E-08, -0.1068E-07,   &
      -0.2436E-07, -0.4081E-07, -0.5740E-07, -0.7165E-07, -0.8046E-07,  &
      -0.8082E-07, -0.7289E-07, -0.6141E-07, -0.5294E-07, -0.5134E-07,  &
      -0.5552E-07, -0.5609E-07, -0.3464E-07,  0.3275E-07,  0.1669E-06,  &
      0.3745E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      0.1342E-04,  0.2640E-04,  0.5138E-04,  0.9830E-04,  0.1832E-03,   &
      0.3286E-03,  0.5589E-03,  0.8915E-03,  0.1329E-02,  0.1859E-02,   &
      0.2468E-02,  0.3150E-02,  0.3920E-02,  0.4806E-02,  0.5855E-02,   &
      0.7140E-02,  0.8763E-02,  0.1085E-01,  0.1356E-01,  0.1707E-01,   &
      0.2158E-01,  0.2736E-01,  0.3471E-01,  0.4407E-01,  0.5608E-01,   &
      0.7161E-01,  0.9184E-01,  0.1183E+00,  0.1528E+00,  0.1973E+00,   &
      0.2537E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      -0.5680E-08, -0.1329E-07, -0.3243E-07, -0.8121E-07, -0.2044E-06,  &
      -0.4963E-06, -0.1115E-05, -0.2242E-05, -0.3974E-05, -0.6276E-05,  &
      -0.9015E-05, -0.1211E-04, -0.1559E-04, -0.1956E-04, -0.2423E-04,  &
      -0.2999E-04, -0.3716E-04, -0.4588E-04, -0.5618E-04, -0.6818E-04,  &
      -0.8218E-04, -0.9847E-04, -0.1171E-03, -0.1382E-03, -0.1621E-03,  &
      -0.1892E-03, -0.2197E-03, -0.2535E-03, -0.2902E-03, -0.3293E-03,  &
      -0.3700E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 4, 4)/                               &
      0.2166E-10,  0.5229E-10,  0.1294E-09,  0.3193E-09,  0.7644E-09,   &
      0.1686E-08,  0.3213E-08,  0.5092E-08,  0.6753E-08,  0.7640E-08,   &
      0.7302E-08,  0.5696E-08,  0.2917E-08, -0.1984E-08, -0.1108E-07,   &
      -0.2497E-07, -0.4171E-07, -0.5849E-07, -0.7254E-07, -0.8017E-07,  &
      -0.7802E-07, -0.6662E-07, -0.5153E-07, -0.3961E-07, -0.3387E-07,  &
      -0.3219E-07, -0.2426E-07,  0.8700E-08,  0.9027E-07,  0.2400E-06,  &
      0.4623E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      0.1342E-04,  0.2640E-04,  0.5138E-04,  0.9832E-04,  0.1833E-03,   &
      0.3287E-03,  0.5591E-03,  0.8922E-03,  0.1330E-02,  0.1862E-02,   &
      0.2473E-02,  0.3159E-02,  0.3937E-02,  0.4837E-02,  0.5911E-02,   &
      0.7240E-02,  0.8943E-02,  0.1117E-01,  0.1411E-01,  0.1798E-01,   &
      0.2304E-01,  0.2961E-01,  0.3807E-01,  0.4896E-01,  0.6308E-01,   &
      0.8148E-01,  0.1056E+00,  0.1371E+00,  0.1780E+00,  0.2303E+00,   &
      0.2958E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      -0.5675E-08, -0.1328E-07, -0.3239E-07, -0.8110E-07, -0.2040E-06,  &
      -0.4954E-06, -0.1114E-05, -0.2238E-05, -0.3968E-05, -0.6265E-05,  &
      -0.8996E-05, -0.1208E-04, -0.1553E-04, -0.1945E-04, -0.2404E-04,  &
      -0.2966E-04, -0.3663E-04, -0.4508E-04, -0.5508E-04, -0.6686E-04,  &
      -0.8082E-04, -0.9732E-04, -0.1165E-03, -0.1382E-03, -0.1630E-03,  &
      -0.1913E-03, -0.2234E-03, -0.2593E-03, -0.2989E-03, -0.3417E-03,  &
      -0.3857E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 5, 5)/                               &
      0.2163E-10,  0.5209E-10,  0.1291E-09,  0.3186E-09,  0.7626E-09,   &
      0.1682E-08,  0.3203E-08,  0.5078E-08,  0.6730E-08,  0.7606E-08,   &
      0.7246E-08,  0.5592E-08,  0.2735E-08, -0.2325E-08, -0.1162E-07,   &
      -0.2576E-07, -0.4268E-07, -0.5938E-07, -0.7262E-07, -0.7827E-07,  &
      -0.7297E-07, -0.5786E-07, -0.3930E-07, -0.2373E-07, -0.1295E-07,  &
      -0.3728E-08,  0.1465E-07,  0.6114E-07,  0.1590E-06,  0.3257E-06,  &
      0.5622E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      0.1342E-04,  0.2640E-04,  0.5139E-04,  0.9834E-04,  0.1833E-03,   &
      0.3288E-03,  0.5596E-03,  0.8932E-03,  0.1332E-02,  0.1866E-02,   &
      0.2481E-02,  0.3174E-02,  0.3963E-02,  0.4885E-02,  0.5997E-02,   &
      0.7394E-02,  0.9215E-02,  0.1164E-01,  0.1489E-01,  0.1924E-01,   &
      0.2501E-01,  0.3258E-01,  0.4243E-01,  0.5523E-01,  0.7195E-01,   &
      0.9387E-01,  0.1226E+00,  0.1601E+00,  0.2084E+00,  0.2695E+00,   &
      0.3446E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      -0.5671E-08, -0.1326E-07, -0.3234E-07, -0.8091E-07, -0.2035E-06,  &
      -0.4941E-06, -0.1111E-05, -0.2232E-05, -0.3958E-05, -0.6247E-05,  &
      -0.8966E-05, -0.1202E-04, -0.1544E-04, -0.1929E-04, -0.2377E-04,  &
      -0.2921E-04, -0.3593E-04, -0.4409E-04, -0.5385E-04, -0.6555E-04,  &
      -0.7965E-04, -0.9656E-04, -0.1163E-03, -0.1390E-03, -0.1649E-03,  &
      -0.1947E-03, -0.2288E-03, -0.2675E-03, -0.3109E-03, -0.3575E-03,  &
      -0.4039E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 6, 6)/                               &
      0.2155E-10,  0.5188E-10,  0.1288E-09,  0.3175E-09,  0.7599E-09,   &
      0.1675E-08,  0.3190E-08,  0.5059E-08,  0.6699E-08,  0.7551E-08,   &
      0.7154E-08,  0.5435E-08,  0.2452E-08, -0.2802E-08, -0.1235E-07,   &
      -0.2668E-07, -0.4353E-07, -0.5962E-07, -0.7134E-07, -0.7435E-07,  &
      -0.6551E-07, -0.4676E-07, -0.2475E-07, -0.4876E-08,  0.1235E-07,  &
      0.3092E-07,  0.6192E-07,  0.1243E-06,  0.2400E-06,  0.4247E-06,   &
      0.6755E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      0.1342E-04,  0.2640E-04,  0.5139E-04,  0.9837E-04,  0.1834E-03,   &
      0.3291E-03,  0.5603E-03,  0.8949E-03,  0.1336E-02,  0.1873E-02,   &
      0.2494E-02,  0.3198E-02,  0.4005E-02,  0.4960E-02,  0.6130E-02,   &
      0.7628E-02,  0.9618E-02,  0.1232E-01,  0.1599E-01,  0.2097E-01,   &
      0.2764E-01,  0.3646E-01,  0.4803E-01,  0.6319E-01,  0.8312E-01,   &
      0.1093E+00,  0.1436E+00,  0.1881E+00,  0.2448E+00,  0.3153E+00,   &
      0.4001E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      -0.5665E-08, -0.1322E-07, -0.3224E-07, -0.8063E-07, -0.2027E-06,  &
      -0.4921E-06, -0.1106E-05, -0.2223E-05, -0.3942E-05, -0.6220E-05,  &
      -0.8920E-05, -0.1194E-04, -0.1530E-04, -0.1905E-04, -0.2337E-04,  &
      -0.2860E-04, -0.3505E-04, -0.4296E-04, -0.5259E-04, -0.6439E-04,  &
      -0.7884E-04, -0.9635E-04, -0.1170E-03, -0.1407E-03, -0.1681E-03,  &
      -0.1998E-03, -0.2366E-03, -0.2790E-03, -0.3265E-03, -0.3763E-03,  &
      -0.4235E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 7, 7)/                               &
      0.2157E-10,  0.5178E-10,  0.1283E-09,  0.3162E-09,  0.7558E-09,   &
      0.1665E-08,  0.3169E-08,  0.5027E-08,  0.6645E-08,  0.7472E-08,   &
      0.7017E-08,  0.5212E-08,  0.2059E-08, -0.3443E-08, -0.1321E-07,   &
      -0.2754E-07, -0.4389E-07, -0.5869E-07, -0.6825E-07, -0.6819E-07,  &
      -0.5570E-07, -0.3343E-07, -0.7592E-08,  0.1778E-07,  0.4322E-07,  &
      0.7330E-07,  0.1190E-06,  0.1993E-06,  0.3348E-06,  0.5376E-06,   &
      0.8030E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      0.1342E-04,  0.2641E-04,  0.5141E-04,  0.9842E-04,  0.1836E-03,   &
      0.3295E-03,  0.5614E-03,  0.8975E-03,  0.1341E-02,  0.1884E-02,   &
      0.2514E-02,  0.3234E-02,  0.4071E-02,  0.5075E-02,  0.6332E-02,   &
      0.7976E-02,  0.1021E-01,  0.1328E-01,  0.1751E-01,  0.2329E-01,   &
      0.3109E-01,  0.4146E-01,  0.5517E-01,  0.7325E-01,  0.9710E-01,   &
      0.1284E+00,  0.1693E+00,  0.2217E+00,  0.2876E+00,  0.3679E+00,   &
      0.4616E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      -0.5652E-08, -0.1318E-07, -0.3210E-07, -0.8018E-07, -0.2014E-06,  &
      -0.4888E-06, -0.1099E-05, -0.2210E-05, -0.3918E-05, -0.6179E-05,  &
      -0.8849E-05, -0.1182E-04, -0.1509E-04, -0.1871E-04, -0.2284E-04,  &
      -0.2782E-04, -0.3403E-04, -0.4177E-04, -0.5145E-04, -0.6354E-04,  &
      -0.7853E-04, -0.9681E-04, -0.1185E-03, -0.1437E-03, -0.1729E-03,  &
      -0.2072E-03, -0.2475E-03, -0.2942E-03, -0.3457E-03, -0.3973E-03,  &
      -0.4434E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 8, 8)/                               &
      0.2153E-10,  0.5151E-10,  0.1273E-09,  0.3136E-09,  0.7488E-09,   &
      0.1649E-08,  0.3142E-08,  0.4980E-08,  0.6559E-08,  0.7346E-08,   &
      0.6813E-08,  0.4884E-08,  0.1533E-08, -0.4209E-08, -0.1409E-07,   &
      -0.2801E-07, -0.4320E-07, -0.5614E-07, -0.6312E-07, -0.5976E-07,  &
      -0.4369E-07, -0.1775E-07,  0.1280E-07,  0.4534E-07,  0.8106E-07,  &
      0.1246E-06,  0.1874E-06,  0.2873E-06,  0.4433E-06,  0.6651E-06,   &
      0.9477E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      0.1342E-04,  0.2641E-04,  0.5143E-04,  0.9849E-04,  0.1838E-03,   &
      0.3302E-03,  0.5631E-03,  0.9016E-03,  0.1350E-02,  0.1901E-02,   &
      0.2546E-02,  0.3292E-02,  0.4171E-02,  0.5250E-02,  0.6634E-02,   &
      0.8486E-02,  0.1104E-01,  0.1460E-01,  0.1955E-01,  0.2635E-01,   &
      0.3555E-01,  0.4786E-01,  0.6421E-01,  0.8588E-01,  0.1145E+00,   &
      0.1519E+00,  0.2003E+00,  0.2615E+00,  0.3372E+00,  0.4269E+00,   &
      0.5281E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      -0.5629E-08, -0.1310E-07, -0.3186E-07, -0.7948E-07, -0.1995E-06,  &
      -0.4837E-06, -0.1088E-05, -0.2188E-05, -0.3880E-05, -0.6115E-05,  &
      -0.8743E-05, -0.1165E-04, -0.1480E-04, -0.1824E-04, -0.2216E-04,  &
      -0.2691E-04, -0.3293E-04, -0.4067E-04, -0.5057E-04, -0.6314E-04,  &
      -0.7885E-04, -0.9813E-04, -0.1212E-03, -0.1482E-03, -0.1799E-03,  &
      -0.2175E-03, -0.2622E-03, -0.3135E-03, -0.3678E-03, -0.4193E-03,  &
      -0.4627E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip= 9, 9)/                               &
      0.2121E-10,  0.5076E-10,  0.1257E-09,  0.3091E-09,  0.7379E-09,   &
      0.1623E-08,  0.3097E-08,  0.4904E-08,  0.6453E-08,  0.7168E-08,   &
      0.6534E-08,  0.4458E-08,  0.8932E-09, -0.5026E-08, -0.1469E-07,   &
      -0.2765E-07, -0.4103E-07, -0.5169E-07, -0.5585E-07, -0.4913E-07,  &
      -0.2954E-07,  0.6372E-09,  0.3738E-07,  0.7896E-07,  0.1272E-06,  &
      0.1867E-06,  0.2682E-06,  0.3895E-06,  0.5672E-06,  0.8091E-06,   &
      0.1114E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=10,10)/                               &
      0.1343E-04,  0.2642E-04,  0.5147E-04,  0.9861E-04,  0.1842E-03,   &
      0.3312E-03,  0.5658E-03,  0.9080E-03,  0.1364E-02,  0.1928E-02,   &
      0.2595E-02,  0.3379E-02,  0.4325E-02,  0.5513E-02,  0.7077E-02,   &
      0.9215E-02,  0.1220E-01,  0.1640E-01,  0.2226E-01,  0.3032E-01,   &
      0.4127E-01,  0.5598E-01,  0.7559E-01,  0.1016E+00,  0.1359E+00,   &
      0.1804E+00,  0.2372E+00,  0.3081E+00,  0.3935E+00,  0.4916E+00,   &
      0.5975E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=10,10)/                               &
      -0.5597E-08, -0.1300E-07, -0.3148E-07, -0.7838E-07, -0.1964E-06,  &
      -0.4759E-06, -0.1071E-05, -0.2155E-05, -0.3822E-05, -0.6019E-05,  &
      -0.8586E-05, -0.1139E-04, -0.1439E-04, -0.1764E-04, -0.2134E-04,  &
      -0.2591E-04, -0.3188E-04, -0.3978E-04, -0.5011E-04, -0.6334E-04,  &
      -0.7998E-04, -0.1006E-03, -0.1253E-03, -0.1547E-03, -0.1895E-03,  &
      -0.2315E-03, -0.2811E-03, -0.3363E-03, -0.3917E-03, -0.4413E-03,  &
      -0.4809E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=10,10)/                               &
      0.2109E-10,  0.5017E-10,  0.1235E-09,  0.3021E-09,  0.7217E-09,   &
      0.1585E-08,  0.3028E-08,  0.4796E-08,  0.6285E-08,  0.6910E-08,   &
      0.6178E-08,  0.3945E-08,  0.2436E-09, -0.5632E-08, -0.1464E-07,   &
      -0.2596E-07, -0.3707E-07, -0.4527E-07, -0.4651E-07, -0.3644E-07,  &
      -0.1296E-07,  0.2250E-07,  0.6722E-07,  0.1202E-06,  0.1831E-06,  &
      0.2605E-06,  0.3627E-06,  0.5062E-06,  0.7064E-06,  0.9725E-06,   &
      0.1304E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=11,11)/                               &
      0.1343E-04,  0.2644E-04,  0.5152E-04,  0.9878E-04,  0.1847E-03,   &
      0.3328E-03,  0.5701E-03,  0.9179E-03,  0.1385E-02,  0.1969E-02,   &
      0.2671E-02,  0.3513E-02,  0.4554E-02,  0.5900E-02,  0.7713E-02,   &
      0.1023E-01,  0.1379E-01,  0.1879E-01,  0.2578E-01,  0.3542E-01,   &
      0.4854E-01,  0.6622E-01,  0.8983E-01,  0.1211E+00,  0.1619E+00,   &
      0.2145E+00,  0.2807E+00,  0.3614E+00,  0.4559E+00,  0.5603E+00,   &
      0.6675E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=11,11)/                               &
      -0.5538E-08, -0.1280E-07, -0.3089E-07, -0.7667E-07, -0.1917E-06,  &
      -0.4642E-06, -0.1045E-05, -0.2106E-05, -0.3736E-05, -0.5878E-05,  &
      -0.8363E-05, -0.1104E-04, -0.1387E-04, -0.1692E-04, -0.2044E-04,  &
      -0.2493E-04, -0.3101E-04, -0.3926E-04, -0.5020E-04, -0.6429E-04,  &
      -0.8213E-04, -0.1044E-03, -0.1314E-03, -0.1637E-03, -0.2027E-03,  &
      -0.2498E-03, -0.3042E-03, -0.3617E-03, -0.4163E-03, -0.4625E-03,  &
      -0.4969E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=11,11)/                               &
      0.2067E-10,  0.4903E-10,  0.1200E-09,  0.2917E-09,  0.6965E-09,   &
      0.1532E-08,  0.2925E-08,  0.4632E-08,  0.6054E-08,  0.6590E-08,   &
      0.5746E-08,  0.3436E-08, -0.2251E-09, -0.5703E-08, -0.1344E-07,   &
      -0.2256E-07, -0.3120E-07, -0.3690E-07, -0.3520E-07, -0.2164E-07,  &
      0.6510E-08,  0.4895E-07,  0.1037E-06,  0.1702E-06,  0.2502E-06,   &
      0.3472E-06,  0.4710E-06,  0.6379E-06,  0.8633E-06,  0.1159E-05,   &
      0.1514E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=12,12)/                               &
      0.1344E-04,  0.2647E-04,  0.5161E-04,  0.9906E-04,  0.1856E-03,   &
      0.3353E-03,  0.5765E-03,  0.9331E-03,  0.1417E-02,  0.2032E-02,   &
      0.2785E-02,  0.3712E-02,  0.4892E-02,  0.6456E-02,  0.8604E-02,   &
      0.1162E-01,  0.1590E-01,  0.2192E-01,  0.3033E-01,  0.4193E-01,   &
      0.5774E-01,  0.7906E-01,  0.1075E+00,  0.1449E+00,  0.1934E+00,   &
      0.2549E+00,  0.3309E+00,  0.4213E+00,  0.5232E+00,  0.6308E+00,   &
      0.7348E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=12,12)/                               &
      -0.5476E-08, -0.1257E-07, -0.3008E-07, -0.7418E-07, -0.1848E-06,  &
      -0.4468E-06, -0.1006E-05, -0.2032E-05, -0.3611E-05, -0.5679E-05,  &
      -0.8058E-05, -0.1059E-04, -0.1324E-04, -0.1612E-04, -0.1956E-04,  &
      -0.2411E-04, -0.3046E-04, -0.3925E-04, -0.5098E-04, -0.6619E-04,  &
      -0.8562E-04, -0.1100E-03, -0.1399E-03, -0.1761E-03, -0.2202E-03,  &
      -0.2726E-03, -0.3306E-03, -0.3885E-03, -0.4404E-03, -0.4820E-03,  &
      -0.5082E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=12,12)/                               &
      0.2041E-10,  0.4771E-10,  0.1149E-09,  0.2782E-09,  0.6614E-09,   &
      0.1451E-08,  0.2778E-08,  0.4401E-08,  0.5736E-08,  0.6189E-08,   &
      0.5315E-08,  0.3087E-08, -0.2518E-09, -0.4806E-08, -0.1071E-07,   &
      -0.1731E-07, -0.2346E-07, -0.2659E-07, -0.2184E-07, -0.4261E-08,  &
      0.2975E-07,  0.8112E-07,  0.1484E-06,  0.2308E-06,  0.3296E-06,   &
      0.4475E-06,  0.5942E-06,  0.7859E-06,  0.1041E-05,  0.1369E-05,   &
      0.1726E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=13,13)/                               &
      0.1345E-04,  0.2650E-04,  0.5173E-04,  0.9947E-04,  0.1868E-03,   &
      0.3389E-03,  0.5861E-03,  0.9559E-03,  0.1466E-02,  0.2125E-02,   &
      0.2955E-02,  0.4004E-02,  0.5376E-02,  0.7235E-02,  0.9824E-02,   &
      0.1348E-01,  0.1866E-01,  0.2596E-01,  0.3613E-01,  0.5016E-01,   &
      0.6929E-01,  0.9504E-01,  0.1292E+00,  0.1738E+00,  0.2309E+00,   &
      0.3021E+00,  0.3880E+00,  0.4868E+00,  0.5936E+00,  0.7003E+00,   &
      0.7964E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=13,13)/                               &
      -0.5362E-08, -0.1223E-07, -0.2895E-07, -0.7071E-07, -0.1748E-06,  &
      -0.4219E-06, -0.9516E-06, -0.1928E-05, -0.3436E-05, -0.5409E-05,  &
      -0.7666E-05, -0.1005E-04, -0.1254E-04, -0.1533E-04, -0.1880E-04,  &
      -0.2358E-04, -0.3038E-04, -0.3988E-04, -0.5264E-04, -0.6934E-04,  &
      -0.9083E-04, -0.1179E-03, -0.1515E-03, -0.1927E-03, -0.2424E-03,  &
      -0.2994E-03, -0.3591E-03, -0.4155E-03, -0.4634E-03, -0.4982E-03,  &
      -0.5096E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=13,13)/                               &
      0.1976E-10,  0.4551E-10,  0.1086E-09,  0.2601E-09,  0.6126E-09,   &
      0.1345E-08,  0.2583E-08,  0.4112E-08,  0.5365E-08,  0.5796E-08,   &
      0.5031E-08,  0.3182E-08,  0.5970E-09, -0.2547E-08, -0.6172E-08,   &
      -0.1017E-07, -0.1388E-07, -0.1430E-07, -0.6118E-08,  0.1624E-07,  &
      0.5791E-07,  0.1205E-06,  0.2025E-06,  0.3032E-06,  0.4225E-06,   &
      0.5619E-06,  0.7322E-06,  0.9528E-06,  0.1243E-05,  0.1592E-05,   &
      0.1904E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=14,14)/                               &
      0.1346E-04,  0.2655E-04,  0.5192E-04,  0.1001E-03,  0.1887E-03,   &
      0.3442E-03,  0.6001E-03,  0.9892E-03,  0.1536E-02,  0.2262E-02,   &
      0.3200E-02,  0.4420E-02,  0.6053E-02,  0.8300E-02,  0.1146E-01,   &
      0.1592E-01,  0.2224E-01,  0.3112E-01,  0.4348E-01,  0.6051E-01,   &
      0.8369E-01,  0.1147E+00,  0.1556E+00,  0.2084E+00,  0.2749E+00,   &
      0.3561E+00,  0.4511E+00,  0.5562E+00,  0.6644E+00,  0.7655E+00,   &
      0.8499E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=14,14)/                               &
      -0.5210E-08, -0.1172E-07, -0.2731E-07, -0.6598E-07, -0.1615E-06,  &
      -0.3880E-06, -0.8769E-06, -0.1787E-05, -0.3204E-05, -0.5066E-05,  &
      -0.7197E-05, -0.9451E-05, -0.1185E-04, -0.1465E-04, -0.1831E-04,  &
      -0.2346E-04, -0.3088E-04, -0.4132E-04, -0.5545E-04, -0.7410E-04,  &
      -0.9820E-04, -0.1288E-03, -0.1670E-03, -0.2140E-03, -0.2692E-03,  &
      -0.3293E-03, -0.3886E-03, -0.4417E-03, -0.4840E-03, -0.5073E-03,  &
      -0.4944E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=14,14)/                               &
      0.1880E-10,  0.4271E-10,  0.9966E-10,  0.2352E-09,  0.5497E-09,   &
      0.1205E-08,  0.2334E-08,  0.3765E-08,  0.4993E-08,  0.5532E-08,   &
      0.5148E-08,  0.4055E-08,  0.2650E-08,  0.1326E-08,  0.2019E-09,   &
      -0.1124E-08, -0.2234E-08,  0.2827E-09,  0.1247E-07,  0.4102E-07,  &
      0.9228E-07,  0.1682E-06,  0.2676E-06,  0.3885E-06,  0.5286E-06,   &
      0.6904E-06,  0.8871E-06,  0.1142E-05,  0.1466E-05,  0.1800E-05,   &
      0.2004E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=15,15)/                               &
      0.1348E-04,  0.2663E-04,  0.5216E-04,  0.1009E-03,  0.1912E-03,   &
      0.3515E-03,  0.6196E-03,  0.1036E-02,  0.1637E-02,  0.2456E-02,   &
      0.3544E-02,  0.4996E-02,  0.6973E-02,  0.9722E-02,  0.1360E-01,   &
      0.1908E-01,  0.2681E-01,  0.3766E-01,  0.5272E-01,  0.7343E-01,   &
      0.1015E+00,  0.1388E+00,  0.1874E+00,  0.2492E+00,  0.3257E+00,   &
      0.4165E+00,  0.5191E+00,  0.6275E+00,  0.7324E+00,  0.8235E+00,   &
      0.8939E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=15,15)/                               &
      -0.5045E-08, -0.1113E-07, -0.2540E-07, -0.6008E-07, -0.1449E-06,  &
      -0.3457E-06, -0.7826E-06, -0.1609E-05, -0.2920E-05, -0.4665E-05,  &
      -0.6691E-05, -0.8868E-05, -0.1127E-04, -0.1422E-04, -0.1820E-04,  &
      -0.2389E-04, -0.3213E-04, -0.4380E-04, -0.5975E-04, -0.8092E-04,  &
      -0.1083E-03, -0.1433E-03, -0.1873E-03, -0.2402E-03, -0.2997E-03,  &
      -0.3607E-03, -0.4178E-03, -0.4662E-03, -0.4994E-03, -0.5028E-03,  &
      -0.4563E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=15,15)/                               &
      0.1804E-10,  0.3983E-10,  0.9045E-10,  0.2080E-09,  0.4786E-09,   &
      0.1046E-08,  0.2052E-08,  0.3413E-08,  0.4704E-08,  0.5565E-08,   &
      0.5887E-08,  0.5981E-08,  0.6202E-08,  0.6998E-08,  0.8493E-08,   &
      0.1002E-07,  0.1184E-07,  0.1780E-07,  0.3483E-07,  0.7122E-07,   &
      0.1341E-06,  0.2259E-06,  0.3446E-06,  0.4866E-06,  0.6486E-06,   &
      0.8343E-06,  0.1063E-05,  0.1356E-05,  0.1690E-05,  0.1951E-05,   &
      0.2005E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=16,16)/                               &
      0.1351E-04,  0.2672E-04,  0.5247E-04,  0.1019E-03,  0.1944E-03,   &
      0.3609E-03,  0.6451E-03,  0.1098E-02,  0.1772E-02,  0.2718E-02,   &
      0.4009E-02,  0.5767E-02,  0.8190E-02,  0.1158E-01,  0.1636E-01,   &
      0.2311E-01,  0.3260E-01,  0.4586E-01,  0.6425E-01,  0.8940E-01,   &
      0.1232E+00,  0.1678E+00,  0.2251E+00,  0.2967E+00,  0.3831E+00,   &
      0.4825E+00,  0.5901E+00,  0.6976E+00,  0.7946E+00,  0.8725E+00,   &
      0.9285E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=16,16)/                               &
      -0.4850E-08, -0.1045E-07, -0.2334E-07, -0.5367E-07, -0.1265E-06,  &
      -0.2980E-06, -0.6750E-06, -0.1406E-05, -0.2601E-05, -0.4239E-05,  &
      -0.6201E-05, -0.8389E-05, -0.1091E-04, -0.1413E-04, -0.1859E-04,  &
      -0.2500E-04, -0.3432E-04, -0.4761E-04, -0.6595E-04, -0.9030E-04,  &
      -0.1219E-03, -0.1624E-03, -0.2126E-03, -0.2708E-03, -0.3327E-03,  &
      -0.3926E-03, -0.4458E-03, -0.4871E-03, -0.5045E-03, -0.4777E-03,  &
      -0.3954E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=16,16)/                               &
      0.1717E-10,  0.3723E-10,  0.8093E-10,  0.1817E-09,  0.4100E-09,   &
      0.8932E-09,  0.1791E-08,  0.3126E-08,  0.4634E-08,  0.6095E-08,   &
      0.7497E-08,  0.9170E-08,  0.1136E-07,  0.1453E-07,  0.1892E-07,   &
      0.2369E-07,  0.2909E-07,  0.3922E-07,  0.6232E-07,  0.1083E-06,   &
      0.1847E-06,  0.2943E-06,  0.4336E-06,  0.5970E-06,  0.7815E-06,   &
      0.9959E-06,  0.1263E-05,  0.1583E-05,  0.1880E-05,  0.2009E-05,   &
      0.1914E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=17,17)/                               &
      0.1353E-04,  0.2681E-04,  0.5283E-04,  0.1031E-03,  0.1981E-03,   &
      0.3721E-03,  0.6761E-03,  0.1176E-02,  0.1943E-02,  0.3055E-02,   &
      0.4612E-02,  0.6766E-02,  0.9760E-02,  0.1396E-01,  0.1986E-01,   &
      0.2818E-01,  0.3984E-01,  0.5609E-01,  0.7850E-01,  0.1090E+00,   &
      0.1495E+00,  0.2023E+00,  0.2691E+00,  0.3508E+00,  0.4465E+00,   &
      0.5524E+00,  0.6613E+00,  0.7633E+00,  0.8485E+00,  0.9119E+00,   &
      0.9543E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=17,17)/                               &
      -0.4673E-08, -0.9862E-08, -0.2135E-07, -0.4753E-07, -0.1087E-06,  &
      -0.2512E-06, -0.5671E-06, -0.1199E-05, -0.2281E-05, -0.3842E-05,  &
      -0.5804E-05, -0.8110E-05, -0.1088E-04, -0.1452E-04, -0.1961E-04,  &
      -0.2696E-04, -0.3768E-04, -0.5311E-04, -0.7444E-04, -0.1028E-03,  &
      -0.1397E-03, -0.1865E-03, -0.2427E-03, -0.3047E-03, -0.3667E-03,  &
      -0.4237E-03, -0.4712E-03, -0.5003E-03, -0.4921E-03, -0.4286E-03,  &
      -0.3188E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=17,17)/                               &
      0.1653E-10,  0.3436E-10,  0.7431E-10,  0.1605E-09,  0.3548E-09,   &
      0.7723E-09,  0.1595E-08,  0.2966E-08,  0.4849E-08,  0.7169E-08,   &
      0.1003E-07,  0.1366E-07,  0.1825E-07,  0.2419E-07,  0.3186E-07,   &
      0.4068E-07,  0.5064E-07,  0.6618E-07,  0.9684E-07,  0.1536E-06,   &
      0.2450E-06,  0.3730E-06,  0.5328E-06,  0.7184E-06,  0.9291E-06,   &
      0.1180E-05,  0.1484E-05,  0.1798E-05,  0.1992E-05,  0.1968E-05,   &
      0.1736E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=18,18)/                               &
      0.1356E-04,  0.2691E-04,  0.5318E-04,  0.1043E-03,  0.2020E-03,   &
      0.3841E-03,  0.7100E-03,  0.1263E-02,  0.2144E-02,  0.3464E-02,   &
      0.5359E-02,  0.8019E-02,  0.1174E-01,  0.1694E-01,  0.2426E-01,   &
      0.3451E-01,  0.4883E-01,  0.6870E-01,  0.9593E-01,  0.1326E+00,   &
      0.1809E+00,  0.2428E+00,  0.3196E+00,  0.4112E+00,  0.5147E+00,   &
      0.6239E+00,  0.7297E+00,  0.8217E+00,  0.8928E+00,  0.9421E+00,   &
      0.9726E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=18,18)/                               &
      -0.4532E-08, -0.9395E-08, -0.1978E-07, -0.4272E-07, -0.9442E-07,  &
      -0.2124E-06, -0.4747E-06, -0.1017E-05, -0.2003E-05, -0.3524E-05,  &
      -0.5567E-05, -0.8108E-05, -0.1127E-04, -0.1547E-04, -0.2138E-04,  &
      -0.2996E-04, -0.4251E-04, -0.6059E-04, -0.8563E-04, -0.1190E-03,  &
      -0.1623E-03, -0.2156E-03, -0.2767E-03, -0.3403E-03, -0.4006E-03,  &
      -0.4530E-03, -0.4912E-03, -0.4995E-03, -0.4563E-03, -0.3592E-03,  &
      -0.2383E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=18,18)/                               &
      0.1593E-10,  0.3276E-10,  0.6896E-10,  0.1476E-09,  0.3190E-09,   &
      0.6944E-09,  0.1474E-08,  0.2935E-08,  0.5300E-08,  0.8697E-08,   &
      0.1336E-07,  0.1946E-07,  0.2707E-07,  0.3637E-07,  0.4800E-07,   &
      0.6187E-07,  0.7806E-07,  0.1008E-06,  0.1404E-06,  0.2089E-06,   &
      0.3153E-06,  0.4613E-06,  0.6416E-06,  0.8506E-06,  0.1095E-05,   &
      0.1387E-05,  0.1708E-05,  0.1956E-05,  0.2003E-05,  0.1836E-05,   &
      0.1483E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=19,19)/                               &
      0.1358E-04,  0.2700E-04,  0.5350E-04,  0.1054E-03,  0.2057E-03,   &
      0.3955E-03,  0.7434E-03,  0.1353E-02,  0.2361E-02,  0.3928E-02,   &
      0.6237E-02,  0.9531E-02,  0.1416E-01,  0.2063E-01,  0.2968E-01,   &
      0.4233E-01,  0.5990E-01,  0.8412E-01,  0.1170E+00,  0.1608E+00,   &
      0.2177E+00,  0.2894E+00,  0.3764E+00,  0.4768E+00,  0.5855E+00,   &
      0.6941E+00,  0.7921E+00,  0.8710E+00,  0.9276E+00,  0.9641E+00,   &
      0.9846E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=19,19)/                               &
      -0.4448E-08, -0.9085E-08, -0.1877E-07, -0.3946E-07, -0.8472E-07,  &
      -0.1852E-06, -0.4074E-06, -0.8791E-06, -0.1789E-05, -0.3314E-05,  &
      -0.5521E-05, -0.8425E-05, -0.1215E-04, -0.1711E-04, -0.2407E-04,  &
      -0.3421E-04, -0.4905E-04, -0.7032E-04, -0.9985E-04, -0.1394E-03,  &
      -0.1897E-03, -0.2491E-03, -0.3132E-03, -0.3763E-03, -0.4332E-03,  &
      -0.4786E-03, -0.5005E-03, -0.4775E-03, -0.3970E-03, -0.2794E-03,  &
      -0.1652E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=19,19)/                               &
      0.1566E-10,  0.3219E-10,  0.6635E-10,  0.1400E-09,  0.2999E-09,   &
      0.6513E-09,  0.1406E-08,  0.2953E-08,  0.5789E-08,  0.1037E-07,   &
      0.1709E-07,  0.2623E-07,  0.3777E-07,  0.5159E-07,  0.6823E-07,   &
      0.8864E-07,  0.1134E-06,  0.1461E-06,  0.1960E-06,  0.2761E-06,   &
      0.3962E-06,  0.5583E-06,  0.7580E-06,  0.9957E-06,  0.1282E-05,   &
      0.1607E-05,  0.1898E-05,  0.2020E-05,  0.1919E-05,  0.1623E-05,   &
      0.1171E-05/
  DATA ((h71(ip,iw,1),iw=1,31),ip=20,20)/                               &
      0.1360E-04,  0.2707E-04,  0.5375E-04,  0.1063E-03,  0.2087E-03,   &
      0.4052E-03,  0.7731E-03,  0.1437E-02,  0.2575E-02,  0.4414E-02,   &
      0.7212E-02,  0.1128E-01,  0.1704E-01,  0.2509E-01,  0.3631E-01,   &
      0.5188E-01,  0.7338E-01,  0.1028E+00,  0.1422E+00,  0.1940E+00,   &
      0.2603E+00,  0.3422E+00,  0.4387E+00,  0.5459E+00,  0.6563E+00,   &
      0.7597E+00,  0.8461E+00,  0.9105E+00,  0.9536E+00,  0.9791E+00,   &
      0.9920E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=20,20)/                               &
      -0.4403E-08, -0.8896E-08, -0.1818E-07, -0.3751E-07, -0.7880E-07,  &
      -0.1683E-06, -0.3640E-06, -0.7852E-06, -0.1640E-05, -0.3191E-05,  &
      -0.5634E-05, -0.9046E-05, -0.1355E-04, -0.1953E-04, -0.2786E-04,  &
      -0.3995E-04, -0.5752E-04, -0.8256E-04, -0.1174E-03, -0.1638E-03,  &
      -0.2211E-03, -0.2854E-03, -0.3507E-03, -0.4116E-03, -0.4633E-03,  &
      -0.4966E-03, -0.4921E-03, -0.4309E-03, -0.3215E-03, -0.2016E-03,  &
      -0.1061E-03/
  DATA ((h73(ip,iw,1),iw=1,31),ip=20,20)/                               &
      0.1551E-10,  0.3147E-10,  0.6419E-10,  0.1356E-09,  0.2860E-09,   &
      0.6178E-09,  0.1353E-08,  0.2934E-08,  0.6095E-08,  0.1174E-07,   &
      0.2067E-07,  0.3346E-07,  0.5014E-07,  0.7024E-07,  0.9377E-07,   &
      0.1226E-06,  0.1592E-06,  0.2056E-06,  0.2678E-06,  0.3584E-06,   &
      0.4892E-06,  0.6651E-06,  0.8859E-06,  0.1160E-05,  0.1488E-05,   &
      0.1814E-05,  0.2010E-05,  0.1984E-05,  0.1748E-05,  0.1338E-05,   &
      0.8445E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip=21,21)/                               &
      0.1361E-04,  0.2711E-04,  0.5393E-04,  0.1070E-03,  0.2110E-03,   &
      0.4129E-03,  0.7973E-03,  0.1508E-02,  0.2769E-02,  0.4886E-02,   &
      0.8229E-02,  0.1322E-01,  0.2037E-01,  0.3038E-01,  0.4427E-01,   &
      0.6342E-01,  0.8963E-01,  0.1250E+00,  0.1720E+00,  0.2327E+00,   &
      0.3089E+00,  0.4007E+00,  0.5052E+00,  0.6163E+00,  0.7241E+00,   &
      0.8179E+00,  0.8905E+00,  0.9408E+00,  0.9720E+00,  0.9887E+00,   &
      0.9961E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=21,21)/                               &
      -0.4379E-08, -0.8801E-08, -0.1782E-07, -0.3642E-07, -0.7536E-07,  &
      -0.1581E-06, -0.3366E-06, -0.7227E-06, -0.1532E-05, -0.3106E-05,  &
      -0.5810E-05, -0.9862E-05, -0.1540E-04, -0.2279E-04, -0.3292E-04,  &
      -0.4738E-04, -0.6817E-04, -0.9765E-04, -0.1384E-03, -0.1918E-03,  &
      -0.2551E-03, -0.3226E-03, -0.3876E-03, -0.4452E-03, -0.4883E-03,  &
      -0.5005E-03, -0.4598E-03, -0.3633E-03, -0.2416E-03, -0.1349E-03,  &
      -0.6278E-04/
  DATA ((h73(ip,iw,1),iw=1,31),ip=21,21)/                               &
      0.1542E-10,  0.3111E-10,  0.6345E-10,  0.1310E-09,  0.2742E-09,   &
      0.5902E-09,  0.1289E-08,  0.2826E-08,  0.6103E-08,  0.1250E-07,   &
      0.2355E-07,  0.4041E-07,  0.6347E-07,  0.9217E-07,  0.1256E-06,   &
      0.1658E-06,  0.2175E-06,  0.2824E-06,  0.3607E-06,  0.4614E-06,   &
      0.6004E-06,  0.7880E-06,  0.1034E-05,  0.1349E-05,  0.1698E-05,   &
      0.1965E-05,  0.2021E-05,  0.1857E-05,  0.1500E-05,  0.1015E-05,   &
      0.5467E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip=22,22)/                               &
      0.1362E-04,  0.2714E-04,  0.5405E-04,  0.1074E-03,  0.2127E-03,   &
      0.4187E-03,  0.8159E-03,  0.1565E-02,  0.2933E-02,  0.5314E-02,   &
      0.9222E-02,  0.1525E-01,  0.2406E-01,  0.3649E-01,  0.5367E-01,   &
      0.7717E-01,  0.1090E+00,  0.1514E+00,  0.2067E+00,  0.2770E+00,   &
      0.3633E+00,  0.4640E+00,  0.5742E+00,  0.6853E+00,  0.7859E+00,   &
      0.8670E+00,  0.9253E+00,  0.9629E+00,  0.9842E+00,  0.9942E+00,   &
      0.9983E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=22,22)/                               &
      -0.4366E-08, -0.8749E-08, -0.1761E-07, -0.3578E-07, -0.7322E-07,  &
      -0.1517E-06, -0.3189E-06, -0.6785E-06, -0.1446E-05, -0.3014E-05,  &
      -0.5933E-05, -0.1069E-04, -0.1755E-04, -0.2683E-04, -0.3936E-04,  &
      -0.5675E-04, -0.8137E-04, -0.1160E-03, -0.1630E-03, -0.2223E-03,  &
      -0.2899E-03, -0.3589E-03, -0.4230E-03, -0.4755E-03, -0.5031E-03,  &
      -0.4834E-03, -0.4036E-03, -0.2849E-03, -0.1687E-03, -0.8356E-04,  &
      -0.3388E-04/
  DATA ((h73(ip,iw,1),iw=1,31),ip=22,22)/                               &
      0.1536E-10,  0.3086E-10,  0.6248E-10,  0.1288E-09,  0.2664E-09,   &
      0.5637E-09,  0.1222E-08,  0.2680E-08,  0.5899E-08,  0.1262E-07,   &
      0.2527E-07,  0.4621E-07,  0.7678E-07,  0.1165E-06,  0.1640E-06,   &
      0.2199E-06,  0.2904E-06,  0.3783E-06,  0.4787E-06,  0.5925E-06,   &
      0.7377E-06,  0.9389E-06,  0.1216E-05,  0.1560E-05,  0.1879E-05,   &
      0.2025E-05,  0.1940E-05,  0.1650E-05,  0.1194E-05,  0.6981E-06,   &
      0.3103E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip=23,23)/                               &
      0.1362E-04,  0.2716E-04,  0.5413E-04,  0.1077E-03,  0.2139E-03,   &
      0.4228E-03,  0.8295E-03,  0.1609E-02,  0.3063E-02,  0.5676E-02,   &
      0.1013E-01,  0.1726E-01,  0.2799E-01,  0.4332E-01,  0.6452E-01,   &
      0.9328E-01,  0.1317E+00,  0.1820E+00,  0.2467E+00,  0.3270E+00,   &
      0.4228E+00,  0.5308E+00,  0.6434E+00,  0.7499E+00,  0.8395E+00,   &
      0.9065E+00,  0.9515E+00,  0.9782E+00,  0.9916E+00,  0.9973E+00,   &
      0.9993E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=23,23)/                               &
      -0.4359E-08, -0.8720E-08, -0.1749E-07, -0.3527E-07, -0.7175E-07,  &
      -0.1473E-06, -0.3062E-06, -0.6451E-06, -0.1372E-05, -0.2902E-05,  &
      -0.5936E-05, -0.1133E-04, -0.1971E-04, -0.3143E-04, -0.4715E-04,  &
      -0.6833E-04, -0.9759E-04, -0.1379E-03, -0.1907E-03, -0.2542E-03,  &
      -0.3239E-03, -0.3935E-03, -0.4559E-03, -0.4991E-03, -0.5009E-03,  &
      -0.4414E-03, -0.3306E-03, -0.2077E-03, -0.1093E-03, -0.4754E-04,  &
      -0.1642E-04/
  DATA ((h73(ip,iw,1),iw=1,31),ip=23,23)/                               &
      0.1531E-10,  0.3070E-10,  0.6184E-10,  0.1257E-09,  0.2578E-09,   &
      0.5451E-09,  0.1159E-08,  0.2526E-08,  0.5585E-08,  0.1225E-07,   &
      0.2576E-07,  0.5017E-07,  0.8855E-07,  0.1417E-06,  0.2078E-06,   &
      0.2858E-06,  0.3802E-06,  0.4946E-06,  0.6226E-06,  0.7572E-06,   &
      0.9137E-06,  0.1133E-05,  0.1438E-05,  0.1772E-05,  0.1994E-05,   &
      0.1994E-05,  0.1779E-05,  0.1375E-05,  0.8711E-06,  0.4273E-06,   &
      0.1539E-06/
  DATA ((h71(ip,iw,1),iw=1,31),ip=24,24)/                               &
      0.1362E-04,  0.2717E-04,  0.5417E-04,  0.1079E-03,  0.2146E-03,   &
      0.4256E-03,  0.8393E-03,  0.1641E-02,  0.3163E-02,  0.5968E-02,   &
      0.1092E-01,  0.1915E-01,  0.3195E-01,  0.5066E-01,  0.7669E-01,   &
      0.1117E+00,  0.1578E+00,  0.2173E+00,  0.2919E+00,  0.3824E+00,   &
      0.4867E+00,  0.5992E+00,  0.7100E+00,  0.8076E+00,  0.8838E+00,   &
      0.9370E+00,  0.9702E+00,  0.9880E+00,  0.9959E+00,  0.9988E+00,   &
      0.9998E+00/
  DATA ((h72(ip,iw,1),iw=1,31),ip=24,24)/                               &
      -0.4354E-08, -0.8703E-08, -0.1742E-07, -0.3499E-07, -0.7074E-07,  &
      -0.1441E-06, -0.2971E-06, -0.6195E-06, -0.1309E-05, -0.2780E-05,  &
      -0.5823E-05, -0.1165E-04, -0.2152E-04, -0.3616E-04, -0.5604E-04,  &
      -0.8230E-04, -0.1173E-03, -0.1635E-03, -0.2211E-03, -0.2868E-03,  &
      -0.3567E-03, -0.4260E-03, -0.4844E-03, -0.5097E-03, -0.4750E-03,  &
      -0.3779E-03, -0.2522E-03, -0.1409E-03, -0.6540E-04, -0.2449E-04,  &
      -0.6948E-05/
  DATA ((h73(ip,iw,1),iw=1,31),ip=24,24)/                               &
      0.1529E-10,  0.3060E-10,  0.6142E-10,  0.1241E-09,  0.2535E-09,   &
      0.5259E-09,  0.1107E-08,  0.2383E-08,  0.5243E-08,  0.1161E-07,   &
      0.2523E-07,  0.5188E-07,  0.9757E-07,  0.1657E-06,  0.2553E-06,   &
      0.3629E-06,  0.4878E-06,  0.6323E-06,  0.7923E-06,  0.9575E-06,   &
      0.1139E-05,  0.1381E-05,  0.1687E-05,  0.1952E-05,  0.2029E-05,   &
      0.1890E-05,  0.1552E-05,  0.1062E-05,  0.5728E-06,  0.2280E-06,   &
      0.6762E-07/
  DATA ((h71(ip,iw,1),iw=1,31),ip=25,25)/                               &
      0.1363E-04,  0.2718E-04,  0.5420E-04,  0.1080E-03,  0.2151E-03,   &
      0.4275E-03,  0.8461E-03,  0.1664E-02,  0.3237E-02,  0.6195E-02,   &
      0.1156E-01,  0.2080E-01,  0.3573E-01,  0.5818E-01,  0.8981E-01,   &
      0.1323E+00,  0.1874E+00,  0.2570E+00,  0.3423E+00,  0.4425E+00,   &
      0.5534E+00,  0.6669E+00,  0.7714E+00,  0.8568E+00,  0.9191E+00,   &
      0.9597E+00,  0.9828E+00,  0.9938E+00,  0.9981E+00,  0.9996E+00,   &
      0.1000E+01/
  DATA ((h72(ip,iw,1),iw=1,31),ip=25,25)/                               &
      -0.4352E-08, -0.8693E-08, -0.1738E-07, -0.3483E-07, -0.7006E-07,  &
      -0.1423E-06, -0.2905E-06, -0.6008E-06, -0.1258E-05, -0.2663E-05,  &
      -0.5638E-05, -0.1165E-04, -0.2270E-04, -0.4044E-04, -0.6554E-04,  &
      -0.9855E-04, -0.1407E-03, -0.1928E-03, -0.2534E-03, -0.3197E-03,  &
      -0.3890E-03, -0.4563E-03, -0.5040E-03, -0.4998E-03, -0.4249E-03,  &
      -0.3025E-03, -0.1794E-03, -0.8860E-04, -0.3575E-04, -0.1122E-04,  &
      -0.2506E-05/
  DATA ((h73(ip,iw,1),iw=1,31),ip=25,25)/                               &
      0.1527E-10,  0.3053E-10,  0.6115E-10,  0.1230E-09,  0.2492E-09,   &
      0.5149E-09,  0.1068E-08,  0.2268E-08,  0.4932E-08,  0.1089E-07,   &
      0.2408E-07,  0.5156E-07,  0.1028E-06,  0.1859E-06,  0.3028E-06,   &
      0.4476E-06,  0.6124E-06,  0.7932E-06,  0.9879E-06,  0.1194E-05,   &
      0.1417E-05,  0.1673E-05,  0.1929E-05,  0.2064E-05,  0.1997E-05,   &
      0.1725E-05,  0.1267E-05,  0.7464E-06,  0.3312E-06,  0.1066E-06,   &
      0.2718E-07/
  DATA ((h71(ip,iw,1),iw=1,31),ip=26,26)/                               &
      0.1363E-04,  0.2719E-04,  0.5422E-04,  0.1081E-03,  0.2154E-03,   &
      0.4287E-03,  0.8506E-03,  0.1680E-02,  0.3291E-02,  0.6364E-02,   &
      0.1206E-01,  0.2218E-01,  0.3912E-01,  0.6544E-01,  0.1033E+00,   &
      0.1544E+00,  0.2198E+00,  0.3008E+00,  0.3970E+00,  0.5060E+00,   &
      0.6209E+00,  0.7311E+00,  0.8254E+00,  0.8972E+00,  0.9462E+00,   &
      0.9757E+00,  0.9907E+00,  0.9970E+00,  0.9992E+00,  0.9999E+00,   &
      0.1000E+01/
  DATA ((h72(ip,iw,1),iw=1,31),ip=26,26)/                               &
      -0.4351E-08, -0.8688E-08, -0.1736E-07, -0.3473E-07, -0.6966E-07,  &
      -0.1405E-06, -0.2857E-06, -0.5867E-06, -0.1218E-05, -0.2563E-05,  &
      -0.5435E-05, -0.1144E-04, -0.2321E-04, -0.4379E-04, -0.7487E-04,  &
      -0.1163E-03, -0.1670E-03, -0.2250E-03, -0.2876E-03, -0.3535E-03,  &
      -0.4215E-03, -0.4826E-03, -0.5082E-03, -0.4649E-03, -0.3564E-03,  &
      -0.2264E-03, -0.1188E-03, -0.5128E-04, -0.1758E-04, -0.4431E-05,  &
      -0.7275E-06/
  DATA ((h73(ip,iw,1),iw=1,31),ip=26,26)/                               &
      0.1525E-10,  0.3048E-10,  0.6097E-10,  0.1223E-09,  0.2466E-09,   &
      0.5021E-09,  0.1032E-08,  0.2195E-08,  0.4688E-08,  0.1027E-07,   &
      0.2279E-07,  0.4999E-07,  0.1046E-06,  0.2009E-06,  0.3460E-06,   &
      0.5335E-06,  0.7478E-06,  0.9767E-06,  0.1216E-05,  0.1469E-05,   &
      0.1735E-05,  0.1977E-05,  0.2121E-05,  0.2103E-05,  0.1902E-05,   &
      0.1495E-05,  0.9541E-06,  0.4681E-06,  0.1672E-06,  0.4496E-07,   &
      0.9859E-08/
!
!-----------------------------------------------------------------------
!
!  The following DATA statements originally came from file
!  "co2.tran3", which define pre-computed tables used for co2 (band
!  3) transmittance calculations.
!
!-----------------------------------------------------------------------
!
! co2.tran3

  REAL :: c1(26,24,7),c2(26,24,7),c3(26,24,7)

  COMMON /radtab002/ c1,c2,c3

  DATA ((c1(ip,iw,1),iw=1,24),ip= 1, 1)/                                &
      0.1444E-03,  0.2378E-03,  0.3644E-03,  0.5245E-03,  0.7311E-03,   &
      0.1015E-02,  0.1416E-02,  0.1975E-02,  0.2715E-02,  0.3651E-02,   &
      0.4813E-02,  0.6264E-02,  0.8084E-02,  0.1037E-01,  0.1327E-01,   &
      0.1693E-01,  0.2155E-01,  0.2734E-01,  0.3453E-01,  0.4337E-01,   &
      0.5414E-01,  0.6726E-01,  0.8335E-01,  0.1032E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 1, 1)/                                &
      -0.2878E-06, -0.6295E-06, -0.1270E-05, -0.2323E-05, -0.3910E-05,  &
      -0.6235E-05, -0.9527E-05, -0.1391E-04, -0.1947E-04, -0.2652E-04,  &
      -0.3568E-04, -0.4777E-04, -0.6363E-04, -0.8414E-04, -0.1102E-03,  &
      -0.1425E-03, -0.1822E-03, -0.2301E-03, -0.2869E-03, -0.3534E-03,  &
      -0.4305E-03, -0.5188E-03, -0.6173E-03, -0.7229E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 1, 1)/                                &
      -0.2369E-09, -0.5453E-09, -0.1434E-08, -0.3513E-08, -0.7277E-08,  &
      -0.1283E-07, -0.1983E-07, -0.2838E-07, -0.4075E-07, -0.6115E-07,  &
      -0.9201E-07, -0.1325E-06, -0.1844E-06, -0.2534E-06, -0.3430E-06,  &
      -0.4550E-06, -0.5896E-06, -0.7434E-06, -0.9121E-06, -0.1096E-05,  &
      -0.1298E-05, -0.1508E-05, -0.1689E-05, -0.1773E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 2, 2)/                                &
      0.1444E-03,  0.2379E-03,  0.3646E-03,  0.5250E-03,  0.7320E-03,   &
      0.1016E-02,  0.1419E-02,  0.1981E-02,  0.2726E-02,  0.3669E-02,   &
      0.4847E-02,  0.6325E-02,  0.8193E-02,  0.1056E-01,  0.1358E-01,   &
      0.1742E-01,  0.2228E-01,  0.2843E-01,  0.3611E-01,  0.4561E-01,   &
      0.5730E-01,  0.7169E-01,  0.8952E-01,  0.1117E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 2, 2)/                                &
      -0.2875E-06, -0.6289E-06, -0.1269E-05, -0.2321E-05, -0.3907E-05,  &
      -0.6229E-05, -0.9516E-05, -0.1389E-04, -0.1944E-04, -0.2646E-04,  &
      -0.3559E-04, -0.4762E-04, -0.6340E-04, -0.8384E-04, -0.1098E-03,  &
      -0.1423E-03, -0.1824E-03, -0.2309E-03, -0.2887E-03, -0.3566E-03,  &
      -0.4355E-03, -0.5260E-03, -0.6274E-03, -0.7367E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 2, 2)/                                &
      -0.2382E-09, -0.5476E-09, -0.1437E-08, -0.3520E-08, -0.7291E-08,  &
      -0.1286E-07, -0.1989E-07, -0.2849E-07, -0.4093E-07, -0.6144E-07,  &
      -0.9241E-07, -0.1330E-06, -0.1852E-06, -0.2542E-06, -0.3435E-06,  &
      -0.4549E-06, -0.5891E-06, -0.7427E-06, -0.9114E-06, -0.1096E-05,  &
      -0.1298E-05, -0.1509E-05, -0.1689E-05, -0.1772E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 3, 3)/                                &
      0.1445E-03,  0.2381E-03,  0.3650E-03,  0.5258E-03,  0.7335E-03,   &
      0.1019E-02,  0.1424E-02,  0.1990E-02,  0.2742E-02,  0.3698E-02,   &
      0.4899E-02,  0.6418E-02,  0.8353E-02,  0.1083E-01,  0.1401E-01,   &
      0.1807E-01,  0.2326E-01,  0.2985E-01,  0.3814E-01,  0.4849E-01,   &
      0.6134E-01,  0.7733E-01,  0.9732E-01,  0.1223E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 3, 3)/                                &
      -0.2871E-06, -0.6279E-06, -0.1267E-05, -0.2318E-05, -0.3901E-05,  &
      -0.6219E-05, -0.9500E-05, -0.1386E-04, -0.1939E-04, -0.2639E-04,  &
      -0.3547E-04, -0.4743E-04, -0.6313E-04, -0.8354E-04, -0.1096E-03,  &
      -0.1425E-03, -0.1831E-03, -0.2325E-03, -0.2916E-03, -0.3613E-03,  &
      -0.4425E-03, -0.5361E-03, -0.6412E-03, -0.7550E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 3, 3)/                                &
      -0.2404E-09, -0.5516E-09, -0.1443E-08, -0.3531E-08, -0.7310E-08,  &
      -0.1290E-07, -0.1997E-07, -0.2865E-07, -0.4121E-07, -0.6185E-07,  &
      -0.9295E-07, -0.1337E-06, -0.1860E-06, -0.2549E-06, -0.3438E-06,  &
      -0.4547E-06, -0.5888E-06, -0.7424E-06, -0.9114E-06, -0.1097E-05,  &
      -0.1300E-05, -0.1511E-05, -0.1691E-05, -0.1771E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 4, 4)/                                &
      0.1446E-03,  0.2383E-03,  0.3656E-03,  0.5270E-03,  0.7358E-03,   &
      0.1023E-02,  0.1432E-02,  0.2003E-02,  0.2766E-02,  0.3743E-02,   &
      0.4979E-02,  0.6557E-02,  0.8587E-02,  0.1121E-01,  0.1459E-01,   &
      0.1895E-01,  0.2455E-01,  0.3170E-01,  0.4076E-01,  0.5217E-01,   &
      0.6649E-01,  0.8448E-01,  0.1071E+00,  0.1353E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 4, 4)/                                &
      -0.2865E-06, -0.6264E-06, -0.1264E-05, -0.2313E-05, -0.3892E-05,  &
      -0.6204E-05, -0.9474E-05, -0.1382E-04, -0.1932E-04, -0.2628E-04,  &
      -0.3530E-04, -0.4720E-04, -0.6286E-04, -0.8333E-04, -0.1097E-03,  &
      -0.1430E-03, -0.1845E-03, -0.2352E-03, -0.2960E-03, -0.3681E-03,  &
      -0.4523E-03, -0.5496E-03, -0.6595E-03, -0.7790E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 4, 4)/                                &
      -0.2433E-09, -0.5580E-09, -0.1454E-08, -0.3550E-08, -0.7345E-08,  &
      -0.1296E-07, -0.2010E-07, -0.2889E-07, -0.4159E-07, -0.6239E-07,  &
      -0.9360E-07, -0.1345E-06, -0.1867E-06, -0.2554E-06, -0.3439E-06,  &
      -0.4548E-06, -0.5890E-06, -0.7429E-06, -0.9127E-06, -0.1099E-05,  &
      -0.1304E-05, -0.1516E-05, -0.1693E-05, -0.1770E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 5, 5)/                                &
      0.1448E-03,  0.2387E-03,  0.3666E-03,  0.5290E-03,  0.7394E-03,   &
      0.1030E-02,  0.1444E-02,  0.2025E-02,  0.2805E-02,  0.3811E-02,   &
      0.5099E-02,  0.6761E-02,  0.8919E-02,  0.1173E-01,  0.1538E-01,   &
      0.2011E-01,  0.2622E-01,  0.3408E-01,  0.4412E-01,  0.5686E-01,   &
      0.7302E-01,  0.9346E-01,  0.1192E+00,  0.1512E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 5, 5)/                                &
      -0.2854E-06, -0.6241E-06, -0.1260E-05, -0.2305E-05, -0.3878E-05,  &
      -0.6181E-05, -0.9435E-05, -0.1375E-04, -0.1922E-04, -0.2613E-04,  &
      -0.3510E-04, -0.4696E-04, -0.6265E-04, -0.8334E-04, -0.1102E-03,  &
      -0.1443E-03, -0.1870E-03, -0.2393E-03, -0.3025E-03, -0.3775E-03,  &
      -0.4656E-03, -0.5678E-03, -0.6835E-03, -0.8098E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 5, 5)/                                &
      -0.2485E-09, -0.5672E-09, -0.1468E-08, -0.3577E-08, -0.7395E-08,  &
      -0.1306E-07, -0.2029E-07, -0.2923E-07, -0.4213E-07, -0.6307E-07,  &
      -0.9429E-07, -0.1351E-06, -0.1872E-06, -0.2557E-06, -0.3442E-06,  &
      -0.4553E-06, -0.5899E-06, -0.7447E-06, -0.9163E-06, -0.1105E-05,  &
      -0.1311E-05, -0.1522E-05, -0.1697E-05, -0.1766E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 6, 6)/                                &
      0.1450E-03,  0.2394E-03,  0.3680E-03,  0.5320E-03,  0.7452E-03,   &
      0.1040E-02,  0.1462E-02,  0.2058E-02,  0.2863E-02,  0.3914E-02,   &
      0.5275E-02,  0.7051E-02,  0.9378E-02,  0.1243E-01,  0.1641E-01,   &
      0.2162E-01,  0.2838E-01,  0.3713E-01,  0.4839E-01,  0.6282E-01,   &
      0.8125E-01,  0.1046E+00,  0.1340E+00,  0.1702E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 6, 6)/                                &
      -0.2837E-06, -0.6203E-06, -0.1252E-05, -0.2292E-05, -0.3857E-05,  &
      -0.6146E-05, -0.9377E-05, -0.1366E-04, -0.1909E-04, -0.2596E-04,  &
      -0.3489E-04, -0.4676E-04, -0.6263E-04, -0.8372E-04, -0.1113E-03,  &
      -0.1465E-03, -0.1908E-03, -0.2454E-03, -0.3115E-03, -0.3903E-03,  &
      -0.4833E-03, -0.5915E-03, -0.7144E-03, -0.8483E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 6, 6)/                                &
      -0.2557E-09, -0.5835E-09, -0.1495E-08, -0.3619E-08, -0.7472E-08,  &
      -0.1320E-07, -0.2055E-07, -0.2970E-07, -0.4281E-07, -0.6379E-07,  &
      -0.9492E-07, -0.1356E-06, -0.1876E-06, -0.2561E-06, -0.3451E-06,  &
      -0.4568E-06, -0.5924E-06, -0.7489E-06, -0.9229E-06, -0.1114E-05,  &
      -0.1321E-05, -0.1531E-05, -0.1700E-05, -0.1756E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 7, 7)/                                &
      0.1454E-03,  0.2404E-03,  0.3704E-03,  0.5368E-03,  0.7542E-03,   &
      0.1056E-02,  0.1491E-02,  0.2108E-02,  0.2951E-02,  0.4066E-02,   &
      0.5529E-02,  0.7457E-02,  0.1000E-01,  0.1336E-01,  0.1777E-01,   &
      0.2357E-01,  0.3115E-01,  0.4102E-01,  0.5382E-01,  0.7035E-01,   &
      0.9154E-01,  0.1184E+00,  0.1519E+00,  0.1926E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 7, 7)/                                &
      -0.2811E-06, -0.6147E-06, -0.1241E-05, -0.2272E-05, -0.3825E-05,  &
      -0.6093E-05, -0.9294E-05, -0.1354E-04, -0.1893E-04, -0.2577E-04,  &
      -0.3472E-04, -0.4672E-04, -0.6292E-04, -0.8464E-04, -0.1132E-03,  &
      -0.1500E-03, -0.1964E-03, -0.2539E-03, -0.3237E-03, -0.4074E-03,  &
      -0.5065E-03, -0.6222E-03, -0.7532E-03, -0.8955E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 7, 7)/                                &
      -0.2673E-09, -0.6022E-09, -0.1531E-08, -0.3682E-08, -0.7588E-08,  &
      -0.1342E-07, -0.2092E-07, -0.3030E-07, -0.4357E-07, -0.6448E-07,  &
      -0.9533E-07, -0.1359E-06, -0.1879E-06, -0.2570E-06, -0.3470E-06,  &
      -0.4598E-06, -0.5971E-06, -0.7563E-06, -0.9334E-06, -0.1127E-05,  &
      -0.1336E-05, -0.1543E-05, -0.1701E-05, -0.1738E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 8, 8)/                                &
      0.1460E-03,  0.2420E-03,  0.3740E-03,  0.5443E-03,  0.7681E-03,   &
      0.1081E-02,  0.1535E-02,  0.2184E-02,  0.3082E-02,  0.4286E-02,   &
      0.5885E-02,  0.8011E-02,  0.1083E-01,  0.1458E-01,  0.1954E-01,   &
      0.2608E-01,  0.3468E-01,  0.4595E-01,  0.6068E-01,  0.7979E-01,   &
      0.1043E+00,  0.1351E+00,  0.1731E+00,  0.2184E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 8, 8)/                                &
      -0.2770E-06, -0.6058E-06, -0.1224E-05, -0.2243E-05, -0.3777E-05,  &
      -0.6018E-05, -0.9181E-05, -0.1339E-04, -0.1876E-04, -0.2561E-04,  &
      -0.3467E-04, -0.4695E-04, -0.6370E-04, -0.8635E-04, -0.1163E-03,  &
      -0.1551E-03, -0.2043E-03, -0.2654E-03, -0.3400E-03, -0.4299E-03,  &
      -0.5366E-03, -0.6609E-03, -0.8010E-03, -0.9521E-03/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 8, 8)/                                &
      -0.2845E-09, -0.6367E-09, -0.1591E-08, -0.3779E-08, -0.7752E-08,  &
      -0.1370E-07, -0.2140E-07, -0.3101E-07, -0.4437E-07, -0.6498E-07,  &
      -0.9551E-07, -0.1360E-06, -0.1887E-06, -0.2590E-06, -0.3503E-06,  &
      -0.4650E-06, -0.6052E-06, -0.7681E-06, -0.9488E-06, -0.1145E-05,  &
      -0.1354E-05, -0.1555E-05, -0.1698E-05, -0.1701E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip= 9, 9)/                                &
      0.1470E-03,  0.2444E-03,  0.3796E-03,  0.5557E-03,  0.7894E-03,   &
      0.1119E-02,  0.1600E-02,  0.2296E-02,  0.3271E-02,  0.4596E-02,   &
      0.6373E-02,  0.8752E-02,  0.1193E-01,  0.1617E-01,  0.2181E-01,   &
      0.2928E-01,  0.3916E-01,  0.5220E-01,  0.6930E-01,  0.9150E-01,   &
      0.1198E+00,  0.1551E+00,  0.1978E+00,  0.2475E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip= 9, 9)/                                &
      -0.2709E-06, -0.5925E-06, -0.1198E-05, -0.2199E-05, -0.3708E-05,  &
      -0.5913E-05, -0.9036E-05, -0.1322E-04, -0.1861E-04, -0.2556E-04,  &
      -0.3486E-04, -0.4760E-04, -0.6516E-04, -0.8909E-04, -0.1210E-03,  &
      -0.1624E-03, -0.2151E-03, -0.2808E-03, -0.3615E-03, -0.4590E-03,  &
      -0.5747E-03, -0.7088E-03, -0.8585E-03, -0.1018E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip= 9, 9)/                                &
      -0.3119E-09, -0.6873E-09, -0.1676E-08, -0.3915E-08, -0.7973E-08,  &
      -0.1407E-07, -0.2200E-07, -0.3179E-07, -0.4505E-07, -0.6522E-07,  &
      -0.9551E-07, -0.1364E-06, -0.1902E-06, -0.2622E-06, -0.3557E-06,  &
      -0.4735E-06, -0.6178E-06, -0.7853E-06, -0.9700E-06, -0.1169E-05,  &
      -0.1377E-05, -0.1567E-05, -0.1683E-05, -0.1631E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=10,10)/                                &
      0.1484E-03,  0.2482E-03,  0.3882E-03,  0.5732E-03,  0.8217E-03,   &
      0.1176E-02,  0.1696E-02,  0.2457E-02,  0.3536E-02,  0.5021E-02,   &
      0.7028E-02,  0.9728E-02,  0.1336E-01,  0.1821E-01,  0.2470E-01,   &
      0.3334E-01,  0.4482E-01,  0.6004E-01,  0.8003E-01,  0.1059E+00,   &
      0.1385E+00,  0.1785E+00,  0.2259E+00,  0.2794E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=10,10)/                                &
      -0.2620E-06, -0.5728E-06, -0.1161E-05, -0.2136E-05, -0.3612E-05,  &
      -0.5777E-05, -0.8867E-05, -0.1306E-04, -0.1854E-04, -0.2572E-04,  &
      -0.3543E-04, -0.4887E-04, -0.6756E-04, -0.9321E-04, -0.1275E-03,  &
      -0.1723E-03, -0.2295E-03, -0.3011E-03, -0.3894E-03, -0.4960E-03,  &
      -0.6220E-03, -0.7665E-03, -0.9259E-03, -0.1095E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=10,10)/                                &
      -0.3497E-09, -0.7575E-09, -0.1791E-08, -0.4091E-08, -0.8254E-08,  &
      -0.1452E-07, -0.2265E-07, -0.3255E-07, -0.4557E-07, -0.6530E-07,  &
      -0.9557E-07, -0.1374E-06, -0.1930E-06, -0.2675E-06, -0.3644E-06,  &
      -0.4866E-06, -0.6362E-06, -0.8090E-06, -0.9981E-06, -0.1199E-05,  &
      -0.1402E-05, -0.1574E-05, -0.1643E-05, -0.1506E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=11,11)/                                &
      0.1506E-03,  0.2538E-03,  0.4010E-03,  0.5992E-03,  0.8693E-03,   &
      0.1258E-02,  0.1834E-02,  0.2683E-02,  0.3901E-02,  0.5591E-02,   &
      0.7890E-02,  0.1100E-01,  0.1519E-01,  0.2082E-01,  0.2837E-01,   &
      0.3845E-01,  0.5192E-01,  0.6981E-01,  0.9323E-01,  0.1232E+00,   &
      0.1606E+00,  0.2055E+00,  0.2571E+00,  0.3133E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=11,11)/                                &
      -0.2494E-06, -0.5450E-06, -0.1108E-05, -0.2049E-05, -0.3485E-05,  &
      -0.5612E-05, -0.8695E-05, -0.1296E-04, -0.1865E-04, -0.2620E-04,  &
      -0.3654E-04, -0.5099E-04, -0.7121E-04, -0.9909E-04, -0.1365E-03,  &
      -0.1855E-03, -0.2483E-03, -0.3274E-03, -0.4248E-03, -0.5421E-03,  &
      -0.6794E-03, -0.8346E-03, -0.1003E-02, -0.1181E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=11,11)/                                &
      -0.3973E-09, -0.8499E-09, -0.1944E-08, -0.4319E-08, -0.8596E-08,  &
      -0.1501E-07, -0.2332E-07, -0.3326E-07, -0.4600E-07, -0.6541E-07,  &
      -0.9592E-07, -0.1392E-06, -0.1975E-06, -0.2757E-06, -0.3774E-06,  &
      -0.5057E-06, -0.6614E-06, -0.8401E-06, -0.1034E-05, -0.1235E-05,  &
      -0.1427E-05, -0.1565E-05, -0.1560E-05, -0.1310E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=12,12)/                                &
      0.1537E-03,  0.2618E-03,  0.4196E-03,  0.6368E-03,  0.9377E-03,   &
      0.1374E-02,  0.2024E-02,  0.2990E-02,  0.4387E-02,  0.6339E-02,   &
      0.9008E-02,  0.1263E-01,  0.1752E-01,  0.2410E-01,  0.3296E-01,   &
      0.4485E-01,  0.6077E-01,  0.8185E-01,  0.1092E+00,  0.1439E+00,   &
      0.1861E+00,  0.2356E+00,  0.2906E+00,  0.3483E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=12,12)/                                &
      -0.2326E-06, -0.5076E-06, -0.1037E-05, -0.1935E-05, -0.3329E-05,  &
      -0.5433E-05, -0.8553E-05, -0.1298E-04, -0.1902E-04, -0.2716E-04,  &
      -0.3840E-04, -0.5421E-04, -0.7643E-04, -0.1071E-03, -0.1485E-03,  &
      -0.2028E-03, -0.2727E-03, -0.3608E-03, -0.4689E-03, -0.5981E-03,  &
      -0.7471E-03, -0.9128E-03, -0.1091E-02, -0.1276E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=12,12)/                                &
      -0.4576E-09, -0.9621E-09, -0.2122E-08, -0.4569E-08, -0.8941E-08,  &
      -0.1550E-07, -0.2398E-07, -0.3404E-07, -0.4663E-07, -0.6577E-07,  &
      -0.9677E-07, -0.1421E-06, -0.2042E-06, -0.2878E-06, -0.3962E-06,  &
      -0.5318E-06, -0.6946E-06, -0.8798E-06, -0.1078E-05, -0.1275E-05,  &
      -0.1445E-05, -0.1523E-05, -0.1413E-05, -0.1030E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=13,13)/                                &
      0.1579E-03,  0.2729E-03,  0.4454E-03,  0.6893E-03,  0.1033E-02,   &
      0.1533E-02,  0.2280E-02,  0.3396E-02,  0.5018E-02,  0.7299E-02,   &
      0.1043E-01,  0.1468E-01,  0.2044E-01,  0.2820E-01,  0.3867E-01,   &
      0.5278E-01,  0.7166E-01,  0.9648E-01,  0.1283E+00,  0.1679E+00,   &
      0.2150E+00,  0.2685E+00,  0.3256E+00,  0.3836E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=13,13)/                                &
      -0.2120E-06, -0.4613E-06, -0.9487E-06, -0.1798E-05, -0.3153E-05,  &
      -0.5260E-05, -0.8480E-05, -0.1319E-04, -0.1976E-04, -0.2876E-04,  &
      -0.4125E-04, -0.5885E-04, -0.8357E-04, -0.1178E-03, -0.1640E-03,  &
      -0.2250E-03, -0.3036E-03, -0.4023E-03, -0.5226E-03, -0.6643E-03,  &
      -0.8250E-03, -0.1001E-02, -0.1187E-02, -0.1378E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=13,13)/                                &
      -0.5223E-09, -0.1082E-08, -0.2314E-08, -0.4826E-08, -0.9255E-08,  &
      -0.1596E-07, -0.2472E-07, -0.3507E-07, -0.4774E-07, -0.6677E-07,  &
      -0.9841E-07, -0.1466E-06, -0.2141E-06, -0.3049E-06, -0.4219E-06,  &
      -0.5662E-06, -0.7370E-06, -0.9290E-06, -0.1129E-05, -0.1315E-05,  &
      -0.1441E-05, -0.1427E-05, -0.1184E-05, -0.6731E-06/
  DATA ((c1(ip,iw,1),iw=1,24),ip=14,14)/                                &
      0.1634E-03,  0.2873E-03,  0.4793E-03,  0.7589E-03,  0.1159E-02,   &
      0.1742E-02,  0.2614E-02,  0.3916E-02,  0.5817E-02,  0.8503E-02,   &
      0.1220E-01,  0.1723E-01,  0.2403E-01,  0.3324E-01,  0.4572E-01,   &
      0.6253E-01,  0.8488E-01,  0.1140E+00,  0.1507E+00,  0.1952E+00,   &
      0.2468E+00,  0.3031E+00,  0.3612E+00,  0.4186E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=14,14)/                                &
      -0.1896E-06, -0.4100E-06, -0.8500E-06, -0.1645E-05, -0.2972E-05,  &
      -0.5116E-05, -0.8508E-05, -0.1363E-04, -0.2097E-04, -0.3115E-04,  &
      -0.4531E-04, -0.6517E-04, -0.9298E-04, -0.1315E-03, -0.1837E-03,  &
      -0.2528E-03, -0.3417E-03, -0.4525E-03, -0.5860E-03, -0.7405E-03,  &
      -0.9123E-03, -0.1097E-02, -0.1290E-02, -0.1482E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=14,14)/                                &
      -0.5738E-09, -0.1185E-08, -0.2465E-08, -0.5015E-08, -0.9502E-08,  &
      -0.1640E-07, -0.2567E-07, -0.3675E-07, -0.4990E-07, -0.6893E-07,  &
      -0.1014E-06, -0.1533E-06, -0.2278E-06, -0.3278E-06, -0.4553E-06,  &
      -0.6098E-06, -0.7899E-06, -0.9876E-06, -0.1184E-05, -0.1342E-05,  &
      -0.1393E-05, -0.1254E-05, -0.8703E-06, -0.2593E-06/
  DATA ((c1(ip,iw,1),iw=1,24),ip=15,15)/                                &
      0.1697E-03,  0.3043E-03,  0.5205E-03,  0.8458E-03,  0.1319E-02,   &
      0.2009E-02,  0.3034E-02,  0.4563E-02,  0.6800E-02,  0.9975E-02,   &
      0.1436E-01,  0.2033E-01,  0.2842E-01,  0.3941E-01,  0.5431E-01,   &
      0.7432E-01,  0.1007E+00,  0.1344E+00,  0.1762E+00,  0.2255E+00,   &
      0.2806E+00,  0.3385E+00,  0.3964E+00,  0.4532E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=15,15)/                                &
      -0.1689E-06, -0.3610E-06, -0.7531E-06, -0.1495E-05, -0.2803E-05,  &
      -0.5013E-05, -0.8646E-05, -0.1433E-04, -0.2270E-04, -0.3446E-04,  &
      -0.5077E-04, -0.7342E-04, -0.1049E-03, -0.1486E-03, -0.2080E-03,  &
      -0.2866E-03, -0.3873E-03, -0.5115E-03, -0.6586E-03, -0.8256E-03,  &
      -0.1008E-02, -0.1201E-02, -0.1398E-02, -0.1583E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=15,15)/                                &
      -0.6063E-09, -0.1245E-08, -0.2559E-08, -0.5110E-08, -0.9652E-08,  &
      -0.1685E-07, -0.2693E-07, -0.3933E-07, -0.5373E-07, -0.7330E-07,  &
      -0.1066E-06, -0.1625E-06, -0.2453E-06, -0.3564E-06, -0.4963E-06,  &
      -0.6636E-06, -0.8532E-06, -0.1054E-05, -0.1236E-05, -0.1339E-05,  &
      -0.1280E-05, -0.9947E-06, -0.4862E-06,  0.1889E-06/
  DATA ((c1(ip,iw,1),iw=1,24),ip=16,16)/                                &
      0.1763E-03,  0.3227E-03,  0.5664E-03,  0.9465E-03,  0.1511E-02,   &
      0.2335E-02,  0.3549E-02,  0.5348E-02,  0.7977E-02,  0.1172E-01,   &
      0.1692E-01,  0.2402E-01,  0.3369E-01,  0.4685E-01,  0.6465E-01,   &
      0.8835E-01,  0.1192E+00,  0.1579E+00,  0.2046E+00,  0.2579E+00,   &
      0.3153E+00,  0.3736E+00,  0.4308E+00,  0.4875E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=16,16)/                                &
      -0.1533E-06, -0.3224E-06, -0.6725E-06, -0.1365E-05, -0.2657E-05,  &
      -0.4953E-05, -0.8878E-05, -0.1525E-04, -0.2490E-04, -0.3866E-04,  &
      -0.5766E-04, -0.8372E-04, -0.1197E-03, -0.1695E-03, -0.2372E-03,  &
      -0.3266E-03, -0.4401E-03, -0.5783E-03, -0.7390E-03, -0.9180E-03,  &
      -0.1110E-02, -0.1309E-02, -0.1503E-02, -0.1676E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=16,16)/                                &
      -0.6109E-09, -0.1253E-08, -0.2555E-08, -0.5100E-08, -0.9703E-08,  &
      -0.1729E-07, -0.2846E-07, -0.4291E-07, -0.5988E-07, -0.8135E-07,  &
      -0.1158E-06, -0.1750E-06, -0.2657E-06, -0.3890E-06, -0.5438E-06,  &
      -0.7262E-06, -0.9256E-06, -0.1122E-05, -0.1269E-05, -0.1284E-05,  &
      -0.1086E-05, -0.6553E-06, -0.5588E-07,  0.6660E-06/
  DATA ((c1(ip,iw,1),iw=1,24),ip=17,17)/                                &
      0.1824E-03,  0.3403E-03,  0.6126E-03,  0.1054E-02,  0.1727E-02,   &
      0.2716E-02,  0.4160E-02,  0.6275E-02,  0.9353E-02,  0.1375E-01,   &
      0.1990E-01,  0.2837E-01,  0.3995E-01,  0.5571E-01,  0.7690E-01,   &
      0.1048E+00,  0.1404E+00,  0.1841E+00,  0.2353E+00,  0.2916E+00,   &
      0.3500E+00,  0.4078E+00,  0.4646E+00,  0.5215E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=17,17)/                                &
      -0.1436E-06, -0.2978E-06, -0.6179E-06, -0.1270E-05, -0.2546E-05,  &
      -0.4927E-05, -0.9164E-05, -0.1628E-04, -0.2740E-04, -0.4353E-04,  &
      -0.6579E-04, -0.9606E-04, -0.1375E-03, -0.1943E-03, -0.2712E-03,  &
      -0.3722E-03, -0.4993E-03, -0.6515E-03, -0.8255E-03, -0.1016E-02,  &
      -0.1217E-02, -0.1417E-02, -0.1602E-02, -0.1757E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=17,17)/                                &
      -0.6015E-09, -0.1225E-08, -0.2489E-08, -0.4978E-08, -0.9608E-08,  &
      -0.1756E-07, -0.2993E-07, -0.4715E-07, -0.6853E-07, -0.9454E-07,  &
      -0.1314E-06, -0.1920E-06, -0.2877E-06, -0.4222E-06, -0.5940E-06,  &
      -0.7936E-06, -0.1002E-05, -0.1181E-05, -0.1262E-05, -0.1156E-05,  &
      -0.8086E-06, -0.2604E-06,  0.4056E-06,  0.1164E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=18,18)/                                &
      0.1875E-03,  0.3555E-03,  0.6547E-03,  0.1159E-02,  0.1954E-02,   &
      0.3140E-02,  0.4861E-02,  0.7345E-02,  0.1093E-01,  0.1606E-01,   &
      0.2330E-01,  0.3339E-01,  0.4729E-01,  0.6613E-01,  0.9118E-01,   &
      0.1236E+00,  0.1642E+00,  0.2127E+00,  0.2674E+00,  0.3254E+00,   &
      0.3836E+00,  0.4408E+00,  0.4978E+00,  0.5551E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=18,18)/                                &
      -0.1390E-06, -0.2850E-06, -0.5878E-06, -0.1213E-05, -0.2477E-05,  &
      -0.4934E-05, -0.9466E-05, -0.1731E-04, -0.2990E-04, -0.4860E-04,  &
      -0.7471E-04, -0.1102E-03, -0.1582E-03, -0.2230E-03, -0.3098E-03,  &
      -0.4228E-03, -0.5632E-03, -0.7291E-03, -0.9158E-03, -0.1117E-02,  &
      -0.1323E-02, -0.1519E-02, -0.1689E-02, -0.1824E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=18,18)/                                &
      -0.5875E-09, -0.1187E-08, -0.2392E-08, -0.4777E-08, -0.9321E-08,  &
      -0.1745E-07, -0.3091E-07, -0.5121E-07, -0.7879E-07, -0.1130E-06,  &
      -0.1555E-06, -0.2161E-06, -0.3110E-06, -0.4527E-06, -0.6400E-06,  &
      -0.8571E-06, -0.1069E-05, -0.1209E-05, -0.1193E-05, -0.9472E-06,  &
      -0.4712E-06,  0.1597E-06,  0.8892E-06,  0.1671E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=19,19)/                                &
      0.1914E-03,  0.3677E-03,  0.6900E-03,  0.1252E-02,  0.2172E-02,   &
      0.3581E-02,  0.5632E-02,  0.8553E-02,  0.1271E-01,  0.1866E-01,   &
      0.2715E-01,  0.3914E-01,  0.5576E-01,  0.7817E-01,  0.1076E+00,   &
      0.1449E+00,  0.1903E+00,  0.2429E+00,  0.2999E+00,  0.3582E+00,   &
      0.4157E+00,  0.4727E+00,  0.5303E+00,  0.5878E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=19,19)/                                &
      -0.1371E-06, -0.2799E-06, -0.5756E-06, -0.1190E-05, -0.2455E-05,  &
      -0.4982E-05, -0.9770E-05, -0.1824E-04, -0.3214E-04, -0.5332E-04,  &
      -0.8371E-04, -0.1255E-03, -0.1814E-03, -0.2555E-03, -0.3528E-03,  &
      -0.4774E-03, -0.6306E-03, -0.8095E-03, -0.1008E-02, -0.1218E-02,  &
      -0.1424E-02, -0.1610E-02, -0.1763E-02, -0.1875E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=19,19)/                                &
      -0.5739E-09, -0.1144E-08, -0.2283E-08, -0.4524E-08, -0.8848E-08,  &
      -0.1686E-07, -0.3096E-07, -0.5411E-07, -0.8876E-07, -0.1343E-06,  &
      -0.1880E-06, -0.2511E-06, -0.3405E-06, -0.4800E-06, -0.6756E-06,  &
      -0.9041E-06, -0.1105E-05, -0.1184E-05, -0.1049E-05, -0.6701E-06,  &
      -0.1061E-06,  0.5899E-06,  0.1376E-05,  0.2160E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=20,20)/                                &
      0.1942E-03,  0.3767E-03,  0.7173E-03,  0.1328E-02,  0.2364E-02,   &
      0.4005E-02,  0.6433E-02,  0.9873E-02,  0.1471E-01,  0.2160E-01,   &
      0.3150E-01,  0.4565E-01,  0.6537E-01,  0.9183E-01,  0.1260E+00,   &
      0.1683E+00,  0.2183E+00,  0.2738E+00,  0.3318E+00,  0.3894E+00,   &
      0.4463E+00,  0.5038E+00,  0.5619E+00,  0.6191E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=20,20)/                                &
      -0.1368E-06, -0.2791E-06, -0.5744E-06, -0.1192E-05, -0.2475E-05,  &
      -0.5078E-05, -0.1008E-04, -0.1903E-04, -0.3392E-04, -0.5726E-04,  &
      -0.9202E-04, -0.1409E-03, -0.2063E-03, -0.2912E-03, -0.3997E-03,  &
      -0.5357E-03, -0.7004E-03, -0.8911E-03, -0.1100E-02, -0.1314E-02,  &
      -0.1514E-02, -0.1687E-02, -0.1822E-02, -0.1908E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=20,20)/                                &
      -0.5617E-09, -0.1109E-08, -0.2184E-08, -0.4264E-08, -0.8251E-08,  &
      -0.1582E-07, -0.3000E-07, -0.5536E-07, -0.9656E-07, -0.1549E-06,  &
      -0.2254E-06, -0.2999E-06, -0.3855E-06, -0.5114E-06, -0.6982E-06,  &
      -0.9171E-06, -0.1082E-05, -0.1078E-05, -0.8280E-06, -0.3561E-06,  &
      0.2636E-06,  0.1015E-05,  0.1836E-05,  0.2588E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=21,21)/                                &
      0.1962E-03,  0.3831E-03,  0.7370E-03,  0.1386E-02,  0.2520E-02,   &
      0.4379E-02,  0.7206E-02,  0.1125E-01,  0.1692E-01,  0.2493E-01,   &
      0.3644E-01,  0.5299E-01,  0.7611E-01,  0.1070E+00,  0.1463E+00,   &
      0.1936E+00,  0.2474E+00,  0.3046E+00,  0.3621E+00,  0.4188E+00,   &
      0.4758E+00,  0.5339E+00,  0.5921E+00,  0.6482E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=21,21)/                                &
      -0.1371E-06, -0.2803E-06, -0.5786E-06, -0.1206E-05, -0.2522E-05,  &
      -0.5211E-05, -0.1040E-04, -0.1969E-04, -0.3522E-04, -0.6021E-04,  &
      -0.9890E-04, -0.1552E-03, -0.2312E-03, -0.3285E-03, -0.4496E-03,  &
      -0.5973E-03, -0.7728E-03, -0.9733E-03, -0.1188E-02, -0.1399E-02,  &
      -0.1590E-02, -0.1748E-02, -0.1862E-02, -0.1922E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=21,21)/                                &
      -0.5521E-09, -0.1082E-08, -0.2100E-08, -0.4025E-08, -0.7661E-08,  &
      -0.1462E-07, -0.2837E-07, -0.5493E-07, -0.1013E-06, -0.1716E-06,  &
      -0.2627E-06, -0.3609E-06, -0.4548E-06, -0.5617E-06, -0.7128E-06,  &
      -0.8814E-06, -0.9684E-06, -0.8687E-06, -0.5417E-06, -0.3260E-07,  &
      0.6298E-06,  0.1417E-05,  0.2233E-05,  0.2884E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=22,22)/                                &
      0.1974E-03,  0.3872E-03,  0.7505E-03,  0.1427E-02,  0.2638E-02,   &
      0.4682E-02,  0.7896E-02,  0.1261E-01,  0.1927E-01,  0.2865E-01,   &
      0.4207E-01,  0.6125E-01,  0.8802E-01,  0.1236E+00,  0.1681E+00,   &
      0.2201E+00,  0.2766E+00,  0.3342E+00,  0.3906E+00,  0.4468E+00,   &
      0.5043E+00,  0.5628E+00,  0.6204E+00,  0.6743E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=22,22)/                                &
      -0.1377E-06, -0.2818E-06, -0.5836E-06, -0.1222E-05, -0.2570E-05,  &
      -0.5339E-05, -0.1069E-04, -0.2019E-04, -0.3606E-04, -0.6211E-04,  &
      -0.1038E-03, -0.1666E-03, -0.2537E-03, -0.3653E-03, -0.5012E-03,  &
      -0.6623E-03, -0.8484E-03, -0.1055E-02, -0.1268E-02, -0.1470E-02,  &
      -0.1649E-02, -0.1790E-02, -0.1882E-02, -0.1920E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=22,22)/                                &
      -0.5464E-09, -0.1064E-08, -0.2050E-08, -0.3874E-08, -0.7265E-08,  &
      -0.1373E-07, -0.2688E-07, -0.5376E-07, -0.1035E-06, -0.1833E-06,  &
      -0.2955E-06, -0.4267E-06, -0.5474E-06, -0.6443E-06, -0.7332E-06,  &
      -0.7933E-06, -0.7465E-06, -0.5424E-06, -0.1941E-06,  0.3078E-06,  &
      0.9845E-06,  0.1771E-05,  0.2515E-05,  0.2962E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=23,23)/                                &
      0.1981E-03,  0.3899E-03,  0.7594E-03,  0.1455E-02,  0.2722E-02,   &
      0.4913E-02,  0.8469E-02,  0.1387E-01,  0.2168E-01,  0.3275E-01,   &
      0.4842E-01,  0.7058E-01,  0.1012E+00,  0.1414E+00,  0.1908E+00,   &
      0.2467E+00,  0.3050E+00,  0.3620E+00,  0.4176E+00,  0.4739E+00,   &
      0.5318E+00,  0.5900E+00,  0.6460E+00,  0.6969E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=23,23)/                                &
      -0.1374E-06, -0.2821E-06, -0.5849E-06, -0.1227E-05, -0.2587E-05,  &
      -0.5392E-05, -0.1082E-04, -0.2043E-04, -0.3640E-04, -0.6291E-04,  &
      -0.1064E-03, -0.1742E-03, -0.2713E-03, -0.3983E-03, -0.5523E-03,  &
      -0.7302E-03, -0.9280E-03, -0.1135E-02, -0.1338E-02, -0.1526E-02,  &
      -0.1690E-02, -0.1811E-02, -0.1880E-02, -0.1904E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=23,23)/                                &
      -0.5505E-09, -0.1066E-08, -0.2044E-08, -0.3856E-08, -0.7199E-08,  &
      -0.1353E-07, -0.2638E-07, -0.5316E-07, -0.1044E-06, -0.1908E-06,  &
      -0.3207E-06, -0.4858E-06, -0.6471E-06, -0.7512E-06, -0.7676E-06,  &
      -0.6661E-06, -0.4252E-06, -0.1067E-06,  0.2334E-06,  0.6913E-06,  &
      0.1330E-05,  0.2055E-05,  0.2617E-05,  0.2760E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=24,24)/                                &
      0.1986E-03,  0.3917E-03,  0.7654E-03,  0.1475E-02,  0.2782E-02,   &
      0.5086E-02,  0.8931E-02,  0.1497E-01,  0.2401E-01,  0.3707E-01,   &
      0.5549E-01,  0.8107E-01,  0.1157E+00,  0.1604E+00,  0.2138E+00,   &
      0.2723E+00,  0.3311E+00,  0.3877E+00,  0.4433E+00,  0.5001E+00,   &
      0.5580E+00,  0.6152E+00,  0.6683E+00,  0.7158E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=24,24)/                                &
      -0.1372E-06, -0.2802E-06, -0.5797E-06, -0.1212E-05, -0.2549E-05,  &
      -0.5312E-05, -0.1068E-04, -0.2023E-04, -0.3609E-04, -0.6255E-04,  &
      -0.1068E-03, -0.1777E-03, -0.2830E-03, -0.4252E-03, -0.6004E-03,  &
      -0.8005E-03, -0.1011E-02, -0.1213E-02, -0.1399E-02, -0.1569E-02,  &
      -0.1712E-02, -0.1809E-02, -0.1858E-02, -0.1883E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=24,24)/                                &
      -0.5589E-09, -0.1071E-08, -0.2083E-08, -0.3965E-08, -0.7465E-08,  &
      -0.1408E-07, -0.2720E-07, -0.5414E-07, -0.1061E-06, -0.1958E-06,  &
      -0.3365E-06, -0.5263E-06, -0.7236E-06, -0.8420E-06, -0.7920E-06,  &
      -0.5166E-06, -0.5606E-07,  0.4032E-06,  0.7697E-06,  0.1160E-05,  &
      0.1692E-05,  0.2251E-05,  0.2483E-05,  0.2295E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=25,25)/                                &
      0.1990E-03,  0.3929E-03,  0.7699E-03,  0.1490E-02,  0.2829E-02,   &
      0.5226E-02,  0.9314E-02,  0.1593E-01,  0.2618E-01,  0.4144E-01,   &
      0.6312E-01,  0.9271E-01,  0.1317E+00,  0.1803E+00,  0.2364E+00,   &
      0.2956E+00,  0.3541E+00,  0.4111E+00,  0.4680E+00,  0.5255E+00,   &
      0.5829E+00,  0.6376E+00,  0.6869E+00,  0.7311E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=25,25)/                                &
      -0.1366E-06, -0.2772E-06, -0.5687E-06, -0.1179E-05, -0.2458E-05,  &
      -0.5093E-05, -0.1024E-04, -0.1950E-04, -0.3503E-04, -0.6107E-04,  &
      -0.1053E-03, -0.1782E-03, -0.2902E-03, -0.4470E-03, -0.6455E-03,  &
      -0.8715E-03, -0.1095E-02, -0.1290E-02, -0.1458E-02, -0.1604E-02,  &
      -0.1716E-02, -0.1783E-02, -0.1821E-02, -0.1862E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=25,25)/                                &
      -0.5574E-09, -0.1099E-08, -0.2136E-08, -0.4136E-08, -0.7893E-08,  &
      -0.1505E-07, -0.2894E-07, -0.5650E-07, -0.1084E-06, -0.1986E-06,  &
      -0.3416E-06, -0.5381E-06, -0.7439E-06, -0.8545E-06, -0.7482E-06,  &
      -0.3541E-06,  0.2762E-06,  0.9306E-06,  0.1416E-05,  0.1754E-05,  &
      0.2105E-05,  0.2343E-05,  0.2113E-05,  0.1689E-05/
  DATA ((c1(ip,iw,1),iw=1,24),ip=26,26)/                                &
      0.1993E-03,  0.3940E-03,  0.7739E-03,  0.1503E-02,  0.2871E-02,   &
      0.5350E-02,  0.9655E-02,  0.1679E-01,  0.2817E-01,  0.4563E-01,   &
      0.7094E-01,  0.1052E+00,  0.1488E+00,  0.2006E+00,  0.2575E+00,   &
      0.3155E+00,  0.3732E+00,  0.4317E+00,  0.4909E+00,  0.5496E+00,   &
      0.6058E+00,  0.6569E+00,  0.7019E+00,  0.7436E+00/
  DATA ((c2(ip,iw,1),iw=1,24),ip=26,26)/                                &
      -0.1351E-06, -0.2730E-06, -0.5547E-06, -0.1136E-05, -0.2337E-05,  &
      -0.4789E-05, -0.9589E-05, -0.1836E-04, -0.3337E-04, -0.5890E-04,  &
      -0.1031E-03, -0.1781E-03, -0.2974E-03, -0.4696E-03, -0.6912E-03,  &
      -0.9400E-03, -0.1174E-02, -0.1368E-02, -0.1521E-02, -0.1635E-02,  &
      -0.1706E-02, -0.1742E-02, -0.1779E-02, -0.1846E-02/
  DATA ((c3(ip,iw,1),iw=1,24),ip=26,26)/                                &
      -0.5597E-09, -0.1126E-08, -0.2190E-08, -0.4298E-08, -0.8333E-08,  &
      -0.1610E-07, -0.3092E-07, -0.5912E-07, -0.1108E-06, -0.1982E-06,  &
      -0.3334E-06, -0.5129E-06, -0.6865E-06, -0.7484E-06, -0.5999E-06,  &
      -0.1961E-06,  0.5028E-06,  0.1395E-05,  0.2125E-05,  0.2489E-05,  &
      0.2584E-05,  0.2312E-05,  0.1587E-05,  0.1122E-05/
!
!-----------------------------------------------------------------------
!
!  The following DATA statements originally came from file
!  "o3.tran3", which define pre-computed tables used for o3 (band5)
!  transmittance calculations.
!
!-----------------------------------------------------------------------
!
! o3.tran3

  REAL :: o1(26,21,7),o2(26,21,7),o3(26,21,7)

  COMMON /radtab003 /o1,o2,o3

  DATA ((o1(ip,iw,1),iw=1,21),ip= 1, 1)/                                &
      0.7117E-05,  0.1419E-04,  0.2828E-04,  0.5629E-04,  0.1117E-03,   &
      0.2207E-03,  0.4326E-03,  0.8367E-03,  0.1586E-02,  0.2911E-02,   &
      0.5106E-02,  0.8433E-02,  0.1302E-01,  0.1896E-01,  0.2658E-01,   &
      0.3657E-01,  0.4988E-01,  0.6765E-01,  0.9092E-01,  0.1204E+00,   &
      0.1559E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 1, 1)/                                &
      0.6531E-10,  0.5926E-10, -0.1646E-09, -0.1454E-08, -0.7376E-08,   &
      -0.2968E-07, -0.1071E-06, -0.3584E-06, -0.1125E-05, -0.3289E-05,  &
      -0.8760E-05, -0.2070E-04, -0.4259E-04, -0.7691E-04, -0.1264E-03,  &
      -0.1957E-03, -0.2895E-03, -0.4107E-03, -0.5588E-03, -0.7300E-03,  &
      -0.9199E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 1, 1)/                                &
      -0.2438E-10, -0.4826E-10, -0.9474E-10, -0.1828E-09, -0.3406E-09,  &
      -0.6223E-09, -0.1008E-08, -0.1412E-08, -0.1244E-08,  0.8485E-09,  &
      0.6343E-08,  0.1201E-07,  0.2838E-08, -0.4024E-07, -0.1257E-06,   &
      -0.2566E-06, -0.4298E-06, -0.6184E-06, -0.7657E-06, -0.8153E-06,  &
      -0.7552E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 2, 2)/                                &
      0.7117E-05,  0.1419E-04,  0.2828E-04,  0.5629E-04,  0.1117E-03,   &
      0.2207E-03,  0.4326E-03,  0.8367E-03,  0.1586E-02,  0.2912E-02,   &
      0.5107E-02,  0.8435E-02,  0.1303E-01,  0.1897E-01,  0.2660E-01,   &
      0.3660E-01,  0.4995E-01,  0.6777E-01,  0.9114E-01,  0.1207E+00,   &
      0.1566E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 2, 2)/                                &
      0.6193E-10,  0.5262E-10, -0.1774E-09, -0.1478E-08, -0.7416E-08,   &
      -0.2985E-07, -0.1071E-06, -0.3584E-06, -0.1124E-05, -0.3287E-05,  &
      -0.8753E-05, -0.2069E-04, -0.4256E-04, -0.7686E-04, -0.1264E-03,  &
      -0.1956E-03, -0.2893E-03, -0.4103E-03, -0.5580E-03, -0.7285E-03,  &
      -0.9171E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 2, 2)/                                &
      -0.2436E-10, -0.4822E-10, -0.9466E-10, -0.1827E-09, -0.3404E-09,  &
      -0.6220E-09, -0.1008E-08, -0.1414E-08, -0.1247E-08,  0.8360E-09,  &
      0.6312E-08,  0.1194E-07,  0.2753E-08, -0.4040E-07, -0.1260E-06,   &
      -0.2571E-06, -0.4307E-06, -0.6202E-06, -0.7687E-06, -0.8204E-06,  &
      -0.7636E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 3, 3)/                                &
      0.7117E-05,  0.1419E-04,  0.2828E-04,  0.5628E-04,  0.1117E-03,   &
      0.2207E-03,  0.4326E-03,  0.8367E-03,  0.1586E-02,  0.2912E-02,   &
      0.5109E-02,  0.8439E-02,  0.1303E-01,  0.1899E-01,  0.2664E-01,   &
      0.3666E-01,  0.5005E-01,  0.6795E-01,  0.9147E-01,  0.1213E+00,   &
      0.1576E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 3, 3)/                                &
      0.5658E-10,  0.4212E-10, -0.1977E-09, -0.1516E-08, -0.7481E-08,   &
      -0.2995E-07, -0.1072E-06, -0.3583E-06, -0.1123E-05, -0.3283E-05,  &
      -0.8744E-05, -0.2067E-04, -0.4252E-04, -0.7679E-04, -0.1262E-03,  &
      -0.1953E-03, -0.2889E-03, -0.4096E-03, -0.5567E-03, -0.7263E-03,  &
      -0.9130E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 3, 3)/                                &
      -0.2433E-10, -0.4815E-10, -0.9453E-10, -0.1825E-09, -0.3400E-09,  &
      -0.6215E-09, -0.1007E-08, -0.1415E-08, -0.1253E-08,  0.8143E-09,  &
      0.6269E-08,  0.1186E-07,  0.2604E-08, -0.4067E-07, -0.1264E-06,   &
      -0.2579E-06, -0.4321E-06, -0.6229E-06, -0.7732E-06, -0.8277E-06,  &
      -0.7752E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 4, 4)/                                &
      0.7116E-05,  0.1419E-04,  0.2828E-04,  0.5628E-04,  0.1117E-03,   &
      0.2207E-03,  0.4326E-03,  0.8368E-03,  0.1586E-02,  0.2913E-02,   &
      0.5111E-02,  0.8444E-02,  0.1305E-01,  0.1902E-01,  0.2669E-01,   &
      0.3676E-01,  0.5022E-01,  0.6825E-01,  0.9199E-01,  0.1222E+00,   &
      0.1591E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 4, 4)/                                &
      0.4814E-10,  0.2552E-10, -0.2298E-09, -0.1576E-08, -0.7579E-08,   &
      -0.3009E-07, -0.1074E-06, -0.3581E-06, -0.1122E-05, -0.3278E-05,  &
      -0.8729E-05, -0.2063E-04, -0.4245E-04, -0.7667E-04, -0.1260E-03,  &
      -0.1950E-03, -0.2883E-03, -0.4086E-03, -0.5549E-03, -0.7229E-03,  &
      -0.9071E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 4, 4)/                                &
      -0.2428E-10, -0.4805E-10, -0.9433E-10, -0.1821E-09, -0.3394E-09,  &
      -0.6206E-09, -0.1008E-08, -0.1416E-08, -0.1261E-08,  0.7860E-09,  &
      0.6188E-08,  0.1171E-07,  0.2389E-08, -0.4109E-07, -0.1271E-06,   &
      -0.2591E-06, -0.4344E-06, -0.6267E-06, -0.7797E-06, -0.8378E-06,  &
      -0.7901E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 5, 5)/                                &
      0.7116E-05,  0.1419E-04,  0.2827E-04,  0.5627E-04,  0.1117E-03,   &
      0.2207E-03,  0.4326E-03,  0.8368E-03,  0.1586E-02,  0.2914E-02,   &
      0.5114E-02,  0.8454E-02,  0.1307E-01,  0.1906E-01,  0.2677E-01,   &
      0.3690E-01,  0.5048E-01,  0.6872E-01,  0.9281E-01,  0.1236E+00,   &
      0.1615E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 5, 5)/                                &
      0.3482E-10, -0.6492E-12, -0.2805E-09, -0.1671E-08, -0.7740E-08,   &
      -0.3032E-07, -0.1076E-06, -0.3582E-06, -0.1120E-05, -0.3270E-05,  &
      -0.8704E-05, -0.2058E-04, -0.4235E-04, -0.7649E-04, -0.1257E-03,  &
      -0.1945E-03, -0.2874E-03, -0.4070E-03, -0.5521E-03, -0.7181E-03,  &
      -0.8990E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 5, 5)/                                &
      -0.2419E-10, -0.4788E-10, -0.9401E-10, -0.1815E-09, -0.3385E-09,  &
      -0.6192E-09, -0.1006E-08, -0.1417E-08, -0.1273E-08,  0.7404E-09,  &
      0.6068E-08,  0.1148E-07,  0.2021E-08, -0.4165E-07, -0.1281E-06,   &
      -0.2609E-06, -0.4375E-06, -0.6323E-06, -0.7887E-06, -0.8508E-06,  &
      -0.8067E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 6, 6)/                                &
      0.7114E-05,  0.1419E-04,  0.2827E-04,  0.5627E-04,  0.1117E-03,   &
      0.2207E-03,  0.4325E-03,  0.8369E-03,  0.1587E-02,  0.2916E-02,   &
      0.5120E-02,  0.8468E-02,  0.1310E-01,  0.1913E-01,  0.2690E-01,   &
      0.3714E-01,  0.5090E-01,  0.6944E-01,  0.9407E-01,  0.1258E+00,   &
      0.1651E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 6, 6)/                                &
      0.1388E-10, -0.4180E-10, -0.3601E-09, -0.1820E-08, -0.7993E-08,   &
      -0.3068E-07, -0.1081E-06, -0.3580E-06, -0.1117E-05, -0.3257E-05,  &
      -0.8667E-05, -0.2049E-04, -0.4218E-04, -0.7620E-04, -0.1253E-03,  &
      -0.1937E-03, -0.2860E-03, -0.4047E-03, -0.5481E-03, -0.7115E-03,  &
      -0.8885E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 6, 6)/                                &
      -0.2406E-10, -0.4762E-10, -0.9351E-10, -0.1806E-09, -0.3370E-09,  &
      -0.6170E-09, -0.1004E-08, -0.1417E-08, -0.1297E-08,  0.6738E-09,  &
      0.5895E-08,  0.1113E-07,  0.1466E-08, -0.4265E-07, -0.1298E-06,   &
      -0.2636E-06, -0.4423E-06, -0.6402E-06, -0.8005E-06, -0.8658E-06,  &
      -0.8222E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 7, 7)/                                &
      0.7113E-05,  0.1418E-04,  0.2826E-04,  0.5625E-04,  0.1117E-03,   &
      0.2206E-03,  0.4325E-03,  0.8371E-03,  0.1588E-02,  0.2918E-02,   &
      0.5128E-02,  0.8491E-02,  0.1315E-01,  0.1923E-01,  0.2710E-01,   &
      0.3750E-01,  0.5154E-01,  0.7056E-01,  0.9600E-01,  0.1290E+00,   &
      0.1703E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 7, 7)/                                &
      -0.1889E-10, -0.1062E-09, -0.4847E-09, -0.2053E-08, -0.8389E-08,  &
      -0.3140E-07, -0.1089E-06, -0.3577E-06, -0.1112E-05, -0.3236E-05,  &
      -0.8607E-05, -0.2035E-04, -0.4192E-04, -0.7576E-04, -0.1245E-03,  &
      -0.1925E-03, -0.2840E-03, -0.4013E-03, -0.5427E-03, -0.7029E-03,  &
      -0.8756E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 7, 7)/                                &
      -0.2385E-10, -0.4722E-10, -0.9273E-10, -0.1791E-09, -0.3348E-09,  &
      -0.6121E-09, -0.9974E-09, -0.1422E-08, -0.1326E-08,  0.5603E-09,  &
      0.5604E-08,  0.1061E-07,  0.6106E-09, -0.4398E-07, -0.1321E-06,   &
      -0.2676E-06, -0.4490E-06, -0.6507E-06, -0.8145E-06, -0.8801E-06,  &
      -0.8311E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 8, 8)/                                &
      0.7110E-05,  0.1418E-04,  0.2825E-04,  0.5623E-04,  0.1116E-03,   &
      0.2206E-03,  0.4325E-03,  0.8373E-03,  0.1589E-02,  0.2923E-02,   &
      0.5141E-02,  0.8526E-02,  0.1324E-01,  0.1940E-01,  0.2741E-01,   &
      0.3807E-01,  0.5253E-01,  0.7227E-01,  0.9889E-01,  0.1338E+00,   &
      0.1777E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 8, 8)/                                &
      -0.6983E-10, -0.2063E-09, -0.6785E-09, -0.2416E-08, -0.9000E-08,  &
      -0.3243E-07, -0.1100E-06, -0.3574E-06, -0.1104E-05, -0.3205E-05,  &
      -0.8516E-05, -0.2014E-04, -0.4151E-04, -0.7508E-04, -0.1234E-03,  &
      -0.1907E-03, -0.2811E-03, -0.3966E-03, -0.5355E-03, -0.6924E-03,  &
      -0.8613E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 8, 8)/                                &
      -0.2353E-10, -0.4659E-10, -0.9153E-10, -0.1769E-09, -0.3313E-09,  &
      -0.6054E-09, -0.9899E-09, -0.1430E-08, -0.1375E-08,  0.3874E-09,  &
      0.5171E-08,  0.9807E-08, -0.7345E-09, -0.4604E-07, -0.1356E-06,   &
      -0.2731E-06, -0.4577E-06, -0.6632E-06, -0.8284E-06, -0.8894E-06,  &
      -0.8267E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip= 9, 9)/                                &
      0.7105E-05,  0.1417E-04,  0.2823E-04,  0.5620E-04,  0.1116E-03,   &
      0.2205E-03,  0.4325E-03,  0.8376E-03,  0.1591E-02,  0.2929E-02,   &
      0.5162E-02,  0.8581E-02,  0.1336E-01,  0.1966E-01,  0.2790E-01,   &
      0.3894E-01,  0.5404E-01,  0.7484E-01,  0.1031E+00,  0.1405E+00,   &
      0.1880E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip= 9, 9)/                                &
      -0.1481E-09, -0.3601E-09, -0.9762E-09, -0.2973E-08, -0.1014E-07,  &
      -0.3421E-07, -0.1121E-06, -0.3569E-06, -0.1092E-05, -0.3156E-05,  &
      -0.8375E-05, -0.1981E-04, -0.4090E-04, -0.7405E-04, -0.1218E-03,  &
      -0.1881E-03, -0.2770E-03, -0.3906E-03, -0.5269E-03, -0.6810E-03,  &
      -0.8471E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip= 9, 9)/                                &
      -0.2304E-10, -0.4564E-10, -0.8969E-10, -0.1735E-09, -0.3224E-09,  &
      -0.5933E-09, -0.9756E-09, -0.1428E-08, -0.1446E-08,  0.1156E-09,  &
      0.4499E-08,  0.8469E-08, -0.2720E-08, -0.4904E-07, -0.1401E-06,   &
      -0.2801E-06, -0.4681E-06, -0.6761E-06, -0.8387E-06, -0.8879E-06,  &
      -0.8040E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=10,10)/                                &
      0.7098E-05,  0.1415E-04,  0.2821E-04,  0.5615E-04,  0.1115E-03,   &
      0.2204E-03,  0.4325E-03,  0.8382E-03,  0.1593E-02,  0.2940E-02,   &
      0.5194E-02,  0.8666E-02,  0.1356E-01,  0.2006E-01,  0.2865E-01,   &
      0.4026E-01,  0.5631E-01,  0.7863E-01,  0.1093E+00,  0.1500E+00,   &
      0.2017E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=10,10)/                                &
      -0.2661E-09, -0.5923E-09, -0.1426E-08, -0.3816E-08, -0.1159E-07,  &
      -0.3654E-07, -0.1143E-06, -0.3559E-06, -0.1074E-05, -0.3083E-05,  &
      -0.8159E-05, -0.1932E-04, -0.3998E-04, -0.7253E-04, -0.1194E-03,  &
      -0.1845E-03, -0.2718E-03, -0.3833E-03, -0.5176E-03, -0.6701E-03,  &
      -0.8354E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=10,10)/                                &
      -0.2232E-10, -0.4421E-10, -0.8695E-10, -0.1684E-09, -0.3141E-09,  &
      -0.5765E-09, -0.9606E-09, -0.1434E-08, -0.1551E-08, -0.2663E-09,  &
      0.3515E-08,  0.6549E-08, -0.5479E-08, -0.5312E-07, -0.1460E-06,   &
      -0.2883E-06, -0.4787E-06, -0.6863E-06, -0.8399E-06, -0.8703E-06,  &
      -0.7602E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=11,11)/                                &
      0.7088E-05,  0.1413E-04,  0.2817E-04,  0.5608E-04,  0.1114E-03,   &
      0.2203E-03,  0.4325E-03,  0.8390E-03,  0.1598E-02,  0.2955E-02,   &
      0.5242E-02,  0.8796E-02,  0.1386E-01,  0.2067E-01,  0.2978E-01,   &
      0.4224E-01,  0.5964E-01,  0.8406E-01,  0.1178E+00,  0.1627E+00,   &
      0.2197E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=11,11)/                                &
      -0.4394E-09, -0.9330E-09, -0.2086E-08, -0.5054E-08, -0.1373E-07,  &
      -0.3971E-07, -0.1178E-06, -0.3546E-06, -0.1049E-05, -0.2976E-05,  &
      -0.7847E-05, -0.1860E-04, -0.3864E-04, -0.7038E-04, -0.1162E-03,  &
      -0.1798E-03, -0.2654E-03, -0.3754E-03, -0.5091E-03, -0.6621E-03,  &
      -0.8286E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=11,11)/                                &
      -0.2127E-10, -0.4216E-10, -0.8300E-10, -0.1611E-09, -0.3019E-09,  &
      -0.5597E-09, -0.9431E-09, -0.1450E-08, -0.1694E-08, -0.7913E-09,  &
      0.2144E-08,  0.3990E-08, -0.9282E-08, -0.5810E-07, -0.1525E-06,   &
      -0.2965E-06, -0.4869E-06, -0.6894E-06, -0.8281E-06, -0.8350E-06,  &
      -0.6956E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=12,12)/                                &
      0.7073E-05,  0.1411E-04,  0.2811E-04,  0.5598E-04,  0.1112E-03,   &
      0.2201E-03,  0.4324E-03,  0.8401E-03,  0.1604E-02,  0.2978E-02,   &
      0.5313E-02,  0.8987E-02,  0.1431E-01,  0.2158E-01,  0.3145E-01,   &
      0.4512E-01,  0.6440E-01,  0.9161E-01,  0.1293E+00,  0.1793E+00,   &
      0.2426E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=12,12)/                                &
      -0.6829E-09, -0.1412E-08, -0.3014E-08, -0.6799E-08, -0.1675E-07,  &
      -0.4450E-07, -0.1235E-06, -0.3538E-06, -0.1014E-05, -0.2827E-05,  &
      -0.7407E-05, -0.1759E-04, -0.3676E-04, -0.6744E-04, -0.1120E-03,  &
      -0.1742E-03, -0.2585E-03, -0.3683E-03, -0.5034E-03, -0.6594E-03,  &
      -0.8290E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=12,12)/                                &
      -0.1985E-10, -0.3937E-10, -0.7761E-10, -0.1511E-09, -0.2855E-09,  &
      -0.5313E-09, -0.9251E-09, -0.1470E-08, -0.1898E-08, -0.1519E-08,  &
      0.2914E-09,  0.5675E-09, -0.1405E-07, -0.6359E-07, -0.1584E-06,   &
      -0.3020E-06, -0.4893E-06, -0.6821E-06, -0.8021E-06, -0.7834E-06,  &
      -0.6105E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=13,13)/                                &
      0.7053E-05,  0.1407E-04,  0.2804E-04,  0.5584E-04,  0.1110E-03,   &
      0.2198E-03,  0.4324E-03,  0.8420E-03,  0.1613E-02,  0.3011E-02,   &
      0.5416E-02,  0.9263E-02,  0.1495E-01,  0.2289E-01,  0.3384E-01,   &
      0.4918E-01,  0.7096E-01,  0.1018E+00,  0.1442E+00,  0.2004E+00,   &
      0.2708E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=13,13)/                                &
      -0.1004E-08, -0.2043E-08, -0.4239E-08, -0.9104E-08, -0.2075E-07,  &
      -0.5096E-07, -0.1307E-06, -0.3520E-06, -0.9671E-06, -0.2630E-05,  &
      -0.6825E-05, -0.1624E-04, -0.3429E-04, -0.6369E-04, -0.1069E-03,  &
      -0.1680E-03, -0.2520E-03, -0.3635E-03, -0.5029E-03, -0.6647E-03,  &
      -0.8390E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=13,13)/                                &
      -0.1807E-10, -0.3587E-10, -0.7085E-10, -0.1385E-09, -0.2648E-09,  &
      -0.4958E-09, -0.8900E-09, -0.1473E-08, -0.2112E-08, -0.2399E-08,  &
      -0.2002E-08, -0.3646E-08, -0.1931E-07, -0.6852E-07, -0.1618E-06,  &
      -0.3021E-06, -0.4828E-06, -0.6634E-06, -0.7643E-06, -0.7177E-06,  &
      -0.5054E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=14,14)/                                &
      0.7029E-05,  0.1402E-04,  0.2795E-04,  0.5567E-04,  0.1107E-03,   &
      0.2195E-03,  0.4326E-03,  0.8447E-03,  0.1625E-02,  0.3056E-02,   &
      0.5554E-02,  0.9638E-02,  0.1584E-01,  0.2470E-01,  0.3713E-01,   &
      0.5470E-01,  0.7969E-01,  0.1149E+00,  0.1631E+00,  0.2263E+00,   &
      0.3045E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=14,14)/                                &
      -0.1387E-08, -0.2798E-08, -0.5706E-08, -0.1187E-07, -0.2564E-07,  &
      -0.5866E-07, -0.1398E-06, -0.3516E-06, -0.9148E-06, -0.2398E-05,  &
      -0.6122E-05, -0.1459E-04, -0.3125E-04, -0.5923E-04, -0.1013E-03,  &
      -0.1620E-03, -0.2473E-03, -0.3631E-03, -0.5098E-03, -0.6800E-03,  &
      -0.8603E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=14,14)/                                &
      -0.1610E-10, -0.3200E-10, -0.6337E-10, -0.1245E-09, -0.2408E-09,  &
      -0.4533E-09, -0.8405E-09, -0.1464E-08, -0.2337E-08, -0.3341E-08,  &
      -0.4467E-08, -0.8154E-08, -0.2436E-07, -0.7128E-07, -0.1604E-06,  &
      -0.2945E-06, -0.4666E-06, -0.6357E-06, -0.7187E-06, -0.6419E-06,  &
      -0.3795E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=15,15)/                                &
      0.7003E-05,  0.1397E-04,  0.2785E-04,  0.5550E-04,  0.1104E-03,   &
      0.2192E-03,  0.4329E-03,  0.8481E-03,  0.1641E-02,  0.3112E-02,   &
      0.5729E-02,  0.1012E-01,  0.1698E-01,  0.2708E-01,  0.4146E-01,   &
      0.6189E-01,  0.9085E-01,  0.1313E+00,  0.1862E+00,  0.2571E+00,   &
      0.3433E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=15,15)/                                &
      -0.1788E-08, -0.3588E-08, -0.7244E-08, -0.1479E-07, -0.3083E-07,  &
      -0.6671E-07, -0.1497E-06, -0.3519E-06, -0.8607E-06, -0.2154E-05,  &
      -0.5364E-05, -0.1276E-04, -0.2785E-04, -0.5435E-04, -0.9573E-04,  &
      -0.1570E-03, -0.2455E-03, -0.3682E-03, -0.5253E-03, -0.7065E-03,  &
      -0.8938E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=15,15)/                                &
      -0.1429E-10, -0.2843E-10, -0.5645E-10, -0.1115E-09, -0.2181E-09,  &
      -0.4200E-09, -0.7916E-09, -0.1460E-08, -0.2542E-08, -0.4168E-08,  &
      -0.6703E-08, -0.1215E-07, -0.2821E-07, -0.7073E-07, -0.1530E-06,  &
      -0.2791E-06, -0.4426E-06, -0.6027E-06, -0.6707E-06, -0.5591E-06,  &
      -0.2328E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=16,16)/                                &
      0.6981E-05,  0.1393E-04,  0.2777E-04,  0.5535E-04,  0.1102E-03,   &
      0.2190E-03,  0.4336E-03,  0.8527E-03,  0.1660E-02,  0.3177E-02,   &
      0.5930E-02,  0.1068E-01,  0.1836E-01,  0.3000E-01,  0.4686E-01,   &
      0.7083E-01,  0.1046E+00,  0.1511E+00,  0.2134E+00,  0.2924E+00,   &
      0.3861E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=16,16)/                                &
      -0.2141E-08, -0.4286E-08, -0.8603E-08, -0.1737E-07, -0.3548E-07,  &
      -0.7410E-07, -0.1590E-06, -0.3537E-06, -0.8142E-06, -0.1935E-05,  &
      -0.4658E-05, -0.1099E-04, -0.2444E-04, -0.4948E-04, -0.9067E-04,  &
      -0.1538E-03, -0.2474E-03, -0.3793E-03, -0.5495E-03, -0.7439E-03,  &
      -0.9383E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=16,16)/                                &
      -0.1295E-10, -0.2581E-10, -0.5136E-10, -0.1019E-09, -0.2011E-09,  &
      -0.3916E-09, -0.7585E-09, -0.1439E-08, -0.2648E-08, -0.4747E-08,  &
      -0.8301E-08, -0.1499E-07, -0.3024E-07, -0.6702E-07, -0.1399E-06,  &
      -0.2564E-06, -0.4117E-06, -0.5669E-06, -0.6239E-06, -0.4748E-06,  &
      -0.7013E-07/
  DATA ((o1(ip,iw,1),iw=1,21),ip=17,17)/                                &
      0.6967E-05,  0.1390E-04,  0.2772E-04,  0.5527E-04,  0.1101E-03,   &
      0.2191E-03,  0.4346E-03,  0.8579E-03,  0.1679E-02,  0.3244E-02,   &
      0.6139E-02,  0.1127E-01,  0.1986E-01,  0.3330E-01,  0.5315E-01,   &
      0.8139E-01,  0.1207E+00,  0.1741E+00,  0.2442E+00,  0.3311E+00,   &
      0.4312E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=17,17)/                                &
      -0.2400E-08, -0.4796E-08, -0.9599E-08, -0.1927E-07, -0.3892E-07,  &
      -0.7954E-07, -0.1661E-06, -0.3540E-06, -0.7780E-06, -0.1763E-05,  &
      -0.4092E-05, -0.9512E-05, -0.2142E-04, -0.4502E-04, -0.8640E-04,  &
      -0.1525E-03, -0.2526E-03, -0.3955E-03, -0.5805E-03, -0.7897E-03,  &
      -0.9899E-03/
  DATA ((o3(ip,iw,1),iw=1,21),ip=17,17)/                                &
      -0.1220E-10, -0.2432E-10, -0.4845E-10, -0.9640E-10, -0.1912E-09,  &
      -0.3771E-09, -0.7392E-09, -0.1420E-08, -0.2702E-08, -0.5049E-08,  &
      -0.9214E-08, -0.1659E-07, -0.3101E-07, -0.6162E-07, -0.1235E-06,  &
      -0.2287E-06, -0.3755E-06, -0.5274E-06, -0.5790E-06, -0.3947E-06,  &
      0.1003E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=18,18)/                                &
      0.6963E-05,  0.1389E-04,  0.2771E-04,  0.5526E-04,  0.1101E-03,   &
      0.2193E-03,  0.4359E-03,  0.8629E-03,  0.1698E-02,  0.3305E-02,   &
      0.6331E-02,  0.1183E-01,  0.2133E-01,  0.3671E-01,  0.5996E-01,   &
      0.9320E-01,  0.1389E+00,  0.1999E+00,  0.2778E+00,  0.3717E+00,   &
      0.4761E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=18,18)/                                &
      -0.2557E-08, -0.5106E-08, -0.1020E-07, -0.2043E-07, -0.4103E-07,  &
      -0.8293E-07, -0.1697E-06, -0.3531E-06, -0.7531E-06, -0.1645E-05,  &
      -0.3690E-05, -0.8411E-05, -0.1902E-04, -0.4118E-04, -0.8276E-04,  &
      -0.1525E-03, -0.2601E-03, -0.4147E-03, -0.6149E-03, -0.8384E-03,  &
      -0.1042E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=18,18)/                                &
      -0.1189E-10, -0.2372E-10, -0.4729E-10, -0.9421E-10, -0.1873E-09,  &
      -0.3713E-09, -0.7317E-09, -0.1437E-08, -0.2764E-08, -0.5243E-08,  &
      -0.9691E-08, -0.1751E-07, -0.3122E-07, -0.5693E-07, -0.1076E-06,  &
      -0.1981E-06, -0.3324E-06, -0.4785E-06, -0.5280E-06, -0.3174E-06,  &
      0.2672E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=19,19)/                                &
      0.6963E-05,  0.1389E-04,  0.2771E-04,  0.5528E-04,  0.1102E-03,   &
      0.2196E-03,  0.4370E-03,  0.8672E-03,  0.1712E-02,  0.3355E-02,   &
      0.6488E-02,  0.1230E-01,  0.2262E-01,  0.3989E-01,  0.6677E-01,   &
      0.1056E+00,  0.1586E+00,  0.2276E+00,  0.3131E+00,  0.4124E+00,   &
      0.5188E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=19,19)/                                &
      -0.2630E-08, -0.5249E-08, -0.1048E-07, -0.2096E-07, -0.4198E-07,  &
      -0.8440E-07, -0.1710E-06, -0.3513E-06, -0.7326E-06, -0.1562E-05,  &
      -0.3416E-05, -0.7637E-05, -0.1719E-04, -0.3795E-04, -0.7926E-04,  &
      -0.1524E-03, -0.2680E-03, -0.4344E-03, -0.6486E-03, -0.8838E-03,  &
      -0.1089E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=19,19)/                                &
      -0.1188E-10, -0.2369E-10, -0.4725E-10, -0.9417E-10, -0.1875E-09,  &
      -0.3725E-09, -0.7365E-09, -0.1445E-08, -0.2814E-08, -0.5384E-08,  &
      -0.1008E-07, -0.1816E-07, -0.3179E-07, -0.5453E-07, -0.9500E-07,  &
      -0.1679E-06, -0.2819E-06, -0.4109E-06, -0.4555E-06, -0.2283E-06,  &
      0.4283E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=20,20)/                                &
      0.6963E-05,  0.1389E-04,  0.2772E-04,  0.5529E-04,  0.1103E-03,   &
      0.2198E-03,  0.4377E-03,  0.8701E-03,  0.1723E-02,  0.3391E-02,   &
      0.6606E-02,  0.1266E-01,  0.2366E-01,  0.4262E-01,  0.7304E-01,   &
      0.1179E+00,  0.1789E+00,  0.2563E+00,  0.3487E+00,  0.4516E+00,   &
      0.5572E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=20,20)/                                &
      -0.2651E-08, -0.5291E-08, -0.1056E-07, -0.2110E-07, -0.4221E-07,  &
      -0.8462E-07, -0.1705E-06, -0.3466E-06, -0.7155E-06, -0.1501E-05,  &
      -0.3223E-05, -0.7079E-05, -0.1581E-04, -0.3517E-04, -0.7553E-04,  &
      -0.1510E-03, -0.2746E-03, -0.4528E-03, -0.6789E-03, -0.9214E-03,  &
      -0.1124E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=20,20)/                                &
      -0.1193E-10, -0.2380E-10, -0.4748E-10, -0.9465E-10, -0.1886E-09,  &
      -0.3751E-09, -0.7436E-09, -0.1466E-08, -0.2872E-08, -0.5508E-08,  &
      -0.1038E-07, -0.1891E-07, -0.3279E-07, -0.5420E-07, -0.8711E-07,  &
      -0.1403E-06, -0.2248E-06, -0.3221E-06, -0.3459E-06, -0.1066E-06,  &
      0.5938E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=21,21)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5530E-04,  0.1103E-03,   &
      0.2199E-03,  0.4382E-03,  0.8719E-03,  0.1730E-02,  0.3416E-02,   &
      0.6690E-02,  0.1293E-01,  0.2445E-01,  0.4479E-01,  0.7837E-01,   &
      0.1291E+00,  0.1985E+00,  0.2846E+00,  0.3831E+00,  0.4875E+00,   &
      0.5902E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=21,21)/                                &
      -0.2654E-08, -0.5296E-08, -0.1057E-07, -0.2111E-07, -0.4219E-07,  &
      -0.8445E-07, -0.1696E-06, -0.3428E-06, -0.7013E-06, -0.1458E-05,  &
      -0.3084E-05, -0.6678E-05, -0.1476E-04, -0.3284E-04, -0.7173E-04,  &
      -0.1481E-03, -0.2786E-03, -0.4688E-03, -0.7052E-03, -0.9506E-03,  &
      -0.1148E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=21,21)/                                &
      -0.1195E-10, -0.2384E-10, -0.4755E-10, -0.9482E-10, -0.1890E-09,  &
      -0.3761E-09, -0.7469E-09, -0.1476E-08, -0.2892E-08, -0.5603E-08,  &
      -0.1060E-07, -0.1942E-07, -0.3393E-07, -0.5508E-07, -0.8290E-07,  &
      -0.1182E-06, -0.1657E-06, -0.2170E-06, -0.1997E-06,  0.6227E-07,  &
      0.7847E-06/
  DATA ((o1(ip,iw,1),iw=1,21),ip=22,22)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5530E-04,  0.1103E-03,   &
      0.2200E-03,  0.4385E-03,  0.8731E-03,  0.1735E-02,  0.3433E-02,   &
      0.6748E-02,  0.1311E-01,  0.2502E-01,  0.4642E-01,  0.8258E-01,   &
      0.1385E+00,  0.2160E+00,  0.3107E+00,  0.4146E+00,  0.5188E+00,   &
      0.6171E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=22,22)/                                &
      -0.2653E-08, -0.5295E-08, -0.1057E-07, -0.2110E-07, -0.4215E-07,  &
      -0.8430E-07, -0.1690E-06, -0.3403E-06, -0.6919E-06, -0.1427E-05,  &
      -0.2991E-05, -0.6399E-05, -0.1398E-04, -0.3099E-04, -0.6824E-04,  &
      -0.1441E-03, -0.2795E-03, -0.4814E-03, -0.7282E-03, -0.9739E-03,  &
      -0.1163E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=22,22)/                                &
      -0.1195E-10, -0.2384E-10, -0.4756E-10, -0.9485E-10, -0.1891E-09,  &
      -0.3765E-09, -0.7483E-09, -0.1481E-08, -0.2908E-08, -0.5660E-08,  &
      -0.1075E-07, -0.1980E-07, -0.3472E-07, -0.5626E-07, -0.8149E-07,  &
      -0.1027E-06, -0.1136E-06, -0.1071E-06, -0.2991E-07,  0.2743E-06,  &
      0.1017E-05/
  DATA ((o1(ip,iw,1),iw=1,21),ip=23,23)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5530E-04,  0.1103E-03,   &
      0.2200E-03,  0.4387E-03,  0.8738E-03,  0.1738E-02,  0.3445E-02,   &
      0.6786E-02,  0.1324E-01,  0.2541E-01,  0.4757E-01,  0.8567E-01,   &
      0.1459E+00,  0.2303E+00,  0.3331E+00,  0.4415E+00,  0.5444E+00,   &
      0.6377E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=23,23)/                                &
      -0.2653E-08, -0.5294E-08, -0.1057E-07, -0.2109E-07, -0.4212E-07,  &
      -0.8420E-07, -0.1686E-06, -0.3388E-06, -0.6858E-06, -0.1406E-05,  &
      -0.2928E-05, -0.6206E-05, -0.1344E-04, -0.2961E-04, -0.6533E-04,  &
      -0.1399E-03, -0.2780E-03, -0.4904E-03, -0.7488E-03, -0.9953E-03,  &
      -0.1175E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=23,23)/                                &
      -0.1195E-10, -0.2384E-10, -0.4756E-10, -0.9485E-10, -0.1891E-09,  &
      -0.3767E-09, -0.7492E-09, -0.1485E-08, -0.2924E-08, -0.5671E-08,  &
      -0.1084E-07, -0.2009E-07, -0.3549E-07, -0.5773E-07, -0.8208E-07,  &
      -0.9394E-07, -0.7270E-07, -0.3947E-08,  0.1456E-06,  0.5083E-06,  &
      0.1270E-05/
  DATA ((o1(ip,iw,1),iw=1,21),ip=24,24)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5531E-04,  0.1103E-03,   &
      0.2201E-03,  0.4388E-03,  0.8743E-03,  0.1740E-02,  0.3452E-02,   &
      0.6811E-02,  0.1332E-01,  0.2567E-01,  0.4835E-01,  0.8782E-01,   &
      0.1511E+00,  0.2412E+00,  0.3507E+00,  0.4627E+00,  0.5638E+00,   &
      0.6526E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=24,24)/                                &
      -0.2653E-08, -0.5294E-08, -0.1056E-07, -0.2109E-07, -0.4210E-07,  &
      -0.8413E-07, -0.1684E-06, -0.3379E-06, -0.6820E-06, -0.1393E-05,  &
      -0.2889E-05, -0.6080E-05, -0.1307E-04, -0.2861E-04, -0.6310E-04,  &
      -0.1363E-03, -0.2758E-03, -0.4969E-03, -0.7681E-03, -0.1017E-02,  &
      -0.1186E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=24,24)/                                &
      -0.1195E-10, -0.2384E-10, -0.4756E-10, -0.9485E-10, -0.1891E-09,  &
      -0.3768E-09, -0.7497E-09, -0.1487E-08, -0.2933E-08, -0.5710E-08,  &
      -0.1089E-07, -0.2037E-07, -0.3616E-07, -0.5907E-07, -0.8351E-07,  &
      -0.8925E-07, -0.4122E-07,  0.8779E-07,  0.3143E-06,  0.7281E-06,  &
      0.1500E-05/
  DATA ((o1(ip,iw,1),iw=1,21),ip=25,25)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5531E-04,  0.1103E-03,   &
      0.2201E-03,  0.4388E-03,  0.8745E-03,  0.1741E-02,  0.3456E-02,   &
      0.6827E-02,  0.1337E-01,  0.2584E-01,  0.4885E-01,  0.8924E-01,   &
      0.1547E+00,  0.2488E+00,  0.3632E+00,  0.4779E+00,  0.5771E+00,   &
      0.6627E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=25,25)/                                &
      -0.2653E-08, -0.5293E-08, -0.1056E-07, -0.2108E-07, -0.4209E-07,  &
      -0.8409E-07, -0.1682E-06, -0.3373E-06, -0.6797E-06, -0.1383E-05,  &
      -0.2862E-05, -0.5993E-05, -0.1283E-04, -0.2795E-04, -0.6158E-04,  &
      -0.1338E-03, -0.2743E-03, -0.5030E-03, -0.7863E-03, -0.1038E-02,  &
      -0.1196E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=25,25)/                                &
      -0.1195E-10, -0.2383E-10, -0.4755E-10, -0.9484E-10, -0.1891E-09,  &
      -0.3768E-09, -0.7499E-09, -0.1489E-08, -0.2939E-08, -0.5741E-08,  &
      -0.1100E-07, -0.2066E-07, -0.3660E-07, -0.6002E-07, -0.8431E-07,  &
      -0.8556E-07, -0.1674E-07,  0.1638E-06,  0.4525E-06,  0.8949E-06,  &
      0.1669E-05/
  DATA ((o1(ip,iw,1),iw=1,21),ip=26,26)/                                &
      0.6964E-05,  0.1389E-04,  0.2772E-04,  0.5531E-04,  0.1103E-03,   &
      0.2201E-03,  0.4389E-03,  0.8747E-03,  0.1741E-02,  0.3458E-02,   &
      0.6836E-02,  0.1340E-01,  0.2594E-01,  0.4916E-01,  0.9011E-01,   &
      0.1569E+00,  0.2536E+00,  0.3714E+00,  0.4877E+00,  0.5856E+00,   &
      0.6695E+00/
  DATA ((o2(ip,iw,1),iw=1,21),ip=26,26)/                                &
      -0.2652E-08, -0.5292E-08, -0.1056E-07, -0.2108E-07, -0.4208E-07,  &
      -0.8406E-07, -0.1681E-06, -0.3369E-06, -0.6784E-06, -0.1378E-05,  &
      -0.2843E-05, -0.5944E-05, -0.1269E-04, -0.2759E-04, -0.6078E-04,  &
      -0.1326E-03, -0.2742E-03, -0.5088E-03, -0.8013E-03, -0.1054E-02,  &
      -0.1202E-02/
  DATA ((o3(ip,iw,1),iw=1,21),ip=26,26)/                                &
      -0.1194E-10, -0.2383E-10, -0.4754E-10, -0.9482E-10, -0.1891E-09,  &
      -0.3768E-09, -0.7499E-09, -0.1489E-08, -0.2941E-08, -0.5752E-08,  &
      -0.1104E-07, -0.2069E-07, -0.3661E-07, -0.6012E-07, -0.8399E-07,  &
      -0.8183E-07,  0.1930E-08,  0.2167E-06,  0.5434E-06,  0.9990E-06,  &
      0.1787E-05/
!
!-----------------------------------------------------------------------
!
!  The following DATA statements originally came from file
!  "cai.dat", which define pre-computed tables cai
!
!-----------------------------------------------------------------------
!
!  integer   nm,nt,na
!  parameter (nm=11,nt=9,na=11)

  REAL :: caib(11,9,11),caif(9,11)

  COMMON /radtab004/ caib,caif

  DATA ((caib(1,i,j),j=1,11),i=1,9)/                                    &
      0.,0.084,0.170,0.258,0.349,0.442,0.540,0.643,0.752,0.870,1.,      &
      0.,0.076,0.153,0.233,0.315,0.401,0.492,0.589,0.698,0.826,1.,      &
      0.,0.069,0.139,0.210,0.283,0.359,0.438,0.523,0.619,0.741,1.,      &
      0.,0.065,0.130,0.196,0.263,0.332,0.403,0.478,0.561,0.671,1.,      &
      0.,0.062,0.126,0.189,0.253,0.318,0.385,0.454,0.533,0.681,1.,      &
      0.,0.062,0.123,0.185,0.248,0.311,0.375,0.444,0.539,0.738,1.,      &
      0.,0.061,0.122,0.183,0.244,0.307,0.370,0.444,0.577,0.752,1.,      &
      0.,0.060,0.121,0.182,0.243,0.304,0.368,0.457,0.574,0.732,1.,      &
      0.,0.060,0.120,0.181,0.242,0.302,0.367,0.451,0.551,0.690,1./
  DATA ((caib(2,i,j),j=1,11),i=1,9)/                                    &
      0.,0.094,0.190,0.286,0.384,0.482,0.583,0.684,0.788,0.893,1.,      &
      0.,0.090,0.180,0.274,0.368,0.466,0.566,0.668,0.774,0.885,1.,      &
      0.,0.082,0.167,0.254,0.343,0.436,0.533,0.636,0.746,0.866,1.,      &
      0.,0.074,0.151,0.229,0.310,0.395,0.485,0.582,0.692,0.822,1.,      &
      0.,0.068,0.138,0.209,0.282,0.358,0.439,0.527,0.630,0.769,1.,      &
      0.,0.065,0.130,0.197,0.265,0.336,0.410,0.493,0.599,0.766,1.,      &
      0.,0.063,0.126,0.190,0.256,0.323,0.394,0.480,0.604,0.772,1.,      &
      0.,0.062,0.124,0.186,0.249,0.314,0.385,0.475,0.594,0.749,1.,      &
      0.,0.061,0.122,0.183,0.245,0.309,0.378,0.462,0.564,0.704,1./
  DATA ((caib(3,i,j),j=1,11),i=1,9)/                                    &
      0.,0.097,0.194,0.292,0.392,0.491,0.591,0.692,0.794,0.897,1.,      &
      0.,0.094,0.189,0.286,0.383,0.482,0.582,0.684,0.788,0.893,1.,      &
      0.,0.090,0.180,0.274,0.368,0.466,0.566,0.668,0.775,0.885,1.,      &
      0.,0.083,0.167,0.254,0.344,0.438,0.535,0.638,0.748,0.868,1.,      &
      0.,0.075,0.152,0.232,0.314,0.400,0.492,0.592,0.703,0.835,1.,      &
      0.,0.069,0.140,0.212,0.288,0.366,0.451,0.546,0.659,0.805,1.,      &
      0.,0.066,0.132,0.200,0.270,0.344,0.424,0.518,0.638,0.794,1.,      &
      0.,0.063,0.127,0.192,0.259,0.329,0.406,0.499,0.616,0.769,1.,      &
      0.,0.062,0.124,0.187,0.251,0.318,0.391,0.477,0.580,0.721,1./
  DATA ((caib(4,i,j),j=1,11),i=1,9)/                                    &
      0.,0.098,0.196,0.295,0.394,0.494,0.594,0.695,0.796,0.898,1.,      &
      0.,0.096,0.193,0.290,0.389,0.488,0.589,0.690,0.792,0.896,1.,      &
      0.,0.093,0.187,0.282,0.379,0.478,0.578,0.680,0.784,0.891,1.,      &
      0.,0.087,0.176,0.268,0.362,0.458,0.557,0.661,0.768,0.881,1.,      &
      0.,0.080,0.163,0.248,0.336,0.428,0.524,0.628,0.739,0.862,1.,      &
      0.,0.074,0.149,0.226,0.308,0.393,0.485,0.586,0.700,0.835,1.,      &
      0.,0.068,0.138,0.210,0.285,0.365,0.452,0.550,0.668,0.814,1.,      &
      0.,0.065,0.131,0.199,0.269,0.344,0.426,0.522,0.638,0.786,1.,      &
      0.,0.063,0.126,0.191,0.257,0.327,0.404,0.491,0.596,0.737,1./
  DATA ((caib(5,i,j),j=1,11),i=1,9)/                                    &
      0.,0.098,0.197,0.296,0.396,0.496,0.596,0.696,0.797,0.898,1.,      &
      0.,0.097,0.195,0.293,0.392,0.492,0.592,0.693,0.794,0.897,1.,      &
      0.,0.095,0.190,0.287,0.385,0.484,0.584,0.686,0.789,0.894,1.,      &
      0.,0.090,0.182,0.276,0.372,0.470,0.570,0.672,0.778,0.887,1.,      &
      0.,0.084,0.171,0.259,0.351,0.446,0.545,0.649,0.758,0.875,1.,      &
      0.,0.077,0.157,0.239,0.325,0.415,0.511,0.614,0.728,0.855,1.,      &
      0.,0.071,0.145,0.220,0.300,0.384,0.476,0.578,0.694,0.832,1.,      &
      0.,0.067,0.135,0.206,0.280,0.358,0.444,0.542,0.658,0.802,1.,      &
      0.,0.064,0.129,0.195,0.264,0.337,0.416,0.504,0.610,0.751,1./
  DATA ((caib(6,i,j),j=1,11),i=1,9)/                                    &
      0.,0.099,0.198,0.298,0.397,0.497,0.597,0.698,0.798,0.899,1.,      &
      0.,0.098,0.196,0.295,0.394,0.494,0.594,0.695,0.796,0.898,1.,      &
      0.,0.096,0.193,0.290,0.389,0.488,0.588,0.690,0.792,0.896,1.,      &
      0.,0.093,0.187,0.282,0.379,0.478,0.578,0.680,0.784,0.891,1.,      &
      0.,0.088,0.177,0.268,0.362,0.460,0.559,0.663,0.770,0.882,1.,      &
      0.,0.081,0.164,0.250,0.340,0.433,0.531,0.636,0.747,0.868,1.,      &
      0.,0.074,0.151,0.231,0.314,0.402,0.497,0.600,0.716,0.846,1.,      &
      0.,0.069,0.140,0.214,0.291,0.372,0.462,0.561,0.675,0.815,1.,      &
      0.,0.065,0.132,0.200,0.271,0.346,0.427,0.517,0.624,0.764,1./
  DATA ((caib(7,i,j),j=1,11),i=1,9)/                                    &
      0.,0.099,0.199,0.298,0.398,0.498,0.598,0.698,0.798,0.899,1.,      &
      0.,0.098,0.197,0.296,0.396,0.496,0.596,0.696,0.797,0.898,1.,      &
      0.,0.097,0.195,0.293,0.392,0.492,0.592,0.693,0.794,0.897,1.,      &
      0.,0.094,0.190,0.287,0.384,0.484,0.584,0.686,0.789,0.894,1.,      &
      0.,0.090,0.182,0.276,0.372,0.470,0.570,0.673,0.779,0.888,1.,      &
      0.,0.084,0.171,0.260,0.353,0.448,0.548,0.652,0.761,0.877,1.,      &
      0.,0.078,0.158,0.241,0.328,0.419,0.516,0.620,0.733,0.858,1.,      &
      0.,0.072,0.145,0.222,0.302,0.386,0.478,0.578,0.692,0.827,1.,      &
      0.,0.067,0.135,0.206,0.278,0.355,0.438,0.530,0.637,0.775,1./
  DATA ((caib(8,i,j),j=1,11),i=1,9)/                                    &
      0.,0.100,0.199,0.299,0.399,0.498,0.599,0.699,0.799,0.900,1.,      &
      0.,0.099,0.198,0.298,0.397,0.497,0.597,0.698,0.798,0.899,1.,      &
      0.,0.098,0.196,0.295,0.395,0.494,0.594,0.695,0.796,0.898,1.,      &
      0.,0.096,0.193,0.291,0.390,0.489,0.589,0.690,0.793,0.896,1.,      &
      0.,0.093,0.188,0.283,0.380,0.479,0.579,0.682,0.786,0.892,1.,      &
      0.,0.088,0.178,0.270,0.365,0.462,0.562,0.665,0.772,0.884,1.,      &
      0.,0.082,0.165,0.252,0.341,0.434,0.532,0.636,0.747,0.867,1.,      &
      0.,0.074,0.151,0.230,0.313,0.400,0.492,0.593,0.706,0.837,1.,      &
      0.,0.069,0.139,0.211,0.286,0.364,0.448,0.541,0.649,0.786,1./
  DATA ((caib(9,i,j),j=1,11),i=1,9)/                                    &
      0.,0.100,0.200,0.299,0.399,0.499,0.599,0.700,0.800,0.900,1.,      &
      0.,0.100,0.199,0.299,0.399,0.498,0.599,0.699,0.799,0.900,1.,      &
      0.,0.099,0.198,0.298,0.397,0.497,0.597,0.698,0.798,0.899,1.,      &
      0.,0.098,0.196,0.295,0.394,0.494,0.594,0.695,0.796,0.898,1.,      &
      0.,0.096,0.192,0.290,0.388,0.487,0.588,0.689,0.791,0.895,1.,      &
      0.,0.092,0.185,0.280,0.376,0.474,0.574,0.676,0.781,0.889,1.,      &
      0.,0.086,0.173,0.262,0.354,0.449,0.547,0.650,0.759,0.875,1.,      &
      0.,0.078,0.157,0.239,0.324,0.412,0.506,0.607,0.719,0.846,1.,      &
      0.,0.071,0.143,0.217,0.293,0.373,0.459,0.552,0.660,0.796,1./
  DATA ((caib(10,i,j),j=1,11),i=1,9)/                                   &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.299,0.399,0.499,0.599,0.699,0.799,0.900,1.,      &
      0.,0.099,0.198,0.297,0.396,0.496,0.595,0.696,0.796,0.898,1.,      &
      0.,0.096,0.192,0.289,0.387,0.485,0.585,0.686,0.788,0.893,1.,      &
      0.,0.090,0.181,0.273,0.366,0.462,0.560,0.662,0.769,0.881,1.,      &
      0.,0.082,0.164,0.248,0.335,0.424,0.519,0.620,0.730,0.854,1.,      &
      0.,0.073,0.147,0.223,0.301,0.382,0.468,0.563,0.671,0.805,1./
  DATA ((caib(11,i,j),j=1,11),i=1,9)/                                   &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.300,0.400,0.500,0.600,0.700,0.800,0.900,1.,      &
      0.,0.100,0.200,0.299,0.398,0.496,0.595,0.695,0.795,0.897,1.,      &
      0.,0.096,0.190,0.284,0.378,0.474,0.572,0.674,0.778,0.886,1.,      &
      0.,0.086,0.171,0.257,0.345,0.436,0.531,0.632,0.740,0.861,1.,      &
      0.,0.076,0.152,0.229,0.308,0.390,0.478,0.573,0.681,0.813,1./
!
  DATA ((caif(i,j),j=1,11),i=1,9)/                                      &
      0.,0.099,0.198,0.298,0.397,0.497,0.597,0.698,0.798,0.899,1.,      &
      0.,0.098,0.196,0.295,0.395,0.495,0.595,0.695,0.796,0.898,1.,      &
      0.,0.096,0.193,0.291,0.390,0.489,0.589,0.690,0.793,0.896,1.,      &
      0.,0.093,0.187,0.283,0.380,0.479,0.580,0.681,0.786,0.892,1.,      &
      0.,0.087,0.177,0.268,0.363,0.460,0.561,0.665,0.772,0.884,1.,      &
      0.,0.079,0.160,0.246,0.335,0.430,0.529,0.635,0.747,0.869,1.,      &
      0.,0.068,0.141,0.217,0.298,0.385,0.481,0.586,0.704,0.840,1.,      &
      0.,0.059,0.120,0.185,0.256,0.333,0.419,0.518,0.637,0.789,1.,      &
      0.,0.051,0.104,0.160,0.219,0.284,0.357,0.443,0.551,0.707,1./
!
!-----------------------------------------------------------------------
!
!  The following DATA statements originally came from file
!  "cah.dat", which define pre-computed tables used for co2.
!
!-----------------------------------------------------------------------
!
  REAL :: cah(22,19)

  COMMON /radtab005/ cah

  DATA ((cah(i,j),i=1,22),j= 1, 5)/                                     &
      0.9923, 0.9922, 0.9921, 0.9920, 0.9916, 0.9910, 0.9899, 0.9882,   &
      0.9856, 0.9818, 0.9761, 0.9678, 0.9558, 0.9395, 0.9188, 0.8945,   &
      0.8675, 0.8376, 0.8029, 0.7621, 0.7154, 0.6647, 0.9876, 0.9876,   &
      0.9875, 0.9873, 0.9870, 0.9864, 0.9854, 0.9837, 0.9811, 0.9773,   &
      0.9718, 0.9636, 0.9518, 0.9358, 0.9153, 0.8913, 0.8647, 0.8350,   &
      0.8005, 0.7599, 0.7133, 0.6627, 0.9808, 0.9807, 0.9806, 0.9805,   &
      0.9802, 0.9796, 0.9786, 0.9769, 0.9744, 0.9707, 0.9653, 0.9573,   &
      0.9459, 0.9302, 0.9102, 0.8866, 0.8604, 0.8311, 0.7969, 0.7565,   &
      0.7101, 0.6596, 0.9708, 0.9708, 0.9707, 0.9705, 0.9702, 0.9697,   &
      0.9687, 0.9671, 0.9647, 0.9612, 0.9560, 0.9483, 0.9372, 0.9221,   &
      0.9027, 0.8798, 0.8542, 0.8253, 0.7916, 0.7515, 0.7054, 0.6551,   &
      0.9568, 0.9568, 0.9567, 0.9565, 0.9562, 0.9557, 0.9548, 0.9533,   &
      0.9510, 0.9477, 0.9428, 0.9355, 0.9250, 0.9106, 0.8921, 0.8700,   &
      0.8452, 0.8171, 0.7839, 0.7443, 0.6986, 0.6486/

  DATA ((cah(i,j),i=1,22),j= 6,10)/                                     &
      0.9377, 0.9377, 0.9376, 0.9375, 0.9372, 0.9367, 0.9359, 0.9345,   &
      0.9324, 0.9294, 0.9248, 0.9181, 0.9083, 0.8948, 0.8774, 0.8565,   &
      0.8328, 0.8055, 0.7731, 0.7342, 0.6890, 0.6395, 0.9126, 0.9126,   &
      0.9125, 0.9124, 0.9121, 0.9117, 0.9110, 0.9098, 0.9079, 0.9052,   &
      0.9012, 0.8951, 0.8862, 0.8739, 0.8579, 0.8385, 0.8161, 0.7900,   &
      0.7585, 0.7205, 0.6760, 0.6270, 0.8809, 0.8809, 0.8808, 0.8807,   &
      0.8805, 0.8802, 0.8796, 0.8786, 0.8770, 0.8747, 0.8712, 0.8659,   &
      0.8582, 0.8473, 0.8329, 0.8153, 0.7945, 0.7697, 0.7394, 0.7024,   &
      0.6588, 0.6105, 0.8427, 0.8427, 0.8427, 0.8426, 0.8424, 0.8422,   &
      0.8417, 0.8409, 0.8397, 0.8378, 0.8350, 0.8306, 0.8241, 0.8148,   &
      0.8023, 0.7866, 0.7676, 0.7444, 0.7154, 0.6796, 0.6370, 0.5897,   &
      0.7990, 0.7990, 0.7990, 0.7989, 0.7988, 0.7987, 0.7983, 0.7978,   &
      0.7969, 0.7955, 0.7933, 0.7899, 0.7846, 0.7769, 0.7664, 0.7528,   &
      0.7357, 0.7141, 0.6866, 0.6520, 0.6108, 0.5646/

  DATA ((cah(i,j),i=1,22),j=11,15)/                                     &
      0.7515, 0.7515, 0.7515, 0.7515, 0.7514, 0.7513, 0.7511, 0.7507,   &
      0.7501, 0.7491, 0.7476, 0.7450, 0.7409, 0.7347, 0.7261, 0.7144,   &
      0.6992, 0.6793, 0.6533, 0.6203, 0.5805, 0.5357, 0.7020, 0.7020,   &
      0.7020, 0.7019, 0.7019, 0.7018, 0.7017, 0.7015, 0.7011, 0.7005,   &
      0.6993, 0.6974, 0.6943, 0.6894, 0.6823, 0.6723, 0.6588, 0.6406,   &
      0.6161, 0.5847, 0.5466, 0.5034, 0.6518, 0.6518, 0.6518, 0.6518,   &
      0.6518, 0.6517, 0.6517, 0.6515, 0.6513, 0.6508, 0.6500, 0.6485,   &
      0.6459, 0.6419, 0.6359, 0.6273, 0.6151, 0.5983, 0.5755, 0.5458,   &
      0.5095, 0.4681, 0.6017, 0.6017, 0.6017, 0.6017, 0.6016, 0.6016,   &
      0.6016, 0.6015, 0.6013, 0.6009, 0.6002, 0.5989, 0.5967, 0.5932,   &
      0.5879, 0.5801, 0.5691, 0.5535, 0.5322, 0.5043, 0.4700, 0.4308,   &
      0.5518, 0.5518, 0.5518, 0.5518, 0.5518, 0.5518, 0.5517, 0.5516,   &
      0.5514, 0.5511, 0.5505, 0.5493, 0.5473, 0.5441, 0.5393, 0.5322,   &
      0.5220, 0.5076, 0.4878, 0.4617, 0.4297, 0.3929/

  DATA ((cah(i,j),i=1,22),j=16,19)/                                     &
      0.5031, 0.5031, 0.5031, 0.5031, 0.5031, 0.5030, 0.5030, 0.5029,   &
      0.5028, 0.5025, 0.5019, 0.5008, 0.4990, 0.4960, 0.4916, 0.4850,   &
      0.4757, 0.4624, 0.4441, 0.4201, 0.3904, 0.3564, 0.4565, 0.4565,   &
      0.4565, 0.4564, 0.4564, 0.4564, 0.4564, 0.4563, 0.4562, 0.4559,   &
      0.4553, 0.4544, 0.4527, 0.4500, 0.4460, 0.4400, 0.4315, 0.4194,   &
      0.4028, 0.3809, 0.3538, 0.3227, 0.4122, 0.4122, 0.4122, 0.4122,   &
      0.4122, 0.4122, 0.4122, 0.4121, 0.4120, 0.4117, 0.4112, 0.4104,   &
      0.4089, 0.4065, 0.4029, 0.3976, 0.3900, 0.3792, 0.3643, 0.3447,   &
      0.3203, 0.2923, 0.3696, 0.3696, 0.3696, 0.3696, 0.3696, 0.3696,   &
      0.3695, 0.3695, 0.3694, 0.3691, 0.3687, 0.3680, 0.3667, 0.3647,   &
      0.3615, 0.3570, 0.3504, 0.3409, 0.3279, 0.3106, 0.2892, 0.2642/
!
!-----------------------------------------------------------------------
!
!  End of RADDATA
!
!-----------------------------------------------------------------------
!

END BLOCK DATA raddata
